/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.Conditional;
import com.dickimawbooks.bib2gls.FieldValueElement;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldPatternMatch
implements Conditional {
    protected Pattern pattern;
    protected FieldValueElement fieldValueElem;

    public FieldPatternMatch(FieldValueElement fieldValueElement, Pattern pattern) {
        this.fieldValueElem = fieldValueElement;
        this.pattern = pattern;
    }

    @Override
    public boolean booleanValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        String string = this.fieldValueElem.getStringValue(bib2GlsEntry);
        if (string == null) {
            string = "";
        }
        Matcher matcher = this.pattern.matcher(string);
        boolean bl = matcher.matches();
        bib2GlsEntry.getResource().setLastMatch(matcher);
        if (bib2Gls.getDebugLevel() > 0) {
            bib2Gls.logAndPrintMessage(String.format("Entry: %s%nCondition: %s%nValue: \"%s\"%nResult: %s", new Object[]{bib2GlsEntry, this.toString(), string, bl}));
        }
        return bl;
    }

    public String toString() {
        return String.format("%s=/%s/", this.fieldValueElem, this.pattern.pattern());
    }
}

