/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.Conditional;
import com.dickimawbooks.bib2gls.FieldValueElement;
import com.dickimawbooks.bib2gls.Relational;
import java.io.IOException;

public class FieldFieldMatch
implements Conditional {
    protected FieldValueElement fieldValueElem1;
    protected FieldValueElement fieldValueElem2;
    protected Relational relation;

    public FieldFieldMatch(FieldValueElement fieldValueElement, Relational relational, FieldValueElement fieldValueElement2) {
        this.fieldValueElem1 = fieldValueElement;
        this.fieldValueElem2 = fieldValueElement2;
        this.relation = relational;
    }

    @Override
    public boolean booleanValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        String string;
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        String string2 = this.fieldValueElem1.getStringValue(bib2GlsEntry);
        if (string2 == null) {
            string2 = "";
        }
        if ((string = this.fieldValueElem2.getStringValue(bib2GlsEntry)) == null) {
            string = "";
        }
        boolean bl = this.compare(string2, string);
        if (bib2Gls.getDebugLevel() > 0) {
            bib2Gls.logAndPrintMessage(String.format("Entry: %s%nCondition: %s%nValue 1: \"%s\"%nValue 2: \"%s\"%nResult: %s", new Object[]{bib2GlsEntry, this.toString(), string2, string, bl}));
        }
        return bl;
    }

    protected boolean compare(String string, String string2) {
        int n = string.compareTo(string2);
        switch (this.relation) {
            case EQUALS: {
                return n == 0;
            }
            case NOT_EQUALS: {
                return n != 0;
            }
            case LT: {
                return n < 0;
            }
            case LE: {
                return n <= 0;
            }
            case GT: {
                return n > 0;
            }
            case GE: {
                return n >= 0;
            }
        }
        throw new AssertionError((Object)("Missing Relational enum " + (Object)((Object)this.relation)));
    }

    public String toString() {
        return String.format("%s %s %s", new Object[]{this.fieldValueElem1, this.relation, this.fieldValueElem2});
    }
}

