#include "symbiont.h"

/*
 *	Routine Initialize_Threads initializes all thread descriptors
 *	(done one time only). This is preferable to the rather large
 *	C initialization that would be necessary if using compile-time
 *	initialization:
 */

Initialize_Threads ()
{
	auto   unsigned long Stream;
	auto   struct Thread *Thread_Ptr;
	auto   struct dsc$descriptor *Desc_Ptr;
	auto   unsigned char *Ptr;

	for (Stream = 0; Stream < sizeof (Device_Thread) / sizeof (struct Thread); Stream++) {
		Thread_Ptr = &Device_Thread[Stream];
/*
 *	First, zero the entire block:
 */
		for (Ptr = (unsigned char *) Thread_Ptr; Ptr < &Thread_Ptr[1]; )
			*Ptr++ = 0;
/*
 *	Initialize all the dynamic string descriptors:
 */
		for (Desc_Ptr = &Thread_Ptr->DESC_START_THREAD;
                     Desc_Ptr < &Thread_Ptr->DESC_END;
		     Desc_Ptr++)
			Set_Dynamic_VMS_Descriptor (Desc_Ptr);
/*
 *	Miscellaneous:
 */
		Thread_Ptr->Stream_Number = Stream;
	}
}

/*
 *	Routines ReInitialize_Thread and ReInitialize_Task re-initialize
 *	task parameters in a thread structure during main execution:
 */

unsigned long ReInitialize_Thread (Thread_Ptr)
struct Thread *Thread_Ptr;
{
	auto   struct dsc$descriptor *Desc_Ptr;
	auto   unsigned long Sys_Status;
	extern unsigned long ReInitialize_Task(), Str$Free1_DX();

	for (Desc_Ptr = &Thread_Ptr->DESC_START_THREAD; Desc_Ptr < &Thread_Ptr->DESC_END_THREAD;
	     Desc_Ptr++) {
		Sys_Status = Str$Free1_DX (Desc_Ptr);
		if ((Sys_Status & 0x01) == 0)
			return (Sys_Status);
	}
	return (ReInitialize_Task (Thread_Ptr));
}

unsigned long ReInitialize_Task (Thread_Ptr)
struct Thread *Thread_Ptr;
{
	auto   struct dsc$descriptor *Desc_Ptr;
	auto   unsigned long Sys_Status, *Long_Ptr;
	auto   unsigned char *Ptr;
	extern unsigned long Str$Free1_DX(), Free_Output_List();
	globalvalue SS$_NORMAL;
/*
 *	Zero all the longword values associated with message data, which are
 *	all contiguous:
 */
	for (Long_Ptr = &Thread_Ptr->LONG_START; Long_Ptr < &Thread_Ptr->LONG_END; )
		*Long_Ptr++ = 0;
/*
 *	Zero the various structures, which are all contiguous:
 */
	for (Ptr = &Thread_Ptr->MISC_START; Ptr < &Thread_Ptr->MISC_END; )
		*Ptr++ = 0;
/*
 *	Free all the dynamic strings, which are all contiguous:
 */
	for (Desc_Ptr = &Thread_Ptr->DESC_START; Desc_Ptr < &Thread_Ptr->DESC_END; Desc_Ptr++) {
		Sys_Status = Str$Free1_DX (Desc_Ptr);
		if ((Sys_Status & 0x01) == 0) return (Sys_Status);
	}
/*
 *	Reset the default department
 */
	Sys_Status = Str$Copy_Dx (&Thread_Ptr->Department,
				  &Thread_Ptr->Department_Default);
	if ((Sys_Status & 0x01) == 0) return (Sys_Status);
/*
 *	Free any miscellaneous and statistics output generated:
 */
	Sys_Status = Free_Output_List (&Thread_Ptr->Misc_Output_Head);
	if ((Sys_Status & 0x01) == 0) return (Sys_Status);
	Sys_Status = Free_Output_List (&Thread_Ptr->Stats_Output_Head);
	if ((Sys_Status & 0x01) == 0) return (Sys_Status);
/*
 *	Set up the input buffer for received messages; miscellaneous:
 */
	Set_VMS_Descriptor (Thread_Ptr->Input_Buffer, 0,
                            &Thread_Ptr->Input_Buffer_Desc);
	Thread_Ptr->Current_Page = 1;
	Thread_Ptr->N_Condition_Values = 0;
	Thread_Ptr->Task_Options = 0;
	Thread_Ptr->Output_Page_Count = 0;
	Thread_Ptr->Library_Module_Count = 0;
	Thread_Ptr->Timer_Count = 0;
	return (SS$_NORMAL);
}

unsigned long Free_Output_List (Output_Head)
struct Misc_Output **Output_Head;
{
	auto   unsigned long Sys_Status;
	auto   struct Misc_Output *Misc_Ptr;
	extern unsigned long Str$Free1_DX();
	globalvalue SS$_NORMAL;

	while ((Misc_Ptr = *Output_Head) != 0) {
		Sys_Status = Str$Free1_DX (&Misc_Ptr->Misc_Output_Desc);
		if ((Sys_Status & 0x01) == 0)
			return (Sys_Status);
		*Output_Head = Misc_Ptr->Link;
		Mem_Free (Misc_Ptr);
	}
	return (SS$_NORMAL);
}
