/*
 *	This file contains function protocol definitions for routines
 *	in the file 'vmsfileio.c' or 'stdcfio.c'.
 */

#define Open_File_M(a,b,c,d) \
    Open_File ((char *) (a), \
               (char *) (b), \
               (char *) (c), \
               (char *) (d))
extern pointer Open_File();

#define Delete_File_M(a) Delete_File ((pointer) (a))
extern int Delete_File();

#define Close_File_M(a) Close_File ((pointer) (a))

#define Set_File_Open_Status_M(a,b) \
    Set_File_Open_Status ((pointer) (a), \
                          (unsigned long *) (b))

#define Full_File_Name_M(a) Full_File_Name ((pointer) (a))
extern char *Full_File_Name();

#define Read_Character_M(a) Read_Character ((pointer) (a))
extern unsigned char Read_Character();

#define Read_Character_Reverse_M(a) Read_Character_Reverse ((pointer) (a))
extern unsigned char Read_Character_Reverse();

#define Read_Block_M(a,b,c) \
    Read_Block ((char *) (a), \
                (unsigned int) (b), \
                (pointer) (c))
extern int Read_Block();

#define Write_Character_M(a,b) \
    Write_Character ((char) (a), \
                     (pointer) (b))

#define Write_Block_M(a,b,c) \
    Write_Block ((char *) (a), \
                 (unsigned int) (b), \
                 (pointer) (c))
extern int Write_Block();

#define Set_File_IO_Status_M(a,b) \
    Set_File_IO_Status ((pointer) (a), \
                        (unsigned long *) (b))

#define Set_File_Position_M(a,b) \
    Set_File_Position ((unsigned long) (a), \
                       (pointer) (b))
extern unsigned long Set_File_Position();

#define Set_EOF_M(a) Set_EOF ((pointer) (a))
extern unsigned long Set_EOF();

#define File_At_EOF_M(a) File_At_EOF ((pointer) (a))
extern int File_At_EOF();

#define File_Position_M(a) File_Position ((pointer) (a))
extern unsigned long File_Position();

#define Get_EOF_Address_M(a) Get_EOF_Address ((pointer) (a))
extern unsigned long Get_EOF_Address();

#define Get_File_Stats_M(a,b) \
    Get_File_Stats ((pointer) (a), \
                    (unsigned long *) (b))
