// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
// $Header: hp2686.h,v 1.14 91/05/20 20:05:52 hmgr Exp $

// HP2686 LaserJet+ device-specific definitions.
// The LaserJet+ Reference Manual should be consulted for more
// information on the various constants.
//
// by Parag Patel


class HP2686 : public Device
{
protected:
    HP2686(int maxf, int maxc, int maxpg, int maxld, int res,
		    int ho, int vo, int fhmn, int fhmx, int fvmn, int fvmx,
		    int fwd, int fhg, char *deffp);
    void downljchar(font &f, fontchar &g, int ch);
public:
    HP2686();
    ~HP2686();

    const char *char2dev(int ch, int &len);
    long sp2dev(double sp);
    double dev2sp(long pix);

    void newpage(boolean odd, boolean first);
    void downchar(font &f, fontchar &g, int ch);
    void bigchar(font &f, fontchar &g, int ch);
    void movehv(long h, long v);
    void moveh(long);
    void movev(long);
    void push();
    void pop();
    void delfont(font &);
    void newfont(font &);
    void usefont(font &);
    void rule(double v, double h);
};

#ifndef HP2686_FPATH
#define HP2686_FPATH "/usr/lib/tex/fontbits/laser:/usr/lib/tex/fnt:/usr/local/tex/fontbits/laser"
#endif

// about 1 inch from both margins - tweaked until TeX test comes out right
// when printed to a LaserJet - lots of fun with unprintable regions!
#define HP2686_HOFFSET 245
#define HP2686_VOFFSET 300
