# The LaTeX package csvsimple - version 2.6.1 (2024/05/16)


> Copyright (c) 2008-2024 by Prof. Dr. Dr. Thomas F. Sturm <thomas dot sturm at unibw dot de>

> This work may be distributed and/or modified under the
> conditions of the LaTeX Project Public License, either version 1.3
> of this license or (at your option) any later version.
> The latest version of this license is in
>   http://www.latex-project.org/lppl.txt
> and version 1.3 or later is part of all distributions of LaTeX
> version 2005/12/01 or later.

> This work has the LPPL maintenance status `author-maintained`.

> This work consists of all files listed in README.md


`csvsimple` provides a simple *LaTeX* interface for the processing of files 
with comma separated values (CSV). `csvsimple` relies heavily on a key value 
syntax which results in an easy way of usage. Filtering and table generation 
is especially supported. Since the package is considered as a lightweight 
tool, there is no support for data sorting or data base storage.


## Contents of the package

-  `README.md`                 this file
-  `CHANGES.md`                log of changes (history)
-  `csvsimple.sty`             LaTeX package file (style file)
-  `csvsimple-l3.sty`          LaTeX package file (style file)
-  `csvsimple-legacy.sty`      LaTeX package file (style file)
-  `csvsimple.pdf`             Documentation for csvsimple
-  `csvsimple-l3.pdf`          Documentation for csvsimple (LaTeX3)
-  `csvsimple-legacy.pdf`      Documentation for csvsimple (Legacy)
-  `csvsimple.tex`             Source code of the documentation
-  `csvsimple-l3.tex`          Source code of the documentation
-  `csvsimple-legacy.tex`      Source code of the documentation
-  `csvsimple-doc.sty`         Source code of the documentation
-  `csvsimple-title.png`       Picture for the documentation
-  `csvsimple-example.tex`     Example file for package usage
-  `csvsimple-example.csv`     CSV file as part of the example
-  `csvsimple-example.pdf`     Compiled example
-  `amountsort.xml`            csvsorter configuration file (example)
-  `catsort.xml`               csvsorter configuration file (example)
-  `encoding.xml`              csvsorter configuration file (example)
-  `gradesort.xml`             csvsorter configuration file (example)
-  `matriculationsort.xml`     csvsorter configuration file (example)
-  `namesort.xml`              csvsorter configuration file (example)
-  `transform.xml`             csvsorter configuration file (example)


## Installation

Copy the contents of the `csvsimple.tds.zip` from CTAN to your local TeX file tree.

Alternatively, put the files to their respective locations within the TeX installation:

-  `csvsimple.sty`         ->  /tex/latex/csvsimple
-  `csvsimple-l3.sty`      ->  /tex/latex/csvsimple
-  `csvsimple-legacy.sty`  ->  /tex/latex/csvsimple
-  all other files         ->  /doc/latex/csvsimple
