h15863
s 00001/00001/01046
d R 6.1 91/12/09 22:40:12 root 6 5
c (1) Fixed bug where 'c'c & 's' in Hebrew mode reversed English strings.  
c (2) Fixed bug where if you typed ^X while editing in a 'c' command, vi.iv might  
c     append the contents of another line to the current line.  
c (3) Preserve & recover now work with vi.iv.
e
s 00099/00026/00948
d D 5.1 90/04/24 14:34:30 haim 5 4
c (1) 'c & 's commands no longer reverse English strings while in Hebrew mode.
c *** CHANGED *** 91/12/09 21:00:08 haim
c (1) Fixed bug where directions of secondary language strings would
c be reversed if cancelled a command sequence (e.g., 'c', 'd', 'y').
c [function operate in ex_voper.c]
c (2) Fixed bug where substitute command would sometimes result in a
c segmentation fault.  [function subschang in ex_re.c]
c (3) Added other checks for null pointers [especially in ex_RL.c]
e
s 00000/00000/00974
d D 4.1 90/02/09 09:59:31 haim 4 3
c (1) created new termcap definitions vt100iv & suniv. Renamed the old
c termcap defintion to vi100iv.
c (2) Added use of TERMIV, EXINITIV, & .exrciv.
c *** CHANGED *** 90/02/09 10:22:23 haim
c (1) created new termcap definitions vt100iv & suniv. Renamed the old
e
s 00000/00000/00974
d D 3.1 90/01/01 14:16:24 haim 3 2
c Fixed the following bugs: [1] echoing previous lines during insert
c mode, [2] cursor stuck in corner when inserting LR text in RL view,
c [3] prints "ERROR" instead of correct messages.
c Also deleted unused entries from termcap.
e
s 00003/00001/00971
d D 2.1 89/12/27 09:22:00 haim 2 1
c First version installed on the Technion Computer Science Faculty 
c (TCSF) CS network.  usuable, but has some bugs, the worst of which 
c is that in insert mode, when you start a new line, previous lines 
c are echoed on that new line.  Installed by Haim Roman 11/1989.
c *** CHANGED *** 89/12/27 12:09:18 haim
c 
e
s 00972/00000/00000
d D 1.1 89/12/26 15:06:17 haim 1 0
c Inherited by Haim Roman from Yael Dubinsky approximately 10/1989.  Yael 
c started the installation on the Technion Computer Science computers, 
c but had to leave before completing the installation.
c *** CHANGED *** 89/12/26 15:19:00 haim
c date and time created 89/12/26 15:06:17 by haim
e
u
U
f e 0
t
T
I 1
D 5
/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */
E 5
I 5
/* FILE: ex_voper.c -- visual mode "operate" function
*===========================================================
* EDIT HISTORY:
*
* 24/04/90	HAIM ROMAN, TECHNION COMPUTER SCIENCE FACULTY
* (1) Added Comments
* (2) Added call to 'setlf' to undo conversion from time-order to
* visual-order.  Search for "c == 0".
*------------------------------------------------------------
* Copyright (c) 1980 Regents of the University of California.
* All rights reserved.  The Berkeley software License Agreement
* specifies the terms and conditions for redistribution.
*============================================================
* DATA
*============================================================
*/
E 5

#ifndef lint
static char *sccsid = "@(#)ex_voper.c	7.4 (Berkeley) 6/7/85";
#endif not lint

#include "ex.h"
#include "ex_tty.h"
#include "ex_vis.h"
#include "ex_RL.h"

#define	blank()		isspace(wcursor[0] & TRIM)
#define	forbid(a)	if (a) goto errlab;

char	vscandir[2] =	{ '/', 0 };

/*
 * Findlen was added for the vi.iv by uri Habusha. It's true
 * if the previous scanning word is in secondery language.
 */


bool findlen = 0;

D 5

/*
 * Decode an operator/operand type command.
 * Eventually we switch to an operator subroutine in ex_vops.c.
 * The work here is setting up a function variable to point
 * to the routine we want, and manipulation of the variables
 * wcursor and wdot, which mark the other end of the affected
 * area.  If wdot is zero, then the current line is the other end,
 * and if wcursor is zero, then the first non-blank location of the
 * other line is implied.
 */
E 5
I 5
/*===================================================================
* FUNCTIONS
*===================================================================
* operate --  Decode an operator/operand type command.
* Eventually we switch to an operator subroutine in ex_vops.c.
* The work here is setting up a function variable to point
* to the routine we want, and manipulation of the variables
* wcursor and wdot, which mark the other end of the affected
* area.  If wdot is zero, then the current line is the other end,
* and if wcursor is zero, then the first non-blank location of the
* other line is implied.
*
* INPUT ARGUMENTS:
* ----------------
* c -- 1st character of the command
* cnt --
*
* GLOBAL VARIABLES: (this list might not be complete)
* -----------------
* workcmd (in) -- 5-character buffer containing the form of the
*	command as the user typed this (which might be different from 'c')
*
* OTHER NOTES:
* ------------
* (1) "Stuttering" refers to repeating the command letter to make it
* apply to the entire line (e.g. 'cc', 'dd).
*---------------------------------------------------------------
*/
E 5
operate(c, cnt)
	register int c, cnt;
{
	register int i;
	int (*moveop)(), (*deleteop)();
	register int (*opf)();
	bool subop = 0;
	char *oglobp, *ocurs, *hp;
	register line *addr;
	line *odot;
	static char lastFKND, lastFCHR;
	short d;
	bool sINdirect;
	bool changdir = 0;
	char *inline;

	moveop = vmove, deleteop = vdelete;
	wcursor = cursor;
	wdot = NOLINE;
	notecnt = 0;
	dir = 1;
D 5
	convto = 0;
E 5
I 5
	convto = 0;	/* true = converted from time order to visual order (?) */

	/*------------------------------------------------------
	 * switch statement on the command character
	 *-----------------------------------------------------
	 */
E 5
	switch (c) {

	/*
	 * d		delete operator.
	 */
	case 'd':
		moveop = vdelete;
		deleteop = beep;
		setlf(&convto);
		break;

	/*
	 * s		substitute characters, like c\040, i.e. change space.
	 */
	case 's':
		ungetkey(' ');
		subop++;
		/* fall into ... */

	/*
	 * c		Change operator.
	 */
	case 'c':
I 5
		/* The 'C' command is equivalent to 'c$' & 'S' is
		 * equivalent to 'cc'.  However these sub-operators
		 * (i.e., arguments) might not be in c's buffer, so
		 * flag the fact that we DO have sub-operators.
		 */
E 5
		if (c == 'c' && workcmd[0] == 'C' || workcmd[0] == 'S')
			subop++;
I 5
		
E 5
		moveop = vchange;
		deleteop = beep;
		if (isecondlang && !ishef)
			dir = -1;
I 5
		
		/* Convert line from time-order to visual order.
		 * "convto" is toggled to mark that this conversion
		 * has taken place.	(There is a chance that we're
		 * really converting from visual order to time order,
		 * but I think that I'm correct -- Haim Roman 24/04/90)
		 */
E 5
		setlf(&convto);
		break;

	/*
	 * !		Filter through a UNIX command.
	 */
	case '!':
		moveop = vfilter;
		deleteop = beep;
		break;

	/*
	 * y		Yank operator.  Place specified text so that it
	 *		can be put back with p/P.  Also yanks to named buffers.
	 */
	case 'y':
		moveop = vyankit;
		deleteop = beep;
D 5
		setlf(&convto);
E 5
I 5
		setlf(&convto);	/* convert linebuf to visual order; toggle convto */
E 5
		break;

	/*
	 * =		Reformat operator (for LISP).
	 */
#ifdef LISPCODE
	case '=':
		forbid(!value(LISP));
		/* fall into ... */
#endif

	/*
	 * >		Right shift operator.
	 * <		Left shift operator.
	 */
	case '<':
	case '>':
		moveop = vshftop;
		deleteop = beep;
		break;

	/*
	 * r		Replace character under cursor with single following
	 *		character.
	 */
	case 'r':
		chadir();
		vmacchng(1);
		vrep(cnt);
		return;

	default:
		goto nocount;
D 5
	}
	vmacchng(1);
E 5
I 5
	}  /* end of switch for command character */


	/*---------------------------------------------------
	 * Miscellaneous
	 *-------------------------------------------------
	 */
	vmacchng(1);	/* handles case where change is inside a macro */
E 5
	/*
	 * Had an operator, so accept another count.
	 * Multiply counts together.
	 */
	if (isdigit(peekkey()) && peekkey() != '0') {
		cnt *= vgetcnt();
		Xcnt = cnt;
		forbid (cnt <= 0);
	}

	/*
D 5
	 * Get next character, mapping it and saving as
	 * part of command for repeat.
E 5
I 5
	 * Get next character, mapping it and saving as part of command for repeat.
	 * If it is an ESCAPE character, abort the command now & return.
E 5
	 */
	changdir = 1;
D 5
	c = map(getesc(),arrows);
	if (c == 0)
E 5
I 5
	c = map(getesc(),arrows);  /* if char = ESC, this will return 0 */
	if (c == 0) {
		/* if the line buffer has been converted to visual order
		 * by a previous call to setlf, undo that by another
		 * call to setlf.
		 *	[Added 24/04/90 by Haim Roman]
		 */
		if (convto)  setlf (&convto);
E 5
		return;
I 5
	}
E 5
	if (!subop)
		*lastcp++ = c;
nocount:
	opf = moveop;
	switch (c) {

	/*
	 * b		Back up a word.
	 * B		Back up a word, liberal definition.
	 */
	case 'b':
	case 'B':
		dir = -1;
		/* fall into ... */

	/*
	 * w		Forward a word.
	 * W		Forward a word, liberal definition.
	 */
	case 'W':
	case 'w':
		wdkind = c & ' ';
		forbid(lfind(2, cnt, opf, 0) < 0);
		vmoving = 0;
		break;

	/*
	 * E		to end of following blank/nonblank word
	 */
	case 'E':
		wdkind = 0;
		goto ein;

	/*
	 * e		To end of following word.
	 */
	case 'e':
		wdkind = 1;
ein:
		forbid(lfind(3, cnt - 1, opf, 0) < 0);
		vmoving = 0;
		break;

	/*
	 * (		Back an s-expression.
	 */
	case '(':
		dir = -1;
		/* fall into... */

	/*
	 * )		Forward an s-expression.
	 */
	case ')':
		forbid(lfind(0, cnt, opf, (line *) 0) < 0);
		markDOT();
		break;

	/*
	 * {		Back an s-expression, but don't stop on atoms.
	 *		In text mode, a paragraph.  For C, a balanced set
	 *		of {}'s.
	 */
	case '{':
		dir = -1;
		/* fall into... */

	/*
	 * }		Forward an s-expression, but don't stop on atoms.
	 *		In text mode, back paragraph.  For C, back a balanced
	 *		set of {}'s.
	 */
	case '}':
		forbid(lfind(1, cnt, opf, (line *) 0) < 0);
		markDOT();
		break;

	/*
	 * %		To matching () or {}.  If not at ( or { scan for
	 *		first such after cursor on this line.
	 */
	case '%':
		vsave();
		i = lmatchp((line *) 0);
#ifdef TRACE
		if (trace)
			fprintf(trace, "after lmatchp in %, dot=%d, wdot=%d, dol=%d\n", lineno(dot), lineno(wdot), lineno(dol));
#endif
		getDOT();
		forbid(!i);
		if (opf != vmove)
			if (dir > 0)
				wcursor++;
			else
				cursor++;
		else
			markDOT();
		vmoving = 0;
		break;

	/*
	 * [		Back to beginning of defun, i.e. an ( in column 1.
	 *		For text, back to a section macro.
	 *		For C, back to a { in column 1 (~~ beg of function.)
	 */
	case '[':
		dir = -1;
		/* fall into ... */

	/*
	 * ]		Forward to next defun, i.e. a ( in column 1.
	 *		For text, forward section.
	 *		For C, forward to a } in column 1 (if delete or such)
	 *		or if a move to a { in column 1.
	 */
	case ']':
		if (!vglobp)
			forbid(getkey() != c);
		forbid (Xhadcnt);
		vsave();
		i = lbrack(c, opf);
		getDOT();
		forbid(!i);
		markDOT();
		if (ospeed > B300)
			hold |= HOLDWIG;
		break;

	/*
	 * ,		Invert last find with f F t or T, like inverse
	 *		of ;.
	 */
	case ',':
		forbid (lastFKND == 0);
		c = isupper(lastFKND) ? tolower(lastFKND) : toupper(lastFKND);
		i = lastFCHR;
		if (vglobp == 0)
			vglobp = "";
		subop++;
		goto nocount;

	/*
	 * 0		To beginning of real line.
	 */
	case '0':
		wcursor = linebuf;
		vmoving = 0;
		break;

	/*
	 * ;		Repeat last find with f F t or T.
	 */
	case ';':
		forbid (lastFKND == 0);
		c = lastFKND;
		i = lastFCHR;
		if (!convto)
			setlf(&convto);
		switch (c) {

		case 'T':
			if (--wcursor < linebuf)
				wcursor = linebuf;
			break;
		case 't':
			if (!*++wcursor)
				wcursor--;
		}
		subop++;
		goto nocount;

	/*
	 * F		Find single character before cursor in current line.
	 * T		Like F, but stops before character.
	 */
	case 'F':	/* inverted find */
	case 'T':
		dir = -1;
		/* fall into ... */

	/*
	 * f		Find single character following cursor in current line.
	 * t		Like f, but stope before character.
	 */
	case 'f':	/* find */
	case 't':
		if (!subop) {
			sINdirect = INdirect;
			INdirect = (isRLtext ? RL : LR);
			chadir();
			if ((i = getesc()) == *svalue(CHLK)){
				INdirect = !INdirect;
				chadir();
				i = getesc();
			}
			if (isRL)
				i |= QUOTE;
			INdirect = sINdirect;
			if ((i & TRIM) == 0){
				return;
			}
			*lastcp++ = i;
		}
		if (vglobp == 0)
			lastFKND = c, lastFCHR = i;
		if (!convto)
			setlf(&convto);
		for (; cnt > 0; cnt--)
			forbid (find(i) == 0);
		vmoving = 0;
		switch (c) {

		case 'T':
			wcursor++;
			break;

		case 't':
			wcursor--;
		case 'f':
fixup:
			if (moveop != vmove)
				wcursor++;
			break;
		}
		if (moveop == vmove)
			setlf(&convto);
		break;

	/*
	 * |		Find specified print column in current line.
	 */
	case '|':
		if (Pline == numbline)
			cnt += 8;
		vmovcol = cnt;
		vmoving = 1;
		wcursor = vfindcol(cnt);
		break;

	/*
	 * ^		To beginning of non-white space on line.
	 */
	case '^':
		wcursor = vskipwh(linebuf);
		vmoving = 0;
		break;

	/*
	 * $		To end of line.
	 */
	case '$':
		if (opf == vmove) {
			vmoving = 1;
			vmovcol = 20000;
		} else
			vmoving = 0;
		if (cnt > 1) {
			if (opf == vmove) {
				wcursor = 0;
				cnt--;
			} else
				wcursor = linebuf;
			/* This is wrong at EOF */
			wdot = dot + cnt;
			break;
		}
		if (linebuf[0]) {
			wcursor = strend(linebuf) - 1;
			goto fixup;
		}
		wcursor = linebuf;
		break;
	/*
	 * V 		back a character in order time.
	 */
	case 'V':
		dir = -1;
		/*fall into....*/
	/*
	 * v 		Forward a character in order time.
	 */
	case 'v':
		if (!ishef)
			goto chnrl;
		screencol(linebuf, &wcursor);
		changseclan(linebuf, Mdirect);
		forbid (margin() || opf == vmove && edge());
		while (cnt > 0 && !margin())
			wcursor += dir, cnt--;
		if (margin() && opf == vmove || wcursor < linebuf)
			wcursor -= dir;
		vmoving = 0;
		screencol(linebuf, &wcursor);
		changseclan(linebuf, Mdirect);
		break;
	/*
	 * h		Back a character.
	 * ^H		Back a character.
	 * For RL text we need to change the direction of cursor.
	 * this lines were added by Uri habusha for vi.iv at 31/5/88.
	 */
	case 'h':
	case CTRL(h):
		if(!isRLtext && !changdir)
			dir = -1;
		goto chnrl;
		/* fall into ... */

	/*
	 * space	Forward a character.
	 */
	case 'l':
	case ' ':
		if(isRLtext && !changdir)
			dir = -1;
chnrl:
		forbid (margin() || opf == vmove && edge());
		while (cnt > 0 && !margin())
			wcursor += dir, cnt--;
		if (margin() && opf == vmove || wcursor < linebuf)
			wcursor -= dir;
		vmoving = 0;
		if (isecondlang && changdir){
			wcursor++;
/*			cursor++;*/
		}
		break;

	/*
	 * D		Delete to end of line, short for d$.
	 */
	case 'D':
		cnt = INF;
		goto deleteit;

	/*
	 * X		Delete character before cursor.
	 */
	case 'X':
		dir = -1;
		/* fall into ... */
deleteit:
	/*
	 * x		Delete character at cursor, leaving cursor where it is.
	 */
	case 'x':
		setlf(&convto);
		if (margin())
			goto errlab;
		vmacchng(1);
		while (cnt > 0 && !margin())
			wcursor += dir, cnt--;
		opf = deleteop;
		vmoving = 0;
		break;

	default:
		/*
		 * Stuttered operators are equivalent to the operator on
		 * a line, thus turn dd into d_.
		 */
		if (opf == vmove || c != workcmd[0]) {
errlab:
I 5
			/* if line was converted from time order to
			 * visual order, convert it back (the comment
			 * might be the reverse of what actually
			 * happens, but I think it's correct --
			 *	(Haim Roman, 24/04/90)
			 */
E 5
			if (convto)
				setlf(&convto);
I 5
			
E 5
			beep();
			vmacp = 0;
			return;
		}
		/* fall into ... */

	/*
	 * _		Target for a line or group of lines.
	 *		Stuttering is more convenient; this is mostly
	 *		for aesthetics.
	 */
	case '_':
		wdot = dot + cnt - 1;
		vmoving = 0;
		wcursor = 0;
		break;

	/*
	 * H		To first, home line on screen.
	 *		Count is for count'th line rather than first.
	 */
	case 'H':
		wdot = (dot - vcline) + cnt - 1;
		if (opf == vmove)
			markit(wdot);
		vmoving = 0;
		wcursor = 0;
		break;

	/*
	 * -		Backwards lines, to first non-white character.
	 */
	case '-':
		wdot = dot - cnt;
		vmoving = 0;
		wcursor = 0;
		break;

	/*
	 * ^P		To previous line same column.  Ridiculous on the
	 *		console of the VAX since it puts console in LSI mode.
	 */
	case 'k':
	case CTRL(p):
		wdot = dot - cnt;
		if (vmoving == 0)
			vmoving = 1, vmovcol = column(cursor);
		wcursor = 0;
		break;

	/*
	 * L		To last line on screen, or count'th line from the
	 *		bottom.
	 */
	case 'L':
		wdot = dot + vcnt - vcline - cnt;
		if (opf == vmove)
			markit(wdot);
		vmoving = 0;
		wcursor = 0;
		break;

	/*
	 * M		To the middle of the screen.
	 */
	case 'M':
		wdot = dot + ((vcnt + 1) / 2) - vcline - 1;
		if (opf == vmove)
			markit(wdot);
		vmoving = 0;
		wcursor = 0;
		break;

	/*
	 * +		Forward line, to first non-white.
	 *
	 * CR		Convenient synonym for +.
	 */
	case '+':
	case CR:
		wdot = dot + cnt;
		vmoving = 0;
		wcursor = 0;
		break;

	/*
	 * ^N		To next line, same column if possible.
	 *
	 * LF		Linefeed is a convenient synonym for ^N.
	 */
	case CTRL(n):
	case 'j':
	case NL:
		wdot = dot + cnt;
		if (vmoving == 0)
			vmoving = 1, vmovcol = column(cursor);
		wcursor = 0;
		break;

	/*
	 * n		Search to next match of current pattern.
	 */
	case 'n':
		vglobp = vscandir;
		c = *vglobp++;
		goto nocount;

	/*
	 * N		Like n but in reverse direction.
	 */
	case 'N':
		vglobp = vscandir[0] == '/' ? "?" : "/";
		c = *vglobp++;
		goto nocount;

	/*
	 * '		Return to line specified by following mark,
	 *		first white position on line.
	 *
	 * `		Return to marked line at remembered column.
	 */
	case '\'':
	case '`':
		d = c;
		c = getesc();
		if (c == 0)
			return;
		c = markreg(c);
		forbid (c == 0);
		wdot = getmark(c);
		forbid (wdot == NOLINE);
		forbid (Xhadcnt);
		vmoving = 0;
		wcursor = d == '`' ? ncols[c - 'a'] : 0;
		if (opf == vmove && (wdot != dot || (d == '`' && wcursor != cursor)))
			markDOT();
		if (wcursor) {
			vsave();
			getline(*wdot, ishef);
			if (wcursor > strend(linebuf))
				wcursor = 0;
			getDOT();
		}
		if (ospeed > B300)
			hold |= HOLDWIG;
		break;

	/*
	 * G		Goto count'th line, or last line if no count
	 *		given.
	 */
	case 'G':
		if (!Xhadcnt)
			cnt = lineDOL();
		wdot = zero + cnt;
		forbid (wdot < one || wdot > dol);
		if (opf == vmove)
			markit(wdot);
		vmoving = 0;
		wcursor = 0;
		break;

	/*
	 * /		Scan forward for following re.
	 * ?		Scan backward for following re.
	 */
	case '/':
	case '?':
		forbid (Xhadcnt);
		vsave();
		inline = cursor;
		if (ishef)
			screencol(linebuf, &inline);
		ocurs = cursor;
		odot = dot;
		wcursor = 0;
		if (readecho(c))
			return;
		setscan(genbuf, 0);
		if (!vglobp)
			vscandir[0] = genbuf[0];
		oglobp = globp; CP(vutmp, genbuf); globp = vutmp;
		if (globp[1] != 0) {
			int e;
			e = globp[1];
			if ((RL_letter(e)) != Mdirect)
				findlen = 1;
			else
				findlen = 0;
		}
		d = peekc;
fromsemi:
		ungetchar(0);
		fixecho();
		CATCH
#ifndef CBREAK
			/*
			 * Lose typeahead (ick).
			 */
			vcook();
#endif
			addr = address(inline);
#ifndef CBREAK
			vraw();
#endif
		ONERR
#ifndef CBREAK
			vraw();
#endif
slerr:
			globp = oglobp;
			dot = odot;
			cursor = ocurs;
			ungetchar(d);
			splitw = 0;
			vclean();
			vjumpto(dot, ocurs, 0);
			return;
		ENDCATCH
		if (globp == 0)
			globp = "";
		else if (peekc)
			--globp;
		if (*globp == ';') {
			/* /foo/;/bar/ */
			globp++;
			dot = addr;
			cursor = loc1;
			goto fromsemi;
		}
		dot = odot;
		ungetchar(d);
		c = 0;
		if (*globp == 'z')
			globp++, c = '\n';
		if (any(*globp, "^+-."))
			c = *globp++;
		i = 0;
		while (isdigit(*globp))
			i = i * 10 + *globp++ - '0';
		if (any(*globp, "^+-."))
			c = *globp++;
		if (*globp) {
			/* random junk after the pattern */
			beep();
			goto slerr;
		}
		globp = oglobp;
		splitw = 0;
		vmoving = 0;
		wcursor = loc1;
		if (i != 0)
			vsetsiz(i);
		if (opf == vmove) {
			if (state == ONEOPEN || state == HARDOPEN)
				outline = destline = WBOT;
			if (addr != dot || loc1 != cursor)
				markDOT();
			if (loc1 > linebuf && *loc1 == 0)
				loc1--;
			if (c)
				vjumpto(addr, loc1, c);
			else {
				vmoving = 0;
				if (loc1) {
					vmoving++;
					if (findlen)
						if (ishef)
							vmovcol = hscreencol(loc1);
						else
							vmovcol = column(loc2-1);
					else
						vmovcol = column(loc1);
				}
				getDOT();
				if (state == CRTOPEN && addr != dot)
					vup1();
				vupdown(addr - dot, NOSTR);
			}
			return;
		}
		lastcp[-1] = 'n';
		getDOT();
		wdot = addr;
		break;
D 5
	}
E 5
I 5
	} /* I think this is the end of a switch statement */
E 5
	/*
	 * Apply.
	 */
	if (vreg && wdot == 0)
		wdot = dot;
	(*opf)(c);
I 5

	/* if the line buffer has been converted to visual order by a
	 * call to setlf, undo that by a 2nd call to setlf.
	 *
	 *	(Not sure if the comment is correct, but I think
	 *	that's the case.	Haim Roman, 15/03/90)
	 */
E 5
	if (convto)
		setlf(&convto);
	wdot = NOLINE;
D 5
}
E 5
I 5
}  /* end of function operate */
E 5

/*
 * Find single character c, in direction dir from cursor.
 */
find(c)
	char c;
{
I 2
	int d;
E 2

	for(;;) {
		if (edge())
			return (0);
		wcursor += dir;
D 2
		if (islower(c & TRIM) || c == 0340){
E 2
I 2
		d = c;
		if (islower(c & TRIM) || d == 0340){
E 2
			if (*wcursor == c)
				return (1);
		} else
			if ((*wcursor & TRIM) == (c & TRIM))
				return (1);
	}
}

/*
 * Do a word motion with operator op, and cnt more words
 * to go after this.
 */
word(op, cnt)
	register int (*op)();
	int cnt;
{
	register int which;
	register char *iwc;
	register line *iwdot = wdot;

	if (dir == 1) {
		iwc = wcursor;
		which = wordch(wcursor);
		while (wordof(which, wcursor)) {
			if (cnt == 1 && op != vmove && wcursor[1] == 0) {
				wcursor++;
				break;
			}
			if (!lnext())
				return (0);
			if (wcursor == linebuf)
				break;
		}
		/* Unless last segment of a change skip blanks */
		if (op != vchange || cnt > 1)
			while (!margin() && blank())
				wcursor++;
		else
			if (wcursor == iwc && iwdot == wdot && *iwc)
				wcursor++;
		if (op == vmove && margin())
			wcursor--;
	} else {
		if (!isecondlang && !lnext())
			return (0);
		while (blank())
			if (!lnext())
				return (0);
		if (!margin()) {
			which = wordch(wcursor);
			while (!margin() && wordof(which, wcursor))
				wcursor--;
		}
		if (wcursor < linebuf || !wordof(which, wcursor))
			wcursor++;
	}
	return (1);
}

/*
 * To end of word, with operator op and cnt more motions
 * remaining after this.
 */
eend(op)
	register int (*op)();
{
	register int which;

	if (!lnext())
		return;
	while (blank())
		if (!lnext())
			return;
	which = wordch(wcursor);
	while (wordof(which, wcursor)) {
		if (wcursor[1] == 0) {
			wcursor++;
			break;
		}
		if (!lnext())
			return;
	}
	if (op != vchange && op != vdelete && wcursor > linebuf)
		wcursor--;
}

/*
 * Wordof tells whether the character at *wc is in a word of
 * kind which (blank/nonblank words are 0, conservative words 1).
 */
wordof(which, wc)
	char which;
	register char *wc;
{

	if (isspace(*wc & TRIM))
		return (0);
	return (!wdkind || wordch(wc) == which);
}

/*
 * Wordch tells whether character at *wc is a word character
 * i.e. an alfa, digit, or underscore.
 */
wordch(wc)
	char *wc;
{
	register unsigned c;

	c = wc[0] & (QUOTE | TRIM); 
	return (isrlalpa(c) || isdigit(c&TRIM) || (c&TRIM) == '_');
	
}

/*
 * Edge tells when we hit the last character in the current line.
 */
edge()
{

	if (linebuf[0] == 0)
		return (1);
	if (dir == 1)
		return (wcursor[1] == 0);
	else
		return (wcursor == linebuf);
}

/*
 * Margin tells us when we have fallen off the end of the line.
 */
margin()
{

	return (wcursor < linebuf || wcursor[0] == 0);
}
E 1
