#include <stdio.h>
#include "stack.h"

typedef void *stack_node;

typedef struct {
    int size;
    int top;
    stack_node *elements;
} stack_head, *stack_ptr;

stack
#ifdef __STDC__
stack_create(int initial_size)
#else /* !__STDC__ */
stack_create(initial_size)
int initial_size;
#endif /* !__STDC__ */
{
    stack_ptr st = (stack_ptr)malloc(sizeof(stack_head));

    st->size = initial_size;
    st->top = 0;
    st->elements = (stack_node *)malloc(sizeof(stack_node) * initial_size);
    return((stack)st);
}

void
#ifdef __STDC__
stack_free(stack st, void (*free_func)(void *))
#else /* !__STDC__ */
stack_free(st, free_func)
stack st;
void (*free_func)();
#endif /* !__STDC__ */
{
    stack_ptr sptr = (stack_ptr)st;
    int i;

    for (i = 0; i < sptr->top; i++)
      (*free_func)(sptr->elements[i]);
    free((char *)sptr->elements);
    free((char *)sptr);
}

int
#ifdef __STDC__
stack_push(stack st, void *data)
#else /* !__STDC__ */
stack_push(st, data)
stack st;
void *data;
#endif /* !__STDC__ */
{
    stack_ptr sptr = (stack_ptr)st;
    int pos = sptr->top;

    sptr->top++;
    if (sptr->top == sptr->size)
      return(-1);
    sptr->elements[pos] = data;
    return(0);
}

void *
#ifdef __STDC__
stack_pop(stack st)
#else /* !__STDC__ */
stack_pop(st)
stack st;
#endif /* !__STDC__ */
{
    stack_ptr sptr = (stack_ptr)st;

    if (sptr->top == 0)
      return(NULL);
    sptr->top--;
    return(sptr->elements[sptr->top]);
}

void
#ifdef __STDC__
stack_flush(stack st)
#else /* !__STDC__ */
stack_flush(st)
stack st;
#endif /* !__STDC__ */
{
    stack_ptr sptr = (stack_ptr)st;

    sptr->top = 0;
}

int
#ifdef __STDC__
stack_size(stack st)
#else /* !__STDC__ */
stack_size(st)
stack st;
#endif /* !__STDC__ */
{
    return(((stack_ptr)st)->top);
}

void
#ifdef __STDC__
stack_dump(stack st, void (*action_func)(void *))
#else /* !__STDC__ */
stack_dump(st, action_func)
stack st;
void (*action_func)();
#endif /* !__STDC__ */
{
    stack_ptr sptr = (stack_ptr)st;
    int i, top = sptr->top - 1;

    for (i = top; i >= 0; i--)
      (*action_func)(sptr->elements[i]);
}

void *
#ifdef __STDC__
stack_top(stack st)
#else /* !__STDC__ */
stack_top(st)
stack st;
#endif /* !__STDC__ */
{
    stack_ptr sptr = (stack_ptr)st;
    int top = sptr->top - 1;

    if (top < 0)
      return(NULL);
    return(sptr->elements[top]);
}
