#ifndef _stack_h
#define _stack_h

typedef void *stack;

/*
 * If stack_push returns -1, stack overflow occured.
 * If stack_pop returns NULL, stack underflow occured.
 * Need to insure that no NULL elements are pushed on stack.
 */

#ifdef __STDC__

stack stack_create(int);
void  stack_free(stack, void (*)(void *));
int   stack_push(stack, void *);
void *stack_pop(stack);
void  stack_flush(stack);
int   stack_size(stack);
void  stack_dump(stack, void (*)(void *));
void *stack_top(stack);

#else /* !__STDC__ */

stack stack_create(/* int initial_size */);
void  stack_free(/* stack st, void (*free_func)(void *data) */);
int   stack_push(/* stack st, void *data */);
void *stack_pop(/* stack st */);
void  stack_flush(/* stack st */);
int   stack_size(/* stack st */);
void  stack_dump(/* stack st, void (*action_func)(void *data) */);
void *stack_top(/* stack st */);

#endif /* !__STDC__ */

#endif /* _stack_h */
