#include "EditMask.h"
#include "qbibman.h"
#include "AbsWin.h"
#include <signal.h>
#include <qarray.h>

/*!
*/
#ifdef _USE_RECODE
QString recode(QString x,bool toTex){
 char *const a[]={"recode","latin1:latex",NULL};
 char *const b[]={"recode","latex:latin1",NULL};
 char c;
 int pto[2],pfrom[2],pid,fd_from,fd_to,i,ii;

 if (x.isEmpty()) return x; //don't recode empty strings
 if (pipe(pto)) {perror("pipeto"); return x;}
 if (pipe(pfrom)) {perror("pipefrom"); ::close(pto[0]);::close(pto[1]);return x;}
 pid = fork();
 if (pid==-1) {perror("Could not fork"); return x;}
 if (pid == 0) {   // Child
  dup2( pto[0], 0 );
  dup2( pfrom[1], 1 );
  if (::close(pto[0])) perror("close");
  if (::close(pto[1]))perror("close");
  if (::close(pfrom[0]))perror("close");
  if (::close(pfrom[1]))perror("close");
  if (toTex)  execvp(a[0], a ); else execvp(b[0],b);
  perror(a[0]);
  exit(-1);
 }
                         //parent
 fd_from=pfrom[0];
 fd_to=pto[1];
 ::close(pto[0]);
 ::close(pfrom[1]);
 QString r("");

 write(fd_to,qstrdup(x),x.length());
 ::close(fd_to);
 do {
  i=read(fd_from,&c,1);
  if (i==1) r+=c;
  } while (i==1);
  if (i==-1) {
   perror("Error while reading pipe");
   r=x;
  }
  ::close(fd_from);
  printf("recoded %s TO %s\n",qstrdup(x),qstrdup(r));
  return r;
}
#else
#define recode(a,y) a
#endif

EditMask::EditMask(ApplicationWindow *parent, const char *name, Record e)
: QDialog(parent, name, TRUE)
{
  QFont fnt;
  QColor fg, bg, light, dark, mid, text, base;
  QColorGroup normal, disabled, active;
  QPalette pal;

  this->resize(915, 660);
  this->setCaption("Edit Entry");
  key_lab = new QLabel(this);
  key_lab->setGeometry(245, 20, 80, 30);
  key_lab->setText("Reference id");
  key_lab->setAlignment(33);
  ok = new QPushButton(this);
  ok->setGeometry(70, 615, 100, 30);
  ok->setText("Ok");
  ok->setToggleButton((bool)1);
  ok->setDefault((bool)1);
  ok->setAutoDefault((bool)1);
  cancel = new QPushButton(this);
  cancel->setGeometry(325, 615, 100, 30);
  cancel->setText("Cancel");
  cancel->setToggleButton((bool)1);
  abstract = new QPushButton(this);
  abstract->setGeometry(700, 600, 150, 20);
  abstract->setText("Abstract");
  auth_lab = new QLabel(this);
  auth_lab->setGeometry(700, 65, 100, 30);
  auth_lab->setText("Author(s)");
  auth_lab->setAlignment(33);
  editor_lab = new QLabel(this);
  editor_lab->setGeometry(700, 305, 100, 30);
  editor_lab->setText("Editor(s)");
  editor_lab->setAlignment(33);
  ref_label = new QLabel(this);
  ref_label->setGeometry(20, 20, 100, 30);
  ref_label->setText("Reference type");
  ref_label->setAlignment(33);
  reftype = new QComboBox(this);
  reftype->setGeometry(125, 20, 100, 30);
  reftype->setFocusPolicy((QWidget::FocusPolicy)3);
  id_edit = new QLineEdit(this);
  id_edit->setGeometry(330, 20, 100, 30);

  ee=e;
  char **c=entry_type+6;
  for (int i=0;*c;c++,i++){
   if (i==3) c++;                     // to avoid "conference"
   reftype->insertItem(*c);
  }  
  int i=(RecordType(e))-6; 
  if (i>2) i--;
  reftype->setCurrentItem(i); 
  id_edit->setText((RecordHeap(e))[0]);
  for (int i=0;i<NFIELD;i++){
   if (i==2) {
    browse=new QPushButton(this);
    browse->setText("journal");
    browse->setGeometry(10,25*i+60,60,25);
    connect(browse,SIGNAL(clicked()),this,SLOT(JBrowseList()));
   } else {  
    labels[i]=new QLabel(this); 
    labels[i]->setText(FIELDS[i]);
    labels[i]->setGeometry(10,25*i+60,90,25);
   }
   fields[i]=new QLineEdit(this);
   fields[i]->setText(recode(getfield(i),0)); 
   fields[i]->setCursorPosition(0);
   fields[i]->setGeometry(100,25*i+60,500,25);
  }
  auth_edit=new QMultiLineEdit(this);
  auth_edit->setGeometry(700,90,150,200);
  browse=new QPushButton(this);
  browse->setText("Browse");
  browse->setGeometry(700,290,150,20);
  connect(browse,SIGNAL(clicked()),this,SLOT(ABrowseList()));
  QStrList al;
  for (int i=2;i<(RecordFree(ee));i+=2)
    if (((RecordHeap(ee))[i])==symbol("author")) {
     al=getnames((RecordHeap(ee))[i+1]);
     break;
    }
  for (unsigned i=0;i<al.count();i++)
   auth_edit->append(recode(al.at(i),0));
  
  
  ed_edit=new QMultiLineEdit(this);
  ed_edit->setGeometry(700,330,150,200);
  browse=new QPushButton(this);
  browse->setText("Browse");
  browse->setGeometry(700,530,150,20);
  connect(browse,SIGNAL(clicked()),this,SLOT(EBrowseList()));
  QStrList el;
  for (int i=2;i<(RecordFree(ee));i+=2)
    if (((RecordHeap(ee))[i])==symbol("editor")) {
     el=getnames((RecordHeap(ee))[i+1]);
     break;
    }
  for (unsigned i=0;i<el.count();i++)
   ed_edit->append(recode(el.at(i),0));
  
  connect(ok,SIGNAL(clicked()),SLOT(update()));
  connect(cancel,SIGNAL(clicked()),SLOT(reject()));
  connect(abstract,SIGNAL(clicked()),SLOT(view_abstract()));
  connect(reftype,SIGNAL(activated(int)),SLOT(typechanged(int)));
  typechanged(reftype->currentItem()); 
}

EditMask::~EditMask()
{
}

/*!
*/

void EditMask::typechanged(int newtype) {
 int req_field[13][25]={
 {1,2,5,6,7,8,9,23},
 {1,5,8,7,17,12,10,6,11,23,24},
 {1,13,12,6,5},
 {1,3,4,9,19,5,8,7,17,12,10,6,11,23,24},
 {1,3,11,5,8,7,17,19,4,9,12,10,6,24},
 {1,3,5,7,8,17,9,12,6,16,11,18,24},
 {1,16,12,10,6,5,18},
 {1,15,5,19,12,6,18},
 {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,24},
 {1,15,5,19,12,6,18},
 {1,5,8,7,17,12,11,18,6,16,24},
 {1,14,5,19,7,12,6,18},
 {1,18,6,5},
 };
 for (int i=1;i<22;i++)
  fields[i]->setEnabled(0);
 ed_edit->setEnabled(0);
 int k;
 for (int i=0;i<25;i++){
  if (!(k=req_field[newtype][i])) break;
   else {
    if (k<22) fields[req_field[newtype][i]]->setEnabled(1);
    if (k==24) ed_edit->setEnabled(1);
   } 
 }
}

/*!
*/

QString EditMask::getfield(int f) {
 QString qs;
  for (int i=2;i<(RecordFree(ee));i+=2){
    if (((RecordHeap(ee))[i])==symbol(FIELDS[f])) qs=((RecordHeap(ee))[i+1]);
  }
  return strip_braces(qs);
}

void EditMask::JBrowseList(){
 BrowseList *bl=new BrowseList(2,this,"Journal names");
 bl->setCaption("journal names");
 bl->exec();
}
void EditMask::ABrowseList(){
 BrowseList *bl=new BrowseList(0,this,NULL);
 bl->setCaption("available names");
 bl->exec();
}
void EditMask::EBrowseList(){
 BrowseList *bl=new BrowseList(1,this,NULL);
 bl->setCaption("available names");
 bl->exec();
}
void EditMask::name_insert(const char* s,QMultiLineEdit *edit){
 int l,c;
 edit->cursorPosition(&l,&c);
 edit->removeLine(l);
 edit->insertLine(s,l);
 if (l==edit->numLines()-1) edit->append("\n");
 edit->setCursorPosition(l+1,c);
}

void EditMask::aname_insert(const char* s){
 name_insert(s,auth_edit);
}

void EditMask::ename_insert(const char* s){
 name_insert(s,ed_edit);
}

void EditMask::update(){
 QString qs;
 for (int i=0;i<NFIELD;i++){
  qs=recode(fields[i]->text(),1);
  if (!qs.isEmpty()) {
   if (qs[0]!='@') {qs.prepend("{");qs.append("}");} else qs=qs.remove(0,1);
   push_to_record(ee,symbol(FIELDS[i]),symbol((char *)qs.data()));
  } else { 
   for (int j=2;j<RecordFree(ee);j+=2)
    if (((RecordHeap(ee))[j])==symbol(FIELDS[i])) (RecordHeap(ee))[j]=NULL;
  }  
 }
 RecordType(ee)=reftype->currentItem()+6;
 if (RecordType(ee)>8) (RecordType(ee))++;   //to avoid "conference"
 QString a;
 int isstr=0;
 for (int j=0;j<2;j++){
  char *sym;
  a="";
  QMultiLineEdit *edit;
  if (!j) {
   sym=symbol("author");
   edit=auth_edit;
  } else {
   sym=symbol("editor");
   edit=ed_edit;
  }
  if (!strlen(edit->text())) {
   for (int i=2;i<RecordFree(ee);i+=2)
    if (((RecordHeap(ee))[i])==sym) (RecordHeap(ee))[i]=NULL;
   continue;
  }
  for (int i=0;i<edit->numLines();i++){
   const char *c=qstrdup(recode(edit->textLine(i),1));
   if (!c) continue;
   if (*c=='\0') continue;
   if (a.isEmpty()) {
    if (*c=='@') {
     a+=c+1;
     isstr=1;
    } else {
     a+="{";
     a+=c;
     isstr=0;
    } 
   } else {
    if (isstr) {
     a+=" { and } # ";
     if (*c=='@') a+=c+1;
      else {
       a+="{ and ";
       a+=c;
       isstr=0;
      } 
    } else {
     if (*c=='@') {a+="} # ";isstr=1;a+=c+1;} 
      else {
      a+=" and ";
      a+=c;
     } 
    }
   }
  }
  if ((!a.isEmpty()) && (!isstr)) a+="}";
  if (!a.isEmpty()) push_to_record(ee,sym,symbol(qstrdup((a.data()))));
 }
 rewrite_record(((ApplicationWindow*)(parent()))->db,ee);
 if ((*id_edit->text())) 
  (RecordHeap(ee))[0]=symbol((char *)id_edit->text());
 else
  make_key(((ApplicationWindow*)(parent()))->db,ee);
 emit accept();
}

void EditMask::view_abstract(){
 QString qs;
 AbsWin *a;
  for (int i=2;i<(RecordFree(ee));i+=2){
    if (((RecordHeap(ee))[i])==symbol("abstract")) qs=((RecordHeap(ee))[i+1]);
  }
  if (qs.isEmpty()) QMessageBox::information(this,"Abstract","This record does not contain an abstract field","OK",0,0,0,0);
  else {
   a=new AbsWin(this,strip_braces(qs));
   a->exec();
  }   
}
