.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "1.03",
.\"     date            = "19 February 1999",
.\"     time            = "12:34:05 MST",
.\"     filename        = "citetags.man",
.\"     address         = "Center for Scientific Computing
.\"                        University of Utah
.\"                        Department of Mathematics, 322 INSCC
.\"                        155 S 1400 E RM 233
.\"                        Salt Lake City, UT 84112-0090
.\"                        USA
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 585 1640, +1 801 581 4148",
.\"     checksum        = "41666 126 547 4764",
.\"     email           = "beebe@math.utah.edu, beebe@acm.org,
.\"                        beebe@ieee.org (Internet)",
.\"     URL             = "http://www.math.utah.edu/~beebe",
.\"     checksum        = "48699 195 869 6955",
.\"     email           = "beebe@math.utah.edu, beebe@acm.org,
.\"                        beebe@ieee.org (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, BibTeX, citation label,
.\"                        citation tag",
.\"     supported       = "yes",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the citetags command, a shell script
.\"                        that invokes an awk program to extract
.\"                        citation tags from a LaTeX source file or
.\"                        .aux file for later use with citefind(1).
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.if n .ds La LaTeX
.if t .ds La L\\h'-0.24m'\\v'-0.15v'\\s-2A\\s+2\\h'-0.15m'\\v'0.15v'T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.TH CITETAGS 1 "19 February 1999" "Version 1.03"
.\"======================================================================
.SH NAME
citetags \- extract BibTeX citation tags from a LaTeX source or .aux file
.\"======================================================================
.SH SYNOPSIS
.BI citetags " LaTeX source or .aux file >tagsfile"
.\"======================================================================
.SH DESCRIPTION
.B citetags
extracts \*(Bi\& citation tags from a \*(La\& source file or
.I .aux
file and sends them to
.IR stdout ,
possibly for later input to
.BR citefind (1).
.PP
.B citetags
and
.BR citefind (1)
can be used to extract from a large \*(Bi\&
bibliography data base just those bibliography
entries that are actually used in a particular
document, perhaps for submission to a publisher,
or distribution in electronic form.
.\"======================================================================
.SH BUGS
.B citetags
is not smart enough to incorporate \*(Bi\& cross
references unless they are themselves cited.
.PP
That feature should be added.
.\"======================================================================
.SH "SEE ALSO"
.BR bibcheck (1),
.BR bibclean (1),
.BR bibdup (1),
.BR bibextract (1),
.BR bibjoin (1),
.BR biblabel (1),
.BR biblex (1),
.BR biborder (1),
.BR bibparse (1),
.BR bibsort (1),
.BR bibtex (1),
.BR bibunlex (1),
.BR citefind (1),
.BR citesub (1),
.BR gawk (1),
.BR latex (1),
.BR nawk (1),
.BR tex (1).
.\"======================================================================
.SH FILES
.\" NB: LIBDIR and BINDIR are substituted for real directory names
.\"     by a sed script invoked by "make install".
.TP \w'@LIBDIR@/citetags.awk'u+2n
@LIBDIR@/citetags.awk
.BR nawk (1)
program for tag extraction.
.TP
@BINDIR@/citetags
user-callable shell script to invoke
.BR nawk (1).
.\"======================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 322 INSCC
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
USA
Tel: +1 801 581 5254
FAX: +1 801 585 1640, +1 801 581 4148
Email: beebe@math.utah.edu, beebe@acm.org, beebe@ieee.org (Internet)
WWW: http://www.math.utah.edu/~beebe
.fi
.\"==============================[The End]==============================
