/****************************************************************************
** $Id: application.h,v 1.5 1998/06/23 09:47:41 warwick Exp $
**
** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifndef APPLICATION_H
#define APPLICATION_H

#include <qmainwindow.h>
#include <qlistview.h>
#include <qstrlist.h>
#include <qtoolbutton.h> 
#include <qfiledialog.h>
#include "entry.h"
#include "MyLV.h"
#include "FindDial.h"

class QToolBar;
class QPopupMenu;

class ApplicationWindow: public QMainWindow
{
    Q_OBJECT
public:
    ApplicationWindow(int isFind=0);
    ~ApplicationWindow();
    void readfromaux(char *);
    DB db;
    QStrList journalnames,authornames;
    MyLVI *addEntry(Record);
    QToolButton *fileOpen,*filePrint,*fileSave;
    int fw, edited;
    MyLV *lv;
    virtual bool close(bool);
private slots:
    void load();
    void load( char *fileName );
    void save();
    void save_as();
    void print();
    void doprint();
    void closeDoc();
    void find();
    void closeFile_slot();
    void edit_Entry(QListViewItem *);
    void edit_Entry();
    void about();

private:
    void closeFile();
    QString getFileName(int opendial);
    void save(const char*,int real=1);
    QFileDialog *qfd;
    MyLVI *lvi;
    QToolBar *fileTools;
    QPopupMenu *controls;
    bool realprint;
    QString fn;

protected:
 void resizeEvent(class QResizeEvent *);
 
public slots:
 void hide();
};


#endif
