/*
 * Copyright (c) 1992, Bruno Grossniklaus, grossnik@iam.unibe.ch
 * 
 * I added new features for special use at the IAM and fixed some bugs.
 * 
 */

/*
 * Copyright (c) 1990, William C. Ogden, ogden@nmsu.edu
 * 
 * Permission is granted to copy and distribute this file in modified or
 * unmodified form, for noncommercial use, provided (a) this copyright notice
 * is preserved, (b) no attempt is made to restrict redistribution of this
 * file, and (c) this file is not distributed as part of any collection whose
 * redistribution is restricted by a compilation copyright.
 */





#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <xview/dragdrop.h>
#include <xview/cursor.h>
#include <xview/notice.h>
#include <gdd.h>

#include "bc_show.h"


/* local globals */
int             inum;


extern void
show_ref_type(type_id)
	int             type_id;
{
        offset_xv_y = (int) xv_get(Bc_properties_popup->properties_popup_offset_xv_y, PANEL_VALUE, NULL);
	ref_types_show_fct[type_id].show_fct();
}



extern void
hide_all()
{
	/* hide all textpanels but keep the citekey, key and ref_type fields */

	int             i;

	for (i = 1; i < num_of_fields; i++)
		if ((i != citekey_id) && (i != key_id))
			xv_set(field_ptr[i], XV_SHOW, FALSE, NULL);

	/* not in the panel item list are ... */
	xv_set(Bc_base_window->base_window_message_or_1,
	       XV_SHOW, FALSE,
	       NULL);
	xv_set(Bc_base_window->base_window_message_or_2,
	       XV_SHOW, FALSE,
	       NULL);
	xv_set(Bc_base_window->base_window_message_and_or,
	       XV_SHOW, FALSE,
	       NULL);
	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_SHOW, FALSE,
	       NULL);
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_SHOW, FALSE,
	       NULL);
	xv_set(Bc_base_window->base_window_month_button,
	       XV_SHOW, FALSE,
	       NULL);
#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_SHOW, FALSE,
	       NULL);
#endif

}



/*
 * Current_item
 */

extern void
show_current_item()
{
	int             i;

	hide_all();

	/* set the panel values */
	for (i = 0; i < num_of_fields; i++) {
		if ((*current_item).field[i])
			xv_set(field_ptr[i], PANEL_VALUE, (*current_item).field[i], NULL);
		else
			xv_set(field_ptr[i], PANEL_VALUE, "", NULL);
	}

	textsw_delete(Bc_annotation_popup->annotation_popup_textplane, NULL, TEXTSW_INFINITY);
	textsw_reset(Bc_annotation_popup->annotation_popup_textplane, NULL, NULL);

	if ((*current_item).annote)
		textsw_insert(Bc_annotation_popup->annotation_popup_textplane, (*current_item).annote, strlen((*current_item).annote));

	xv_set(Bc_annotation_popup->annotation_popup_textplane, TEXTSW_FIRST, NULL, NULL);


	textsw_delete(Bc_ns_popup->ns_popup_textplane, NULL, TEXTSW_INFINITY);
	textsw_reset(Bc_ns_popup->ns_popup_textplane, NULL, NULL);

	if ((*current_item).nsfield)
		textsw_insert(Bc_ns_popup->ns_popup_textplane, (*current_item).nsfield, strlen((*current_item).nsfield));

	xv_set(Bc_ns_popup->ns_popup_textplane, TEXTSW_FIRST, NULL, NULL);


	annote_edit_count = (int) xv_get(Bc_annotation_popup->annotation_popup_textplane, TEXTSW_EDIT_COUNT);
	ns_edit_count = (int) xv_get(Bc_ns_popup->ns_popup_textplane, TEXTSW_EDIT_COUNT);
	edit_count = (int) xv_get(Bc_abbrev_popup->abbrev_popup_textplane, TEXTSW_EDIT_COUNT);

	xv_set(Bc_base_window->base_window_month_button, PANEL_VALUE, -1, NULL);

	i = 0;
	while ((i < NUM_OF_REF_TYPES) && (strcasecmp(current_item->ref_type, ref_types_show_fct[i].ref_type_token) != NULL))
		i++;

	if ((i < NUM_OF_REF_TYPES) && (strcasecmp(current_item->ref_type, ref_types_show_fct[i].ref_type_token) == NULL)) {
		xv_set(Bc_base_window->base_window_ref_type, PANEL_VALUE, i, NULL);
		show_ref_type(i);
	}
	if (i == NUM_OF_REF_TYPES) {
		fprintf(PRINT_TO, "bibcard: ERROR in show_current_item()!\n");
		fprintf(PRINT_TO, "bibcard: %s is not a reference type.\n", current_item->ref_type);
		exit(ERROR);
	}
	if ((int) xv_get(Bc_expand_popup->expand_popup, XV_SHOW) == TRUE) {
		textsw_delete(Bc_expand_popup->expand_popup_textplane, NULL, TEXTSW_INFINITY);
		textsw_reset(Bc_expand_popup->expand_popup_textplane, NULL, NULL);
		textsw_insert(Bc_expand_popup->expand_popup_textplane,
			      (char *) xv_get(expand_item, PANEL_VALUE),
			 strlen((char *) xv_get(expand_item, PANEL_VALUE)));
		xv_set(Bc_expand_popup->expand_popup_textplane, TEXTSW_FIRST, NULL, NULL);
	}
}



/*
 * article
 */

extern void
show_article()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_journal;
	xv_set(Bc_base_window->base_window_journal,
	       XV_X, JOURNAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_volume;
	xv_set(Bc_base_window->base_window_volume,
	       XV_X, VOLUME_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_or_2,
	       XV_X, MESSAGE_OR_2_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + ( ((line - 1) * offset_xv_y + (line * offset_xv_y)) / 2 ),
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_number;
	xv_set(Bc_base_window->base_window_number,
	       XV_X, NUMBER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_pages;
	xv_set(Bc_base_window->base_window_pages,
	       XV_X, PAGES_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

	last_field = inum - 1;
}



/*
 * book
 */

extern void
show_book()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_or_1,
	       XV_X, MESSAGE_OR_1_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + ( ((line - 1) * offset_xv_y + (line * offset_xv_y)) / 2 ),
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_editor;
	xv_set(Bc_base_window->base_window_editor,
	       XV_X, EDITOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_publisher;
	xv_set(Bc_base_window->base_window_publisher,
	       XV_X, PUBLISHER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_volume;
	xv_set(Bc_base_window->base_window_volume,
	       XV_X, VOLUME_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_or_2,
	       XV_X, MESSAGE_OR_2_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + ( ((line - 1) * offset_xv_y + (line * offset_xv_y)) / 2 ),
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_number;
	xv_set(Bc_base_window->base_window_number,
	       XV_X, NUMBER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_series;
	xv_set(Bc_base_window->base_window_series,
	       XV_X, SERIES_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_address;
	xv_set(Bc_base_window->base_window_address,
	       XV_X, ADDRESS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_edition;
	xv_set(Bc_base_window->base_window_edition,
	       XV_X, EDITION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif


	last_field = inum - 1;
}


/*
 * booklet
 */

extern void
show_booklet()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_howpublished;
	xv_set(Bc_base_window->base_window_howpublished,
	       XV_X, HOWPUBLISHED_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_address;
	xv_set(Bc_base_window->base_window_address,
	       XV_X, ADDRESS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

	last_field = inum - 1;
}



extern void
show_conference()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_booktitle;
	xv_set(Bc_base_window->base_window_booktitle,
	       XV_X, BOOKTITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);


	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_editor;
	xv_set(Bc_base_window->base_window_editor,
	       XV_X, EDITOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_volume;
	xv_set(Bc_base_window->base_window_volume,
	       XV_X, VOLUME_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_or_2,
	       XV_X, MESSAGE_OR_2_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + ( ((line - 1) * offset_xv_y + (line * offset_xv_y)) / 2 ),
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_number;
	xv_set(Bc_base_window->base_window_number,
	       XV_X, NUMBER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_series;
	xv_set(Bc_base_window->base_window_series,
	       XV_X, SERIES_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_pages;
	xv_set(Bc_base_window->base_window_pages,
	       XV_X, PAGES_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_address;
	xv_set(Bc_base_window->base_window_address,
	       XV_X, ADDRESS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_organization;
	xv_set(Bc_base_window->base_window_organization,
	       XV_X, ORGANIZATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_publisher;
	xv_set(Bc_base_window->base_window_publisher,
	       XV_X, PUBLISHER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

	last_field = inum - 1;
}




/*
 * In Book
 */

extern void
show_inbook()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_or_1,
	       XV_X, MESSAGE_OR_1_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + ( ((line - 1) * offset_xv_y + (line * offset_xv_y)) / 2 ),
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_editor;
	xv_set(Bc_base_window->base_window_editor,
	       XV_X, EDITOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_chapter;
	xv_set(Bc_base_window->base_window_chapter,
	       XV_X, CHAPTER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_and_or,
	       XV_X, MESSAGE_AND_OR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + ( ((line - 1) * offset_xv_y + (line * offset_xv_y)) / 2 ),
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_pages;
	xv_set(Bc_base_window->base_window_pages,
	       XV_X, PAGES_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_publisher;
	xv_set(Bc_base_window->base_window_publisher,
	       XV_X, PUBLISHER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_volume;
	xv_set(Bc_base_window->base_window_volume,
	       XV_X, VOLUME_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_or_2,
	       XV_X, MESSAGE_OR_2_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + ( ((line - 1) * offset_xv_y + (line * offset_xv_y)) / 2 ),
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_number;
	xv_set(Bc_base_window->base_window_number,
	       XV_X, NUMBER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_series;
	xv_set(Bc_base_window->base_window_series,
	       XV_X, SERIES_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_type;
	xv_set(Bc_base_window->base_window_type,
	       XV_X, TYPE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_address;
	xv_set(Bc_base_window->base_window_address,
	       XV_X, ADDRESS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_edition;
	xv_set(Bc_base_window->base_window_edition,
	       XV_X, EDITION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

	last_field = inum - 1;
}



/*
 * In Collection
 */

extern void
show_incollection()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_booktitle;
	xv_set(Bc_base_window->base_window_booktitle,
	       XV_X, BOOKTITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_publisher;
	xv_set(Bc_base_window->base_window_publisher,
	       XV_X, PUBLISHER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_editor;
	xv_set(Bc_base_window->base_window_editor,
	       XV_X, EDITOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_volume;
	xv_set(Bc_base_window->base_window_volume,
	       XV_X, VOLUME_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_or_2,
	       XV_X, MESSAGE_OR_2_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + ( ((line - 1) * offset_xv_y + (line * offset_xv_y)) / 2 ),
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_number;
	xv_set(Bc_base_window->base_window_number,
	       XV_X, NUMBER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_series;
	xv_set(Bc_base_window->base_window_series,
	       XV_X, SERIES_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);


	nxt_fld[inum++] = Bc_base_window->base_window_type;
	xv_set(Bc_base_window->base_window_type,
	       XV_X, TYPE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_chapter;
	xv_set(Bc_base_window->base_window_chapter,
	       XV_X, CHAPTER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_pages;
	xv_set(Bc_base_window->base_window_pages,
	       XV_X, PAGES_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);


	nxt_fld[inum++] = Bc_base_window->base_window_address;
	xv_set(Bc_base_window->base_window_address,
	       XV_X, ADDRESS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_edition;
	xv_set(Bc_base_window->base_window_edition,
	       XV_X, EDITION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X + 1 * OFFSET_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X + 1 * OFFSET_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

	last_field = inum - 1;
}



/*
 * In Proceedings
 */

extern void
show_inproceedings()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_booktitle;
	xv_set(Bc_base_window->base_window_booktitle,
	       XV_X, BOOKTITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);


	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_editor;
	xv_set(Bc_base_window->base_window_editor,
	       XV_X, EDITOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_volume;
	xv_set(Bc_base_window->base_window_volume,
	       XV_X, VOLUME_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_or_2,
	       XV_X, MESSAGE_OR_2_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + ( ((line - 1) * offset_xv_y + (line * offset_xv_y)) / 2 ),
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_number;
	xv_set(Bc_base_window->base_window_number,
	       XV_X, NUMBER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_series;
	xv_set(Bc_base_window->base_window_series,
	       XV_X, SERIES_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_pages;
	xv_set(Bc_base_window->base_window_pages,
	       XV_X, PAGES_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_address;
	xv_set(Bc_base_window->base_window_address,
	       XV_X, ADDRESS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);


	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_organization;
	xv_set(Bc_base_window->base_window_organization,
	       XV_X, ORGANIZATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_publisher;
	xv_set(Bc_base_window->base_window_publisher,
	       XV_X, PUBLISHER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

	last_field = inum - 1;
}



/*
 * Manual
 */

extern void
show_manual()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_organization;
	xv_set(Bc_base_window->base_window_organization,
	       XV_X, ORGANIZATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_address;
	xv_set(Bc_base_window->base_window_address,
	       XV_X, ADDRESS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_edition;
	xv_set(Bc_base_window->base_window_edition,
	       XV_X, EDITION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif


	last_field = inum - 1;
}



/*
 * Masters Thesis
 */

extern void
show_mastersthesis()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_school;
	xv_set(Bc_base_window->base_window_school,
	       XV_X, SCHOOL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_type;
	xv_set(Bc_base_window->base_window_type,
	       XV_X, TYPE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_address;
	xv_set(Bc_base_window->base_window_address,
	       XV_X, ADDRESS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

	last_field = inum - 1;
}


/*
 * Misc
 */

extern void
show_misc()
{
	int             inum = 2;
	int             line = 0;

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_howpublished;
	xv_set(Bc_base_window->base_window_howpublished,
	       XV_X, HOWPUBLISHED_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

	last_field = inum - 1;
}


/*
 * PhD Thesis
 */

extern void
show_phdthesis()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_school;
	xv_set(Bc_base_window->base_window_school,
	       XV_X, SCHOOL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_type;
	xv_set(Bc_base_window->base_window_type,
	       XV_X, TYPE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_address;
	xv_set(Bc_base_window->base_window_address,
	       XV_X, ADDRESS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

	last_field = inum - 1;
}

/*
 * Proceedings
 */

extern void
show_proceedings()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_editor;
	xv_set(Bc_base_window->base_window_editor,
	       XV_X, EDITOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_volume;
	xv_set(Bc_base_window->base_window_volume,
	       XV_X, VOLUME_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_or_2,
	       XV_X, MESSAGE_OR_2_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + ( ((line - 1) * offset_xv_y + (line * offset_xv_y)) / 2 ),
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_number;
	xv_set(Bc_base_window->base_window_number,
	       XV_X, NUMBER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_series;
	xv_set(Bc_base_window->base_window_series,
	       XV_X, SERIES_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_address;
	xv_set(Bc_base_window->base_window_address,
	       XV_X, ADDRESS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_organization;
	xv_set(Bc_base_window->base_window_organization,
	       XV_X, ORGANIZATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_publisher;
	xv_set(Bc_base_window->base_window_publisher,
	       XV_X, PUBLISHER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

	last_field = inum - 1;
}



/*
 * Tech Report
 */

extern void
show_techreport()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_institution;
	xv_set(Bc_base_window->base_window_institution,
	       XV_X, INSTITUTION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_type;
	xv_set(Bc_base_window->base_window_type,
	       XV_X, TYPE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_number;
	xv_set(Bc_base_window->base_window_number,
	       XV_X, NUMBER_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_address;
	xv_set(Bc_base_window->base_window_address,
	       XV_X, ADDRESS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

	last_field = inum - 1;
}



/*
 * Unpublished
 */

extern void
show_unpublished()
{
	int             inum = 2;
	int             line = 0;

	nxt_fld[inum++] = Bc_base_window->base_window_author;
	xv_set(Bc_base_window->base_window_author,
	       XV_X, AUTHOR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_title;
	xv_set(Bc_base_window->base_window_title,
	       XV_X, TITLE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_note;
	xv_set(Bc_base_window->base_window_note,
	       XV_X, NOTE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_message_optionalfields,
	       XV_X, MESSAGE_OPTIONAL_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	xv_set(Bc_base_window->base_window_month_button,
	       XV_X, MONTH_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_month;
	xv_set(Bc_base_window->base_window_month,
	       XV_X, MONTH_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_year;
	xv_set(Bc_base_window->base_window_year,
	       XV_X, YEAR_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

if (num_of_fields != STD_NUM_OF_FIELDS) {
	xv_set(Bc_base_window->base_window_message_user_fields,
	       XV_X, MESSAGE_USER_FIELDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
}

#ifdef CRINDEX_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crindex;
	xv_set(Bc_base_window->base_window_crindex,
	       XV_X, CRINDEX_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef CROSS_REF_KEY_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_crossref;
	xv_set(Bc_base_window->base_window_crossref,
	       XV_X, CROSSREF_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef DATE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_date;
	xv_set(Bc_base_window->base_window_date,
	       XV_X, DATE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef KEYWORDS_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_keywords;
	xv_set(Bc_base_window->base_window_keywords,
	       XV_X, KEYWORDS_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef LOCATION_FIELD
	xv_set(Bc_base_window->base_window_location_button,
	       XV_X, LOCATION_BUTTON_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);

	nxt_fld[inum++] = Bc_base_window->base_window_location;
	xv_set(Bc_base_window->base_window_location,
	       XV_X, LOCATION_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef SIGNATURE_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_signature;
	xv_set(Bc_base_window->base_window_signature,
	       XV_X, SIGNATURE_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

#ifdef ISBN_FIELD
	nxt_fld[inum++] = Bc_base_window->base_window_isbn;
	xv_set(Bc_base_window->base_window_isbn,
	       XV_X, ISBN_XV_X,
	       XV_Y, (LINE_1_XV_Y + 3 * offset_xv_y) + line++ * offset_xv_y,
	       XV_SHOW, TRUE,
	       NULL);
#endif

	last_field = inum - 1;
}
