/* Definitions and headers for communication with W32
   Copyright (C) 1989, 1993, 1994 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef __MW32TERM__
#define __MW32TERM__
#include <windows.h>
#include "w32gui.h"
#ifdef MW32_FONT
#include "mw32font.h"
#endif
/* #include "frame.h" */



#ifdef MW32_FONT
#else
typedef struct w32_font_t
{
  TEXTMETRIC tm ;
  HFONT hfont ;
} w32_font_t ;
#endif

#define PIX_TYPE Color
#define BLACK_PIX_DEFAULT PALETTERGB(0,0,0)
#define WHITE_PIX_DEFAULT PALETTERGB(255,255,255)

#define ROOT_WINDOW GetDesktopWindow()
#ifdef MW32_FONT
#define FONT_TYPE fs_fonts
#else
#define FONT_TYPE w32_font_t
#endif

#ifdef MW32_FONT
#define FONT_WIDTH(font) ((font) -> hmetric)
#define FONT_HEIGHT(font) ((font) -> vmetric)
#define FONT_OVERHANG(font) ((font) -> overhang)
#define FONT_BASE(font) ((font) -> font_base)
#define FRAME_FONT(f) ((f) -> output_data.w32 -> font)
#define FRAME_FONTSET(f) ((f) -> output_data.w32 -> fontset)
#define FRAME_FONT_BASELINE(f) ((f) -> output_data.w32 -> font_baseline)
#define FRAME_CURRENT_CURSOR(f) ((f) ->  output_data.w32 -> current_cursor)
#define FRAME_CURSOR_HEIGHT(f) ((f) ->  output_data.w32 -> cursor_height)
#define FONT_HFONT(font, prop)                                             \
((MWF_GET_FONT((font), (prop))!=0)?(MWF_GET_FONT((font), (prop))):         \
(get_hfont((font), (prop))))
#define FRAME_FONT_WIDTH(f) (FONT_WIDTH(FRAME_FONT(f)))
#define FRAME_FONT_HEIGHT(f) (FONT_HEIGHT(FRAME_FONT(f)))
#define FRAME_FONT_OVERHANG(f) (FONT_OVERHANG(FRAME_FONT(f)))
#define FRAME_FONT_BASE(f) (FONT_BASE(FRAME_FONT(f)))
#define FACE_PROPERTY(face) ((FACE_BOLD_P(face)? BOLD_FONT_PROPERTY:0)+    \
                             (FACE_ITALIC_P(face)?ITALIC_FONT_PROPERTY:0))
#else
#define FONT_WIDTH(f)	((f)->tm.tmAveCharWidth) 
#define FONT_HEIGHT(f)	((f)->tm.tmHeight)
#define FONT_OVERHANG(f) ((f)->tm.tmOverhang) /* 96.3.22 by himi */
#define FONT_BASE(f)    ((f)->tm.tmAscent)
#endif

extern struct frame *w32_window_to_frame ();

/* multi display not supported ..... */

/* The frame (if any) which has the window that has keyboard focus.
   Zero if none.  This is examined by Ffocus_frame in w32fns.c.  Note
   that a mere EnterNotify event can set this; if you need to know the
   last frame specified in a FocusIn or FocusOut event, use
   w32_focus_event_frame.  
   (temporaryly use w32_focus_frame) */

extern struct frame *w32_focus_frame;

/* Height of this X screen in pixels.  */
extern int w32_screen_height;

/* Height of this X screen in millimeters.  */
extern int w32_screen_height_mm;

/* Width of this X screen in pixels.  */
extern int w32_screen_width;

/* Width of this X screen in millimeters.  */
extern int w32_screen_width_mm;

/* Number of planes for this screen.  */
extern int w32_screen_planes;

/* Mask of which mouse buttons are currently held down.  */
extern unsigned int w32_mouse_grabbed;


enum text_cursor_kinds {
  filled_box_cursor,
  hollow_box_cursor,
  bar_cursor,
  caret_cursor,
  checkered_caret_cursor,
  hairline_caret_cursor
};

/* Each W32 frame object points to its own struct w32_display object
   in the output_data.w32 field.  The w32_output structure contains all
   the information that is specific to w32.  */

struct w32_output
{
#ifdef TERMINAL_FACE
  struct f_display f;
#endif

  /* Position of the X window (x and y offsets in root window).  */
  int left_pos;
  int top_pos;

  /* Border width of the X window as known by the X window system.  */
  int border_width;

  /* Size of the X window in pixels.  */
  int pixel_height, pixel_width;

  /* Height of a line, in pixels.  */
  int line_height;

  /* 1 means frame size is about to change.
     2 means frame size has been already changed and adjusted.  */
  int frame_change_state;

  /* 0 means the frame has no caret.
     1 means the frame has a caret, but which is invisible.
     2 means the frame has a caret, which is visible. */
  int caret_state;

#ifdef MULE
  /* Upper space of each line, in pixels. */
  int upper_space;

  /* Lower space of each line, in pixels. */
  int lower_space;
#endif  /* MULE */

  /* Width of the internal border.  This is a line of background color
     just inside the window's border.  When the frame is selected,
     a highlighting is displayed inside the internal border.  */
  int internal_border_width;

  /* The X window used for this frame.
     May be zero while the frame object is being created
     and the X window has not yet been created.  */
  HWND window_desc;

  /* The X window used for the bitmap icon;
     or 0 if we don't have a bitmap icon.  */
  HWND icon_desc;

  /* The X window that is the parent of this X window.
     Usually but not always RootWindow.  */
  HWND parent_desc;

  /* frame menubar handle */
  HANDLE menubar_handle;

  /* Event handle to inform 
     message loop thread that mainthread have done something
     on the frame. */
  HANDLE mainthread_to_frame_handle;

  /* If this flag is set, menubar is never reconstructed.
     This is used mainly during menubar activation.*/
  int disable_reconstruct_menubar;

  W32FontStruct *font;

  /* The baseline position of the default ASCII font.  */
  int font_baseline;

  /* If a fontset is specified for this frame instead of font, this
     value contains an ID of the fontset, else -1.  */
  int fontset;

  /* Pixel values used for various purposes.
     border_pixel may be -1 meaning use a gray tile.  */
  PIX_TYPE background_pixel;
  PIX_TYPE foreground_pixel;
  PIX_TYPE cursor_pixel;
  PIX_TYPE border_pixel;
  PIX_TYPE mouse_pixel;
  PIX_TYPE cursor_foreground_pixel;

  /* Descriptor for the cursor in use for this window.  */
  HCURSOR text_cursor;
  HCURSOR nontext_cursor;
  HCURSOR modeline_cursor;
  HCURSOR cross_cursor;

  /* The name that was associated with the icon, the last time
     it was refreshed.  Usually the same as the name of the
     buffer in the currently selected window in the frame */
  char *icon_label;

  /* Flag to set when the X window needs to be completely repainted.  */
  int needs_exposure;

  /* What kind of text cursor is drawn in this window right now?
     (If there is no cursor (phys_cursor_x < 0), then this means nothing.)  */
  enum text_cursor_kinds current_cursor;


  /* Cursor height. Range is 0 - 4, means glyph_height*x/4.
     0 means line (or dot) which width is window border. */
  int cursor_height;

  /* What kind of text cursor should we draw in the future?
     This should always be filled_box_cursor or bar_cursor.  */
  enum text_cursor_kinds desired_cursor;

  /* The window style flags */

  DWORD dwStyle;
  DWORD dwStyleEx;

  /* The size of the extra width currently allotted for vertical
     scroll bars, in pixels.  */
  int vertical_scroll_bar_extra;

  /* Table of parameter faces for this frame.  Any X resources (pixel
     values, fonts) referred to here have been allocated explicitly
     for this face, and should be freed if we change the face.  */
  struct face **param_faces;
  int n_param_faces;

#ifndef TERMINAL_FACE
  /* Table of computed faces for this frame.  These are the faces
     whose indexes go into the upper bits of a glyph, computed by
     combining the parameter faces specified by overlays, text
     properties, and what have you.  The X resources mentioned here
     are all shared with parameter faces.  */
  struct face **computed_faces;
  int n_computed_faces;		/* How many are valid */
  int size_computed_faces;	/* How many are allocated */
#endif
};

#ifndef TERMINAL_FACE
/* Get at the computed faces of an W32 frame.  */
#define FRAME_PARAM_FACES(f) ((f)->output_data.w32->param_faces)
#define FRAME_N_PARAM_FACES(f) ((f)->output_data.w32->n_param_faces)
#define FRAME_DEFAULT_PARAM_FACE(f) (FRAME_PARAM_FACES (f)[0])
#define FRAME_MODE_LINE_PARAM_FACE(f) (FRAME_PARAM_FACES (f)[1])

#define FRAME_COMPUTED_FACES(f) ((f)->output_data.w32->computed_faces)
#define FRAME_N_COMPUTED_FACES(f) ((f)->output_data.w32->n_computed_faces)
#define FRAME_SIZE_COMPUTED_FACES(f) ((f)->output_data.w32->size_computed_faces)
#define FRAME_DEFAULT_FACE(f) ((f)->output_data.w32->computed_faces[0])
#define FRAME_MODE_LINE_FACE(f) ((f)->output_data.w32->computed_faces[1])
#endif

/* Return the window associated with the frame F.  */
#define FRAME_W32_WINDOW(f) ((f)->output_data.w32->window_desc)

#define FRAME_FOREGROUND_PIXEL(f) ((f)->output_data.w32->foreground_pixel)
#define FRAME_BACKGROUND_PIXEL(f) ((f)->output_data.w32->background_pixel)
#define FRAME_INTERNAL_BORDER_WIDTH(f) ((f)->output_data.w32->internal_border_width)

/* These two really ought to be called FRAME_PIXEL_{WIDTH,HEIGHT}.  */
#define PIXEL_WIDTH(f) ((f)->output_data.w32->pixel_width)
#define PIXEL_HEIGHT(f) ((f)->output_data.w32->pixel_height)
#define FRAME_LINE_HEIGHT(f) ((f)->output_data.w32->line_height)

#define FRAME_DESIRED_CURSOR(f) ((f)->output_data.w32->desired_cursor)


/* When X windows are used, a glyph may be a 16 bit unsigned datum.
   The high order byte is the face number and is used as an index
   in the face table.  A face is a font plus:
    1) the unhighlighted foreground color,
    2) the unhighlighted background color.
   For highlighting, the two colors are exchanged.
   Face number 0 is unused.  The low order byte of a glyph gives
   the character within the font.  All fonts are assumed to be
   fixed width, and to have the same height and width.  */

#define MAX_FACES_AND_GLYPHS 256
extern struct face *w32_face_table[];


/* X-specific scroll bar stuff.  */

/* We represent scroll bars as lisp vectors.  This allows us to place
   references to them in windows without worrying about whether we'll
   end up with windows referring to dead scroll bars; the garbage
   collector will free it when its time comes.

   We use struct scroll_bar as a template for accessing fields of the
   vector.  */

struct scroll_bar {

  /* These fields are shared by all vectors.  */
  int size_from_Lisp_Vector_struct;
  struct Lisp_Vector *next_from_Lisp_Vector_struct;

  /* The window we're a scroll bar for.  */
  Lisp_Object window;

  /* The next and previous in the chain of scroll bars in this frame.  */
  Lisp_Object next, prev;

  /* The X window representing this scroll bar.  Since this is a full
     32-bit quantity, we store it split into two 32-bit values.  */
  Lisp_Object w32_window_low, w32_window_high;

  /* The position and size of the scroll bar in pixels, relative to the
     frame.  */
  Lisp_Object top, left, width, height;

  /* The starting and ending positions of the handle, relative to the
     handle area (i.e. zero is the top position, not
     SCROLL_BAR_TOP_BORDER).  If they're equal, that means the handle
     hasn't been drawn yet.

     These are not actually the locations where the beginning and end
     are drawn; in order to keep handles from becoming invisible when
     editing large files, we establish a minimum height by always
     drawing handle bottoms VERTICAL_SCROLL_BAR_MIN_HANDLE pixels below
     where they would be normally; the bottom and top are in a
     different co-ordinate system.  */
  Lisp_Object start, end;

  /* If the scroll bar handle is currently being dragged by the user,
     this is the number of pixels from the top of the handle to the
     place where the user grabbed it.  If the handle isn't currently
     being dragged, this is Qnil.  */
  Lisp_Object dragging;
};

/* The number of elements a vector holding a struct scroll_bar needs.  */
#define SCROLL_BAR_VEC_SIZE \
  ((sizeof (struct scroll_bar) - sizeof (int) - sizeof (struct Lisp_Vector *)) \
   / sizeof (Lisp_Object))

/* Turning a lisp vector value into a pointer to a struct scroll_bar.  */
#define XSCROLL_BAR(vec) ((struct scroll_bar *) XPNTR (vec))


/* Building a 32-bit C integer from two 16-bit lisp integers.  */
#define SCROLL_BAR_PACK(low, high) (XINT (high) << 16 | XINT (low))

/* Setting two lisp integers to the low and high words of a 32-bit C int.  */
#define SCROLL_BAR_UNPACK(low, high, int32) \
  (XSET ((low),  Lisp_Int,  (int32)        & 0xffff), \
   XSET ((high), Lisp_Int, ((int32) >> 16) & 0xffff))


/* Extract the X window id of the scroll bar from a struct scroll_bar.  */
#define SCROLL_BAR_W32_WINDOW(ptr) \
  ((HWND) SCROLL_BAR_PACK ((ptr)->w32_window_low, (ptr)->w32_window_high))

/* Store a window id in a struct scroll_bar.  */
#define SET_SCROLL_BAR_W32_WINDOW(ptr, id) \
  (SCROLL_BAR_UNPACK ((ptr)->w32_window_low, (ptr)->w32_window_high, (int) id))


/* Return the outside pixel height for a vertical scroll bar HEIGHT
   rows high on frame F.  */
#define VERTICAL_SCROLL_BAR_PIXEL_HEIGHT(f, height) \
  ((height) * (f)->output_data.w32->line_height)

/* Return the inside width of a vertical scroll bar, given the outside
   width.  */
#define VERTICAL_SCROLL_BAR_INSIDE_WIDTH(width) \
  ((width) - VERTICAL_SCROLL_BAR_LEFT_BORDER - VERTICAL_SCROLL_BAR_RIGHT_BORDER)

/* Return the inside width of a vertical scroll bar, given the outside
   width.  */
#define VERTICAL_SCROLL_BAR_INSIDE_WIDTH(width) \
  ((width) - VERTICAL_SCROLL_BAR_LEFT_BORDER - VERTICAL_SCROLL_BAR_RIGHT_BORDER)

/* Return the length of the rectangle within which the top of the
   handle must stay.  This isn't equivalent to the inside height,
   because the scroll bar handle has a minimum height.  

   This is the real range of motion for the scroll bar, so when we're
   scaling buffer positions to scroll bar positions, we use this, not
   VERTICAL_SCROLL_BAR_INSIDE_HEIGHT.  */
#if 0 /* modified by himi 96.9.18 */
#define VERTICAL_SCROLL_BAR_TOP_RANGE(height) \
  (VERTICAL_SCROLL_BAR_INSIDE_HEIGHT (height) - VERTICAL_SCROLL_BAR_MIN_HANDLE)
#else
#define VERTICAL_SCROLL_BAR_TOP_RANGE(height) 0xffff
#endif

/* Return the inside height of vertical scroll bar, given the outside
   height.  See VERTICAL_SCROLL_BAR_TOP_RANGE too.  */
#define VERTICAL_SCROLL_BAR_INSIDE_HEIGHT(height) \
  ((height) - VERTICAL_SCROLL_BAR_TOP_BORDER - VERTICAL_SCROLL_BAR_BOTTOM_BORDER)


/* Border widths for scroll bars.

   Scroll bar windows don't have any X borders; their border width is
   set to zero, and we redraw borders ourselves.  This makes the code
   a bit cleaner, since we don't have to convert between outside width
   (used when relating to the rest of the screen) and inside width
   (used when sizing and drawing the scroll bar window itself).

   The handle moves up and down/back and forth in a rectangle inset
   from the edges of the scroll bar.  These are widths by which we
   inset the handle boundaries from the scroll bar edges.  */
#define VERTICAL_SCROLL_BAR_LEFT_BORDER (0)
#define VERTICAL_SCROLL_BAR_RIGHT_BORDER (0)
#define VERTICAL_SCROLL_BAR_TOP_BORDER (0)
#define VERTICAL_SCROLL_BAR_BOTTOM_BORDER (0)

/* Minimum lengths for scroll bar handles, in pixels.  */
#define VERTICAL_SCROLL_BAR_MIN_HANDLE (5)


/* Manipulating pixel sizes and character sizes.
   Knowledge of which factors affect the overall size of the window should
   be hidden in these macros, if that's possible.

/* Return the upper/left pixel position of the character cell on frame F
   at ROW/COL.  */
#define CHAR_TO_PIXEL_ROW(f, row) \
  ((f)->output_data.w32->internal_border_width \
   + (row) * (f)->output_data.w32->line_height)
#ifdef MEADOW
#define CHAR_TO_PIXEL_COL(f, col) \
  ((f)->output_data.w32->internal_border_width \
   + (col) * FRAME_FONT_WIDTH(f))
#else
#define CHAR_TO_PIXEL_COL(f, col) \
  ((f)->output_data.w32->internal_border_width \
   + (col) * FONT_WIDTH ((f)->output_data.w32->font))
#endif

/* Return the pixel width/height of frame F if it has
   WIDTH columns/HEIGHT rows.  */
#define CHAR_TO_PIXEL_WIDTH(f, width) \
  (CHAR_TO_PIXEL_COL (f, width) \
   + (f)->output_data.w32->vertical_scroll_bar_extra \
   + (f)->output_data.w32->internal_border_width)
#define CHAR_TO_PIXEL_HEIGHT(f, height) \
  (CHAR_TO_PIXEL_ROW (f, height) \
   + (f)->output_data.w32->internal_border_width)


/* Return the row/column (zero-based) of the character cell containing 
   the pixel on FRAME at ROW/COL.  */
#define PIXEL_TO_CHAR_ROW(f, row) \
  (((row) - (f)->output_data.w32->internal_border_width) \
   / (f)->output_data.w32->line_height)

#ifdef MEADOW
#define PIXEL_TO_CHAR_COL(f, col) \
  (((col) - (f)->output_data.w32->internal_border_width) \
   / FRAME_FONT_WIDTH (f))
#else
#define PIXEL_TO_CHAR_COL(f, col) \
  (((col) - (f)->output_data.w32->internal_border_width) \
   / FONT_WIDTH ((f)->output_data.w32->font))
#endif

/* How many columns/rows of text can we fit in WIDTH/HEIGHT pixels on
   frame F?  */
#define PIXEL_TO_CHAR_WIDTH(f, width) \
  (PIXEL_TO_CHAR_COL (f, ((width) \
			  - (f)->output_data.w32->internal_border_width \
			  - (f)->output_data.w32->vertical_scroll_bar_extra)))
#define PIXEL_TO_CHAR_HEIGHT(f, height) \
  (PIXEL_TO_CHAR_ROW (f, ((height) \
			  - (f)->output_data.w32->internal_border_width)))

/* If a struct input_event has a kind which is selection_request_event
   or selection_clear_event, then its contents are really described
   by this structure.  */

/* For an event of kind selection_request_event,
   this structure really describes the contents.  */
struct selection_input_event
{
  int kind;
  HWND requestor;
  ATOM selection, target, property;
  Time time;
};

#define SELECTION_EVENT_REQUESTOR(eventp)	\
  (((struct selection_input_event *) (eventp))->requestor)
#define SELECTION_EVENT_SELECTION(eventp)	\
  (((struct selection_input_event *) (eventp))->selection)
#define SELECTION_EVENT_TARGET(eventp)	\
  (((struct selection_input_event *) (eventp))->target)
#define SELECTION_EVENT_PROPERTY(eventp)	\
  (((struct selection_input_event *) (eventp))->property)
#define SELECTION_EVENT_TIME(eventp)	\
  (((struct selection_input_event *) (eventp))->time)


/* Interface to the face code functions.  */

/* Create the first two computed faces for a frame -- the ones that
   have GC's.  */
extern void init_frame_faces (/* FRAME_PTR */);

/* Free the resources for the faces associated with a frame.  */
extern void free_frame_faces (/* FRAME_PTR */);

/* Given a computed face, find or make an equivalent display face
   in face_vector, and return a pointer to it.  */
extern struct face *intern_face (/* FRAME_PTR, struct face * */);

/* Given a frame and a face name, return the face's ID number, or
   zero if it isn't a recognized face name.  */
extern int face_name_id_number (/* FRAME_PTR, Lisp_Object */);

/* Return non-zero if FONT1 and FONT2 have the same size bounding box.
   We assume that they're both character-cell fonts.  */
extern int same_size_fonts (/* XFontStruct *, XFontStruct * */);

/* Recompute the GC's for the default and modeline faces.
   We call this after changing frame parameters on which those GC's
   depend.  */
extern void recompute_basic_faces (/* FRAME_PTR */);

/* Return the face ID associated with a buffer position POS.  Store
   into *ENDPTR the next position at which a different face is
   needed.  This does not take account of glyphs that specify their
   own face codes.  F is the frame in use for display, and W is a
   window displaying the current buffer.

   REGION_BEG, REGION_END delimit the region, so it can be highlighted.  */
extern int compute_char_face (/* FRAME_PTR frame,
				 struct window *w,
				 int pos,
				 int region_beg, int region_end,
				 int *endptr */);
/* Return the face ID to use to display a special glyph which selects
   FACE_CODE as the face ID, assuming that ordinarily the face would
   be BASIC_FACE.  F is the frame.  */
extern int compute_glyph_face (/* FRAME_PTR, int */);

/* disable to hide mouse cursor */
void lock_mouse_cursor_visible(/* int lock */);


/* Bit Gravity */

#define ForgetGravity		0
#define NorthWestGravity	1
#define NorthGravity		2
#define NorthEastGravity	3
#define WestGravity		4
#define CenterGravity		5
#define EastGravity		6
#define SouthWestGravity	7
#define SouthGravity		8
#define SouthEastGravity	9
#define StaticGravity		10

#define NoValue		0x0000
#define XValue  	0x0001
#define YValue		0x0002
#define WidthValue  	0x0004
#define HeightValue  	0x0008
#define AllValues 	0x000F
#define XNegative 	0x0010
#define YNegative 	0x0020

#define USPosition	(1L << 0) /* user specified x, y */
#define USSize		(1L << 1) /* user specified width, height */

#define PPosition	(1L << 2) /* program specified position */
#define PSize		(1L << 3) /* program specified size */
#define PMinSize	(1L << 4) /* program specified minimum size */
#define PMaxSize	(1L << 5) /* program specified maximum size */
#define PResizeInc	(1L << 6) /* program specified resize increments */
#define PAspect		(1L << 7) /* program specified min and max aspect ratios */
#define PBaseSize	(1L << 8) /* program specified base for incrementing */
#define PWinGravity	(1L << 9) /* program specified window gravity */

/* Message definitions */

#define WM_EMACS_PRIVATE_START (WM_USER + 2000)
#define WM_EMACS_PRIVATE_END (WM_USER + 3000)

#define IS_EMACS_PRIVATE_MESSAGE(message)    \
  (((message) >= WM_EMACS_PRIVATE_START) &&  \
   ((message) < WM_EMACS_PRIVATE_END))

#define WM_EMACS_SIZE                              (WM_USER+2000)
#define WM_EMACS_MOVE                              (WM_USER+2001)
#define WM_EMACS_DESTROY                           (WM_USER+2002)
#define WM_EMACS_ACTIVATE                          (WM_USER+2003)
#define WM_EMACS_CLOSE_CONNECTION                  (WM_USER+2004)
#define WM_EMACS_CREATE_FRAME                      (WM_USER+2005) 
#define WM_EMACS_POPUP_MENU                        (WM_USER+2006)
#define WM_EMACS_DESTROY_FRAME                     (WM_USER+2007)
#define WM_EMACS_FLASH_WINDOW                      (WM_USER+2008)
#define WM_EMACS_SETCARET                          (WM_USER+2009)
#define WM_EMACS_CLEAR_MOUSE_FACE                  (WM_USER+2010)
/* to report "switch-buffer" event by himi */
#define WM_IME_REPORT     0x0280
#define IR_STRING         0x140
#define IR_OPENCONVERT    0x120
#define IR_CLOSECONVERT   0x122

#define IDM_UNDO 100
#ifdef W32_SCROLLBAR
#define WM_EMACS_VSCROLL                           (WM_USER+2020)
#define WM_EMACS_CREATE_SCROLLBAR                  (WM_USER+2021)
#define WM_EMACS_DESTROY_SCROLLBAR                 (WM_USER+2022)
#endif

#define WM_EMACS_CREATE_FRAME_REPLY                (WM_USER+2050)
#define WM_EMACS_CREATE_SCROLLBAR_REPLY            (WM_USER+2051)
#define WM_EMACS_DESTROY_FRAME_REPLY               (WM_USER+2052)
#define WM_EMACS_POPUP_MENU_REPLY                  (WM_USER+2053)
#define WM_EMACS_SETLOCALE                         (WM_USER+2054)
#define WM_EMACS_SETKEYBOARDLAYOUT                 (WM_USER+2055)
#define WM_EMACS_REGISTER_HOT_KEY                  (WM_USER+2056)
#define WM_EMACS_UNREGISTER_HOT_KEY                (WM_USER+2057)

/* This method guarantee message reachability.
   But you must deal with any messages sent by this method in
   window procedure.  You cannot deal with them in the thread
   message loop(W32read_socket). */
#define SEND_INFORM_MESSAGE(window, message, wparam, lparam)     \
  (SendMessage ((window), (message), (wparam), (lparam)))

/*
  You should avoid using this method to send message to the
  message thread if possible.  Although this method guarantee
  message reachablity even when message thread has no window,
  you must deal with any messages sent by this method
  both in the thread message loop(W32read_socket) and
  in the window procedure(normally w32_WndProc).
*/
#define SEND_MSGTHREAD_INFORM_MESSAGE(message, wparam, lparam)       \
  do {                                                               \
    if (w32_frame_window != INVALID_HANDLE_VALUE)                    \
      SendMessage(w32_frame_window, (message), (wparam), (lparam));  \
    else                                                             \
      while (!PostThreadMessage (msg_thread_id, (message),           \
                                 (wparam), (lparam)))                \
        sleep(1);                                                    \
  }while(0)

/* If you want to add message operating function that is
   effective both in the thread message loop(W32read_socket)
   and in the window procedure(normally w32_WndProc),
   declare such function declarations here. */
extern void w32_create_frame_window (struct frame *f, LPSTR title);
#ifdef IME_CONTROL
extern void w32_ime_create_agent();
#endif

/* This method does NOT guarantee message reachability
   if its destination is the message thread. */
#define POST_THREAD_INFORM_MESSAGE(thread, message, wparam, lparam)    \
  while (!PostThreadMessage ((thread), (message), (wparam), (lparam))) \
    sleep(1)

/* This method does NOT guarantee message reachability in any case. */
#define POST_INFORM_MESSAGE(window, message, wparam, lparam)      \
  while (!PostMessage ((window), (message), (wparam), (lparam)))  \
    sleep(1)

#define WAIT_REPLY_MESSAGE(ret, msgno)                           \
  do {                                                           \
    GetMessage ((ret), NULL, 0, 0);                              \
  } while((ret)->message != (msgno))                             \

  

/* The class of this Windows application.  */
#ifdef MEADOW
#define EMACS_CLASS "MEADOW"
#else
#define EMACS_CLASS "Emacs"
#endif

#ifdef W32_INTELLIMOUSE
#ifndef WM_MOUSEWHEEL
#define WM_MOUSEWHEEL 0x20A
#endif
#ifndef WHEEL_DELTA
#define WHEEL_DELTA 120
#endif
#ifndef SPI_GETWHEELSCROLLLINES
#define SPI_GETWHEELSCROLLLINES 104
#endif
#ifndef WHEEL_PAGESCROLL
#define WHEEL_PAGESCROLL (0xffffffff)
#endif
#endif

#ifdef MEADOW
#ifndef VK_KANJI
#define VK_KANJI 0x19
#endif
#ifndef VK_KANA
#define VK_KANA  0x15
#endif
#define VK_COMPEND 0x1A
#define WM_MEADOW_CREATE_WINDOW    (WM_USER+2100)
#define WM_MEADOW_CREATE_SCROLLBAR (WM_USER+2101)

/* For internal communications
   from window procedure to event loop. */
#define WM_MULE_IME_REPORT         (WM_USER+2200)
#define WM_MULE_IME_STATUS         (WM_USER+2201)


#endif

#ifdef IME_CONTROL

/* For internal communications
   from main thread to window procedure. */
#define WM_MULE_IMM_MESSAGE_START             (WM_USER+2300)
#define WM_MULE_IMM_SET_STATUS                (WM_USER+2300)
#define WM_MULE_IMM_GET_STATUS                (WM_USER+2301)
#define WM_MULE_IMM_DEAL_WITH_CONTEXT         (WM_USER+2302)
#define WM_MULE_IMM_SET_COMPOSITION_STRING    (WM_USER+2303)
#define WM_MULE_IMM_GET_COMPOSITION_STRING    (WM_USER+2304)
#define WM_MULE_IMM_SET_MODE                  (WM_USER+2305)
#define WM_MULE_IMM_NOTIFY                    (WM_USER+2310)
#define WM_MULE_IMM_GET_UNDETERMINED_STRING_LENGTH (WM_USER+2320)
#define WM_MULE_IMM_MESSAGE_END               (WM_USER+2399)
#define MESSAGE_IMM_COM_P(message)              \
  (((message) >= WM_MULE_IMM_MESSAGE_START) &&  \
   ((message) <= WM_MULE_IMM_MESSAGE_END))

/* For synchronization
   to create conversion agent
   between main thread and event loop. */
#define WM_MULE_IME_CREATE_AGENT        (WM_USER+2400)
#define WM_MULE_IME_CREATE_AGENT_REPLY  (WM_USER+2401)
#define WM_MULE_IME_DESTROY_AGENT       (WM_USER+2402)
#define WM_MULE_IME_DESTROY_AGENT_REPLY (WM_USER+2403)
#define CONVAGENT_CLASS "ConvAgent"

#define WM_MULE_IMM_SET_COMPOSITION_FONT       (WM_USER+2404)
#define WM_MULE_IMM_SET_COMPOSITION_FONT_REPLY (WM_USER+2405)

#endif

extern void w32_fill_rect () ;

#define w32_fill_area(f,hdc,pix,x,y,nx,ny) \
{ \
    RECT rect ; \
    rect.left = x ; \
    rect.top = y ; \
    rect.right = x + nx ; \
    rect.bottom = y + ny ; \
    w32_fill_rect (f,hdc,pix,&rect) ; \
}

#define w32_clear_rect(f,hdc,lprect) \
w32_fill_rect (f,hdc,f->output_data.w32->background_pixel,lprect)

#define w32_clear_area(f,hdc,x,y,nx,ny) \
w32_fill_area (f,hdc,f->output_data.w32->background_pixel,x,y,nx,ny)

#define MapMode(hdc) (hdc)
/* extern HDC MapMode() ; */
/* Modified by himi */

#define MyGetDC(hwnd) (MapMode(GetDC(hwnd)))

extern int GetKeyModifierState();
#define W32GETMODIFIER GetKeyModifierState()

#define W32GETMOUSEMODIFIER(mouse) \
 (W32GETMODIFIER | (mouse ? up_modifier : down_modifier))

extern void menubar_selection_callback (HWND hwnd, int client_data);

extern void w32_display_cursor ();
extern int w32_get_glyph_width(struct frame *f, GLYPH g);
extern void x_set_window_size ();

/* Message Handling thread & its id.  */
extern HANDLE msg_thread;
extern DWORD msg_thread_id;

/* Main thread & its id. */
extern HANDLE main_thread;
extern DWORD main_thread_id;

/* flag if mw32term is blocked in message loop. */
extern int message_loop_blocked_p;

/* If the system has already created frame, this variable is set to
   its window handle.  This variable is used for sending message to
   window procedure. */
extern HWND w32_frame_window;

#ifdef MEADOW
/* for decoding to "w32_coding_system".  */
extern Lisp_Object Vw32_system_coding_system;

#define MEADOW_DECODE_BUF buf_mule_decode_01211

#define MEADOW_DECODE_ALLOC_PREDEFINE \
TCHAR *MEADOW_DECODE_BUF; \
struct coding_system mccode_mule_decode_01211; \
int bufsize_mule_decoding_01211

#define MEADOW_DECODE_ALLOC(len) \
setup_coding_system(Fcheck_coding_system(Vw32_system_coding_system), \
		    &mccode_mule_decode_01211); \
bufsize_mule_decoding_01211 = decoding_buffer_size(&mccode_mule_decode_01211, (len));\
MEADOW_DECODE_BUF = alloca(bufsize_mule_decoding_01211);

#define MEADOW_DECODE(string, len) \
(decode_coding(&mccode_mule_decode_01211, \
	       (string), MEADOW_DECODE_BUF, (len), bufsize))

#define MEADOW_DECODE_PRODUCED (mccode_mule_decode_01211.produced)

/* for encoding.  */

#define MEADOW_ENCODE_BUF buf_mule_encode_01211

#define MEADOW_ENCODE_ALLOC_PREDEFINE \
TCHAR *MEADOW_ENCODE_BUF; \
struct coding_system mccode_mule_encode_01211; \
int bufsize_mule_encoding_01211


#define MEADOW_ENCODE_ALLOC(len) \
(setup_coding_system(Fcheck_coding_system(Vw32_system_coding_system), \
		     &mccode_mule_encode_01211)); \
bufsize_mule_encoding_01211 = encoding_buffer_size(&mccode_mule_encode_01211, (len));\
MEADOW_ENCODE_BUF = alloca(bufsize_mule_encoding_01211);

#define MEADOW_ENCODE(string, len) \
(encode_coding(&mccode_mule_encode_01211, \
	       (string), MEADOW_ENCODE_BUF, (len), bufsize_mule_encoding_01211))
	       
#define MEADOW_ENCODE_PRODUCED (mccode_mule_encode_01211.produced)
#endif

#define LISPY_STRING_BYTES(str) (STRING_BYTES(XSTRING(str)))
#define LISPY_STRING_CHARS(str) (XSTRING(str)->size)

#endif /* __MW32TERM__ */
