;;; default.el --- load auto-autoload.el

;;; Copyright (C) 2002-2009 The Meadow Team

;; Author: KOSEKI Yoshinori <kose@meadowy.org>
;;         Koichiro Ohba <koichiro@meadowy.org>
;; Keywords: elisp

;;; Commentary:

;; Emacs Lisp Packages for Meadow.

;; If you don't want to load this file, set ~/.emacs.
;; (setq inhibit-default-init t)

;;; Code:

;;; Meadow/packages
;;; emacs/packages


(setq netinstall-pkg-dir (expand-file-name (concat data-directory 
					     "../packages")))
(unless (file-exists-p netinstall-pkg-dir)
  (setq netinstall-pkg-dir (expand-file-name (concat data-directory 
					       "../../packages")))
  (unless (file-exists-p netinstall-pkg-dir)
    (setq netinstall-pkg-dir nil)))
    
;; When Meadow/packages/pkginfo/***/auto-autoloads.el exists, load it.
(let* ((dir (expand-file-name "pkginfo" netinstall-pkg-dir))
       (dirs (directory-files dir))
      el)
  (while dirs
    (setq el (concat dir "/" (car dirs) "/auto-autoloads.el"))
    (if (file-exists-p el)
	(load-file el))
    (setq dirs (cdr dirs))))

;; add Netinstalled info path ($MEADOW/info)
(defadvice info-initialize
  (after info-initialize-after activate)
  "add directory `$MEADOW/info' to Info-directory-list." 
  (let ((dir (expand-file-name "info" netinstall-pkg-dir)))
    (unless (member dir Info-directory-list)
      (setq Info-directory-list (append (list dir) Info-directory-list)))))

;; source-directory
(unless (file-exists-p source-directory)
  (setq source-directory (expand-file-name "../src" netinstall-pkg-dir)))

;; add svn revision
(when (featurep 'meadow)
  (defadvice Meadow-version (after Meadow-version-after activate)
    "Add svn revison to Meadow-version(f)"
    (let ((info (expand-file-name "../.svn.info" data-directory))
	  str rev date)
      (when (file-exists-p info)
	(save-excursion
	  (set-buffer (find-file-noselect info))
	  (setq str (buffer-substring-no-properties 
		     (point-min) (- (point-max) 1)))
	  (string-match "^Last Changed Rev: \\([0-9]+\\)" str)
	  (setq rev (substring str (match-beginning 1) (match-end 1)))
	  (string-match "^Last Changed Date: \\([0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]\\)" str)
	  (setq date (substring str (match-beginning 1) (match-end 1)))
	  (kill-buffer nil))
	(setq ad-return-value (concat ad-return-value " (" date " Rev." rev ")"))))))

;;; default.el ends here
