;;; cheat-font-lock.el --- modify font-lock-keywords
;;; Copyright (c) 2002, 2003, 2004, 2005
;;;   by HIRAOKA Kazuyuki <khi@users.sourceforge.jp>
;;; $Id: cheat-font-lock.el,v 1.15 2005/07/24 12:24:20 hira Exp $
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 1, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; The GNU General Public License is available by anonymouse ftp from
;;; prep.ai.mit.edu in pub/gnu/COPYING.  Alternately, you can write to
;;; the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
;;; USA.
;;--------------------------------------------------------------------

;; depends on internal implementation of font-lock.el

;; renamed from howm-font-lock.el [2003-12-12]

(require 'font-lock)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; This code is canceled because it caused a bug on howm-1.2.2rc5.
;; cheat-font-lock-merge-keywords must support compiled keywords for current
;; implementation of riffle-contents-mode. [2005-04-28]
;; See below.
;; snap:///~/elisp/howm/howm-view.el#223:(define-derived-mode howm-view-contents-mode riffle-contents-mode "HowmC"
;; snap:///~/elisp/howm/howm-view.el#256:(cheat-font-lock-merge-keywords howm-view-contents-font-lock-keywords
;; 
;; (if (and (fboundp 'font-lock-add-keywords) (>= emacs-major-version 21))
;;     (progn
;;       (defun cheat-font-lock-merge-keywords (&rest keywords-list)
;;         ;; compiled keywords are not supported in keywords-list.
;;         (font-lock-add-keywords nil (apply #'append keywords-list) 'set))
;;       (defun cheat-font-lock-append-keywords (entries)
;;         (font-lock-add-keywords nil entries 'append))
;;       (defun cheat-font-lock-prepend-keywords (entries)
;;         (font-lock-add-keywords nil entries))
;;       ;; inhibit warning. sigh...
;;       (defun cheat-font-lock-20040624-format-p () nil)
;;       (defun cheat-font-lock-compiled-p (keywords) nil)
;;       (defun cheat-font-lock-compiled-body (keywords) nil)
;;       )
;;   (progn
;;     ;; for xemacs and emacs20
;;     ))

(defun cheat-font-lock-20040624-format-p ()
  (= (length (font-lock-compile-keywords '(("dummy" . 'dummy)))) 3)) ;; dirty
(defun cheat-font-lock-compiled-p (keywords)
  (eq (car-safe keywords) t))
(if (cheat-font-lock-20040624-format-p)
    (defun cheat-font-lock-compiled-body (keywords)
      (cddr keywords))
  (defun cheat-font-lock-compiled-body (keywords)
    (cdr keywords)))
(defun cheat-font-lock-keywords (keywords)
  (if (cheat-font-lock-compiled-p keywords)
      (cheat-font-lock-compiled-body keywords)
    keywords))
(defun cheat-font-lock-merge-keywords (&rest keywords-list)
  (let ((bodies-list (mapcar #'cheat-font-lock-keywords keywords-list)))
    (setq font-lock-keywords
          (apply #'append bodies-list))))
(defun cheat-font-lock-append-keywords (entries)
  (cheat-font-lock-merge-keywords font-lock-keywords entries))
(defun cheat-font-lock-prepend-keywords (entries)
  (cheat-font-lock-merge-keywords entries font-lock-keywords))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun cheat-font-lock-mode (&optional silent)
  "Enable font-lock-mode without calling fontify-buffer."
  ;; For xemacs. But this seems to have no effect. ;_; [2004-01-14]
  (when silent
    (set (make-local-variable 'font-lock-verbose) nil))
  ;; Keywords are not highlighted on the fly in emacs-21.3.50.1
  ;; when font-lock-defaults is nil. I don't understand this. [2003-11-28]
  (when (null font-lock-defaults)
    (set (make-local-variable 'font-lock-defaults) '(nil)))
  ;; Without the next line, global value is changed to t. [2003-12-30]
  ;; (emacs-20.7.2 on Vine Linux 2.6)
  (make-local-variable 'font-lock-fontified)
  (let* ((font-lock-fontified t) ;; adjourn fontify-buffer
         (bname (buffer-name))
         (need-rename (eq (aref (buffer-name) 0) ?\ )))
    ;; Rename invisible buffer in order to force font-lock-mode.
    ;; cf. snap:///usr/share/emacs/21.2/lisp/font-lock.el#694:(define-minor-mode font-lock-mode
    (when need-rename
      (rename-buffer (concat "xxx-" bname) t))
    (font-lock-mode 1)
    (when need-rename
      (rename-buffer bname)))
  (font-lock-set-defaults))

;; ;; for emacs20 and xemacs
;; (defun cheat-font-lock-jit-p (&optional i-dont-understand-this)
;;   (and (fboundp 'font-lock-fontify-block)
;;        (boundp 'jit-lock-mode)
;;        (or i-dont-understand-this
;;            (progn
;;              (defvar jit-lock-mode t) ;; Inhibit warning. Sigh...
;;              jit-lock-mode))))
;; (defun cheat-font-lock-fontify (&optional i-dont-understand-this)
;;   (if (cheat-font-lock-jit-p i-dont-understand-this)
;;       (font-lock-fontify-block)
;;     (font-lock-fontify-buffer)))

;; cancel [2005-07-23]
;; I give up slow font-lock for emacs20.
;; http://pc8.2ch.net/test/read.cgi/unix/1077881095/743-744n
;; 
;; ;; pending
;; ;; I can't tell whether this is really needed, because the report
;; ;; didn't specify versions of emacs and howm.
;; 
;; ;; 2005-07-13  HIRAOKA Kazuyuki  <khi@users.sourceforge.jp>
;; ;;
;; ;; 	* cheat-font-lock.el (cheat-font-lock-fontifier): new option.
;; ;; 	thx > http://pc8.2ch.net/test/read.cgi/unix/1077881095/736
;; 
;; (defcustom cheat-font-lock-fontifier 'font-lock-fontify-buffer
;;   "Function to fontify buffer.
;; It should be `font-lock-fontify-buffer' in most environments.
;; If font-lock is too slow, consider to use `font-lock-fontify-block' insted.
;; The latter case may happen in emacs20."
;;   :type '(radio (const :tag "fontify whole buffer" font-lock-fontify-buffer)
;;                 (const :tag "fontify block only" font-lock-fontify-block)
;;                 function)
;;   :group 'howm-efficiency
;;   :group 'howm-faces)
;; (defun cheat-font-lock-fontify (&optional dummy)
;;   (funcall cheat-font-lock-fontifier))

(defun cheat-font-lock-fontify (&optional dummy)
  (font-lock-fontify-buffer))

(provide 'cheat-font-lock)

;;; cheat-font-lock.el ends here
