;; -*- Mode: Emacs-Lisp -*-
;;
;; elscreen-howm.el
;;
(defconst elscreen-howm-version "0.0.1 (December 16, 2005)")
;;
;; Author:   Naoto Morishima <naoto@morishima.net>
;; Created:  November 6, 2005
;; Revised:  December 16, 2005

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

(provide 'elscreen-howm)
(require 'elscreen)
(require 'howm)


;;; User Customizable Variables:

(defcustom elscreen-howm-mode-to-nickname-alist
  '(("^howm-\\(menu-mode$\\|view-\\)" . "howm(menu)"))
  "*Alist composed of the pair of mode-name and corresponding screen-name."
  :type '(alist :key-type string :value-type (choice string function))
  :tag "Howm major-mode to nickname alist"
  :set (lambda (symbol value)
         (custom-set-default symbol value)
	 (elscreen-rebuild-mode-to-nickname-alist))
  :group 'howm)
(elscreen-set-mode-to-nickname-alist 'elscreen-howm-mode-to-nickname-alist)

(defcustom elscreen-howm-buffer-to-nickname-alist
  '(("\\.howm$" .
     (lambda (buf)
       (format "howm(%s)" (substring (buffer-name buf) 0 -5)))))
  "*Alist composed of the pair of regular expression of
buffer-name and corresponding screen-name."
  :type '(alist :key-type string :value-type (choice string function))
  :tag "Howm buffer to nickname alist"
  :set (lambda (symbol value)
         (custom-set-default symbol value)
	 (elscreen-rebuild-buffer-to-nickname-alist))
  :group 'howm)
(elscreen-set-buffer-to-nickname-alist 'elscreen-howm-buffer-to-nickname-alist)


;;; Code:

;; delete other windows when howm-menu is invoked
(defadvice howm-menu (around elscreen-howm-menu activate)
  (delete-other-windows)
  ad-do-it)

;; open existing page with new screen from menu directly
(defadvice howm-keyword-search (around elscreen-howm-keyword-search-1 activate)
  (let ((current-screen (elscreen-get-current-screen))
	(window-configuration (elscreen-current-window-configuration)))
    ad-do-it
    (when (ad-get-arg 2)
      (elscreen-set-window-configuration current-screen window-configuration))))

(defadvice howm-view-contents-open-sub (around elscreen-howm-view-contents-open-sub activate)
  (let ((elscreen-window-configuration (elscreen-current-window-configuration))
	howm-buffer)
    ad-do-it
    (setq howm-buffer (current-buffer))
    (elscreen-apply-window-configuration elscreen-window-configuration)
    (elscreen-find-and-goto-by-buffer howm-buffer 'create)))

;; create new page with new screen
(defadvice howm-create-file-with-title (around elscreen-howm-create-file-with-title activate)
  (save-current-buffer
    (elscreen-create))
  ad-do-it)

;; search keyword or related
(defmacro elscreen-howm-search-or-related (ad-do-it)
  (` (let ((target-screen
	    (or (elscreen-find-screen-by-buffer (howm-menu-name howm-menu-top))
		(elscreen-find-screen-by-buffer howm-view-summary-name)
		(elscreen-find-screen-by-buffer howm-view-contents-name)
		(elscreen-get-current-screen))))
       (elscreen-goto target-screen)
       (, ad-do-it))))

(defadvice howm-keyword-search (around elscreen-howm-keyword-search-2 activate)
  (elscreen-howm-search-or-related ad-do-it))

(defadvice howm-list-related (around elscreen-howm-list-related activate)
  (elscreen-howm-search-or-related ad-do-it))

;; kill screen when exiting from howm-mode
(defun howm-save-and-kill-buffer/screen ()
  (interactive)
  (let* ((file-name (buffer-file-name)))
    (when (and file-name (string-match "\\.howm" file-name))
      (if (save-excursion
	    (goto-char (point-min))
	    (re-search-forward "[^ \t\r\n]" nil t))
	  (howm-save-buffer)
	(set-buffer-modified-p nil)
	(when (file-exists-p file-name)
	  (delete-file file-name)
	  (message "(Deleted %s)" (file-name-nondirectory file-name))))
      (kill-buffer nil)
      (unless (elscreen-one-screen-p)
	(elscreen-kill)))))

(eval-after-load "howm-mode"
  '(progn
     (define-key howm-mode-map
       "\C-c\C-c" 'howm-save-and-kill-buffer/screen)))
