;; -*- Mode: Emacs-Lisp -*-
;;
;; elscreen-wl.el 
;;
(defconst elscreen-w3m-version "0.1.0 (November 12, 2005)")
;;
;; Author:   Naoto Morishima <naoto@morishima.net>
;; Created:  August 6, 2004
;; Revised:  November 12, 2005

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

(provide 'elscreen-w3m)
(require 'elscreen)

(add-hook 'w3m-mode-hook
	  (lambda ()
	    (eval '(elscreen-screen-modified-hook-setup
		    (w3m-fontify-after-hook force-immediately)))))

(defadvice w3m-goto-url-new-session (around elscreen-w3m-create activate)
  (if (< (elscreen-get-number-of-screens) 10)
      (elscreen-create)
    (split-window)
    (other-window 1))
  ad-do-it)
