;;; tex-site.el - Site specific variables.  Don't edit.

;; Copyright (C) 1991, 2000, 2001 Kresten Krab Thorup
;; Copyright (C) 1993, 1994, 1997, 1999,
;;               2003, 2004 Free Software Foundation, Inc.

;; Author: Per Abrahamsen <abraham@dina.kvl.dk>
;; Maintainer: auc-tex@sunsite.dk
;; Keywords: tex

;; This file is part of AUCTeX.

;; AUCTeX is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; AUCTeX is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with AUCTeX; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Commentary:

;; This file used to contain variables customized for the local site.
;; This way of customizing AUCTeX should no longer be used.  All
;; relevant variables can be customized by using
;; M-x customize-variable RET
;; on them.  Copying stuff into this file, as was recommended
;; previously, would interfere with the operation of customize.
;;
;; Basically, this file contains a bunch of autoloads and
;; automatically generated information.  AUCTeX is enabled by placing
;; (require 'tex-site)
;; into a user's .emacs file, or the administrator can insert it in
;; the site-start.el file for a site-wide default.
;;
;; The right place for this file is in the `site-lisp' directory.

;;; Code:

(if (< emacs-major-version 21)
  (error "AUCTeX requires Emacs 21 or later"))

(defvar no-doc
  "This function is part of AUCTeX, but has not yet been loaded.
Full documentation will be available after autoloading the function."
  "Documentation for autoload functions.")

(defvar TeX-lisp-directory (expand-file-name (concat data-directory 
					     "../packages/lisp/auctex"))
   "*The directory where most of the AUCTeX lisp files are located.
tex-site.el (wherein this variable is defined) resides in its parent
directory. For the location of lisp files associated with styles, see
the variables TeX-style-* (hand-generated lisp) and TeX-auto-*
(automatically generated lisp).")

(defvar TeX-image-directory (expand-file-name
			     "images"
			     TeX-lisp-directory)
  "*The directory where the AUCTeX images are located.")

(defcustom TeX-auto-global "/usr/local/var/auctex"
  "*Directory containing automatically generated information.
Must end with a directory separator.

For storing automatic extracted information about the TeX macros
shared by all users of a site."
  :group 'TeX-file
  :type 'directory)

;;; Autoloads:

(add-to-list 'auto-mode-alist '("\\.dtx\\'" . doctex-mode))
(add-to-list 'auto-mode-alist '("\\.drv\\'" . latex-mode))

(add-to-list 'load-path TeX-lisp-directory)

;; This hook will store bibitems when you save a BibTeX buffer.
(add-hook 'bibtex-mode-hook 'BibTeX-auto-store)
(autoload 'BibTeX-auto-store "latex" no-doc t)

(autoload 'tex-mode "tex" no-doc t)
(autoload 'plain-tex-mode "tex" no-doc t)
(autoload 'ams-tex-mode "tex" no-doc t)
(autoload 'context-mode "context" no-doc t)
(autoload 'doctex-mode "latex" no-doc t)
(autoload 'TeX-auto-generate "tex" no-doc t)
(autoload 'TeX-auto-generate-global "tex" no-doc t)
(autoload 'TeX-insert-quote "tex" no-doc t)
(autoload 'TeX-submit-bug-report "tex" no-doc t)
(autoload 'japanese-plain-tex-mode "tex-jp" no-doc t)
(autoload 'japanese-latex-mode "tex-jp" no-doc t)
(autoload 'texinfo-mode "tex-info" no-doc t)
(autoload 'latex-mode "latex" no-doc t)

(add-to-list 'load-path TeX-image-directory)
(autoload 'LaTeX-install-toolbar "tex-bar")

(provide 'tex-site)

;;; tex-site.el ends here
