;;; bdf.el --- BDF font file manager for Meadow.

;; Copyright (C) 2002 KOSEKI Yoshinori <kose@meadowy.org>

;; Author: KOSEKI Yoshinori <kose@meadowy.org>
;; Keywords: BDF, meadow
;; $Revision: 1.3 $

;;; Commentary:

;; Set BDF fonts directory to bdf-directory-list.

;;; Code:

(defun bdf-configure-fontset (fontset bdf-alist)
  "if not exist fontset, then make fontset, else return fontlist."
  (let ((exist (member fontset (w32-font-list)))
	(fontlist '(spec)))
    (dolist (x bdf-alist)
      (setq fontlist (append fontlist (bdf-make-char-spec x))))
    (if exist
	(list fontlist)
      (w32-add-font fontset (list fontlist)))))

(defun bdf-make-char-spec (list)
  "Set normal, bold, italic, bold-itaric fonts."
  (let* ((charset (car list))
	 (fl (nth 1 list))
	 (normal (nth 0 fl))
	 (bold (nth 1 fl))
	 (italic (nth 2 fl))
	 (bold-italic (nth 3 fl))
	 (encoding (nth 2 list))
	 (char-spec (function (lambda (c w s e f)
		(append `((:char-spec ,c :height any :weight ,w :slant ,s)
			  strict
			  (bdf-font ,f))
			(if e
			    (list (list `(encoding . ,e)))))))))
    (when (setq normal (bdf-file-exists-p normal bdf-directory-list))
      (unless (and bold
		   (setq bold (bdf-file-exists-p bold bdf-directory-list)))
	(setq bold normal))
      (unless (and italic
		   (setq italic (bdf-file-exists-p italic bdf-directory-list)))
	(setq italic normal))
      (unless (and bold-italic
		   (setq bold-italic (bdf-file-exists-p bold-italic 
							bdf-directory-list)))
	(setq bold-italic normal))
      (list (funcall char-spec charset 'normal 'normal encoding normal)
	    (funcall char-spec charset 'bold 'normal encoding bold)
	    (funcall char-spec charset 'normal 'any encoding italic)
	    (funcall char-spec charset 'bold 'any encoding bold-italic)))))

;; internal function
(defun bdf-file-exists-p (FILE LIST)
  "return filename"
  (let ((lst LIST)
	file)
    (catch 'font
      (while lst
	(if (file-exists-p (setq file (expand-file-name FILE (car lst))))
	  (throw 'font file))
      (setq lst (cdr lst))))))

(provide 'bdf)

;;; bdf.el ends here
