;;; -*- Mode: Emacs-Lisp ; Coding: iso-2022-jp-unix -*-

;;; dotemacs.el --- startup file for classical Greek on Meadow

;; Copyright (C) 2002
;;   National Institute of Advanced Industrial Science and Technology (AIST)
;;   Registration Number H14PRO020

;; Author: TAKAHASHI Naoto <ntakahas@m17n.org>
;; Keywords: multilingual, classical Greek

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Last modified: 2 September 2002

(unless (and (featurep 'meadow)
	     (= emacs-major-version 21))
  (error "only Meadow2 !!!!"))

;; including Netinstall "misc" package.
(require 'bdf)

;;;; elisp dir is $MEADOW/site-lisp/cgreek-meadow
;; do it.
;; cd $MEADOW/site-lisp/
;; tar zxvf cgreek-meadow.tar.gz

(load "cgreek-conf")
(load "cgreek")

;;; Meadow specific part begins here

; hints for Japanese users
;(set-language-environment 'japanese)
;(set-keyboard-coding-system 'sjis-dos)
;(mw32-ime-initialize)
;(setq mw32-ime-mode-line-state-indicator "[--]")
;(setq mw32-ime-mode-line-state-indicator-list '("--" "[$B$"(B]" "[--]"))
;(setq cgreek-japanese-input-method "MW32-IME")

;;; bdf font
(defvar cgreek-font-path
  (expand-file-name "../../fonts/cgreek" data-directory)
  "Set cgreek font path.")

(add-to-list 'bdf-directory-list cgreek-font-path)

;; ps-bdf.el bug!?!?
(eval-after-load "ps-bdf"
  '(add-to-list 'bdf-directory-list cgreek-font-path))

(defvar font-file-alist-cgreek14
  '((ascii ("7x14.bdf"))
    (latin-iso8859-1 ("7x14.bdf") 1-byte-set-msb)
    (japanese-jisx0208 ("k14.bdf"))
    (latin-jisx0201 ("7x14rk.bdf"))
    (katakana-jisx0201 ("7x14rk.bdf") 1-byte-set-msb)
    (cgreek ("cgreek14.bdf") encode-cgreek-font)))

(defvar font-file-alist-cgreek16
  '((ascii ("8x16.bdf"))
    (latin-iso8859-1 ("8x16.bdf") 1-byte-set-msb)
    (japanese-jisx0208 ("jiskan16.bdf"))
    (latin-jisx0201 ("8x16rk.bdf"))
    (katakana-jisx0201 ("8x16rk.bdf") 1-byte-set-msb)
    (cgreek ("cgreek16.bdf") encode-cgreek-font)))

(defvar font-file-alist-cgreek24
  '((ascii ("12x24.bdf"))
    (latin-iso8859-1 ("12x24.bdf") 1-byte-set-msb)
    (japanese-jisx0208 ("jiskan24.bdf"))
    (latin-jisx0201 ("12x24rk.bdf"))
    (katakana-jisx0201 ("12x24rk.bdf") 1-byte-set-msb)
    (cgreek ("cgreek24.bdf") encode-cgreek-font)))

(w32-regist-font-encoder
 'encode-cgreek-font 'ccl-encode-cgreek-font 1)

;;(bdf-configure-fontset "fontset-cgreek14" font-file-alist-cgreek14)
(bdf-configure-fontset "fontset-cgreek16" font-file-alist-cgreek16)
;;(bdf-configure-fontset "fontset-cgreek24" font-file-alist-cgreek24)

(setq default-frame-alist
      (cons '(font . "fontset-cgreek16") default-frame-alist))

;;; Meadow specific part ends here

;;; ps-print
(setq ps-multibyte-buffer 'bdf-font-except-latin)

(eval-after-load "ps-mule"
  '(setq ps-mule-font-info-database-ps-bdf
	 (append ps-mule-font-info-database-ps-bdf
		 '((cgreek 
		    (normal bdf "cgreek24.bdf" ps-mule-encode-7bit 2))))))

; default coding system for *.tex files
(defvar cgreek-tex-coding-system 'japanese-shift-jis-cgreek)

; default input methods
(defvar cgreek-greek-input-method "cgreek")
(defvar cgreek-latin-input-method "latin-1-postfix")
(defvar cgreek-japanese-input-method "japanese")

; functions to switch input language
(defun cgreek-greek-mode ()
  (interactive)
  (set-input-method cgreek-greek-input-method))
(defun cgreek-latin-mode ()
  (interactive)
  (set-input-method cgreek-latin-input-method))
(defun cgreek-japanese-mode ()
  (interactive)
  (set-input-method cgreek-japanese-input-method))

; language selection by menu
(define-key cgreek-menu-map [japanese]
  '("Japanese Mode" . cgreek-japanese-mode))
(define-key cgreek-menu-map [latin]
  '("Latin Mode" . cgreek-latin-mode))
(define-key cgreek-menu-map [greek]
  '("Greek Mode" . cgreek-greek-mode))

; language selection by function keys
;(global-set-key [f10] 'cgreek-greek-mode)
;(global-set-key [f11] 'cgreek-latin-mode)
;(global-set-key [f12] 'cgreek-japanese-mode)

;;; dotemacs.el ends here
