;;; cgreek.el --- Support for classical Greek -*- coding: iso-2022-7bit; -*-

;; Copyright (C) 2002
;;   National Institute of Advanced Industrial Science and Technology (AIST)
;;   Registration Number H14PRO020

;; Author: TAKAHASHI Naoto <ntakahas@m17n.org>
;; Keywords: multilingual, classical Greek

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Last modified: 2 September 2002

;;; Commentary:

;; CGreek does not have a corresponding language environment because
;; it is rarely used as the primary language.  To be combined with or
;; included in another language, having its own language environment
;; is problematic.

;; Loading this file adds the CGreek menu in the menu bar.  Also some
;; CGreek-related hooks are installed.  
;; Use `M-x exit-cgreek-environment' to remove them.
;; Use `M-x setup-cgreek-environment' to reactivate them.

;;; Code:

(define-ccl-program ccl-decode-cgreek
  '(4
    ((read r0)
     (loop
      (write-read-repeat
       r0
       [  0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15
	 16  17  18  19  20  21  22  23  24  25  26  27  28  29  30  31
	 32  ?$,4 A(B  ?$,4 B(B  ?$,4 C(B  ?$,4 D(B  ?$,4 E(B  ?$,4 F(B  ?$,4 G(B  40  41  42  ?$,4 K(B  44  45  46  ?$,4 O(B
	 48  49  50  51  52  53  54  55  56  57  ?$,4 Z(B  ?$,4 [(B  60  61  62  63
	 ?$,4 `(B  ?$,4 a(B  ?$,4 b(B  ?$,4 c(B  ?$,4 d(B  ?$,4 e(B  ?$,4 f(B  ?$,4 g(B  ?$,4 h(B  ?$,4 i(B  ?$,4 j(B  ?$,4 k(B  ?$,4 l(B  ?$,4 m(B  ?$,4 n(B  ?$,4 o(B
	 ?$,4 p(B  ?$,4 q(B  ?$,4 r(B  ?$,4 s(B  ?$,4 t(B  ?$,4 u(B  ?$,4 v(B  ?$,4 w(B  ?$,4 x(B  ?$,4 y(B  ?$,4 z(B  91  ?$,4 |(B  93  ?$,4 ~(B  95
	 ?$,4! (B  ?$,4!!(B  ?$,4!"(B  ?$,4!#(B  ?$,4!$(B  ?$,4!%(B  ?$,4!&(B  ?$,4!'(B  ?$,4!((B  ?$,4!)(B  ?$,4!*(B  ?$,4!+(B  ?$,4!,(B  ?$,4!-(B  ?$,4!.(B  ?$,4!/(B
	 ?$,4!0(B  ?$,4!1(B  ?$,4!2(B  ?$,4!3(B  ?$,4!4(B  ?$,4!5(B  ?$,4!6(B  ?$,4!7(B  ?$,4!8(B  ?$,4!9(B  ?$,4!:(B 123 124 125 126 127
	128 129 130  ?$,4!C(B  ?$,4!D(B  ?$,4!E(B  ?$,4!F(B  ?$,4!G(B  ?$,4!H(B  ?$,4!I(B  ?$,4!J(B  ?$,4!K(B  ?$,4!L(B  ?$,4!M(B  ?$,4!N(B  ?$,4!O(B
	 ?$,4!P(B  ?$,4!Q(B  ?$,4!R(B  ?$,4!S(B  ?$,4!T(B  ?$,4!U(B  ?$,4!V(B  ?$,4!W(B  ?$,4!X(B  ?$,4!Y(B  ?$,4!Z(B  ?$,4![(B  ?$,4!\(B  ?$,4!](B  ?$,4!^(B  ?$,4!_(B
	 ?$,4!`(B  ?$,4!a(B  ?$,4!b(B  ?$,4!c(B  ?$,4!d(B  ?$,4!e(B  ?$,4!f(B  ?$,4!g(B  ?$,4!h(B  ?$,4!i(B  ?$,4!j(B  ?$,4!k(B  ?$,4!l(B  ?$,4!m(B  ?$,4!n(B  ?$,4!o(B
	 ?$,4!p(B  ?$,4!q(B  ?$,4!r(B  ?$,4!s(B  ?$,4!t(B  ?$,4!u(B  ?$,4!v(B  ?$,4!w(B  ?$,4!x(B  ?$,4!y(B  ?$,4!z(B  ?$,4!{(B  ?$,4!|(B  ?$,4!}(B  ?$,4!~(B  ?$,4!(B
	 ?$,4" (B  ?$,4"!(B  ?$,4""(B  ?$,4"#(B  ?$,4"$(B  ?$,4"%(B  ?$,4"&(B  ?$,4"'(B  ?$,4"((B  ?$,4")(B  ?$,4"*(B  ?$,4"+(B  ?$,4",(B  ?$,4"-(B  ?$,4".(B  ?$,4"/(B
	 ?$,4"0(B  ?$,4"1(B  ?$,4"2(B  ?$,4"3(B  ?$,4"4(B  ?$,4"5(B  ?$,4"6(B  ?$,4"7(B  ?$,4"8(B  ?$,4"9(B  ?$,4":(B  ?$,4";(B  ?$,4"<(B  ?$,4"=(B  ?$,4">(B  ?$,4"?(B
	 ?$,4"@(B  ?$,4"A(B  ?$,4"B(B  ?$,4"C(B  ?$,4"D(B  ?$,4"E(B  ?$,4"F(B  ?$,4"G(B  ?$,4"H(B  ?$,4"I(B  ?$,4"J(B  ?$,4"K(B  ?$,4"L(B  ?$,4"M(B  ?$,4"N(B  ?$,4"O(B
	 ?$,4"P(B  ?$,4"Q(B  ?$,4"R(B  ?$,4"S(B  ?$,4"T(B  ?$,4"U(B  ?$,4"V(B  ?$,4"W(B  ?$,4"X(B  ?$,4"Y(B  ?$,4"Z(B  ?$,4"[(B  ?$,4"\(B  ?$,4"](B 254 255 ]
       ))))
  "CCL program to decode the 8-bit MuleCGreek charset.")

(define-ccl-program ccl-encode-cgreek
  `(1
    ((read r2)
     (loop
      (if (r2 == ,leading-code-private-21)
	  ((read r0)
	   (if (r0 == ,(charset-id 'cgreek))
	       ((read r1 r2)
		(r2 = ((((r1 - 160) * 96) + r2) - 160))
		(write-read-repeat r2))
	     ((write r2 r0)
	      (read r2)
	      (repeat))))
	(write-read-repeat r2))))))

(define-ccl-program ccl-encode-cgreek-font
  '(0
    ;; In:  R0:cgreek (not checked)
    ;;      R1:position code 1
    ;;      R2:position code 2
    ;; Out: R1:font codepoint
    (r1 = ((((r1 - 32) * 96) + r2) - 32)))
  "CCL program to encode cgreek chars to the MuleCGreek font")

(make-coding-system
 'iso-2022-7bit-cgreek 2 ?j
 "Same as iso-2022-7bit but use TeX commands for some symbols"
 '((ascii t) nil nil nil
   short ascii-eol ascii-cntl seven)
 '((safe-charsets . t)
   (post-read-conversion . cgreek-post-read-conversion)
   (pre-write-conversion . cgreek-pre-write-conversion)))

(make-coding-system
 'japanese-shift-jis-cgreek 1 ?s
 "Same as japanese-shift-jis but use TeX commands for some symbols"
 nil
 '((safe-charsets ascii japanese-jisx0208 japanese-jisx0208-1978
		  latin-jisx0201 katakana-jisx0201)
   (post-read-conversion . cgreek-post-read-conversion)
   (pre-write-conversion . cgreek-pre-write-conversion)
   (charset-origin-alist (japanese-jisx0208 "SJIS" encode-sjis-char)
			 (katakana-jisx0201 "SJIS" encode-sjis-char))))

(make-coding-system
 'japanese-iso-8bit-cgreek 2 ?e
 "Same as japanese-iso-8bit but use TeX commands for some symbols"
 '(ascii japanese-jisx0208 katakana-jisx0201 japanese-jisx0212
   short ascii-eol ascii-cntl nil nil single-shift)
 '((safe-charsets ascii latin-jisx0201 japanese-jisx0208 japanese-jisx0208-1978
		 katakana-jisx0201 japanese-jisx0212)
   (post-read-conversion . cgreek-post-read-conversion)
   (pre-write-conversion . cgreek-pre-write-conversion)))

(make-coding-system
 'greek-WinGreek 4 ?g
 "Coding-system for classical Greek.  Based on the 8-bit WinGreek charset."
 '(ccl-decode-cgreek . ccl-encode-cgreek)
 '((safe-charsets . t)))

(modify-category-entry (make-char 'cgreek) ?g)

(require 'cgreek-util)
(require 'cgreek-quail)

(setup-cgreek-environment)

;;; cgreek.el ends here
