/* subject.c generated by valac 0.26.1, the Vala compiler
 * generated from subject.vala, do not modify */

/* subject.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Seif Lotfy <seif@lotfy.com>
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define ZEITGEIST_TYPE_SUBJECT (zeitgeist_subject_get_type ())
#define ZEITGEIST_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject))
#define ZEITGEIST_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))
#define ZEITGEIST_IS_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_IS_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_SUBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))

typedef struct _ZeitgeistSubject ZeitgeistSubject;
typedef struct _ZeitgeistSubjectClass ZeitgeistSubjectClass;
typedef struct _ZeitgeistSubjectPrivate ZeitgeistSubjectPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_chunk_free0(var) ((var == NULL) ? NULL : (var = (g_string_chunk_free (var), NULL)))

struct _ZeitgeistSubject {
	GObject parent_instance;
	ZeitgeistSubjectPrivate * priv;
};

struct _ZeitgeistSubjectClass {
	GObjectClass parent_class;
};

struct _ZeitgeistSubjectPrivate {
	gchar* _uri;
	gchar* _origin;
	gchar* _text;
	gchar* _storage;
	gchar* _current_uri;
	gchar* _current_origin;
	const gchar* _mimetype;
	const gchar* _interpretation;
	const gchar* _manifestation;
};

typedef enum  {
	ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_DATA_MODEL_ERROR_NULL_EVENT,
	ZEITGEIST_DATA_MODEL_ERROR_TOO_MANY_RESULTS
} ZeitgeistDataModelError;
#define ZEITGEIST_DATA_MODEL_ERROR zeitgeist_data_model_error_quark ()

static gpointer zeitgeist_subject_parent_class = NULL;
static GStringChunk* zeitgeist_subject_url_store;
static GStringChunk* zeitgeist_subject_url_store = NULL;

GType zeitgeist_subject_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_SUBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectPrivate))
enum  {
	ZEITGEIST_SUBJECT_DUMMY_PROPERTY,
	ZEITGEIST_SUBJECT_URI,
	ZEITGEIST_SUBJECT_ORIGIN,
	ZEITGEIST_SUBJECT_TEXT,
	ZEITGEIST_SUBJECT_STORAGE,
	ZEITGEIST_SUBJECT_CURRENT_URI,
	ZEITGEIST_SUBJECT_CURRENT_ORIGIN,
	ZEITGEIST_SUBJECT_MIMETYPE,
	ZEITGEIST_SUBJECT_INTERPRETATION,
	ZEITGEIST_SUBJECT_MANIFESTATION
};
ZeitgeistSubject* zeitgeist_subject_new_full (const gchar* uri, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* origin, const gchar* text, const gchar* storage);
ZeitgeistSubject* zeitgeist_subject_construct_full (GType object_type, const gchar* uri, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* origin, const gchar* text, const gchar* storage);
void zeitgeist_subject_set_uri (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_interpretation (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_manifestation (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_mimetype (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_origin (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_text (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_storage (ZeitgeistSubject* self, const gchar* value);
ZeitgeistSubject* zeitgeist_subject_new_move_event (const gchar* source_uri, const gchar* source_origin, const gchar* destination_uri, const gchar* destination_origin, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* text, const gchar* storage);
ZeitgeistSubject* zeitgeist_subject_construct_move_event (GType object_type, const gchar* source_uri, const gchar* source_origin, const gchar* destination_uri, const gchar* destination_origin, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* text, const gchar* storage);
void zeitgeist_subject_set_current_uri (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_current_origin (ZeitgeistSubject* self, const gchar* value);
GQuark zeitgeist_data_model_error_quark (void);
ZeitgeistSubject* zeitgeist_subject_new_from_variant (GVariant* subject_variant, GError** error);
ZeitgeistSubject* zeitgeist_subject_construct_from_variant (GType object_type, GVariant* subject_variant, GError** error);
void zeitgeist_utils_assert_sig (gboolean condition, const gchar* error_message, GError** error);
gchar* zeitgeist_next_string_or_null (GVariantIter* iter);
GVariant* zeitgeist_subject_to_variant (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_interpretation (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_manifestation (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_origin (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_mimetype (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_text (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_storage (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_current_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_current_origin (ZeitgeistSubject* self);
gboolean zeitgeist_subject_matches_template (ZeitgeistSubject* self, ZeitgeistSubject* template_subject);
gboolean zeitgeist_check_field_match (const gchar* property, const gchar* template_property, gboolean is_symbol, gboolean can_wildcard);
ZeitgeistSubject* zeitgeist_subject_new (void);
ZeitgeistSubject* zeitgeist_subject_construct (GType object_type);
static void zeitgeist_subject_finalize (GObject* obj);
static void _vala_zeitgeist_subject_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_subject_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/** 
     * Create a new Subject structure with predefined data
     * @param uri The URI or URL of the subject
     * @param interpretation The interpretation type of the subject.
     * @param manifestation The manifestation type of the subject.
     * @param mimetype The mimetype of the subject. Eg. <emphasis>text/plain</emphasis>
     * @param origin The origin of the subject.
     * @param text A small textual representation of the subject suitable for display
     * @param storage String identifier for the storage medium the subject is on.
     *
     * @return A newly create {@link Subject} instance. The returned subject will
     *          have a floating reference which will be consumed if you pass the
     *          event to any of the methods provided by this library (like
     *          adding it to an event).
     */
ZeitgeistSubject* zeitgeist_subject_construct_full (GType object_type, const gchar* uri, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* origin, const gchar* text, const gchar* storage) {
	ZeitgeistSubject * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	_tmp0_ = uri;
	zeitgeist_subject_set_uri (self, _tmp0_);
	_tmp1_ = interpretation;
	zeitgeist_subject_set_interpretation (self, _tmp1_);
	_tmp2_ = manifestation;
	zeitgeist_subject_set_manifestation (self, _tmp2_);
	_tmp3_ = mimetype;
	zeitgeist_subject_set_mimetype (self, _tmp3_);
	_tmp4_ = origin;
	zeitgeist_subject_set_origin (self, _tmp4_);
	_tmp5_ = text;
	zeitgeist_subject_set_text (self, _tmp5_);
	_tmp6_ = storage;
	zeitgeist_subject_set_storage (self, _tmp6_);
	return self;
}


ZeitgeistSubject* zeitgeist_subject_new_full (const gchar* uri, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* origin, const gchar* text, const gchar* storage) {
	return zeitgeist_subject_construct_full (ZEITGEIST_TYPE_SUBJECT, uri, interpretation, manifestation, mimetype, origin, text, storage);
}


/** 
     * Create a new Subject structure to describe a move event
     *
     * @param source_uri The URI or URL of the subject
     * @param source_origin The URI or URL of the subject
     * @param destination_uri The URI or URL of the subject
     * @param destination_origin The URI or URL of the subject
     * @param interpretation The interpretation type of the subject.
     * @param manifestation The manifestation type of the subject.
     * @param mimetype The mimetype of the subject. Eg. <emphasis>text/plain</emphasis>
     * @param text A small textual representation of the subject suitable for display
     * @param storage String identifier for the storage medium the subject is on.
     *
     * @return A newly create {@link Subject} instance. The returned subject will
     *          have a floating reference which will be consumed if you pass the
     *          event to any of the methods provided by this library (like
     *          adding it to an event).
     */
ZeitgeistSubject* zeitgeist_subject_construct_move_event (GType object_type, const gchar* source_uri, const gchar* source_origin, const gchar* destination_uri, const gchar* destination_origin, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* text, const gchar* storage) {
	ZeitgeistSubject * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	_tmp0_ = source_uri;
	zeitgeist_subject_set_uri (self, _tmp0_);
	_tmp1_ = source_origin;
	zeitgeist_subject_set_origin (self, _tmp1_);
	_tmp2_ = destination_uri;
	zeitgeist_subject_set_current_uri (self, _tmp2_);
	_tmp3_ = destination_origin;
	zeitgeist_subject_set_current_origin (self, _tmp3_);
	_tmp4_ = interpretation;
	zeitgeist_subject_set_interpretation (self, _tmp4_);
	_tmp5_ = manifestation;
	zeitgeist_subject_set_manifestation (self, _tmp5_);
	_tmp6_ = mimetype;
	zeitgeist_subject_set_mimetype (self, _tmp6_);
	_tmp7_ = text;
	zeitgeist_subject_set_text (self, _tmp7_);
	_tmp8_ = storage;
	zeitgeist_subject_set_storage (self, _tmp8_);
	return self;
}


ZeitgeistSubject* zeitgeist_subject_new_move_event (const gchar* source_uri, const gchar* source_origin, const gchar* destination_uri, const gchar* destination_origin, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* text, const gchar* storage) {
	return zeitgeist_subject_construct_move_event (ZEITGEIST_TYPE_SUBJECT, source_uri, source_origin, destination_uri, destination_origin, interpretation, manifestation, mimetype, text, storage);
}


/** 
     * Create a new Subject structure from predefined {@link GLib.Variant} data
     *
     * @param subject_variant A {@link GLib.Variant} decscribing the subject data.
     *
     * @return A newly create {@link Subject} instance. The returned subject will
     *          have a floating reference which will be consumed if you pass the
     *          event to any of the methods provided by this library (like
     *          adding it to an event).
     */
ZeitgeistSubject* zeitgeist_subject_construct_from_variant (GType object_type, GVariant* subject_variant, GError** error) {
	ZeitgeistSubject * self = NULL;
	GVariantIter* iter = NULL;
	GVariant* _tmp0_ = NULL;
	GVariantIter* _tmp1_ = NULL;
	gsize subject_props = 0UL;
	gsize _tmp2_ = 0UL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (subject_variant != NULL, NULL);
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	_tmp0_ = subject_variant;
	_tmp1_ = g_variant_iter_new (_tmp0_);
	iter = _tmp1_;
	_tmp2_ = g_variant_iter_n_children (iter);
	subject_props = _tmp2_;
	zeitgeist_utils_assert_sig (subject_props >= ((gsize) 7), "Missing subject information", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = zeitgeist_next_string_or_null (iter);
	_tmp4_ = _tmp3_;
	zeitgeist_subject_set_uri (self, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = zeitgeist_next_string_or_null (iter);
	_tmp6_ = _tmp5_;
	zeitgeist_subject_set_interpretation (self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = zeitgeist_next_string_or_null (iter);
	_tmp8_ = _tmp7_;
	zeitgeist_subject_set_manifestation (self, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = zeitgeist_next_string_or_null (iter);
	_tmp10_ = _tmp9_;
	zeitgeist_subject_set_origin (self, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = zeitgeist_next_string_or_null (iter);
	_tmp12_ = _tmp11_;
	zeitgeist_subject_set_mimetype (self, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = zeitgeist_next_string_or_null (iter);
	_tmp14_ = _tmp13_;
	zeitgeist_subject_set_text (self, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = zeitgeist_next_string_or_null (iter);
	_tmp16_ = _tmp15_;
	zeitgeist_subject_set_storage (self, _tmp16_);
	_g_free0 (_tmp16_);
	if (subject_props >= ((gsize) 8)) {
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp17_ = zeitgeist_next_string_or_null (iter);
		_tmp18_ = _tmp17_;
		zeitgeist_subject_set_current_uri (self, _tmp18_);
		_g_free0 (_tmp18_);
	}
	if (subject_props >= ((gsize) 9)) {
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp19_ = zeitgeist_next_string_or_null (iter);
		_tmp20_ = _tmp19_;
		zeitgeist_subject_set_current_origin (self, _tmp20_);
		_g_free0 (_tmp20_);
	}
	_g_variant_iter_free0 (iter);
	return self;
}


ZeitgeistSubject* zeitgeist_subject_new_from_variant (GVariant* subject_variant, GError** error) {
	return zeitgeist_subject_construct_from_variant (ZEITGEIST_TYPE_SUBJECT, subject_variant, error);
}


GVariant* zeitgeist_subject_to_variant (ZeitgeistSubject* self) {
	GVariant* result = NULL;
	gchar* ptr_arr[9] = {0};
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp41_ = NULL;
	GVariant* _tmp42_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_uri;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = self->priv->_uri;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	ptr_arr[0] = _tmp0_;
	_tmp3_ = ptr_arr[0];
	_tmp5_ = zeitgeist_subject_get_interpretation (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = zeitgeist_subject_get_interpretation (self);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = "";
	}
	ptr_arr[1] = _tmp4_;
	_tmp9_ = ptr_arr[1];
	_tmp11_ = zeitgeist_subject_get_manifestation (self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp13_ = zeitgeist_subject_get_manifestation (self);
		_tmp14_ = _tmp13_;
		_tmp10_ = _tmp14_;
	} else {
		_tmp10_ = "";
	}
	ptr_arr[2] = _tmp10_;
	_tmp15_ = ptr_arr[2];
	_tmp17_ = self->priv->_origin;
	if (_tmp17_ != NULL) {
		const gchar* _tmp18_ = NULL;
		_tmp18_ = self->priv->_origin;
		_tmp16_ = _tmp18_;
	} else {
		_tmp16_ = "";
	}
	ptr_arr[3] = _tmp16_;
	_tmp19_ = ptr_arr[3];
	_tmp21_ = zeitgeist_subject_get_mimetype (self);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp23_ = zeitgeist_subject_get_mimetype (self);
		_tmp24_ = _tmp23_;
		_tmp20_ = _tmp24_;
	} else {
		_tmp20_ = "";
	}
	ptr_arr[4] = _tmp20_;
	_tmp25_ = ptr_arr[4];
	_tmp27_ = self->priv->_text;
	if (_tmp27_ != NULL) {
		const gchar* _tmp28_ = NULL;
		_tmp28_ = self->priv->_text;
		_tmp26_ = _tmp28_;
	} else {
		_tmp26_ = "";
	}
	ptr_arr[5] = _tmp26_;
	_tmp29_ = ptr_arr[5];
	_tmp31_ = self->priv->_storage;
	if (_tmp31_ != NULL) {
		const gchar* _tmp32_ = NULL;
		_tmp32_ = self->priv->_storage;
		_tmp30_ = _tmp32_;
	} else {
		_tmp30_ = "";
	}
	ptr_arr[6] = _tmp30_;
	_tmp33_ = ptr_arr[6];
	_tmp35_ = self->priv->_current_uri;
	if (_tmp35_ != NULL) {
		const gchar* _tmp36_ = NULL;
		_tmp36_ = self->priv->_current_uri;
		_tmp34_ = _tmp36_;
	} else {
		_tmp34_ = "";
	}
	ptr_arr[7] = _tmp34_;
	_tmp37_ = ptr_arr[7];
	_tmp39_ = self->priv->_current_origin;
	if (_tmp39_ != NULL) {
		const gchar* _tmp40_ = NULL;
		_tmp40_ = self->priv->_current_origin;
		_tmp38_ = _tmp40_;
	} else {
		_tmp38_ = "";
	}
	ptr_arr[8] = _tmp38_;
	_tmp41_ = ptr_arr[8];
	_tmp42_ = g_variant_new_strv ((gchar**) ptr_arr, (9 * sizeof (gchar*)) / sizeof (gchar*));
	g_variant_ref_sink (_tmp42_);
	result = _tmp42_;
	return result;
}


/**
     * @return true if this Subject matches *subject_template*. Empty
     * fields in the template are treated as wildcards.
     * Interpretations and manifestations are also matched if they are
     * children of the types specified in `subject_template`.
     * @param template_subject a {@link Subject}
    */
gboolean zeitgeist_subject_matches_template (ZeitgeistSubject* self, ZeitgeistSubject* template_subject) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	ZeitgeistSubject* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	ZeitgeistSubject* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	ZeitgeistSubject* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	ZeitgeistSubject* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_ = NULL;
	ZeitgeistSubject* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp24_ = NULL;
	ZeitgeistSubject* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	ZeitgeistSubject* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (template_subject != NULL, FALSE);
	_tmp0_ = self->priv->_uri;
	_tmp1_ = template_subject;
	_tmp2_ = _tmp1_->priv->_uri;
	_tmp3_ = zeitgeist_check_field_match (_tmp0_, _tmp2_, FALSE, TRUE);
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_current_uri;
	_tmp5_ = template_subject;
	_tmp6_ = _tmp5_->priv->_current_uri;
	_tmp7_ = zeitgeist_check_field_match (_tmp4_, _tmp6_, FALSE, TRUE);
	if (!_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = zeitgeist_subject_get_interpretation (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = template_subject;
	_tmp11_ = zeitgeist_subject_get_interpretation (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = zeitgeist_check_field_match (_tmp9_, _tmp12_, TRUE, FALSE);
	if (!_tmp13_) {
		result = FALSE;
		return result;
	}
	_tmp14_ = zeitgeist_subject_get_manifestation (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = template_subject;
	_tmp17_ = zeitgeist_subject_get_manifestation (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = zeitgeist_check_field_match (_tmp15_, _tmp18_, TRUE, FALSE);
	if (!_tmp19_) {
		result = FALSE;
		return result;
	}
	_tmp20_ = self->priv->_origin;
	_tmp21_ = template_subject;
	_tmp22_ = _tmp21_->priv->_origin;
	_tmp23_ = zeitgeist_check_field_match (_tmp20_, _tmp22_, FALSE, TRUE);
	if (!_tmp23_) {
		result = FALSE;
		return result;
	}
	_tmp24_ = self->priv->_current_origin;
	_tmp25_ = template_subject;
	_tmp26_ = _tmp25_->priv->_current_origin;
	_tmp27_ = zeitgeist_check_field_match (_tmp24_, _tmp26_, FALSE, TRUE);
	if (!_tmp27_) {
		result = FALSE;
		return result;
	}
	_tmp28_ = zeitgeist_subject_get_mimetype (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = template_subject;
	_tmp31_ = zeitgeist_subject_get_mimetype (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = zeitgeist_check_field_match (_tmp29_, _tmp32_, FALSE, TRUE);
	if (!_tmp33_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


ZeitgeistSubject* zeitgeist_subject_construct (GType object_type) {
	ZeitgeistSubject * self = NULL;
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	return self;
}


ZeitgeistSubject* zeitgeist_subject_new (void) {
	return zeitgeist_subject_construct (ZEITGEIST_TYPE_SUBJECT);
}


const gchar* zeitgeist_subject_get_uri (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_uri (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	g_object_notify ((GObject *) self, "uri");
}


const gchar* zeitgeist_subject_get_origin (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_origin;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_origin (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_origin);
	self->priv->_origin = _tmp1_;
	g_object_notify ((GObject *) self, "origin");
}


const gchar* zeitgeist_subject_get_text (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_text (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	g_object_notify ((GObject *) self, "text");
}


const gchar* zeitgeist_subject_get_storage (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_storage;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_storage (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_storage);
	self->priv->_storage = _tmp1_;
	g_object_notify ((GObject *) self, "storage");
}


const gchar* zeitgeist_subject_get_current_uri (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_uri;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_current_uri (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_current_uri);
	self->priv->_current_uri = _tmp1_;
	g_object_notify ((GObject *) self, "current-uri");
}


const gchar* zeitgeist_subject_get_current_origin (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_origin;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_current_origin (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_current_origin);
	self->priv->_current_origin = _tmp1_;
	g_object_notify ((GObject *) self, "current-origin");
}


const gchar* zeitgeist_subject_get_mimetype (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mimetype;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_mimetype (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		GStringChunk* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = zeitgeist_subject_url_store;
		_tmp3_ = value;
		_tmp4_ = g_string_chunk_insert_const (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	self->priv->_mimetype = _tmp0_;
	g_object_notify ((GObject *) self, "mimetype");
}


const gchar* zeitgeist_subject_get_interpretation (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_interpretation;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_interpretation (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		GStringChunk* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = zeitgeist_subject_url_store;
		_tmp3_ = value;
		_tmp4_ = g_string_chunk_insert_const (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	self->priv->_interpretation = _tmp0_;
	g_object_notify ((GObject *) self, "interpretation");
}


const gchar* zeitgeist_subject_get_manifestation (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manifestation;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_manifestation (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		GStringChunk* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = zeitgeist_subject_url_store;
		_tmp3_ = value;
		_tmp4_ = g_string_chunk_insert_const (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	self->priv->_manifestation = _tmp0_;
	g_object_notify ((GObject *) self, "manifestation");
}


static void zeitgeist_subject_class_init (ZeitgeistSubjectClass * klass) {
	GStringChunk* _tmp0_ = NULL;
	zeitgeist_subject_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistSubjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_subject_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_subject_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_subject_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_ORIGIN, g_param_spec_string ("origin", "origin", "origin", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_STORAGE, g_param_spec_string ("storage", "storage", "storage", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_CURRENT_URI, g_param_spec_string ("current-uri", "current-uri", "current-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_CURRENT_ORIGIN, g_param_spec_string ("current-origin", "current-origin", "current-origin", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_MIMETYPE, g_param_spec_string ("mimetype", "mimetype", "mimetype", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_INTERPRETATION, g_param_spec_string ("interpretation", "interpretation", "interpretation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_MANIFESTATION, g_param_spec_string ("manifestation", "manifestation", "manifestation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_string_chunk_new ((gsize) 4096);
	_g_string_chunk_free0 (zeitgeist_subject_url_store);
	zeitgeist_subject_url_store = _tmp0_;
}


static void zeitgeist_subject_instance_init (ZeitgeistSubject * self) {
	self->priv = ZEITGEIST_SUBJECT_GET_PRIVATE (self);
}


static void zeitgeist_subject_finalize (GObject* obj) {
	ZeitgeistSubject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_origin);
	_g_free0 (self->priv->_text);
	_g_free0 (self->priv->_storage);
	_g_free0 (self->priv->_current_uri);
	_g_free0 (self->priv->_current_origin);
	G_OBJECT_CLASS (zeitgeist_subject_parent_class)->finalize (obj);
}


/**
 * Subject objects abstract Zeitgeist subjects
 *
 * In Zeitgeist terminology, a //subject// is something (a file, web page,
 * person, conversation, etc.) that was somehow involved or affected by
 * a {@link Event}.
 */
GType zeitgeist_subject_get_type (void) {
	static volatile gsize zeitgeist_subject_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_subject_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSubjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_subject_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSubject), 0, (GInstanceInitFunc) zeitgeist_subject_instance_init, NULL };
		GType zeitgeist_subject_type_id;
		zeitgeist_subject_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistSubject", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_subject_type_id__volatile, zeitgeist_subject_type_id);
	}
	return zeitgeist_subject_type_id__volatile;
}


static void _vala_zeitgeist_subject_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistSubject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject);
	switch (property_id) {
		case ZEITGEIST_SUBJECT_URI:
		g_value_set_string (value, zeitgeist_subject_get_uri (self));
		break;
		case ZEITGEIST_SUBJECT_ORIGIN:
		g_value_set_string (value, zeitgeist_subject_get_origin (self));
		break;
		case ZEITGEIST_SUBJECT_TEXT:
		g_value_set_string (value, zeitgeist_subject_get_text (self));
		break;
		case ZEITGEIST_SUBJECT_STORAGE:
		g_value_set_string (value, zeitgeist_subject_get_storage (self));
		break;
		case ZEITGEIST_SUBJECT_CURRENT_URI:
		g_value_set_string (value, zeitgeist_subject_get_current_uri (self));
		break;
		case ZEITGEIST_SUBJECT_CURRENT_ORIGIN:
		g_value_set_string (value, zeitgeist_subject_get_current_origin (self));
		break;
		case ZEITGEIST_SUBJECT_MIMETYPE:
		g_value_set_string (value, zeitgeist_subject_get_mimetype (self));
		break;
		case ZEITGEIST_SUBJECT_INTERPRETATION:
		g_value_set_string (value, zeitgeist_subject_get_interpretation (self));
		break;
		case ZEITGEIST_SUBJECT_MANIFESTATION:
		g_value_set_string (value, zeitgeist_subject_get_manifestation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_subject_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistSubject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject);
	switch (property_id) {
		case ZEITGEIST_SUBJECT_URI:
		zeitgeist_subject_set_uri (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_ORIGIN:
		zeitgeist_subject_set_origin (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_TEXT:
		zeitgeist_subject_set_text (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_STORAGE:
		zeitgeist_subject_set_storage (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_CURRENT_URI:
		zeitgeist_subject_set_current_uri (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_CURRENT_ORIGIN:
		zeitgeist_subject_set_current_origin (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_MIMETYPE:
		zeitgeist_subject_set_mimetype (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_INTERPRETATION:
		zeitgeist_subject_set_interpretation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_MANIFESTATION:
		zeitgeist_subject_set_manifestation (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



