/* ds-registry.c generated by valac 0.20.1, the Vala compiler
 * generated from ds-registry.vala, do not modify */

/* ds-registry.vala
 *
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * Based upon a Python implementation (2009-2010) by:
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-datamodel.h"
#include "zeitgeist-engine.h"
#include "zeitgeist.h"
#include <gio/gio.h>

#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION (zeitgeist_data_source_registry_extension_get_type ())
#define ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION, ZeitgeistDataSourceRegistryExtension))
#define ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION, ZeitgeistDataSourceRegistryExtensionClass))
#define ZEITGEIST_IS_DATA_SOURCE_REGISTRY_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION))
#define ZEITGEIST_IS_DATA_SOURCE_REGISTRY_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION))
#define ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION, ZeitgeistDataSourceRegistryExtensionClass))

typedef struct _ZeitgeistDataSourceRegistryExtension ZeitgeistDataSourceRegistryExtension;
typedef struct _ZeitgeistDataSourceRegistryExtensionClass ZeitgeistDataSourceRegistryExtensionClass;
typedef struct _ZeitgeistDataSourceRegistryExtensionPrivate ZeitgeistDataSourceRegistryExtensionPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ZeitgeistDataSourceRegistryExtensionGetDataSourcesData ZeitgeistDataSourceRegistryExtensionGetDataSourcesData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData;
typedef struct _ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData;
typedef struct _ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ZeitgeistDataSourceRegistryExtension {
	ZeitgeistExtension parent_instance;
	ZeitgeistDataSourceRegistryExtensionPrivate * priv;
};

struct _ZeitgeistDataSourceRegistryExtensionClass {
	ZeitgeistExtensionClass parent_class;
};

struct _ZeitgeistDataSourceRegistryExtensionPrivate {
	GHashTable* sources;
	GHashTable* running_ds;
	GHashTable* bus_name_2_ds;
	guint registration_id;
	gboolean dirty;
};

struct _ZeitgeistDataSourceRegistryExtensionGetDataSourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistDataSourceRegistryExtension* self;
	GCancellable* cancellable;
	GVariant* result;
	GHashTable* _tmp0_;
	GVariant* _tmp1_;
};

struct _ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistDataSourceRegistryExtension* self;
	gchar* unique_id;
	gchar* name;
	gchar* description;
	GVariant* event_templates;
	GCancellable* cancellable;
	char* sender;
	gboolean result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const char* _tmp3_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_;
	GPtrArray* _tmp7_;
	GPtrArray* sender_array;
	GPtrArray* _tmp8_;
	GPtrArray* _tmp9_;
	GPtrArray* _tmp10_;
	const char* _tmp11_;
	char* _tmp12_;
	GHashTable* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GPtrArray* _tmp16_;
	GPtrArray* _tmp17_;
	const char* _tmp18_;
	GPtrArray* _tmp19_;
	gboolean _tmp20_;
	GPtrArray* _tmp21_;
	const char* _tmp22_;
	char* _tmp23_;
	GHashTable* _tmp24_;
	const char* _tmp25_;
	gconstpointer _tmp26_;
	const gchar* ds_id;
	const gchar* _tmp27_;
	GHashTable* _tmp28_;
	const char* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gboolean _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gboolean _tmp37_;
	GHashTable* _tmp38_;
	const char* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GPtrArray* templates;
	GHashTable* _tmp42_;
	const gchar* _tmp43_;
	gconstpointer _tmp44_;
	ZeitgeistDataSource* ds;
	ZeitgeistDataSource* _tmp45_;
	GVariant* _tmp46_;
	GPtrArray* _tmp47_;
	GPtrArray* _tmp48_;
	ZeitgeistDataSource* _tmp49_;
	const gchar* _tmp50_;
	ZeitgeistDataSource* _tmp51_;
	const gchar* _tmp52_;
	ZeitgeistDataSource* _tmp53_;
	GPtrArray* _tmp54_;
	ZeitgeistDataSource* _tmp55_;
	gint64 _tmp56_;
	ZeitgeistDataSource* _tmp57_;
	ZeitgeistDataSource* _tmp58_;
	GVariant* _tmp59_;
	GVariant* _tmp60_;
	ZeitgeistDataSource* _tmp61_;
	gboolean _tmp62_;
	gboolean _tmp63_;
	GVariant* _tmp64_;
	GPtrArray* _tmp65_;
	GPtrArray* _tmp66_;
	const gchar* _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_;
	GPtrArray* _tmp70_;
	ZeitgeistDataSource* _tmp71_;
	ZeitgeistDataSource* new_ds;
	ZeitgeistDataSource* _tmp72_;
	ZeitgeistDataSource* _tmp73_;
	ZeitgeistDataSource* _tmp74_;
	gint64 _tmp75_;
	GHashTable* _tmp76_;
	const gchar* _tmp77_;
	gchar* _tmp78_;
	ZeitgeistDataSource* _tmp79_;
	ZeitgeistDataSource* _tmp80_;
	ZeitgeistDataSource* _tmp81_;
	GVariant* _tmp82_;
	GVariant* _tmp83_;
	ZeitgeistDataSource* _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp86_;
	GError * _inner_error_;
};

struct _ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistDataSourceRegistryExtension* self;
	gchar* unique_id;
	gboolean enabled;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	gconstpointer _tmp4_;
	ZeitgeistDataSource* ds;
	ZeitgeistDataSource* _tmp5_;
	ZeitgeistDataSource* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	ZeitgeistDataSource* _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	const gchar* _tmp14_;
};

struct _ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistDataSourceRegistryExtension* self;
	gchar* unique_id;
	GCancellable* cancellable;
	GVariant* result;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	ZeitgeistDataSource* ds;
	ZeitgeistDataSource* _tmp3_;
	ZeitgeistDataSource* _tmp4_;
	GVariant* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError * _inner_error_;
};


static gpointer zeitgeist_data_source_registry_extension_parent_class = NULL;
static ZeitgeistRemoteRegistryIface* zeitgeist_data_source_registry_extension_zeitgeist_remote_registry_parent_iface = NULL;
static GType zeitgeist_data_source_registry_extension_type_id = 0;

GHashTable* zeitgeist_data_sources_registry_from_variant (GVariant* sources_variant, gboolean reset_running, GError** error);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
GType zeitgeist_data_source_registry_extension_get_type (void) G_GNUC_CONST;
GType zeitgeist_data_source_registry_extension_register_type (GTypeModule * module);
#define ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION, ZeitgeistDataSourceRegistryExtensionPrivate))
enum  {
	ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_DUMMY_PROPERTY
};
#define ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_MULTIPLE_MARKER "<multiple>"
#define ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_DISK_WRITE_TIMEOUT ((guint) (5 * 60))
static ZeitgeistDataSourceRegistryExtension* zeitgeist_data_source_registry_extension_new (void);
static ZeitgeistDataSourceRegistryExtension* zeitgeist_data_source_registry_extension_construct (GType object_type);
static void zeitgeist_data_source_registry_extension_real_unload (ZeitgeistExtension* base);
static gboolean zeitgeist_data_source_registry_extension_flush (ZeitgeistDataSourceRegistryExtension* self);
static void zeitgeist_data_source_registry_extension_real_get_data_sources_data_free (gpointer _data);
static void zeitgeist_data_source_registry_extension_real_get_data_sources (ZeitgeistRemoteRegistry* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_data_source_registry_extension_real_get_data_sources_co (ZeitgeistDataSourceRegistryExtensionGetDataSourcesData* _data_);
static gboolean zeitgeist_data_source_registry_extension_is_sender_known (ZeitgeistDataSourceRegistryExtension* self, const char* sender, GPtrArray* sender_array);
static void zeitgeist_data_source_registry_extension_real_register_data_source_data_free (gpointer _data);
static void zeitgeist_data_source_registry_extension_real_register_data_source (ZeitgeistRemoteRegistry* base, const gchar* unique_id, const gchar* name, const gchar* description, GVariant* event_templates, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_data_source_registry_extension_real_register_data_source_co (ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData* _data_);
static void zeitgeist_data_source_registry_extension_real_set_data_source_enabled_data_free (gpointer _data);
static void zeitgeist_data_source_registry_extension_real_set_data_source_enabled (ZeitgeistRemoteRegistry* base, const gchar* unique_id, gboolean enabled, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_data_source_registry_extension_real_set_data_source_enabled_co (ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData* _data_);
static void zeitgeist_data_source_registry_extension_real_get_data_source_from_id_data_free (gpointer _data);
static void zeitgeist_data_source_registry_extension_real_get_data_source_from_id (ZeitgeistRemoteRegistry* base, const gchar* unique_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_data_source_registry_extension_real_get_data_source_from_id_co (ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData* _data_);
static void zeitgeist_data_source_registry_extension_real_pre_insert_events (ZeitgeistExtension* base, GPtrArray* events, const char* sender);
static void zeitgeist_data_source_registry_extension_name_owner_changed (ZeitgeistDataSourceRegistryExtension* self, GDBusConnection* conn, const gchar* sender, const gchar* path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters);
static GObject * zeitgeist_data_source_registry_extension_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_ptr_array_unref0_ (gpointer var);
static void _zeitgeist_data_source_registry_extension_name_owner_changed_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self);
static gboolean _zeitgeist_data_source_registry_extension_flush_gsource_func (gpointer self);
static void zeitgeist_data_source_registry_extension_finalize (GObject* obj);
GType zeitgeist_extension_register (GTypeModule* module);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GHashTable* zeitgeist_data_sources_registry_from_variant (GVariant* sources_variant, gboolean reset_running, GError** error) {
	GHashTable* result = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* registry;
	GVariant* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sources_variant != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	registry = _tmp2_;
	_tmp3_ = sources_variant;
	_tmp4_ = g_variant_get_type_string (_tmp3_);
	g_warn_if_fail (g_strcmp0 (_tmp4_, ZEITGEIST_DATA_SOURCES_SIG_DATASOURCES) == 0);
	{
		GVariant* _tmp5_;
		GVariantIter* _tmp6_ = NULL;
		GVariantIter* _ds_variant_it;
		GVariant* ds_variant = NULL;
		_tmp5_ = sources_variant;
		_tmp6_ = g_variant_iter_new (_tmp5_);
		_ds_variant_it = _tmp6_;
		while (TRUE) {
			GVariantIter* _tmp7_;
			GVariant* _tmp8_ = NULL;
			GVariant* _tmp9_;
			GVariant* _tmp10_;
			gboolean _tmp11_;
			ZeitgeistDataSource* _tmp12_;
			ZeitgeistDataSource* ds;
			GHashTable* _tmp13_;
			ZeitgeistDataSource* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			ZeitgeistDataSource* _tmp18_;
			ZeitgeistDataSource* _tmp19_;
			_tmp7_ = _ds_variant_it;
			_tmp8_ = g_variant_iter_next_value (_tmp7_);
			_g_variant_unref0 (ds_variant);
			ds_variant = _tmp8_;
			_tmp9_ = ds_variant;
			if (!(_tmp9_ != NULL)) {
				break;
			}
			_tmp10_ = ds_variant;
			_tmp11_ = reset_running;
			_tmp12_ = zeitgeist_data_source_new_from_variant (_tmp10_, _tmp11_, &_inner_error_);
			ds = _tmp12_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_variant_unref0 (ds_variant);
					_g_variant_iter_free0 (_ds_variant_it);
					_g_hash_table_unref0 (registry);
					return NULL;
				} else {
					_g_variant_unref0 (ds_variant);
					_g_variant_iter_free0 (_ds_variant_it);
					_g_hash_table_unref0 (registry);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp13_ = registry;
			_tmp14_ = ds;
			_tmp15_ = zeitgeist_data_source_get_unique_id (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup (_tmp16_);
			_tmp18_ = ds;
			_tmp19_ = _g_object_ref0 (_tmp18_);
			g_hash_table_insert (_tmp13_, _tmp17_, _tmp19_);
			_g_object_unref0 (ds);
		}
		_g_variant_unref0 (ds_variant);
		_g_variant_iter_free0 (_ds_variant_it);
	}
	result = registry;
	return result;
}


static ZeitgeistDataSourceRegistryExtension* zeitgeist_data_source_registry_extension_construct (GType object_type) {
	ZeitgeistDataSourceRegistryExtension * self = NULL;
	self = (ZeitgeistDataSourceRegistryExtension*) g_object_new (object_type, NULL);
	return self;
}


static ZeitgeistDataSourceRegistryExtension* zeitgeist_data_source_registry_extension_new (void) {
	return zeitgeist_data_source_registry_extension_construct (ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION);
}


static void zeitgeist_data_source_registry_extension_real_unload (ZeitgeistExtension* base) {
	ZeitgeistDataSourceRegistryExtension * self;
	guint _tmp5_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistDataSourceRegistryExtension*) base;
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* connection;
		guint _tmp1_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->registration_id;
		if (_tmp1_ != ((guint) 0)) {
			guint _tmp2_;
			_tmp2_ = self->priv->registration_id;
			g_dbus_connection_unregister_object (connection, _tmp2_);
			self->priv->registration_id = (guint) 0;
		}
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("ds-registry.vala:129: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	zeitgeist_data_source_registry_extension_flush (self);
	_tmp5_ = ((GObject*) self)->ref_count;
	g_debug ("ds-registry.vala:133: %s, this.ref_count = %u", "Zeitgeist.DataSourceRegistryExtension.unload", _tmp5_);
}


static void zeitgeist_data_source_registry_extension_real_get_data_sources_data_free (gpointer _data) {
	ZeitgeistDataSourceRegistryExtensionGetDataSourcesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDataSourceRegistryExtensionGetDataSourcesData, _data_);
}


static void zeitgeist_data_source_registry_extension_real_get_data_sources (ZeitgeistRemoteRegistry* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDataSourceRegistryExtension * self;
	ZeitgeistDataSourceRegistryExtensionGetDataSourcesData* _data_;
	ZeitgeistDataSourceRegistryExtension* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	self = (ZeitgeistDataSourceRegistryExtension*) base;
	_data_ = g_slice_new0 (ZeitgeistDataSourceRegistryExtensionGetDataSourcesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_data_source_registry_extension_real_get_data_sources);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_data_source_registry_extension_real_get_data_sources_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	zeitgeist_data_source_registry_extension_real_get_data_sources_co (_data_);
}


static GVariant* zeitgeist_data_source_registry_extension_real_get_data_sources_finish (ZeitgeistRemoteRegistry* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	ZeitgeistDataSourceRegistryExtensionGetDataSourcesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean zeitgeist_data_source_registry_extension_real_get_data_sources_co (ZeitgeistDataSourceRegistryExtensionGetDataSourcesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->sources;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = zeitgeist_data_sources_to_variant (_data_->_tmp0_);
	_data_->result = _data_->_tmp1_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gboolean zeitgeist_data_source_registry_extension_is_sender_known (ZeitgeistDataSourceRegistryExtension* self, const char* sender, GPtrArray* sender_array) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (sender_array != NULL, FALSE);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				GPtrArray* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				const char* _tmp7_;
				GPtrArray* _tmp8_;
				gint _tmp9_;
				gconstpointer _tmp10_ = NULL;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = sender_array;
				_tmp5_ = g_ptr_array_get_length (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = sender;
				_tmp8_ = sender_array;
				_tmp9_ = i;
				_tmp10_ = g_ptr_array_index (_tmp8_, (guint) _tmp9_);
				if (g_strcmp0 (_tmp7_, (const char*) _tmp10_) == 0) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static void zeitgeist_data_source_registry_extension_real_register_data_source_data_free (gpointer _data) {
	ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData* _data_;
	_data_ = _data;
	_g_free0 (_data_->unique_id);
	_g_free0 (_data_->name);
	_g_free0 (_data_->description);
	_g_variant_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData, _data_);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void zeitgeist_data_source_registry_extension_real_register_data_source (ZeitgeistRemoteRegistry* base, const gchar* unique_id, const gchar* name, const gchar* description, GVariant* event_templates, GCancellable* cancellable, const char* sender, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDataSourceRegistryExtension * self;
	ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData* _data_;
	ZeitgeistDataSourceRegistryExtension* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GCancellable* _tmp9_;
	GCancellable* _tmp10_;
	const char* _tmp11_;
	char* _tmp12_;
	self = (ZeitgeistDataSourceRegistryExtension*) base;
	_data_ = g_slice_new0 (ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_data_source_registry_extension_real_register_data_source);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_data_source_registry_extension_real_register_data_source_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = unique_id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->unique_id);
	_data_->unique_id = _tmp2_;
	_tmp3_ = name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->name);
	_data_->name = _tmp4_;
	_tmp5_ = description;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->description);
	_data_->description = _tmp6_;
	_tmp7_ = event_templates;
	_tmp8_ = _g_variant_ref0 (_tmp7_);
	_g_variant_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp8_;
	_tmp9_ = cancellable;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp10_;
	_tmp11_ = sender;
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp12_;
	zeitgeist_data_source_registry_extension_real_register_data_source_co (_data_);
}


static gboolean zeitgeist_data_source_registry_extension_real_register_data_source_finish (ZeitgeistRemoteRegistry* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static gboolean zeitgeist_data_source_registry_extension_real_register_data_source_co (ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->unique_id;
	_data_->_tmp1_ = _data_->name;
	_data_->_tmp2_ = _data_->description;
	g_debug ("ds-registry.vala:157: %s: %s, %s, %s", "Zeitgeist.DataSourceRegistryExtension.register_data_source", _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_);
	_data_->_tmp3_ = _data_->sender;
	if (_data_->_tmp3_ == NULL) {
		g_warning ("ds-registry.vala:161: %s: sender == null, ignoring request", "Zeitgeist.DataSourceRegistryExtension.register_data_source");
		_data_->result = FALSE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->running_ds;
	_data_->_tmp5_ = _data_->unique_id;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_hash_table_lookup (_data_->_tmp4_, _data_->_tmp5_);
	_data_->_tmp7_ = _g_ptr_array_ref0 ((GPtrArray*) _data_->_tmp6_);
	_data_->sender_array = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->sender_array;
	if (_data_->_tmp8_ == NULL) {
		_data_->_tmp9_ = g_ptr_array_new_with_free_func (_g_free0_);
		_g_ptr_array_unref0 (_data_->sender_array);
		_data_->sender_array = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->sender_array;
		_data_->_tmp11_ = _data_->sender;
		_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
		g_ptr_array_add (_data_->_tmp10_, _data_->_tmp12_);
		_data_->_tmp13_ = _data_->self->priv->running_ds;
		_data_->_tmp14_ = _data_->unique_id;
		_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->sender_array;
		_data_->_tmp17_ = _g_ptr_array_ref0 (_data_->_tmp16_);
		g_hash_table_insert (_data_->_tmp13_, _data_->_tmp15_, _data_->_tmp17_);
	} else {
		_data_->_tmp18_ = _data_->sender;
		_data_->_tmp19_ = _data_->sender_array;
		_data_->_tmp20_ = FALSE;
		_data_->_tmp20_ = zeitgeist_data_source_registry_extension_is_sender_known (_data_->self, _data_->_tmp18_, _data_->_tmp19_);
		if (!_data_->_tmp20_) {
			_data_->_tmp21_ = _data_->sender_array;
			_data_->_tmp22_ = _data_->sender;
			_data_->_tmp23_ = g_strdup (_data_->_tmp22_);
			g_ptr_array_add (_data_->_tmp21_, _data_->_tmp23_);
		}
	}
	_data_->_tmp24_ = _data_->self->priv->bus_name_2_ds;
	_data_->_tmp25_ = _data_->sender;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = g_hash_table_lookup (_data_->_tmp24_, (const gchar*) _data_->_tmp25_);
	_data_->ds_id = (const gchar*) _data_->_tmp26_;
	_data_->_tmp27_ = _data_->ds_id;
	if (_data_->_tmp27_ == NULL) {
		_data_->_tmp28_ = _data_->self->priv->bus_name_2_ds;
		_data_->_tmp29_ = _data_->sender;
		_data_->_tmp30_ = g_strdup ((gchar*) _data_->_tmp29_);
		_data_->_tmp31_ = _data_->unique_id;
		_data_->_tmp32_ = g_strdup (_data_->_tmp31_);
		g_hash_table_insert (_data_->_tmp28_, _data_->_tmp30_, _data_->_tmp32_);
	} else {
		_data_->_tmp34_ = _data_->ds_id;
		_data_->_tmp35_ = _data_->unique_id;
		if (g_strcmp0 (_data_->_tmp34_, _data_->_tmp35_) != 0) {
			_data_->_tmp36_ = _data_->ds_id;
			_data_->_tmp33_ = g_strcmp0 (_data_->_tmp36_, ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_MULTIPLE_MARKER) != 0;
		} else {
			_data_->_tmp33_ = FALSE;
		}
		_data_->_tmp37_ = _data_->_tmp33_;
		if (_data_->_tmp37_) {
			_data_->_tmp38_ = _data_->self->priv->bus_name_2_ds;
			_data_->_tmp39_ = _data_->sender;
			_data_->_tmp40_ = g_strdup ((gchar*) _data_->_tmp39_);
			_data_->_tmp41_ = g_strdup (ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_MULTIPLE_MARKER);
			g_hash_table_insert (_data_->_tmp38_, _data_->_tmp40_, _data_->_tmp41_);
		}
	}
	_data_->_tmp42_ = _data_->self->priv->sources;
	_data_->_tmp43_ = _data_->unique_id;
	_data_->_tmp44_ = NULL;
	_data_->_tmp44_ = g_hash_table_lookup (_data_->_tmp42_, _data_->_tmp43_);
	_data_->ds = (ZeitgeistDataSource*) _data_->_tmp44_;
	_data_->_tmp45_ = _data_->ds;
	if (_data_->_tmp45_ != NULL) {
		_data_->_tmp46_ = _data_->event_templates;
		_data_->_tmp47_ = NULL;
		_data_->_tmp47_ = zeitgeist_events_from_variant (_data_->_tmp46_, &_data_->_inner_error_);
		_data_->_tmp48_ = _data_->_tmp47_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_ptr_array_unref0 (_data_->templates);
				_g_ptr_array_unref0 (_data_->sender_array);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_ptr_array_unref0 (_data_->templates);
				_g_ptr_array_unref0 (_data_->sender_array);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_g_ptr_array_unref0 (_data_->templates);
		_data_->templates = _data_->_tmp48_;
		_data_->_tmp49_ = _data_->ds;
		_data_->_tmp50_ = _data_->name;
		zeitgeist_data_source_set_name (_data_->_tmp49_, _data_->_tmp50_);
		_data_->_tmp51_ = _data_->ds;
		_data_->_tmp52_ = _data_->description;
		zeitgeist_data_source_set_description (_data_->_tmp51_, _data_->_tmp52_);
		_data_->_tmp53_ = _data_->ds;
		_data_->_tmp54_ = _data_->templates;
		zeitgeist_data_source_set_event_templates (_data_->_tmp53_, _data_->_tmp54_);
		_data_->_tmp55_ = _data_->ds;
		_data_->_tmp56_ = 0LL;
		_data_->_tmp56_ = zeitgeist_timestamp_from_now ();
		zeitgeist_data_source_set_timestamp (_data_->_tmp55_, _data_->_tmp56_);
		_data_->_tmp57_ = _data_->ds;
		zeitgeist_data_source_set_running (_data_->_tmp57_, TRUE);
		_data_->self->priv->dirty = TRUE;
		_data_->_tmp58_ = _data_->ds;
		_data_->_tmp59_ = NULL;
		_data_->_tmp59_ = zeitgeist_data_source_to_variant (_data_->_tmp58_);
		_data_->_tmp60_ = _data_->_tmp59_;
		g_signal_emit_by_name ((ZeitgeistRemoteRegistry*) _data_->self, "data-source-registered", _data_->_tmp60_);
		_g_variant_unref0 (_data_->_tmp60_);
		_data_->_tmp61_ = _data_->ds;
		_data_->_tmp62_ = zeitgeist_data_source_get_enabled (_data_->_tmp61_);
		_data_->_tmp63_ = _data_->_tmp62_;
		_data_->result = _data_->_tmp63_;
		_g_ptr_array_unref0 (_data_->templates);
		_g_ptr_array_unref0 (_data_->sender_array);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp64_ = _data_->event_templates;
		_data_->_tmp65_ = NULL;
		_data_->_tmp65_ = zeitgeist_events_from_variant (_data_->_tmp64_, &_data_->_inner_error_);
		_data_->_tmp66_ = _data_->_tmp65_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_ptr_array_unref0 (_data_->templates);
				_g_ptr_array_unref0 (_data_->sender_array);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_ptr_array_unref0 (_data_->templates);
				_g_ptr_array_unref0 (_data_->sender_array);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_g_ptr_array_unref0 (_data_->templates);
		_data_->templates = _data_->_tmp66_;
		_data_->_tmp67_ = _data_->unique_id;
		_data_->_tmp68_ = _data_->name;
		_data_->_tmp69_ = _data_->description;
		_data_->_tmp70_ = _data_->templates;
		_data_->_tmp71_ = zeitgeist_data_source_new_full (_data_->_tmp67_, _data_->_tmp68_, _data_->_tmp69_, _data_->_tmp70_);
		_data_->new_ds = _data_->_tmp71_;
		_data_->_tmp72_ = _data_->new_ds;
		zeitgeist_data_source_set_enabled (_data_->_tmp72_, TRUE);
		_data_->_tmp73_ = _data_->new_ds;
		zeitgeist_data_source_set_running (_data_->_tmp73_, TRUE);
		_data_->_tmp74_ = _data_->new_ds;
		_data_->_tmp75_ = 0LL;
		_data_->_tmp75_ = zeitgeist_timestamp_from_now ();
		zeitgeist_data_source_set_timestamp (_data_->_tmp74_, _data_->_tmp75_);
		_data_->_tmp76_ = _data_->self->priv->sources;
		_data_->_tmp77_ = _data_->unique_id;
		_data_->_tmp78_ = g_strdup (_data_->_tmp77_);
		_data_->_tmp79_ = _data_->new_ds;
		_data_->_tmp80_ = _g_object_ref0 (_data_->_tmp79_);
		g_hash_table_insert (_data_->_tmp76_, _data_->_tmp78_, _data_->_tmp80_);
		_data_->self->priv->dirty = TRUE;
		_data_->_tmp81_ = _data_->new_ds;
		_data_->_tmp82_ = NULL;
		_data_->_tmp82_ = zeitgeist_data_source_to_variant (_data_->_tmp81_);
		_data_->_tmp83_ = _data_->_tmp82_;
		g_signal_emit_by_name ((ZeitgeistRemoteRegistry*) _data_->self, "data-source-registered", _data_->_tmp83_);
		_g_variant_unref0 (_data_->_tmp83_);
		_data_->_tmp84_ = _data_->new_ds;
		_data_->_tmp85_ = zeitgeist_data_source_get_enabled (_data_->_tmp84_);
		_data_->_tmp86_ = _data_->_tmp85_;
		_data_->result = _data_->_tmp86_;
		_g_object_unref0 (_data_->new_ds);
		_g_ptr_array_unref0 (_data_->templates);
		_g_ptr_array_unref0 (_data_->sender_array);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_ptr_array_unref0 (_data_->templates);
	_g_ptr_array_unref0 (_data_->sender_array);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_data_source_registry_extension_real_set_data_source_enabled_data_free (gpointer _data) {
	ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData* _data_;
	_data_ = _data;
	_g_free0 (_data_->unique_id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData, _data_);
}


static void zeitgeist_data_source_registry_extension_real_set_data_source_enabled (ZeitgeistRemoteRegistry* base, const gchar* unique_id, gboolean enabled, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDataSourceRegistryExtension * self;
	ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData* _data_;
	ZeitgeistDataSourceRegistryExtension* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
	self = (ZeitgeistDataSourceRegistryExtension*) base;
	_data_ = g_slice_new0 (ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_data_source_registry_extension_real_set_data_source_enabled);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_data_source_registry_extension_real_set_data_source_enabled_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = unique_id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->unique_id);
	_data_->unique_id = _tmp2_;
	_tmp3_ = enabled;
	_data_->enabled = _tmp3_;
	_tmp4_ = cancellable;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp5_;
	zeitgeist_data_source_registry_extension_real_set_data_source_enabled_co (_data_);
}


static void zeitgeist_data_source_registry_extension_real_set_data_source_enabled_finish (ZeitgeistRemoteRegistry* base, GAsyncResult* _res_, GError** error) {
	ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean zeitgeist_data_source_registry_extension_real_set_data_source_enabled_co (ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->unique_id;
	_data_->_tmp1_ = _data_->enabled;
	g_debug ("ds-registry.vala:225: %s: %s, %d", "Zeitgeist.DataSourceRegistryExtension.set_data_source_enabled", _data_->_tmp0_, (gint) _data_->_tmp1_);
	_data_->_tmp2_ = _data_->self->priv->sources;
	_data_->_tmp3_ = _data_->unique_id;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_hash_table_lookup (_data_->_tmp2_, _data_->_tmp3_);
	_data_->ds = (ZeitgeistDataSource*) _data_->_tmp4_;
	_data_->_tmp5_ = _data_->ds;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->ds;
		_data_->_tmp7_ = zeitgeist_data_source_get_enabled (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->enabled;
		if (_data_->_tmp8_ != _data_->_tmp9_) {
			_data_->_tmp10_ = _data_->ds;
			_data_->_tmp11_ = _data_->enabled;
			zeitgeist_data_source_set_enabled (_data_->_tmp10_, _data_->_tmp11_);
			_data_->self->priv->dirty = TRUE;
			_data_->_tmp12_ = _data_->unique_id;
			_data_->_tmp13_ = _data_->enabled;
			g_signal_emit_by_name ((ZeitgeistRemoteRegistry*) _data_->self, "data-source-enabled", _data_->_tmp12_, _data_->_tmp13_);
		}
	} else {
		_data_->_tmp14_ = _data_->unique_id;
		g_warning ("ds-registry.vala:238: DataSource \"%s\" isn't registered!", _data_->_tmp14_);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_data_source_registry_extension_real_get_data_source_from_id_data_free (gpointer _data) {
	ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData* _data_;
	_data_ = _data;
	_g_free0 (_data_->unique_id);
	_g_object_unref0 (_data_->cancellable);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData, _data_);
}


static void zeitgeist_data_source_registry_extension_real_get_data_source_from_id (ZeitgeistRemoteRegistry* base, const gchar* unique_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistDataSourceRegistryExtension * self;
	ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData* _data_;
	ZeitgeistDataSourceRegistryExtension* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (ZeitgeistDataSourceRegistryExtension*) base;
	_data_ = g_slice_new0 (ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_data_source_registry_extension_real_get_data_source_from_id);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_data_source_registry_extension_real_get_data_source_from_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = unique_id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->unique_id);
	_data_->unique_id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	zeitgeist_data_source_registry_extension_real_get_data_source_from_id_co (_data_);
}


static GVariant* zeitgeist_data_source_registry_extension_real_get_data_source_from_id_finish (ZeitgeistRemoteRegistry* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean zeitgeist_data_source_registry_extension_real_get_data_source_from_id_co (ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->sources;
	_data_->_tmp1_ = _data_->unique_id;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_hash_table_lookup (_data_->_tmp0_, _data_->_tmp1_);
	_data_->ds = (ZeitgeistDataSource*) _data_->_tmp2_;
	_data_->_tmp3_ = _data_->ds;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = _data_->ds;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = zeitgeist_data_source_to_variant (_data_->_tmp4_);
		_data_->result = _data_->_tmp5_;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->unique_id;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_strdup_printf ("Datasource with unique ID: %s not found", _data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_KEY, _data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_g_free0 (_data_->_tmp8_);
	_data_->_inner_error_ = _data_->_tmp10_;
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
	g_error_free (_data_->_inner_error_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void g_ptr_array_set (GPtrArray* self, guint index, gpointer data) {
	gpointer _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = data;
	data = NULL;
	g_ptr_array_add (self, _tmp0_);
	_tmp1_ = index;
	g_ptr_array_remove_index_fast (self, _tmp1_);
}


static void zeitgeist_data_source_registry_extension_real_pre_insert_events (ZeitgeistExtension* base, GPtrArray* events, const char* sender) {
	ZeitgeistDataSourceRegistryExtension * self;
	GHashTable* _tmp0_;
	GList* _tmp1_ = NULL;
	self = (ZeitgeistDataSourceRegistryExtension*) base;
	g_return_if_fail (events != NULL);
	_tmp0_ = self->priv->running_ds;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	{
		GList* unique_id_collection = NULL;
		GList* unique_id_it = NULL;
		unique_id_collection = _tmp1_;
		for (unique_id_it = unique_id_collection; unique_id_it != NULL; unique_id_it = unique_id_it->next) {
			const gchar* unique_id = NULL;
			unique_id = (const gchar*) unique_id_it->data;
			{
				GHashTable* _tmp2_;
				const gchar* _tmp3_;
				gconstpointer _tmp4_ = NULL;
				GPtrArray* _tmp5_;
				GPtrArray* bus_names;
				const char* _tmp6_;
				GPtrArray* _tmp7_;
				gboolean _tmp8_ = FALSE;
				_tmp2_ = self->priv->running_ds;
				_tmp3_ = unique_id;
				_tmp4_ = g_hash_table_lookup (_tmp2_, _tmp3_);
				_tmp5_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp4_);
				bus_names = _tmp5_;
				_tmp6_ = sender;
				_tmp7_ = bus_names;
				_tmp8_ = zeitgeist_data_source_registry_extension_is_sender_known (self, _tmp6_, _tmp7_);
				if (_tmp8_) {
					GHashTable* _tmp9_;
					const gchar* _tmp10_;
					gconstpointer _tmp11_ = NULL;
					ZeitgeistDataSource* _tmp12_;
					ZeitgeistDataSource* data_source;
					ZeitgeistDataSource* _tmp13_;
					gint64 _tmp14_ = 0LL;
					GHashTable* _tmp15_;
					const char* _tmp16_;
					gconstpointer _tmp17_ = NULL;
					const gchar* ds_id;
					gboolean _tmp18_ = FALSE;
					ZeitgeistDataSource* _tmp19_;
					gboolean _tmp20_;
					gboolean _tmp21_;
					gboolean _tmp23_;
					_tmp9_ = self->priv->sources;
					_tmp10_ = unique_id;
					_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
					_tmp12_ = _g_object_ref0 ((ZeitgeistDataSource*) _tmp11_);
					data_source = _tmp12_;
					_tmp13_ = data_source;
					_tmp14_ = zeitgeist_timestamp_from_now ();
					zeitgeist_data_source_set_timestamp (_tmp13_, _tmp14_);
					self->priv->dirty = TRUE;
					_tmp15_ = self->priv->bus_name_2_ds;
					_tmp16_ = sender;
					_tmp17_ = g_hash_table_lookup (_tmp15_, (const gchar*) _tmp16_);
					ds_id = (const gchar*) _tmp17_;
					_tmp19_ = data_source;
					_tmp20_ = zeitgeist_data_source_get_enabled (_tmp19_);
					_tmp21_ = _tmp20_;
					if (!_tmp21_) {
						const gchar* _tmp22_;
						_tmp22_ = ds_id;
						_tmp18_ = g_strcmp0 (_tmp22_, ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_MULTIPLE_MARKER) != 0;
					} else {
						_tmp18_ = FALSE;
					}
					_tmp23_ = _tmp18_;
					if (_tmp23_) {
						{
							gint i;
							i = 0;
							{
								gboolean _tmp24_;
								_tmp24_ = TRUE;
								while (TRUE) {
									gboolean _tmp25_;
									gint _tmp27_;
									GPtrArray* _tmp28_;
									gint _tmp29_;
									gint _tmp30_;
									GPtrArray* _tmp31_;
									gint _tmp32_;
									_tmp25_ = _tmp24_;
									if (!_tmp25_) {
										gint _tmp26_;
										_tmp26_ = i;
										i = _tmp26_ + 1;
									}
									_tmp24_ = FALSE;
									_tmp27_ = i;
									_tmp28_ = events;
									_tmp29_ = g_ptr_array_get_length (_tmp28_);
									_tmp30_ = _tmp29_;
									if (!(_tmp27_ < _tmp30_)) {
										break;
									}
									_tmp31_ = events;
									_tmp32_ = i;
									g_ptr_array_set (_tmp31_, (guint) _tmp32_, NULL);
								}
							}
						}
					}
					_g_object_unref0 (data_source);
				}
				_g_ptr_array_unref0 (bus_names);
			}
		}
		_g_list_free0 (unique_id_collection);
	}
}


static void zeitgeist_data_source_registry_extension_name_owner_changed (ZeitgeistDataSourceRegistryExtension* self, GDBusConnection* conn, const gchar* sender, const gchar* path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters) {
	GVariant* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* name;
	GVariant* _tmp5_;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* new_owner;
	const gchar* _tmp10_;
	GPtrArray* _tmp11_;
	GPtrArray* disconnected_ds;
	GPtrArray* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp0_ = parameters;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_dup_string (_tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp2_);
	name = _tmp4_;
	_tmp5_ = parameters;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 2);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_dup_string (_tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp7_);
	new_owner = _tmp9_;
	_tmp10_ = new_owner;
	if (g_strcmp0 (_tmp10_, "") != 0) {
		_g_free0 (new_owner);
		_g_free0 (name);
		return;
	}
	_tmp11_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	disconnected_ds = _tmp11_;
	{
		GHashTable* _tmp12_;
		GHashTableIter iter = {0};
		const gchar* uid = NULL;
		GPtrArray* name_arr = NULL;
		_tmp12_ = self->priv->running_ds;
		g_hash_table_iter_init (&iter, _tmp12_);
		while (TRUE) {
			gconstpointer _tmp13_ = NULL;
			gconstpointer _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			_tmp15_ = g_hash_table_iter_next (&iter, &_tmp13_, &_tmp14_);
			uid = _tmp13_;
			name_arr = _tmp14_;
			if (!_tmp15_) {
				break;
			}
			{
				gint i;
				i = 0;
				{
					gboolean _tmp16_;
					_tmp16_ = TRUE;
					while (TRUE) {
						gboolean _tmp17_;
						gint _tmp19_;
						GPtrArray* _tmp20_;
						gint _tmp21_;
						gint _tmp22_;
						GPtrArray* _tmp23_;
						gint _tmp24_;
						gconstpointer _tmp25_ = NULL;
						const gchar* _tmp26_;
						_tmp17_ = _tmp16_;
						if (!_tmp17_) {
							gint _tmp18_;
							_tmp18_ = i;
							i = _tmp18_ + 1;
						}
						_tmp16_ = FALSE;
						_tmp19_ = i;
						_tmp20_ = name_arr;
						_tmp21_ = g_ptr_array_get_length (_tmp20_);
						_tmp22_ = _tmp21_;
						if (!(_tmp19_ < _tmp22_)) {
							break;
						}
						_tmp23_ = name_arr;
						_tmp24_ = i;
						_tmp25_ = g_ptr_array_index (_tmp23_, (guint) _tmp24_);
						_tmp26_ = name;
						if (g_strcmp0 ((const char*) _tmp25_, _tmp26_) == 0) {
							GPtrArray* _tmp27_;
							GHashTable* _tmp28_;
							const gchar* _tmp29_;
							gconstpointer _tmp30_ = NULL;
							ZeitgeistDataSource* _tmp31_;
							GPtrArray* _tmp32_;
							gint _tmp33_;
							_tmp27_ = disconnected_ds;
							_tmp28_ = self->priv->sources;
							_tmp29_ = uid;
							_tmp30_ = g_hash_table_lookup (_tmp28_, _tmp29_);
							_tmp31_ = _g_object_ref0 ((ZeitgeistDataSource*) _tmp30_);
							g_ptr_array_add (_tmp27_, _tmp31_);
							_tmp32_ = name_arr;
							_tmp33_ = i;
							i = _tmp33_ - 1;
							g_ptr_array_remove_index_fast (_tmp32_, (guint) _tmp33_);
						}
					}
				}
			}
		}
	}
	_tmp34_ = disconnected_ds;
	_tmp35_ = g_ptr_array_get_length (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp36_ == 0) {
		_g_ptr_array_unref0 (disconnected_ds);
		_g_free0 (new_owner);
		_g_free0 (name);
		return;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp37_;
			_tmp37_ = TRUE;
			while (TRUE) {
				gboolean _tmp38_;
				gint _tmp40_;
				GPtrArray* _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				GPtrArray* _tmp44_;
				gint _tmp45_;
				gconstpointer _tmp46_ = NULL;
				ZeitgeistDataSource* _tmp47_;
				ZeitgeistDataSource* ds;
				ZeitgeistDataSource* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				const gchar* uid;
				ZeitgeistDataSource* _tmp51_;
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				ZeitgeistDataSource* _tmp55_;
				gint64 _tmp56_ = 0LL;
				GHashTable* _tmp57_;
				const gchar* _tmp58_;
				gconstpointer _tmp59_ = NULL;
				gint _tmp60_;
				gint _tmp61_;
				_tmp38_ = _tmp37_;
				if (!_tmp38_) {
					gint _tmp39_;
					_tmp39_ = i;
					i = _tmp39_ + 1;
				}
				_tmp37_ = FALSE;
				_tmp40_ = i;
				_tmp41_ = disconnected_ds;
				_tmp42_ = g_ptr_array_get_length (_tmp41_);
				_tmp43_ = _tmp42_;
				if (!(_tmp40_ < _tmp43_)) {
					break;
				}
				_tmp44_ = disconnected_ds;
				_tmp45_ = i;
				_tmp46_ = g_ptr_array_index (_tmp44_, (guint) _tmp45_);
				_tmp47_ = _g_object_ref0 ((ZeitgeistDataSource*) _tmp46_);
				ds = _tmp47_;
				_tmp48_ = ds;
				_tmp49_ = zeitgeist_data_source_get_unique_id (_tmp48_);
				_tmp50_ = _tmp49_;
				uid = _tmp50_;
				_tmp51_ = ds;
				_tmp52_ = zeitgeist_data_source_get_name (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = uid;
				g_debug ("ds-registry.vala:320: Client disconnected: %s [%s]", _tmp53_, _tmp54_);
				_tmp55_ = ds;
				_tmp56_ = zeitgeist_timestamp_from_now ();
				zeitgeist_data_source_set_timestamp (_tmp55_, _tmp56_);
				self->priv->dirty = TRUE;
				_tmp57_ = self->priv->running_ds;
				_tmp58_ = uid;
				_tmp59_ = g_hash_table_lookup (_tmp57_, _tmp58_);
				_tmp60_ = g_ptr_array_get_length ((GPtrArray*) _tmp59_);
				_tmp61_ = _tmp60_;
				if (_tmp61_ == 0) {
					ZeitgeistDataSource* _tmp62_;
					const gchar* _tmp63_;
					const gchar* _tmp64_;
					const gchar* _tmp65_;
					GHashTable* _tmp66_;
					const gchar* _tmp67_;
					ZeitgeistDataSource* _tmp68_;
					ZeitgeistDataSource* _tmp69_;
					GVariant* _tmp70_ = NULL;
					GVariant* _tmp71_;
					_tmp62_ = ds;
					_tmp63_ = zeitgeist_data_source_get_name (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = uid;
					g_debug ("ds-registry.vala:328: No remaining client running: %s [%s]", _tmp64_, _tmp65_);
					_tmp66_ = self->priv->running_ds;
					_tmp67_ = uid;
					g_hash_table_remove (_tmp66_, _tmp67_);
					_tmp68_ = ds;
					zeitgeist_data_source_set_running (_tmp68_, FALSE);
					_tmp69_ = ds;
					_tmp70_ = zeitgeist_data_source_to_variant (_tmp69_);
					_tmp71_ = _tmp70_;
					g_signal_emit_by_name ((ZeitgeistRemoteRegistry*) self, "data-source-disconnected", _tmp71_);
					_g_variant_unref0 (_tmp71_);
				}
				_g_object_unref0 (ds);
			}
		}
	}
	_g_ptr_array_unref0 (disconnected_ds);
	_g_free0 (new_owner);
	_g_free0 (name);
}


static gboolean zeitgeist_data_source_registry_extension_flush (ZeitgeistDataSourceRegistryExtension* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->dirty;
	if (_tmp0_) {
		GHashTable* _tmp1_;
		GVariant* _tmp2_ = NULL;
		GVariant* v;
		GVariant* _tmp3_;
		_tmp1_ = self->priv->sources;
		_tmp2_ = zeitgeist_data_sources_to_variant (_tmp1_);
		v = _tmp2_;
		_tmp3_ = v;
		zeitgeist_extension_store_config ((ZeitgeistExtension*) self, "registry", _tmp3_);
		self->priv->dirty = FALSE;
		_g_variant_unref0 (v);
	}
	result = TRUE;
	return result;
}


static void _g_ptr_array_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}


static void _zeitgeist_data_source_registry_extension_name_owner_changed_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self) {
	zeitgeist_data_source_registry_extension_name_owner_changed (self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}


static gboolean _zeitgeist_data_source_registry_extension_flush_gsource_func (gpointer self) {
	gboolean result;
	result = zeitgeist_data_source_registry_extension_flush (self);
	return result;
}


static GObject * zeitgeist_data_source_registry_extension_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistDataSourceRegistryExtension * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GVariant* _tmp6_ = NULL;
	GVariant* registry;
	GVariant* _tmp7_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_data_source_registry_extension_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION, ZeitgeistDataSourceRegistryExtension);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->bus_name_2_ds);
	self->priv->bus_name_2_ds = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->running_ds);
	self->priv->running_ds = _tmp5_;
	_tmp6_ = zeitgeist_extension_retrieve_config ((ZeitgeistExtension*) self, "registry", ZEITGEIST_DATA_SOURCES_SIG_DATASOURCES);
	registry = _tmp6_;
	_tmp7_ = registry;
	if (_tmp7_ != NULL) {
		{
			GVariant* _tmp8_;
			GHashTable* _tmp9_ = NULL;
			GHashTable* _tmp10_;
			_tmp8_ = registry;
			_tmp9_ = zeitgeist_data_sources_registry_from_variant (_tmp8_, TRUE, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
					goto __catch1_zeitgeist_data_model_error;
				}
				_g_variant_unref0 (registry);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_g_hash_table_unref0 (self->priv->sources);
			self->priv->sources = _tmp10_;
		}
		goto __finally1;
		__catch1_zeitgeist_data_model_error:
		{
			GError* e = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			GHashFunc _tmp13_;
			GEqualFunc _tmp14_;
			GHashTable* _tmp15_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_warning ("ds-registry.vala:84: Error while loading datasource registry: %s", _tmp12_);
			_tmp13_ = g_str_hash;
			_tmp14_ = g_str_equal;
			_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, _g_free0_, _g_object_unref0_);
			_g_hash_table_unref0 (self->priv->sources);
			self->priv->sources = _tmp15_;
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_variant_unref0 (registry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	} else {
		GHashFunc _tmp16_;
		GEqualFunc _tmp17_;
		GHashTable* _tmp18_;
		_tmp16_ = g_str_hash;
		_tmp17_ = g_str_equal;
		_tmp18_ = g_hash_table_new_full (_tmp16_, _tmp17_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (self->priv->sources);
		self->priv->sources = _tmp18_;
	}
	{
		GDBusConnection* _tmp19_ = NULL;
		GDBusConnection* connection;
		GDBusConnection* _tmp20_;
		guint _tmp21_ = 0U;
		guint _tmp22_;
		GDBusConnection* _tmp23_;
		_tmp19_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp19_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp20_ = connection;
		_tmp21_ = zeitgeist_remote_registry_register_object ((ZeitgeistRemoteRegistry*) self, _tmp20_, "/org/gnome/zeitgeist/data_source_registry", &_inner_error_);
		_tmp22_ = _tmp21_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (connection);
			goto __catch2_g_error;
		}
		self->priv->registration_id = _tmp22_;
		_tmp23_ = connection;
		g_dbus_connection_signal_subscribe (_tmp23_, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameOwnerChanged", "/org/freedesktop/DBus", NULL, 0, _zeitgeist_data_source_registry_extension_name_owner_changed_gd_bus_signal_callback, g_object_ref (self), g_object_unref);
		_g_object_unref0 (connection);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = err;
		_tmp25_ = _tmp24_->message;
		g_warning ("ds-registry.vala:109: %s", _tmp25_);
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_variant_unref0 (registry);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	g_timeout_add_seconds_full (G_PRIORITY_LOW, ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_DISK_WRITE_TIMEOUT, _zeitgeist_data_source_registry_extension_flush_gsource_func, g_object_ref (self), g_object_unref);
	_g_variant_unref0 (registry);
	return obj;
}


static void zeitgeist_data_source_registry_extension_class_init (ZeitgeistDataSourceRegistryExtensionClass * klass) {
	zeitgeist_data_source_registry_extension_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistDataSourceRegistryExtensionPrivate));
	ZEITGEIST_EXTENSION_CLASS (klass)->unload = zeitgeist_data_source_registry_extension_real_unload;
	ZEITGEIST_EXTENSION_CLASS (klass)->pre_insert_events = zeitgeist_data_source_registry_extension_real_pre_insert_events;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_data_source_registry_extension_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_data_source_registry_extension_finalize;
}


static void zeitgeist_data_source_registry_extension_zeitgeist_remote_registry_interface_init (ZeitgeistRemoteRegistryIface * iface) {
	zeitgeist_data_source_registry_extension_zeitgeist_remote_registry_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_data_sources = (GVariant* (*)(ZeitgeistRemoteRegistry*, GCancellable*, GError**)) zeitgeist_data_source_registry_extension_real_get_data_sources;
	iface->get_data_sources_finish = zeitgeist_data_source_registry_extension_real_get_data_sources_finish;
	iface->register_data_source = (gboolean (*)(ZeitgeistRemoteRegistry*, const gchar*, const gchar*, const gchar*, GVariant*, GCancellable*, const char*, GError**)) zeitgeist_data_source_registry_extension_real_register_data_source;
	iface->register_data_source_finish = zeitgeist_data_source_registry_extension_real_register_data_source_finish;
	iface->set_data_source_enabled = (void (*)(ZeitgeistRemoteRegistry*, const gchar*, gboolean, GCancellable*, GError**)) zeitgeist_data_source_registry_extension_real_set_data_source_enabled;
	iface->set_data_source_enabled_finish = zeitgeist_data_source_registry_extension_real_set_data_source_enabled_finish;
	iface->get_data_source_from_id = (GVariant* (*)(ZeitgeistRemoteRegistry*, const gchar*, GCancellable*, GError**)) zeitgeist_data_source_registry_extension_real_get_data_source_from_id;
	iface->get_data_source_from_id_finish = zeitgeist_data_source_registry_extension_real_get_data_source_from_id_finish;
}


static void zeitgeist_data_source_registry_extension_instance_init (ZeitgeistDataSourceRegistryExtension * self) {
	self->priv = ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_GET_PRIVATE (self);
}


static void zeitgeist_data_source_registry_extension_finalize (GObject* obj) {
	ZeitgeistDataSourceRegistryExtension * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION, ZeitgeistDataSourceRegistryExtension);
	_g_hash_table_unref0 (self->priv->sources);
	_g_hash_table_unref0 (self->priv->running_ds);
	_g_hash_table_unref0 (self->priv->bus_name_2_ds);
	G_OBJECT_CLASS (zeitgeist_data_source_registry_extension_parent_class)->finalize (obj);
}


GType zeitgeist_data_source_registry_extension_get_type (void) {
	return zeitgeist_data_source_registry_extension_type_id;
}


GType zeitgeist_data_source_registry_extension_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistDataSourceRegistryExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_data_source_registry_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistDataSourceRegistryExtension), 0, (GInstanceInitFunc) zeitgeist_data_source_registry_extension_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_registry_info = { (GInterfaceInitFunc) zeitgeist_data_source_registry_extension_zeitgeist_remote_registry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_data_source_registry_extension_type_id = g_type_module_register_type (module, ZEITGEIST_TYPE_EXTENSION, "ZeitgeistDataSourceRegistryExtension", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_data_source_registry_extension_type_id, ZEITGEIST_TYPE_REMOTE_REGISTRY, &zeitgeist_remote_registry_info);
	return zeitgeist_data_source_registry_extension_type_id;
}


GType zeitgeist_extension_register (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	zeitgeist_data_source_registry_extension_register_type (module);
	result = ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION;
	return result;
}



