% Turabian Formatting for LaTeX
%
% Based on the Chicago Manual of Style (16th edition) and Kate Turabian's A
% Manual for Writers of Research Papers, Theses, and Dissertations (8th edition)
%
% ==============================
% Copyright 2013 Omar Abdool
%
% This work may be distributed and/or modified under the conditions of the LaTeX
% Project Public License (LPPL), either version 1.3 of this license or (at your
% option) any later version.
%
% The latest version of this license is in:
%	http://www.latex-project.org/lppl.txt
% and version 1.3 or later is part of all distributions of LaTeX version
% 2005/12/01 or later.
%
% LPPL Maintenance Status: maintained (by Omar Abdool)
%
% This work consists of the files: turabian-formatting.sty,
% turabian-researchpaper.cls, turabian-thesis.cls, turabian-formatting-doc.tex,
% and turabian-formatting-doc.pdf (in addition to the README file).
%
% ==============================
%
%


\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{turabian-thesis}[2015/11/14 Turabian Theses and Dissertations]


% Default point size
\def\@@ptsize{12pt}


% Options for document class, some passed to book class

\DeclareOption{raggedright}{%
	\PassOptionsToPackage{\CurrentOption}{turabian-formatting}}

\DeclareOption{emptymargins}{%
	\PassOptionsToPackage{\CurrentOption}{turabian-formatting}}

\DeclareOption{endnotes}{%
	\PassOptionsToPackage{\CurrentOption}{turabian-formatting}}

\DeclareOption{twocolumn}{%
	\ClassWarningNoLine{turabian-researchpaper}{The '\CurrentOption' option is not supported.}
	\OptionNotUsed}

\DeclareOption{notitlepage}{%
	\ClassWarningNoLine{turabian-researchpaper}{The '\CurrentOption' option is not supported.}
	\OptionNotUsed}

\DeclareOption{10pt}{\def\@@ptsize{10pt}}

\DeclareOption{11pt}{\def\@@ptsize{11pt}}

\DeclareOption{12pt}{\def\@@ptsize{12pt}}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}

\ProcessOptions\relax


\LoadClass[titlepage,oneside,onecolumn,\@@ptsize]{book}


\RequirePackage{geometry}

\RequirePackage{turabian-formatting}


% Margin adjustment by increasing the binding off-set

\geometry{bindingoffset=0.5in}


% Renew \maketitle command Thesis/Dissertation title page.

\institution{[Institution]}

\newcommand{\faculty}[1]{\def\@faculty{#1}}
\faculty{[Faculty]}

\newcommand{\mydegree}[1]{\def\@mydegree{#1}}
\mydegree{[Degree]}

\newcommand{\department}[1]{\def\@department{#1}}
\department{[Department]}

\newcommand{\location}[1]{\def\@location{#1}}
\location{[City], [State/Province]}

\renewcommand{\maketitle}{%
	\begin{titlepage}%
		\let\footnotesize\small
		\let\footnoterule\relax
		\renewcommand{\thanks}[1]{\def\@thanks{##1}}
		\thanks{}
		\normalfont\normalsize
		\begin{center}
			\vspace*{-1.2\baselineskip}
			\parskip=0.833\baselineskip
			\@institution\par
			\vspace*{\stretch{1}}
			\ifthenelse{\equal{\@subtitle}{}}%
				{%
					{\bfseries\@title}\par%
				}%
				{%
					{\bfseries\@title :}\par
					{\bfseries\@subtitle}\par%
				}
			\vspace*{\stretch{1}}
			A Dissertation Submitted to\par
			\@faculty\par
			in Candidacy for the Degree of\par
			\@mydegree\par
			\vspace*{1\baselineskip}
			\@department\par
			\vspace*{\stretch{1}}
			by\par
			{\bfseries\@author}\par
			\vspace*{\stretch{1}}
			\@location\par
			\@date
			\parskip=0pt
		\end{center}%
	\end{titlepage}%

	% Copyright page
	\setcounter{page}{2}
	\singlespacing
	\vspace*{\stretch{1}}
	\noindent Copyright \copyright\ \the\year\ by \@author \\*\noindent All rights reserved
	\clearpage

	\setcounter{footnote}{0}

	\global\let\thanks\relax
	\global\let\maketitle\relax

	\global\let\@thanks\@empty
	\global\let\@author\@empty
	\global\let\@course\@empty
	\global\let\@institution\@empty
	\global\let\@date\@empty
	\global\let\@title\@empty
	\global\let\@subtitle\@empty
	\global\let\@location\@empty
	\global\let\@mydegree\@empty
	\global\let\@department\@empty
	\global\let\@faculty\@empty

	\global\let\title\relax
	\global\let\subtitle\relax
	\global\let\author\relax
	\global\let\date\relax
	\global\let\course\relax
	\global\let\institution\relax
	\global\let\location\relax
	\global\let\mydegree\relax
	\global\let\department\relax
	\global\let\faculty\relax
	\global\let\and\relax
}


