#include <qtwebkit_includes.h>

#include <smoke.h>
#include <qtwebkit_smoke.h>

namespace __smokeqtwebkit {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QAction
      switch(to) {
        case 1: return (void*)(QAction*)xptr;
        default: return xptr;
      }
    case 2:   //QActionEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QActionEvent*)xptr;
        case 2: return (void*)(QActionEvent*)xptr;
        default: return xptr;
      }
    case 3:   //QBool
      switch(to) {
        case 3: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 4:   //QByteArray
      switch(to) {
        case 4: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 5:   //QChildEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 5: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 6:   //QCloseEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QCloseEvent*)xptr;
        case 6: return (void*)(QCloseEvent*)xptr;
        default: return xptr;
      }
    case 7:   //QContextMenuEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QContextMenuEvent*)xptr;
        case 7: return (void*)(QContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 8:   //QDateTime
      switch(to) {
        case 8: return (void*)(QDateTime*)xptr;
        default: return xptr;
      }
    case 9:   //QDragEnterEvent
      switch(to) {
        case 11: return (void*)(QDragMoveEvent*)(QDragEnterEvent*)xptr;
        case 12: return (void*)(QDropEvent*)(QDragEnterEvent*)xptr;
        case 13: return (void*)(QEvent*)(QDragEnterEvent*)xptr;
        case 9: return (void*)(QDragEnterEvent*)xptr;
        default: return xptr;
      }
    case 10:   //QDragLeaveEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QDragLeaveEvent*)xptr;
        case 10: return (void*)(QDragLeaveEvent*)xptr;
        default: return xptr;
      }
    case 11:   //QDragMoveEvent
      switch(to) {
        case 12: return (void*)(QDropEvent*)(QDragMoveEvent*)xptr;
        case 13: return (void*)(QEvent*)(QDragMoveEvent*)xptr;
        case 11: return (void*)(QDragMoveEvent*)xptr;
        default: return xptr;
      }
    case 12:   //QDropEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QDropEvent*)xptr;
        case 12: return (void*)(QDropEvent*)xptr;
        default: return xptr;
      }
    case 13:   //QEvent
      switch(to) {
        case 13: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 14:   //QFocusEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QFocusEvent*)xptr;
        case 14: return (void*)(QFocusEvent*)xptr;
        default: return xptr;
      }
    case 15:   //QFont
      switch(to) {
        case 15: return (void*)(QFont*)xptr;
        default: return xptr;
      }
    case 17:   //QHideEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QHideEvent*)xptr;
        case 17: return (void*)(QHideEvent*)xptr;
        default: return xptr;
      }
    case 18:   //QIcon
      switch(to) {
        case 18: return (void*)(QIcon*)xptr;
        default: return xptr;
      }
    case 19:   //QInputMethodEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QInputMethodEvent*)xptr;
        case 19: return (void*)(QInputMethodEvent*)xptr;
        default: return xptr;
      }
    case 20:   //QKeyEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QKeyEvent*)xptr;
        case 20: return (void*)(QKeyEvent*)xptr;
        default: return xptr;
      }
    case 21:   //QMenu
      switch(to) {
        case 21: return (void*)(QMenu*)xptr;
        default: return xptr;
      }
    case 22:   //QMetaObject
      switch(to) {
        case 22: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 23:   //QMouseEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QMouseEvent*)xptr;
        case 23: return (void*)(QMouseEvent*)xptr;
        default: return xptr;
      }
    case 24:   //QMoveEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QMoveEvent*)xptr;
        case 24: return (void*)(QMoveEvent*)xptr;
        default: return xptr;
      }
    case 25:   //QNetworkAccessManager
      switch(to) {
        case 28: return (void*)(QObject*)(QNetworkAccessManager*)xptr;
        case 25: return (void*)(QNetworkAccessManager*)xptr;
        default: return xptr;
      }
    case 26:   //QNetworkReply
      switch(to) {
        case 26: return (void*)(QNetworkReply*)xptr;
        default: return xptr;
      }
    case 27:   //QNetworkRequest
      switch(to) {
        case 27: return (void*)(QNetworkRequest*)xptr;
        default: return xptr;
      }
    case 28:   //QObject
      switch(to) {
        case 28: return (void*)(QObject*)xptr;
        case 55: return (void*)(QWebHistoryInterface*)(QObject*)xptr;
        case 59: return (void*)(QWebPage*)(QObject*)xptr;
        case 68: return (void*)(QWebPluginFactory*)(QObject*)xptr;
        case 76: return (void*)(QWebView*)(QObject*)xptr;
        case 58: return (void*)(QWebInspector*)(QObject*)xptr;
        case 53: return (void*)(QWebFrame*)(QObject*)xptr;
        default: return xptr;
      }
    case 29:   //QPaintEngine
      switch(to) {
        case 29: return (void*)(QPaintEngine*)xptr;
        default: return xptr;
      }
    case 30:   //QPaintEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QPaintEvent*)xptr;
        case 30: return (void*)(QPaintEvent*)xptr;
        default: return xptr;
      }
    case 31:   //QPainter
      switch(to) {
        case 31: return (void*)(QPainter*)xptr;
        default: return xptr;
      }
    case 32:   //QPalette
      switch(to) {
        case 32: return (void*)(QPalette*)xptr;
        default: return xptr;
      }
    case 33:   //QPixmap
      switch(to) {
        case 33: return (void*)(QPixmap*)xptr;
        default: return xptr;
      }
    case 34:   //QPoint
      switch(to) {
        case 34: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 35:   //QPrinter
      switch(to) {
        case 35: return (void*)(QPrinter*)xptr;
        default: return xptr;
      }
    case 36:   //QRect
      switch(to) {
        case 36: return (void*)(QRect*)xptr;
        default: return xptr;
      }
    case 37:   //QRegExp
      switch(to) {
        case 37: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 38:   //QRegion
      switch(to) {
        case 38: return (void*)(QRegion*)xptr;
        default: return xptr;
      }
    case 39:   //QResizeEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QResizeEvent*)xptr;
        case 39: return (void*)(QResizeEvent*)xptr;
        default: return xptr;
      }
    case 40:   //QShowEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QShowEvent*)xptr;
        case 40: return (void*)(QShowEvent*)xptr;
        default: return xptr;
      }
    case 41:   //QSize
      switch(to) {
        case 41: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 42:   //QStyle
      switch(to) {
        case 42: return (void*)(QStyle*)xptr;
        default: return xptr;
      }
    case 43:   //QTabletEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QTabletEvent*)xptr;
        case 43: return (void*)(QTabletEvent*)xptr;
        default: return xptr;
      }
    case 44:   //QTimerEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 44: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 45:   //QUndoStack
      switch(to) {
        case 45: return (void*)(QUndoStack*)xptr;
        default: return xptr;
      }
    case 46:   //QUrl
      switch(to) {
        case 46: return (void*)(QUrl*)xptr;
        default: return xptr;
      }
    case 47:   //QVariant
      switch(to) {
        case 47: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 48:   //QWebDatabase
      switch(to) {
        case 48: return (void*)(QWebDatabase*)xptr;
        default: return xptr;
      }
    case 49:   //QWebElement
      switch(to) {
        case 49: return (void*)(QWebElement*)xptr;
        default: return xptr;
      }
    case 50:   //QWebElementCollection
      switch(to) {
        case 50: return (void*)(QWebElementCollection*)xptr;
        default: return xptr;
      }
    case 51:   //QWebElementCollection::const_iterator
      switch(to) {
        case 51: return (void*)(QWebElementCollection::const_iterator*)xptr;
        default: return xptr;
      }
    case 52:   //QWebElementCollection::iterator
      switch(to) {
        case 52: return (void*)(QWebElementCollection::iterator*)xptr;
        default: return xptr;
      }
    case 53:   //QWebFrame
      switch(to) {
        case 28: return (void*)(QObject*)(QWebFrame*)xptr;
        case 53: return (void*)(QWebFrame*)xptr;
        default: return xptr;
      }
    case 54:   //QWebHistory
      switch(to) {
        case 54: return (void*)(QWebHistory*)xptr;
        default: return xptr;
      }
    case 55:   //QWebHistoryInterface
      switch(to) {
        case 28: return (void*)(QObject*)(QWebHistoryInterface*)xptr;
        case 55: return (void*)(QWebHistoryInterface*)xptr;
        default: return xptr;
      }
    case 56:   //QWebHistoryItem
      switch(to) {
        case 56: return (void*)(QWebHistoryItem*)xptr;
        default: return xptr;
      }
    case 57:   //QWebHitTestResult
      switch(to) {
        case 57: return (void*)(QWebHitTestResult*)xptr;
        default: return xptr;
      }
    case 58:   //QWebInspector
      switch(to) {
        case 78: return (void*)(QWidget*)(QWebInspector*)xptr;
        case 28: return (void*)(QObject*)(QWebInspector*)xptr;
        case 58: return (void*)(QWebInspector*)xptr;
        default: return xptr;
      }
    case 59:   //QWebPage
      switch(to) {
        case 28: return (void*)(QObject*)(QWebPage*)xptr;
        case 59: return (void*)(QWebPage*)xptr;
        default: return xptr;
      }
    case 60:   //QWebPage::ChooseMultipleFilesExtensionOption
      switch(to) {
        case 64: return (void*)(QWebPage::ExtensionOption*)(QWebPage::ChooseMultipleFilesExtensionOption*)xptr;
        case 60: return (void*)(QWebPage::ChooseMultipleFilesExtensionOption*)xptr;
        default: return xptr;
      }
    case 61:   //QWebPage::ChooseMultipleFilesExtensionReturn
      switch(to) {
        case 65: return (void*)(QWebPage::ExtensionReturn*)(QWebPage::ChooseMultipleFilesExtensionReturn*)xptr;
        case 61: return (void*)(QWebPage::ChooseMultipleFilesExtensionReturn*)xptr;
        default: return xptr;
      }
    case 62:   //QWebPage::ErrorPageExtensionOption
      switch(to) {
        case 64: return (void*)(QWebPage::ExtensionOption*)(QWebPage::ErrorPageExtensionOption*)xptr;
        case 62: return (void*)(QWebPage::ErrorPageExtensionOption*)xptr;
        default: return xptr;
      }
    case 63:   //QWebPage::ErrorPageExtensionReturn
      switch(to) {
        case 65: return (void*)(QWebPage::ExtensionReturn*)(QWebPage::ErrorPageExtensionReturn*)xptr;
        case 63: return (void*)(QWebPage::ErrorPageExtensionReturn*)xptr;
        default: return xptr;
      }
    case 64:   //QWebPage::ExtensionOption
      switch(to) {
        case 64: return (void*)(QWebPage::ExtensionOption*)xptr;
        case 62: return (void*)(QWebPage::ErrorPageExtensionOption*)(QWebPage::ExtensionOption*)xptr;
        case 60: return (void*)(QWebPage::ChooseMultipleFilesExtensionOption*)(QWebPage::ExtensionOption*)xptr;
        default: return xptr;
      }
    case 65:   //QWebPage::ExtensionReturn
      switch(to) {
        case 65: return (void*)(QWebPage::ExtensionReturn*)xptr;
        case 61: return (void*)(QWebPage::ChooseMultipleFilesExtensionReturn*)(QWebPage::ExtensionReturn*)xptr;
        case 63: return (void*)(QWebPage::ErrorPageExtensionReturn*)(QWebPage::ExtensionReturn*)xptr;
        default: return xptr;
      }
    case 66:   //QWebPage::ViewportAttributes
      switch(to) {
        case 66: return (void*)(QWebPage::ViewportAttributes*)xptr;
        default: return xptr;
      }
    case 67:   //QWebPagePrivate
      switch(to) {
        case 67: return (void*)(QWebPagePrivate*)xptr;
        default: return xptr;
      }
    case 68:   //QWebPluginFactory
      switch(to) {
        case 28: return (void*)(QObject*)(QWebPluginFactory*)xptr;
        case 68: return (void*)(QWebPluginFactory*)xptr;
        default: return xptr;
      }
    case 69:   //QWebPluginFactory::ExtensionOption
      switch(to) {
        case 69: return (void*)(QWebPluginFactory::ExtensionOption*)xptr;
        default: return xptr;
      }
    case 70:   //QWebPluginFactory::ExtensionReturn
      switch(to) {
        case 70: return (void*)(QWebPluginFactory::ExtensionReturn*)xptr;
        default: return xptr;
      }
    case 71:   //QWebPluginFactory::MimeType
      switch(to) {
        case 71: return (void*)(QWebPluginFactory::MimeType*)xptr;
        default: return xptr;
      }
    case 72:   //QWebPluginFactory::Plugin
      switch(to) {
        case 72: return (void*)(QWebPluginFactory::Plugin*)xptr;
        default: return xptr;
      }
    case 73:   //QWebSecurityOrigin
      switch(to) {
        case 73: return (void*)(QWebSecurityOrigin*)xptr;
        default: return xptr;
      }
    case 74:   //QWebSettings
      switch(to) {
        case 74: return (void*)(QWebSettings*)xptr;
        default: return xptr;
      }
    case 75:   //QWebSettingsPrivate
      switch(to) {
        case 75: return (void*)(QWebSettingsPrivate*)xptr;
        default: return xptr;
      }
    case 76:   //QWebView
      switch(to) {
        case 78: return (void*)(QWidget*)(QWebView*)xptr;
        case 28: return (void*)(QObject*)(QWebView*)xptr;
        case 76: return (void*)(QWebView*)xptr;
        default: return xptr;
      }
    case 77:   //QWheelEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QWheelEvent*)xptr;
        case 77: return (void*)(QWheelEvent*)xptr;
        default: return xptr;
      }
    case 78:   //QWidget
      switch(to) {
        case 28: return (void*)(QObject*)(QWidget*)xptr;
        case 78: return (void*)(QWidget*)xptr;
        case 76: return (void*)(QWebView*)(QWidget*)xptr;
        case 58: return (void*)(QWebInspector*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    28, 0,	// 1: QObject
    78, 0,	// 3: QWidget
    64, 0,	// 5: QWebPage::ExtensionOption
    65, 0,	// 7: QWebPage::ExtensionReturn
};

// These are the xenum functions for manipulating enum pointers
void xenum_QWebSettings(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QWebPage(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QWebPluginFactory(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QWebElement(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QWebFrame(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebDatabase(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebElement(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebElementCollection(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebElementCollection__const_iterator(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebElementCollection__iterator(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebFrame(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebHistory(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebHistoryInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebHistoryItem(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebHitTestResult(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebInspector(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ChooseMultipleFilesExtensionOption(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ChooseMultipleFilesExtensionReturn(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ErrorPageExtensionOption(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ErrorPageExtensionReturn(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ExtensionOption(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ExtensionReturn(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ViewportAttributes(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPluginFactory(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPluginFactory__ExtensionOption(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPluginFactory__ExtensionReturn(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPluginFactory__MimeType(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPluginFactory__Plugin(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebSecurityOrigin(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebSettings(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebView(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QAction", true, 0, 0, 0, 0, 0 },	//1
    { "QActionEvent", true, 0, 0, 0, 0, 0 },	//2
    { "QBool", true, 0, 0, 0, 0, 0 },	//3
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//4
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//5
    { "QCloseEvent", true, 0, 0, 0, 0, 0 },	//6
    { "QContextMenuEvent", true, 0, 0, 0, 0, 0 },	//7
    { "QDateTime", true, 0, 0, 0, 0, 0 },	//8
    { "QDragEnterEvent", true, 0, 0, 0, 0, 0 },	//9
    { "QDragLeaveEvent", true, 0, 0, 0, 0, 0 },	//10
    { "QDragMoveEvent", true, 0, 0, 0, 0, 0 },	//11
    { "QDropEvent", true, 0, 0, 0, 0, 0 },	//12
    { "QEvent", true, 0, 0, 0, 0, 0 },	//13
    { "QFocusEvent", true, 0, 0, 0, 0, 0 },	//14
    { "QFont", true, 0, 0, 0, 0, 0 },	//15
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//16
    { "QHideEvent", true, 0, 0, 0, 0, 0 },	//17
    { "QIcon", true, 0, 0, 0, 0, 0 },	//18
    { "QInputMethodEvent", true, 0, 0, 0, 0, 0 },	//19
    { "QKeyEvent", true, 0, 0, 0, 0, 0 },	//20
    { "QMenu", true, 0, 0, 0, 0, 0 },	//21
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//22
    { "QMouseEvent", true, 0, 0, 0, 0, 0 },	//23
    { "QMoveEvent", true, 0, 0, 0, 0, 0 },	//24
    { "QNetworkAccessManager", true, 0, 0, 0, 0, 0 },	//25
    { "QNetworkReply", true, 0, 0, 0, 0, 0 },	//26
    { "QNetworkRequest", true, 0, 0, 0, 0, 0 },	//27
    { "QObject", true, 0, 0, 0, 0, 0 },	//28
    { "QPaintEngine", true, 0, 0, 0, 0, 0 },	//29
    { "QPaintEvent", true, 0, 0, 0, 0, 0 },	//30
    { "QPainter", true, 0, 0, 0, 0, 0 },	//31
    { "QPalette", true, 0, 0, 0, 0, 0 },	//32
    { "QPixmap", true, 0, 0, 0, 0, 0 },	//33
    { "QPoint", true, 0, 0, 0, 0, 0 },	//34
    { "QPrinter", true, 0, 0, 0, 0, 0 },	//35
    { "QRect", true, 0, 0, 0, 0, 0 },	//36
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//37
    { "QRegion", true, 0, 0, 0, 0, 0 },	//38
    { "QResizeEvent", true, 0, 0, 0, 0, 0 },	//39
    { "QShowEvent", true, 0, 0, 0, 0, 0 },	//40
    { "QSize", true, 0, 0, 0, 0, 0 },	//41
    { "QStyle", true, 0, 0, 0, 0, 0 },	//42
    { "QTabletEvent", true, 0, 0, 0, 0, 0 },	//43
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//44
    { "QUndoStack", true, 0, 0, 0, 0, 0 },	//45
    { "QUrl", true, 0, 0, 0, 0, 0 },	//46
    { "QVariant", true, 0, 0, 0, 0, 0 },	//47
    { "QWebDatabase", false, 0, xcall_QWebDatabase, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebDatabase) },	//48
    { "QWebElement", false, 0, xcall_QWebElement, xenum_QWebElement, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebElement) },	//49
    { "QWebElementCollection", false, 0, xcall_QWebElementCollection, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebElementCollection) },	//50
    { "QWebElementCollection::const_iterator", false, 0, xcall_QWebElementCollection__const_iterator, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebElementCollection::const_iterator) },	//51
    { "QWebElementCollection::iterator", false, 0, xcall_QWebElementCollection__iterator, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebElementCollection::iterator) },	//52
    { "QWebFrame", false, 1, xcall_QWebFrame, xenum_QWebFrame, Smoke::cf_virtual, sizeof(QWebFrame) },	//53
    { "QWebHistory", false, 0, xcall_QWebHistory, 0, 0, sizeof(QWebHistory) },	//54
    { "QWebHistoryInterface", false, 1, xcall_QWebHistoryInterface, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QWebHistoryInterface) },	//55
    { "QWebHistoryItem", false, 0, xcall_QWebHistoryItem, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebHistoryItem) },	//56
    { "QWebHitTestResult", false, 0, xcall_QWebHitTestResult, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebHitTestResult) },	//57
    { "QWebInspector", false, 3, xcall_QWebInspector, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QWebInspector) },	//58
    { "QWebPage", false, 1, xcall_QWebPage, xenum_QWebPage, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QWebPage) },	//59
    { "QWebPage::ChooseMultipleFilesExtensionOption", false, 5, xcall_QWebPage__ChooseMultipleFilesExtensionOption, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ChooseMultipleFilesExtensionOption) },	//60
    { "QWebPage::ChooseMultipleFilesExtensionReturn", false, 7, xcall_QWebPage__ChooseMultipleFilesExtensionReturn, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ChooseMultipleFilesExtensionReturn) },	//61
    { "QWebPage::ErrorPageExtensionOption", false, 5, xcall_QWebPage__ErrorPageExtensionOption, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ErrorPageExtensionOption) },	//62
    { "QWebPage::ErrorPageExtensionReturn", false, 7, xcall_QWebPage__ErrorPageExtensionReturn, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ErrorPageExtensionReturn) },	//63
    { "QWebPage::ExtensionOption", false, 0, xcall_QWebPage__ExtensionOption, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ExtensionOption) },	//64
    { "QWebPage::ExtensionReturn", false, 0, xcall_QWebPage__ExtensionReturn, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ExtensionReturn) },	//65
    { "QWebPage::ViewportAttributes", false, 0, xcall_QWebPage__ViewportAttributes, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ViewportAttributes) },	//66
    { "QWebPagePrivate", true, 0, 0, 0, 0, 0 },	//67
    { "QWebPluginFactory", false, 1, xcall_QWebPluginFactory, xenum_QWebPluginFactory, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QWebPluginFactory) },	//68
    { "QWebPluginFactory::ExtensionOption", false, 0, xcall_QWebPluginFactory__ExtensionOption, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPluginFactory::ExtensionOption) },	//69
    { "QWebPluginFactory::ExtensionReturn", false, 0, xcall_QWebPluginFactory__ExtensionReturn, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPluginFactory::ExtensionReturn) },	//70
    { "QWebPluginFactory::MimeType", false, 0, xcall_QWebPluginFactory__MimeType, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPluginFactory::MimeType) },	//71
    { "QWebPluginFactory::Plugin", false, 0, xcall_QWebPluginFactory__Plugin, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPluginFactory::Plugin) },	//72
    { "QWebSecurityOrigin", false, 0, xcall_QWebSecurityOrigin, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebSecurityOrigin) },	//73
    { "QWebSettings", false, 0, xcall_QWebSettings, xenum_QWebSettings, 0, sizeof(QWebSettings) },	//74
    { "QWebSettingsPrivate", true, 0, 0, 0, 0, 0 },	//75
    { "QWebView", false, 3, xcall_QWebView, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QWebView) },	//76
    { "QWheelEvent", true, 0, 0, 0, 0, 0 },	//77
    { "QWidget", true, 0, 0, 0, 0, 0 },	//78
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QAction*", 1, Smoke::t_class|Smoke::tf_ptr },	//1
    { "QActionEvent*", 2, Smoke::t_class|Smoke::tf_ptr },	//2
    { "QBool", 3, Smoke::t_class|Smoke::tf_stack },	//3
    { "QByteArray&", 4, Smoke::t_class|Smoke::tf_ref },	//4
    { "QChildEvent*", 5, Smoke::t_class|Smoke::tf_ptr },	//5
    { "QCloseEvent*", 6, Smoke::t_class|Smoke::tf_ptr },	//6
    { "QContextMenuEvent*", 7, Smoke::t_class|Smoke::tf_ptr },	//7
    { "QDateTime", 8, Smoke::t_class|Smoke::tf_stack },	//8
    { "QDragEnterEvent*", 9, Smoke::t_class|Smoke::tf_ptr },	//9
    { "QDragLeaveEvent*", 10, Smoke::t_class|Smoke::tf_ptr },	//10
    { "QDragMoveEvent*", 11, Smoke::t_class|Smoke::tf_ptr },	//11
    { "QDrawBorderPixmap::DrawingHint", 0, Smoke::t_enum|Smoke::tf_stack },	//12
    { "QDropEvent*", 12, Smoke::t_class|Smoke::tf_ptr },	//13
    { "QEvent*", 13, Smoke::t_class|Smoke::tf_ptr },	//14
    { "QFlags<QPainter::RenderHint>", 0, Smoke::t_uint|Smoke::tf_stack },	//15
    { "QFlags<QWebPage::FindFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//16
    { "QFocusEvent*", 14, Smoke::t_class|Smoke::tf_ptr },	//17
    { "QHideEvent*", 17, Smoke::t_class|Smoke::tf_ptr },	//18
    { "QIcon", 18, Smoke::t_class|Smoke::tf_stack },	//19
    { "QInputMethodEvent*", 19, Smoke::t_class|Smoke::tf_ptr },	//20
    { "QKeyEvent*", 20, Smoke::t_class|Smoke::tf_ptr },	//21
    { "QList<QWebDatabase>", 0, Smoke::t_voidp|Smoke::tf_stack },	//22
    { "QList<QWebElement>", 0, Smoke::t_voidp|Smoke::tf_stack },	//23
    { "QList<QWebFrame*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//24
    { "QList<QWebHistoryItem>", 0, Smoke::t_voidp|Smoke::tf_stack },	//25
    { "QList<QWebPluginFactory::MimeType>&", 0, Smoke::t_voidp|Smoke::tf_ref },	//26
    { "QList<QWebPluginFactory::Plugin>", 0, Smoke::t_voidp|Smoke::tf_stack },	//27
    { "QList<QWebSecurityOrigin>", 0, Smoke::t_voidp|Smoke::tf_stack },	//28
    { "QMenu*", 21, Smoke::t_class|Smoke::tf_ptr },	//29
    { "QMetaObject::Call", 22, Smoke::t_enum|Smoke::tf_stack },	//30
    { "QMouseEvent*", 23, Smoke::t_class|Smoke::tf_ptr },	//31
    { "QMoveEvent*", 24, Smoke::t_class|Smoke::tf_ptr },	//32
    { "QMultiMap<QString,QString>", 0, Smoke::t_voidp|Smoke::tf_stack },	//33
    { "QNetworkAccessManager*", 25, Smoke::t_class|Smoke::tf_ptr },	//34
    { "QNetworkAccessManager::Operation", 25, Smoke::t_enum|Smoke::tf_stack },	//35
    { "QNetworkReply*", 26, Smoke::t_class|Smoke::tf_ptr },	//36
    { "QNetworkRequest", 27, Smoke::t_class|Smoke::tf_stack },	//37
    { "QObject*", 28, Smoke::t_class|Smoke::tf_ptr },	//38
    { "QPaintDevice::PaintDeviceMetric", 0, Smoke::t_enum|Smoke::tf_stack },	//39
    { "QPaintEngine*", 29, Smoke::t_class|Smoke::tf_ptr },	//40
    { "QPaintEvent*", 30, Smoke::t_class|Smoke::tf_ptr },	//41
    { "QPainter*", 31, Smoke::t_class|Smoke::tf_ptr },	//42
    { "QPainter::RenderHint", 31, Smoke::t_enum|Smoke::tf_stack },	//43
    { "QPalette", 32, Smoke::t_class|Smoke::tf_stack },	//44
    { "QPixmap", 33, Smoke::t_class|Smoke::tf_stack },	//45
    { "QPoint", 34, Smoke::t_class|Smoke::tf_stack },	//46
    { "QPrinter*", 35, Smoke::t_class|Smoke::tf_ptr },	//47
    { "QRect", 36, Smoke::t_class|Smoke::tf_stack },	//48
    { "QRegExp&", 37, Smoke::t_class|Smoke::tf_ref },	//49
    { "QResizeEvent*", 39, Smoke::t_class|Smoke::tf_ptr },	//50
    { "QScriptEngine::ValueOwnership", 0, Smoke::t_enum|Smoke::tf_stack },	//51
    { "QShowEvent*", 40, Smoke::t_class|Smoke::tf_ptr },	//52
    { "QSize", 41, Smoke::t_class|Smoke::tf_stack },	//53
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//54
    { "QString&", 0, Smoke::t_voidp|Smoke::tf_ref },	//55
    { "QString*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//56
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//57
    { "QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref },	//58
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//59
    { "QStyle&", 42, Smoke::t_class|Smoke::tf_ref },	//60
    { "QTabletEvent*", 43, Smoke::t_class|Smoke::tf_ptr },	//61
    { "QTimerEvent*", 44, Smoke::t_class|Smoke::tf_ptr },	//62
    { "QUndoStack*", 45, Smoke::t_class|Smoke::tf_ptr },	//63
    { "QUrl", 46, Smoke::t_class|Smoke::tf_stack },	//64
    { "QUrl&", 46, Smoke::t_class|Smoke::tf_ref },	//65
    { "QVariant", 47, Smoke::t_class|Smoke::tf_stack },	//66
    { "QWebDatabase", 48, Smoke::t_class|Smoke::tf_stack },	//67
    { "QWebDatabase&", 48, Smoke::t_class|Smoke::tf_ref },	//68
    { "QWebDatabase*", 48, Smoke::t_class|Smoke::tf_ptr },	//69
    { "QWebElement", 49, Smoke::t_class|Smoke::tf_stack },	//70
    { "QWebElement&", 49, Smoke::t_class|Smoke::tf_ref },	//71
    { "QWebElement*", 49, Smoke::t_class|Smoke::tf_ptr },	//72
    { "QWebElement::StyleResolveStrategy", 49, Smoke::t_enum|Smoke::tf_stack },	//73
    { "QWebElementCollection", 50, Smoke::t_class|Smoke::tf_stack },	//74
    { "QWebElementCollection&", 50, Smoke::t_class|Smoke::tf_ref },	//75
    { "QWebElementCollection*", 50, Smoke::t_class|Smoke::tf_ptr },	//76
    { "QWebElementCollection::const_iterator", 51, Smoke::t_class|Smoke::tf_stack },	//77
    { "QWebElementCollection::const_iterator&", 51, Smoke::t_class|Smoke::tf_ref },	//78
    { "QWebElementCollection::const_iterator*", 51, Smoke::t_class|Smoke::tf_ptr },	//79
    { "QWebElementCollection::iterator", 52, Smoke::t_class|Smoke::tf_stack },	//80
    { "QWebElementCollection::iterator&", 52, Smoke::t_class|Smoke::tf_ref },	//81
    { "QWebElementCollection::iterator*", 52, Smoke::t_class|Smoke::tf_ptr },	//82
    { "QWebFrame*", 53, Smoke::t_class|Smoke::tf_ptr },	//83
    { "QWebFrame::RenderLayer", 53, Smoke::t_enum|Smoke::tf_stack },	//84
    { "QWebHistory*", 54, Smoke::t_class|Smoke::tf_ptr },	//85
    { "QWebHistoryInterface*", 55, Smoke::t_class|Smoke::tf_ptr },	//86
    { "QWebHistoryItem", 56, Smoke::t_class|Smoke::tf_stack },	//87
    { "QWebHistoryItem&", 56, Smoke::t_class|Smoke::tf_ref },	//88
    { "QWebHistoryItem*", 56, Smoke::t_class|Smoke::tf_ptr },	//89
    { "QWebHitTestResult", 57, Smoke::t_class|Smoke::tf_stack },	//90
    { "QWebHitTestResult&", 57, Smoke::t_class|Smoke::tf_ref },	//91
    { "QWebHitTestResult*", 57, Smoke::t_class|Smoke::tf_ptr },	//92
    { "QWebInspector*", 58, Smoke::t_class|Smoke::tf_ptr },	//93
    { "QWebPage*", 59, Smoke::t_class|Smoke::tf_ptr },	//94
    { "QWebPage::ChooseMultipleFilesExtensionOption*", 60, Smoke::t_class|Smoke::tf_ptr },	//95
    { "QWebPage::ChooseMultipleFilesExtensionReturn*", 61, Smoke::t_class|Smoke::tf_ptr },	//96
    { "QWebPage::ErrorDomain", 59, Smoke::t_enum|Smoke::tf_stack },	//97
    { "QWebPage::ErrorPageExtensionOption*", 62, Smoke::t_class|Smoke::tf_ptr },	//98
    { "QWebPage::ErrorPageExtensionReturn*", 63, Smoke::t_class|Smoke::tf_ptr },	//99
    { "QWebPage::Extension", 59, Smoke::t_enum|Smoke::tf_stack },	//100
    { "QWebPage::ExtensionOption*", 64, Smoke::t_class|Smoke::tf_ptr },	//101
    { "QWebPage::ExtensionReturn*", 65, Smoke::t_class|Smoke::tf_ptr },	//102
    { "QWebPage::Feature", 59, Smoke::t_enum|Smoke::tf_stack },	//103
    { "QWebPage::FindFlag", 59, Smoke::t_enum|Smoke::tf_stack },	//104
    { "QWebPage::LinkDelegationPolicy", 59, Smoke::t_enum|Smoke::tf_stack },	//105
    { "QWebPage::NavigationType", 59, Smoke::t_enum|Smoke::tf_stack },	//106
    { "QWebPage::PermissionPolicy", 59, Smoke::t_enum|Smoke::tf_stack },	//107
    { "QWebPage::ViewportAttributes", 66, Smoke::t_class|Smoke::tf_stack },	//108
    { "QWebPage::ViewportAttributes&", 66, Smoke::t_class|Smoke::tf_ref },	//109
    { "QWebPage::ViewportAttributes*", 66, Smoke::t_class|Smoke::tf_ptr },	//110
    { "QWebPage::WebAction", 59, Smoke::t_enum|Smoke::tf_stack },	//111
    { "QWebPage::WebWindowType", 59, Smoke::t_enum|Smoke::tf_stack },	//112
    { "QWebPagePrivate*", 67, Smoke::t_class|Smoke::tf_ptr },	//113
    { "QWebPluginFactory*", 68, Smoke::t_class|Smoke::tf_ptr },	//114
    { "QWebPluginFactory::Extension", 68, Smoke::t_enum|Smoke::tf_stack },	//115
    { "QWebPluginFactory::ExtensionOption*", 69, Smoke::t_class|Smoke::tf_ptr },	//116
    { "QWebPluginFactory::ExtensionReturn*", 70, Smoke::t_class|Smoke::tf_ptr },	//117
    { "QWebPluginFactory::MimeType", 71, Smoke::t_class|Smoke::tf_stack },	//118
    { "QWebPluginFactory::MimeType*", 71, Smoke::t_class|Smoke::tf_ptr },	//119
    { "QWebPluginFactory::Plugin", 72, Smoke::t_class|Smoke::tf_stack },	//120
    { "QWebPluginFactory::Plugin*", 72, Smoke::t_class|Smoke::tf_ptr },	//121
    { "QWebSecurityOrigin", 73, Smoke::t_class|Smoke::tf_stack },	//122
    { "QWebSecurityOrigin&", 73, Smoke::t_class|Smoke::tf_ref },	//123
    { "QWebSecurityOrigin*", 73, Smoke::t_class|Smoke::tf_ptr },	//124
    { "QWebSettings*", 74, Smoke::t_class|Smoke::tf_ptr },	//125
    { "QWebSettings::FontFamily", 74, Smoke::t_enum|Smoke::tf_stack },	//126
    { "QWebSettings::FontSize", 74, Smoke::t_enum|Smoke::tf_stack },	//127
    { "QWebSettings::ThirdPartyCookiePolicy", 74, Smoke::t_enum|Smoke::tf_stack },	//128
    { "QWebSettings::WebAttribute", 74, Smoke::t_enum|Smoke::tf_stack },	//129
    { "QWebSettings::WebGraphic", 74, Smoke::t_enum|Smoke::tf_stack },	//130
    { "QWebSettingsPrivate*", 75, Smoke::t_class|Smoke::tf_ptr },	//131
    { "QWebView*", 76, Smoke::t_class|Smoke::tf_ptr },	//132
    { "QWheelEvent*", 77, Smoke::t_class|Smoke::tf_ptr },	//133
    { "QWidget*", 78, Smoke::t_class|Smoke::tf_ptr },	//134
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//135
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//136
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//137
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//138
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//139
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//140
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//141
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//142
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//143
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//144
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//145
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//146
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//147
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//148
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//149
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//150
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//151
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//152
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//153
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//154
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//155
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//156
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//157
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//158
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//159
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//160
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//161
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//162
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//163
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//164
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//165
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//166
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//167
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//168
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//169
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//170
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//171
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//172
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//173
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//174
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//175
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//176
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//177
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//178
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//179
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//180
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//181
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//182
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//183
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//184
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//185
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//186
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//187
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//188
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//189
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//190
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//191
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//192
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//193
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//194
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//195
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//196
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//197
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//198
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//199
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//200
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//201
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//202
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//203
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//204
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//205
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//206
    { "_XEvent*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//207
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//208
    { "const QByteArray&", 4, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//209
    { "const QFont&", 15, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//210
    { "const QList<QWebPluginFactory::MimeType>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//211
    { "const QMetaObject&", 22, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//212
    { "const QMetaObject*", 22, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//213
    { "const QNetworkRequest&", 27, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//214
    { "const QPalette&", 32, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//215
    { "const QPixmap&", 33, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//216
    { "const QPoint&", 34, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//217
    { "const QRect&", 36, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//218
    { "const QRegExp&", 37, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//219
    { "const QRegion&", 38, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//220
    { "const QSize&", 41, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//221
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//222
    { "const QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//223
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//224
    { "const QUrl&", 46, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//225
    { "const QVariant&", 47, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//226
    { "const QWebDatabase&", 48, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//227
    { "const QWebElement", 49, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//228
    { "const QWebElement&", 49, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//229
    { "const QWebElementCollection&", 50, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//230
    { "const QWebElementCollection*", 50, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//231
    { "const QWebElementCollection::const_iterator&", 51, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//232
    { "const QWebElementCollection::iterator&", 52, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//233
    { "const QWebHistoryItem&", 56, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//234
    { "const QWebHitTestResult&", 57, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//235
    { "const QWebPage::ChooseMultipleFilesExtensionOption&", 60, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//236
    { "const QWebPage::ChooseMultipleFilesExtensionReturn&", 61, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//237
    { "const QWebPage::ErrorPageExtensionOption&", 62, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//238
    { "const QWebPage::ErrorPageExtensionReturn&", 63, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//239
    { "const QWebPage::ExtensionOption&", 64, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//240
    { "const QWebPage::ExtensionOption*", 64, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//241
    { "const QWebPage::ExtensionReturn&", 65, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//242
    { "const QWebPage::ViewportAttributes&", 66, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//243
    { "const QWebPluginFactory::ExtensionOption&", 69, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//244
    { "const QWebPluginFactory::ExtensionOption*", 69, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//245
    { "const QWebPluginFactory::ExtensionReturn&", 70, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//246
    { "const QWebPluginFactory::MimeType&", 71, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//247
    { "const QWebPluginFactory::Plugin&", 72, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//248
    { "const QWebSecurityOrigin&", 73, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//249
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//250
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//251
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//252
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//253
    { "long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//254
    { "quint64", 0, Smoke::t_voidp|Smoke::tf_stack },	//255
    { "unsigned long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//256
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//257
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//258
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//259
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    14, 0,	//1  QEvent*
    38, 14, 0,	//3  QObject*, QEvent*
    62, 0,	//6  QTimerEvent*
    5, 0,	//8  QChildEvent*
    250, 0,	//10  const char*
    227, 0,	//12  const QWebDatabase&
    229, 0,	//14  const QWebElement&
    222, 0,	//16  const QString&
    222, 222, 0,	//18  const QString&, const QString&
    222, 222, 222, 0,	//21  const QString&, const QString&, const QString&
    222, 73, 0,	//25  const QString&, QWebElement::StyleResolveStrategy
    42, 0,	//28  QPainter*
    42, 218, 0,	//30  QPainter*, const QRect&
    229, 222, 0,	//33  const QWebElement&, const QString&
    230, 0,	//36  const QWebElementCollection&
    253, 0,	//38  int
    231, 253, 0,	//40  const QWebElementCollection*, int
    232, 0,	//43  const QWebElementCollection::const_iterator&
    77, 0,	//45  QWebElementCollection::const_iterator
    233, 0,	//47  const QWebElementCollection::iterator&
    80, 0,	//49  QWebElementCollection::iterator
    250, 250, 0,	//51  const char*, const char*
    250, 250, 253, 0,	//54  const char*, const char*, int
    30, 253, 258, 0,	//58  QMetaObject::Call, int, void**
    225, 0,	//62  const QUrl&
    214, 35, 209, 0,	//64  const QNetworkRequest&, QNetworkAccessManager::Operation, const QByteArray&
    222, 225, 0,	//68  const QString&, const QUrl&
    209, 222, 225, 0,	//71  const QByteArray&, const QString&, const QUrl&
    222, 38, 0,	//75  const QString&, QObject*
    222, 38, 51, 0,	//78  const QString&, QObject*, QScriptEngine::ValueOwnership
    181, 0,	//82  Qt::Orientation
    181, 185, 0,	//84  Qt::Orientation, Qt::ScrollBarPolicy
    181, 253, 0,	//87  Qt::Orientation, int
    253, 253, 0,	//90  int, int
    217, 0,	//93  const QPoint&
    42, 220, 0,	//95  QPainter*, const QRegion&
    42, 84, 220, 0,	//98  QPainter*, QWebFrame::RenderLayer, const QRegion&
    252, 0,	//102  double
    47, 0,	//104  QPrinter*
    221, 0,	//106  const QSize&
    208, 0,	//108  bool
    214, 0,	//110  const QNetworkRequest&
    214, 35, 0,	//112  const QNetworkRequest&, QNetworkAccessManager::Operation
    209, 0,	//115  const QByteArray&
    209, 222, 0,	//117  const QByteArray&, const QString&
    42, 84, 0,	//120  QPainter*, QWebFrame::RenderLayer
    234, 0,	//123  const QWebHistoryItem&
    38, 0,	//125  QObject*
    86, 0,	//127  QWebHistoryInterface*
    226, 0,	//129  const QVariant&
    235, 0,	//131  const QWebHitTestResult&
    134, 0,	//133  QWidget*
    94, 0,	//135  QWebPage*
    50, 0,	//137  QResizeEvent*
    52, 0,	//139  QShowEvent*
    18, 0,	//141  QHideEvent*
    6, 0,	//143  QCloseEvent*
    34, 0,	//145  QNetworkAccessManager*
    114, 0,	//147  QWebPluginFactory*
    111, 0,	//149  QWebPage::WebAction
    111, 208, 0,	//151  QWebPage::WebAction, bool
    218, 0,	//154  const QRect&
    169, 0,	//156  Qt::InputMethodQuery
    222, 16, 0,	//158  const QString&, QFlags<QWebPage::FindFlag>
    105, 0,	//161  QWebPage::LinkDelegationPolicy
    215, 0,	//163  const QPalette&
    7, 0,	//165  QContextMenuEvent*
    83, 103, 107, 0,	//167  QWebFrame*, QWebPage::Feature, QWebPage::PermissionPolicy
    100, 241, 102, 0,	//171  QWebPage::Extension, const QWebPage::ExtensionOption*, QWebPage::ExtensionReturn*
    100, 0,	//175  QWebPage::Extension
    83, 0,	//177  QWebFrame*
    253, 253, 218, 0,	//179  int, int, const QRect&
    36, 0,	//183  QNetworkReply*
    83, 54, 0,	//185  QWebFrame*, QString
    124, 255, 0,	//188  QWebSecurityOrigin*, quint64
    124, 255, 255, 0,	//191  QWebSecurityOrigin*, quint64, quint64
    83, 89, 0,	//195  QWebFrame*, QWebHistoryItem*
    83, 103, 0,	//198  QWebFrame*, QWebPage::Feature
    112, 0,	//201  QWebPage::WebWindowType
    222, 225, 223, 223, 0,	//203  const QString&, const QUrl&, const QStringList&, const QStringList&
    83, 214, 106, 0,	//208  QWebFrame*, const QNetworkRequest&, QWebPage::NavigationType
    83, 222, 0,	//212  QWebFrame*, const QString&
    83, 222, 222, 56, 0,	//215  QWebFrame*, const QString&, const QString&, QString*
    222, 253, 222, 0,	//220  const QString&, int, const QString&
    100, 241, 0,	//224  QWebPage::Extension, const QWebPage::ExtensionOption*
    236, 0,	//227  const QWebPage::ChooseMultipleFilesExtensionOption&
    223, 0,	//229  const QStringList&
    237, 0,	//231  const QWebPage::ChooseMultipleFilesExtensionReturn&
    238, 0,	//233  const QWebPage::ErrorPageExtensionOption&
    97, 0,	//235  QWebPage::ErrorDomain
    239, 0,	//237  const QWebPage::ErrorPageExtensionReturn&
    240, 0,	//239  const QWebPage::ExtensionOption&
    242, 0,	//241  const QWebPage::ExtensionReturn&
    243, 0,	//243  const QWebPage::ViewportAttributes&
    115, 245, 117, 0,	//245  QWebPluginFactory::Extension, const QWebPluginFactory::ExtensionOption*, QWebPluginFactory::ExtensionReturn*
    115, 0,	//249  QWebPluginFactory::Extension
    115, 245, 0,	//251  QWebPluginFactory::Extension, const QWebPluginFactory::ExtensionOption*
    244, 0,	//254  const QWebPluginFactory::ExtensionOption&
    246, 0,	//256  const QWebPluginFactory::ExtensionReturn&
    247, 0,	//258  const QWebPluginFactory::MimeType&
    248, 0,	//260  const QWebPluginFactory::Plugin&
    211, 0,	//262  const QList<QWebPluginFactory::MimeType>&
    254, 0,	//264  long long
    249, 0,	//266  const QWebSecurityOrigin&
    126, 222, 0,	//268  QWebSettings::FontFamily, const QString&
    126, 0,	//271  QWebSettings::FontFamily
    127, 253, 0,	//273  QWebSettings::FontSize, int
    127, 0,	//276  QWebSettings::FontSize
    129, 208, 0,	//278  QWebSettings::WebAttribute, bool
    129, 0,	//281  QWebSettings::WebAttribute
    130, 216, 0,	//283  QWebSettings::WebGraphic, const QPixmap&
    130, 0,	//286  QWebSettings::WebGraphic
    253, 253, 253, 0,	//288  int, int, int
    128, 0,	//292  QWebSettings::ThirdPartyCookiePolicy
    15, 0,	//294  QFlags<QPainter::RenderHint>
    43, 208, 0,	//296  QPainter::RenderHint, bool
    41, 0,	//299  QPaintEvent*
    31, 0,	//301  QMouseEvent*
    133, 0,	//303  QWheelEvent*
    21, 0,	//305  QKeyEvent*
    9, 0,	//307  QDragEnterEvent*
    10, 0,	//309  QDragLeaveEvent*
    11, 0,	//311  QDragMoveEvent*
    13, 0,	//313  QDropEvent*
    17, 0,	//315  QFocusEvent*
    20, 0,	//317  QInputMethodEvent*
    43, 0,	//319  QPainter::RenderHint
    32, 0,	//321  QMoveEvent*
    61, 0,	//323  QTabletEvent*
    2, 0,	//325  QActionEvent*
    207, 0,	//327  _XEvent*
    39, 0,	//329  QPaintDevice::PaintDeviceMetric
    60, 0,	//331  QStyle&
    210, 0,	//333  const QFont&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "AcceleratedCompositingEnabled",	//1
    "AlignCenter",	//2
    "AlignJustified",	//3
    "AlignLeft",	//4
    "AlignRight",	//5
    "AllLayers",	//6
    "AllowThirdPartyWithExistingCookies",	//7
    "AlwaysAllowThirdPartyCookies",	//8
    "AlwaysBlockThirdPartyCookies",	//9
    "AutoLoadImages",	//10
    "Back",	//11
    "CSSGridLayoutEnabled",	//12
    "CSSRegionsEnabled",	//13
    "CaretBrowsingEnabled",	//14
    "CascadedStyle",	//15
    "ChooseMultipleFilesExtension",	//16
    "ChooseMultipleFilesExtensionOption",	//17
    "ChooseMultipleFilesExtensionOption#",	//18
    "ChooseMultipleFilesExtensionReturn",	//19
    "ChooseMultipleFilesExtensionReturn#",	//20
    "ComputedStyle",	//21
    "ContentsLayer",	//22
    "Copy",	//23
    "CopyImageToClipboard",	//24
    "CopyImageUrlToClipboard",	//25
    "CopyLinkToClipboard",	//26
    "CursiveFont",	//27
    "Cut",	//28
    "DefaultFixedFontSize",	//29
    "DefaultFontSize",	//30
    "DefaultFrameIconGraphic",	//31
    "DelegateAllLinks",	//32
    "DelegateExternalLinks",	//33
    "DeleteButtonGraphic",	//34
    "DeleteEndOfWord",	//35
    "DeleteStartOfWord",	//36
    "DeveloperExtrasEnabled",	//37
    "DnsPrefetchEnabled",	//38
    "DontDelegateLinks",	//39
    "DownloadImageToDisk",	//40
    "DownloadLinkToDisk",	//41
    "DrawChildren",	//42
    "DrawWindowBackground",	//43
    "ErrorPageExtension",	//44
    "ErrorPageExtensionOption",	//45
    "ErrorPageExtensionOption#",	//46
    "ErrorPageExtensionReturn",	//47
    "ErrorPageExtensionReturn#",	//48
    "ExtensionOption",	//49
    "ExtensionOption#",	//50
    "ExtensionReturn",	//51
    "ExtensionReturn#",	//52
    "FantasyFont",	//53
    "FindBackward",	//54
    "FindCaseSensitively",	//55
    "FindWrapsAroundDocument",	//56
    "FixedFont",	//57
    "Forward",	//58
    "FrameFlatteningEnabled",	//59
    "Geolocation",	//60
    "HighlightAllOccurrences",	//61
    "Http",	//62
    "HyperlinkAuditingEnabled",	//63
    "IgnoreMask",	//64
    "Indent",	//65
    "InlineStyle",	//66
    "InputSpeechButtonGraphic",	//67
    "InsertLineSeparator",	//68
    "InsertOrderedList",	//69
    "InsertParagraphSeparator",	//70
    "InsertUnorderedList",	//71
    "InspectElement",	//72
    "JavaEnabled",	//73
    "JavascriptCanAccessClipboard",	//74
    "JavascriptCanCloseWindows",	//75
    "JavascriptCanOpenWindows",	//76
    "JavascriptEnabled",	//77
    "LinksIncludedInFocusChain",	//78
    "LocalContentCanAccessFileUrls",	//79
    "LocalContentCanAccessRemoteUrls",	//80
    "LocalStorageDatabaseEnabled",	//81
    "LocalStorageEnabled",	//82
    "MimeType",	//83
    "MimeType#",	//84
    "MinimumFontSize",	//85
    "MinimumLogicalFontSize",	//86
    "MissingImageGraphic",	//87
    "MissingPluginGraphic",	//88
    "MoveToEndOfBlock",	//89
    "MoveToEndOfDocument",	//90
    "MoveToEndOfLine",	//91
    "MoveToNextChar",	//92
    "MoveToNextLine",	//93
    "MoveToNextWord",	//94
    "MoveToPreviousChar",	//95
    "MoveToPreviousLine",	//96
    "MoveToPreviousWord",	//97
    "MoveToStartOfBlock",	//98
    "MoveToStartOfDocument",	//99
    "MoveToStartOfLine",	//100
    "NavigationTypeBackOrForward",	//101
    "NavigationTypeFormResubmitted",	//102
    "NavigationTypeFormSubmitted",	//103
    "NavigationTypeLinkClicked",	//104
    "NavigationTypeOther",	//105
    "NavigationTypeReload",	//106
    "NoWebAction",	//107
    "Notifications",	//108
    "NotificationsEnabled",	//109
    "OfflineStorageDatabaseEnabled",	//110
    "OfflineWebApplicationCacheEnabled",	//111
    "OpenFrameInNewWindow",	//112
    "OpenImageInNewWindow",	//113
    "OpenLink",	//114
    "OpenLinkInNewWindow",	//115
    "OpenLinkInThisWindow",	//116
    "Outdent",	//117
    "PanIconLayer",	//118
    "Paste",	//119
    "PasteAndMatchStyle",	//120
    "PermissionDeniedByUser",	//121
    "PermissionGrantedByUser",	//122
    "PermissionUnknown",	//123
    "Plugin",	//124
    "Plugin#",	//125
    "PluginsEnabled",	//126
    "PrintElementBackgrounds",	//127
    "PrivateBrowsingEnabled",	//128
    "QWebDatabase",	//129
    "QWebDatabase#",	//130
    "QWebElement",	//131
    "QWebElement#",	//132
    "QWebElementCollection",	//133
    "QWebElementCollection#",	//134
    "QWebElementCollection#$",	//135
    "QWebHistoryInterface",	//136
    "QWebHistoryInterface#",	//137
    "QWebHistoryItem",	//138
    "QWebHistoryItem#",	//139
    "QWebHitTestResult",	//140
    "QWebHitTestResult#",	//141
    "QWebInspector",	//142
    "QWebInspector#",	//143
    "QWebPage",	//144
    "QWebPage#",	//145
    "QWebPluginFactory",	//146
    "QWebPluginFactory#",	//147
    "QWebSecurityOrigin",	//148
    "QWebSecurityOrigin#",	//149
    "QWebView",	//150
    "QWebView#",	//151
    "QtNetwork",	//152
    "Redo",	//153
    "Reload",	//154
    "ReloadAndBypassCache",	//155
    "RemoveFormat",	//156
    "SansSerifFont",	//157
    "ScrollAnimatorEnabled",	//158
    "ScrollBarLayer",	//159
    "SearchCancelButtonGraphic",	//160
    "SearchCancelButtonPressedGraphic",	//161
    "SelectAll",	//162
    "SelectEndOfBlock",	//163
    "SelectEndOfDocument",	//164
    "SelectEndOfLine",	//165
    "SelectNextChar",	//166
    "SelectNextLine",	//167
    "SelectNextWord",	//168
    "SelectPreviousChar",	//169
    "SelectPreviousLine",	//170
    "SelectPreviousWord",	//171
    "SelectStartOfBlock",	//172
    "SelectStartOfDocument",	//173
    "SelectStartOfLine",	//174
    "SerifFont",	//175
    "SetTextDirectionDefault",	//176
    "SetTextDirectionLeftToRight",	//177
    "SetTextDirectionRightToLeft",	//178
    "SiteSpecificQuirksEnabled",	//179
    "SpatialNavigationEnabled",	//180
    "StandardFont",	//181
    "Stop",	//182
    "StopScheduledPageRefresh",	//183
    "TextAreaSizeGripCornerGraphic",	//184
    "TiledBackingStoreEnabled",	//185
    "ToggleBold",	//186
    "ToggleItalic",	//187
    "ToggleStrikethrough",	//188
    "ToggleSubscript",	//189
    "ToggleSuperscript",	//190
    "ToggleUnderline",	//191
    "Undo",	//192
    "ViewportAttributes",	//193
    "ViewportAttributes#",	//194
    "WebActionCount",	//195
    "WebBrowserWindow",	//196
    "WebGLEnabled",	//197
    "WebKit",	//198
    "WebModalDialog",	//199
    "XSSAuditingEnabled",	//200
    "ZoomTextOnly",	//201
    "acceptNavigationRequest",	//202
    "acceptNavigationRequest##$",	//203
    "action",	//204
    "action$",	//205
    "actionEvent",	//206
    "addClass",	//207
    "addClass$",	//208
    "addHistoryEntry",	//209
    "addHistoryEntry$",	//210
    "addLocalScheme",	//211
    "addLocalScheme$",	//212
    "addToJavaScriptWindowObject",	//213
    "addToJavaScriptWindowObject$#",	//214
    "addToJavaScriptWindowObject$#$",	//215
    "allOrigins",	//216
    "alternateText",	//217
    "append",	//218
    "append#",	//219
    "appendInside",	//220
    "appendInside#",	//221
    "appendInside$",	//222
    "appendOutside",	//223
    "appendOutside#",	//224
    "appendOutside$",	//225
    "applicationCacheQuotaExceeded",	//226
    "applicationCacheQuotaExceeded#$",	//227
    "applicationCacheQuotaExceeded#$$",	//228
    "at",	//229
    "at$",	//230
    "attribute",	//231
    "attribute$",	//232
    "attribute$$",	//233
    "attributeNS",	//234
    "attributeNS$$",	//235
    "attributeNS$$$",	//236
    "attributeNames",	//237
    "attributeNames$",	//238
    "back",	//239
    "backItem",	//240
    "backItems",	//241
    "backItems$",	//242
    "baseUrl",	//243
    "begin",	//244
    "boundingRect",	//245
    "bytesReceived",	//246
    "canGoBack",	//247
    "canGoForward",	//248
    "changeEvent",	//249
    "changeEvent#",	//250
    "childEvent",	//251
    "childFrames",	//252
    "chooseFile",	//253
    "chooseFile#$",	//254
    "classes",	//255
    "clear",	//256
    "clearIconDatabase",	//257
    "clearMemoryCaches",	//258
    "clone",	//259
    "closeEvent",	//260
    "closeEvent#",	//261
    "connectNotify",	//262
    "constBegin",	//263
    "constEnd",	//264
    "const_iterator",	//265
    "const_iterator#",	//266
    "const_iterator#$",	//267
    "content",	//268
    "contentType",	//269
    "contentsChanged",	//270
    "contentsSize",	//271
    "contentsSizeChanged",	//272
    "contentsSizeChanged#",	//273
    "contextMenuEvent",	//274
    "contextMenuEvent#",	//275
    "count",	//276
    "create",	//277
    "create$#??",	//278
    "createPlugin",	//279
    "createPlugin$#??",	//280
    "createStandardContextMenu",	//281
    "createWindow",	//282
    "createWindow$",	//283
    "currentFrame",	//284
    "currentItem",	//285
    "currentItemIndex",	//286
    "customEvent",	//287
    "databaseQuota",	//288
    "databaseQuotaExceeded",	//289
    "databaseQuotaExceeded#$",	//290
    "databaseUsage",	//291
    "databases",	//292
    "defaultInterface",	//293
    "defaultTextEncoding",	//294
    "description",	//295
    "devType",	//296
    "devicePixelRatio",	//297
    "disconnectNotify",	//298
    "displayName",	//299
    "document",	//300
    "documentElement",	//301
    "domain",	//302
    "downloadRequested",	//303
    "downloadRequested#",	//304
    "dragEnterEvent",	//305
    "dragEnterEvent#",	//306
    "dragLeaveEvent",	//307
    "dragLeaveEvent#",	//308
    "dragMoveEvent",	//309
    "dragMoveEvent#",	//310
    "dropEvent",	//311
    "dropEvent#",	//312
    "element",	//313
    "enablePersistentStorage",	//314
    "enablePersistentStorage$",	//315
    "enabledChange",	//316
    "encloseContentsWith",	//317
    "encloseContentsWith#",	//318
    "encloseContentsWith$",	//319
    "encloseWith",	//320
    "encloseWith#",	//321
    "encloseWith$",	//322
    "enclosingBlockElement",	//323
    "encoding",	//324
    "end",	//325
    "enterEvent",	//326
    "error",	//327
    "errorString",	//328
    "evaluateJavaScript",	//329
    "evaluateJavaScript$",	//330
    "event",	//331
    "event#",	//332
    "eventFilter",	//333
    "expectedSize",	//334
    "extension",	//335
    "extension$",	//336
    "extension$#",	//337
    "extension$##",	//338
    "featurePermissionRequestCanceled",	//339
    "featurePermissionRequestCanceled#$",	//340
    "featurePermissionRequested",	//341
    "featurePermissionRequested#$",	//342
    "fileExtensions",	//343
    "fileName",	//344
    "fileNames",	//345
    "findAll",	//346
    "findAll$",	//347
    "findAllElements",	//348
    "findAllElements$",	//349
    "findFirst",	//350
    "findFirst$",	//351
    "findFirstElement",	//352
    "findFirstElement$",	//353
    "findText",	//354
    "findText$",	//355
    "findText$$",	//356
    "first",	//357
    "firstChild",	//358
    "focusInEvent",	//359
    "focusInEvent#",	//360
    "focusNextPrevChild",	//361
    "focusNextPrevChild$",	//362
    "focusOutEvent",	//363
    "focusOutEvent#",	//364
    "fontChange",	//365
    "fontFamily",	//366
    "fontFamily$",	//367
    "fontSize",	//368
    "fontSize$",	//369
    "forward",	//370
    "forwardItem",	//371
    "forwardItems",	//372
    "forwardItems$",	//373
    "forwardUnsupportedContent",	//374
    "frame",	//375
    "frameAt",	//376
    "frameAt#",	//377
    "frameCreated",	//378
    "frameCreated#",	//379
    "frameName",	//380
    "geometry",	//381
    "geometryChangeRequested",	//382
    "geometryChangeRequested#",	//383
    "globalSettings",	//384
    "goToItem",	//385
    "goToItem#",	//386
    "handle",	//387
    "hasAttribute",	//388
    "hasAttribute$",	//389
    "hasAttributeNS",	//390
    "hasAttributeNS$$",	//391
    "hasAttributes",	//392
    "hasClass",	//393
    "hasClass$",	//394
    "hasFocus",	//395
    "hasSelection",	//396
    "heightForWidth",	//397
    "hideEvent",	//398
    "hideEvent#",	//399
    "history",	//400
    "historyContains",	//401
    "historyContains$",	//402
    "hitTestContent",	//403
    "hitTestContent#",	//404
    "host",	//405
    "icon",	//406
    "iconChanged",	//407
    "iconDatabasePath",	//408
    "iconForUrl",	//409
    "iconForUrl#",	//410
    "imageUrl",	//411
    "initialLayoutCompleted",	//412
    "initialScaleFactor",	//413
    "inputMethodEvent",	//414
    "inputMethodEvent#",	//415
    "inputMethodQuery",	//416
    "inputMethodQuery$",	//417
    "isContentEditable",	//418
    "isContentSelected",	//419
    "isModified",	//420
    "isNull",	//421
    "isUserScalable",	//422
    "isValid",	//423
    "itemAt",	//424
    "itemAt$",	//425
    "items",	//426
    "iterator",	//427
    "iterator#",	//428
    "iterator#$",	//429
    "javaScriptAlert",	//430
    "javaScriptAlert#$",	//431
    "javaScriptConfirm",	//432
    "javaScriptConfirm#$",	//433
    "javaScriptConsoleMessage",	//434
    "javaScriptConsoleMessage$$$",	//435
    "javaScriptPrompt",	//436
    "javaScriptPrompt#$$$",	//437
    "javaScriptWindowObjectCleared",	//438
    "keyPressEvent",	//439
    "keyPressEvent#",	//440
    "keyReleaseEvent",	//441
    "keyReleaseEvent#",	//442
    "languageChange",	//443
    "last",	//444
    "lastChild",	//445
    "lastVisited",	//446
    "leaveEvent",	//447
    "linkClicked",	//448
    "linkClicked#",	//449
    "linkDelegationPolicy",	//450
    "linkElement",	//451
    "linkHovered",	//452
    "linkHovered$$$",	//453
    "linkTargetFrame",	//454
    "linkText",	//455
    "linkTitle",	//456
    "linkUrl",	//457
    "load",	//458
    "load#",	//459
    "load#$",	//460
    "load#$#",	//461
    "loadFinished",	//462
    "loadFinished$",	//463
    "loadProgress",	//464
    "loadProgress$",	//465
    "loadStarted",	//466
    "localName",	//467
    "localSchemes",	//468
    "localStoragePath",	//469
    "mainFrame",	//470
    "maximumItemCount",	//471
    "maximumPagesInCache",	//472
    "maximumScaleFactor",	//473
    "menuBarVisibilityChangeRequested",	//474
    "menuBarVisibilityChangeRequested$",	//475
    "metaData",	//476
    "metaObject",	//477
    "metric",	//478
    "microFocusChanged",	//479
    "mimeTypes",	//480
    "minimumScaleFactor",	//481
    "minimumSizeHint",	//482
    "mouseDoubleClickEvent",	//483
    "mouseDoubleClickEvent#",	//484
    "mouseMoveEvent",	//485
    "mouseMoveEvent#",	//486
    "mousePressEvent",	//487
    "mousePressEvent#",	//488
    "mouseReleaseEvent",	//489
    "mouseReleaseEvent#",	//490
    "moveEvent",	//491
    "name",	//492
    "namespaceUri",	//493
    "networkAccessManager",	//494
    "nextSibling",	//495
    "offlineStorageDefaultQuota",	//496
    "offlineStoragePath",	//497
    "offlineWebApplicationCachePath",	//498
    "offlineWebApplicationCacheQuota",	//499
    "operator!=",	//500
    "operator!=#",	//501
    "operator*",	//502
    "operator+",	//503
    "operator+#",	//504
    "operator+$",	//505
    "operator++",	//506
    "operator++$",	//507
    "operator+=",	//508
    "operator+=#",	//509
    "operator+=$",	//510
    "operator-",	//511
    "operator-#",	//512
    "operator-$",	//513
    "operator--",	//514
    "operator--$",	//515
    "operator-=",	//516
    "operator-=$",	//517
    "operator<",	//518
    "operator<#",	//519
    "operator<=",	//520
    "operator<=#",	//521
    "operator=",	//522
    "operator=#",	//523
    "operator==",	//524
    "operator==#",	//525
    "operator>",	//526
    "operator>#",	//527
    "operator>=",	//528
    "operator>=#",	//529
    "operator[]",	//530
    "operator[]$",	//531
    "origin",	//532
    "originalUrl",	//533
    "page",	//534
    "pageAction",	//535
    "pageAction$",	//536
    "pageChanged",	//537
    "paintEngine",	//538
    "paintEvent",	//539
    "paintEvent#",	//540
    "palette",	//541
    "paletteChange",	//542
    "parent",	//543
    "parentFrame",	//544
    "pixmap",	//545
    "pluginFactory",	//546
    "plugins",	//547
    "port",	//548
    "pos",	//549
    "preferredContentsSize",	//550
    "prefix",	//551
    "prependInside",	//552
    "prependInside#",	//553
    "prependInside$",	//554
    "prependOutside",	//555
    "prependOutside#",	//556
    "prependOutside$",	//557
    "previousSibling",	//558
    "print",	//559
    "print#",	//560
    "printRequested",	//561
    "printRequested#",	//562
    "provisionalLoad",	//563
    "qt_metacall",	//564
    "qt_metacall$$?",	//565
    "qt_metacast",	//566
    "qt_metacast$",	//567
    "refreshPlugins",	//568
    "reload",	//569
    "removeAllChildren",	//570
    "removeAllDatabases",	//571
    "removeAttribute",	//572
    "removeAttribute$",	//573
    "removeAttributeNS",	//574
    "removeAttributeNS$$",	//575
    "removeClass",	//576
    "removeClass$",	//577
    "removeDatabase",	//578
    "removeDatabase#",	//579
    "removeFromDocument",	//580
    "removeLocalScheme",	//581
    "removeLocalScheme$",	//582
    "render",	//583
    "render#",	//584
    "render##",	//585
    "render#$",	//586
    "render#$#",	//587
    "renderHints",	//588
    "renderTreeDump",	//589
    "repaintRequested",	//590
    "repaintRequested#",	//591
    "replace",	//592
    "replace#",	//593
    "replace$",	//594
    "requestedUrl",	//595
    "resetAttribute",	//596
    "resetAttribute$",	//597
    "resetFontFamily",	//598
    "resetFontFamily$",	//599
    "resetFontSize",	//600
    "resetFontSize$",	//601
    "resizeEvent",	//602
    "resizeEvent#",	//603
    "restoreFrameStateRequested",	//604
    "restoreFrameStateRequested#",	//605
    "saveFrameStateRequested",	//606
    "saveFrameStateRequested##",	//607
    "scheme",	//608
    "scroll",	//609
    "scroll$$",	//610
    "scrollBarGeometry",	//611
    "scrollBarGeometry$",	//612
    "scrollBarMaximum",	//613
    "scrollBarMaximum$",	//614
    "scrollBarMinimum",	//615
    "scrollBarMinimum$",	//616
    "scrollBarPolicy",	//617
    "scrollBarPolicy$",	//618
    "scrollBarValue",	//619
    "scrollBarValue$",	//620
    "scrollPosition",	//621
    "scrollRequested",	//622
    "scrollRequested$$#",	//623
    "scrollToAnchor",	//624
    "scrollToAnchor$",	//625
    "securityOrigin",	//626
    "selectedHtml",	//627
    "selectedText",	//628
    "selectionChanged",	//629
    "setActualVisibleContentRect",	//630
    "setActualVisibleContentRect#",	//631
    "setApplicationCacheQuota",	//632
    "setApplicationCacheQuota$",	//633
    "setAttribute",	//634
    "setAttribute$$",	//635
    "setAttributeNS",	//636
    "setAttributeNS$$$",	//637
    "setBaseUrl",	//638
    "setBaseUrl#",	//639
    "setContent",	//640
    "setContent#",	//641
    "setContent#$",	//642
    "setContent#$#",	//643
    "setContentEditable",	//644
    "setContentEditable$",	//645
    "setContentType",	//646
    "setContentType$",	//647
    "setDatabaseQuota",	//648
    "setDatabaseQuota$",	//649
    "setDefaultInterface",	//650
    "setDefaultInterface#",	//651
    "setDefaultTextEncoding",	//652
    "setDefaultTextEncoding$",	//653
    "setDescription",	//654
    "setDescription$",	//655
    "setDomain",	//656
    "setDomain$",	//657
    "setEncoding",	//658
    "setEncoding$",	//659
    "setError",	//660
    "setError$",	//661
    "setErrorString",	//662
    "setErrorString$",	//663
    "setFeaturePermission",	//664
    "setFeaturePermission#$$",	//665
    "setFileExtensions",	//666
    "setFileExtensions?",	//667
    "setFileNames",	//668
    "setFileNames?",	//669
    "setFocus",	//670
    "setFontFamily",	//671
    "setFontFamily$$",	//672
    "setFontSize",	//673
    "setFontSize$$",	//674
    "setForwardUnsupportedContent",	//675
    "setForwardUnsupportedContent$",	//676
    "setFrame",	//677
    "setFrame#",	//678
    "setHtml",	//679
    "setHtml$",	//680
    "setHtml$#",	//681
    "setIconDatabasePath",	//682
    "setIconDatabasePath$",	//683
    "setInnerXml",	//684
    "setInnerXml$",	//685
    "setLinkDelegationPolicy",	//686
    "setLinkDelegationPolicy$",	//687
    "setLocalStoragePath",	//688
    "setLocalStoragePath$",	//689
    "setMaximumItemCount",	//690
    "setMaximumItemCount$",	//691
    "setMaximumPagesInCache",	//692
    "setMaximumPagesInCache$",	//693
    "setMimeTypes",	//694
    "setMimeTypes?",	//695
    "setName",	//696
    "setName$",	//697
    "setNetworkAccessManager",	//698
    "setNetworkAccessManager#",	//699
    "setObjectCacheCapacities",	//700
    "setObjectCacheCapacities$$$",	//701
    "setOfflineStorageDefaultQuota",	//702
    "setOfflineStorageDefaultQuota$",	//703
    "setOfflineStoragePath",	//704
    "setOfflineStoragePath$",	//705
    "setOfflineWebApplicationCachePath",	//706
    "setOfflineWebApplicationCachePath$",	//707
    "setOfflineWebApplicationCacheQuota",	//708
    "setOfflineWebApplicationCacheQuota$",	//709
    "setOuterXml",	//710
    "setOuterXml$",	//711
    "setPage",	//712
    "setPage#",	//713
    "setPalette",	//714
    "setPalette#",	//715
    "setParentFrame",	//716
    "setParentFrame#",	//717
    "setPlainText",	//718
    "setPlainText$",	//719
    "setPluginFactory",	//720
    "setPluginFactory#",	//721
    "setPreferredContentsSize",	//722
    "setPreferredContentsSize#",	//723
    "setRenderHint",	//724
    "setRenderHint$",	//725
    "setRenderHint$$",	//726
    "setRenderHints",	//727
    "setRenderHints$",	//728
    "setScrollBarPolicy",	//729
    "setScrollBarPolicy$$",	//730
    "setScrollBarValue",	//731
    "setScrollBarValue$$",	//732
    "setScrollPosition",	//733
    "setScrollPosition#",	//734
    "setStyleProperty",	//735
    "setStyleProperty$$",	//736
    "setSuggestedFileNames",	//737
    "setSuggestedFileNames?",	//738
    "setTextSizeMultiplier",	//739
    "setTextSizeMultiplier$",	//740
    "setThirdPartyCookiePolicy",	//741
    "setThirdPartyCookiePolicy$",	//742
    "setUrl",	//743
    "setUrl#",	//744
    "setUserData",	//745
    "setUserData#",	//746
    "setUserStyleSheetUrl",	//747
    "setUserStyleSheetUrl#",	//748
    "setView",	//749
    "setView#",	//750
    "setViewportSize",	//751
    "setViewportSize#",	//752
    "setVisible",	//753
    "setWebGraphic",	//754
    "setWebGraphic$#",	//755
    "setZoomFactor",	//756
    "setZoomFactor$",	//757
    "settings",	//758
    "shouldInterruptJavaScript",	//759
    "showEvent",	//760
    "showEvent#",	//761
    "size",	//762
    "sizeHint",	//763
    "staticMetaObject",	//764
    "statusBarMessage",	//765
    "statusBarMessage$",	//766
    "statusBarVisibilityChangeRequested",	//767
    "statusBarVisibilityChangeRequested$",	//768
    "stop",	//769
    "styleChange",	//770
    "styleProperty",	//771
    "styleProperty$$",	//772
    "suggestedFileNames",	//773
    "supportedContentTypes",	//774
    "supportsContentType",	//775
    "supportsContentType$",	//776
    "supportsExtension",	//777
    "supportsExtension$",	//778
    "swallowContextMenuEvent",	//779
    "swallowContextMenuEvent#",	//780
    "tabletEvent",	//781
    "tagName",	//782
    "takeFromDocument",	//783
    "testAttribute",	//784
    "testAttribute$",	//785
    "textSizeMultiplier",	//786
    "thirdPartyCookiePolicy",	//787
    "timerEvent",	//788
    "title",	//789
    "titleChanged",	//790
    "titleChanged$",	//791
    "toHtml",	//792
    "toInnerXml",	//793
    "toList",	//794
    "toOuterXml",	//795
    "toPlainText",	//796
    "toggleClass",	//797
    "toggleClass$",	//798
    "toolBarVisibilityChangeRequested",	//799
    "toolBarVisibilityChangeRequested$",	//800
    "totalBytes",	//801
    "tr",	//802
    "tr$",	//803
    "tr$$",	//804
    "tr$$$",	//805
    "trUtf8",	//806
    "trUtf8$",	//807
    "trUtf8$$",	//808
    "trUtf8$$$",	//809
    "triggerAction",	//810
    "triggerAction$",	//811
    "triggerAction$$",	//812
    "triggerPageAction",	//813
    "triggerPageAction$",	//814
    "triggerPageAction$$",	//815
    "undoStack",	//816
    "unsupportedContent",	//817
    "unsupportedContent#",	//818
    "updatePositionDependentActions",	//819
    "updatePositionDependentActions#",	//820
    "url",	//821
    "urlChanged",	//822
    "urlChanged#",	//823
    "userAgentForUrl",	//824
    "userAgentForUrl#",	//825
    "userData",	//826
    "userStyleSheetUrl",	//827
    "view",	//828
    "viewportAttributesForSize",	//829
    "viewportAttributesForSize#",	//830
    "viewportChangeRequested",	//831
    "viewportSize",	//832
    "webFrame",	//833
    "webGraphic",	//834
    "webGraphic$",	//835
    "wheelEvent",	//836
    "wheelEvent#",	//837
    "windowActivationChange",	//838
    "windowCloseRequested",	//839
    "x11Event",	//840
    "zoomFactor",	//841
    "~ChooseMultipleFilesExtensionOption",	//842
    "~ChooseMultipleFilesExtensionReturn",	//843
    "~ErrorPageExtensionOption",	//844
    "~ErrorPageExtensionReturn",	//845
    "~ExtensionOption",	//846
    "~ExtensionReturn",	//847
    "~MimeType",	//848
    "~Plugin",	//849
    "~QWebDatabase",	//850
    "~QWebElement",	//851
    "~QWebElementCollection",	//852
    "~QWebHistoryInterface",	//853
    "~QWebHistoryItem",	//854
    "~QWebHitTestResult",	//855
    "~QWebInspector",	//856
    "~QWebPage",	//857
    "~QWebPluginFactory",	//858
    "~QWebSecurityOrigin",	//859
    "~QWebView",	//860
    "~ViewportAttributes",	//861
    "~const_iterator",	//862
    "~iterator",	//863
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {28, 331, 1, 1, Smoke::mf_virtual, 208, 0},	//1 QObject::event(QEvent*)
    {28, 333, 3, 2, Smoke::mf_virtual, 208, 0},	//2 QObject::eventFilter(QObject*, QEvent*)
    {28, 788, 6, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3 QObject::timerEvent(QTimerEvent*)
    {28, 251, 8, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//4 QObject::childEvent(QChildEvent*)
    {28, 287, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//5 QObject::customEvent(QEvent*)
    {28, 262, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//6 QObject::connectNotify(const char*)
    {28, 298, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//7 QObject::disconnectNotify(const char*)
    {48, 129, 12, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 69, 1},	//8 QWebDatabase::QWebDatabase(const QWebDatabase&)
    {48, 522, 12, 1, 0, 68, 2},	//9 QWebDatabase::operator=(const QWebDatabase&)
    {48, 492, 0, 0, Smoke::mf_const, 54, 3},	//10 QWebDatabase::name() const
    {48, 299, 0, 0, Smoke::mf_const, 54, 4},	//11 QWebDatabase::displayName() const
    {48, 334, 0, 0, Smoke::mf_const, 254, 5},	//12 QWebDatabase::expectedSize() const
    {48, 762, 0, 0, Smoke::mf_const, 254, 6},	//13 QWebDatabase::size() const
    {48, 344, 0, 0, Smoke::mf_const, 54, 7},	//14 QWebDatabase::fileName() const
    {48, 532, 0, 0, Smoke::mf_const, 122, 8},	//15 QWebDatabase::origin() const
    {48, 578, 12, 1, Smoke::mf_static, 0, 9},	//16 QWebDatabase::removeDatabase(const QWebDatabase&)
    {48, 571, 0, 0, Smoke::mf_static, 0, 10},	//17 QWebDatabase::removeAllDatabases()
    {48, 850, 0, 0, Smoke::mf_dtor, 0, 11 },	//18 QWebDatabase::~QWebDatabase()
    {49, 131, 0, 0, Smoke::mf_ctor, 72, 1},	//19 QWebElement::QWebElement()
    {49, 131, 14, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 72, 2},	//20 QWebElement::QWebElement(const QWebElement&)
    {49, 522, 14, 1, 0, 71, 3},	//21 QWebElement::operator=(const QWebElement&)
    {49, 524, 14, 1, Smoke::mf_const, 208, 4},	//22 QWebElement::operator==(const QWebElement&) const
    {49, 500, 14, 1, Smoke::mf_const, 208, 5},	//23 QWebElement::operator!=(const QWebElement&) const
    {49, 421, 0, 0, Smoke::mf_const, 208, 6},	//24 QWebElement::isNull() const
    {49, 346, 16, 1, Smoke::mf_const, 74, 7},	//25 QWebElement::findAll(const QString&) const
    {49, 350, 16, 1, Smoke::mf_const, 70, 8},	//26 QWebElement::findFirst(const QString&) const
    {49, 718, 16, 1, 0, 0, 9},	//27 QWebElement::setPlainText(const QString&)
    {49, 796, 0, 0, Smoke::mf_const, 54, 10},	//28 QWebElement::toPlainText() const
    {49, 710, 16, 1, 0, 0, 11},	//29 QWebElement::setOuterXml(const QString&)
    {49, 795, 0, 0, Smoke::mf_const, 54, 12},	//30 QWebElement::toOuterXml() const
    {49, 684, 16, 1, 0, 0, 13},	//31 QWebElement::setInnerXml(const QString&)
    {49, 793, 0, 0, Smoke::mf_const, 54, 14},	//32 QWebElement::toInnerXml() const
    {49, 634, 18, 2, 0, 0, 15},	//33 QWebElement::setAttribute(const QString&, const QString&)
    {49, 636, 21, 3, 0, 0, 16},	//34 QWebElement::setAttributeNS(const QString&, const QString&, const QString&)
    {49, 231, 18, 2, Smoke::mf_const, 54, 17},	//35 QWebElement::attribute(const QString&, const QString&) const
    {49, 234, 21, 3, Smoke::mf_const, 54, 18},	//36 QWebElement::attributeNS(const QString&, const QString&, const QString&) const
    {49, 388, 16, 1, Smoke::mf_const, 208, 19},	//37 QWebElement::hasAttribute(const QString&) const
    {49, 390, 18, 2, Smoke::mf_const, 208, 20},	//38 QWebElement::hasAttributeNS(const QString&, const QString&) const
    {49, 572, 16, 1, 0, 0, 21},	//39 QWebElement::removeAttribute(const QString&)
    {49, 574, 18, 2, 0, 0, 22},	//40 QWebElement::removeAttributeNS(const QString&, const QString&)
    {49, 392, 0, 0, Smoke::mf_const, 208, 23},	//41 QWebElement::hasAttributes() const
    {49, 237, 16, 1, Smoke::mf_const, 57, 24},	//42 QWebElement::attributeNames(const QString&) const
    {49, 255, 0, 0, Smoke::mf_const, 57, 25},	//43 QWebElement::classes() const
    {49, 393, 16, 1, Smoke::mf_const, 208, 26},	//44 QWebElement::hasClass(const QString&) const
    {49, 207, 16, 1, 0, 0, 27},	//45 QWebElement::addClass(const QString&)
    {49, 576, 16, 1, 0, 0, 28},	//46 QWebElement::removeClass(const QString&)
    {49, 797, 16, 1, 0, 0, 29},	//47 QWebElement::toggleClass(const QString&)
    {49, 395, 0, 0, Smoke::mf_const, 208, 30},	//48 QWebElement::hasFocus() const
    {49, 670, 0, 0, 0, 0, 31},	//49 QWebElement::setFocus()
    {49, 381, 0, 0, Smoke::mf_const, 48, 32},	//50 QWebElement::geometry() const
    {49, 782, 0, 0, Smoke::mf_const, 54, 33},	//51 QWebElement::tagName() const
    {49, 551, 0, 0, Smoke::mf_const, 54, 34},	//52 QWebElement::prefix() const
    {49, 467, 0, 0, Smoke::mf_const, 54, 35},	//53 QWebElement::localName() const
    {49, 493, 0, 0, Smoke::mf_const, 54, 36},	//54 QWebElement::namespaceUri() const
    {49, 543, 0, 0, Smoke::mf_const, 70, 37},	//55 QWebElement::parent() const
    {49, 358, 0, 0, Smoke::mf_const, 70, 38},	//56 QWebElement::firstChild() const
    {49, 445, 0, 0, Smoke::mf_const, 70, 39},	//57 QWebElement::lastChild() const
    {49, 495, 0, 0, Smoke::mf_const, 70, 40},	//58 QWebElement::nextSibling() const
    {49, 558, 0, 0, Smoke::mf_const, 70, 41},	//59 QWebElement::previousSibling() const
    {49, 300, 0, 0, Smoke::mf_const, 70, 42},	//60 QWebElement::document() const
    {49, 833, 0, 0, Smoke::mf_const, 83, 43},	//61 QWebElement::webFrame() const
    {49, 220, 16, 1, 0, 0, 44},	//62 QWebElement::appendInside(const QString&)
    {49, 220, 14, 1, 0, 0, 45},	//63 QWebElement::appendInside(const QWebElement&)
    {49, 552, 16, 1, 0, 0, 46},	//64 QWebElement::prependInside(const QString&)
    {49, 552, 14, 1, 0, 0, 47},	//65 QWebElement::prependInside(const QWebElement&)
    {49, 223, 16, 1, 0, 0, 48},	//66 QWebElement::appendOutside(const QString&)
    {49, 223, 14, 1, 0, 0, 49},	//67 QWebElement::appendOutside(const QWebElement&)
    {49, 555, 16, 1, 0, 0, 50},	//68 QWebElement::prependOutside(const QString&)
    {49, 555, 14, 1, 0, 0, 51},	//69 QWebElement::prependOutside(const QWebElement&)
    {49, 317, 14, 1, 0, 0, 52},	//70 QWebElement::encloseContentsWith(const QWebElement&)
    {49, 317, 16, 1, 0, 0, 53},	//71 QWebElement::encloseContentsWith(const QString&)
    {49, 320, 16, 1, 0, 0, 54},	//72 QWebElement::encloseWith(const QString&)
    {49, 320, 14, 1, 0, 0, 55},	//73 QWebElement::encloseWith(const QWebElement&)
    {49, 592, 16, 1, 0, 0, 56},	//74 QWebElement::replace(const QString&)
    {49, 592, 14, 1, 0, 0, 57},	//75 QWebElement::replace(const QWebElement&)
    {49, 259, 0, 0, Smoke::mf_const, 70, 58},	//76 QWebElement::clone() const
    {49, 783, 0, 0, 0, 71, 59},	//77 QWebElement::takeFromDocument()
    {49, 580, 0, 0, 0, 0, 60},	//78 QWebElement::removeFromDocument()
    {49, 570, 0, 0, 0, 0, 61},	//79 QWebElement::removeAllChildren()
    {49, 329, 16, 1, 0, 66, 62},	//80 QWebElement::evaluateJavaScript(const QString&)
    {49, 771, 25, 2, Smoke::mf_const, 54, 63},	//81 QWebElement::styleProperty(const QString&, QWebElement::StyleResolveStrategy) const
    {49, 735, 18, 2, 0, 0, 64},	//82 QWebElement::setStyleProperty(const QString&, const QString&)
    {49, 583, 28, 1, 0, 0, 65},	//83 QWebElement::render(QPainter*)
    {49, 583, 30, 2, 0, 0, 66},	//84 QWebElement::render(QPainter*, const QRect&)
    {49, 231, 16, 1, Smoke::mf_const, 54, 67},	//85 QWebElement::attribute(const QString&) const
    {49, 234, 18, 2, Smoke::mf_const, 54, 68},	//86 QWebElement::attributeNS(const QString&, const QString&) const
    {49, 237, 0, 0, Smoke::mf_const, 57, 69},	//87 QWebElement::attributeNames() const
    {49, 66, 0, 0, Smoke::mf_static|Smoke::mf_enum, 73, 70},	//88 QWebElement::InlineStyle (enum)
    {49, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 73, 71},	//89 QWebElement::CascadedStyle (enum)
    {49, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 73, 72},	//90 QWebElement::ComputedStyle (enum)
    {49, 851, 0, 0, Smoke::mf_dtor, 0, 73 },	//91 QWebElement::~QWebElement()
    {50, 133, 0, 0, Smoke::mf_ctor, 76, 1},	//92 QWebElementCollection::QWebElementCollection()
    {50, 133, 33, 2, Smoke::mf_ctor, 76, 2},	//93 QWebElementCollection::QWebElementCollection(const QWebElement&, const QString&)
    {50, 133, 36, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 76, 3},	//94 QWebElementCollection::QWebElementCollection(const QWebElementCollection&)
    {50, 522, 36, 1, 0, 75, 4},	//95 QWebElementCollection::operator=(const QWebElementCollection&)
    {50, 503, 36, 1, Smoke::mf_const, 74, 5},	//96 QWebElementCollection::operator+(const QWebElementCollection&) const
    {50, 508, 36, 1, 0, 75, 6},	//97 QWebElementCollection::operator+=(const QWebElementCollection&)
    {50, 218, 36, 1, 0, 0, 7},	//98 QWebElementCollection::append(const QWebElementCollection&)
    {50, 276, 0, 0, Smoke::mf_const, 253, 8},	//99 QWebElementCollection::count() const
    {50, 229, 38, 1, Smoke::mf_const, 70, 9},	//100 QWebElementCollection::at(int) const
    {50, 530, 38, 1, Smoke::mf_const, 70, 10},	//101 QWebElementCollection::operator[](int) const
    {50, 357, 0, 0, Smoke::mf_const, 70, 11},	//102 QWebElementCollection::first() const
    {50, 444, 0, 0, Smoke::mf_const, 70, 12},	//103 QWebElementCollection::last() const
    {50, 794, 0, 0, Smoke::mf_const, 23, 13},	//104 QWebElementCollection::toList() const
    {50, 244, 0, 0, Smoke::mf_const, 77, 14},	//105 QWebElementCollection::begin() const
    {50, 325, 0, 0, Smoke::mf_const, 77, 15},	//106 QWebElementCollection::end() const
    {50, 263, 0, 0, Smoke::mf_const, 77, 16},	//107 QWebElementCollection::constBegin() const
    {50, 264, 0, 0, Smoke::mf_const, 77, 17},	//108 QWebElementCollection::constEnd() const
    {50, 244, 0, 0, 0, 80, 18},	//109 QWebElementCollection::begin()
    {50, 325, 0, 0, 0, 80, 19},	//110 QWebElementCollection::end()
    {50, 852, 0, 0, Smoke::mf_dtor, 0, 20 },	//111 QWebElementCollection::~QWebElementCollection()
    {51, 265, 40, 2, Smoke::mf_ctor, 79, 1},	//112 QWebElementCollection::const_iterator::const_iterator(const QWebElementCollection*, int)
    {51, 265, 43, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 79, 2},	//113 QWebElementCollection::const_iterator::const_iterator(const QWebElementCollection::const_iterator&)
    {51, 502, 0, 0, Smoke::mf_const, 228, 3},	//114 QWebElementCollection::const_iterator::operator*() const
    {51, 524, 43, 1, Smoke::mf_const, 208, 4},	//115 QWebElementCollection::const_iterator::operator==(const QWebElementCollection::const_iterator&) const
    {51, 500, 43, 1, Smoke::mf_const, 208, 5},	//116 QWebElementCollection::const_iterator::operator!=(const QWebElementCollection::const_iterator&) const
    {51, 518, 43, 1, Smoke::mf_const, 208, 6},	//117 QWebElementCollection::const_iterator::operator<(const QWebElementCollection::const_iterator&) const
    {51, 520, 43, 1, Smoke::mf_const, 208, 7},	//118 QWebElementCollection::const_iterator::operator<=(const QWebElementCollection::const_iterator&) const
    {51, 526, 43, 1, Smoke::mf_const, 208, 8},	//119 QWebElementCollection::const_iterator::operator>(const QWebElementCollection::const_iterator&) const
    {51, 528, 43, 1, Smoke::mf_const, 208, 9},	//120 QWebElementCollection::const_iterator::operator>=(const QWebElementCollection::const_iterator&) const
    {51, 506, 0, 0, 0, 78, 10},	//121 QWebElementCollection::const_iterator::operator++()
    {51, 506, 38, 1, 0, 77, 11},	//122 QWebElementCollection::const_iterator::operator++(int)
    {51, 514, 0, 0, 0, 78, 12},	//123 QWebElementCollection::const_iterator::operator--()
    {51, 514, 38, 1, 0, 77, 13},	//124 QWebElementCollection::const_iterator::operator--(int)
    {51, 508, 38, 1, 0, 78, 14},	//125 QWebElementCollection::const_iterator::operator+=(int)
    {51, 516, 38, 1, 0, 78, 15},	//126 QWebElementCollection::const_iterator::operator-=(int)
    {51, 503, 38, 1, Smoke::mf_const, 77, 16},	//127 QWebElementCollection::const_iterator::operator+(int) const
    {51, 511, 38, 1, Smoke::mf_const, 77, 17},	//128 QWebElementCollection::const_iterator::operator-(int) const
    {51, 511, 45, 1, Smoke::mf_const, 253, 18},	//129 QWebElementCollection::const_iterator::operator-(QWebElementCollection::const_iterator) const
    {51, 862, 0, 0, Smoke::mf_dtor, 0, 19 },	//130 QWebElementCollection::const_iterator::~const_iterator()
    {52, 427, 40, 2, Smoke::mf_ctor, 82, 1},	//131 QWebElementCollection::iterator::iterator(const QWebElementCollection*, int)
    {52, 427, 47, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 82, 2},	//132 QWebElementCollection::iterator::iterator(const QWebElementCollection::iterator&)
    {52, 502, 0, 0, Smoke::mf_const, 70, 3},	//133 QWebElementCollection::iterator::operator*() const
    {52, 524, 47, 1, Smoke::mf_const, 208, 4},	//134 QWebElementCollection::iterator::operator==(const QWebElementCollection::iterator&) const
    {52, 500, 47, 1, Smoke::mf_const, 208, 5},	//135 QWebElementCollection::iterator::operator!=(const QWebElementCollection::iterator&) const
    {52, 518, 47, 1, Smoke::mf_const, 208, 6},	//136 QWebElementCollection::iterator::operator<(const QWebElementCollection::iterator&) const
    {52, 520, 47, 1, Smoke::mf_const, 208, 7},	//137 QWebElementCollection::iterator::operator<=(const QWebElementCollection::iterator&) const
    {52, 526, 47, 1, Smoke::mf_const, 208, 8},	//138 QWebElementCollection::iterator::operator>(const QWebElementCollection::iterator&) const
    {52, 528, 47, 1, Smoke::mf_const, 208, 9},	//139 QWebElementCollection::iterator::operator>=(const QWebElementCollection::iterator&) const
    {52, 506, 0, 0, 0, 81, 10},	//140 QWebElementCollection::iterator::operator++()
    {52, 506, 38, 1, 0, 80, 11},	//141 QWebElementCollection::iterator::operator++(int)
    {52, 514, 0, 0, 0, 81, 12},	//142 QWebElementCollection::iterator::operator--()
    {52, 514, 38, 1, 0, 80, 13},	//143 QWebElementCollection::iterator::operator--(int)
    {52, 508, 38, 1, 0, 81, 14},	//144 QWebElementCollection::iterator::operator+=(int)
    {52, 516, 38, 1, 0, 81, 15},	//145 QWebElementCollection::iterator::operator-=(int)
    {52, 503, 38, 1, Smoke::mf_const, 80, 16},	//146 QWebElementCollection::iterator::operator+(int) const
    {52, 511, 38, 1, Smoke::mf_const, 80, 17},	//147 QWebElementCollection::iterator::operator-(int) const
    {52, 511, 49, 1, Smoke::mf_const, 253, 18},	//148 QWebElementCollection::iterator::operator-(QWebElementCollection::iterator) const
    {52, 863, 0, 0, Smoke::mf_dtor, 0, 19 },	//149 QWebElementCollection::iterator::~iterator()
    {53, 477, 0, 0, Smoke::mf_const, 213, 1},	//150 QWebFrame::metaObject() const
    {53, 566, 10, 1, 0, 257, 2},	//151 QWebFrame::qt_metacast(const char*)
    {53, 802, 51, 2, Smoke::mf_static, 54, 3},	//152 QWebFrame::tr(const char*, const char*)
    {53, 806, 51, 2, Smoke::mf_static, 54, 4},	//153 QWebFrame::trUtf8(const char*, const char*)
    {53, 802, 54, 3, Smoke::mf_static, 54, 5},	//154 QWebFrame::tr(const char*, const char*, int)
    {53, 806, 54, 3, Smoke::mf_static, 54, 6},	//155 QWebFrame::trUtf8(const char*, const char*, int)
    {53, 564, 58, 3, 0, 253, 7},	//156 QWebFrame::qt_metacall(QMetaObject::Call, int, void**)
    {53, 534, 0, 0, Smoke::mf_const, 94, 8},	//157 QWebFrame::page() const
    {53, 458, 62, 1, 0, 0, 9},	//158 QWebFrame::load(const QUrl&)
    {53, 458, 64, 3, 0, 0, 10},	//159 QWebFrame::load(const QNetworkRequest&, QNetworkAccessManager::Operation, const QByteArray&)
    {53, 679, 68, 2, 0, 0, 11},	//160 QWebFrame::setHtml(const QString&, const QUrl&)
    {53, 640, 71, 3, 0, 0, 12},	//161 QWebFrame::setContent(const QByteArray&, const QString&, const QUrl&)
    {53, 213, 75, 2, 0, 0, 13},	//162 QWebFrame::addToJavaScriptWindowObject(const QString&, QObject*)
    {53, 213, 78, 3, 0, 0, 14},	//163 QWebFrame::addToJavaScriptWindowObject(const QString&, QObject*, QScriptEngine::ValueOwnership)
    {53, 792, 0, 0, Smoke::mf_const, 54, 15},	//164 QWebFrame::toHtml() const
    {53, 796, 0, 0, Smoke::mf_const, 54, 16},	//165 QWebFrame::toPlainText() const
    {53, 589, 0, 0, Smoke::mf_const, 54, 17},	//166 QWebFrame::renderTreeDump() const
    {53, 789, 0, 0, Smoke::mf_const|Smoke::mf_property, 54, 18},	//167 QWebFrame::title() const
    {53, 743, 62, 1, Smoke::mf_property, 0, 19},	//168 QWebFrame::setUrl(const QUrl&)
    {53, 821, 0, 0, Smoke::mf_const|Smoke::mf_property, 64, 20},	//169 QWebFrame::url() const
    {53, 595, 0, 0, Smoke::mf_const|Smoke::mf_property, 64, 21},	//170 QWebFrame::requestedUrl() const
    {53, 243, 0, 0, Smoke::mf_const|Smoke::mf_property, 64, 22},	//171 QWebFrame::baseUrl() const
    {53, 406, 0, 0, Smoke::mf_const|Smoke::mf_property, 19, 23},	//172 QWebFrame::icon() const
    {53, 476, 0, 0, Smoke::mf_const, 33, 24},	//173 QWebFrame::metaData() const
    {53, 380, 0, 0, Smoke::mf_const, 54, 25},	//174 QWebFrame::frameName() const
    {53, 544, 0, 0, Smoke::mf_const, 83, 26},	//175 QWebFrame::parentFrame() const
    {53, 252, 0, 0, Smoke::mf_const, 24, 27},	//176 QWebFrame::childFrames() const
    {53, 617, 82, 1, Smoke::mf_const, 185, 28},	//177 QWebFrame::scrollBarPolicy(Qt::Orientation) const
    {53, 729, 84, 2, 0, 0, 29},	//178 QWebFrame::setScrollBarPolicy(Qt::Orientation, Qt::ScrollBarPolicy)
    {53, 731, 87, 2, 0, 0, 30},	//179 QWebFrame::setScrollBarValue(Qt::Orientation, int)
    {53, 619, 82, 1, Smoke::mf_const, 253, 31},	//180 QWebFrame::scrollBarValue(Qt::Orientation) const
    {53, 615, 82, 1, Smoke::mf_const, 253, 32},	//181 QWebFrame::scrollBarMinimum(Qt::Orientation) const
    {53, 613, 82, 1, Smoke::mf_const, 253, 33},	//182 QWebFrame::scrollBarMaximum(Qt::Orientation) const
    {53, 611, 82, 1, Smoke::mf_const, 48, 34},	//183 QWebFrame::scrollBarGeometry(Qt::Orientation) const
    {53, 609, 90, 2, 0, 0, 35},	//184 QWebFrame::scroll(int, int)
    {53, 621, 0, 0, Smoke::mf_const|Smoke::mf_property, 46, 36},	//185 QWebFrame::scrollPosition() const
    {53, 733, 93, 1, Smoke::mf_property, 0, 37},	//186 QWebFrame::setScrollPosition(const QPoint&)
    {53, 624, 16, 1, 0, 0, 38},	//187 QWebFrame::scrollToAnchor(const QString&)
    {53, 583, 28, 1, 0, 0, 39},	//188 QWebFrame::render(QPainter*)
    {53, 583, 95, 2, 0, 0, 40},	//189 QWebFrame::render(QPainter*, const QRegion&)
    {53, 583, 98, 3, 0, 0, 41},	//190 QWebFrame::render(QPainter*, QWebFrame::RenderLayer, const QRegion&)
    {53, 739, 102, 1, 0, 0, 42},	//191 QWebFrame::setTextSizeMultiplier(double)
    {53, 786, 0, 0, Smoke::mf_const, 252, 43},	//192 QWebFrame::textSizeMultiplier() const
    {53, 841, 0, 0, Smoke::mf_const, 252, 44},	//193 QWebFrame::zoomFactor() const
    {53, 756, 102, 1, 0, 0, 45},	//194 QWebFrame::setZoomFactor(double)
    {53, 395, 0, 0, Smoke::mf_const|Smoke::mf_property, 208, 46},	//195 QWebFrame::hasFocus() const
    {53, 670, 0, 0, 0, 0, 47},	//196 QWebFrame::setFocus()
    {53, 549, 0, 0, Smoke::mf_const, 46, 48},	//197 QWebFrame::pos() const
    {53, 381, 0, 0, Smoke::mf_const, 48, 49},	//198 QWebFrame::geometry() const
    {53, 271, 0, 0, Smoke::mf_const|Smoke::mf_property, 53, 50},	//199 QWebFrame::contentsSize() const
    {53, 301, 0, 0, Smoke::mf_const, 70, 51},	//200 QWebFrame::documentElement() const
    {53, 348, 16, 1, Smoke::mf_const, 74, 52},	//201 QWebFrame::findAllElements(const QString&) const
    {53, 352, 16, 1, Smoke::mf_const, 70, 53},	//202 QWebFrame::findFirstElement(const QString&) const
    {53, 403, 93, 1, Smoke::mf_const, 90, 54},	//203 QWebFrame::hitTestContent(const QPoint&) const
    {53, 331, 1, 1, 0, 208, 55},	//204 QWebFrame::event(QEvent*)
    {53, 626, 0, 0, Smoke::mf_const, 122, 56},	//205 QWebFrame::securityOrigin() const
    {53, 329, 16, 1, Smoke::mf_slot, 66, 57},	//206 QWebFrame::evaluateJavaScript(const QString&)
    {53, 559, 104, 1, Smoke::mf_const|Smoke::mf_slot, 0, 58},	//207 QWebFrame::print(QPrinter*) const
    {53, 438, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 59},	//208 QWebFrame::javaScriptWindowObjectCleared()
    {53, 563, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 60},	//209 QWebFrame::provisionalLoad()
    {53, 790, 16, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 61},	//210 QWebFrame::titleChanged(const QString&)
    {53, 822, 62, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 62},	//211 QWebFrame::urlChanged(const QUrl&)
    {53, 412, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 63},	//212 QWebFrame::initialLayoutCompleted()
    {53, 407, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 64},	//213 QWebFrame::iconChanged()
    {53, 272, 106, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 65},	//214 QWebFrame::contentsSizeChanged(const QSize&)
    {53, 466, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 66},	//215 QWebFrame::loadStarted()
    {53, 462, 108, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 67},	//216 QWebFrame::loadFinished(bool)
    {53, 537, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 68},	//217 QWebFrame::pageChanged()
    {53, 802, 10, 1, Smoke::mf_static, 54, 69},	//218 QWebFrame::tr(const char*)
    {53, 806, 10, 1, Smoke::mf_static, 54, 70},	//219 QWebFrame::trUtf8(const char*)
    {53, 458, 110, 1, 0, 0, 71},	//220 QWebFrame::load(const QNetworkRequest&)
    {53, 458, 112, 2, 0, 0, 72},	//221 QWebFrame::load(const QNetworkRequest&, QNetworkAccessManager::Operation)
    {53, 679, 16, 1, 0, 0, 73},	//222 QWebFrame::setHtml(const QString&)
    {53, 640, 115, 1, 0, 0, 74},	//223 QWebFrame::setContent(const QByteArray&)
    {53, 640, 117, 2, 0, 0, 75},	//224 QWebFrame::setContent(const QByteArray&, const QString&)
    {53, 583, 120, 2, 0, 0, 76},	//225 QWebFrame::render(QPainter*, QWebFrame::RenderLayer)
    {53, 764, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 212, 77},	//226 QWebFrame::staticMetaObject() const
    {53, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 78},	//227 QWebFrame::ContentsLayer (enum)
    {53, 159, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 79},	//228 QWebFrame::ScrollBarLayer (enum)
    {53, 118, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 80},	//229 QWebFrame::PanIconLayer (enum)
    {53, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 81},	//230 QWebFrame::AllLayers (enum)
    {54, 256, 0, 0, 0, 0, 1},	//231 QWebHistory::clear()
    {54, 426, 0, 0, Smoke::mf_const, 25, 2},	//232 QWebHistory::items() const
    {54, 241, 38, 1, Smoke::mf_const, 25, 3},	//233 QWebHistory::backItems(int) const
    {54, 372, 38, 1, Smoke::mf_const, 25, 4},	//234 QWebHistory::forwardItems(int) const
    {54, 247, 0, 0, Smoke::mf_const, 208, 5},	//235 QWebHistory::canGoBack() const
    {54, 248, 0, 0, Smoke::mf_const, 208, 6},	//236 QWebHistory::canGoForward() const
    {54, 239, 0, 0, 0, 0, 7},	//237 QWebHistory::back()
    {54, 370, 0, 0, 0, 0, 8},	//238 QWebHistory::forward()
    {54, 385, 123, 1, 0, 0, 9},	//239 QWebHistory::goToItem(const QWebHistoryItem&)
    {54, 240, 0, 0, Smoke::mf_const, 87, 10},	//240 QWebHistory::backItem() const
    {54, 285, 0, 0, Smoke::mf_const, 87, 11},	//241 QWebHistory::currentItem() const
    {54, 371, 0, 0, Smoke::mf_const, 87, 12},	//242 QWebHistory::forwardItem() const
    {54, 424, 38, 1, Smoke::mf_const, 87, 13},	//243 QWebHistory::itemAt(int) const
    {54, 286, 0, 0, Smoke::mf_const, 253, 14},	//244 QWebHistory::currentItemIndex() const
    {54, 276, 0, 0, Smoke::mf_const, 253, 15},	//245 QWebHistory::count() const
    {54, 471, 0, 0, Smoke::mf_const, 253, 16},	//246 QWebHistory::maximumItemCount() const
    {54, 690, 38, 1, 0, 0, 17},	//247 QWebHistory::setMaximumItemCount(int)
    {55, 477, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 213, 1},	//248 QWebHistoryInterface::metaObject() const
    {55, 566, 10, 1, Smoke::mf_virtual, 257, 2},	//249 QWebHistoryInterface::qt_metacast(const char*)
    {55, 802, 51, 2, Smoke::mf_static, 54, 3},	//250 QWebHistoryInterface::tr(const char*, const char*)
    {55, 806, 51, 2, Smoke::mf_static, 54, 4},	//251 QWebHistoryInterface::trUtf8(const char*, const char*)
    {55, 802, 54, 3, Smoke::mf_static, 54, 5},	//252 QWebHistoryInterface::tr(const char*, const char*, int)
    {55, 806, 54, 3, Smoke::mf_static, 54, 6},	//253 QWebHistoryInterface::trUtf8(const char*, const char*, int)
    {55, 564, 58, 3, Smoke::mf_virtual, 253, 7},	//254 QWebHistoryInterface::qt_metacall(QMetaObject::Call, int, void**)
    {55, 136, 125, 1, Smoke::mf_ctor, 86, 8},	//255 QWebHistoryInterface::QWebHistoryInterface(QObject*)
    {55, 650, 127, 1, Smoke::mf_static, 0, 9},	//256 QWebHistoryInterface::setDefaultInterface(QWebHistoryInterface*)
    {55, 293, 0, 0, Smoke::mf_static, 86, 10},	//257 QWebHistoryInterface::defaultInterface()
    {55, 401, 16, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 208, 11},	//258 QWebHistoryInterface::historyContains(const QString&) const [pure virtual]
    {55, 209, 16, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 12},	//259 QWebHistoryInterface::addHistoryEntry(const QString&) [pure virtual]
    {55, 802, 10, 1, Smoke::mf_static, 54, 13},	//260 QWebHistoryInterface::tr(const char*)
    {55, 806, 10, 1, Smoke::mf_static, 54, 14},	//261 QWebHistoryInterface::trUtf8(const char*)
    {55, 136, 0, 0, Smoke::mf_ctor, 86, 15},	//262 QWebHistoryInterface::QWebHistoryInterface()
    {55, 764, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 212, 16},	//263 QWebHistoryInterface::staticMetaObject() const
    {55, 853, 0, 0, Smoke::mf_dtor, 0, 17 },	//264 QWebHistoryInterface::~QWebHistoryInterface()
    {56, 138, 123, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 89, 1},	//265 QWebHistoryItem::QWebHistoryItem(const QWebHistoryItem&)
    {56, 522, 123, 1, 0, 88, 2},	//266 QWebHistoryItem::operator=(const QWebHistoryItem&)
    {56, 533, 0, 0, Smoke::mf_const, 64, 3},	//267 QWebHistoryItem::originalUrl() const
    {56, 821, 0, 0, Smoke::mf_const, 64, 4},	//268 QWebHistoryItem::url() const
    {56, 789, 0, 0, Smoke::mf_const, 54, 5},	//269 QWebHistoryItem::title() const
    {56, 446, 0, 0, Smoke::mf_const, 8, 6},	//270 QWebHistoryItem::lastVisited() const
    {56, 406, 0, 0, Smoke::mf_const, 19, 7},	//271 QWebHistoryItem::icon() const
    {56, 826, 0, 0, Smoke::mf_const, 66, 8},	//272 QWebHistoryItem::userData() const
    {56, 745, 129, 1, 0, 0, 9},	//273 QWebHistoryItem::setUserData(const QVariant&)
    {56, 423, 0, 0, Smoke::mf_const, 208, 10},	//274 QWebHistoryItem::isValid() const
    {56, 854, 0, 0, Smoke::mf_dtor, 0, 11 },	//275 QWebHistoryItem::~QWebHistoryItem()
    {57, 140, 0, 0, Smoke::mf_ctor, 92, 1},	//276 QWebHitTestResult::QWebHitTestResult()
    {57, 140, 131, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 92, 2},	//277 QWebHitTestResult::QWebHitTestResult(const QWebHitTestResult&)
    {57, 522, 131, 1, 0, 91, 3},	//278 QWebHitTestResult::operator=(const QWebHitTestResult&)
    {57, 421, 0, 0, Smoke::mf_const, 208, 4},	//279 QWebHitTestResult::isNull() const
    {57, 549, 0, 0, Smoke::mf_const, 46, 5},	//280 QWebHitTestResult::pos() const
    {57, 245, 0, 0, Smoke::mf_const, 48, 6},	//281 QWebHitTestResult::boundingRect() const
    {57, 323, 0, 0, Smoke::mf_const, 70, 7},	//282 QWebHitTestResult::enclosingBlockElement() const
    {57, 789, 0, 0, Smoke::mf_const, 54, 8},	//283 QWebHitTestResult::title() const
    {57, 455, 0, 0, Smoke::mf_const, 54, 9},	//284 QWebHitTestResult::linkText() const
    {57, 457, 0, 0, Smoke::mf_const, 64, 10},	//285 QWebHitTestResult::linkUrl() const
    {57, 456, 0, 0, Smoke::mf_const, 64, 11},	//286 QWebHitTestResult::linkTitle() const
    {57, 454, 0, 0, Smoke::mf_const, 83, 12},	//287 QWebHitTestResult::linkTargetFrame() const
    {57, 451, 0, 0, Smoke::mf_const, 70, 13},	//288 QWebHitTestResult::linkElement() const
    {57, 217, 0, 0, Smoke::mf_const, 54, 14},	//289 QWebHitTestResult::alternateText() const
    {57, 411, 0, 0, Smoke::mf_const, 64, 15},	//290 QWebHitTestResult::imageUrl() const
    {57, 545, 0, 0, Smoke::mf_const, 45, 16},	//291 QWebHitTestResult::pixmap() const
    {57, 418, 0, 0, Smoke::mf_const, 208, 17},	//292 QWebHitTestResult::isContentEditable() const
    {57, 419, 0, 0, Smoke::mf_const, 208, 18},	//293 QWebHitTestResult::isContentSelected() const
    {57, 313, 0, 0, Smoke::mf_const, 70, 19},	//294 QWebHitTestResult::element() const
    {57, 375, 0, 0, Smoke::mf_const, 83, 20},	//295 QWebHitTestResult::frame() const
    {57, 855, 0, 0, Smoke::mf_dtor, 0, 21 },	//296 QWebHitTestResult::~QWebHitTestResult()
    {58, 477, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 213, 1},	//297 QWebInspector::metaObject() const
    {58, 566, 10, 1, Smoke::mf_virtual, 257, 2},	//298 QWebInspector::qt_metacast(const char*)
    {58, 802, 51, 2, Smoke::mf_static, 54, 3},	//299 QWebInspector::tr(const char*, const char*)
    {58, 806, 51, 2, Smoke::mf_static, 54, 4},	//300 QWebInspector::trUtf8(const char*, const char*)
    {58, 802, 54, 3, Smoke::mf_static, 54, 5},	//301 QWebInspector::tr(const char*, const char*, int)
    {58, 806, 54, 3, Smoke::mf_static, 54, 6},	//302 QWebInspector::trUtf8(const char*, const char*, int)
    {58, 564, 58, 3, Smoke::mf_virtual, 253, 7},	//303 QWebInspector::qt_metacall(QMetaObject::Call, int, void**)
    {58, 142, 133, 1, Smoke::mf_ctor, 93, 8},	//304 QWebInspector::QWebInspector(QWidget*)
    {58, 712, 135, 1, 0, 0, 9},	//305 QWebInspector::setPage(QWebPage*)
    {58, 534, 0, 0, Smoke::mf_const, 94, 10},	//306 QWebInspector::page() const
    {58, 763, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 53, 11},	//307 QWebInspector::sizeHint() const
    {58, 331, 1, 1, Smoke::mf_virtual, 208, 12},	//308 QWebInspector::event(QEvent*)
    {58, 602, 137, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 13},	//309 QWebInspector::resizeEvent(QResizeEvent*)
    {58, 760, 139, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 14},	//310 QWebInspector::showEvent(QShowEvent*)
    {58, 398, 141, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 15},	//311 QWebInspector::hideEvent(QHideEvent*)
    {58, 260, 143, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 16},	//312 QWebInspector::closeEvent(QCloseEvent*)
    {58, 802, 10, 1, Smoke::mf_static, 54, 17},	//313 QWebInspector::tr(const char*)
    {58, 806, 10, 1, Smoke::mf_static, 54, 18},	//314 QWebInspector::trUtf8(const char*)
    {58, 142, 0, 0, Smoke::mf_ctor, 93, 19},	//315 QWebInspector::QWebInspector()
    {58, 764, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 212, 20},	//316 QWebInspector::staticMetaObject() const
    {58, 856, 0, 0, Smoke::mf_dtor, 0, 21 },	//317 QWebInspector::~QWebInspector()
    {59, 477, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 213, 1},	//318 QWebPage::metaObject() const
    {59, 566, 10, 1, Smoke::mf_virtual, 257, 2},	//319 QWebPage::qt_metacast(const char*)
    {59, 802, 51, 2, Smoke::mf_static, 54, 3},	//320 QWebPage::tr(const char*, const char*)
    {59, 806, 51, 2, Smoke::mf_static, 54, 4},	//321 QWebPage::trUtf8(const char*, const char*)
    {59, 802, 54, 3, Smoke::mf_static, 54, 5},	//322 QWebPage::tr(const char*, const char*, int)
    {59, 806, 54, 3, Smoke::mf_static, 54, 6},	//323 QWebPage::trUtf8(const char*, const char*, int)
    {59, 564, 58, 3, Smoke::mf_virtual, 253, 7},	//324 QWebPage::qt_metacall(QMetaObject::Call, int, void**)
    {59, 144, 125, 1, Smoke::mf_ctor, 94, 8},	//325 QWebPage::QWebPage(QObject*)
    {59, 470, 0, 0, Smoke::mf_const, 83, 9},	//326 QWebPage::mainFrame() const
    {59, 284, 0, 0, Smoke::mf_const, 83, 10},	//327 QWebPage::currentFrame() const
    {59, 376, 93, 1, Smoke::mf_const, 83, 11},	//328 QWebPage::frameAt(const QPoint&) const
    {59, 400, 0, 0, Smoke::mf_const, 85, 12},	//329 QWebPage::history() const
    {59, 758, 0, 0, Smoke::mf_const, 125, 13},	//330 QWebPage::settings() const
    {59, 749, 133, 1, 0, 0, 14},	//331 QWebPage::setView(QWidget*)
    {59, 828, 0, 0, Smoke::mf_const, 134, 15},	//332 QWebPage::view() const
    {59, 420, 0, 0, Smoke::mf_const|Smoke::mf_property, 208, 16},	//333 QWebPage::isModified() const
    {59, 816, 0, 0, Smoke::mf_const, 63, 17},	//334 QWebPage::undoStack() const
    {59, 698, 145, 1, 0, 0, 18},	//335 QWebPage::setNetworkAccessManager(QNetworkAccessManager*)
    {59, 494, 0, 0, Smoke::mf_const, 34, 19},	//336 QWebPage::networkAccessManager() const
    {59, 720, 147, 1, 0, 0, 20},	//337 QWebPage::setPluginFactory(QWebPluginFactory*)
    {59, 546, 0, 0, Smoke::mf_const, 114, 21},	//338 QWebPage::pluginFactory() const
    {59, 801, 0, 0, Smoke::mf_const, 256, 22},	//339 QWebPage::totalBytes() const
    {59, 246, 0, 0, Smoke::mf_const, 256, 23},	//340 QWebPage::bytesReceived() const
    {59, 396, 0, 0, Smoke::mf_const|Smoke::mf_property, 208, 24},	//341 QWebPage::hasSelection() const
    {59, 628, 0, 0, Smoke::mf_const|Smoke::mf_property, 54, 25},	//342 QWebPage::selectedText() const
    {59, 627, 0, 0, Smoke::mf_const|Smoke::mf_property, 54, 26},	//343 QWebPage::selectedHtml() const
    {59, 204, 149, 1, Smoke::mf_const, 1, 27},	//344 QWebPage::action(QWebPage::WebAction) const
    {59, 810, 151, 2, Smoke::mf_virtual, 0, 28},	//345 QWebPage::triggerAction(QWebPage::WebAction, bool)
    {59, 832, 0, 0, Smoke::mf_const|Smoke::mf_property, 53, 29},	//346 QWebPage::viewportSize() const
    {59, 751, 106, 1, Smoke::mf_const|Smoke::mf_property, 0, 30},	//347 QWebPage::setViewportSize(const QSize&) const
    {59, 829, 106, 1, Smoke::mf_const, 108, 31},	//348 QWebPage::viewportAttributesForSize(const QSize&) const
    {59, 550, 0, 0, Smoke::mf_const|Smoke::mf_property, 53, 32},	//349 QWebPage::preferredContentsSize() const
    {59, 722, 106, 1, Smoke::mf_const|Smoke::mf_property, 0, 33},	//350 QWebPage::setPreferredContentsSize(const QSize&) const
    {59, 630, 154, 1, Smoke::mf_const, 0, 34},	//351 QWebPage::setActualVisibleContentRect(const QRect&) const
    {59, 331, 1, 1, Smoke::mf_virtual, 208, 35},	//352 QWebPage::event(QEvent*)
    {59, 361, 108, 1, 0, 208, 36},	//353 QWebPage::focusNextPrevChild(bool)
    {59, 416, 156, 1, Smoke::mf_const, 66, 37},	//354 QWebPage::inputMethodQuery(Qt::InputMethodQuery) const
    {59, 354, 158, 2, 0, 208, 38},	//355 QWebPage::findText(const QString&, QFlags<QWebPage::FindFlag>)
    {59, 675, 108, 1, Smoke::mf_property, 0, 39},	//356 QWebPage::setForwardUnsupportedContent(bool)
    {59, 374, 0, 0, Smoke::mf_const|Smoke::mf_property, 208, 40},	//357 QWebPage::forwardUnsupportedContent() const
    {59, 686, 161, 1, Smoke::mf_property, 0, 41},	//358 QWebPage::setLinkDelegationPolicy(QWebPage::LinkDelegationPolicy)
    {59, 450, 0, 0, Smoke::mf_const|Smoke::mf_property, 105, 42},	//359 QWebPage::linkDelegationPolicy() const
    {59, 714, 163, 1, Smoke::mf_property, 0, 43},	//360 QWebPage::setPalette(const QPalette&)
    {59, 541, 0, 0, Smoke::mf_const|Smoke::mf_property, 44, 44},	//361 QWebPage::palette() const
    {59, 644, 108, 1, Smoke::mf_property, 0, 45},	//362 QWebPage::setContentEditable(bool)
    {59, 418, 0, 0, Smoke::mf_const|Smoke::mf_property, 208, 46},	//363 QWebPage::isContentEditable() const
    {59, 779, 165, 1, 0, 208, 47},	//364 QWebPage::swallowContextMenuEvent(QContextMenuEvent*)
    {59, 819, 93, 1, 0, 0, 48},	//365 QWebPage::updatePositionDependentActions(const QPoint&)
    {59, 281, 0, 0, 0, 29, 49},	//366 QWebPage::createStandardContextMenu()
    {59, 664, 167, 3, 0, 0, 50},	//367 QWebPage::setFeaturePermission(QWebFrame*, QWebPage::Feature, QWebPage::PermissionPolicy)
    {59, 774, 0, 0, Smoke::mf_const, 57, 51},	//368 QWebPage::supportedContentTypes() const
    {59, 775, 16, 1, Smoke::mf_const, 208, 52},	//369 QWebPage::supportsContentType(const QString&) const
    {59, 335, 171, 3, Smoke::mf_virtual, 208, 53},	//370 QWebPage::extension(QWebPage::Extension, const QWebPage::ExtensionOption*, QWebPage::ExtensionReturn*)
    {59, 777, 175, 1, Smoke::mf_const|Smoke::mf_virtual, 208, 54},	//371 QWebPage::supportsExtension(QWebPage::Extension) const
    {59, 387, 0, 0, Smoke::mf_const, 113, 55},	//372 QWebPage::handle() const
    {59, 759, 0, 0, Smoke::mf_slot, 208, 56},	//373 QWebPage::shouldInterruptJavaScript()
    {59, 466, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 57},	//374 QWebPage::loadStarted()
    {59, 464, 38, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 58},	//375 QWebPage::loadProgress(int)
    {59, 462, 108, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 59},	//376 QWebPage::loadFinished(bool)
    {59, 452, 21, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 60},	//377 QWebPage::linkHovered(const QString&, const QString&, const QString&)
    {59, 765, 16, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 61},	//378 QWebPage::statusBarMessage(const QString&)
    {59, 629, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 62},	//379 QWebPage::selectionChanged()
    {59, 378, 177, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 63},	//380 QWebPage::frameCreated(QWebFrame*)
    {59, 382, 154, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 64},	//381 QWebPage::geometryChangeRequested(const QRect&)
    {59, 590, 154, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 65},	//382 QWebPage::repaintRequested(const QRect&)
    {59, 622, 179, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 66},	//383 QWebPage::scrollRequested(int, int, const QRect&)
    {59, 839, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 67},	//384 QWebPage::windowCloseRequested()
    {59, 561, 177, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 68},	//385 QWebPage::printRequested(QWebFrame*)
    {59, 448, 62, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 69},	//386 QWebPage::linkClicked(const QUrl&)
    {59, 799, 108, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 70},	//387 QWebPage::toolBarVisibilityChangeRequested(bool)
    {59, 767, 108, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 71},	//388 QWebPage::statusBarVisibilityChangeRequested(bool)
    {59, 474, 108, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 72},	//389 QWebPage::menuBarVisibilityChangeRequested(bool)
    {59, 817, 183, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 73},	//390 QWebPage::unsupportedContent(QNetworkReply*)
    {59, 303, 110, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 74},	//391 QWebPage::downloadRequested(const QNetworkRequest&)
    {59, 479, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 75},	//392 QWebPage::microFocusChanged()
    {59, 270, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 76},	//393 QWebPage::contentsChanged()
    {59, 289, 185, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 77},	//394 QWebPage::databaseQuotaExceeded(QWebFrame*, QString)
    {59, 226, 188, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 78},	//395 QWebPage::applicationCacheQuotaExceeded(QWebSecurityOrigin*, quint64)
    {59, 226, 191, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 79},	//396 QWebPage::applicationCacheQuotaExceeded(QWebSecurityOrigin*, quint64, quint64)
    {59, 606, 195, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 80},	//397 QWebPage::saveFrameStateRequested(QWebFrame*, QWebHistoryItem*)
    {59, 604, 177, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 81},	//398 QWebPage::restoreFrameStateRequested(QWebFrame*)
    {59, 831, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 82},	//399 QWebPage::viewportChangeRequested()
    {59, 341, 198, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 83},	//400 QWebPage::featurePermissionRequested(QWebFrame*, QWebPage::Feature)
    {59, 339, 198, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 84},	//401 QWebPage::featurePermissionRequestCanceled(QWebFrame*, QWebPage::Feature)
    {59, 282, 201, 1, Smoke::mf_protected|Smoke::mf_virtual, 94, 85},	//402 QWebPage::createWindow(QWebPage::WebWindowType)
    {59, 279, 203, 4, Smoke::mf_protected|Smoke::mf_virtual, 38, 86},	//403 QWebPage::createPlugin(const QString&, const QUrl&, const QStringList&, const QStringList&)
    {59, 202, 208, 3, Smoke::mf_protected|Smoke::mf_virtual, 208, 87},	//404 QWebPage::acceptNavigationRequest(QWebFrame*, const QNetworkRequest&, QWebPage::NavigationType)
    {59, 253, 212, 2, Smoke::mf_protected|Smoke::mf_virtual, 54, 88},	//405 QWebPage::chooseFile(QWebFrame*, const QString&)
    {59, 430, 212, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 89},	//406 QWebPage::javaScriptAlert(QWebFrame*, const QString&)
    {59, 432, 212, 2, Smoke::mf_protected|Smoke::mf_virtual, 208, 90},	//407 QWebPage::javaScriptConfirm(QWebFrame*, const QString&)
    {59, 436, 215, 4, Smoke::mf_protected|Smoke::mf_virtual, 208, 91},	//408 QWebPage::javaScriptPrompt(QWebFrame*, const QString&, const QString&, QString*)
    {59, 434, 220, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 92},	//409 QWebPage::javaScriptConsoleMessage(const QString&, int, const QString&)
    {59, 824, 62, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 54, 93},	//410 QWebPage::userAgentForUrl(const QUrl&) const
    {59, 802, 10, 1, Smoke::mf_static, 54, 94},	//411 QWebPage::tr(const char*)
    {59, 806, 10, 1, Smoke::mf_static, 54, 95},	//412 QWebPage::trUtf8(const char*)
    {59, 144, 0, 0, Smoke::mf_ctor, 94, 96},	//413 QWebPage::QWebPage()
    {59, 810, 149, 1, 0, 0, 97},	//414 QWebPage::triggerAction(QWebPage::WebAction)
    {59, 354, 16, 1, 0, 208, 98},	//415 QWebPage::findText(const QString&)
    {59, 335, 175, 1, 0, 208, 99},	//416 QWebPage::extension(QWebPage::Extension)
    {59, 335, 224, 2, 0, 208, 100},	//417 QWebPage::extension(QWebPage::Extension, const QWebPage::ExtensionOption*)
    {59, 764, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 212, 101},	//418 QWebPage::staticMetaObject() const
    {59, 104, 0, 0, Smoke::mf_static|Smoke::mf_enum, 106, 102},	//419 QWebPage::NavigationTypeLinkClicked (enum)
    {59, 103, 0, 0, Smoke::mf_static|Smoke::mf_enum, 106, 103},	//420 QWebPage::NavigationTypeFormSubmitted (enum)
    {59, 101, 0, 0, Smoke::mf_static|Smoke::mf_enum, 106, 104},	//421 QWebPage::NavigationTypeBackOrForward (enum)
    {59, 106, 0, 0, Smoke::mf_static|Smoke::mf_enum, 106, 105},	//422 QWebPage::NavigationTypeReload (enum)
    {59, 102, 0, 0, Smoke::mf_static|Smoke::mf_enum, 106, 106},	//423 QWebPage::NavigationTypeFormResubmitted (enum)
    {59, 105, 0, 0, Smoke::mf_static|Smoke::mf_enum, 106, 107},	//424 QWebPage::NavigationTypeOther (enum)
    {59, 107, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 108},	//425 QWebPage::NoWebAction (enum)
    {59, 114, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 109},	//426 QWebPage::OpenLink (enum)
    {59, 115, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 110},	//427 QWebPage::OpenLinkInNewWindow (enum)
    {59, 112, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 111},	//428 QWebPage::OpenFrameInNewWindow (enum)
    {59, 41, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 112},	//429 QWebPage::DownloadLinkToDisk (enum)
    {59, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 113},	//430 QWebPage::CopyLinkToClipboard (enum)
    {59, 113, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 114},	//431 QWebPage::OpenImageInNewWindow (enum)
    {59, 40, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 115},	//432 QWebPage::DownloadImageToDisk (enum)
    {59, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 116},	//433 QWebPage::CopyImageToClipboard (enum)
    {59, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 117},	//434 QWebPage::Back (enum)
    {59, 58, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 118},	//435 QWebPage::Forward (enum)
    {59, 182, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 119},	//436 QWebPage::Stop (enum)
    {59, 154, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 120},	//437 QWebPage::Reload (enum)
    {59, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 121},	//438 QWebPage::Cut (enum)
    {59, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 122},	//439 QWebPage::Copy (enum)
    {59, 119, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 123},	//440 QWebPage::Paste (enum)
    {59, 192, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 124},	//441 QWebPage::Undo (enum)
    {59, 153, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 125},	//442 QWebPage::Redo (enum)
    {59, 92, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 126},	//443 QWebPage::MoveToNextChar (enum)
    {59, 95, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 127},	//444 QWebPage::MoveToPreviousChar (enum)
    {59, 94, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 128},	//445 QWebPage::MoveToNextWord (enum)
    {59, 97, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 129},	//446 QWebPage::MoveToPreviousWord (enum)
    {59, 93, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 130},	//447 QWebPage::MoveToNextLine (enum)
    {59, 96, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 131},	//448 QWebPage::MoveToPreviousLine (enum)
    {59, 100, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 132},	//449 QWebPage::MoveToStartOfLine (enum)
    {59, 91, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 133},	//450 QWebPage::MoveToEndOfLine (enum)
    {59, 98, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 134},	//451 QWebPage::MoveToStartOfBlock (enum)
    {59, 89, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 135},	//452 QWebPage::MoveToEndOfBlock (enum)
    {59, 99, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 136},	//453 QWebPage::MoveToStartOfDocument (enum)
    {59, 90, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 137},	//454 QWebPage::MoveToEndOfDocument (enum)
    {59, 166, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 138},	//455 QWebPage::SelectNextChar (enum)
    {59, 169, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 139},	//456 QWebPage::SelectPreviousChar (enum)
    {59, 168, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 140},	//457 QWebPage::SelectNextWord (enum)
    {59, 171, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 141},	//458 QWebPage::SelectPreviousWord (enum)
    {59, 167, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 142},	//459 QWebPage::SelectNextLine (enum)
    {59, 170, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 143},	//460 QWebPage::SelectPreviousLine (enum)
    {59, 174, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 144},	//461 QWebPage::SelectStartOfLine (enum)
    {59, 165, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 145},	//462 QWebPage::SelectEndOfLine (enum)
    {59, 172, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 146},	//463 QWebPage::SelectStartOfBlock (enum)
    {59, 163, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 147},	//464 QWebPage::SelectEndOfBlock (enum)
    {59, 173, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 148},	//465 QWebPage::SelectStartOfDocument (enum)
    {59, 164, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 149},	//466 QWebPage::SelectEndOfDocument (enum)
    {59, 36, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 150},	//467 QWebPage::DeleteStartOfWord (enum)
    {59, 35, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 151},	//468 QWebPage::DeleteEndOfWord (enum)
    {59, 176, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 152},	//469 QWebPage::SetTextDirectionDefault (enum)
    {59, 177, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 153},	//470 QWebPage::SetTextDirectionLeftToRight (enum)
    {59, 178, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 154},	//471 QWebPage::SetTextDirectionRightToLeft (enum)
    {59, 186, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 155},	//472 QWebPage::ToggleBold (enum)
    {59, 187, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 156},	//473 QWebPage::ToggleItalic (enum)
    {59, 191, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 157},	//474 QWebPage::ToggleUnderline (enum)
    {59, 72, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 158},	//475 QWebPage::InspectElement (enum)
    {59, 70, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 159},	//476 QWebPage::InsertParagraphSeparator (enum)
    {59, 68, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 160},	//477 QWebPage::InsertLineSeparator (enum)
    {59, 162, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 161},	//478 QWebPage::SelectAll (enum)
    {59, 155, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 162},	//479 QWebPage::ReloadAndBypassCache (enum)
    {59, 120, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 163},	//480 QWebPage::PasteAndMatchStyle (enum)
    {59, 156, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 164},	//481 QWebPage::RemoveFormat (enum)
    {59, 188, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 165},	//482 QWebPage::ToggleStrikethrough (enum)
    {59, 189, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 166},	//483 QWebPage::ToggleSubscript (enum)
    {59, 190, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 167},	//484 QWebPage::ToggleSuperscript (enum)
    {59, 71, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 168},	//485 QWebPage::InsertUnorderedList (enum)
    {59, 69, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 169},	//486 QWebPage::InsertOrderedList (enum)
    {59, 65, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 170},	//487 QWebPage::Indent (enum)
    {59, 117, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 171},	//488 QWebPage::Outdent (enum)
    {59, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 172},	//489 QWebPage::AlignCenter (enum)
    {59, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 173},	//490 QWebPage::AlignJustified (enum)
    {59, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 174},	//491 QWebPage::AlignLeft (enum)
    {59, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 175},	//492 QWebPage::AlignRight (enum)
    {59, 183, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 176},	//493 QWebPage::StopScheduledPageRefresh (enum)
    {59, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 177},	//494 QWebPage::CopyImageUrlToClipboard (enum)
    {59, 116, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 178},	//495 QWebPage::OpenLinkInThisWindow (enum)
    {59, 195, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 179},	//496 QWebPage::WebActionCount (enum)
    {59, 54, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 180},	//497 QWebPage::FindBackward (enum)
    {59, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 181},	//498 QWebPage::FindCaseSensitively (enum)
    {59, 56, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 182},	//499 QWebPage::FindWrapsAroundDocument (enum)
    {59, 61, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 183},	//500 QWebPage::HighlightAllOccurrences (enum)
    {59, 39, 0, 0, Smoke::mf_static|Smoke::mf_enum, 105, 184},	//501 QWebPage::DontDelegateLinks (enum)
    {59, 33, 0, 0, Smoke::mf_static|Smoke::mf_enum, 105, 185},	//502 QWebPage::DelegateExternalLinks (enum)
    {59, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 105, 186},	//503 QWebPage::DelegateAllLinks (enum)
    {59, 196, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 187},	//504 QWebPage::WebBrowserWindow (enum)
    {59, 199, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 188},	//505 QWebPage::WebModalDialog (enum)
    {59, 123, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 189},	//506 QWebPage::PermissionUnknown (enum)
    {59, 122, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 190},	//507 QWebPage::PermissionGrantedByUser (enum)
    {59, 121, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 191},	//508 QWebPage::PermissionDeniedByUser (enum)
    {59, 108, 0, 0, Smoke::mf_static|Smoke::mf_enum, 103, 192},	//509 QWebPage::Notifications (enum)
    {59, 60, 0, 0, Smoke::mf_static|Smoke::mf_enum, 103, 193},	//510 QWebPage::Geolocation (enum)
    {59, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 194},	//511 QWebPage::ChooseMultipleFilesExtension (enum)
    {59, 44, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 195},	//512 QWebPage::ErrorPageExtension (enum)
    {59, 152, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 196},	//513 QWebPage::QtNetwork (enum)
    {59, 62, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 197},	//514 QWebPage::Http (enum)
    {59, 198, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 198},	//515 QWebPage::WebKit (enum)
    {59, 857, 0, 0, Smoke::mf_dtor, 0, 199 },	//516 QWebPage::~QWebPage()
    {60, 17, 0, 0, Smoke::mf_ctor, 95, 1},	//517 QWebPage::ChooseMultipleFilesExtensionOption::ChooseMultipleFilesExtensionOption()
    {60, 17, 227, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 95, 2},	//518 QWebPage::ChooseMultipleFilesExtensionOption::ChooseMultipleFilesExtensionOption(const QWebPage::ChooseMultipleFilesExtensionOption&)
    {60, 544, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 83, 3},	//519 QWebPage::ChooseMultipleFilesExtensionOption::parentFrame() const
    {60, 716, 177, 1, Smoke::mf_attribute, 0, 4},	//520 QWebPage::ChooseMultipleFilesExtensionOption::setParentFrame(QWebFrame*)
    {60, 773, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 58, 5},	//521 QWebPage::ChooseMultipleFilesExtensionOption::suggestedFileNames() const
    {60, 737, 229, 1, Smoke::mf_attribute, 0, 6},	//522 QWebPage::ChooseMultipleFilesExtensionOption::setSuggestedFileNames(const QStringList&)
    {60, 842, 0, 0, Smoke::mf_dtor, 0, 7 },	//523 QWebPage::ChooseMultipleFilesExtensionOption::~ChooseMultipleFilesExtensionOption()
    {61, 19, 0, 0, Smoke::mf_ctor, 96, 1},	//524 QWebPage::ChooseMultipleFilesExtensionReturn::ChooseMultipleFilesExtensionReturn()
    {61, 19, 231, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 96, 2},	//525 QWebPage::ChooseMultipleFilesExtensionReturn::ChooseMultipleFilesExtensionReturn(const QWebPage::ChooseMultipleFilesExtensionReturn&)
    {61, 345, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 58, 3},	//526 QWebPage::ChooseMultipleFilesExtensionReturn::fileNames() const
    {61, 668, 229, 1, Smoke::mf_attribute, 0, 4},	//527 QWebPage::ChooseMultipleFilesExtensionReturn::setFileNames(const QStringList&)
    {61, 843, 0, 0, Smoke::mf_dtor, 0, 5 },	//528 QWebPage::ChooseMultipleFilesExtensionReturn::~ChooseMultipleFilesExtensionReturn()
    {62, 45, 0, 0, Smoke::mf_ctor, 98, 1},	//529 QWebPage::ErrorPageExtensionOption::ErrorPageExtensionOption()
    {62, 45, 233, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 98, 2},	//530 QWebPage::ErrorPageExtensionOption::ErrorPageExtensionOption(const QWebPage::ErrorPageExtensionOption&)
    {62, 821, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 65, 3},	//531 QWebPage::ErrorPageExtensionOption::url() const
    {62, 743, 62, 1, Smoke::mf_attribute, 0, 4},	//532 QWebPage::ErrorPageExtensionOption::setUrl(const QUrl&)
    {62, 375, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 83, 5},	//533 QWebPage::ErrorPageExtensionOption::frame() const
    {62, 677, 177, 1, Smoke::mf_attribute, 0, 6},	//534 QWebPage::ErrorPageExtensionOption::setFrame(QWebFrame*)
    {62, 302, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 97, 7},	//535 QWebPage::ErrorPageExtensionOption::domain() const
    {62, 656, 235, 1, Smoke::mf_attribute, 0, 8},	//536 QWebPage::ErrorPageExtensionOption::setDomain(QWebPage::ErrorDomain)
    {62, 327, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 253, 9},	//537 QWebPage::ErrorPageExtensionOption::error() const
    {62, 660, 38, 1, Smoke::mf_attribute, 0, 10},	//538 QWebPage::ErrorPageExtensionOption::setError(int)
    {62, 328, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 55, 11},	//539 QWebPage::ErrorPageExtensionOption::errorString() const
    {62, 662, 16, 1, Smoke::mf_attribute, 0, 12},	//540 QWebPage::ErrorPageExtensionOption::setErrorString(const QString&)
    {62, 844, 0, 0, Smoke::mf_dtor, 0, 13 },	//541 QWebPage::ErrorPageExtensionOption::~ErrorPageExtensionOption()
    {63, 47, 0, 0, Smoke::mf_ctor, 99, 1},	//542 QWebPage::ErrorPageExtensionReturn::ErrorPageExtensionReturn()
    {63, 47, 237, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 99, 2},	//543 QWebPage::ErrorPageExtensionReturn::ErrorPageExtensionReturn(const QWebPage::ErrorPageExtensionReturn&)
    {63, 269, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 55, 3},	//544 QWebPage::ErrorPageExtensionReturn::contentType() const
    {63, 646, 16, 1, Smoke::mf_attribute, 0, 4},	//545 QWebPage::ErrorPageExtensionReturn::setContentType(const QString&)
    {63, 324, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 55, 5},	//546 QWebPage::ErrorPageExtensionReturn::encoding() const
    {63, 658, 16, 1, Smoke::mf_attribute, 0, 6},	//547 QWebPage::ErrorPageExtensionReturn::setEncoding(const QString&)
    {63, 243, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 65, 7},	//548 QWebPage::ErrorPageExtensionReturn::baseUrl() const
    {63, 638, 62, 1, Smoke::mf_attribute, 0, 8},	//549 QWebPage::ErrorPageExtensionReturn::setBaseUrl(const QUrl&)
    {63, 268, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 4, 9},	//550 QWebPage::ErrorPageExtensionReturn::content() const
    {63, 640, 115, 1, Smoke::mf_attribute, 0, 10},	//551 QWebPage::ErrorPageExtensionReturn::setContent(const QByteArray&)
    {63, 845, 0, 0, Smoke::mf_dtor, 0, 11 },	//552 QWebPage::ErrorPageExtensionReturn::~ErrorPageExtensionReturn()
    {64, 49, 0, 0, Smoke::mf_ctor, 101, 1},	//553 QWebPage::ExtensionOption::ExtensionOption()
    {64, 49, 239, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 101, 2},	//554 QWebPage::ExtensionOption::ExtensionOption(const QWebPage::ExtensionOption&)
    {64, 846, 0, 0, Smoke::mf_dtor, 0, 3 },	//555 QWebPage::ExtensionOption::~ExtensionOption()
    {65, 51, 0, 0, Smoke::mf_ctor, 102, 1},	//556 QWebPage::ExtensionReturn::ExtensionReturn()
    {65, 51, 241, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 102, 2},	//557 QWebPage::ExtensionReturn::ExtensionReturn(const QWebPage::ExtensionReturn&)
    {65, 847, 0, 0, Smoke::mf_dtor, 0, 3 },	//558 QWebPage::ExtensionReturn::~ExtensionReturn()
    {66, 193, 0, 0, Smoke::mf_ctor, 110, 1},	//559 QWebPage::ViewportAttributes::ViewportAttributes()
    {66, 193, 243, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 110, 2},	//560 QWebPage::ViewportAttributes::ViewportAttributes(const QWebPage::ViewportAttributes&)
    {66, 522, 243, 1, 0, 109, 3},	//561 QWebPage::ViewportAttributes::operator=(const QWebPage::ViewportAttributes&)
    {66, 413, 0, 0, Smoke::mf_const, 252, 4},	//562 QWebPage::ViewportAttributes::initialScaleFactor() const
    {66, 481, 0, 0, Smoke::mf_const, 252, 5},	//563 QWebPage::ViewportAttributes::minimumScaleFactor() const
    {66, 473, 0, 0, Smoke::mf_const, 252, 6},	//564 QWebPage::ViewportAttributes::maximumScaleFactor() const
    {66, 297, 0, 0, Smoke::mf_const, 252, 7},	//565 QWebPage::ViewportAttributes::devicePixelRatio() const
    {66, 422, 0, 0, Smoke::mf_const, 208, 8},	//566 QWebPage::ViewportAttributes::isUserScalable() const
    {66, 423, 0, 0, Smoke::mf_const, 208, 9},	//567 QWebPage::ViewportAttributes::isValid() const
    {66, 762, 0, 0, Smoke::mf_const, 53, 10},	//568 QWebPage::ViewportAttributes::size() const
    {66, 861, 0, 0, Smoke::mf_dtor, 0, 11 },	//569 QWebPage::ViewportAttributes::~ViewportAttributes()
    {68, 477, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 213, 1},	//570 QWebPluginFactory::metaObject() const
    {68, 566, 10, 1, Smoke::mf_virtual, 257, 2},	//571 QWebPluginFactory::qt_metacast(const char*)
    {68, 802, 51, 2, Smoke::mf_static, 54, 3},	//572 QWebPluginFactory::tr(const char*, const char*)
    {68, 806, 51, 2, Smoke::mf_static, 54, 4},	//573 QWebPluginFactory::trUtf8(const char*, const char*)
    {68, 802, 54, 3, Smoke::mf_static, 54, 5},	//574 QWebPluginFactory::tr(const char*, const char*, int)
    {68, 806, 54, 3, Smoke::mf_static, 54, 6},	//575 QWebPluginFactory::trUtf8(const char*, const char*, int)
    {68, 564, 58, 3, Smoke::mf_virtual, 253, 7},	//576 QWebPluginFactory::qt_metacall(QMetaObject::Call, int, void**)
    {68, 146, 125, 1, Smoke::mf_ctor, 114, 8},	//577 QWebPluginFactory::QWebPluginFactory(QObject*)
    {68, 547, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 27, 9},	//578 QWebPluginFactory::plugins() const [pure virtual]
    {68, 568, 0, 0, Smoke::mf_virtual, 0, 10},	//579 QWebPluginFactory::refreshPlugins()
    {68, 277, 203, 4, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 38, 11},	//580 QWebPluginFactory::create(const QString&, const QUrl&, const QStringList&, const QStringList&) const [pure virtual]
    {68, 335, 245, 3, Smoke::mf_virtual, 208, 12},	//581 QWebPluginFactory::extension(QWebPluginFactory::Extension, const QWebPluginFactory::ExtensionOption*, QWebPluginFactory::ExtensionReturn*)
    {68, 777, 249, 1, Smoke::mf_const|Smoke::mf_virtual, 208, 13},	//582 QWebPluginFactory::supportsExtension(QWebPluginFactory::Extension) const
    {68, 802, 10, 1, Smoke::mf_static, 54, 14},	//583 QWebPluginFactory::tr(const char*)
    {68, 806, 10, 1, Smoke::mf_static, 54, 15},	//584 QWebPluginFactory::trUtf8(const char*)
    {68, 146, 0, 0, Smoke::mf_ctor, 114, 16},	//585 QWebPluginFactory::QWebPluginFactory()
    {68, 335, 249, 1, 0, 208, 17},	//586 QWebPluginFactory::extension(QWebPluginFactory::Extension)
    {68, 335, 251, 2, 0, 208, 18},	//587 QWebPluginFactory::extension(QWebPluginFactory::Extension, const QWebPluginFactory::ExtensionOption*)
    {68, 764, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 212, 19},	//588 QWebPluginFactory::staticMetaObject() const
    {68, 858, 0, 0, Smoke::mf_dtor, 0, 20 },	//589 QWebPluginFactory::~QWebPluginFactory()
    {69, 49, 0, 0, Smoke::mf_ctor, 116, 1},	//590 QWebPluginFactory::ExtensionOption::ExtensionOption()
    {69, 49, 254, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 116, 2},	//591 QWebPluginFactory::ExtensionOption::ExtensionOption(const QWebPluginFactory::ExtensionOption&)
    {69, 846, 0, 0, Smoke::mf_dtor, 0, 3 },	//592 QWebPluginFactory::ExtensionOption::~ExtensionOption()
    {70, 51, 0, 0, Smoke::mf_ctor, 117, 1},	//593 QWebPluginFactory::ExtensionReturn::ExtensionReturn()
    {70, 51, 256, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 117, 2},	//594 QWebPluginFactory::ExtensionReturn::ExtensionReturn(const QWebPluginFactory::ExtensionReturn&)
    {70, 847, 0, 0, Smoke::mf_dtor, 0, 3 },	//595 QWebPluginFactory::ExtensionReturn::~ExtensionReturn()
    {71, 524, 258, 1, Smoke::mf_const, 208, 1},	//596 QWebPluginFactory::MimeType::operator==(const QWebPluginFactory::MimeType&) const
    {71, 500, 258, 1, Smoke::mf_const, 208, 2},	//597 QWebPluginFactory::MimeType::operator!=(const QWebPluginFactory::MimeType&) const
    {71, 83, 0, 0, Smoke::mf_ctor, 119, 3},	//598 QWebPluginFactory::MimeType::MimeType()
    {71, 83, 258, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 119, 4},	//599 QWebPluginFactory::MimeType::MimeType(const QWebPluginFactory::MimeType&)
    {71, 492, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 55, 5},	//600 QWebPluginFactory::MimeType::name() const
    {71, 696, 16, 1, Smoke::mf_attribute, 0, 6},	//601 QWebPluginFactory::MimeType::setName(const QString&)
    {71, 295, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 55, 7},	//602 QWebPluginFactory::MimeType::description() const
    {71, 654, 16, 1, Smoke::mf_attribute, 0, 8},	//603 QWebPluginFactory::MimeType::setDescription(const QString&)
    {71, 343, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 58, 9},	//604 QWebPluginFactory::MimeType::fileExtensions() const
    {71, 666, 229, 1, Smoke::mf_attribute, 0, 10},	//605 QWebPluginFactory::MimeType::setFileExtensions(const QStringList&)
    {71, 848, 0, 0, Smoke::mf_dtor, 0, 11 },	//606 QWebPluginFactory::MimeType::~MimeType()
    {72, 124, 0, 0, Smoke::mf_ctor, 121, 1},	//607 QWebPluginFactory::Plugin::Plugin()
    {72, 124, 260, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 121, 2},	//608 QWebPluginFactory::Plugin::Plugin(const QWebPluginFactory::Plugin&)
    {72, 492, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 55, 3},	//609 QWebPluginFactory::Plugin::name() const
    {72, 696, 16, 1, Smoke::mf_attribute, 0, 4},	//610 QWebPluginFactory::Plugin::setName(const QString&)
    {72, 295, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 55, 5},	//611 QWebPluginFactory::Plugin::description() const
    {72, 654, 16, 1, Smoke::mf_attribute, 0, 6},	//612 QWebPluginFactory::Plugin::setDescription(const QString&)
    {72, 480, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 26, 7},	//613 QWebPluginFactory::Plugin::mimeTypes() const
    {72, 694, 262, 1, Smoke::mf_attribute, 0, 8},	//614 QWebPluginFactory::Plugin::setMimeTypes(const QList<QWebPluginFactory::MimeType>&)
    {72, 849, 0, 0, Smoke::mf_dtor, 0, 9 },	//615 QWebPluginFactory::Plugin::~Plugin()
    {73, 216, 0, 0, Smoke::mf_static, 28, 1},	//616 QWebSecurityOrigin::allOrigins()
    {73, 211, 16, 1, Smoke::mf_static, 0, 2},	//617 QWebSecurityOrigin::addLocalScheme(const QString&)
    {73, 581, 16, 1, Smoke::mf_static, 0, 3},	//618 QWebSecurityOrigin::removeLocalScheme(const QString&)
    {73, 468, 0, 0, Smoke::mf_static, 57, 4},	//619 QWebSecurityOrigin::localSchemes()
    {73, 608, 0, 0, Smoke::mf_const, 54, 5},	//620 QWebSecurityOrigin::scheme() const
    {73, 405, 0, 0, Smoke::mf_const, 54, 6},	//621 QWebSecurityOrigin::host() const
    {73, 548, 0, 0, Smoke::mf_const, 253, 7},	//622 QWebSecurityOrigin::port() const
    {73, 291, 0, 0, Smoke::mf_const, 254, 8},	//623 QWebSecurityOrigin::databaseUsage() const
    {73, 288, 0, 0, Smoke::mf_const, 254, 9},	//624 QWebSecurityOrigin::databaseQuota() const
    {73, 648, 264, 1, 0, 0, 10},	//625 QWebSecurityOrigin::setDatabaseQuota(long long)
    {73, 632, 264, 1, 0, 0, 11},	//626 QWebSecurityOrigin::setApplicationCacheQuota(long long)
    {73, 292, 0, 0, Smoke::mf_const, 22, 12},	//627 QWebSecurityOrigin::databases() const
    {73, 148, 266, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 124, 13},	//628 QWebSecurityOrigin::QWebSecurityOrigin(const QWebSecurityOrigin&)
    {73, 522, 266, 1, 0, 123, 14},	//629 QWebSecurityOrigin::operator=(const QWebSecurityOrigin&)
    {73, 859, 0, 0, Smoke::mf_dtor, 0, 15 },	//630 QWebSecurityOrigin::~QWebSecurityOrigin()
    {74, 384, 0, 0, Smoke::mf_static, 125, 1},	//631 QWebSettings::globalSettings()
    {74, 671, 268, 2, 0, 0, 2},	//632 QWebSettings::setFontFamily(QWebSettings::FontFamily, const QString&)
    {74, 366, 271, 1, Smoke::mf_const, 54, 3},	//633 QWebSettings::fontFamily(QWebSettings::FontFamily) const
    {74, 598, 271, 1, 0, 0, 4},	//634 QWebSettings::resetFontFamily(QWebSettings::FontFamily)
    {74, 673, 273, 2, 0, 0, 5},	//635 QWebSettings::setFontSize(QWebSettings::FontSize, int)
    {74, 368, 276, 1, Smoke::mf_const, 253, 6},	//636 QWebSettings::fontSize(QWebSettings::FontSize) const
    {74, 600, 276, 1, 0, 0, 7},	//637 QWebSettings::resetFontSize(QWebSettings::FontSize)
    {74, 634, 278, 2, 0, 0, 8},	//638 QWebSettings::setAttribute(QWebSettings::WebAttribute, bool)
    {74, 784, 281, 1, Smoke::mf_const, 208, 9},	//639 QWebSettings::testAttribute(QWebSettings::WebAttribute) const
    {74, 596, 281, 1, 0, 0, 10},	//640 QWebSettings::resetAttribute(QWebSettings::WebAttribute)
    {74, 747, 62, 1, 0, 0, 11},	//641 QWebSettings::setUserStyleSheetUrl(const QUrl&)
    {74, 827, 0, 0, Smoke::mf_const, 64, 12},	//642 QWebSettings::userStyleSheetUrl() const
    {74, 652, 16, 1, 0, 0, 13},	//643 QWebSettings::setDefaultTextEncoding(const QString&)
    {74, 294, 0, 0, Smoke::mf_const, 54, 14},	//644 QWebSettings::defaultTextEncoding() const
    {74, 682, 16, 1, Smoke::mf_static, 0, 15},	//645 QWebSettings::setIconDatabasePath(const QString&)
    {74, 408, 0, 0, Smoke::mf_static, 54, 16},	//646 QWebSettings::iconDatabasePath()
    {74, 257, 0, 0, Smoke::mf_static, 0, 17},	//647 QWebSettings::clearIconDatabase()
    {74, 409, 62, 1, Smoke::mf_static, 19, 18},	//648 QWebSettings::iconForUrl(const QUrl&)
    {74, 754, 283, 2, Smoke::mf_static, 0, 19},	//649 QWebSettings::setWebGraphic(QWebSettings::WebGraphic, const QPixmap&)
    {74, 834, 286, 1, Smoke::mf_static, 45, 20},	//650 QWebSettings::webGraphic(QWebSettings::WebGraphic)
    {74, 692, 38, 1, Smoke::mf_static, 0, 21},	//651 QWebSettings::setMaximumPagesInCache(int)
    {74, 472, 0, 0, Smoke::mf_static, 253, 22},	//652 QWebSettings::maximumPagesInCache()
    {74, 700, 288, 3, Smoke::mf_static, 0, 23},	//653 QWebSettings::setObjectCacheCapacities(int, int, int)
    {74, 704, 16, 1, Smoke::mf_static, 0, 24},	//654 QWebSettings::setOfflineStoragePath(const QString&)
    {74, 497, 0, 0, Smoke::mf_static, 54, 25},	//655 QWebSettings::offlineStoragePath()
    {74, 702, 264, 1, Smoke::mf_static, 0, 26},	//656 QWebSettings::setOfflineStorageDefaultQuota(long long)
    {74, 496, 0, 0, Smoke::mf_static, 254, 27},	//657 QWebSettings::offlineStorageDefaultQuota()
    {74, 706, 16, 1, Smoke::mf_static, 0, 28},	//658 QWebSettings::setOfflineWebApplicationCachePath(const QString&)
    {74, 498, 0, 0, Smoke::mf_static, 54, 29},	//659 QWebSettings::offlineWebApplicationCachePath()
    {74, 708, 264, 1, Smoke::mf_static, 0, 30},	//660 QWebSettings::setOfflineWebApplicationCacheQuota(long long)
    {74, 499, 0, 0, Smoke::mf_static, 254, 31},	//661 QWebSettings::offlineWebApplicationCacheQuota()
    {74, 688, 16, 1, 0, 0, 32},	//662 QWebSettings::setLocalStoragePath(const QString&)
    {74, 469, 0, 0, Smoke::mf_const, 54, 33},	//663 QWebSettings::localStoragePath() const
    {74, 258, 0, 0, Smoke::mf_static, 0, 34},	//664 QWebSettings::clearMemoryCaches()
    {74, 314, 16, 1, Smoke::mf_static, 0, 35},	//665 QWebSettings::enablePersistentStorage(const QString&)
    {74, 741, 292, 1, 0, 0, 36},	//666 QWebSettings::setThirdPartyCookiePolicy(QWebSettings::ThirdPartyCookiePolicy)
    {74, 787, 0, 0, Smoke::mf_const, 128, 37},	//667 QWebSettings::thirdPartyCookiePolicy() const
    {74, 387, 0, 0, Smoke::mf_const, 131, 38},	//668 QWebSettings::handle() const
    {74, 314, 0, 0, Smoke::mf_static, 0, 39},	//669 QWebSettings::enablePersistentStorage()
    {74, 181, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 40},	//670 QWebSettings::StandardFont (enum)
    {74, 57, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 41},	//671 QWebSettings::FixedFont (enum)
    {74, 175, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 42},	//672 QWebSettings::SerifFont (enum)
    {74, 157, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 43},	//673 QWebSettings::SansSerifFont (enum)
    {74, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 44},	//674 QWebSettings::CursiveFont (enum)
    {74, 53, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 45},	//675 QWebSettings::FantasyFont (enum)
    {74, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 46},	//676 QWebSettings::AutoLoadImages (enum)
    {74, 77, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 47},	//677 QWebSettings::JavascriptEnabled (enum)
    {74, 73, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 48},	//678 QWebSettings::JavaEnabled (enum)
    {74, 126, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 49},	//679 QWebSettings::PluginsEnabled (enum)
    {74, 128, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 50},	//680 QWebSettings::PrivateBrowsingEnabled (enum)
    {74, 76, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 51},	//681 QWebSettings::JavascriptCanOpenWindows (enum)
    {74, 74, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 52},	//682 QWebSettings::JavascriptCanAccessClipboard (enum)
    {74, 37, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 53},	//683 QWebSettings::DeveloperExtrasEnabled (enum)
    {74, 78, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 54},	//684 QWebSettings::LinksIncludedInFocusChain (enum)
    {74, 201, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 55},	//685 QWebSettings::ZoomTextOnly (enum)
    {74, 127, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 56},	//686 QWebSettings::PrintElementBackgrounds (enum)
    {74, 110, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 57},	//687 QWebSettings::OfflineStorageDatabaseEnabled (enum)
    {74, 111, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 58},	//688 QWebSettings::OfflineWebApplicationCacheEnabled (enum)
    {74, 82, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 59},	//689 QWebSettings::LocalStorageEnabled (enum)
    {74, 81, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 60},	//690 QWebSettings::LocalStorageDatabaseEnabled (enum)
    {74, 80, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 61},	//691 QWebSettings::LocalContentCanAccessRemoteUrls (enum)
    {74, 38, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 62},	//692 QWebSettings::DnsPrefetchEnabled (enum)
    {74, 200, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 63},	//693 QWebSettings::XSSAuditingEnabled (enum)
    {74, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 64},	//694 QWebSettings::AcceleratedCompositingEnabled (enum)
    {74, 180, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 65},	//695 QWebSettings::SpatialNavigationEnabled (enum)
    {74, 79, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 66},	//696 QWebSettings::LocalContentCanAccessFileUrls (enum)
    {74, 185, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 67},	//697 QWebSettings::TiledBackingStoreEnabled (enum)
    {74, 59, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 68},	//698 QWebSettings::FrameFlatteningEnabled (enum)
    {74, 179, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 69},	//699 QWebSettings::SiteSpecificQuirksEnabled (enum)
    {74, 75, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 70},	//700 QWebSettings::JavascriptCanCloseWindows (enum)
    {74, 197, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 71},	//701 QWebSettings::WebGLEnabled (enum)
    {74, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 72},	//702 QWebSettings::CSSRegionsEnabled (enum)
    {74, 63, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 73},	//703 QWebSettings::HyperlinkAuditingEnabled (enum)
    {74, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 74},	//704 QWebSettings::CSSGridLayoutEnabled (enum)
    {74, 158, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 75},	//705 QWebSettings::ScrollAnimatorEnabled (enum)
    {74, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 76},	//706 QWebSettings::CaretBrowsingEnabled (enum)
    {74, 109, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 77},	//707 QWebSettings::NotificationsEnabled (enum)
    {74, 87, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 78},	//708 QWebSettings::MissingImageGraphic (enum)
    {74, 88, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 79},	//709 QWebSettings::MissingPluginGraphic (enum)
    {74, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 80},	//710 QWebSettings::DefaultFrameIconGraphic (enum)
    {74, 184, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 81},	//711 QWebSettings::TextAreaSizeGripCornerGraphic (enum)
    {74, 34, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 82},	//712 QWebSettings::DeleteButtonGraphic (enum)
    {74, 67, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 83},	//713 QWebSettings::InputSpeechButtonGraphic (enum)
    {74, 160, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 84},	//714 QWebSettings::SearchCancelButtonGraphic (enum)
    {74, 161, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 85},	//715 QWebSettings::SearchCancelButtonPressedGraphic (enum)
    {74, 85, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 86},	//716 QWebSettings::MinimumFontSize (enum)
    {74, 86, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 87},	//717 QWebSettings::MinimumLogicalFontSize (enum)
    {74, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 88},	//718 QWebSettings::DefaultFontSize (enum)
    {74, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 89},	//719 QWebSettings::DefaultFixedFontSize (enum)
    {74, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 90},	//720 QWebSettings::AlwaysAllowThirdPartyCookies (enum)
    {74, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 91},	//721 QWebSettings::AlwaysBlockThirdPartyCookies (enum)
    {74, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 92},	//722 QWebSettings::AllowThirdPartyWithExistingCookies (enum)
    {76, 477, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 213, 1},	//723 QWebView::metaObject() const
    {76, 566, 10, 1, Smoke::mf_virtual, 257, 2},	//724 QWebView::qt_metacast(const char*)
    {76, 802, 51, 2, Smoke::mf_static, 54, 3},	//725 QWebView::tr(const char*, const char*)
    {76, 806, 51, 2, Smoke::mf_static, 54, 4},	//726 QWebView::trUtf8(const char*, const char*)
    {76, 802, 54, 3, Smoke::mf_static, 54, 5},	//727 QWebView::tr(const char*, const char*, int)
    {76, 806, 54, 3, Smoke::mf_static, 54, 6},	//728 QWebView::trUtf8(const char*, const char*, int)
    {76, 564, 58, 3, Smoke::mf_virtual, 253, 7},	//729 QWebView::qt_metacall(QMetaObject::Call, int, void**)
    {76, 150, 133, 1, Smoke::mf_ctor, 132, 8},	//730 QWebView::QWebView(QWidget*)
    {76, 534, 0, 0, Smoke::mf_const, 94, 9},	//731 QWebView::page() const
    {76, 712, 135, 1, 0, 0, 10},	//732 QWebView::setPage(QWebPage*)
    {76, 458, 62, 1, 0, 0, 11},	//733 QWebView::load(const QUrl&)
    {76, 458, 64, 3, 0, 0, 12},	//734 QWebView::load(const QNetworkRequest&, QNetworkAccessManager::Operation, const QByteArray&)
    {76, 679, 68, 2, 0, 0, 13},	//735 QWebView::setHtml(const QString&, const QUrl&)
    {76, 640, 71, 3, 0, 0, 14},	//736 QWebView::setContent(const QByteArray&, const QString&, const QUrl&)
    {76, 400, 0, 0, Smoke::mf_const, 85, 15},	//737 QWebView::history() const
    {76, 758, 0, 0, Smoke::mf_const, 125, 16},	//738 QWebView::settings() const
    {76, 789, 0, 0, Smoke::mf_const|Smoke::mf_property, 54, 17},	//739 QWebView::title() const
    {76, 743, 62, 1, Smoke::mf_property, 0, 18},	//740 QWebView::setUrl(const QUrl&)
    {76, 821, 0, 0, Smoke::mf_const|Smoke::mf_property, 64, 19},	//741 QWebView::url() const
    {76, 406, 0, 0, Smoke::mf_const|Smoke::mf_property, 19, 20},	//742 QWebView::icon() const
    {76, 396, 0, 0, Smoke::mf_const|Smoke::mf_property, 208, 21},	//743 QWebView::hasSelection() const
    {76, 628, 0, 0, Smoke::mf_const|Smoke::mf_property, 54, 22},	//744 QWebView::selectedText() const
    {76, 627, 0, 0, Smoke::mf_const|Smoke::mf_property, 54, 23},	//745 QWebView::selectedHtml() const
    {76, 535, 149, 1, Smoke::mf_const, 1, 24},	//746 QWebView::pageAction(QWebPage::WebAction) const
    {76, 813, 151, 2, 0, 0, 25},	//747 QWebView::triggerPageAction(QWebPage::WebAction, bool)
    {76, 420, 0, 0, Smoke::mf_const|Smoke::mf_property, 208, 26},	//748 QWebView::isModified() const
    {76, 416, 156, 1, Smoke::mf_const|Smoke::mf_virtual, 66, 27},	//749 QWebView::inputMethodQuery(Qt::InputMethodQuery) const
    {76, 763, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 53, 28},	//750 QWebView::sizeHint() const
    {76, 841, 0, 0, Smoke::mf_const, 252, 29},	//751 QWebView::zoomFactor() const
    {76, 756, 102, 1, 0, 0, 30},	//752 QWebView::setZoomFactor(double)
    {76, 739, 102, 1, 0, 0, 31},	//753 QWebView::setTextSizeMultiplier(double)
    {76, 786, 0, 0, Smoke::mf_const, 252, 32},	//754 QWebView::textSizeMultiplier() const
    {76, 588, 0, 0, Smoke::mf_const, 15, 33},	//755 QWebView::renderHints() const
    {76, 727, 294, 1, 0, 0, 34},	//756 QWebView::setRenderHints(QFlags<QPainter::RenderHint>)
    {76, 724, 296, 2, 0, 0, 35},	//757 QWebView::setRenderHint(QPainter::RenderHint, bool)
    {76, 354, 158, 2, 0, 208, 36},	//758 QWebView::findText(const QString&, QFlags<QWebPage::FindFlag>)
    {76, 331, 1, 1, Smoke::mf_virtual, 208, 37},	//759 QWebView::event(QEvent*)
    {76, 769, 0, 0, Smoke::mf_slot, 0, 38},	//760 QWebView::stop()
    {76, 239, 0, 0, Smoke::mf_slot, 0, 39},	//761 QWebView::back()
    {76, 370, 0, 0, Smoke::mf_slot, 0, 40},	//762 QWebView::forward()
    {76, 569, 0, 0, Smoke::mf_slot, 0, 41},	//763 QWebView::reload()
    {76, 559, 104, 1, Smoke::mf_const|Smoke::mf_slot, 0, 42},	//764 QWebView::print(QPrinter*) const
    {76, 466, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 43},	//765 QWebView::loadStarted()
    {76, 464, 38, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 44},	//766 QWebView::loadProgress(int)
    {76, 462, 108, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 45},	//767 QWebView::loadFinished(bool)
    {76, 790, 16, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 46},	//768 QWebView::titleChanged(const QString&)
    {76, 765, 16, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 47},	//769 QWebView::statusBarMessage(const QString&)
    {76, 448, 62, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 48},	//770 QWebView::linkClicked(const QUrl&)
    {76, 629, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 49},	//771 QWebView::selectionChanged()
    {76, 407, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 50},	//772 QWebView::iconChanged()
    {76, 822, 62, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 51},	//773 QWebView::urlChanged(const QUrl&)
    {76, 602, 137, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 52},	//774 QWebView::resizeEvent(QResizeEvent*)
    {76, 539, 299, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 53},	//775 QWebView::paintEvent(QPaintEvent*)
    {76, 282, 201, 1, Smoke::mf_protected|Smoke::mf_virtual, 132, 54},	//776 QWebView::createWindow(QWebPage::WebWindowType)
    {76, 249, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 55},	//777 QWebView::changeEvent(QEvent*)
    {76, 485, 301, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 56},	//778 QWebView::mouseMoveEvent(QMouseEvent*)
    {76, 487, 301, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 57},	//779 QWebView::mousePressEvent(QMouseEvent*)
    {76, 483, 301, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 58},	//780 QWebView::mouseDoubleClickEvent(QMouseEvent*)
    {76, 489, 301, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 59},	//781 QWebView::mouseReleaseEvent(QMouseEvent*)
    {76, 274, 165, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 60},	//782 QWebView::contextMenuEvent(QContextMenuEvent*)
    {76, 836, 303, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 61},	//783 QWebView::wheelEvent(QWheelEvent*)
    {76, 439, 305, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 62},	//784 QWebView::keyPressEvent(QKeyEvent*)
    {76, 441, 305, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 63},	//785 QWebView::keyReleaseEvent(QKeyEvent*)
    {76, 305, 307, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 64},	//786 QWebView::dragEnterEvent(QDragEnterEvent*)
    {76, 307, 309, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 65},	//787 QWebView::dragLeaveEvent(QDragLeaveEvent*)
    {76, 309, 311, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 66},	//788 QWebView::dragMoveEvent(QDragMoveEvent*)
    {76, 311, 313, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 67},	//789 QWebView::dropEvent(QDropEvent*)
    {76, 359, 315, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 68},	//790 QWebView::focusInEvent(QFocusEvent*)
    {76, 363, 315, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 69},	//791 QWebView::focusOutEvent(QFocusEvent*)
    {76, 414, 317, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 70},	//792 QWebView::inputMethodEvent(QInputMethodEvent*)
    {76, 361, 108, 1, Smoke::mf_protected|Smoke::mf_virtual, 208, 71},	//793 QWebView::focusNextPrevChild(bool)
    {76, 802, 10, 1, Smoke::mf_static, 54, 72},	//794 QWebView::tr(const char*)
    {76, 806, 10, 1, Smoke::mf_static, 54, 73},	//795 QWebView::trUtf8(const char*)
    {76, 150, 0, 0, Smoke::mf_ctor, 132, 74},	//796 QWebView::QWebView()
    {76, 458, 110, 1, 0, 0, 75},	//797 QWebView::load(const QNetworkRequest&)
    {76, 458, 112, 2, 0, 0, 76},	//798 QWebView::load(const QNetworkRequest&, QNetworkAccessManager::Operation)
    {76, 679, 16, 1, 0, 0, 77},	//799 QWebView::setHtml(const QString&)
    {76, 640, 115, 1, 0, 0, 78},	//800 QWebView::setContent(const QByteArray&)
    {76, 640, 117, 2, 0, 0, 79},	//801 QWebView::setContent(const QByteArray&, const QString&)
    {76, 813, 149, 1, 0, 0, 80},	//802 QWebView::triggerPageAction(QWebPage::WebAction)
    {76, 724, 319, 1, 0, 0, 81},	//803 QWebView::setRenderHint(QPainter::RenderHint)
    {76, 354, 16, 1, 0, 208, 82},	//804 QWebView::findText(const QString&)
    {76, 764, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 212, 83},	//805 QWebView::staticMetaObject() const
    {76, 860, 0, 0, Smoke::mf_dtor, 0, 84 },	//806 QWebView::~QWebView()
    {78, 296, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 253, 0},	//807 QWidget::devType() const
    {78, 753, 108, 1, Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//808 QWidget::setVisible(bool)
    {78, 482, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 53, 0},	//809 QWidget::minimumSizeHint() const
    {78, 397, 38, 1, Smoke::mf_const|Smoke::mf_virtual, 253, 0},	//810 QWidget::heightForWidth(int) const
    {78, 538, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 40, 0},	//811 QWidget::paintEngine() const
    {78, 487, 301, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//812 QWidget::mousePressEvent(QMouseEvent*)
    {78, 489, 301, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//813 QWidget::mouseReleaseEvent(QMouseEvent*)
    {78, 483, 301, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//814 QWidget::mouseDoubleClickEvent(QMouseEvent*)
    {78, 485, 301, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//815 QWidget::mouseMoveEvent(QMouseEvent*)
    {78, 836, 303, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//816 QWidget::wheelEvent(QWheelEvent*)
    {78, 439, 305, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//817 QWidget::keyPressEvent(QKeyEvent*)
    {78, 441, 305, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//818 QWidget::keyReleaseEvent(QKeyEvent*)
    {78, 359, 315, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//819 QWidget::focusInEvent(QFocusEvent*)
    {78, 363, 315, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//820 QWidget::focusOutEvent(QFocusEvent*)
    {78, 326, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//821 QWidget::enterEvent(QEvent*)
    {78, 447, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//822 QWidget::leaveEvent(QEvent*)
    {78, 539, 299, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//823 QWidget::paintEvent(QPaintEvent*)
    {78, 491, 321, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//824 QWidget::moveEvent(QMoveEvent*)
    {78, 260, 143, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//825 QWidget::closeEvent(QCloseEvent*)
    {78, 274, 165, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//826 QWidget::contextMenuEvent(QContextMenuEvent*)
    {78, 781, 323, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//827 QWidget::tabletEvent(QTabletEvent*)
    {78, 206, 325, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//828 QWidget::actionEvent(QActionEvent*)
    {78, 305, 307, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//829 QWidget::dragEnterEvent(QDragEnterEvent*)
    {78, 309, 311, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//830 QWidget::dragMoveEvent(QDragMoveEvent*)
    {78, 307, 309, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//831 QWidget::dragLeaveEvent(QDragLeaveEvent*)
    {78, 311, 313, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//832 QWidget::dropEvent(QDropEvent*)
    {78, 760, 139, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//833 QWidget::showEvent(QShowEvent*)
    {78, 398, 141, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//834 QWidget::hideEvent(QHideEvent*)
    {78, 840, 327, 1, Smoke::mf_protected|Smoke::mf_virtual, 208, 0},	//835 QWidget::x11Event(_XEvent*)
    {78, 249, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//836 QWidget::changeEvent(QEvent*)
    {78, 478, 329, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 253, 0},	//837 QWidget::metric(QPaintDevice::PaintDeviceMetric) const
    {78, 414, 317, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//838 QWidget::inputMethodEvent(QInputMethodEvent*)
    {78, 416, 156, 1, Smoke::mf_const|Smoke::mf_virtual, 66, 0},	//839 QWidget::inputMethodQuery(Qt::InputMethodQuery) const
    {78, 361, 108, 1, Smoke::mf_protected|Smoke::mf_virtual, 208, 0},	//840 QWidget::focusNextPrevChild(bool)
    {78, 770, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//841 QWidget::styleChange(QStyle&)
    {78, 316, 108, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//842 QWidget::enabledChange(bool)
    {78, 542, 163, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//843 QWidget::paletteChange(const QPalette&)
    {78, 365, 333, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//844 QWidget::fontChange(const QFont&)
    {78, 838, 108, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//845 QWidget::windowActivationChange(bool)
    {78, 443, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//846 QWidget::languageChange()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    158,  // QWebFrame::load(const QUrl&)
    220,  // QWebFrame::load(const QNetworkRequest&)
    0,
    105,  // QWebElementCollection::begin() const
    109,  // QWebElementCollection::begin()
    0,
    106,  // QWebElementCollection::end() const
    110,  // QWebElementCollection::end()
    0,
    733,  // QWebView::load(const QUrl&)
    797,  // QWebView::load(const QNetworkRequest&)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {48, 130, 8},	// QWebDatabase::QWebDatabase#
    {48, 299, 11},	// QWebDatabase::displayName
    {48, 334, 12},	// QWebDatabase::expectedSize
    {48, 344, 14},	// QWebDatabase::fileName
    {48, 492, 10},	// QWebDatabase::name
    {48, 523, 9},	// QWebDatabase::operator=#
    {48, 532, 15},	// QWebDatabase::origin
    {48, 571, 17},	// QWebDatabase::removeAllDatabases
    {48, 579, 16},	// QWebDatabase::removeDatabase#
    {48, 762, 13},	// QWebDatabase::size
    {48, 850, 18},	// QWebDatabase::~QWebDatabase
    {49, 15, 89},	// QWebElement::CascadedStyle
    {49, 21, 90},	// QWebElement::ComputedStyle
    {49, 66, 88},	// QWebElement::InlineStyle
    {49, 131, 19},	// QWebElement::QWebElement
    {49, 132, 20},	// QWebElement::QWebElement#
    {49, 208, 45},	// QWebElement::addClass$
    {49, 221, 63},	// QWebElement::appendInside#
    {49, 222, 62},	// QWebElement::appendInside$
    {49, 224, 67},	// QWebElement::appendOutside#
    {49, 225, 66},	// QWebElement::appendOutside$
    {49, 232, 85},	// QWebElement::attribute$
    {49, 233, 35},	// QWebElement::attribute$$
    {49, 235, 86},	// QWebElement::attributeNS$$
    {49, 236, 36},	// QWebElement::attributeNS$$$
    {49, 237, 87},	// QWebElement::attributeNames
    {49, 238, 42},	// QWebElement::attributeNames$
    {49, 255, 43},	// QWebElement::classes
    {49, 259, 76},	// QWebElement::clone
    {49, 300, 60},	// QWebElement::document
    {49, 318, 70},	// QWebElement::encloseContentsWith#
    {49, 319, 71},	// QWebElement::encloseContentsWith$
    {49, 321, 73},	// QWebElement::encloseWith#
    {49, 322, 72},	// QWebElement::encloseWith$
    {49, 330, 80},	// QWebElement::evaluateJavaScript$
    {49, 347, 25},	// QWebElement::findAll$
    {49, 351, 26},	// QWebElement::findFirst$
    {49, 358, 56},	// QWebElement::firstChild
    {49, 381, 50},	// QWebElement::geometry
    {49, 389, 37},	// QWebElement::hasAttribute$
    {49, 391, 38},	// QWebElement::hasAttributeNS$$
    {49, 392, 41},	// QWebElement::hasAttributes
    {49, 394, 44},	// QWebElement::hasClass$
    {49, 395, 48},	// QWebElement::hasFocus
    {49, 421, 24},	// QWebElement::isNull
    {49, 445, 57},	// QWebElement::lastChild
    {49, 467, 53},	// QWebElement::localName
    {49, 493, 54},	// QWebElement::namespaceUri
    {49, 495, 58},	// QWebElement::nextSibling
    {49, 501, 23},	// QWebElement::operator!=#
    {49, 523, 21},	// QWebElement::operator=#
    {49, 525, 22},	// QWebElement::operator==#
    {49, 543, 55},	// QWebElement::parent
    {49, 551, 52},	// QWebElement::prefix
    {49, 553, 65},	// QWebElement::prependInside#
    {49, 554, 64},	// QWebElement::prependInside$
    {49, 556, 69},	// QWebElement::prependOutside#
    {49, 557, 68},	// QWebElement::prependOutside$
    {49, 558, 59},	// QWebElement::previousSibling
    {49, 570, 79},	// QWebElement::removeAllChildren
    {49, 573, 39},	// QWebElement::removeAttribute$
    {49, 575, 40},	// QWebElement::removeAttributeNS$$
    {49, 577, 46},	// QWebElement::removeClass$
    {49, 580, 78},	// QWebElement::removeFromDocument
    {49, 584, 83},	// QWebElement::render#
    {49, 585, 84},	// QWebElement::render##
    {49, 593, 75},	// QWebElement::replace#
    {49, 594, 74},	// QWebElement::replace$
    {49, 635, 33},	// QWebElement::setAttribute$$
    {49, 637, 34},	// QWebElement::setAttributeNS$$$
    {49, 670, 49},	// QWebElement::setFocus
    {49, 685, 31},	// QWebElement::setInnerXml$
    {49, 711, 29},	// QWebElement::setOuterXml$
    {49, 719, 27},	// QWebElement::setPlainText$
    {49, 736, 82},	// QWebElement::setStyleProperty$$
    {49, 772, 81},	// QWebElement::styleProperty$$
    {49, 782, 51},	// QWebElement::tagName
    {49, 783, 77},	// QWebElement::takeFromDocument
    {49, 793, 32},	// QWebElement::toInnerXml
    {49, 795, 30},	// QWebElement::toOuterXml
    {49, 796, 28},	// QWebElement::toPlainText
    {49, 798, 47},	// QWebElement::toggleClass$
    {49, 833, 61},	// QWebElement::webFrame
    {49, 851, 91},	// QWebElement::~QWebElement
    {50, 133, 92},	// QWebElementCollection::QWebElementCollection
    {50, 134, 94},	// QWebElementCollection::QWebElementCollection#
    {50, 135, 93},	// QWebElementCollection::QWebElementCollection#$
    {50, 219, 98},	// QWebElementCollection::append#
    {50, 230, 100},	// QWebElementCollection::at$
    {50, 244, -4},	// QWebElementCollection::begin
    {50, 263, 107},	// QWebElementCollection::constBegin
    {50, 264, 108},	// QWebElementCollection::constEnd
    {50, 276, 99},	// QWebElementCollection::count
    {50, 325, -7},	// QWebElementCollection::end
    {50, 357, 102},	// QWebElementCollection::first
    {50, 444, 103},	// QWebElementCollection::last
    {50, 504, 96},	// QWebElementCollection::operator+#
    {50, 509, 97},	// QWebElementCollection::operator+=#
    {50, 523, 95},	// QWebElementCollection::operator=#
    {50, 531, 101},	// QWebElementCollection::operator[]$
    {50, 794, 104},	// QWebElementCollection::toList
    {50, 852, 111},	// QWebElementCollection::~QWebElementCollection
    {51, 266, 113},	// QWebElementCollection::const_iterator::const_iterator#
    {51, 267, 112},	// QWebElementCollection::const_iterator::const_iterator#$
    {51, 501, 116},	// QWebElementCollection::const_iterator::operator!=#
    {51, 502, 114},	// QWebElementCollection::const_iterator::operator*
    {51, 505, 127},	// QWebElementCollection::const_iterator::operator+$
    {51, 506, 121},	// QWebElementCollection::const_iterator::operator++
    {51, 507, 122},	// QWebElementCollection::const_iterator::operator++$
    {51, 510, 125},	// QWebElementCollection::const_iterator::operator+=$
    {51, 512, 129},	// QWebElementCollection::const_iterator::operator-#
    {51, 513, 128},	// QWebElementCollection::const_iterator::operator-$
    {51, 514, 123},	// QWebElementCollection::const_iterator::operator--
    {51, 515, 124},	// QWebElementCollection::const_iterator::operator--$
    {51, 517, 126},	// QWebElementCollection::const_iterator::operator-=$
    {51, 519, 117},	// QWebElementCollection::const_iterator::operator<#
    {51, 521, 118},	// QWebElementCollection::const_iterator::operator<=#
    {51, 525, 115},	// QWebElementCollection::const_iterator::operator==#
    {51, 527, 119},	// QWebElementCollection::const_iterator::operator>#
    {51, 529, 120},	// QWebElementCollection::const_iterator::operator>=#
    {51, 862, 130},	// QWebElementCollection::const_iterator::~const_iterator
    {52, 428, 132},	// QWebElementCollection::iterator::iterator#
    {52, 429, 131},	// QWebElementCollection::iterator::iterator#$
    {52, 501, 135},	// QWebElementCollection::iterator::operator!=#
    {52, 502, 133},	// QWebElementCollection::iterator::operator*
    {52, 505, 146},	// QWebElementCollection::iterator::operator+$
    {52, 506, 140},	// QWebElementCollection::iterator::operator++
    {52, 507, 141},	// QWebElementCollection::iterator::operator++$
    {52, 510, 144},	// QWebElementCollection::iterator::operator+=$
    {52, 512, 148},	// QWebElementCollection::iterator::operator-#
    {52, 513, 147},	// QWebElementCollection::iterator::operator-$
    {52, 514, 142},	// QWebElementCollection::iterator::operator--
    {52, 515, 143},	// QWebElementCollection::iterator::operator--$
    {52, 517, 145},	// QWebElementCollection::iterator::operator-=$
    {52, 519, 136},	// QWebElementCollection::iterator::operator<#
    {52, 521, 137},	// QWebElementCollection::iterator::operator<=#
    {52, 525, 134},	// QWebElementCollection::iterator::operator==#
    {52, 527, 138},	// QWebElementCollection::iterator::operator>#
    {52, 529, 139},	// QWebElementCollection::iterator::operator>=#
    {52, 863, 149},	// QWebElementCollection::iterator::~iterator
    {53, 6, 230},	// QWebFrame::AllLayers
    {53, 22, 227},	// QWebFrame::ContentsLayer
    {53, 118, 229},	// QWebFrame::PanIconLayer
    {53, 159, 228},	// QWebFrame::ScrollBarLayer
    {53, 214, 162},	// QWebFrame::addToJavaScriptWindowObject$#
    {53, 215, 163},	// QWebFrame::addToJavaScriptWindowObject$#$
    {53, 243, 171},	// QWebFrame::baseUrl
    {53, 252, 176},	// QWebFrame::childFrames
    {53, 271, 199},	// QWebFrame::contentsSize
    {53, 273, 214},	// QWebFrame::contentsSizeChanged#
    {53, 301, 200},	// QWebFrame::documentElement
    {53, 330, 206},	// QWebFrame::evaluateJavaScript$
    {53, 332, 204},	// QWebFrame::event#
    {53, 349, 201},	// QWebFrame::findAllElements$
    {53, 353, 202},	// QWebFrame::findFirstElement$
    {53, 380, 174},	// QWebFrame::frameName
    {53, 381, 198},	// QWebFrame::geometry
    {53, 395, 195},	// QWebFrame::hasFocus
    {53, 404, 203},	// QWebFrame::hitTestContent#
    {53, 406, 172},	// QWebFrame::icon
    {53, 407, 213},	// QWebFrame::iconChanged
    {53, 412, 212},	// QWebFrame::initialLayoutCompleted
    {53, 438, 208},	// QWebFrame::javaScriptWindowObjectCleared
    {53, 459, -1},	// QWebFrame::load#
    {53, 460, 221},	// QWebFrame::load#$
    {53, 461, 159},	// QWebFrame::load#$#
    {53, 463, 216},	// QWebFrame::loadFinished$
    {53, 466, 215},	// QWebFrame::loadStarted
    {53, 476, 173},	// QWebFrame::metaData
    {53, 477, 150},	// QWebFrame::metaObject
    {53, 534, 157},	// QWebFrame::page
    {53, 537, 217},	// QWebFrame::pageChanged
    {53, 544, 175},	// QWebFrame::parentFrame
    {53, 549, 197},	// QWebFrame::pos
    {53, 560, 207},	// QWebFrame::print#
    {53, 563, 209},	// QWebFrame::provisionalLoad
    {53, 565, 156},	// QWebFrame::qt_metacall$$?
    {53, 567, 151},	// QWebFrame::qt_metacast$
    {53, 584, 188},	// QWebFrame::render#
    {53, 585, 189},	// QWebFrame::render##
    {53, 586, 225},	// QWebFrame::render#$
    {53, 587, 190},	// QWebFrame::render#$#
    {53, 589, 166},	// QWebFrame::renderTreeDump
    {53, 595, 170},	// QWebFrame::requestedUrl
    {53, 610, 184},	// QWebFrame::scroll$$
    {53, 612, 183},	// QWebFrame::scrollBarGeometry$
    {53, 614, 182},	// QWebFrame::scrollBarMaximum$
    {53, 616, 181},	// QWebFrame::scrollBarMinimum$
    {53, 618, 177},	// QWebFrame::scrollBarPolicy$
    {53, 620, 180},	// QWebFrame::scrollBarValue$
    {53, 621, 185},	// QWebFrame::scrollPosition
    {53, 625, 187},	// QWebFrame::scrollToAnchor$
    {53, 626, 205},	// QWebFrame::securityOrigin
    {53, 641, 223},	// QWebFrame::setContent#
    {53, 642, 224},	// QWebFrame::setContent#$
    {53, 643, 161},	// QWebFrame::setContent#$#
    {53, 670, 196},	// QWebFrame::setFocus
    {53, 680, 222},	// QWebFrame::setHtml$
    {53, 681, 160},	// QWebFrame::setHtml$#
    {53, 730, 178},	// QWebFrame::setScrollBarPolicy$$
    {53, 732, 179},	// QWebFrame::setScrollBarValue$$
    {53, 734, 186},	// QWebFrame::setScrollPosition#
    {53, 740, 191},	// QWebFrame::setTextSizeMultiplier$
    {53, 744, 168},	// QWebFrame::setUrl#
    {53, 757, 194},	// QWebFrame::setZoomFactor$
    {53, 764, 226},	// QWebFrame::staticMetaObject
    {53, 786, 192},	// QWebFrame::textSizeMultiplier
    {53, 789, 167},	// QWebFrame::title
    {53, 791, 210},	// QWebFrame::titleChanged$
    {53, 792, 164},	// QWebFrame::toHtml
    {53, 796, 165},	// QWebFrame::toPlainText
    {53, 803, 218},	// QWebFrame::tr$
    {53, 804, 152},	// QWebFrame::tr$$
    {53, 805, 154},	// QWebFrame::tr$$$
    {53, 807, 219},	// QWebFrame::trUtf8$
    {53, 808, 153},	// QWebFrame::trUtf8$$
    {53, 809, 155},	// QWebFrame::trUtf8$$$
    {53, 821, 169},	// QWebFrame::url
    {53, 823, 211},	// QWebFrame::urlChanged#
    {53, 841, 193},	// QWebFrame::zoomFactor
    {54, 239, 237},	// QWebHistory::back
    {54, 240, 240},	// QWebHistory::backItem
    {54, 242, 233},	// QWebHistory::backItems$
    {54, 247, 235},	// QWebHistory::canGoBack
    {54, 248, 236},	// QWebHistory::canGoForward
    {54, 256, 231},	// QWebHistory::clear
    {54, 276, 245},	// QWebHistory::count
    {54, 285, 241},	// QWebHistory::currentItem
    {54, 286, 244},	// QWebHistory::currentItemIndex
    {54, 370, 238},	// QWebHistory::forward
    {54, 371, 242},	// QWebHistory::forwardItem
    {54, 373, 234},	// QWebHistory::forwardItems$
    {54, 386, 239},	// QWebHistory::goToItem#
    {54, 425, 243},	// QWebHistory::itemAt$
    {54, 426, 232},	// QWebHistory::items
    {54, 471, 246},	// QWebHistory::maximumItemCount
    {54, 691, 247},	// QWebHistory::setMaximumItemCount$
    {55, 136, 262},	// QWebHistoryInterface::QWebHistoryInterface
    {55, 137, 255},	// QWebHistoryInterface::QWebHistoryInterface#
    {55, 210, 259},	// QWebHistoryInterface::addHistoryEntry$
    {55, 293, 257},	// QWebHistoryInterface::defaultInterface
    {55, 402, 258},	// QWebHistoryInterface::historyContains$
    {55, 477, 248},	// QWebHistoryInterface::metaObject
    {55, 565, 254},	// QWebHistoryInterface::qt_metacall$$?
    {55, 567, 249},	// QWebHistoryInterface::qt_metacast$
    {55, 651, 256},	// QWebHistoryInterface::setDefaultInterface#
    {55, 764, 263},	// QWebHistoryInterface::staticMetaObject
    {55, 803, 260},	// QWebHistoryInterface::tr$
    {55, 804, 250},	// QWebHistoryInterface::tr$$
    {55, 805, 252},	// QWebHistoryInterface::tr$$$
    {55, 807, 261},	// QWebHistoryInterface::trUtf8$
    {55, 808, 251},	// QWebHistoryInterface::trUtf8$$
    {55, 809, 253},	// QWebHistoryInterface::trUtf8$$$
    {55, 853, 264},	// QWebHistoryInterface::~QWebHistoryInterface
    {56, 139, 265},	// QWebHistoryItem::QWebHistoryItem#
    {56, 406, 271},	// QWebHistoryItem::icon
    {56, 423, 274},	// QWebHistoryItem::isValid
    {56, 446, 270},	// QWebHistoryItem::lastVisited
    {56, 523, 266},	// QWebHistoryItem::operator=#
    {56, 533, 267},	// QWebHistoryItem::originalUrl
    {56, 746, 273},	// QWebHistoryItem::setUserData#
    {56, 789, 269},	// QWebHistoryItem::title
    {56, 821, 268},	// QWebHistoryItem::url
    {56, 826, 272},	// QWebHistoryItem::userData
    {56, 854, 275},	// QWebHistoryItem::~QWebHistoryItem
    {57, 140, 276},	// QWebHitTestResult::QWebHitTestResult
    {57, 141, 277},	// QWebHitTestResult::QWebHitTestResult#
    {57, 217, 289},	// QWebHitTestResult::alternateText
    {57, 245, 281},	// QWebHitTestResult::boundingRect
    {57, 313, 294},	// QWebHitTestResult::element
    {57, 323, 282},	// QWebHitTestResult::enclosingBlockElement
    {57, 375, 295},	// QWebHitTestResult::frame
    {57, 411, 290},	// QWebHitTestResult::imageUrl
    {57, 418, 292},	// QWebHitTestResult::isContentEditable
    {57, 419, 293},	// QWebHitTestResult::isContentSelected
    {57, 421, 279},	// QWebHitTestResult::isNull
    {57, 451, 288},	// QWebHitTestResult::linkElement
    {57, 454, 287},	// QWebHitTestResult::linkTargetFrame
    {57, 455, 284},	// QWebHitTestResult::linkText
    {57, 456, 286},	// QWebHitTestResult::linkTitle
    {57, 457, 285},	// QWebHitTestResult::linkUrl
    {57, 523, 278},	// QWebHitTestResult::operator=#
    {57, 545, 291},	// QWebHitTestResult::pixmap
    {57, 549, 280},	// QWebHitTestResult::pos
    {57, 789, 283},	// QWebHitTestResult::title
    {57, 855, 296},	// QWebHitTestResult::~QWebHitTestResult
    {58, 142, 315},	// QWebInspector::QWebInspector
    {58, 143, 304},	// QWebInspector::QWebInspector#
    {58, 261, 312},	// QWebInspector::closeEvent#
    {58, 332, 308},	// QWebInspector::event#
    {58, 399, 311},	// QWebInspector::hideEvent#
    {58, 477, 297},	// QWebInspector::metaObject
    {58, 534, 306},	// QWebInspector::page
    {58, 565, 303},	// QWebInspector::qt_metacall$$?
    {58, 567, 298},	// QWebInspector::qt_metacast$
    {58, 603, 309},	// QWebInspector::resizeEvent#
    {58, 713, 305},	// QWebInspector::setPage#
    {58, 761, 310},	// QWebInspector::showEvent#
    {58, 763, 307},	// QWebInspector::sizeHint
    {58, 764, 316},	// QWebInspector::staticMetaObject
    {58, 803, 313},	// QWebInspector::tr$
    {58, 804, 299},	// QWebInspector::tr$$
    {58, 805, 301},	// QWebInspector::tr$$$
    {58, 807, 314},	// QWebInspector::trUtf8$
    {58, 808, 300},	// QWebInspector::trUtf8$$
    {58, 809, 302},	// QWebInspector::trUtf8$$$
    {58, 856, 317},	// QWebInspector::~QWebInspector
    {59, 2, 489},	// QWebPage::AlignCenter
    {59, 3, 490},	// QWebPage::AlignJustified
    {59, 4, 491},	// QWebPage::AlignLeft
    {59, 5, 492},	// QWebPage::AlignRight
    {59, 11, 434},	// QWebPage::Back
    {59, 16, 511},	// QWebPage::ChooseMultipleFilesExtension
    {59, 23, 439},	// QWebPage::Copy
    {59, 24, 433},	// QWebPage::CopyImageToClipboard
    {59, 25, 494},	// QWebPage::CopyImageUrlToClipboard
    {59, 26, 430},	// QWebPage::CopyLinkToClipboard
    {59, 28, 438},	// QWebPage::Cut
    {59, 32, 503},	// QWebPage::DelegateAllLinks
    {59, 33, 502},	// QWebPage::DelegateExternalLinks
    {59, 35, 468},	// QWebPage::DeleteEndOfWord
    {59, 36, 467},	// QWebPage::DeleteStartOfWord
    {59, 39, 501},	// QWebPage::DontDelegateLinks
    {59, 40, 432},	// QWebPage::DownloadImageToDisk
    {59, 41, 429},	// QWebPage::DownloadLinkToDisk
    {59, 44, 512},	// QWebPage::ErrorPageExtension
    {59, 54, 497},	// QWebPage::FindBackward
    {59, 55, 498},	// QWebPage::FindCaseSensitively
    {59, 56, 499},	// QWebPage::FindWrapsAroundDocument
    {59, 58, 435},	// QWebPage::Forward
    {59, 60, 510},	// QWebPage::Geolocation
    {59, 61, 500},	// QWebPage::HighlightAllOccurrences
    {59, 62, 514},	// QWebPage::Http
    {59, 65, 487},	// QWebPage::Indent
    {59, 68, 477},	// QWebPage::InsertLineSeparator
    {59, 69, 486},	// QWebPage::InsertOrderedList
    {59, 70, 476},	// QWebPage::InsertParagraphSeparator
    {59, 71, 485},	// QWebPage::InsertUnorderedList
    {59, 72, 475},	// QWebPage::InspectElement
    {59, 89, 452},	// QWebPage::MoveToEndOfBlock
    {59, 90, 454},	// QWebPage::MoveToEndOfDocument
    {59, 91, 450},	// QWebPage::MoveToEndOfLine
    {59, 92, 443},	// QWebPage::MoveToNextChar
    {59, 93, 447},	// QWebPage::MoveToNextLine
    {59, 94, 445},	// QWebPage::MoveToNextWord
    {59, 95, 444},	// QWebPage::MoveToPreviousChar
    {59, 96, 448},	// QWebPage::MoveToPreviousLine
    {59, 97, 446},	// QWebPage::MoveToPreviousWord
    {59, 98, 451},	// QWebPage::MoveToStartOfBlock
    {59, 99, 453},	// QWebPage::MoveToStartOfDocument
    {59, 100, 449},	// QWebPage::MoveToStartOfLine
    {59, 101, 421},	// QWebPage::NavigationTypeBackOrForward
    {59, 102, 423},	// QWebPage::NavigationTypeFormResubmitted
    {59, 103, 420},	// QWebPage::NavigationTypeFormSubmitted
    {59, 104, 419},	// QWebPage::NavigationTypeLinkClicked
    {59, 105, 424},	// QWebPage::NavigationTypeOther
    {59, 106, 422},	// QWebPage::NavigationTypeReload
    {59, 107, 425},	// QWebPage::NoWebAction
    {59, 108, 509},	// QWebPage::Notifications
    {59, 112, 428},	// QWebPage::OpenFrameInNewWindow
    {59, 113, 431},	// QWebPage::OpenImageInNewWindow
    {59, 114, 426},	// QWebPage::OpenLink
    {59, 115, 427},	// QWebPage::OpenLinkInNewWindow
    {59, 116, 495},	// QWebPage::OpenLinkInThisWindow
    {59, 117, 488},	// QWebPage::Outdent
    {59, 119, 440},	// QWebPage::Paste
    {59, 120, 480},	// QWebPage::PasteAndMatchStyle
    {59, 121, 508},	// QWebPage::PermissionDeniedByUser
    {59, 122, 507},	// QWebPage::PermissionGrantedByUser
    {59, 123, 506},	// QWebPage::PermissionUnknown
    {59, 144, 413},	// QWebPage::QWebPage
    {59, 145, 325},	// QWebPage::QWebPage#
    {59, 152, 513},	// QWebPage::QtNetwork
    {59, 153, 442},	// QWebPage::Redo
    {59, 154, 437},	// QWebPage::Reload
    {59, 155, 479},	// QWebPage::ReloadAndBypassCache
    {59, 156, 481},	// QWebPage::RemoveFormat
    {59, 162, 478},	// QWebPage::SelectAll
    {59, 163, 464},	// QWebPage::SelectEndOfBlock
    {59, 164, 466},	// QWebPage::SelectEndOfDocument
    {59, 165, 462},	// QWebPage::SelectEndOfLine
    {59, 166, 455},	// QWebPage::SelectNextChar
    {59, 167, 459},	// QWebPage::SelectNextLine
    {59, 168, 457},	// QWebPage::SelectNextWord
    {59, 169, 456},	// QWebPage::SelectPreviousChar
    {59, 170, 460},	// QWebPage::SelectPreviousLine
    {59, 171, 458},	// QWebPage::SelectPreviousWord
    {59, 172, 463},	// QWebPage::SelectStartOfBlock
    {59, 173, 465},	// QWebPage::SelectStartOfDocument
    {59, 174, 461},	// QWebPage::SelectStartOfLine
    {59, 176, 469},	// QWebPage::SetTextDirectionDefault
    {59, 177, 470},	// QWebPage::SetTextDirectionLeftToRight
    {59, 178, 471},	// QWebPage::SetTextDirectionRightToLeft
    {59, 182, 436},	// QWebPage::Stop
    {59, 183, 493},	// QWebPage::StopScheduledPageRefresh
    {59, 186, 472},	// QWebPage::ToggleBold
    {59, 187, 473},	// QWebPage::ToggleItalic
    {59, 188, 482},	// QWebPage::ToggleStrikethrough
    {59, 189, 483},	// QWebPage::ToggleSubscript
    {59, 190, 484},	// QWebPage::ToggleSuperscript
    {59, 191, 474},	// QWebPage::ToggleUnderline
    {59, 192, 441},	// QWebPage::Undo
    {59, 195, 496},	// QWebPage::WebActionCount
    {59, 196, 504},	// QWebPage::WebBrowserWindow
    {59, 198, 515},	// QWebPage::WebKit
    {59, 199, 505},	// QWebPage::WebModalDialog
    {59, 203, 404},	// QWebPage::acceptNavigationRequest##$
    {59, 205, 344},	// QWebPage::action$
    {59, 227, 395},	// QWebPage::applicationCacheQuotaExceeded#$
    {59, 228, 396},	// QWebPage::applicationCacheQuotaExceeded#$$
    {59, 246, 340},	// QWebPage::bytesReceived
    {59, 254, 405},	// QWebPage::chooseFile#$
    {59, 270, 393},	// QWebPage::contentsChanged
    {59, 280, 403},	// QWebPage::createPlugin$#??
    {59, 281, 366},	// QWebPage::createStandardContextMenu
    {59, 283, 402},	// QWebPage::createWindow$
    {59, 284, 327},	// QWebPage::currentFrame
    {59, 290, 394},	// QWebPage::databaseQuotaExceeded#$
    {59, 304, 391},	// QWebPage::downloadRequested#
    {59, 332, 352},	// QWebPage::event#
    {59, 336, 416},	// QWebPage::extension$
    {59, 337, 417},	// QWebPage::extension$#
    {59, 338, 370},	// QWebPage::extension$##
    {59, 340, 401},	// QWebPage::featurePermissionRequestCanceled#$
    {59, 342, 400},	// QWebPage::featurePermissionRequested#$
    {59, 355, 415},	// QWebPage::findText$
    {59, 356, 355},	// QWebPage::findText$$
    {59, 362, 353},	// QWebPage::focusNextPrevChild$
    {59, 374, 357},	// QWebPage::forwardUnsupportedContent
    {59, 377, 328},	// QWebPage::frameAt#
    {59, 379, 380},	// QWebPage::frameCreated#
    {59, 383, 381},	// QWebPage::geometryChangeRequested#
    {59, 387, 372},	// QWebPage::handle
    {59, 396, 341},	// QWebPage::hasSelection
    {59, 400, 329},	// QWebPage::history
    {59, 417, 354},	// QWebPage::inputMethodQuery$
    {59, 418, 363},	// QWebPage::isContentEditable
    {59, 420, 333},	// QWebPage::isModified
    {59, 431, 406},	// QWebPage::javaScriptAlert#$
    {59, 433, 407},	// QWebPage::javaScriptConfirm#$
    {59, 435, 409},	// QWebPage::javaScriptConsoleMessage$$$
    {59, 437, 408},	// QWebPage::javaScriptPrompt#$$$
    {59, 449, 386},	// QWebPage::linkClicked#
    {59, 450, 359},	// QWebPage::linkDelegationPolicy
    {59, 453, 377},	// QWebPage::linkHovered$$$
    {59, 463, 376},	// QWebPage::loadFinished$
    {59, 465, 375},	// QWebPage::loadProgress$
    {59, 466, 374},	// QWebPage::loadStarted
    {59, 470, 326},	// QWebPage::mainFrame
    {59, 475, 389},	// QWebPage::menuBarVisibilityChangeRequested$
    {59, 477, 318},	// QWebPage::metaObject
    {59, 479, 392},	// QWebPage::microFocusChanged
    {59, 494, 336},	// QWebPage::networkAccessManager
    {59, 541, 361},	// QWebPage::palette
    {59, 546, 338},	// QWebPage::pluginFactory
    {59, 550, 349},	// QWebPage::preferredContentsSize
    {59, 562, 385},	// QWebPage::printRequested#
    {59, 565, 324},	// QWebPage::qt_metacall$$?
    {59, 567, 319},	// QWebPage::qt_metacast$
    {59, 591, 382},	// QWebPage::repaintRequested#
    {59, 605, 398},	// QWebPage::restoreFrameStateRequested#
    {59, 607, 397},	// QWebPage::saveFrameStateRequested##
    {59, 623, 383},	// QWebPage::scrollRequested$$#
    {59, 627, 343},	// QWebPage::selectedHtml
    {59, 628, 342},	// QWebPage::selectedText
    {59, 629, 379},	// QWebPage::selectionChanged
    {59, 631, 351},	// QWebPage::setActualVisibleContentRect#
    {59, 645, 362},	// QWebPage::setContentEditable$
    {59, 665, 367},	// QWebPage::setFeaturePermission#$$
    {59, 676, 356},	// QWebPage::setForwardUnsupportedContent$
    {59, 687, 358},	// QWebPage::setLinkDelegationPolicy$
    {59, 699, 335},	// QWebPage::setNetworkAccessManager#
    {59, 715, 360},	// QWebPage::setPalette#
    {59, 721, 337},	// QWebPage::setPluginFactory#
    {59, 723, 350},	// QWebPage::setPreferredContentsSize#
    {59, 750, 331},	// QWebPage::setView#
    {59, 752, 347},	// QWebPage::setViewportSize#
    {59, 758, 330},	// QWebPage::settings
    {59, 759, 373},	// QWebPage::shouldInterruptJavaScript
    {59, 764, 418},	// QWebPage::staticMetaObject
    {59, 766, 378},	// QWebPage::statusBarMessage$
    {59, 768, 388},	// QWebPage::statusBarVisibilityChangeRequested$
    {59, 774, 368},	// QWebPage::supportedContentTypes
    {59, 776, 369},	// QWebPage::supportsContentType$
    {59, 778, 371},	// QWebPage::supportsExtension$
    {59, 780, 364},	// QWebPage::swallowContextMenuEvent#
    {59, 800, 387},	// QWebPage::toolBarVisibilityChangeRequested$
    {59, 801, 339},	// QWebPage::totalBytes
    {59, 803, 411},	// QWebPage::tr$
    {59, 804, 320},	// QWebPage::tr$$
    {59, 805, 322},	// QWebPage::tr$$$
    {59, 807, 412},	// QWebPage::trUtf8$
    {59, 808, 321},	// QWebPage::trUtf8$$
    {59, 809, 323},	// QWebPage::trUtf8$$$
    {59, 811, 414},	// QWebPage::triggerAction$
    {59, 812, 345},	// QWebPage::triggerAction$$
    {59, 816, 334},	// QWebPage::undoStack
    {59, 818, 390},	// QWebPage::unsupportedContent#
    {59, 820, 365},	// QWebPage::updatePositionDependentActions#
    {59, 825, 410},	// QWebPage::userAgentForUrl#
    {59, 828, 332},	// QWebPage::view
    {59, 830, 348},	// QWebPage::viewportAttributesForSize#
    {59, 831, 399},	// QWebPage::viewportChangeRequested
    {59, 832, 346},	// QWebPage::viewportSize
    {59, 839, 384},	// QWebPage::windowCloseRequested
    {59, 857, 516},	// QWebPage::~QWebPage
    {60, 17, 517},	// QWebPage::ChooseMultipleFilesExtensionOption::ChooseMultipleFilesExtensionOption
    {60, 18, 518},	// QWebPage::ChooseMultipleFilesExtensionOption::ChooseMultipleFilesExtensionOption#
    {60, 544, 519},	// QWebPage::ChooseMultipleFilesExtensionOption::parentFrame
    {60, 717, 520},	// QWebPage::ChooseMultipleFilesExtensionOption::setParentFrame#
    {60, 738, 522},	// QWebPage::ChooseMultipleFilesExtensionOption::setSuggestedFileNames?
    {60, 773, 521},	// QWebPage::ChooseMultipleFilesExtensionOption::suggestedFileNames
    {60, 842, 523},	// QWebPage::ChooseMultipleFilesExtensionOption::~ChooseMultipleFilesExtensionOption
    {61, 19, 524},	// QWebPage::ChooseMultipleFilesExtensionReturn::ChooseMultipleFilesExtensionReturn
    {61, 20, 525},	// QWebPage::ChooseMultipleFilesExtensionReturn::ChooseMultipleFilesExtensionReturn#
    {61, 345, 526},	// QWebPage::ChooseMultipleFilesExtensionReturn::fileNames
    {61, 669, 527},	// QWebPage::ChooseMultipleFilesExtensionReturn::setFileNames?
    {61, 843, 528},	// QWebPage::ChooseMultipleFilesExtensionReturn::~ChooseMultipleFilesExtensionReturn
    {62, 45, 529},	// QWebPage::ErrorPageExtensionOption::ErrorPageExtensionOption
    {62, 46, 530},	// QWebPage::ErrorPageExtensionOption::ErrorPageExtensionOption#
    {62, 302, 535},	// QWebPage::ErrorPageExtensionOption::domain
    {62, 327, 537},	// QWebPage::ErrorPageExtensionOption::error
    {62, 328, 539},	// QWebPage::ErrorPageExtensionOption::errorString
    {62, 375, 533},	// QWebPage::ErrorPageExtensionOption::frame
    {62, 657, 536},	// QWebPage::ErrorPageExtensionOption::setDomain$
    {62, 661, 538},	// QWebPage::ErrorPageExtensionOption::setError$
    {62, 663, 540},	// QWebPage::ErrorPageExtensionOption::setErrorString$
    {62, 678, 534},	// QWebPage::ErrorPageExtensionOption::setFrame#
    {62, 744, 532},	// QWebPage::ErrorPageExtensionOption::setUrl#
    {62, 821, 531},	// QWebPage::ErrorPageExtensionOption::url
    {62, 844, 541},	// QWebPage::ErrorPageExtensionOption::~ErrorPageExtensionOption
    {63, 47, 542},	// QWebPage::ErrorPageExtensionReturn::ErrorPageExtensionReturn
    {63, 48, 543},	// QWebPage::ErrorPageExtensionReturn::ErrorPageExtensionReturn#
    {63, 243, 548},	// QWebPage::ErrorPageExtensionReturn::baseUrl
    {63, 268, 550},	// QWebPage::ErrorPageExtensionReturn::content
    {63, 269, 544},	// QWebPage::ErrorPageExtensionReturn::contentType
    {63, 324, 546},	// QWebPage::ErrorPageExtensionReturn::encoding
    {63, 639, 549},	// QWebPage::ErrorPageExtensionReturn::setBaseUrl#
    {63, 641, 551},	// QWebPage::ErrorPageExtensionReturn::setContent#
    {63, 647, 545},	// QWebPage::ErrorPageExtensionReturn::setContentType$
    {63, 659, 547},	// QWebPage::ErrorPageExtensionReturn::setEncoding$
    {63, 845, 552},	// QWebPage::ErrorPageExtensionReturn::~ErrorPageExtensionReturn
    {64, 49, 553},	// QWebPage::ExtensionOption::ExtensionOption
    {64, 50, 554},	// QWebPage::ExtensionOption::ExtensionOption#
    {64, 846, 555},	// QWebPage::ExtensionOption::~ExtensionOption
    {65, 51, 556},	// QWebPage::ExtensionReturn::ExtensionReturn
    {65, 52, 557},	// QWebPage::ExtensionReturn::ExtensionReturn#
    {65, 847, 558},	// QWebPage::ExtensionReturn::~ExtensionReturn
    {66, 193, 559},	// QWebPage::ViewportAttributes::ViewportAttributes
    {66, 194, 560},	// QWebPage::ViewportAttributes::ViewportAttributes#
    {66, 297, 565},	// QWebPage::ViewportAttributes::devicePixelRatio
    {66, 413, 562},	// QWebPage::ViewportAttributes::initialScaleFactor
    {66, 422, 566},	// QWebPage::ViewportAttributes::isUserScalable
    {66, 423, 567},	// QWebPage::ViewportAttributes::isValid
    {66, 473, 564},	// QWebPage::ViewportAttributes::maximumScaleFactor
    {66, 481, 563},	// QWebPage::ViewportAttributes::minimumScaleFactor
    {66, 523, 561},	// QWebPage::ViewportAttributes::operator=#
    {66, 762, 568},	// QWebPage::ViewportAttributes::size
    {66, 861, 569},	// QWebPage::ViewportAttributes::~ViewportAttributes
    {68, 146, 585},	// QWebPluginFactory::QWebPluginFactory
    {68, 147, 577},	// QWebPluginFactory::QWebPluginFactory#
    {68, 278, 580},	// QWebPluginFactory::create$#??
    {68, 336, 586},	// QWebPluginFactory::extension$
    {68, 337, 587},	// QWebPluginFactory::extension$#
    {68, 338, 581},	// QWebPluginFactory::extension$##
    {68, 477, 570},	// QWebPluginFactory::metaObject
    {68, 547, 578},	// QWebPluginFactory::plugins
    {68, 565, 576},	// QWebPluginFactory::qt_metacall$$?
    {68, 567, 571},	// QWebPluginFactory::qt_metacast$
    {68, 568, 579},	// QWebPluginFactory::refreshPlugins
    {68, 764, 588},	// QWebPluginFactory::staticMetaObject
    {68, 778, 582},	// QWebPluginFactory::supportsExtension$
    {68, 803, 583},	// QWebPluginFactory::tr$
    {68, 804, 572},	// QWebPluginFactory::tr$$
    {68, 805, 574},	// QWebPluginFactory::tr$$$
    {68, 807, 584},	// QWebPluginFactory::trUtf8$
    {68, 808, 573},	// QWebPluginFactory::trUtf8$$
    {68, 809, 575},	// QWebPluginFactory::trUtf8$$$
    {68, 858, 589},	// QWebPluginFactory::~QWebPluginFactory
    {69, 49, 590},	// QWebPluginFactory::ExtensionOption::ExtensionOption
    {69, 50, 591},	// QWebPluginFactory::ExtensionOption::ExtensionOption#
    {69, 846, 592},	// QWebPluginFactory::ExtensionOption::~ExtensionOption
    {70, 51, 593},	// QWebPluginFactory::ExtensionReturn::ExtensionReturn
    {70, 52, 594},	// QWebPluginFactory::ExtensionReturn::ExtensionReturn#
    {70, 847, 595},	// QWebPluginFactory::ExtensionReturn::~ExtensionReturn
    {71, 83, 598},	// QWebPluginFactory::MimeType::MimeType
    {71, 84, 599},	// QWebPluginFactory::MimeType::MimeType#
    {71, 295, 602},	// QWebPluginFactory::MimeType::description
    {71, 343, 604},	// QWebPluginFactory::MimeType::fileExtensions
    {71, 492, 600},	// QWebPluginFactory::MimeType::name
    {71, 501, 597},	// QWebPluginFactory::MimeType::operator!=#
    {71, 525, 596},	// QWebPluginFactory::MimeType::operator==#
    {71, 655, 603},	// QWebPluginFactory::MimeType::setDescription$
    {71, 667, 605},	// QWebPluginFactory::MimeType::setFileExtensions?
    {71, 697, 601},	// QWebPluginFactory::MimeType::setName$
    {71, 848, 606},	// QWebPluginFactory::MimeType::~MimeType
    {72, 124, 607},	// QWebPluginFactory::Plugin::Plugin
    {72, 125, 608},	// QWebPluginFactory::Plugin::Plugin#
    {72, 295, 611},	// QWebPluginFactory::Plugin::description
    {72, 480, 613},	// QWebPluginFactory::Plugin::mimeTypes
    {72, 492, 609},	// QWebPluginFactory::Plugin::name
    {72, 655, 612},	// QWebPluginFactory::Plugin::setDescription$
    {72, 695, 614},	// QWebPluginFactory::Plugin::setMimeTypes?
    {72, 697, 610},	// QWebPluginFactory::Plugin::setName$
    {72, 849, 615},	// QWebPluginFactory::Plugin::~Plugin
    {73, 149, 628},	// QWebSecurityOrigin::QWebSecurityOrigin#
    {73, 212, 617},	// QWebSecurityOrigin::addLocalScheme$
    {73, 216, 616},	// QWebSecurityOrigin::allOrigins
    {73, 288, 624},	// QWebSecurityOrigin::databaseQuota
    {73, 291, 623},	// QWebSecurityOrigin::databaseUsage
    {73, 292, 627},	// QWebSecurityOrigin::databases
    {73, 405, 621},	// QWebSecurityOrigin::host
    {73, 468, 619},	// QWebSecurityOrigin::localSchemes
    {73, 523, 629},	// QWebSecurityOrigin::operator=#
    {73, 548, 622},	// QWebSecurityOrigin::port
    {73, 582, 618},	// QWebSecurityOrigin::removeLocalScheme$
    {73, 608, 620},	// QWebSecurityOrigin::scheme
    {73, 633, 626},	// QWebSecurityOrigin::setApplicationCacheQuota$
    {73, 649, 625},	// QWebSecurityOrigin::setDatabaseQuota$
    {73, 859, 630},	// QWebSecurityOrigin::~QWebSecurityOrigin
    {74, 1, 694},	// QWebSettings::AcceleratedCompositingEnabled
    {74, 7, 722},	// QWebSettings::AllowThirdPartyWithExistingCookies
    {74, 8, 720},	// QWebSettings::AlwaysAllowThirdPartyCookies
    {74, 9, 721},	// QWebSettings::AlwaysBlockThirdPartyCookies
    {74, 10, 676},	// QWebSettings::AutoLoadImages
    {74, 12, 704},	// QWebSettings::CSSGridLayoutEnabled
    {74, 13, 702},	// QWebSettings::CSSRegionsEnabled
    {74, 14, 706},	// QWebSettings::CaretBrowsingEnabled
    {74, 27, 674},	// QWebSettings::CursiveFont
    {74, 29, 719},	// QWebSettings::DefaultFixedFontSize
    {74, 30, 718},	// QWebSettings::DefaultFontSize
    {74, 31, 710},	// QWebSettings::DefaultFrameIconGraphic
    {74, 34, 712},	// QWebSettings::DeleteButtonGraphic
    {74, 37, 683},	// QWebSettings::DeveloperExtrasEnabled
    {74, 38, 692},	// QWebSettings::DnsPrefetchEnabled
    {74, 53, 675},	// QWebSettings::FantasyFont
    {74, 57, 671},	// QWebSettings::FixedFont
    {74, 59, 698},	// QWebSettings::FrameFlatteningEnabled
    {74, 63, 703},	// QWebSettings::HyperlinkAuditingEnabled
    {74, 67, 713},	// QWebSettings::InputSpeechButtonGraphic
    {74, 73, 678},	// QWebSettings::JavaEnabled
    {74, 74, 682},	// QWebSettings::JavascriptCanAccessClipboard
    {74, 75, 700},	// QWebSettings::JavascriptCanCloseWindows
    {74, 76, 681},	// QWebSettings::JavascriptCanOpenWindows
    {74, 77, 677},	// QWebSettings::JavascriptEnabled
    {74, 78, 684},	// QWebSettings::LinksIncludedInFocusChain
    {74, 79, 696},	// QWebSettings::LocalContentCanAccessFileUrls
    {74, 80, 691},	// QWebSettings::LocalContentCanAccessRemoteUrls
    {74, 81, 690},	// QWebSettings::LocalStorageDatabaseEnabled
    {74, 82, 689},	// QWebSettings::LocalStorageEnabled
    {74, 85, 716},	// QWebSettings::MinimumFontSize
    {74, 86, 717},	// QWebSettings::MinimumLogicalFontSize
    {74, 87, 708},	// QWebSettings::MissingImageGraphic
    {74, 88, 709},	// QWebSettings::MissingPluginGraphic
    {74, 109, 707},	// QWebSettings::NotificationsEnabled
    {74, 110, 687},	// QWebSettings::OfflineStorageDatabaseEnabled
    {74, 111, 688},	// QWebSettings::OfflineWebApplicationCacheEnabled
    {74, 126, 679},	// QWebSettings::PluginsEnabled
    {74, 127, 686},	// QWebSettings::PrintElementBackgrounds
    {74, 128, 680},	// QWebSettings::PrivateBrowsingEnabled
    {74, 157, 673},	// QWebSettings::SansSerifFont
    {74, 158, 705},	// QWebSettings::ScrollAnimatorEnabled
    {74, 160, 714},	// QWebSettings::SearchCancelButtonGraphic
    {74, 161, 715},	// QWebSettings::SearchCancelButtonPressedGraphic
    {74, 175, 672},	// QWebSettings::SerifFont
    {74, 179, 699},	// QWebSettings::SiteSpecificQuirksEnabled
    {74, 180, 695},	// QWebSettings::SpatialNavigationEnabled
    {74, 181, 670},	// QWebSettings::StandardFont
    {74, 184, 711},	// QWebSettings::TextAreaSizeGripCornerGraphic
    {74, 185, 697},	// QWebSettings::TiledBackingStoreEnabled
    {74, 197, 701},	// QWebSettings::WebGLEnabled
    {74, 200, 693},	// QWebSettings::XSSAuditingEnabled
    {74, 201, 685},	// QWebSettings::ZoomTextOnly
    {74, 257, 647},	// QWebSettings::clearIconDatabase
    {74, 258, 664},	// QWebSettings::clearMemoryCaches
    {74, 294, 644},	// QWebSettings::defaultTextEncoding
    {74, 314, 669},	// QWebSettings::enablePersistentStorage
    {74, 315, 665},	// QWebSettings::enablePersistentStorage$
    {74, 367, 633},	// QWebSettings::fontFamily$
    {74, 369, 636},	// QWebSettings::fontSize$
    {74, 384, 631},	// QWebSettings::globalSettings
    {74, 387, 668},	// QWebSettings::handle
    {74, 408, 646},	// QWebSettings::iconDatabasePath
    {74, 410, 648},	// QWebSettings::iconForUrl#
    {74, 469, 663},	// QWebSettings::localStoragePath
    {74, 472, 652},	// QWebSettings::maximumPagesInCache
    {74, 496, 657},	// QWebSettings::offlineStorageDefaultQuota
    {74, 497, 655},	// QWebSettings::offlineStoragePath
    {74, 498, 659},	// QWebSettings::offlineWebApplicationCachePath
    {74, 499, 661},	// QWebSettings::offlineWebApplicationCacheQuota
    {74, 597, 640},	// QWebSettings::resetAttribute$
    {74, 599, 634},	// QWebSettings::resetFontFamily$
    {74, 601, 637},	// QWebSettings::resetFontSize$
    {74, 635, 638},	// QWebSettings::setAttribute$$
    {74, 653, 643},	// QWebSettings::setDefaultTextEncoding$
    {74, 672, 632},	// QWebSettings::setFontFamily$$
    {74, 674, 635},	// QWebSettings::setFontSize$$
    {74, 683, 645},	// QWebSettings::setIconDatabasePath$
    {74, 689, 662},	// QWebSettings::setLocalStoragePath$
    {74, 693, 651},	// QWebSettings::setMaximumPagesInCache$
    {74, 701, 653},	// QWebSettings::setObjectCacheCapacities$$$
    {74, 703, 656},	// QWebSettings::setOfflineStorageDefaultQuota$
    {74, 705, 654},	// QWebSettings::setOfflineStoragePath$
    {74, 707, 658},	// QWebSettings::setOfflineWebApplicationCachePath$
    {74, 709, 660},	// QWebSettings::setOfflineWebApplicationCacheQuota$
    {74, 742, 666},	// QWebSettings::setThirdPartyCookiePolicy$
    {74, 748, 641},	// QWebSettings::setUserStyleSheetUrl#
    {74, 755, 649},	// QWebSettings::setWebGraphic$#
    {74, 785, 639},	// QWebSettings::testAttribute$
    {74, 787, 667},	// QWebSettings::thirdPartyCookiePolicy
    {74, 827, 642},	// QWebSettings::userStyleSheetUrl
    {74, 835, 650},	// QWebSettings::webGraphic$
    {76, 150, 796},	// QWebView::QWebView
    {76, 151, 730},	// QWebView::QWebView#
    {76, 239, 761},	// QWebView::back
    {76, 250, 777},	// QWebView::changeEvent#
    {76, 275, 782},	// QWebView::contextMenuEvent#
    {76, 283, 776},	// QWebView::createWindow$
    {76, 306, 786},	// QWebView::dragEnterEvent#
    {76, 308, 787},	// QWebView::dragLeaveEvent#
    {76, 310, 788},	// QWebView::dragMoveEvent#
    {76, 312, 789},	// QWebView::dropEvent#
    {76, 332, 759},	// QWebView::event#
    {76, 355, 804},	// QWebView::findText$
    {76, 356, 758},	// QWebView::findText$$
    {76, 360, 790},	// QWebView::focusInEvent#
    {76, 362, 793},	// QWebView::focusNextPrevChild$
    {76, 364, 791},	// QWebView::focusOutEvent#
    {76, 370, 762},	// QWebView::forward
    {76, 396, 743},	// QWebView::hasSelection
    {76, 400, 737},	// QWebView::history
    {76, 406, 742},	// QWebView::icon
    {76, 407, 772},	// QWebView::iconChanged
    {76, 415, 792},	// QWebView::inputMethodEvent#
    {76, 417, 749},	// QWebView::inputMethodQuery$
    {76, 420, 748},	// QWebView::isModified
    {76, 440, 784},	// QWebView::keyPressEvent#
    {76, 442, 785},	// QWebView::keyReleaseEvent#
    {76, 449, 770},	// QWebView::linkClicked#
    {76, 459, -10},	// QWebView::load#
    {76, 460, 798},	// QWebView::load#$
    {76, 461, 734},	// QWebView::load#$#
    {76, 463, 767},	// QWebView::loadFinished$
    {76, 465, 766},	// QWebView::loadProgress$
    {76, 466, 765},	// QWebView::loadStarted
    {76, 477, 723},	// QWebView::metaObject
    {76, 484, 780},	// QWebView::mouseDoubleClickEvent#
    {76, 486, 778},	// QWebView::mouseMoveEvent#
    {76, 488, 779},	// QWebView::mousePressEvent#
    {76, 490, 781},	// QWebView::mouseReleaseEvent#
    {76, 534, 731},	// QWebView::page
    {76, 536, 746},	// QWebView::pageAction$
    {76, 540, 775},	// QWebView::paintEvent#
    {76, 560, 764},	// QWebView::print#
    {76, 565, 729},	// QWebView::qt_metacall$$?
    {76, 567, 724},	// QWebView::qt_metacast$
    {76, 569, 763},	// QWebView::reload
    {76, 588, 755},	// QWebView::renderHints
    {76, 603, 774},	// QWebView::resizeEvent#
    {76, 627, 745},	// QWebView::selectedHtml
    {76, 628, 744},	// QWebView::selectedText
    {76, 629, 771},	// QWebView::selectionChanged
    {76, 641, 800},	// QWebView::setContent#
    {76, 642, 801},	// QWebView::setContent#$
    {76, 643, 736},	// QWebView::setContent#$#
    {76, 680, 799},	// QWebView::setHtml$
    {76, 681, 735},	// QWebView::setHtml$#
    {76, 713, 732},	// QWebView::setPage#
    {76, 725, 803},	// QWebView::setRenderHint$
    {76, 726, 757},	// QWebView::setRenderHint$$
    {76, 728, 756},	// QWebView::setRenderHints$
    {76, 740, 753},	// QWebView::setTextSizeMultiplier$
    {76, 744, 740},	// QWebView::setUrl#
    {76, 757, 752},	// QWebView::setZoomFactor$
    {76, 758, 738},	// QWebView::settings
    {76, 763, 750},	// QWebView::sizeHint
    {76, 764, 805},	// QWebView::staticMetaObject
    {76, 766, 769},	// QWebView::statusBarMessage$
    {76, 769, 760},	// QWebView::stop
    {76, 786, 754},	// QWebView::textSizeMultiplier
    {76, 789, 739},	// QWebView::title
    {76, 791, 768},	// QWebView::titleChanged$
    {76, 803, 794},	// QWebView::tr$
    {76, 804, 725},	// QWebView::tr$$
    {76, 805, 727},	// QWebView::tr$$$
    {76, 807, 795},	// QWebView::trUtf8$
    {76, 808, 726},	// QWebView::trUtf8$$
    {76, 809, 728},	// QWebView::trUtf8$$$
    {76, 814, 802},	// QWebView::triggerPageAction$
    {76, 815, 747},	// QWebView::triggerPageAction$$
    {76, 821, 741},	// QWebView::url
    {76, 823, 773},	// QWebView::urlChanged#
    {76, 837, 783},	// QWebView::wheelEvent#
    {76, 841, 751},	// QWebView::zoomFactor
    {76, 860, 806},	// QWebView::~QWebView
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();
SMOKE_IMPORT void init_qtgui_Smoke();

static bool initialized = false;
Smoke *qtwebkit_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qtwebkit_Smoke() {
    init_qtcore_Smoke();
    init_qtgui_Smoke();
    if (initialized) return;
    qtwebkit_Smoke = new Smoke(
        "qtwebkit",
        __smokeqtwebkit::classes, 78,
        __smokeqtwebkit::methods, 847,
        __smokeqtwebkit::methodMaps, 796,
        __smokeqtwebkit::methodNames, 863,
        __smokeqtwebkit::types, 259,
        __smokeqtwebkit::inheritanceList,
        __smokeqtwebkit::argumentList,
        __smokeqtwebkit::ambiguousMethodList,
        __smokeqtwebkit::cast );
    initialized = true;
}

void delete_qtwebkit_Smoke() { delete qtwebkit_Smoke; }

}
