#include <qtnetwork_includes.h>

#include <smoke.h>
#include <qtnetwork_smoke.h>

namespace __smokeqtnetwork {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QAbstractNetworkCache
      switch(to) {
        case 42: return (void*)(QObject*)(QAbstractNetworkCache*)xptr;
        case 1: return (void*)(QAbstractNetworkCache*)xptr;
        case 34: return (void*)(QNetworkDiskCache*)(QAbstractNetworkCache*)xptr;
        default: return xptr;
      }
    case 2:   //QAbstractSocket
      switch(to) {
        case 21: return (void*)(QIODevice*)(QAbstractSocket*)xptr;
        case 42: return (void*)(QObject*)(QAbstractSocket*)xptr;
        case 2: return (void*)(QAbstractSocket*)xptr;
        case 54: return (void*)(QUdpSocket*)(QAbstractSocket*)xptr;
        case 50: return (void*)(QSslSocket*)(QAbstractSocket*)xptr;
        case 52: return (void*)(QTcpSocket*)(QAbstractSocket*)xptr;
        default: return xptr;
      }
    case 3:   //QAuthenticator
      switch(to) {
        case 3: return (void*)(QAuthenticator*)xptr;
        default: return xptr;
      }
    case 4:   //QBool
      switch(to) {
        case 4: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 5:   //QByteArray
      switch(to) {
        case 5: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 6:   //QChildEvent
      switch(to) {
        case 10: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 6: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 7:   //QDataStream
      switch(to) {
        case 7: return (void*)(QDataStream*)xptr;
        default: return xptr;
      }
    case 8:   //QDateTime
      switch(to) {
        case 8: return (void*)(QDateTime*)xptr;
        default: return xptr;
      }
    case 9:   //QDebug
      switch(to) {
        case 9: return (void*)(QDebug*)xptr;
        default: return xptr;
      }
    case 10:   //QEvent
      switch(to) {
        case 10: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 11:   //QFtp
      switch(to) {
        case 42: return (void*)(QObject*)(QFtp*)xptr;
        case 11: return (void*)(QFtp*)xptr;
        default: return xptr;
      }
    case 13:   //QHostAddress
      switch(to) {
        case 13: return (void*)(QHostAddress*)xptr;
        default: return xptr;
      }
    case 14:   //QHostInfo
      switch(to) {
        case 14: return (void*)(QHostInfo*)xptr;
        default: return xptr;
      }
    case 15:   //QHttp
      switch(to) {
        case 42: return (void*)(QObject*)(QHttp*)xptr;
        case 15: return (void*)(QHttp*)xptr;
        default: return xptr;
      }
    case 16:   //QHttpHeader
      switch(to) {
        case 16: return (void*)(QHttpHeader*)xptr;
        case 19: return (void*)(QHttpRequestHeader*)(QHttpHeader*)xptr;
        case 20: return (void*)(QHttpResponseHeader*)(QHttpHeader*)xptr;
        default: return xptr;
      }
    case 17:   //QHttpMultiPart
      switch(to) {
        case 42: return (void*)(QObject*)(QHttpMultiPart*)xptr;
        case 17: return (void*)(QHttpMultiPart*)xptr;
        default: return xptr;
      }
    case 18:   //QHttpPart
      switch(to) {
        case 18: return (void*)(QHttpPart*)xptr;
        default: return xptr;
      }
    case 19:   //QHttpRequestHeader
      switch(to) {
        case 16: return (void*)(QHttpHeader*)(QHttpRequestHeader*)xptr;
        case 19: return (void*)(QHttpRequestHeader*)xptr;
        default: return xptr;
      }
    case 20:   //QHttpResponseHeader
      switch(to) {
        case 16: return (void*)(QHttpHeader*)(QHttpResponseHeader*)xptr;
        case 20: return (void*)(QHttpResponseHeader*)xptr;
        default: return xptr;
      }
    case 21:   //QIODevice
      switch(to) {
        case 42: return (void*)(QObject*)(QIODevice*)xptr;
        case 21: return (void*)(QIODevice*)xptr;
        case 39: return (void*)(QNetworkReply*)(QIODevice*)xptr;
        case 54: return (void*)(QUdpSocket*)(QIODevice*)xptr;
        case 2: return (void*)(QAbstractSocket*)(QIODevice*)xptr;
        case 50: return (void*)(QSslSocket*)(QIODevice*)xptr;
        case 52: return (void*)(QTcpSocket*)(QIODevice*)xptr;
        case 25: return (void*)(QLocalSocket*)(QIODevice*)xptr;
        default: return xptr;
      }
    case 22:   //QIPv6Address
      switch(to) {
        case 22: return (void*)(QIPv6Address*)xptr;
        default: return xptr;
      }
    case 23:   //QIncompatibleFlag
      switch(to) {
        case 23: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 24:   //QLocalServer
      switch(to) {
        case 42: return (void*)(QObject*)(QLocalServer*)xptr;
        case 24: return (void*)(QLocalServer*)xptr;
        default: return xptr;
      }
    case 25:   //QLocalSocket
      switch(to) {
        case 21: return (void*)(QIODevice*)(QLocalSocket*)xptr;
        case 42: return (void*)(QObject*)(QLocalSocket*)xptr;
        case 25: return (void*)(QLocalSocket*)xptr;
        default: return xptr;
      }
    case 26:   //QMetaObject
      switch(to) {
        case 26: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 27:   //QNetworkAccessManager
      switch(to) {
        case 42: return (void*)(QObject*)(QNetworkAccessManager*)xptr;
        case 27: return (void*)(QNetworkAccessManager*)xptr;
        default: return xptr;
      }
    case 28:   //QNetworkAddressEntry
      switch(to) {
        case 28: return (void*)(QNetworkAddressEntry*)xptr;
        default: return xptr;
      }
    case 29:   //QNetworkCacheMetaData
      switch(to) {
        case 29: return (void*)(QNetworkCacheMetaData*)xptr;
        default: return xptr;
      }
    case 30:   //QNetworkConfiguration
      switch(to) {
        case 30: return (void*)(QNetworkConfiguration*)xptr;
        default: return xptr;
      }
    case 31:   //QNetworkConfigurationManager
      switch(to) {
        case 42: return (void*)(QObject*)(QNetworkConfigurationManager*)xptr;
        case 31: return (void*)(QNetworkConfigurationManager*)xptr;
        default: return xptr;
      }
    case 32:   //QNetworkCookie
      switch(to) {
        case 32: return (void*)(QNetworkCookie*)xptr;
        default: return xptr;
      }
    case 33:   //QNetworkCookieJar
      switch(to) {
        case 42: return (void*)(QObject*)(QNetworkCookieJar*)xptr;
        case 33: return (void*)(QNetworkCookieJar*)xptr;
        default: return xptr;
      }
    case 34:   //QNetworkDiskCache
      switch(to) {
        case 1: return (void*)(QAbstractNetworkCache*)(QNetworkDiskCache*)xptr;
        case 42: return (void*)(QObject*)(QNetworkDiskCache*)xptr;
        case 34: return (void*)(QNetworkDiskCache*)xptr;
        default: return xptr;
      }
    case 35:   //QNetworkInterface
      switch(to) {
        case 35: return (void*)(QNetworkInterface*)xptr;
        default: return xptr;
      }
    case 36:   //QNetworkProxy
      switch(to) {
        case 36: return (void*)(QNetworkProxy*)xptr;
        default: return xptr;
      }
    case 37:   //QNetworkProxyFactory
      switch(to) {
        case 37: return (void*)(QNetworkProxyFactory*)xptr;
        default: return xptr;
      }
    case 38:   //QNetworkProxyQuery
      switch(to) {
        case 38: return (void*)(QNetworkProxyQuery*)xptr;
        default: return xptr;
      }
    case 39:   //QNetworkReply
      switch(to) {
        case 21: return (void*)(QIODevice*)(QNetworkReply*)xptr;
        case 42: return (void*)(QObject*)(QNetworkReply*)xptr;
        case 39: return (void*)(QNetworkReply*)xptr;
        default: return xptr;
      }
    case 40:   //QNetworkRequest
      switch(to) {
        case 40: return (void*)(QNetworkRequest*)xptr;
        default: return xptr;
      }
    case 41:   //QNetworkSession
      switch(to) {
        case 42: return (void*)(QObject*)(QNetworkSession*)xptr;
        case 41: return (void*)(QNetworkSession*)xptr;
        default: return xptr;
      }
    case 42:   //QObject
      switch(to) {
        case 42: return (void*)(QObject*)xptr;
        case 11: return (void*)(QFtp*)(QObject*)xptr;
        case 33: return (void*)(QNetworkCookieJar*)(QObject*)xptr;
        case 24: return (void*)(QLocalServer*)(QObject*)xptr;
        case 17: return (void*)(QHttpMultiPart*)(QObject*)xptr;
        case 39: return (void*)(QNetworkReply*)(QObject*)xptr;
        case 54: return (void*)(QUdpSocket*)(QObject*)xptr;
        case 1: return (void*)(QAbstractNetworkCache*)(QObject*)xptr;
        case 41: return (void*)(QNetworkSession*)(QObject*)xptr;
        case 2: return (void*)(QAbstractSocket*)(QObject*)xptr;
        case 15: return (void*)(QHttp*)(QObject*)xptr;
        case 50: return (void*)(QSslSocket*)(QObject*)xptr;
        case 27: return (void*)(QNetworkAccessManager*)(QObject*)xptr;
        case 52: return (void*)(QTcpSocket*)(QObject*)xptr;
        case 34: return (void*)(QNetworkDiskCache*)(QObject*)xptr;
        case 51: return (void*)(QTcpServer*)(QObject*)xptr;
        case 25: return (void*)(QLocalSocket*)(QObject*)xptr;
        case 31: return (void*)(QNetworkConfigurationManager*)(QObject*)xptr;
        default: return xptr;
      }
    case 43:   //QRegExp
      switch(to) {
        case 43: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 45:   //QSslCertificate
      switch(to) {
        case 45: return (void*)(QSslCertificate*)xptr;
        default: return xptr;
      }
    case 46:   //QSslCipher
      switch(to) {
        case 46: return (void*)(QSslCipher*)xptr;
        default: return xptr;
      }
    case 47:   //QSslConfiguration
      switch(to) {
        case 47: return (void*)(QSslConfiguration*)xptr;
        default: return xptr;
      }
    case 48:   //QSslError
      switch(to) {
        case 48: return (void*)(QSslError*)xptr;
        default: return xptr;
      }
    case 49:   //QSslKey
      switch(to) {
        case 49: return (void*)(QSslKey*)xptr;
        default: return xptr;
      }
    case 50:   //QSslSocket
      switch(to) {
        case 52: return (void*)(QTcpSocket*)(QSslSocket*)xptr;
        case 2: return (void*)(QAbstractSocket*)(QSslSocket*)xptr;
        case 21: return (void*)(QIODevice*)(QSslSocket*)xptr;
        case 42: return (void*)(QObject*)(QSslSocket*)xptr;
        case 50: return (void*)(QSslSocket*)xptr;
        default: return xptr;
      }
    case 51:   //QTcpServer
      switch(to) {
        case 42: return (void*)(QObject*)(QTcpServer*)xptr;
        case 51: return (void*)(QTcpServer*)xptr;
        default: return xptr;
      }
    case 52:   //QTcpSocket
      switch(to) {
        case 2: return (void*)(QAbstractSocket*)(QTcpSocket*)xptr;
        case 21: return (void*)(QIODevice*)(QTcpSocket*)xptr;
        case 42: return (void*)(QObject*)(QTcpSocket*)xptr;
        case 52: return (void*)(QTcpSocket*)xptr;
        case 50: return (void*)(QSslSocket*)(QTcpSocket*)xptr;
        default: return xptr;
      }
    case 53:   //QTimerEvent
      switch(to) {
        case 10: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 53: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 54:   //QUdpSocket
      switch(to) {
        case 2: return (void*)(QAbstractSocket*)(QUdpSocket*)xptr;
        case 21: return (void*)(QIODevice*)(QUdpSocket*)xptr;
        case 42: return (void*)(QObject*)(QUdpSocket*)xptr;
        case 54: return (void*)(QUdpSocket*)xptr;
        default: return xptr;
      }
    case 55:   //QUrl
      switch(to) {
        case 55: return (void*)(QUrl*)xptr;
        default: return xptr;
      }
    case 56:   //QUrlInfo
      switch(to) {
        case 56: return (void*)(QUrlInfo*)xptr;
        default: return xptr;
      }
    case 57:   //QVariant
      switch(to) {
        case 57: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 58:   //sockaddr
      switch(to) {
        case 58: return (void*)(sockaddr*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    42, 0,	// 1: QObject
    21, 0,	// 3: QIODevice
    16, 0,	// 5: QHttpHeader
    1, 0,	// 7: QAbstractNetworkCache
    52, 0,	// 9: QTcpSocket
    2, 0,	// 11: QAbstractSocket
};

// These are the xenum functions for manipulating enum pointers
void xenum_QSsl(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QSslSocket(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QNetworkAccessManager(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QFtp(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QNetworkConfigurationManager(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QNetworkConfiguration(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QHttp(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QSslCertificate(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QNetworkRequest(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QSslError(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QNetworkProxy(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QHostAddress(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QNetworkSession(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QNetworkCookie(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QAbstractSocket(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QNetworkProxyQuery(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QNetworkReply(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QLocalSocket(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QNetworkInterface(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QUrlInfo(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QHttpMultiPart(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QHostInfo(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QUdpSocket(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QAbstractNetworkCache(Smoke::Index, void*, Smoke::Stack);
void xcall_QAbstractSocket(Smoke::Index, void*, Smoke::Stack);
void xcall_QAuthenticator(Smoke::Index, void*, Smoke::Stack);
void xcall_QFtp(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_QHostAddress(Smoke::Index, void*, Smoke::Stack);
void xcall_QHostInfo(Smoke::Index, void*, Smoke::Stack);
void xcall_QHttp(Smoke::Index, void*, Smoke::Stack);
void xcall_QHttpHeader(Smoke::Index, void*, Smoke::Stack);
void xcall_QHttpMultiPart(Smoke::Index, void*, Smoke::Stack);
void xcall_QHttpPart(Smoke::Index, void*, Smoke::Stack);
void xcall_QHttpRequestHeader(Smoke::Index, void*, Smoke::Stack);
void xcall_QHttpResponseHeader(Smoke::Index, void*, Smoke::Stack);
void xcall_QIPv6Address(Smoke::Index, void*, Smoke::Stack);
void xcall_QLocalServer(Smoke::Index, void*, Smoke::Stack);
void xcall_QLocalSocket(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkAccessManager(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkAddressEntry(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkCacheMetaData(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkConfiguration(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkConfigurationManager(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkCookie(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkCookieJar(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkDiskCache(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkProxy(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkProxyFactory(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkProxyQuery(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkReply(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkRequest(Smoke::Index, void*, Smoke::Stack);
void xcall_QNetworkSession(Smoke::Index, void*, Smoke::Stack);
void xcall_QSsl(Smoke::Index, void*, Smoke::Stack);
void xcall_QSslCertificate(Smoke::Index, void*, Smoke::Stack);
void xcall_QSslCipher(Smoke::Index, void*, Smoke::Stack);
void xcall_QSslConfiguration(Smoke::Index, void*, Smoke::Stack);
void xcall_QSslError(Smoke::Index, void*, Smoke::Stack);
void xcall_QSslKey(Smoke::Index, void*, Smoke::Stack);
void xcall_QSslSocket(Smoke::Index, void*, Smoke::Stack);
void xcall_QTcpServer(Smoke::Index, void*, Smoke::Stack);
void xcall_QTcpSocket(Smoke::Index, void*, Smoke::Stack);
void xcall_QUdpSocket(Smoke::Index, void*, Smoke::Stack);
void xcall_QUrlInfo(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QAbstractNetworkCache", false, 1, xcall_QAbstractNetworkCache, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QAbstractNetworkCache) },	//1
    { "QAbstractSocket", false, 3, xcall_QAbstractSocket, xenum_QAbstractSocket, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QAbstractSocket) },	//2
    { "QAuthenticator", false, 0, xcall_QAuthenticator, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QAuthenticator) },	//3
    { "QBool", true, 0, 0, 0, 0, 0 },	//4
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//5
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//6
    { "QDataStream", true, 0, 0, 0, 0, 0 },	//7
    { "QDateTime", true, 0, 0, 0, 0, 0 },	//8
    { "QDebug", true, 0, 0, 0, 0, 0 },	//9
    { "QEvent", true, 0, 0, 0, 0, 0 },	//10
    { "QFtp", false, 1, xcall_QFtp, xenum_QFtp, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QFtp) },	//11
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//12
    { "QHostAddress", false, 0, xcall_QHostAddress, xenum_QHostAddress, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QHostAddress) },	//13
    { "QHostInfo", false, 0, xcall_QHostInfo, xenum_QHostInfo, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QHostInfo) },	//14
    { "QHttp", false, 1, xcall_QHttp, xenum_QHttp, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QHttp) },	//15
    { "QHttpHeader", false, 0, xcall_QHttpHeader, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QHttpHeader) },	//16
    { "QHttpMultiPart", false, 1, xcall_QHttpMultiPart, xenum_QHttpMultiPart, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QHttpMultiPart) },	//17
    { "QHttpPart", false, 0, xcall_QHttpPart, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QHttpPart) },	//18
    { "QHttpRequestHeader", false, 5, xcall_QHttpRequestHeader, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QHttpRequestHeader) },	//19
    { "QHttpResponseHeader", false, 5, xcall_QHttpResponseHeader, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QHttpResponseHeader) },	//20
    { "QIODevice", true, 0, 0, 0, 0, 0 },	//21
    { "QIPv6Address", false, 0, xcall_QIPv6Address, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QIPv6Address) },	//22
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//23
    { "QLocalServer", false, 1, xcall_QLocalServer, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QLocalServer) },	//24
    { "QLocalSocket", false, 3, xcall_QLocalSocket, xenum_QLocalSocket, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QLocalSocket) },	//25
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//26
    { "QNetworkAccessManager", false, 1, xcall_QNetworkAccessManager, xenum_QNetworkAccessManager, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QNetworkAccessManager) },	//27
    { "QNetworkAddressEntry", false, 0, xcall_QNetworkAddressEntry, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QNetworkAddressEntry) },	//28
    { "QNetworkCacheMetaData", false, 0, xcall_QNetworkCacheMetaData, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QNetworkCacheMetaData) },	//29
    { "QNetworkConfiguration", false, 0, xcall_QNetworkConfiguration, xenum_QNetworkConfiguration, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QNetworkConfiguration) },	//30
    { "QNetworkConfigurationManager", false, 1, xcall_QNetworkConfigurationManager, xenum_QNetworkConfigurationManager, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QNetworkConfigurationManager) },	//31
    { "QNetworkCookie", false, 0, xcall_QNetworkCookie, xenum_QNetworkCookie, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QNetworkCookie) },	//32
    { "QNetworkCookieJar", false, 1, xcall_QNetworkCookieJar, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QNetworkCookieJar) },	//33
    { "QNetworkDiskCache", false, 7, xcall_QNetworkDiskCache, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QNetworkDiskCache) },	//34
    { "QNetworkInterface", false, 0, xcall_QNetworkInterface, xenum_QNetworkInterface, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QNetworkInterface) },	//35
    { "QNetworkProxy", false, 0, xcall_QNetworkProxy, xenum_QNetworkProxy, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QNetworkProxy) },	//36
    { "QNetworkProxyFactory", false, 0, xcall_QNetworkProxyFactory, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QNetworkProxyFactory) },	//37
    { "QNetworkProxyQuery", false, 0, xcall_QNetworkProxyQuery, xenum_QNetworkProxyQuery, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QNetworkProxyQuery) },	//38
    { "QNetworkReply", false, 3, xcall_QNetworkReply, xenum_QNetworkReply, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QNetworkReply) },	//39
    { "QNetworkRequest", false, 0, xcall_QNetworkRequest, xenum_QNetworkRequest, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QNetworkRequest) },	//40
    { "QNetworkSession", false, 1, xcall_QNetworkSession, xenum_QNetworkSession, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QNetworkSession) },	//41
    { "QObject", true, 0, 0, 0, 0, 0 },	//42
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//43
    { "QSsl", false, 0, xcall_QSsl, xenum_QSsl, Smoke::cf_namespace, 0 },	//44
    { "QSslCertificate", false, 0, xcall_QSslCertificate, xenum_QSslCertificate, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QSslCertificate) },	//45
    { "QSslCipher", false, 0, xcall_QSslCipher, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QSslCipher) },	//46
    { "QSslConfiguration", false, 0, xcall_QSslConfiguration, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QSslConfiguration) },	//47
    { "QSslError", false, 0, xcall_QSslError, xenum_QSslError, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QSslError) },	//48
    { "QSslKey", false, 0, xcall_QSslKey, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QSslKey) },	//49
    { "QSslSocket", false, 9, xcall_QSslSocket, xenum_QSslSocket, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QSslSocket) },	//50
    { "QTcpServer", false, 1, xcall_QTcpServer, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QTcpServer) },	//51
    { "QTcpSocket", false, 11, xcall_QTcpSocket, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QTcpSocket) },	//52
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//53
    { "QUdpSocket", false, 11, xcall_QUdpSocket, xenum_QUdpSocket, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QUdpSocket) },	//54
    { "QUrl", true, 0, 0, 0, 0, 0 },	//55
    { "QUrlInfo", false, 0, xcall_QUrlInfo, xenum_QUrlInfo, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QUrlInfo) },	//56
    { "QVariant", true, 0, 0, 0, 0, 0 },	//57
    { "sockaddr", true, 0, 0, 0, 0, 0 },	//58
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QAbstractNetworkCache*", 1, Smoke::t_class|Smoke::tf_ptr },	//1
    { "QAbstractSocket*", 2, Smoke::t_class|Smoke::tf_ptr },	//2
    { "QAbstractSocket::NetworkLayerProtocol", 2, Smoke::t_enum|Smoke::tf_stack },	//3
    { "QAbstractSocket::SocketError", 2, Smoke::t_enum|Smoke::tf_stack },	//4
    { "QAbstractSocket::SocketOption", 2, Smoke::t_enum|Smoke::tf_stack },	//5
    { "QAbstractSocket::SocketState", 2, Smoke::t_enum|Smoke::tf_stack },	//6
    { "QAbstractSocket::SocketType", 2, Smoke::t_enum|Smoke::tf_stack },	//7
    { "QAuthenticator&", 3, Smoke::t_class|Smoke::tf_ref },	//8
    { "QAuthenticator*", 3, Smoke::t_class|Smoke::tf_ptr },	//9
    { "QBool", 4, Smoke::t_class|Smoke::tf_stack },	//10
    { "QByteArray", 5, Smoke::t_class|Smoke::tf_stack },	//11
    { "QChildEvent*", 6, Smoke::t_class|Smoke::tf_ptr },	//12
    { "QCryptographicHash::Algorithm", 0, Smoke::t_enum|Smoke::tf_stack },	//13
    { "QDataStream&", 7, Smoke::t_class|Smoke::tf_ref },	//14
    { "QDateTime", 8, Smoke::t_class|Smoke::tf_stack },	//15
    { "QDebug", 9, Smoke::t_class|Smoke::tf_stack },	//16
    { "QEvent*", 10, Smoke::t_class|Smoke::tf_ptr },	//17
    { "QFlags<QIODevice::OpenModeFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//18
    { "QFlags<QNetworkConfiguration::StateFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//19
    { "QFlags<QNetworkConfigurationManager::Capability>", 0, Smoke::t_uint|Smoke::tf_stack },	//20
    { "QFlags<QNetworkInterface::InterfaceFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//21
    { "QFlags<QNetworkProxy::Capability>", 0, Smoke::t_uint|Smoke::tf_stack },	//22
    { "QFlags<QSsl::SslOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//23
    { "QFlags<QUdpSocket::BindFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//24
    { "QFtp*", 11, Smoke::t_class|Smoke::tf_ptr },	//25
    { "QFtp::Command", 11, Smoke::t_enum|Smoke::tf_stack },	//26
    { "QFtp::Error", 11, Smoke::t_enum|Smoke::tf_stack },	//27
    { "QFtp::State", 11, Smoke::t_enum|Smoke::tf_stack },	//28
    { "QFtp::TransferMode", 11, Smoke::t_enum|Smoke::tf_stack },	//29
    { "QFtp::TransferType", 11, Smoke::t_enum|Smoke::tf_stack },	//30
    { "QHash<QNetworkRequest::Attribute,QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack },	//31
    { "QHash<QString,QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack },	//32
    { "QHostAddress", 13, Smoke::t_class|Smoke::tf_stack },	//33
    { "QHostAddress&", 13, Smoke::t_class|Smoke::tf_ref },	//34
    { "QHostAddress*", 13, Smoke::t_class|Smoke::tf_ptr },	//35
    { "QHostAddress::SpecialAddress", 13, Smoke::t_enum|Smoke::tf_stack },	//36
    { "QHostInfo", 14, Smoke::t_class|Smoke::tf_stack },	//37
    { "QHostInfo&", 14, Smoke::t_class|Smoke::tf_ref },	//38
    { "QHostInfo*", 14, Smoke::t_class|Smoke::tf_ptr },	//39
    { "QHostInfo::HostInfoError", 14, Smoke::t_enum|Smoke::tf_stack },	//40
    { "QHttp*", 15, Smoke::t_class|Smoke::tf_ptr },	//41
    { "QHttp::ConnectionMode", 15, Smoke::t_enum|Smoke::tf_stack },	//42
    { "QHttp::Error", 15, Smoke::t_enum|Smoke::tf_stack },	//43
    { "QHttp::State", 15, Smoke::t_enum|Smoke::tf_stack },	//44
    { "QHttpHeader&", 16, Smoke::t_class|Smoke::tf_ref },	//45
    { "QHttpHeader*", 16, Smoke::t_class|Smoke::tf_ptr },	//46
    { "QHttpMultiPart*", 17, Smoke::t_class|Smoke::tf_ptr },	//47
    { "QHttpMultiPart::ContentType", 17, Smoke::t_enum|Smoke::tf_stack },	//48
    { "QHttpPart&", 18, Smoke::t_class|Smoke::tf_ref },	//49
    { "QHttpPart*", 18, Smoke::t_class|Smoke::tf_ptr },	//50
    { "QHttpRequestHeader", 19, Smoke::t_class|Smoke::tf_stack },	//51
    { "QHttpRequestHeader&", 19, Smoke::t_class|Smoke::tf_ref },	//52
    { "QHttpRequestHeader*", 19, Smoke::t_class|Smoke::tf_ptr },	//53
    { "QHttpResponseHeader", 20, Smoke::t_class|Smoke::tf_stack },	//54
    { "QHttpResponseHeader&", 20, Smoke::t_class|Smoke::tf_ref },	//55
    { "QHttpResponseHeader*", 20, Smoke::t_class|Smoke::tf_ptr },	//56
    { "QIODevice*", 21, Smoke::t_class|Smoke::tf_ptr },	//57
    { "QIODevice::OpenMode", 0, Smoke::t_uint|Smoke::tf_stack },	//58
    { "QIODevice::OpenModeFlag", 21, Smoke::t_enum|Smoke::tf_stack },	//59
    { "QIPv6Address", 22, Smoke::t_class|Smoke::tf_stack },	//60
    { "QIPv6Address*", 22, Smoke::t_class|Smoke::tf_ptr },	//61
    { "QIncompatibleFlag", 23, Smoke::t_class|Smoke::tf_stack },	//62
    { "QIntegerForSizeof< void* >::Unsigned", 0, Smoke::t_voidp|Smoke::tf_stack },	//63
    { "QList<QByteArray>", 0, Smoke::t_voidp|Smoke::tf_stack },	//64
    { "QList<QHostAddress>", 0, Smoke::t_voidp|Smoke::tf_stack },	//65
    { "QList<QNetworkAddressEntry>", 0, Smoke::t_voidp|Smoke::tf_stack },	//66
    { "QList<QNetworkConfiguration>", 0, Smoke::t_voidp|Smoke::tf_stack },	//67
    { "QList<QNetworkCookie>", 0, Smoke::t_voidp|Smoke::tf_stack },	//68
    { "QList<QNetworkInterface>", 0, Smoke::t_voidp|Smoke::tf_stack },	//69
    { "QList<QNetworkProxy>", 0, Smoke::t_voidp|Smoke::tf_stack },	//70
    { "QList<QPair<QByteArray,QByteArray> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//71
    { "QList<QPair<QString,QString> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//72
    { "QList<QSslCertificate>", 0, Smoke::t_voidp|Smoke::tf_stack },	//73
    { "QList<QSslCipher>", 0, Smoke::t_voidp|Smoke::tf_stack },	//74
    { "QList<QSslError>", 0, Smoke::t_voidp|Smoke::tf_stack },	//75
    { "QLocalServer*", 24, Smoke::t_class|Smoke::tf_ptr },	//76
    { "QLocalSocket*", 25, Smoke::t_class|Smoke::tf_ptr },	//77
    { "QLocalSocket::LocalSocketError", 25, Smoke::t_enum|Smoke::tf_stack },	//78
    { "QLocalSocket::LocalSocketState", 25, Smoke::t_enum|Smoke::tf_stack },	//79
    { "QMetaObject::Call", 26, Smoke::t_enum|Smoke::tf_stack },	//80
    { "QMultiMap<QSsl::AlternateNameEntryType,QString>", 0, Smoke::t_voidp|Smoke::tf_stack },	//81
    { "QNetworkAccessManager*", 27, Smoke::t_class|Smoke::tf_ptr },	//82
    { "QNetworkAccessManager::NetworkAccessibility", 27, Smoke::t_enum|Smoke::tf_stack },	//83
    { "QNetworkAccessManager::Operation", 27, Smoke::t_enum|Smoke::tf_stack },	//84
    { "QNetworkAddressEntry", 28, Smoke::t_class|Smoke::tf_stack },	//85
    { "QNetworkAddressEntry&", 28, Smoke::t_class|Smoke::tf_ref },	//86
    { "QNetworkAddressEntry*", 28, Smoke::t_class|Smoke::tf_ptr },	//87
    { "QNetworkCacheMetaData", 29, Smoke::t_class|Smoke::tf_stack },	//88
    { "QNetworkCacheMetaData&", 29, Smoke::t_class|Smoke::tf_ref },	//89
    { "QNetworkCacheMetaData*", 29, Smoke::t_class|Smoke::tf_ptr },	//90
    { "QNetworkConfiguration", 30, Smoke::t_class|Smoke::tf_stack },	//91
    { "QNetworkConfiguration&", 30, Smoke::t_class|Smoke::tf_ref },	//92
    { "QNetworkConfiguration*", 30, Smoke::t_class|Smoke::tf_ptr },	//93
    { "QNetworkConfiguration::BearerType", 30, Smoke::t_enum|Smoke::tf_stack },	//94
    { "QNetworkConfiguration::Purpose", 30, Smoke::t_enum|Smoke::tf_stack },	//95
    { "QNetworkConfiguration::StateFlag", 30, Smoke::t_enum|Smoke::tf_stack },	//96
    { "QNetworkConfiguration::Type", 30, Smoke::t_enum|Smoke::tf_stack },	//97
    { "QNetworkConfigurationManager*", 31, Smoke::t_class|Smoke::tf_ptr },	//98
    { "QNetworkConfigurationManager::Capability", 31, Smoke::t_enum|Smoke::tf_stack },	//99
    { "QNetworkCookie", 32, Smoke::t_class|Smoke::tf_stack },	//100
    { "QNetworkCookie&", 32, Smoke::t_class|Smoke::tf_ref },	//101
    { "QNetworkCookie*", 32, Smoke::t_class|Smoke::tf_ptr },	//102
    { "QNetworkCookie::RawForm", 32, Smoke::t_enum|Smoke::tf_stack },	//103
    { "QNetworkCookieJar*", 33, Smoke::t_class|Smoke::tf_ptr },	//104
    { "QNetworkDiskCache*", 34, Smoke::t_class|Smoke::tf_ptr },	//105
    { "QNetworkInterface", 35, Smoke::t_class|Smoke::tf_stack },	//106
    { "QNetworkInterface&", 35, Smoke::t_class|Smoke::tf_ref },	//107
    { "QNetworkInterface*", 35, Smoke::t_class|Smoke::tf_ptr },	//108
    { "QNetworkInterface::InterfaceFlag", 35, Smoke::t_enum|Smoke::tf_stack },	//109
    { "QNetworkProxy", 36, Smoke::t_class|Smoke::tf_stack },	//110
    { "QNetworkProxy&", 36, Smoke::t_class|Smoke::tf_ref },	//111
    { "QNetworkProxy*", 36, Smoke::t_class|Smoke::tf_ptr },	//112
    { "QNetworkProxy::Capability", 36, Smoke::t_enum|Smoke::tf_stack },	//113
    { "QNetworkProxy::ProxyType", 36, Smoke::t_enum|Smoke::tf_stack },	//114
    { "QNetworkProxyFactory*", 37, Smoke::t_class|Smoke::tf_ptr },	//115
    { "QNetworkProxyQuery&", 38, Smoke::t_class|Smoke::tf_ref },	//116
    { "QNetworkProxyQuery*", 38, Smoke::t_class|Smoke::tf_ptr },	//117
    { "QNetworkProxyQuery::QueryType", 38, Smoke::t_enum|Smoke::tf_stack },	//118
    { "QNetworkReply*", 39, Smoke::t_class|Smoke::tf_ptr },	//119
    { "QNetworkReply::NetworkError", 39, Smoke::t_enum|Smoke::tf_stack },	//120
    { "QNetworkRequest", 40, Smoke::t_class|Smoke::tf_stack },	//121
    { "QNetworkRequest&", 40, Smoke::t_class|Smoke::tf_ref },	//122
    { "QNetworkRequest*", 40, Smoke::t_class|Smoke::tf_ptr },	//123
    { "QNetworkRequest::Attribute", 40, Smoke::t_enum|Smoke::tf_stack },	//124
    { "QNetworkRequest::CacheLoadControl", 40, Smoke::t_enum|Smoke::tf_stack },	//125
    { "QNetworkRequest::KnownHeaders", 40, Smoke::t_enum|Smoke::tf_stack },	//126
    { "QNetworkRequest::LoadControl", 40, Smoke::t_enum|Smoke::tf_stack },	//127
    { "QNetworkRequest::Priority", 40, Smoke::t_enum|Smoke::tf_stack },	//128
    { "QNetworkSession*", 41, Smoke::t_class|Smoke::tf_ptr },	//129
    { "QNetworkSession::SessionError", 41, Smoke::t_enum|Smoke::tf_stack },	//130
    { "QNetworkSession::State", 41, Smoke::t_enum|Smoke::tf_stack },	//131
    { "QObject*", 42, Smoke::t_class|Smoke::tf_ptr },	//132
    { "QPair<QByteArray,QByteArray>", 0, Smoke::t_voidp|Smoke::tf_stack },	//133
    { "QPair<QHostAddress,int>", 0, Smoke::t_voidp|Smoke::tf_stack },	//134
    { "QPair<QString,QString>", 0, Smoke::t_voidp|Smoke::tf_stack },	//135
    { "QRegExp&", 43, Smoke::t_class|Smoke::tf_ref },	//136
    { "QRegExp::PatternSyntax", 43, Smoke::t_enum|Smoke::tf_stack },	//137
    { "QSsl::AlternateNameEntryType", 44, Smoke::t_enum|Smoke::tf_stack },	//138
    { "QSsl::EncodingFormat", 44, Smoke::t_enum|Smoke::tf_stack },	//139
    { "QSsl::KeyAlgorithm", 44, Smoke::t_enum|Smoke::tf_stack },	//140
    { "QSsl::KeyType", 44, Smoke::t_enum|Smoke::tf_stack },	//141
    { "QSsl::SslOption", 44, Smoke::t_enum|Smoke::tf_stack },	//142
    { "QSsl::SslProtocol", 44, Smoke::t_enum|Smoke::tf_stack },	//143
    { "QSslCertificate", 45, Smoke::t_class|Smoke::tf_stack },	//144
    { "QSslCertificate&", 45, Smoke::t_class|Smoke::tf_ref },	//145
    { "QSslCertificate*", 45, Smoke::t_class|Smoke::tf_ptr },	//146
    { "QSslCertificate::SubjectInfo", 45, Smoke::t_enum|Smoke::tf_stack },	//147
    { "QSslCipher", 46, Smoke::t_class|Smoke::tf_stack },	//148
    { "QSslCipher&", 46, Smoke::t_class|Smoke::tf_ref },	//149
    { "QSslCipher*", 46, Smoke::t_class|Smoke::tf_ptr },	//150
    { "QSslConfiguration", 47, Smoke::t_class|Smoke::tf_stack },	//151
    { "QSslConfiguration&", 47, Smoke::t_class|Smoke::tf_ref },	//152
    { "QSslConfiguration*", 47, Smoke::t_class|Smoke::tf_ptr },	//153
    { "QSslError", 48, Smoke::t_class|Smoke::tf_stack },	//154
    { "QSslError&", 48, Smoke::t_class|Smoke::tf_ref },	//155
    { "QSslError*", 48, Smoke::t_class|Smoke::tf_ptr },	//156
    { "QSslError::SslError", 48, Smoke::t_enum|Smoke::tf_stack },	//157
    { "QSslKey", 49, Smoke::t_class|Smoke::tf_stack },	//158
    { "QSslKey&", 49, Smoke::t_class|Smoke::tf_ref },	//159
    { "QSslKey*", 49, Smoke::t_class|Smoke::tf_ptr },	//160
    { "QSslSocket*", 50, Smoke::t_class|Smoke::tf_ptr },	//161
    { "QSslSocket::PeerVerifyMode", 50, Smoke::t_enum|Smoke::tf_stack },	//162
    { "QSslSocket::SslMode", 50, Smoke::t_enum|Smoke::tf_stack },	//163
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//164
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//165
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//166
    { "QTcpServer*", 51, Smoke::t_class|Smoke::tf_ptr },	//167
    { "QTcpSocket*", 52, Smoke::t_class|Smoke::tf_ptr },	//168
    { "QTimerEvent*", 53, Smoke::t_class|Smoke::tf_ptr },	//169
    { "QUdpSocket*", 54, Smoke::t_class|Smoke::tf_ptr },	//170
    { "QUdpSocket::BindFlag", 54, Smoke::t_enum|Smoke::tf_stack },	//171
    { "QUrl", 55, Smoke::t_class|Smoke::tf_stack },	//172
    { "QUrlInfo", 56, Smoke::t_class|Smoke::tf_stack },	//173
    { "QUrlInfo&", 56, Smoke::t_class|Smoke::tf_ref },	//174
    { "QUrlInfo*", 56, Smoke::t_class|Smoke::tf_ptr },	//175
    { "QUrlInfo::PermissionSpec", 56, Smoke::t_enum|Smoke::tf_stack },	//176
    { "QVariant", 57, Smoke::t_class|Smoke::tf_stack },	//177
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//178
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//179
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//180
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//181
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//182
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//183
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//184
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//185
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//186
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//187
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//188
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//189
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//190
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//191
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//192
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//193
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//194
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//195
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//196
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//197
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//198
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//199
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//200
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//201
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//202
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//203
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//204
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//205
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//206
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//207
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//208
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//209
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//210
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//211
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//212
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//213
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//214
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//215
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//216
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//217
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//218
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//219
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//220
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//221
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//222
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//223
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//224
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//225
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//226
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//227
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//228
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//229
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//230
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//231
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//232
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//233
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//234
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//235
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//236
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//237
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//238
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//239
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//240
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//241
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//242
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//243
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//244
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//245
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//246
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//247
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//248
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//249
    { "QtConcurrent::ReduceOption", 0, Smoke::t_enum|Smoke::tf_stack },	//250
    { "QtConcurrent::ThreadFunctionResult", 0, Smoke::t_enum|Smoke::tf_stack },	//251
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//252
    { "bool*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//253
    { "char*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//254
    { "const QAuthenticator&", 3, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//255
    { "const QByteArray&", 5, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//256
    { "const QDateTime&", 8, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//257
    { "const QHash<QNetworkRequest::Attribute,QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//258
    { "const QHostAddress&", 13, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//259
    { "const QHostInfo&", 14, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//260
    { "const QHttpHeader&", 16, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//261
    { "const QHttpPart&", 18, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//262
    { "const QHttpRequestHeader&", 19, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//263
    { "const QHttpResponseHeader&", 20, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//264
    { "const QIPv6Address&", 22, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//265
    { "const QList<QHostAddress>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//266
    { "const QList<QNetworkCookie>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//267
    { "const QList<QPair<QByteArray,QByteArray> >&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//268
    { "const QList<QPair<QString,QString> >&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//269
    { "const QList<QSslCertificate>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//270
    { "const QList<QSslCipher>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//271
    { "const QList<QSslError>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//272
    { "const QMetaObject&", 26, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//273
    { "const QMetaObject*", 26, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//274
    { "const QNetworkAddressEntry&", 28, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//275
    { "const QNetworkCacheMetaData&", 29, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//276
    { "const QNetworkConfiguration&", 30, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//277
    { "const QNetworkCookie&", 32, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//278
    { "const QNetworkInterface&", 35, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//279
    { "const QNetworkProxy&", 36, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//280
    { "const QNetworkProxyFactory&", 37, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//281
    { "const QNetworkProxyQuery&", 38, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//282
    { "const QNetworkRequest&", 40, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//283
    { "const QPair<QHostAddress,int>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//284
    { "const QRegExp&", 43, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//285
    { "const QSslCertificate&", 45, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//286
    { "const QSslCipher&", 46, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//287
    { "const QSslConfiguration&", 47, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//288
    { "const QSslError&", 48, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//289
    { "const QSslError::SslError&", 48, Smoke::t_enum|Smoke::tf_ref|Smoke::tf_const },	//290
    { "const QSslKey&", 49, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//291
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//292
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//293
    { "const QUrl&", 55, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//294
    { "const QUrlInfo&", 56, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//295
    { "const QVariant&", 57, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//296
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//297
    { "const sockaddr*", 58, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//298
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//299
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//300
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//301
    { "long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//302
    { "qint64", 0, Smoke::t_voidp|Smoke::tf_stack },	//303
    { "quint16", 0, Smoke::t_ushort|Smoke::tf_stack },	//304
    { "unsigned char", 0, Smoke::t_uchar|Smoke::tf_stack },	//305
    { "unsigned char&", 0, Smoke::t_voidp|Smoke::tf_ref },	//306
    { "unsigned char*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//307
    { "unsigned int", 0, Smoke::t_uint|Smoke::tf_stack },	//308
    { "unsigned long", 0, Smoke::t_ulong|Smoke::tf_stack },	//309
    { "unsigned long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//310
    { "unsigned short", 0, Smoke::t_ushort|Smoke::tf_stack },	//311
    { "unsigned short*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//312
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//313
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//314
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//315
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    297, 0,	//1  const char*
    297, 297, 0,	//3  const char*, const char*
    297, 297, 300, 0,	//6  const char*, const char*, int
    80, 300, 314, 0,	//10  QMetaObject::Call, int, void**
    294, 0,	//14  const QUrl&
    276, 0,	//16  const QNetworkCacheMetaData&
    57, 0,	//18  QIODevice*
    132, 0,	//20  QObject*
    7, 132, 0,	//22  QAbstractSocket::SocketType, QObject*
    292, 311, 18, 0,	//25  const QString&, unsigned short, QFlags<QIODevice::OpenModeFlag>
    259, 311, 18, 0,	//29  const QHostAddress&, unsigned short, QFlags<QIODevice::OpenModeFlag>
    302, 0,	//33  long long
    300, 6, 18, 0,	//35  int, QAbstractSocket::SocketState, QFlags<QIODevice::OpenModeFlag>
    5, 296, 0,	//39  QAbstractSocket::SocketOption, const QVariant&
    5, 0,	//42  QAbstractSocket::SocketOption
    300, 0,	//44  int
    280, 0,	//46  const QNetworkProxy&
    6, 0,	//48  QAbstractSocket::SocketState
    4, 0,	//50  QAbstractSocket::SocketError
    280, 9, 0,	//52  const QNetworkProxy&, QAuthenticator*
    292, 304, 58, 0,	//55  const QString&, quint16, QIODevice::OpenMode
    254, 302, 0,	//59  char*, long long
    297, 302, 0,	//62  const char*, long long
    311, 0,	//65  unsigned short
    259, 0,	//67  const QHostAddress&
    292, 0,	//69  const QString&
    292, 311, 0,	//71  const QString&, unsigned short
    259, 311, 0,	//74  const QHostAddress&, unsigned short
    300, 6, 0,	//77  int, QAbstractSocket::SocketState
    292, 304, 0,	//80  const QString&, quint16
    255, 0,	//83  const QAuthenticator&
    292, 296, 0,	//85  const QString&, const QVariant&
    292, 292, 0,	//88  const QString&, const QString&
    29, 0,	//91  QFtp::TransferMode
    292, 57, 30, 0,	//93  const QString&, QIODevice*, QFtp::TransferType
    256, 292, 30, 0,	//97  const QByteArray&, const QString&, QFtp::TransferType
    57, 292, 30, 0,	//101  QIODevice*, const QString&, QFtp::TransferType
    295, 0,	//105  const QUrlInfo&
    303, 303, 0,	//107  qint64, qint64
    300, 292, 0,	//110  int, const QString&
    300, 252, 0,	//113  int, bool
    252, 0,	//116  bool
    292, 57, 0,	//118  const QString&, QIODevice*
    256, 292, 0,	//121  const QByteArray&, const QString&
    57, 292, 0,	//124  QIODevice*, const QString&
    16, 259, 0,	//127  QDebug, const QHostAddress&
    16, 78, 0,	//130  QDebug, QLocalSocket::LocalSocketError
    14, 259, 0,	//133  QDataStream&, const QHostAddress&
    16, 290, 0,	//136  QDebug, const QSslError::SslError&
    16, 286, 0,	//139  QDebug, const QSslCertificate&
    109, 109, 0,	//142  QNetworkInterface::InterfaceFlag, QNetworkInterface::InterfaceFlag
    109, 21, 0,	//145  QNetworkInterface::InterfaceFlag, QFlags<QNetworkInterface::InterfaceFlag>
    36, 259, 0,	//148  QHostAddress::SpecialAddress, const QHostAddress&
    171, 300, 0,	//151  QUdpSocket::BindFlag, int
    171, 24, 0,	//154  QUdpSocket::BindFlag, QFlags<QUdpSocket::BindFlag>
    16, 289, 0,	//157  QDebug, const QSslError&
    16, 6, 0,	//160  QDebug, QAbstractSocket::SocketState
    16, 4, 0,	//163  QDebug, QAbstractSocket::SocketError
    142, 300, 0,	//166  QSsl::SslOption, int
    16, 147, 0,	//169  QDebug, QSslCertificate::SubjectInfo
    16, 291, 0,	//172  QDebug, const QSslKey&
    14, 34, 0,	//175  QDataStream&, QHostAddress&
    14, 276, 0,	//178  QDataStream&, const QNetworkCacheMetaData&
    113, 113, 0,	//181  QNetworkProxy::Capability, QNetworkProxy::Capability
    99, 20, 0,	//184  QNetworkConfigurationManager::Capability, QFlags<QNetworkConfigurationManager::Capability>
    171, 171, 0,	//187  QUdpSocket::BindFlag, QUdpSocket::BindFlag
    113, 300, 0,	//190  QNetworkProxy::Capability, int
    16, 278, 0,	//193  QDebug, const QNetworkCookie&
    16, 79, 0,	//196  QDebug, QLocalSocket::LocalSocketState
    16, 279, 0,	//199  QDebug, const QNetworkInterface&
    16, 287, 0,	//202  QDebug, const QSslCipher&
    14, 89, 0,	//205  QDataStream&, QNetworkCacheMetaData&
    142, 142, 0,	//208  QSsl::SslOption, QSsl::SslOption
    113, 22, 0,	//211  QNetworkProxy::Capability, QFlags<QNetworkProxy::Capability>
    109, 300, 0,	//214  QNetworkInterface::InterfaceFlag, int
    99, 99, 0,	//217  QNetworkConfigurationManager::Capability, QNetworkConfigurationManager::Capability
    142, 23, 0,	//220  QSsl::SslOption, QFlags<QSsl::SslOption>
    99, 300, 0,	//223  QNetworkConfigurationManager::Capability, int
    308, 0,	//226  unsigned int
    307, 0,	//228  unsigned char*
    265, 0,	//230  const QIPv6Address&
    298, 0,	//232  const sockaddr*
    36, 0,	//234  QHostAddress::SpecialAddress
    259, 300, 0,	//236  const QHostAddress&, int
    284, 0,	//239  const QPair<QHostAddress,int>&
    260, 0,	//241  const QHostInfo&
    266, 0,	//243  const QList<QHostAddress>&
    40, 0,	//245  QHostInfo::HostInfoError
    292, 132, 297, 0,	//247  const QString&, QObject*, const char*
    292, 311, 132, 0,	//251  const QString&, unsigned short, QObject*
    292, 42, 311, 132, 0,	//255  const QString&, QHttp::ConnectionMode, unsigned short, QObject*
    292, 42, 311, 0,	//260  const QString&, QHttp::ConnectionMode, unsigned short
    168, 0,	//264  QTcpSocket*
    292, 300, 292, 292, 0,	//266  const QString&, int, const QString&, const QString&
    292, 57, 57, 0,	//271  const QString&, QIODevice*, QIODevice*
    292, 256, 57, 0,	//275  const QString&, const QByteArray&, QIODevice*
    263, 57, 57, 0,	//279  const QHttpRequestHeader&, QIODevice*, QIODevice*
    263, 256, 57, 0,	//283  const QHttpRequestHeader&, const QByteArray&, QIODevice*
    264, 0,	//287  const QHttpResponseHeader&
    300, 300, 0,	//289  int, int
    292, 304, 9, 0,	//292  const QString&, quint16, QAuthenticator*
    272, 0,	//296  const QList<QSslError>&
    292, 42, 0,	//298  const QString&, QHttp::ConnectionMode
    292, 300, 0,	//301  const QString&, int
    292, 300, 292, 0,	//304  const QString&, int, const QString&
    292, 256, 0,	//308  const QString&, const QByteArray&
    263, 0,	//311  const QHttpRequestHeader&
    263, 57, 0,	//313  const QHttpRequestHeader&, QIODevice*
    263, 256, 0,	//316  const QHttpRequestHeader&, const QByteArray&
    261, 0,	//319  const QHttpHeader&
    269, 0,	//321  const QList<QPair<QString,QString> >&
    48, 132, 0,	//323  QHttpMultiPart::ContentType, QObject*
    262, 0,	//326  const QHttpPart&
    48, 0,	//328  QHttpMultiPart::ContentType
    256, 0,	//330  const QByteArray&
    126, 296, 0,	//332  QNetworkRequest::KnownHeaders, const QVariant&
    256, 256, 0,	//335  const QByteArray&, const QByteArray&
    292, 292, 300, 300, 0,	//338  const QString&, const QString&, int, int
    292, 292, 300, 0,	//343  const QString&, const QString&, int
    300, 292, 300, 300, 0,	//347  int, const QString&, int, int
    300, 292, 300, 0,	//352  int, const QString&, int
    18, 0,	//356  QFlags<QIODevice::OpenModeFlag>
    300, 253, 0,	//358  int, bool*
    63, 0,	//361  QIntegerForSizeof< void* >::Unsigned
    292, 18, 0,	//363  const QString&, QFlags<QIODevice::OpenModeFlag>
    63, 79, 18, 0,	//366  QIntegerForSizeof< void* >::Unsigned, QLocalSocket::LocalSocketState, QFlags<QIODevice::OpenModeFlag>
    78, 0,	//370  QLocalSocket::LocalSocketError
    79, 0,	//372  QLocalSocket::LocalSocketState
    63, 79, 0,	//374  QIntegerForSizeof< void* >::Unsigned, QLocalSocket::LocalSocketState
    115, 0,	//377  QNetworkProxyFactory*
    1, 0,	//379  QAbstractNetworkCache*
    104, 0,	//381  QNetworkCookieJar*
    283, 0,	//383  const QNetworkRequest&
    283, 57, 0,	//385  const QNetworkRequest&, QIODevice*
    283, 256, 0,	//388  const QNetworkRequest&, const QByteArray&
    283, 47, 0,	//391  const QNetworkRequest&, QHttpMultiPart*
    283, 256, 57, 0,	//394  const QNetworkRequest&, const QByteArray&, QIODevice*
    277, 0,	//398  const QNetworkConfiguration&
    83, 0,	//400  QNetworkAccessManager::NetworkAccessibility
    119, 9, 0,	//402  QNetworkReply*, QAuthenticator*
    119, 0,	//405  QNetworkReply*
    119, 272, 0,	//407  QNetworkReply*, const QList<QSslError>&
    84, 283, 57, 0,	//410  QNetworkAccessManager::Operation, const QNetworkRequest&, QIODevice*
    84, 283, 0,	//414  QNetworkAccessManager::Operation, const QNetworkRequest&
    275, 0,	//417  const QNetworkAddressEntry&
    268, 0,	//419  const QList<QPair<QByteArray,QByteArray> >&
    257, 0,	//421  const QDateTime&
    258, 0,	//423  const QHash<QNetworkRequest::Attribute,QVariant>&
    19, 0,	//425  QFlags<QNetworkConfiguration::StateFlag>
    278, 0,	//427  const QNetworkCookie&
    103, 0,	//429  QNetworkCookie::RawForm
    267, 294, 0,	//431  const QList<QNetworkCookie>&, const QUrl&
    267, 0,	//434  const QList<QNetworkCookie>&
    279, 0,	//436  const QNetworkInterface&
    114, 292, 311, 292, 292, 0,	//438  QNetworkProxy::ProxyType, const QString&, unsigned short, const QString&, const QString&
    114, 0,	//444  QNetworkProxy::ProxyType
    22, 0,	//446  QFlags<QNetworkProxy::Capability>
    114, 292, 0,	//448  QNetworkProxy::ProxyType, const QString&
    114, 292, 311, 0,	//451  QNetworkProxy::ProxyType, const QString&, unsigned short
    114, 292, 311, 292, 0,	//455  QNetworkProxy::ProxyType, const QString&, unsigned short, const QString&
    282, 0,	//460  const QNetworkProxyQuery&
    281, 0,	//462  const QNetworkProxyFactory&
    294, 118, 0,	//464  const QUrl&, QNetworkProxyQuery::QueryType
    292, 300, 292, 118, 0,	//467  const QString&, int, const QString&, QNetworkProxyQuery::QueryType
    311, 292, 118, 0,	//472  unsigned short, const QString&, QNetworkProxyQuery::QueryType
    277, 294, 118, 0,	//476  const QNetworkConfiguration&, const QUrl&, QNetworkProxyQuery::QueryType
    277, 292, 300, 292, 118, 0,	//480  const QNetworkConfiguration&, const QString&, int, const QString&, QNetworkProxyQuery::QueryType
    277, 311, 292, 118, 0,	//486  const QNetworkConfiguration&, unsigned short, const QString&, QNetworkProxyQuery::QueryType
    118, 0,	//491  QNetworkProxyQuery::QueryType
    311, 292, 0,	//493  unsigned short, const QString&
    277, 294, 0,	//496  const QNetworkConfiguration&, const QUrl&
    277, 292, 300, 0,	//499  const QNetworkConfiguration&, const QString&, int
    277, 292, 300, 292, 0,	//503  const QNetworkConfiguration&, const QString&, int, const QString&
    277, 311, 0,	//508  const QNetworkConfiguration&, unsigned short
    277, 311, 292, 0,	//511  const QNetworkConfiguration&, unsigned short, const QString&
    126, 0,	//515  QNetworkRequest::KnownHeaders
    124, 0,	//517  QNetworkRequest::Attribute
    288, 0,	//519  const QSslConfiguration&
    120, 0,	//521  QNetworkReply::NetworkError
    84, 0,	//523  QNetworkAccessManager::Operation
    120, 292, 0,	//525  QNetworkReply::NetworkError, const QString&
    124, 296, 0,	//528  QNetworkRequest::Attribute, const QVariant&
    128, 0,	//531  QNetworkRequest::Priority
    277, 132, 0,	//533  const QNetworkConfiguration&, QObject*
    131, 0,	//536  QNetworkSession::State
    130, 0,	//538  QNetworkSession::SessionError
    277, 252, 0,	//540  const QNetworkConfiguration&, bool
    17, 0,	//543  QEvent*
    132, 17, 0,	//545  QObject*, QEvent*
    169, 0,	//548  QTimerEvent*
    12, 0,	//550  QChildEvent*
    57, 139, 0,	//552  QIODevice*, QSsl::EncodingFormat
    256, 139, 0,	//555  const QByteArray&, QSsl::EncodingFormat
    286, 0,	//558  const QSslCertificate&
    13, 0,	//560  QCryptographicHash::Algorithm
    147, 0,	//562  QSslCertificate::SubjectInfo
    292, 139, 137, 0,	//564  const QString&, QSsl::EncodingFormat, QRegExp::PatternSyntax
    292, 139, 0,	//568  const QString&, QSsl::EncodingFormat
    292, 143, 0,	//571  const QString&, QSsl::SslProtocol
    287, 0,	//574  const QSslCipher&
    143, 0,	//576  QSsl::SslProtocol
    162, 0,	//578  QSslSocket::PeerVerifyMode
    291, 0,	//580  const QSslKey&
    271, 0,	//582  const QList<QSslCipher>&
    270, 0,	//584  const QList<QSslCertificate>&
    142, 252, 0,	//586  QSsl::SslOption, bool
    142, 0,	//589  QSsl::SslOption
    157, 0,	//591  QSslError::SslError
    157, 286, 0,	//593  QSslError::SslError, const QSslCertificate&
    289, 0,	//596  const QSslError&
    256, 140, 139, 141, 256, 0,	//598  const QByteArray&, QSsl::KeyAlgorithm, QSsl::EncodingFormat, QSsl::KeyType, const QByteArray&
    57, 140, 139, 141, 256, 0,	//604  QIODevice*, QSsl::KeyAlgorithm, QSsl::EncodingFormat, QSsl::KeyType, const QByteArray&
    256, 140, 0,	//610  const QByteArray&, QSsl::KeyAlgorithm
    256, 140, 139, 0,	//613  const QByteArray&, QSsl::KeyAlgorithm, QSsl::EncodingFormat
    256, 140, 139, 141, 0,	//617  const QByteArray&, QSsl::KeyAlgorithm, QSsl::EncodingFormat, QSsl::KeyType
    57, 140, 0,	//622  QIODevice*, QSsl::KeyAlgorithm
    57, 140, 139, 0,	//625  QIODevice*, QSsl::KeyAlgorithm, QSsl::EncodingFormat
    57, 140, 139, 141, 0,	//629  QIODevice*, QSsl::KeyAlgorithm, QSsl::EncodingFormat, QSsl::KeyType
    292, 311, 292, 18, 0,	//634  const QString&, unsigned short, const QString&, QFlags<QIODevice::OpenModeFlag>
    292, 140, 139, 256, 0,	//639  const QString&, QSsl::KeyAlgorithm, QSsl::EncodingFormat, const QByteArray&
    163, 0,	//644  QSslSocket::SslMode
    303, 0,	//646  qint64
    292, 311, 292, 0,	//648  const QString&, unsigned short, const QString&
    292, 140, 0,	//652  const QString&, QSsl::KeyAlgorithm
    292, 140, 139, 0,	//655  const QString&, QSsl::KeyAlgorithm, QSsl::EncodingFormat
    259, 311, 24, 0,	//659  const QHostAddress&, unsigned short, QFlags<QUdpSocket::BindFlag>
    311, 24, 0,	//663  unsigned short, QFlags<QUdpSocket::BindFlag>
    259, 279, 0,	//666  const QHostAddress&, const QNetworkInterface&
    254, 302, 35, 312, 0,	//669  char*, long long, QHostAddress*, unsigned short*
    297, 302, 259, 311, 0,	//674  const char*, long long, const QHostAddress&, unsigned short
    256, 259, 311, 0,	//679  const QByteArray&, const QHostAddress&, unsigned short
    254, 302, 35, 0,	//683  char*, long long, QHostAddress*
    292, 300, 292, 292, 302, 257, 257, 252, 252, 252, 252, 252, 252, 0,	//687  const QString&, int, const QString&, const QString&, long long, const QDateTime&, const QDateTime&, bool, bool, bool, bool, bool, bool
    294, 300, 292, 292, 302, 257, 257, 252, 252, 252, 252, 252, 252, 0,	//701  const QUrl&, int, const QString&, const QString&, long long, const QDateTime&, const QDateTime&, bool, bool, bool, bool, bool, bool
    295, 295, 300, 0,	//715  const QUrlInfo&, const QUrlInfo&, int
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "Aborted",	//1
    "Accessible",	//2
    "Active",	//3
    "AddressInUseError",	//4
    "AlternativeType",	//5
    "AlwaysCache",	//6
    "AlwaysNetwork",	//7
    "Any",	//8
    "AnyIPv6",	//9
    "AnyProtocol",	//10
    "Append",	//11
    "ApplicationLevelRoaming",	//12
    "Ascii",	//13
    "AuthenticationRequiredError",	//14
    "AuthenticationReuseAttribute",	//15
    "AuthorityIssuerSerialNumberMismatch",	//16
    "AutoVerifyPeer",	//17
    "Automatic",	//18
    "Bearer2G",	//19
    "BearerBluetooth",	//20
    "BearerCDMA2000",	//21
    "BearerEthernet",	//22
    "BearerHSPA",	//23
    "BearerUnknown",	//24
    "BearerWCDMA",	//25
    "BearerWLAN",	//26
    "BearerWiMAX",	//27
    "Binary",	//28
    "BoundState",	//29
    "Broadcast",	//30
    "CacheLoadControlAttribute",	//31
    "CacheSaveControlAttribute",	//32
    "CachingCapability",	//33
    "CanBroadcast",	//34
    "CanMulticast",	//35
    "CanStartAndStopInterfaces",	//36
    "Cd",	//37
    "CertificateBlacklisted",	//38
    "CertificateExpired",	//39
    "CertificateNotYetValid",	//40
    "CertificateRejected",	//41
    "CertificateRevoked",	//42
    "CertificateSignatureFailed",	//43
    "CertificateUntrusted",	//44
    "Close",	//45
    "Closing",	//46
    "ClosingState",	//47
    "CommonName",	//48
    "ConnectToHost",	//49
    "Connected",	//50
    "ConnectedState",	//51
    "Connecting",	//52
    "ConnectingState",	//53
    "ConnectionEncryptedAttribute",	//54
    "ConnectionError",	//55
    "ConnectionModeHttp",	//56
    "ConnectionModeHttps",	//57
    "ConnectionRefused",	//58
    "ConnectionRefusedError",	//59
    "ContentAccessDenied",	//60
    "ContentDispositionHeader",	//61
    "ContentLengthHeader",	//62
    "ContentNotFoundError",	//63
    "ContentOperationNotPermittedError",	//64
    "ContentReSendError",	//65
    "ContentTypeHeader",	//66
    "CookieHeader",	//67
    "CookieLoadControlAttribute",	//68
    "CookieSaveControlAttribute",	//69
    "CountryName",	//70
    "CustomOperation",	//71
    "CustomVerbAttribute",	//72
    "DataStatistics",	//73
    "DatagramTooLargeError",	//74
    "DefaultForPlatform",	//75
    "DefaultProxy",	//76
    "Defined",	//77
    "DeleteOperation",	//78
    "Der",	//79
    "DirectConnectionRouting",	//80
    "Disconnected",	//81
    "Discovered",	//82
    "DnsEntry",	//83
    "DoNotBufferUploadDataAttribute",	//84
    "DontShareAddress",	//85
    "DownloadBufferAttribute",	//86
    "Dsa",	//87
    "EmailEntry",	//88
    "ExeGroup",	//89
    "ExeOther",	//90
    "ExeOwner",	//91
    "ForcedRoaming",	//92
    "FormDataType",	//93
    "FtpCachingProxy",	//94
    "Full",	//95
    "Get",	//96
    "GetOperation",	//97
    "HeadOperation",	//98
    "HighPriority",	//99
    "HostLookup",	//100
    "HostLookupState",	//101
    "HostNameLookupCapability",	//102
    "HostNameMismatch",	//103
    "HostNotFound",	//104
    "HostNotFoundError",	//105
    "HttpCachingProxy",	//106
    "HttpPipeliningAllowedAttribute",	//107
    "HttpPipeliningWasUsedAttribute",	//108
    "HttpProxy",	//109
    "HttpReasonPhraseAttribute",	//110
    "HttpStatusCodeAttribute",	//111
    "IPv4Protocol",	//112
    "IPv6Protocol",	//113
    "InternetAccessPoint",	//114
    "Invalid",	//115
    "InvalidCaCertificate",	//116
    "InvalidConfigurationError",	//117
    "InvalidNotAfterField",	//118
    "InvalidNotBeforeField",	//119
    "InvalidPurpose",	//120
    "InvalidResponseHeader",	//121
    "IsLoopBack",	//122
    "IsPointToPoint",	//123
    "IsRunning",	//124
    "IsUp",	//125
    "KeepAliveOption",	//126
    "LastModifiedHeader",	//127
    "List",	//128
    "ListeningCapability",	//129
    "ListeningState",	//130
    "LocalHost",	//131
    "LocalHostIPv6",	//132
    "LocalityName",	//133
    "LocationHeader",	//134
    "LoggedIn",	//135
    "Login",	//136
    "LowDelayOption",	//137
    "LowPriority",	//138
    "Manual",	//139
    "MaximumDownloadBufferSizeAttribute",	//140
    "MixedType",	//141
    "Mkdir",	//142
    "MulticastLoopbackOption",	//143
    "MulticastTtlOption",	//144
    "NameAndValueOnly",	//145
    "NetworkError",	//146
    "NetworkSessionRequired",	//147
    "NoError",	//148
    "NoPeerCertificate",	//149
    "NoProxy",	//150
    "NoSslSupport",	//151
    "None",	//152
    "NormalPriority",	//153
    "NotAccessible",	//154
    "NotAvailable",	//155
    "NotConnected",	//156
    "NotOpen",	//157
    "Null",	//158
    "OperationCanceledError",	//159
    "OperationNotSupportedError",	//160
    "Organization",	//161
    "OrganizationalUnitName",	//162
    "Passive",	//163
    "PathLengthExceeded",	//164
    "PeerClosedError",	//165
    "Pem",	//166
    "PostOperation",	//167
    "PreferCache",	//168
    "PreferNetwork",	//169
    "PrivateKey",	//170
    "PrivatePurpose",	//171
    "ProtocolFailure",	//172
    "ProtocolInvalidOperationError",	//173
    "ProtocolUnknownError",	//174
    "ProxyAuthenticationRequiredError",	//175
    "ProxyConnectionClosedError",	//176
    "ProxyConnectionRefusedError",	//177
    "ProxyConnectionTimeoutError",	//178
    "ProxyNotFoundError",	//179
    "ProxyProtocolError",	//180
    "ProxyTimeoutError",	//181
    "PublicKey",	//182
    "PublicPurpose",	//183
    "Put",	//184
    "PutOperation",	//185
    "QAbstractNetworkCache",	//186
    "QAbstractNetworkCache#",	//187
    "QAbstractSocket",	//188
    "QAbstractSocket$#",	//189
    "QAuthenticator",	//190
    "QAuthenticator#",	//191
    "QFtp",	//192
    "QFtp#",	//193
    "QHostAddress",	//194
    "QHostAddress#",	//195
    "QHostAddress$",	//196
    "QHostInfo",	//197
    "QHostInfo#",	//198
    "QHostInfo$",	//199
    "QHttp",	//200
    "QHttp#",	//201
    "QHttp$",	//202
    "QHttp$$",	//203
    "QHttp$$#",	//204
    "QHttp$$$",	//205
    "QHttp$$$#",	//206
    "QHttpHeader",	//207
    "QHttpHeader#",	//208
    "QHttpHeader$",	//209
    "QHttpMultiPart",	//210
    "QHttpMultiPart#",	//211
    "QHttpMultiPart$",	//212
    "QHttpMultiPart$#",	//213
    "QHttpPart",	//214
    "QHttpPart#",	//215
    "QHttpRequestHeader",	//216
    "QHttpRequestHeader#",	//217
    "QHttpRequestHeader$",	//218
    "QHttpRequestHeader$$",	//219
    "QHttpRequestHeader$$$",	//220
    "QHttpRequestHeader$$$$",	//221
    "QHttpResponseHeader",	//222
    "QHttpResponseHeader#",	//223
    "QHttpResponseHeader$",	//224
    "QHttpResponseHeader$$",	//225
    "QHttpResponseHeader$$$",	//226
    "QHttpResponseHeader$$$$",	//227
    "QIPv6Address",	//228
    "QIPv6Address#",	//229
    "QLocalServer",	//230
    "QLocalServer#",	//231
    "QLocalSocket",	//232
    "QLocalSocket#",	//233
    "QNetworkAccessManager",	//234
    "QNetworkAccessManager#",	//235
    "QNetworkAddressEntry",	//236
    "QNetworkAddressEntry#",	//237
    "QNetworkCacheMetaData",	//238
    "QNetworkCacheMetaData#",	//239
    "QNetworkConfiguration",	//240
    "QNetworkConfiguration#",	//241
    "QNetworkConfigurationManager",	//242
    "QNetworkConfigurationManager#",	//243
    "QNetworkCookie",	//244
    "QNetworkCookie#",	//245
    "QNetworkCookie##",	//246
    "QNetworkCookieJar",	//247
    "QNetworkCookieJar#",	//248
    "QNetworkDiskCache",	//249
    "QNetworkDiskCache#",	//250
    "QNetworkInterface",	//251
    "QNetworkInterface#",	//252
    "QNetworkProxy",	//253
    "QNetworkProxy#",	//254
    "QNetworkProxy$",	//255
    "QNetworkProxy$$",	//256
    "QNetworkProxy$$$",	//257
    "QNetworkProxy$$$$",	//258
    "QNetworkProxy$$$$$",	//259
    "QNetworkProxyFactory",	//260
    "QNetworkProxyFactory#",	//261
    "QNetworkProxyQuery",	//262
    "QNetworkProxyQuery#",	//263
    "QNetworkProxyQuery##",	//264
    "QNetworkProxyQuery##$",	//265
    "QNetworkProxyQuery#$",	//266
    "QNetworkProxyQuery#$$",	//267
    "QNetworkProxyQuery#$$$",	//268
    "QNetworkProxyQuery#$$$$",	//269
    "QNetworkProxyQuery$",	//270
    "QNetworkProxyQuery$$",	//271
    "QNetworkProxyQuery$$$",	//272
    "QNetworkProxyQuery$$$$",	//273
    "QNetworkReply",	//274
    "QNetworkReply#",	//275
    "QNetworkRequest",	//276
    "QNetworkRequest#",	//277
    "QNetworkSession",	//278
    "QNetworkSession#",	//279
    "QNetworkSession##",	//280
    "QSslCertificate",	//281
    "QSslCertificate#",	//282
    "QSslCertificate#$",	//283
    "QSslCipher",	//284
    "QSslCipher#",	//285
    "QSslCipher$$",	//286
    "QSslConfiguration",	//287
    "QSslConfiguration#",	//288
    "QSslError",	//289
    "QSslError#",	//290
    "QSslError$",	//291
    "QSslError$#",	//292
    "QSslKey",	//293
    "QSslKey#",	//294
    "QSslKey#$",	//295
    "QSslKey#$$",	//296
    "QSslKey#$$$",	//297
    "QSslKey#$$$#",	//298
    "QSslSocket",	//299
    "QSslSocket#",	//300
    "QTcpServer",	//301
    "QTcpServer#",	//302
    "QTcpSocket",	//303
    "QTcpSocket#",	//304
    "QUdpSocket",	//305
    "QUdpSocket#",	//306
    "QUrlInfo",	//307
    "QUrlInfo#",	//308
    "QUrlInfo#$$$$##$$$$$$",	//309
    "QUrlInfo$$$$$##$$$$$$",	//310
    "QueryPeer",	//311
    "RawCommand",	//312
    "ReadGroup",	//313
    "ReadOnly",	//314
    "ReadOther",	//315
    "ReadOwner",	//316
    "ReadWrite",	//317
    "Reading",	//318
    "RedirectionTargetAttribute",	//319
    "RelatedType",	//320
    "RemoteHostClosedError",	//321
    "Remove",	//322
    "Rename",	//323
    "ReuseAddressHint",	//324
    "Rmdir",	//325
    "Roaming",	//326
    "RoamingError",	//327
    "Rsa",	//328
    "SecureProtocols",	//329
    "SelfSignedCertificate",	//330
    "SelfSignedCertificateInChain",	//331
    "Sending",	//332
    "ServerNotFoundError",	//333
    "ServiceNetwork",	//334
    "ServiceSpecificPurpose",	//335
    "SessionAbortedError",	//336
    "SetCookieHeader",	//337
    "SetProxy",	//338
    "SetTransferMode",	//339
    "ShareAddress",	//340
    "SocketAccessError",	//341
    "SocketAddressNotAvailableError",	//342
    "SocketResourceError",	//343
    "SocketTimeoutError",	//344
    "Socks5Proxy",	//345
    "SourceIsFromCacheAttribute",	//346
    "SslClientMode",	//347
    "SslHandshakeFailedError",	//348
    "SslOptionDisableCompression",	//349
    "SslOptionDisableEmptyFragments",	//350
    "SslOptionDisableLegacyRenegotiation",	//351
    "SslOptionDisableServerNameIndication",	//352
    "SslOptionDisableSessionTickets",	//353
    "SslServerMode",	//354
    "SslV2",	//355
    "SslV3",	//356
    "StateOrProvinceName",	//357
    "SubjectIssuerMismatch",	//358
    "SynchronousRequestAttribute",	//359
    "SystemSessionSupport",	//360
    "TcpServer",	//361
    "TcpSocket",	//362
    "TemporaryNetworkFailureError",	//363
    "Text",	//364
    "TimeoutError",	//365
    "TlsV1",	//366
    "TlsV1SslV3",	//367
    "Truncate",	//368
    "TunnelingCapability",	//369
    "UdpSocket",	//370
    "UdpTunnelingCapability",	//371
    "UnableToDecodeIssuerPublicKey",	//372
    "UnableToDecryptCertificateSignature",	//373
    "UnableToGetIssuerCertificate",	//374
    "UnableToGetLocalIssuerCertificate",	//375
    "UnableToVerifyFirstCertificate",	//376
    "Unbuffered",	//377
    "Unconnected",	//378
    "UnconnectedState",	//379
    "Undefined",	//380
    "UnencryptedMode",	//381
    "UnexpectedClose",	//382
    "UnfinishedSocketOperationError",	//383
    "UnknownAccessibility",	//384
    "UnknownContentError",	//385
    "UnknownError",	//386
    "UnknownNetworkError",	//387
    "UnknownNetworkLayerProtocol",	//388
    "UnknownOperation",	//389
    "UnknownProtocol",	//390
    "UnknownProxyError",	//391
    "UnknownPurpose",	//392
    "UnknownSessionError",	//393
    "UnknownSocketError",	//394
    "UnknownSocketType",	//395
    "UnspecifiedError",	//396
    "UnsupportedSocketOperationError",	//397
    "UrlRequest",	//398
    "User",	//399
    "UserChoice",	//400
    "UserMax",	//401
    "VerifyNone",	//402
    "VerifyPeer",	//403
    "WriteGroup",	//404
    "WriteOnly",	//405
    "WriteOther",	//406
    "WriteOwner",	//407
    "WrongContentLength",	//408
    "abort",	//409
    "abortHostLookup",	//410
    "abortHostLookup$",	//411
    "accept",	//412
    "activeConfiguration",	//413
    "activeTime",	//414
    "addCaCertificate",	//415
    "addCaCertificate#",	//416
    "addCaCertificates",	//417
    "addCaCertificates$",	//418
    "addCaCertificates$$",	//419
    "addCaCertificates$$$",	//420
    "addCaCertificates?",	//421
    "addDefaultCaCertificate",	//422
    "addDefaultCaCertificate#",	//423
    "addDefaultCaCertificates",	//424
    "addDefaultCaCertificates$",	//425
    "addDefaultCaCertificates$$",	//426
    "addDefaultCaCertificates$$$",	//427
    "addDefaultCaCertificates?",	//428
    "addPendingConnection",	//429
    "addPendingConnection#",	//430
    "addValue",	//431
    "addValue$$",	//432
    "addressEntries",	//433
    "addresses",	//434
    "algorithm",	//435
    "allAddresses",	//436
    "allConfigurations",	//437
    "allConfigurations$",	//438
    "allCookies",	//439
    "allInterfaces",	//440
    "allValues",	//441
    "allValues$",	//442
    "alternateSubjectNames",	//443
    "append",	//444
    "append#",	//445
    "applicationProxy",	//446
    "atEnd",	//447
    "attribute",	//448
    "attribute$",	//449
    "attribute$#",	//450
    "attributes",	//451
    "authenticationMethod",	//452
    "authenticationRequired",	//453
    "authenticationRequired##",	//454
    "authenticationRequired$$#",	//455
    "bearerName",	//456
    "bearerType",	//457
    "bearerTypeName",	//458
    "bind",	//459
    "bind#$",	//460
    "bind#$$",	//461
    "bind$",	//462
    "bind$$",	//463
    "boundary",	//464
    "broadcast",	//465
    "bytesAvailable",	//466
    "bytesReceived",	//467
    "bytesToWrite",	//468
    "bytesWritten",	//469
    "caCertificates",	//470
    "cache",	//471
    "cacheDirectory",	//472
    "cacheSize",	//473
    "canReadLine",	//474
    "capabilities",	//475
    "cd",	//476
    "cd$",	//477
    "certificate",	//478
    "childEvent",	//479
    "children",	//480
    "ciphers",	//481
    "clear",	//482
    "clearPendingCommands",	//483
    "clearPendingRequests",	//484
    "close",	//485
    "closeConnection",	//486
    "closed",	//487
    "commandFinished",	//488
    "commandFinished$$",	//489
    "commandStarted",	//490
    "commandStarted$",	//491
    "configuration",	//492
    "configurationAdded",	//493
    "configurationAdded#",	//494
    "configurationChanged",	//495
    "configurationChanged#",	//496
    "configurationFromIdentifier",	//497
    "configurationFromIdentifier$",	//498
    "configurationRemoved",	//499
    "configurationRemoved#",	//500
    "connectNotify",	//501
    "connectNotify$",	//502
    "connectToHost",	//503
    "connectToHost#$",	//504
    "connectToHost#$$",	//505
    "connectToHost$",	//506
    "connectToHost$$",	//507
    "connectToHost$$$",	//508
    "connectToHostEncrypted",	//509
    "connectToHostEncrypted$$",	//510
    "connectToHostEncrypted$$$",	//511
    "connectToHostEncrypted$$$$",	//512
    "connectToHostImplementation",	//513
    "connectToHostImplementation$$",	//514
    "connectToHostImplementation$$$",	//515
    "connectToServer",	//516
    "connectToServer$",	//517
    "connectToServer$$",	//518
    "connected",	//519
    "contentLength",	//520
    "contentType",	//521
    "cookieJar",	//522
    "cookiesForUrl",	//523
    "cookiesForUrl#",	//524
    "createRequest",	//525
    "createRequest$#",	//526
    "createRequest$##",	//527
    "currentCommand",	//528
    "currentDestinationDevice",	//529
    "currentDevice",	//530
    "currentId",	//531
    "currentRequest",	//532
    "currentSourceDevice",	//533
    "customEvent",	//534
    "data",	//535
    "data#",	//536
    "dataReadProgress",	//537
    "dataReadProgress$$",	//538
    "dataSendProgress",	//539
    "dataSendProgress$$",	//540
    "dataTransferProgress",	//541
    "dataTransferProgress$$",	//542
    "defaultCaCertificates",	//543
    "defaultCiphers",	//544
    "defaultConfiguration",	//545
    "deleteResource",	//546
    "deleteResource#",	//547
    "detach",	//548
    "digest",	//549
    "digest$",	//550
    "disconnectFromHost",	//551
    "disconnectFromHostImplementation",	//552
    "disconnectFromServer",	//553
    "disconnectNotify",	//554
    "disconnectNotify$",	//555
    "disconnected",	//556
    "domain",	//557
    "done",	//558
    "done$",	//559
    "downloadProgress",	//560
    "downloadProgress$$",	//561
    "effectiveDate",	//562
    "encrypted",	//563
    "encryptedBytesAvailable",	//564
    "encryptedBytesToWrite",	//565
    "encryptedBytesWritten",	//566
    "encryptedBytesWritten$",	//567
    "encryptionMethod",	//568
    "equal",	//569
    "equal##$",	//570
    "error",	//571
    "error$",	//572
    "errorString",	//573
    "event",	//574
    "eventFilter",	//575
    "expirationDate",	//576
    "expire",	//577
    "expiryDate",	//578
    "fileMetaData",	//579
    "fileMetaData$",	//580
    "finished",	//581
    "finished#",	//582
    "flags",	//583
    "flush",	//584
    "fromData",	//585
    "fromData#",	//586
    "fromData#$",	//587
    "fromDevice",	//588
    "fromDevice#",	//589
    "fromDevice#$",	//590
    "fromName",	//591
    "fromName$",	//592
    "fromPath",	//593
    "fromPath$",	//594
    "fromPath$$",	//595
    "fromPath$$$",	//596
    "fullServerName",	//597
    "get",	//598
    "get#",	//599
    "get$",	//600
    "get$#",	//601
    "get$#$",	//602
    "greaterThan",	//603
    "greaterThan##$",	//604
    "group",	//605
    "handle",	//606
    "hardwareAddress",	//607
    "hasContentLength",	//608
    "hasContentType",	//609
    "hasKey",	//610
    "hasKey$",	//611
    "hasPendingCommands",	//612
    "hasPendingConnections",	//613
    "hasPendingDatagrams",	//614
    "hasPendingRequests",	//615
    "hasRawHeader",	//616
    "hasRawHeader#",	//617
    "head",	//618
    "head#",	//619
    "head$",	//620
    "header",	//621
    "header$",	//622
    "hostFound",	//623
    "hostName",	//624
    "humanReadableName",	//625
    "identifier",	//626
    "ignore",	//627
    "ignoreSslErrors",	//628
    "ignoreSslErrors?",	//629
    "incomingConnection",	//630
    "incomingConnection$",	//631
    "incomingConnection?",	//632
    "index",	//633
    "insert",	//634
    "insert#",	//635
    "interface",	//636
    "interfaceFromIndex",	//637
    "interfaceFromIndex$",	//638
    "interfaceFromName",	//639
    "interfaceFromName$",	//640
    "ip",	//641
    "isCachingProxy",	//642
    "isDir",	//643
    "isEncrypted",	//644
    "isExecutable",	//645
    "isFile",	//646
    "isFinished",	//647
    "isHttpOnly",	//648
    "isInSubnet",	//649
    "isInSubnet#$",	//650
    "isInSubnet?",	//651
    "isListening",	//652
    "isNull",	//653
    "isOnline",	//654
    "isOpen",	//655
    "isReadable",	//656
    "isRoamingAvailable",	//657
    "isRunning",	//658
    "isSecure",	//659
    "isSequential",	//660
    "isSessionCookie",	//661
    "isSymLink",	//662
    "isTransparentProxy",	//663
    "isValid",	//664
    "isWritable",	//665
    "issuerInfo",	//666
    "issuerInfo#",	//667
    "issuerInfo$",	//668
    "joinMulticastGroup",	//669
    "joinMulticastGroup#",	//670
    "joinMulticastGroup##",	//671
    "keyExchangeMethod",	//672
    "keys",	//673
    "lastModified",	//674
    "lastRead",	//675
    "lastResponse",	//676
    "leaveMulticastGroup",	//677
    "leaveMulticastGroup#",	//678
    "leaveMulticastGroup##",	//679
    "length",	//680
    "lessThan",	//681
    "lessThan##$",	//682
    "list",	//683
    "list$",	//684
    "listInfo",	//685
    "listInfo#",	//686
    "listen",	//687
    "listen#",	//688
    "listen#$",	//689
    "listen$",	//690
    "localAddress",	//691
    "localCertificate",	//692
    "localDomainName",	//693
    "localHostName",	//694
    "localPort",	//695
    "login",	//696
    "login$",	//697
    "login$$",	//698
    "lookupHost",	//699
    "lookupHost$#$",	//700
    "lookupId",	//701
    "majorVersion",	//702
    "manager",	//703
    "maxPendingConnections",	//704
    "maximumCacheSize",	//705
    "metaData",	//706
    "metaData#",	//707
    "metaDataChanged",	//708
    "metaObject",	//709
    "method",	//710
    "migrate",	//711
    "minorVersion",	//712
    "mkdir",	//713
    "mkdir$",	//714
    "mode",	//715
    "modeChanged",	//716
    "modeChanged$",	//717
    "multicastInterface",	//718
    "name",	//719
    "netmask",	//720
    "networkAccessible",	//721
    "networkAccessibleChanged",	//722
    "networkAccessibleChanged$",	//723
    "networkConfiguration",	//724
    "networkSessionConnected",	//725
    "newConfigurationActivated",	//726
    "newConnection",	//727
    "nextPendingConnection",	//728
    "onlineStateChanged",	//729
    "onlineStateChanged$",	//730
    "open",	//731
    "opened",	//732
    "operation",	//733
    "operator!=",	//734
    "operator!=#",	//735
    "operator!=$",	//736
    "operator<<",	//737
    "operator<<##",	//738
    "operator<<#$",	//739
    "operator=",	//740
    "operator=#",	//741
    "operator=$",	//742
    "operator==",	//743
    "operator==#",	//744
    "operator==$",	//745
    "operator==$#",	//746
    "operator>>",	//747
    "operator>>##",	//748
    "operator[]",	//749
    "operator[]$",	//750
    "operator|",	//751
    "operator|$$",	//752
    "option",	//753
    "option$",	//754
    "options",	//755
    "originatingObject",	//756
    "owner",	//757
    "parse",	//758
    "parse$",	//759
    "parseCookies",	//760
    "parseCookies#",	//761
    "parseLine",	//762
    "parseLine$$",	//763
    "parseSubnet",	//764
    "parseSubnet$",	//765
    "password",	//766
    "path",	//767
    "peerAddress",	//768
    "peerCertificate",	//769
    "peerCertificateChain",	//770
    "peerHostName",	//771
    "peerName",	//772
    "peerPort",	//773
    "peerVerifyDepth",	//774
    "peerVerifyError",	//775
    "peerVerifyError#",	//776
    "peerVerifyMode",	//777
    "peerVerifyName",	//778
    "pendingDatagramSize",	//779
    "permissions",	//780
    "port",	//781
    "pos",	//782
    "post",	//783
    "post##",	//784
    "post$#",	//785
    "post$##",	//786
    "preferredConfigurationChanged",	//787
    "preferredConfigurationChanged#$",	//788
    "prefixLength",	//789
    "prepare",	//790
    "prepare#",	//791
    "priority",	//792
    "privateKey",	//793
    "protocol",	//794
    "protocolString",	//795
    "protocolTag",	//796
    "proxy",	//797
    "proxyAuthenticationRequired",	//798
    "proxyAuthenticationRequired##",	//799
    "proxyFactory",	//800
    "proxyForQuery",	//801
    "proxyForQuery#",	//802
    "publicKey",	//803
    "purpose",	//804
    "put",	//805
    "put##",	//806
    "put#$",	//807
    "put#$$",	//808
    "qHash",	//809
    "qHash#",	//810
    "qt_metacall",	//811
    "qt_metacall$$?",	//812
    "qt_metacast",	//813
    "qt_metacast$",	//814
    "queryProxy",	//815
    "queryProxy#",	//816
    "queryType",	//817
    "rawCommand",	//818
    "rawCommand$",	//819
    "rawCommandReply",	//820
    "rawCommandReply$$",	//821
    "rawHeader",	//822
    "rawHeader#",	//823
    "rawHeaderList",	//824
    "rawHeaderPairs",	//825
    "rawHeaders",	//826
    "read",	//827
    "read$$",	//828
    "readAll",	//829
    "readBufferSize",	//830
    "readData",	//831
    "readData$$",	//832
    "readDatagram",	//833
    "readDatagram$$",	//834
    "readDatagram$$#",	//835
    "readDatagram$$#$",	//836
    "readLineData",	//837
    "readLineData$$",	//838
    "readyRead",	//839
    "readyRead#",	//840
    "realm",	//841
    "reasonPhrase",	//842
    "reject",	//843
    "remove",	//844
    "remove#",	//845
    "remove$",	//846
    "removeAllValues",	//847
    "removeAllValues$",	//848
    "removeServer",	//849
    "removeServer$",	//850
    "removeValue",	//851
    "removeValue$",	//852
    "rename",	//853
    "rename$$",	//854
    "request",	//855
    "request#",	//856
    "request##",	//857
    "request###",	//858
    "requestFinished",	//859
    "requestFinished$$",	//860
    "requestStarted",	//861
    "requestStarted$",	//862
    "reset",	//863
    "responseHeaderReceived",	//864
    "responseHeaderReceived#",	//865
    "rmdir",	//866
    "rmdir$",	//867
    "saveToDisk",	//868
    "scopeId",	//869
    "seek",	//870
    "sendCustomRequest",	//871
    "sendCustomRequest##",	//872
    "sendCustomRequest###",	//873
    "serialNumber",	//874
    "serverAddress",	//875
    "serverError",	//876
    "serverName",	//877
    "serverPort",	//878
    "sessionCipher",	//879
    "sessionProperty",	//880
    "sessionProperty$",	//881
    "setAddress",	//882
    "setAddress#",	//883
    "setAddress$",	//884
    "setAddresses",	//885
    "setAddresses?",	//886
    "setAllCookies",	//887
    "setAllCookies?",	//888
    "setApplicationProxy",	//889
    "setApplicationProxy#",	//890
    "setApplicationProxyFactory",	//891
    "setApplicationProxyFactory#",	//892
    "setAttribute",	//893
    "setAttribute$#",	//894
    "setAttributes",	//895
    "setAttributes?",	//896
    "setBody",	//897
    "setBody#",	//898
    "setBodyDevice",	//899
    "setBodyDevice#",	//900
    "setBoundary",	//901
    "setBoundary#",	//902
    "setBroadcast",	//903
    "setBroadcast#",	//904
    "setCaCertificates",	//905
    "setCaCertificates?",	//906
    "setCache",	//907
    "setCache#",	//908
    "setCacheDirectory",	//909
    "setCacheDirectory$",	//910
    "setCapabilities",	//911
    "setCapabilities$",	//912
    "setCiphers",	//913
    "setCiphers$",	//914
    "setCiphers?",	//915
    "setConfiguration",	//916
    "setConfiguration#",	//917
    "setContentLength",	//918
    "setContentLength$",	//919
    "setContentType",	//920
    "setContentType$",	//921
    "setCookieJar",	//922
    "setCookieJar#",	//923
    "setCookiesFromUrl",	//924
    "setCookiesFromUrl?#",	//925
    "setDefaultCaCertificates",	//926
    "setDefaultCaCertificates?",	//927
    "setDefaultCiphers",	//928
    "setDefaultCiphers?",	//929
    "setDefaultConfiguration",	//930
    "setDefaultConfiguration#",	//931
    "setDir",	//932
    "setDir$",	//933
    "setDomain",	//934
    "setDomain$",	//935
    "setError",	//936
    "setError$",	//937
    "setError$$",	//938
    "setErrorString",	//939
    "setErrorString$",	//940
    "setExpirationDate",	//941
    "setExpirationDate#",	//942
    "setFile",	//943
    "setFile$",	//944
    "setFinished",	//945
    "setFinished$",	//946
    "setGroup",	//947
    "setGroup$",	//948
    "setHeader",	//949
    "setHeader$#",	//950
    "setHost",	//951
    "setHost$",	//952
    "setHost$$",	//953
    "setHost$$$",	//954
    "setHostName",	//955
    "setHostName$",	//956
    "setHttpOnly",	//957
    "setHttpOnly$",	//958
    "setIp",	//959
    "setIp#",	//960
    "setLastModified",	//961
    "setLastModified#",	//962
    "setLastRead",	//963
    "setLastRead#",	//964
    "setLocalAddress",	//965
    "setLocalAddress#",	//966
    "setLocalCertificate",	//967
    "setLocalCertificate#",	//968
    "setLocalCertificate$",	//969
    "setLocalCertificate$$",	//970
    "setLocalPort",	//971
    "setLocalPort$",	//972
    "setLookupId",	//973
    "setLookupId$",	//974
    "setMaxPendingConnections",	//975
    "setMaxPendingConnections$",	//976
    "setMaximumCacheSize",	//977
    "setMaximumCacheSize$",	//978
    "setMulticastInterface",	//979
    "setMulticastInterface#",	//980
    "setName",	//981
    "setName#",	//982
    "setName$",	//983
    "setNetmask",	//984
    "setNetmask#",	//985
    "setNetworkAccessible",	//986
    "setNetworkAccessible$",	//987
    "setNetworkConfiguration",	//988
    "setNetworkConfiguration#",	//989
    "setOperation",	//990
    "setOperation$",	//991
    "setOption",	//992
    "setOption$#",	//993
    "setOriginatingObject",	//994
    "setOriginatingObject#",	//995
    "setOwner",	//996
    "setOwner$",	//997
    "setPassword",	//998
    "setPassword$",	//999
    "setPath",	//1000
    "setPath$",	//1001
    "setPeerAddress",	//1002
    "setPeerAddress#",	//1003
    "setPeerHostName",	//1004
    "setPeerHostName$",	//1005
    "setPeerName",	//1006
    "setPeerName$",	//1007
    "setPeerPort",	//1008
    "setPeerPort$",	//1009
    "setPeerVerifyDepth",	//1010
    "setPeerVerifyDepth$",	//1011
    "setPeerVerifyMode",	//1012
    "setPeerVerifyMode$",	//1013
    "setPeerVerifyName",	//1014
    "setPeerVerifyName$",	//1015
    "setPermissions",	//1016
    "setPermissions$",	//1017
    "setPort",	//1018
    "setPort$",	//1019
    "setPrefixLength",	//1020
    "setPrefixLength$",	//1021
    "setPriority",	//1022
    "setPriority$",	//1023
    "setPrivateKey",	//1024
    "setPrivateKey#",	//1025
    "setPrivateKey$",	//1026
    "setPrivateKey$$",	//1027
    "setPrivateKey$$$",	//1028
    "setPrivateKey$$$#",	//1029
    "setProtocol",	//1030
    "setProtocol$",	//1031
    "setProtocolTag",	//1032
    "setProtocolTag$",	//1033
    "setProxy",	//1034
    "setProxy#",	//1035
    "setProxy$$",	//1036
    "setProxy$$$",	//1037
    "setProxy$$$$",	//1038
    "setProxyFactory",	//1039
    "setProxyFactory#",	//1040
    "setQueryType",	//1041
    "setQueryType$",	//1042
    "setRawHeader",	//1043
    "setRawHeader##",	//1044
    "setRawHeaders",	//1045
    "setRawHeaders?",	//1046
    "setReadBufferSize",	//1047
    "setReadBufferSize$",	//1048
    "setReadable",	//1049
    "setReadable$",	//1050
    "setRequest",	//1051
    "setRequest#",	//1052
    "setRequest$$",	//1053
    "setRequest$$$",	//1054
    "setRequest$$$$",	//1055
    "setSaveToDisk",	//1056
    "setSaveToDisk$",	//1057
    "setScopeId",	//1058
    "setScopeId$",	//1059
    "setSecure",	//1060
    "setSecure$",	//1061
    "setSessionProperty",	//1062
    "setSessionProperty$#",	//1063
    "setSize",	//1064
    "setSize$",	//1065
    "setSocket",	//1066
    "setSocket#",	//1067
    "setSocketDescriptor",	//1068
    "setSocketDescriptor$",	//1069
    "setSocketDescriptor$$",	//1070
    "setSocketDescriptor$$$",	//1071
    "setSocketDescriptor?",	//1072
    "setSocketDescriptor?$",	//1073
    "setSocketDescriptor?$$",	//1074
    "setSocketError",	//1075
    "setSocketError$",	//1076
    "setSocketOption",	//1077
    "setSocketOption$#",	//1078
    "setSocketState",	//1079
    "setSocketState$",	//1080
    "setSslConfiguration",	//1081
    "setSslConfiguration#",	//1082
    "setSslOption",	//1083
    "setSslOption$$",	//1084
    "setStatusLine",	//1085
    "setStatusLine$",	//1086
    "setStatusLine$$",	//1087
    "setStatusLine$$$",	//1088
    "setStatusLine$$$$",	//1089
    "setSymLink",	//1090
    "setSymLink$",	//1091
    "setTransferMode",	//1092
    "setTransferMode$",	//1093
    "setType",	//1094
    "setType$",	//1095
    "setUrl",	//1096
    "setUrl#",	//1097
    "setUseSystemConfiguration",	//1098
    "setUseSystemConfiguration$",	//1099
    "setUser",	//1100
    "setUser$",	//1101
    "setUser$$",	//1102
    "setValid",	//1103
    "setValid$",	//1104
    "setValue",	//1105
    "setValue#",	//1106
    "setValue$$",	//1107
    "setValues",	//1108
    "setValues?",	//1109
    "setWritable",	//1110
    "setWritable$",	//1111
    "size",	//1112
    "socketDescriptor",	//1113
    "socketOption",	//1114
    "socketOption$",	//1115
    "socketType",	//1116
    "sslConfiguration",	//1117
    "sslErrors",	//1118
    "sslErrors#?",	//1119
    "sslErrors?",	//1120
    "startClientEncryption",	//1121
    "startServerEncryption",	//1122
    "state",	//1123
    "stateChanged",	//1124
    "stateChanged$",	//1125
    "staticMetaObject",	//1126
    "statusCode",	//1127
    "stop",	//1128
    "subjectInfo",	//1129
    "subjectInfo#",	//1130
    "subjectInfo$",	//1131
    "supportedBits",	//1132
    "supportedCiphers",	//1133
    "supportsSsl",	//1134
    "systemCaCertificates",	//1135
    "systemProxyForQuery",	//1136
    "systemProxyForQuery#",	//1137
    "testSslOption",	//1138
    "testSslOption$",	//1139
    "timerEvent",	//1140
    "toDer",	//1141
    "toDer#",	//1142
    "toIPv4Address",	//1143
    "toIPv6Address",	//1144
    "toPem",	//1145
    "toPem#",	//1146
    "toRawForm",	//1147
    "toRawForm$",	//1148
    "toString",	//1149
    "tr",	//1150
    "tr$",	//1151
    "tr$$",	//1152
    "tr$$$",	//1153
    "trUtf8",	//1154
    "trUtf8$",	//1155
    "trUtf8$$",	//1156
    "trUtf8$$$",	//1157
    "type",	//1158
    "updateCompleted",	//1159
    "updateConfigurations",	//1160
    "updateMetaData",	//1161
    "updateMetaData#",	//1162
    "uploadProgress",	//1163
    "uploadProgress$$",	//1164
    "url",	//1165
    "usedBits",	//1166
    "user",	//1167
    "value",	//1168
    "value$",	//1169
    "values",	//1170
    "version",	//1171
    "waitForBytesWritten",	//1172
    "waitForBytesWritten$",	//1173
    "waitForConnected",	//1174
    "waitForConnected$",	//1175
    "waitForDisconnected",	//1176
    "waitForDisconnected$",	//1177
    "waitForEncrypted",	//1178
    "waitForEncrypted$",	//1179
    "waitForNewConnection",	//1180
    "waitForNewConnection$",	//1181
    "waitForNewConnection$$",	//1182
    "waitForOpened",	//1183
    "waitForOpened$",	//1184
    "waitForReadyRead",	//1185
    "waitForReadyRead$",	//1186
    "writeData",	//1187
    "writeData$$",	//1188
    "writeDatagram",	//1189
    "writeDatagram##$",	//1190
    "writeDatagram$$#$",	//1191
    "~QAbstractNetworkCache",	//1192
    "~QAbstractSocket",	//1193
    "~QAuthenticator",	//1194
    "~QFtp",	//1195
    "~QHostAddress",	//1196
    "~QHostInfo",	//1197
    "~QHttp",	//1198
    "~QHttpHeader",	//1199
    "~QHttpMultiPart",	//1200
    "~QHttpPart",	//1201
    "~QHttpRequestHeader",	//1202
    "~QHttpResponseHeader",	//1203
    "~QIPv6Address",	//1204
    "~QLocalServer",	//1205
    "~QLocalSocket",	//1206
    "~QNetworkAccessManager",	//1207
    "~QNetworkAddressEntry",	//1208
    "~QNetworkCacheMetaData",	//1209
    "~QNetworkConfiguration",	//1210
    "~QNetworkConfigurationManager",	//1211
    "~QNetworkCookie",	//1212
    "~QNetworkCookieJar",	//1213
    "~QNetworkDiskCache",	//1214
    "~QNetworkInterface",	//1215
    "~QNetworkProxy",	//1216
    "~QNetworkProxyFactory",	//1217
    "~QNetworkProxyQuery",	//1218
    "~QNetworkReply",	//1219
    "~QNetworkRequest",	//1220
    "~QNetworkSession",	//1221
    "~QSslCertificate",	//1222
    "~QSslCipher",	//1223
    "~QSslConfiguration",	//1224
    "~QSslError",	//1225
    "~QSslKey",	//1226
    "~QSslSocket",	//1227
    "~QTcpServer",	//1228
    "~QTcpSocket",	//1229
    "~QUdpSocket",	//1230
    "~QUrlInfo",	//1231
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {1, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//1 QAbstractNetworkCache::metaObject() const
    {1, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//2 QAbstractNetworkCache::qt_metacast(const char*)
    {1, 1150, 3, 2, Smoke::mf_static, 164, 3},	//3 QAbstractNetworkCache::tr(const char*, const char*)
    {1, 1154, 3, 2, Smoke::mf_static, 164, 4},	//4 QAbstractNetworkCache::trUtf8(const char*, const char*)
    {1, 1150, 6, 3, Smoke::mf_static, 164, 5},	//5 QAbstractNetworkCache::tr(const char*, const char*, int)
    {1, 1154, 6, 3, Smoke::mf_static, 164, 6},	//6 QAbstractNetworkCache::trUtf8(const char*, const char*, int)
    {1, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//7 QAbstractNetworkCache::qt_metacall(QMetaObject::Call, int, void**)
    {1, 706, 14, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 88, 8},	//8 QAbstractNetworkCache::metaData(const QUrl&) [pure virtual]
    {1, 1161, 16, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 9},	//9 QAbstractNetworkCache::updateMetaData(const QNetworkCacheMetaData&) [pure virtual]
    {1, 535, 14, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 57, 10},	//10 QAbstractNetworkCache::data(const QUrl&) [pure virtual]
    {1, 844, 14, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 252, 11},	//11 QAbstractNetworkCache::remove(const QUrl&) [pure virtual]
    {1, 473, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 302, 12},	//12 QAbstractNetworkCache::cacheSize() const [pure virtual]
    {1, 790, 16, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 57, 13},	//13 QAbstractNetworkCache::prepare(const QNetworkCacheMetaData&) [pure virtual]
    {1, 634, 18, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 14},	//14 QAbstractNetworkCache::insert(QIODevice*) [pure virtual]
    {1, 482, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual|Smoke::mf_slot, 0, 15},	//15 QAbstractNetworkCache::clear() [pure virtual]
    {1, 186, 20, 1, Smoke::mf_ctor|Smoke::mf_protected, 1, 16},	//16 QAbstractNetworkCache::QAbstractNetworkCache(QObject*)
    {1, 1150, 1, 1, Smoke::mf_static, 164, 17},	//17 QAbstractNetworkCache::tr(const char*)
    {1, 1154, 1, 1, Smoke::mf_static, 164, 18},	//18 QAbstractNetworkCache::trUtf8(const char*)
    {1, 186, 0, 0, Smoke::mf_ctor|Smoke::mf_protected, 1, 19},	//19 QAbstractNetworkCache::QAbstractNetworkCache()
    {1, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 20},	//20 QAbstractNetworkCache::staticMetaObject() const
    {1, 1192, 0, 0, Smoke::mf_dtor, 0, 21 },	//21 QAbstractNetworkCache::~QAbstractNetworkCache()
    {2, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//22 QAbstractSocket::metaObject() const
    {2, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//23 QAbstractSocket::qt_metacast(const char*)
    {2, 1150, 3, 2, Smoke::mf_static, 164, 3},	//24 QAbstractSocket::tr(const char*, const char*)
    {2, 1154, 3, 2, Smoke::mf_static, 164, 4},	//25 QAbstractSocket::trUtf8(const char*, const char*)
    {2, 1150, 6, 3, Smoke::mf_static, 164, 5},	//26 QAbstractSocket::tr(const char*, const char*, int)
    {2, 1154, 6, 3, Smoke::mf_static, 164, 6},	//27 QAbstractSocket::trUtf8(const char*, const char*, int)
    {2, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//28 QAbstractSocket::qt_metacall(QMetaObject::Call, int, void**)
    {2, 188, 22, 2, Smoke::mf_ctor, 2, 8},	//29 QAbstractSocket::QAbstractSocket(QAbstractSocket::SocketType, QObject*)
    {2, 503, 25, 3, 0, 0, 9},	//30 QAbstractSocket::connectToHost(const QString&, unsigned short, QFlags<QIODevice::OpenModeFlag>)
    {2, 503, 29, 3, 0, 0, 10},	//31 QAbstractSocket::connectToHost(const QHostAddress&, unsigned short, QFlags<QIODevice::OpenModeFlag>)
    {2, 551, 0, 0, 0, 0, 11},	//32 QAbstractSocket::disconnectFromHost()
    {2, 664, 0, 0, Smoke::mf_const, 252, 12},	//33 QAbstractSocket::isValid() const
    {2, 466, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 302, 13},	//34 QAbstractSocket::bytesAvailable() const
    {2, 468, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 302, 14},	//35 QAbstractSocket::bytesToWrite() const
    {2, 474, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 252, 15},	//36 QAbstractSocket::canReadLine() const
    {2, 695, 0, 0, Smoke::mf_const, 311, 16},	//37 QAbstractSocket::localPort() const
    {2, 691, 0, 0, Smoke::mf_const, 33, 17},	//38 QAbstractSocket::localAddress() const
    {2, 773, 0, 0, Smoke::mf_const, 311, 18},	//39 QAbstractSocket::peerPort() const
    {2, 768, 0, 0, Smoke::mf_const, 33, 19},	//40 QAbstractSocket::peerAddress() const
    {2, 772, 0, 0, Smoke::mf_const, 164, 20},	//41 QAbstractSocket::peerName() const
    {2, 830, 0, 0, Smoke::mf_const, 302, 21},	//42 QAbstractSocket::readBufferSize() const
    {2, 1047, 33, 1, 0, 0, 22},	//43 QAbstractSocket::setReadBufferSize(long long)
    {2, 409, 0, 0, 0, 0, 23},	//44 QAbstractSocket::abort()
    {2, 1113, 0, 0, Smoke::mf_const, 300, 24},	//45 QAbstractSocket::socketDescriptor() const
    {2, 1068, 35, 3, 0, 252, 25},	//46 QAbstractSocket::setSocketDescriptor(int, QAbstractSocket::SocketState, QFlags<QIODevice::OpenModeFlag>)
    {2, 1077, 39, 2, 0, 0, 26},	//47 QAbstractSocket::setSocketOption(QAbstractSocket::SocketOption, const QVariant&)
    {2, 1114, 42, 1, 0, 177, 27},	//48 QAbstractSocket::socketOption(QAbstractSocket::SocketOption)
    {2, 1116, 0, 0, Smoke::mf_const, 7, 28},	//49 QAbstractSocket::socketType() const
    {2, 1123, 0, 0, Smoke::mf_const, 6, 29},	//50 QAbstractSocket::state() const
    {2, 571, 0, 0, Smoke::mf_const, 4, 30},	//51 QAbstractSocket::error() const
    {2, 485, 0, 0, Smoke::mf_virtual, 0, 31},	//52 QAbstractSocket::close()
    {2, 660, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 252, 32},	//53 QAbstractSocket::isSequential() const
    {2, 447, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 252, 33},	//54 QAbstractSocket::atEnd() const
    {2, 584, 0, 0, 0, 252, 34},	//55 QAbstractSocket::flush()
    {2, 1174, 44, 1, 0, 252, 35},	//56 QAbstractSocket::waitForConnected(int)
    {2, 1185, 44, 1, Smoke::mf_virtual, 252, 36},	//57 QAbstractSocket::waitForReadyRead(int)
    {2, 1172, 44, 1, Smoke::mf_virtual, 252, 37},	//58 QAbstractSocket::waitForBytesWritten(int)
    {2, 1176, 44, 1, 0, 252, 38},	//59 QAbstractSocket::waitForDisconnected(int)
    {2, 1034, 46, 1, 0, 0, 39},	//60 QAbstractSocket::setProxy(const QNetworkProxy&)
    {2, 797, 0, 0, Smoke::mf_const, 110, 40},	//61 QAbstractSocket::proxy() const
    {2, 623, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 41},	//62 QAbstractSocket::hostFound()
    {2, 519, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 42},	//63 QAbstractSocket::connected()
    {2, 556, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 43},	//64 QAbstractSocket::disconnected()
    {2, 1124, 48, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 44},	//65 QAbstractSocket::stateChanged(QAbstractSocket::SocketState)
    {2, 571, 50, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 45},	//66 QAbstractSocket::error(QAbstractSocket::SocketError)
    {2, 798, 52, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 46},	//67 QAbstractSocket::proxyAuthenticationRequired(const QNetworkProxy&, QAuthenticator*)
    {2, 513, 55, 3, Smoke::mf_protected|Smoke::mf_slot, 0, 47},	//68 QAbstractSocket::connectToHostImplementation(const QString&, quint16, QIODevice::OpenMode)
    {2, 552, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 48},	//69 QAbstractSocket::disconnectFromHostImplementation()
    {2, 831, 59, 2, Smoke::mf_protected|Smoke::mf_virtual, 302, 49},	//70 QAbstractSocket::readData(char*, long long)
    {2, 837, 59, 2, Smoke::mf_protected|Smoke::mf_virtual, 302, 50},	//71 QAbstractSocket::readLineData(char*, long long)
    {2, 1187, 62, 2, Smoke::mf_protected|Smoke::mf_virtual, 302, 51},	//72 QAbstractSocket::writeData(const char*, long long)
    {2, 1079, 48, 1, Smoke::mf_protected, 0, 52},	//73 QAbstractSocket::setSocketState(QAbstractSocket::SocketState)
    {2, 1075, 50, 1, Smoke::mf_protected, 0, 53},	//74 QAbstractSocket::setSocketError(QAbstractSocket::SocketError)
    {2, 971, 65, 1, Smoke::mf_protected, 0, 54},	//75 QAbstractSocket::setLocalPort(unsigned short)
    {2, 965, 67, 1, Smoke::mf_protected, 0, 55},	//76 QAbstractSocket::setLocalAddress(const QHostAddress&)
    {2, 1008, 65, 1, Smoke::mf_protected, 0, 56},	//77 QAbstractSocket::setPeerPort(unsigned short)
    {2, 1002, 67, 1, Smoke::mf_protected, 0, 57},	//78 QAbstractSocket::setPeerAddress(const QHostAddress&)
    {2, 1006, 69, 1, Smoke::mf_protected, 0, 58},	//79 QAbstractSocket::setPeerName(const QString&)
    {2, 1150, 1, 1, Smoke::mf_static, 164, 59},	//80 QAbstractSocket::tr(const char*)
    {2, 1154, 1, 1, Smoke::mf_static, 164, 60},	//81 QAbstractSocket::trUtf8(const char*)
    {2, 503, 71, 2, 0, 0, 61},	//82 QAbstractSocket::connectToHost(const QString&, unsigned short)
    {2, 503, 74, 2, 0, 0, 62},	//83 QAbstractSocket::connectToHost(const QHostAddress&, unsigned short)
    {2, 1068, 44, 1, 0, 252, 63},	//84 QAbstractSocket::setSocketDescriptor(int)
    {2, 1068, 77, 2, 0, 252, 64},	//85 QAbstractSocket::setSocketDescriptor(int, QAbstractSocket::SocketState)
    {2, 1174, 0, 0, 0, 252, 65},	//86 QAbstractSocket::waitForConnected()
    {2, 1185, 0, 0, 0, 252, 66},	//87 QAbstractSocket::waitForReadyRead()
    {2, 1172, 0, 0, 0, 252, 67},	//88 QAbstractSocket::waitForBytesWritten()
    {2, 1176, 0, 0, 0, 252, 68},	//89 QAbstractSocket::waitForDisconnected()
    {2, 513, 80, 2, Smoke::mf_protected|Smoke::mf_slot, 0, 69},	//90 QAbstractSocket::connectToHostImplementation(const QString&, quint16)
    {2, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 70},	//91 QAbstractSocket::staticMetaObject() const
    {2, 362, 0, 0, Smoke::mf_static|Smoke::mf_enum, 7, 71},	//92 QAbstractSocket::TcpSocket (enum)
    {2, 370, 0, 0, Smoke::mf_static|Smoke::mf_enum, 7, 72},	//93 QAbstractSocket::UdpSocket (enum)
    {2, 395, 0, 0, Smoke::mf_static|Smoke::mf_enum, 7, 73},	//94 QAbstractSocket::UnknownSocketType (enum)
    {2, 112, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 74},	//95 QAbstractSocket::IPv4Protocol (enum)
    {2, 113, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 75},	//96 QAbstractSocket::IPv6Protocol (enum)
    {2, 388, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 76},	//97 QAbstractSocket::UnknownNetworkLayerProtocol (enum)
    {2, 59, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 77},	//98 QAbstractSocket::ConnectionRefusedError (enum)
    {2, 321, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 78},	//99 QAbstractSocket::RemoteHostClosedError (enum)
    {2, 105, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 79},	//100 QAbstractSocket::HostNotFoundError (enum)
    {2, 341, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 80},	//101 QAbstractSocket::SocketAccessError (enum)
    {2, 343, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 81},	//102 QAbstractSocket::SocketResourceError (enum)
    {2, 344, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 82},	//103 QAbstractSocket::SocketTimeoutError (enum)
    {2, 74, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 83},	//104 QAbstractSocket::DatagramTooLargeError (enum)
    {2, 146, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 84},	//105 QAbstractSocket::NetworkError (enum)
    {2, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 85},	//106 QAbstractSocket::AddressInUseError (enum)
    {2, 342, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 86},	//107 QAbstractSocket::SocketAddressNotAvailableError (enum)
    {2, 397, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 87},	//108 QAbstractSocket::UnsupportedSocketOperationError (enum)
    {2, 383, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 88},	//109 QAbstractSocket::UnfinishedSocketOperationError (enum)
    {2, 175, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 89},	//110 QAbstractSocket::ProxyAuthenticationRequiredError (enum)
    {2, 348, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 90},	//111 QAbstractSocket::SslHandshakeFailedError (enum)
    {2, 177, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 91},	//112 QAbstractSocket::ProxyConnectionRefusedError (enum)
    {2, 176, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 92},	//113 QAbstractSocket::ProxyConnectionClosedError (enum)
    {2, 178, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 93},	//114 QAbstractSocket::ProxyConnectionTimeoutError (enum)
    {2, 179, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 94},	//115 QAbstractSocket::ProxyNotFoundError (enum)
    {2, 180, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 95},	//116 QAbstractSocket::ProxyProtocolError (enum)
    {2, 394, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 96},	//117 QAbstractSocket::UnknownSocketError (enum)
    {2, 379, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 97},	//118 QAbstractSocket::UnconnectedState (enum)
    {2, 101, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 98},	//119 QAbstractSocket::HostLookupState (enum)
    {2, 53, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 99},	//120 QAbstractSocket::ConnectingState (enum)
    {2, 51, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 100},	//121 QAbstractSocket::ConnectedState (enum)
    {2, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 101},	//122 QAbstractSocket::BoundState (enum)
    {2, 130, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 102},	//123 QAbstractSocket::ListeningState (enum)
    {2, 47, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 103},	//124 QAbstractSocket::ClosingState (enum)
    {2, 137, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 104},	//125 QAbstractSocket::LowDelayOption (enum)
    {2, 126, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 105},	//126 QAbstractSocket::KeepAliveOption (enum)
    {2, 144, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 106},	//127 QAbstractSocket::MulticastTtlOption (enum)
    {2, 143, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 107},	//128 QAbstractSocket::MulticastLoopbackOption (enum)
    {2, 1193, 0, 0, Smoke::mf_dtor, 0, 108 },	//129 QAbstractSocket::~QAbstractSocket()
    {3, 190, 0, 0, Smoke::mf_ctor, 9, 1},	//130 QAuthenticator::QAuthenticator()
    {3, 190, 83, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 9, 2},	//131 QAuthenticator::QAuthenticator(const QAuthenticator&)
    {3, 740, 83, 1, 0, 8, 3},	//132 QAuthenticator::operator=(const QAuthenticator&)
    {3, 743, 83, 1, Smoke::mf_const, 252, 4},	//133 QAuthenticator::operator==(const QAuthenticator&) const
    {3, 734, 83, 1, Smoke::mf_const, 252, 5},	//134 QAuthenticator::operator!=(const QAuthenticator&) const
    {3, 1167, 0, 0, Smoke::mf_const, 164, 6},	//135 QAuthenticator::user() const
    {3, 1100, 69, 1, 0, 0, 7},	//136 QAuthenticator::setUser(const QString&)
    {3, 766, 0, 0, Smoke::mf_const, 164, 8},	//137 QAuthenticator::password() const
    {3, 998, 69, 1, 0, 0, 9},	//138 QAuthenticator::setPassword(const QString&)
    {3, 841, 0, 0, Smoke::mf_const, 164, 10},	//139 QAuthenticator::realm() const
    {3, 753, 69, 1, Smoke::mf_const, 177, 11},	//140 QAuthenticator::option(const QString&) const
    {3, 755, 0, 0, Smoke::mf_const, 32, 12},	//141 QAuthenticator::options() const
    {3, 992, 85, 2, 0, 0, 13},	//142 QAuthenticator::setOption(const QString&, const QVariant&)
    {3, 653, 0, 0, Smoke::mf_const, 252, 14},	//143 QAuthenticator::isNull() const
    {3, 548, 0, 0, 0, 0, 15},	//144 QAuthenticator::detach()
    {3, 1194, 0, 0, Smoke::mf_dtor, 0, 16 },	//145 QAuthenticator::~QAuthenticator()
    {11, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//146 QFtp::metaObject() const
    {11, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//147 QFtp::qt_metacast(const char*)
    {11, 1150, 3, 2, Smoke::mf_static, 164, 3},	//148 QFtp::tr(const char*, const char*)
    {11, 1154, 3, 2, Smoke::mf_static, 164, 4},	//149 QFtp::trUtf8(const char*, const char*)
    {11, 1150, 6, 3, Smoke::mf_static, 164, 5},	//150 QFtp::tr(const char*, const char*, int)
    {11, 1154, 6, 3, Smoke::mf_static, 164, 6},	//151 QFtp::trUtf8(const char*, const char*, int)
    {11, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//152 QFtp::qt_metacall(QMetaObject::Call, int, void**)
    {11, 192, 20, 1, Smoke::mf_ctor, 25, 8},	//153 QFtp::QFtp(QObject*)
    {11, 1034, 71, 2, 0, 300, 9},	//154 QFtp::setProxy(const QString&, unsigned short)
    {11, 503, 71, 2, 0, 300, 10},	//155 QFtp::connectToHost(const QString&, unsigned short)
    {11, 696, 88, 2, 0, 300, 11},	//156 QFtp::login(const QString&, const QString&)
    {11, 485, 0, 0, 0, 300, 12},	//157 QFtp::close()
    {11, 1092, 91, 1, 0, 300, 13},	//158 QFtp::setTransferMode(QFtp::TransferMode)
    {11, 683, 69, 1, 0, 300, 14},	//159 QFtp::list(const QString&)
    {11, 476, 69, 1, 0, 300, 15},	//160 QFtp::cd(const QString&)
    {11, 598, 93, 3, 0, 300, 16},	//161 QFtp::get(const QString&, QIODevice*, QFtp::TransferType)
    {11, 805, 97, 3, 0, 300, 17},	//162 QFtp::put(const QByteArray&, const QString&, QFtp::TransferType)
    {11, 805, 101, 3, 0, 300, 18},	//163 QFtp::put(QIODevice*, const QString&, QFtp::TransferType)
    {11, 844, 69, 1, 0, 300, 19},	//164 QFtp::remove(const QString&)
    {11, 713, 69, 1, 0, 300, 20},	//165 QFtp::mkdir(const QString&)
    {11, 866, 69, 1, 0, 300, 21},	//166 QFtp::rmdir(const QString&)
    {11, 853, 88, 2, 0, 300, 22},	//167 QFtp::rename(const QString&, const QString&)
    {11, 818, 69, 1, 0, 300, 23},	//168 QFtp::rawCommand(const QString&)
    {11, 466, 0, 0, Smoke::mf_const, 302, 24},	//169 QFtp::bytesAvailable() const
    {11, 827, 59, 2, 0, 302, 25},	//170 QFtp::read(char*, long long)
    {11, 829, 0, 0, 0, 11, 26},	//171 QFtp::readAll()
    {11, 531, 0, 0, Smoke::mf_const, 300, 27},	//172 QFtp::currentId() const
    {11, 530, 0, 0, Smoke::mf_const, 57, 28},	//173 QFtp::currentDevice() const
    {11, 528, 0, 0, Smoke::mf_const, 26, 29},	//174 QFtp::currentCommand() const
    {11, 612, 0, 0, Smoke::mf_const, 252, 30},	//175 QFtp::hasPendingCommands() const
    {11, 483, 0, 0, 0, 0, 31},	//176 QFtp::clearPendingCommands()
    {11, 1123, 0, 0, Smoke::mf_const, 28, 32},	//177 QFtp::state() const
    {11, 571, 0, 0, Smoke::mf_const, 27, 33},	//178 QFtp::error() const
    {11, 573, 0, 0, Smoke::mf_const, 164, 34},	//179 QFtp::errorString() const
    {11, 409, 0, 0, Smoke::mf_slot, 0, 35},	//180 QFtp::abort()
    {11, 1124, 44, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 36},	//181 QFtp::stateChanged(int)
    {11, 685, 105, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 37},	//182 QFtp::listInfo(const QUrlInfo&)
    {11, 839, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 38},	//183 QFtp::readyRead()
    {11, 541, 107, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 39},	//184 QFtp::dataTransferProgress(qint64, qint64)
    {11, 820, 110, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 40},	//185 QFtp::rawCommandReply(int, const QString&)
    {11, 490, 44, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 41},	//186 QFtp::commandStarted(int)
    {11, 488, 113, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 42},	//187 QFtp::commandFinished(int, bool)
    {11, 558, 116, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 43},	//188 QFtp::done(bool)
    {11, 1150, 1, 1, Smoke::mf_static, 164, 44},	//189 QFtp::tr(const char*)
    {11, 1154, 1, 1, Smoke::mf_static, 164, 45},	//190 QFtp::trUtf8(const char*)
    {11, 192, 0, 0, Smoke::mf_ctor, 25, 46},	//191 QFtp::QFtp()
    {11, 503, 69, 1, 0, 300, 47},	//192 QFtp::connectToHost(const QString&)
    {11, 696, 0, 0, 0, 300, 48},	//193 QFtp::login()
    {11, 696, 69, 1, 0, 300, 49},	//194 QFtp::login(const QString&)
    {11, 683, 0, 0, 0, 300, 50},	//195 QFtp::list()
    {11, 598, 69, 1, 0, 300, 51},	//196 QFtp::get(const QString&)
    {11, 598, 118, 2, 0, 300, 52},	//197 QFtp::get(const QString&, QIODevice*)
    {11, 805, 121, 2, 0, 300, 53},	//198 QFtp::put(const QByteArray&, const QString&)
    {11, 805, 124, 2, 0, 300, 54},	//199 QFtp::put(QIODevice*, const QString&)
    {11, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 55},	//200 QFtp::staticMetaObject() const
    {11, 378, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 56},	//201 QFtp::Unconnected (enum)
    {11, 100, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 57},	//202 QFtp::HostLookup (enum)
    {11, 52, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 58},	//203 QFtp::Connecting (enum)
    {11, 50, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 59},	//204 QFtp::Connected (enum)
    {11, 135, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 60},	//205 QFtp::LoggedIn (enum)
    {11, 46, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 61},	//206 QFtp::Closing (enum)
    {11, 148, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 62},	//207 QFtp::NoError (enum)
    {11, 386, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 63},	//208 QFtp::UnknownError (enum)
    {11, 104, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 64},	//209 QFtp::HostNotFound (enum)
    {11, 58, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 65},	//210 QFtp::ConnectionRefused (enum)
    {11, 156, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 66},	//211 QFtp::NotConnected (enum)
    {11, 152, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 67},	//212 QFtp::None (enum)
    {11, 339, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 68},	//213 QFtp::SetTransferMode (enum)
    {11, 338, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 69},	//214 QFtp::SetProxy (enum)
    {11, 49, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 70},	//215 QFtp::ConnectToHost (enum)
    {11, 136, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 71},	//216 QFtp::Login (enum)
    {11, 45, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 72},	//217 QFtp::Close (enum)
    {11, 128, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 73},	//218 QFtp::List (enum)
    {11, 37, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 74},	//219 QFtp::Cd (enum)
    {11, 96, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 75},	//220 QFtp::Get (enum)
    {11, 184, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 76},	//221 QFtp::Put (enum)
    {11, 322, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 77},	//222 QFtp::Remove (enum)
    {11, 142, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 78},	//223 QFtp::Mkdir (enum)
    {11, 325, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 79},	//224 QFtp::Rmdir (enum)
    {11, 323, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 80},	//225 QFtp::Rename (enum)
    {11, 312, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 81},	//226 QFtp::RawCommand (enum)
    {11, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 82},	//227 QFtp::Active (enum)
    {11, 163, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 83},	//228 QFtp::Passive (enum)
    {11, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 30, 84},	//229 QFtp::Binary (enum)
    {11, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 30, 85},	//230 QFtp::Ascii (enum)
    {11, 1195, 0, 0, Smoke::mf_dtor, 0, 86 },	//231 QFtp::~QFtp()
    {12, 737, 127, 2, Smoke::mf_static, 16, 1},	//232 QGlobalSpace::operator<<(QDebug, const QHostAddress&)
    {12, 737, 130, 2, Smoke::mf_static, 16, 2},	//233 QGlobalSpace::operator<<(QDebug, QLocalSocket::LocalSocketError)
    {12, 737, 133, 2, Smoke::mf_static, 14, 3},	//234 QGlobalSpace::operator<<(QDataStream&, const QHostAddress&)
    {12, 737, 136, 2, Smoke::mf_static, 16, 4},	//235 QGlobalSpace::operator<<(QDebug, const QSslError::SslError&)
    {12, 737, 139, 2, Smoke::mf_static, 16, 5},	//236 QGlobalSpace::operator<<(QDebug, const QSslCertificate&)
    {12, 751, 142, 2, Smoke::mf_static, 21, 6},	//237 QGlobalSpace::operator|(QNetworkInterface::InterfaceFlag, QNetworkInterface::InterfaceFlag)
    {12, 751, 145, 2, Smoke::mf_static, 21, 7},	//238 QGlobalSpace::operator|(QNetworkInterface::InterfaceFlag, QFlags<QNetworkInterface::InterfaceFlag>)
    {12, 743, 148, 2, Smoke::mf_static, 252, 8},	//239 QGlobalSpace::operator==(QHostAddress::SpecialAddress, const QHostAddress&)
    {12, 751, 151, 2, Smoke::mf_static, 62, 9},	//240 QGlobalSpace::operator|(QUdpSocket::BindFlag, int)
    {12, 751, 154, 2, Smoke::mf_static, 24, 10},	//241 QGlobalSpace::operator|(QUdpSocket::BindFlag, QFlags<QUdpSocket::BindFlag>)
    {12, 737, 157, 2, Smoke::mf_static, 16, 11},	//242 QGlobalSpace::operator<<(QDebug, const QSslError&)
    {12, 737, 160, 2, Smoke::mf_static, 16, 12},	//243 QGlobalSpace::operator<<(QDebug, QAbstractSocket::SocketState)
    {12, 737, 163, 2, Smoke::mf_static, 16, 13},	//244 QGlobalSpace::operator<<(QDebug, QAbstractSocket::SocketError)
    {12, 751, 166, 2, Smoke::mf_static, 62, 14},	//245 QGlobalSpace::operator|(QSsl::SslOption, int)
    {12, 737, 169, 2, Smoke::mf_static, 16, 15},	//246 QGlobalSpace::operator<<(QDebug, QSslCertificate::SubjectInfo)
    {12, 737, 172, 2, Smoke::mf_static, 16, 16},	//247 QGlobalSpace::operator<<(QDebug, const QSslKey&)
    {12, 809, 67, 1, Smoke::mf_static, 308, 17},	//248 QGlobalSpace::qHash(const QHostAddress&)
    {12, 747, 175, 2, Smoke::mf_static, 14, 18},	//249 QGlobalSpace::operator>>(QDataStream&, QHostAddress&)
    {12, 737, 178, 2, Smoke::mf_static, 14, 19},	//250 QGlobalSpace::operator<<(QDataStream&, const QNetworkCacheMetaData&)
    {12, 751, 181, 2, Smoke::mf_static, 22, 20},	//251 QGlobalSpace::operator|(QNetworkProxy::Capability, QNetworkProxy::Capability)
    {12, 751, 184, 2, Smoke::mf_static, 20, 21},	//252 QGlobalSpace::operator|(QNetworkConfigurationManager::Capability, QFlags<QNetworkConfigurationManager::Capability>)
    {12, 751, 187, 2, Smoke::mf_static, 24, 22},	//253 QGlobalSpace::operator|(QUdpSocket::BindFlag, QUdpSocket::BindFlag)
    {12, 751, 190, 2, Smoke::mf_static, 62, 23},	//254 QGlobalSpace::operator|(QNetworkProxy::Capability, int)
    {12, 737, 193, 2, Smoke::mf_static, 16, 24},	//255 QGlobalSpace::operator<<(QDebug, const QNetworkCookie&)
    {12, 737, 196, 2, Smoke::mf_static, 16, 25},	//256 QGlobalSpace::operator<<(QDebug, QLocalSocket::LocalSocketState)
    {12, 737, 199, 2, Smoke::mf_static, 16, 26},	//257 QGlobalSpace::operator<<(QDebug, const QNetworkInterface&)
    {12, 737, 202, 2, Smoke::mf_static, 16, 27},	//258 QGlobalSpace::operator<<(QDebug, const QSslCipher&)
    {12, 747, 205, 2, Smoke::mf_static, 14, 28},	//259 QGlobalSpace::operator>>(QDataStream&, QNetworkCacheMetaData&)
    {12, 751, 208, 2, Smoke::mf_static, 23, 29},	//260 QGlobalSpace::operator|(QSsl::SslOption, QSsl::SslOption)
    {12, 751, 211, 2, Smoke::mf_static, 22, 30},	//261 QGlobalSpace::operator|(QNetworkProxy::Capability, QFlags<QNetworkProxy::Capability>)
    {12, 751, 214, 2, Smoke::mf_static, 62, 31},	//262 QGlobalSpace::operator|(QNetworkInterface::InterfaceFlag, int)
    {12, 751, 217, 2, Smoke::mf_static, 20, 32},	//263 QGlobalSpace::operator|(QNetworkConfigurationManager::Capability, QNetworkConfigurationManager::Capability)
    {12, 751, 220, 2, Smoke::mf_static, 23, 33},	//264 QGlobalSpace::operator|(QSsl::SslOption, QFlags<QSsl::SslOption>)
    {12, 751, 223, 2, Smoke::mf_static, 62, 34},	//265 QGlobalSpace::operator|(QNetworkConfigurationManager::Capability, int)
    {13, 194, 0, 0, Smoke::mf_ctor, 35, 1},	//266 QHostAddress::QHostAddress()
    {13, 194, 226, 1, Smoke::mf_ctor, 35, 2},	//267 QHostAddress::QHostAddress(unsigned int)
    {13, 194, 228, 1, Smoke::mf_ctor, 35, 3},	//268 QHostAddress::QHostAddress(unsigned char*)
    {13, 194, 230, 1, Smoke::mf_ctor, 35, 4},	//269 QHostAddress::QHostAddress(const QIPv6Address&)
    {13, 194, 232, 1, Smoke::mf_ctor, 35, 5},	//270 QHostAddress::QHostAddress(const sockaddr*)
    {13, 194, 69, 1, Smoke::mf_ctor, 35, 6},	//271 QHostAddress::QHostAddress(const QString&)
    {13, 194, 67, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 35, 7},	//272 QHostAddress::QHostAddress(const QHostAddress&)
    {13, 194, 234, 1, Smoke::mf_ctor, 35, 8},	//273 QHostAddress::QHostAddress(QHostAddress::SpecialAddress)
    {13, 740, 67, 1, 0, 34, 9},	//274 QHostAddress::operator=(const QHostAddress&)
    {13, 740, 69, 1, 0, 34, 10},	//275 QHostAddress::operator=(const QString&)
    {13, 882, 226, 1, 0, 0, 11},	//276 QHostAddress::setAddress(unsigned int)
    {13, 882, 228, 1, 0, 0, 12},	//277 QHostAddress::setAddress(unsigned char*)
    {13, 882, 230, 1, 0, 0, 13},	//278 QHostAddress::setAddress(const QIPv6Address&)
    {13, 882, 232, 1, 0, 0, 14},	//279 QHostAddress::setAddress(const sockaddr*)
    {13, 882, 69, 1, 0, 252, 15},	//280 QHostAddress::setAddress(const QString&)
    {13, 794, 0, 0, Smoke::mf_const, 3, 16},	//281 QHostAddress::protocol() const
    {13, 1143, 0, 0, Smoke::mf_const, 308, 17},	//282 QHostAddress::toIPv4Address() const
    {13, 1144, 0, 0, Smoke::mf_const, 60, 18},	//283 QHostAddress::toIPv6Address() const
    {13, 1149, 0, 0, Smoke::mf_const, 164, 19},	//284 QHostAddress::toString() const
    {13, 869, 0, 0, Smoke::mf_const, 164, 20},	//285 QHostAddress::scopeId() const
    {13, 1058, 69, 1, 0, 0, 21},	//286 QHostAddress::setScopeId(const QString&)
    {13, 743, 67, 1, Smoke::mf_const, 252, 22},	//287 QHostAddress::operator==(const QHostAddress&) const
    {13, 743, 234, 1, Smoke::mf_const, 252, 23},	//288 QHostAddress::operator==(QHostAddress::SpecialAddress) const
    {13, 734, 67, 1, Smoke::mf_const, 252, 24},	//289 QHostAddress::operator!=(const QHostAddress&) const
    {13, 734, 234, 1, Smoke::mf_const, 252, 25},	//290 QHostAddress::operator!=(QHostAddress::SpecialAddress) const
    {13, 653, 0, 0, Smoke::mf_const, 252, 26},	//291 QHostAddress::isNull() const
    {13, 482, 0, 0, 0, 0, 27},	//292 QHostAddress::clear()
    {13, 649, 236, 2, Smoke::mf_const, 252, 28},	//293 QHostAddress::isInSubnet(const QHostAddress&, int) const
    {13, 649, 239, 1, Smoke::mf_const, 252, 29},	//294 QHostAddress::isInSubnet(const QPair<QHostAddress,int>&) const
    {13, 764, 69, 1, Smoke::mf_static, 134, 30},	//295 QHostAddress::parseSubnet(const QString&)
    {13, 158, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 31},	//296 QHostAddress::Null (enum)
    {13, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 32},	//297 QHostAddress::Broadcast (enum)
    {13, 131, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 33},	//298 QHostAddress::LocalHost (enum)
    {13, 132, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 34},	//299 QHostAddress::LocalHostIPv6 (enum)
    {13, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 35},	//300 QHostAddress::Any (enum)
    {13, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 36},	//301 QHostAddress::AnyIPv6 (enum)
    {13, 1196, 0, 0, Smoke::mf_dtor, 0, 37 },	//302 QHostAddress::~QHostAddress()
    {14, 197, 44, 1, Smoke::mf_ctor, 39, 1},	//303 QHostInfo::QHostInfo(int)
    {14, 197, 241, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 39, 2},	//304 QHostInfo::QHostInfo(const QHostInfo&)
    {14, 740, 241, 1, 0, 38, 3},	//305 QHostInfo::operator=(const QHostInfo&)
    {14, 624, 0, 0, Smoke::mf_const, 164, 4},	//306 QHostInfo::hostName() const
    {14, 955, 69, 1, 0, 0, 5},	//307 QHostInfo::setHostName(const QString&)
    {14, 434, 0, 0, Smoke::mf_const, 65, 6},	//308 QHostInfo::addresses() const
    {14, 885, 243, 1, 0, 0, 7},	//309 QHostInfo::setAddresses(const QList<QHostAddress>&)
    {14, 571, 0, 0, Smoke::mf_const, 40, 8},	//310 QHostInfo::error() const
    {14, 936, 245, 1, 0, 0, 9},	//311 QHostInfo::setError(QHostInfo::HostInfoError)
    {14, 573, 0, 0, Smoke::mf_const, 164, 10},	//312 QHostInfo::errorString() const
    {14, 939, 69, 1, 0, 0, 11},	//313 QHostInfo::setErrorString(const QString&)
    {14, 973, 44, 1, 0, 0, 12},	//314 QHostInfo::setLookupId(int)
    {14, 701, 0, 0, Smoke::mf_const, 300, 13},	//315 QHostInfo::lookupId() const
    {14, 699, 247, 3, Smoke::mf_static, 300, 14},	//316 QHostInfo::lookupHost(const QString&, QObject*, const char*)
    {14, 410, 44, 1, Smoke::mf_static, 0, 15},	//317 QHostInfo::abortHostLookup(int)
    {14, 591, 69, 1, Smoke::mf_static, 37, 16},	//318 QHostInfo::fromName(const QString&)
    {14, 694, 0, 0, Smoke::mf_static, 164, 17},	//319 QHostInfo::localHostName()
    {14, 693, 0, 0, Smoke::mf_static, 164, 18},	//320 QHostInfo::localDomainName()
    {14, 197, 0, 0, Smoke::mf_ctor, 39, 19},	//321 QHostInfo::QHostInfo()
    {14, 148, 0, 0, Smoke::mf_static|Smoke::mf_enum, 40, 20},	//322 QHostInfo::NoError (enum)
    {14, 104, 0, 0, Smoke::mf_static|Smoke::mf_enum, 40, 21},	//323 QHostInfo::HostNotFound (enum)
    {14, 386, 0, 0, Smoke::mf_static|Smoke::mf_enum, 40, 22},	//324 QHostInfo::UnknownError (enum)
    {14, 1197, 0, 0, Smoke::mf_dtor, 0, 23 },	//325 QHostInfo::~QHostInfo()
    {15, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//326 QHttp::metaObject() const
    {15, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//327 QHttp::qt_metacast(const char*)
    {15, 1150, 3, 2, Smoke::mf_static, 164, 3},	//328 QHttp::tr(const char*, const char*)
    {15, 1154, 3, 2, Smoke::mf_static, 164, 4},	//329 QHttp::trUtf8(const char*, const char*)
    {15, 1150, 6, 3, Smoke::mf_static, 164, 5},	//330 QHttp::tr(const char*, const char*, int)
    {15, 1154, 6, 3, Smoke::mf_static, 164, 6},	//331 QHttp::trUtf8(const char*, const char*, int)
    {15, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//332 QHttp::qt_metacall(QMetaObject::Call, int, void**)
    {15, 200, 20, 1, Smoke::mf_ctor, 41, 8},	//333 QHttp::QHttp(QObject*)
    {15, 200, 251, 3, Smoke::mf_ctor, 41, 9},	//334 QHttp::QHttp(const QString&, unsigned short, QObject*)
    {15, 200, 255, 4, Smoke::mf_ctor, 41, 10},	//335 QHttp::QHttp(const QString&, QHttp::ConnectionMode, unsigned short, QObject*)
    {15, 951, 71, 2, 0, 300, 11},	//336 QHttp::setHost(const QString&, unsigned short)
    {15, 951, 260, 3, 0, 300, 12},	//337 QHttp::setHost(const QString&, QHttp::ConnectionMode, unsigned short)
    {15, 1066, 264, 1, 0, 300, 13},	//338 QHttp::setSocket(QTcpSocket*)
    {15, 1100, 88, 2, 0, 300, 14},	//339 QHttp::setUser(const QString&, const QString&)
    {15, 1034, 266, 4, 0, 300, 15},	//340 QHttp::setProxy(const QString&, int, const QString&, const QString&)
    {15, 1034, 46, 1, 0, 300, 16},	//341 QHttp::setProxy(const QNetworkProxy&)
    {15, 598, 118, 2, 0, 300, 17},	//342 QHttp::get(const QString&, QIODevice*)
    {15, 783, 271, 3, 0, 300, 18},	//343 QHttp::post(const QString&, QIODevice*, QIODevice*)
    {15, 783, 275, 3, 0, 300, 19},	//344 QHttp::post(const QString&, const QByteArray&, QIODevice*)
    {15, 618, 69, 1, 0, 300, 20},	//345 QHttp::head(const QString&)
    {15, 855, 279, 3, 0, 300, 21},	//346 QHttp::request(const QHttpRequestHeader&, QIODevice*, QIODevice*)
    {15, 855, 283, 3, 0, 300, 22},	//347 QHttp::request(const QHttpRequestHeader&, const QByteArray&, QIODevice*)
    {15, 486, 0, 0, 0, 300, 23},	//348 QHttp::closeConnection()
    {15, 485, 0, 0, 0, 300, 24},	//349 QHttp::close()
    {15, 466, 0, 0, Smoke::mf_const, 302, 25},	//350 QHttp::bytesAvailable() const
    {15, 827, 59, 2, 0, 302, 26},	//351 QHttp::read(char*, long long)
    {15, 829, 0, 0, 0, 11, 27},	//352 QHttp::readAll()
    {15, 531, 0, 0, Smoke::mf_const, 300, 28},	//353 QHttp::currentId() const
    {15, 533, 0, 0, Smoke::mf_const, 57, 29},	//354 QHttp::currentSourceDevice() const
    {15, 529, 0, 0, Smoke::mf_const, 57, 30},	//355 QHttp::currentDestinationDevice() const
    {15, 532, 0, 0, Smoke::mf_const, 51, 31},	//356 QHttp::currentRequest() const
    {15, 676, 0, 0, Smoke::mf_const, 54, 32},	//357 QHttp::lastResponse() const
    {15, 615, 0, 0, Smoke::mf_const, 252, 33},	//358 QHttp::hasPendingRequests() const
    {15, 484, 0, 0, 0, 0, 34},	//359 QHttp::clearPendingRequests()
    {15, 1123, 0, 0, Smoke::mf_const, 44, 35},	//360 QHttp::state() const
    {15, 571, 0, 0, Smoke::mf_const, 43, 36},	//361 QHttp::error() const
    {15, 573, 0, 0, Smoke::mf_const, 164, 37},	//362 QHttp::errorString() const
    {15, 409, 0, 0, Smoke::mf_slot, 0, 38},	//363 QHttp::abort()
    {15, 628, 0, 0, Smoke::mf_slot, 0, 39},	//364 QHttp::ignoreSslErrors()
    {15, 1124, 44, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 40},	//365 QHttp::stateChanged(int)
    {15, 864, 287, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 41},	//366 QHttp::responseHeaderReceived(const QHttpResponseHeader&)
    {15, 839, 287, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 42},	//367 QHttp::readyRead(const QHttpResponseHeader&)
    {15, 539, 289, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 43},	//368 QHttp::dataSendProgress(int, int)
    {15, 537, 289, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 44},	//369 QHttp::dataReadProgress(int, int)
    {15, 861, 44, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 45},	//370 QHttp::requestStarted(int)
    {15, 859, 113, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 46},	//371 QHttp::requestFinished(int, bool)
    {15, 558, 116, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 47},	//372 QHttp::done(bool)
    {15, 798, 52, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 48},	//373 QHttp::proxyAuthenticationRequired(const QNetworkProxy&, QAuthenticator*)
    {15, 453, 292, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 49},	//374 QHttp::authenticationRequired(const QString&, quint16, QAuthenticator*)
    {15, 1118, 296, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 50},	//375 QHttp::sslErrors(const QList<QSslError>&)
    {15, 1150, 1, 1, Smoke::mf_static, 164, 51},	//376 QHttp::tr(const char*)
    {15, 1154, 1, 1, Smoke::mf_static, 164, 52},	//377 QHttp::trUtf8(const char*)
    {15, 200, 0, 0, Smoke::mf_ctor, 41, 53},	//378 QHttp::QHttp()
    {15, 200, 69, 1, Smoke::mf_ctor, 41, 54},	//379 QHttp::QHttp(const QString&)
    {15, 200, 71, 2, Smoke::mf_ctor, 41, 55},	//380 QHttp::QHttp(const QString&, unsigned short)
    {15, 200, 298, 2, Smoke::mf_ctor, 41, 56},	//381 QHttp::QHttp(const QString&, QHttp::ConnectionMode)
    {15, 200, 260, 3, Smoke::mf_ctor, 41, 57},	//382 QHttp::QHttp(const QString&, QHttp::ConnectionMode, unsigned short)
    {15, 951, 69, 1, 0, 300, 58},	//383 QHttp::setHost(const QString&)
    {15, 951, 298, 2, 0, 300, 59},	//384 QHttp::setHost(const QString&, QHttp::ConnectionMode)
    {15, 1100, 69, 1, 0, 300, 60},	//385 QHttp::setUser(const QString&)
    {15, 1034, 301, 2, 0, 300, 61},	//386 QHttp::setProxy(const QString&, int)
    {15, 1034, 304, 3, 0, 300, 62},	//387 QHttp::setProxy(const QString&, int, const QString&)
    {15, 598, 69, 1, 0, 300, 63},	//388 QHttp::get(const QString&)
    {15, 783, 118, 2, 0, 300, 64},	//389 QHttp::post(const QString&, QIODevice*)
    {15, 783, 308, 2, 0, 300, 65},	//390 QHttp::post(const QString&, const QByteArray&)
    {15, 855, 311, 1, 0, 300, 66},	//391 QHttp::request(const QHttpRequestHeader&)
    {15, 855, 313, 2, 0, 300, 67},	//392 QHttp::request(const QHttpRequestHeader&, QIODevice*)
    {15, 855, 316, 2, 0, 300, 68},	//393 QHttp::request(const QHttpRequestHeader&, const QByteArray&)
    {15, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 69},	//394 QHttp::staticMetaObject() const
    {15, 56, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 70},	//395 QHttp::ConnectionModeHttp (enum)
    {15, 57, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 71},	//396 QHttp::ConnectionModeHttps (enum)
    {15, 378, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 72},	//397 QHttp::Unconnected (enum)
    {15, 100, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 73},	//398 QHttp::HostLookup (enum)
    {15, 52, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 74},	//399 QHttp::Connecting (enum)
    {15, 332, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 75},	//400 QHttp::Sending (enum)
    {15, 318, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 76},	//401 QHttp::Reading (enum)
    {15, 50, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 77},	//402 QHttp::Connected (enum)
    {15, 46, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 78},	//403 QHttp::Closing (enum)
    {15, 148, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 79},	//404 QHttp::NoError (enum)
    {15, 386, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 80},	//405 QHttp::UnknownError (enum)
    {15, 104, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 81},	//406 QHttp::HostNotFound (enum)
    {15, 58, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 82},	//407 QHttp::ConnectionRefused (enum)
    {15, 382, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 83},	//408 QHttp::UnexpectedClose (enum)
    {15, 121, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 84},	//409 QHttp::InvalidResponseHeader (enum)
    {15, 408, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 85},	//410 QHttp::WrongContentLength (enum)
    {15, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 86},	//411 QHttp::Aborted (enum)
    {15, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 87},	//412 QHttp::AuthenticationRequiredError (enum)
    {15, 175, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 88},	//413 QHttp::ProxyAuthenticationRequiredError (enum)
    {15, 1198, 0, 0, Smoke::mf_dtor, 0, 89 },	//414 QHttp::~QHttp()
    {16, 207, 0, 0, Smoke::mf_ctor, 46, 1},	//415 QHttpHeader::QHttpHeader()
    {16, 207, 319, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 46, 2},	//416 QHttpHeader::QHttpHeader(const QHttpHeader&)
    {16, 207, 69, 1, Smoke::mf_ctor, 46, 3},	//417 QHttpHeader::QHttpHeader(const QString&)
    {16, 740, 319, 1, 0, 45, 4},	//418 QHttpHeader::operator=(const QHttpHeader&)
    {16, 1105, 88, 2, 0, 0, 5},	//419 QHttpHeader::setValue(const QString&, const QString&)
    {16, 1108, 321, 1, 0, 0, 6},	//420 QHttpHeader::setValues(const QList<QPair<QString,QString> >&)
    {16, 431, 88, 2, 0, 0, 7},	//421 QHttpHeader::addValue(const QString&, const QString&)
    {16, 1170, 0, 0, Smoke::mf_const, 72, 8},	//422 QHttpHeader::values() const
    {16, 610, 69, 1, Smoke::mf_const, 252, 9},	//423 QHttpHeader::hasKey(const QString&) const
    {16, 673, 0, 0, Smoke::mf_const, 165, 10},	//424 QHttpHeader::keys() const
    {16, 1168, 69, 1, Smoke::mf_const, 164, 11},	//425 QHttpHeader::value(const QString&) const
    {16, 441, 69, 1, Smoke::mf_const, 165, 12},	//426 QHttpHeader::allValues(const QString&) const
    {16, 851, 69, 1, 0, 0, 13},	//427 QHttpHeader::removeValue(const QString&)
    {16, 847, 69, 1, 0, 0, 14},	//428 QHttpHeader::removeAllValues(const QString&)
    {16, 608, 0, 0, Smoke::mf_const, 252, 15},	//429 QHttpHeader::hasContentLength() const
    {16, 520, 0, 0, Smoke::mf_const, 308, 16},	//430 QHttpHeader::contentLength() const
    {16, 918, 44, 1, 0, 0, 17},	//431 QHttpHeader::setContentLength(int)
    {16, 609, 0, 0, Smoke::mf_const, 252, 18},	//432 QHttpHeader::hasContentType() const
    {16, 521, 0, 0, Smoke::mf_const, 164, 19},	//433 QHttpHeader::contentType() const
    {16, 920, 69, 1, 0, 0, 20},	//434 QHttpHeader::setContentType(const QString&)
    {16, 1149, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 164, 21},	//435 QHttpHeader::toString() const
    {16, 664, 0, 0, Smoke::mf_const, 252, 22},	//436 QHttpHeader::isValid() const
    {16, 702, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 300, 23},	//437 QHttpHeader::majorVersion() const [pure virtual]
    {16, 712, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 300, 24},	//438 QHttpHeader::minorVersion() const [pure virtual]
    {16, 762, 301, 2, Smoke::mf_protected|Smoke::mf_virtual, 252, 25},	//439 QHttpHeader::parseLine(const QString&, int)
    {16, 758, 69, 1, Smoke::mf_protected, 252, 26},	//440 QHttpHeader::parse(const QString&)
    {16, 1103, 116, 1, Smoke::mf_protected, 0, 27},	//441 QHttpHeader::setValid(bool)
    {16, 1199, 0, 0, Smoke::mf_dtor, 0, 28 },	//442 QHttpHeader::~QHttpHeader()
    {17, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//443 QHttpMultiPart::metaObject() const
    {17, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//444 QHttpMultiPart::qt_metacast(const char*)
    {17, 1150, 3, 2, Smoke::mf_static, 164, 3},	//445 QHttpMultiPart::tr(const char*, const char*)
    {17, 1154, 3, 2, Smoke::mf_static, 164, 4},	//446 QHttpMultiPart::trUtf8(const char*, const char*)
    {17, 1150, 6, 3, Smoke::mf_static, 164, 5},	//447 QHttpMultiPart::tr(const char*, const char*, int)
    {17, 1154, 6, 3, Smoke::mf_static, 164, 6},	//448 QHttpMultiPart::trUtf8(const char*, const char*, int)
    {17, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//449 QHttpMultiPart::qt_metacall(QMetaObject::Call, int, void**)
    {17, 210, 20, 1, Smoke::mf_ctor, 47, 8},	//450 QHttpMultiPart::QHttpMultiPart(QObject*)
    {17, 210, 323, 2, Smoke::mf_ctor, 47, 9},	//451 QHttpMultiPart::QHttpMultiPart(QHttpMultiPart::ContentType, QObject*)
    {17, 444, 326, 1, 0, 0, 10},	//452 QHttpMultiPart::append(const QHttpPart&)
    {17, 920, 328, 1, 0, 0, 11},	//453 QHttpMultiPart::setContentType(QHttpMultiPart::ContentType)
    {17, 464, 0, 0, Smoke::mf_const, 11, 12},	//454 QHttpMultiPart::boundary() const
    {17, 901, 330, 1, 0, 0, 13},	//455 QHttpMultiPart::setBoundary(const QByteArray&)
    {17, 1150, 1, 1, Smoke::mf_static, 164, 14},	//456 QHttpMultiPart::tr(const char*)
    {17, 1154, 1, 1, Smoke::mf_static, 164, 15},	//457 QHttpMultiPart::trUtf8(const char*)
    {17, 210, 0, 0, Smoke::mf_ctor, 47, 16},	//458 QHttpMultiPart::QHttpMultiPart()
    {17, 210, 328, 1, Smoke::mf_ctor, 47, 17},	//459 QHttpMultiPart::QHttpMultiPart(QHttpMultiPart::ContentType)
    {17, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 18},	//460 QHttpMultiPart::staticMetaObject() const
    {17, 141, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 19},	//461 QHttpMultiPart::MixedType (enum)
    {17, 320, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 20},	//462 QHttpMultiPart::RelatedType (enum)
    {17, 93, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 21},	//463 QHttpMultiPart::FormDataType (enum)
    {17, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 22},	//464 QHttpMultiPart::AlternativeType (enum)
    {17, 1200, 0, 0, Smoke::mf_dtor, 0, 23 },	//465 QHttpMultiPart::~QHttpMultiPart()
    {18, 214, 0, 0, Smoke::mf_ctor, 50, 1},	//466 QHttpPart::QHttpPart()
    {18, 214, 326, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 50, 2},	//467 QHttpPart::QHttpPart(const QHttpPart&)
    {18, 740, 326, 1, 0, 49, 3},	//468 QHttpPart::operator=(const QHttpPart&)
    {18, 743, 326, 1, Smoke::mf_const, 252, 4},	//469 QHttpPart::operator==(const QHttpPart&) const
    {18, 734, 326, 1, Smoke::mf_const, 252, 5},	//470 QHttpPart::operator!=(const QHttpPart&) const
    {18, 949, 332, 2, 0, 0, 6},	//471 QHttpPart::setHeader(QNetworkRequest::KnownHeaders, const QVariant&)
    {18, 1043, 335, 2, 0, 0, 7},	//472 QHttpPart::setRawHeader(const QByteArray&, const QByteArray&)
    {18, 897, 330, 1, 0, 0, 8},	//473 QHttpPart::setBody(const QByteArray&)
    {18, 899, 18, 1, 0, 0, 9},	//474 QHttpPart::setBodyDevice(QIODevice*)
    {18, 1201, 0, 0, Smoke::mf_dtor, 0, 10 },	//475 QHttpPart::~QHttpPart()
    {19, 216, 0, 0, Smoke::mf_ctor, 53, 1},	//476 QHttpRequestHeader::QHttpRequestHeader()
    {19, 216, 338, 4, Smoke::mf_ctor, 53, 2},	//477 QHttpRequestHeader::QHttpRequestHeader(const QString&, const QString&, int, int)
    {19, 216, 311, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 53, 3},	//478 QHttpRequestHeader::QHttpRequestHeader(const QHttpRequestHeader&)
    {19, 216, 69, 1, Smoke::mf_ctor, 53, 4},	//479 QHttpRequestHeader::QHttpRequestHeader(const QString&)
    {19, 740, 311, 1, 0, 52, 5},	//480 QHttpRequestHeader::operator=(const QHttpRequestHeader&)
    {19, 1051, 338, 4, 0, 0, 6},	//481 QHttpRequestHeader::setRequest(const QString&, const QString&, int, int)
    {19, 710, 0, 0, Smoke::mf_const, 164, 7},	//482 QHttpRequestHeader::method() const
    {19, 767, 0, 0, Smoke::mf_const, 164, 8},	//483 QHttpRequestHeader::path() const
    {19, 702, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 300, 9},	//484 QHttpRequestHeader::majorVersion() const
    {19, 712, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 300, 10},	//485 QHttpRequestHeader::minorVersion() const
    {19, 1149, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 164, 11},	//486 QHttpRequestHeader::toString() const
    {19, 762, 301, 2, Smoke::mf_protected|Smoke::mf_virtual, 252, 12},	//487 QHttpRequestHeader::parseLine(const QString&, int)
    {19, 216, 88, 2, Smoke::mf_ctor, 53, 13},	//488 QHttpRequestHeader::QHttpRequestHeader(const QString&, const QString&)
    {19, 216, 343, 3, Smoke::mf_ctor, 53, 14},	//489 QHttpRequestHeader::QHttpRequestHeader(const QString&, const QString&, int)
    {19, 1051, 88, 2, 0, 0, 15},	//490 QHttpRequestHeader::setRequest(const QString&, const QString&)
    {19, 1051, 343, 3, 0, 0, 16},	//491 QHttpRequestHeader::setRequest(const QString&, const QString&, int)
    {19, 1202, 0, 0, Smoke::mf_dtor, 0, 17 },	//492 QHttpRequestHeader::~QHttpRequestHeader()
    {20, 222, 0, 0, Smoke::mf_ctor, 56, 1},	//493 QHttpResponseHeader::QHttpResponseHeader()
    {20, 222, 287, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 56, 2},	//494 QHttpResponseHeader::QHttpResponseHeader(const QHttpResponseHeader&)
    {20, 222, 69, 1, Smoke::mf_ctor, 56, 3},	//495 QHttpResponseHeader::QHttpResponseHeader(const QString&)
    {20, 222, 347, 4, Smoke::mf_ctor, 56, 4},	//496 QHttpResponseHeader::QHttpResponseHeader(int, const QString&, int, int)
    {20, 740, 287, 1, 0, 55, 5},	//497 QHttpResponseHeader::operator=(const QHttpResponseHeader&)
    {20, 1085, 347, 4, 0, 0, 6},	//498 QHttpResponseHeader::setStatusLine(int, const QString&, int, int)
    {20, 1127, 0, 0, Smoke::mf_const, 300, 7},	//499 QHttpResponseHeader::statusCode() const
    {20, 842, 0, 0, Smoke::mf_const, 164, 8},	//500 QHttpResponseHeader::reasonPhrase() const
    {20, 702, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 300, 9},	//501 QHttpResponseHeader::majorVersion() const
    {20, 712, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 300, 10},	//502 QHttpResponseHeader::minorVersion() const
    {20, 1149, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 164, 11},	//503 QHttpResponseHeader::toString() const
    {20, 762, 301, 2, Smoke::mf_protected|Smoke::mf_virtual, 252, 12},	//504 QHttpResponseHeader::parseLine(const QString&, int)
    {20, 222, 44, 1, Smoke::mf_ctor, 56, 13},	//505 QHttpResponseHeader::QHttpResponseHeader(int)
    {20, 222, 110, 2, Smoke::mf_ctor, 56, 14},	//506 QHttpResponseHeader::QHttpResponseHeader(int, const QString&)
    {20, 222, 352, 3, Smoke::mf_ctor, 56, 15},	//507 QHttpResponseHeader::QHttpResponseHeader(int, const QString&, int)
    {20, 1085, 44, 1, 0, 0, 16},	//508 QHttpResponseHeader::setStatusLine(int)
    {20, 1085, 110, 2, 0, 0, 17},	//509 QHttpResponseHeader::setStatusLine(int, const QString&)
    {20, 1085, 352, 3, 0, 0, 18},	//510 QHttpResponseHeader::setStatusLine(int, const QString&, int)
    {20, 1203, 0, 0, Smoke::mf_dtor, 0, 19 },	//511 QHttpResponseHeader::~QHttpResponseHeader()
    {21, 731, 356, 1, Smoke::mf_virtual, 252, 0},	//512 QIODevice::open(QFlags<QIODevice::OpenModeFlag>)
    {21, 782, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 302, 0},	//513 QIODevice::pos() const
    {21, 1112, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 302, 0},	//514 QIODevice::size() const
    {21, 870, 33, 1, Smoke::mf_virtual, 252, 0},	//515 QIODevice::seek(long long)
    {21, 447, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 252, 0},	//516 QIODevice::atEnd() const
    {21, 863, 0, 0, Smoke::mf_virtual, 252, 0},	//517 QIODevice::reset()
    {21, 466, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 302, 0},	//518 QIODevice::bytesAvailable() const
    {21, 468, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 302, 0},	//519 QIODevice::bytesToWrite() const
    {21, 474, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 252, 0},	//520 QIODevice::canReadLine() const
    {21, 1185, 44, 1, Smoke::mf_virtual, 252, 0},	//521 QIODevice::waitForReadyRead(int)
    {21, 1172, 44, 1, Smoke::mf_virtual, 252, 0},	//522 QIODevice::waitForBytesWritten(int)
    {21, 831, 59, 2, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 302, 0},	//523 QIODevice::readData(char*, long long) [pure virtual]
    {21, 837, 59, 2, Smoke::mf_protected|Smoke::mf_virtual, 302, 0},	//524 QIODevice::readLineData(char*, long long)
    {21, 157, 0, 0, Smoke::mf_static|Smoke::mf_enum, 59, 14},	//525 QIODevice::NotOpen (enum)
    {21, 314, 0, 0, Smoke::mf_static|Smoke::mf_enum, 59, 15},	//526 QIODevice::ReadOnly (enum)
    {21, 405, 0, 0, Smoke::mf_static|Smoke::mf_enum, 59, 16},	//527 QIODevice::WriteOnly (enum)
    {21, 317, 0, 0, Smoke::mf_static|Smoke::mf_enum, 59, 17},	//528 QIODevice::ReadWrite (enum)
    {21, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 59, 18},	//529 QIODevice::Append (enum)
    {21, 368, 0, 0, Smoke::mf_static|Smoke::mf_enum, 59, 19},	//530 QIODevice::Truncate (enum)
    {21, 364, 0, 0, Smoke::mf_static|Smoke::mf_enum, 59, 20},	//531 QIODevice::Text (enum)
    {21, 377, 0, 0, Smoke::mf_static|Smoke::mf_enum, 59, 21},	//532 QIODevice::Unbuffered (enum)
    {22, 749, 44, 1, 0, 306, 1},	//533 QIPv6Address::operator[](int)
    {22, 749, 44, 1, Smoke::mf_const, 305, 2},	//534 QIPv6Address::operator[](int) const
    {22, 228, 0, 0, Smoke::mf_ctor, 61, 3},	//535 QIPv6Address::QIPv6Address()
    {22, 228, 230, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 61, 4},	//536 QIPv6Address::QIPv6Address(const QIPv6Address&)
    {22, 1204, 0, 0, Smoke::mf_dtor, 0, 5 },	//537 QIPv6Address::~QIPv6Address()
    {24, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//538 QLocalServer::metaObject() const
    {24, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//539 QLocalServer::qt_metacast(const char*)
    {24, 1150, 3, 2, Smoke::mf_static, 164, 3},	//540 QLocalServer::tr(const char*, const char*)
    {24, 1154, 3, 2, Smoke::mf_static, 164, 4},	//541 QLocalServer::trUtf8(const char*, const char*)
    {24, 1150, 6, 3, Smoke::mf_static, 164, 5},	//542 QLocalServer::tr(const char*, const char*, int)
    {24, 1154, 6, 3, Smoke::mf_static, 164, 6},	//543 QLocalServer::trUtf8(const char*, const char*, int)
    {24, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//544 QLocalServer::qt_metacall(QMetaObject::Call, int, void**)
    {24, 727, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 8},	//545 QLocalServer::newConnection()
    {24, 230, 20, 1, Smoke::mf_ctor, 76, 9},	//546 QLocalServer::QLocalServer(QObject*)
    {24, 485, 0, 0, 0, 0, 10},	//547 QLocalServer::close()
    {24, 573, 0, 0, Smoke::mf_const, 164, 11},	//548 QLocalServer::errorString() const
    {24, 613, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 252, 12},	//549 QLocalServer::hasPendingConnections() const
    {24, 652, 0, 0, Smoke::mf_const, 252, 13},	//550 QLocalServer::isListening() const
    {24, 687, 69, 1, 0, 252, 14},	//551 QLocalServer::listen(const QString&)
    {24, 704, 0, 0, Smoke::mf_const, 300, 15},	//552 QLocalServer::maxPendingConnections() const
    {24, 728, 0, 0, Smoke::mf_virtual, 77, 16},	//553 QLocalServer::nextPendingConnection()
    {24, 877, 0, 0, Smoke::mf_const, 164, 17},	//554 QLocalServer::serverName() const
    {24, 597, 0, 0, Smoke::mf_const, 164, 18},	//555 QLocalServer::fullServerName() const
    {24, 849, 69, 1, Smoke::mf_static, 252, 19},	//556 QLocalServer::removeServer(const QString&)
    {24, 876, 0, 0, Smoke::mf_const, 4, 20},	//557 QLocalServer::serverError() const
    {24, 975, 44, 1, 0, 0, 21},	//558 QLocalServer::setMaxPendingConnections(int)
    {24, 1180, 358, 2, 0, 252, 22},	//559 QLocalServer::waitForNewConnection(int, bool*)
    {24, 630, 361, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 23},	//560 QLocalServer::incomingConnection(QIntegerForSizeof< void* >::Unsigned)
    {24, 1150, 1, 1, Smoke::mf_static, 164, 24},	//561 QLocalServer::tr(const char*)
    {24, 1154, 1, 1, Smoke::mf_static, 164, 25},	//562 QLocalServer::trUtf8(const char*)
    {24, 230, 0, 0, Smoke::mf_ctor, 76, 26},	//563 QLocalServer::QLocalServer()
    {24, 1180, 0, 0, 0, 252, 27},	//564 QLocalServer::waitForNewConnection()
    {24, 1180, 44, 1, 0, 252, 28},	//565 QLocalServer::waitForNewConnection(int)
    {24, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 29},	//566 QLocalServer::staticMetaObject() const
    {24, 1205, 0, 0, Smoke::mf_dtor, 0, 30 },	//567 QLocalServer::~QLocalServer()
    {25, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//568 QLocalSocket::metaObject() const
    {25, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//569 QLocalSocket::qt_metacast(const char*)
    {25, 1150, 3, 2, Smoke::mf_static, 164, 3},	//570 QLocalSocket::tr(const char*, const char*)
    {25, 1154, 3, 2, Smoke::mf_static, 164, 4},	//571 QLocalSocket::trUtf8(const char*, const char*)
    {25, 1150, 6, 3, Smoke::mf_static, 164, 5},	//572 QLocalSocket::tr(const char*, const char*, int)
    {25, 1154, 6, 3, Smoke::mf_static, 164, 6},	//573 QLocalSocket::trUtf8(const char*, const char*, int)
    {25, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//574 QLocalSocket::qt_metacall(QMetaObject::Call, int, void**)
    {25, 232, 20, 1, Smoke::mf_ctor, 77, 8},	//575 QLocalSocket::QLocalSocket(QObject*)
    {25, 516, 363, 2, 0, 0, 9},	//576 QLocalSocket::connectToServer(const QString&, QFlags<QIODevice::OpenModeFlag>)
    {25, 553, 0, 0, 0, 0, 10},	//577 QLocalSocket::disconnectFromServer()
    {25, 877, 0, 0, Smoke::mf_const, 164, 11},	//578 QLocalSocket::serverName() const
    {25, 597, 0, 0, Smoke::mf_const, 164, 12},	//579 QLocalSocket::fullServerName() const
    {25, 409, 0, 0, 0, 0, 13},	//580 QLocalSocket::abort()
    {25, 660, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 252, 14},	//581 QLocalSocket::isSequential() const
    {25, 466, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 302, 15},	//582 QLocalSocket::bytesAvailable() const
    {25, 468, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 302, 16},	//583 QLocalSocket::bytesToWrite() const
    {25, 474, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 252, 17},	//584 QLocalSocket::canReadLine() const
    {25, 485, 0, 0, Smoke::mf_virtual, 0, 18},	//585 QLocalSocket::close()
    {25, 571, 0, 0, Smoke::mf_const, 78, 19},	//586 QLocalSocket::error() const
    {25, 584, 0, 0, 0, 252, 20},	//587 QLocalSocket::flush()
    {25, 664, 0, 0, Smoke::mf_const, 252, 21},	//588 QLocalSocket::isValid() const
    {25, 830, 0, 0, Smoke::mf_const, 302, 22},	//589 QLocalSocket::readBufferSize() const
    {25, 1047, 33, 1, 0, 0, 23},	//590 QLocalSocket::setReadBufferSize(long long)
    {25, 1068, 366, 3, 0, 252, 24},	//591 QLocalSocket::setSocketDescriptor(QIntegerForSizeof< void* >::Unsigned, QLocalSocket::LocalSocketState, QFlags<QIODevice::OpenModeFlag>)
    {25, 1113, 0, 0, Smoke::mf_const, 63, 25},	//592 QLocalSocket::socketDescriptor() const
    {25, 1123, 0, 0, Smoke::mf_const, 79, 26},	//593 QLocalSocket::state() const
    {25, 1172, 44, 1, Smoke::mf_virtual, 252, 27},	//594 QLocalSocket::waitForBytesWritten(int)
    {25, 1174, 44, 1, 0, 252, 28},	//595 QLocalSocket::waitForConnected(int)
    {25, 1176, 44, 1, 0, 252, 29},	//596 QLocalSocket::waitForDisconnected(int)
    {25, 1185, 44, 1, Smoke::mf_virtual, 252, 30},	//597 QLocalSocket::waitForReadyRead(int)
    {25, 519, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 31},	//598 QLocalSocket::connected()
    {25, 556, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 32},	//599 QLocalSocket::disconnected()
    {25, 571, 370, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 33},	//600 QLocalSocket::error(QLocalSocket::LocalSocketError)
    {25, 1124, 372, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 34},	//601 QLocalSocket::stateChanged(QLocalSocket::LocalSocketState)
    {25, 831, 59, 2, Smoke::mf_protected|Smoke::mf_virtual, 302, 35},	//602 QLocalSocket::readData(char*, long long)
    {25, 1187, 62, 2, Smoke::mf_protected|Smoke::mf_virtual, 302, 36},	//603 QLocalSocket::writeData(const char*, long long)
    {25, 1150, 1, 1, Smoke::mf_static, 164, 37},	//604 QLocalSocket::tr(const char*)
    {25, 1154, 1, 1, Smoke::mf_static, 164, 38},	//605 QLocalSocket::trUtf8(const char*)
    {25, 232, 0, 0, Smoke::mf_ctor, 77, 39},	//606 QLocalSocket::QLocalSocket()
    {25, 516, 69, 1, 0, 0, 40},	//607 QLocalSocket::connectToServer(const QString&)
    {25, 1068, 361, 1, 0, 252, 41},	//608 QLocalSocket::setSocketDescriptor(QIntegerForSizeof< void* >::Unsigned)
    {25, 1068, 374, 2, 0, 252, 42},	//609 QLocalSocket::setSocketDescriptor(QIntegerForSizeof< void* >::Unsigned, QLocalSocket::LocalSocketState)
    {25, 1172, 0, 0, 0, 252, 43},	//610 QLocalSocket::waitForBytesWritten()
    {25, 1174, 0, 0, 0, 252, 44},	//611 QLocalSocket::waitForConnected()
    {25, 1176, 0, 0, 0, 252, 45},	//612 QLocalSocket::waitForDisconnected()
    {25, 1185, 0, 0, 0, 252, 46},	//613 QLocalSocket::waitForReadyRead()
    {25, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 47},	//614 QLocalSocket::staticMetaObject() const
    {25, 59, 0, 0, Smoke::mf_static|Smoke::mf_enum, 78, 48},	//615 QLocalSocket::ConnectionRefusedError (enum)
    {25, 165, 0, 0, Smoke::mf_static|Smoke::mf_enum, 78, 49},	//616 QLocalSocket::PeerClosedError (enum)
    {25, 333, 0, 0, Smoke::mf_static|Smoke::mf_enum, 78, 50},	//617 QLocalSocket::ServerNotFoundError (enum)
    {25, 341, 0, 0, Smoke::mf_static|Smoke::mf_enum, 78, 51},	//618 QLocalSocket::SocketAccessError (enum)
    {25, 343, 0, 0, Smoke::mf_static|Smoke::mf_enum, 78, 52},	//619 QLocalSocket::SocketResourceError (enum)
    {25, 344, 0, 0, Smoke::mf_static|Smoke::mf_enum, 78, 53},	//620 QLocalSocket::SocketTimeoutError (enum)
    {25, 74, 0, 0, Smoke::mf_static|Smoke::mf_enum, 78, 54},	//621 QLocalSocket::DatagramTooLargeError (enum)
    {25, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 78, 55},	//622 QLocalSocket::ConnectionError (enum)
    {25, 397, 0, 0, Smoke::mf_static|Smoke::mf_enum, 78, 56},	//623 QLocalSocket::UnsupportedSocketOperationError (enum)
    {25, 394, 0, 0, Smoke::mf_static|Smoke::mf_enum, 78, 57},	//624 QLocalSocket::UnknownSocketError (enum)
    {25, 379, 0, 0, Smoke::mf_static|Smoke::mf_enum, 79, 58},	//625 QLocalSocket::UnconnectedState (enum)
    {25, 53, 0, 0, Smoke::mf_static|Smoke::mf_enum, 79, 59},	//626 QLocalSocket::ConnectingState (enum)
    {25, 51, 0, 0, Smoke::mf_static|Smoke::mf_enum, 79, 60},	//627 QLocalSocket::ConnectedState (enum)
    {25, 47, 0, 0, Smoke::mf_static|Smoke::mf_enum, 79, 61},	//628 QLocalSocket::ClosingState (enum)
    {25, 1206, 0, 0, Smoke::mf_dtor, 0, 62 },	//629 QLocalSocket::~QLocalSocket()
    {27, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//630 QNetworkAccessManager::metaObject() const
    {27, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//631 QNetworkAccessManager::qt_metacast(const char*)
    {27, 1150, 3, 2, Smoke::mf_static, 164, 3},	//632 QNetworkAccessManager::tr(const char*, const char*)
    {27, 1154, 3, 2, Smoke::mf_static, 164, 4},	//633 QNetworkAccessManager::trUtf8(const char*, const char*)
    {27, 1150, 6, 3, Smoke::mf_static, 164, 5},	//634 QNetworkAccessManager::tr(const char*, const char*, int)
    {27, 1154, 6, 3, Smoke::mf_static, 164, 6},	//635 QNetworkAccessManager::trUtf8(const char*, const char*, int)
    {27, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//636 QNetworkAccessManager::qt_metacall(QMetaObject::Call, int, void**)
    {27, 234, 20, 1, Smoke::mf_ctor, 82, 8},	//637 QNetworkAccessManager::QNetworkAccessManager(QObject*)
    {27, 797, 0, 0, Smoke::mf_const, 110, 9},	//638 QNetworkAccessManager::proxy() const
    {27, 1034, 46, 1, 0, 0, 10},	//639 QNetworkAccessManager::setProxy(const QNetworkProxy&)
    {27, 800, 0, 0, Smoke::mf_const, 115, 11},	//640 QNetworkAccessManager::proxyFactory() const
    {27, 1039, 377, 1, 0, 0, 12},	//641 QNetworkAccessManager::setProxyFactory(QNetworkProxyFactory*)
    {27, 471, 0, 0, Smoke::mf_const, 1, 13},	//642 QNetworkAccessManager::cache() const
    {27, 907, 379, 1, 0, 0, 14},	//643 QNetworkAccessManager::setCache(QAbstractNetworkCache*)
    {27, 522, 0, 0, Smoke::mf_const, 104, 15},	//644 QNetworkAccessManager::cookieJar() const
    {27, 922, 381, 1, 0, 0, 16},	//645 QNetworkAccessManager::setCookieJar(QNetworkCookieJar*)
    {27, 618, 383, 1, 0, 119, 17},	//646 QNetworkAccessManager::head(const QNetworkRequest&)
    {27, 598, 383, 1, 0, 119, 18},	//647 QNetworkAccessManager::get(const QNetworkRequest&)
    {27, 783, 385, 2, 0, 119, 19},	//648 QNetworkAccessManager::post(const QNetworkRequest&, QIODevice*)
    {27, 783, 388, 2, 0, 119, 20},	//649 QNetworkAccessManager::post(const QNetworkRequest&, const QByteArray&)
    {27, 783, 391, 2, 0, 119, 21},	//650 QNetworkAccessManager::post(const QNetworkRequest&, QHttpMultiPart*)
    {27, 805, 385, 2, 0, 119, 22},	//651 QNetworkAccessManager::put(const QNetworkRequest&, QIODevice*)
    {27, 805, 388, 2, 0, 119, 23},	//652 QNetworkAccessManager::put(const QNetworkRequest&, const QByteArray&)
    {27, 805, 391, 2, 0, 119, 24},	//653 QNetworkAccessManager::put(const QNetworkRequest&, QHttpMultiPart*)
    {27, 546, 383, 1, 0, 119, 25},	//654 QNetworkAccessManager::deleteResource(const QNetworkRequest&)
    {27, 871, 394, 3, 0, 119, 26},	//655 QNetworkAccessManager::sendCustomRequest(const QNetworkRequest&, const QByteArray&, QIODevice*)
    {27, 916, 398, 1, 0, 0, 27},	//656 QNetworkAccessManager::setConfiguration(const QNetworkConfiguration&)
    {27, 492, 0, 0, Smoke::mf_const, 91, 28},	//657 QNetworkAccessManager::configuration() const
    {27, 413, 0, 0, Smoke::mf_const, 91, 29},	//658 QNetworkAccessManager::activeConfiguration() const
    {27, 986, 400, 1, Smoke::mf_property, 0, 30},	//659 QNetworkAccessManager::setNetworkAccessible(QNetworkAccessManager::NetworkAccessibility)
    {27, 721, 0, 0, Smoke::mf_const|Smoke::mf_property, 83, 31},	//660 QNetworkAccessManager::networkAccessible() const
    {27, 798, 52, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 32},	//661 QNetworkAccessManager::proxyAuthenticationRequired(const QNetworkProxy&, QAuthenticator*)
    {27, 453, 402, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 33},	//662 QNetworkAccessManager::authenticationRequired(QNetworkReply*, QAuthenticator*)
    {27, 581, 405, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 34},	//663 QNetworkAccessManager::finished(QNetworkReply*)
    {27, 1118, 407, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 35},	//664 QNetworkAccessManager::sslErrors(QNetworkReply*, const QList<QSslError>&)
    {27, 725, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 36},	//665 QNetworkAccessManager::networkSessionConnected()
    {27, 722, 400, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 37},	//666 QNetworkAccessManager::networkAccessibleChanged(QNetworkAccessManager::NetworkAccessibility)
    {27, 525, 410, 3, Smoke::mf_protected|Smoke::mf_virtual, 119, 38},	//667 QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation, const QNetworkRequest&, QIODevice*)
    {27, 1150, 1, 1, Smoke::mf_static, 164, 39},	//668 QNetworkAccessManager::tr(const char*)
    {27, 1154, 1, 1, Smoke::mf_static, 164, 40},	//669 QNetworkAccessManager::trUtf8(const char*)
    {27, 234, 0, 0, Smoke::mf_ctor, 82, 41},	//670 QNetworkAccessManager::QNetworkAccessManager()
    {27, 871, 388, 2, 0, 119, 42},	//671 QNetworkAccessManager::sendCustomRequest(const QNetworkRequest&, const QByteArray&)
    {27, 525, 414, 2, Smoke::mf_protected, 119, 43},	//672 QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation, const QNetworkRequest&)
    {27, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 44},	//673 QNetworkAccessManager::staticMetaObject() const
    {27, 98, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 45},	//674 QNetworkAccessManager::HeadOperation (enum)
    {27, 97, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 46},	//675 QNetworkAccessManager::GetOperation (enum)
    {27, 185, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 47},	//676 QNetworkAccessManager::PutOperation (enum)
    {27, 167, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 48},	//677 QNetworkAccessManager::PostOperation (enum)
    {27, 78, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 49},	//678 QNetworkAccessManager::DeleteOperation (enum)
    {27, 71, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 50},	//679 QNetworkAccessManager::CustomOperation (enum)
    {27, 389, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 51},	//680 QNetworkAccessManager::UnknownOperation (enum)
    {27, 384, 0, 0, Smoke::mf_static|Smoke::mf_enum, 83, 52},	//681 QNetworkAccessManager::UnknownAccessibility (enum)
    {27, 154, 0, 0, Smoke::mf_static|Smoke::mf_enum, 83, 53},	//682 QNetworkAccessManager::NotAccessible (enum)
    {27, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 83, 54},	//683 QNetworkAccessManager::Accessible (enum)
    {27, 1207, 0, 0, Smoke::mf_dtor, 0, 55 },	//684 QNetworkAccessManager::~QNetworkAccessManager()
    {28, 236, 0, 0, Smoke::mf_ctor, 87, 1},	//685 QNetworkAddressEntry::QNetworkAddressEntry()
    {28, 236, 417, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 87, 2},	//686 QNetworkAddressEntry::QNetworkAddressEntry(const QNetworkAddressEntry&)
    {28, 740, 417, 1, 0, 86, 3},	//687 QNetworkAddressEntry::operator=(const QNetworkAddressEntry&)
    {28, 743, 417, 1, Smoke::mf_const, 252, 4},	//688 QNetworkAddressEntry::operator==(const QNetworkAddressEntry&) const
    {28, 734, 417, 1, Smoke::mf_const, 252, 5},	//689 QNetworkAddressEntry::operator!=(const QNetworkAddressEntry&) const
    {28, 641, 0, 0, Smoke::mf_const, 33, 6},	//690 QNetworkAddressEntry::ip() const
    {28, 959, 67, 1, 0, 0, 7},	//691 QNetworkAddressEntry::setIp(const QHostAddress&)
    {28, 720, 0, 0, Smoke::mf_const, 33, 8},	//692 QNetworkAddressEntry::netmask() const
    {28, 984, 67, 1, 0, 0, 9},	//693 QNetworkAddressEntry::setNetmask(const QHostAddress&)
    {28, 789, 0, 0, Smoke::mf_const, 300, 10},	//694 QNetworkAddressEntry::prefixLength() const
    {28, 1020, 44, 1, 0, 0, 11},	//695 QNetworkAddressEntry::setPrefixLength(int)
    {28, 465, 0, 0, Smoke::mf_const, 33, 12},	//696 QNetworkAddressEntry::broadcast() const
    {28, 903, 67, 1, 0, 0, 13},	//697 QNetworkAddressEntry::setBroadcast(const QHostAddress&)
    {28, 1208, 0, 0, Smoke::mf_dtor, 0, 14 },	//698 QNetworkAddressEntry::~QNetworkAddressEntry()
    {29, 238, 0, 0, Smoke::mf_ctor, 90, 1},	//699 QNetworkCacheMetaData::QNetworkCacheMetaData()
    {29, 238, 16, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 90, 2},	//700 QNetworkCacheMetaData::QNetworkCacheMetaData(const QNetworkCacheMetaData&)
    {29, 740, 16, 1, 0, 89, 3},	//701 QNetworkCacheMetaData::operator=(const QNetworkCacheMetaData&)
    {29, 743, 16, 1, Smoke::mf_const, 252, 4},	//702 QNetworkCacheMetaData::operator==(const QNetworkCacheMetaData&) const
    {29, 734, 16, 1, Smoke::mf_const, 252, 5},	//703 QNetworkCacheMetaData::operator!=(const QNetworkCacheMetaData&) const
    {29, 664, 0, 0, Smoke::mf_const, 252, 6},	//704 QNetworkCacheMetaData::isValid() const
    {29, 1165, 0, 0, Smoke::mf_const, 172, 7},	//705 QNetworkCacheMetaData::url() const
    {29, 1096, 14, 1, 0, 0, 8},	//706 QNetworkCacheMetaData::setUrl(const QUrl&)
    {29, 826, 0, 0, Smoke::mf_const, 71, 9},	//707 QNetworkCacheMetaData::rawHeaders() const
    {29, 1045, 419, 1, 0, 0, 10},	//708 QNetworkCacheMetaData::setRawHeaders(const QList<QPair<QByteArray,QByteArray> >&)
    {29, 674, 0, 0, Smoke::mf_const, 15, 11},	//709 QNetworkCacheMetaData::lastModified() const
    {29, 961, 421, 1, 0, 0, 12},	//710 QNetworkCacheMetaData::setLastModified(const QDateTime&)
    {29, 576, 0, 0, Smoke::mf_const, 15, 13},	//711 QNetworkCacheMetaData::expirationDate() const
    {29, 941, 421, 1, 0, 0, 14},	//712 QNetworkCacheMetaData::setExpirationDate(const QDateTime&)
    {29, 868, 0, 0, Smoke::mf_const, 252, 15},	//713 QNetworkCacheMetaData::saveToDisk() const
    {29, 1056, 116, 1, 0, 0, 16},	//714 QNetworkCacheMetaData::setSaveToDisk(bool)
    {29, 451, 0, 0, Smoke::mf_const, 31, 17},	//715 QNetworkCacheMetaData::attributes() const
    {29, 895, 423, 1, 0, 0, 18},	//716 QNetworkCacheMetaData::setAttributes(const QHash<QNetworkRequest::Attribute,QVariant>&)
    {29, 1209, 0, 0, Smoke::mf_dtor, 0, 19 },	//717 QNetworkCacheMetaData::~QNetworkCacheMetaData()
    {30, 240, 0, 0, Smoke::mf_ctor, 93, 1},	//718 QNetworkConfiguration::QNetworkConfiguration()
    {30, 240, 398, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 93, 2},	//719 QNetworkConfiguration::QNetworkConfiguration(const QNetworkConfiguration&)
    {30, 740, 398, 1, 0, 92, 3},	//720 QNetworkConfiguration::operator=(const QNetworkConfiguration&)
    {30, 743, 398, 1, Smoke::mf_const, 252, 4},	//721 QNetworkConfiguration::operator==(const QNetworkConfiguration&) const
    {30, 734, 398, 1, Smoke::mf_const, 252, 5},	//722 QNetworkConfiguration::operator!=(const QNetworkConfiguration&) const
    {30, 1123, 0, 0, Smoke::mf_const, 19, 6},	//723 QNetworkConfiguration::state() const
    {30, 1158, 0, 0, Smoke::mf_const, 97, 7},	//724 QNetworkConfiguration::type() const
    {30, 804, 0, 0, Smoke::mf_const, 95, 8},	//725 QNetworkConfiguration::purpose() const
    {30, 456, 0, 0, Smoke::mf_const, 164, 9},	//726 QNetworkConfiguration::bearerName() const
    {30, 457, 0, 0, Smoke::mf_const, 94, 10},	//727 QNetworkConfiguration::bearerType() const
    {30, 458, 0, 0, Smoke::mf_const, 164, 11},	//728 QNetworkConfiguration::bearerTypeName() const
    {30, 626, 0, 0, Smoke::mf_const, 164, 12},	//729 QNetworkConfiguration::identifier() const
    {30, 657, 0, 0, Smoke::mf_const, 252, 13},	//730 QNetworkConfiguration::isRoamingAvailable() const
    {30, 480, 0, 0, Smoke::mf_const, 67, 14},	//731 QNetworkConfiguration::children() const
    {30, 719, 0, 0, Smoke::mf_const, 164, 15},	//732 QNetworkConfiguration::name() const
    {30, 664, 0, 0, Smoke::mf_const, 252, 16},	//733 QNetworkConfiguration::isValid() const
    {30, 114, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 17},	//734 QNetworkConfiguration::InternetAccessPoint (enum)
    {30, 334, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 18},	//735 QNetworkConfiguration::ServiceNetwork (enum)
    {30, 400, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 19},	//736 QNetworkConfiguration::UserChoice (enum)
    {30, 115, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 20},	//737 QNetworkConfiguration::Invalid (enum)
    {30, 392, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 21},	//738 QNetworkConfiguration::UnknownPurpose (enum)
    {30, 183, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 22},	//739 QNetworkConfiguration::PublicPurpose (enum)
    {30, 171, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 23},	//740 QNetworkConfiguration::PrivatePurpose (enum)
    {30, 335, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 24},	//741 QNetworkConfiguration::ServiceSpecificPurpose (enum)
    {30, 380, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 25},	//742 QNetworkConfiguration::Undefined (enum)
    {30, 77, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 26},	//743 QNetworkConfiguration::Defined (enum)
    {30, 82, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 27},	//744 QNetworkConfiguration::Discovered (enum)
    {30, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 28},	//745 QNetworkConfiguration::Active (enum)
    {30, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 29},	//746 QNetworkConfiguration::BearerUnknown (enum)
    {30, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 30},	//747 QNetworkConfiguration::BearerEthernet (enum)
    {30, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 31},	//748 QNetworkConfiguration::BearerWLAN (enum)
    {30, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 32},	//749 QNetworkConfiguration::Bearer2G (enum)
    {30, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 33},	//750 QNetworkConfiguration::BearerCDMA2000 (enum)
    {30, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 34},	//751 QNetworkConfiguration::BearerWCDMA (enum)
    {30, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 35},	//752 QNetworkConfiguration::BearerHSPA (enum)
    {30, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 36},	//753 QNetworkConfiguration::BearerBluetooth (enum)
    {30, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 37},	//754 QNetworkConfiguration::BearerWiMAX (enum)
    {30, 1210, 0, 0, Smoke::mf_dtor, 0, 38 },	//755 QNetworkConfiguration::~QNetworkConfiguration()
    {31, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//756 QNetworkConfigurationManager::metaObject() const
    {31, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//757 QNetworkConfigurationManager::qt_metacast(const char*)
    {31, 1150, 3, 2, Smoke::mf_static, 164, 3},	//758 QNetworkConfigurationManager::tr(const char*, const char*)
    {31, 1154, 3, 2, Smoke::mf_static, 164, 4},	//759 QNetworkConfigurationManager::trUtf8(const char*, const char*)
    {31, 1150, 6, 3, Smoke::mf_static, 164, 5},	//760 QNetworkConfigurationManager::tr(const char*, const char*, int)
    {31, 1154, 6, 3, Smoke::mf_static, 164, 6},	//761 QNetworkConfigurationManager::trUtf8(const char*, const char*, int)
    {31, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//762 QNetworkConfigurationManager::qt_metacall(QMetaObject::Call, int, void**)
    {31, 242, 20, 1, Smoke::mf_ctor, 98, 8},	//763 QNetworkConfigurationManager::QNetworkConfigurationManager(QObject*)
    {31, 475, 0, 0, Smoke::mf_const, 20, 9},	//764 QNetworkConfigurationManager::capabilities() const
    {31, 545, 0, 0, Smoke::mf_const, 91, 10},	//765 QNetworkConfigurationManager::defaultConfiguration() const
    {31, 437, 425, 1, Smoke::mf_const, 67, 11},	//766 QNetworkConfigurationManager::allConfigurations(QFlags<QNetworkConfiguration::StateFlag>) const
    {31, 497, 69, 1, Smoke::mf_const, 91, 12},	//767 QNetworkConfigurationManager::configurationFromIdentifier(const QString&) const
    {31, 654, 0, 0, Smoke::mf_const, 252, 13},	//768 QNetworkConfigurationManager::isOnline() const
    {31, 1160, 0, 0, Smoke::mf_slot, 0, 14},	//769 QNetworkConfigurationManager::updateConfigurations()
    {31, 493, 398, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 15},	//770 QNetworkConfigurationManager::configurationAdded(const QNetworkConfiguration&)
    {31, 499, 398, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 16},	//771 QNetworkConfigurationManager::configurationRemoved(const QNetworkConfiguration&)
    {31, 495, 398, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//772 QNetworkConfigurationManager::configurationChanged(const QNetworkConfiguration&)
    {31, 729, 116, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//773 QNetworkConfigurationManager::onlineStateChanged(bool)
    {31, 1159, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//774 QNetworkConfigurationManager::updateCompleted()
    {31, 1150, 1, 1, Smoke::mf_static, 164, 20},	//775 QNetworkConfigurationManager::tr(const char*)
    {31, 1154, 1, 1, Smoke::mf_static, 164, 21},	//776 QNetworkConfigurationManager::trUtf8(const char*)
    {31, 242, 0, 0, Smoke::mf_ctor, 98, 22},	//777 QNetworkConfigurationManager::QNetworkConfigurationManager()
    {31, 437, 0, 0, Smoke::mf_const, 67, 23},	//778 QNetworkConfigurationManager::allConfigurations() const
    {31, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 24},	//779 QNetworkConfigurationManager::staticMetaObject() const
    {31, 36, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 25},	//780 QNetworkConfigurationManager::CanStartAndStopInterfaces (enum)
    {31, 80, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 26},	//781 QNetworkConfigurationManager::DirectConnectionRouting (enum)
    {31, 360, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 27},	//782 QNetworkConfigurationManager::SystemSessionSupport (enum)
    {31, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 28},	//783 QNetworkConfigurationManager::ApplicationLevelRoaming (enum)
    {31, 92, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 29},	//784 QNetworkConfigurationManager::ForcedRoaming (enum)
    {31, 73, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 30},	//785 QNetworkConfigurationManager::DataStatistics (enum)
    {31, 147, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 31},	//786 QNetworkConfigurationManager::NetworkSessionRequired (enum)
    {31, 1211, 0, 0, Smoke::mf_dtor, 0, 32 },	//787 QNetworkConfigurationManager::~QNetworkConfigurationManager()
    {32, 244, 335, 2, Smoke::mf_ctor, 102, 1},	//788 QNetworkCookie::QNetworkCookie(const QByteArray&, const QByteArray&)
    {32, 244, 427, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 102, 2},	//789 QNetworkCookie::QNetworkCookie(const QNetworkCookie&)
    {32, 740, 427, 1, 0, 101, 3},	//790 QNetworkCookie::operator=(const QNetworkCookie&)
    {32, 743, 427, 1, Smoke::mf_const, 252, 4},	//791 QNetworkCookie::operator==(const QNetworkCookie&) const
    {32, 734, 427, 1, Smoke::mf_const, 252, 5},	//792 QNetworkCookie::operator!=(const QNetworkCookie&) const
    {32, 659, 0, 0, Smoke::mf_const, 252, 6},	//793 QNetworkCookie::isSecure() const
    {32, 1060, 116, 1, 0, 0, 7},	//794 QNetworkCookie::setSecure(bool)
    {32, 648, 0, 0, Smoke::mf_const, 252, 8},	//795 QNetworkCookie::isHttpOnly() const
    {32, 957, 116, 1, 0, 0, 9},	//796 QNetworkCookie::setHttpOnly(bool)
    {32, 661, 0, 0, Smoke::mf_const, 252, 10},	//797 QNetworkCookie::isSessionCookie() const
    {32, 576, 0, 0, Smoke::mf_const, 15, 11},	//798 QNetworkCookie::expirationDate() const
    {32, 941, 421, 1, 0, 0, 12},	//799 QNetworkCookie::setExpirationDate(const QDateTime&)
    {32, 557, 0, 0, Smoke::mf_const, 164, 13},	//800 QNetworkCookie::domain() const
    {32, 934, 69, 1, 0, 0, 14},	//801 QNetworkCookie::setDomain(const QString&)
    {32, 767, 0, 0, Smoke::mf_const, 164, 15},	//802 QNetworkCookie::path() const
    {32, 1000, 69, 1, 0, 0, 16},	//803 QNetworkCookie::setPath(const QString&)
    {32, 719, 0, 0, Smoke::mf_const, 11, 17},	//804 QNetworkCookie::name() const
    {32, 981, 330, 1, 0, 0, 18},	//805 QNetworkCookie::setName(const QByteArray&)
    {32, 1168, 0, 0, Smoke::mf_const, 11, 19},	//806 QNetworkCookie::value() const
    {32, 1105, 330, 1, 0, 0, 20},	//807 QNetworkCookie::setValue(const QByteArray&)
    {32, 1147, 429, 1, Smoke::mf_const, 11, 21},	//808 QNetworkCookie::toRawForm(QNetworkCookie::RawForm) const
    {32, 760, 330, 1, Smoke::mf_static, 68, 22},	//809 QNetworkCookie::parseCookies(const QByteArray&)
    {32, 244, 0, 0, Smoke::mf_ctor, 102, 23},	//810 QNetworkCookie::QNetworkCookie()
    {32, 244, 330, 1, Smoke::mf_ctor, 102, 24},	//811 QNetworkCookie::QNetworkCookie(const QByteArray&)
    {32, 1147, 0, 0, Smoke::mf_const, 11, 25},	//812 QNetworkCookie::toRawForm() const
    {32, 145, 0, 0, Smoke::mf_static|Smoke::mf_enum, 103, 26},	//813 QNetworkCookie::NameAndValueOnly (enum)
    {32, 95, 0, 0, Smoke::mf_static|Smoke::mf_enum, 103, 27},	//814 QNetworkCookie::Full (enum)
    {32, 1212, 0, 0, Smoke::mf_dtor, 0, 28 },	//815 QNetworkCookie::~QNetworkCookie()
    {33, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//816 QNetworkCookieJar::metaObject() const
    {33, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//817 QNetworkCookieJar::qt_metacast(const char*)
    {33, 1150, 3, 2, Smoke::mf_static, 164, 3},	//818 QNetworkCookieJar::tr(const char*, const char*)
    {33, 1154, 3, 2, Smoke::mf_static, 164, 4},	//819 QNetworkCookieJar::trUtf8(const char*, const char*)
    {33, 1150, 6, 3, Smoke::mf_static, 164, 5},	//820 QNetworkCookieJar::tr(const char*, const char*, int)
    {33, 1154, 6, 3, Smoke::mf_static, 164, 6},	//821 QNetworkCookieJar::trUtf8(const char*, const char*, int)
    {33, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//822 QNetworkCookieJar::qt_metacall(QMetaObject::Call, int, void**)
    {33, 247, 20, 1, Smoke::mf_ctor, 104, 8},	//823 QNetworkCookieJar::QNetworkCookieJar(QObject*)
    {33, 523, 14, 1, Smoke::mf_const|Smoke::mf_virtual, 68, 9},	//824 QNetworkCookieJar::cookiesForUrl(const QUrl&) const
    {33, 924, 431, 2, Smoke::mf_virtual, 252, 10},	//825 QNetworkCookieJar::setCookiesFromUrl(const QList<QNetworkCookie>&, const QUrl&)
    {33, 439, 0, 0, Smoke::mf_const|Smoke::mf_protected, 68, 11},	//826 QNetworkCookieJar::allCookies() const
    {33, 887, 434, 1, Smoke::mf_protected, 0, 12},	//827 QNetworkCookieJar::setAllCookies(const QList<QNetworkCookie>&)
    {33, 1150, 1, 1, Smoke::mf_static, 164, 13},	//828 QNetworkCookieJar::tr(const char*)
    {33, 1154, 1, 1, Smoke::mf_static, 164, 14},	//829 QNetworkCookieJar::trUtf8(const char*)
    {33, 247, 0, 0, Smoke::mf_ctor, 104, 15},	//830 QNetworkCookieJar::QNetworkCookieJar()
    {33, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 16},	//831 QNetworkCookieJar::staticMetaObject() const
    {33, 1213, 0, 0, Smoke::mf_dtor, 0, 17 },	//832 QNetworkCookieJar::~QNetworkCookieJar()
    {34, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//833 QNetworkDiskCache::metaObject() const
    {34, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//834 QNetworkDiskCache::qt_metacast(const char*)
    {34, 1150, 3, 2, Smoke::mf_static, 164, 3},	//835 QNetworkDiskCache::tr(const char*, const char*)
    {34, 1154, 3, 2, Smoke::mf_static, 164, 4},	//836 QNetworkDiskCache::trUtf8(const char*, const char*)
    {34, 1150, 6, 3, Smoke::mf_static, 164, 5},	//837 QNetworkDiskCache::tr(const char*, const char*, int)
    {34, 1154, 6, 3, Smoke::mf_static, 164, 6},	//838 QNetworkDiskCache::trUtf8(const char*, const char*, int)
    {34, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//839 QNetworkDiskCache::qt_metacall(QMetaObject::Call, int, void**)
    {34, 249, 20, 1, Smoke::mf_ctor, 105, 8},	//840 QNetworkDiskCache::QNetworkDiskCache(QObject*)
    {34, 472, 0, 0, Smoke::mf_const, 164, 9},	//841 QNetworkDiskCache::cacheDirectory() const
    {34, 909, 69, 1, 0, 0, 10},	//842 QNetworkDiskCache::setCacheDirectory(const QString&)
    {34, 705, 0, 0, Smoke::mf_const, 302, 11},	//843 QNetworkDiskCache::maximumCacheSize() const
    {34, 977, 33, 1, 0, 0, 12},	//844 QNetworkDiskCache::setMaximumCacheSize(long long)
    {34, 473, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 302, 13},	//845 QNetworkDiskCache::cacheSize() const
    {34, 706, 14, 1, Smoke::mf_virtual, 88, 14},	//846 QNetworkDiskCache::metaData(const QUrl&)
    {34, 1161, 16, 1, Smoke::mf_virtual, 0, 15},	//847 QNetworkDiskCache::updateMetaData(const QNetworkCacheMetaData&)
    {34, 535, 14, 1, Smoke::mf_virtual, 57, 16},	//848 QNetworkDiskCache::data(const QUrl&)
    {34, 844, 14, 1, Smoke::mf_virtual, 252, 17},	//849 QNetworkDiskCache::remove(const QUrl&)
    {34, 790, 16, 1, Smoke::mf_virtual, 57, 18},	//850 QNetworkDiskCache::prepare(const QNetworkCacheMetaData&)
    {34, 634, 18, 1, Smoke::mf_virtual, 0, 19},	//851 QNetworkDiskCache::insert(QIODevice*)
    {34, 579, 69, 1, Smoke::mf_const, 88, 20},	//852 QNetworkDiskCache::fileMetaData(const QString&) const
    {34, 482, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 21},	//853 QNetworkDiskCache::clear()
    {34, 577, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 302, 22},	//854 QNetworkDiskCache::expire()
    {34, 1150, 1, 1, Smoke::mf_static, 164, 23},	//855 QNetworkDiskCache::tr(const char*)
    {34, 1154, 1, 1, Smoke::mf_static, 164, 24},	//856 QNetworkDiskCache::trUtf8(const char*)
    {34, 249, 0, 0, Smoke::mf_ctor, 105, 25},	//857 QNetworkDiskCache::QNetworkDiskCache()
    {34, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 26},	//858 QNetworkDiskCache::staticMetaObject() const
    {34, 1214, 0, 0, Smoke::mf_dtor, 0, 27 },	//859 QNetworkDiskCache::~QNetworkDiskCache()
    {35, 251, 0, 0, Smoke::mf_ctor, 108, 1},	//860 QNetworkInterface::QNetworkInterface()
    {35, 251, 436, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 108, 2},	//861 QNetworkInterface::QNetworkInterface(const QNetworkInterface&)
    {35, 740, 436, 1, 0, 107, 3},	//862 QNetworkInterface::operator=(const QNetworkInterface&)
    {35, 664, 0, 0, Smoke::mf_const, 252, 4},	//863 QNetworkInterface::isValid() const
    {35, 633, 0, 0, Smoke::mf_const, 300, 5},	//864 QNetworkInterface::index() const
    {35, 719, 0, 0, Smoke::mf_const, 164, 6},	//865 QNetworkInterface::name() const
    {35, 625, 0, 0, Smoke::mf_const, 164, 7},	//866 QNetworkInterface::humanReadableName() const
    {35, 583, 0, 0, Smoke::mf_const, 21, 8},	//867 QNetworkInterface::flags() const
    {35, 607, 0, 0, Smoke::mf_const, 164, 9},	//868 QNetworkInterface::hardwareAddress() const
    {35, 433, 0, 0, Smoke::mf_const, 66, 10},	//869 QNetworkInterface::addressEntries() const
    {35, 639, 69, 1, Smoke::mf_static, 106, 11},	//870 QNetworkInterface::interfaceFromName(const QString&)
    {35, 637, 44, 1, Smoke::mf_static, 106, 12},	//871 QNetworkInterface::interfaceFromIndex(int)
    {35, 440, 0, 0, Smoke::mf_static, 69, 13},	//872 QNetworkInterface::allInterfaces()
    {35, 436, 0, 0, Smoke::mf_static, 65, 14},	//873 QNetworkInterface::allAddresses()
    {35, 125, 0, 0, Smoke::mf_static|Smoke::mf_enum, 109, 15},	//874 QNetworkInterface::IsUp (enum)
    {35, 124, 0, 0, Smoke::mf_static|Smoke::mf_enum, 109, 16},	//875 QNetworkInterface::IsRunning (enum)
    {35, 34, 0, 0, Smoke::mf_static|Smoke::mf_enum, 109, 17},	//876 QNetworkInterface::CanBroadcast (enum)
    {35, 122, 0, 0, Smoke::mf_static|Smoke::mf_enum, 109, 18},	//877 QNetworkInterface::IsLoopBack (enum)
    {35, 123, 0, 0, Smoke::mf_static|Smoke::mf_enum, 109, 19},	//878 QNetworkInterface::IsPointToPoint (enum)
    {35, 35, 0, 0, Smoke::mf_static|Smoke::mf_enum, 109, 20},	//879 QNetworkInterface::CanMulticast (enum)
    {35, 1215, 0, 0, Smoke::mf_dtor, 0, 21 },	//880 QNetworkInterface::~QNetworkInterface()
    {36, 253, 0, 0, Smoke::mf_ctor, 112, 1},	//881 QNetworkProxy::QNetworkProxy()
    {36, 253, 438, 5, Smoke::mf_ctor, 112, 2},	//882 QNetworkProxy::QNetworkProxy(QNetworkProxy::ProxyType, const QString&, unsigned short, const QString&, const QString&)
    {36, 253, 46, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 112, 3},	//883 QNetworkProxy::QNetworkProxy(const QNetworkProxy&)
    {36, 740, 46, 1, 0, 111, 4},	//884 QNetworkProxy::operator=(const QNetworkProxy&)
    {36, 743, 46, 1, Smoke::mf_const, 252, 5},	//885 QNetworkProxy::operator==(const QNetworkProxy&) const
    {36, 734, 46, 1, Smoke::mf_const, 252, 6},	//886 QNetworkProxy::operator!=(const QNetworkProxy&) const
    {36, 1094, 444, 1, 0, 0, 7},	//887 QNetworkProxy::setType(QNetworkProxy::ProxyType)
    {36, 1158, 0, 0, Smoke::mf_const, 114, 8},	//888 QNetworkProxy::type() const
    {36, 911, 446, 1, 0, 0, 9},	//889 QNetworkProxy::setCapabilities(QFlags<QNetworkProxy::Capability>)
    {36, 475, 0, 0, Smoke::mf_const, 22, 10},	//890 QNetworkProxy::capabilities() const
    {36, 642, 0, 0, Smoke::mf_const, 252, 11},	//891 QNetworkProxy::isCachingProxy() const
    {36, 663, 0, 0, Smoke::mf_const, 252, 12},	//892 QNetworkProxy::isTransparentProxy() const
    {36, 1100, 69, 1, 0, 0, 13},	//893 QNetworkProxy::setUser(const QString&)
    {36, 1167, 0, 0, Smoke::mf_const, 164, 14},	//894 QNetworkProxy::user() const
    {36, 998, 69, 1, 0, 0, 15},	//895 QNetworkProxy::setPassword(const QString&)
    {36, 766, 0, 0, Smoke::mf_const, 164, 16},	//896 QNetworkProxy::password() const
    {36, 955, 69, 1, 0, 0, 17},	//897 QNetworkProxy::setHostName(const QString&)
    {36, 624, 0, 0, Smoke::mf_const, 164, 18},	//898 QNetworkProxy::hostName() const
    {36, 1018, 65, 1, 0, 0, 19},	//899 QNetworkProxy::setPort(unsigned short)
    {36, 781, 0, 0, Smoke::mf_const, 311, 20},	//900 QNetworkProxy::port() const
    {36, 889, 46, 1, Smoke::mf_static, 0, 21},	//901 QNetworkProxy::setApplicationProxy(const QNetworkProxy&)
    {36, 446, 0, 0, Smoke::mf_static, 110, 22},	//902 QNetworkProxy::applicationProxy()
    {36, 253, 444, 1, Smoke::mf_ctor, 112, 23},	//903 QNetworkProxy::QNetworkProxy(QNetworkProxy::ProxyType)
    {36, 253, 448, 2, Smoke::mf_ctor, 112, 24},	//904 QNetworkProxy::QNetworkProxy(QNetworkProxy::ProxyType, const QString&)
    {36, 253, 451, 3, Smoke::mf_ctor, 112, 25},	//905 QNetworkProxy::QNetworkProxy(QNetworkProxy::ProxyType, const QString&, unsigned short)
    {36, 253, 455, 4, Smoke::mf_ctor, 112, 26},	//906 QNetworkProxy::QNetworkProxy(QNetworkProxy::ProxyType, const QString&, unsigned short, const QString&)
    {36, 76, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 27},	//907 QNetworkProxy::DefaultProxy (enum)
    {36, 345, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 28},	//908 QNetworkProxy::Socks5Proxy (enum)
    {36, 150, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 29},	//909 QNetworkProxy::NoProxy (enum)
    {36, 109, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 30},	//910 QNetworkProxy::HttpProxy (enum)
    {36, 106, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 31},	//911 QNetworkProxy::HttpCachingProxy (enum)
    {36, 94, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 32},	//912 QNetworkProxy::FtpCachingProxy (enum)
    {36, 369, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 33},	//913 QNetworkProxy::TunnelingCapability (enum)
    {36, 129, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 34},	//914 QNetworkProxy::ListeningCapability (enum)
    {36, 371, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 35},	//915 QNetworkProxy::UdpTunnelingCapability (enum)
    {36, 33, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 36},	//916 QNetworkProxy::CachingCapability (enum)
    {36, 102, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 37},	//917 QNetworkProxy::HostNameLookupCapability (enum)
    {36, 1216, 0, 0, Smoke::mf_dtor, 0, 38 },	//918 QNetworkProxy::~QNetworkProxy()
    {37, 260, 0, 0, Smoke::mf_ctor, 115, 1},	//919 QNetworkProxyFactory::QNetworkProxyFactory()
    {37, 815, 460, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 70, 2},	//920 QNetworkProxyFactory::queryProxy(const QNetworkProxyQuery&) [pure virtual]
    {37, 1098, 116, 1, Smoke::mf_static, 0, 3},	//921 QNetworkProxyFactory::setUseSystemConfiguration(bool)
    {37, 891, 377, 1, Smoke::mf_static, 0, 4},	//922 QNetworkProxyFactory::setApplicationProxyFactory(QNetworkProxyFactory*)
    {37, 801, 460, 1, Smoke::mf_static, 70, 5},	//923 QNetworkProxyFactory::proxyForQuery(const QNetworkProxyQuery&)
    {37, 1136, 460, 1, Smoke::mf_static, 70, 6},	//924 QNetworkProxyFactory::systemProxyForQuery(const QNetworkProxyQuery&)
    {37, 260, 462, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 115, 7},	//925 QNetworkProxyFactory::QNetworkProxyFactory(const QNetworkProxyFactory&)
    {37, 815, 0, 0, 0, 70, 8},	//926 QNetworkProxyFactory::queryProxy()
    {37, 1136, 0, 0, Smoke::mf_static, 70, 9},	//927 QNetworkProxyFactory::systemProxyForQuery()
    {37, 1217, 0, 0, Smoke::mf_dtor, 0, 10 },	//928 QNetworkProxyFactory::~QNetworkProxyFactory()
    {38, 262, 0, 0, Smoke::mf_ctor, 117, 1},	//929 QNetworkProxyQuery::QNetworkProxyQuery()
    {38, 262, 464, 2, Smoke::mf_ctor, 117, 2},	//930 QNetworkProxyQuery::QNetworkProxyQuery(const QUrl&, QNetworkProxyQuery::QueryType)
    {38, 262, 467, 4, Smoke::mf_ctor, 117, 3},	//931 QNetworkProxyQuery::QNetworkProxyQuery(const QString&, int, const QString&, QNetworkProxyQuery::QueryType)
    {38, 262, 472, 3, Smoke::mf_ctor, 117, 4},	//932 QNetworkProxyQuery::QNetworkProxyQuery(unsigned short, const QString&, QNetworkProxyQuery::QueryType)
    {38, 262, 460, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 117, 5},	//933 QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkProxyQuery&)
    {38, 262, 476, 3, Smoke::mf_ctor, 117, 6},	//934 QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, const QUrl&, QNetworkProxyQuery::QueryType)
    {38, 262, 480, 5, Smoke::mf_ctor, 117, 7},	//935 QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, const QString&, int, const QString&, QNetworkProxyQuery::QueryType)
    {38, 262, 486, 4, Smoke::mf_ctor, 117, 8},	//936 QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, unsigned short, const QString&, QNetworkProxyQuery::QueryType)
    {38, 740, 460, 1, 0, 116, 9},	//937 QNetworkProxyQuery::operator=(const QNetworkProxyQuery&)
    {38, 743, 460, 1, Smoke::mf_const, 252, 10},	//938 QNetworkProxyQuery::operator==(const QNetworkProxyQuery&) const
    {38, 734, 460, 1, Smoke::mf_const, 252, 11},	//939 QNetworkProxyQuery::operator!=(const QNetworkProxyQuery&) const
    {38, 817, 0, 0, Smoke::mf_const, 118, 12},	//940 QNetworkProxyQuery::queryType() const
    {38, 1041, 491, 1, 0, 0, 13},	//941 QNetworkProxyQuery::setQueryType(QNetworkProxyQuery::QueryType)
    {38, 773, 0, 0, Smoke::mf_const, 300, 14},	//942 QNetworkProxyQuery::peerPort() const
    {38, 1008, 44, 1, 0, 0, 15},	//943 QNetworkProxyQuery::setPeerPort(int)
    {38, 771, 0, 0, Smoke::mf_const, 164, 16},	//944 QNetworkProxyQuery::peerHostName() const
    {38, 1004, 69, 1, 0, 0, 17},	//945 QNetworkProxyQuery::setPeerHostName(const QString&)
    {38, 695, 0, 0, Smoke::mf_const, 300, 18},	//946 QNetworkProxyQuery::localPort() const
    {38, 971, 44, 1, 0, 0, 19},	//947 QNetworkProxyQuery::setLocalPort(int)
    {38, 796, 0, 0, Smoke::mf_const, 164, 20},	//948 QNetworkProxyQuery::protocolTag() const
    {38, 1032, 69, 1, 0, 0, 21},	//949 QNetworkProxyQuery::setProtocolTag(const QString&)
    {38, 1165, 0, 0, Smoke::mf_const, 172, 22},	//950 QNetworkProxyQuery::url() const
    {38, 1096, 14, 1, 0, 0, 23},	//951 QNetworkProxyQuery::setUrl(const QUrl&)
    {38, 724, 0, 0, Smoke::mf_const, 91, 24},	//952 QNetworkProxyQuery::networkConfiguration() const
    {38, 988, 398, 1, 0, 0, 25},	//953 QNetworkProxyQuery::setNetworkConfiguration(const QNetworkConfiguration&)
    {38, 262, 14, 1, Smoke::mf_ctor, 117, 26},	//954 QNetworkProxyQuery::QNetworkProxyQuery(const QUrl&)
    {38, 262, 301, 2, Smoke::mf_ctor, 117, 27},	//955 QNetworkProxyQuery::QNetworkProxyQuery(const QString&, int)
    {38, 262, 304, 3, Smoke::mf_ctor, 117, 28},	//956 QNetworkProxyQuery::QNetworkProxyQuery(const QString&, int, const QString&)
    {38, 262, 65, 1, Smoke::mf_ctor, 117, 29},	//957 QNetworkProxyQuery::QNetworkProxyQuery(unsigned short)
    {38, 262, 493, 2, Smoke::mf_ctor, 117, 30},	//958 QNetworkProxyQuery::QNetworkProxyQuery(unsigned short, const QString&)
    {38, 262, 496, 2, Smoke::mf_ctor, 117, 31},	//959 QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, const QUrl&)
    {38, 262, 499, 3, Smoke::mf_ctor, 117, 32},	//960 QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, const QString&, int)
    {38, 262, 503, 4, Smoke::mf_ctor, 117, 33},	//961 QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, const QString&, int, const QString&)
    {38, 262, 508, 2, Smoke::mf_ctor, 117, 34},	//962 QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, unsigned short)
    {38, 262, 511, 3, Smoke::mf_ctor, 117, 35},	//963 QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, unsigned short, const QString&)
    {38, 362, 0, 0, Smoke::mf_static|Smoke::mf_enum, 118, 36},	//964 QNetworkProxyQuery::TcpSocket (enum)
    {38, 370, 0, 0, Smoke::mf_static|Smoke::mf_enum, 118, 37},	//965 QNetworkProxyQuery::UdpSocket (enum)
    {38, 361, 0, 0, Smoke::mf_static|Smoke::mf_enum, 118, 38},	//966 QNetworkProxyQuery::TcpServer (enum)
    {38, 398, 0, 0, Smoke::mf_static|Smoke::mf_enum, 118, 39},	//967 QNetworkProxyQuery::UrlRequest (enum)
    {38, 1218, 0, 0, Smoke::mf_dtor, 0, 40 },	//968 QNetworkProxyQuery::~QNetworkProxyQuery()
    {39, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//969 QNetworkReply::metaObject() const
    {39, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//970 QNetworkReply::qt_metacast(const char*)
    {39, 1150, 3, 2, Smoke::mf_static, 164, 3},	//971 QNetworkReply::tr(const char*, const char*)
    {39, 1154, 3, 2, Smoke::mf_static, 164, 4},	//972 QNetworkReply::trUtf8(const char*, const char*)
    {39, 1150, 6, 3, Smoke::mf_static, 164, 5},	//973 QNetworkReply::tr(const char*, const char*, int)
    {39, 1154, 6, 3, Smoke::mf_static, 164, 6},	//974 QNetworkReply::trUtf8(const char*, const char*, int)
    {39, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//975 QNetworkReply::qt_metacall(QMetaObject::Call, int, void**)
    {39, 409, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 8},	//976 QNetworkReply::abort() [pure virtual]
    {39, 485, 0, 0, Smoke::mf_virtual, 0, 9},	//977 QNetworkReply::close()
    {39, 660, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 252, 10},	//978 QNetworkReply::isSequential() const
    {39, 830, 0, 0, Smoke::mf_const, 302, 11},	//979 QNetworkReply::readBufferSize() const
    {39, 1047, 33, 1, Smoke::mf_virtual, 0, 12},	//980 QNetworkReply::setReadBufferSize(long long)
    {39, 703, 0, 0, Smoke::mf_const, 82, 13},	//981 QNetworkReply::manager() const
    {39, 733, 0, 0, Smoke::mf_const, 84, 14},	//982 QNetworkReply::operation() const
    {39, 855, 0, 0, Smoke::mf_const, 121, 15},	//983 QNetworkReply::request() const
    {39, 571, 0, 0, Smoke::mf_const, 120, 16},	//984 QNetworkReply::error() const
    {39, 647, 0, 0, Smoke::mf_const, 252, 17},	//985 QNetworkReply::isFinished() const
    {39, 658, 0, 0, Smoke::mf_const, 252, 18},	//986 QNetworkReply::isRunning() const
    {39, 1165, 0, 0, Smoke::mf_const, 172, 19},	//987 QNetworkReply::url() const
    {39, 621, 515, 1, Smoke::mf_const, 177, 20},	//988 QNetworkReply::header(QNetworkRequest::KnownHeaders) const
    {39, 616, 330, 1, Smoke::mf_const, 252, 21},	//989 QNetworkReply::hasRawHeader(const QByteArray&) const
    {39, 824, 0, 0, Smoke::mf_const, 64, 22},	//990 QNetworkReply::rawHeaderList() const
    {39, 822, 330, 1, Smoke::mf_const, 11, 23},	//991 QNetworkReply::rawHeader(const QByteArray&) const
    {39, 825, 0, 0, Smoke::mf_const, 268, 24},	//992 QNetworkReply::rawHeaderPairs() const
    {39, 448, 517, 1, Smoke::mf_const, 177, 25},	//993 QNetworkReply::attribute(QNetworkRequest::Attribute) const
    {39, 1117, 0, 0, Smoke::mf_const, 151, 26},	//994 QNetworkReply::sslConfiguration() const
    {39, 1081, 519, 1, 0, 0, 27},	//995 QNetworkReply::setSslConfiguration(const QSslConfiguration&)
    {39, 628, 296, 1, 0, 0, 28},	//996 QNetworkReply::ignoreSslErrors(const QList<QSslError>&)
    {39, 628, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 29},	//997 QNetworkReply::ignoreSslErrors()
    {39, 708, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 30},	//998 QNetworkReply::metaDataChanged()
    {39, 581, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 31},	//999 QNetworkReply::finished()
    {39, 571, 521, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 32},	//1000 QNetworkReply::error(QNetworkReply::NetworkError)
    {39, 1118, 296, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 33},	//1001 QNetworkReply::sslErrors(const QList<QSslError>&)
    {39, 1163, 107, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 34},	//1002 QNetworkReply::uploadProgress(qint64, qint64)
    {39, 560, 107, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 35},	//1003 QNetworkReply::downloadProgress(qint64, qint64)
    {39, 274, 20, 1, Smoke::mf_ctor|Smoke::mf_protected, 119, 36},	//1004 QNetworkReply::QNetworkReply(QObject*)
    {39, 1187, 62, 2, Smoke::mf_protected|Smoke::mf_virtual, 302, 37},	//1005 QNetworkReply::writeData(const char*, long long)
    {39, 990, 523, 1, Smoke::mf_protected, 0, 38},	//1006 QNetworkReply::setOperation(QNetworkAccessManager::Operation)
    {39, 1051, 383, 1, Smoke::mf_protected, 0, 39},	//1007 QNetworkReply::setRequest(const QNetworkRequest&)
    {39, 936, 525, 2, Smoke::mf_protected, 0, 40},	//1008 QNetworkReply::setError(QNetworkReply::NetworkError, const QString&)
    {39, 945, 116, 1, Smoke::mf_protected, 0, 41},	//1009 QNetworkReply::setFinished(bool)
    {39, 1096, 14, 1, Smoke::mf_protected, 0, 42},	//1010 QNetworkReply::setUrl(const QUrl&)
    {39, 949, 332, 2, Smoke::mf_protected, 0, 43},	//1011 QNetworkReply::setHeader(QNetworkRequest::KnownHeaders, const QVariant&)
    {39, 1043, 335, 2, Smoke::mf_protected, 0, 44},	//1012 QNetworkReply::setRawHeader(const QByteArray&, const QByteArray&)
    {39, 893, 528, 2, Smoke::mf_protected, 0, 45},	//1013 QNetworkReply::setAttribute(QNetworkRequest::Attribute, const QVariant&)
    {39, 1150, 1, 1, Smoke::mf_static, 164, 46},	//1014 QNetworkReply::tr(const char*)
    {39, 1154, 1, 1, Smoke::mf_static, 164, 47},	//1015 QNetworkReply::trUtf8(const char*)
    {39, 274, 0, 0, Smoke::mf_ctor|Smoke::mf_protected, 119, 48},	//1016 QNetworkReply::QNetworkReply()
    {39, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 49},	//1017 QNetworkReply::staticMetaObject() const
    {39, 148, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 50},	//1018 QNetworkReply::NoError (enum)
    {39, 59, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 51},	//1019 QNetworkReply::ConnectionRefusedError (enum)
    {39, 321, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 52},	//1020 QNetworkReply::RemoteHostClosedError (enum)
    {39, 105, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 53},	//1021 QNetworkReply::HostNotFoundError (enum)
    {39, 365, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 54},	//1022 QNetworkReply::TimeoutError (enum)
    {39, 159, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 55},	//1023 QNetworkReply::OperationCanceledError (enum)
    {39, 348, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 56},	//1024 QNetworkReply::SslHandshakeFailedError (enum)
    {39, 363, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 57},	//1025 QNetworkReply::TemporaryNetworkFailureError (enum)
    {39, 387, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 58},	//1026 QNetworkReply::UnknownNetworkError (enum)
    {39, 177, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 59},	//1027 QNetworkReply::ProxyConnectionRefusedError (enum)
    {39, 176, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 60},	//1028 QNetworkReply::ProxyConnectionClosedError (enum)
    {39, 179, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 61},	//1029 QNetworkReply::ProxyNotFoundError (enum)
    {39, 181, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 62},	//1030 QNetworkReply::ProxyTimeoutError (enum)
    {39, 175, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 63},	//1031 QNetworkReply::ProxyAuthenticationRequiredError (enum)
    {39, 391, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 64},	//1032 QNetworkReply::UnknownProxyError (enum)
    {39, 60, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 65},	//1033 QNetworkReply::ContentAccessDenied (enum)
    {39, 64, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 66},	//1034 QNetworkReply::ContentOperationNotPermittedError (enum)
    {39, 63, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 67},	//1035 QNetworkReply::ContentNotFoundError (enum)
    {39, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 68},	//1036 QNetworkReply::AuthenticationRequiredError (enum)
    {39, 65, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 69},	//1037 QNetworkReply::ContentReSendError (enum)
    {39, 385, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 70},	//1038 QNetworkReply::UnknownContentError (enum)
    {39, 174, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 71},	//1039 QNetworkReply::ProtocolUnknownError (enum)
    {39, 173, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 72},	//1040 QNetworkReply::ProtocolInvalidOperationError (enum)
    {39, 172, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 73},	//1041 QNetworkReply::ProtocolFailure (enum)
    {39, 1219, 0, 0, Smoke::mf_dtor, 0, 74 },	//1042 QNetworkReply::~QNetworkReply()
    {40, 276, 14, 1, Smoke::mf_ctor, 123, 1},	//1043 QNetworkRequest::QNetworkRequest(const QUrl&)
    {40, 276, 383, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 123, 2},	//1044 QNetworkRequest::QNetworkRequest(const QNetworkRequest&)
    {40, 740, 383, 1, 0, 122, 3},	//1045 QNetworkRequest::operator=(const QNetworkRequest&)
    {40, 743, 383, 1, Smoke::mf_const, 252, 4},	//1046 QNetworkRequest::operator==(const QNetworkRequest&) const
    {40, 734, 383, 1, Smoke::mf_const, 252, 5},	//1047 QNetworkRequest::operator!=(const QNetworkRequest&) const
    {40, 1165, 0, 0, Smoke::mf_const, 172, 6},	//1048 QNetworkRequest::url() const
    {40, 1096, 14, 1, 0, 0, 7},	//1049 QNetworkRequest::setUrl(const QUrl&)
    {40, 621, 515, 1, Smoke::mf_const, 177, 8},	//1050 QNetworkRequest::header(QNetworkRequest::KnownHeaders) const
    {40, 949, 332, 2, 0, 0, 9},	//1051 QNetworkRequest::setHeader(QNetworkRequest::KnownHeaders, const QVariant&)
    {40, 616, 330, 1, Smoke::mf_const, 252, 10},	//1052 QNetworkRequest::hasRawHeader(const QByteArray&) const
    {40, 824, 0, 0, Smoke::mf_const, 64, 11},	//1053 QNetworkRequest::rawHeaderList() const
    {40, 822, 330, 1, Smoke::mf_const, 11, 12},	//1054 QNetworkRequest::rawHeader(const QByteArray&) const
    {40, 1043, 335, 2, 0, 0, 13},	//1055 QNetworkRequest::setRawHeader(const QByteArray&, const QByteArray&)
    {40, 448, 528, 2, Smoke::mf_const, 177, 14},	//1056 QNetworkRequest::attribute(QNetworkRequest::Attribute, const QVariant&) const
    {40, 893, 528, 2, 0, 0, 15},	//1057 QNetworkRequest::setAttribute(QNetworkRequest::Attribute, const QVariant&)
    {40, 1117, 0, 0, Smoke::mf_const, 151, 16},	//1058 QNetworkRequest::sslConfiguration() const
    {40, 1081, 519, 1, 0, 0, 17},	//1059 QNetworkRequest::setSslConfiguration(const QSslConfiguration&)
    {40, 994, 20, 1, 0, 0, 18},	//1060 QNetworkRequest::setOriginatingObject(QObject*)
    {40, 756, 0, 0, Smoke::mf_const, 132, 19},	//1061 QNetworkRequest::originatingObject() const
    {40, 792, 0, 0, Smoke::mf_const, 128, 20},	//1062 QNetworkRequest::priority() const
    {40, 1022, 531, 1, 0, 0, 21},	//1063 QNetworkRequest::setPriority(QNetworkRequest::Priority)
    {40, 276, 0, 0, Smoke::mf_ctor, 123, 22},	//1064 QNetworkRequest::QNetworkRequest()
    {40, 448, 517, 1, Smoke::mf_const, 177, 23},	//1065 QNetworkRequest::attribute(QNetworkRequest::Attribute) const
    {40, 66, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 24},	//1066 QNetworkRequest::ContentTypeHeader (enum)
    {40, 62, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 25},	//1067 QNetworkRequest::ContentLengthHeader (enum)
    {40, 134, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 26},	//1068 QNetworkRequest::LocationHeader (enum)
    {40, 127, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 27},	//1069 QNetworkRequest::LastModifiedHeader (enum)
    {40, 67, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 28},	//1070 QNetworkRequest::CookieHeader (enum)
    {40, 337, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 29},	//1071 QNetworkRequest::SetCookieHeader (enum)
    {40, 61, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 30},	//1072 QNetworkRequest::ContentDispositionHeader (enum)
    {40, 111, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 31},	//1073 QNetworkRequest::HttpStatusCodeAttribute (enum)
    {40, 110, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 32},	//1074 QNetworkRequest::HttpReasonPhraseAttribute (enum)
    {40, 319, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 33},	//1075 QNetworkRequest::RedirectionTargetAttribute (enum)
    {40, 54, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 34},	//1076 QNetworkRequest::ConnectionEncryptedAttribute (enum)
    {40, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 35},	//1077 QNetworkRequest::CacheLoadControlAttribute (enum)
    {40, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 36},	//1078 QNetworkRequest::CacheSaveControlAttribute (enum)
    {40, 346, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 37},	//1079 QNetworkRequest::SourceIsFromCacheAttribute (enum)
    {40, 84, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 38},	//1080 QNetworkRequest::DoNotBufferUploadDataAttribute (enum)
    {40, 107, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 39},	//1081 QNetworkRequest::HttpPipeliningAllowedAttribute (enum)
    {40, 108, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 40},	//1082 QNetworkRequest::HttpPipeliningWasUsedAttribute (enum)
    {40, 72, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 41},	//1083 QNetworkRequest::CustomVerbAttribute (enum)
    {40, 68, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 42},	//1084 QNetworkRequest::CookieLoadControlAttribute (enum)
    {40, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 43},	//1085 QNetworkRequest::AuthenticationReuseAttribute (enum)
    {40, 69, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 44},	//1086 QNetworkRequest::CookieSaveControlAttribute (enum)
    {40, 140, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 45},	//1087 QNetworkRequest::MaximumDownloadBufferSizeAttribute (enum)
    {40, 86, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 46},	//1088 QNetworkRequest::DownloadBufferAttribute (enum)
    {40, 359, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 47},	//1089 QNetworkRequest::SynchronousRequestAttribute (enum)
    {40, 399, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 48},	//1090 QNetworkRequest::User (enum)
    {40, 401, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 49},	//1091 QNetworkRequest::UserMax (enum)
    {40, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 125, 50},	//1092 QNetworkRequest::AlwaysNetwork (enum)
    {40, 169, 0, 0, Smoke::mf_static|Smoke::mf_enum, 125, 51},	//1093 QNetworkRequest::PreferNetwork (enum)
    {40, 168, 0, 0, Smoke::mf_static|Smoke::mf_enum, 125, 52},	//1094 QNetworkRequest::PreferCache (enum)
    {40, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 125, 53},	//1095 QNetworkRequest::AlwaysCache (enum)
    {40, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 54},	//1096 QNetworkRequest::Automatic (enum)
    {40, 139, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 55},	//1097 QNetworkRequest::Manual (enum)
    {40, 99, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 56},	//1098 QNetworkRequest::HighPriority (enum)
    {40, 153, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 57},	//1099 QNetworkRequest::NormalPriority (enum)
    {40, 138, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 58},	//1100 QNetworkRequest::LowPriority (enum)
    {40, 1220, 0, 0, Smoke::mf_dtor, 0, 59 },	//1101 QNetworkRequest::~QNetworkRequest()
    {41, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//1102 QNetworkSession::metaObject() const
    {41, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//1103 QNetworkSession::qt_metacast(const char*)
    {41, 1150, 3, 2, Smoke::mf_static, 164, 3},	//1104 QNetworkSession::tr(const char*, const char*)
    {41, 1154, 3, 2, Smoke::mf_static, 164, 4},	//1105 QNetworkSession::trUtf8(const char*, const char*)
    {41, 1150, 6, 3, Smoke::mf_static, 164, 5},	//1106 QNetworkSession::tr(const char*, const char*, int)
    {41, 1154, 6, 3, Smoke::mf_static, 164, 6},	//1107 QNetworkSession::trUtf8(const char*, const char*, int)
    {41, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//1108 QNetworkSession::qt_metacall(QMetaObject::Call, int, void**)
    {41, 278, 533, 2, Smoke::mf_ctor, 129, 8},	//1109 QNetworkSession::QNetworkSession(const QNetworkConfiguration&, QObject*)
    {41, 655, 0, 0, Smoke::mf_const, 252, 9},	//1110 QNetworkSession::isOpen() const
    {41, 492, 0, 0, Smoke::mf_const, 91, 10},	//1111 QNetworkSession::configuration() const
    {41, 636, 0, 0, Smoke::mf_const, 106, 11},	//1112 QNetworkSession::interface() const
    {41, 1123, 0, 0, Smoke::mf_const, 131, 12},	//1113 QNetworkSession::state() const
    {41, 571, 0, 0, Smoke::mf_const, 130, 13},	//1114 QNetworkSession::error() const
    {41, 573, 0, 0, Smoke::mf_const, 164, 14},	//1115 QNetworkSession::errorString() const
    {41, 880, 69, 1, Smoke::mf_const, 177, 15},	//1116 QNetworkSession::sessionProperty(const QString&) const
    {41, 1062, 85, 2, 0, 0, 16},	//1117 QNetworkSession::setSessionProperty(const QString&, const QVariant&)
    {41, 469, 0, 0, Smoke::mf_const, 310, 17},	//1118 QNetworkSession::bytesWritten() const
    {41, 467, 0, 0, Smoke::mf_const, 310, 18},	//1119 QNetworkSession::bytesReceived() const
    {41, 414, 0, 0, Smoke::mf_const, 310, 19},	//1120 QNetworkSession::activeTime() const
    {41, 1183, 44, 1, 0, 252, 20},	//1121 QNetworkSession::waitForOpened(int)
    {41, 731, 0, 0, Smoke::mf_slot, 0, 21},	//1122 QNetworkSession::open()
    {41, 485, 0, 0, Smoke::mf_slot, 0, 22},	//1123 QNetworkSession::close()
    {41, 1128, 0, 0, Smoke::mf_slot, 0, 23},	//1124 QNetworkSession::stop()
    {41, 711, 0, 0, Smoke::mf_slot, 0, 24},	//1125 QNetworkSession::migrate()
    {41, 627, 0, 0, Smoke::mf_slot, 0, 25},	//1126 QNetworkSession::ignore()
    {41, 412, 0, 0, Smoke::mf_slot, 0, 26},	//1127 QNetworkSession::accept()
    {41, 843, 0, 0, Smoke::mf_slot, 0, 27},	//1128 QNetworkSession::reject()
    {41, 1124, 536, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 28},	//1129 QNetworkSession::stateChanged(QNetworkSession::State)
    {41, 732, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 29},	//1130 QNetworkSession::opened()
    {41, 487, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 30},	//1131 QNetworkSession::closed()
    {41, 571, 538, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 31},	//1132 QNetworkSession::error(QNetworkSession::SessionError)
    {41, 787, 540, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 32},	//1133 QNetworkSession::preferredConfigurationChanged(const QNetworkConfiguration&, bool)
    {41, 726, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 33},	//1134 QNetworkSession::newConfigurationActivated()
    {41, 501, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 34},	//1135 QNetworkSession::connectNotify(const char*)
    {41, 554, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 35},	//1136 QNetworkSession::disconnectNotify(const char*)
    {41, 1150, 1, 1, Smoke::mf_static, 164, 36},	//1137 QNetworkSession::tr(const char*)
    {41, 1154, 1, 1, Smoke::mf_static, 164, 37},	//1138 QNetworkSession::trUtf8(const char*)
    {41, 278, 398, 1, Smoke::mf_ctor, 129, 38},	//1139 QNetworkSession::QNetworkSession(const QNetworkConfiguration&)
    {41, 1183, 0, 0, 0, 252, 39},	//1140 QNetworkSession::waitForOpened()
    {41, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 40},	//1141 QNetworkSession::staticMetaObject() const
    {41, 115, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 41},	//1142 QNetworkSession::Invalid (enum)
    {41, 155, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 42},	//1143 QNetworkSession::NotAvailable (enum)
    {41, 52, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 43},	//1144 QNetworkSession::Connecting (enum)
    {41, 50, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 44},	//1145 QNetworkSession::Connected (enum)
    {41, 46, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 45},	//1146 QNetworkSession::Closing (enum)
    {41, 81, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 46},	//1147 QNetworkSession::Disconnected (enum)
    {41, 326, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 47},	//1148 QNetworkSession::Roaming (enum)
    {41, 393, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 48},	//1149 QNetworkSession::UnknownSessionError (enum)
    {41, 336, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 49},	//1150 QNetworkSession::SessionAbortedError (enum)
    {41, 327, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 50},	//1151 QNetworkSession::RoamingError (enum)
    {41, 160, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 51},	//1152 QNetworkSession::OperationNotSupportedError (enum)
    {41, 117, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 52},	//1153 QNetworkSession::InvalidConfigurationError (enum)
    {41, 1221, 0, 0, Smoke::mf_dtor, 0, 53 },	//1154 QNetworkSession::~QNetworkSession()
    {42, 574, 543, 1, Smoke::mf_virtual, 252, 0},	//1155 QObject::event(QEvent*)
    {42, 575, 545, 2, Smoke::mf_virtual, 252, 0},	//1156 QObject::eventFilter(QObject*, QEvent*)
    {42, 1140, 548, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1157 QObject::timerEvent(QTimerEvent*)
    {42, 479, 550, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1158 QObject::childEvent(QChildEvent*)
    {42, 534, 543, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1159 QObject::customEvent(QEvent*)
    {42, 501, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1160 QObject::connectNotify(const char*)
    {42, 554, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1161 QObject::disconnectNotify(const char*)
    {44, 328, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 1},	//1162 QSsl::Rsa (enum)
    {44, 87, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 2},	//1163 QSsl::Dsa (enum)
    {44, 166, 0, 0, Smoke::mf_static|Smoke::mf_enum, 139, 3},	//1164 QSsl::Pem (enum)
    {44, 79, 0, 0, Smoke::mf_static|Smoke::mf_enum, 139, 4},	//1165 QSsl::Der (enum)
    {44, 350, 0, 0, Smoke::mf_static|Smoke::mf_enum, 142, 5},	//1166 QSsl::SslOptionDisableEmptyFragments (enum)
    {44, 353, 0, 0, Smoke::mf_static|Smoke::mf_enum, 142, 6},	//1167 QSsl::SslOptionDisableSessionTickets (enum)
    {44, 349, 0, 0, Smoke::mf_static|Smoke::mf_enum, 142, 7},	//1168 QSsl::SslOptionDisableCompression (enum)
    {44, 352, 0, 0, Smoke::mf_static|Smoke::mf_enum, 142, 8},	//1169 QSsl::SslOptionDisableServerNameIndication (enum)
    {44, 351, 0, 0, Smoke::mf_static|Smoke::mf_enum, 142, 9},	//1170 QSsl::SslOptionDisableLegacyRenegotiation (enum)
    {44, 356, 0, 0, Smoke::mf_static|Smoke::mf_enum, 143, 10},	//1171 QSsl::SslV3 (enum)
    {44, 355, 0, 0, Smoke::mf_static|Smoke::mf_enum, 143, 11},	//1172 QSsl::SslV2 (enum)
    {44, 366, 0, 0, Smoke::mf_static|Smoke::mf_enum, 143, 12},	//1173 QSsl::TlsV1 (enum)
    {44, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 143, 13},	//1174 QSsl::AnyProtocol (enum)
    {44, 367, 0, 0, Smoke::mf_static|Smoke::mf_enum, 143, 14},	//1175 QSsl::TlsV1SslV3 (enum)
    {44, 329, 0, 0, Smoke::mf_static|Smoke::mf_enum, 143, 15},	//1176 QSsl::SecureProtocols (enum)
    {44, 390, 0, 0, Smoke::mf_static|Smoke::mf_enum, 143, 16},	//1177 QSsl::UnknownProtocol (enum)
    {44, 88, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 17},	//1178 QSsl::EmailEntry (enum)
    {44, 83, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 18},	//1179 QSsl::DnsEntry (enum)
    {44, 170, 0, 0, Smoke::mf_static|Smoke::mf_enum, 141, 19},	//1180 QSsl::PrivateKey (enum)
    {44, 182, 0, 0, Smoke::mf_static|Smoke::mf_enum, 141, 20},	//1181 QSsl::PublicKey (enum)
    {45, 281, 552, 2, Smoke::mf_ctor, 146, 1},	//1182 QSslCertificate::QSslCertificate(QIODevice*, QSsl::EncodingFormat)
    {45, 281, 555, 2, Smoke::mf_ctor, 146, 2},	//1183 QSslCertificate::QSslCertificate(const QByteArray&, QSsl::EncodingFormat)
    {45, 281, 558, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 146, 3},	//1184 QSslCertificate::QSslCertificate(const QSslCertificate&)
    {45, 740, 558, 1, 0, 145, 4},	//1185 QSslCertificate::operator=(const QSslCertificate&)
    {45, 743, 558, 1, Smoke::mf_const, 252, 5},	//1186 QSslCertificate::operator==(const QSslCertificate&) const
    {45, 734, 558, 1, Smoke::mf_const, 252, 6},	//1187 QSslCertificate::operator!=(const QSslCertificate&) const
    {45, 653, 0, 0, Smoke::mf_const, 252, 7},	//1188 QSslCertificate::isNull() const
    {45, 664, 0, 0, Smoke::mf_const, 252, 8},	//1189 QSslCertificate::isValid() const
    {45, 482, 0, 0, 0, 0, 9},	//1190 QSslCertificate::clear()
    {45, 1171, 0, 0, Smoke::mf_const, 11, 10},	//1191 QSslCertificate::version() const
    {45, 874, 0, 0, Smoke::mf_const, 11, 11},	//1192 QSslCertificate::serialNumber() const
    {45, 549, 560, 1, Smoke::mf_const, 11, 12},	//1193 QSslCertificate::digest(QCryptographicHash::Algorithm) const
    {45, 666, 562, 1, Smoke::mf_const, 164, 13},	//1194 QSslCertificate::issuerInfo(QSslCertificate::SubjectInfo) const
    {45, 666, 330, 1, Smoke::mf_const, 164, 14},	//1195 QSslCertificate::issuerInfo(const QByteArray&) const
    {45, 1129, 562, 1, Smoke::mf_const, 164, 15},	//1196 QSslCertificate::subjectInfo(QSslCertificate::SubjectInfo) const
    {45, 1129, 330, 1, Smoke::mf_const, 164, 16},	//1197 QSslCertificate::subjectInfo(const QByteArray&) const
    {45, 443, 0, 0, Smoke::mf_const, 81, 17},	//1198 QSslCertificate::alternateSubjectNames() const
    {45, 562, 0, 0, Smoke::mf_const, 15, 18},	//1199 QSslCertificate::effectiveDate() const
    {45, 578, 0, 0, Smoke::mf_const, 15, 19},	//1200 QSslCertificate::expiryDate() const
    {45, 803, 0, 0, Smoke::mf_const, 158, 20},	//1201 QSslCertificate::publicKey() const
    {45, 1145, 0, 0, Smoke::mf_const, 11, 21},	//1202 QSslCertificate::toPem() const
    {45, 1141, 0, 0, Smoke::mf_const, 11, 22},	//1203 QSslCertificate::toDer() const
    {45, 593, 564, 3, Smoke::mf_static, 73, 23},	//1204 QSslCertificate::fromPath(const QString&, QSsl::EncodingFormat, QRegExp::PatternSyntax)
    {45, 588, 552, 2, Smoke::mf_static, 73, 24},	//1205 QSslCertificate::fromDevice(QIODevice*, QSsl::EncodingFormat)
    {45, 585, 555, 2, Smoke::mf_static, 73, 25},	//1206 QSslCertificate::fromData(const QByteArray&, QSsl::EncodingFormat)
    {45, 606, 0, 0, Smoke::mf_const, 309, 26},	//1207 QSslCertificate::handle() const
    {45, 281, 18, 1, Smoke::mf_ctor, 146, 27},	//1208 QSslCertificate::QSslCertificate(QIODevice*)
    {45, 281, 0, 0, Smoke::mf_ctor, 146, 28},	//1209 QSslCertificate::QSslCertificate()
    {45, 281, 330, 1, Smoke::mf_ctor, 146, 29},	//1210 QSslCertificate::QSslCertificate(const QByteArray&)
    {45, 549, 0, 0, Smoke::mf_const, 11, 30},	//1211 QSslCertificate::digest() const
    {45, 593, 69, 1, Smoke::mf_static, 73, 31},	//1212 QSslCertificate::fromPath(const QString&)
    {45, 593, 568, 2, Smoke::mf_static, 73, 32},	//1213 QSslCertificate::fromPath(const QString&, QSsl::EncodingFormat)
    {45, 588, 18, 1, Smoke::mf_static, 73, 33},	//1214 QSslCertificate::fromDevice(QIODevice*)
    {45, 585, 330, 1, Smoke::mf_static, 73, 34},	//1215 QSslCertificate::fromData(const QByteArray&)
    {45, 161, 0, 0, Smoke::mf_static|Smoke::mf_enum, 147, 35},	//1216 QSslCertificate::Organization (enum)
    {45, 48, 0, 0, Smoke::mf_static|Smoke::mf_enum, 147, 36},	//1217 QSslCertificate::CommonName (enum)
    {45, 133, 0, 0, Smoke::mf_static|Smoke::mf_enum, 147, 37},	//1218 QSslCertificate::LocalityName (enum)
    {45, 162, 0, 0, Smoke::mf_static|Smoke::mf_enum, 147, 38},	//1219 QSslCertificate::OrganizationalUnitName (enum)
    {45, 70, 0, 0, Smoke::mf_static|Smoke::mf_enum, 147, 39},	//1220 QSslCertificate::CountryName (enum)
    {45, 357, 0, 0, Smoke::mf_static|Smoke::mf_enum, 147, 40},	//1221 QSslCertificate::StateOrProvinceName (enum)
    {45, 1222, 0, 0, Smoke::mf_dtor, 0, 41 },	//1222 QSslCertificate::~QSslCertificate()
    {46, 284, 0, 0, Smoke::mf_ctor, 150, 1},	//1223 QSslCipher::QSslCipher()
    {46, 284, 571, 2, Smoke::mf_ctor, 150, 2},	//1224 QSslCipher::QSslCipher(const QString&, QSsl::SslProtocol)
    {46, 284, 574, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 150, 3},	//1225 QSslCipher::QSslCipher(const QSslCipher&)
    {46, 740, 574, 1, 0, 149, 4},	//1226 QSslCipher::operator=(const QSslCipher&)
    {46, 743, 574, 1, Smoke::mf_const, 252, 5},	//1227 QSslCipher::operator==(const QSslCipher&) const
    {46, 734, 574, 1, Smoke::mf_const, 252, 6},	//1228 QSslCipher::operator!=(const QSslCipher&) const
    {46, 653, 0, 0, Smoke::mf_const, 252, 7},	//1229 QSslCipher::isNull() const
    {46, 719, 0, 0, Smoke::mf_const, 164, 8},	//1230 QSslCipher::name() const
    {46, 1132, 0, 0, Smoke::mf_const, 300, 9},	//1231 QSslCipher::supportedBits() const
    {46, 1166, 0, 0, Smoke::mf_const, 300, 10},	//1232 QSslCipher::usedBits() const
    {46, 672, 0, 0, Smoke::mf_const, 164, 11},	//1233 QSslCipher::keyExchangeMethod() const
    {46, 452, 0, 0, Smoke::mf_const, 164, 12},	//1234 QSslCipher::authenticationMethod() const
    {46, 568, 0, 0, Smoke::mf_const, 164, 13},	//1235 QSslCipher::encryptionMethod() const
    {46, 795, 0, 0, Smoke::mf_const, 164, 14},	//1236 QSslCipher::protocolString() const
    {46, 794, 0, 0, Smoke::mf_const, 143, 15},	//1237 QSslCipher::protocol() const
    {46, 1223, 0, 0, Smoke::mf_dtor, 0, 16 },	//1238 QSslCipher::~QSslCipher()
    {47, 287, 0, 0, Smoke::mf_ctor, 153, 1},	//1239 QSslConfiguration::QSslConfiguration()
    {47, 287, 519, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 153, 2},	//1240 QSslConfiguration::QSslConfiguration(const QSslConfiguration&)
    {47, 740, 519, 1, 0, 152, 3},	//1241 QSslConfiguration::operator=(const QSslConfiguration&)
    {47, 743, 519, 1, Smoke::mf_const, 252, 4},	//1242 QSslConfiguration::operator==(const QSslConfiguration&) const
    {47, 734, 519, 1, Smoke::mf_const, 252, 5},	//1243 QSslConfiguration::operator!=(const QSslConfiguration&) const
    {47, 653, 0, 0, Smoke::mf_const, 252, 6},	//1244 QSslConfiguration::isNull() const
    {47, 794, 0, 0, Smoke::mf_const, 143, 7},	//1245 QSslConfiguration::protocol() const
    {47, 1030, 576, 1, 0, 0, 8},	//1246 QSslConfiguration::setProtocol(QSsl::SslProtocol)
    {47, 777, 0, 0, Smoke::mf_const, 162, 9},	//1247 QSslConfiguration::peerVerifyMode() const
    {47, 1012, 578, 1, 0, 0, 10},	//1248 QSslConfiguration::setPeerVerifyMode(QSslSocket::PeerVerifyMode)
    {47, 774, 0, 0, Smoke::mf_const, 300, 11},	//1249 QSslConfiguration::peerVerifyDepth() const
    {47, 1010, 44, 1, 0, 0, 12},	//1250 QSslConfiguration::setPeerVerifyDepth(int)
    {47, 692, 0, 0, Smoke::mf_const, 144, 13},	//1251 QSslConfiguration::localCertificate() const
    {47, 967, 558, 1, 0, 0, 14},	//1252 QSslConfiguration::setLocalCertificate(const QSslCertificate&)
    {47, 769, 0, 0, Smoke::mf_const, 144, 15},	//1253 QSslConfiguration::peerCertificate() const
    {47, 770, 0, 0, Smoke::mf_const, 73, 16},	//1254 QSslConfiguration::peerCertificateChain() const
    {47, 879, 0, 0, Smoke::mf_const, 148, 17},	//1255 QSslConfiguration::sessionCipher() const
    {47, 793, 0, 0, Smoke::mf_const, 158, 18},	//1256 QSslConfiguration::privateKey() const
    {47, 1024, 580, 1, 0, 0, 19},	//1257 QSslConfiguration::setPrivateKey(const QSslKey&)
    {47, 481, 0, 0, Smoke::mf_const, 74, 20},	//1258 QSslConfiguration::ciphers() const
    {47, 913, 582, 1, 0, 0, 21},	//1259 QSslConfiguration::setCiphers(const QList<QSslCipher>&)
    {47, 470, 0, 0, Smoke::mf_const, 73, 22},	//1260 QSslConfiguration::caCertificates() const
    {47, 905, 584, 1, 0, 0, 23},	//1261 QSslConfiguration::setCaCertificates(const QList<QSslCertificate>&)
    {47, 1083, 586, 2, 0, 0, 24},	//1262 QSslConfiguration::setSslOption(QSsl::SslOption, bool)
    {47, 1138, 589, 1, Smoke::mf_const, 252, 25},	//1263 QSslConfiguration::testSslOption(QSsl::SslOption) const
    {47, 545, 0, 0, Smoke::mf_static, 151, 26},	//1264 QSslConfiguration::defaultConfiguration()
    {47, 930, 519, 1, Smoke::mf_static, 0, 27},	//1265 QSslConfiguration::setDefaultConfiguration(const QSslConfiguration&)
    {47, 1224, 0, 0, Smoke::mf_dtor, 0, 28 },	//1266 QSslConfiguration::~QSslConfiguration()
    {48, 289, 0, 0, Smoke::mf_ctor, 156, 1},	//1267 QSslError::QSslError()
    {48, 289, 591, 1, Smoke::mf_ctor, 156, 2},	//1268 QSslError::QSslError(QSslError::SslError)
    {48, 289, 593, 2, Smoke::mf_ctor, 156, 3},	//1269 QSslError::QSslError(QSslError::SslError, const QSslCertificate&)
    {48, 289, 596, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 156, 4},	//1270 QSslError::QSslError(const QSslError&)
    {48, 740, 596, 1, 0, 155, 5},	//1271 QSslError::operator=(const QSslError&)
    {48, 743, 596, 1, Smoke::mf_const, 252, 6},	//1272 QSslError::operator==(const QSslError&) const
    {48, 734, 596, 1, Smoke::mf_const, 252, 7},	//1273 QSslError::operator!=(const QSslError&) const
    {48, 571, 0, 0, Smoke::mf_const, 157, 8},	//1274 QSslError::error() const
    {48, 573, 0, 0, Smoke::mf_const, 164, 9},	//1275 QSslError::errorString() const
    {48, 478, 0, 0, Smoke::mf_const, 144, 10},	//1276 QSslError::certificate() const
    {48, 148, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 11},	//1277 QSslError::NoError (enum)
    {48, 374, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 12},	//1278 QSslError::UnableToGetIssuerCertificate (enum)
    {48, 373, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 13},	//1279 QSslError::UnableToDecryptCertificateSignature (enum)
    {48, 372, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 14},	//1280 QSslError::UnableToDecodeIssuerPublicKey (enum)
    {48, 43, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 15},	//1281 QSslError::CertificateSignatureFailed (enum)
    {48, 40, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 16},	//1282 QSslError::CertificateNotYetValid (enum)
    {48, 39, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 17},	//1283 QSslError::CertificateExpired (enum)
    {48, 119, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 18},	//1284 QSslError::InvalidNotBeforeField (enum)
    {48, 118, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 19},	//1285 QSslError::InvalidNotAfterField (enum)
    {48, 330, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 20},	//1286 QSslError::SelfSignedCertificate (enum)
    {48, 331, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 21},	//1287 QSslError::SelfSignedCertificateInChain (enum)
    {48, 375, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 22},	//1288 QSslError::UnableToGetLocalIssuerCertificate (enum)
    {48, 376, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 23},	//1289 QSslError::UnableToVerifyFirstCertificate (enum)
    {48, 42, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 24},	//1290 QSslError::CertificateRevoked (enum)
    {48, 116, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 25},	//1291 QSslError::InvalidCaCertificate (enum)
    {48, 164, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 26},	//1292 QSslError::PathLengthExceeded (enum)
    {48, 120, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 27},	//1293 QSslError::InvalidPurpose (enum)
    {48, 44, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 28},	//1294 QSslError::CertificateUntrusted (enum)
    {48, 41, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 29},	//1295 QSslError::CertificateRejected (enum)
    {48, 358, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 30},	//1296 QSslError::SubjectIssuerMismatch (enum)
    {48, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 31},	//1297 QSslError::AuthorityIssuerSerialNumberMismatch (enum)
    {48, 149, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 32},	//1298 QSslError::NoPeerCertificate (enum)
    {48, 103, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 33},	//1299 QSslError::HostNameMismatch (enum)
    {48, 151, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 34},	//1300 QSslError::NoSslSupport (enum)
    {48, 38, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 35},	//1301 QSslError::CertificateBlacklisted (enum)
    {48, 396, 0, 0, Smoke::mf_static|Smoke::mf_enum, 157, 36},	//1302 QSslError::UnspecifiedError (enum)
    {48, 1225, 0, 0, Smoke::mf_dtor, 0, 37 },	//1303 QSslError::~QSslError()
    {49, 293, 0, 0, Smoke::mf_ctor, 160, 1},	//1304 QSslKey::QSslKey()
    {49, 293, 598, 5, Smoke::mf_ctor, 160, 2},	//1305 QSslKey::QSslKey(const QByteArray&, QSsl::KeyAlgorithm, QSsl::EncodingFormat, QSsl::KeyType, const QByteArray&)
    {49, 293, 604, 5, Smoke::mf_ctor, 160, 3},	//1306 QSslKey::QSslKey(QIODevice*, QSsl::KeyAlgorithm, QSsl::EncodingFormat, QSsl::KeyType, const QByteArray&)
    {49, 293, 580, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 160, 4},	//1307 QSslKey::QSslKey(const QSslKey&)
    {49, 740, 580, 1, 0, 159, 5},	//1308 QSslKey::operator=(const QSslKey&)
    {49, 653, 0, 0, Smoke::mf_const, 252, 6},	//1309 QSslKey::isNull() const
    {49, 482, 0, 0, 0, 0, 7},	//1310 QSslKey::clear()
    {49, 680, 0, 0, Smoke::mf_const, 300, 8},	//1311 QSslKey::length() const
    {49, 1158, 0, 0, Smoke::mf_const, 141, 9},	//1312 QSslKey::type() const
    {49, 435, 0, 0, Smoke::mf_const, 140, 10},	//1313 QSslKey::algorithm() const
    {49, 1145, 330, 1, Smoke::mf_const, 11, 11},	//1314 QSslKey::toPem(const QByteArray&) const
    {49, 1141, 330, 1, Smoke::mf_const, 11, 12},	//1315 QSslKey::toDer(const QByteArray&) const
    {49, 606, 0, 0, Smoke::mf_const, 309, 13},	//1316 QSslKey::handle() const
    {49, 743, 580, 1, Smoke::mf_const, 252, 14},	//1317 QSslKey::operator==(const QSslKey&) const
    {49, 734, 580, 1, Smoke::mf_const, 252, 15},	//1318 QSslKey::operator!=(const QSslKey&) const
    {49, 293, 610, 2, Smoke::mf_ctor, 160, 16},	//1319 QSslKey::QSslKey(const QByteArray&, QSsl::KeyAlgorithm)
    {49, 293, 613, 3, Smoke::mf_ctor, 160, 17},	//1320 QSslKey::QSslKey(const QByteArray&, QSsl::KeyAlgorithm, QSsl::EncodingFormat)
    {49, 293, 617, 4, Smoke::mf_ctor, 160, 18},	//1321 QSslKey::QSslKey(const QByteArray&, QSsl::KeyAlgorithm, QSsl::EncodingFormat, QSsl::KeyType)
    {49, 293, 622, 2, Smoke::mf_ctor, 160, 19},	//1322 QSslKey::QSslKey(QIODevice*, QSsl::KeyAlgorithm)
    {49, 293, 625, 3, Smoke::mf_ctor, 160, 20},	//1323 QSslKey::QSslKey(QIODevice*, QSsl::KeyAlgorithm, QSsl::EncodingFormat)
    {49, 293, 629, 4, Smoke::mf_ctor, 160, 21},	//1324 QSslKey::QSslKey(QIODevice*, QSsl::KeyAlgorithm, QSsl::EncodingFormat, QSsl::KeyType)
    {49, 1145, 0, 0, Smoke::mf_const, 11, 22},	//1325 QSslKey::toPem() const
    {49, 1141, 0, 0, Smoke::mf_const, 11, 23},	//1326 QSslKey::toDer() const
    {49, 1226, 0, 0, Smoke::mf_dtor, 0, 24 },	//1327 QSslKey::~QSslKey()
    {50, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//1328 QSslSocket::metaObject() const
    {50, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//1329 QSslSocket::qt_metacast(const char*)
    {50, 1150, 3, 2, Smoke::mf_static, 164, 3},	//1330 QSslSocket::tr(const char*, const char*)
    {50, 1154, 3, 2, Smoke::mf_static, 164, 4},	//1331 QSslSocket::trUtf8(const char*, const char*)
    {50, 1150, 6, 3, Smoke::mf_static, 164, 5},	//1332 QSslSocket::tr(const char*, const char*, int)
    {50, 1154, 6, 3, Smoke::mf_static, 164, 6},	//1333 QSslSocket::trUtf8(const char*, const char*, int)
    {50, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//1334 QSslSocket::qt_metacall(QMetaObject::Call, int, void**)
    {50, 299, 20, 1, Smoke::mf_ctor, 161, 8},	//1335 QSslSocket::QSslSocket(QObject*)
    {50, 509, 25, 3, 0, 0, 9},	//1336 QSslSocket::connectToHostEncrypted(const QString&, unsigned short, QFlags<QIODevice::OpenModeFlag>)
    {50, 509, 634, 4, 0, 0, 10},	//1337 QSslSocket::connectToHostEncrypted(const QString&, unsigned short, const QString&, QFlags<QIODevice::OpenModeFlag>)
    {50, 1068, 35, 3, 0, 252, 11},	//1338 QSslSocket::setSocketDescriptor(int, QAbstractSocket::SocketState, QFlags<QIODevice::OpenModeFlag>)
    {50, 1077, 39, 2, 0, 0, 12},	//1339 QSslSocket::setSocketOption(QAbstractSocket::SocketOption, const QVariant&)
    {50, 1114, 42, 1, 0, 177, 13},	//1340 QSslSocket::socketOption(QAbstractSocket::SocketOption)
    {50, 715, 0, 0, Smoke::mf_const, 163, 14},	//1341 QSslSocket::mode() const
    {50, 644, 0, 0, Smoke::mf_const, 252, 15},	//1342 QSslSocket::isEncrypted() const
    {50, 794, 0, 0, Smoke::mf_const, 143, 16},	//1343 QSslSocket::protocol() const
    {50, 1030, 576, 1, 0, 0, 17},	//1344 QSslSocket::setProtocol(QSsl::SslProtocol)
    {50, 777, 0, 0, Smoke::mf_const, 162, 18},	//1345 QSslSocket::peerVerifyMode() const
    {50, 1012, 578, 1, 0, 0, 19},	//1346 QSslSocket::setPeerVerifyMode(QSslSocket::PeerVerifyMode)
    {50, 774, 0, 0, Smoke::mf_const, 300, 20},	//1347 QSslSocket::peerVerifyDepth() const
    {50, 1010, 44, 1, 0, 0, 21},	//1348 QSslSocket::setPeerVerifyDepth(int)
    {50, 778, 0, 0, Smoke::mf_const, 164, 22},	//1349 QSslSocket::peerVerifyName() const
    {50, 1014, 69, 1, 0, 0, 23},	//1350 QSslSocket::setPeerVerifyName(const QString&)
    {50, 466, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 302, 24},	//1351 QSslSocket::bytesAvailable() const
    {50, 468, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 302, 25},	//1352 QSslSocket::bytesToWrite() const
    {50, 474, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 252, 26},	//1353 QSslSocket::canReadLine() const
    {50, 485, 0, 0, Smoke::mf_virtual, 0, 27},	//1354 QSslSocket::close()
    {50, 447, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 252, 28},	//1355 QSslSocket::atEnd() const
    {50, 584, 0, 0, 0, 252, 29},	//1356 QSslSocket::flush()
    {50, 409, 0, 0, 0, 0, 30},	//1357 QSslSocket::abort()
    {50, 1047, 33, 1, 0, 0, 31},	//1358 QSslSocket::setReadBufferSize(long long)
    {50, 564, 0, 0, Smoke::mf_const, 302, 32},	//1359 QSslSocket::encryptedBytesAvailable() const
    {50, 565, 0, 0, Smoke::mf_const, 302, 33},	//1360 QSslSocket::encryptedBytesToWrite() const
    {50, 1117, 0, 0, Smoke::mf_const, 151, 34},	//1361 QSslSocket::sslConfiguration() const
    {50, 1081, 519, 1, 0, 0, 35},	//1362 QSslSocket::setSslConfiguration(const QSslConfiguration&)
    {50, 967, 558, 1, 0, 0, 36},	//1363 QSslSocket::setLocalCertificate(const QSslCertificate&)
    {50, 967, 568, 2, 0, 0, 37},	//1364 QSslSocket::setLocalCertificate(const QString&, QSsl::EncodingFormat)
    {50, 692, 0, 0, Smoke::mf_const, 144, 38},	//1365 QSslSocket::localCertificate() const
    {50, 769, 0, 0, Smoke::mf_const, 144, 39},	//1366 QSslSocket::peerCertificate() const
    {50, 770, 0, 0, Smoke::mf_const, 73, 40},	//1367 QSslSocket::peerCertificateChain() const
    {50, 879, 0, 0, Smoke::mf_const, 148, 41},	//1368 QSslSocket::sessionCipher() const
    {50, 1024, 580, 1, 0, 0, 42},	//1369 QSslSocket::setPrivateKey(const QSslKey&)
    {50, 1024, 639, 4, 0, 0, 43},	//1370 QSslSocket::setPrivateKey(const QString&, QSsl::KeyAlgorithm, QSsl::EncodingFormat, const QByteArray&)
    {50, 793, 0, 0, Smoke::mf_const, 158, 44},	//1371 QSslSocket::privateKey() const
    {50, 481, 0, 0, Smoke::mf_const, 74, 45},	//1372 QSslSocket::ciphers() const
    {50, 913, 582, 1, 0, 0, 46},	//1373 QSslSocket::setCiphers(const QList<QSslCipher>&)
    {50, 913, 69, 1, 0, 0, 47},	//1374 QSslSocket::setCiphers(const QString&)
    {50, 928, 582, 1, Smoke::mf_static, 0, 48},	//1375 QSslSocket::setDefaultCiphers(const QList<QSslCipher>&)
    {50, 544, 0, 0, Smoke::mf_static, 74, 49},	//1376 QSslSocket::defaultCiphers()
    {50, 1133, 0, 0, Smoke::mf_static, 74, 50},	//1377 QSslSocket::supportedCiphers()
    {50, 417, 564, 3, 0, 252, 51},	//1378 QSslSocket::addCaCertificates(const QString&, QSsl::EncodingFormat, QRegExp::PatternSyntax)
    {50, 415, 558, 1, 0, 0, 52},	//1379 QSslSocket::addCaCertificate(const QSslCertificate&)
    {50, 417, 584, 1, 0, 0, 53},	//1380 QSslSocket::addCaCertificates(const QList<QSslCertificate>&)
    {50, 905, 584, 1, 0, 0, 54},	//1381 QSslSocket::setCaCertificates(const QList<QSslCertificate>&)
    {50, 470, 0, 0, Smoke::mf_const, 73, 55},	//1382 QSslSocket::caCertificates() const
    {50, 424, 564, 3, Smoke::mf_static, 252, 56},	//1383 QSslSocket::addDefaultCaCertificates(const QString&, QSsl::EncodingFormat, QRegExp::PatternSyntax)
    {50, 422, 558, 1, Smoke::mf_static, 0, 57},	//1384 QSslSocket::addDefaultCaCertificate(const QSslCertificate&)
    {50, 424, 584, 1, Smoke::mf_static, 0, 58},	//1385 QSslSocket::addDefaultCaCertificates(const QList<QSslCertificate>&)
    {50, 926, 584, 1, Smoke::mf_static, 0, 59},	//1386 QSslSocket::setDefaultCaCertificates(const QList<QSslCertificate>&)
    {50, 543, 0, 0, Smoke::mf_static, 73, 60},	//1387 QSslSocket::defaultCaCertificates()
    {50, 1135, 0, 0, Smoke::mf_static, 73, 61},	//1388 QSslSocket::systemCaCertificates()
    {50, 1174, 44, 1, 0, 252, 62},	//1389 QSslSocket::waitForConnected(int)
    {50, 1178, 44, 1, 0, 252, 63},	//1390 QSslSocket::waitForEncrypted(int)
    {50, 1185, 44, 1, Smoke::mf_virtual, 252, 64},	//1391 QSslSocket::waitForReadyRead(int)
    {50, 1172, 44, 1, Smoke::mf_virtual, 252, 65},	//1392 QSslSocket::waitForBytesWritten(int)
    {50, 1176, 44, 1, 0, 252, 66},	//1393 QSslSocket::waitForDisconnected(int)
    {50, 1118, 0, 0, Smoke::mf_const, 75, 67},	//1394 QSslSocket::sslErrors() const
    {50, 1134, 0, 0, Smoke::mf_static, 252, 68},	//1395 QSslSocket::supportsSsl()
    {50, 628, 296, 1, 0, 0, 69},	//1396 QSslSocket::ignoreSslErrors(const QList<QSslError>&)
    {50, 1121, 0, 0, Smoke::mf_slot, 0, 70},	//1397 QSslSocket::startClientEncryption()
    {50, 1122, 0, 0, Smoke::mf_slot, 0, 71},	//1398 QSslSocket::startServerEncryption()
    {50, 628, 0, 0, Smoke::mf_slot, 0, 72},	//1399 QSslSocket::ignoreSslErrors()
    {50, 563, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 73},	//1400 QSslSocket::encrypted()
    {50, 775, 596, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 74},	//1401 QSslSocket::peerVerifyError(const QSslError&)
    {50, 1118, 296, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 75},	//1402 QSslSocket::sslErrors(const QList<QSslError>&)
    {50, 716, 644, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 76},	//1403 QSslSocket::modeChanged(QSslSocket::SslMode)
    {50, 566, 646, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 77},	//1404 QSslSocket::encryptedBytesWritten(qint64)
    {50, 513, 55, 3, Smoke::mf_protected|Smoke::mf_slot, 0, 78},	//1405 QSslSocket::connectToHostImplementation(const QString&, quint16, QIODevice::OpenMode)
    {50, 552, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 79},	//1406 QSslSocket::disconnectFromHostImplementation()
    {50, 831, 59, 2, Smoke::mf_protected|Smoke::mf_virtual, 302, 80},	//1407 QSslSocket::readData(char*, long long)
    {50, 1187, 62, 2, Smoke::mf_protected|Smoke::mf_virtual, 302, 81},	//1408 QSslSocket::writeData(const char*, long long)
    {50, 1150, 1, 1, Smoke::mf_static, 164, 82},	//1409 QSslSocket::tr(const char*)
    {50, 1154, 1, 1, Smoke::mf_static, 164, 83},	//1410 QSslSocket::trUtf8(const char*)
    {50, 299, 0, 0, Smoke::mf_ctor, 161, 84},	//1411 QSslSocket::QSslSocket()
    {50, 509, 71, 2, 0, 0, 85},	//1412 QSslSocket::connectToHostEncrypted(const QString&, unsigned short)
    {50, 509, 648, 3, 0, 0, 86},	//1413 QSslSocket::connectToHostEncrypted(const QString&, unsigned short, const QString&)
    {50, 1068, 44, 1, 0, 252, 87},	//1414 QSslSocket::setSocketDescriptor(int)
    {50, 1068, 77, 2, 0, 252, 88},	//1415 QSslSocket::setSocketDescriptor(int, QAbstractSocket::SocketState)
    {50, 967, 69, 1, 0, 0, 89},	//1416 QSslSocket::setLocalCertificate(const QString&)
    {50, 1024, 69, 1, 0, 0, 90},	//1417 QSslSocket::setPrivateKey(const QString&)
    {50, 1024, 652, 2, 0, 0, 91},	//1418 QSslSocket::setPrivateKey(const QString&, QSsl::KeyAlgorithm)
    {50, 1024, 655, 3, 0, 0, 92},	//1419 QSslSocket::setPrivateKey(const QString&, QSsl::KeyAlgorithm, QSsl::EncodingFormat)
    {50, 417, 69, 1, 0, 252, 93},	//1420 QSslSocket::addCaCertificates(const QString&)
    {50, 417, 568, 2, 0, 252, 94},	//1421 QSslSocket::addCaCertificates(const QString&, QSsl::EncodingFormat)
    {50, 424, 69, 1, Smoke::mf_static, 252, 95},	//1422 QSslSocket::addDefaultCaCertificates(const QString&)
    {50, 424, 568, 2, Smoke::mf_static, 252, 96},	//1423 QSslSocket::addDefaultCaCertificates(const QString&, QSsl::EncodingFormat)
    {50, 1174, 0, 0, 0, 252, 97},	//1424 QSslSocket::waitForConnected()
    {50, 1178, 0, 0, 0, 252, 98},	//1425 QSslSocket::waitForEncrypted()
    {50, 1185, 0, 0, 0, 252, 99},	//1426 QSslSocket::waitForReadyRead()
    {50, 1172, 0, 0, 0, 252, 100},	//1427 QSslSocket::waitForBytesWritten()
    {50, 1176, 0, 0, 0, 252, 101},	//1428 QSslSocket::waitForDisconnected()
    {50, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 102},	//1429 QSslSocket::staticMetaObject() const
    {50, 381, 0, 0, Smoke::mf_static|Smoke::mf_enum, 163, 103},	//1430 QSslSocket::UnencryptedMode (enum)
    {50, 347, 0, 0, Smoke::mf_static|Smoke::mf_enum, 163, 104},	//1431 QSslSocket::SslClientMode (enum)
    {50, 354, 0, 0, Smoke::mf_static|Smoke::mf_enum, 163, 105},	//1432 QSslSocket::SslServerMode (enum)
    {50, 402, 0, 0, Smoke::mf_static|Smoke::mf_enum, 162, 106},	//1433 QSslSocket::VerifyNone (enum)
    {50, 311, 0, 0, Smoke::mf_static|Smoke::mf_enum, 162, 107},	//1434 QSslSocket::QueryPeer (enum)
    {50, 403, 0, 0, Smoke::mf_static|Smoke::mf_enum, 162, 108},	//1435 QSslSocket::VerifyPeer (enum)
    {50, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 162, 109},	//1436 QSslSocket::AutoVerifyPeer (enum)
    {50, 1227, 0, 0, Smoke::mf_dtor, 0, 110 },	//1437 QSslSocket::~QSslSocket()
    {51, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//1438 QTcpServer::metaObject() const
    {51, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//1439 QTcpServer::qt_metacast(const char*)
    {51, 1150, 3, 2, Smoke::mf_static, 164, 3},	//1440 QTcpServer::tr(const char*, const char*)
    {51, 1154, 3, 2, Smoke::mf_static, 164, 4},	//1441 QTcpServer::trUtf8(const char*, const char*)
    {51, 1150, 6, 3, Smoke::mf_static, 164, 5},	//1442 QTcpServer::tr(const char*, const char*, int)
    {51, 1154, 6, 3, Smoke::mf_static, 164, 6},	//1443 QTcpServer::trUtf8(const char*, const char*, int)
    {51, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//1444 QTcpServer::qt_metacall(QMetaObject::Call, int, void**)
    {51, 301, 20, 1, Smoke::mf_ctor, 167, 8},	//1445 QTcpServer::QTcpServer(QObject*)
    {51, 687, 74, 2, 0, 252, 9},	//1446 QTcpServer::listen(const QHostAddress&, unsigned short)
    {51, 485, 0, 0, 0, 0, 10},	//1447 QTcpServer::close()
    {51, 652, 0, 0, Smoke::mf_const, 252, 11},	//1448 QTcpServer::isListening() const
    {51, 975, 44, 1, 0, 0, 12},	//1449 QTcpServer::setMaxPendingConnections(int)
    {51, 704, 0, 0, Smoke::mf_const, 300, 13},	//1450 QTcpServer::maxPendingConnections() const
    {51, 878, 0, 0, Smoke::mf_const, 311, 14},	//1451 QTcpServer::serverPort() const
    {51, 875, 0, 0, Smoke::mf_const, 33, 15},	//1452 QTcpServer::serverAddress() const
    {51, 1113, 0, 0, Smoke::mf_const, 300, 16},	//1453 QTcpServer::socketDescriptor() const
    {51, 1068, 44, 1, 0, 252, 17},	//1454 QTcpServer::setSocketDescriptor(int)
    {51, 1180, 358, 2, 0, 252, 18},	//1455 QTcpServer::waitForNewConnection(int, bool*)
    {51, 613, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 252, 19},	//1456 QTcpServer::hasPendingConnections() const
    {51, 728, 0, 0, Smoke::mf_virtual, 168, 20},	//1457 QTcpServer::nextPendingConnection()
    {51, 876, 0, 0, Smoke::mf_const, 4, 21},	//1458 QTcpServer::serverError() const
    {51, 573, 0, 0, Smoke::mf_const, 164, 22},	//1459 QTcpServer::errorString() const
    {51, 1034, 46, 1, 0, 0, 23},	//1460 QTcpServer::setProxy(const QNetworkProxy&)
    {51, 797, 0, 0, Smoke::mf_const, 110, 24},	//1461 QTcpServer::proxy() const
    {51, 630, 44, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 25},	//1462 QTcpServer::incomingConnection(int)
    {51, 429, 264, 1, Smoke::mf_protected, 0, 26},	//1463 QTcpServer::addPendingConnection(QTcpSocket*)
    {51, 727, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//1464 QTcpServer::newConnection()
    {51, 1150, 1, 1, Smoke::mf_static, 164, 28},	//1465 QTcpServer::tr(const char*)
    {51, 1154, 1, 1, Smoke::mf_static, 164, 29},	//1466 QTcpServer::trUtf8(const char*)
    {51, 301, 0, 0, Smoke::mf_ctor, 167, 30},	//1467 QTcpServer::QTcpServer()
    {51, 687, 0, 0, 0, 252, 31},	//1468 QTcpServer::listen()
    {51, 687, 67, 1, 0, 252, 32},	//1469 QTcpServer::listen(const QHostAddress&)
    {51, 1180, 0, 0, 0, 252, 33},	//1470 QTcpServer::waitForNewConnection()
    {51, 1180, 44, 1, 0, 252, 34},	//1471 QTcpServer::waitForNewConnection(int)
    {51, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 35},	//1472 QTcpServer::staticMetaObject() const
    {51, 1228, 0, 0, Smoke::mf_dtor, 0, 36 },	//1473 QTcpServer::~QTcpServer()
    {52, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//1474 QTcpSocket::metaObject() const
    {52, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//1475 QTcpSocket::qt_metacast(const char*)
    {52, 1150, 3, 2, Smoke::mf_static, 164, 3},	//1476 QTcpSocket::tr(const char*, const char*)
    {52, 1154, 3, 2, Smoke::mf_static, 164, 4},	//1477 QTcpSocket::trUtf8(const char*, const char*)
    {52, 1150, 6, 3, Smoke::mf_static, 164, 5},	//1478 QTcpSocket::tr(const char*, const char*, int)
    {52, 1154, 6, 3, Smoke::mf_static, 164, 6},	//1479 QTcpSocket::trUtf8(const char*, const char*, int)
    {52, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//1480 QTcpSocket::qt_metacall(QMetaObject::Call, int, void**)
    {52, 303, 20, 1, Smoke::mf_ctor, 168, 8},	//1481 QTcpSocket::QTcpSocket(QObject*)
    {52, 1150, 1, 1, Smoke::mf_static, 164, 9},	//1482 QTcpSocket::tr(const char*)
    {52, 1154, 1, 1, Smoke::mf_static, 164, 10},	//1483 QTcpSocket::trUtf8(const char*)
    {52, 303, 0, 0, Smoke::mf_ctor, 168, 11},	//1484 QTcpSocket::QTcpSocket()
    {52, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 12},	//1485 QTcpSocket::staticMetaObject() const
    {52, 1229, 0, 0, Smoke::mf_dtor, 0, 13 },	//1486 QTcpSocket::~QTcpSocket()
    {54, 709, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 274, 1},	//1487 QUdpSocket::metaObject() const
    {54, 813, 1, 1, Smoke::mf_virtual, 313, 2},	//1488 QUdpSocket::qt_metacast(const char*)
    {54, 1150, 3, 2, Smoke::mf_static, 164, 3},	//1489 QUdpSocket::tr(const char*, const char*)
    {54, 1154, 3, 2, Smoke::mf_static, 164, 4},	//1490 QUdpSocket::trUtf8(const char*, const char*)
    {54, 1150, 6, 3, Smoke::mf_static, 164, 5},	//1491 QUdpSocket::tr(const char*, const char*, int)
    {54, 1154, 6, 3, Smoke::mf_static, 164, 6},	//1492 QUdpSocket::trUtf8(const char*, const char*, int)
    {54, 811, 10, 3, Smoke::mf_virtual, 300, 7},	//1493 QUdpSocket::qt_metacall(QMetaObject::Call, int, void**)
    {54, 305, 20, 1, Smoke::mf_ctor, 170, 8},	//1494 QUdpSocket::QUdpSocket(QObject*)
    {54, 459, 74, 2, 0, 252, 9},	//1495 QUdpSocket::bind(const QHostAddress&, unsigned short)
    {54, 459, 65, 1, 0, 252, 10},	//1496 QUdpSocket::bind(unsigned short)
    {54, 459, 659, 3, 0, 252, 11},	//1497 QUdpSocket::bind(const QHostAddress&, unsigned short, QFlags<QUdpSocket::BindFlag>)
    {54, 459, 663, 2, 0, 252, 12},	//1498 QUdpSocket::bind(unsigned short, QFlags<QUdpSocket::BindFlag>)
    {54, 669, 67, 1, 0, 252, 13},	//1499 QUdpSocket::joinMulticastGroup(const QHostAddress&)
    {54, 669, 666, 2, 0, 252, 14},	//1500 QUdpSocket::joinMulticastGroup(const QHostAddress&, const QNetworkInterface&)
    {54, 677, 67, 1, 0, 252, 15},	//1501 QUdpSocket::leaveMulticastGroup(const QHostAddress&)
    {54, 677, 666, 2, 0, 252, 16},	//1502 QUdpSocket::leaveMulticastGroup(const QHostAddress&, const QNetworkInterface&)
    {54, 718, 0, 0, Smoke::mf_const, 106, 17},	//1503 QUdpSocket::multicastInterface() const
    {54, 979, 436, 1, 0, 0, 18},	//1504 QUdpSocket::setMulticastInterface(const QNetworkInterface&)
    {54, 614, 0, 0, Smoke::mf_const, 252, 19},	//1505 QUdpSocket::hasPendingDatagrams() const
    {54, 779, 0, 0, Smoke::mf_const, 302, 20},	//1506 QUdpSocket::pendingDatagramSize() const
    {54, 833, 669, 4, 0, 302, 21},	//1507 QUdpSocket::readDatagram(char*, long long, QHostAddress*, unsigned short*)
    {54, 1189, 674, 4, 0, 302, 22},	//1508 QUdpSocket::writeDatagram(const char*, long long, const QHostAddress&, unsigned short)
    {54, 1189, 679, 3, 0, 302, 23},	//1509 QUdpSocket::writeDatagram(const QByteArray&, const QHostAddress&, unsigned short)
    {54, 1150, 1, 1, Smoke::mf_static, 164, 24},	//1510 QUdpSocket::tr(const char*)
    {54, 1154, 1, 1, Smoke::mf_static, 164, 25},	//1511 QUdpSocket::trUtf8(const char*)
    {54, 305, 0, 0, Smoke::mf_ctor, 170, 26},	//1512 QUdpSocket::QUdpSocket()
    {54, 459, 0, 0, 0, 252, 27},	//1513 QUdpSocket::bind()
    {54, 833, 59, 2, 0, 302, 28},	//1514 QUdpSocket::readDatagram(char*, long long)
    {54, 833, 683, 3, 0, 302, 29},	//1515 QUdpSocket::readDatagram(char*, long long, QHostAddress*)
    {54, 1126, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 273, 30},	//1516 QUdpSocket::staticMetaObject() const
    {54, 75, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 31},	//1517 QUdpSocket::DefaultForPlatform (enum)
    {54, 340, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 32},	//1518 QUdpSocket::ShareAddress (enum)
    {54, 85, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 33},	//1519 QUdpSocket::DontShareAddress (enum)
    {54, 324, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 34},	//1520 QUdpSocket::ReuseAddressHint (enum)
    {54, 1230, 0, 0, Smoke::mf_dtor, 0, 35 },	//1521 QUdpSocket::~QUdpSocket()
    {56, 307, 0, 0, Smoke::mf_ctor, 175, 1},	//1522 QUrlInfo::QUrlInfo()
    {56, 307, 105, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 175, 2},	//1523 QUrlInfo::QUrlInfo(const QUrlInfo&)
    {56, 307, 687, 13, Smoke::mf_ctor, 175, 3},	//1524 QUrlInfo::QUrlInfo(const QString&, int, const QString&, const QString&, long long, const QDateTime&, const QDateTime&, bool, bool, bool, bool, bool, bool)
    {56, 307, 701, 13, Smoke::mf_ctor, 175, 4},	//1525 QUrlInfo::QUrlInfo(const QUrl&, int, const QString&, const QString&, long long, const QDateTime&, const QDateTime&, bool, bool, bool, bool, bool, bool)
    {56, 740, 105, 1, 0, 174, 5},	//1526 QUrlInfo::operator=(const QUrlInfo&)
    {56, 981, 69, 1, Smoke::mf_virtual, 0, 6},	//1527 QUrlInfo::setName(const QString&)
    {56, 932, 116, 1, Smoke::mf_virtual, 0, 7},	//1528 QUrlInfo::setDir(bool)
    {56, 943, 116, 1, Smoke::mf_virtual, 0, 8},	//1529 QUrlInfo::setFile(bool)
    {56, 1090, 116, 1, Smoke::mf_virtual, 0, 9},	//1530 QUrlInfo::setSymLink(bool)
    {56, 996, 69, 1, Smoke::mf_virtual, 0, 10},	//1531 QUrlInfo::setOwner(const QString&)
    {56, 947, 69, 1, Smoke::mf_virtual, 0, 11},	//1532 QUrlInfo::setGroup(const QString&)
    {56, 1064, 33, 1, Smoke::mf_virtual, 0, 12},	//1533 QUrlInfo::setSize(long long)
    {56, 1110, 116, 1, Smoke::mf_virtual, 0, 13},	//1534 QUrlInfo::setWritable(bool)
    {56, 1049, 116, 1, Smoke::mf_virtual, 0, 14},	//1535 QUrlInfo::setReadable(bool)
    {56, 1016, 44, 1, Smoke::mf_virtual, 0, 15},	//1536 QUrlInfo::setPermissions(int)
    {56, 961, 421, 1, Smoke::mf_virtual, 0, 16},	//1537 QUrlInfo::setLastModified(const QDateTime&)
    {56, 963, 421, 1, 0, 0, 17},	//1538 QUrlInfo::setLastRead(const QDateTime&)
    {56, 664, 0, 0, Smoke::mf_const, 252, 18},	//1539 QUrlInfo::isValid() const
    {56, 719, 0, 0, Smoke::mf_const, 164, 19},	//1540 QUrlInfo::name() const
    {56, 780, 0, 0, Smoke::mf_const, 300, 20},	//1541 QUrlInfo::permissions() const
    {56, 757, 0, 0, Smoke::mf_const, 164, 21},	//1542 QUrlInfo::owner() const
    {56, 605, 0, 0, Smoke::mf_const, 164, 22},	//1543 QUrlInfo::group() const
    {56, 1112, 0, 0, Smoke::mf_const, 302, 23},	//1544 QUrlInfo::size() const
    {56, 674, 0, 0, Smoke::mf_const, 15, 24},	//1545 QUrlInfo::lastModified() const
    {56, 675, 0, 0, Smoke::mf_const, 15, 25},	//1546 QUrlInfo::lastRead() const
    {56, 643, 0, 0, Smoke::mf_const, 252, 26},	//1547 QUrlInfo::isDir() const
    {56, 646, 0, 0, Smoke::mf_const, 252, 27},	//1548 QUrlInfo::isFile() const
    {56, 662, 0, 0, Smoke::mf_const, 252, 28},	//1549 QUrlInfo::isSymLink() const
    {56, 665, 0, 0, Smoke::mf_const, 252, 29},	//1550 QUrlInfo::isWritable() const
    {56, 656, 0, 0, Smoke::mf_const, 252, 30},	//1551 QUrlInfo::isReadable() const
    {56, 645, 0, 0, Smoke::mf_const, 252, 31},	//1552 QUrlInfo::isExecutable() const
    {56, 603, 715, 3, Smoke::mf_static, 252, 32},	//1553 QUrlInfo::greaterThan(const QUrlInfo&, const QUrlInfo&, int)
    {56, 681, 715, 3, Smoke::mf_static, 252, 33},	//1554 QUrlInfo::lessThan(const QUrlInfo&, const QUrlInfo&, int)
    {56, 569, 715, 3, Smoke::mf_static, 252, 34},	//1555 QUrlInfo::equal(const QUrlInfo&, const QUrlInfo&, int)
    {56, 743, 105, 1, Smoke::mf_const, 252, 35},	//1556 QUrlInfo::operator==(const QUrlInfo&) const
    {56, 734, 105, 1, Smoke::mf_const, 252, 36},	//1557 QUrlInfo::operator!=(const QUrlInfo&) const
    {56, 316, 0, 0, Smoke::mf_static|Smoke::mf_enum, 176, 37},	//1558 QUrlInfo::ReadOwner (enum)
    {56, 407, 0, 0, Smoke::mf_static|Smoke::mf_enum, 176, 38},	//1559 QUrlInfo::WriteOwner (enum)
    {56, 91, 0, 0, Smoke::mf_static|Smoke::mf_enum, 176, 39},	//1560 QUrlInfo::ExeOwner (enum)
    {56, 313, 0, 0, Smoke::mf_static|Smoke::mf_enum, 176, 40},	//1561 QUrlInfo::ReadGroup (enum)
    {56, 404, 0, 0, Smoke::mf_static|Smoke::mf_enum, 176, 41},	//1562 QUrlInfo::WriteGroup (enum)
    {56, 89, 0, 0, Smoke::mf_static|Smoke::mf_enum, 176, 42},	//1563 QUrlInfo::ExeGroup (enum)
    {56, 315, 0, 0, Smoke::mf_static|Smoke::mf_enum, 176, 43},	//1564 QUrlInfo::ReadOther (enum)
    {56, 406, 0, 0, Smoke::mf_static|Smoke::mf_enum, 176, 44},	//1565 QUrlInfo::WriteOther (enum)
    {56, 90, 0, 0, Smoke::mf_static|Smoke::mf_enum, 176, 45},	//1566 QUrlInfo::ExeOther (enum)
    {56, 1231, 0, 0, Smoke::mf_dtor, 0, 46 },	//1567 QUrlInfo::~QUrlInfo()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    380,  // QHttp::QHttp(const QString&, unsigned short)
    381,  // QHttp::QHttp(const QString&, QHttp::ConnectionMode)
    0,
    389,  // QHttp::post(const QString&, QIODevice*)
    390,  // QHttp::post(const QString&, const QByteArray&)
    0,
    343,  // QHttp::post(const QString&, QIODevice*, QIODevice*)
    344,  // QHttp::post(const QString&, const QByteArray&, QIODevice*)
    0,
    392,  // QHttp::request(const QHttpRequestHeader&, QIODevice*)
    393,  // QHttp::request(const QHttpRequestHeader&, const QByteArray&)
    0,
    346,  // QHttp::request(const QHttpRequestHeader&, QIODevice*, QIODevice*)
    347,  // QHttp::request(const QHttpRequestHeader&, const QByteArray&, QIODevice*)
    0,
    336,  // QHttp::setHost(const QString&, unsigned short)
    384,  // QHttp::setHost(const QString&, QHttp::ConnectionMode)
    0,
    1319,  // QSslKey::QSslKey(const QByteArray&, QSsl::KeyAlgorithm)
    1322,  // QSslKey::QSslKey(QIODevice*, QSsl::KeyAlgorithm)
    0,
    1320,  // QSslKey::QSslKey(const QByteArray&, QSsl::KeyAlgorithm, QSsl::EncodingFormat)
    1323,  // QSslKey::QSslKey(QIODevice*, QSsl::KeyAlgorithm, QSsl::EncodingFormat)
    0,
    1321,  // QSslKey::QSslKey(const QByteArray&, QSsl::KeyAlgorithm, QSsl::EncodingFormat, QSsl::KeyType)
    1324,  // QSslKey::QSslKey(QIODevice*, QSsl::KeyAlgorithm, QSsl::EncodingFormat, QSsl::KeyType)
    0,
    1305,  // QSslKey::QSslKey(const QByteArray&, QSsl::KeyAlgorithm, QSsl::EncodingFormat, QSsl::KeyType, const QByteArray&)
    1306,  // QSslKey::QSslKey(QIODevice*, QSsl::KeyAlgorithm, QSsl::EncodingFormat, QSsl::KeyType, const QByteArray&)
    0,
    232,  // QGlobalSpace::operator<<(QDebug, const QHostAddress&)
    234,  // QGlobalSpace::operator<<(QDataStream&, const QHostAddress&)
    236,  // QGlobalSpace::operator<<(QDebug, const QSslCertificate&)
    242,  // QGlobalSpace::operator<<(QDebug, const QSslError&)
    247,  // QGlobalSpace::operator<<(QDebug, const QSslKey&)
    250,  // QGlobalSpace::operator<<(QDataStream&, const QNetworkCacheMetaData&)
    255,  // QGlobalSpace::operator<<(QDebug, const QNetworkCookie&)
    257,  // QGlobalSpace::operator<<(QDebug, const QNetworkInterface&)
    258,  // QGlobalSpace::operator<<(QDebug, const QSslCipher&)
    0,
    233,  // QGlobalSpace::operator<<(QDebug, QLocalSocket::LocalSocketError)
    235,  // QGlobalSpace::operator<<(QDebug, const QSslError::SslError&)
    243,  // QGlobalSpace::operator<<(QDebug, QAbstractSocket::SocketState)
    244,  // QGlobalSpace::operator<<(QDebug, QAbstractSocket::SocketError)
    246,  // QGlobalSpace::operator<<(QDebug, QSslCertificate::SubjectInfo)
    256,  // QGlobalSpace::operator<<(QDebug, QLocalSocket::LocalSocketState)
    0,
    249,  // QGlobalSpace::operator>>(QDataStream&, QHostAddress&)
    259,  // QGlobalSpace::operator>>(QDataStream&, QNetworkCacheMetaData&)
    0,
    237,  // QGlobalSpace::operator|(QNetworkInterface::InterfaceFlag, QNetworkInterface::InterfaceFlag)
    238,  // QGlobalSpace::operator|(QNetworkInterface::InterfaceFlag, QFlags<QNetworkInterface::InterfaceFlag>)
    240,  // QGlobalSpace::operator|(QUdpSocket::BindFlag, int)
    241,  // QGlobalSpace::operator|(QUdpSocket::BindFlag, QFlags<QUdpSocket::BindFlag>)
    245,  // QGlobalSpace::operator|(QSsl::SslOption, int)
    251,  // QGlobalSpace::operator|(QNetworkProxy::Capability, QNetworkProxy::Capability)
    252,  // QGlobalSpace::operator|(QNetworkConfigurationManager::Capability, QFlags<QNetworkConfigurationManager::Capability>)
    253,  // QGlobalSpace::operator|(QUdpSocket::BindFlag, QUdpSocket::BindFlag)
    254,  // QGlobalSpace::operator|(QNetworkProxy::Capability, int)
    260,  // QGlobalSpace::operator|(QSsl::SslOption, QSsl::SslOption)
    261,  // QGlobalSpace::operator|(QNetworkProxy::Capability, QFlags<QNetworkProxy::Capability>)
    262,  // QGlobalSpace::operator|(QNetworkInterface::InterfaceFlag, int)
    263,  // QGlobalSpace::operator|(QNetworkConfigurationManager::Capability, QNetworkConfigurationManager::Capability)
    264,  // QGlobalSpace::operator|(QSsl::SslOption, QFlags<QSsl::SslOption>)
    265,  // QGlobalSpace::operator|(QNetworkConfigurationManager::Capability, int)
    0,
    1043,  // QNetworkRequest::QNetworkRequest(const QUrl&)
    1044,  // QNetworkRequest::QNetworkRequest(const QNetworkRequest&)
    0,
    648,  // QNetworkAccessManager::post(const QNetworkRequest&, QIODevice*)
    649,  // QNetworkAccessManager::post(const QNetworkRequest&, const QByteArray&)
    650,  // QNetworkAccessManager::post(const QNetworkRequest&, QHttpMultiPart*)
    0,
    651,  // QNetworkAccessManager::put(const QNetworkRequest&, QIODevice*)
    652,  // QNetworkAccessManager::put(const QNetworkRequest&, const QByteArray&)
    653,  // QNetworkAccessManager::put(const QNetworkRequest&, QHttpMultiPart*)
    0,
    789,  // QNetworkCookie::QNetworkCookie(const QNetworkCookie&)
    811,  // QNetworkCookie::QNetworkCookie(const QByteArray&)
    0,
    1336,  // QSslSocket::connectToHostEncrypted(const QString&, unsigned short, QFlags<QIODevice::OpenModeFlag>)
    1413,  // QSslSocket::connectToHostEncrypted(const QString&, unsigned short, const QString&)
    0,
    198,  // QFtp::put(const QByteArray&, const QString&)
    199,  // QFtp::put(QIODevice*, const QString&)
    0,
    162,  // QFtp::put(const QByteArray&, const QString&, QFtp::TransferType)
    163,  // QFtp::put(QIODevice*, const QString&, QFtp::TransferType)
    0,
    269,  // QHostAddress::QHostAddress(const QIPv6Address&)
    270,  // QHostAddress::QHostAddress(const sockaddr*)
    272,  // QHostAddress::QHostAddress(const QHostAddress&)
    0,
    267,  // QHostAddress::QHostAddress(unsigned int)
    268,  // QHostAddress::QHostAddress(unsigned char*)
    271,  // QHostAddress::QHostAddress(const QString&)
    273,  // QHostAddress::QHostAddress(QHostAddress::SpecialAddress)
    0,
    278,  // QHostAddress::setAddress(const QIPv6Address&)
    279,  // QHostAddress::setAddress(const sockaddr*)
    0,
    276,  // QHostAddress::setAddress(unsigned int)
    277,  // QHostAddress::setAddress(unsigned char*)
    280,  // QHostAddress::setAddress(const QString&)
    0,
    533,  // QIPv6Address::operator[](int)
    534,  // QIPv6Address::operator[](int) const
    0,
    933,  // QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkProxyQuery&)
    954,  // QNetworkProxyQuery::QNetworkProxyQuery(const QUrl&)
    0,
    930,  // QNetworkProxyQuery::QNetworkProxyQuery(const QUrl&, QNetworkProxyQuery::QueryType)
    962,  // QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, unsigned short)
    0,
    960,  // QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, const QString&, int)
    963,  // QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, unsigned short, const QString&)
    0,
    936,  // QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, unsigned short, const QString&, QNetworkProxyQuery::QueryType)
    961,  // QNetworkProxyQuery::QNetworkProxyQuery(const QNetworkConfiguration&, const QString&, int, const QString&)
    0,
    955,  // QNetworkProxyQuery::QNetworkProxyQuery(const QString&, int)
    958,  // QNetworkProxyQuery::QNetworkProxyQuery(unsigned short, const QString&)
    0,
    932,  // QNetworkProxyQuery::QNetworkProxyQuery(unsigned short, const QString&, QNetworkProxyQuery::QueryType)
    956,  // QNetworkProxyQuery::QNetworkProxyQuery(const QString&, int, const QString&)
    0,
    1184,  // QSslCertificate::QSslCertificate(const QSslCertificate&)
    1208,  // QSslCertificate::QSslCertificate(QIODevice*)
    1210,  // QSslCertificate::QSslCertificate(const QByteArray&)
    0,
    1182,  // QSslCertificate::QSslCertificate(QIODevice*, QSsl::EncodingFormat)
    1183,  // QSslCertificate::QSslCertificate(const QByteArray&, QSsl::EncodingFormat)
    0,
    495,  // QHttpResponseHeader::QHttpResponseHeader(const QString&)
    505,  // QHttpResponseHeader::QHttpResponseHeader(int)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {1, 186, 19},	// QAbstractNetworkCache::QAbstractNetworkCache
    {1, 187, 16},	// QAbstractNetworkCache::QAbstractNetworkCache#
    {1, 473, 12},	// QAbstractNetworkCache::cacheSize
    {1, 482, 15},	// QAbstractNetworkCache::clear
    {1, 536, 10},	// QAbstractNetworkCache::data#
    {1, 635, 14},	// QAbstractNetworkCache::insert#
    {1, 707, 8},	// QAbstractNetworkCache::metaData#
    {1, 709, 1},	// QAbstractNetworkCache::metaObject
    {1, 791, 13},	// QAbstractNetworkCache::prepare#
    {1, 812, 7},	// QAbstractNetworkCache::qt_metacall$$?
    {1, 814, 2},	// QAbstractNetworkCache::qt_metacast$
    {1, 845, 11},	// QAbstractNetworkCache::remove#
    {1, 1126, 20},	// QAbstractNetworkCache::staticMetaObject
    {1, 1151, 17},	// QAbstractNetworkCache::tr$
    {1, 1152, 3},	// QAbstractNetworkCache::tr$$
    {1, 1153, 5},	// QAbstractNetworkCache::tr$$$
    {1, 1155, 18},	// QAbstractNetworkCache::trUtf8$
    {1, 1156, 4},	// QAbstractNetworkCache::trUtf8$$
    {1, 1157, 6},	// QAbstractNetworkCache::trUtf8$$$
    {1, 1162, 9},	// QAbstractNetworkCache::updateMetaData#
    {1, 1192, 21},	// QAbstractNetworkCache::~QAbstractNetworkCache
    {2, 4, 106},	// QAbstractSocket::AddressInUseError
    {2, 29, 122},	// QAbstractSocket::BoundState
    {2, 47, 124},	// QAbstractSocket::ClosingState
    {2, 51, 121},	// QAbstractSocket::ConnectedState
    {2, 53, 120},	// QAbstractSocket::ConnectingState
    {2, 59, 98},	// QAbstractSocket::ConnectionRefusedError
    {2, 74, 104},	// QAbstractSocket::DatagramTooLargeError
    {2, 101, 119},	// QAbstractSocket::HostLookupState
    {2, 105, 100},	// QAbstractSocket::HostNotFoundError
    {2, 112, 95},	// QAbstractSocket::IPv4Protocol
    {2, 113, 96},	// QAbstractSocket::IPv6Protocol
    {2, 126, 126},	// QAbstractSocket::KeepAliveOption
    {2, 130, 123},	// QAbstractSocket::ListeningState
    {2, 137, 125},	// QAbstractSocket::LowDelayOption
    {2, 143, 128},	// QAbstractSocket::MulticastLoopbackOption
    {2, 144, 127},	// QAbstractSocket::MulticastTtlOption
    {2, 146, 105},	// QAbstractSocket::NetworkError
    {2, 175, 110},	// QAbstractSocket::ProxyAuthenticationRequiredError
    {2, 176, 113},	// QAbstractSocket::ProxyConnectionClosedError
    {2, 177, 112},	// QAbstractSocket::ProxyConnectionRefusedError
    {2, 178, 114},	// QAbstractSocket::ProxyConnectionTimeoutError
    {2, 179, 115},	// QAbstractSocket::ProxyNotFoundError
    {2, 180, 116},	// QAbstractSocket::ProxyProtocolError
    {2, 189, 29},	// QAbstractSocket::QAbstractSocket$#
    {2, 321, 99},	// QAbstractSocket::RemoteHostClosedError
    {2, 341, 101},	// QAbstractSocket::SocketAccessError
    {2, 342, 107},	// QAbstractSocket::SocketAddressNotAvailableError
    {2, 343, 102},	// QAbstractSocket::SocketResourceError
    {2, 344, 103},	// QAbstractSocket::SocketTimeoutError
    {2, 348, 111},	// QAbstractSocket::SslHandshakeFailedError
    {2, 362, 92},	// QAbstractSocket::TcpSocket
    {2, 370, 93},	// QAbstractSocket::UdpSocket
    {2, 379, 118},	// QAbstractSocket::UnconnectedState
    {2, 383, 109},	// QAbstractSocket::UnfinishedSocketOperationError
    {2, 388, 97},	// QAbstractSocket::UnknownNetworkLayerProtocol
    {2, 394, 117},	// QAbstractSocket::UnknownSocketError
    {2, 395, 94},	// QAbstractSocket::UnknownSocketType
    {2, 397, 108},	// QAbstractSocket::UnsupportedSocketOperationError
    {2, 409, 44},	// QAbstractSocket::abort
    {2, 447, 54},	// QAbstractSocket::atEnd
    {2, 466, 34},	// QAbstractSocket::bytesAvailable
    {2, 468, 35},	// QAbstractSocket::bytesToWrite
    {2, 474, 36},	// QAbstractSocket::canReadLine
    {2, 485, 52},	// QAbstractSocket::close
    {2, 504, 83},	// QAbstractSocket::connectToHost#$
    {2, 505, 31},	// QAbstractSocket::connectToHost#$$
    {2, 507, 82},	// QAbstractSocket::connectToHost$$
    {2, 508, 30},	// QAbstractSocket::connectToHost$$$
    {2, 514, 90},	// QAbstractSocket::connectToHostImplementation$$
    {2, 515, 68},	// QAbstractSocket::connectToHostImplementation$$$
    {2, 519, 63},	// QAbstractSocket::connected
    {2, 551, 32},	// QAbstractSocket::disconnectFromHost
    {2, 552, 69},	// QAbstractSocket::disconnectFromHostImplementation
    {2, 556, 64},	// QAbstractSocket::disconnected
    {2, 571, 51},	// QAbstractSocket::error
    {2, 572, 66},	// QAbstractSocket::error$
    {2, 584, 55},	// QAbstractSocket::flush
    {2, 623, 62},	// QAbstractSocket::hostFound
    {2, 660, 53},	// QAbstractSocket::isSequential
    {2, 664, 33},	// QAbstractSocket::isValid
    {2, 691, 38},	// QAbstractSocket::localAddress
    {2, 695, 37},	// QAbstractSocket::localPort
    {2, 709, 22},	// QAbstractSocket::metaObject
    {2, 768, 40},	// QAbstractSocket::peerAddress
    {2, 772, 41},	// QAbstractSocket::peerName
    {2, 773, 39},	// QAbstractSocket::peerPort
    {2, 797, 61},	// QAbstractSocket::proxy
    {2, 799, 67},	// QAbstractSocket::proxyAuthenticationRequired##
    {2, 812, 28},	// QAbstractSocket::qt_metacall$$?
    {2, 814, 23},	// QAbstractSocket::qt_metacast$
    {2, 830, 42},	// QAbstractSocket::readBufferSize
    {2, 832, 70},	// QAbstractSocket::readData$$
    {2, 838, 71},	// QAbstractSocket::readLineData$$
    {2, 966, 76},	// QAbstractSocket::setLocalAddress#
    {2, 972, 75},	// QAbstractSocket::setLocalPort$
    {2, 1003, 78},	// QAbstractSocket::setPeerAddress#
    {2, 1007, 79},	// QAbstractSocket::setPeerName$
    {2, 1009, 77},	// QAbstractSocket::setPeerPort$
    {2, 1035, 60},	// QAbstractSocket::setProxy#
    {2, 1048, 43},	// QAbstractSocket::setReadBufferSize$
    {2, 1069, 84},	// QAbstractSocket::setSocketDescriptor$
    {2, 1070, 85},	// QAbstractSocket::setSocketDescriptor$$
    {2, 1071, 46},	// QAbstractSocket::setSocketDescriptor$$$
    {2, 1076, 74},	// QAbstractSocket::setSocketError$
    {2, 1078, 47},	// QAbstractSocket::setSocketOption$#
    {2, 1080, 73},	// QAbstractSocket::setSocketState$
    {2, 1113, 45},	// QAbstractSocket::socketDescriptor
    {2, 1115, 48},	// QAbstractSocket::socketOption$
    {2, 1116, 49},	// QAbstractSocket::socketType
    {2, 1123, 50},	// QAbstractSocket::state
    {2, 1125, 65},	// QAbstractSocket::stateChanged$
    {2, 1126, 91},	// QAbstractSocket::staticMetaObject
    {2, 1151, 80},	// QAbstractSocket::tr$
    {2, 1152, 24},	// QAbstractSocket::tr$$
    {2, 1153, 26},	// QAbstractSocket::tr$$$
    {2, 1155, 81},	// QAbstractSocket::trUtf8$
    {2, 1156, 25},	// QAbstractSocket::trUtf8$$
    {2, 1157, 27},	// QAbstractSocket::trUtf8$$$
    {2, 1172, 88},	// QAbstractSocket::waitForBytesWritten
    {2, 1173, 58},	// QAbstractSocket::waitForBytesWritten$
    {2, 1174, 86},	// QAbstractSocket::waitForConnected
    {2, 1175, 56},	// QAbstractSocket::waitForConnected$
    {2, 1176, 89},	// QAbstractSocket::waitForDisconnected
    {2, 1177, 59},	// QAbstractSocket::waitForDisconnected$
    {2, 1185, 87},	// QAbstractSocket::waitForReadyRead
    {2, 1186, 57},	// QAbstractSocket::waitForReadyRead$
    {2, 1188, 72},	// QAbstractSocket::writeData$$
    {2, 1193, 129},	// QAbstractSocket::~QAbstractSocket
    {3, 190, 130},	// QAuthenticator::QAuthenticator
    {3, 191, 131},	// QAuthenticator::QAuthenticator#
    {3, 548, 144},	// QAuthenticator::detach
    {3, 653, 143},	// QAuthenticator::isNull
    {3, 735, 134},	// QAuthenticator::operator!=#
    {3, 741, 132},	// QAuthenticator::operator=#
    {3, 744, 133},	// QAuthenticator::operator==#
    {3, 754, 140},	// QAuthenticator::option$
    {3, 755, 141},	// QAuthenticator::options
    {3, 766, 137},	// QAuthenticator::password
    {3, 841, 139},	// QAuthenticator::realm
    {3, 993, 142},	// QAuthenticator::setOption$#
    {3, 999, 138},	// QAuthenticator::setPassword$
    {3, 1101, 136},	// QAuthenticator::setUser$
    {3, 1167, 135},	// QAuthenticator::user
    {3, 1194, 145},	// QAuthenticator::~QAuthenticator
    {11, 3, 227},	// QFtp::Active
    {11, 13, 230},	// QFtp::Ascii
    {11, 28, 229},	// QFtp::Binary
    {11, 37, 219},	// QFtp::Cd
    {11, 45, 217},	// QFtp::Close
    {11, 46, 206},	// QFtp::Closing
    {11, 49, 215},	// QFtp::ConnectToHost
    {11, 50, 204},	// QFtp::Connected
    {11, 52, 203},	// QFtp::Connecting
    {11, 58, 210},	// QFtp::ConnectionRefused
    {11, 96, 220},	// QFtp::Get
    {11, 100, 202},	// QFtp::HostLookup
    {11, 104, 209},	// QFtp::HostNotFound
    {11, 128, 218},	// QFtp::List
    {11, 135, 205},	// QFtp::LoggedIn
    {11, 136, 216},	// QFtp::Login
    {11, 142, 223},	// QFtp::Mkdir
    {11, 148, 207},	// QFtp::NoError
    {11, 152, 212},	// QFtp::None
    {11, 156, 211},	// QFtp::NotConnected
    {11, 163, 228},	// QFtp::Passive
    {11, 184, 221},	// QFtp::Put
    {11, 192, 191},	// QFtp::QFtp
    {11, 193, 153},	// QFtp::QFtp#
    {11, 312, 226},	// QFtp::RawCommand
    {11, 322, 222},	// QFtp::Remove
    {11, 323, 225},	// QFtp::Rename
    {11, 325, 224},	// QFtp::Rmdir
    {11, 338, 214},	// QFtp::SetProxy
    {11, 339, 213},	// QFtp::SetTransferMode
    {11, 378, 201},	// QFtp::Unconnected
    {11, 386, 208},	// QFtp::UnknownError
    {11, 409, 180},	// QFtp::abort
    {11, 466, 169},	// QFtp::bytesAvailable
    {11, 477, 160},	// QFtp::cd$
    {11, 483, 176},	// QFtp::clearPendingCommands
    {11, 485, 157},	// QFtp::close
    {11, 489, 187},	// QFtp::commandFinished$$
    {11, 491, 186},	// QFtp::commandStarted$
    {11, 506, 192},	// QFtp::connectToHost$
    {11, 507, 155},	// QFtp::connectToHost$$
    {11, 528, 174},	// QFtp::currentCommand
    {11, 530, 173},	// QFtp::currentDevice
    {11, 531, 172},	// QFtp::currentId
    {11, 542, 184},	// QFtp::dataTransferProgress$$
    {11, 559, 188},	// QFtp::done$
    {11, 571, 178},	// QFtp::error
    {11, 573, 179},	// QFtp::errorString
    {11, 600, 196},	// QFtp::get$
    {11, 601, 197},	// QFtp::get$#
    {11, 602, 161},	// QFtp::get$#$
    {11, 612, 175},	// QFtp::hasPendingCommands
    {11, 683, 195},	// QFtp::list
    {11, 684, 159},	// QFtp::list$
    {11, 686, 182},	// QFtp::listInfo#
    {11, 696, 193},	// QFtp::login
    {11, 697, 194},	// QFtp::login$
    {11, 698, 156},	// QFtp::login$$
    {11, 709, 146},	// QFtp::metaObject
    {11, 714, 165},	// QFtp::mkdir$
    {11, 807, -84},	// QFtp::put#$
    {11, 808, -87},	// QFtp::put#$$
    {11, 812, 152},	// QFtp::qt_metacall$$?
    {11, 814, 147},	// QFtp::qt_metacast$
    {11, 819, 168},	// QFtp::rawCommand$
    {11, 821, 185},	// QFtp::rawCommandReply$$
    {11, 828, 170},	// QFtp::read$$
    {11, 829, 171},	// QFtp::readAll
    {11, 839, 183},	// QFtp::readyRead
    {11, 846, 164},	// QFtp::remove$
    {11, 854, 167},	// QFtp::rename$$
    {11, 867, 166},	// QFtp::rmdir$
    {11, 1036, 154},	// QFtp::setProxy$$
    {11, 1093, 158},	// QFtp::setTransferMode$
    {11, 1123, 177},	// QFtp::state
    {11, 1125, 181},	// QFtp::stateChanged$
    {11, 1126, 200},	// QFtp::staticMetaObject
    {11, 1151, 189},	// QFtp::tr$
    {11, 1152, 148},	// QFtp::tr$$
    {11, 1153, 150},	// QFtp::tr$$$
    {11, 1155, 190},	// QFtp::trUtf8$
    {11, 1156, 149},	// QFtp::trUtf8$$
    {11, 1157, 151},	// QFtp::trUtf8$$$
    {11, 1195, 231},	// QFtp::~QFtp
    {12, 738, -31},	// QGlobalSpace::operator<<##
    {12, 739, -41},	// QGlobalSpace::operator<<#$
    {12, 746, 239},	// QGlobalSpace::operator==$#
    {12, 748, -48},	// QGlobalSpace::operator>>##
    {12, 752, -51},	// QGlobalSpace::operator|$$
    {12, 810, 248},	// QGlobalSpace::qHash#
    {13, 8, 300},	// QHostAddress::Any
    {13, 9, 301},	// QHostAddress::AnyIPv6
    {13, 30, 297},	// QHostAddress::Broadcast
    {13, 131, 298},	// QHostAddress::LocalHost
    {13, 132, 299},	// QHostAddress::LocalHostIPv6
    {13, 158, 296},	// QHostAddress::Null
    {13, 194, 266},	// QHostAddress::QHostAddress
    {13, 195, -90},	// QHostAddress::QHostAddress#
    {13, 196, -94},	// QHostAddress::QHostAddress$
    {13, 482, 292},	// QHostAddress::clear
    {13, 650, 293},	// QHostAddress::isInSubnet#$
    {13, 651, 294},	// QHostAddress::isInSubnet?
    {13, 653, 291},	// QHostAddress::isNull
    {13, 735, 289},	// QHostAddress::operator!=#
    {13, 736, 290},	// QHostAddress::operator!=$
    {13, 741, 274},	// QHostAddress::operator=#
    {13, 742, 275},	// QHostAddress::operator=$
    {13, 744, 287},	// QHostAddress::operator==#
    {13, 745, 288},	// QHostAddress::operator==$
    {13, 765, 295},	// QHostAddress::parseSubnet$
    {13, 794, 281},	// QHostAddress::protocol
    {13, 869, 285},	// QHostAddress::scopeId
    {13, 883, -99},	// QHostAddress::setAddress#
    {13, 884, -102},	// QHostAddress::setAddress$
    {13, 1059, 286},	// QHostAddress::setScopeId$
    {13, 1143, 282},	// QHostAddress::toIPv4Address
    {13, 1144, 283},	// QHostAddress::toIPv6Address
    {13, 1149, 284},	// QHostAddress::toString
    {13, 1196, 302},	// QHostAddress::~QHostAddress
    {14, 104, 323},	// QHostInfo::HostNotFound
    {14, 148, 322},	// QHostInfo::NoError
    {14, 197, 321},	// QHostInfo::QHostInfo
    {14, 198, 304},	// QHostInfo::QHostInfo#
    {14, 199, 303},	// QHostInfo::QHostInfo$
    {14, 386, 324},	// QHostInfo::UnknownError
    {14, 411, 317},	// QHostInfo::abortHostLookup$
    {14, 434, 308},	// QHostInfo::addresses
    {14, 571, 310},	// QHostInfo::error
    {14, 573, 312},	// QHostInfo::errorString
    {14, 592, 318},	// QHostInfo::fromName$
    {14, 624, 306},	// QHostInfo::hostName
    {14, 693, 320},	// QHostInfo::localDomainName
    {14, 694, 319},	// QHostInfo::localHostName
    {14, 700, 316},	// QHostInfo::lookupHost$#$
    {14, 701, 315},	// QHostInfo::lookupId
    {14, 741, 305},	// QHostInfo::operator=#
    {14, 886, 309},	// QHostInfo::setAddresses?
    {14, 937, 311},	// QHostInfo::setError$
    {14, 940, 313},	// QHostInfo::setErrorString$
    {14, 956, 307},	// QHostInfo::setHostName$
    {14, 974, 314},	// QHostInfo::setLookupId$
    {14, 1197, 325},	// QHostInfo::~QHostInfo
    {15, 1, 411},	// QHttp::Aborted
    {15, 14, 412},	// QHttp::AuthenticationRequiredError
    {15, 46, 403},	// QHttp::Closing
    {15, 50, 402},	// QHttp::Connected
    {15, 52, 399},	// QHttp::Connecting
    {15, 56, 395},	// QHttp::ConnectionModeHttp
    {15, 57, 396},	// QHttp::ConnectionModeHttps
    {15, 58, 407},	// QHttp::ConnectionRefused
    {15, 100, 398},	// QHttp::HostLookup
    {15, 104, 406},	// QHttp::HostNotFound
    {15, 121, 409},	// QHttp::InvalidResponseHeader
    {15, 148, 404},	// QHttp::NoError
    {15, 175, 413},	// QHttp::ProxyAuthenticationRequiredError
    {15, 200, 378},	// QHttp::QHttp
    {15, 201, 333},	// QHttp::QHttp#
    {15, 202, 379},	// QHttp::QHttp$
    {15, 203, -1},	// QHttp::QHttp$$
    {15, 204, 334},	// QHttp::QHttp$$#
    {15, 205, 382},	// QHttp::QHttp$$$
    {15, 206, 335},	// QHttp::QHttp$$$#
    {15, 318, 401},	// QHttp::Reading
    {15, 332, 400},	// QHttp::Sending
    {15, 378, 397},	// QHttp::Unconnected
    {15, 382, 408},	// QHttp::UnexpectedClose
    {15, 386, 405},	// QHttp::UnknownError
    {15, 408, 410},	// QHttp::WrongContentLength
    {15, 409, 363},	// QHttp::abort
    {15, 455, 374},	// QHttp::authenticationRequired$$#
    {15, 466, 350},	// QHttp::bytesAvailable
    {15, 484, 359},	// QHttp::clearPendingRequests
    {15, 485, 349},	// QHttp::close
    {15, 486, 348},	// QHttp::closeConnection
    {15, 529, 355},	// QHttp::currentDestinationDevice
    {15, 531, 353},	// QHttp::currentId
    {15, 532, 356},	// QHttp::currentRequest
    {15, 533, 354},	// QHttp::currentSourceDevice
    {15, 538, 369},	// QHttp::dataReadProgress$$
    {15, 540, 368},	// QHttp::dataSendProgress$$
    {15, 559, 372},	// QHttp::done$
    {15, 571, 361},	// QHttp::error
    {15, 573, 362},	// QHttp::errorString
    {15, 600, 388},	// QHttp::get$
    {15, 601, 342},	// QHttp::get$#
    {15, 615, 358},	// QHttp::hasPendingRequests
    {15, 620, 345},	// QHttp::head$
    {15, 628, 364},	// QHttp::ignoreSslErrors
    {15, 676, 357},	// QHttp::lastResponse
    {15, 709, 326},	// QHttp::metaObject
    {15, 785, -4},	// QHttp::post$#
    {15, 786, -7},	// QHttp::post$##
    {15, 799, 373},	// QHttp::proxyAuthenticationRequired##
    {15, 812, 332},	// QHttp::qt_metacall$$?
    {15, 814, 327},	// QHttp::qt_metacast$
    {15, 828, 351},	// QHttp::read$$
    {15, 829, 352},	// QHttp::readAll
    {15, 840, 367},	// QHttp::readyRead#
    {15, 856, 391},	// QHttp::request#
    {15, 857, -10},	// QHttp::request##
    {15, 858, -13},	// QHttp::request###
    {15, 860, 371},	// QHttp::requestFinished$$
    {15, 862, 370},	// QHttp::requestStarted$
    {15, 865, 366},	// QHttp::responseHeaderReceived#
    {15, 952, 383},	// QHttp::setHost$
    {15, 953, -16},	// QHttp::setHost$$
    {15, 954, 337},	// QHttp::setHost$$$
    {15, 1035, 341},	// QHttp::setProxy#
    {15, 1036, 386},	// QHttp::setProxy$$
    {15, 1037, 387},	// QHttp::setProxy$$$
    {15, 1038, 340},	// QHttp::setProxy$$$$
    {15, 1067, 338},	// QHttp::setSocket#
    {15, 1101, 385},	// QHttp::setUser$
    {15, 1102, 339},	// QHttp::setUser$$
    {15, 1120, 375},	// QHttp::sslErrors?
    {15, 1123, 360},	// QHttp::state
    {15, 1125, 365},	// QHttp::stateChanged$
    {15, 1126, 394},	// QHttp::staticMetaObject
    {15, 1151, 376},	// QHttp::tr$
    {15, 1152, 328},	// QHttp::tr$$
    {15, 1153, 330},	// QHttp::tr$$$
    {15, 1155, 377},	// QHttp::trUtf8$
    {15, 1156, 329},	// QHttp::trUtf8$$
    {15, 1157, 331},	// QHttp::trUtf8$$$
    {15, 1198, 414},	// QHttp::~QHttp
    {16, 207, 415},	// QHttpHeader::QHttpHeader
    {16, 208, 416},	// QHttpHeader::QHttpHeader#
    {16, 209, 417},	// QHttpHeader::QHttpHeader$
    {16, 432, 421},	// QHttpHeader::addValue$$
    {16, 442, 426},	// QHttpHeader::allValues$
    {16, 520, 430},	// QHttpHeader::contentLength
    {16, 521, 433},	// QHttpHeader::contentType
    {16, 608, 429},	// QHttpHeader::hasContentLength
    {16, 609, 432},	// QHttpHeader::hasContentType
    {16, 611, 423},	// QHttpHeader::hasKey$
    {16, 664, 436},	// QHttpHeader::isValid
    {16, 673, 424},	// QHttpHeader::keys
    {16, 702, 437},	// QHttpHeader::majorVersion
    {16, 712, 438},	// QHttpHeader::minorVersion
    {16, 741, 418},	// QHttpHeader::operator=#
    {16, 759, 440},	// QHttpHeader::parse$
    {16, 763, 439},	// QHttpHeader::parseLine$$
    {16, 848, 428},	// QHttpHeader::removeAllValues$
    {16, 852, 427},	// QHttpHeader::removeValue$
    {16, 919, 431},	// QHttpHeader::setContentLength$
    {16, 921, 434},	// QHttpHeader::setContentType$
    {16, 1104, 441},	// QHttpHeader::setValid$
    {16, 1107, 419},	// QHttpHeader::setValue$$
    {16, 1109, 420},	// QHttpHeader::setValues?
    {16, 1149, 435},	// QHttpHeader::toString
    {16, 1169, 425},	// QHttpHeader::value$
    {16, 1170, 422},	// QHttpHeader::values
    {16, 1199, 442},	// QHttpHeader::~QHttpHeader
    {17, 5, 464},	// QHttpMultiPart::AlternativeType
    {17, 93, 463},	// QHttpMultiPart::FormDataType
    {17, 141, 461},	// QHttpMultiPart::MixedType
    {17, 210, 458},	// QHttpMultiPart::QHttpMultiPart
    {17, 211, 450},	// QHttpMultiPart::QHttpMultiPart#
    {17, 212, 459},	// QHttpMultiPart::QHttpMultiPart$
    {17, 213, 451},	// QHttpMultiPart::QHttpMultiPart$#
    {17, 320, 462},	// QHttpMultiPart::RelatedType
    {17, 445, 452},	// QHttpMultiPart::append#
    {17, 464, 454},	// QHttpMultiPart::boundary
    {17, 709, 443},	// QHttpMultiPart::metaObject
    {17, 812, 449},	// QHttpMultiPart::qt_metacall$$?
    {17, 814, 444},	// QHttpMultiPart::qt_metacast$
    {17, 902, 455},	// QHttpMultiPart::setBoundary#
    {17, 921, 453},	// QHttpMultiPart::setContentType$
    {17, 1126, 460},	// QHttpMultiPart::staticMetaObject
    {17, 1151, 456},	// QHttpMultiPart::tr$
    {17, 1152, 445},	// QHttpMultiPart::tr$$
    {17, 1153, 447},	// QHttpMultiPart::tr$$$
    {17, 1155, 457},	// QHttpMultiPart::trUtf8$
    {17, 1156, 446},	// QHttpMultiPart::trUtf8$$
    {17, 1157, 448},	// QHttpMultiPart::trUtf8$$$
    {17, 1200, 465},	// QHttpMultiPart::~QHttpMultiPart
    {18, 214, 466},	// QHttpPart::QHttpPart
    {18, 215, 467},	// QHttpPart::QHttpPart#
    {18, 735, 470},	// QHttpPart::operator!=#
    {18, 741, 468},	// QHttpPart::operator=#
    {18, 744, 469},	// QHttpPart::operator==#
    {18, 898, 473},	// QHttpPart::setBody#
    {18, 900, 474},	// QHttpPart::setBodyDevice#
    {18, 950, 471},	// QHttpPart::setHeader$#
    {18, 1044, 472},	// QHttpPart::setRawHeader##
    {18, 1201, 475},	// QHttpPart::~QHttpPart
    {19, 216, 476},	// QHttpRequestHeader::QHttpRequestHeader
    {19, 217, 478},	// QHttpRequestHeader::QHttpRequestHeader#
    {19, 218, 479},	// QHttpRequestHeader::QHttpRequestHeader$
    {19, 219, 488},	// QHttpRequestHeader::QHttpRequestHeader$$
    {19, 220, 489},	// QHttpRequestHeader::QHttpRequestHeader$$$
    {19, 221, 477},	// QHttpRequestHeader::QHttpRequestHeader$$$$
    {19, 702, 484},	// QHttpRequestHeader::majorVersion
    {19, 710, 482},	// QHttpRequestHeader::method
    {19, 712, 485},	// QHttpRequestHeader::minorVersion
    {19, 741, 480},	// QHttpRequestHeader::operator=#
    {19, 763, 487},	// QHttpRequestHeader::parseLine$$
    {19, 767, 483},	// QHttpRequestHeader::path
    {19, 1053, 490},	// QHttpRequestHeader::setRequest$$
    {19, 1054, 491},	// QHttpRequestHeader::setRequest$$$
    {19, 1055, 481},	// QHttpRequestHeader::setRequest$$$$
    {19, 1149, 486},	// QHttpRequestHeader::toString
    {19, 1202, 492},	// QHttpRequestHeader::~QHttpRequestHeader
    {20, 222, 493},	// QHttpResponseHeader::QHttpResponseHeader
    {20, 223, 494},	// QHttpResponseHeader::QHttpResponseHeader#
    {20, 224, -134},	// QHttpResponseHeader::QHttpResponseHeader$
    {20, 225, 506},	// QHttpResponseHeader::QHttpResponseHeader$$
    {20, 226, 507},	// QHttpResponseHeader::QHttpResponseHeader$$$
    {20, 227, 496},	// QHttpResponseHeader::QHttpResponseHeader$$$$
    {20, 702, 501},	// QHttpResponseHeader::majorVersion
    {20, 712, 502},	// QHttpResponseHeader::minorVersion
    {20, 741, 497},	// QHttpResponseHeader::operator=#
    {20, 763, 504},	// QHttpResponseHeader::parseLine$$
    {20, 842, 500},	// QHttpResponseHeader::reasonPhrase
    {20, 1086, 508},	// QHttpResponseHeader::setStatusLine$
    {20, 1087, 509},	// QHttpResponseHeader::setStatusLine$$
    {20, 1088, 510},	// QHttpResponseHeader::setStatusLine$$$
    {20, 1089, 498},	// QHttpResponseHeader::setStatusLine$$$$
    {20, 1127, 499},	// QHttpResponseHeader::statusCode
    {20, 1149, 503},	// QHttpResponseHeader::toString
    {20, 1203, 511},	// QHttpResponseHeader::~QHttpResponseHeader
    {22, 228, 535},	// QIPv6Address::QIPv6Address
    {22, 229, 536},	// QIPv6Address::QIPv6Address#
    {22, 750, -106},	// QIPv6Address::operator[]$
    {22, 1204, 537},	// QIPv6Address::~QIPv6Address
    {24, 230, 563},	// QLocalServer::QLocalServer
    {24, 231, 546},	// QLocalServer::QLocalServer#
    {24, 485, 547},	// QLocalServer::close
    {24, 573, 548},	// QLocalServer::errorString
    {24, 597, 555},	// QLocalServer::fullServerName
    {24, 613, 549},	// QLocalServer::hasPendingConnections
    {24, 632, 560},	// QLocalServer::incomingConnection?
    {24, 652, 550},	// QLocalServer::isListening
    {24, 690, 551},	// QLocalServer::listen$
    {24, 704, 552},	// QLocalServer::maxPendingConnections
    {24, 709, 538},	// QLocalServer::metaObject
    {24, 727, 545},	// QLocalServer::newConnection
    {24, 728, 553},	// QLocalServer::nextPendingConnection
    {24, 812, 544},	// QLocalServer::qt_metacall$$?
    {24, 814, 539},	// QLocalServer::qt_metacast$
    {24, 850, 556},	// QLocalServer::removeServer$
    {24, 876, 557},	// QLocalServer::serverError
    {24, 877, 554},	// QLocalServer::serverName
    {24, 976, 558},	// QLocalServer::setMaxPendingConnections$
    {24, 1126, 566},	// QLocalServer::staticMetaObject
    {24, 1151, 561},	// QLocalServer::tr$
    {24, 1152, 540},	// QLocalServer::tr$$
    {24, 1153, 542},	// QLocalServer::tr$$$
    {24, 1155, 562},	// QLocalServer::trUtf8$
    {24, 1156, 541},	// QLocalServer::trUtf8$$
    {24, 1157, 543},	// QLocalServer::trUtf8$$$
    {24, 1180, 564},	// QLocalServer::waitForNewConnection
    {24, 1181, 565},	// QLocalServer::waitForNewConnection$
    {24, 1182, 559},	// QLocalServer::waitForNewConnection$$
    {24, 1205, 567},	// QLocalServer::~QLocalServer
    {25, 47, 628},	// QLocalSocket::ClosingState
    {25, 51, 627},	// QLocalSocket::ConnectedState
    {25, 53, 626},	// QLocalSocket::ConnectingState
    {25, 55, 622},	// QLocalSocket::ConnectionError
    {25, 59, 615},	// QLocalSocket::ConnectionRefusedError
    {25, 74, 621},	// QLocalSocket::DatagramTooLargeError
    {25, 165, 616},	// QLocalSocket::PeerClosedError
    {25, 232, 606},	// QLocalSocket::QLocalSocket
    {25, 233, 575},	// QLocalSocket::QLocalSocket#
    {25, 333, 617},	// QLocalSocket::ServerNotFoundError
    {25, 341, 618},	// QLocalSocket::SocketAccessError
    {25, 343, 619},	// QLocalSocket::SocketResourceError
    {25, 344, 620},	// QLocalSocket::SocketTimeoutError
    {25, 379, 625},	// QLocalSocket::UnconnectedState
    {25, 394, 624},	// QLocalSocket::UnknownSocketError
    {25, 397, 623},	// QLocalSocket::UnsupportedSocketOperationError
    {25, 409, 580},	// QLocalSocket::abort
    {25, 466, 582},	// QLocalSocket::bytesAvailable
    {25, 468, 583},	// QLocalSocket::bytesToWrite
    {25, 474, 584},	// QLocalSocket::canReadLine
    {25, 485, 585},	// QLocalSocket::close
    {25, 517, 607},	// QLocalSocket::connectToServer$
    {25, 518, 576},	// QLocalSocket::connectToServer$$
    {25, 519, 598},	// QLocalSocket::connected
    {25, 553, 577},	// QLocalSocket::disconnectFromServer
    {25, 556, 599},	// QLocalSocket::disconnected
    {25, 571, 586},	// QLocalSocket::error
    {25, 572, 600},	// QLocalSocket::error$
    {25, 584, 587},	// QLocalSocket::flush
    {25, 597, 579},	// QLocalSocket::fullServerName
    {25, 660, 581},	// QLocalSocket::isSequential
    {25, 664, 588},	// QLocalSocket::isValid
    {25, 709, 568},	// QLocalSocket::metaObject
    {25, 812, 574},	// QLocalSocket::qt_metacall$$?
    {25, 814, 569},	// QLocalSocket::qt_metacast$
    {25, 830, 589},	// QLocalSocket::readBufferSize
    {25, 832, 602},	// QLocalSocket::readData$$
    {25, 877, 578},	// QLocalSocket::serverName
    {25, 1048, 590},	// QLocalSocket::setReadBufferSize$
    {25, 1072, 608},	// QLocalSocket::setSocketDescriptor?
    {25, 1073, 609},	// QLocalSocket::setSocketDescriptor?$
    {25, 1074, 591},	// QLocalSocket::setSocketDescriptor?$$
    {25, 1113, 592},	// QLocalSocket::socketDescriptor
    {25, 1123, 593},	// QLocalSocket::state
    {25, 1125, 601},	// QLocalSocket::stateChanged$
    {25, 1126, 614},	// QLocalSocket::staticMetaObject
    {25, 1151, 604},	// QLocalSocket::tr$
    {25, 1152, 570},	// QLocalSocket::tr$$
    {25, 1153, 572},	// QLocalSocket::tr$$$
    {25, 1155, 605},	// QLocalSocket::trUtf8$
    {25, 1156, 571},	// QLocalSocket::trUtf8$$
    {25, 1157, 573},	// QLocalSocket::trUtf8$$$
    {25, 1172, 610},	// QLocalSocket::waitForBytesWritten
    {25, 1173, 594},	// QLocalSocket::waitForBytesWritten$
    {25, 1174, 611},	// QLocalSocket::waitForConnected
    {25, 1175, 595},	// QLocalSocket::waitForConnected$
    {25, 1176, 612},	// QLocalSocket::waitForDisconnected
    {25, 1177, 596},	// QLocalSocket::waitForDisconnected$
    {25, 1185, 613},	// QLocalSocket::waitForReadyRead
    {25, 1186, 597},	// QLocalSocket::waitForReadyRead$
    {25, 1188, 603},	// QLocalSocket::writeData$$
    {25, 1206, 629},	// QLocalSocket::~QLocalSocket
    {27, 2, 683},	// QNetworkAccessManager::Accessible
    {27, 71, 679},	// QNetworkAccessManager::CustomOperation
    {27, 78, 678},	// QNetworkAccessManager::DeleteOperation
    {27, 97, 675},	// QNetworkAccessManager::GetOperation
    {27, 98, 674},	// QNetworkAccessManager::HeadOperation
    {27, 154, 682},	// QNetworkAccessManager::NotAccessible
    {27, 167, 677},	// QNetworkAccessManager::PostOperation
    {27, 185, 676},	// QNetworkAccessManager::PutOperation
    {27, 234, 670},	// QNetworkAccessManager::QNetworkAccessManager
    {27, 235, 637},	// QNetworkAccessManager::QNetworkAccessManager#
    {27, 384, 681},	// QNetworkAccessManager::UnknownAccessibility
    {27, 389, 680},	// QNetworkAccessManager::UnknownOperation
    {27, 413, 658},	// QNetworkAccessManager::activeConfiguration
    {27, 454, 662},	// QNetworkAccessManager::authenticationRequired##
    {27, 471, 642},	// QNetworkAccessManager::cache
    {27, 492, 657},	// QNetworkAccessManager::configuration
    {27, 522, 644},	// QNetworkAccessManager::cookieJar
    {27, 526, 672},	// QNetworkAccessManager::createRequest$#
    {27, 527, 667},	// QNetworkAccessManager::createRequest$##
    {27, 547, 654},	// QNetworkAccessManager::deleteResource#
    {27, 582, 663},	// QNetworkAccessManager::finished#
    {27, 599, 647},	// QNetworkAccessManager::get#
    {27, 619, 646},	// QNetworkAccessManager::head#
    {27, 709, 630},	// QNetworkAccessManager::metaObject
    {27, 721, 660},	// QNetworkAccessManager::networkAccessible
    {27, 723, 666},	// QNetworkAccessManager::networkAccessibleChanged$
    {27, 725, 665},	// QNetworkAccessManager::networkSessionConnected
    {27, 784, -70},	// QNetworkAccessManager::post##
    {27, 797, 638},	// QNetworkAccessManager::proxy
    {27, 799, 661},	// QNetworkAccessManager::proxyAuthenticationRequired##
    {27, 800, 640},	// QNetworkAccessManager::proxyFactory
    {27, 806, -74},	// QNetworkAccessManager::put##
    {27, 812, 636},	// QNetworkAccessManager::qt_metacall$$?
    {27, 814, 631},	// QNetworkAccessManager::qt_metacast$
    {27, 872, 671},	// QNetworkAccessManager::sendCustomRequest##
    {27, 873, 655},	// QNetworkAccessManager::sendCustomRequest###
    {27, 908, 643},	// QNetworkAccessManager::setCache#
    {27, 917, 656},	// QNetworkAccessManager::setConfiguration#
    {27, 923, 645},	// QNetworkAccessManager::setCookieJar#
    {27, 987, 659},	// QNetworkAccessManager::setNetworkAccessible$
    {27, 1035, 639},	// QNetworkAccessManager::setProxy#
    {27, 1040, 641},	// QNetworkAccessManager::setProxyFactory#
    {27, 1119, 664},	// QNetworkAccessManager::sslErrors#?
    {27, 1126, 673},	// QNetworkAccessManager::staticMetaObject
    {27, 1151, 668},	// QNetworkAccessManager::tr$
    {27, 1152, 632},	// QNetworkAccessManager::tr$$
    {27, 1153, 634},	// QNetworkAccessManager::tr$$$
    {27, 1155, 669},	// QNetworkAccessManager::trUtf8$
    {27, 1156, 633},	// QNetworkAccessManager::trUtf8$$
    {27, 1157, 635},	// QNetworkAccessManager::trUtf8$$$
    {27, 1207, 684},	// QNetworkAccessManager::~QNetworkAccessManager
    {28, 236, 685},	// QNetworkAddressEntry::QNetworkAddressEntry
    {28, 237, 686},	// QNetworkAddressEntry::QNetworkAddressEntry#
    {28, 465, 696},	// QNetworkAddressEntry::broadcast
    {28, 641, 690},	// QNetworkAddressEntry::ip
    {28, 720, 692},	// QNetworkAddressEntry::netmask
    {28, 735, 689},	// QNetworkAddressEntry::operator!=#
    {28, 741, 687},	// QNetworkAddressEntry::operator=#
    {28, 744, 688},	// QNetworkAddressEntry::operator==#
    {28, 789, 694},	// QNetworkAddressEntry::prefixLength
    {28, 904, 697},	// QNetworkAddressEntry::setBroadcast#
    {28, 960, 691},	// QNetworkAddressEntry::setIp#
    {28, 985, 693},	// QNetworkAddressEntry::setNetmask#
    {28, 1021, 695},	// QNetworkAddressEntry::setPrefixLength$
    {28, 1208, 698},	// QNetworkAddressEntry::~QNetworkAddressEntry
    {29, 238, 699},	// QNetworkCacheMetaData::QNetworkCacheMetaData
    {29, 239, 700},	// QNetworkCacheMetaData::QNetworkCacheMetaData#
    {29, 451, 715},	// QNetworkCacheMetaData::attributes
    {29, 576, 711},	// QNetworkCacheMetaData::expirationDate
    {29, 664, 704},	// QNetworkCacheMetaData::isValid
    {29, 674, 709},	// QNetworkCacheMetaData::lastModified
    {29, 735, 703},	// QNetworkCacheMetaData::operator!=#
    {29, 741, 701},	// QNetworkCacheMetaData::operator=#
    {29, 744, 702},	// QNetworkCacheMetaData::operator==#
    {29, 826, 707},	// QNetworkCacheMetaData::rawHeaders
    {29, 868, 713},	// QNetworkCacheMetaData::saveToDisk
    {29, 896, 716},	// QNetworkCacheMetaData::setAttributes?
    {29, 942, 712},	// QNetworkCacheMetaData::setExpirationDate#
    {29, 962, 710},	// QNetworkCacheMetaData::setLastModified#
    {29, 1046, 708},	// QNetworkCacheMetaData::setRawHeaders?
    {29, 1057, 714},	// QNetworkCacheMetaData::setSaveToDisk$
    {29, 1097, 706},	// QNetworkCacheMetaData::setUrl#
    {29, 1165, 705},	// QNetworkCacheMetaData::url
    {29, 1209, 717},	// QNetworkCacheMetaData::~QNetworkCacheMetaData
    {30, 3, 745},	// QNetworkConfiguration::Active
    {30, 19, 749},	// QNetworkConfiguration::Bearer2G
    {30, 20, 753},	// QNetworkConfiguration::BearerBluetooth
    {30, 21, 750},	// QNetworkConfiguration::BearerCDMA2000
    {30, 22, 747},	// QNetworkConfiguration::BearerEthernet
    {30, 23, 752},	// QNetworkConfiguration::BearerHSPA
    {30, 24, 746},	// QNetworkConfiguration::BearerUnknown
    {30, 25, 751},	// QNetworkConfiguration::BearerWCDMA
    {30, 26, 748},	// QNetworkConfiguration::BearerWLAN
    {30, 27, 754},	// QNetworkConfiguration::BearerWiMAX
    {30, 77, 743},	// QNetworkConfiguration::Defined
    {30, 82, 744},	// QNetworkConfiguration::Discovered
    {30, 114, 734},	// QNetworkConfiguration::InternetAccessPoint
    {30, 115, 737},	// QNetworkConfiguration::Invalid
    {30, 171, 740},	// QNetworkConfiguration::PrivatePurpose
    {30, 183, 739},	// QNetworkConfiguration::PublicPurpose
    {30, 240, 718},	// QNetworkConfiguration::QNetworkConfiguration
    {30, 241, 719},	// QNetworkConfiguration::QNetworkConfiguration#
    {30, 334, 735},	// QNetworkConfiguration::ServiceNetwork
    {30, 335, 741},	// QNetworkConfiguration::ServiceSpecificPurpose
    {30, 380, 742},	// QNetworkConfiguration::Undefined
    {30, 392, 738},	// QNetworkConfiguration::UnknownPurpose
    {30, 400, 736},	// QNetworkConfiguration::UserChoice
    {30, 456, 726},	// QNetworkConfiguration::bearerName
    {30, 457, 727},	// QNetworkConfiguration::bearerType
    {30, 458, 728},	// QNetworkConfiguration::bearerTypeName
    {30, 480, 731},	// QNetworkConfiguration::children
    {30, 626, 729},	// QNetworkConfiguration::identifier
    {30, 657, 730},	// QNetworkConfiguration::isRoamingAvailable
    {30, 664, 733},	// QNetworkConfiguration::isValid
    {30, 719, 732},	// QNetworkConfiguration::name
    {30, 735, 722},	// QNetworkConfiguration::operator!=#
    {30, 741, 720},	// QNetworkConfiguration::operator=#
    {30, 744, 721},	// QNetworkConfiguration::operator==#
    {30, 804, 725},	// QNetworkConfiguration::purpose
    {30, 1123, 723},	// QNetworkConfiguration::state
    {30, 1158, 724},	// QNetworkConfiguration::type
    {30, 1210, 755},	// QNetworkConfiguration::~QNetworkConfiguration
    {31, 12, 783},	// QNetworkConfigurationManager::ApplicationLevelRoaming
    {31, 36, 780},	// QNetworkConfigurationManager::CanStartAndStopInterfaces
    {31, 73, 785},	// QNetworkConfigurationManager::DataStatistics
    {31, 80, 781},	// QNetworkConfigurationManager::DirectConnectionRouting
    {31, 92, 784},	// QNetworkConfigurationManager::ForcedRoaming
    {31, 147, 786},	// QNetworkConfigurationManager::NetworkSessionRequired
    {31, 242, 777},	// QNetworkConfigurationManager::QNetworkConfigurationManager
    {31, 243, 763},	// QNetworkConfigurationManager::QNetworkConfigurationManager#
    {31, 360, 782},	// QNetworkConfigurationManager::SystemSessionSupport
    {31, 437, 778},	// QNetworkConfigurationManager::allConfigurations
    {31, 438, 766},	// QNetworkConfigurationManager::allConfigurations$
    {31, 475, 764},	// QNetworkConfigurationManager::capabilities
    {31, 494, 770},	// QNetworkConfigurationManager::configurationAdded#
    {31, 496, 772},	// QNetworkConfigurationManager::configurationChanged#
    {31, 498, 767},	// QNetworkConfigurationManager::configurationFromIdentifier$
    {31, 500, 771},	// QNetworkConfigurationManager::configurationRemoved#
    {31, 545, 765},	// QNetworkConfigurationManager::defaultConfiguration
    {31, 654, 768},	// QNetworkConfigurationManager::isOnline
    {31, 709, 756},	// QNetworkConfigurationManager::metaObject
    {31, 730, 773},	// QNetworkConfigurationManager::onlineStateChanged$
    {31, 812, 762},	// QNetworkConfigurationManager::qt_metacall$$?
    {31, 814, 757},	// QNetworkConfigurationManager::qt_metacast$
    {31, 1126, 779},	// QNetworkConfigurationManager::staticMetaObject
    {31, 1151, 775},	// QNetworkConfigurationManager::tr$
    {31, 1152, 758},	// QNetworkConfigurationManager::tr$$
    {31, 1153, 760},	// QNetworkConfigurationManager::tr$$$
    {31, 1155, 776},	// QNetworkConfigurationManager::trUtf8$
    {31, 1156, 759},	// QNetworkConfigurationManager::trUtf8$$
    {31, 1157, 761},	// QNetworkConfigurationManager::trUtf8$$$
    {31, 1159, 774},	// QNetworkConfigurationManager::updateCompleted
    {31, 1160, 769},	// QNetworkConfigurationManager::updateConfigurations
    {31, 1211, 787},	// QNetworkConfigurationManager::~QNetworkConfigurationManager
    {32, 95, 814},	// QNetworkCookie::Full
    {32, 145, 813},	// QNetworkCookie::NameAndValueOnly
    {32, 244, 810},	// QNetworkCookie::QNetworkCookie
    {32, 245, -78},	// QNetworkCookie::QNetworkCookie#
    {32, 246, 788},	// QNetworkCookie::QNetworkCookie##
    {32, 557, 800},	// QNetworkCookie::domain
    {32, 576, 798},	// QNetworkCookie::expirationDate
    {32, 648, 795},	// QNetworkCookie::isHttpOnly
    {32, 659, 793},	// QNetworkCookie::isSecure
    {32, 661, 797},	// QNetworkCookie::isSessionCookie
    {32, 719, 804},	// QNetworkCookie::name
    {32, 735, 792},	// QNetworkCookie::operator!=#
    {32, 741, 790},	// QNetworkCookie::operator=#
    {32, 744, 791},	// QNetworkCookie::operator==#
    {32, 761, 809},	// QNetworkCookie::parseCookies#
    {32, 767, 802},	// QNetworkCookie::path
    {32, 935, 801},	// QNetworkCookie::setDomain$
    {32, 942, 799},	// QNetworkCookie::setExpirationDate#
    {32, 958, 796},	// QNetworkCookie::setHttpOnly$
    {32, 982, 805},	// QNetworkCookie::setName#
    {32, 1001, 803},	// QNetworkCookie::setPath$
    {32, 1061, 794},	// QNetworkCookie::setSecure$
    {32, 1106, 807},	// QNetworkCookie::setValue#
    {32, 1147, 812},	// QNetworkCookie::toRawForm
    {32, 1148, 808},	// QNetworkCookie::toRawForm$
    {32, 1168, 806},	// QNetworkCookie::value
    {32, 1212, 815},	// QNetworkCookie::~QNetworkCookie
    {33, 247, 830},	// QNetworkCookieJar::QNetworkCookieJar
    {33, 248, 823},	// QNetworkCookieJar::QNetworkCookieJar#
    {33, 439, 826},	// QNetworkCookieJar::allCookies
    {33, 524, 824},	// QNetworkCookieJar::cookiesForUrl#
    {33, 709, 816},	// QNetworkCookieJar::metaObject
    {33, 812, 822},	// QNetworkCookieJar::qt_metacall$$?
    {33, 814, 817},	// QNetworkCookieJar::qt_metacast$
    {33, 888, 827},	// QNetworkCookieJar::setAllCookies?
    {33, 925, 825},	// QNetworkCookieJar::setCookiesFromUrl?#
    {33, 1126, 831},	// QNetworkCookieJar::staticMetaObject
    {33, 1151, 828},	// QNetworkCookieJar::tr$
    {33, 1152, 818},	// QNetworkCookieJar::tr$$
    {33, 1153, 820},	// QNetworkCookieJar::tr$$$
    {33, 1155, 829},	// QNetworkCookieJar::trUtf8$
    {33, 1156, 819},	// QNetworkCookieJar::trUtf8$$
    {33, 1157, 821},	// QNetworkCookieJar::trUtf8$$$
    {33, 1213, 832},	// QNetworkCookieJar::~QNetworkCookieJar
    {34, 249, 857},	// QNetworkDiskCache::QNetworkDiskCache
    {34, 250, 840},	// QNetworkDiskCache::QNetworkDiskCache#
    {34, 472, 841},	// QNetworkDiskCache::cacheDirectory
    {34, 473, 845},	// QNetworkDiskCache::cacheSize
    {34, 482, 853},	// QNetworkDiskCache::clear
    {34, 536, 848},	// QNetworkDiskCache::data#
    {34, 577, 854},	// QNetworkDiskCache::expire
    {34, 580, 852},	// QNetworkDiskCache::fileMetaData$
    {34, 635, 851},	// QNetworkDiskCache::insert#
    {34, 705, 843},	// QNetworkDiskCache::maximumCacheSize
    {34, 707, 846},	// QNetworkDiskCache::metaData#
    {34, 709, 833},	// QNetworkDiskCache::metaObject
    {34, 791, 850},	// QNetworkDiskCache::prepare#
    {34, 812, 839},	// QNetworkDiskCache::qt_metacall$$?
    {34, 814, 834},	// QNetworkDiskCache::qt_metacast$
    {34, 845, 849},	// QNetworkDiskCache::remove#
    {34, 910, 842},	// QNetworkDiskCache::setCacheDirectory$
    {34, 978, 844},	// QNetworkDiskCache::setMaximumCacheSize$
    {34, 1126, 858},	// QNetworkDiskCache::staticMetaObject
    {34, 1151, 855},	// QNetworkDiskCache::tr$
    {34, 1152, 835},	// QNetworkDiskCache::tr$$
    {34, 1153, 837},	// QNetworkDiskCache::tr$$$
    {34, 1155, 856},	// QNetworkDiskCache::trUtf8$
    {34, 1156, 836},	// QNetworkDiskCache::trUtf8$$
    {34, 1157, 838},	// QNetworkDiskCache::trUtf8$$$
    {34, 1162, 847},	// QNetworkDiskCache::updateMetaData#
    {34, 1214, 859},	// QNetworkDiskCache::~QNetworkDiskCache
    {35, 34, 876},	// QNetworkInterface::CanBroadcast
    {35, 35, 879},	// QNetworkInterface::CanMulticast
    {35, 122, 877},	// QNetworkInterface::IsLoopBack
    {35, 123, 878},	// QNetworkInterface::IsPointToPoint
    {35, 124, 875},	// QNetworkInterface::IsRunning
    {35, 125, 874},	// QNetworkInterface::IsUp
    {35, 251, 860},	// QNetworkInterface::QNetworkInterface
    {35, 252, 861},	// QNetworkInterface::QNetworkInterface#
    {35, 433, 869},	// QNetworkInterface::addressEntries
    {35, 436, 873},	// QNetworkInterface::allAddresses
    {35, 440, 872},	// QNetworkInterface::allInterfaces
    {35, 583, 867},	// QNetworkInterface::flags
    {35, 607, 868},	// QNetworkInterface::hardwareAddress
    {35, 625, 866},	// QNetworkInterface::humanReadableName
    {35, 633, 864},	// QNetworkInterface::index
    {35, 638, 871},	// QNetworkInterface::interfaceFromIndex$
    {35, 640, 870},	// QNetworkInterface::interfaceFromName$
    {35, 664, 863},	// QNetworkInterface::isValid
    {35, 719, 865},	// QNetworkInterface::name
    {35, 741, 862},	// QNetworkInterface::operator=#
    {35, 1215, 880},	// QNetworkInterface::~QNetworkInterface
    {36, 33, 916},	// QNetworkProxy::CachingCapability
    {36, 76, 907},	// QNetworkProxy::DefaultProxy
    {36, 94, 912},	// QNetworkProxy::FtpCachingProxy
    {36, 102, 917},	// QNetworkProxy::HostNameLookupCapability
    {36, 106, 911},	// QNetworkProxy::HttpCachingProxy
    {36, 109, 910},	// QNetworkProxy::HttpProxy
    {36, 129, 914},	// QNetworkProxy::ListeningCapability
    {36, 150, 909},	// QNetworkProxy::NoProxy
    {36, 253, 881},	// QNetworkProxy::QNetworkProxy
    {36, 254, 883},	// QNetworkProxy::QNetworkProxy#
    {36, 255, 903},	// QNetworkProxy::QNetworkProxy$
    {36, 256, 904},	// QNetworkProxy::QNetworkProxy$$
    {36, 257, 905},	// QNetworkProxy::QNetworkProxy$$$
    {36, 258, 906},	// QNetworkProxy::QNetworkProxy$$$$
    {36, 259, 882},	// QNetworkProxy::QNetworkProxy$$$$$
    {36, 345, 908},	// QNetworkProxy::Socks5Proxy
    {36, 369, 913},	// QNetworkProxy::TunnelingCapability
    {36, 371, 915},	// QNetworkProxy::UdpTunnelingCapability
    {36, 446, 902},	// QNetworkProxy::applicationProxy
    {36, 475, 890},	// QNetworkProxy::capabilities
    {36, 624, 898},	// QNetworkProxy::hostName
    {36, 642, 891},	// QNetworkProxy::isCachingProxy
    {36, 663, 892},	// QNetworkProxy::isTransparentProxy
    {36, 735, 886},	// QNetworkProxy::operator!=#
    {36, 741, 884},	// QNetworkProxy::operator=#
    {36, 744, 885},	// QNetworkProxy::operator==#
    {36, 766, 896},	// QNetworkProxy::password
    {36, 781, 900},	// QNetworkProxy::port
    {36, 890, 901},	// QNetworkProxy::setApplicationProxy#
    {36, 912, 889},	// QNetworkProxy::setCapabilities$
    {36, 956, 897},	// QNetworkProxy::setHostName$
    {36, 999, 895},	// QNetworkProxy::setPassword$
    {36, 1019, 899},	// QNetworkProxy::setPort$
    {36, 1095, 887},	// QNetworkProxy::setType$
    {36, 1101, 893},	// QNetworkProxy::setUser$
    {36, 1158, 888},	// QNetworkProxy::type
    {36, 1167, 894},	// QNetworkProxy::user
    {36, 1216, 918},	// QNetworkProxy::~QNetworkProxy
    {37, 260, 919},	// QNetworkProxyFactory::QNetworkProxyFactory
    {37, 261, 925},	// QNetworkProxyFactory::QNetworkProxyFactory#
    {37, 802, 923},	// QNetworkProxyFactory::proxyForQuery#
    {37, 815, 926},	// QNetworkProxyFactory::queryProxy
    {37, 816, 920},	// QNetworkProxyFactory::queryProxy#
    {37, 892, 922},	// QNetworkProxyFactory::setApplicationProxyFactory#
    {37, 1099, 921},	// QNetworkProxyFactory::setUseSystemConfiguration$
    {37, 1136, 927},	// QNetworkProxyFactory::systemProxyForQuery
    {37, 1137, 924},	// QNetworkProxyFactory::systemProxyForQuery#
    {37, 1217, 928},	// QNetworkProxyFactory::~QNetworkProxyFactory
    {38, 262, 929},	// QNetworkProxyQuery::QNetworkProxyQuery
    {38, 263, -109},	// QNetworkProxyQuery::QNetworkProxyQuery#
    {38, 264, 959},	// QNetworkProxyQuery::QNetworkProxyQuery##
    {38, 265, 934},	// QNetworkProxyQuery::QNetworkProxyQuery##$
    {38, 266, -112},	// QNetworkProxyQuery::QNetworkProxyQuery#$
    {38, 267, -115},	// QNetworkProxyQuery::QNetworkProxyQuery#$$
    {38, 268, -118},	// QNetworkProxyQuery::QNetworkProxyQuery#$$$
    {38, 269, 935},	// QNetworkProxyQuery::QNetworkProxyQuery#$$$$
    {38, 270, 957},	// QNetworkProxyQuery::QNetworkProxyQuery$
    {38, 271, -121},	// QNetworkProxyQuery::QNetworkProxyQuery$$
    {38, 272, -124},	// QNetworkProxyQuery::QNetworkProxyQuery$$$
    {38, 273, 931},	// QNetworkProxyQuery::QNetworkProxyQuery$$$$
    {38, 361, 966},	// QNetworkProxyQuery::TcpServer
    {38, 362, 964},	// QNetworkProxyQuery::TcpSocket
    {38, 370, 965},	// QNetworkProxyQuery::UdpSocket
    {38, 398, 967},	// QNetworkProxyQuery::UrlRequest
    {38, 695, 946},	// QNetworkProxyQuery::localPort
    {38, 724, 952},	// QNetworkProxyQuery::networkConfiguration
    {38, 735, 939},	// QNetworkProxyQuery::operator!=#
    {38, 741, 937},	// QNetworkProxyQuery::operator=#
    {38, 744, 938},	// QNetworkProxyQuery::operator==#
    {38, 771, 944},	// QNetworkProxyQuery::peerHostName
    {38, 773, 942},	// QNetworkProxyQuery::peerPort
    {38, 796, 948},	// QNetworkProxyQuery::protocolTag
    {38, 817, 940},	// QNetworkProxyQuery::queryType
    {38, 972, 947},	// QNetworkProxyQuery::setLocalPort$
    {38, 989, 953},	// QNetworkProxyQuery::setNetworkConfiguration#
    {38, 1005, 945},	// QNetworkProxyQuery::setPeerHostName$
    {38, 1009, 943},	// QNetworkProxyQuery::setPeerPort$
    {38, 1033, 949},	// QNetworkProxyQuery::setProtocolTag$
    {38, 1042, 941},	// QNetworkProxyQuery::setQueryType$
    {38, 1097, 951},	// QNetworkProxyQuery::setUrl#
    {38, 1165, 950},	// QNetworkProxyQuery::url
    {38, 1218, 968},	// QNetworkProxyQuery::~QNetworkProxyQuery
    {39, 14, 1036},	// QNetworkReply::AuthenticationRequiredError
    {39, 59, 1019},	// QNetworkReply::ConnectionRefusedError
    {39, 60, 1033},	// QNetworkReply::ContentAccessDenied
    {39, 63, 1035},	// QNetworkReply::ContentNotFoundError
    {39, 64, 1034},	// QNetworkReply::ContentOperationNotPermittedError
    {39, 65, 1037},	// QNetworkReply::ContentReSendError
    {39, 105, 1021},	// QNetworkReply::HostNotFoundError
    {39, 148, 1018},	// QNetworkReply::NoError
    {39, 159, 1023},	// QNetworkReply::OperationCanceledError
    {39, 172, 1041},	// QNetworkReply::ProtocolFailure
    {39, 173, 1040},	// QNetworkReply::ProtocolInvalidOperationError
    {39, 174, 1039},	// QNetworkReply::ProtocolUnknownError
    {39, 175, 1031},	// QNetworkReply::ProxyAuthenticationRequiredError
    {39, 176, 1028},	// QNetworkReply::ProxyConnectionClosedError
    {39, 177, 1027},	// QNetworkReply::ProxyConnectionRefusedError
    {39, 179, 1029},	// QNetworkReply::ProxyNotFoundError
    {39, 181, 1030},	// QNetworkReply::ProxyTimeoutError
    {39, 274, 1016},	// QNetworkReply::QNetworkReply
    {39, 275, 1004},	// QNetworkReply::QNetworkReply#
    {39, 321, 1020},	// QNetworkReply::RemoteHostClosedError
    {39, 348, 1024},	// QNetworkReply::SslHandshakeFailedError
    {39, 363, 1025},	// QNetworkReply::TemporaryNetworkFailureError
    {39, 365, 1022},	// QNetworkReply::TimeoutError
    {39, 385, 1038},	// QNetworkReply::UnknownContentError
    {39, 387, 1026},	// QNetworkReply::UnknownNetworkError
    {39, 391, 1032},	// QNetworkReply::UnknownProxyError
    {39, 409, 976},	// QNetworkReply::abort
    {39, 449, 993},	// QNetworkReply::attribute$
    {39, 485, 977},	// QNetworkReply::close
    {39, 561, 1003},	// QNetworkReply::downloadProgress$$
    {39, 571, 984},	// QNetworkReply::error
    {39, 572, 1000},	// QNetworkReply::error$
    {39, 581, 999},	// QNetworkReply::finished
    {39, 617, 989},	// QNetworkReply::hasRawHeader#
    {39, 622, 988},	// QNetworkReply::header$
    {39, 628, 997},	// QNetworkReply::ignoreSslErrors
    {39, 629, 996},	// QNetworkReply::ignoreSslErrors?
    {39, 647, 985},	// QNetworkReply::isFinished
    {39, 658, 986},	// QNetworkReply::isRunning
    {39, 660, 978},	// QNetworkReply::isSequential
    {39, 703, 981},	// QNetworkReply::manager
    {39, 708, 998},	// QNetworkReply::metaDataChanged
    {39, 709, 969},	// QNetworkReply::metaObject
    {39, 733, 982},	// QNetworkReply::operation
    {39, 812, 975},	// QNetworkReply::qt_metacall$$?
    {39, 814, 970},	// QNetworkReply::qt_metacast$
    {39, 823, 991},	// QNetworkReply::rawHeader#
    {39, 824, 990},	// QNetworkReply::rawHeaderList
    {39, 825, 992},	// QNetworkReply::rawHeaderPairs
    {39, 830, 979},	// QNetworkReply::readBufferSize
    {39, 855, 983},	// QNetworkReply::request
    {39, 894, 1013},	// QNetworkReply::setAttribute$#
    {39, 938, 1008},	// QNetworkReply::setError$$
    {39, 946, 1009},	// QNetworkReply::setFinished$
    {39, 950, 1011},	// QNetworkReply::setHeader$#
    {39, 991, 1006},	// QNetworkReply::setOperation$
    {39, 1044, 1012},	// QNetworkReply::setRawHeader##
    {39, 1048, 980},	// QNetworkReply::setReadBufferSize$
    {39, 1052, 1007},	// QNetworkReply::setRequest#
    {39, 1082, 995},	// QNetworkReply::setSslConfiguration#
    {39, 1097, 1010},	// QNetworkReply::setUrl#
    {39, 1117, 994},	// QNetworkReply::sslConfiguration
    {39, 1120, 1001},	// QNetworkReply::sslErrors?
    {39, 1126, 1017},	// QNetworkReply::staticMetaObject
    {39, 1151, 1014},	// QNetworkReply::tr$
    {39, 1152, 971},	// QNetworkReply::tr$$
    {39, 1153, 973},	// QNetworkReply::tr$$$
    {39, 1155, 1015},	// QNetworkReply::trUtf8$
    {39, 1156, 972},	// QNetworkReply::trUtf8$$
    {39, 1157, 974},	// QNetworkReply::trUtf8$$$
    {39, 1164, 1002},	// QNetworkReply::uploadProgress$$
    {39, 1165, 987},	// QNetworkReply::url
    {39, 1188, 1005},	// QNetworkReply::writeData$$
    {39, 1219, 1042},	// QNetworkReply::~QNetworkReply
    {40, 6, 1095},	// QNetworkRequest::AlwaysCache
    {40, 7, 1092},	// QNetworkRequest::AlwaysNetwork
    {40, 15, 1085},	// QNetworkRequest::AuthenticationReuseAttribute
    {40, 18, 1096},	// QNetworkRequest::Automatic
    {40, 31, 1077},	// QNetworkRequest::CacheLoadControlAttribute
    {40, 32, 1078},	// QNetworkRequest::CacheSaveControlAttribute
    {40, 54, 1076},	// QNetworkRequest::ConnectionEncryptedAttribute
    {40, 61, 1072},	// QNetworkRequest::ContentDispositionHeader
    {40, 62, 1067},	// QNetworkRequest::ContentLengthHeader
    {40, 66, 1066},	// QNetworkRequest::ContentTypeHeader
    {40, 67, 1070},	// QNetworkRequest::CookieHeader
    {40, 68, 1084},	// QNetworkRequest::CookieLoadControlAttribute
    {40, 69, 1086},	// QNetworkRequest::CookieSaveControlAttribute
    {40, 72, 1083},	// QNetworkRequest::CustomVerbAttribute
    {40, 84, 1080},	// QNetworkRequest::DoNotBufferUploadDataAttribute
    {40, 86, 1088},	// QNetworkRequest::DownloadBufferAttribute
    {40, 99, 1098},	// QNetworkRequest::HighPriority
    {40, 107, 1081},	// QNetworkRequest::HttpPipeliningAllowedAttribute
    {40, 108, 1082},	// QNetworkRequest::HttpPipeliningWasUsedAttribute
    {40, 110, 1074},	// QNetworkRequest::HttpReasonPhraseAttribute
    {40, 111, 1073},	// QNetworkRequest::HttpStatusCodeAttribute
    {40, 127, 1069},	// QNetworkRequest::LastModifiedHeader
    {40, 134, 1068},	// QNetworkRequest::LocationHeader
    {40, 138, 1100},	// QNetworkRequest::LowPriority
    {40, 139, 1097},	// QNetworkRequest::Manual
    {40, 140, 1087},	// QNetworkRequest::MaximumDownloadBufferSizeAttribute
    {40, 153, 1099},	// QNetworkRequest::NormalPriority
    {40, 168, 1094},	// QNetworkRequest::PreferCache
    {40, 169, 1093},	// QNetworkRequest::PreferNetwork
    {40, 276, 1064},	// QNetworkRequest::QNetworkRequest
    {40, 277, -67},	// QNetworkRequest::QNetworkRequest#
    {40, 319, 1075},	// QNetworkRequest::RedirectionTargetAttribute
    {40, 337, 1071},	// QNetworkRequest::SetCookieHeader
    {40, 346, 1079},	// QNetworkRequest::SourceIsFromCacheAttribute
    {40, 359, 1089},	// QNetworkRequest::SynchronousRequestAttribute
    {40, 399, 1090},	// QNetworkRequest::User
    {40, 401, 1091},	// QNetworkRequest::UserMax
    {40, 449, 1065},	// QNetworkRequest::attribute$
    {40, 450, 1056},	// QNetworkRequest::attribute$#
    {40, 617, 1052},	// QNetworkRequest::hasRawHeader#
    {40, 622, 1050},	// QNetworkRequest::header$
    {40, 735, 1047},	// QNetworkRequest::operator!=#
    {40, 741, 1045},	// QNetworkRequest::operator=#
    {40, 744, 1046},	// QNetworkRequest::operator==#
    {40, 756, 1061},	// QNetworkRequest::originatingObject
    {40, 792, 1062},	// QNetworkRequest::priority
    {40, 823, 1054},	// QNetworkRequest::rawHeader#
    {40, 824, 1053},	// QNetworkRequest::rawHeaderList
    {40, 894, 1057},	// QNetworkRequest::setAttribute$#
    {40, 950, 1051},	// QNetworkRequest::setHeader$#
    {40, 995, 1060},	// QNetworkRequest::setOriginatingObject#
    {40, 1023, 1063},	// QNetworkRequest::setPriority$
    {40, 1044, 1055},	// QNetworkRequest::setRawHeader##
    {40, 1082, 1059},	// QNetworkRequest::setSslConfiguration#
    {40, 1097, 1049},	// QNetworkRequest::setUrl#
    {40, 1117, 1058},	// QNetworkRequest::sslConfiguration
    {40, 1165, 1048},	// QNetworkRequest::url
    {40, 1220, 1101},	// QNetworkRequest::~QNetworkRequest
    {41, 46, 1146},	// QNetworkSession::Closing
    {41, 50, 1145},	// QNetworkSession::Connected
    {41, 52, 1144},	// QNetworkSession::Connecting
    {41, 81, 1147},	// QNetworkSession::Disconnected
    {41, 115, 1142},	// QNetworkSession::Invalid
    {41, 117, 1153},	// QNetworkSession::InvalidConfigurationError
    {41, 155, 1143},	// QNetworkSession::NotAvailable
    {41, 160, 1152},	// QNetworkSession::OperationNotSupportedError
    {41, 279, 1139},	// QNetworkSession::QNetworkSession#
    {41, 280, 1109},	// QNetworkSession::QNetworkSession##
    {41, 326, 1148},	// QNetworkSession::Roaming
    {41, 327, 1151},	// QNetworkSession::RoamingError
    {41, 336, 1150},	// QNetworkSession::SessionAbortedError
    {41, 393, 1149},	// QNetworkSession::UnknownSessionError
    {41, 412, 1127},	// QNetworkSession::accept
    {41, 414, 1120},	// QNetworkSession::activeTime
    {41, 467, 1119},	// QNetworkSession::bytesReceived
    {41, 469, 1118},	// QNetworkSession::bytesWritten
    {41, 485, 1123},	// QNetworkSession::close
    {41, 487, 1131},	// QNetworkSession::closed
    {41, 492, 1111},	// QNetworkSession::configuration
    {41, 502, 1135},	// QNetworkSession::connectNotify$
    {41, 555, 1136},	// QNetworkSession::disconnectNotify$
    {41, 571, 1114},	// QNetworkSession::error
    {41, 572, 1132},	// QNetworkSession::error$
    {41, 573, 1115},	// QNetworkSession::errorString
    {41, 627, 1126},	// QNetworkSession::ignore
    {41, 636, 1112},	// QNetworkSession::interface
    {41, 655, 1110},	// QNetworkSession::isOpen
    {41, 709, 1102},	// QNetworkSession::metaObject
    {41, 711, 1125},	// QNetworkSession::migrate
    {41, 726, 1134},	// QNetworkSession::newConfigurationActivated
    {41, 731, 1122},	// QNetworkSession::open
    {41, 732, 1130},	// QNetworkSession::opened
    {41, 788, 1133},	// QNetworkSession::preferredConfigurationChanged#$
    {41, 812, 1108},	// QNetworkSession::qt_metacall$$?
    {41, 814, 1103},	// QNetworkSession::qt_metacast$
    {41, 843, 1128},	// QNetworkSession::reject
    {41, 881, 1116},	// QNetworkSession::sessionProperty$
    {41, 1063, 1117},	// QNetworkSession::setSessionProperty$#
    {41, 1123, 1113},	// QNetworkSession::state
    {41, 1125, 1129},	// QNetworkSession::stateChanged$
    {41, 1126, 1141},	// QNetworkSession::staticMetaObject
    {41, 1128, 1124},	// QNetworkSession::stop
    {41, 1151, 1137},	// QNetworkSession::tr$
    {41, 1152, 1104},	// QNetworkSession::tr$$
    {41, 1153, 1106},	// QNetworkSession::tr$$$
    {41, 1155, 1138},	// QNetworkSession::trUtf8$
    {41, 1156, 1105},	// QNetworkSession::trUtf8$$
    {41, 1157, 1107},	// QNetworkSession::trUtf8$$$
    {41, 1183, 1140},	// QNetworkSession::waitForOpened
    {41, 1184, 1121},	// QNetworkSession::waitForOpened$
    {41, 1221, 1154},	// QNetworkSession::~QNetworkSession
    {44, 10, 1174},	// QSsl::AnyProtocol
    {44, 79, 1165},	// QSsl::Der
    {44, 83, 1179},	// QSsl::DnsEntry
    {44, 87, 1163},	// QSsl::Dsa
    {44, 88, 1178},	// QSsl::EmailEntry
    {44, 166, 1164},	// QSsl::Pem
    {44, 170, 1180},	// QSsl::PrivateKey
    {44, 182, 1181},	// QSsl::PublicKey
    {44, 328, 1162},	// QSsl::Rsa
    {44, 329, 1176},	// QSsl::SecureProtocols
    {44, 349, 1168},	// QSsl::SslOptionDisableCompression
    {44, 350, 1166},	// QSsl::SslOptionDisableEmptyFragments
    {44, 351, 1170},	// QSsl::SslOptionDisableLegacyRenegotiation
    {44, 352, 1169},	// QSsl::SslOptionDisableServerNameIndication
    {44, 353, 1167},	// QSsl::SslOptionDisableSessionTickets
    {44, 355, 1172},	// QSsl::SslV2
    {44, 356, 1171},	// QSsl::SslV3
    {44, 366, 1173},	// QSsl::TlsV1
    {44, 367, 1175},	// QSsl::TlsV1SslV3
    {44, 390, 1177},	// QSsl::UnknownProtocol
    {45, 48, 1217},	// QSslCertificate::CommonName
    {45, 70, 1220},	// QSslCertificate::CountryName
    {45, 133, 1218},	// QSslCertificate::LocalityName
    {45, 161, 1216},	// QSslCertificate::Organization
    {45, 162, 1219},	// QSslCertificate::OrganizationalUnitName
    {45, 281, 1209},	// QSslCertificate::QSslCertificate
    {45, 282, -127},	// QSslCertificate::QSslCertificate#
    {45, 283, -131},	// QSslCertificate::QSslCertificate#$
    {45, 357, 1221},	// QSslCertificate::StateOrProvinceName
    {45, 443, 1198},	// QSslCertificate::alternateSubjectNames
    {45, 482, 1190},	// QSslCertificate::clear
    {45, 549, 1211},	// QSslCertificate::digest
    {45, 550, 1193},	// QSslCertificate::digest$
    {45, 562, 1199},	// QSslCertificate::effectiveDate
    {45, 578, 1200},	// QSslCertificate::expiryDate
    {45, 586, 1215},	// QSslCertificate::fromData#
    {45, 587, 1206},	// QSslCertificate::fromData#$
    {45, 589, 1214},	// QSslCertificate::fromDevice#
    {45, 590, 1205},	// QSslCertificate::fromDevice#$
    {45, 594, 1212},	// QSslCertificate::fromPath$
    {45, 595, 1213},	// QSslCertificate::fromPath$$
    {45, 596, 1204},	// QSslCertificate::fromPath$$$
    {45, 606, 1207},	// QSslCertificate::handle
    {45, 653, 1188},	// QSslCertificate::isNull
    {45, 664, 1189},	// QSslCertificate::isValid
    {45, 667, 1195},	// QSslCertificate::issuerInfo#
    {45, 668, 1194},	// QSslCertificate::issuerInfo$
    {45, 735, 1187},	// QSslCertificate::operator!=#
    {45, 741, 1185},	// QSslCertificate::operator=#
    {45, 744, 1186},	// QSslCertificate::operator==#
    {45, 803, 1201},	// QSslCertificate::publicKey
    {45, 874, 1192},	// QSslCertificate::serialNumber
    {45, 1130, 1197},	// QSslCertificate::subjectInfo#
    {45, 1131, 1196},	// QSslCertificate::subjectInfo$
    {45, 1141, 1203},	// QSslCertificate::toDer
    {45, 1145, 1202},	// QSslCertificate::toPem
    {45, 1171, 1191},	// QSslCertificate::version
    {45, 1222, 1222},	// QSslCertificate::~QSslCertificate
    {46, 284, 1223},	// QSslCipher::QSslCipher
    {46, 285, 1225},	// QSslCipher::QSslCipher#
    {46, 286, 1224},	// QSslCipher::QSslCipher$$
    {46, 452, 1234},	// QSslCipher::authenticationMethod
    {46, 568, 1235},	// QSslCipher::encryptionMethod
    {46, 653, 1229},	// QSslCipher::isNull
    {46, 672, 1233},	// QSslCipher::keyExchangeMethod
    {46, 719, 1230},	// QSslCipher::name
    {46, 735, 1228},	// QSslCipher::operator!=#
    {46, 741, 1226},	// QSslCipher::operator=#
    {46, 744, 1227},	// QSslCipher::operator==#
    {46, 794, 1237},	// QSslCipher::protocol
    {46, 795, 1236},	// QSslCipher::protocolString
    {46, 1132, 1231},	// QSslCipher::supportedBits
    {46, 1166, 1232},	// QSslCipher::usedBits
    {46, 1223, 1238},	// QSslCipher::~QSslCipher
    {47, 287, 1239},	// QSslConfiguration::QSslConfiguration
    {47, 288, 1240},	// QSslConfiguration::QSslConfiguration#
    {47, 470, 1260},	// QSslConfiguration::caCertificates
    {47, 481, 1258},	// QSslConfiguration::ciphers
    {47, 545, 1264},	// QSslConfiguration::defaultConfiguration
    {47, 653, 1244},	// QSslConfiguration::isNull
    {47, 692, 1251},	// QSslConfiguration::localCertificate
    {47, 735, 1243},	// QSslConfiguration::operator!=#
    {47, 741, 1241},	// QSslConfiguration::operator=#
    {47, 744, 1242},	// QSslConfiguration::operator==#
    {47, 769, 1253},	// QSslConfiguration::peerCertificate
    {47, 770, 1254},	// QSslConfiguration::peerCertificateChain
    {47, 774, 1249},	// QSslConfiguration::peerVerifyDepth
    {47, 777, 1247},	// QSslConfiguration::peerVerifyMode
    {47, 793, 1256},	// QSslConfiguration::privateKey
    {47, 794, 1245},	// QSslConfiguration::protocol
    {47, 879, 1255},	// QSslConfiguration::sessionCipher
    {47, 906, 1261},	// QSslConfiguration::setCaCertificates?
    {47, 915, 1259},	// QSslConfiguration::setCiphers?
    {47, 931, 1265},	// QSslConfiguration::setDefaultConfiguration#
    {47, 968, 1252},	// QSslConfiguration::setLocalCertificate#
    {47, 1011, 1250},	// QSslConfiguration::setPeerVerifyDepth$
    {47, 1013, 1248},	// QSslConfiguration::setPeerVerifyMode$
    {47, 1025, 1257},	// QSslConfiguration::setPrivateKey#
    {47, 1031, 1246},	// QSslConfiguration::setProtocol$
    {47, 1084, 1262},	// QSslConfiguration::setSslOption$$
    {47, 1139, 1263},	// QSslConfiguration::testSslOption$
    {47, 1224, 1266},	// QSslConfiguration::~QSslConfiguration
    {48, 16, 1297},	// QSslError::AuthorityIssuerSerialNumberMismatch
    {48, 38, 1301},	// QSslError::CertificateBlacklisted
    {48, 39, 1283},	// QSslError::CertificateExpired
    {48, 40, 1282},	// QSslError::CertificateNotYetValid
    {48, 41, 1295},	// QSslError::CertificateRejected
    {48, 42, 1290},	// QSslError::CertificateRevoked
    {48, 43, 1281},	// QSslError::CertificateSignatureFailed
    {48, 44, 1294},	// QSslError::CertificateUntrusted
    {48, 103, 1299},	// QSslError::HostNameMismatch
    {48, 116, 1291},	// QSslError::InvalidCaCertificate
    {48, 118, 1285},	// QSslError::InvalidNotAfterField
    {48, 119, 1284},	// QSslError::InvalidNotBeforeField
    {48, 120, 1293},	// QSslError::InvalidPurpose
    {48, 148, 1277},	// QSslError::NoError
    {48, 149, 1298},	// QSslError::NoPeerCertificate
    {48, 151, 1300},	// QSslError::NoSslSupport
    {48, 164, 1292},	// QSslError::PathLengthExceeded
    {48, 289, 1267},	// QSslError::QSslError
    {48, 290, 1270},	// QSslError::QSslError#
    {48, 291, 1268},	// QSslError::QSslError$
    {48, 292, 1269},	// QSslError::QSslError$#
    {48, 330, 1286},	// QSslError::SelfSignedCertificate
    {48, 331, 1287},	// QSslError::SelfSignedCertificateInChain
    {48, 358, 1296},	// QSslError::SubjectIssuerMismatch
    {48, 372, 1280},	// QSslError::UnableToDecodeIssuerPublicKey
    {48, 373, 1279},	// QSslError::UnableToDecryptCertificateSignature
    {48, 374, 1278},	// QSslError::UnableToGetIssuerCertificate
    {48, 375, 1288},	// QSslError::UnableToGetLocalIssuerCertificate
    {48, 376, 1289},	// QSslError::UnableToVerifyFirstCertificate
    {48, 396, 1302},	// QSslError::UnspecifiedError
    {48, 478, 1276},	// QSslError::certificate
    {48, 571, 1274},	// QSslError::error
    {48, 573, 1275},	// QSslError::errorString
    {48, 735, 1273},	// QSslError::operator!=#
    {48, 741, 1271},	// QSslError::operator=#
    {48, 744, 1272},	// QSslError::operator==#
    {48, 1225, 1303},	// QSslError::~QSslError
    {49, 293, 1304},	// QSslKey::QSslKey
    {49, 294, 1307},	// QSslKey::QSslKey#
    {49, 295, -19},	// QSslKey::QSslKey#$
    {49, 296, -22},	// QSslKey::QSslKey#$$
    {49, 297, -25},	// QSslKey::QSslKey#$$$
    {49, 298, -28},	// QSslKey::QSslKey#$$$#
    {49, 435, 1313},	// QSslKey::algorithm
    {49, 482, 1310},	// QSslKey::clear
    {49, 606, 1316},	// QSslKey::handle
    {49, 653, 1309},	// QSslKey::isNull
    {49, 680, 1311},	// QSslKey::length
    {49, 735, 1318},	// QSslKey::operator!=#
    {49, 741, 1308},	// QSslKey::operator=#
    {49, 744, 1317},	// QSslKey::operator==#
    {49, 1141, 1326},	// QSslKey::toDer
    {49, 1142, 1315},	// QSslKey::toDer#
    {49, 1145, 1325},	// QSslKey::toPem
    {49, 1146, 1314},	// QSslKey::toPem#
    {49, 1158, 1312},	// QSslKey::type
    {49, 1226, 1327},	// QSslKey::~QSslKey
    {50, 17, 1436},	// QSslSocket::AutoVerifyPeer
    {50, 299, 1411},	// QSslSocket::QSslSocket
    {50, 300, 1335},	// QSslSocket::QSslSocket#
    {50, 311, 1434},	// QSslSocket::QueryPeer
    {50, 347, 1431},	// QSslSocket::SslClientMode
    {50, 354, 1432},	// QSslSocket::SslServerMode
    {50, 381, 1430},	// QSslSocket::UnencryptedMode
    {50, 402, 1433},	// QSslSocket::VerifyNone
    {50, 403, 1435},	// QSslSocket::VerifyPeer
    {50, 409, 1357},	// QSslSocket::abort
    {50, 416, 1379},	// QSslSocket::addCaCertificate#
    {50, 418, 1420},	// QSslSocket::addCaCertificates$
    {50, 419, 1421},	// QSslSocket::addCaCertificates$$
    {50, 420, 1378},	// QSslSocket::addCaCertificates$$$
    {50, 421, 1380},	// QSslSocket::addCaCertificates?
    {50, 423, 1384},	// QSslSocket::addDefaultCaCertificate#
    {50, 425, 1422},	// QSslSocket::addDefaultCaCertificates$
    {50, 426, 1423},	// QSslSocket::addDefaultCaCertificates$$
    {50, 427, 1383},	// QSslSocket::addDefaultCaCertificates$$$
    {50, 428, 1385},	// QSslSocket::addDefaultCaCertificates?
    {50, 447, 1355},	// QSslSocket::atEnd
    {50, 466, 1351},	// QSslSocket::bytesAvailable
    {50, 468, 1352},	// QSslSocket::bytesToWrite
    {50, 470, 1382},	// QSslSocket::caCertificates
    {50, 474, 1353},	// QSslSocket::canReadLine
    {50, 481, 1372},	// QSslSocket::ciphers
    {50, 485, 1354},	// QSslSocket::close
    {50, 510, 1412},	// QSslSocket::connectToHostEncrypted$$
    {50, 511, -81},	// QSslSocket::connectToHostEncrypted$$$
    {50, 512, 1337},	// QSslSocket::connectToHostEncrypted$$$$
    {50, 515, 1405},	// QSslSocket::connectToHostImplementation$$$
    {50, 543, 1387},	// QSslSocket::defaultCaCertificates
    {50, 544, 1376},	// QSslSocket::defaultCiphers
    {50, 552, 1406},	// QSslSocket::disconnectFromHostImplementation
    {50, 563, 1400},	// QSslSocket::encrypted
    {50, 564, 1359},	// QSslSocket::encryptedBytesAvailable
    {50, 565, 1360},	// QSslSocket::encryptedBytesToWrite
    {50, 567, 1404},	// QSslSocket::encryptedBytesWritten$
    {50, 584, 1356},	// QSslSocket::flush
    {50, 628, 1399},	// QSslSocket::ignoreSslErrors
    {50, 629, 1396},	// QSslSocket::ignoreSslErrors?
    {50, 644, 1342},	// QSslSocket::isEncrypted
    {50, 692, 1365},	// QSslSocket::localCertificate
    {50, 709, 1328},	// QSslSocket::metaObject
    {50, 715, 1341},	// QSslSocket::mode
    {50, 717, 1403},	// QSslSocket::modeChanged$
    {50, 769, 1366},	// QSslSocket::peerCertificate
    {50, 770, 1367},	// QSslSocket::peerCertificateChain
    {50, 774, 1347},	// QSslSocket::peerVerifyDepth
    {50, 776, 1401},	// QSslSocket::peerVerifyError#
    {50, 777, 1345},	// QSslSocket::peerVerifyMode
    {50, 778, 1349},	// QSslSocket::peerVerifyName
    {50, 793, 1371},	// QSslSocket::privateKey
    {50, 794, 1343},	// QSslSocket::protocol
    {50, 812, 1334},	// QSslSocket::qt_metacall$$?
    {50, 814, 1329},	// QSslSocket::qt_metacast$
    {50, 832, 1407},	// QSslSocket::readData$$
    {50, 879, 1368},	// QSslSocket::sessionCipher
    {50, 906, 1381},	// QSslSocket::setCaCertificates?
    {50, 914, 1374},	// QSslSocket::setCiphers$
    {50, 915, 1373},	// QSslSocket::setCiphers?
    {50, 927, 1386},	// QSslSocket::setDefaultCaCertificates?
    {50, 929, 1375},	// QSslSocket::setDefaultCiphers?
    {50, 968, 1363},	// QSslSocket::setLocalCertificate#
    {50, 969, 1416},	// QSslSocket::setLocalCertificate$
    {50, 970, 1364},	// QSslSocket::setLocalCertificate$$
    {50, 1011, 1348},	// QSslSocket::setPeerVerifyDepth$
    {50, 1013, 1346},	// QSslSocket::setPeerVerifyMode$
    {50, 1015, 1350},	// QSslSocket::setPeerVerifyName$
    {50, 1025, 1369},	// QSslSocket::setPrivateKey#
    {50, 1026, 1417},	// QSslSocket::setPrivateKey$
    {50, 1027, 1418},	// QSslSocket::setPrivateKey$$
    {50, 1028, 1419},	// QSslSocket::setPrivateKey$$$
    {50, 1029, 1370},	// QSslSocket::setPrivateKey$$$#
    {50, 1031, 1344},	// QSslSocket::setProtocol$
    {50, 1048, 1358},	// QSslSocket::setReadBufferSize$
    {50, 1069, 1414},	// QSslSocket::setSocketDescriptor$
    {50, 1070, 1415},	// QSslSocket::setSocketDescriptor$$
    {50, 1071, 1338},	// QSslSocket::setSocketDescriptor$$$
    {50, 1078, 1339},	// QSslSocket::setSocketOption$#
    {50, 1082, 1362},	// QSslSocket::setSslConfiguration#
    {50, 1115, 1340},	// QSslSocket::socketOption$
    {50, 1117, 1361},	// QSslSocket::sslConfiguration
    {50, 1118, 1394},	// QSslSocket::sslErrors
    {50, 1120, 1402},	// QSslSocket::sslErrors?
    {50, 1121, 1397},	// QSslSocket::startClientEncryption
    {50, 1122, 1398},	// QSslSocket::startServerEncryption
    {50, 1126, 1429},	// QSslSocket::staticMetaObject
    {50, 1133, 1377},	// QSslSocket::supportedCiphers
    {50, 1134, 1395},	// QSslSocket::supportsSsl
    {50, 1135, 1388},	// QSslSocket::systemCaCertificates
    {50, 1151, 1409},	// QSslSocket::tr$
    {50, 1152, 1330},	// QSslSocket::tr$$
    {50, 1153, 1332},	// QSslSocket::tr$$$
    {50, 1155, 1410},	// QSslSocket::trUtf8$
    {50, 1156, 1331},	// QSslSocket::trUtf8$$
    {50, 1157, 1333},	// QSslSocket::trUtf8$$$
    {50, 1172, 1427},	// QSslSocket::waitForBytesWritten
    {50, 1173, 1392},	// QSslSocket::waitForBytesWritten$
    {50, 1174, 1424},	// QSslSocket::waitForConnected
    {50, 1175, 1389},	// QSslSocket::waitForConnected$
    {50, 1176, 1428},	// QSslSocket::waitForDisconnected
    {50, 1177, 1393},	// QSslSocket::waitForDisconnected$
    {50, 1178, 1425},	// QSslSocket::waitForEncrypted
    {50, 1179, 1390},	// QSslSocket::waitForEncrypted$
    {50, 1185, 1426},	// QSslSocket::waitForReadyRead
    {50, 1186, 1391},	// QSslSocket::waitForReadyRead$
    {50, 1188, 1408},	// QSslSocket::writeData$$
    {50, 1227, 1437},	// QSslSocket::~QSslSocket
    {51, 301, 1467},	// QTcpServer::QTcpServer
    {51, 302, 1445},	// QTcpServer::QTcpServer#
    {51, 430, 1463},	// QTcpServer::addPendingConnection#
    {51, 485, 1447},	// QTcpServer::close
    {51, 573, 1459},	// QTcpServer::errorString
    {51, 613, 1456},	// QTcpServer::hasPendingConnections
    {51, 631, 1462},	// QTcpServer::incomingConnection$
    {51, 652, 1448},	// QTcpServer::isListening
    {51, 687, 1468},	// QTcpServer::listen
    {51, 688, 1469},	// QTcpServer::listen#
    {51, 689, 1446},	// QTcpServer::listen#$
    {51, 704, 1450},	// QTcpServer::maxPendingConnections
    {51, 709, 1438},	// QTcpServer::metaObject
    {51, 727, 1464},	// QTcpServer::newConnection
    {51, 728, 1457},	// QTcpServer::nextPendingConnection
    {51, 797, 1461},	// QTcpServer::proxy
    {51, 812, 1444},	// QTcpServer::qt_metacall$$?
    {51, 814, 1439},	// QTcpServer::qt_metacast$
    {51, 875, 1452},	// QTcpServer::serverAddress
    {51, 876, 1458},	// QTcpServer::serverError
    {51, 878, 1451},	// QTcpServer::serverPort
    {51, 976, 1449},	// QTcpServer::setMaxPendingConnections$
    {51, 1035, 1460},	// QTcpServer::setProxy#
    {51, 1069, 1454},	// QTcpServer::setSocketDescriptor$
    {51, 1113, 1453},	// QTcpServer::socketDescriptor
    {51, 1126, 1472},	// QTcpServer::staticMetaObject
    {51, 1151, 1465},	// QTcpServer::tr$
    {51, 1152, 1440},	// QTcpServer::tr$$
    {51, 1153, 1442},	// QTcpServer::tr$$$
    {51, 1155, 1466},	// QTcpServer::trUtf8$
    {51, 1156, 1441},	// QTcpServer::trUtf8$$
    {51, 1157, 1443},	// QTcpServer::trUtf8$$$
    {51, 1180, 1470},	// QTcpServer::waitForNewConnection
    {51, 1181, 1471},	// QTcpServer::waitForNewConnection$
    {51, 1182, 1455},	// QTcpServer::waitForNewConnection$$
    {51, 1228, 1473},	// QTcpServer::~QTcpServer
    {52, 303, 1484},	// QTcpSocket::QTcpSocket
    {52, 304, 1481},	// QTcpSocket::QTcpSocket#
    {52, 709, 1474},	// QTcpSocket::metaObject
    {52, 812, 1480},	// QTcpSocket::qt_metacall$$?
    {52, 814, 1475},	// QTcpSocket::qt_metacast$
    {52, 1126, 1485},	// QTcpSocket::staticMetaObject
    {52, 1151, 1482},	// QTcpSocket::tr$
    {52, 1152, 1476},	// QTcpSocket::tr$$
    {52, 1153, 1478},	// QTcpSocket::tr$$$
    {52, 1155, 1483},	// QTcpSocket::trUtf8$
    {52, 1156, 1477},	// QTcpSocket::trUtf8$$
    {52, 1157, 1479},	// QTcpSocket::trUtf8$$$
    {52, 1229, 1486},	// QTcpSocket::~QTcpSocket
    {54, 75, 1517},	// QUdpSocket::DefaultForPlatform
    {54, 85, 1519},	// QUdpSocket::DontShareAddress
    {54, 305, 1512},	// QUdpSocket::QUdpSocket
    {54, 306, 1494},	// QUdpSocket::QUdpSocket#
    {54, 324, 1520},	// QUdpSocket::ReuseAddressHint
    {54, 340, 1518},	// QUdpSocket::ShareAddress
    {54, 459, 1513},	// QUdpSocket::bind
    {54, 460, 1495},	// QUdpSocket::bind#$
    {54, 461, 1497},	// QUdpSocket::bind#$$
    {54, 462, 1496},	// QUdpSocket::bind$
    {54, 463, 1498},	// QUdpSocket::bind$$
    {54, 614, 1505},	// QUdpSocket::hasPendingDatagrams
    {54, 670, 1499},	// QUdpSocket::joinMulticastGroup#
    {54, 671, 1500},	// QUdpSocket::joinMulticastGroup##
    {54, 678, 1501},	// QUdpSocket::leaveMulticastGroup#
    {54, 679, 1502},	// QUdpSocket::leaveMulticastGroup##
    {54, 709, 1487},	// QUdpSocket::metaObject
    {54, 718, 1503},	// QUdpSocket::multicastInterface
    {54, 779, 1506},	// QUdpSocket::pendingDatagramSize
    {54, 812, 1493},	// QUdpSocket::qt_metacall$$?
    {54, 814, 1488},	// QUdpSocket::qt_metacast$
    {54, 834, 1514},	// QUdpSocket::readDatagram$$
    {54, 835, 1515},	// QUdpSocket::readDatagram$$#
    {54, 836, 1507},	// QUdpSocket::readDatagram$$#$
    {54, 980, 1504},	// QUdpSocket::setMulticastInterface#
    {54, 1126, 1516},	// QUdpSocket::staticMetaObject
    {54, 1151, 1510},	// QUdpSocket::tr$
    {54, 1152, 1489},	// QUdpSocket::tr$$
    {54, 1153, 1491},	// QUdpSocket::tr$$$
    {54, 1155, 1511},	// QUdpSocket::trUtf8$
    {54, 1156, 1490},	// QUdpSocket::trUtf8$$
    {54, 1157, 1492},	// QUdpSocket::trUtf8$$$
    {54, 1190, 1509},	// QUdpSocket::writeDatagram##$
    {54, 1191, 1508},	// QUdpSocket::writeDatagram$$#$
    {54, 1230, 1521},	// QUdpSocket::~QUdpSocket
    {56, 89, 1563},	// QUrlInfo::ExeGroup
    {56, 90, 1566},	// QUrlInfo::ExeOther
    {56, 91, 1560},	// QUrlInfo::ExeOwner
    {56, 307, 1522},	// QUrlInfo::QUrlInfo
    {56, 308, 1523},	// QUrlInfo::QUrlInfo#
    {56, 309, 1525},	// QUrlInfo::QUrlInfo#$$$$##$$$$$$
    {56, 310, 1524},	// QUrlInfo::QUrlInfo$$$$$##$$$$$$
    {56, 313, 1561},	// QUrlInfo::ReadGroup
    {56, 315, 1564},	// QUrlInfo::ReadOther
    {56, 316, 1558},	// QUrlInfo::ReadOwner
    {56, 404, 1562},	// QUrlInfo::WriteGroup
    {56, 406, 1565},	// QUrlInfo::WriteOther
    {56, 407, 1559},	// QUrlInfo::WriteOwner
    {56, 570, 1555},	// QUrlInfo::equal##$
    {56, 604, 1553},	// QUrlInfo::greaterThan##$
    {56, 605, 1543},	// QUrlInfo::group
    {56, 643, 1547},	// QUrlInfo::isDir
    {56, 645, 1552},	// QUrlInfo::isExecutable
    {56, 646, 1548},	// QUrlInfo::isFile
    {56, 656, 1551},	// QUrlInfo::isReadable
    {56, 662, 1549},	// QUrlInfo::isSymLink
    {56, 664, 1539},	// QUrlInfo::isValid
    {56, 665, 1550},	// QUrlInfo::isWritable
    {56, 674, 1545},	// QUrlInfo::lastModified
    {56, 675, 1546},	// QUrlInfo::lastRead
    {56, 682, 1554},	// QUrlInfo::lessThan##$
    {56, 719, 1540},	// QUrlInfo::name
    {56, 735, 1557},	// QUrlInfo::operator!=#
    {56, 741, 1526},	// QUrlInfo::operator=#
    {56, 744, 1556},	// QUrlInfo::operator==#
    {56, 757, 1542},	// QUrlInfo::owner
    {56, 780, 1541},	// QUrlInfo::permissions
    {56, 933, 1528},	// QUrlInfo::setDir$
    {56, 944, 1529},	// QUrlInfo::setFile$
    {56, 948, 1532},	// QUrlInfo::setGroup$
    {56, 962, 1537},	// QUrlInfo::setLastModified#
    {56, 964, 1538},	// QUrlInfo::setLastRead#
    {56, 983, 1527},	// QUrlInfo::setName$
    {56, 997, 1531},	// QUrlInfo::setOwner$
    {56, 1017, 1536},	// QUrlInfo::setPermissions$
    {56, 1050, 1535},	// QUrlInfo::setReadable$
    {56, 1065, 1533},	// QUrlInfo::setSize$
    {56, 1091, 1530},	// QUrlInfo::setSymLink$
    {56, 1111, 1534},	// QUrlInfo::setWritable$
    {56, 1112, 1544},	// QUrlInfo::size
    {56, 1231, 1567},	// QUrlInfo::~QUrlInfo
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();

static bool initialized = false;
Smoke *qtnetwork_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qtnetwork_Smoke() {
    init_qtcore_Smoke();
    if (initialized) return;
    qtnetwork_Smoke = new Smoke(
        "qtnetwork",
        __smokeqtnetwork::classes, 58,
        __smokeqtnetwork::methods, 1568,
        __smokeqtnetwork::methodMaps, 1474,
        __smokeqtnetwork::methodNames, 1231,
        __smokeqtnetwork::types, 315,
        __smokeqtnetwork::inheritanceList,
        __smokeqtnetwork::argumentList,
        __smokeqtnetwork::ambiguousMethodList,
        __smokeqtnetwork::cast );
    initialized = true;
}

void delete_qtnetwork_Smoke() { delete qtnetwork_Smoke; }

}
