#include <qtmultimedia_includes.h>

#include <smoke.h>
#include <qtmultimedia_smoke.h>

namespace __smokeqtmultimedia {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QAbstractVideoBuffer
      switch(to) {
        case 1: return (void*)(QAbstractVideoBuffer*)xptr;
        default: return xptr;
      }
    case 2:   //QAbstractVideoSurface
      switch(to) {
        case 36: return (void*)(QObject*)(QAbstractVideoSurface*)xptr;
        case 2: return (void*)(QAbstractVideoSurface*)xptr;
        default: return xptr;
      }
    case 3:   //QAccessible2Interface
      switch(to) {
        case 3: return (void*)(QAccessible2Interface*)xptr;
        default: return xptr;
      }
    case 5:   //QAudioDeviceInfo
      switch(to) {
        case 5: return (void*)(QAudioDeviceInfo*)xptr;
        default: return xptr;
      }
    case 6:   //QAudioFormat
      switch(to) {
        case 6: return (void*)(QAudioFormat*)xptr;
        default: return xptr;
      }
    case 7:   //QAudioInput
      switch(to) {
        case 36: return (void*)(QObject*)(QAudioInput*)xptr;
        case 7: return (void*)(QAudioInput*)xptr;
        default: return xptr;
      }
    case 8:   //QAudioOutput
      switch(to) {
        case 36: return (void*)(QObject*)(QAudioOutput*)xptr;
        case 8: return (void*)(QAudioOutput*)xptr;
        default: return xptr;
      }
    case 9:   //QBool
      switch(to) {
        case 9: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 10:   //QBrush
      switch(to) {
        case 10: return (void*)(QBrush*)xptr;
        default: return xptr;
      }
    case 11:   //QByteArray
      switch(to) {
        case 11: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 12:   //QChildEvent
      switch(to) {
        case 17: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 12: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 13:   //QColor
      switch(to) {
        case 13: return (void*)(QColor*)xptr;
        default: return xptr;
      }
    case 14:   //QCursor
      switch(to) {
        case 14: return (void*)(QCursor*)xptr;
        default: return xptr;
      }
    case 15:   //QDataStream
      switch(to) {
        case 15: return (void*)(QDataStream*)xptr;
        default: return xptr;
      }
    case 16:   //QDebug
      switch(to) {
        case 16: return (void*)(QDebug*)xptr;
        default: return xptr;
      }
    case 17:   //QEvent
      switch(to) {
        case 17: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 18:   //QFont
      switch(to) {
        case 18: return (void*)(QFont*)xptr;
        default: return xptr;
      }
    case 20:   //QGraphicsItem
      switch(to) {
        case 20: return (void*)(QGraphicsItem*)xptr;
        default: return xptr;
      }
    case 21:   //QGraphicsObject
      switch(to) {
        case 36: return (void*)(QObject*)(QGraphicsObject*)xptr;
        case 20: return (void*)(QGraphicsItem*)(QGraphicsObject*)xptr;
        case 21: return (void*)(QGraphicsObject*)xptr;
        default: return xptr;
      }
    case 22:   //QIODevice
      switch(to) {
        case 36: return (void*)(QObject*)(QIODevice*)xptr;
        case 22: return (void*)(QIODevice*)xptr;
        default: return xptr;
      }
    case 23:   //QIcon
      switch(to) {
        case 23: return (void*)(QIcon*)xptr;
        default: return xptr;
      }
    case 24:   //QImage
      switch(to) {
        case 24: return (void*)(QImage*)xptr;
        default: return xptr;
      }
    case 25:   //QIncompatibleFlag
      switch(to) {
        case 25: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 26:   //QItemSelectionRange
      switch(to) {
        case 26: return (void*)(QItemSelectionRange*)xptr;
        default: return xptr;
      }
    case 27:   //QKeyEvent
      switch(to) {
        case 17: return (void*)(QEvent*)(QKeyEvent*)xptr;
        case 27: return (void*)(QKeyEvent*)xptr;
        default: return xptr;
      }
    case 28:   //QKeySequence
      switch(to) {
        case 28: return (void*)(QKeySequence*)xptr;
        default: return xptr;
      }
    case 29:   //QLine
      switch(to) {
        case 29: return (void*)(QLine*)xptr;
        default: return xptr;
      }
    case 30:   //QLineF
      switch(to) {
        case 30: return (void*)(QLineF*)xptr;
        default: return xptr;
      }
    case 31:   //QListWidgetItem
      switch(to) {
        case 31: return (void*)(QListWidgetItem*)xptr;
        default: return xptr;
      }
    case 32:   //QMargins
      switch(to) {
        case 32: return (void*)(QMargins*)xptr;
        default: return xptr;
      }
    case 33:   //QMatrix
      switch(to) {
        case 33: return (void*)(QMatrix*)xptr;
        default: return xptr;
      }
    case 34:   //QMatrix4x4
      switch(to) {
        case 34: return (void*)(QMatrix4x4*)xptr;
        default: return xptr;
      }
    case 35:   //QMetaObject
      switch(to) {
        case 35: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 36:   //QObject
      switch(to) {
        case 36: return (void*)(QObject*)xptr;
        case 7: return (void*)(QAudioInput*)(QObject*)xptr;
        case 8: return (void*)(QAudioOutput*)(QObject*)xptr;
        case 2: return (void*)(QAbstractVideoSurface*)(QObject*)xptr;
        default: return xptr;
      }
    case 37:   //QPainter
      switch(to) {
        case 37: return (void*)(QPainter*)xptr;
        default: return xptr;
      }
    case 38:   //QPainterPath
      switch(to) {
        case 38: return (void*)(QPainterPath*)xptr;
        default: return xptr;
      }
    case 39:   //QPalette
      switch(to) {
        case 39: return (void*)(QPalette*)xptr;
        default: return xptr;
      }
    case 40:   //QPen
      switch(to) {
        case 40: return (void*)(QPen*)xptr;
        default: return xptr;
      }
    case 41:   //QPicture
      switch(to) {
        case 41: return (void*)(QPicture*)xptr;
        default: return xptr;
      }
    case 42:   //QPixmap
      switch(to) {
        case 42: return (void*)(QPixmap*)xptr;
        default: return xptr;
      }
    case 43:   //QPoint
      switch(to) {
        case 43: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 44:   //QPointF
      switch(to) {
        case 44: return (void*)(QPointF*)xptr;
        default: return xptr;
      }
    case 45:   //QPolygon
      switch(to) {
        case 45: return (void*)(QPolygon*)xptr;
        default: return xptr;
      }
    case 46:   //QPolygonF
      switch(to) {
        case 46: return (void*)(QPolygonF*)xptr;
        default: return xptr;
      }
    case 47:   //QQuaternion
      switch(to) {
        case 47: return (void*)(QQuaternion*)xptr;
        default: return xptr;
      }
    case 48:   //QRect
      switch(to) {
        case 48: return (void*)(QRect*)xptr;
        default: return xptr;
      }
    case 49:   //QRegExp
      switch(to) {
        case 49: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 50:   //QRegion
      switch(to) {
        case 50: return (void*)(QRegion*)xptr;
        default: return xptr;
      }
    case 51:   //QSize
      switch(to) {
        case 51: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 52:   //QSizePolicy
      switch(to) {
        case 52: return (void*)(QSizePolicy*)xptr;
        default: return xptr;
      }
    case 53:   //QSplitter
      switch(to) {
        case 36: return (void*)(QObject*)(QSplitter*)xptr;
        case 53: return (void*)(QSplitter*)xptr;
        default: return xptr;
      }
    case 54:   //QStandardItem
      switch(to) {
        case 54: return (void*)(QStandardItem*)xptr;
        default: return xptr;
      }
    case 55:   //QStyleOption
      switch(to) {
        case 55: return (void*)(QStyleOption*)xptr;
        default: return xptr;
      }
    case 56:   //QTableWidgetItem
      switch(to) {
        case 56: return (void*)(QTableWidgetItem*)xptr;
        default: return xptr;
      }
    case 57:   //QTextCodec
      switch(to) {
        case 57: return (void*)(QTextCodec*)xptr;
        default: return xptr;
      }
    case 58:   //QTextFormat
      switch(to) {
        case 58: return (void*)(QTextFormat*)xptr;
        default: return xptr;
      }
    case 59:   //QTextLength
      switch(to) {
        case 59: return (void*)(QTextLength*)xptr;
        default: return xptr;
      }
    case 60:   //QTextStream
      switch(to) {
        case 60: return (void*)(QTextStream*)xptr;
        default: return xptr;
      }
    case 61:   //QTileRules
      switch(to) {
        case 61: return (void*)(QTileRules*)xptr;
        default: return xptr;
      }
    case 62:   //QTimerEvent
      switch(to) {
        case 17: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 62: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 63:   //QTransform
      switch(to) {
        case 63: return (void*)(QTransform*)xptr;
        default: return xptr;
      }
    case 64:   //QTreeWidgetItem
      switch(to) {
        case 64: return (void*)(QTreeWidgetItem*)xptr;
        default: return xptr;
      }
    case 65:   //QVariant
      switch(to) {
        case 65: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 66:   //QVector2D
      switch(to) {
        case 66: return (void*)(QVector2D*)xptr;
        default: return xptr;
      }
    case 67:   //QVector3D
      switch(to) {
        case 67: return (void*)(QVector3D*)xptr;
        default: return xptr;
      }
    case 68:   //QVector4D
      switch(to) {
        case 68: return (void*)(QVector4D*)xptr;
        default: return xptr;
      }
    case 69:   //QVideoFrame
      switch(to) {
        case 69: return (void*)(QVideoFrame*)xptr;
        default: return xptr;
      }
    case 70:   //QVideoSurfaceFormat
      switch(to) {
        case 70: return (void*)(QVideoSurfaceFormat*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    36, 0,	// 1: QObject
};

// These are the xenum functions for manipulating enum pointers
void xenum_QAudio(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QVideoFrame(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QAudioFormat(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QVideoSurfaceFormat(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QAbstractVideoBuffer(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QAbstractVideoSurface(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QAbstractVideoBuffer(Smoke::Index, void*, Smoke::Stack);
void xcall_QAbstractVideoSurface(Smoke::Index, void*, Smoke::Stack);
void xcall_QAudio(Smoke::Index, void*, Smoke::Stack);
void xcall_QAudioDeviceInfo(Smoke::Index, void*, Smoke::Stack);
void xcall_QAudioFormat(Smoke::Index, void*, Smoke::Stack);
void xcall_QAudioInput(Smoke::Index, void*, Smoke::Stack);
void xcall_QAudioOutput(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_QVideoFrame(Smoke::Index, void*, Smoke::Stack);
void xcall_QVideoSurfaceFormat(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QAbstractVideoBuffer", false, 0, xcall_QAbstractVideoBuffer, xenum_QAbstractVideoBuffer, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QAbstractVideoBuffer) },	//1
    { "QAbstractVideoSurface", false, 1, xcall_QAbstractVideoSurface, xenum_QAbstractVideoSurface, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QAbstractVideoSurface) },	//2
    { "QAccessible2Interface", true, 0, 0, 0, 0, 0 },	//3
    { "QAudio", false, 0, xcall_QAudio, xenum_QAudio, Smoke::cf_namespace, 0 },	//4
    { "QAudioDeviceInfo", false, 0, xcall_QAudioDeviceInfo, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QAudioDeviceInfo) },	//5
    { "QAudioFormat", false, 0, xcall_QAudioFormat, xenum_QAudioFormat, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QAudioFormat) },	//6
    { "QAudioInput", false, 1, xcall_QAudioInput, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QAudioInput) },	//7
    { "QAudioOutput", false, 1, xcall_QAudioOutput, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QAudioOutput) },	//8
    { "QBool", true, 0, 0, 0, 0, 0 },	//9
    { "QBrush", true, 0, 0, 0, 0, 0 },	//10
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//11
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//12
    { "QColor", true, 0, 0, 0, 0, 0 },	//13
    { "QCursor", true, 0, 0, 0, 0, 0 },	//14
    { "QDataStream", true, 0, 0, 0, 0, 0 },	//15
    { "QDebug", true, 0, 0, 0, 0, 0 },	//16
    { "QEvent", true, 0, 0, 0, 0, 0 },	//17
    { "QFont", true, 0, 0, 0, 0, 0 },	//18
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//19
    { "QGraphicsItem", true, 0, 0, 0, 0, 0 },	//20
    { "QGraphicsObject", true, 0, 0, 0, 0, 0 },	//21
    { "QIODevice", true, 0, 0, 0, 0, 0 },	//22
    { "QIcon", true, 0, 0, 0, 0, 0 },	//23
    { "QImage", true, 0, 0, 0, 0, 0 },	//24
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//25
    { "QItemSelectionRange", true, 0, 0, 0, 0, 0 },	//26
    { "QKeyEvent", true, 0, 0, 0, 0, 0 },	//27
    { "QKeySequence", true, 0, 0, 0, 0, 0 },	//28
    { "QLine", true, 0, 0, 0, 0, 0 },	//29
    { "QLineF", true, 0, 0, 0, 0, 0 },	//30
    { "QListWidgetItem", true, 0, 0, 0, 0, 0 },	//31
    { "QMargins", true, 0, 0, 0, 0, 0 },	//32
    { "QMatrix", true, 0, 0, 0, 0, 0 },	//33
    { "QMatrix4x4", true, 0, 0, 0, 0, 0 },	//34
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//35
    { "QObject", true, 0, 0, 0, 0, 0 },	//36
    { "QPainter", true, 0, 0, 0, 0, 0 },	//37
    { "QPainterPath", true, 0, 0, 0, 0, 0 },	//38
    { "QPalette", true, 0, 0, 0, 0, 0 },	//39
    { "QPen", true, 0, 0, 0, 0, 0 },	//40
    { "QPicture", true, 0, 0, 0, 0, 0 },	//41
    { "QPixmap", true, 0, 0, 0, 0, 0 },	//42
    { "QPoint", true, 0, 0, 0, 0, 0 },	//43
    { "QPointF", true, 0, 0, 0, 0, 0 },	//44
    { "QPolygon", true, 0, 0, 0, 0, 0 },	//45
    { "QPolygonF", true, 0, 0, 0, 0, 0 },	//46
    { "QQuaternion", true, 0, 0, 0, 0, 0 },	//47
    { "QRect", true, 0, 0, 0, 0, 0 },	//48
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//49
    { "QRegion", true, 0, 0, 0, 0, 0 },	//50
    { "QSize", true, 0, 0, 0, 0, 0 },	//51
    { "QSizePolicy", true, 0, 0, 0, 0, 0 },	//52
    { "QSplitter", true, 0, 0, 0, 0, 0 },	//53
    { "QStandardItem", true, 0, 0, 0, 0, 0 },	//54
    { "QStyleOption", true, 0, 0, 0, 0, 0 },	//55
    { "QTableWidgetItem", true, 0, 0, 0, 0, 0 },	//56
    { "QTextCodec", true, 0, 0, 0, 0, 0 },	//57
    { "QTextFormat", true, 0, 0, 0, 0, 0 },	//58
    { "QTextLength", true, 0, 0, 0, 0, 0 },	//59
    { "QTextStream", true, 0, 0, 0, 0, 0 },	//60
    { "QTileRules", true, 0, 0, 0, 0, 0 },	//61
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//62
    { "QTransform", true, 0, 0, 0, 0, 0 },	//63
    { "QTreeWidgetItem", true, 0, 0, 0, 0, 0 },	//64
    { "QVariant", true, 0, 0, 0, 0, 0 },	//65
    { "QVector2D", true, 0, 0, 0, 0, 0 },	//66
    { "QVector3D", true, 0, 0, 0, 0, 0 },	//67
    { "QVector4D", true, 0, 0, 0, 0, 0 },	//68
    { "QVideoFrame", false, 0, xcall_QVideoFrame, xenum_QVideoFrame, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QVideoFrame) },	//69
    { "QVideoSurfaceFormat", false, 0, xcall_QVideoSurfaceFormat, xenum_QVideoSurfaceFormat, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QVideoSurfaceFormat) },	//70
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QAbstractItemView::EditTrigger", 0, Smoke::t_enum|Smoke::tf_stack },	//1
    { "QAbstractPrintDialog::PrintDialogOption", 0, Smoke::t_enum|Smoke::tf_stack },	//2
    { "QAbstractSpinBox::StepEnabledFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//3
    { "QAbstractVideoBuffer*", 1, Smoke::t_class|Smoke::tf_ptr },	//4
    { "QAbstractVideoBuffer::HandleType", 1, Smoke::t_enum|Smoke::tf_stack },	//5
    { "QAbstractVideoBuffer::MapMode", 1, Smoke::t_enum|Smoke::tf_stack },	//6
    { "QAbstractVideoSurface*", 2, Smoke::t_class|Smoke::tf_ptr },	//7
    { "QAbstractVideoSurface::Error", 2, Smoke::t_enum|Smoke::tf_stack },	//8
    { "QAccessible2::BoundaryType", 0, Smoke::t_enum|Smoke::tf_stack },	//9
    { "QAccessible2::CoordinateType", 0, Smoke::t_enum|Smoke::tf_stack },	//10
    { "QAccessible2::InterfaceType", 0, Smoke::t_enum|Smoke::tf_stack },	//11
    { "QAccessible2::TableModelChangeType", 0, Smoke::t_enum|Smoke::tf_stack },	//12
    { "QAccessible2Interface*", 3, Smoke::t_class|Smoke::tf_ptr },	//13
    { "QAccessible::RelationFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//14
    { "QAccessible::StateFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//15
    { "QAudio::Error", 4, Smoke::t_enum|Smoke::tf_stack },	//16
    { "QAudio::Mode", 4, Smoke::t_enum|Smoke::tf_stack },	//17
    { "QAudio::State", 4, Smoke::t_enum|Smoke::tf_stack },	//18
    { "QAudioDeviceInfo", 5, Smoke::t_class|Smoke::tf_stack },	//19
    { "QAudioDeviceInfo&", 5, Smoke::t_class|Smoke::tf_ref },	//20
    { "QAudioDeviceInfo*", 5, Smoke::t_class|Smoke::tf_ptr },	//21
    { "QAudioFormat", 6, Smoke::t_class|Smoke::tf_stack },	//22
    { "QAudioFormat&", 6, Smoke::t_class|Smoke::tf_ref },	//23
    { "QAudioFormat*", 6, Smoke::t_class|Smoke::tf_ptr },	//24
    { "QAudioFormat::Endian", 6, Smoke::t_enum|Smoke::tf_stack },	//25
    { "QAudioFormat::SampleType", 6, Smoke::t_enum|Smoke::tf_stack },	//26
    { "QAudioInput*", 7, Smoke::t_class|Smoke::tf_ptr },	//27
    { "QAudioOutput*", 8, Smoke::t_class|Smoke::tf_ptr },	//28
    { "QBool", 9, Smoke::t_class|Smoke::tf_stack },	//29
    { "QBrush&", 10, Smoke::t_class|Smoke::tf_ref },	//30
    { "QByteArray", 11, Smoke::t_class|Smoke::tf_stack },	//31
    { "QChildEvent*", 12, Smoke::t_class|Smoke::tf_ptr },	//32
    { "QColor&", 13, Smoke::t_class|Smoke::tf_ref },	//33
    { "QColorDialog::ColorDialogOption", 0, Smoke::t_enum|Smoke::tf_stack },	//34
    { "QCursor&", 14, Smoke::t_class|Smoke::tf_ref },	//35
    { "QDataStream&", 15, Smoke::t_class|Smoke::tf_ref },	//36
    { "QDateTimeEdit::Section", 0, Smoke::t_enum|Smoke::tf_stack },	//37
    { "QDebug", 16, Smoke::t_class|Smoke::tf_stack },	//38
    { "QDialogButtonBox::StandardButton", 0, Smoke::t_enum|Smoke::tf_stack },	//39
    { "QDockWidget::DockWidgetFeature", 0, Smoke::t_enum|Smoke::tf_stack },	//40
    { "QDrawBorderPixmap::DrawingHint", 0, Smoke::t_enum|Smoke::tf_stack },	//41
    { "QEvent*", 17, Smoke::t_class|Smoke::tf_ptr },	//42
    { "QFileDialog::Option", 0, Smoke::t_enum|Smoke::tf_stack },	//43
    { "QFlags<QAbstractItemView::EditTrigger>", 0, Smoke::t_uint|Smoke::tf_stack },	//44
    { "QFlags<QAbstractPrintDialog::PrintDialogOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//45
    { "QFlags<QAbstractSpinBox::StepEnabledFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//46
    { "QFlags<QAccessible::RelationFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//47
    { "QFlags<QAccessible::StateFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//48
    { "QFlags<QColorDialog::ColorDialogOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//49
    { "QFlags<QDateTimeEdit::Section>", 0, Smoke::t_uint|Smoke::tf_stack },	//50
    { "QFlags<QDialogButtonBox::StandardButton>", 0, Smoke::t_uint|Smoke::tf_stack },	//51
    { "QFlags<QDockWidget::DockWidgetFeature>", 0, Smoke::t_uint|Smoke::tf_stack },	//52
    { "QFlags<QDrawBorderPixmap::DrawingHint>", 0, Smoke::t_uint|Smoke::tf_stack },	//53
    { "QFlags<QFileDialog::Option>", 0, Smoke::t_uint|Smoke::tf_stack },	//54
    { "QFlags<QFontComboBox::FontFilter>", 0, Smoke::t_uint|Smoke::tf_stack },	//55
    { "QFlags<QFontDialog::FontDialogOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//56
    { "QFlags<QGestureRecognizer::ResultFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//57
    { "QFlags<QGraphicsBlurEffect::BlurHint>", 0, Smoke::t_uint|Smoke::tf_stack },	//58
    { "QFlags<QGraphicsEffect::ChangeFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//59
    { "QFlags<QGraphicsItem::GraphicsItemFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//60
    { "QFlags<QGraphicsScene::SceneLayer>", 0, Smoke::t_uint|Smoke::tf_stack },	//61
    { "QFlags<QGraphicsView::CacheModeFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//62
    { "QFlags<QGraphicsView::OptimizationFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//63
    { "QFlags<QImageIOPlugin::Capability>", 0, Smoke::t_uint|Smoke::tf_stack },	//64
    { "QFlags<QInputDialog::InputDialogOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//65
    { "QFlags<QItemSelectionModel::SelectionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//66
    { "QFlags<QMainWindow::DockOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//67
    { "QFlags<QMdiArea::AreaOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//68
    { "QFlags<QMdiSubWindow::SubWindowOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//69
    { "QFlags<QMessageBox::StandardButton>", 0, Smoke::t_uint|Smoke::tf_stack },	//70
    { "QFlags<QPaintEngine::DirtyFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//71
    { "QFlags<QPaintEngine::PaintEngineFeature>", 0, Smoke::t_uint|Smoke::tf_stack },	//72
    { "QFlags<QPainter::RenderHint>", 0, Smoke::t_uint|Smoke::tf_stack },	//73
    { "QFlags<QPinchGesture::ChangeFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//74
    { "QFlags<QSizePolicy::ControlType>", 0, Smoke::t_uint|Smoke::tf_stack },	//75
    { "QFlags<QStyle::StateFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//76
    { "QFlags<QStyle::SubControl>", 0, Smoke::t_uint|Smoke::tf_stack },	//77
    { "QFlags<QStyleOptionButton::ButtonFeature>", 0, Smoke::t_uint|Smoke::tf_stack },	//78
    { "QFlags<QStyleOptionFrameV2::FrameFeature>", 0, Smoke::t_uint|Smoke::tf_stack },	//79
    { "QFlags<QStyleOptionQ3ListViewItem::Q3ListViewItemFeature>", 0, Smoke::t_uint|Smoke::tf_stack },	//80
    { "QFlags<QStyleOptionTab::CornerWidget>", 0, Smoke::t_uint|Smoke::tf_stack },	//81
    { "QFlags<QStyleOptionToolBar::ToolBarFeature>", 0, Smoke::t_uint|Smoke::tf_stack },	//82
    { "QFlags<QStyleOptionToolButton::ToolButtonFeature>", 0, Smoke::t_uint|Smoke::tf_stack },	//83
    { "QFlags<QStyleOptionViewItemV2::ViewItemFeature>", 0, Smoke::t_uint|Smoke::tf_stack },	//84
    { "QFlags<QTextDocument::FindFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//85
    { "QFlags<QTextEdit::AutoFormattingFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//86
    { "QFlags<QTextFormat::PageBreakFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//87
    { "QFlags<QTextItem::RenderFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//88
    { "QFlags<QTextOption::Flag>", 0, Smoke::t_uint|Smoke::tf_stack },	//89
    { "QFlags<QTreeWidgetItemIterator::IteratorFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//90
    { "QFlags<QWidget::RenderFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//91
    { "QFlags<QWizard::WizardOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//92
    { "QFont&", 18, Smoke::t_class|Smoke::tf_ref },	//93
    { "QFontComboBox::FontFilter", 0, Smoke::t_enum|Smoke::tf_stack },	//94
    { "QFontDialog::FontDialogOption", 0, Smoke::t_enum|Smoke::tf_stack },	//95
    { "QGestureRecognizer::ResultFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//96
    { "QGraphicsBlurEffect::BlurHint", 0, Smoke::t_enum|Smoke::tf_stack },	//97
    { "QGraphicsEffect::ChangeFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//98
    { "QGraphicsItem*", 20, Smoke::t_class|Smoke::tf_ptr },	//99
    { "QGraphicsItem::GraphicsItemChange", 20, Smoke::t_enum|Smoke::tf_stack },	//100
    { "QGraphicsItem::GraphicsItemFlag", 20, Smoke::t_enum|Smoke::tf_stack },	//101
    { "QGraphicsObject*", 21, Smoke::t_class|Smoke::tf_ptr },	//102
    { "QGraphicsScene::SceneLayer", 0, Smoke::t_enum|Smoke::tf_stack },	//103
    { "QGraphicsView::CacheModeFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//104
    { "QGraphicsView::OptimizationFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//105
    { "QIODevice*", 22, Smoke::t_class|Smoke::tf_ptr },	//106
    { "QIcon&", 23, Smoke::t_class|Smoke::tf_ref },	//107
    { "QImage&", 24, Smoke::t_class|Smoke::tf_ref },	//108
    { "QImage::Format", 24, Smoke::t_enum|Smoke::tf_stack },	//109
    { "QImageIOPlugin::Capability", 0, Smoke::t_enum|Smoke::tf_stack },	//110
    { "QIncompatibleFlag", 25, Smoke::t_class|Smoke::tf_stack },	//111
    { "QInputDialog::InputDialogOption", 0, Smoke::t_enum|Smoke::tf_stack },	//112
    { "QItemSelectionModel::SelectionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//113
    { "QKeyEvent*", 27, Smoke::t_class|Smoke::tf_ptr },	//114
    { "QKeySequence&", 28, Smoke::t_class|Smoke::tf_ref },	//115
    { "QKeySequence::StandardKey", 28, Smoke::t_enum|Smoke::tf_stack },	//116
    { "QLine", 29, Smoke::t_class|Smoke::tf_stack },	//117
    { "QLineF", 30, Smoke::t_class|Smoke::tf_stack },	//118
    { "QList<QAudioDeviceInfo>", 0, Smoke::t_voidp|Smoke::tf_stack },	//119
    { "QList<QAudioFormat::Endian>", 0, Smoke::t_voidp|Smoke::tf_stack },	//120
    { "QList<QAudioFormat::SampleType>", 0, Smoke::t_voidp|Smoke::tf_stack },	//121
    { "QList<QByteArray>", 0, Smoke::t_voidp|Smoke::tf_stack },	//122
    { "QList<QVideoFrame::PixelFormat>", 0, Smoke::t_voidp|Smoke::tf_stack },	//123
    { "QList<int>", 0, Smoke::t_voidp|Smoke::tf_stack },	//124
    { "QListWidgetItem&", 31, Smoke::t_class|Smoke::tf_ref },	//125
    { "QMainWindow::DockOption", 0, Smoke::t_enum|Smoke::tf_stack },	//126
    { "QMatrix&", 33, Smoke::t_class|Smoke::tf_ref },	//127
    { "QMatrix4x4", 34, Smoke::t_class|Smoke::tf_stack },	//128
    { "QMatrix4x4&", 34, Smoke::t_class|Smoke::tf_ref },	//129
    { "QMdiArea::AreaOption", 0, Smoke::t_enum|Smoke::tf_stack },	//130
    { "QMdiSubWindow::SubWindowOption", 0, Smoke::t_enum|Smoke::tf_stack },	//131
    { "QMessageBox::StandardButton", 0, Smoke::t_enum|Smoke::tf_stack },	//132
    { "QMetaObject::Call", 35, Smoke::t_enum|Smoke::tf_stack },	//133
    { "QObject*", 36, Smoke::t_class|Smoke::tf_ptr },	//134
    { "QPaintEngine::DirtyFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//135
    { "QPaintEngine::PaintEngineFeature", 0, Smoke::t_enum|Smoke::tf_stack },	//136
    { "QPainter*", 37, Smoke::t_class|Smoke::tf_ptr },	//137
    { "QPainter::RenderHint", 37, Smoke::t_enum|Smoke::tf_stack },	//138
    { "QPainterPath", 38, Smoke::t_class|Smoke::tf_stack },	//139
    { "QPainterPath&", 38, Smoke::t_class|Smoke::tf_ref },	//140
    { "QPalette&", 39, Smoke::t_class|Smoke::tf_ref },	//141
    { "QPen&", 40, Smoke::t_class|Smoke::tf_ref },	//142
    { "QPicture&", 41, Smoke::t_class|Smoke::tf_ref },	//143
    { "QPinchGesture::ChangeFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//144
    { "QPixmap&", 42, Smoke::t_class|Smoke::tf_ref },	//145
    { "QPoint", 43, Smoke::t_class|Smoke::tf_stack },	//146
    { "QPointF", 44, Smoke::t_class|Smoke::tf_stack },	//147
    { "QPolygon", 45, Smoke::t_class|Smoke::tf_stack },	//148
    { "QPolygon&", 45, Smoke::t_class|Smoke::tf_ref },	//149
    { "QPolygonF", 46, Smoke::t_class|Smoke::tf_stack },	//150
    { "QPolygonF&", 46, Smoke::t_class|Smoke::tf_ref },	//151
    { "QQuaternion&", 47, Smoke::t_class|Smoke::tf_ref },	//152
    { "QRect", 48, Smoke::t_class|Smoke::tf_stack },	//153
    { "QRegExp&", 49, Smoke::t_class|Smoke::tf_ref },	//154
    { "QRegion", 50, Smoke::t_class|Smoke::tf_stack },	//155
    { "QRegion&", 50, Smoke::t_class|Smoke::tf_ref },	//156
    { "QSize", 51, Smoke::t_class|Smoke::tf_stack },	//157
    { "QSizePolicy&", 52, Smoke::t_class|Smoke::tf_ref },	//158
    { "QSizePolicy::ControlType", 52, Smoke::t_enum|Smoke::tf_stack },	//159
    { "QSplitter&", 53, Smoke::t_class|Smoke::tf_ref },	//160
    { "QStandardItem&", 54, Smoke::t_class|Smoke::tf_ref },	//161
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//162
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//163
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//164
    { "QStyle::StateFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//165
    { "QStyle::SubControl", 0, Smoke::t_enum|Smoke::tf_stack },	//166
    { "QStyleOptionButton::ButtonFeature", 0, Smoke::t_enum|Smoke::tf_stack },	//167
    { "QStyleOptionFrameV2::FrameFeature", 0, Smoke::t_enum|Smoke::tf_stack },	//168
    { "QStyleOptionQ3ListViewItem::Q3ListViewItemFeature", 0, Smoke::t_enum|Smoke::tf_stack },	//169
    { "QStyleOptionTab::CornerWidget", 0, Smoke::t_enum|Smoke::tf_stack },	//170
    { "QStyleOptionToolBar::ToolBarFeature", 0, Smoke::t_enum|Smoke::tf_stack },	//171
    { "QStyleOptionToolButton::ToolButtonFeature", 0, Smoke::t_enum|Smoke::tf_stack },	//172
    { "QStyleOptionViewItemV2::ViewItemFeature", 0, Smoke::t_enum|Smoke::tf_stack },	//173
    { "QTableWidgetItem&", 56, Smoke::t_class|Smoke::tf_ref },	//174
    { "QTextCodec*", 57, Smoke::t_class|Smoke::tf_ptr },	//175
    { "QTextDocument::FindFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//176
    { "QTextEdit::AutoFormattingFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//177
    { "QTextFormat&", 58, Smoke::t_class|Smoke::tf_ref },	//178
    { "QTextFormat::PageBreakFlag", 58, Smoke::t_enum|Smoke::tf_stack },	//179
    { "QTextItem::RenderFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//180
    { "QTextLength&", 59, Smoke::t_class|Smoke::tf_ref },	//181
    { "QTextOption::Flag", 0, Smoke::t_enum|Smoke::tf_stack },	//182
    { "QTextStream&", 60, Smoke::t_class|Smoke::tf_ref },	//183
    { "QTimerEvent*", 62, Smoke::t_class|Smoke::tf_ptr },	//184
    { "QTransform", 63, Smoke::t_class|Smoke::tf_stack },	//185
    { "QTransform&", 63, Smoke::t_class|Smoke::tf_ref },	//186
    { "QTreeWidgetItem&", 64, Smoke::t_class|Smoke::tf_ref },	//187
    { "QTreeWidgetItemIterator::IteratorFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//188
    { "QVariant", 65, Smoke::t_class|Smoke::tf_stack },	//189
    { "QVector2D&", 66, Smoke::t_class|Smoke::tf_ref },	//190
    { "QVector3D", 67, Smoke::t_class|Smoke::tf_stack },	//191
    { "QVector3D&", 67, Smoke::t_class|Smoke::tf_ref },	//192
    { "QVector4D", 68, Smoke::t_class|Smoke::tf_stack },	//193
    { "QVector4D&", 68, Smoke::t_class|Smoke::tf_ref },	//194
    { "QVideoFrame&", 69, Smoke::t_class|Smoke::tf_ref },	//195
    { "QVideoFrame*", 69, Smoke::t_class|Smoke::tf_ptr },	//196
    { "QVideoFrame::FieldType", 69, Smoke::t_enum|Smoke::tf_stack },	//197
    { "QVideoFrame::PixelFormat", 69, Smoke::t_enum|Smoke::tf_stack },	//198
    { "QVideoSurfaceFormat", 70, Smoke::t_class|Smoke::tf_stack },	//199
    { "QVideoSurfaceFormat&", 70, Smoke::t_class|Smoke::tf_ref },	//200
    { "QVideoSurfaceFormat*", 70, Smoke::t_class|Smoke::tf_ptr },	//201
    { "QVideoSurfaceFormat::Direction", 70, Smoke::t_enum|Smoke::tf_stack },	//202
    { "QVideoSurfaceFormat::YCbCrColorSpace", 70, Smoke::t_enum|Smoke::tf_stack },	//203
    { "QWidget::RenderFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//204
    { "QWizard::WizardOption", 0, Smoke::t_enum|Smoke::tf_stack },	//205
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//206
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//207
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//208
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//209
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//210
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//211
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//212
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//213
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//214
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//215
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//216
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//217
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//218
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//219
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//220
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//221
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//222
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//223
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//224
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//225
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//226
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//227
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//228
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//229
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//230
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//231
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//232
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//233
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//234
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//235
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//236
    { "Qt::HitTestAccuracy", 0, Smoke::t_enum|Smoke::tf_stack },	//237
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//238
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//239
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//240
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//241
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//242
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//243
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//244
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//245
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//246
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//247
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//248
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//249
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//250
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//251
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//252
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//253
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//254
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//255
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//256
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//257
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//258
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//259
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//260
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//261
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//262
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//263
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//264
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//265
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//266
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//267
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//268
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//269
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//270
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//271
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//272
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//273
    { "Qt::WhiteSpaceMode", 0, Smoke::t_enum|Smoke::tf_stack },	//274
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//275
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//276
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//277
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//278
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//279
    { "QtConcurrent::ReduceOption", 0, Smoke::t_enum|Smoke::tf_stack },	//280
    { "QtConcurrent::ThreadFunctionResult", 0, Smoke::t_enum|Smoke::tf_stack },	//281
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//282
    { "const QAudioDeviceInfo&", 5, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//283
    { "const QAudioFormat&", 6, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//284
    { "const QBrush&", 10, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//285
    { "const QBrush*", 10, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//286
    { "const QByteArray&", 11, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//287
    { "const QColor&", 13, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//288
    { "const QCursor&", 14, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//289
    { "const QEvent*", 17, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//290
    { "const QFont&", 18, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//291
    { "const QIcon&", 23, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//292
    { "const QImage&", 24, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//293
    { "const QItemSelectionRange&", 26, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//294
    { "const QKeySequence&", 28, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//295
    { "const QLine&", 29, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//296
    { "const QLineF&", 30, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//297
    { "const QListWidgetItem&", 31, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//298
    { "const QMargins&", 32, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//299
    { "const QMatrix&", 33, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//300
    { "const QMatrix4x4&", 34, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//301
    { "const QMetaObject&", 35, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//302
    { "const QMetaObject*", 35, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//303
    { "const QPainterPath&", 38, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//304
    { "const QPalette&", 39, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//305
    { "const QPen&", 40, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//306
    { "const QPicture&", 41, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//307
    { "const QPixmap&", 42, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//308
    { "const QPoint&", 43, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//309
    { "const QPointF&", 44, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//310
    { "const QPolygon&", 45, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//311
    { "const QPolygonF&", 46, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//312
    { "const QQuaternion", 47, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//313
    { "const QQuaternion&", 47, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//314
    { "const QRect&", 48, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//315
    { "const QRegExp&", 49, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//316
    { "const QRegion&", 50, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//317
    { "const QSize&", 51, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//318
    { "const QSizePolicy&", 52, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//319
    { "const QSplitter&", 53, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//320
    { "const QStandardItem&", 54, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//321
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//322
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//323
    { "const QStyleOption&", 55, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//324
    { "const QStyleOption::OptionType&", 55, Smoke::t_enum|Smoke::tf_ref|Smoke::tf_const },	//325
    { "const QTableWidgetItem&", 56, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//326
    { "const QTextFormat&", 58, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//327
    { "const QTextLength&", 59, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//328
    { "const QTileRules&", 61, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//329
    { "const QTransform&", 63, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//330
    { "const QTreeWidgetItem&", 64, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//331
    { "const QVariant&", 65, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//332
    { "const QVector2D", 66, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//333
    { "const QVector2D&", 66, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//334
    { "const QVector3D", 67, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//335
    { "const QVector3D&", 67, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//336
    { "const QVector4D", 68, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//337
    { "const QVector4D&", 68, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//338
    { "const QVideoFrame&", 69, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//339
    { "const QVideoSurfaceFormat&", 70, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//340
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//341
    { "const unsigned char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//342
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//343
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//344
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//345
    { "int*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//346
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//347
    { "long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//348
    { "unsigned char*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//349
    { "unsigned int", 0, Smoke::t_uint|Smoke::tf_stack },	//350
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//351
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//352
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//353
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    5, 0,	//1  QAbstractVideoBuffer::HandleType
    6, 346, 346, 0,	//3  QAbstractVideoBuffer::MapMode, int*, int*
    341, 0,	//7  const char*
    341, 341, 0,	//9  const char*, const char*
    341, 341, 345, 0,	//12  const char*, const char*, int
    133, 345, 352, 0,	//16  QMetaObject::Call, int, void**
    134, 0,	//20  QObject*
    340, 0,	//22  const QVideoSurfaceFormat&
    339, 0,	//24  const QVideoFrame&
    282, 0,	//26  bool
    8, 0,	//28  QAbstractVideoSurface::Error
    283, 0,	//30  const QAudioDeviceInfo&
    284, 0,	//32  const QAudioFormat&
    17, 0,	//34  QAudio::Mode
    345, 0,	//36  int
    322, 0,	//38  const QString&
    25, 0,	//40  QAudioFormat::Endian
    26, 0,	//42  QAudioFormat::SampleType
    284, 134, 0,	//44  const QAudioFormat&, QObject*
    283, 284, 134, 0,	//47  const QAudioDeviceInfo&, const QAudioFormat&, QObject*
    106, 0,	//51  QIODevice*
    18, 0,	//53  QAudio::State
    283, 284, 0,	//55  const QAudioDeviceInfo&, const QAudioFormat&
    96, 96, 0,	//58  QGestureRecognizer::ResultFlag, QGestureRecognizer::ResultFlag
    38, 294, 0,	//61  QDebug, const QItemSelectionRange&
    38, 324, 0,	//64  QDebug, const QStyleOption&
    1, 1, 0,	//67  QAbstractItemView::EditTrigger, QAbstractItemView::EditTrigger
    36, 108, 0,	//70  QDataStream&, QImage&
    36, 319, 0,	//73  QDataStream&, const QSizePolicy&
    171, 345, 0,	//76  QStyleOptionToolBar::ToolBarFeature, int
    38, 330, 0,	//79  QDebug, const QTransform&
    36, 330, 0,	//82  QDataStream&, const QTransform&
    301, 301, 0,	//85  const QMatrix4x4&, const QMatrix4x4&
    338, 338, 0,	//88  const QVector4D&, const QVector4D&
    310, 300, 0,	//91  const QPointF&, const QMatrix&
    136, 136, 0,	//94  QPaintEngine::PaintEngineFeature, QPaintEngine::PaintEngineFeature
    296, 330, 0,	//97  const QLine&, const QTransform&
    334, 334, 0,	//100  const QVector2D&, const QVector2D&
    330, 330, 0,	//103  const QTransform&, const QTransform&
    350, 0,	//106  unsigned int
    43, 54, 0,	//108  QFileDialog::Option, QFlags<QFileDialog::Option>
    314, 0,	//111  const QQuaternion&
    2, 2, 0,	//113  QAbstractPrintDialog::PrintDialogOption, QAbstractPrintDialog::PrintDialogOption
    314, 344, 0,	//116  const QQuaternion&, double
    170, 170, 0,	//119  QStyleOptionTab::CornerWidget, QStyleOptionTab::CornerWidget
    169, 169, 0,	//122  QStyleOptionQ3ListViewItem::Q3ListViewItemFeature, QStyleOptionQ3ListViewItem::Q3ListViewItemFeature
    94, 94, 0,	//125  QFontComboBox::FontFilter, QFontComboBox::FontFilter
    179, 179, 0,	//128  QTextFormat::PageBreakFlag, QTextFormat::PageBreakFlag
    38, 291, 0,	//131  QDebug, const QFont&
    38, 311, 0,	//134  QDebug, const QPolygon&
    166, 345, 0,	//137  QStyle::SubControl, int
    40, 40, 0,	//140  QDockWidget::DockWidgetFeature, QDockWidget::DockWidgetFeature
    334, 0,	//143  const QVector2D&
    137, 315, 305, 282, 345, 286, 0,	//145  QPainter*, const QRect&, const QPalette&, bool, int, const QBrush*
    137, 315, 305, 0,	//152  QPainter*, const QRect&, const QPalette&
    137, 315, 305, 282, 0,	//156  QPainter*, const QRect&, const QPalette&, bool
    137, 315, 305, 282, 345, 0,	//161  QPainter*, const QRect&, const QPalette&, bool, int
    36, 305, 0,	//167  QDataStream&, const QPalette&
    176, 85, 0,	//170  QTextDocument::FindFlag, QFlags<QTextDocument::FindFlag>
    314, 314, 0,	//173  const QQuaternion&, const QQuaternion&
    177, 86, 0,	//176  QTextEdit::AutoFormattingFlag, QFlags<QTextEdit::AutoFormattingFlag>
    15, 48, 0,	//179  QAccessible::StateFlag, QFlags<QAccessible::StateFlag>
    312, 330, 0,	//182  const QPolygonF&, const QTransform&
    38, 312, 0,	//185  QDebug, const QPolygonF&
    144, 74, 0,	//188  QPinchGesture::ChangeFlag, QFlags<QPinchGesture::ChangeFlag>
    137, 345, 345, 345, 345, 305, 282, 286, 0,	//191  QPainter*, int, int, int, int, const QPalette&, bool, const QBrush*
    137, 345, 345, 345, 345, 305, 0,	//200  QPainter*, int, int, int, int, const QPalette&
    137, 345, 345, 345, 345, 305, 282, 0,	//207  QPainter*, int, int, int, int, const QPalette&, bool
    204, 345, 0,	//215  QWidget::RenderFlag, int
    38, 288, 0,	//218  QDebug, const QColor&
    188, 345, 0,	//221  QTreeWidgetItemIterator::IteratorFlag, int
    137, 345, 345, 345, 345, 305, 282, 345, 345, 286, 0,	//224  QPainter*, int, int, int, int, const QPalette&, bool, int, int, const QBrush*
    137, 345, 345, 345, 345, 305, 282, 345, 0,	//235  QPainter*, int, int, int, int, const QPalette&, bool, int
    137, 345, 345, 345, 345, 305, 282, 345, 345, 0,	//244  QPainter*, int, int, int, int, const QPalette&, bool, int, int
    36, 142, 0,	//254  QDataStream&, QPen&
    96, 57, 0,	//257  QGestureRecognizer::ResultFlag, QFlags<QGestureRecognizer::ResultFlag>
    36, 33, 0,	//260  QDataStream&, QColor&
    98, 98, 0,	//263  QGraphicsEffect::ChangeFlag, QGraphicsEffect::ChangeFlag
    95, 345, 0,	//266  QFontDialog::FontDialogOption, int
    169, 345, 0,	//269  QStyleOptionQ3ListViewItem::Q3ListViewItemFeature, int
    296, 300, 0,	//272  const QLine&, const QMatrix&
    135, 135, 0,	//275  QPaintEngine::DirtyFlag, QPaintEngine::DirtyFlag
    345, 345, 345, 0,	//278  int, int, int
    297, 300, 0,	//282  const QLineF&, const QMatrix&
    304, 300, 0,	//285  const QPainterPath&, const QMatrix&
    336, 336, 0,	//288  const QVector3D&, const QVector3D&
    36, 295, 0,	//291  QDataStream&, const QKeySequence&
    36, 326, 0,	//294  QDataStream&, const QTableWidgetItem&
    38, 100, 0,	//297  QDebug, QGraphicsItem::GraphicsItemChange
    113, 345, 0,	//300  QItemSelectionModel::SelectionFlag, int
    36, 289, 0,	//303  QDataStream&, const QCursor&
    132, 70, 0,	//306  QMessageBox::StandardButton, QFlags<QMessageBox::StandardButton>
    36, 307, 0,	//309  QDataStream&, const QPicture&
    132, 132, 0,	//312  QMessageBox::StandardButton, QMessageBox::StandardButton
    36, 194, 0,	//315  QDataStream&, QVector4D&
    131, 69, 0,	//318  QMdiSubWindow::SubWindowOption, QFlags<QMdiSubWindow::SubWindowOption>
    38, 76, 0,	//321  QDebug, QFlags<QStyle::StateFlag>
    95, 95, 0,	//324  QFontDialog::FontDialogOption, QFontDialog::FontDialogOption
    36, 331, 0,	//327  QDataStream&, const QTreeWidgetItem&
    138, 138, 0,	//330  QPainter::RenderHint, QPainter::RenderHint
    330, 344, 0,	//333  const QTransform&, double
    183, 320, 0,	//336  QTextStream&, const QSplitter&
    3, 46, 0,	//339  QAbstractSpinBox::StepEnabledFlag, QFlags<QAbstractSpinBox::StepEnabledFlag>
    334, 344, 0,	//342  const QVector2D&, double
    188, 188, 0,	//345  QTreeWidgetItemIterator::IteratorFlag, QTreeWidgetItemIterator::IteratorFlag
    167, 167, 0,	//348  QStyleOptionButton::ButtonFeature, QStyleOptionButton::ButtonFeature
    338, 344, 0,	//351  const QVector4D&, double
    167, 345, 0,	//354  QStyleOptionButton::ButtonFeature, int
    301, 344, 0,	//357  const QMatrix4x4&, double
    304, 330, 0,	//360  const QPainterPath&, const QTransform&
    36, 285, 0,	//363  QDataStream&, const QBrush&
    130, 68, 0,	//366  QMdiArea::AreaOption, QFlags<QMdiArea::AreaOption>
    3, 3, 0,	//369  QAbstractSpinBox::StepEnabledFlag, QAbstractSpinBox::StepEnabledFlag
    112, 345, 0,	//372  QInputDialog::InputDialogOption, int
    165, 345, 0,	//375  QStyle::StateFlag, int
    36, 156, 0,	//378  QDataStream&, QRegion&
    138, 345, 0,	//381  QPainter::RenderHint, int
    170, 345, 0,	//384  QStyleOptionTab::CornerWidget, int
    205, 205, 0,	//387  QWizard::WizardOption, QWizard::WizardOption
    205, 92, 0,	//390  QWizard::WizardOption, QFlags<QWizard::WizardOption>
    136, 72, 0,	//393  QPaintEngine::PaintEngineFeature, QFlags<QPaintEngine::PaintEngineFeature>
    101, 101, 0,	//396  QGraphicsItem::GraphicsItemFlag, QGraphicsItem::GraphicsItemFlag
    137, 345, 345, 345, 345, 305, 282, 345, 286, 0,	//399  QPainter*, int, int, int, int, const QPalette&, bool, int, const QBrush*
    336, 301, 0,	//409  const QVector3D&, const QMatrix4x4&
    137, 315, 305, 282, 286, 0,	//412  QPainter*, const QRect&, const QPalette&, bool, const QBrush*
    159, 159, 0,	//418  QSizePolicy::ControlType, QSizePolicy::ControlType
    94, 345, 0,	//421  QFontComboBox::FontFilter, int
    176, 345, 0,	//424  QTextDocument::FindFlag, int
    36, 35, 0,	//427  QDataStream&, QCursor&
    336, 344, 0,	//430  const QVector3D&, double
    36, 186, 0,	//433  QDataStream&, QTransform&
    311, 300, 0,	//436  const QPolygon&, const QMatrix&
    170, 81, 0,	//439  QStyleOptionTab::CornerWidget, QFlags<QStyleOptionTab::CornerWidget>
    38, 306, 0,	//442  QDebug, const QPen&
    172, 172, 0,	//445  QStyleOptionToolButton::ToolButtonFeature, QStyleOptionToolButton::ToolButtonFeature
    137, 315, 305, 282, 345, 345, 286, 0,	//448  QPainter*, const QRect&, const QPalette&, bool, int, int, const QBrush*
    137, 315, 305, 282, 345, 345, 0,	//456  QPainter*, const QRect&, const QPalette&, bool, int, int
    177, 177, 0,	//463  QTextEdit::AutoFormattingFlag, QTextEdit::AutoFormattingFlag
    135, 345, 0,	//466  QPaintEngine::DirtyFlag, int
    101, 345, 0,	//469  QGraphicsItem::GraphicsItemFlag, int
    36, 308, 0,	//472  QDataStream&, const QPixmap&
    310, 330, 0,	//475  const QPointF&, const QTransform&
    38, 336, 0,	//478  QDebug, const QVector3D&
    40, 52, 0,	//481  QDockWidget::DockWidgetFeature, QFlags<QDockWidget::DockWidgetFeature>
    98, 345, 0,	//484  QGraphicsEffect::ChangeFlag, int
    137, 345, 345, 345, 345, 288, 345, 286, 0,	//487  QPainter*, int, int, int, int, const QColor&, int, const QBrush*
    137, 345, 345, 345, 345, 288, 0,	//496  QPainter*, int, int, int, int, const QColor&
    137, 345, 345, 345, 345, 288, 345, 0,	//503  QPainter*, int, int, int, int, const QColor&, int
    159, 75, 0,	//511  QSizePolicy::ControlType, QFlags<QSizePolicy::ControlType>
    3, 345, 0,	//514  QAbstractSpinBox::StepEnabledFlag, int
    38, 334, 0,	//517  QDebug, const QVector2D&
    301, 338, 0,	//520  const QMatrix4x4&, const QVector4D&
    15, 345, 0,	//523  QAccessible::StateFlag, int
    137, 315, 288, 345, 286, 0,	//526  QPainter*, const QRect&, const QColor&, int, const QBrush*
    137, 315, 288, 0,	//532  QPainter*, const QRect&, const QColor&
    137, 315, 288, 345, 0,	//536  QPainter*, const QRect&, const QColor&, int
    144, 144, 0,	//541  QPinchGesture::ChangeFlag, QPinchGesture::ChangeFlag
    37, 345, 0,	//544  QDateTimeEdit::Section, int
    309, 300, 0,	//547  const QPoint&, const QMatrix&
    36, 306, 0,	//550  QDataStream&, const QPen&
    204, 204, 0,	//553  QWidget::RenderFlag, QWidget::RenderFlag
    137, 315, 299, 308, 315, 299, 329, 53, 0,	//556  QPainter*, const QRect&, const QMargins&, const QPixmap&, const QRect&, const QMargins&, const QTileRules&, QFlags<QDrawBorderPixmap::DrawingHint>
    137, 315, 299, 308, 315, 299, 0,	//565  QPainter*, const QRect&, const QMargins&, const QPixmap&, const QRect&, const QMargins&
    137, 315, 299, 308, 315, 299, 329, 0,	//572  QPainter*, const QRect&, const QMargins&, const QPixmap&, const QRect&, const QMargins&, const QTileRules&
    34, 345, 0,	//580  QColorDialog::ColorDialogOption, int
    36, 107, 0,	//583  QDataStream&, QIcon&
    36, 311, 0,	//586  QDataStream&, const QPolygon&
    204, 91, 0,	//589  QWidget::RenderFlag, QFlags<QWidget::RenderFlag>
    179, 345, 0,	//592  QTextFormat::PageBreakFlag, int
    110, 345, 0,	//595  QImageIOPlugin::Capability, int
    38, 60, 0,	//598  QDebug, QFlags<QGraphicsItem::GraphicsItemFlag>
    104, 345, 0,	//601  QGraphicsView::CacheModeFlag, int
    1, 345, 0,	//604  QAbstractItemView::EditTrigger, int
    38, 338, 0,	//607  QDebug, const QVector4D&
    205, 345, 0,	//610  QWizard::WizardOption, int
    43, 345, 0,	//613  QFileDialog::Option, int
    165, 76, 0,	//616  QStyle::StateFlag, QFlags<QStyle::StateFlag>
    301, 309, 0,	//619  const QMatrix4x4&, const QPoint&
    172, 83, 0,	//622  QStyleOptionToolButton::ToolButtonFeature, QFlags<QStyleOptionToolButton::ToolButtonFeature>
    103, 61, 0,	//625  QGraphicsScene::SceneLayer, QFlags<QGraphicsScene::SceneLayer>
    130, 130, 0,	//628  QMdiArea::AreaOption, QMdiArea::AreaOption
    36, 161, 0,	//631  QDataStream&, QStandardItem&
    136, 345, 0,	//634  QPaintEngine::PaintEngineFeature, int
    38, 304, 0,	//637  QDebug, const QPainterPath&
    34, 49, 0,	//640  QColorDialog::ColorDialogOption, QFlags<QColorDialog::ColorDialogOption>
    36, 30, 0,	//643  QDataStream&, QBrush&
    36, 129, 0,	//646  QDataStream&, QMatrix4x4&
    338, 0,	//649  const QVector4D&
    38, 301, 0,	//651  QDebug, const QMatrix4x4&
    105, 345, 0,	//654  QGraphicsView::OptimizationFlag, int
    36, 178, 0,	//657  QDataStream&, QTextFormat&
    36, 125, 0,	//660  QDataStream&, QListWidgetItem&
    98, 59, 0,	//663  QGraphicsEffect::ChangeFlag, QFlags<QGraphicsEffect::ChangeFlag>
    97, 58, 0,	//666  QGraphicsBlurEffect::BlurHint, QFlags<QGraphicsBlurEffect::BlurHint>
    172, 345, 0,	//669  QStyleOptionToolButton::ToolButtonFeature, int
    132, 345, 0,	//672  QMessageBox::StandardButton, int
    38, 101, 0,	//675  QDebug, QGraphicsItem::GraphicsItemFlag
    14, 47, 0,	//678  QAccessible::RelationFlag, QFlags<QAccessible::RelationFlag>
    116, 114, 0,	//681  QKeySequence::StandardKey, QKeyEvent*
    159, 345, 0,	//684  QSizePolicy::ControlType, int
    36, 158, 0,	//687  QDataStream&, QSizePolicy&
    36, 127, 0,	//690  QDataStream&, QMatrix&
    169, 80, 0,	//693  QStyleOptionQ3ListViewItem::Q3ListViewItemFeature, QFlags<QStyleOptionQ3ListViewItem::Q3ListViewItemFeature>
    301, 310, 0,	//696  const QMatrix4x4&, const QPointF&
    301, 0,	//699  const QMatrix4x4&
    344, 334, 0,	//701  double, const QVector2D&
    2, 45, 0,	//704  QAbstractPrintDialog::PrintDialogOption, QFlags<QAbstractPrintDialog::PrintDialogOption>
    112, 112, 0,	//707  QInputDialog::InputDialogOption, QInputDialog::InputDialogOption
    2, 345, 0,	//710  QAbstractPrintDialog::PrintDialogOption, int
    36, 336, 0,	//713  QDataStream&, const QVector3D&
    297, 330, 0,	//716  const QLineF&, const QTransform&
    36, 312, 0,	//719  QDataStream&, const QPolygonF&
    344, 336, 0,	//722  double, const QVector3D&
    36, 291, 0,	//725  QDataStream&, const QFont&
    182, 89, 0,	//728  QTextOption::Flag, QFlags<QTextOption::Flag>
    36, 174, 0,	//731  QDataStream&, QTableWidgetItem&
    166, 77, 0,	//734  QStyle::SubControl, QFlags<QStyle::SubControl>
    36, 334, 0,	//737  QDataStream&, const QVector2D&
    36, 300, 0,	//740  QDataStream&, const QMatrix&
    138, 73, 0,	//743  QPainter::RenderHint, QFlags<QPainter::RenderHint>
    344, 301, 0,	//746  double, const QMatrix4x4&
    105, 63, 0,	//749  QGraphicsView::OptimizationFlag, QFlags<QGraphicsView::OptimizationFlag>
    180, 180, 0,	//752  QTextItem::RenderFlag, QTextItem::RenderFlag
    104, 104, 0,	//755  QGraphicsView::CacheModeFlag, QGraphicsView::CacheModeFlag
    36, 151, 0,	//758  QDataStream&, QPolygonF&
    188, 90, 0,	//761  QTreeWidgetItemIterator::IteratorFlag, QFlags<QTreeWidgetItemIterator::IteratorFlag>
    36, 141, 0,	//764  QDataStream&, QPalette&
    36, 304, 0,	//767  QDataStream&, const QPainterPath&
    15, 15, 0,	//770  QAccessible::StateFlag, QAccessible::StateFlag
    114, 116, 0,	//773  QKeyEvent*, QKeySequence::StandardKey
    104, 62, 0,	//776  QGraphicsView::CacheModeFlag, QFlags<QGraphicsView::CacheModeFlag>
    166, 166, 0,	//779  QStyle::SubControl, QStyle::SubControl
    1, 44, 0,	//782  QAbstractItemView::EditTrigger, QFlags<QAbstractItemView::EditTrigger>
    144, 345, 0,	//785  QPinchGesture::ChangeFlag, int
    36, 152, 0,	//788  QDataStream&, QQuaternion&
    338, 301, 0,	//791  const QVector4D&, const QMatrix4x4&
    300, 300, 0,	//794  const QMatrix&, const QMatrix&
    173, 173, 0,	//797  QStyleOptionViewItemV2::ViewItemFeature, QStyleOptionViewItemV2::ViewItemFeature
    126, 67, 0,	//800  QMainWindow::DockOption, QFlags<QMainWindow::DockOption>
    38, 102, 0,	//803  QDebug, QGraphicsObject*
    131, 131, 0,	//806  QMdiSubWindow::SubWindowOption, QMdiSubWindow::SubWindowOption
    36, 293, 0,	//809  QDataStream&, const QImage&
    344, 314, 0,	//812  double, const QQuaternion&
    176, 176, 0,	//815  QTextDocument::FindFlag, QTextDocument::FindFlag
    38, 295, 0,	//818  QDebug, const QKeySequence&
    135, 71, 0,	//821  QPaintEngine::DirtyFlag, QFlags<QPaintEngine::DirtyFlag>
    39, 39, 0,	//824  QDialogButtonBox::StandardButton, QDialogButtonBox::StandardButton
    14, 14, 0,	//827  QAccessible::RelationFlag, QAccessible::RelationFlag
    103, 103, 0,	//830  QGraphicsScene::SceneLayer, QGraphicsScene::SceneLayer
    38, 290, 0,	//833  QDebug, const QEvent*
    36, 93, 0,	//836  QDataStream&, QFont&
    112, 65, 0,	//839  QInputDialog::InputDialogOption, QFlags<QInputDialog::InputDialogOption>
    113, 66, 0,	//842  QItemSelectionModel::SelectionFlag, QFlags<QItemSelectionModel::SelectionFlag>
    96, 345, 0,	//845  QGestureRecognizer::ResultFlag, int
    311, 330, 0,	//848  const QPolygon&, const QTransform&
    173, 84, 0,	//851  QStyleOptionViewItemV2::ViewItemFeature, QFlags<QStyleOptionViewItemV2::ViewItemFeature>
    36, 181, 0,	//854  QDataStream&, QTextLength&
    36, 317, 0,	//857  QDataStream&, const QRegion&
    38, 300, 0,	//860  QDebug, const QMatrix&
    97, 345, 0,	//863  QGraphicsBlurEffect::BlurHint, int
    182, 182, 0,	//866  QTextOption::Flag, QTextOption::Flag
    36, 288, 0,	//869  QDataStream&, const QColor&
    37, 37, 0,	//872  QDateTimeEdit::Section, QDateTimeEdit::Section
    301, 336, 0,	//875  const QMatrix4x4&, const QVector3D&
    38, 285, 0,	//878  QDebug, const QBrush&
    168, 168, 0,	//881  QStyleOptionFrameV2::FrameFeature, QStyleOptionFrameV2::FrameFeature
    36, 187, 0,	//884  QDataStream&, QTreeWidgetItem&
    36, 115, 0,	//887  QDataStream&, QKeySequence&
    177, 345, 0,	//890  QTextEdit::AutoFormattingFlag, int
    38, 340, 0,	//893  QDebug, const QVideoSurfaceFormat&
    110, 64, 0,	//896  QImageIOPlugin::Capability, QFlags<QImageIOPlugin::Capability>
    36, 328, 0,	//899  QDataStream&, const QTextLength&
    317, 330, 0,	//902  const QRegion&, const QTransform&
    310, 301, 0,	//905  const QPointF&, const QMatrix4x4&
    38, 99, 0,	//908  QDebug, QGraphicsItem*
    40, 345, 0,	//911  QDockWidget::DockWidgetFeature, int
    36, 298, 0,	//914  QDataStream&, const QListWidgetItem&
    103, 345, 0,	//917  QGraphicsScene::SceneLayer, int
    38, 325, 0,	//920  QDebug, const QStyleOption::OptionType&
    36, 321, 0,	//923  QDataStream&, const QStandardItem&
    312, 300, 0,	//926  const QPolygonF&, const QMatrix&
    14, 345, 0,	//929  QAccessible::RelationFlag, int
    36, 149, 0,	//932  QDataStream&, QPolygon&
    137, 315, 299, 308, 0,	//935  QPainter*, const QRect&, const QMargins&, const QPixmap&
    94, 55, 0,	//940  QFontComboBox::FontFilter, QFlags<QFontComboBox::FontFilter>
    43, 43, 0,	//943  QFileDialog::Option, QFileDialog::Option
    130, 345, 0,	//946  QMdiArea::AreaOption, int
    37, 50, 0,	//949  QDateTimeEdit::Section, QFlags<QDateTimeEdit::Section>
    39, 51, 0,	//952  QDialogButtonBox::StandardButton, QFlags<QDialogButtonBox::StandardButton>
    137, 309, 309, 305, 282, 345, 345, 0,	//955  QPainter*, const QPoint&, const QPoint&, const QPalette&, bool, int, int
    137, 309, 309, 305, 0,	//963  QPainter*, const QPoint&, const QPoint&, const QPalette&
    137, 309, 309, 305, 282, 0,	//968  QPainter*, const QPoint&, const QPoint&, const QPalette&, bool
    137, 309, 309, 305, 282, 345, 0,	//974  QPainter*, const QPoint&, const QPoint&, const QPalette&, bool, int
    113, 113, 0,	//981  QItemSelectionModel::SelectionFlag, QItemSelectionModel::SelectionFlag
    183, 160, 0,	//984  QTextStream&, QSplitter&
    36, 301, 0,	//987  QDataStream&, const QMatrix4x4&
    36, 338, 0,	//990  QDataStream&, const QVector4D&
    165, 165, 0,	//993  QStyle::StateFlag, QStyle::StateFlag
    294, 0,	//996  const QItemSelectionRange&
    36, 145, 0,	//998  QDataStream&, QPixmap&
    309, 301, 0,	//1001  const QPoint&, const QMatrix4x4&
    95, 56, 0,	//1004  QFontDialog::FontDialogOption, QFlags<QFontDialog::FontDialogOption>
    105, 105, 0,	//1007  QGraphicsView::OptimizationFlag, QGraphicsView::OptimizationFlag
    336, 0,	//1010  const QVector3D&
    167, 78, 0,	//1012  QStyleOptionButton::ButtonFeature, QFlags<QStyleOptionButton::ButtonFeature>
    34, 34, 0,	//1015  QColorDialog::ColorDialogOption, QColorDialog::ColorDialogOption
    36, 292, 0,	//1018  QDataStream&, const QIcon&
    36, 192, 0,	//1021  QDataStream&, QVector3D&
    173, 345, 0,	//1024  QStyleOptionViewItemV2::ViewItemFeature, int
    344, 338, 0,	//1027  double, const QVector4D&
    36, 140, 0,	//1030  QDataStream&, QPainterPath&
    101, 60, 0,	//1033  QGraphicsItem::GraphicsItemFlag, QFlags<QGraphicsItem::GraphicsItemFlag>
    36, 143, 0,	//1036  QDataStream&, QPicture&
    180, 88, 0,	//1039  QTextItem::RenderFlag, QFlags<QTextItem::RenderFlag>
    309, 330, 0,	//1042  const QPoint&, const QTransform&
    168, 345, 0,	//1045  QStyleOptionFrameV2::FrameFeature, int
    39, 345, 0,	//1048  QDialogButtonBox::StandardButton, int
    171, 171, 0,	//1051  QStyleOptionToolBar::ToolBarFeature, QStyleOptionToolBar::ToolBarFeature
    36, 190, 0,	//1054  QDataStream&, QVector2D&
    180, 345, 0,	//1057  QTextItem::RenderFlag, int
    126, 345, 0,	//1060  QMainWindow::DockOption, int
    179, 87, 0,	//1063  QTextFormat::PageBreakFlag, QFlags<QTextFormat::PageBreakFlag>
    38, 314, 0,	//1066  QDebug, const QQuaternion&
    168, 79, 0,	//1069  QStyleOptionFrameV2::FrameFeature, QFlags<QStyleOptionFrameV2::FrameFeature>
    36, 327, 0,	//1072  QDataStream&, const QTextFormat&
    131, 345, 0,	//1075  QMdiSubWindow::SubWindowOption, int
    97, 97, 0,	//1078  QGraphicsBlurEffect::BlurHint, QGraphicsBlurEffect::BlurHint
    110, 110, 0,	//1081  QImageIOPlugin::Capability, QImageIOPlugin::Capability
    36, 314, 0,	//1084  QDataStream&, const QQuaternion&
    317, 300, 0,	//1087  const QRegion&, const QMatrix&
    38, 317, 0,	//1090  QDebug, const QRegion&
    182, 345, 0,	//1093  QTextOption::Flag, int
    345, 345, 345, 345, 0,	//1096  int, int, int, int
    171, 82, 0,	//1101  QStyleOptionToolBar::ToolBarFeature, QFlags<QStyleOptionToolBar::ToolBarFeature>
    126, 126, 0,	//1104  QMainWindow::DockOption, QMainWindow::DockOption
    42, 0,	//1107  QEvent*
    134, 42, 0,	//1109  QObject*, QEvent*
    184, 0,	//1112  QTimerEvent*
    32, 0,	//1114  QChildEvent*
    4, 318, 198, 0,	//1116  QAbstractVideoBuffer*, const QSize&, QVideoFrame::PixelFormat
    345, 318, 345, 198, 0,	//1120  int, const QSize&, int, QVideoFrame::PixelFormat
    293, 0,	//1125  const QImage&
    197, 0,	//1127  QVideoFrame::FieldType
    6, 0,	//1129  QAbstractVideoBuffer::MapMode
    348, 0,	//1131  long long
    109, 0,	//1133  QImage::Format
    198, 0,	//1135  QVideoFrame::PixelFormat
    318, 198, 5, 0,	//1137  const QSize&, QVideoFrame::PixelFormat, QAbstractVideoBuffer::HandleType
    318, 0,	//1141  const QSize&
    345, 345, 0,	//1143  int, int
    315, 0,	//1146  const QRect&
    202, 0,	//1148  QVideoSurfaceFormat::Direction
    344, 0,	//1150  double
    203, 0,	//1152  QVideoSurfaceFormat::YCbCrColorSpace
    341, 332, 0,	//1154  const char*, const QVariant&
    318, 198, 0,	//1157  const QSize&, QVideoFrame::PixelFormat
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "ActiveState",	//1
    "AudioInput",	//2
    "AudioOutput",	//3
    "BigEndian",	//4
    "BottomField",	//5
    "BottomToTop",	//6
    "CoreImageHandle",	//7
    "FatalError",	//8
    "Float",	//9
    "Format_ARGB32",	//10
    "Format_ARGB32_Premultiplied",	//11
    "Format_ARGB8565_Premultiplied",	//12
    "Format_AYUV444",	//13
    "Format_AYUV444_Premultiplied",	//14
    "Format_BGR24",	//15
    "Format_BGR32",	//16
    "Format_BGR555",	//17
    "Format_BGR565",	//18
    "Format_BGRA32",	//19
    "Format_BGRA32_Premultiplied",	//20
    "Format_BGRA5658_Premultiplied",	//21
    "Format_IMC1",	//22
    "Format_IMC2",	//23
    "Format_IMC3",	//24
    "Format_IMC4",	//25
    "Format_Invalid",	//26
    "Format_NV12",	//27
    "Format_NV21",	//28
    "Format_RGB24",	//29
    "Format_RGB32",	//30
    "Format_RGB555",	//31
    "Format_RGB565",	//32
    "Format_UYVY",	//33
    "Format_User",	//34
    "Format_Y16",	//35
    "Format_Y8",	//36
    "Format_YUV420P",	//37
    "Format_YUV444",	//38
    "Format_YUYV",	//39
    "Format_YV12",	//40
    "GLTextureHandle",	//41
    "IOError",	//42
    "IdleState",	//43
    "IncorrectFormatError",	//44
    "InterlacedFrame",	//45
    "LittleEndian",	//46
    "NoError",	//47
    "NoHandle",	//48
    "NotMapped",	//49
    "OpenError",	//50
    "ProgressiveFrame",	//51
    "QAbstractVideoBuffer",	//52
    "QAbstractVideoBuffer$",	//53
    "QAbstractVideoSurface",	//54
    "QAbstractVideoSurface#",	//55
    "QAudioDeviceInfo",	//56
    "QAudioDeviceInfo#",	//57
    "QAudioFormat",	//58
    "QAudioFormat#",	//59
    "QAudioInput",	//60
    "QAudioInput#",	//61
    "QAudioInput##",	//62
    "QAudioInput###",	//63
    "QAudioOutput",	//64
    "QAudioOutput#",	//65
    "QAudioOutput##",	//66
    "QAudioOutput###",	//67
    "QPixmapHandle",	//68
    "QVideoFrame",	//69
    "QVideoFrame#",	//70
    "QVideoFrame##$",	//71
    "QVideoFrame$#$$",	//72
    "QVideoSurfaceFormat",	//73
    "QVideoSurfaceFormat#",	//74
    "QVideoSurfaceFormat#$",	//75
    "QVideoSurfaceFormat#$$",	//76
    "ReadOnly",	//77
    "ReadWrite",	//78
    "ResourceError",	//79
    "SP_CustomCameraCaptureButton",	//80
    "SP_CustomCameraCaptureButtonPressed",	//81
    "SP_CustomCameraPauseButton",	//82
    "SP_CustomCameraPauseButtonPressed",	//83
    "SP_CustomCameraPlayButton",	//84
    "SP_CustomCameraPlayButtonPressed",	//85
    "SP_CustomCameraRecButton",	//86
    "SP_CustomCameraRecButtonPressed",	//87
    "SP_CustomCameraStopButton",	//88
    "SP_CustomCameraStopButtonPressed",	//89
    "SP_CustomTabAll",	//90
    "SP_CustomTabArtist",	//91
    "SP_CustomTabFavourite",	//92
    "SP_CustomTabGenre",	//93
    "SP_CustomTabLanguage",	//94
    "SP_CustomTabMusicAlbum",	//95
    "SP_CustomTabPhotosAlbum",	//96
    "SP_CustomTabPhotosAll",	//97
    "SP_CustomTabPlaylist",	//98
    "SP_CustomTabServices",	//99
    "SP_CustomTabSongs",	//100
    "SP_CustomTabVideos",	//101
    "SP_CustomToolBarAdd",	//102
    "SP_CustomToolBarAddDetail",	//103
    "SP_CustomToolBarAgain",	//104
    "SP_CustomToolBarAgenda",	//105
    "SP_CustomToolBarAudioOff",	//106
    "SP_CustomToolBarAudioOn",	//107
    "SP_CustomToolBarBack",	//108
    "SP_CustomToolBarBluetoothOff",	//109
    "SP_CustomToolBarBluetoothOn",	//110
    "SP_CustomToolBarCancel",	//111
    "SP_CustomToolBarDelete",	//112
    "SP_CustomToolBarDone",	//113
    "SP_CustomToolBarEdit",	//114
    "SP_CustomToolBarEditDisabled",	//115
    "SP_CustomToolBarEmailSend",	//116
    "SP_CustomToolBarEmergencyCall",	//117
    "SP_CustomToolBarFavouriteAdd",	//118
    "SP_CustomToolBarFavouriteRemove",	//119
    "SP_CustomToolBarFavourites",	//120
    "SP_CustomToolBarGo",	//121
    "SP_CustomToolBarHome",	//122
    "SP_CustomToolBarImageTools",	//123
    "SP_CustomToolBarList",	//124
    "SP_CustomToolBarLock",	//125
    "SP_CustomToolBarLogs",	//126
    "SP_CustomToolBarMenu",	//127
    "SP_CustomToolBarNewContact",	//128
    "SP_CustomToolBarNewGroup",	//129
    "SP_CustomToolBarNextFrame",	//130
    "SP_CustomToolBarNowPlay",	//131
    "SP_CustomToolBarOptions",	//132
    "SP_CustomToolBarOther",	//133
    "SP_CustomToolBarOvi",	//134
    "SP_CustomToolBarPreviousFrame",	//135
    "SP_CustomToolBarRead",	//136
    "SP_CustomToolBarRedo",	//137
    "SP_CustomToolBarRedoDisabled",	//138
    "SP_CustomToolBarRefresh",	//139
    "SP_CustomToolBarRemoveDetail",	//140
    "SP_CustomToolBarRemoveDisabled",	//141
    "SP_CustomToolBarRepeat",	//142
    "SP_CustomToolBarRepeatOff",	//143
    "SP_CustomToolBarRepeatOne",	//144
    "SP_CustomToolBarSearch",	//145
    "SP_CustomToolBarSearchDisabled",	//146
    "SP_CustomToolBarSelectContent",	//147
    "SP_CustomToolBarSelfTimer",	//148
    "SP_CustomToolBarSend",	//149
    "SP_CustomToolBarSendDimmed",	//150
    "SP_CustomToolBarShare",	//151
    "SP_CustomToolBarShift",	//152
    "SP_CustomToolBarShuffle",	//153
    "SP_CustomToolBarShuffleOff",	//154
    "SP_CustomToolBarSignalOff",	//155
    "SP_CustomToolBarSignalOn",	//156
    "SP_CustomToolBarSync",	//157
    "SP_CustomToolBarTools",	//158
    "SP_CustomToolBarTrim",	//159
    "SP_CustomToolBarUnlock",	//160
    "SP_CustomToolBarUnmark",	//161
    "SP_CustomToolBarView",	//162
    "SP_CustomToolBarWlanOff",	//163
    "SP_CustomToolBarWlanOn",	//164
    "SignedInt",	//165
    "StoppedError",	//166
    "StoppedState",	//167
    "SuspendedState",	//168
    "TopField",	//169
    "TopToBottom",	//170
    "UnSignedInt",	//171
    "UnderrunError",	//172
    "Unknown",	//173
    "UnsupportedFormatError",	//174
    "UserHandle",	//175
    "WriteOnly",	//176
    "XvShmImageHandle",	//177
    "YCbCr_BT601",	//178
    "YCbCr_BT709",	//179
    "YCbCr_CustomMatrix",	//180
    "YCbCr_JPEG",	//181
    "YCbCr_Undefined",	//182
    "YCbCr_xvYCC601",	//183
    "YCbCr_xvYCC709",	//184
    "activeChanged",	//185
    "activeChanged$",	//186
    "availableDevices",	//187
    "availableDevices$",	//188
    "bits",	//189
    "bufferSize",	//190
    "byteOrder",	//191
    "bytesFree",	//192
    "bytesPerLine",	//193
    "bytesReady",	//194
    "channelCount",	//195
    "channels",	//196
    "childEvent",	//197
    "codec",	//198
    "connectNotify",	//199
    "customEvent",	//200
    "defaultInputDevice",	//201
    "defaultOutputDevice",	//202
    "deviceName",	//203
    "disconnectNotify",	//204
    "elapsedUSecs",	//205
    "endTime",	//206
    "error",	//207
    "event",	//208
    "eventFilter",	//209
    "fieldType",	//210
    "format",	//211
    "frameHeight",	//212
    "frameRate",	//213
    "frameSize",	//214
    "frameWidth",	//215
    "frequency",	//216
    "handle",	//217
    "handleType",	//218
    "height",	//219
    "imageFormatFromPixelFormat",	//220
    "imageFormatFromPixelFormat$",	//221
    "isActive",	//222
    "isFormatSupported",	//223
    "isFormatSupported#",	//224
    "isMapped",	//225
    "isNull",	//226
    "isReadable",	//227
    "isValid",	//228
    "isWritable",	//229
    "map",	//230
    "map$",	//231
    "map$$$",	//232
    "mapMode",	//233
    "mappedBytes",	//234
    "metaObject",	//235
    "nearestFormat",	//236
    "nearestFormat#",	//237
    "notify",	//238
    "notifyInterval",	//239
    "operator!=",	//240
    "operator!=#",	//241
    "operator!=##",	//242
    "operator*",	//243
    "operator*##",	//244
    "operator*#$",	//245
    "operator*$#",	//246
    "operator+",	//247
    "operator+##",	//248
    "operator+#$",	//249
    "operator-",	//250
    "operator-#",	//251
    "operator-##",	//252
    "operator-#$",	//253
    "operator/",	//254
    "operator/#$",	//255
    "operator<<",	//256
    "operator<<##",	//257
    "operator<<#$",	//258
    "operator=",	//259
    "operator=#",	//260
    "operator==",	//261
    "operator==#",	//262
    "operator==##",	//263
    "operator==#$",	//264
    "operator==$#",	//265
    "operator>>",	//266
    "operator>>##",	//267
    "operator|",	//268
    "operator|$$",	//269
    "periodSize",	//270
    "pixelAspectRatio",	//271
    "pixelFormat",	//272
    "pixelFormatFromImageFormat",	//273
    "pixelFormatFromImageFormat$",	//274
    "preferredFormat",	//275
    "present",	//276
    "present#",	//277
    "processedUSecs",	//278
    "property",	//279
    "property$",	//280
    "propertyNames",	//281
    "qAccessibleActionCastHelper",	//282
    "qAccessibleEditableTextCastHelper",	//283
    "qAccessibleImageCastHelper",	//284
    "qAccessibleTable2CastHelper",	//285
    "qAccessibleTableCastHelper",	//286
    "qAccessibleTextCastHelper",	//287
    "qAccessibleValueCastHelper",	//288
    "qAlpha",	//289
    "qAlpha$",	//290
    "qBlue",	//291
    "qBlue$",	//292
    "qDrawBorderPixmap",	//293
    "qDrawBorderPixmap####",	//294
    "qDrawBorderPixmap######",	//295
    "qDrawBorderPixmap#######",	//296
    "qDrawBorderPixmap#######$",	//297
    "qDrawPlainRect",	//298
    "qDrawPlainRect###",	//299
    "qDrawPlainRect###$",	//300
    "qDrawPlainRect###$#",	//301
    "qDrawPlainRect#$$$$#",	//302
    "qDrawPlainRect#$$$$#$",	//303
    "qDrawPlainRect#$$$$#$#",	//304
    "qDrawShadeLine",	//305
    "qDrawShadeLine####",	//306
    "qDrawShadeLine####$",	//307
    "qDrawShadeLine####$$",	//308
    "qDrawShadeLine####$$$",	//309
    "qDrawShadeLine#$$$$#",	//310
    "qDrawShadeLine#$$$$#$",	//311
    "qDrawShadeLine#$$$$#$$",	//312
    "qDrawShadeLine#$$$$#$$$",	//313
    "qDrawShadePanel",	//314
    "qDrawShadePanel###",	//315
    "qDrawShadePanel###$",	//316
    "qDrawShadePanel###$$",	//317
    "qDrawShadePanel###$$#",	//318
    "qDrawShadePanel#$$$$#",	//319
    "qDrawShadePanel#$$$$#$",	//320
    "qDrawShadePanel#$$$$#$$",	//321
    "qDrawShadePanel#$$$$#$$#",	//322
    "qDrawShadeRect",	//323
    "qDrawShadeRect###",	//324
    "qDrawShadeRect###$",	//325
    "qDrawShadeRect###$$",	//326
    "qDrawShadeRect###$$$",	//327
    "qDrawShadeRect###$$$#",	//328
    "qDrawShadeRect#$$$$#",	//329
    "qDrawShadeRect#$$$$#$",	//330
    "qDrawShadeRect#$$$$#$$",	//331
    "qDrawShadeRect#$$$$#$$$",	//332
    "qDrawShadeRect#$$$$#$$$#",	//333
    "qDrawWinButton",	//334
    "qDrawWinButton###",	//335
    "qDrawWinButton###$",	//336
    "qDrawWinButton###$#",	//337
    "qDrawWinButton#$$$$#",	//338
    "qDrawWinButton#$$$$#$",	//339
    "qDrawWinButton#$$$$#$#",	//340
    "qDrawWinPanel",	//341
    "qDrawWinPanel###",	//342
    "qDrawWinPanel###$",	//343
    "qDrawWinPanel###$#",	//344
    "qDrawWinPanel#$$$$#",	//345
    "qDrawWinPanel#$$$$#$",	//346
    "qDrawWinPanel#$$$$#$#",	//347
    "qFuzzyCompare",	//348
    "qFuzzyCompare##",	//349
    "qGray",	//350
    "qGray$",	//351
    "qGray$$$",	//352
    "qGreen",	//353
    "qGreen$",	//354
    "qHash",	//355
    "qHash#",	//356
    "qIsGray",	//357
    "qIsGray$",	//358
    "qRed",	//359
    "qRed$",	//360
    "qRgb",	//361
    "qRgb$$$",	//362
    "qRgba",	//363
    "qRgba$$$$",	//364
    "qt_metacall",	//365
    "qt_metacall$$?",	//366
    "qt_metacast",	//367
    "qt_metacast$",	//368
    "reset",	//369
    "resume",	//370
    "sampleRate",	//371
    "sampleSize",	//372
    "sampleType",	//373
    "scanLineDirection",	//374
    "setBufferSize",	//375
    "setBufferSize$",	//376
    "setByteOrder",	//377
    "setByteOrder$",	//378
    "setChannelCount",	//379
    "setChannelCount$",	//380
    "setChannels",	//381
    "setChannels$",	//382
    "setCodec",	//383
    "setCodec$",	//384
    "setEndTime",	//385
    "setEndTime$",	//386
    "setError",	//387
    "setError$",	//388
    "setFieldType",	//389
    "setFieldType$",	//390
    "setFrameRate",	//391
    "setFrameRate$",	//392
    "setFrameSize",	//393
    "setFrameSize#",	//394
    "setFrameSize$$",	//395
    "setFrequency",	//396
    "setFrequency$",	//397
    "setNotifyInterval",	//398
    "setNotifyInterval$",	//399
    "setPixelAspectRatio",	//400
    "setPixelAspectRatio#",	//401
    "setPixelAspectRatio$$",	//402
    "setProperty",	//403
    "setProperty$#",	//404
    "setSampleRate",	//405
    "setSampleRate$",	//406
    "setSampleSize",	//407
    "setSampleSize$",	//408
    "setSampleType",	//409
    "setSampleType$",	//410
    "setScanLineDirection",	//411
    "setScanLineDirection$",	//412
    "setStartTime",	//413
    "setStartTime$",	//414
    "setViewport",	//415
    "setViewport#",	//416
    "setYCbCrColorSpace",	//417
    "setYCbCrColorSpace$",	//418
    "size",	//419
    "sizeHint",	//420
    "start",	//421
    "start#",	//422
    "startTime",	//423
    "state",	//424
    "stateChanged",	//425
    "stateChanged$",	//426
    "staticMetaObject",	//427
    "stop",	//428
    "supportedByteOrders",	//429
    "supportedChannelCounts",	//430
    "supportedChannels",	//431
    "supportedCodecs",	//432
    "supportedFormatsChanged",	//433
    "supportedFrequencies",	//434
    "supportedPixelFormats",	//435
    "supportedPixelFormats$",	//436
    "supportedSampleRates",	//437
    "supportedSampleSizes",	//438
    "supportedSampleTypes",	//439
    "surfaceFormat",	//440
    "surfaceFormatChanged",	//441
    "surfaceFormatChanged#",	//442
    "suspend",	//443
    "timerEvent",	//444
    "tr",	//445
    "tr$",	//446
    "tr$$",	//447
    "tr$$$",	//448
    "trUtf8",	//449
    "trUtf8$",	//450
    "trUtf8$$",	//451
    "trUtf8$$$",	//452
    "unmap",	//453
    "viewport",	//454
    "width",	//455
    "yCbCrColorSpace",	//456
    "~QAbstractVideoBuffer",	//457
    "~QAbstractVideoSurface",	//458
    "~QAudioDeviceInfo",	//459
    "~QAudioFormat",	//460
    "~QAudioInput",	//461
    "~QAudioOutput",	//462
    "~QVideoFrame",	//463
    "~QVideoSurfaceFormat",	//464
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {1, 52, 1, 1, Smoke::mf_ctor, 4, 1},	//1 QAbstractVideoBuffer::QAbstractVideoBuffer(QAbstractVideoBuffer::HandleType)
    {1, 218, 0, 0, Smoke::mf_const, 5, 2},	//2 QAbstractVideoBuffer::handleType() const
    {1, 233, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 6, 3},	//3 QAbstractVideoBuffer::mapMode() const [pure virtual]
    {1, 230, 3, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 349, 4},	//4 QAbstractVideoBuffer::map(QAbstractVideoBuffer::MapMode, int*, int*) [pure virtual]
    {1, 453, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 5},	//5 QAbstractVideoBuffer::unmap() [pure virtual]
    {1, 217, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 189, 6},	//6 QAbstractVideoBuffer::handle() const
    {1, 48, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 7},	//7 QAbstractVideoBuffer::NoHandle (enum)
    {1, 41, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 8},	//8 QAbstractVideoBuffer::GLTextureHandle (enum)
    {1, 177, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 9},	//9 QAbstractVideoBuffer::XvShmImageHandle (enum)
    {1, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 10},	//10 QAbstractVideoBuffer::CoreImageHandle (enum)
    {1, 68, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 11},	//11 QAbstractVideoBuffer::QPixmapHandle (enum)
    {1, 175, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 12},	//12 QAbstractVideoBuffer::UserHandle (enum)
    {1, 49, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 13},	//13 QAbstractVideoBuffer::NotMapped (enum)
    {1, 77, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 14},	//14 QAbstractVideoBuffer::ReadOnly (enum)
    {1, 176, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 15},	//15 QAbstractVideoBuffer::WriteOnly (enum)
    {1, 78, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 16},	//16 QAbstractVideoBuffer::ReadWrite (enum)
    {1, 457, 0, 0, Smoke::mf_dtor, 0, 17 },	//17 QAbstractVideoBuffer::~QAbstractVideoBuffer()
    {2, 235, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 303, 1},	//18 QAbstractVideoSurface::metaObject() const
    {2, 367, 7, 1, Smoke::mf_virtual, 351, 2},	//19 QAbstractVideoSurface::qt_metacast(const char*)
    {2, 445, 9, 2, Smoke::mf_static, 162, 3},	//20 QAbstractVideoSurface::tr(const char*, const char*)
    {2, 449, 9, 2, Smoke::mf_static, 162, 4},	//21 QAbstractVideoSurface::trUtf8(const char*, const char*)
    {2, 445, 12, 3, Smoke::mf_static, 162, 5},	//22 QAbstractVideoSurface::tr(const char*, const char*, int)
    {2, 449, 12, 3, Smoke::mf_static, 162, 6},	//23 QAbstractVideoSurface::trUtf8(const char*, const char*, int)
    {2, 365, 16, 3, Smoke::mf_virtual, 345, 7},	//24 QAbstractVideoSurface::qt_metacall(QMetaObject::Call, int, void**)
    {2, 54, 20, 1, Smoke::mf_ctor, 7, 8},	//25 QAbstractVideoSurface::QAbstractVideoSurface(QObject*)
    {2, 435, 1, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 123, 9},	//26 QAbstractVideoSurface::supportedPixelFormats(QAbstractVideoBuffer::HandleType) const [pure virtual]
    {2, 223, 22, 1, Smoke::mf_const|Smoke::mf_virtual, 282, 10},	//27 QAbstractVideoSurface::isFormatSupported(const QVideoSurfaceFormat&) const
    {2, 236, 22, 1, Smoke::mf_const|Smoke::mf_virtual, 199, 11},	//28 QAbstractVideoSurface::nearestFormat(const QVideoSurfaceFormat&) const
    {2, 440, 0, 0, Smoke::mf_const, 199, 12},	//29 QAbstractVideoSurface::surfaceFormat() const
    {2, 421, 22, 1, Smoke::mf_virtual, 282, 13},	//30 QAbstractVideoSurface::start(const QVideoSurfaceFormat&)
    {2, 428, 0, 0, Smoke::mf_virtual, 0, 14},	//31 QAbstractVideoSurface::stop()
    {2, 222, 0, 0, Smoke::mf_const, 282, 15},	//32 QAbstractVideoSurface::isActive() const
    {2, 276, 24, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 282, 16},	//33 QAbstractVideoSurface::present(const QVideoFrame&) [pure virtual]
    {2, 207, 0, 0, Smoke::mf_const, 8, 17},	//34 QAbstractVideoSurface::error() const
    {2, 185, 26, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//35 QAbstractVideoSurface::activeChanged(bool)
    {2, 441, 22, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//36 QAbstractVideoSurface::surfaceFormatChanged(const QVideoSurfaceFormat&)
    {2, 433, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 20},	//37 QAbstractVideoSurface::supportedFormatsChanged()
    {2, 387, 28, 1, Smoke::mf_protected, 0, 21},	//38 QAbstractVideoSurface::setError(QAbstractVideoSurface::Error)
    {2, 445, 7, 1, Smoke::mf_static, 162, 22},	//39 QAbstractVideoSurface::tr(const char*)
    {2, 449, 7, 1, Smoke::mf_static, 162, 23},	//40 QAbstractVideoSurface::trUtf8(const char*)
    {2, 54, 0, 0, Smoke::mf_ctor, 7, 24},	//41 QAbstractVideoSurface::QAbstractVideoSurface()
    {2, 435, 0, 0, Smoke::mf_const, 123, 25},	//42 QAbstractVideoSurface::supportedPixelFormats() const
    {2, 427, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 302, 26},	//43 QAbstractVideoSurface::staticMetaObject() const
    {2, 47, 0, 0, Smoke::mf_static|Smoke::mf_enum, 8, 27},	//44 QAbstractVideoSurface::NoError (enum)
    {2, 174, 0, 0, Smoke::mf_static|Smoke::mf_enum, 8, 28},	//45 QAbstractVideoSurface::UnsupportedFormatError (enum)
    {2, 44, 0, 0, Smoke::mf_static|Smoke::mf_enum, 8, 29},	//46 QAbstractVideoSurface::IncorrectFormatError (enum)
    {2, 166, 0, 0, Smoke::mf_static|Smoke::mf_enum, 8, 30},	//47 QAbstractVideoSurface::StoppedError (enum)
    {2, 79, 0, 0, Smoke::mf_static|Smoke::mf_enum, 8, 31},	//48 QAbstractVideoSurface::ResourceError (enum)
    {2, 458, 0, 0, Smoke::mf_dtor, 0, 32 },	//49 QAbstractVideoSurface::~QAbstractVideoSurface()
    {4, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 1},	//50 QAudio::AudioInput (enum)
    {4, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 2},	//51 QAudio::AudioOutput (enum)
    {4, 47, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 3},	//52 QAudio::NoError (enum)
    {4, 50, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 4},	//53 QAudio::OpenError (enum)
    {4, 42, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 5},	//54 QAudio::IOError (enum)
    {4, 172, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 6},	//55 QAudio::UnderrunError (enum)
    {4, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 7},	//56 QAudio::FatalError (enum)
    {4, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 8},	//57 QAudio::ActiveState (enum)
    {4, 168, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 9},	//58 QAudio::SuspendedState (enum)
    {4, 167, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 10},	//59 QAudio::StoppedState (enum)
    {4, 43, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 11},	//60 QAudio::IdleState (enum)
    {5, 56, 0, 0, Smoke::mf_ctor, 21, 1},	//61 QAudioDeviceInfo::QAudioDeviceInfo()
    {5, 56, 30, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 21, 2},	//62 QAudioDeviceInfo::QAudioDeviceInfo(const QAudioDeviceInfo&)
    {5, 259, 30, 1, 0, 20, 3},	//63 QAudioDeviceInfo::operator=(const QAudioDeviceInfo&)
    {5, 226, 0, 0, Smoke::mf_const, 282, 4},	//64 QAudioDeviceInfo::isNull() const
    {5, 203, 0, 0, Smoke::mf_const, 162, 5},	//65 QAudioDeviceInfo::deviceName() const
    {5, 223, 32, 1, Smoke::mf_const, 282, 6},	//66 QAudioDeviceInfo::isFormatSupported(const QAudioFormat&) const
    {5, 275, 0, 0, Smoke::mf_const, 22, 7},	//67 QAudioDeviceInfo::preferredFormat() const
    {5, 236, 32, 1, Smoke::mf_const, 22, 8},	//68 QAudioDeviceInfo::nearestFormat(const QAudioFormat&) const
    {5, 432, 0, 0, Smoke::mf_const, 163, 9},	//69 QAudioDeviceInfo::supportedCodecs() const
    {5, 434, 0, 0, Smoke::mf_const, 124, 10},	//70 QAudioDeviceInfo::supportedFrequencies() const
    {5, 437, 0, 0, Smoke::mf_const, 124, 11},	//71 QAudioDeviceInfo::supportedSampleRates() const
    {5, 431, 0, 0, Smoke::mf_const, 124, 12},	//72 QAudioDeviceInfo::supportedChannels() const
    {5, 430, 0, 0, Smoke::mf_const, 124, 13},	//73 QAudioDeviceInfo::supportedChannelCounts() const
    {5, 438, 0, 0, Smoke::mf_const, 124, 14},	//74 QAudioDeviceInfo::supportedSampleSizes() const
    {5, 429, 0, 0, Smoke::mf_const, 120, 15},	//75 QAudioDeviceInfo::supportedByteOrders() const
    {5, 439, 0, 0, Smoke::mf_const, 121, 16},	//76 QAudioDeviceInfo::supportedSampleTypes() const
    {5, 201, 0, 0, Smoke::mf_static, 19, 17},	//77 QAudioDeviceInfo::defaultInputDevice()
    {5, 202, 0, 0, Smoke::mf_static, 19, 18},	//78 QAudioDeviceInfo::defaultOutputDevice()
    {5, 187, 34, 1, Smoke::mf_static, 119, 19},	//79 QAudioDeviceInfo::availableDevices(QAudio::Mode)
    {5, 459, 0, 0, Smoke::mf_dtor, 0, 20 },	//80 QAudioDeviceInfo::~QAudioDeviceInfo()
    {6, 58, 0, 0, Smoke::mf_ctor, 24, 1},	//81 QAudioFormat::QAudioFormat()
    {6, 58, 32, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 24, 2},	//82 QAudioFormat::QAudioFormat(const QAudioFormat&)
    {6, 259, 32, 1, 0, 23, 3},	//83 QAudioFormat::operator=(const QAudioFormat&)
    {6, 261, 32, 1, Smoke::mf_const, 282, 4},	//84 QAudioFormat::operator==(const QAudioFormat&) const
    {6, 240, 32, 1, Smoke::mf_const, 282, 5},	//85 QAudioFormat::operator!=(const QAudioFormat&) const
    {6, 228, 0, 0, Smoke::mf_const, 282, 6},	//86 QAudioFormat::isValid() const
    {6, 396, 36, 1, 0, 0, 7},	//87 QAudioFormat::setFrequency(int)
    {6, 216, 0, 0, Smoke::mf_const, 345, 8},	//88 QAudioFormat::frequency() const
    {6, 405, 36, 1, 0, 0, 9},	//89 QAudioFormat::setSampleRate(int)
    {6, 371, 0, 0, Smoke::mf_const, 345, 10},	//90 QAudioFormat::sampleRate() const
    {6, 381, 36, 1, 0, 0, 11},	//91 QAudioFormat::setChannels(int)
    {6, 196, 0, 0, Smoke::mf_const, 345, 12},	//92 QAudioFormat::channels() const
    {6, 379, 36, 1, 0, 0, 13},	//93 QAudioFormat::setChannelCount(int)
    {6, 195, 0, 0, Smoke::mf_const, 345, 14},	//94 QAudioFormat::channelCount() const
    {6, 407, 36, 1, 0, 0, 15},	//95 QAudioFormat::setSampleSize(int)
    {6, 372, 0, 0, Smoke::mf_const, 345, 16},	//96 QAudioFormat::sampleSize() const
    {6, 383, 38, 1, 0, 0, 17},	//97 QAudioFormat::setCodec(const QString&)
    {6, 198, 0, 0, Smoke::mf_const, 162, 18},	//98 QAudioFormat::codec() const
    {6, 377, 40, 1, 0, 0, 19},	//99 QAudioFormat::setByteOrder(QAudioFormat::Endian)
    {6, 191, 0, 0, Smoke::mf_const, 25, 20},	//100 QAudioFormat::byteOrder() const
    {6, 409, 42, 1, 0, 0, 21},	//101 QAudioFormat::setSampleType(QAudioFormat::SampleType)
    {6, 373, 0, 0, Smoke::mf_const, 26, 22},	//102 QAudioFormat::sampleType() const
    {6, 173, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 23},	//103 QAudioFormat::Unknown (enum)
    {6, 165, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 24},	//104 QAudioFormat::SignedInt (enum)
    {6, 171, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 25},	//105 QAudioFormat::UnSignedInt (enum)
    {6, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 26},	//106 QAudioFormat::Float (enum)
    {6, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 27},	//107 QAudioFormat::BigEndian (enum)
    {6, 46, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 28},	//108 QAudioFormat::LittleEndian (enum)
    {6, 460, 0, 0, Smoke::mf_dtor, 0, 29 },	//109 QAudioFormat::~QAudioFormat()
    {7, 235, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 303, 1},	//110 QAudioInput::metaObject() const
    {7, 367, 7, 1, Smoke::mf_virtual, 351, 2},	//111 QAudioInput::qt_metacast(const char*)
    {7, 445, 9, 2, Smoke::mf_static, 162, 3},	//112 QAudioInput::tr(const char*, const char*)
    {7, 449, 9, 2, Smoke::mf_static, 162, 4},	//113 QAudioInput::trUtf8(const char*, const char*)
    {7, 445, 12, 3, Smoke::mf_static, 162, 5},	//114 QAudioInput::tr(const char*, const char*, int)
    {7, 449, 12, 3, Smoke::mf_static, 162, 6},	//115 QAudioInput::trUtf8(const char*, const char*, int)
    {7, 365, 16, 3, Smoke::mf_virtual, 345, 7},	//116 QAudioInput::qt_metacall(QMetaObject::Call, int, void**)
    {7, 60, 44, 2, Smoke::mf_ctor, 27, 8},	//117 QAudioInput::QAudioInput(const QAudioFormat&, QObject*)
    {7, 60, 47, 3, Smoke::mf_ctor, 27, 9},	//118 QAudioInput::QAudioInput(const QAudioDeviceInfo&, const QAudioFormat&, QObject*)
    {7, 211, 0, 0, Smoke::mf_const, 22, 10},	//119 QAudioInput::format() const
    {7, 421, 51, 1, 0, 0, 11},	//120 QAudioInput::start(QIODevice*)
    {7, 421, 0, 0, 0, 106, 12},	//121 QAudioInput::start()
    {7, 428, 0, 0, 0, 0, 13},	//122 QAudioInput::stop()
    {7, 369, 0, 0, 0, 0, 14},	//123 QAudioInput::reset()
    {7, 443, 0, 0, 0, 0, 15},	//124 QAudioInput::suspend()
    {7, 370, 0, 0, 0, 0, 16},	//125 QAudioInput::resume()
    {7, 375, 36, 1, 0, 0, 17},	//126 QAudioInput::setBufferSize(int)
    {7, 190, 0, 0, Smoke::mf_const, 345, 18},	//127 QAudioInput::bufferSize() const
    {7, 194, 0, 0, Smoke::mf_const, 345, 19},	//128 QAudioInput::bytesReady() const
    {7, 270, 0, 0, Smoke::mf_const, 345, 20},	//129 QAudioInput::periodSize() const
    {7, 398, 36, 1, 0, 0, 21},	//130 QAudioInput::setNotifyInterval(int)
    {7, 239, 0, 0, Smoke::mf_const, 345, 22},	//131 QAudioInput::notifyInterval() const
    {7, 278, 0, 0, Smoke::mf_const, 348, 23},	//132 QAudioInput::processedUSecs() const
    {7, 205, 0, 0, Smoke::mf_const, 348, 24},	//133 QAudioInput::elapsedUSecs() const
    {7, 207, 0, 0, Smoke::mf_const, 16, 25},	//134 QAudioInput::error() const
    {7, 424, 0, 0, Smoke::mf_const, 18, 26},	//135 QAudioInput::state() const
    {7, 425, 53, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//136 QAudioInput::stateChanged(QAudio::State)
    {7, 238, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 28},	//137 QAudioInput::notify()
    {7, 445, 7, 1, Smoke::mf_static, 162, 29},	//138 QAudioInput::tr(const char*)
    {7, 449, 7, 1, Smoke::mf_static, 162, 30},	//139 QAudioInput::trUtf8(const char*)
    {7, 60, 0, 0, Smoke::mf_ctor, 27, 31},	//140 QAudioInput::QAudioInput()
    {7, 60, 32, 1, Smoke::mf_ctor, 27, 32},	//141 QAudioInput::QAudioInput(const QAudioFormat&)
    {7, 60, 30, 1, Smoke::mf_ctor, 27, 33},	//142 QAudioInput::QAudioInput(const QAudioDeviceInfo&)
    {7, 60, 55, 2, Smoke::mf_ctor, 27, 34},	//143 QAudioInput::QAudioInput(const QAudioDeviceInfo&, const QAudioFormat&)
    {7, 427, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 302, 35},	//144 QAudioInput::staticMetaObject() const
    {7, 461, 0, 0, Smoke::mf_dtor, 0, 36 },	//145 QAudioInput::~QAudioInput()
    {8, 235, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 303, 1},	//146 QAudioOutput::metaObject() const
    {8, 367, 7, 1, Smoke::mf_virtual, 351, 2},	//147 QAudioOutput::qt_metacast(const char*)
    {8, 445, 9, 2, Smoke::mf_static, 162, 3},	//148 QAudioOutput::tr(const char*, const char*)
    {8, 449, 9, 2, Smoke::mf_static, 162, 4},	//149 QAudioOutput::trUtf8(const char*, const char*)
    {8, 445, 12, 3, Smoke::mf_static, 162, 5},	//150 QAudioOutput::tr(const char*, const char*, int)
    {8, 449, 12, 3, Smoke::mf_static, 162, 6},	//151 QAudioOutput::trUtf8(const char*, const char*, int)
    {8, 365, 16, 3, Smoke::mf_virtual, 345, 7},	//152 QAudioOutput::qt_metacall(QMetaObject::Call, int, void**)
    {8, 64, 44, 2, Smoke::mf_ctor, 28, 8},	//153 QAudioOutput::QAudioOutput(const QAudioFormat&, QObject*)
    {8, 64, 47, 3, Smoke::mf_ctor, 28, 9},	//154 QAudioOutput::QAudioOutput(const QAudioDeviceInfo&, const QAudioFormat&, QObject*)
    {8, 211, 0, 0, Smoke::mf_const, 22, 10},	//155 QAudioOutput::format() const
    {8, 421, 51, 1, 0, 0, 11},	//156 QAudioOutput::start(QIODevice*)
    {8, 421, 0, 0, 0, 106, 12},	//157 QAudioOutput::start()
    {8, 428, 0, 0, 0, 0, 13},	//158 QAudioOutput::stop()
    {8, 369, 0, 0, 0, 0, 14},	//159 QAudioOutput::reset()
    {8, 443, 0, 0, 0, 0, 15},	//160 QAudioOutput::suspend()
    {8, 370, 0, 0, 0, 0, 16},	//161 QAudioOutput::resume()
    {8, 375, 36, 1, 0, 0, 17},	//162 QAudioOutput::setBufferSize(int)
    {8, 190, 0, 0, Smoke::mf_const, 345, 18},	//163 QAudioOutput::bufferSize() const
    {8, 192, 0, 0, Smoke::mf_const, 345, 19},	//164 QAudioOutput::bytesFree() const
    {8, 270, 0, 0, Smoke::mf_const, 345, 20},	//165 QAudioOutput::periodSize() const
    {8, 398, 36, 1, 0, 0, 21},	//166 QAudioOutput::setNotifyInterval(int)
    {8, 239, 0, 0, Smoke::mf_const, 345, 22},	//167 QAudioOutput::notifyInterval() const
    {8, 278, 0, 0, Smoke::mf_const, 348, 23},	//168 QAudioOutput::processedUSecs() const
    {8, 205, 0, 0, Smoke::mf_const, 348, 24},	//169 QAudioOutput::elapsedUSecs() const
    {8, 207, 0, 0, Smoke::mf_const, 16, 25},	//170 QAudioOutput::error() const
    {8, 424, 0, 0, Smoke::mf_const, 18, 26},	//171 QAudioOutput::state() const
    {8, 425, 53, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//172 QAudioOutput::stateChanged(QAudio::State)
    {8, 238, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 28},	//173 QAudioOutput::notify()
    {8, 445, 7, 1, Smoke::mf_static, 162, 29},	//174 QAudioOutput::tr(const char*)
    {8, 449, 7, 1, Smoke::mf_static, 162, 30},	//175 QAudioOutput::trUtf8(const char*)
    {8, 64, 0, 0, Smoke::mf_ctor, 28, 31},	//176 QAudioOutput::QAudioOutput()
    {8, 64, 32, 1, Smoke::mf_ctor, 28, 32},	//177 QAudioOutput::QAudioOutput(const QAudioFormat&)
    {8, 64, 30, 1, Smoke::mf_ctor, 28, 33},	//178 QAudioOutput::QAudioOutput(const QAudioDeviceInfo&)
    {8, 64, 55, 2, Smoke::mf_ctor, 28, 34},	//179 QAudioOutput::QAudioOutput(const QAudioDeviceInfo&, const QAudioFormat&)
    {8, 427, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 302, 35},	//180 QAudioOutput::staticMetaObject() const
    {8, 462, 0, 0, Smoke::mf_dtor, 0, 36 },	//181 QAudioOutput::~QAudioOutput()
    {19, 268, 58, 2, Smoke::mf_static, 57, 1},	//182 QGlobalSpace::operator|(QGestureRecognizer::ResultFlag, QGestureRecognizer::ResultFlag)
    {19, 256, 61, 2, Smoke::mf_static, 38, 2},	//183 QGlobalSpace::operator<<(QDebug, const QItemSelectionRange&)
    {19, 256, 64, 2, Smoke::mf_static, 38, 3},	//184 QGlobalSpace::operator<<(QDebug, const QStyleOption&)
    {19, 268, 67, 2, Smoke::mf_static, 44, 4},	//185 QGlobalSpace::operator|(QAbstractItemView::EditTrigger, QAbstractItemView::EditTrigger)
    {19, 266, 70, 2, Smoke::mf_static, 36, 5},	//186 QGlobalSpace::operator>>(QDataStream&, QImage&)
    {19, 256, 73, 2, Smoke::mf_static, 36, 6},	//187 QGlobalSpace::operator<<(QDataStream&, const QSizePolicy&)
    {19, 268, 76, 2, Smoke::mf_static, 111, 7},	//188 QGlobalSpace::operator|(QStyleOptionToolBar::ToolBarFeature, int)
    {19, 256, 79, 2, Smoke::mf_static, 38, 8},	//189 QGlobalSpace::operator<<(QDebug, const QTransform&)
    {19, 256, 82, 2, Smoke::mf_static, 36, 9},	//190 QGlobalSpace::operator<<(QDataStream&, const QTransform&)
    {19, 250, 85, 2, Smoke::mf_static, 128, 10},	//191 QGlobalSpace::operator-(const QMatrix4x4&, const QMatrix4x4&)
    {19, 250, 88, 2, Smoke::mf_static, 337, 11},	//192 QGlobalSpace::operator-(const QVector4D&, const QVector4D&)
    {19, 243, 91, 2, Smoke::mf_static, 147, 12},	//193 QGlobalSpace::operator*(const QPointF&, const QMatrix&)
    {19, 268, 94, 2, Smoke::mf_static, 72, 13},	//194 QGlobalSpace::operator|(QPaintEngine::PaintEngineFeature, QPaintEngine::PaintEngineFeature)
    {19, 243, 97, 2, Smoke::mf_static, 117, 14},	//195 QGlobalSpace::operator*(const QLine&, const QTransform&)
    {19, 348, 100, 2, Smoke::mf_static, 282, 15},	//196 QGlobalSpace::qFuzzyCompare(const QVector2D&, const QVector2D&)
    {19, 348, 103, 2, Smoke::mf_static, 282, 16},	//197 QGlobalSpace::qFuzzyCompare(const QTransform&, const QTransform&)
    {19, 350, 106, 1, Smoke::mf_static, 345, 17},	//198 QGlobalSpace::qGray(unsigned int)
    {19, 268, 108, 2, Smoke::mf_static, 54, 18},	//199 QGlobalSpace::operator|(QFileDialog::Option, QFlags<QFileDialog::Option>)
    {19, 250, 111, 1, Smoke::mf_static, 313, 19},	//200 QGlobalSpace::operator-(const QQuaternion&)
    {19, 268, 113, 2, Smoke::mf_static, 45, 20},	//201 QGlobalSpace::operator|(QAbstractPrintDialog::PrintDialogOption, QAbstractPrintDialog::PrintDialogOption)
    {19, 359, 106, 1, Smoke::mf_static, 345, 21},	//202 QGlobalSpace::qRed(unsigned int)
    {19, 243, 116, 2, Smoke::mf_static, 313, 22},	//203 QGlobalSpace::operator*(const QQuaternion&, double)
    {19, 268, 119, 2, Smoke::mf_static, 81, 23},	//204 QGlobalSpace::operator|(QStyleOptionTab::CornerWidget, QStyleOptionTab::CornerWidget)
    {19, 268, 122, 2, Smoke::mf_static, 80, 24},	//205 QGlobalSpace::operator|(QStyleOptionQ3ListViewItem::Q3ListViewItemFeature, QStyleOptionQ3ListViewItem::Q3ListViewItemFeature)
    {19, 268, 125, 2, Smoke::mf_static, 55, 25},	//206 QGlobalSpace::operator|(QFontComboBox::FontFilter, QFontComboBox::FontFilter)
    {19, 268, 128, 2, Smoke::mf_static, 87, 26},	//207 QGlobalSpace::operator|(QTextFormat::PageBreakFlag, QTextFormat::PageBreakFlag)
    {19, 256, 131, 2, Smoke::mf_static, 38, 27},	//208 QGlobalSpace::operator<<(QDebug, const QFont&)
    {19, 256, 134, 2, Smoke::mf_static, 38, 28},	//209 QGlobalSpace::operator<<(QDebug, const QPolygon&)
    {19, 289, 106, 1, Smoke::mf_static, 345, 29},	//210 QGlobalSpace::qAlpha(unsigned int)
    {19, 268, 137, 2, Smoke::mf_static, 111, 30},	//211 QGlobalSpace::operator|(QStyle::SubControl, int)
    {19, 268, 140, 2, Smoke::mf_static, 52, 31},	//212 QGlobalSpace::operator|(QDockWidget::DockWidgetFeature, QDockWidget::DockWidgetFeature)
    {19, 353, 106, 1, Smoke::mf_static, 345, 32},	//213 QGlobalSpace::qGreen(unsigned int)
    {19, 250, 143, 1, Smoke::mf_static, 333, 33},	//214 QGlobalSpace::operator-(const QVector2D&)
    {19, 314, 145, 6, Smoke::mf_static, 0, 34},	//215 QGlobalSpace::qDrawShadePanel(QPainter*, const QRect&, const QPalette&, bool, int, const QBrush*)
    {19, 314, 152, 3, Smoke::mf_static, 0, 35},	//216 QGlobalSpace::qDrawShadePanel(QPainter*, const QRect&, const QPalette&)
    {19, 314, 156, 4, Smoke::mf_static, 0, 36},	//217 QGlobalSpace::qDrawShadePanel(QPainter*, const QRect&, const QPalette&, bool)
    {19, 314, 161, 5, Smoke::mf_static, 0, 37},	//218 QGlobalSpace::qDrawShadePanel(QPainter*, const QRect&, const QPalette&, bool, int)
    {19, 256, 167, 2, Smoke::mf_static, 36, 38},	//219 QGlobalSpace::operator<<(QDataStream&, const QPalette&)
    {19, 243, 88, 2, Smoke::mf_static, 337, 39},	//220 QGlobalSpace::operator*(const QVector4D&, const QVector4D&)
    {19, 268, 170, 2, Smoke::mf_static, 85, 40},	//221 QGlobalSpace::operator|(QTextDocument::FindFlag, QFlags<QTextDocument::FindFlag>)
    {19, 243, 173, 2, Smoke::mf_static, 313, 41},	//222 QGlobalSpace::operator*(const QQuaternion&, const QQuaternion&)
    {19, 268, 176, 2, Smoke::mf_static, 86, 42},	//223 QGlobalSpace::operator|(QTextEdit::AutoFormattingFlag, QFlags<QTextEdit::AutoFormattingFlag>)
    {19, 268, 179, 2, Smoke::mf_static, 48, 43},	//224 QGlobalSpace::operator|(QAccessible::StateFlag, QFlags<QAccessible::StateFlag>)
    {19, 243, 182, 2, Smoke::mf_static, 150, 44},	//225 QGlobalSpace::operator*(const QPolygonF&, const QTransform&)
    {19, 256, 185, 2, Smoke::mf_static, 38, 45},	//226 QGlobalSpace::operator<<(QDebug, const QPolygonF&)
    {19, 268, 188, 2, Smoke::mf_static, 74, 46},	//227 QGlobalSpace::operator|(QPinchGesture::ChangeFlag, QFlags<QPinchGesture::ChangeFlag>)
    {19, 334, 191, 8, Smoke::mf_static, 0, 47},	//228 QGlobalSpace::qDrawWinButton(QPainter*, int, int, int, int, const QPalette&, bool, const QBrush*)
    {19, 334, 200, 6, Smoke::mf_static, 0, 48},	//229 QGlobalSpace::qDrawWinButton(QPainter*, int, int, int, int, const QPalette&)
    {19, 334, 207, 7, Smoke::mf_static, 0, 49},	//230 QGlobalSpace::qDrawWinButton(QPainter*, int, int, int, int, const QPalette&, bool)
    {19, 268, 215, 2, Smoke::mf_static, 111, 50},	//231 QGlobalSpace::operator|(QWidget::RenderFlag, int)
    {19, 256, 218, 2, Smoke::mf_static, 38, 51},	//232 QGlobalSpace::operator<<(QDebug, const QColor&)
    {19, 268, 221, 2, Smoke::mf_static, 111, 52},	//233 QGlobalSpace::operator|(QTreeWidgetItemIterator::IteratorFlag, int)
    {19, 323, 224, 10, Smoke::mf_static, 0, 53},	//234 QGlobalSpace::qDrawShadeRect(QPainter*, int, int, int, int, const QPalette&, bool, int, int, const QBrush*)
    {19, 323, 200, 6, Smoke::mf_static, 0, 54},	//235 QGlobalSpace::qDrawShadeRect(QPainter*, int, int, int, int, const QPalette&)
    {19, 323, 207, 7, Smoke::mf_static, 0, 55},	//236 QGlobalSpace::qDrawShadeRect(QPainter*, int, int, int, int, const QPalette&, bool)
    {19, 323, 235, 8, Smoke::mf_static, 0, 56},	//237 QGlobalSpace::qDrawShadeRect(QPainter*, int, int, int, int, const QPalette&, bool, int)
    {19, 323, 244, 9, Smoke::mf_static, 0, 57},	//238 QGlobalSpace::qDrawShadeRect(QPainter*, int, int, int, int, const QPalette&, bool, int, int)
    {19, 266, 254, 2, Smoke::mf_static, 36, 58},	//239 QGlobalSpace::operator>>(QDataStream&, QPen&)
    {19, 268, 257, 2, Smoke::mf_static, 57, 59},	//240 QGlobalSpace::operator|(QGestureRecognizer::ResultFlag, QFlags<QGestureRecognizer::ResultFlag>)
    {19, 266, 260, 2, Smoke::mf_static, 36, 60},	//241 QGlobalSpace::operator>>(QDataStream&, QColor&)
    {19, 268, 263, 2, Smoke::mf_static, 59, 61},	//242 QGlobalSpace::operator|(QGraphicsEffect::ChangeFlag, QGraphicsEffect::ChangeFlag)
    {19, 268, 266, 2, Smoke::mf_static, 111, 62},	//243 QGlobalSpace::operator|(QFontDialog::FontDialogOption, int)
    {19, 268, 269, 2, Smoke::mf_static, 111, 63},	//244 QGlobalSpace::operator|(QStyleOptionQ3ListViewItem::Q3ListViewItemFeature, int)
    {19, 243, 272, 2, Smoke::mf_static, 117, 64},	//245 QGlobalSpace::operator*(const QLine&, const QMatrix&)
    {19, 268, 275, 2, Smoke::mf_static, 71, 65},	//246 QGlobalSpace::operator|(QPaintEngine::DirtyFlag, QPaintEngine::DirtyFlag)
    {19, 247, 88, 2, Smoke::mf_static, 337, 66},	//247 QGlobalSpace::operator+(const QVector4D&, const QVector4D&)
    {19, 350, 278, 3, Smoke::mf_static, 345, 67},	//248 QGlobalSpace::qGray(int, int, int)
    {19, 243, 282, 2, Smoke::mf_static, 118, 68},	//249 QGlobalSpace::operator*(const QLineF&, const QMatrix&)
    {19, 243, 285, 2, Smoke::mf_static, 139, 69},	//250 QGlobalSpace::operator*(const QPainterPath&, const QMatrix&)
    {19, 261, 288, 2, Smoke::mf_static, 282, 70},	//251 QGlobalSpace::operator==(const QVector3D&, const QVector3D&)
    {19, 240, 100, 2, Smoke::mf_static, 282, 71},	//252 QGlobalSpace::operator!=(const QVector2D&, const QVector2D&)
    {19, 256, 291, 2, Smoke::mf_static, 36, 72},	//253 QGlobalSpace::operator<<(QDataStream&, const QKeySequence&)
    {19, 256, 294, 2, Smoke::mf_static, 36, 73},	//254 QGlobalSpace::operator<<(QDataStream&, const QTableWidgetItem&)
    {19, 256, 297, 2, Smoke::mf_static, 38, 74},	//255 QGlobalSpace::operator<<(QDebug, QGraphicsItem::GraphicsItemChange)
    {19, 268, 300, 2, Smoke::mf_static, 111, 75},	//256 QGlobalSpace::operator|(QItemSelectionModel::SelectionFlag, int)
    {19, 256, 303, 2, Smoke::mf_static, 36, 76},	//257 QGlobalSpace::operator<<(QDataStream&, const QCursor&)
    {19, 268, 306, 2, Smoke::mf_static, 70, 77},	//258 QGlobalSpace::operator|(QMessageBox::StandardButton, QFlags<QMessageBox::StandardButton>)
    {19, 256, 309, 2, Smoke::mf_static, 36, 78},	//259 QGlobalSpace::operator<<(QDataStream&, const QPicture&)
    {19, 268, 312, 2, Smoke::mf_static, 70, 79},	//260 QGlobalSpace::operator|(QMessageBox::StandardButton, QMessageBox::StandardButton)
    {19, 266, 315, 2, Smoke::mf_static, 36, 80},	//261 QGlobalSpace::operator>>(QDataStream&, QVector4D&)
    {19, 247, 100, 2, Smoke::mf_static, 333, 81},	//262 QGlobalSpace::operator+(const QVector2D&, const QVector2D&)
    {19, 268, 318, 2, Smoke::mf_static, 69, 82},	//263 QGlobalSpace::operator|(QMdiSubWindow::SubWindowOption, QFlags<QMdiSubWindow::SubWindowOption>)
    {19, 256, 321, 2, Smoke::mf_static, 38, 83},	//264 QGlobalSpace::operator<<(QDebug, QFlags<QStyle::StateFlag>)
    {19, 268, 324, 2, Smoke::mf_static, 56, 84},	//265 QGlobalSpace::operator|(QFontDialog::FontDialogOption, QFontDialog::FontDialogOption)
    {19, 256, 327, 2, Smoke::mf_static, 36, 85},	//266 QGlobalSpace::operator<<(QDataStream&, const QTreeWidgetItem&)
    {19, 268, 330, 2, Smoke::mf_static, 73, 86},	//267 QGlobalSpace::operator|(QPainter::RenderHint, QPainter::RenderHint)
    {19, 254, 333, 2, Smoke::mf_static, 185, 87},	//268 QGlobalSpace::operator/(const QTransform&, double)
    {19, 256, 336, 2, Smoke::mf_static, 183, 88},	//269 QGlobalSpace::operator<<(QTextStream&, const QSplitter&)
    {19, 268, 339, 2, Smoke::mf_static, 46, 89},	//270 QGlobalSpace::operator|(QAbstractSpinBox::StepEnabledFlag, QFlags<QAbstractSpinBox::StepEnabledFlag>)
    {19, 243, 342, 2, Smoke::mf_static, 333, 90},	//271 QGlobalSpace::operator*(const QVector2D&, double)
    {19, 268, 345, 2, Smoke::mf_static, 90, 91},	//272 QGlobalSpace::operator|(QTreeWidgetItemIterator::IteratorFlag, QTreeWidgetItemIterator::IteratorFlag)
    {19, 268, 348, 2, Smoke::mf_static, 78, 92},	//273 QGlobalSpace::operator|(QStyleOptionButton::ButtonFeature, QStyleOptionButton::ButtonFeature)
    {19, 243, 351, 2, Smoke::mf_static, 337, 93},	//274 QGlobalSpace::operator*(const QVector4D&, double)
    {19, 268, 354, 2, Smoke::mf_static, 111, 94},	//275 QGlobalSpace::operator|(QStyleOptionButton::ButtonFeature, int)
    {19, 261, 173, 2, Smoke::mf_static, 282, 95},	//276 QGlobalSpace::operator==(const QQuaternion&, const QQuaternion&)
    {19, 287, 0, 0, Smoke::mf_static, 13, 96},	//277 QGlobalSpace::qAccessibleTextCastHelper()
    {19, 348, 85, 2, Smoke::mf_static, 282, 97},	//278 QGlobalSpace::qFuzzyCompare(const QMatrix4x4&, const QMatrix4x4&)
    {19, 254, 357, 2, Smoke::mf_static, 128, 98},	//279 QGlobalSpace::operator/(const QMatrix4x4&, double)
    {19, 243, 360, 2, Smoke::mf_static, 139, 99},	//280 QGlobalSpace::operator*(const QPainterPath&, const QTransform&)
    {19, 256, 363, 2, Smoke::mf_static, 36, 100},	//281 QGlobalSpace::operator<<(QDataStream&, const QBrush&)
    {19, 268, 366, 2, Smoke::mf_static, 68, 101},	//282 QGlobalSpace::operator|(QMdiArea::AreaOption, QFlags<QMdiArea::AreaOption>)
    {19, 268, 369, 2, Smoke::mf_static, 46, 102},	//283 QGlobalSpace::operator|(QAbstractSpinBox::StepEnabledFlag, QAbstractSpinBox::StepEnabledFlag)
    {19, 268, 372, 2, Smoke::mf_static, 111, 103},	//284 QGlobalSpace::operator|(QInputDialog::InputDialogOption, int)
    {19, 268, 375, 2, Smoke::mf_static, 111, 104},	//285 QGlobalSpace::operator|(QStyle::StateFlag, int)
    {19, 247, 85, 2, Smoke::mf_static, 128, 105},	//286 QGlobalSpace::operator+(const QMatrix4x4&, const QMatrix4x4&)
    {19, 243, 100, 2, Smoke::mf_static, 333, 106},	//287 QGlobalSpace::operator*(const QVector2D&, const QVector2D&)
    {19, 266, 378, 2, Smoke::mf_static, 36, 107},	//288 QGlobalSpace::operator>>(QDataStream&, QRegion&)
    {19, 268, 381, 2, Smoke::mf_static, 111, 108},	//289 QGlobalSpace::operator|(QPainter::RenderHint, int)
    {19, 268, 384, 2, Smoke::mf_static, 111, 109},	//290 QGlobalSpace::operator|(QStyleOptionTab::CornerWidget, int)
    {19, 268, 387, 2, Smoke::mf_static, 92, 110},	//291 QGlobalSpace::operator|(QWizard::WizardOption, QWizard::WizardOption)
    {19, 268, 390, 2, Smoke::mf_static, 92, 111},	//292 QGlobalSpace::operator|(QWizard::WizardOption, QFlags<QWizard::WizardOption>)
    {19, 268, 393, 2, Smoke::mf_static, 72, 112},	//293 QGlobalSpace::operator|(QPaintEngine::PaintEngineFeature, QFlags<QPaintEngine::PaintEngineFeature>)
    {19, 268, 396, 2, Smoke::mf_static, 60, 113},	//294 QGlobalSpace::operator|(QGraphicsItem::GraphicsItemFlag, QGraphicsItem::GraphicsItemFlag)
    {19, 314, 399, 9, Smoke::mf_static, 0, 114},	//295 QGlobalSpace::qDrawShadePanel(QPainter*, int, int, int, int, const QPalette&, bool, int, const QBrush*)
    {19, 314, 200, 6, Smoke::mf_static, 0, 115},	//296 QGlobalSpace::qDrawShadePanel(QPainter*, int, int, int, int, const QPalette&)
    {19, 314, 207, 7, Smoke::mf_static, 0, 116},	//297 QGlobalSpace::qDrawShadePanel(QPainter*, int, int, int, int, const QPalette&, bool)
    {19, 314, 235, 8, Smoke::mf_static, 0, 117},	//298 QGlobalSpace::qDrawShadePanel(QPainter*, int, int, int, int, const QPalette&, bool, int)
    {19, 247, 173, 2, Smoke::mf_static, 313, 118},	//299 QGlobalSpace::operator+(const QQuaternion&, const QQuaternion&)
    {19, 243, 409, 2, Smoke::mf_static, 191, 119},	//300 QGlobalSpace::operator*(const QVector3D&, const QMatrix4x4&)
    {19, 334, 412, 5, Smoke::mf_static, 0, 120},	//301 QGlobalSpace::qDrawWinButton(QPainter*, const QRect&, const QPalette&, bool, const QBrush*)
    {19, 334, 152, 3, Smoke::mf_static, 0, 121},	//302 QGlobalSpace::qDrawWinButton(QPainter*, const QRect&, const QPalette&)
    {19, 334, 156, 4, Smoke::mf_static, 0, 122},	//303 QGlobalSpace::qDrawWinButton(QPainter*, const QRect&, const QPalette&, bool)
    {19, 268, 418, 2, Smoke::mf_static, 75, 123},	//304 QGlobalSpace::operator|(QSizePolicy::ControlType, QSizePolicy::ControlType)
    {19, 268, 421, 2, Smoke::mf_static, 111, 124},	//305 QGlobalSpace::operator|(QFontComboBox::FontFilter, int)
    {19, 268, 424, 2, Smoke::mf_static, 111, 125},	//306 QGlobalSpace::operator|(QTextDocument::FindFlag, int)
    {19, 266, 427, 2, Smoke::mf_static, 36, 126},	//307 QGlobalSpace::operator>>(QDataStream&, QCursor&)
    {19, 250, 100, 2, Smoke::mf_static, 333, 127},	//308 QGlobalSpace::operator-(const QVector2D&, const QVector2D&)
    {19, 243, 430, 2, Smoke::mf_static, 335, 128},	//309 QGlobalSpace::operator*(const QVector3D&, double)
    {19, 266, 433, 2, Smoke::mf_static, 36, 129},	//310 QGlobalSpace::operator>>(QDataStream&, QTransform&)
    {19, 243, 436, 2, Smoke::mf_static, 148, 130},	//311 QGlobalSpace::operator*(const QPolygon&, const QMatrix&)
    {19, 268, 439, 2, Smoke::mf_static, 81, 131},	//312 QGlobalSpace::operator|(QStyleOptionTab::CornerWidget, QFlags<QStyleOptionTab::CornerWidget>)
    {19, 256, 442, 2, Smoke::mf_static, 38, 132},	//313 QGlobalSpace::operator<<(QDebug, const QPen&)
    {19, 268, 445, 2, Smoke::mf_static, 83, 133},	//314 QGlobalSpace::operator|(QStyleOptionToolButton::ToolButtonFeature, QStyleOptionToolButton::ToolButtonFeature)
    {19, 323, 448, 7, Smoke::mf_static, 0, 134},	//315 QGlobalSpace::qDrawShadeRect(QPainter*, const QRect&, const QPalette&, bool, int, int, const QBrush*)
    {19, 323, 152, 3, Smoke::mf_static, 0, 135},	//316 QGlobalSpace::qDrawShadeRect(QPainter*, const QRect&, const QPalette&)
    {19, 323, 156, 4, Smoke::mf_static, 0, 136},	//317 QGlobalSpace::qDrawShadeRect(QPainter*, const QRect&, const QPalette&, bool)
    {19, 323, 161, 5, Smoke::mf_static, 0, 137},	//318 QGlobalSpace::qDrawShadeRect(QPainter*, const QRect&, const QPalette&, bool, int)
    {19, 323, 456, 6, Smoke::mf_static, 0, 138},	//319 QGlobalSpace::qDrawShadeRect(QPainter*, const QRect&, const QPalette&, bool, int, int)
    {19, 268, 463, 2, Smoke::mf_static, 86, 139},	//320 QGlobalSpace::operator|(QTextEdit::AutoFormattingFlag, QTextEdit::AutoFormattingFlag)
    {19, 268, 466, 2, Smoke::mf_static, 111, 140},	//321 QGlobalSpace::operator|(QPaintEngine::DirtyFlag, int)
    {19, 268, 469, 2, Smoke::mf_static, 111, 141},	//322 QGlobalSpace::operator|(QGraphicsItem::GraphicsItemFlag, int)
    {19, 256, 472, 2, Smoke::mf_static, 36, 142},	//323 QGlobalSpace::operator<<(QDataStream&, const QPixmap&)
    {19, 243, 475, 2, Smoke::mf_static, 147, 143},	//324 QGlobalSpace::operator*(const QPointF&, const QTransform&)
    {19, 256, 478, 2, Smoke::mf_static, 38, 144},	//325 QGlobalSpace::operator<<(QDebug, const QVector3D&)
    {19, 268, 481, 2, Smoke::mf_static, 52, 145},	//326 QGlobalSpace::operator|(QDockWidget::DockWidgetFeature, QFlags<QDockWidget::DockWidgetFeature>)
    {19, 268, 484, 2, Smoke::mf_static, 111, 146},	//327 QGlobalSpace::operator|(QGraphicsEffect::ChangeFlag, int)
    {19, 298, 487, 8, Smoke::mf_static, 0, 147},	//328 QGlobalSpace::qDrawPlainRect(QPainter*, int, int, int, int, const QColor&, int, const QBrush*)
    {19, 298, 496, 6, Smoke::mf_static, 0, 148},	//329 QGlobalSpace::qDrawPlainRect(QPainter*, int, int, int, int, const QColor&)
    {19, 298, 503, 7, Smoke::mf_static, 0, 149},	//330 QGlobalSpace::qDrawPlainRect(QPainter*, int, int, int, int, const QColor&, int)
    {19, 243, 85, 2, Smoke::mf_static, 128, 150},	//331 QGlobalSpace::operator*(const QMatrix4x4&, const QMatrix4x4&)
    {19, 268, 511, 2, Smoke::mf_static, 75, 151},	//332 QGlobalSpace::operator|(QSizePolicy::ControlType, QFlags<QSizePolicy::ControlType>)
    {19, 268, 514, 2, Smoke::mf_static, 111, 152},	//333 QGlobalSpace::operator|(QAbstractSpinBox::StepEnabledFlag, int)
    {19, 256, 517, 2, Smoke::mf_static, 38, 153},	//334 QGlobalSpace::operator<<(QDebug, const QVector2D&)
    {19, 243, 520, 2, Smoke::mf_static, 193, 154},	//335 QGlobalSpace::operator*(const QMatrix4x4&, const QVector4D&)
    {19, 268, 523, 2, Smoke::mf_static, 111, 155},	//336 QGlobalSpace::operator|(QAccessible::StateFlag, int)
    {19, 298, 526, 5, Smoke::mf_static, 0, 156},	//337 QGlobalSpace::qDrawPlainRect(QPainter*, const QRect&, const QColor&, int, const QBrush*)
    {19, 298, 532, 3, Smoke::mf_static, 0, 157},	//338 QGlobalSpace::qDrawPlainRect(QPainter*, const QRect&, const QColor&)
    {19, 298, 536, 4, Smoke::mf_static, 0, 158},	//339 QGlobalSpace::qDrawPlainRect(QPainter*, const QRect&, const QColor&, int)
    {19, 268, 541, 2, Smoke::mf_static, 74, 159},	//340 QGlobalSpace::operator|(QPinchGesture::ChangeFlag, QPinchGesture::ChangeFlag)
    {19, 268, 544, 2, Smoke::mf_static, 111, 160},	//341 QGlobalSpace::operator|(QDateTimeEdit::Section, int)
    {19, 243, 547, 2, Smoke::mf_static, 146, 161},	//342 QGlobalSpace::operator*(const QPoint&, const QMatrix&)
    {19, 256, 550, 2, Smoke::mf_static, 36, 162},	//343 QGlobalSpace::operator<<(QDataStream&, const QPen&)
    {19, 268, 553, 2, Smoke::mf_static, 91, 163},	//344 QGlobalSpace::operator|(QWidget::RenderFlag, QWidget::RenderFlag)
    {19, 293, 556, 8, Smoke::mf_static, 0, 164},	//345 QGlobalSpace::qDrawBorderPixmap(QPainter*, const QRect&, const QMargins&, const QPixmap&, const QRect&, const QMargins&, const QTileRules&, QFlags<QDrawBorderPixmap::DrawingHint>)
    {19, 293, 565, 6, Smoke::mf_static, 0, 165},	//346 QGlobalSpace::qDrawBorderPixmap(QPainter*, const QRect&, const QMargins&, const QPixmap&, const QRect&, const QMargins&)
    {19, 293, 572, 7, Smoke::mf_static, 0, 166},	//347 QGlobalSpace::qDrawBorderPixmap(QPainter*, const QRect&, const QMargins&, const QPixmap&, const QRect&, const QMargins&, const QTileRules&)
    {19, 268, 580, 2, Smoke::mf_static, 111, 167},	//348 QGlobalSpace::operator|(QColorDialog::ColorDialogOption, int)
    {19, 266, 583, 2, Smoke::mf_static, 36, 168},	//349 QGlobalSpace::operator>>(QDataStream&, QIcon&)
    {19, 256, 586, 2, Smoke::mf_static, 36, 169},	//350 QGlobalSpace::operator<<(QDataStream&, const QPolygon&)
    {19, 243, 333, 2, Smoke::mf_static, 185, 170},	//351 QGlobalSpace::operator*(const QTransform&, double)
    {19, 268, 589, 2, Smoke::mf_static, 91, 171},	//352 QGlobalSpace::operator|(QWidget::RenderFlag, QFlags<QWidget::RenderFlag>)
    {19, 268, 592, 2, Smoke::mf_static, 111, 172},	//353 QGlobalSpace::operator|(QTextFormat::PageBreakFlag, int)
    {19, 268, 595, 2, Smoke::mf_static, 111, 173},	//354 QGlobalSpace::operator|(QImageIOPlugin::Capability, int)
    {19, 256, 598, 2, Smoke::mf_static, 38, 174},	//355 QGlobalSpace::operator<<(QDebug, QFlags<QGraphicsItem::GraphicsItemFlag>)
    {19, 268, 601, 2, Smoke::mf_static, 111, 175},	//356 QGlobalSpace::operator|(QGraphicsView::CacheModeFlag, int)
    {19, 268, 604, 2, Smoke::mf_static, 111, 176},	//357 QGlobalSpace::operator|(QAbstractItemView::EditTrigger, int)
    {19, 256, 607, 2, Smoke::mf_static, 38, 177},	//358 QGlobalSpace::operator<<(QDebug, const QVector4D&)
    {19, 268, 610, 2, Smoke::mf_static, 111, 178},	//359 QGlobalSpace::operator|(QWizard::WizardOption, int)
    {19, 268, 613, 2, Smoke::mf_static, 111, 179},	//360 QGlobalSpace::operator|(QFileDialog::Option, int)
    {19, 268, 616, 2, Smoke::mf_static, 76, 180},	//361 QGlobalSpace::operator|(QStyle::StateFlag, QFlags<QStyle::StateFlag>)
    {19, 254, 351, 2, Smoke::mf_static, 337, 181},	//362 QGlobalSpace::operator/(const QVector4D&, double)
    {19, 243, 619, 2, Smoke::mf_static, 146, 182},	//363 QGlobalSpace::operator*(const QMatrix4x4&, const QPoint&)
    {19, 268, 622, 2, Smoke::mf_static, 83, 183},	//364 QGlobalSpace::operator|(QStyleOptionToolButton::ToolButtonFeature, QFlags<QStyleOptionToolButton::ToolButtonFeature>)
    {19, 268, 625, 2, Smoke::mf_static, 61, 184},	//365 QGlobalSpace::operator|(QGraphicsScene::SceneLayer, QFlags<QGraphicsScene::SceneLayer>)
    {19, 254, 116, 2, Smoke::mf_static, 313, 185},	//366 QGlobalSpace::operator/(const QQuaternion&, double)
    {19, 268, 628, 2, Smoke::mf_static, 68, 186},	//367 QGlobalSpace::operator|(QMdiArea::AreaOption, QMdiArea::AreaOption)
    {19, 266, 631, 2, Smoke::mf_static, 36, 187},	//368 QGlobalSpace::operator>>(QDataStream&, QStandardItem&)
    {19, 284, 0, 0, Smoke::mf_static, 13, 188},	//369 QGlobalSpace::qAccessibleImageCastHelper()
    {19, 268, 634, 2, Smoke::mf_static, 111, 189},	//370 QGlobalSpace::operator|(QPaintEngine::PaintEngineFeature, int)
    {19, 256, 637, 2, Smoke::mf_static, 38, 190},	//371 QGlobalSpace::operator<<(QDebug, const QPainterPath&)
    {19, 268, 640, 2, Smoke::mf_static, 49, 191},	//372 QGlobalSpace::operator|(QColorDialog::ColorDialogOption, QFlags<QColorDialog::ColorDialogOption>)
    {19, 266, 643, 2, Smoke::mf_static, 36, 192},	//373 QGlobalSpace::operator>>(QDataStream&, QBrush&)
    {19, 266, 646, 2, Smoke::mf_static, 36, 193},	//374 QGlobalSpace::operator>>(QDataStream&, QMatrix4x4&)
    {19, 250, 649, 1, Smoke::mf_static, 337, 194},	//375 QGlobalSpace::operator-(const QVector4D&)
    {19, 256, 651, 2, Smoke::mf_static, 38, 195},	//376 QGlobalSpace::operator<<(QDebug, const QMatrix4x4&)
    {19, 268, 654, 2, Smoke::mf_static, 111, 196},	//377 QGlobalSpace::operator|(QGraphicsView::OptimizationFlag, int)
    {19, 266, 657, 2, Smoke::mf_static, 36, 197},	//378 QGlobalSpace::operator>>(QDataStream&, QTextFormat&)
    {19, 240, 288, 2, Smoke::mf_static, 282, 198},	//379 QGlobalSpace::operator!=(const QVector3D&, const QVector3D&)
    {19, 261, 100, 2, Smoke::mf_static, 282, 199},	//380 QGlobalSpace::operator==(const QVector2D&, const QVector2D&)
    {19, 254, 342, 2, Smoke::mf_static, 333, 200},	//381 QGlobalSpace::operator/(const QVector2D&, double)
    {19, 266, 660, 2, Smoke::mf_static, 36, 201},	//382 QGlobalSpace::operator>>(QDataStream&, QListWidgetItem&)
    {19, 268, 663, 2, Smoke::mf_static, 59, 202},	//383 QGlobalSpace::operator|(QGraphicsEffect::ChangeFlag, QFlags<QGraphicsEffect::ChangeFlag>)
    {19, 268, 666, 2, Smoke::mf_static, 58, 203},	//384 QGlobalSpace::operator|(QGraphicsBlurEffect::BlurHint, QFlags<QGraphicsBlurEffect::BlurHint>)
    {19, 268, 669, 2, Smoke::mf_static, 111, 204},	//385 QGlobalSpace::operator|(QStyleOptionToolButton::ToolButtonFeature, int)
    {19, 286, 0, 0, Smoke::mf_static, 13, 205},	//386 QGlobalSpace::qAccessibleTableCastHelper()
    {19, 268, 672, 2, Smoke::mf_static, 111, 206},	//387 QGlobalSpace::operator|(QMessageBox::StandardButton, int)
    {19, 243, 357, 2, Smoke::mf_static, 128, 207},	//388 QGlobalSpace::operator*(const QMatrix4x4&, double)
    {19, 256, 675, 2, Smoke::mf_static, 38, 208},	//389 QGlobalSpace::operator<<(QDebug, QGraphicsItem::GraphicsItemFlag)
    {19, 268, 678, 2, Smoke::mf_static, 47, 209},	//390 QGlobalSpace::operator|(QAccessible::RelationFlag, QFlags<QAccessible::RelationFlag>)
    {19, 261, 681, 2, Smoke::mf_static, 282, 210},	//391 QGlobalSpace::operator==(QKeySequence::StandardKey, QKeyEvent*)
    {19, 268, 684, 2, Smoke::mf_static, 111, 211},	//392 QGlobalSpace::operator|(QSizePolicy::ControlType, int)
    {19, 266, 687, 2, Smoke::mf_static, 36, 212},	//393 QGlobalSpace::operator>>(QDataStream&, QSizePolicy&)
    {19, 266, 690, 2, Smoke::mf_static, 36, 213},	//394 QGlobalSpace::operator>>(QDataStream&, QMatrix&)
    {19, 268, 693, 2, Smoke::mf_static, 80, 214},	//395 QGlobalSpace::operator|(QStyleOptionQ3ListViewItem::Q3ListViewItemFeature, QFlags<QStyleOptionQ3ListViewItem::Q3ListViewItemFeature>)
    {19, 357, 106, 1, Smoke::mf_static, 282, 215},	//396 QGlobalSpace::qIsGray(unsigned int)
    {19, 243, 696, 2, Smoke::mf_static, 147, 216},	//397 QGlobalSpace::operator*(const QMatrix4x4&, const QPointF&)
    {19, 250, 699, 1, Smoke::mf_static, 128, 217},	//398 QGlobalSpace::operator-(const QMatrix4x4&)
    {19, 243, 701, 2, Smoke::mf_static, 333, 218},	//399 QGlobalSpace::operator*(double, const QVector2D&)
    {19, 268, 704, 2, Smoke::mf_static, 45, 219},	//400 QGlobalSpace::operator|(QAbstractPrintDialog::PrintDialogOption, QFlags<QAbstractPrintDialog::PrintDialogOption>)
    {19, 268, 707, 2, Smoke::mf_static, 65, 220},	//401 QGlobalSpace::operator|(QInputDialog::InputDialogOption, QInputDialog::InputDialogOption)
    {19, 268, 710, 2, Smoke::mf_static, 111, 221},	//402 QGlobalSpace::operator|(QAbstractPrintDialog::PrintDialogOption, int)
    {19, 256, 713, 2, Smoke::mf_static, 36, 222},	//403 QGlobalSpace::operator<<(QDataStream&, const QVector3D&)
    {19, 243, 716, 2, Smoke::mf_static, 118, 223},	//404 QGlobalSpace::operator*(const QLineF&, const QTransform&)
    {19, 256, 719, 2, Smoke::mf_static, 36, 224},	//405 QGlobalSpace::operator<<(QDataStream&, const QPolygonF&)
    {19, 243, 722, 2, Smoke::mf_static, 335, 225},	//406 QGlobalSpace::operator*(double, const QVector3D&)
    {19, 256, 725, 2, Smoke::mf_static, 36, 226},	//407 QGlobalSpace::operator<<(QDataStream&, const QFont&)
    {19, 268, 728, 2, Smoke::mf_static, 89, 227},	//408 QGlobalSpace::operator|(QTextOption::Flag, QFlags<QTextOption::Flag>)
    {19, 266, 731, 2, Smoke::mf_static, 36, 228},	//409 QGlobalSpace::operator>>(QDataStream&, QTableWidgetItem&)
    {19, 268, 734, 2, Smoke::mf_static, 77, 229},	//410 QGlobalSpace::operator|(QStyle::SubControl, QFlags<QStyle::SubControl>)
    {19, 261, 88, 2, Smoke::mf_static, 282, 230},	//411 QGlobalSpace::operator==(const QVector4D&, const QVector4D&)
    {19, 256, 737, 2, Smoke::mf_static, 36, 231},	//412 QGlobalSpace::operator<<(QDataStream&, const QVector2D&)
    {19, 256, 740, 2, Smoke::mf_static, 36, 232},	//413 QGlobalSpace::operator<<(QDataStream&, const QMatrix&)
    {19, 254, 430, 2, Smoke::mf_static, 335, 233},	//414 QGlobalSpace::operator/(const QVector3D&, double)
    {19, 268, 743, 2, Smoke::mf_static, 73, 234},	//415 QGlobalSpace::operator|(QPainter::RenderHint, QFlags<QPainter::RenderHint>)
    {19, 243, 746, 2, Smoke::mf_static, 128, 235},	//416 QGlobalSpace::operator*(double, const QMatrix4x4&)
    {19, 268, 749, 2, Smoke::mf_static, 63, 236},	//417 QGlobalSpace::operator|(QGraphicsView::OptimizationFlag, QFlags<QGraphicsView::OptimizationFlag>)
    {19, 361, 278, 3, Smoke::mf_static, 350, 237},	//418 QGlobalSpace::qRgb(int, int, int)
    {19, 348, 88, 2, Smoke::mf_static, 282, 238},	//419 QGlobalSpace::qFuzzyCompare(const QVector4D&, const QVector4D&)
    {19, 268, 752, 2, Smoke::mf_static, 88, 239},	//420 QGlobalSpace::operator|(QTextItem::RenderFlag, QTextItem::RenderFlag)
    {19, 268, 755, 2, Smoke::mf_static, 62, 240},	//421 QGlobalSpace::operator|(QGraphicsView::CacheModeFlag, QGraphicsView::CacheModeFlag)
    {19, 266, 758, 2, Smoke::mf_static, 36, 241},	//422 QGlobalSpace::operator>>(QDataStream&, QPolygonF&)
    {19, 268, 761, 2, Smoke::mf_static, 90, 242},	//423 QGlobalSpace::operator|(QTreeWidgetItemIterator::IteratorFlag, QFlags<QTreeWidgetItemIterator::IteratorFlag>)
    {19, 266, 764, 2, Smoke::mf_static, 36, 243},	//424 QGlobalSpace::operator>>(QDataStream&, QPalette&)
    {19, 256, 767, 2, Smoke::mf_static, 36, 244},	//425 QGlobalSpace::operator<<(QDataStream&, const QPainterPath&)
    {19, 268, 770, 2, Smoke::mf_static, 48, 245},	//426 QGlobalSpace::operator|(QAccessible::StateFlag, QAccessible::StateFlag)
    {19, 261, 773, 2, Smoke::mf_static, 282, 246},	//427 QGlobalSpace::operator==(QKeyEvent*, QKeySequence::StandardKey)
    {19, 268, 776, 2, Smoke::mf_static, 62, 247},	//428 QGlobalSpace::operator|(QGraphicsView::CacheModeFlag, QFlags<QGraphicsView::CacheModeFlag>)
    {19, 268, 779, 2, Smoke::mf_static, 77, 248},	//429 QGlobalSpace::operator|(QStyle::SubControl, QStyle::SubControl)
    {19, 288, 0, 0, Smoke::mf_static, 13, 249},	//430 QGlobalSpace::qAccessibleValueCastHelper()
    {19, 268, 782, 2, Smoke::mf_static, 44, 250},	//431 QGlobalSpace::operator|(QAbstractItemView::EditTrigger, QFlags<QAbstractItemView::EditTrigger>)
    {19, 268, 785, 2, Smoke::mf_static, 111, 251},	//432 QGlobalSpace::operator|(QPinchGesture::ChangeFlag, int)
    {19, 266, 788, 2, Smoke::mf_static, 36, 252},	//433 QGlobalSpace::operator>>(QDataStream&, QQuaternion&)
    {19, 243, 791, 2, Smoke::mf_static, 193, 253},	//434 QGlobalSpace::operator*(const QVector4D&, const QMatrix4x4&)
    {19, 348, 794, 2, Smoke::mf_static, 282, 254},	//435 QGlobalSpace::qFuzzyCompare(const QMatrix&, const QMatrix&)
    {19, 268, 797, 2, Smoke::mf_static, 84, 255},	//436 QGlobalSpace::operator|(QStyleOptionViewItemV2::ViewItemFeature, QStyleOptionViewItemV2::ViewItemFeature)
    {19, 268, 800, 2, Smoke::mf_static, 67, 256},	//437 QGlobalSpace::operator|(QMainWindow::DockOption, QFlags<QMainWindow::DockOption>)
    {19, 256, 803, 2, Smoke::mf_static, 38, 257},	//438 QGlobalSpace::operator<<(QDebug, QGraphicsObject*)
    {19, 268, 806, 2, Smoke::mf_static, 69, 258},	//439 QGlobalSpace::operator|(QMdiSubWindow::SubWindowOption, QMdiSubWindow::SubWindowOption)
    {19, 256, 809, 2, Smoke::mf_static, 36, 259},	//440 QGlobalSpace::operator<<(QDataStream&, const QImage&)
    {19, 243, 812, 2, Smoke::mf_static, 313, 260},	//441 QGlobalSpace::operator*(double, const QQuaternion&)
    {19, 268, 815, 2, Smoke::mf_static, 85, 261},	//442 QGlobalSpace::operator|(QTextDocument::FindFlag, QTextDocument::FindFlag)
    {19, 256, 818, 2, Smoke::mf_static, 38, 262},	//443 QGlobalSpace::operator<<(QDebug, const QKeySequence&)
    {19, 268, 821, 2, Smoke::mf_static, 71, 263},	//444 QGlobalSpace::operator|(QPaintEngine::DirtyFlag, QFlags<QPaintEngine::DirtyFlag>)
    {19, 268, 824, 2, Smoke::mf_static, 51, 264},	//445 QGlobalSpace::operator|(QDialogButtonBox::StandardButton, QDialogButtonBox::StandardButton)
    {19, 268, 827, 2, Smoke::mf_static, 47, 265},	//446 QGlobalSpace::operator|(QAccessible::RelationFlag, QAccessible::RelationFlag)
    {19, 348, 288, 2, Smoke::mf_static, 282, 266},	//447 QGlobalSpace::qFuzzyCompare(const QVector3D&, const QVector3D&)
    {19, 268, 830, 2, Smoke::mf_static, 61, 267},	//448 QGlobalSpace::operator|(QGraphicsScene::SceneLayer, QGraphicsScene::SceneLayer)
    {19, 256, 833, 2, Smoke::mf_static, 38, 268},	//449 QGlobalSpace::operator<<(QDebug, const QEvent*)
    {19, 266, 836, 2, Smoke::mf_static, 36, 269},	//450 QGlobalSpace::operator>>(QDataStream&, QFont&)
    {19, 268, 839, 2, Smoke::mf_static, 65, 270},	//451 QGlobalSpace::operator|(QInputDialog::InputDialogOption, QFlags<QInputDialog::InputDialogOption>)
    {19, 268, 842, 2, Smoke::mf_static, 66, 271},	//452 QGlobalSpace::operator|(QItemSelectionModel::SelectionFlag, QFlags<QItemSelectionModel::SelectionFlag>)
    {19, 285, 0, 0, Smoke::mf_static, 13, 272},	//453 QGlobalSpace::qAccessibleTable2CastHelper()
    {19, 268, 845, 2, Smoke::mf_static, 111, 273},	//454 QGlobalSpace::operator|(QGestureRecognizer::ResultFlag, int)
    {19, 243, 848, 2, Smoke::mf_static, 148, 274},	//455 QGlobalSpace::operator*(const QPolygon&, const QTransform&)
    {19, 268, 851, 2, Smoke::mf_static, 84, 275},	//456 QGlobalSpace::operator|(QStyleOptionViewItemV2::ViewItemFeature, QFlags<QStyleOptionViewItemV2::ViewItemFeature>)
    {19, 266, 854, 2, Smoke::mf_static, 36, 276},	//457 QGlobalSpace::operator>>(QDataStream&, QTextLength&)
    {19, 348, 173, 2, Smoke::mf_static, 282, 277},	//458 QGlobalSpace::qFuzzyCompare(const QQuaternion&, const QQuaternion&)
    {19, 305, 244, 9, Smoke::mf_static, 0, 278},	//459 QGlobalSpace::qDrawShadeLine(QPainter*, int, int, int, int, const QPalette&, bool, int, int)
    {19, 305, 200, 6, Smoke::mf_static, 0, 279},	//460 QGlobalSpace::qDrawShadeLine(QPainter*, int, int, int, int, const QPalette&)
    {19, 305, 207, 7, Smoke::mf_static, 0, 280},	//461 QGlobalSpace::qDrawShadeLine(QPainter*, int, int, int, int, const QPalette&, bool)
    {19, 305, 235, 8, Smoke::mf_static, 0, 281},	//462 QGlobalSpace::qDrawShadeLine(QPainter*, int, int, int, int, const QPalette&, bool, int)
    {19, 256, 857, 2, Smoke::mf_static, 36, 282},	//463 QGlobalSpace::operator<<(QDataStream&, const QRegion&)
    {19, 256, 860, 2, Smoke::mf_static, 38, 283},	//464 QGlobalSpace::operator<<(QDebug, const QMatrix&)
    {19, 268, 863, 2, Smoke::mf_static, 111, 284},	//465 QGlobalSpace::operator|(QGraphicsBlurEffect::BlurHint, int)
    {19, 268, 866, 2, Smoke::mf_static, 89, 285},	//466 QGlobalSpace::operator|(QTextOption::Flag, QTextOption::Flag)
    {19, 256, 869, 2, Smoke::mf_static, 36, 286},	//467 QGlobalSpace::operator<<(QDataStream&, const QColor&)
    {19, 268, 872, 2, Smoke::mf_static, 50, 287},	//468 QGlobalSpace::operator|(QDateTimeEdit::Section, QDateTimeEdit::Section)
    {19, 283, 0, 0, Smoke::mf_static, 13, 288},	//469 QGlobalSpace::qAccessibleEditableTextCastHelper()
    {19, 243, 875, 2, Smoke::mf_static, 191, 289},	//470 QGlobalSpace::operator*(const QMatrix4x4&, const QVector3D&)
    {19, 256, 878, 2, Smoke::mf_static, 38, 290},	//471 QGlobalSpace::operator<<(QDebug, const QBrush&)
    {19, 268, 881, 2, Smoke::mf_static, 79, 291},	//472 QGlobalSpace::operator|(QStyleOptionFrameV2::FrameFeature, QStyleOptionFrameV2::FrameFeature)
    {19, 266, 884, 2, Smoke::mf_static, 36, 292},	//473 QGlobalSpace::operator>>(QDataStream&, QTreeWidgetItem&)
    {19, 266, 887, 2, Smoke::mf_static, 36, 293},	//474 QGlobalSpace::operator>>(QDataStream&, QKeySequence&)
    {19, 268, 890, 2, Smoke::mf_static, 111, 294},	//475 QGlobalSpace::operator|(QTextEdit::AutoFormattingFlag, int)
    {19, 247, 288, 2, Smoke::mf_static, 335, 295},	//476 QGlobalSpace::operator+(const QVector3D&, const QVector3D&)
    {19, 256, 893, 2, Smoke::mf_static, 38, 296},	//477 QGlobalSpace::operator<<(QDebug, const QVideoSurfaceFormat&)
    {19, 268, 896, 2, Smoke::mf_static, 64, 297},	//478 QGlobalSpace::operator|(QImageIOPlugin::Capability, QFlags<QImageIOPlugin::Capability>)
    {19, 256, 899, 2, Smoke::mf_static, 36, 298},	//479 QGlobalSpace::operator<<(QDataStream&, const QTextLength&)
    {19, 243, 902, 2, Smoke::mf_static, 155, 299},	//480 QGlobalSpace::operator*(const QRegion&, const QTransform&)
    {19, 243, 905, 2, Smoke::mf_static, 147, 300},	//481 QGlobalSpace::operator*(const QPointF&, const QMatrix4x4&)
    {19, 256, 908, 2, Smoke::mf_static, 38, 301},	//482 QGlobalSpace::operator<<(QDebug, QGraphicsItem*)
    {19, 268, 911, 2, Smoke::mf_static, 111, 302},	//483 QGlobalSpace::operator|(QDockWidget::DockWidgetFeature, int)
    {19, 256, 914, 2, Smoke::mf_static, 36, 303},	//484 QGlobalSpace::operator<<(QDataStream&, const QListWidgetItem&)
    {19, 268, 917, 2, Smoke::mf_static, 111, 304},	//485 QGlobalSpace::operator|(QGraphicsScene::SceneLayer, int)
    {19, 256, 920, 2, Smoke::mf_static, 38, 305},	//486 QGlobalSpace::operator<<(QDebug, const QStyleOption::OptionType&)
    {19, 256, 923, 2, Smoke::mf_static, 36, 306},	//487 QGlobalSpace::operator<<(QDataStream&, const QStandardItem&)
    {19, 243, 926, 2, Smoke::mf_static, 150, 307},	//488 QGlobalSpace::operator*(const QPolygonF&, const QMatrix&)
    {19, 240, 173, 2, Smoke::mf_static, 282, 308},	//489 QGlobalSpace::operator!=(const QQuaternion&, const QQuaternion&)
    {19, 268, 929, 2, Smoke::mf_static, 111, 309},	//490 QGlobalSpace::operator|(QAccessible::RelationFlag, int)
    {19, 266, 932, 2, Smoke::mf_static, 36, 310},	//491 QGlobalSpace::operator>>(QDataStream&, QPolygon&)
    {19, 240, 88, 2, Smoke::mf_static, 282, 311},	//492 QGlobalSpace::operator!=(const QVector4D&, const QVector4D&)
    {19, 293, 935, 4, Smoke::mf_static, 0, 312},	//493 QGlobalSpace::qDrawBorderPixmap(QPainter*, const QRect&, const QMargins&, const QPixmap&)
    {19, 268, 940, 2, Smoke::mf_static, 55, 313},	//494 QGlobalSpace::operator|(QFontComboBox::FontFilter, QFlags<QFontComboBox::FontFilter>)
    {19, 268, 943, 2, Smoke::mf_static, 54, 314},	//495 QGlobalSpace::operator|(QFileDialog::Option, QFileDialog::Option)
    {19, 268, 946, 2, Smoke::mf_static, 111, 315},	//496 QGlobalSpace::operator|(QMdiArea::AreaOption, int)
    {19, 268, 949, 2, Smoke::mf_static, 50, 316},	//497 QGlobalSpace::operator|(QDateTimeEdit::Section, QFlags<QDateTimeEdit::Section>)
    {19, 268, 952, 2, Smoke::mf_static, 51, 317},	//498 QGlobalSpace::operator|(QDialogButtonBox::StandardButton, QFlags<QDialogButtonBox::StandardButton>)
    {19, 305, 955, 7, Smoke::mf_static, 0, 318},	//499 QGlobalSpace::qDrawShadeLine(QPainter*, const QPoint&, const QPoint&, const QPalette&, bool, int, int)
    {19, 305, 963, 4, Smoke::mf_static, 0, 319},	//500 QGlobalSpace::qDrawShadeLine(QPainter*, const QPoint&, const QPoint&, const QPalette&)
    {19, 305, 968, 5, Smoke::mf_static, 0, 320},	//501 QGlobalSpace::qDrawShadeLine(QPainter*, const QPoint&, const QPoint&, const QPalette&, bool)
    {19, 305, 974, 6, Smoke::mf_static, 0, 321},	//502 QGlobalSpace::qDrawShadeLine(QPainter*, const QPoint&, const QPoint&, const QPalette&, bool, int)
    {19, 268, 981, 2, Smoke::mf_static, 66, 322},	//503 QGlobalSpace::operator|(QItemSelectionModel::SelectionFlag, QItemSelectionModel::SelectionFlag)
    {19, 243, 288, 2, Smoke::mf_static, 335, 323},	//504 QGlobalSpace::operator*(const QVector3D&, const QVector3D&)
    {19, 341, 412, 5, Smoke::mf_static, 0, 324},	//505 QGlobalSpace::qDrawWinPanel(QPainter*, const QRect&, const QPalette&, bool, const QBrush*)
    {19, 341, 152, 3, Smoke::mf_static, 0, 325},	//506 QGlobalSpace::qDrawWinPanel(QPainter*, const QRect&, const QPalette&)
    {19, 341, 156, 4, Smoke::mf_static, 0, 326},	//507 QGlobalSpace::qDrawWinPanel(QPainter*, const QRect&, const QPalette&, bool)
    {19, 266, 984, 2, Smoke::mf_static, 183, 327},	//508 QGlobalSpace::operator>>(QTextStream&, QSplitter&)
    {19, 256, 987, 2, Smoke::mf_static, 36, 328},	//509 QGlobalSpace::operator<<(QDataStream&, const QMatrix4x4&)
    {19, 247, 333, 2, Smoke::mf_static, 185, 329},	//510 QGlobalSpace::operator+(const QTransform&, double)
    {19, 256, 990, 2, Smoke::mf_static, 36, 330},	//511 QGlobalSpace::operator<<(QDataStream&, const QVector4D&)
    {19, 268, 993, 2, Smoke::mf_static, 76, 331},	//512 QGlobalSpace::operator|(QStyle::StateFlag, QStyle::StateFlag)
    {19, 355, 996, 1, Smoke::mf_static, 350, 332},	//513 QGlobalSpace::qHash(const QItemSelectionRange&)
    {19, 266, 998, 2, Smoke::mf_static, 36, 333},	//514 QGlobalSpace::operator>>(QDataStream&, QPixmap&)
    {19, 243, 1001, 2, Smoke::mf_static, 146, 334},	//515 QGlobalSpace::operator*(const QPoint&, const QMatrix4x4&)
    {19, 268, 1004, 2, Smoke::mf_static, 56, 335},	//516 QGlobalSpace::operator|(QFontDialog::FontDialogOption, QFlags<QFontDialog::FontDialogOption>)
    {19, 268, 1007, 2, Smoke::mf_static, 63, 336},	//517 QGlobalSpace::operator|(QGraphicsView::OptimizationFlag, QGraphicsView::OptimizationFlag)
    {19, 250, 1010, 1, Smoke::mf_static, 335, 337},	//518 QGlobalSpace::operator-(const QVector3D&)
    {19, 268, 1012, 2, Smoke::mf_static, 78, 338},	//519 QGlobalSpace::operator|(QStyleOptionButton::ButtonFeature, QFlags<QStyleOptionButton::ButtonFeature>)
    {19, 268, 1015, 2, Smoke::mf_static, 49, 339},	//520 QGlobalSpace::operator|(QColorDialog::ColorDialogOption, QColorDialog::ColorDialogOption)
    {19, 256, 1018, 2, Smoke::mf_static, 36, 340},	//521 QGlobalSpace::operator<<(QDataStream&, const QIcon&)
    {19, 266, 1021, 2, Smoke::mf_static, 36, 341},	//522 QGlobalSpace::operator>>(QDataStream&, QVector3D&)
    {19, 268, 1024, 2, Smoke::mf_static, 111, 342},	//523 QGlobalSpace::operator|(QStyleOptionViewItemV2::ViewItemFeature, int)
    {19, 243, 1027, 2, Smoke::mf_static, 337, 343},	//524 QGlobalSpace::operator*(double, const QVector4D&)
    {19, 266, 1030, 2, Smoke::mf_static, 36, 344},	//525 QGlobalSpace::operator>>(QDataStream&, QPainterPath&)
    {19, 268, 1033, 2, Smoke::mf_static, 60, 345},	//526 QGlobalSpace::operator|(QGraphicsItem::GraphicsItemFlag, QFlags<QGraphicsItem::GraphicsItemFlag>)
    {19, 266, 1036, 2, Smoke::mf_static, 36, 346},	//527 QGlobalSpace::operator>>(QDataStream&, QPicture&)
    {19, 341, 191, 8, Smoke::mf_static, 0, 347},	//528 QGlobalSpace::qDrawWinPanel(QPainter*, int, int, int, int, const QPalette&, bool, const QBrush*)
    {19, 341, 200, 6, Smoke::mf_static, 0, 348},	//529 QGlobalSpace::qDrawWinPanel(QPainter*, int, int, int, int, const QPalette&)
    {19, 341, 207, 7, Smoke::mf_static, 0, 349},	//530 QGlobalSpace::qDrawWinPanel(QPainter*, int, int, int, int, const QPalette&, bool)
    {19, 268, 1039, 2, Smoke::mf_static, 88, 350},	//531 QGlobalSpace::operator|(QTextItem::RenderFlag, QFlags<QTextItem::RenderFlag>)
    {19, 243, 1042, 2, Smoke::mf_static, 146, 351},	//532 QGlobalSpace::operator*(const QPoint&, const QTransform&)
    {19, 268, 1045, 2, Smoke::mf_static, 111, 352},	//533 QGlobalSpace::operator|(QStyleOptionFrameV2::FrameFeature, int)
    {19, 268, 1048, 2, Smoke::mf_static, 111, 353},	//534 QGlobalSpace::operator|(QDialogButtonBox::StandardButton, int)
    {19, 250, 173, 2, Smoke::mf_static, 313, 354},	//535 QGlobalSpace::operator-(const QQuaternion&, const QQuaternion&)
    {19, 268, 1051, 2, Smoke::mf_static, 82, 355},	//536 QGlobalSpace::operator|(QStyleOptionToolBar::ToolBarFeature, QStyleOptionToolBar::ToolBarFeature)
    {19, 250, 288, 2, Smoke::mf_static, 335, 356},	//537 QGlobalSpace::operator-(const QVector3D&, const QVector3D&)
    {19, 266, 1054, 2, Smoke::mf_static, 36, 357},	//538 QGlobalSpace::operator>>(QDataStream&, QVector2D&)
    {19, 268, 1057, 2, Smoke::mf_static, 111, 358},	//539 QGlobalSpace::operator|(QTextItem::RenderFlag, int)
    {19, 282, 0, 0, Smoke::mf_static, 13, 359},	//540 QGlobalSpace::qAccessibleActionCastHelper()
    {19, 291, 106, 1, Smoke::mf_static, 345, 360},	//541 QGlobalSpace::qBlue(unsigned int)
    {19, 268, 1060, 2, Smoke::mf_static, 111, 361},	//542 QGlobalSpace::operator|(QMainWindow::DockOption, int)
    {19, 268, 1063, 2, Smoke::mf_static, 87, 362},	//543 QGlobalSpace::operator|(QTextFormat::PageBreakFlag, QFlags<QTextFormat::PageBreakFlag>)
    {19, 256, 1066, 2, Smoke::mf_static, 38, 363},	//544 QGlobalSpace::operator<<(QDebug, const QQuaternion&)
    {19, 268, 1069, 2, Smoke::mf_static, 79, 364},	//545 QGlobalSpace::operator|(QStyleOptionFrameV2::FrameFeature, QFlags<QStyleOptionFrameV2::FrameFeature>)
    {19, 256, 1072, 2, Smoke::mf_static, 36, 365},	//546 QGlobalSpace::operator<<(QDataStream&, const QTextFormat&)
    {19, 268, 1075, 2, Smoke::mf_static, 111, 366},	//547 QGlobalSpace::operator|(QMdiSubWindow::SubWindowOption, int)
    {19, 268, 1078, 2, Smoke::mf_static, 58, 367},	//548 QGlobalSpace::operator|(QGraphicsBlurEffect::BlurHint, QGraphicsBlurEffect::BlurHint)
    {19, 268, 1081, 2, Smoke::mf_static, 64, 368},	//549 QGlobalSpace::operator|(QImageIOPlugin::Capability, QImageIOPlugin::Capability)
    {19, 256, 1084, 2, Smoke::mf_static, 36, 369},	//550 QGlobalSpace::operator<<(QDataStream&, const QQuaternion&)
    {19, 243, 1087, 2, Smoke::mf_static, 155, 370},	//551 QGlobalSpace::operator*(const QRegion&, const QMatrix&)
    {19, 256, 1090, 2, Smoke::mf_static, 38, 371},	//552 QGlobalSpace::operator<<(QDebug, const QRegion&)
    {19, 268, 1093, 2, Smoke::mf_static, 111, 372},	//553 QGlobalSpace::operator|(QTextOption::Flag, int)
    {19, 363, 1096, 4, Smoke::mf_static, 350, 373},	//554 QGlobalSpace::qRgba(int, int, int, int)
    {19, 268, 1101, 2, Smoke::mf_static, 82, 374},	//555 QGlobalSpace::operator|(QStyleOptionToolBar::ToolBarFeature, QFlags<QStyleOptionToolBar::ToolBarFeature>)
    {19, 268, 1104, 2, Smoke::mf_static, 67, 375},	//556 QGlobalSpace::operator|(QMainWindow::DockOption, QMainWindow::DockOption)
    {19, 250, 333, 2, Smoke::mf_static, 185, 376},	//557 QGlobalSpace::operator-(const QTransform&, double)
    {19, 102, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 377},	//558 QGlobalSpace::SP_CustomToolBarAdd (enum)
    {19, 103, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 378},	//559 QGlobalSpace::SP_CustomToolBarAddDetail (enum)
    {19, 104, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 379},	//560 QGlobalSpace::SP_CustomToolBarAgain (enum)
    {19, 105, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 380},	//561 QGlobalSpace::SP_CustomToolBarAgenda (enum)
    {19, 106, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 381},	//562 QGlobalSpace::SP_CustomToolBarAudioOff (enum)
    {19, 107, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 382},	//563 QGlobalSpace::SP_CustomToolBarAudioOn (enum)
    {19, 108, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 383},	//564 QGlobalSpace::SP_CustomToolBarBack (enum)
    {19, 109, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 384},	//565 QGlobalSpace::SP_CustomToolBarBluetoothOff (enum)
    {19, 110, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 385},	//566 QGlobalSpace::SP_CustomToolBarBluetoothOn (enum)
    {19, 111, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 386},	//567 QGlobalSpace::SP_CustomToolBarCancel (enum)
    {19, 112, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 387},	//568 QGlobalSpace::SP_CustomToolBarDelete (enum)
    {19, 113, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 388},	//569 QGlobalSpace::SP_CustomToolBarDone (enum)
    {19, 114, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 389},	//570 QGlobalSpace::SP_CustomToolBarEdit (enum)
    {19, 115, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 390},	//571 QGlobalSpace::SP_CustomToolBarEditDisabled (enum)
    {19, 116, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 391},	//572 QGlobalSpace::SP_CustomToolBarEmailSend (enum)
    {19, 117, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 392},	//573 QGlobalSpace::SP_CustomToolBarEmergencyCall (enum)
    {19, 118, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 393},	//574 QGlobalSpace::SP_CustomToolBarFavouriteAdd (enum)
    {19, 119, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 394},	//575 QGlobalSpace::SP_CustomToolBarFavouriteRemove (enum)
    {19, 120, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 395},	//576 QGlobalSpace::SP_CustomToolBarFavourites (enum)
    {19, 121, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 396},	//577 QGlobalSpace::SP_CustomToolBarGo (enum)
    {19, 122, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 397},	//578 QGlobalSpace::SP_CustomToolBarHome (enum)
    {19, 123, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 398},	//579 QGlobalSpace::SP_CustomToolBarImageTools (enum)
    {19, 124, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 399},	//580 QGlobalSpace::SP_CustomToolBarList (enum)
    {19, 125, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 400},	//581 QGlobalSpace::SP_CustomToolBarLock (enum)
    {19, 126, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 401},	//582 QGlobalSpace::SP_CustomToolBarLogs (enum)
    {19, 127, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 402},	//583 QGlobalSpace::SP_CustomToolBarMenu (enum)
    {19, 128, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 403},	//584 QGlobalSpace::SP_CustomToolBarNewContact (enum)
    {19, 129, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 404},	//585 QGlobalSpace::SP_CustomToolBarNewGroup (enum)
    {19, 130, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 405},	//586 QGlobalSpace::SP_CustomToolBarNextFrame (enum)
    {19, 131, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 406},	//587 QGlobalSpace::SP_CustomToolBarNowPlay (enum)
    {19, 132, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 407},	//588 QGlobalSpace::SP_CustomToolBarOptions (enum)
    {19, 133, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 408},	//589 QGlobalSpace::SP_CustomToolBarOther (enum)
    {19, 134, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 409},	//590 QGlobalSpace::SP_CustomToolBarOvi (enum)
    {19, 135, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 410},	//591 QGlobalSpace::SP_CustomToolBarPreviousFrame (enum)
    {19, 136, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 411},	//592 QGlobalSpace::SP_CustomToolBarRead (enum)
    {19, 138, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 412},	//593 QGlobalSpace::SP_CustomToolBarRedoDisabled (enum)
    {19, 137, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 413},	//594 QGlobalSpace::SP_CustomToolBarRedo (enum)
    {19, 139, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 414},	//595 QGlobalSpace::SP_CustomToolBarRefresh (enum)
    {19, 140, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 415},	//596 QGlobalSpace::SP_CustomToolBarRemoveDetail (enum)
    {19, 141, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 416},	//597 QGlobalSpace::SP_CustomToolBarRemoveDisabled (enum)
    {19, 142, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 417},	//598 QGlobalSpace::SP_CustomToolBarRepeat (enum)
    {19, 143, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 418},	//599 QGlobalSpace::SP_CustomToolBarRepeatOff (enum)
    {19, 144, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 419},	//600 QGlobalSpace::SP_CustomToolBarRepeatOne (enum)
    {19, 145, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 420},	//601 QGlobalSpace::SP_CustomToolBarSearch (enum)
    {19, 146, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 421},	//602 QGlobalSpace::SP_CustomToolBarSearchDisabled (enum)
    {19, 147, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 422},	//603 QGlobalSpace::SP_CustomToolBarSelectContent (enum)
    {19, 148, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 423},	//604 QGlobalSpace::SP_CustomToolBarSelfTimer (enum)
    {19, 149, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 424},	//605 QGlobalSpace::SP_CustomToolBarSend (enum)
    {19, 150, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 425},	//606 QGlobalSpace::SP_CustomToolBarSendDimmed (enum)
    {19, 151, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 426},	//607 QGlobalSpace::SP_CustomToolBarShare (enum)
    {19, 152, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 427},	//608 QGlobalSpace::SP_CustomToolBarShift (enum)
    {19, 153, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 428},	//609 QGlobalSpace::SP_CustomToolBarShuffle (enum)
    {19, 154, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 429},	//610 QGlobalSpace::SP_CustomToolBarShuffleOff (enum)
    {19, 155, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 430},	//611 QGlobalSpace::SP_CustomToolBarSignalOff (enum)
    {19, 156, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 431},	//612 QGlobalSpace::SP_CustomToolBarSignalOn (enum)
    {19, 157, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 432},	//613 QGlobalSpace::SP_CustomToolBarSync (enum)
    {19, 158, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 433},	//614 QGlobalSpace::SP_CustomToolBarTools (enum)
    {19, 159, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 434},	//615 QGlobalSpace::SP_CustomToolBarTrim (enum)
    {19, 160, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 435},	//616 QGlobalSpace::SP_CustomToolBarUnlock (enum)
    {19, 161, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 436},	//617 QGlobalSpace::SP_CustomToolBarUnmark (enum)
    {19, 162, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 437},	//618 QGlobalSpace::SP_CustomToolBarView (enum)
    {19, 163, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 438},	//619 QGlobalSpace::SP_CustomToolBarWlanOff (enum)
    {19, 164, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 439},	//620 QGlobalSpace::SP_CustomToolBarWlanOn (enum)
    {19, 80, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 440},	//621 QGlobalSpace::SP_CustomCameraCaptureButton (enum)
    {19, 81, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 441},	//622 QGlobalSpace::SP_CustomCameraCaptureButtonPressed (enum)
    {19, 82, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 442},	//623 QGlobalSpace::SP_CustomCameraPauseButton (enum)
    {19, 83, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 443},	//624 QGlobalSpace::SP_CustomCameraPauseButtonPressed (enum)
    {19, 84, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 444},	//625 QGlobalSpace::SP_CustomCameraPlayButton (enum)
    {19, 85, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 445},	//626 QGlobalSpace::SP_CustomCameraPlayButtonPressed (enum)
    {19, 86, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 446},	//627 QGlobalSpace::SP_CustomCameraRecButton (enum)
    {19, 87, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 447},	//628 QGlobalSpace::SP_CustomCameraRecButtonPressed (enum)
    {19, 88, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 448},	//629 QGlobalSpace::SP_CustomCameraStopButton (enum)
    {19, 89, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 449},	//630 QGlobalSpace::SP_CustomCameraStopButtonPressed (enum)
    {19, 90, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 450},	//631 QGlobalSpace::SP_CustomTabAll (enum)
    {19, 91, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 451},	//632 QGlobalSpace::SP_CustomTabArtist (enum)
    {19, 92, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 452},	//633 QGlobalSpace::SP_CustomTabFavourite (enum)
    {19, 93, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 453},	//634 QGlobalSpace::SP_CustomTabGenre (enum)
    {19, 94, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 454},	//635 QGlobalSpace::SP_CustomTabLanguage (enum)
    {19, 95, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 455},	//636 QGlobalSpace::SP_CustomTabMusicAlbum (enum)
    {19, 96, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 456},	//637 QGlobalSpace::SP_CustomTabPhotosAlbum (enum)
    {19, 97, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 457},	//638 QGlobalSpace::SP_CustomTabPhotosAll (enum)
    {19, 98, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 458},	//639 QGlobalSpace::SP_CustomTabPlaylist (enum)
    {19, 99, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 459},	//640 QGlobalSpace::SP_CustomTabServices (enum)
    {19, 100, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 460},	//641 QGlobalSpace::SP_CustomTabSongs (enum)
    {19, 101, 0, 0, Smoke::mf_static|Smoke::mf_enum, 347, 461},	//642 QGlobalSpace::SP_CustomTabVideos (enum)
    {36, 208, 1107, 1, Smoke::mf_virtual, 282, 0},	//643 QObject::event(QEvent*)
    {36, 209, 1109, 2, Smoke::mf_virtual, 282, 0},	//644 QObject::eventFilter(QObject*, QEvent*)
    {36, 444, 1112, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//645 QObject::timerEvent(QTimerEvent*)
    {36, 197, 1114, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//646 QObject::childEvent(QChildEvent*)
    {36, 200, 1107, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//647 QObject::customEvent(QEvent*)
    {36, 199, 7, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//648 QObject::connectNotify(const char*)
    {36, 204, 7, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//649 QObject::disconnectNotify(const char*)
    {69, 69, 0, 0, Smoke::mf_ctor, 196, 1},	//650 QVideoFrame::QVideoFrame()
    {69, 69, 1116, 3, Smoke::mf_ctor, 196, 2},	//651 QVideoFrame::QVideoFrame(QAbstractVideoBuffer*, const QSize&, QVideoFrame::PixelFormat)
    {69, 69, 1120, 4, Smoke::mf_ctor, 196, 3},	//652 QVideoFrame::QVideoFrame(int, const QSize&, int, QVideoFrame::PixelFormat)
    {69, 69, 1125, 1, Smoke::mf_ctor, 196, 4},	//653 QVideoFrame::QVideoFrame(const QImage&)
    {69, 69, 24, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 196, 5},	//654 QVideoFrame::QVideoFrame(const QVideoFrame&)
    {69, 259, 24, 1, 0, 195, 6},	//655 QVideoFrame::operator=(const QVideoFrame&)
    {69, 228, 0, 0, Smoke::mf_const, 282, 7},	//656 QVideoFrame::isValid() const
    {69, 272, 0, 0, Smoke::mf_const, 198, 8},	//657 QVideoFrame::pixelFormat() const
    {69, 218, 0, 0, Smoke::mf_const, 5, 9},	//658 QVideoFrame::handleType() const
    {69, 419, 0, 0, Smoke::mf_const, 157, 10},	//659 QVideoFrame::size() const
    {69, 455, 0, 0, Smoke::mf_const, 345, 11},	//660 QVideoFrame::width() const
    {69, 219, 0, 0, Smoke::mf_const, 345, 12},	//661 QVideoFrame::height() const
    {69, 210, 0, 0, Smoke::mf_const, 197, 13},	//662 QVideoFrame::fieldType() const
    {69, 389, 1127, 1, 0, 0, 14},	//663 QVideoFrame::setFieldType(QVideoFrame::FieldType)
    {69, 225, 0, 0, Smoke::mf_const, 282, 15},	//664 QVideoFrame::isMapped() const
    {69, 227, 0, 0, Smoke::mf_const, 282, 16},	//665 QVideoFrame::isReadable() const
    {69, 229, 0, 0, Smoke::mf_const, 282, 17},	//666 QVideoFrame::isWritable() const
    {69, 233, 0, 0, Smoke::mf_const, 6, 18},	//667 QVideoFrame::mapMode() const
    {69, 230, 1129, 1, 0, 282, 19},	//668 QVideoFrame::map(QAbstractVideoBuffer::MapMode)
    {69, 453, 0, 0, 0, 0, 20},	//669 QVideoFrame::unmap()
    {69, 193, 0, 0, Smoke::mf_const, 345, 21},	//670 QVideoFrame::bytesPerLine() const
    {69, 189, 0, 0, 0, 349, 22},	//671 QVideoFrame::bits()
    {69, 189, 0, 0, Smoke::mf_const, 342, 23},	//672 QVideoFrame::bits() const
    {69, 234, 0, 0, Smoke::mf_const, 345, 24},	//673 QVideoFrame::mappedBytes() const
    {69, 217, 0, 0, Smoke::mf_const, 189, 25},	//674 QVideoFrame::handle() const
    {69, 423, 0, 0, Smoke::mf_const, 348, 26},	//675 QVideoFrame::startTime() const
    {69, 413, 1131, 1, 0, 0, 27},	//676 QVideoFrame::setStartTime(long long)
    {69, 206, 0, 0, Smoke::mf_const, 348, 28},	//677 QVideoFrame::endTime() const
    {69, 385, 1131, 1, 0, 0, 29},	//678 QVideoFrame::setEndTime(long long)
    {69, 273, 1133, 1, Smoke::mf_static, 198, 30},	//679 QVideoFrame::pixelFormatFromImageFormat(QImage::Format)
    {69, 220, 1135, 1, Smoke::mf_static, 109, 31},	//680 QVideoFrame::imageFormatFromPixelFormat(QVideoFrame::PixelFormat)
    {69, 51, 0, 0, Smoke::mf_static|Smoke::mf_enum, 197, 32},	//681 QVideoFrame::ProgressiveFrame (enum)
    {69, 169, 0, 0, Smoke::mf_static|Smoke::mf_enum, 197, 33},	//682 QVideoFrame::TopField (enum)
    {69, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 197, 34},	//683 QVideoFrame::BottomField (enum)
    {69, 45, 0, 0, Smoke::mf_static|Smoke::mf_enum, 197, 35},	//684 QVideoFrame::InterlacedFrame (enum)
    {69, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 36},	//685 QVideoFrame::Format_Invalid (enum)
    {69, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 37},	//686 QVideoFrame::Format_ARGB32 (enum)
    {69, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 38},	//687 QVideoFrame::Format_ARGB32_Premultiplied (enum)
    {69, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 39},	//688 QVideoFrame::Format_RGB32 (enum)
    {69, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 40},	//689 QVideoFrame::Format_RGB24 (enum)
    {69, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 41},	//690 QVideoFrame::Format_RGB565 (enum)
    {69, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 42},	//691 QVideoFrame::Format_RGB555 (enum)
    {69, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 43},	//692 QVideoFrame::Format_ARGB8565_Premultiplied (enum)
    {69, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 44},	//693 QVideoFrame::Format_BGRA32 (enum)
    {69, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 45},	//694 QVideoFrame::Format_BGRA32_Premultiplied (enum)
    {69, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 46},	//695 QVideoFrame::Format_BGR32 (enum)
    {69, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 47},	//696 QVideoFrame::Format_BGR24 (enum)
    {69, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 48},	//697 QVideoFrame::Format_BGR565 (enum)
    {69, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 49},	//698 QVideoFrame::Format_BGR555 (enum)
    {69, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 50},	//699 QVideoFrame::Format_BGRA5658_Premultiplied (enum)
    {69, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 51},	//700 QVideoFrame::Format_AYUV444 (enum)
    {69, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 52},	//701 QVideoFrame::Format_AYUV444_Premultiplied (enum)
    {69, 38, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 53},	//702 QVideoFrame::Format_YUV444 (enum)
    {69, 37, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 54},	//703 QVideoFrame::Format_YUV420P (enum)
    {69, 40, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 55},	//704 QVideoFrame::Format_YV12 (enum)
    {69, 33, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 56},	//705 QVideoFrame::Format_UYVY (enum)
    {69, 39, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 57},	//706 QVideoFrame::Format_YUYV (enum)
    {69, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 58},	//707 QVideoFrame::Format_NV12 (enum)
    {69, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 59},	//708 QVideoFrame::Format_NV21 (enum)
    {69, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 60},	//709 QVideoFrame::Format_IMC1 (enum)
    {69, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 61},	//710 QVideoFrame::Format_IMC2 (enum)
    {69, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 62},	//711 QVideoFrame::Format_IMC3 (enum)
    {69, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 63},	//712 QVideoFrame::Format_IMC4 (enum)
    {69, 36, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 64},	//713 QVideoFrame::Format_Y8 (enum)
    {69, 35, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 65},	//714 QVideoFrame::Format_Y16 (enum)
    {69, 34, 0, 0, Smoke::mf_static|Smoke::mf_enum, 198, 66},	//715 QVideoFrame::Format_User (enum)
    {69, 463, 0, 0, Smoke::mf_dtor, 0, 67 },	//716 QVideoFrame::~QVideoFrame()
    {70, 73, 0, 0, Smoke::mf_ctor, 201, 1},	//717 QVideoSurfaceFormat::QVideoSurfaceFormat()
    {70, 73, 1137, 3, Smoke::mf_ctor, 201, 2},	//718 QVideoSurfaceFormat::QVideoSurfaceFormat(const QSize&, QVideoFrame::PixelFormat, QAbstractVideoBuffer::HandleType)
    {70, 73, 22, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 201, 3},	//719 QVideoSurfaceFormat::QVideoSurfaceFormat(const QVideoSurfaceFormat&)
    {70, 259, 22, 1, 0, 200, 4},	//720 QVideoSurfaceFormat::operator=(const QVideoSurfaceFormat&)
    {70, 261, 22, 1, Smoke::mf_const, 282, 5},	//721 QVideoSurfaceFormat::operator==(const QVideoSurfaceFormat&) const
    {70, 240, 22, 1, Smoke::mf_const, 282, 6},	//722 QVideoSurfaceFormat::operator!=(const QVideoSurfaceFormat&) const
    {70, 228, 0, 0, Smoke::mf_const, 282, 7},	//723 QVideoSurfaceFormat::isValid() const
    {70, 272, 0, 0, Smoke::mf_const, 198, 8},	//724 QVideoSurfaceFormat::pixelFormat() const
    {70, 218, 0, 0, Smoke::mf_const, 5, 9},	//725 QVideoSurfaceFormat::handleType() const
    {70, 214, 0, 0, Smoke::mf_const, 157, 10},	//726 QVideoSurfaceFormat::frameSize() const
    {70, 393, 1141, 1, 0, 0, 11},	//727 QVideoSurfaceFormat::setFrameSize(const QSize&)
    {70, 393, 1143, 2, 0, 0, 12},	//728 QVideoSurfaceFormat::setFrameSize(int, int)
    {70, 215, 0, 0, Smoke::mf_const, 345, 13},	//729 QVideoSurfaceFormat::frameWidth() const
    {70, 212, 0, 0, Smoke::mf_const, 345, 14},	//730 QVideoSurfaceFormat::frameHeight() const
    {70, 454, 0, 0, Smoke::mf_const, 153, 15},	//731 QVideoSurfaceFormat::viewport() const
    {70, 415, 1146, 1, 0, 0, 16},	//732 QVideoSurfaceFormat::setViewport(const QRect&)
    {70, 374, 0, 0, Smoke::mf_const, 202, 17},	//733 QVideoSurfaceFormat::scanLineDirection() const
    {70, 411, 1148, 1, 0, 0, 18},	//734 QVideoSurfaceFormat::setScanLineDirection(QVideoSurfaceFormat::Direction)
    {70, 213, 0, 0, Smoke::mf_const, 344, 19},	//735 QVideoSurfaceFormat::frameRate() const
    {70, 391, 1150, 1, 0, 0, 20},	//736 QVideoSurfaceFormat::setFrameRate(double)
    {70, 271, 0, 0, Smoke::mf_const, 157, 21},	//737 QVideoSurfaceFormat::pixelAspectRatio() const
    {70, 400, 1141, 1, 0, 0, 22},	//738 QVideoSurfaceFormat::setPixelAspectRatio(const QSize&)
    {70, 400, 1143, 2, 0, 0, 23},	//739 QVideoSurfaceFormat::setPixelAspectRatio(int, int)
    {70, 456, 0, 0, Smoke::mf_const, 203, 24},	//740 QVideoSurfaceFormat::yCbCrColorSpace() const
    {70, 417, 1152, 1, 0, 0, 25},	//741 QVideoSurfaceFormat::setYCbCrColorSpace(QVideoSurfaceFormat::YCbCrColorSpace)
    {70, 420, 0, 0, Smoke::mf_const, 157, 26},	//742 QVideoSurfaceFormat::sizeHint() const
    {70, 281, 0, 0, Smoke::mf_const, 122, 27},	//743 QVideoSurfaceFormat::propertyNames() const
    {70, 279, 7, 1, Smoke::mf_const, 189, 28},	//744 QVideoSurfaceFormat::property(const char*) const
    {70, 403, 1154, 2, 0, 0, 29},	//745 QVideoSurfaceFormat::setProperty(const char*, const QVariant&)
    {70, 73, 1157, 2, Smoke::mf_ctor, 201, 30},	//746 QVideoSurfaceFormat::QVideoSurfaceFormat(const QSize&, QVideoFrame::PixelFormat)
    {70, 170, 0, 0, Smoke::mf_static|Smoke::mf_enum, 202, 31},	//747 QVideoSurfaceFormat::TopToBottom (enum)
    {70, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 202, 32},	//748 QVideoSurfaceFormat::BottomToTop (enum)
    {70, 182, 0, 0, Smoke::mf_static|Smoke::mf_enum, 203, 33},	//749 QVideoSurfaceFormat::YCbCr_Undefined (enum)
    {70, 178, 0, 0, Smoke::mf_static|Smoke::mf_enum, 203, 34},	//750 QVideoSurfaceFormat::YCbCr_BT601 (enum)
    {70, 179, 0, 0, Smoke::mf_static|Smoke::mf_enum, 203, 35},	//751 QVideoSurfaceFormat::YCbCr_BT709 (enum)
    {70, 183, 0, 0, Smoke::mf_static|Smoke::mf_enum, 203, 36},	//752 QVideoSurfaceFormat::YCbCr_xvYCC601 (enum)
    {70, 184, 0, 0, Smoke::mf_static|Smoke::mf_enum, 203, 37},	//753 QVideoSurfaceFormat::YCbCr_xvYCC709 (enum)
    {70, 181, 0, 0, Smoke::mf_static|Smoke::mf_enum, 203, 38},	//754 QVideoSurfaceFormat::YCbCr_JPEG (enum)
    {70, 180, 0, 0, Smoke::mf_static|Smoke::mf_enum, 203, 39},	//755 QVideoSurfaceFormat::YCbCr_CustomMatrix (enum)
    {70, 464, 0, 0, Smoke::mf_dtor, 0, 40 },	//756 QVideoSurfaceFormat::~QVideoSurfaceFormat()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    177,  // QAudioOutput::QAudioOutput(const QAudioFormat&)
    178,  // QAudioOutput::QAudioOutput(const QAudioDeviceInfo&)
    0,
    153,  // QAudioOutput::QAudioOutput(const QAudioFormat&, QObject*)
    179,  // QAudioOutput::QAudioOutput(const QAudioDeviceInfo&, const QAudioFormat&)
    0,
    252,  // QGlobalSpace::operator!=(const QVector2D&, const QVector2D&)
    379,  // QGlobalSpace::operator!=(const QVector3D&, const QVector3D&)
    489,  // QGlobalSpace::operator!=(const QQuaternion&, const QQuaternion&)
    492,  // QGlobalSpace::operator!=(const QVector4D&, const QVector4D&)
    0,
    193,  // QGlobalSpace::operator*(const QPointF&, const QMatrix&)
    195,  // QGlobalSpace::operator*(const QLine&, const QTransform&)
    220,  // QGlobalSpace::operator*(const QVector4D&, const QVector4D&)
    222,  // QGlobalSpace::operator*(const QQuaternion&, const QQuaternion&)
    225,  // QGlobalSpace::operator*(const QPolygonF&, const QTransform&)
    245,  // QGlobalSpace::operator*(const QLine&, const QMatrix&)
    249,  // QGlobalSpace::operator*(const QLineF&, const QMatrix&)
    250,  // QGlobalSpace::operator*(const QPainterPath&, const QMatrix&)
    280,  // QGlobalSpace::operator*(const QPainterPath&, const QTransform&)
    287,  // QGlobalSpace::operator*(const QVector2D&, const QVector2D&)
    300,  // QGlobalSpace::operator*(const QVector3D&, const QMatrix4x4&)
    311,  // QGlobalSpace::operator*(const QPolygon&, const QMatrix&)
    324,  // QGlobalSpace::operator*(const QPointF&, const QTransform&)
    331,  // QGlobalSpace::operator*(const QMatrix4x4&, const QMatrix4x4&)
    335,  // QGlobalSpace::operator*(const QMatrix4x4&, const QVector4D&)
    342,  // QGlobalSpace::operator*(const QPoint&, const QMatrix&)
    363,  // QGlobalSpace::operator*(const QMatrix4x4&, const QPoint&)
    397,  // QGlobalSpace::operator*(const QMatrix4x4&, const QPointF&)
    404,  // QGlobalSpace::operator*(const QLineF&, const QTransform&)
    434,  // QGlobalSpace::operator*(const QVector4D&, const QMatrix4x4&)
    455,  // QGlobalSpace::operator*(const QPolygon&, const QTransform&)
    470,  // QGlobalSpace::operator*(const QMatrix4x4&, const QVector3D&)
    480,  // QGlobalSpace::operator*(const QRegion&, const QTransform&)
    481,  // QGlobalSpace::operator*(const QPointF&, const QMatrix4x4&)
    488,  // QGlobalSpace::operator*(const QPolygonF&, const QMatrix&)
    504,  // QGlobalSpace::operator*(const QVector3D&, const QVector3D&)
    515,  // QGlobalSpace::operator*(const QPoint&, const QMatrix4x4&)
    532,  // QGlobalSpace::operator*(const QPoint&, const QTransform&)
    551,  // QGlobalSpace::operator*(const QRegion&, const QMatrix&)
    0,
    203,  // QGlobalSpace::operator*(const QQuaternion&, double)
    271,  // QGlobalSpace::operator*(const QVector2D&, double)
    274,  // QGlobalSpace::operator*(const QVector4D&, double)
    309,  // QGlobalSpace::operator*(const QVector3D&, double)
    351,  // QGlobalSpace::operator*(const QTransform&, double)
    388,  // QGlobalSpace::operator*(const QMatrix4x4&, double)
    0,
    399,  // QGlobalSpace::operator*(double, const QVector2D&)
    406,  // QGlobalSpace::operator*(double, const QVector3D&)
    416,  // QGlobalSpace::operator*(double, const QMatrix4x4&)
    441,  // QGlobalSpace::operator*(double, const QQuaternion&)
    524,  // QGlobalSpace::operator*(double, const QVector4D&)
    0,
    247,  // QGlobalSpace::operator+(const QVector4D&, const QVector4D&)
    262,  // QGlobalSpace::operator+(const QVector2D&, const QVector2D&)
    286,  // QGlobalSpace::operator+(const QMatrix4x4&, const QMatrix4x4&)
    299,  // QGlobalSpace::operator+(const QQuaternion&, const QQuaternion&)
    476,  // QGlobalSpace::operator+(const QVector3D&, const QVector3D&)
    0,
    200,  // QGlobalSpace::operator-(const QQuaternion&)
    214,  // QGlobalSpace::operator-(const QVector2D&)
    375,  // QGlobalSpace::operator-(const QVector4D&)
    398,  // QGlobalSpace::operator-(const QMatrix4x4&)
    518,  // QGlobalSpace::operator-(const QVector3D&)
    0,
    191,  // QGlobalSpace::operator-(const QMatrix4x4&, const QMatrix4x4&)
    192,  // QGlobalSpace::operator-(const QVector4D&, const QVector4D&)
    308,  // QGlobalSpace::operator-(const QVector2D&, const QVector2D&)
    535,  // QGlobalSpace::operator-(const QQuaternion&, const QQuaternion&)
    537,  // QGlobalSpace::operator-(const QVector3D&, const QVector3D&)
    0,
    268,  // QGlobalSpace::operator/(const QTransform&, double)
    279,  // QGlobalSpace::operator/(const QMatrix4x4&, double)
    362,  // QGlobalSpace::operator/(const QVector4D&, double)
    366,  // QGlobalSpace::operator/(const QQuaternion&, double)
    381,  // QGlobalSpace::operator/(const QVector2D&, double)
    414,  // QGlobalSpace::operator/(const QVector3D&, double)
    0,
    183,  // QGlobalSpace::operator<<(QDebug, const QItemSelectionRange&)
    184,  // QGlobalSpace::operator<<(QDebug, const QStyleOption&)
    187,  // QGlobalSpace::operator<<(QDataStream&, const QSizePolicy&)
    189,  // QGlobalSpace::operator<<(QDebug, const QTransform&)
    190,  // QGlobalSpace::operator<<(QDataStream&, const QTransform&)
    208,  // QGlobalSpace::operator<<(QDebug, const QFont&)
    209,  // QGlobalSpace::operator<<(QDebug, const QPolygon&)
    219,  // QGlobalSpace::operator<<(QDataStream&, const QPalette&)
    226,  // QGlobalSpace::operator<<(QDebug, const QPolygonF&)
    232,  // QGlobalSpace::operator<<(QDebug, const QColor&)
    253,  // QGlobalSpace::operator<<(QDataStream&, const QKeySequence&)
    254,  // QGlobalSpace::operator<<(QDataStream&, const QTableWidgetItem&)
    257,  // QGlobalSpace::operator<<(QDataStream&, const QCursor&)
    259,  // QGlobalSpace::operator<<(QDataStream&, const QPicture&)
    266,  // QGlobalSpace::operator<<(QDataStream&, const QTreeWidgetItem&)
    269,  // QGlobalSpace::operator<<(QTextStream&, const QSplitter&)
    281,  // QGlobalSpace::operator<<(QDataStream&, const QBrush&)
    313,  // QGlobalSpace::operator<<(QDebug, const QPen&)
    323,  // QGlobalSpace::operator<<(QDataStream&, const QPixmap&)
    325,  // QGlobalSpace::operator<<(QDebug, const QVector3D&)
    334,  // QGlobalSpace::operator<<(QDebug, const QVector2D&)
    343,  // QGlobalSpace::operator<<(QDataStream&, const QPen&)
    350,  // QGlobalSpace::operator<<(QDataStream&, const QPolygon&)
    358,  // QGlobalSpace::operator<<(QDebug, const QVector4D&)
    371,  // QGlobalSpace::operator<<(QDebug, const QPainterPath&)
    376,  // QGlobalSpace::operator<<(QDebug, const QMatrix4x4&)
    403,  // QGlobalSpace::operator<<(QDataStream&, const QVector3D&)
    405,  // QGlobalSpace::operator<<(QDataStream&, const QPolygonF&)
    407,  // QGlobalSpace::operator<<(QDataStream&, const QFont&)
    412,  // QGlobalSpace::operator<<(QDataStream&, const QVector2D&)
    413,  // QGlobalSpace::operator<<(QDataStream&, const QMatrix&)
    425,  // QGlobalSpace::operator<<(QDataStream&, const QPainterPath&)
    438,  // QGlobalSpace::operator<<(QDebug, QGraphicsObject*)
    440,  // QGlobalSpace::operator<<(QDataStream&, const QImage&)
    443,  // QGlobalSpace::operator<<(QDebug, const QKeySequence&)
    449,  // QGlobalSpace::operator<<(QDebug, const QEvent*)
    463,  // QGlobalSpace::operator<<(QDataStream&, const QRegion&)
    464,  // QGlobalSpace::operator<<(QDebug, const QMatrix&)
    467,  // QGlobalSpace::operator<<(QDataStream&, const QColor&)
    471,  // QGlobalSpace::operator<<(QDebug, const QBrush&)
    477,  // QGlobalSpace::operator<<(QDebug, const QVideoSurfaceFormat&)
    479,  // QGlobalSpace::operator<<(QDataStream&, const QTextLength&)
    482,  // QGlobalSpace::operator<<(QDebug, QGraphicsItem*)
    484,  // QGlobalSpace::operator<<(QDataStream&, const QListWidgetItem&)
    487,  // QGlobalSpace::operator<<(QDataStream&, const QStandardItem&)
    509,  // QGlobalSpace::operator<<(QDataStream&, const QMatrix4x4&)
    511,  // QGlobalSpace::operator<<(QDataStream&, const QVector4D&)
    521,  // QGlobalSpace::operator<<(QDataStream&, const QIcon&)
    544,  // QGlobalSpace::operator<<(QDebug, const QQuaternion&)
    546,  // QGlobalSpace::operator<<(QDataStream&, const QTextFormat&)
    550,  // QGlobalSpace::operator<<(QDataStream&, const QQuaternion&)
    552,  // QGlobalSpace::operator<<(QDebug, const QRegion&)
    0,
    255,  // QGlobalSpace::operator<<(QDebug, QGraphicsItem::GraphicsItemChange)
    264,  // QGlobalSpace::operator<<(QDebug, QFlags<QStyle::StateFlag>)
    355,  // QGlobalSpace::operator<<(QDebug, QFlags<QGraphicsItem::GraphicsItemFlag>)
    389,  // QGlobalSpace::operator<<(QDebug, QGraphicsItem::GraphicsItemFlag)
    486,  // QGlobalSpace::operator<<(QDebug, const QStyleOption::OptionType&)
    0,
    251,  // QGlobalSpace::operator==(const QVector3D&, const QVector3D&)
    276,  // QGlobalSpace::operator==(const QQuaternion&, const QQuaternion&)
    380,  // QGlobalSpace::operator==(const QVector2D&, const QVector2D&)
    411,  // QGlobalSpace::operator==(const QVector4D&, const QVector4D&)
    0,
    186,  // QGlobalSpace::operator>>(QDataStream&, QImage&)
    239,  // QGlobalSpace::operator>>(QDataStream&, QPen&)
    241,  // QGlobalSpace::operator>>(QDataStream&, QColor&)
    261,  // QGlobalSpace::operator>>(QDataStream&, QVector4D&)
    288,  // QGlobalSpace::operator>>(QDataStream&, QRegion&)
    307,  // QGlobalSpace::operator>>(QDataStream&, QCursor&)
    310,  // QGlobalSpace::operator>>(QDataStream&, QTransform&)
    349,  // QGlobalSpace::operator>>(QDataStream&, QIcon&)
    368,  // QGlobalSpace::operator>>(QDataStream&, QStandardItem&)
    373,  // QGlobalSpace::operator>>(QDataStream&, QBrush&)
    374,  // QGlobalSpace::operator>>(QDataStream&, QMatrix4x4&)
    378,  // QGlobalSpace::operator>>(QDataStream&, QTextFormat&)
    382,  // QGlobalSpace::operator>>(QDataStream&, QListWidgetItem&)
    393,  // QGlobalSpace::operator>>(QDataStream&, QSizePolicy&)
    394,  // QGlobalSpace::operator>>(QDataStream&, QMatrix&)
    409,  // QGlobalSpace::operator>>(QDataStream&, QTableWidgetItem&)
    422,  // QGlobalSpace::operator>>(QDataStream&, QPolygonF&)
    424,  // QGlobalSpace::operator>>(QDataStream&, QPalette&)
    433,  // QGlobalSpace::operator>>(QDataStream&, QQuaternion&)
    450,  // QGlobalSpace::operator>>(QDataStream&, QFont&)
    457,  // QGlobalSpace::operator>>(QDataStream&, QTextLength&)
    473,  // QGlobalSpace::operator>>(QDataStream&, QTreeWidgetItem&)
    474,  // QGlobalSpace::operator>>(QDataStream&, QKeySequence&)
    491,  // QGlobalSpace::operator>>(QDataStream&, QPolygon&)
    508,  // QGlobalSpace::operator>>(QTextStream&, QSplitter&)
    514,  // QGlobalSpace::operator>>(QDataStream&, QPixmap&)
    522,  // QGlobalSpace::operator>>(QDataStream&, QVector3D&)
    525,  // QGlobalSpace::operator>>(QDataStream&, QPainterPath&)
    527,  // QGlobalSpace::operator>>(QDataStream&, QPicture&)
    538,  // QGlobalSpace::operator>>(QDataStream&, QVector2D&)
    0,
    182,  // QGlobalSpace::operator|(QGestureRecognizer::ResultFlag, QGestureRecognizer::ResultFlag)
    185,  // QGlobalSpace::operator|(QAbstractItemView::EditTrigger, QAbstractItemView::EditTrigger)
    188,  // QGlobalSpace::operator|(QStyleOptionToolBar::ToolBarFeature, int)
    194,  // QGlobalSpace::operator|(QPaintEngine::PaintEngineFeature, QPaintEngine::PaintEngineFeature)
    199,  // QGlobalSpace::operator|(QFileDialog::Option, QFlags<QFileDialog::Option>)
    201,  // QGlobalSpace::operator|(QAbstractPrintDialog::PrintDialogOption, QAbstractPrintDialog::PrintDialogOption)
    204,  // QGlobalSpace::operator|(QStyleOptionTab::CornerWidget, QStyleOptionTab::CornerWidget)
    205,  // QGlobalSpace::operator|(QStyleOptionQ3ListViewItem::Q3ListViewItemFeature, QStyleOptionQ3ListViewItem::Q3ListViewItemFeature)
    206,  // QGlobalSpace::operator|(QFontComboBox::FontFilter, QFontComboBox::FontFilter)
    207,  // QGlobalSpace::operator|(QTextFormat::PageBreakFlag, QTextFormat::PageBreakFlag)
    211,  // QGlobalSpace::operator|(QStyle::SubControl, int)
    212,  // QGlobalSpace::operator|(QDockWidget::DockWidgetFeature, QDockWidget::DockWidgetFeature)
    221,  // QGlobalSpace::operator|(QTextDocument::FindFlag, QFlags<QTextDocument::FindFlag>)
    223,  // QGlobalSpace::operator|(QTextEdit::AutoFormattingFlag, QFlags<QTextEdit::AutoFormattingFlag>)
    224,  // QGlobalSpace::operator|(QAccessible::StateFlag, QFlags<QAccessible::StateFlag>)
    227,  // QGlobalSpace::operator|(QPinchGesture::ChangeFlag, QFlags<QPinchGesture::ChangeFlag>)
    231,  // QGlobalSpace::operator|(QWidget::RenderFlag, int)
    233,  // QGlobalSpace::operator|(QTreeWidgetItemIterator::IteratorFlag, int)
    240,  // QGlobalSpace::operator|(QGestureRecognizer::ResultFlag, QFlags<QGestureRecognizer::ResultFlag>)
    242,  // QGlobalSpace::operator|(QGraphicsEffect::ChangeFlag, QGraphicsEffect::ChangeFlag)
    243,  // QGlobalSpace::operator|(QFontDialog::FontDialogOption, int)
    244,  // QGlobalSpace::operator|(QStyleOptionQ3ListViewItem::Q3ListViewItemFeature, int)
    246,  // QGlobalSpace::operator|(QPaintEngine::DirtyFlag, QPaintEngine::DirtyFlag)
    256,  // QGlobalSpace::operator|(QItemSelectionModel::SelectionFlag, int)
    258,  // QGlobalSpace::operator|(QMessageBox::StandardButton, QFlags<QMessageBox::StandardButton>)
    260,  // QGlobalSpace::operator|(QMessageBox::StandardButton, QMessageBox::StandardButton)
    263,  // QGlobalSpace::operator|(QMdiSubWindow::SubWindowOption, QFlags<QMdiSubWindow::SubWindowOption>)
    265,  // QGlobalSpace::operator|(QFontDialog::FontDialogOption, QFontDialog::FontDialogOption)
    267,  // QGlobalSpace::operator|(QPainter::RenderHint, QPainter::RenderHint)
    270,  // QGlobalSpace::operator|(QAbstractSpinBox::StepEnabledFlag, QFlags<QAbstractSpinBox::StepEnabledFlag>)
    272,  // QGlobalSpace::operator|(QTreeWidgetItemIterator::IteratorFlag, QTreeWidgetItemIterator::IteratorFlag)
    273,  // QGlobalSpace::operator|(QStyleOptionButton::ButtonFeature, QStyleOptionButton::ButtonFeature)
    275,  // QGlobalSpace::operator|(QStyleOptionButton::ButtonFeature, int)
    282,  // QGlobalSpace::operator|(QMdiArea::AreaOption, QFlags<QMdiArea::AreaOption>)
    283,  // QGlobalSpace::operator|(QAbstractSpinBox::StepEnabledFlag, QAbstractSpinBox::StepEnabledFlag)
    284,  // QGlobalSpace::operator|(QInputDialog::InputDialogOption, int)
    285,  // QGlobalSpace::operator|(QStyle::StateFlag, int)
    289,  // QGlobalSpace::operator|(QPainter::RenderHint, int)
    290,  // QGlobalSpace::operator|(QStyleOptionTab::CornerWidget, int)
    291,  // QGlobalSpace::operator|(QWizard::WizardOption, QWizard::WizardOption)
    292,  // QGlobalSpace::operator|(QWizard::WizardOption, QFlags<QWizard::WizardOption>)
    293,  // QGlobalSpace::operator|(QPaintEngine::PaintEngineFeature, QFlags<QPaintEngine::PaintEngineFeature>)
    294,  // QGlobalSpace::operator|(QGraphicsItem::GraphicsItemFlag, QGraphicsItem::GraphicsItemFlag)
    304,  // QGlobalSpace::operator|(QSizePolicy::ControlType, QSizePolicy::ControlType)
    305,  // QGlobalSpace::operator|(QFontComboBox::FontFilter, int)
    306,  // QGlobalSpace::operator|(QTextDocument::FindFlag, int)
    312,  // QGlobalSpace::operator|(QStyleOptionTab::CornerWidget, QFlags<QStyleOptionTab::CornerWidget>)
    314,  // QGlobalSpace::operator|(QStyleOptionToolButton::ToolButtonFeature, QStyleOptionToolButton::ToolButtonFeature)
    320,  // QGlobalSpace::operator|(QTextEdit::AutoFormattingFlag, QTextEdit::AutoFormattingFlag)
    321,  // QGlobalSpace::operator|(QPaintEngine::DirtyFlag, int)
    322,  // QGlobalSpace::operator|(QGraphicsItem::GraphicsItemFlag, int)
    326,  // QGlobalSpace::operator|(QDockWidget::DockWidgetFeature, QFlags<QDockWidget::DockWidgetFeature>)
    327,  // QGlobalSpace::operator|(QGraphicsEffect::ChangeFlag, int)
    332,  // QGlobalSpace::operator|(QSizePolicy::ControlType, QFlags<QSizePolicy::ControlType>)
    333,  // QGlobalSpace::operator|(QAbstractSpinBox::StepEnabledFlag, int)
    336,  // QGlobalSpace::operator|(QAccessible::StateFlag, int)
    340,  // QGlobalSpace::operator|(QPinchGesture::ChangeFlag, QPinchGesture::ChangeFlag)
    341,  // QGlobalSpace::operator|(QDateTimeEdit::Section, int)
    344,  // QGlobalSpace::operator|(QWidget::RenderFlag, QWidget::RenderFlag)
    348,  // QGlobalSpace::operator|(QColorDialog::ColorDialogOption, int)
    352,  // QGlobalSpace::operator|(QWidget::RenderFlag, QFlags<QWidget::RenderFlag>)
    353,  // QGlobalSpace::operator|(QTextFormat::PageBreakFlag, int)
    354,  // QGlobalSpace::operator|(QImageIOPlugin::Capability, int)
    356,  // QGlobalSpace::operator|(QGraphicsView::CacheModeFlag, int)
    357,  // QGlobalSpace::operator|(QAbstractItemView::EditTrigger, int)
    359,  // QGlobalSpace::operator|(QWizard::WizardOption, int)
    360,  // QGlobalSpace::operator|(QFileDialog::Option, int)
    361,  // QGlobalSpace::operator|(QStyle::StateFlag, QFlags<QStyle::StateFlag>)
    364,  // QGlobalSpace::operator|(QStyleOptionToolButton::ToolButtonFeature, QFlags<QStyleOptionToolButton::ToolButtonFeature>)
    365,  // QGlobalSpace::operator|(QGraphicsScene::SceneLayer, QFlags<QGraphicsScene::SceneLayer>)
    367,  // QGlobalSpace::operator|(QMdiArea::AreaOption, QMdiArea::AreaOption)
    370,  // QGlobalSpace::operator|(QPaintEngine::PaintEngineFeature, int)
    372,  // QGlobalSpace::operator|(QColorDialog::ColorDialogOption, QFlags<QColorDialog::ColorDialogOption>)
    377,  // QGlobalSpace::operator|(QGraphicsView::OptimizationFlag, int)
    383,  // QGlobalSpace::operator|(QGraphicsEffect::ChangeFlag, QFlags<QGraphicsEffect::ChangeFlag>)
    384,  // QGlobalSpace::operator|(QGraphicsBlurEffect::BlurHint, QFlags<QGraphicsBlurEffect::BlurHint>)
    385,  // QGlobalSpace::operator|(QStyleOptionToolButton::ToolButtonFeature, int)
    387,  // QGlobalSpace::operator|(QMessageBox::StandardButton, int)
    390,  // QGlobalSpace::operator|(QAccessible::RelationFlag, QFlags<QAccessible::RelationFlag>)
    392,  // QGlobalSpace::operator|(QSizePolicy::ControlType, int)
    395,  // QGlobalSpace::operator|(QStyleOptionQ3ListViewItem::Q3ListViewItemFeature, QFlags<QStyleOptionQ3ListViewItem::Q3ListViewItemFeature>)
    400,  // QGlobalSpace::operator|(QAbstractPrintDialog::PrintDialogOption, QFlags<QAbstractPrintDialog::PrintDialogOption>)
    401,  // QGlobalSpace::operator|(QInputDialog::InputDialogOption, QInputDialog::InputDialogOption)
    402,  // QGlobalSpace::operator|(QAbstractPrintDialog::PrintDialogOption, int)
    408,  // QGlobalSpace::operator|(QTextOption::Flag, QFlags<QTextOption::Flag>)
    410,  // QGlobalSpace::operator|(QStyle::SubControl, QFlags<QStyle::SubControl>)
    415,  // QGlobalSpace::operator|(QPainter::RenderHint, QFlags<QPainter::RenderHint>)
    417,  // QGlobalSpace::operator|(QGraphicsView::OptimizationFlag, QFlags<QGraphicsView::OptimizationFlag>)
    420,  // QGlobalSpace::operator|(QTextItem::RenderFlag, QTextItem::RenderFlag)
    421,  // QGlobalSpace::operator|(QGraphicsView::CacheModeFlag, QGraphicsView::CacheModeFlag)
    423,  // QGlobalSpace::operator|(QTreeWidgetItemIterator::IteratorFlag, QFlags<QTreeWidgetItemIterator::IteratorFlag>)
    426,  // QGlobalSpace::operator|(QAccessible::StateFlag, QAccessible::StateFlag)
    428,  // QGlobalSpace::operator|(QGraphicsView::CacheModeFlag, QFlags<QGraphicsView::CacheModeFlag>)
    429,  // QGlobalSpace::operator|(QStyle::SubControl, QStyle::SubControl)
    431,  // QGlobalSpace::operator|(QAbstractItemView::EditTrigger, QFlags<QAbstractItemView::EditTrigger>)
    432,  // QGlobalSpace::operator|(QPinchGesture::ChangeFlag, int)
    436,  // QGlobalSpace::operator|(QStyleOptionViewItemV2::ViewItemFeature, QStyleOptionViewItemV2::ViewItemFeature)
    437,  // QGlobalSpace::operator|(QMainWindow::DockOption, QFlags<QMainWindow::DockOption>)
    439,  // QGlobalSpace::operator|(QMdiSubWindow::SubWindowOption, QMdiSubWindow::SubWindowOption)
    442,  // QGlobalSpace::operator|(QTextDocument::FindFlag, QTextDocument::FindFlag)
    444,  // QGlobalSpace::operator|(QPaintEngine::DirtyFlag, QFlags<QPaintEngine::DirtyFlag>)
    445,  // QGlobalSpace::operator|(QDialogButtonBox::StandardButton, QDialogButtonBox::StandardButton)
    446,  // QGlobalSpace::operator|(QAccessible::RelationFlag, QAccessible::RelationFlag)
    448,  // QGlobalSpace::operator|(QGraphicsScene::SceneLayer, QGraphicsScene::SceneLayer)
    451,  // QGlobalSpace::operator|(QInputDialog::InputDialogOption, QFlags<QInputDialog::InputDialogOption>)
    452,  // QGlobalSpace::operator|(QItemSelectionModel::SelectionFlag, QFlags<QItemSelectionModel::SelectionFlag>)
    454,  // QGlobalSpace::operator|(QGestureRecognizer::ResultFlag, int)
    456,  // QGlobalSpace::operator|(QStyleOptionViewItemV2::ViewItemFeature, QFlags<QStyleOptionViewItemV2::ViewItemFeature>)
    465,  // QGlobalSpace::operator|(QGraphicsBlurEffect::BlurHint, int)
    466,  // QGlobalSpace::operator|(QTextOption::Flag, QTextOption::Flag)
    468,  // QGlobalSpace::operator|(QDateTimeEdit::Section, QDateTimeEdit::Section)
    472,  // QGlobalSpace::operator|(QStyleOptionFrameV2::FrameFeature, QStyleOptionFrameV2::FrameFeature)
    475,  // QGlobalSpace::operator|(QTextEdit::AutoFormattingFlag, int)
    478,  // QGlobalSpace::operator|(QImageIOPlugin::Capability, QFlags<QImageIOPlugin::Capability>)
    483,  // QGlobalSpace::operator|(QDockWidget::DockWidgetFeature, int)
    485,  // QGlobalSpace::operator|(QGraphicsScene::SceneLayer, int)
    490,  // QGlobalSpace::operator|(QAccessible::RelationFlag, int)
    494,  // QGlobalSpace::operator|(QFontComboBox::FontFilter, QFlags<QFontComboBox::FontFilter>)
    495,  // QGlobalSpace::operator|(QFileDialog::Option, QFileDialog::Option)
    496,  // QGlobalSpace::operator|(QMdiArea::AreaOption, int)
    497,  // QGlobalSpace::operator|(QDateTimeEdit::Section, QFlags<QDateTimeEdit::Section>)
    498,  // QGlobalSpace::operator|(QDialogButtonBox::StandardButton, QFlags<QDialogButtonBox::StandardButton>)
    503,  // QGlobalSpace::operator|(QItemSelectionModel::SelectionFlag, QItemSelectionModel::SelectionFlag)
    512,  // QGlobalSpace::operator|(QStyle::StateFlag, QStyle::StateFlag)
    516,  // QGlobalSpace::operator|(QFontDialog::FontDialogOption, QFlags<QFontDialog::FontDialogOption>)
    517,  // QGlobalSpace::operator|(QGraphicsView::OptimizationFlag, QGraphicsView::OptimizationFlag)
    519,  // QGlobalSpace::operator|(QStyleOptionButton::ButtonFeature, QFlags<QStyleOptionButton::ButtonFeature>)
    520,  // QGlobalSpace::operator|(QColorDialog::ColorDialogOption, QColorDialog::ColorDialogOption)
    523,  // QGlobalSpace::operator|(QStyleOptionViewItemV2::ViewItemFeature, int)
    526,  // QGlobalSpace::operator|(QGraphicsItem::GraphicsItemFlag, QFlags<QGraphicsItem::GraphicsItemFlag>)
    531,  // QGlobalSpace::operator|(QTextItem::RenderFlag, QFlags<QTextItem::RenderFlag>)
    533,  // QGlobalSpace::operator|(QStyleOptionFrameV2::FrameFeature, int)
    534,  // QGlobalSpace::operator|(QDialogButtonBox::StandardButton, int)
    536,  // QGlobalSpace::operator|(QStyleOptionToolBar::ToolBarFeature, QStyleOptionToolBar::ToolBarFeature)
    539,  // QGlobalSpace::operator|(QTextItem::RenderFlag, int)
    542,  // QGlobalSpace::operator|(QMainWindow::DockOption, int)
    543,  // QGlobalSpace::operator|(QTextFormat::PageBreakFlag, QFlags<QTextFormat::PageBreakFlag>)
    545,  // QGlobalSpace::operator|(QStyleOptionFrameV2::FrameFeature, QFlags<QStyleOptionFrameV2::FrameFeature>)
    547,  // QGlobalSpace::operator|(QMdiSubWindow::SubWindowOption, int)
    548,  // QGlobalSpace::operator|(QGraphicsBlurEffect::BlurHint, QGraphicsBlurEffect::BlurHint)
    549,  // QGlobalSpace::operator|(QImageIOPlugin::Capability, QImageIOPlugin::Capability)
    553,  // QGlobalSpace::operator|(QTextOption::Flag, int)
    555,  // QGlobalSpace::operator|(QStyleOptionToolBar::ToolBarFeature, QFlags<QStyleOptionToolBar::ToolBarFeature>)
    556,  // QGlobalSpace::operator|(QMainWindow::DockOption, QMainWindow::DockOption)
    0,
    196,  // QGlobalSpace::qFuzzyCompare(const QVector2D&, const QVector2D&)
    197,  // QGlobalSpace::qFuzzyCompare(const QTransform&, const QTransform&)
    278,  // QGlobalSpace::qFuzzyCompare(const QMatrix4x4&, const QMatrix4x4&)
    419,  // QGlobalSpace::qFuzzyCompare(const QVector4D&, const QVector4D&)
    435,  // QGlobalSpace::qFuzzyCompare(const QMatrix&, const QMatrix&)
    447,  // QGlobalSpace::qFuzzyCompare(const QVector3D&, const QVector3D&)
    458,  // QGlobalSpace::qFuzzyCompare(const QQuaternion&, const QQuaternion&)
    0,
    141,  // QAudioInput::QAudioInput(const QAudioFormat&)
    142,  // QAudioInput::QAudioInput(const QAudioDeviceInfo&)
    0,
    117,  // QAudioInput::QAudioInput(const QAudioFormat&, QObject*)
    143,  // QAudioInput::QAudioInput(const QAudioDeviceInfo&, const QAudioFormat&)
    0,
    653,  // QVideoFrame::QVideoFrame(const QImage&)
    654,  // QVideoFrame::QVideoFrame(const QVideoFrame&)
    0,
    671,  // QVideoFrame::bits()
    672,  // QVideoFrame::bits() const
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {1, 7, 10},	// QAbstractVideoBuffer::CoreImageHandle
    {1, 41, 8},	// QAbstractVideoBuffer::GLTextureHandle
    {1, 48, 7},	// QAbstractVideoBuffer::NoHandle
    {1, 49, 13},	// QAbstractVideoBuffer::NotMapped
    {1, 53, 1},	// QAbstractVideoBuffer::QAbstractVideoBuffer$
    {1, 68, 11},	// QAbstractVideoBuffer::QPixmapHandle
    {1, 77, 14},	// QAbstractVideoBuffer::ReadOnly
    {1, 78, 16},	// QAbstractVideoBuffer::ReadWrite
    {1, 175, 12},	// QAbstractVideoBuffer::UserHandle
    {1, 176, 15},	// QAbstractVideoBuffer::WriteOnly
    {1, 177, 9},	// QAbstractVideoBuffer::XvShmImageHandle
    {1, 217, 6},	// QAbstractVideoBuffer::handle
    {1, 218, 2},	// QAbstractVideoBuffer::handleType
    {1, 232, 4},	// QAbstractVideoBuffer::map$$$
    {1, 233, 3},	// QAbstractVideoBuffer::mapMode
    {1, 453, 5},	// QAbstractVideoBuffer::unmap
    {1, 457, 17},	// QAbstractVideoBuffer::~QAbstractVideoBuffer
    {2, 44, 46},	// QAbstractVideoSurface::IncorrectFormatError
    {2, 47, 44},	// QAbstractVideoSurface::NoError
    {2, 54, 41},	// QAbstractVideoSurface::QAbstractVideoSurface
    {2, 55, 25},	// QAbstractVideoSurface::QAbstractVideoSurface#
    {2, 79, 48},	// QAbstractVideoSurface::ResourceError
    {2, 166, 47},	// QAbstractVideoSurface::StoppedError
    {2, 174, 45},	// QAbstractVideoSurface::UnsupportedFormatError
    {2, 186, 35},	// QAbstractVideoSurface::activeChanged$
    {2, 207, 34},	// QAbstractVideoSurface::error
    {2, 222, 32},	// QAbstractVideoSurface::isActive
    {2, 224, 27},	// QAbstractVideoSurface::isFormatSupported#
    {2, 235, 18},	// QAbstractVideoSurface::metaObject
    {2, 237, 28},	// QAbstractVideoSurface::nearestFormat#
    {2, 277, 33},	// QAbstractVideoSurface::present#
    {2, 366, 24},	// QAbstractVideoSurface::qt_metacall$$?
    {2, 368, 19},	// QAbstractVideoSurface::qt_metacast$
    {2, 388, 38},	// QAbstractVideoSurface::setError$
    {2, 422, 30},	// QAbstractVideoSurface::start#
    {2, 427, 43},	// QAbstractVideoSurface::staticMetaObject
    {2, 428, 31},	// QAbstractVideoSurface::stop
    {2, 433, 37},	// QAbstractVideoSurface::supportedFormatsChanged
    {2, 435, 42},	// QAbstractVideoSurface::supportedPixelFormats
    {2, 436, 26},	// QAbstractVideoSurface::supportedPixelFormats$
    {2, 440, 29},	// QAbstractVideoSurface::surfaceFormat
    {2, 442, 36},	// QAbstractVideoSurface::surfaceFormatChanged#
    {2, 446, 39},	// QAbstractVideoSurface::tr$
    {2, 447, 20},	// QAbstractVideoSurface::tr$$
    {2, 448, 22},	// QAbstractVideoSurface::tr$$$
    {2, 450, 40},	// QAbstractVideoSurface::trUtf8$
    {2, 451, 21},	// QAbstractVideoSurface::trUtf8$$
    {2, 452, 23},	// QAbstractVideoSurface::trUtf8$$$
    {2, 458, 49},	// QAbstractVideoSurface::~QAbstractVideoSurface
    {4, 1, 57},	// QAudio::ActiveState
    {4, 2, 50},	// QAudio::AudioInput
    {4, 3, 51},	// QAudio::AudioOutput
    {4, 8, 56},	// QAudio::FatalError
    {4, 42, 54},	// QAudio::IOError
    {4, 43, 60},	// QAudio::IdleState
    {4, 47, 52},	// QAudio::NoError
    {4, 50, 53},	// QAudio::OpenError
    {4, 167, 59},	// QAudio::StoppedState
    {4, 168, 58},	// QAudio::SuspendedState
    {4, 172, 55},	// QAudio::UnderrunError
    {5, 56, 61},	// QAudioDeviceInfo::QAudioDeviceInfo
    {5, 57, 62},	// QAudioDeviceInfo::QAudioDeviceInfo#
    {5, 188, 79},	// QAudioDeviceInfo::availableDevices$
    {5, 201, 77},	// QAudioDeviceInfo::defaultInputDevice
    {5, 202, 78},	// QAudioDeviceInfo::defaultOutputDevice
    {5, 203, 65},	// QAudioDeviceInfo::deviceName
    {5, 224, 66},	// QAudioDeviceInfo::isFormatSupported#
    {5, 226, 64},	// QAudioDeviceInfo::isNull
    {5, 237, 68},	// QAudioDeviceInfo::nearestFormat#
    {5, 260, 63},	// QAudioDeviceInfo::operator=#
    {5, 275, 67},	// QAudioDeviceInfo::preferredFormat
    {5, 429, 75},	// QAudioDeviceInfo::supportedByteOrders
    {5, 430, 73},	// QAudioDeviceInfo::supportedChannelCounts
    {5, 431, 72},	// QAudioDeviceInfo::supportedChannels
    {5, 432, 69},	// QAudioDeviceInfo::supportedCodecs
    {5, 434, 70},	// QAudioDeviceInfo::supportedFrequencies
    {5, 437, 71},	// QAudioDeviceInfo::supportedSampleRates
    {5, 438, 74},	// QAudioDeviceInfo::supportedSampleSizes
    {5, 439, 76},	// QAudioDeviceInfo::supportedSampleTypes
    {5, 459, 80},	// QAudioDeviceInfo::~QAudioDeviceInfo
    {6, 4, 107},	// QAudioFormat::BigEndian
    {6, 9, 106},	// QAudioFormat::Float
    {6, 46, 108},	// QAudioFormat::LittleEndian
    {6, 58, 81},	// QAudioFormat::QAudioFormat
    {6, 59, 82},	// QAudioFormat::QAudioFormat#
    {6, 165, 104},	// QAudioFormat::SignedInt
    {6, 171, 105},	// QAudioFormat::UnSignedInt
    {6, 173, 103},	// QAudioFormat::Unknown
    {6, 191, 100},	// QAudioFormat::byteOrder
    {6, 195, 94},	// QAudioFormat::channelCount
    {6, 196, 92},	// QAudioFormat::channels
    {6, 198, 98},	// QAudioFormat::codec
    {6, 216, 88},	// QAudioFormat::frequency
    {6, 228, 86},	// QAudioFormat::isValid
    {6, 241, 85},	// QAudioFormat::operator!=#
    {6, 260, 83},	// QAudioFormat::operator=#
    {6, 262, 84},	// QAudioFormat::operator==#
    {6, 371, 90},	// QAudioFormat::sampleRate
    {6, 372, 96},	// QAudioFormat::sampleSize
    {6, 373, 102},	// QAudioFormat::sampleType
    {6, 378, 99},	// QAudioFormat::setByteOrder$
    {6, 380, 93},	// QAudioFormat::setChannelCount$
    {6, 382, 91},	// QAudioFormat::setChannels$
    {6, 384, 97},	// QAudioFormat::setCodec$
    {6, 397, 87},	// QAudioFormat::setFrequency$
    {6, 406, 89},	// QAudioFormat::setSampleRate$
    {6, 408, 95},	// QAudioFormat::setSampleSize$
    {6, 410, 101},	// QAudioFormat::setSampleType$
    {6, 460, 109},	// QAudioFormat::~QAudioFormat
    {7, 60, 140},	// QAudioInput::QAudioInput
    {7, 61, -328},	// QAudioInput::QAudioInput#
    {7, 62, -331},	// QAudioInput::QAudioInput##
    {7, 63, 118},	// QAudioInput::QAudioInput###
    {7, 190, 127},	// QAudioInput::bufferSize
    {7, 194, 128},	// QAudioInput::bytesReady
    {7, 205, 133},	// QAudioInput::elapsedUSecs
    {7, 207, 134},	// QAudioInput::error
    {7, 211, 119},	// QAudioInput::format
    {7, 235, 110},	// QAudioInput::metaObject
    {7, 238, 137},	// QAudioInput::notify
    {7, 239, 131},	// QAudioInput::notifyInterval
    {7, 270, 129},	// QAudioInput::periodSize
    {7, 278, 132},	// QAudioInput::processedUSecs
    {7, 366, 116},	// QAudioInput::qt_metacall$$?
    {7, 368, 111},	// QAudioInput::qt_metacast$
    {7, 369, 123},	// QAudioInput::reset
    {7, 370, 125},	// QAudioInput::resume
    {7, 376, 126},	// QAudioInput::setBufferSize$
    {7, 399, 130},	// QAudioInput::setNotifyInterval$
    {7, 421, 121},	// QAudioInput::start
    {7, 422, 120},	// QAudioInput::start#
    {7, 424, 135},	// QAudioInput::state
    {7, 426, 136},	// QAudioInput::stateChanged$
    {7, 427, 144},	// QAudioInput::staticMetaObject
    {7, 428, 122},	// QAudioInput::stop
    {7, 443, 124},	// QAudioInput::suspend
    {7, 446, 138},	// QAudioInput::tr$
    {7, 447, 112},	// QAudioInput::tr$$
    {7, 448, 114},	// QAudioInput::tr$$$
    {7, 450, 139},	// QAudioInput::trUtf8$
    {7, 451, 113},	// QAudioInput::trUtf8$$
    {7, 452, 115},	// QAudioInput::trUtf8$$$
    {7, 461, 145},	// QAudioInput::~QAudioInput
    {8, 64, 176},	// QAudioOutput::QAudioOutput
    {8, 65, -1},	// QAudioOutput::QAudioOutput#
    {8, 66, -4},	// QAudioOutput::QAudioOutput##
    {8, 67, 154},	// QAudioOutput::QAudioOutput###
    {8, 190, 163},	// QAudioOutput::bufferSize
    {8, 192, 164},	// QAudioOutput::bytesFree
    {8, 205, 169},	// QAudioOutput::elapsedUSecs
    {8, 207, 170},	// QAudioOutput::error
    {8, 211, 155},	// QAudioOutput::format
    {8, 235, 146},	// QAudioOutput::metaObject
    {8, 238, 173},	// QAudioOutput::notify
    {8, 239, 167},	// QAudioOutput::notifyInterval
    {8, 270, 165},	// QAudioOutput::periodSize
    {8, 278, 168},	// QAudioOutput::processedUSecs
    {8, 366, 152},	// QAudioOutput::qt_metacall$$?
    {8, 368, 147},	// QAudioOutput::qt_metacast$
    {8, 369, 159},	// QAudioOutput::reset
    {8, 370, 161},	// QAudioOutput::resume
    {8, 376, 162},	// QAudioOutput::setBufferSize$
    {8, 399, 166},	// QAudioOutput::setNotifyInterval$
    {8, 421, 157},	// QAudioOutput::start
    {8, 422, 156},	// QAudioOutput::start#
    {8, 424, 171},	// QAudioOutput::state
    {8, 426, 172},	// QAudioOutput::stateChanged$
    {8, 427, 180},	// QAudioOutput::staticMetaObject
    {8, 428, 158},	// QAudioOutput::stop
    {8, 443, 160},	// QAudioOutput::suspend
    {8, 446, 174},	// QAudioOutput::tr$
    {8, 447, 148},	// QAudioOutput::tr$$
    {8, 448, 150},	// QAudioOutput::tr$$$
    {8, 450, 175},	// QAudioOutput::trUtf8$
    {8, 451, 149},	// QAudioOutput::trUtf8$$
    {8, 452, 151},	// QAudioOutput::trUtf8$$$
    {8, 462, 181},	// QAudioOutput::~QAudioOutput
    {19, 80, 621},	// QGlobalSpace::SP_CustomCameraCaptureButton
    {19, 81, 622},	// QGlobalSpace::SP_CustomCameraCaptureButtonPressed
    {19, 82, 623},	// QGlobalSpace::SP_CustomCameraPauseButton
    {19, 83, 624},	// QGlobalSpace::SP_CustomCameraPauseButtonPressed
    {19, 84, 625},	// QGlobalSpace::SP_CustomCameraPlayButton
    {19, 85, 626},	// QGlobalSpace::SP_CustomCameraPlayButtonPressed
    {19, 86, 627},	// QGlobalSpace::SP_CustomCameraRecButton
    {19, 87, 628},	// QGlobalSpace::SP_CustomCameraRecButtonPressed
    {19, 88, 629},	// QGlobalSpace::SP_CustomCameraStopButton
    {19, 89, 630},	// QGlobalSpace::SP_CustomCameraStopButtonPressed
    {19, 90, 631},	// QGlobalSpace::SP_CustomTabAll
    {19, 91, 632},	// QGlobalSpace::SP_CustomTabArtist
    {19, 92, 633},	// QGlobalSpace::SP_CustomTabFavourite
    {19, 93, 634},	// QGlobalSpace::SP_CustomTabGenre
    {19, 94, 635},	// QGlobalSpace::SP_CustomTabLanguage
    {19, 95, 636},	// QGlobalSpace::SP_CustomTabMusicAlbum
    {19, 96, 637},	// QGlobalSpace::SP_CustomTabPhotosAlbum
    {19, 97, 638},	// QGlobalSpace::SP_CustomTabPhotosAll
    {19, 98, 639},	// QGlobalSpace::SP_CustomTabPlaylist
    {19, 99, 640},	// QGlobalSpace::SP_CustomTabServices
    {19, 100, 641},	// QGlobalSpace::SP_CustomTabSongs
    {19, 101, 642},	// QGlobalSpace::SP_CustomTabVideos
    {19, 102, 558},	// QGlobalSpace::SP_CustomToolBarAdd
    {19, 103, 559},	// QGlobalSpace::SP_CustomToolBarAddDetail
    {19, 104, 560},	// QGlobalSpace::SP_CustomToolBarAgain
    {19, 105, 561},	// QGlobalSpace::SP_CustomToolBarAgenda
    {19, 106, 562},	// QGlobalSpace::SP_CustomToolBarAudioOff
    {19, 107, 563},	// QGlobalSpace::SP_CustomToolBarAudioOn
    {19, 108, 564},	// QGlobalSpace::SP_CustomToolBarBack
    {19, 109, 565},	// QGlobalSpace::SP_CustomToolBarBluetoothOff
    {19, 110, 566},	// QGlobalSpace::SP_CustomToolBarBluetoothOn
    {19, 111, 567},	// QGlobalSpace::SP_CustomToolBarCancel
    {19, 112, 568},	// QGlobalSpace::SP_CustomToolBarDelete
    {19, 113, 569},	// QGlobalSpace::SP_CustomToolBarDone
    {19, 114, 570},	// QGlobalSpace::SP_CustomToolBarEdit
    {19, 115, 571},	// QGlobalSpace::SP_CustomToolBarEditDisabled
    {19, 116, 572},	// QGlobalSpace::SP_CustomToolBarEmailSend
    {19, 117, 573},	// QGlobalSpace::SP_CustomToolBarEmergencyCall
    {19, 118, 574},	// QGlobalSpace::SP_CustomToolBarFavouriteAdd
    {19, 119, 575},	// QGlobalSpace::SP_CustomToolBarFavouriteRemove
    {19, 120, 576},	// QGlobalSpace::SP_CustomToolBarFavourites
    {19, 121, 577},	// QGlobalSpace::SP_CustomToolBarGo
    {19, 122, 578},	// QGlobalSpace::SP_CustomToolBarHome
    {19, 123, 579},	// QGlobalSpace::SP_CustomToolBarImageTools
    {19, 124, 580},	// QGlobalSpace::SP_CustomToolBarList
    {19, 125, 581},	// QGlobalSpace::SP_CustomToolBarLock
    {19, 126, 582},	// QGlobalSpace::SP_CustomToolBarLogs
    {19, 127, 583},	// QGlobalSpace::SP_CustomToolBarMenu
    {19, 128, 584},	// QGlobalSpace::SP_CustomToolBarNewContact
    {19, 129, 585},	// QGlobalSpace::SP_CustomToolBarNewGroup
    {19, 130, 586},	// QGlobalSpace::SP_CustomToolBarNextFrame
    {19, 131, 587},	// QGlobalSpace::SP_CustomToolBarNowPlay
    {19, 132, 588},	// QGlobalSpace::SP_CustomToolBarOptions
    {19, 133, 589},	// QGlobalSpace::SP_CustomToolBarOther
    {19, 134, 590},	// QGlobalSpace::SP_CustomToolBarOvi
    {19, 135, 591},	// QGlobalSpace::SP_CustomToolBarPreviousFrame
    {19, 136, 592},	// QGlobalSpace::SP_CustomToolBarRead
    {19, 137, 594},	// QGlobalSpace::SP_CustomToolBarRedo
    {19, 138, 593},	// QGlobalSpace::SP_CustomToolBarRedoDisabled
    {19, 139, 595},	// QGlobalSpace::SP_CustomToolBarRefresh
    {19, 140, 596},	// QGlobalSpace::SP_CustomToolBarRemoveDetail
    {19, 141, 597},	// QGlobalSpace::SP_CustomToolBarRemoveDisabled
    {19, 142, 598},	// QGlobalSpace::SP_CustomToolBarRepeat
    {19, 143, 599},	// QGlobalSpace::SP_CustomToolBarRepeatOff
    {19, 144, 600},	// QGlobalSpace::SP_CustomToolBarRepeatOne
    {19, 145, 601},	// QGlobalSpace::SP_CustomToolBarSearch
    {19, 146, 602},	// QGlobalSpace::SP_CustomToolBarSearchDisabled
    {19, 147, 603},	// QGlobalSpace::SP_CustomToolBarSelectContent
    {19, 148, 604},	// QGlobalSpace::SP_CustomToolBarSelfTimer
    {19, 149, 605},	// QGlobalSpace::SP_CustomToolBarSend
    {19, 150, 606},	// QGlobalSpace::SP_CustomToolBarSendDimmed
    {19, 151, 607},	// QGlobalSpace::SP_CustomToolBarShare
    {19, 152, 608},	// QGlobalSpace::SP_CustomToolBarShift
    {19, 153, 609},	// QGlobalSpace::SP_CustomToolBarShuffle
    {19, 154, 610},	// QGlobalSpace::SP_CustomToolBarShuffleOff
    {19, 155, 611},	// QGlobalSpace::SP_CustomToolBarSignalOff
    {19, 156, 612},	// QGlobalSpace::SP_CustomToolBarSignalOn
    {19, 157, 613},	// QGlobalSpace::SP_CustomToolBarSync
    {19, 158, 614},	// QGlobalSpace::SP_CustomToolBarTools
    {19, 159, 615},	// QGlobalSpace::SP_CustomToolBarTrim
    {19, 160, 616},	// QGlobalSpace::SP_CustomToolBarUnlock
    {19, 161, 617},	// QGlobalSpace::SP_CustomToolBarUnmark
    {19, 162, 618},	// QGlobalSpace::SP_CustomToolBarView
    {19, 163, 619},	// QGlobalSpace::SP_CustomToolBarWlanOff
    {19, 164, 620},	// QGlobalSpace::SP_CustomToolBarWlanOn
    {19, 242, -7},	// QGlobalSpace::operator!=##
    {19, 244, -12},	// QGlobalSpace::operator*##
    {19, 245, -42},	// QGlobalSpace::operator*#$
    {19, 246, -49},	// QGlobalSpace::operator*$#
    {19, 248, -55},	// QGlobalSpace::operator+##
    {19, 249, 510},	// QGlobalSpace::operator+#$
    {19, 251, -61},	// QGlobalSpace::operator-#
    {19, 252, -67},	// QGlobalSpace::operator-##
    {19, 253, 557},	// QGlobalSpace::operator-#$
    {19, 255, -73},	// QGlobalSpace::operator/#$
    {19, 257, -80},	// QGlobalSpace::operator<<##
    {19, 258, -133},	// QGlobalSpace::operator<<#$
    {19, 263, -139},	// QGlobalSpace::operator==##
    {19, 264, 427},	// QGlobalSpace::operator==#$
    {19, 265, 391},	// QGlobalSpace::operator==$#
    {19, 267, -144},	// QGlobalSpace::operator>>##
    {19, 269, -175},	// QGlobalSpace::operator|$$
    {19, 282, 540},	// QGlobalSpace::qAccessibleActionCastHelper
    {19, 283, 469},	// QGlobalSpace::qAccessibleEditableTextCastHelper
    {19, 284, 369},	// QGlobalSpace::qAccessibleImageCastHelper
    {19, 285, 453},	// QGlobalSpace::qAccessibleTable2CastHelper
    {19, 286, 386},	// QGlobalSpace::qAccessibleTableCastHelper
    {19, 287, 277},	// QGlobalSpace::qAccessibleTextCastHelper
    {19, 288, 430},	// QGlobalSpace::qAccessibleValueCastHelper
    {19, 290, 210},	// QGlobalSpace::qAlpha$
    {19, 292, 541},	// QGlobalSpace::qBlue$
    {19, 294, 493},	// QGlobalSpace::qDrawBorderPixmap####
    {19, 295, 346},	// QGlobalSpace::qDrawBorderPixmap######
    {19, 296, 347},	// QGlobalSpace::qDrawBorderPixmap#######
    {19, 297, 345},	// QGlobalSpace::qDrawBorderPixmap#######$
    {19, 299, 338},	// QGlobalSpace::qDrawPlainRect###
    {19, 300, 339},	// QGlobalSpace::qDrawPlainRect###$
    {19, 301, 337},	// QGlobalSpace::qDrawPlainRect###$#
    {19, 302, 329},	// QGlobalSpace::qDrawPlainRect#$$$$#
    {19, 303, 330},	// QGlobalSpace::qDrawPlainRect#$$$$#$
    {19, 304, 328},	// QGlobalSpace::qDrawPlainRect#$$$$#$#
    {19, 306, 500},	// QGlobalSpace::qDrawShadeLine####
    {19, 307, 501},	// QGlobalSpace::qDrawShadeLine####$
    {19, 308, 502},	// QGlobalSpace::qDrawShadeLine####$$
    {19, 309, 499},	// QGlobalSpace::qDrawShadeLine####$$$
    {19, 310, 460},	// QGlobalSpace::qDrawShadeLine#$$$$#
    {19, 311, 461},	// QGlobalSpace::qDrawShadeLine#$$$$#$
    {19, 312, 462},	// QGlobalSpace::qDrawShadeLine#$$$$#$$
    {19, 313, 459},	// QGlobalSpace::qDrawShadeLine#$$$$#$$$
    {19, 315, 216},	// QGlobalSpace::qDrawShadePanel###
    {19, 316, 217},	// QGlobalSpace::qDrawShadePanel###$
    {19, 317, 218},	// QGlobalSpace::qDrawShadePanel###$$
    {19, 318, 215},	// QGlobalSpace::qDrawShadePanel###$$#
    {19, 319, 296},	// QGlobalSpace::qDrawShadePanel#$$$$#
    {19, 320, 297},	// QGlobalSpace::qDrawShadePanel#$$$$#$
    {19, 321, 298},	// QGlobalSpace::qDrawShadePanel#$$$$#$$
    {19, 322, 295},	// QGlobalSpace::qDrawShadePanel#$$$$#$$#
    {19, 324, 316},	// QGlobalSpace::qDrawShadeRect###
    {19, 325, 317},	// QGlobalSpace::qDrawShadeRect###$
    {19, 326, 318},	// QGlobalSpace::qDrawShadeRect###$$
    {19, 327, 319},	// QGlobalSpace::qDrawShadeRect###$$$
    {19, 328, 315},	// QGlobalSpace::qDrawShadeRect###$$$#
    {19, 329, 235},	// QGlobalSpace::qDrawShadeRect#$$$$#
    {19, 330, 236},	// QGlobalSpace::qDrawShadeRect#$$$$#$
    {19, 331, 237},	// QGlobalSpace::qDrawShadeRect#$$$$#$$
    {19, 332, 238},	// QGlobalSpace::qDrawShadeRect#$$$$#$$$
    {19, 333, 234},	// QGlobalSpace::qDrawShadeRect#$$$$#$$$#
    {19, 335, 302},	// QGlobalSpace::qDrawWinButton###
    {19, 336, 303},	// QGlobalSpace::qDrawWinButton###$
    {19, 337, 301},	// QGlobalSpace::qDrawWinButton###$#
    {19, 338, 229},	// QGlobalSpace::qDrawWinButton#$$$$#
    {19, 339, 230},	// QGlobalSpace::qDrawWinButton#$$$$#$
    {19, 340, 228},	// QGlobalSpace::qDrawWinButton#$$$$#$#
    {19, 342, 506},	// QGlobalSpace::qDrawWinPanel###
    {19, 343, 507},	// QGlobalSpace::qDrawWinPanel###$
    {19, 344, 505},	// QGlobalSpace::qDrawWinPanel###$#
    {19, 345, 529},	// QGlobalSpace::qDrawWinPanel#$$$$#
    {19, 346, 530},	// QGlobalSpace::qDrawWinPanel#$$$$#$
    {19, 347, 528},	// QGlobalSpace::qDrawWinPanel#$$$$#$#
    {19, 349, -320},	// QGlobalSpace::qFuzzyCompare##
    {19, 351, 198},	// QGlobalSpace::qGray$
    {19, 352, 248},	// QGlobalSpace::qGray$$$
    {19, 354, 213},	// QGlobalSpace::qGreen$
    {19, 356, 513},	// QGlobalSpace::qHash#
    {19, 358, 396},	// QGlobalSpace::qIsGray$
    {19, 360, 202},	// QGlobalSpace::qRed$
    {19, 362, 418},	// QGlobalSpace::qRgb$$$
    {19, 364, 554},	// QGlobalSpace::qRgba$$$$
    {69, 5, 683},	// QVideoFrame::BottomField
    {69, 10, 686},	// QVideoFrame::Format_ARGB32
    {69, 11, 687},	// QVideoFrame::Format_ARGB32_Premultiplied
    {69, 12, 692},	// QVideoFrame::Format_ARGB8565_Premultiplied
    {69, 13, 700},	// QVideoFrame::Format_AYUV444
    {69, 14, 701},	// QVideoFrame::Format_AYUV444_Premultiplied
    {69, 15, 696},	// QVideoFrame::Format_BGR24
    {69, 16, 695},	// QVideoFrame::Format_BGR32
    {69, 17, 698},	// QVideoFrame::Format_BGR555
    {69, 18, 697},	// QVideoFrame::Format_BGR565
    {69, 19, 693},	// QVideoFrame::Format_BGRA32
    {69, 20, 694},	// QVideoFrame::Format_BGRA32_Premultiplied
    {69, 21, 699},	// QVideoFrame::Format_BGRA5658_Premultiplied
    {69, 22, 709},	// QVideoFrame::Format_IMC1
    {69, 23, 710},	// QVideoFrame::Format_IMC2
    {69, 24, 711},	// QVideoFrame::Format_IMC3
    {69, 25, 712},	// QVideoFrame::Format_IMC4
    {69, 26, 685},	// QVideoFrame::Format_Invalid
    {69, 27, 707},	// QVideoFrame::Format_NV12
    {69, 28, 708},	// QVideoFrame::Format_NV21
    {69, 29, 689},	// QVideoFrame::Format_RGB24
    {69, 30, 688},	// QVideoFrame::Format_RGB32
    {69, 31, 691},	// QVideoFrame::Format_RGB555
    {69, 32, 690},	// QVideoFrame::Format_RGB565
    {69, 33, 705},	// QVideoFrame::Format_UYVY
    {69, 34, 715},	// QVideoFrame::Format_User
    {69, 35, 714},	// QVideoFrame::Format_Y16
    {69, 36, 713},	// QVideoFrame::Format_Y8
    {69, 37, 703},	// QVideoFrame::Format_YUV420P
    {69, 38, 702},	// QVideoFrame::Format_YUV444
    {69, 39, 706},	// QVideoFrame::Format_YUYV
    {69, 40, 704},	// QVideoFrame::Format_YV12
    {69, 45, 684},	// QVideoFrame::InterlacedFrame
    {69, 51, 681},	// QVideoFrame::ProgressiveFrame
    {69, 69, 650},	// QVideoFrame::QVideoFrame
    {69, 70, -334},	// QVideoFrame::QVideoFrame#
    {69, 71, 651},	// QVideoFrame::QVideoFrame##$
    {69, 72, 652},	// QVideoFrame::QVideoFrame$#$$
    {69, 169, 682},	// QVideoFrame::TopField
    {69, 189, -337},	// QVideoFrame::bits
    {69, 193, 670},	// QVideoFrame::bytesPerLine
    {69, 206, 677},	// QVideoFrame::endTime
    {69, 210, 662},	// QVideoFrame::fieldType
    {69, 217, 674},	// QVideoFrame::handle
    {69, 218, 658},	// QVideoFrame::handleType
    {69, 219, 661},	// QVideoFrame::height
    {69, 221, 680},	// QVideoFrame::imageFormatFromPixelFormat$
    {69, 225, 664},	// QVideoFrame::isMapped
    {69, 227, 665},	// QVideoFrame::isReadable
    {69, 228, 656},	// QVideoFrame::isValid
    {69, 229, 666},	// QVideoFrame::isWritable
    {69, 231, 668},	// QVideoFrame::map$
    {69, 233, 667},	// QVideoFrame::mapMode
    {69, 234, 673},	// QVideoFrame::mappedBytes
    {69, 260, 655},	// QVideoFrame::operator=#
    {69, 272, 657},	// QVideoFrame::pixelFormat
    {69, 274, 679},	// QVideoFrame::pixelFormatFromImageFormat$
    {69, 386, 678},	// QVideoFrame::setEndTime$
    {69, 390, 663},	// QVideoFrame::setFieldType$
    {69, 414, 676},	// QVideoFrame::setStartTime$
    {69, 419, 659},	// QVideoFrame::size
    {69, 423, 675},	// QVideoFrame::startTime
    {69, 453, 669},	// QVideoFrame::unmap
    {69, 455, 660},	// QVideoFrame::width
    {69, 463, 716},	// QVideoFrame::~QVideoFrame
    {70, 6, 748},	// QVideoSurfaceFormat::BottomToTop
    {70, 73, 717},	// QVideoSurfaceFormat::QVideoSurfaceFormat
    {70, 74, 719},	// QVideoSurfaceFormat::QVideoSurfaceFormat#
    {70, 75, 746},	// QVideoSurfaceFormat::QVideoSurfaceFormat#$
    {70, 76, 718},	// QVideoSurfaceFormat::QVideoSurfaceFormat#$$
    {70, 170, 747},	// QVideoSurfaceFormat::TopToBottom
    {70, 178, 750},	// QVideoSurfaceFormat::YCbCr_BT601
    {70, 179, 751},	// QVideoSurfaceFormat::YCbCr_BT709
    {70, 180, 755},	// QVideoSurfaceFormat::YCbCr_CustomMatrix
    {70, 181, 754},	// QVideoSurfaceFormat::YCbCr_JPEG
    {70, 182, 749},	// QVideoSurfaceFormat::YCbCr_Undefined
    {70, 183, 752},	// QVideoSurfaceFormat::YCbCr_xvYCC601
    {70, 184, 753},	// QVideoSurfaceFormat::YCbCr_xvYCC709
    {70, 212, 730},	// QVideoSurfaceFormat::frameHeight
    {70, 213, 735},	// QVideoSurfaceFormat::frameRate
    {70, 214, 726},	// QVideoSurfaceFormat::frameSize
    {70, 215, 729},	// QVideoSurfaceFormat::frameWidth
    {70, 218, 725},	// QVideoSurfaceFormat::handleType
    {70, 228, 723},	// QVideoSurfaceFormat::isValid
    {70, 241, 722},	// QVideoSurfaceFormat::operator!=#
    {70, 260, 720},	// QVideoSurfaceFormat::operator=#
    {70, 262, 721},	// QVideoSurfaceFormat::operator==#
    {70, 271, 737},	// QVideoSurfaceFormat::pixelAspectRatio
    {70, 272, 724},	// QVideoSurfaceFormat::pixelFormat
    {70, 280, 744},	// QVideoSurfaceFormat::property$
    {70, 281, 743},	// QVideoSurfaceFormat::propertyNames
    {70, 374, 733},	// QVideoSurfaceFormat::scanLineDirection
    {70, 392, 736},	// QVideoSurfaceFormat::setFrameRate$
    {70, 394, 727},	// QVideoSurfaceFormat::setFrameSize#
    {70, 395, 728},	// QVideoSurfaceFormat::setFrameSize$$
    {70, 401, 738},	// QVideoSurfaceFormat::setPixelAspectRatio#
    {70, 402, 739},	// QVideoSurfaceFormat::setPixelAspectRatio$$
    {70, 404, 745},	// QVideoSurfaceFormat::setProperty$#
    {70, 412, 734},	// QVideoSurfaceFormat::setScanLineDirection$
    {70, 416, 732},	// QVideoSurfaceFormat::setViewport#
    {70, 418, 741},	// QVideoSurfaceFormat::setYCbCrColorSpace$
    {70, 420, 742},	// QVideoSurfaceFormat::sizeHint
    {70, 454, 731},	// QVideoSurfaceFormat::viewport
    {70, 456, 740},	// QVideoSurfaceFormat::yCbCrColorSpace
    {70, 464, 756},	// QVideoSurfaceFormat::~QVideoSurfaceFormat
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();

static bool initialized = false;
Smoke *qtmultimedia_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qtmultimedia_Smoke() {
    init_qtcore_Smoke();
    if (initialized) return;
    qtmultimedia_Smoke = new Smoke(
        "qtmultimedia",
        __smokeqtmultimedia::classes, 70,
        __smokeqtmultimedia::methods, 757,
        __smokeqtmultimedia::methodMaps, 451,
        __smokeqtmultimedia::methodNames, 464,
        __smokeqtmultimedia::types, 353,
        __smokeqtmultimedia::inheritanceList,
        __smokeqtmultimedia::argumentList,
        __smokeqtmultimedia::ambiguousMethodList,
        __smokeqtmultimedia::cast );
    initialized = true;
}

void delete_qtmultimedia_Smoke() { delete qtmultimedia_Smoke; }

}
