#include <qtdbus_includes.h>

#include <smoke.h>
#include <qtdbus_smoke.h>

namespace __smokeqtdbus {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //DBusError
      switch(to) {
        case 1: return (void*)(DBusError*)xptr;
        default: return xptr;
      }
    case 2:   //QBool
      switch(to) {
        case 2: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 3:   //QByteArray
      switch(to) {
        case 3: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 4:   //QChildEvent
      switch(to) {
        case 27: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 4: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 6:   //QDBusAbstractAdaptor
      switch(to) {
        case 33: return (void*)(QObject*)(QDBusAbstractAdaptor*)xptr;
        case 6: return (void*)(QDBusAbstractAdaptor*)xptr;
        default: return xptr;
      }
    case 7:   //QDBusAbstractInterface
      switch(to) {
        case 8: return (void*)(QDBusAbstractInterfaceBase*)(QDBusAbstractInterface*)xptr;
        case 33: return (void*)(QObject*)(QDBusAbstractInterface*)xptr;
        case 7: return (void*)(QDBusAbstractInterface*)xptr;
        case 14: return (void*)(QDBusInterface*)(QDBusAbstractInterface*)xptr;
        case 11: return (void*)(QDBusConnectionInterface*)(QDBusAbstractInterface*)xptr;
        default: return xptr;
      }
    case 8:   //QDBusAbstractInterfaceBase
      switch(to) {
        case 33: return (void*)(QObject*)(QDBusAbstractInterfaceBase*)xptr;
        case 8: return (void*)(QDBusAbstractInterfaceBase*)xptr;
        case 7: return (void*)(QDBusAbstractInterface*)(QDBusAbstractInterfaceBase*)xptr;
        case 14: return (void*)(QDBusInterface*)(QDBusAbstractInterfaceBase*)xptr;
        case 11: return (void*)(QDBusConnectionInterface*)(QDBusAbstractInterfaceBase*)xptr;
        default: return xptr;
      }
    case 9:   //QDBusArgument
      switch(to) {
        case 9: return (void*)(QDBusArgument*)xptr;
        default: return xptr;
      }
    case 10:   //QDBusConnection
      switch(to) {
        case 10: return (void*)(QDBusConnection*)xptr;
        default: return xptr;
      }
    case 11:   //QDBusConnectionInterface
      switch(to) {
        case 7: return (void*)(QDBusAbstractInterface*)(QDBusConnectionInterface*)xptr;
        case 8: return (void*)(QDBusAbstractInterfaceBase*)(QDBusConnectionInterface*)xptr;
        case 33: return (void*)(QObject*)(QDBusConnectionInterface*)xptr;
        case 11: return (void*)(QDBusConnectionInterface*)xptr;
        default: return xptr;
      }
    case 12:   //QDBusContext
      switch(to) {
        case 12: return (void*)(QDBusContext*)xptr;
        default: return xptr;
      }
    case 13:   //QDBusError
      switch(to) {
        case 13: return (void*)(QDBusError*)xptr;
        default: return xptr;
      }
    case 14:   //QDBusInterface
      switch(to) {
        case 7: return (void*)(QDBusAbstractInterface*)(QDBusInterface*)xptr;
        case 8: return (void*)(QDBusAbstractInterfaceBase*)(QDBusInterface*)xptr;
        case 33: return (void*)(QObject*)(QDBusInterface*)xptr;
        case 14: return (void*)(QDBusInterface*)xptr;
        default: return xptr;
      }
    case 15:   //QDBusMessage
      switch(to) {
        case 15: return (void*)(QDBusMessage*)xptr;
        default: return xptr;
      }
    case 16:   //QDBusMetaType
      switch(to) {
        case 16: return (void*)(QDBusMetaType*)xptr;
        default: return xptr;
      }
    case 17:   //QDBusPendingCall
      switch(to) {
        case 17: return (void*)(QDBusPendingCall*)xptr;
        case 18: return (void*)(QDBusPendingCallWatcher*)(QDBusPendingCall*)xptr;
        default: return xptr;
      }
    case 18:   //QDBusPendingCallWatcher
      switch(to) {
        case 33: return (void*)(QObject*)(QDBusPendingCallWatcher*)xptr;
        case 17: return (void*)(QDBusPendingCall*)(QDBusPendingCallWatcher*)xptr;
        case 18: return (void*)(QDBusPendingCallWatcher*)xptr;
        default: return xptr;
      }
    case 19:   //QDBusServer
      switch(to) {
        case 33: return (void*)(QObject*)(QDBusServer*)xptr;
        case 19: return (void*)(QDBusServer*)xptr;
        default: return xptr;
      }
    case 20:   //QDBusServiceWatcher
      switch(to) {
        case 33: return (void*)(QObject*)(QDBusServiceWatcher*)xptr;
        case 20: return (void*)(QDBusServiceWatcher*)xptr;
        default: return xptr;
      }
    case 21:   //QDBusUnixFileDescriptor
      switch(to) {
        case 21: return (void*)(QDBusUnixFileDescriptor*)xptr;
        default: return xptr;
      }
    case 22:   //QDBusVariant
      switch(to) {
        case 43: return (void*)(QVariant*)(QDBusVariant*)xptr;
        case 22: return (void*)(QDBusVariant*)xptr;
        default: return xptr;
      }
    case 23:   //QDBusVirtualObject
      switch(to) {
        case 33: return (void*)(QObject*)(QDBusVirtualObject*)xptr;
        case 23: return (void*)(QDBusVirtualObject*)xptr;
        default: return xptr;
      }
    case 24:   //QDate
      switch(to) {
        case 24: return (void*)(QDate*)xptr;
        default: return xptr;
      }
    case 25:   //QDateTime
      switch(to) {
        case 25: return (void*)(QDateTime*)xptr;
        default: return xptr;
      }
    case 26:   //QDebug
      switch(to) {
        case 26: return (void*)(QDebug*)xptr;
        default: return xptr;
      }
    case 27:   //QEvent
      switch(to) {
        case 27: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 29:   //QIncompatibleFlag
      switch(to) {
        case 29: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 30:   //QLine
      switch(to) {
        case 30: return (void*)(QLine*)xptr;
        default: return xptr;
      }
    case 31:   //QLineF
      switch(to) {
        case 31: return (void*)(QLineF*)xptr;
        default: return xptr;
      }
    case 32:   //QMetaObject
      switch(to) {
        case 32: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 33:   //QObject
      switch(to) {
        case 33: return (void*)(QObject*)xptr;
        case 6: return (void*)(QDBusAbstractAdaptor*)(QObject*)xptr;
        case 7: return (void*)(QDBusAbstractInterface*)(QObject*)xptr;
        case 18: return (void*)(QDBusPendingCallWatcher*)(QObject*)xptr;
        case 8: return (void*)(QDBusAbstractInterfaceBase*)(QObject*)xptr;
        case 20: return (void*)(QDBusServiceWatcher*)(QObject*)xptr;
        case 14: return (void*)(QDBusInterface*)(QObject*)xptr;
        case 11: return (void*)(QDBusConnectionInterface*)(QObject*)xptr;
        case 19: return (void*)(QDBusServer*)(QObject*)xptr;
        case 23: return (void*)(QDBusVirtualObject*)(QObject*)xptr;
        default: return xptr;
      }
    case 34:   //QPoint
      switch(to) {
        case 34: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 35:   //QPointF
      switch(to) {
        case 35: return (void*)(QPointF*)xptr;
        default: return xptr;
      }
    case 36:   //QRect
      switch(to) {
        case 36: return (void*)(QRect*)xptr;
        default: return xptr;
      }
    case 37:   //QRectF
      switch(to) {
        case 37: return (void*)(QRectF*)xptr;
        default: return xptr;
      }
    case 38:   //QRegExp
      switch(to) {
        case 38: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 39:   //QSize
      switch(to) {
        case 39: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 40:   //QSizeF
      switch(to) {
        case 40: return (void*)(QSizeF*)xptr;
        default: return xptr;
      }
    case 41:   //QTime
      switch(to) {
        case 41: return (void*)(QTime*)xptr;
        default: return xptr;
      }
    case 42:   //QTimerEvent
      switch(to) {
        case 27: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 42: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 43:   //QVariant
      switch(to) {
        case 43: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    33, 0,	// 1: QObject
    8, 0,	// 3: QDBusAbstractInterfaceBase
    7, 0,	// 5: QDBusAbstractInterface
    33, 17, 0,	// 7: QObject, QDBusPendingCall
};

// These are the xenum functions for manipulating enum pointers
void xenum_QDBusConnection(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QDBusConnectionInterface(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QDBus(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QDBusArgument(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QDBusServiceWatcher(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QDBusError(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QDBusMessage(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QDBus(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusAbstractAdaptor(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusAbstractInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusAbstractInterfaceBase(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusArgument(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusConnection(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusConnectionInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusContext(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusError(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusMessage(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusMetaType(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusPendingCall(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusPendingCallWatcher(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusServer(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusServiceWatcher(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusUnixFileDescriptor(Smoke::Index, void*, Smoke::Stack);
void xcall_QDBusVirtualObject(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "DBusError", true, 0, 0, 0, 0, 0 },	//1
    { "QBool", true, 0, 0, 0, 0, 0 },	//2
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//3
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//4
    { "QDBus", false, 0, xcall_QDBus, xenum_QDBus, Smoke::cf_namespace, 0 },	//5
    { "QDBusAbstractAdaptor", false, 1, xcall_QDBusAbstractAdaptor, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QDBusAbstractAdaptor) },	//6
    { "QDBusAbstractInterface", false, 3, xcall_QDBusAbstractInterface, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QDBusAbstractInterface) },	//7
    { "QDBusAbstractInterfaceBase", false, 1, xcall_QDBusAbstractInterfaceBase, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QDBusAbstractInterfaceBase) },	//8
    { "QDBusArgument", false, 0, xcall_QDBusArgument, xenum_QDBusArgument, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDBusArgument) },	//9
    { "QDBusConnection", false, 0, xcall_QDBusConnection, xenum_QDBusConnection, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDBusConnection) },	//10
    { "QDBusConnectionInterface", false, 5, xcall_QDBusConnectionInterface, xenum_QDBusConnectionInterface, Smoke::cf_virtual, sizeof(QDBusConnectionInterface) },	//11
    { "QDBusContext", false, 0, xcall_QDBusContext, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDBusContext) },	//12
    { "QDBusError", false, 0, xcall_QDBusError, xenum_QDBusError, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDBusError) },	//13
    { "QDBusInterface", false, 5, xcall_QDBusInterface, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QDBusInterface) },	//14
    { "QDBusMessage", false, 0, xcall_QDBusMessage, xenum_QDBusMessage, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDBusMessage) },	//15
    { "QDBusMetaType", false, 0, xcall_QDBusMetaType, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDBusMetaType) },	//16
    { "QDBusPendingCall", false, 0, xcall_QDBusPendingCall, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDBusPendingCall) },	//17
    { "QDBusPendingCallWatcher", false, 7, xcall_QDBusPendingCallWatcher, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QDBusPendingCallWatcher) },	//18
    { "QDBusServer", false, 1, xcall_QDBusServer, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QDBusServer) },	//19
    { "QDBusServiceWatcher", false, 1, xcall_QDBusServiceWatcher, xenum_QDBusServiceWatcher, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QDBusServiceWatcher) },	//20
    { "QDBusUnixFileDescriptor", false, 0, xcall_QDBusUnixFileDescriptor, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDBusUnixFileDescriptor) },	//21
    { "QDBusVariant", true, 0, 0, 0, 0, 0 },	//22
    { "QDBusVirtualObject", false, 1, xcall_QDBusVirtualObject, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QDBusVirtualObject) },	//23
    { "QDate", true, 0, 0, 0, 0, 0 },	//24
    { "QDateTime", true, 0, 0, 0, 0, 0 },	//25
    { "QDebug", true, 0, 0, 0, 0, 0 },	//26
    { "QEvent", true, 0, 0, 0, 0, 0 },	//27
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//28
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//29
    { "QLine", true, 0, 0, 0, 0, 0 },	//30
    { "QLineF", true, 0, 0, 0, 0, 0 },	//31
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//32
    { "QObject", true, 0, 0, 0, 0, 0 },	//33
    { "QPoint", true, 0, 0, 0, 0, 0 },	//34
    { "QPointF", true, 0, 0, 0, 0, 0 },	//35
    { "QRect", true, 0, 0, 0, 0, 0 },	//36
    { "QRectF", true, 0, 0, 0, 0, 0 },	//37
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//38
    { "QSize", true, 0, 0, 0, 0, 0 },	//39
    { "QSizeF", true, 0, 0, 0, 0, 0 },	//40
    { "QTime", true, 0, 0, 0, 0, 0 },	//41
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//42
    { "QVariant", true, 0, 0, 0, 0, 0 },	//43
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QBool", 2, Smoke::t_class|Smoke::tf_stack },	//1
    { "QByteArray", 3, Smoke::t_class|Smoke::tf_stack },	//2
    { "QByteArray&", 3, Smoke::t_class|Smoke::tf_ref },	//3
    { "QChildEvent*", 4, Smoke::t_class|Smoke::tf_ptr },	//4
    { "QDBus::CallMode", 5, Smoke::t_enum|Smoke::tf_stack },	//5
    { "QDBusAbstractAdaptor*", 6, Smoke::t_class|Smoke::tf_ptr },	//6
    { "QDBusAbstractInterface*", 7, Smoke::t_class|Smoke::tf_ptr },	//7
    { "QDBusArgument&", 9, Smoke::t_class|Smoke::tf_ref },	//8
    { "QDBusArgument*", 9, Smoke::t_class|Smoke::tf_ptr },	//9
    { "QDBusArgument::ElementType", 9, Smoke::t_enum|Smoke::tf_stack },	//10
    { "QDBusConnection", 10, Smoke::t_class|Smoke::tf_stack },	//11
    { "QDBusConnection&", 10, Smoke::t_class|Smoke::tf_ref },	//12
    { "QDBusConnection*", 10, Smoke::t_class|Smoke::tf_ptr },	//13
    { "QDBusConnection::BusType", 10, Smoke::t_enum|Smoke::tf_stack },	//14
    { "QDBusConnection::ConnectionCapability", 10, Smoke::t_enum|Smoke::tf_stack },	//15
    { "QDBusConnection::RegisterOption", 10, Smoke::t_enum|Smoke::tf_stack },	//16
    { "QDBusConnection::UnregisterMode", 10, Smoke::t_enum|Smoke::tf_stack },	//17
    { "QDBusConnection::VirtualObjectRegisterOption", 10, Smoke::t_enum|Smoke::tf_stack },	//18
    { "QDBusConnectionInterface*", 11, Smoke::t_class|Smoke::tf_ptr },	//19
    { "QDBusConnectionInterface::RegisterServiceReply", 11, Smoke::t_enum|Smoke::tf_stack },	//20
    { "QDBusConnectionInterface::ServiceQueueOptions", 11, Smoke::t_enum|Smoke::tf_stack },	//21
    { "QDBusConnectionInterface::ServiceReplacementOptions", 11, Smoke::t_enum|Smoke::tf_stack },	//22
    { "QDBusContext*", 12, Smoke::t_class|Smoke::tf_ptr },	//23
    { "QDBusError", 13, Smoke::t_class|Smoke::tf_stack },	//24
    { "QDBusError&", 13, Smoke::t_class|Smoke::tf_ref },	//25
    { "QDBusError*", 13, Smoke::t_class|Smoke::tf_ptr },	//26
    { "QDBusError::ErrorType", 13, Smoke::t_enum|Smoke::tf_stack },	//27
    { "QDBusInterface*", 14, Smoke::t_class|Smoke::tf_ptr },	//28
    { "QDBusMessage", 15, Smoke::t_class|Smoke::tf_stack },	//29
    { "QDBusMessage&", 15, Smoke::t_class|Smoke::tf_ref },	//30
    { "QDBusMessage*", 15, Smoke::t_class|Smoke::tf_ptr },	//31
    { "QDBusMessage::MessageType", 15, Smoke::t_enum|Smoke::tf_stack },	//32
    { "QDBusMetaType*", 16, Smoke::t_class|Smoke::tf_ptr },	//33
    { "QDBusObjectPath&", 0, Smoke::t_voidp|Smoke::tf_ref },	//34
    { "QDBusPendingCall", 17, Smoke::t_class|Smoke::tf_stack },	//35
    { "QDBusPendingCall&", 17, Smoke::t_class|Smoke::tf_ref },	//36
    { "QDBusPendingCall*", 17, Smoke::t_class|Smoke::tf_ptr },	//37
    { "QDBusPendingCallWatcher*", 18, Smoke::t_class|Smoke::tf_ptr },	//38
    { "QDBusReply<QDBusConnectionInterface::RegisterServiceReply>", 0, Smoke::t_voidp|Smoke::tf_stack },	//39
    { "QDBusReply<QString>", 0, Smoke::t_voidp|Smoke::tf_stack },	//40
    { "QDBusReply<QStringList>", 0, Smoke::t_voidp|Smoke::tf_stack },	//41
    { "QDBusReply<bool>", 0, Smoke::t_voidp|Smoke::tf_stack },	//42
    { "QDBusReply<uint>", 0, Smoke::t_voidp|Smoke::tf_stack },	//43
    { "QDBusReply<void>", 0, Smoke::t_voidp|Smoke::tf_stack },	//44
    { "QDBusServer*", 19, Smoke::t_class|Smoke::tf_ptr },	//45
    { "QDBusServiceWatcher*", 20, Smoke::t_class|Smoke::tf_ptr },	//46
    { "QDBusServiceWatcher::WatchModeFlag", 20, Smoke::t_enum|Smoke::tf_stack },	//47
    { "QDBusSignature&", 0, Smoke::t_voidp|Smoke::tf_ref },	//48
    { "QDBusUnixFileDescriptor&", 21, Smoke::t_class|Smoke::tf_ref },	//49
    { "QDBusUnixFileDescriptor*", 21, Smoke::t_class|Smoke::tf_ptr },	//50
    { "QDBusVariant&", 22, Smoke::t_class|Smoke::tf_ref },	//51
    { "QDBusVirtualObject*", 23, Smoke::t_class|Smoke::tf_ptr },	//52
    { "QDate&", 24, Smoke::t_class|Smoke::tf_ref },	//53
    { "QDateTime&", 25, Smoke::t_class|Smoke::tf_ref },	//54
    { "QDebug", 26, Smoke::t_class|Smoke::tf_stack },	//55
    { "QEvent*", 27, Smoke::t_class|Smoke::tf_ptr },	//56
    { "QFlags<QDBusConnection::ConnectionCapability>", 0, Smoke::t_uint|Smoke::tf_stack },	//57
    { "QFlags<QDBusConnection::RegisterOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//58
    { "QFlags<QDBusConnection::VirtualObjectRegisterOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//59
    { "QFlags<QDBusServiceWatcher::WatchModeFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//60
    { "QIncompatibleFlag", 29, Smoke::t_class|Smoke::tf_stack },	//61
    { "QLine&", 30, Smoke::t_class|Smoke::tf_ref },	//62
    { "QLineF&", 31, Smoke::t_class|Smoke::tf_ref },	//63
    { "QList<QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack },	//64
    { "QMetaObject::Call", 32, Smoke::t_enum|Smoke::tf_stack },	//65
    { "QObject*", 33, Smoke::t_class|Smoke::tf_ptr },	//66
    { "QPoint&", 34, Smoke::t_class|Smoke::tf_ref },	//67
    { "QPointF&", 35, Smoke::t_class|Smoke::tf_ref },	//68
    { "QRect&", 36, Smoke::t_class|Smoke::tf_ref },	//69
    { "QRectF&", 37, Smoke::t_class|Smoke::tf_ref },	//70
    { "QRegExp&", 38, Smoke::t_class|Smoke::tf_ref },	//71
    { "QSize&", 39, Smoke::t_class|Smoke::tf_ref },	//72
    { "QSizeF&", 40, Smoke::t_class|Smoke::tf_ref },	//73
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//74
    { "QString&", 0, Smoke::t_voidp|Smoke::tf_ref },	//75
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//76
    { "QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref },	//77
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//78
    { "QTime&", 41, Smoke::t_class|Smoke::tf_ref },	//79
    { "QTimerEvent*", 42, Smoke::t_class|Smoke::tf_ptr },	//80
    { "QVariant", 43, Smoke::t_class|Smoke::tf_stack },	//81
    { "QVariant&", 43, Smoke::t_class|Smoke::tf_ref },	//82
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//83
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//84
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//85
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//86
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//87
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//88
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//89
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//90
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//91
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//92
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//93
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//94
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//95
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//96
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//97
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//98
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//99
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//100
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//101
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//102
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//103
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//104
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//105
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//106
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//107
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//108
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//109
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//110
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//111
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//112
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//113
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//114
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//115
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//116
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//117
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//118
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//119
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//120
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//121
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//122
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//123
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//124
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//125
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//126
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//127
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//128
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//129
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//130
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//131
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//132
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//133
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//134
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//135
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//136
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//137
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//138
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//139
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//140
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//141
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//142
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//143
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//144
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//145
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//146
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//147
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//148
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//149
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//150
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//151
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//152
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//153
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//154
    { "QtConcurrent::ReduceOption", 0, Smoke::t_enum|Smoke::tf_stack },	//155
    { "QtConcurrent::ThreadFunctionResult", 0, Smoke::t_enum|Smoke::tf_stack },	//156
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//157
    { "bool&", 0, Smoke::t_voidp|Smoke::tf_ref },	//158
    { "const DBusError*", 1, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//159
    { "const QByteArray&", 3, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//160
    { "const QDBusArgument&", 9, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//161
    { "const QDBusConnection&", 10, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//162
    { "const QDBusContext&", 12, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//163
    { "const QDBusError&", 13, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//164
    { "const QDBusMessage&", 15, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//165
    { "const QDBusMetaType&", 16, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//166
    { "const QDBusObjectPath&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//167
    { "const QDBusPendingCall&", 17, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//168
    { "const QDBusSignature&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//169
    { "const QDBusUnixFileDescriptor&", 21, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//170
    { "const QDBusVariant&", 22, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//171
    { "const QDate&", 24, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//172
    { "const QDateTime&", 25, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//173
    { "const QHash<QString,QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//174
    { "const QLine&", 30, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//175
    { "const QLineF&", 31, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//176
    { "const QList<QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//177
    { "const QMap<QString,QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//178
    { "const QMetaObject&", 32, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//179
    { "const QMetaObject*", 32, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//180
    { "const QPoint&", 34, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//181
    { "const QPointF&", 35, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//182
    { "const QRect&", 36, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//183
    { "const QRectF&", 37, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//184
    { "const QRegExp&", 38, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//185
    { "const QSize&", 39, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//186
    { "const QSizeF&", 40, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//187
    { "const QString", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//188
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//189
    { "const QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//190
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//191
    { "const QTime&", 41, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//192
    { "const QVariant&", 43, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//193
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//194
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//195
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//196
    { "double&", 0, Smoke::t_voidp|Smoke::tf_ref },	//197
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//198
    { "int&", 0, Smoke::t_voidp|Smoke::tf_ref },	//199
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//200
    { "long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//201
    { "long long&", 0, Smoke::t_voidp|Smoke::tf_ref },	//202
    { "short", 0, Smoke::t_short|Smoke::tf_stack },	//203
    { "short&", 0, Smoke::t_voidp|Smoke::tf_ref },	//204
    { "uint", 0, Smoke::t_uint|Smoke::tf_stack },	//205
    { "unsigned char", 0, Smoke::t_uchar|Smoke::tf_stack },	//206
    { "unsigned char&", 0, Smoke::t_voidp|Smoke::tf_ref },	//207
    { "unsigned int", 0, Smoke::t_uint|Smoke::tf_stack },	//208
    { "unsigned int&", 0, Smoke::t_voidp|Smoke::tf_ref },	//209
    { "unsigned long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//210
    { "unsigned long long&", 0, Smoke::t_voidp|Smoke::tf_ref },	//211
    { "unsigned short", 0, Smoke::t_ushort|Smoke::tf_stack },	//212
    { "unsigned short&", 0, Smoke::t_voidp|Smoke::tf_ref },	//213
    { "void(*)(QDBusArgument&,const void*)", 0, Smoke::t_voidp|Smoke::tf_stack },	//214
    { "void(*)(const QDBusArgument&,void*)", 0, Smoke::t_voidp|Smoke::tf_stack },	//215
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//216
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//217
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//218
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    194, 0,	//1  const char*
    194, 194, 0,	//3  const char*, const char*
    194, 194, 198, 0,	//6  const char*, const char*, int
    65, 198, 217, 0,	//10  QMetaObject::Call, int, void**
    66, 0,	//14  QObject*
    157, 0,	//16  bool
    198, 0,	//18  int
    189, 193, 193, 193, 193, 193, 193, 193, 193, 0,	//20  const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&
    5, 189, 193, 193, 193, 193, 193, 193, 193, 193, 0,	//30  QDBus::CallMode, const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&
    5, 189, 177, 0,	//41  QDBus::CallMode, const QString&, const QList<QVariant>&
    189, 177, 66, 194, 194, 0,	//45  const QString&, const QList<QVariant>&, QObject*, const char*, const char*
    189, 177, 66, 194, 0,	//51  const QString&, const QList<QVariant>&, QObject*, const char*
    189, 177, 0,	//56  const QString&, const QList<QVariant>&
    189, 189, 194, 162, 66, 0,	//59  const QString&, const QString&, const char*, const QDBusConnection&, QObject*
    194, 193, 0,	//65  const char*, const QVariant&
    189, 0,	//68  const QString&
    189, 193, 0,	//70  const QString&, const QVariant&
    189, 193, 193, 0,	//73  const QString&, const QVariant&, const QVariant&
    189, 193, 193, 193, 0,	//77  const QString&, const QVariant&, const QVariant&, const QVariant&
    189, 193, 193, 193, 193, 0,	//82  const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&
    189, 193, 193, 193, 193, 193, 0,	//88  const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&
    189, 193, 193, 193, 193, 193, 193, 0,	//95  const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&
    189, 193, 193, 193, 193, 193, 193, 193, 0,	//103  const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&
    5, 189, 0,	//112  QDBus::CallMode, const QString&
    5, 189, 193, 0,	//115  QDBus::CallMode, const QString&, const QVariant&
    5, 189, 193, 193, 0,	//119  QDBus::CallMode, const QString&, const QVariant&, const QVariant&
    5, 189, 193, 193, 193, 0,	//124  QDBus::CallMode, const QString&, const QVariant&, const QVariant&, const QVariant&
    5, 189, 193, 193, 193, 193, 0,	//130  QDBus::CallMode, const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&
    5, 189, 193, 193, 193, 193, 193, 0,	//137  QDBus::CallMode, const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&
    5, 189, 193, 193, 193, 193, 193, 193, 0,	//145  QDBus::CallMode, const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&
    5, 189, 193, 193, 193, 193, 193, 193, 193, 0,	//154  QDBus::CallMode, const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&
    161, 0,	//164  const QDBusArgument&
    206, 0,	//166  unsigned char
    203, 0,	//168  short
    212, 0,	//170  unsigned short
    208, 0,	//172  unsigned int
    201, 0,	//174  long long
    210, 0,	//176  unsigned long long
    196, 0,	//178  double
    171, 0,	//180  const QDBusVariant&
    167, 0,	//182  const QDBusObjectPath&
    169, 0,	//184  const QDBusSignature&
    170, 0,	//186  const QDBusUnixFileDescriptor&
    190, 0,	//188  const QStringList&
    160, 0,	//190  const QByteArray&
    198, 198, 0,	//192  int, int
    193, 0,	//195  const QVariant&
    207, 0,	//197  unsigned char&
    158, 0,	//199  bool&
    204, 0,	//201  short&
    213, 0,	//203  unsigned short&
    199, 0,	//205  int&
    209, 0,	//207  unsigned int&
    202, 0,	//209  long long&
    211, 0,	//211  unsigned long long&
    197, 0,	//213  double&
    75, 0,	//215  QString&
    51, 0,	//217  QDBusVariant&
    34, 0,	//219  QDBusObjectPath&
    48, 0,	//221  QDBusSignature&
    49, 0,	//223  QDBusUnixFileDescriptor&
    77, 0,	//225  QStringList&
    3, 0,	//227  QByteArray&
    162, 0,	//229  const QDBusConnection&
    165, 0,	//231  const QDBusMessage&
    165, 66, 194, 194, 198, 0,	//233  const QDBusMessage&, QObject*, const char*, const char*, int
    165, 66, 194, 198, 0,	//239  const QDBusMessage&, QObject*, const char*, int
    165, 5, 198, 0,	//244  const QDBusMessage&, QDBus::CallMode, int
    165, 198, 0,	//248  const QDBusMessage&, int
    189, 189, 189, 189, 66, 194, 0,	//251  const QString&, const QString&, const QString&, const QString&, QObject*, const char*
    189, 189, 189, 189, 189, 66, 194, 0,	//258  const QString&, const QString&, const QString&, const QString&, const QString&, QObject*, const char*
    189, 189, 189, 189, 190, 189, 66, 194, 0,	//266  const QString&, const QString&, const QString&, const QString&, const QStringList&, const QString&, QObject*, const char*
    189, 66, 58, 0,	//275  const QString&, QObject*, QFlags<QDBusConnection::RegisterOption>
    189, 17, 0,	//279  const QString&, QDBusConnection::UnregisterMode
    189, 52, 18, 0,	//282  const QString&, QDBusVirtualObject*, QDBusConnection::VirtualObjectRegisterOption
    14, 189, 0,	//286  QDBusConnection::BusType, const QString&
    189, 189, 0,	//289  const QString&, const QString&
    165, 66, 194, 194, 0,	//292  const QDBusMessage&, QObject*, const char*, const char*
    165, 66, 194, 0,	//297  const QDBusMessage&, QObject*, const char*
    165, 5, 0,	//301  const QDBusMessage&, QDBus::CallMode
    189, 66, 0,	//304  const QString&, QObject*
    189, 52, 0,	//307  const QString&, QDBusVirtualObject*
    189, 21, 22, 0,	//310  const QString&, QDBusConnectionInterface::ServiceQueueOptions, QDBusConnectionInterface::ServiceReplacementOptions
    189, 189, 189, 0,	//314  const QString&, const QString&, const QString&
    164, 165, 0,	//318  const QDBusError&, const QDBusMessage&
    189, 21, 0,	//321  const QString&, QDBusConnectionInterface::ServiceQueueOptions
    27, 189, 0,	//324  QDBusError::ErrorType, const QString&
    163, 0,	//327  const QDBusContext&
    27, 0,	//329  QDBusError::ErrorType
    159, 0,	//331  const DBusError*
    164, 0,	//333  const QDBusError&
    189, 189, 189, 162, 66, 0,	//335  const QString&, const QString&, const QString&, const QDBusConnection&, QObject*
    189, 189, 189, 162, 0,	//341  const QString&, const QString&, const QString&, const QDBusConnection&
    189, 189, 189, 189, 0,	//346  const QString&, const QString&, const QString&, const QString&
    177, 0,	//351  const QList<QVariant>&
    188, 189, 0,	//353  const QString, const QString&
    198, 214, 215, 0,	//356  int, void(*)(QDBusArgument&,const void*), void(*)(const QDBusArgument&,void*)
    8, 198, 195, 0,	//360  QDBusArgument&, int, const void*
    161, 198, 216, 0,	//364  const QDBusArgument&, int, void*
    166, 0,	//368  const QDBusMetaType&
    168, 0,	//370  const QDBusPendingCall&
    168, 66, 0,	//372  const QDBusPendingCall&, QObject*
    38, 0,	//375  QDBusPendingCallWatcher*
    189, 162, 60, 66, 0,	//377  const QString&, const QDBusConnection&, QFlags<QDBusServiceWatcher::WatchModeFlag>, QObject*
    60, 0,	//382  QFlags<QDBusServiceWatcher::WatchModeFlag>
    189, 162, 0,	//384  const QString&, const QDBusConnection&
    189, 162, 60, 0,	//387  const QString&, const QDBusConnection&, QFlags<QDBusServiceWatcher::WatchModeFlag>
    165, 162, 0,	//391  const QDBusMessage&, const QDBusConnection&
    8, 182, 0,	//394  QDBusArgument&, const QPointF&
    8, 176, 0,	//397  QDBusArgument&, const QLineF&
    8, 173, 0,	//400  QDBusArgument&, const QDateTime&
    8, 184, 0,	//403  QDBusArgument&, const QRectF&
    47, 47, 0,	//406  QDBusServiceWatcher::WatchModeFlag, QDBusServiceWatcher::WatchModeFlag
    8, 178, 0,	//409  QDBusArgument&, const QMap<QString,QVariant>&
    169, 169, 0,	//412  const QDBusSignature&, const QDBusSignature&
    18, 59, 0,	//415  QDBusConnection::VirtualObjectRegisterOption, QFlags<QDBusConnection::VirtualObjectRegisterOption>
    161, 79, 0,	//418  const QDBusArgument&, QTime&
    8, 186, 0,	//421  QDBusArgument&, const QSize&
    18, 18, 0,	//424  QDBusConnection::VirtualObjectRegisterOption, QDBusConnection::VirtualObjectRegisterOption
    161, 54, 0,	//427  const QDBusArgument&, QDateTime&
    161, 62, 0,	//430  const QDBusArgument&, QLine&
    16, 16, 0,	//433  QDBusConnection::RegisterOption, QDBusConnection::RegisterOption
    167, 167, 0,	//436  const QDBusObjectPath&, const QDBusObjectPath&
    161, 69, 0,	//439  const QDBusArgument&, QRect&
    161, 70, 0,	//442  const QDBusArgument&, QRectF&
    18, 198, 0,	//445  QDBusConnection::VirtualObjectRegisterOption, int
    165, 25, 82, 0,	//448  const QDBusMessage&, QDBusError&, QVariant&
    161, 73, 0,	//452  const QDBusArgument&, QSizeF&
    161, 63, 0,	//455  const QDBusArgument&, QLineF&
    16, 198, 0,	//458  QDBusConnection::RegisterOption, int
    55, 165, 0,	//461  QDebug, const QDBusMessage&
    47, 60, 0,	//464  QDBusServiceWatcher::WatchModeFlag, QFlags<QDBusServiceWatcher::WatchModeFlag>
    161, 82, 0,	//467  const QDBusArgument&, QVariant&
    161, 68, 0,	//470  const QDBusArgument&, QPointF&
    16, 58, 0,	//473  QDBusConnection::RegisterOption, QFlags<QDBusConnection::RegisterOption>
    8, 181, 0,	//476  QDBusArgument&, const QPoint&
    161, 67, 0,	//479  const QDBusArgument&, QPoint&
    8, 192, 0,	//482  QDBusArgument&, const QTime&
    8, 183, 0,	//485  QDBusArgument&, const QRect&
    161, 72, 0,	//488  const QDBusArgument&, QSize&
    161, 53, 0,	//491  const QDBusArgument&, QDate&
    8, 172, 0,	//494  QDBusArgument&, const QDate&
    8, 177, 0,	//497  QDBusArgument&, const QList<QVariant>&
    8, 174, 0,	//500  QDBusArgument&, const QHash<QString,QVariant>&
    55, 164, 0,	//503  QDebug, const QDBusError&
    171, 171, 0,	//506  const QDBusVariant&, const QDBusVariant&
    8, 187, 0,	//509  QDBusArgument&, const QSizeF&
    47, 198, 0,	//512  QDBusServiceWatcher::WatchModeFlag, int
    8, 175, 0,	//515  QDBusArgument&, const QLine&
    56, 0,	//518  QEvent*
    66, 56, 0,	//520  QObject*, QEvent*
    80, 0,	//523  QTimerEvent*
    4, 0,	//525  QChildEvent*
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "AccessDenied",	//1
    "ActivationBus",	//2
    "AddressInUse",	//3
    "AllowReplacement",	//4
    "ArrayType",	//5
    "AutoDetect",	//6
    "BadAddress",	//7
    "BasicType",	//8
    "Block",	//9
    "BlockWithGui",	//10
    "Disconnected",	//11
    "DontAllowReplacement",	//12
    "DontQueueService",	//13
    "ErrorMessage",	//14
    "ExportAdaptors",	//15
    "ExportAllContents",	//16
    "ExportAllInvokables",	//17
    "ExportAllProperties",	//18
    "ExportAllSignal",	//19
    "ExportAllSignals",	//20
    "ExportAllSlots",	//21
    "ExportChildObjects",	//22
    "ExportNonScriptableContents",	//23
    "ExportNonScriptableInvokables",	//24
    "ExportNonScriptableProperties",	//25
    "ExportNonScriptableSignals",	//26
    "ExportNonScriptableSlots",	//27
    "ExportScriptableContents",	//28
    "ExportScriptableInvokables",	//29
    "ExportScriptableProperties",	//30
    "ExportScriptableSignals",	//31
    "ExportScriptableSlots",	//32
    "Failed",	//33
    "InternalError",	//34
    "InvalidArgs",	//35
    "InvalidInterface",	//36
    "InvalidMember",	//37
    "InvalidMessage",	//38
    "InvalidObjectPath",	//39
    "InvalidService",	//40
    "InvalidSignature",	//41
    "LastErrorType",	//42
    "LimitsExceeded",	//43
    "MapEntryType",	//44
    "MapType",	//45
    "MethodCallMessage",	//46
    "NameAcquired",	//47
    "NameAcquired$",	//48
    "NameLost",	//49
    "NameLost$",	//50
    "NameOwnerChanged",	//51
    "NameOwnerChanged$$$",	//52
    "NoBlock",	//53
    "NoError",	//54
    "NoMemory",	//55
    "NoNetwork",	//56
    "NoReply",	//57
    "NoServer",	//58
    "NotSupported",	//59
    "Other",	//60
    "QDBusAbstractAdaptor",	//61
    "QDBusAbstractAdaptor#",	//62
    "QDBusAbstractInterface",	//63
    "QDBusAbstractInterface$$$##",	//64
    "QDBusArgument",	//65
    "QDBusArgument#",	//66
    "QDBusConnection",	//67
    "QDBusConnection#",	//68
    "QDBusConnection$",	//69
    "QDBusContext",	//70
    "QDBusContext#",	//71
    "QDBusError",	//72
    "QDBusError#",	//73
    "QDBusError$$",	//74
    "QDBusInterface",	//75
    "QDBusInterface$$",	//76
    "QDBusInterface$$$",	//77
    "QDBusInterface$$$#",	//78
    "QDBusInterface$$$##",	//79
    "QDBusMessage",	//80
    "QDBusMessage#",	//81
    "QDBusMetaType",	//82
    "QDBusMetaType#",	//83
    "QDBusPendingCall",	//84
    "QDBusPendingCall#",	//85
    "QDBusPendingCallWatcher",	//86
    "QDBusPendingCallWatcher#",	//87
    "QDBusPendingCallWatcher##",	//88
    "QDBusServer",	//89
    "QDBusServer$",	//90
    "QDBusServer$#",	//91
    "QDBusServiceWatcher",	//92
    "QDBusServiceWatcher#",	//93
    "QDBusServiceWatcher$#",	//94
    "QDBusServiceWatcher$#$",	//95
    "QDBusServiceWatcher$#$#",	//96
    "QDBusUnixFileDescriptor",	//97
    "QDBusUnixFileDescriptor#",	//98
    "QDBusUnixFileDescriptor$",	//99
    "QDBusVirtualObject",	//100
    "QDBusVirtualObject#",	//101
    "QueueService",	//102
    "ReplaceExistingService",	//103
    "ReplyMessage",	//104
    "ServiceNotRegistered",	//105
    "ServiceQueued",	//106
    "ServiceRegistered",	//107
    "ServiceUnknown",	//108
    "SessionBus",	//109
    "SignalMessage",	//110
    "SingleNode",	//111
    "StructureType",	//112
    "SubPath",	//113
    "SystemBus",	//114
    "TimedOut",	//115
    "Timeout",	//116
    "UnixFileDescriptorPassing",	//117
    "UnknownInterface",	//118
    "UnknownMethod",	//119
    "UnknownObject",	//120
    "UnknownType",	//121
    "UnregisterNode",	//122
    "UnregisterTree",	//123
    "VariantType",	//124
    "WatchForOwnerChange",	//125
    "WatchForRegistration",	//126
    "WatchForUnregistration",	//127
    "addWatchedService",	//128
    "addWatchedService$",	//129
    "address",	//130
    "appendVariant",	//131
    "appendVariant#",	//132
    "arguments",	//133
    "asVariant",	//134
    "asyncCall",	//135
    "asyncCall#",	//136
    "asyncCall#$",	//137
    "asyncCall$",	//138
    "asyncCall$#",	//139
    "asyncCall$##",	//140
    "asyncCall$###",	//141
    "asyncCall$####",	//142
    "asyncCall$#####",	//143
    "asyncCall$######",	//144
    "asyncCall$#######",	//145
    "asyncCall$########",	//146
    "asyncCallWithArgumentList",	//147
    "asyncCallWithArgumentList$?",	//148
    "atEnd",	//149
    "autoRelaySignals",	//150
    "autoStartService",	//151
    "baseService",	//152
    "beginArray",	//153
    "beginArray$",	//154
    "beginMap",	//155
    "beginMap$$",	//156
    "beginMapEntry",	//157
    "beginStructure",	//158
    "call",	//159
    "call#",	//160
    "call#$",	//161
    "call#$$",	//162
    "call$",	//163
    "call$#",	//164
    "call$##",	//165
    "call$###",	//166
    "call$####",	//167
    "call$#####",	//168
    "call$######",	//169
    "call$#######",	//170
    "call$########",	//171
    "call$$",	//172
    "call$$#",	//173
    "call$$##",	//174
    "call$$###",	//175
    "call$$####",	//176
    "call$$#####",	//177
    "call$$######",	//178
    "call$$#######",	//179
    "call$$########",	//180
    "callWithArgumentList",	//181
    "callWithArgumentList$$?",	//182
    "callWithCallback",	//183
    "callWithCallback##$",	//184
    "callWithCallback##$$",	//185
    "callWithCallback##$$$",	//186
    "callWithCallback$?#$",	//187
    "callWithCallback$?#$$",	//188
    "callWithCallbackFailed",	//189
    "callWithCallbackFailed##",	//190
    "calledFromDBus",	//191
    "childEvent",	//192
    "connect",	//193
    "connect$$$$#$",	//194
    "connect$$$$$#$",	//195
    "connect$$$$?$#$",	//196
    "connectNotify",	//197
    "connectNotify$",	//198
    "connectToBus",	//199
    "connectToBus$$",	//200
    "connectToPeer",	//201
    "connectToPeer$$",	//202
    "connection",	//203
    "connectionCapabilities",	//204
    "createError",	//205
    "createError#",	//206
    "createError$$",	//207
    "createErrorReply",	//208
    "createErrorReply#",	//209
    "createErrorReply$$",	//210
    "createMethodCall",	//211
    "createMethodCall$$$$",	//212
    "createReply",	//213
    "createReply#",	//214
    "createReply?",	//215
    "createSignal",	//216
    "createSignal$$$",	//217
    "currentSignature",	//218
    "currentType",	//219
    "customEvent",	//220
    "demarshall",	//221
    "demarshall#$$",	//222
    "disconnect",	//223
    "disconnect$$$$#$",	//224
    "disconnect$$$$$#$",	//225
    "disconnect$$$$?$#$",	//226
    "disconnectFromBus",	//227
    "disconnectFromBus$",	//228
    "disconnectFromPeer",	//229
    "disconnectFromPeer$",	//230
    "disconnectNotify",	//231
    "disconnectNotify$",	//232
    "endArray",	//233
    "endMap",	//234
    "endMapEntry",	//235
    "endStructure",	//236
    "error",	//237
    "errorMessage",	//238
    "errorName",	//239
    "errorString",	//240
    "errorString$",	//241
    "event",	//242
    "eventFilter",	//243
    "fileDescriptor",	//244
    "finished",	//245
    "finished#",	//246
    "fromCompletedCall",	//247
    "fromCompletedCall#",	//248
    "fromError",	//249
    "fromError#",	//250
    "giveFileDescriptor",	//251
    "giveFileDescriptor$",	//252
    "handleMessage",	//253
    "handleMessage##",	//254
    "interface",	//255
    "internalConstCall",	//256
    "internalConstCall$$",	//257
    "internalConstCall$$?",	//258
    "internalPointer",	//259
    "internalPropGet",	//260
    "internalPropGet$",	//261
    "internalPropSet",	//262
    "internalPropSet$#",	//263
    "introspect",	//264
    "introspect$",	//265
    "isConnected",	//266
    "isDelayedReply",	//267
    "isError",	//268
    "isFinished",	//269
    "isReplyRequired",	//270
    "isServiceRegistered",	//271
    "isServiceRegistered$",	//272
    "isSupported",	//273
    "isValid",	//274
    "lastError",	//275
    "localMachineId",	//276
    "marshall",	//277
    "marshall#$$",	//278
    "member",	//279
    "message",	//280
    "metaObject",	//281
    "name",	//282
    "newConnection",	//283
    "newConnection#",	//284
    "objectRegisteredAt",	//285
    "objectRegisteredAt$",	//286
    "operator!=",	//287
    "operator!=$$",	//288
    "operator<",	//289
    "operator<$$",	//290
    "operator<<",	//291
    "operator<<#",	//292
    "operator<<##",	//293
    "operator<<#?",	//294
    "operator<<$",	//295
    "operator<<?",	//296
    "operator=",	//297
    "operator=#",	//298
    "operator==",	//299
    "operator==##",	//300
    "operator==$$",	//301
    "operator>>",	//302
    "operator>>#",	//303
    "operator>>##",	//304
    "operator>>$",	//305
    "operator>>?",	//306
    "operator|",	//307
    "operator|$$",	//308
    "path",	//309
    "qDBusReplyFill",	//310
    "qDBusReplyFill###",	//311
    "qHash",	//312
    "qHash$",	//313
    "qt_metacall",	//314
    "qt_metacall$$?",	//315
    "qt_metacast",	//316
    "qt_metacast$",	//317
    "registerMarshallOperators",	//318
    "registerMarshallOperators$$$",	//319
    "registerObject",	//320
    "registerObject$#",	//321
    "registerObject$#$",	//322
    "registerService",	//323
    "registerService$",	//324
    "registerService$$",	//325
    "registerService$$$",	//326
    "registerVirtualObject",	//327
    "registerVirtualObject$#",	//328
    "registerVirtualObject$#$",	//329
    "registeredServiceNames",	//330
    "removeWatchedService",	//331
    "removeWatchedService$",	//332
    "reply",	//333
    "send",	//334
    "send#",	//335
    "sendErrorReply",	//336
    "sendErrorReply$",	//337
    "sendErrorReply$$",	//338
    "sender",	//339
    "service",	//340
    "serviceOwner",	//341
    "serviceOwner$",	//342
    "serviceOwnerChanged",	//343
    "serviceOwnerChanged$$$",	//344
    "servicePid",	//345
    "servicePid$",	//346
    "serviceRegistered",	//347
    "serviceRegistered$",	//348
    "serviceUid",	//349
    "serviceUid$",	//350
    "serviceUnregistered",	//351
    "serviceUnregistered$",	//352
    "sessionBus",	//353
    "setArguments",	//354
    "setArguments?",	//355
    "setAutoRelaySignals",	//356
    "setAutoRelaySignals$",	//357
    "setAutoStartService",	//358
    "setAutoStartService$",	//359
    "setConnection",	//360
    "setConnection#",	//361
    "setDelayedReply",	//362
    "setDelayedReply$",	//363
    "setFileDescriptor",	//364
    "setFileDescriptor$",	//365
    "setTimeout",	//366
    "setTimeout$",	//367
    "setWatchMode",	//368
    "setWatchMode$",	//369
    "setWatchedServices",	//370
    "setWatchedServices?",	//371
    "signature",	//372
    "signatureToType",	//373
    "signatureToType$",	//374
    "startService",	//375
    "startService$",	//376
    "staticMetaObject",	//377
    "systemBus",	//378
    "takeFileDescriptor",	//379
    "timeout",	//380
    "timerEvent",	//381
    "tr",	//382
    "tr$",	//383
    "tr$$",	//384
    "tr$$$",	//385
    "trUtf8",	//386
    "trUtf8$",	//387
    "trUtf8$$",	//388
    "trUtf8$$$",	//389
    "type",	//390
    "typeToSignature",	//391
    "typeToSignature$",	//392
    "unregisterObject",	//393
    "unregisterObject$",	//394
    "unregisterObject$$",	//395
    "unregisterService",	//396
    "unregisterService$",	//397
    "waitForFinished",	//398
    "watchMode",	//399
    "watchedServices",	//400
    "~QDBusAbstractAdaptor",	//401
    "~QDBusAbstractInterface",	//402
    "~QDBusAbstractInterfaceBase",	//403
    "~QDBusArgument",	//404
    "~QDBusConnection",	//405
    "~QDBusContext",	//406
    "~QDBusError",	//407
    "~QDBusInterface",	//408
    "~QDBusMessage",	//409
    "~QDBusMetaType",	//410
    "~QDBusPendingCall",	//411
    "~QDBusPendingCallWatcher",	//412
    "~QDBusServer",	//413
    "~QDBusServiceWatcher",	//414
    "~QDBusUnixFileDescriptor",	//415
    "~QDBusVirtualObject",	//416
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {5, 53, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 1},	//1 QDBus::NoBlock (enum)
    {5, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 2},	//2 QDBus::Block (enum)
    {5, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 3},	//3 QDBus::BlockWithGui (enum)
    {5, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 4},	//4 QDBus::AutoDetect (enum)
    {6, 281, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 180, 1},	//5 QDBusAbstractAdaptor::metaObject() const
    {6, 316, 1, 1, Smoke::mf_virtual, 216, 2},	//6 QDBusAbstractAdaptor::qt_metacast(const char*)
    {6, 382, 3, 2, Smoke::mf_static, 74, 3},	//7 QDBusAbstractAdaptor::tr(const char*, const char*)
    {6, 386, 3, 2, Smoke::mf_static, 74, 4},	//8 QDBusAbstractAdaptor::trUtf8(const char*, const char*)
    {6, 382, 6, 3, Smoke::mf_static, 74, 5},	//9 QDBusAbstractAdaptor::tr(const char*, const char*, int)
    {6, 386, 6, 3, Smoke::mf_static, 74, 6},	//10 QDBusAbstractAdaptor::trUtf8(const char*, const char*, int)
    {6, 314, 10, 3, Smoke::mf_virtual, 198, 7},	//11 QDBusAbstractAdaptor::qt_metacall(QMetaObject::Call, int, void**)
    {6, 61, 14, 1, Smoke::mf_ctor|Smoke::mf_protected, 6, 8},	//12 QDBusAbstractAdaptor::QDBusAbstractAdaptor(QObject*)
    {6, 356, 16, 1, Smoke::mf_protected, 0, 9},	//13 QDBusAbstractAdaptor::setAutoRelaySignals(bool)
    {6, 150, 0, 0, Smoke::mf_const|Smoke::mf_protected, 157, 10},	//14 QDBusAbstractAdaptor::autoRelaySignals() const
    {6, 382, 1, 1, Smoke::mf_static, 74, 11},	//15 QDBusAbstractAdaptor::tr(const char*)
    {6, 386, 1, 1, Smoke::mf_static, 74, 12},	//16 QDBusAbstractAdaptor::trUtf8(const char*)
    {6, 377, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 179, 13},	//17 QDBusAbstractAdaptor::staticMetaObject() const
    {6, 401, 0, 0, Smoke::mf_dtor, 0, 14 },	//18 QDBusAbstractAdaptor::~QDBusAbstractAdaptor()
    {7, 281, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 180, 1},	//19 QDBusAbstractInterface::metaObject() const
    {7, 316, 1, 1, Smoke::mf_virtual, 216, 2},	//20 QDBusAbstractInterface::qt_metacast(const char*)
    {7, 382, 3, 2, Smoke::mf_static, 74, 3},	//21 QDBusAbstractInterface::tr(const char*, const char*)
    {7, 386, 3, 2, Smoke::mf_static, 74, 4},	//22 QDBusAbstractInterface::trUtf8(const char*, const char*)
    {7, 382, 6, 3, Smoke::mf_static, 74, 5},	//23 QDBusAbstractInterface::tr(const char*, const char*, int)
    {7, 386, 6, 3, Smoke::mf_static, 74, 6},	//24 QDBusAbstractInterface::trUtf8(const char*, const char*, int)
    {7, 314, 10, 3, Smoke::mf_virtual, 198, 7},	//25 QDBusAbstractInterface::qt_metacall(QMetaObject::Call, int, void**)
    {7, 274, 0, 0, Smoke::mf_const, 157, 8},	//26 QDBusAbstractInterface::isValid() const
    {7, 203, 0, 0, Smoke::mf_const, 11, 9},	//27 QDBusAbstractInterface::connection() const
    {7, 340, 0, 0, Smoke::mf_const, 74, 10},	//28 QDBusAbstractInterface::service() const
    {7, 309, 0, 0, Smoke::mf_const, 74, 11},	//29 QDBusAbstractInterface::path() const
    {7, 255, 0, 0, Smoke::mf_const, 74, 12},	//30 QDBusAbstractInterface::interface() const
    {7, 275, 0, 0, Smoke::mf_const, 24, 13},	//31 QDBusAbstractInterface::lastError() const
    {7, 366, 18, 1, 0, 0, 14},	//32 QDBusAbstractInterface::setTimeout(int)
    {7, 380, 0, 0, Smoke::mf_const, 198, 15},	//33 QDBusAbstractInterface::timeout() const
    {7, 159, 20, 9, 0, 29, 16},	//34 QDBusAbstractInterface::call(const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 159, 30, 10, 0, 29, 17},	//35 QDBusAbstractInterface::call(QDBus::CallMode, const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 181, 41, 3, 0, 29, 18},	//36 QDBusAbstractInterface::callWithArgumentList(QDBus::CallMode, const QString&, const QList<QVariant>&)
    {7, 183, 45, 5, 0, 157, 19},	//37 QDBusAbstractInterface::callWithCallback(const QString&, const QList<QVariant>&, QObject*, const char*, const char*)
    {7, 183, 51, 4, 0, 157, 20},	//38 QDBusAbstractInterface::callWithCallback(const QString&, const QList<QVariant>&, QObject*, const char*)
    {7, 135, 20, 9, 0, 35, 21},	//39 QDBusAbstractInterface::asyncCall(const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 147, 56, 2, 0, 35, 22},	//40 QDBusAbstractInterface::asyncCallWithArgumentList(const QString&, const QList<QVariant>&)
    {7, 63, 59, 5, Smoke::mf_ctor|Smoke::mf_protected, 7, 23},	//41 QDBusAbstractInterface::QDBusAbstractInterface(const QString&, const QString&, const char*, const QDBusConnection&, QObject*)
    {7, 197, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 24},	//42 QDBusAbstractInterface::connectNotify(const char*)
    {7, 231, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 25},	//43 QDBusAbstractInterface::disconnectNotify(const char*)
    {7, 260, 1, 1, Smoke::mf_const|Smoke::mf_protected, 81, 26},	//44 QDBusAbstractInterface::internalPropGet(const char*) const
    {7, 262, 65, 2, Smoke::mf_protected, 0, 27},	//45 QDBusAbstractInterface::internalPropSet(const char*, const QVariant&)
    {7, 256, 41, 3, Smoke::mf_const|Smoke::mf_protected, 29, 28},	//46 QDBusAbstractInterface::internalConstCall(QDBus::CallMode, const QString&, const QList<QVariant>&) const
    {7, 382, 1, 1, Smoke::mf_static, 74, 29},	//47 QDBusAbstractInterface::tr(const char*)
    {7, 386, 1, 1, Smoke::mf_static, 74, 30},	//48 QDBusAbstractInterface::trUtf8(const char*)
    {7, 159, 68, 1, 0, 29, 31},	//49 QDBusAbstractInterface::call(const QString&)
    {7, 159, 70, 2, 0, 29, 32},	//50 QDBusAbstractInterface::call(const QString&, const QVariant&)
    {7, 159, 73, 3, 0, 29, 33},	//51 QDBusAbstractInterface::call(const QString&, const QVariant&, const QVariant&)
    {7, 159, 77, 4, 0, 29, 34},	//52 QDBusAbstractInterface::call(const QString&, const QVariant&, const QVariant&, const QVariant&)
    {7, 159, 82, 5, 0, 29, 35},	//53 QDBusAbstractInterface::call(const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 159, 88, 6, 0, 29, 36},	//54 QDBusAbstractInterface::call(const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 159, 95, 7, 0, 29, 37},	//55 QDBusAbstractInterface::call(const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 159, 103, 8, 0, 29, 38},	//56 QDBusAbstractInterface::call(const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 159, 112, 2, 0, 29, 39},	//57 QDBusAbstractInterface::call(QDBus::CallMode, const QString&)
    {7, 159, 115, 3, 0, 29, 40},	//58 QDBusAbstractInterface::call(QDBus::CallMode, const QString&, const QVariant&)
    {7, 159, 119, 4, 0, 29, 41},	//59 QDBusAbstractInterface::call(QDBus::CallMode, const QString&, const QVariant&, const QVariant&)
    {7, 159, 124, 5, 0, 29, 42},	//60 QDBusAbstractInterface::call(QDBus::CallMode, const QString&, const QVariant&, const QVariant&, const QVariant&)
    {7, 159, 130, 6, 0, 29, 43},	//61 QDBusAbstractInterface::call(QDBus::CallMode, const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 159, 137, 7, 0, 29, 44},	//62 QDBusAbstractInterface::call(QDBus::CallMode, const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 159, 145, 8, 0, 29, 45},	//63 QDBusAbstractInterface::call(QDBus::CallMode, const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 159, 154, 9, 0, 29, 46},	//64 QDBusAbstractInterface::call(QDBus::CallMode, const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 135, 68, 1, 0, 35, 47},	//65 QDBusAbstractInterface::asyncCall(const QString&)
    {7, 135, 70, 2, 0, 35, 48},	//66 QDBusAbstractInterface::asyncCall(const QString&, const QVariant&)
    {7, 135, 73, 3, 0, 35, 49},	//67 QDBusAbstractInterface::asyncCall(const QString&, const QVariant&, const QVariant&)
    {7, 135, 77, 4, 0, 35, 50},	//68 QDBusAbstractInterface::asyncCall(const QString&, const QVariant&, const QVariant&, const QVariant&)
    {7, 135, 82, 5, 0, 35, 51},	//69 QDBusAbstractInterface::asyncCall(const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 135, 88, 6, 0, 35, 52},	//70 QDBusAbstractInterface::asyncCall(const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 135, 95, 7, 0, 35, 53},	//71 QDBusAbstractInterface::asyncCall(const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 135, 103, 8, 0, 35, 54},	//72 QDBusAbstractInterface::asyncCall(const QString&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&, const QVariant&)
    {7, 256, 112, 2, Smoke::mf_const|Smoke::mf_protected, 29, 55},	//73 QDBusAbstractInterface::internalConstCall(QDBus::CallMode, const QString&) const
    {7, 377, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 179, 56},	//74 QDBusAbstractInterface::staticMetaObject() const
    {7, 402, 0, 0, Smoke::mf_dtor, 0, 57 },	//75 QDBusAbstractInterface::~QDBusAbstractInterface()
    {8, 314, 10, 3, Smoke::mf_virtual, 198, 1},	//76 QDBusAbstractInterfaceBase::qt_metacall(QMetaObject::Call, int, void**)
    {8, 403, 0, 0, Smoke::mf_dtor, 0, 2 },	//77 QDBusAbstractInterfaceBase::~QDBusAbstractInterfaceBase()
    {9, 65, 0, 0, Smoke::mf_ctor, 9, 1},	//78 QDBusArgument::QDBusArgument()
    {9, 65, 164, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 9, 2},	//79 QDBusArgument::QDBusArgument(const QDBusArgument&)
    {9, 297, 164, 1, 0, 8, 3},	//80 QDBusArgument::operator=(const QDBusArgument&)
    {9, 291, 166, 1, 0, 8, 4},	//81 QDBusArgument::operator<<(unsigned char)
    {9, 291, 16, 1, 0, 8, 5},	//82 QDBusArgument::operator<<(bool)
    {9, 291, 168, 1, 0, 8, 6},	//83 QDBusArgument::operator<<(short)
    {9, 291, 170, 1, 0, 8, 7},	//84 QDBusArgument::operator<<(unsigned short)
    {9, 291, 18, 1, 0, 8, 8},	//85 QDBusArgument::operator<<(int)
    {9, 291, 172, 1, 0, 8, 9},	//86 QDBusArgument::operator<<(unsigned int)
    {9, 291, 174, 1, 0, 8, 10},	//87 QDBusArgument::operator<<(long long)
    {9, 291, 176, 1, 0, 8, 11},	//88 QDBusArgument::operator<<(unsigned long long)
    {9, 291, 178, 1, 0, 8, 12},	//89 QDBusArgument::operator<<(double)
    {9, 291, 68, 1, 0, 8, 13},	//90 QDBusArgument::operator<<(const QString&)
    {9, 291, 180, 1, 0, 8, 14},	//91 QDBusArgument::operator<<(const QDBusVariant&)
    {9, 291, 182, 1, 0, 8, 15},	//92 QDBusArgument::operator<<(const QDBusObjectPath&)
    {9, 291, 184, 1, 0, 8, 16},	//93 QDBusArgument::operator<<(const QDBusSignature&)
    {9, 291, 186, 1, 0, 8, 17},	//94 QDBusArgument::operator<<(const QDBusUnixFileDescriptor&)
    {9, 291, 188, 1, 0, 8, 18},	//95 QDBusArgument::operator<<(const QStringList&)
    {9, 291, 190, 1, 0, 8, 19},	//96 QDBusArgument::operator<<(const QByteArray&)
    {9, 158, 0, 0, 0, 0, 20},	//97 QDBusArgument::beginStructure()
    {9, 236, 0, 0, 0, 0, 21},	//98 QDBusArgument::endStructure()
    {9, 153, 18, 1, 0, 0, 22},	//99 QDBusArgument::beginArray(int)
    {9, 233, 0, 0, 0, 0, 23},	//100 QDBusArgument::endArray()
    {9, 155, 192, 2, 0, 0, 24},	//101 QDBusArgument::beginMap(int, int)
    {9, 234, 0, 0, 0, 0, 25},	//102 QDBusArgument::endMap()
    {9, 157, 0, 0, 0, 0, 26},	//103 QDBusArgument::beginMapEntry()
    {9, 235, 0, 0, 0, 0, 27},	//104 QDBusArgument::endMapEntry()
    {9, 131, 195, 1, 0, 0, 28},	//105 QDBusArgument::appendVariant(const QVariant&)
    {9, 218, 0, 0, Smoke::mf_const, 74, 29},	//106 QDBusArgument::currentSignature() const
    {9, 219, 0, 0, Smoke::mf_const, 10, 30},	//107 QDBusArgument::currentType() const
    {9, 302, 197, 1, Smoke::mf_const, 161, 31},	//108 QDBusArgument::operator>>(unsigned char&) const
    {9, 302, 199, 1, Smoke::mf_const, 161, 32},	//109 QDBusArgument::operator>>(bool&) const
    {9, 302, 201, 1, Smoke::mf_const, 161, 33},	//110 QDBusArgument::operator>>(short&) const
    {9, 302, 203, 1, Smoke::mf_const, 161, 34},	//111 QDBusArgument::operator>>(unsigned short&) const
    {9, 302, 205, 1, Smoke::mf_const, 161, 35},	//112 QDBusArgument::operator>>(int&) const
    {9, 302, 207, 1, Smoke::mf_const, 161, 36},	//113 QDBusArgument::operator>>(unsigned int&) const
    {9, 302, 209, 1, Smoke::mf_const, 161, 37},	//114 QDBusArgument::operator>>(long long&) const
    {9, 302, 211, 1, Smoke::mf_const, 161, 38},	//115 QDBusArgument::operator>>(unsigned long long&) const
    {9, 302, 213, 1, Smoke::mf_const, 161, 39},	//116 QDBusArgument::operator>>(double&) const
    {9, 302, 215, 1, Smoke::mf_const, 161, 40},	//117 QDBusArgument::operator>>(QString&) const
    {9, 302, 217, 1, Smoke::mf_const, 161, 41},	//118 QDBusArgument::operator>>(QDBusVariant&) const
    {9, 302, 219, 1, Smoke::mf_const, 161, 42},	//119 QDBusArgument::operator>>(QDBusObjectPath&) const
    {9, 302, 221, 1, Smoke::mf_const, 161, 43},	//120 QDBusArgument::operator>>(QDBusSignature&) const
    {9, 302, 223, 1, Smoke::mf_const, 161, 44},	//121 QDBusArgument::operator>>(QDBusUnixFileDescriptor&) const
    {9, 302, 225, 1, Smoke::mf_const, 161, 45},	//122 QDBusArgument::operator>>(QStringList&) const
    {9, 302, 227, 1, Smoke::mf_const, 161, 46},	//123 QDBusArgument::operator>>(QByteArray&) const
    {9, 158, 0, 0, Smoke::mf_const, 0, 47},	//124 QDBusArgument::beginStructure() const
    {9, 236, 0, 0, Smoke::mf_const, 0, 48},	//125 QDBusArgument::endStructure() const
    {9, 153, 0, 0, Smoke::mf_const, 0, 49},	//126 QDBusArgument::beginArray() const
    {9, 233, 0, 0, Smoke::mf_const, 0, 50},	//127 QDBusArgument::endArray() const
    {9, 155, 0, 0, Smoke::mf_const, 0, 51},	//128 QDBusArgument::beginMap() const
    {9, 234, 0, 0, Smoke::mf_const, 0, 52},	//129 QDBusArgument::endMap() const
    {9, 157, 0, 0, Smoke::mf_const, 0, 53},	//130 QDBusArgument::beginMapEntry() const
    {9, 235, 0, 0, Smoke::mf_const, 0, 54},	//131 QDBusArgument::endMapEntry() const
    {9, 149, 0, 0, Smoke::mf_const, 157, 55},	//132 QDBusArgument::atEnd() const
    {9, 134, 0, 0, Smoke::mf_const, 81, 56},	//133 QDBusArgument::asVariant() const
    {9, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 10, 57},	//134 QDBusArgument::BasicType (enum)
    {9, 124, 0, 0, Smoke::mf_static|Smoke::mf_enum, 10, 58},	//135 QDBusArgument::VariantType (enum)
    {9, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 10, 59},	//136 QDBusArgument::ArrayType (enum)
    {9, 112, 0, 0, Smoke::mf_static|Smoke::mf_enum, 10, 60},	//137 QDBusArgument::StructureType (enum)
    {9, 45, 0, 0, Smoke::mf_static|Smoke::mf_enum, 10, 61},	//138 QDBusArgument::MapType (enum)
    {9, 44, 0, 0, Smoke::mf_static|Smoke::mf_enum, 10, 62},	//139 QDBusArgument::MapEntryType (enum)
    {9, 121, 0, 0, Smoke::mf_static|Smoke::mf_enum, 10, 63},	//140 QDBusArgument::UnknownType (enum)
    {9, 404, 0, 0, Smoke::mf_dtor, 0, 64 },	//141 QDBusArgument::~QDBusArgument()
    {10, 67, 68, 1, Smoke::mf_ctor, 13, 1},	//142 QDBusConnection::QDBusConnection(const QString&)
    {10, 67, 229, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 13, 2},	//143 QDBusConnection::QDBusConnection(const QDBusConnection&)
    {10, 297, 229, 1, 0, 12, 3},	//144 QDBusConnection::operator=(const QDBusConnection&)
    {10, 266, 0, 0, Smoke::mf_const, 157, 4},	//145 QDBusConnection::isConnected() const
    {10, 152, 0, 0, Smoke::mf_const, 74, 5},	//146 QDBusConnection::baseService() const
    {10, 275, 0, 0, Smoke::mf_const, 24, 6},	//147 QDBusConnection::lastError() const
    {10, 282, 0, 0, Smoke::mf_const, 74, 7},	//148 QDBusConnection::name() const
    {10, 204, 0, 0, Smoke::mf_const, 57, 8},	//149 QDBusConnection::connectionCapabilities() const
    {10, 334, 231, 1, Smoke::mf_const, 157, 9},	//150 QDBusConnection::send(const QDBusMessage&) const
    {10, 183, 233, 5, Smoke::mf_const, 157, 10},	//151 QDBusConnection::callWithCallback(const QDBusMessage&, QObject*, const char*, const char*, int) const
    {10, 183, 239, 4, Smoke::mf_const, 157, 11},	//152 QDBusConnection::callWithCallback(const QDBusMessage&, QObject*, const char*, int) const
    {10, 159, 244, 3, Smoke::mf_const, 29, 12},	//153 QDBusConnection::call(const QDBusMessage&, QDBus::CallMode, int) const
    {10, 135, 248, 2, Smoke::mf_const, 35, 13},	//154 QDBusConnection::asyncCall(const QDBusMessage&, int) const
    {10, 193, 251, 6, 0, 157, 14},	//155 QDBusConnection::connect(const QString&, const QString&, const QString&, const QString&, QObject*, const char*)
    {10, 193, 258, 7, 0, 157, 15},	//156 QDBusConnection::connect(const QString&, const QString&, const QString&, const QString&, const QString&, QObject*, const char*)
    {10, 193, 266, 8, 0, 157, 16},	//157 QDBusConnection::connect(const QString&, const QString&, const QString&, const QString&, const QStringList&, const QString&, QObject*, const char*)
    {10, 223, 251, 6, 0, 157, 17},	//158 QDBusConnection::disconnect(const QString&, const QString&, const QString&, const QString&, QObject*, const char*)
    {10, 223, 258, 7, 0, 157, 18},	//159 QDBusConnection::disconnect(const QString&, const QString&, const QString&, const QString&, const QString&, QObject*, const char*)
    {10, 223, 266, 8, 0, 157, 19},	//160 QDBusConnection::disconnect(const QString&, const QString&, const QString&, const QString&, const QStringList&, const QString&, QObject*, const char*)
    {10, 320, 275, 3, 0, 157, 20},	//161 QDBusConnection::registerObject(const QString&, QObject*, QFlags<QDBusConnection::RegisterOption>)
    {10, 393, 279, 2, 0, 0, 21},	//162 QDBusConnection::unregisterObject(const QString&, QDBusConnection::UnregisterMode)
    {10, 285, 68, 1, Smoke::mf_const, 66, 22},	//163 QDBusConnection::objectRegisteredAt(const QString&) const
    {10, 327, 282, 3, 0, 157, 23},	//164 QDBusConnection::registerVirtualObject(const QString&, QDBusVirtualObject*, QDBusConnection::VirtualObjectRegisterOption)
    {10, 323, 68, 1, 0, 157, 24},	//165 QDBusConnection::registerService(const QString&)
    {10, 396, 68, 1, 0, 157, 25},	//166 QDBusConnection::unregisterService(const QString&)
    {10, 255, 0, 0, Smoke::mf_const, 19, 26},	//167 QDBusConnection::interface() const
    {10, 259, 0, 0, Smoke::mf_const, 216, 27},	//168 QDBusConnection::internalPointer() const
    {10, 199, 286, 2, Smoke::mf_static, 11, 28},	//169 QDBusConnection::connectToBus(QDBusConnection::BusType, const QString&)
    {10, 199, 289, 2, Smoke::mf_static, 11, 29},	//170 QDBusConnection::connectToBus(const QString&, const QString&)
    {10, 201, 289, 2, Smoke::mf_static, 11, 30},	//171 QDBusConnection::connectToPeer(const QString&, const QString&)
    {10, 227, 68, 1, Smoke::mf_static, 0, 31},	//172 QDBusConnection::disconnectFromBus(const QString&)
    {10, 229, 68, 1, Smoke::mf_static, 0, 32},	//173 QDBusConnection::disconnectFromPeer(const QString&)
    {10, 276, 0, 0, Smoke::mf_static, 2, 33},	//174 QDBusConnection::localMachineId()
    {10, 353, 0, 0, Smoke::mf_static, 11, 34},	//175 QDBusConnection::sessionBus()
    {10, 378, 0, 0, Smoke::mf_static, 11, 35},	//176 QDBusConnection::systemBus()
    {10, 339, 0, 0, Smoke::mf_static, 11, 36},	//177 QDBusConnection::sender()
    {10, 183, 292, 4, Smoke::mf_const, 157, 37},	//178 QDBusConnection::callWithCallback(const QDBusMessage&, QObject*, const char*, const char*) const
    {10, 183, 297, 3, Smoke::mf_const, 157, 38},	//179 QDBusConnection::callWithCallback(const QDBusMessage&, QObject*, const char*) const
    {10, 159, 231, 1, Smoke::mf_const, 29, 39},	//180 QDBusConnection::call(const QDBusMessage&) const
    {10, 159, 301, 2, Smoke::mf_const, 29, 40},	//181 QDBusConnection::call(const QDBusMessage&, QDBus::CallMode) const
    {10, 135, 231, 1, Smoke::mf_const, 35, 41},	//182 QDBusConnection::asyncCall(const QDBusMessage&) const
    {10, 320, 304, 2, 0, 157, 42},	//183 QDBusConnection::registerObject(const QString&, QObject*)
    {10, 393, 68, 1, 0, 0, 43},	//184 QDBusConnection::unregisterObject(const QString&)
    {10, 327, 307, 2, 0, 157, 44},	//185 QDBusConnection::registerVirtualObject(const QString&, QDBusVirtualObject*)
    {10, 377, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 179, 45},	//186 QDBusConnection::staticMetaObject() const
    {10, 109, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 46},	//187 QDBusConnection::SessionBus (enum)
    {10, 114, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 47},	//188 QDBusConnection::SystemBus (enum)
    {10, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 48},	//189 QDBusConnection::ActivationBus (enum)
    {10, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 49},	//190 QDBusConnection::ExportAdaptors (enum)
    {10, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 50},	//191 QDBusConnection::ExportScriptableSlots (enum)
    {10, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 51},	//192 QDBusConnection::ExportScriptableSignals (enum)
    {10, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 52},	//193 QDBusConnection::ExportScriptableProperties (enum)
    {10, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 53},	//194 QDBusConnection::ExportScriptableInvokables (enum)
    {10, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 54},	//195 QDBusConnection::ExportScriptableContents (enum)
    {10, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 55},	//196 QDBusConnection::ExportNonScriptableSlots (enum)
    {10, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 56},	//197 QDBusConnection::ExportNonScriptableSignals (enum)
    {10, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 57},	//198 QDBusConnection::ExportNonScriptableProperties (enum)
    {10, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 58},	//199 QDBusConnection::ExportNonScriptableInvokables (enum)
    {10, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 59},	//200 QDBusConnection::ExportNonScriptableContents (enum)
    {10, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 60},	//201 QDBusConnection::ExportAllSlots (enum)
    {10, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 61},	//202 QDBusConnection::ExportAllSignals (enum)
    {10, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 62},	//203 QDBusConnection::ExportAllProperties (enum)
    {10, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 63},	//204 QDBusConnection::ExportAllInvokables (enum)
    {10, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 64},	//205 QDBusConnection::ExportAllContents (enum)
    {10, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 65},	//206 QDBusConnection::ExportAllSignal (enum)
    {10, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 66},	//207 QDBusConnection::ExportChildObjects (enum)
    {10, 122, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 67},	//208 QDBusConnection::UnregisterNode (enum)
    {10, 123, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 68},	//209 QDBusConnection::UnregisterTree (enum)
    {10, 111, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 69},	//210 QDBusConnection::SingleNode (enum)
    {10, 113, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 70},	//211 QDBusConnection::SubPath (enum)
    {10, 117, 0, 0, Smoke::mf_static|Smoke::mf_enum, 15, 71},	//212 QDBusConnection::UnixFileDescriptorPassing (enum)
    {10, 405, 0, 0, Smoke::mf_dtor, 0, 72 },	//213 QDBusConnection::~QDBusConnection()
    {11, 281, 0, 0, Smoke::mf_const, 180, 1},	//214 QDBusConnectionInterface::metaObject() const
    {11, 316, 1, 1, 0, 216, 2},	//215 QDBusConnectionInterface::qt_metacast(const char*)
    {11, 382, 3, 2, Smoke::mf_static, 74, 3},	//216 QDBusConnectionInterface::tr(const char*, const char*)
    {11, 386, 3, 2, Smoke::mf_static, 74, 4},	//217 QDBusConnectionInterface::trUtf8(const char*, const char*)
    {11, 382, 6, 3, Smoke::mf_static, 74, 5},	//218 QDBusConnectionInterface::tr(const char*, const char*, int)
    {11, 386, 6, 3, Smoke::mf_static, 74, 6},	//219 QDBusConnectionInterface::trUtf8(const char*, const char*, int)
    {11, 314, 10, 3, 0, 198, 7},	//220 QDBusConnectionInterface::qt_metacall(QMetaObject::Call, int, void**)
    {11, 330, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_slot, 41, 8},	//221 QDBusConnectionInterface::registeredServiceNames() const
    {11, 271, 68, 1, Smoke::mf_const|Smoke::mf_slot, 42, 9},	//222 QDBusConnectionInterface::isServiceRegistered(const QString&) const
    {11, 341, 68, 1, Smoke::mf_const|Smoke::mf_slot, 40, 10},	//223 QDBusConnectionInterface::serviceOwner(const QString&) const
    {11, 396, 68, 1, Smoke::mf_slot, 42, 11},	//224 QDBusConnectionInterface::unregisterService(const QString&)
    {11, 323, 310, 3, Smoke::mf_slot, 39, 12},	//225 QDBusConnectionInterface::registerService(const QString&, QDBusConnectionInterface::ServiceQueueOptions, QDBusConnectionInterface::ServiceReplacementOptions)
    {11, 345, 68, 1, Smoke::mf_const|Smoke::mf_slot, 43, 13},	//226 QDBusConnectionInterface::servicePid(const QString&) const
    {11, 349, 68, 1, Smoke::mf_const|Smoke::mf_slot, 43, 14},	//227 QDBusConnectionInterface::serviceUid(const QString&) const
    {11, 375, 68, 1, Smoke::mf_slot, 44, 15},	//228 QDBusConnectionInterface::startService(const QString&)
    {11, 347, 68, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 16},	//229 QDBusConnectionInterface::serviceRegistered(const QString&)
    {11, 351, 68, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//230 QDBusConnectionInterface::serviceUnregistered(const QString&)
    {11, 343, 314, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//231 QDBusConnectionInterface::serviceOwnerChanged(const QString&, const QString&, const QString&)
    {11, 189, 318, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//232 QDBusConnectionInterface::callWithCallbackFailed(const QDBusError&, const QDBusMessage&)
    {11, 47, 68, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 20},	//233 QDBusConnectionInterface::NameAcquired(const QString&)
    {11, 49, 68, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 21},	//234 QDBusConnectionInterface::NameLost(const QString&)
    {11, 51, 314, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 22},	//235 QDBusConnectionInterface::NameOwnerChanged(const QString&, const QString&, const QString&)
    {11, 197, 1, 1, Smoke::mf_protected, 0, 23},	//236 QDBusConnectionInterface::connectNotify(const char*)
    {11, 231, 1, 1, Smoke::mf_protected, 0, 24},	//237 QDBusConnectionInterface::disconnectNotify(const char*)
    {11, 382, 1, 1, Smoke::mf_static, 74, 25},	//238 QDBusConnectionInterface::tr(const char*)
    {11, 386, 1, 1, Smoke::mf_static, 74, 26},	//239 QDBusConnectionInterface::trUtf8(const char*)
    {11, 323, 68, 1, Smoke::mf_slot, 39, 27},	//240 QDBusConnectionInterface::registerService(const QString&)
    {11, 323, 321, 2, Smoke::mf_slot, 39, 28},	//241 QDBusConnectionInterface::registerService(const QString&, QDBusConnectionInterface::ServiceQueueOptions)
    {11, 377, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 179, 29},	//242 QDBusConnectionInterface::staticMetaObject() const
    {11, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 21, 30},	//243 QDBusConnectionInterface::DontQueueService (enum)
    {11, 102, 0, 0, Smoke::mf_static|Smoke::mf_enum, 21, 31},	//244 QDBusConnectionInterface::QueueService (enum)
    {11, 103, 0, 0, Smoke::mf_static|Smoke::mf_enum, 21, 32},	//245 QDBusConnectionInterface::ReplaceExistingService (enum)
    {11, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 22, 33},	//246 QDBusConnectionInterface::DontAllowReplacement (enum)
    {11, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 22, 34},	//247 QDBusConnectionInterface::AllowReplacement (enum)
    {11, 105, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 35},	//248 QDBusConnectionInterface::ServiceNotRegistered (enum)
    {11, 107, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 36},	//249 QDBusConnectionInterface::ServiceRegistered (enum)
    {11, 106, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 37},	//250 QDBusConnectionInterface::ServiceQueued (enum)
    {12, 70, 0, 0, Smoke::mf_ctor, 23, 1},	//251 QDBusContext::QDBusContext()
    {12, 191, 0, 0, Smoke::mf_const, 157, 2},	//252 QDBusContext::calledFromDBus() const
    {12, 203, 0, 0, Smoke::mf_const, 11, 3},	//253 QDBusContext::connection() const
    {12, 280, 0, 0, Smoke::mf_const, 165, 4},	//254 QDBusContext::message() const
    {12, 267, 0, 0, Smoke::mf_const, 157, 5},	//255 QDBusContext::isDelayedReply() const
    {12, 362, 16, 1, Smoke::mf_const, 0, 6},	//256 QDBusContext::setDelayedReply(bool) const
    {12, 336, 289, 2, Smoke::mf_const, 0, 7},	//257 QDBusContext::sendErrorReply(const QString&, const QString&) const
    {12, 336, 324, 2, Smoke::mf_const, 0, 8},	//258 QDBusContext::sendErrorReply(QDBusError::ErrorType, const QString&) const
    {12, 70, 327, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 23, 9},	//259 QDBusContext::QDBusContext(const QDBusContext&)
    {12, 336, 68, 1, Smoke::mf_const, 0, 10},	//260 QDBusContext::sendErrorReply(const QString&) const
    {12, 336, 329, 1, Smoke::mf_const, 0, 11},	//261 QDBusContext::sendErrorReply(QDBusError::ErrorType) const
    {12, 406, 0, 0, Smoke::mf_dtor, 0, 12 },	//262 QDBusContext::~QDBusContext()
    {13, 72, 331, 1, Smoke::mf_ctor, 26, 1},	//263 QDBusError::QDBusError(const DBusError*)
    {13, 72, 231, 1, Smoke::mf_ctor, 26, 2},	//264 QDBusError::QDBusError(const QDBusMessage&)
    {13, 72, 324, 2, Smoke::mf_ctor, 26, 3},	//265 QDBusError::QDBusError(QDBusError::ErrorType, const QString&)
    {13, 72, 333, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 26, 4},	//266 QDBusError::QDBusError(const QDBusError&)
    {13, 297, 333, 1, 0, 25, 5},	//267 QDBusError::operator=(const QDBusError&)
    {13, 390, 0, 0, Smoke::mf_const, 27, 6},	//268 QDBusError::type() const
    {13, 282, 0, 0, Smoke::mf_const, 74, 7},	//269 QDBusError::name() const
    {13, 280, 0, 0, Smoke::mf_const, 74, 8},	//270 QDBusError::message() const
    {13, 274, 0, 0, Smoke::mf_const, 157, 9},	//271 QDBusError::isValid() const
    {13, 240, 329, 1, Smoke::mf_static, 74, 10},	//272 QDBusError::errorString(QDBusError::ErrorType)
    {13, 72, 0, 0, Smoke::mf_ctor, 26, 11},	//273 QDBusError::QDBusError()
    {13, 54, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 12},	//274 QDBusError::NoError (enum)
    {13, 60, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 13},	//275 QDBusError::Other (enum)
    {13, 33, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 14},	//276 QDBusError::Failed (enum)
    {13, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 15},	//277 QDBusError::NoMemory (enum)
    {13, 108, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 16},	//278 QDBusError::ServiceUnknown (enum)
    {13, 57, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 17},	//279 QDBusError::NoReply (enum)
    {13, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 18},	//280 QDBusError::BadAddress (enum)
    {13, 59, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 19},	//281 QDBusError::NotSupported (enum)
    {13, 43, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 20},	//282 QDBusError::LimitsExceeded (enum)
    {13, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 21},	//283 QDBusError::AccessDenied (enum)
    {13, 58, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 22},	//284 QDBusError::NoServer (enum)
    {13, 116, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 23},	//285 QDBusError::Timeout (enum)
    {13, 56, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 24},	//286 QDBusError::NoNetwork (enum)
    {13, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 25},	//287 QDBusError::AddressInUse (enum)
    {13, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 26},	//288 QDBusError::Disconnected (enum)
    {13, 35, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 27},	//289 QDBusError::InvalidArgs (enum)
    {13, 119, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 28},	//290 QDBusError::UnknownMethod (enum)
    {13, 115, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 29},	//291 QDBusError::TimedOut (enum)
    {13, 41, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 30},	//292 QDBusError::InvalidSignature (enum)
    {13, 118, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 31},	//293 QDBusError::UnknownInterface (enum)
    {13, 34, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 32},	//294 QDBusError::InternalError (enum)
    {13, 120, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 33},	//295 QDBusError::UnknownObject (enum)
    {13, 40, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 34},	//296 QDBusError::InvalidService (enum)
    {13, 39, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 35},	//297 QDBusError::InvalidObjectPath (enum)
    {13, 36, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 36},	//298 QDBusError::InvalidInterface (enum)
    {13, 37, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 37},	//299 QDBusError::InvalidMember (enum)
    {13, 42, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 38},	//300 QDBusError::LastErrorType (enum)
    {13, 407, 0, 0, Smoke::mf_dtor, 0, 39 },	//301 QDBusError::~QDBusError()
    {14, 75, 335, 5, Smoke::mf_ctor, 28, 1},	//302 QDBusInterface::QDBusInterface(const QString&, const QString&, const QString&, const QDBusConnection&, QObject*)
    {14, 281, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 180, 2},	//303 QDBusInterface::metaObject() const
    {14, 316, 1, 1, Smoke::mf_virtual, 216, 3},	//304 QDBusInterface::qt_metacast(const char*)
    {14, 314, 10, 3, Smoke::mf_virtual, 198, 4},	//305 QDBusInterface::qt_metacall(QMetaObject::Call, int, void**)
    {14, 75, 289, 2, Smoke::mf_ctor, 28, 5},	//306 QDBusInterface::QDBusInterface(const QString&, const QString&)
    {14, 75, 314, 3, Smoke::mf_ctor, 28, 6},	//307 QDBusInterface::QDBusInterface(const QString&, const QString&, const QString&)
    {14, 75, 341, 4, Smoke::mf_ctor, 28, 7},	//308 QDBusInterface::QDBusInterface(const QString&, const QString&, const QString&, const QDBusConnection&)
    {14, 408, 0, 0, Smoke::mf_dtor, 0, 8 },	//309 QDBusInterface::~QDBusInterface()
    {15, 80, 0, 0, Smoke::mf_ctor, 31, 1},	//310 QDBusMessage::QDBusMessage()
    {15, 80, 231, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 31, 2},	//311 QDBusMessage::QDBusMessage(const QDBusMessage&)
    {15, 297, 231, 1, 0, 30, 3},	//312 QDBusMessage::operator=(const QDBusMessage&)
    {15, 216, 314, 3, Smoke::mf_static, 29, 4},	//313 QDBusMessage::createSignal(const QString&, const QString&, const QString&)
    {15, 211, 346, 4, Smoke::mf_static, 29, 5},	//314 QDBusMessage::createMethodCall(const QString&, const QString&, const QString&, const QString&)
    {15, 205, 289, 2, Smoke::mf_static, 29, 6},	//315 QDBusMessage::createError(const QString&, const QString&)
    {15, 205, 333, 1, Smoke::mf_static, 29, 7},	//316 QDBusMessage::createError(const QDBusError&)
    {15, 205, 324, 2, Smoke::mf_static, 29, 8},	//317 QDBusMessage::createError(QDBusError::ErrorType, const QString&)
    {15, 213, 351, 1, Smoke::mf_const, 29, 9},	//318 QDBusMessage::createReply(const QList<QVariant>&) const
    {15, 213, 195, 1, Smoke::mf_const, 29, 10},	//319 QDBusMessage::createReply(const QVariant&) const
    {15, 208, 353, 2, Smoke::mf_const, 29, 11},	//320 QDBusMessage::createErrorReply(const QString, const QString&) const
    {15, 208, 333, 1, Smoke::mf_const, 29, 12},	//321 QDBusMessage::createErrorReply(const QDBusError&) const
    {15, 208, 324, 2, Smoke::mf_const, 29, 13},	//322 QDBusMessage::createErrorReply(QDBusError::ErrorType, const QString&) const
    {15, 340, 0, 0, Smoke::mf_const, 74, 14},	//323 QDBusMessage::service() const
    {15, 309, 0, 0, Smoke::mf_const, 74, 15},	//324 QDBusMessage::path() const
    {15, 255, 0, 0, Smoke::mf_const, 74, 16},	//325 QDBusMessage::interface() const
    {15, 279, 0, 0, Smoke::mf_const, 74, 17},	//326 QDBusMessage::member() const
    {15, 239, 0, 0, Smoke::mf_const, 74, 18},	//327 QDBusMessage::errorName() const
    {15, 238, 0, 0, Smoke::mf_const, 74, 19},	//328 QDBusMessage::errorMessage() const
    {15, 390, 0, 0, Smoke::mf_const, 32, 20},	//329 QDBusMessage::type() const
    {15, 372, 0, 0, Smoke::mf_const, 74, 21},	//330 QDBusMessage::signature() const
    {15, 270, 0, 0, Smoke::mf_const, 157, 22},	//331 QDBusMessage::isReplyRequired() const
    {15, 362, 16, 1, Smoke::mf_const, 0, 23},	//332 QDBusMessage::setDelayedReply(bool) const
    {15, 267, 0, 0, Smoke::mf_const, 157, 24},	//333 QDBusMessage::isDelayedReply() const
    {15, 358, 16, 1, 0, 0, 25},	//334 QDBusMessage::setAutoStartService(bool)
    {15, 151, 0, 0, Smoke::mf_const, 157, 26},	//335 QDBusMessage::autoStartService() const
    {15, 354, 351, 1, 0, 0, 27},	//336 QDBusMessage::setArguments(const QList<QVariant>&)
    {15, 133, 0, 0, Smoke::mf_const, 64, 28},	//337 QDBusMessage::arguments() const
    {15, 291, 195, 1, 0, 30, 29},	//338 QDBusMessage::operator<<(const QVariant&)
    {15, 213, 0, 0, Smoke::mf_const, 29, 30},	//339 QDBusMessage::createReply() const
    {15, 38, 0, 0, Smoke::mf_static|Smoke::mf_enum, 32, 31},	//340 QDBusMessage::InvalidMessage (enum)
    {15, 46, 0, 0, Smoke::mf_static|Smoke::mf_enum, 32, 32},	//341 QDBusMessage::MethodCallMessage (enum)
    {15, 104, 0, 0, Smoke::mf_static|Smoke::mf_enum, 32, 33},	//342 QDBusMessage::ReplyMessage (enum)
    {15, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 32, 34},	//343 QDBusMessage::ErrorMessage (enum)
    {15, 110, 0, 0, Smoke::mf_static|Smoke::mf_enum, 32, 35},	//344 QDBusMessage::SignalMessage (enum)
    {15, 409, 0, 0, Smoke::mf_dtor, 0, 36 },	//345 QDBusMessage::~QDBusMessage()
    {16, 318, 356, 3, Smoke::mf_static, 0, 1},	//346 QDBusMetaType::registerMarshallOperators(int, void(*)(QDBusArgument&,const void*), void(*)(const QDBusArgument&,void*))
    {16, 277, 360, 3, Smoke::mf_static, 157, 2},	//347 QDBusMetaType::marshall(QDBusArgument&, int, const void*)
    {16, 221, 364, 3, Smoke::mf_static, 157, 3},	//348 QDBusMetaType::demarshall(const QDBusArgument&, int, void*)
    {16, 373, 1, 1, Smoke::mf_static, 198, 4},	//349 QDBusMetaType::signatureToType(const char*)
    {16, 391, 18, 1, Smoke::mf_static, 194, 5},	//350 QDBusMetaType::typeToSignature(int)
    {16, 82, 0, 0, Smoke::mf_ctor, 33, 6},	//351 QDBusMetaType::QDBusMetaType()
    {16, 82, 368, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 33, 7},	//352 QDBusMetaType::QDBusMetaType(const QDBusMetaType&)
    {16, 410, 0, 0, Smoke::mf_dtor, 0, 8 },	//353 QDBusMetaType::~QDBusMetaType()
    {17, 84, 370, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 37, 1},	//354 QDBusPendingCall::QDBusPendingCall(const QDBusPendingCall&)
    {17, 297, 370, 1, 0, 36, 2},	//355 QDBusPendingCall::operator=(const QDBusPendingCall&)
    {17, 269, 0, 0, Smoke::mf_const, 157, 3},	//356 QDBusPendingCall::isFinished() const
    {17, 398, 0, 0, 0, 0, 4},	//357 QDBusPendingCall::waitForFinished()
    {17, 268, 0, 0, Smoke::mf_const, 157, 5},	//358 QDBusPendingCall::isError() const
    {17, 274, 0, 0, Smoke::mf_const, 157, 6},	//359 QDBusPendingCall::isValid() const
    {17, 237, 0, 0, Smoke::mf_const, 24, 7},	//360 QDBusPendingCall::error() const
    {17, 333, 0, 0, Smoke::mf_const, 29, 8},	//361 QDBusPendingCall::reply() const
    {17, 249, 333, 1, Smoke::mf_static, 35, 9},	//362 QDBusPendingCall::fromError(const QDBusError&)
    {17, 247, 231, 1, Smoke::mf_static, 35, 10},	//363 QDBusPendingCall::fromCompletedCall(const QDBusMessage&)
    {17, 411, 0, 0, Smoke::mf_dtor, 0, 11 },	//364 QDBusPendingCall::~QDBusPendingCall()
    {18, 281, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 180, 1},	//365 QDBusPendingCallWatcher::metaObject() const
    {18, 316, 1, 1, Smoke::mf_virtual, 216, 2},	//366 QDBusPendingCallWatcher::qt_metacast(const char*)
    {18, 382, 3, 2, Smoke::mf_static, 74, 3},	//367 QDBusPendingCallWatcher::tr(const char*, const char*)
    {18, 386, 3, 2, Smoke::mf_static, 74, 4},	//368 QDBusPendingCallWatcher::trUtf8(const char*, const char*)
    {18, 382, 6, 3, Smoke::mf_static, 74, 5},	//369 QDBusPendingCallWatcher::tr(const char*, const char*, int)
    {18, 386, 6, 3, Smoke::mf_static, 74, 6},	//370 QDBusPendingCallWatcher::trUtf8(const char*, const char*, int)
    {18, 314, 10, 3, Smoke::mf_virtual, 198, 7},	//371 QDBusPendingCallWatcher::qt_metacall(QMetaObject::Call, int, void**)
    {18, 86, 372, 2, Smoke::mf_ctor, 38, 8},	//372 QDBusPendingCallWatcher::QDBusPendingCallWatcher(const QDBusPendingCall&, QObject*)
    {18, 398, 0, 0, 0, 0, 9},	//373 QDBusPendingCallWatcher::waitForFinished()
    {18, 245, 375, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 10},	//374 QDBusPendingCallWatcher::finished(QDBusPendingCallWatcher*)
    {18, 382, 1, 1, Smoke::mf_static, 74, 11},	//375 QDBusPendingCallWatcher::tr(const char*)
    {18, 386, 1, 1, Smoke::mf_static, 74, 12},	//376 QDBusPendingCallWatcher::trUtf8(const char*)
    {18, 86, 370, 1, Smoke::mf_ctor, 38, 13},	//377 QDBusPendingCallWatcher::QDBusPendingCallWatcher(const QDBusPendingCall&)
    {18, 377, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 179, 14},	//378 QDBusPendingCallWatcher::staticMetaObject() const
    {18, 412, 0, 0, Smoke::mf_dtor, 0, 15 },	//379 QDBusPendingCallWatcher::~QDBusPendingCallWatcher()
    {19, 281, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 180, 1},	//380 QDBusServer::metaObject() const
    {19, 316, 1, 1, Smoke::mf_virtual, 216, 2},	//381 QDBusServer::qt_metacast(const char*)
    {19, 382, 3, 2, Smoke::mf_static, 74, 3},	//382 QDBusServer::tr(const char*, const char*)
    {19, 386, 3, 2, Smoke::mf_static, 74, 4},	//383 QDBusServer::trUtf8(const char*, const char*)
    {19, 382, 6, 3, Smoke::mf_static, 74, 5},	//384 QDBusServer::tr(const char*, const char*, int)
    {19, 386, 6, 3, Smoke::mf_static, 74, 6},	//385 QDBusServer::trUtf8(const char*, const char*, int)
    {19, 314, 10, 3, Smoke::mf_virtual, 198, 7},	//386 QDBusServer::qt_metacall(QMetaObject::Call, int, void**)
    {19, 89, 304, 2, Smoke::mf_ctor, 45, 8},	//387 QDBusServer::QDBusServer(const QString&, QObject*)
    {19, 266, 0, 0, Smoke::mf_const, 157, 9},	//388 QDBusServer::isConnected() const
    {19, 275, 0, 0, Smoke::mf_const, 24, 10},	//389 QDBusServer::lastError() const
    {19, 130, 0, 0, Smoke::mf_const, 74, 11},	//390 QDBusServer::address() const
    {19, 283, 229, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//391 QDBusServer::newConnection(const QDBusConnection&)
    {19, 382, 1, 1, Smoke::mf_static, 74, 13},	//392 QDBusServer::tr(const char*)
    {19, 386, 1, 1, Smoke::mf_static, 74, 14},	//393 QDBusServer::trUtf8(const char*)
    {19, 89, 0, 0, Smoke::mf_ctor, 45, 15},	//394 QDBusServer::QDBusServer()
    {19, 89, 68, 1, Smoke::mf_ctor, 45, 16},	//395 QDBusServer::QDBusServer(const QString&)
    {19, 377, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 179, 17},	//396 QDBusServer::staticMetaObject() const
    {19, 413, 0, 0, Smoke::mf_dtor, 0, 18 },	//397 QDBusServer::~QDBusServer()
    {20, 281, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 180, 1},	//398 QDBusServiceWatcher::metaObject() const
    {20, 316, 1, 1, Smoke::mf_virtual, 216, 2},	//399 QDBusServiceWatcher::qt_metacast(const char*)
    {20, 382, 3, 2, Smoke::mf_static, 74, 3},	//400 QDBusServiceWatcher::tr(const char*, const char*)
    {20, 386, 3, 2, Smoke::mf_static, 74, 4},	//401 QDBusServiceWatcher::trUtf8(const char*, const char*)
    {20, 382, 6, 3, Smoke::mf_static, 74, 5},	//402 QDBusServiceWatcher::tr(const char*, const char*, int)
    {20, 386, 6, 3, Smoke::mf_static, 74, 6},	//403 QDBusServiceWatcher::trUtf8(const char*, const char*, int)
    {20, 314, 10, 3, Smoke::mf_virtual, 198, 7},	//404 QDBusServiceWatcher::qt_metacall(QMetaObject::Call, int, void**)
    {20, 92, 14, 1, Smoke::mf_ctor, 46, 8},	//405 QDBusServiceWatcher::QDBusServiceWatcher(QObject*)
    {20, 92, 377, 4, Smoke::mf_ctor, 46, 9},	//406 QDBusServiceWatcher::QDBusServiceWatcher(const QString&, const QDBusConnection&, QFlags<QDBusServiceWatcher::WatchModeFlag>, QObject*)
    {20, 400, 0, 0, Smoke::mf_const|Smoke::mf_property, 76, 10},	//407 QDBusServiceWatcher::watchedServices() const
    {20, 370, 188, 1, Smoke::mf_property, 0, 11},	//408 QDBusServiceWatcher::setWatchedServices(const QStringList&)
    {20, 128, 68, 1, 0, 0, 12},	//409 QDBusServiceWatcher::addWatchedService(const QString&)
    {20, 331, 68, 1, 0, 157, 13},	//410 QDBusServiceWatcher::removeWatchedService(const QString&)
    {20, 399, 0, 0, Smoke::mf_const, 60, 14},	//411 QDBusServiceWatcher::watchMode() const
    {20, 368, 382, 1, 0, 0, 15},	//412 QDBusServiceWatcher::setWatchMode(QFlags<QDBusServiceWatcher::WatchModeFlag>)
    {20, 203, 0, 0, Smoke::mf_const, 11, 16},	//413 QDBusServiceWatcher::connection() const
    {20, 360, 229, 1, 0, 0, 17},	//414 QDBusServiceWatcher::setConnection(const QDBusConnection&)
    {20, 347, 68, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//415 QDBusServiceWatcher::serviceRegistered(const QString&)
    {20, 351, 68, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//416 QDBusServiceWatcher::serviceUnregistered(const QString&)
    {20, 343, 314, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 20},	//417 QDBusServiceWatcher::serviceOwnerChanged(const QString&, const QString&, const QString&)
    {20, 382, 1, 1, Smoke::mf_static, 74, 21},	//418 QDBusServiceWatcher::tr(const char*)
    {20, 386, 1, 1, Smoke::mf_static, 74, 22},	//419 QDBusServiceWatcher::trUtf8(const char*)
    {20, 92, 0, 0, Smoke::mf_ctor, 46, 23},	//420 QDBusServiceWatcher::QDBusServiceWatcher()
    {20, 92, 384, 2, Smoke::mf_ctor, 46, 24},	//421 QDBusServiceWatcher::QDBusServiceWatcher(const QString&, const QDBusConnection&)
    {20, 92, 387, 3, Smoke::mf_ctor, 46, 25},	//422 QDBusServiceWatcher::QDBusServiceWatcher(const QString&, const QDBusConnection&, QFlags<QDBusServiceWatcher::WatchModeFlag>)
    {20, 377, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 179, 26},	//423 QDBusServiceWatcher::staticMetaObject() const
    {20, 126, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 27},	//424 QDBusServiceWatcher::WatchForRegistration (enum)
    {20, 127, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 28},	//425 QDBusServiceWatcher::WatchForUnregistration (enum)
    {20, 125, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 29},	//426 QDBusServiceWatcher::WatchForOwnerChange (enum)
    {20, 414, 0, 0, Smoke::mf_dtor, 0, 30 },	//427 QDBusServiceWatcher::~QDBusServiceWatcher()
    {21, 97, 0, 0, Smoke::mf_ctor, 50, 1},	//428 QDBusUnixFileDescriptor::QDBusUnixFileDescriptor()
    {21, 97, 18, 1, Smoke::mf_ctor, 50, 2},	//429 QDBusUnixFileDescriptor::QDBusUnixFileDescriptor(int)
    {21, 97, 186, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 50, 3},	//430 QDBusUnixFileDescriptor::QDBusUnixFileDescriptor(const QDBusUnixFileDescriptor&)
    {21, 297, 186, 1, 0, 49, 4},	//431 QDBusUnixFileDescriptor::operator=(const QDBusUnixFileDescriptor&)
    {21, 274, 0, 0, Smoke::mf_const, 157, 5},	//432 QDBusUnixFileDescriptor::isValid() const
    {21, 244, 0, 0, Smoke::mf_const, 198, 6},	//433 QDBusUnixFileDescriptor::fileDescriptor() const
    {21, 364, 18, 1, 0, 0, 7},	//434 QDBusUnixFileDescriptor::setFileDescriptor(int)
    {21, 251, 18, 1, 0, 0, 8},	//435 QDBusUnixFileDescriptor::giveFileDescriptor(int)
    {21, 379, 0, 0, 0, 198, 9},	//436 QDBusUnixFileDescriptor::takeFileDescriptor()
    {21, 273, 0, 0, Smoke::mf_static, 157, 10},	//437 QDBusUnixFileDescriptor::isSupported()
    {21, 415, 0, 0, Smoke::mf_dtor, 0, 11 },	//438 QDBusUnixFileDescriptor::~QDBusUnixFileDescriptor()
    {23, 281, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 180, 1},	//439 QDBusVirtualObject::metaObject() const
    {23, 316, 1, 1, Smoke::mf_virtual, 216, 2},	//440 QDBusVirtualObject::qt_metacast(const char*)
    {23, 382, 3, 2, Smoke::mf_static, 74, 3},	//441 QDBusVirtualObject::tr(const char*, const char*)
    {23, 386, 3, 2, Smoke::mf_static, 74, 4},	//442 QDBusVirtualObject::trUtf8(const char*, const char*)
    {23, 382, 6, 3, Smoke::mf_static, 74, 5},	//443 QDBusVirtualObject::tr(const char*, const char*, int)
    {23, 386, 6, 3, Smoke::mf_static, 74, 6},	//444 QDBusVirtualObject::trUtf8(const char*, const char*, int)
    {23, 314, 10, 3, Smoke::mf_virtual, 198, 7},	//445 QDBusVirtualObject::qt_metacall(QMetaObject::Call, int, void**)
    {23, 100, 14, 1, Smoke::mf_ctor, 52, 8},	//446 QDBusVirtualObject::QDBusVirtualObject(QObject*)
    {23, 264, 68, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 74, 9},	//447 QDBusVirtualObject::introspect(const QString&) const [pure virtual]
    {23, 253, 391, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 157, 10},	//448 QDBusVirtualObject::handleMessage(const QDBusMessage&, const QDBusConnection&) [pure virtual]
    {23, 382, 1, 1, Smoke::mf_static, 74, 11},	//449 QDBusVirtualObject::tr(const char*)
    {23, 386, 1, 1, Smoke::mf_static, 74, 12},	//450 QDBusVirtualObject::trUtf8(const char*)
    {23, 100, 0, 0, Smoke::mf_ctor, 52, 13},	//451 QDBusVirtualObject::QDBusVirtualObject()
    {23, 377, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 179, 14},	//452 QDBusVirtualObject::staticMetaObject() const
    {23, 416, 0, 0, Smoke::mf_dtor, 0, 15 },	//453 QDBusVirtualObject::~QDBusVirtualObject()
    {28, 291, 394, 2, Smoke::mf_static, 8, 1},	//454 QGlobalSpace::operator<<(QDBusArgument&, const QPointF&)
    {28, 291, 397, 2, Smoke::mf_static, 8, 2},	//455 QGlobalSpace::operator<<(QDBusArgument&, const QLineF&)
    {28, 291, 400, 2, Smoke::mf_static, 8, 3},	//456 QGlobalSpace::operator<<(QDBusArgument&, const QDateTime&)
    {28, 291, 403, 2, Smoke::mf_static, 8, 4},	//457 QGlobalSpace::operator<<(QDBusArgument&, const QRectF&)
    {28, 307, 406, 2, Smoke::mf_static, 60, 5},	//458 QGlobalSpace::operator|(QDBusServiceWatcher::WatchModeFlag, QDBusServiceWatcher::WatchModeFlag)
    {28, 291, 409, 2, Smoke::mf_static, 8, 6},	//459 QGlobalSpace::operator<<(QDBusArgument&, const QMap<QString,QVariant>&)
    {28, 289, 412, 2, Smoke::mf_static, 157, 7},	//460 QGlobalSpace::operator<(const QDBusSignature&, const QDBusSignature&)
    {28, 307, 415, 2, Smoke::mf_static, 59, 8},	//461 QGlobalSpace::operator|(QDBusConnection::VirtualObjectRegisterOption, QFlags<QDBusConnection::VirtualObjectRegisterOption>)
    {28, 302, 418, 2, Smoke::mf_static, 161, 9},	//462 QGlobalSpace::operator>>(const QDBusArgument&, QTime&)
    {28, 291, 421, 2, Smoke::mf_static, 8, 10},	//463 QGlobalSpace::operator<<(QDBusArgument&, const QSize&)
    {28, 287, 412, 2, Smoke::mf_static, 157, 11},	//464 QGlobalSpace::operator!=(const QDBusSignature&, const QDBusSignature&)
    {28, 312, 184, 1, Smoke::mf_static, 208, 12},	//465 QGlobalSpace::qHash(const QDBusSignature&)
    {28, 307, 424, 2, Smoke::mf_static, 59, 13},	//466 QGlobalSpace::operator|(QDBusConnection::VirtualObjectRegisterOption, QDBusConnection::VirtualObjectRegisterOption)
    {28, 302, 427, 2, Smoke::mf_static, 161, 14},	//467 QGlobalSpace::operator>>(const QDBusArgument&, QDateTime&)
    {28, 302, 430, 2, Smoke::mf_static, 161, 15},	//468 QGlobalSpace::operator>>(const QDBusArgument&, QLine&)
    {28, 307, 433, 2, Smoke::mf_static, 58, 16},	//469 QGlobalSpace::operator|(QDBusConnection::RegisterOption, QDBusConnection::RegisterOption)
    {28, 289, 436, 2, Smoke::mf_static, 157, 17},	//470 QGlobalSpace::operator<(const QDBusObjectPath&, const QDBusObjectPath&)
    {28, 302, 439, 2, Smoke::mf_static, 161, 18},	//471 QGlobalSpace::operator>>(const QDBusArgument&, QRect&)
    {28, 302, 442, 2, Smoke::mf_static, 161, 19},	//472 QGlobalSpace::operator>>(const QDBusArgument&, QRectF&)
    {28, 307, 445, 2, Smoke::mf_static, 61, 20},	//473 QGlobalSpace::operator|(QDBusConnection::VirtualObjectRegisterOption, int)
    {28, 310, 448, 3, Smoke::mf_static, 0, 21},	//474 QGlobalSpace::qDBusReplyFill(const QDBusMessage&, QDBusError&, QVariant&)
    {28, 302, 452, 2, Smoke::mf_static, 161, 22},	//475 QGlobalSpace::operator>>(const QDBusArgument&, QSizeF&)
    {28, 302, 455, 2, Smoke::mf_static, 161, 23},	//476 QGlobalSpace::operator>>(const QDBusArgument&, QLineF&)
    {28, 307, 458, 2, Smoke::mf_static, 61, 24},	//477 QGlobalSpace::operator|(QDBusConnection::RegisterOption, int)
    {28, 291, 461, 2, Smoke::mf_static, 55, 25},	//478 QGlobalSpace::operator<<(QDebug, const QDBusMessage&)
    {28, 307, 464, 2, Smoke::mf_static, 60, 26},	//479 QGlobalSpace::operator|(QDBusServiceWatcher::WatchModeFlag, QFlags<QDBusServiceWatcher::WatchModeFlag>)
    {28, 302, 467, 2, Smoke::mf_static, 161, 27},	//480 QGlobalSpace::operator>>(const QDBusArgument&, QVariant&)
    {28, 302, 470, 2, Smoke::mf_static, 161, 28},	//481 QGlobalSpace::operator>>(const QDBusArgument&, QPointF&)
    {28, 307, 473, 2, Smoke::mf_static, 58, 29},	//482 QGlobalSpace::operator|(QDBusConnection::RegisterOption, QFlags<QDBusConnection::RegisterOption>)
    {28, 291, 476, 2, Smoke::mf_static, 8, 30},	//483 QGlobalSpace::operator<<(QDBusArgument&, const QPoint&)
    {28, 299, 436, 2, Smoke::mf_static, 157, 31},	//484 QGlobalSpace::operator==(const QDBusObjectPath&, const QDBusObjectPath&)
    {28, 302, 479, 2, Smoke::mf_static, 161, 32},	//485 QGlobalSpace::operator>>(const QDBusArgument&, QPoint&)
    {28, 291, 482, 2, Smoke::mf_static, 8, 33},	//486 QGlobalSpace::operator<<(QDBusArgument&, const QTime&)
    {28, 291, 485, 2, Smoke::mf_static, 8, 34},	//487 QGlobalSpace::operator<<(QDBusArgument&, const QRect&)
    {28, 302, 488, 2, Smoke::mf_static, 161, 35},	//488 QGlobalSpace::operator>>(const QDBusArgument&, QSize&)
    {28, 302, 491, 2, Smoke::mf_static, 161, 36},	//489 QGlobalSpace::operator>>(const QDBusArgument&, QDate&)
    {28, 291, 494, 2, Smoke::mf_static, 8, 37},	//490 QGlobalSpace::operator<<(QDBusArgument&, const QDate&)
    {28, 291, 497, 2, Smoke::mf_static, 8, 38},	//491 QGlobalSpace::operator<<(QDBusArgument&, const QList<QVariant>&)
    {28, 291, 500, 2, Smoke::mf_static, 8, 39},	//492 QGlobalSpace::operator<<(QDBusArgument&, const QHash<QString,QVariant>&)
    {28, 291, 503, 2, Smoke::mf_static, 55, 40},	//493 QGlobalSpace::operator<<(QDebug, const QDBusError&)
    {28, 299, 506, 2, Smoke::mf_static, 157, 41},	//494 QGlobalSpace::operator==(const QDBusVariant&, const QDBusVariant&)
    {28, 291, 509, 2, Smoke::mf_static, 8, 42},	//495 QGlobalSpace::operator<<(QDBusArgument&, const QSizeF&)
    {28, 287, 436, 2, Smoke::mf_static, 157, 43},	//496 QGlobalSpace::operator!=(const QDBusObjectPath&, const QDBusObjectPath&)
    {28, 307, 512, 2, Smoke::mf_static, 61, 44},	//497 QGlobalSpace::operator|(QDBusServiceWatcher::WatchModeFlag, int)
    {28, 291, 515, 2, Smoke::mf_static, 8, 45},	//498 QGlobalSpace::operator<<(QDBusArgument&, const QLine&)
    {28, 312, 182, 1, Smoke::mf_static, 208, 46},	//499 QGlobalSpace::qHash(const QDBusObjectPath&)
    {28, 299, 412, 2, Smoke::mf_static, 157, 47},	//500 QGlobalSpace::operator==(const QDBusSignature&, const QDBusSignature&)
    {33, 281, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 180, 0},	//501 QObject::metaObject() const
    {33, 316, 1, 1, Smoke::mf_virtual, 216, 0},	//502 QObject::qt_metacast(const char*)
    {33, 242, 518, 1, Smoke::mf_virtual, 157, 0},	//503 QObject::event(QEvent*)
    {33, 243, 520, 2, Smoke::mf_virtual, 157, 0},	//504 QObject::eventFilter(QObject*, QEvent*)
    {33, 381, 523, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//505 QObject::timerEvent(QTimerEvent*)
    {33, 192, 525, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//506 QObject::childEvent(QChildEvent*)
    {33, 220, 518, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//507 QObject::customEvent(QEvent*)
    {33, 197, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//508 QObject::connectNotify(const char*)
    {33, 231, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//509 QObject::disconnectNotify(const char*)
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    152,  // QDBusConnection::callWithCallback(const QDBusMessage&, QObject*, const char*, int) const
    178,  // QDBusConnection::callWithCallback(const QDBusMessage&, QObject*, const char*, const char*) const
    0,
    169,  // QDBusConnection::connectToBus(QDBusConnection::BusType, const QString&)
    170,  // QDBusConnection::connectToBus(const QString&, const QString&)
    0,
    315,  // QDBusMessage::createError(const QString&, const QString&)
    317,  // QDBusMessage::createError(QDBusError::ErrorType, const QString&)
    0,
    320,  // QDBusMessage::createErrorReply(const QString, const QString&) const
    322,  // QDBusMessage::createErrorReply(QDBusError::ErrorType, const QString&) const
    0,
    103,  // QDBusArgument::beginMapEntry()
    130,  // QDBusArgument::beginMapEntry() const
    0,
    97,  // QDBusArgument::beginStructure()
    124,  // QDBusArgument::beginStructure() const
    0,
    100,  // QDBusArgument::endArray()
    127,  // QDBusArgument::endArray() const
    0,
    102,  // QDBusArgument::endMap()
    129,  // QDBusArgument::endMap() const
    0,
    104,  // QDBusArgument::endMapEntry()
    131,  // QDBusArgument::endMapEntry() const
    0,
    98,  // QDBusArgument::endStructure()
    125,  // QDBusArgument::endStructure() const
    0,
    91,  // QDBusArgument::operator<<(const QDBusVariant&)
    94,  // QDBusArgument::operator<<(const QDBusUnixFileDescriptor&)
    96,  // QDBusArgument::operator<<(const QByteArray&)
    0,
    81,  // QDBusArgument::operator<<(unsigned char)
    82,  // QDBusArgument::operator<<(bool)
    83,  // QDBusArgument::operator<<(short)
    84,  // QDBusArgument::operator<<(unsigned short)
    85,  // QDBusArgument::operator<<(int)
    86,  // QDBusArgument::operator<<(unsigned int)
    87,  // QDBusArgument::operator<<(long long)
    88,  // QDBusArgument::operator<<(unsigned long long)
    89,  // QDBusArgument::operator<<(double)
    90,  // QDBusArgument::operator<<(const QString&)
    92,  // QDBusArgument::operator<<(const QDBusObjectPath&)
    93,  // QDBusArgument::operator<<(const QDBusSignature&)
    0,
    118,  // QDBusArgument::operator>>(QDBusVariant&) const
    121,  // QDBusArgument::operator>>(QDBusUnixFileDescriptor&) const
    123,  // QDBusArgument::operator>>(QByteArray&) const
    0,
    108,  // QDBusArgument::operator>>(unsigned char&) const
    109,  // QDBusArgument::operator>>(bool&) const
    110,  // QDBusArgument::operator>>(short&) const
    111,  // QDBusArgument::operator>>(unsigned short&) const
    112,  // QDBusArgument::operator>>(int&) const
    113,  // QDBusArgument::operator>>(unsigned int&) const
    114,  // QDBusArgument::operator>>(long long&) const
    115,  // QDBusArgument::operator>>(unsigned long long&) const
    116,  // QDBusArgument::operator>>(double&) const
    117,  // QDBusArgument::operator>>(QString&) const
    119,  // QDBusArgument::operator>>(QDBusObjectPath&) const
    120,  // QDBusArgument::operator>>(QDBusSignature&) const
    0,
    464,  // QGlobalSpace::operator!=(const QDBusSignature&, const QDBusSignature&)
    496,  // QGlobalSpace::operator!=(const QDBusObjectPath&, const QDBusObjectPath&)
    0,
    460,  // QGlobalSpace::operator<(const QDBusSignature&, const QDBusSignature&)
    470,  // QGlobalSpace::operator<(const QDBusObjectPath&, const QDBusObjectPath&)
    0,
    454,  // QGlobalSpace::operator<<(QDBusArgument&, const QPointF&)
    455,  // QGlobalSpace::operator<<(QDBusArgument&, const QLineF&)
    456,  // QGlobalSpace::operator<<(QDBusArgument&, const QDateTime&)
    457,  // QGlobalSpace::operator<<(QDBusArgument&, const QRectF&)
    463,  // QGlobalSpace::operator<<(QDBusArgument&, const QSize&)
    478,  // QGlobalSpace::operator<<(QDebug, const QDBusMessage&)
    483,  // QGlobalSpace::operator<<(QDBusArgument&, const QPoint&)
    486,  // QGlobalSpace::operator<<(QDBusArgument&, const QTime&)
    487,  // QGlobalSpace::operator<<(QDBusArgument&, const QRect&)
    490,  // QGlobalSpace::operator<<(QDBusArgument&, const QDate&)
    493,  // QGlobalSpace::operator<<(QDebug, const QDBusError&)
    495,  // QGlobalSpace::operator<<(QDBusArgument&, const QSizeF&)
    498,  // QGlobalSpace::operator<<(QDBusArgument&, const QLine&)
    0,
    459,  // QGlobalSpace::operator<<(QDBusArgument&, const QMap<QString,QVariant>&)
    491,  // QGlobalSpace::operator<<(QDBusArgument&, const QList<QVariant>&)
    492,  // QGlobalSpace::operator<<(QDBusArgument&, const QHash<QString,QVariant>&)
    0,
    484,  // QGlobalSpace::operator==(const QDBusObjectPath&, const QDBusObjectPath&)
    500,  // QGlobalSpace::operator==(const QDBusSignature&, const QDBusSignature&)
    0,
    462,  // QGlobalSpace::operator>>(const QDBusArgument&, QTime&)
    467,  // QGlobalSpace::operator>>(const QDBusArgument&, QDateTime&)
    468,  // QGlobalSpace::operator>>(const QDBusArgument&, QLine&)
    471,  // QGlobalSpace::operator>>(const QDBusArgument&, QRect&)
    472,  // QGlobalSpace::operator>>(const QDBusArgument&, QRectF&)
    475,  // QGlobalSpace::operator>>(const QDBusArgument&, QSizeF&)
    476,  // QGlobalSpace::operator>>(const QDBusArgument&, QLineF&)
    480,  // QGlobalSpace::operator>>(const QDBusArgument&, QVariant&)
    481,  // QGlobalSpace::operator>>(const QDBusArgument&, QPointF&)
    485,  // QGlobalSpace::operator>>(const QDBusArgument&, QPoint&)
    488,  // QGlobalSpace::operator>>(const QDBusArgument&, QSize&)
    489,  // QGlobalSpace::operator>>(const QDBusArgument&, QDate&)
    0,
    458,  // QGlobalSpace::operator|(QDBusServiceWatcher::WatchModeFlag, QDBusServiceWatcher::WatchModeFlag)
    461,  // QGlobalSpace::operator|(QDBusConnection::VirtualObjectRegisterOption, QFlags<QDBusConnection::VirtualObjectRegisterOption>)
    466,  // QGlobalSpace::operator|(QDBusConnection::VirtualObjectRegisterOption, QDBusConnection::VirtualObjectRegisterOption)
    469,  // QGlobalSpace::operator|(QDBusConnection::RegisterOption, QDBusConnection::RegisterOption)
    473,  // QGlobalSpace::operator|(QDBusConnection::VirtualObjectRegisterOption, int)
    477,  // QGlobalSpace::operator|(QDBusConnection::RegisterOption, int)
    479,  // QGlobalSpace::operator|(QDBusServiceWatcher::WatchModeFlag, QFlags<QDBusServiceWatcher::WatchModeFlag>)
    482,  // QGlobalSpace::operator|(QDBusConnection::RegisterOption, QFlags<QDBusConnection::RegisterOption>)
    497,  // QGlobalSpace::operator|(QDBusServiceWatcher::WatchModeFlag, int)
    0,
    465,  // QGlobalSpace::qHash(const QDBusSignature&)
    499,  // QGlobalSpace::qHash(const QDBusObjectPath&)
    0,
    260,  // QDBusContext::sendErrorReply(const QString&) const
    261,  // QDBusContext::sendErrorReply(QDBusError::ErrorType) const
    0,
    257,  // QDBusContext::sendErrorReply(const QString&, const QString&) const
    258,  // QDBusContext::sendErrorReply(QDBusError::ErrorType, const QString&) const
    0,
    263,  // QDBusError::QDBusError(const DBusError*)
    264,  // QDBusError::QDBusError(const QDBusMessage&)
    266,  // QDBusError::QDBusError(const QDBusError&)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {5, 6, 4},	// QDBus::AutoDetect
    {5, 9, 2},	// QDBus::Block
    {5, 10, 3},	// QDBus::BlockWithGui
    {5, 53, 1},	// QDBus::NoBlock
    {6, 62, 12},	// QDBusAbstractAdaptor::QDBusAbstractAdaptor#
    {6, 150, 14},	// QDBusAbstractAdaptor::autoRelaySignals
    {6, 281, 5},	// QDBusAbstractAdaptor::metaObject
    {6, 315, 11},	// QDBusAbstractAdaptor::qt_metacall$$?
    {6, 317, 6},	// QDBusAbstractAdaptor::qt_metacast$
    {6, 357, 13},	// QDBusAbstractAdaptor::setAutoRelaySignals$
    {6, 377, 17},	// QDBusAbstractAdaptor::staticMetaObject
    {6, 383, 15},	// QDBusAbstractAdaptor::tr$
    {6, 384, 7},	// QDBusAbstractAdaptor::tr$$
    {6, 385, 9},	// QDBusAbstractAdaptor::tr$$$
    {6, 387, 16},	// QDBusAbstractAdaptor::trUtf8$
    {6, 388, 8},	// QDBusAbstractAdaptor::trUtf8$$
    {6, 389, 10},	// QDBusAbstractAdaptor::trUtf8$$$
    {6, 401, 18},	// QDBusAbstractAdaptor::~QDBusAbstractAdaptor
    {7, 64, 41},	// QDBusAbstractInterface::QDBusAbstractInterface$$$##
    {7, 138, 65},	// QDBusAbstractInterface::asyncCall$
    {7, 139, 66},	// QDBusAbstractInterface::asyncCall$#
    {7, 140, 67},	// QDBusAbstractInterface::asyncCall$##
    {7, 141, 68},	// QDBusAbstractInterface::asyncCall$###
    {7, 142, 69},	// QDBusAbstractInterface::asyncCall$####
    {7, 143, 70},	// QDBusAbstractInterface::asyncCall$#####
    {7, 144, 71},	// QDBusAbstractInterface::asyncCall$######
    {7, 145, 72},	// QDBusAbstractInterface::asyncCall$#######
    {7, 146, 39},	// QDBusAbstractInterface::asyncCall$########
    {7, 148, 40},	// QDBusAbstractInterface::asyncCallWithArgumentList$?
    {7, 163, 49},	// QDBusAbstractInterface::call$
    {7, 164, 50},	// QDBusAbstractInterface::call$#
    {7, 165, 51},	// QDBusAbstractInterface::call$##
    {7, 166, 52},	// QDBusAbstractInterface::call$###
    {7, 167, 53},	// QDBusAbstractInterface::call$####
    {7, 168, 54},	// QDBusAbstractInterface::call$#####
    {7, 169, 55},	// QDBusAbstractInterface::call$######
    {7, 170, 56},	// QDBusAbstractInterface::call$#######
    {7, 171, 34},	// QDBusAbstractInterface::call$########
    {7, 172, 57},	// QDBusAbstractInterface::call$$
    {7, 173, 58},	// QDBusAbstractInterface::call$$#
    {7, 174, 59},	// QDBusAbstractInterface::call$$##
    {7, 175, 60},	// QDBusAbstractInterface::call$$###
    {7, 176, 61},	// QDBusAbstractInterface::call$$####
    {7, 177, 62},	// QDBusAbstractInterface::call$$#####
    {7, 178, 63},	// QDBusAbstractInterface::call$$######
    {7, 179, 64},	// QDBusAbstractInterface::call$$#######
    {7, 180, 35},	// QDBusAbstractInterface::call$$########
    {7, 182, 36},	// QDBusAbstractInterface::callWithArgumentList$$?
    {7, 187, 38},	// QDBusAbstractInterface::callWithCallback$?#$
    {7, 188, 37},	// QDBusAbstractInterface::callWithCallback$?#$$
    {7, 198, 42},	// QDBusAbstractInterface::connectNotify$
    {7, 203, 27},	// QDBusAbstractInterface::connection
    {7, 232, 43},	// QDBusAbstractInterface::disconnectNotify$
    {7, 255, 30},	// QDBusAbstractInterface::interface
    {7, 257, 73},	// QDBusAbstractInterface::internalConstCall$$
    {7, 258, 46},	// QDBusAbstractInterface::internalConstCall$$?
    {7, 261, 44},	// QDBusAbstractInterface::internalPropGet$
    {7, 263, 45},	// QDBusAbstractInterface::internalPropSet$#
    {7, 274, 26},	// QDBusAbstractInterface::isValid
    {7, 275, 31},	// QDBusAbstractInterface::lastError
    {7, 281, 19},	// QDBusAbstractInterface::metaObject
    {7, 309, 29},	// QDBusAbstractInterface::path
    {7, 315, 25},	// QDBusAbstractInterface::qt_metacall$$?
    {7, 317, 20},	// QDBusAbstractInterface::qt_metacast$
    {7, 340, 28},	// QDBusAbstractInterface::service
    {7, 367, 32},	// QDBusAbstractInterface::setTimeout$
    {7, 377, 74},	// QDBusAbstractInterface::staticMetaObject
    {7, 380, 33},	// QDBusAbstractInterface::timeout
    {7, 383, 47},	// QDBusAbstractInterface::tr$
    {7, 384, 21},	// QDBusAbstractInterface::tr$$
    {7, 385, 23},	// QDBusAbstractInterface::tr$$$
    {7, 387, 48},	// QDBusAbstractInterface::trUtf8$
    {7, 388, 22},	// QDBusAbstractInterface::trUtf8$$
    {7, 389, 24},	// QDBusAbstractInterface::trUtf8$$$
    {7, 402, 75},	// QDBusAbstractInterface::~QDBusAbstractInterface
    {8, 315, 76},	// QDBusAbstractInterfaceBase::qt_metacall$$?
    {8, 403, 77},	// QDBusAbstractInterfaceBase::~QDBusAbstractInterfaceBase
    {9, 5, 136},	// QDBusArgument::ArrayType
    {9, 8, 134},	// QDBusArgument::BasicType
    {9, 44, 139},	// QDBusArgument::MapEntryType
    {9, 45, 138},	// QDBusArgument::MapType
    {9, 65, 78},	// QDBusArgument::QDBusArgument
    {9, 66, 79},	// QDBusArgument::QDBusArgument#
    {9, 112, 137},	// QDBusArgument::StructureType
    {9, 121, 140},	// QDBusArgument::UnknownType
    {9, 124, 135},	// QDBusArgument::VariantType
    {9, 132, 105},	// QDBusArgument::appendVariant#
    {9, 134, 133},	// QDBusArgument::asVariant
    {9, 149, 132},	// QDBusArgument::atEnd
    {9, 153, 126},	// QDBusArgument::beginArray
    {9, 154, 99},	// QDBusArgument::beginArray$
    {9, 155, 128},	// QDBusArgument::beginMap
    {9, 156, 101},	// QDBusArgument::beginMap$$
    {9, 157, -13},	// QDBusArgument::beginMapEntry
    {9, 158, -16},	// QDBusArgument::beginStructure
    {9, 218, 106},	// QDBusArgument::currentSignature
    {9, 219, 107},	// QDBusArgument::currentType
    {9, 233, -19},	// QDBusArgument::endArray
    {9, 234, -22},	// QDBusArgument::endMap
    {9, 235, -25},	// QDBusArgument::endMapEntry
    {9, 236, -28},	// QDBusArgument::endStructure
    {9, 292, -31},	// QDBusArgument::operator<<#
    {9, 295, -35},	// QDBusArgument::operator<<$
    {9, 296, 95},	// QDBusArgument::operator<<?
    {9, 298, 80},	// QDBusArgument::operator=#
    {9, 303, -48},	// QDBusArgument::operator>>#
    {9, 305, -52},	// QDBusArgument::operator>>$
    {9, 306, 122},	// QDBusArgument::operator>>?
    {9, 404, 141},	// QDBusArgument::~QDBusArgument
    {10, 2, 189},	// QDBusConnection::ActivationBus
    {10, 15, 190},	// QDBusConnection::ExportAdaptors
    {10, 16, 205},	// QDBusConnection::ExportAllContents
    {10, 17, 204},	// QDBusConnection::ExportAllInvokables
    {10, 18, 203},	// QDBusConnection::ExportAllProperties
    {10, 19, 206},	// QDBusConnection::ExportAllSignal
    {10, 20, 202},	// QDBusConnection::ExportAllSignals
    {10, 21, 201},	// QDBusConnection::ExportAllSlots
    {10, 22, 207},	// QDBusConnection::ExportChildObjects
    {10, 23, 200},	// QDBusConnection::ExportNonScriptableContents
    {10, 24, 199},	// QDBusConnection::ExportNonScriptableInvokables
    {10, 25, 198},	// QDBusConnection::ExportNonScriptableProperties
    {10, 26, 197},	// QDBusConnection::ExportNonScriptableSignals
    {10, 27, 196},	// QDBusConnection::ExportNonScriptableSlots
    {10, 28, 195},	// QDBusConnection::ExportScriptableContents
    {10, 29, 194},	// QDBusConnection::ExportScriptableInvokables
    {10, 30, 193},	// QDBusConnection::ExportScriptableProperties
    {10, 31, 192},	// QDBusConnection::ExportScriptableSignals
    {10, 32, 191},	// QDBusConnection::ExportScriptableSlots
    {10, 68, 143},	// QDBusConnection::QDBusConnection#
    {10, 69, 142},	// QDBusConnection::QDBusConnection$
    {10, 109, 187},	// QDBusConnection::SessionBus
    {10, 111, 210},	// QDBusConnection::SingleNode
    {10, 113, 211},	// QDBusConnection::SubPath
    {10, 114, 188},	// QDBusConnection::SystemBus
    {10, 117, 212},	// QDBusConnection::UnixFileDescriptorPassing
    {10, 122, 208},	// QDBusConnection::UnregisterNode
    {10, 123, 209},	// QDBusConnection::UnregisterTree
    {10, 136, 182},	// QDBusConnection::asyncCall#
    {10, 137, 154},	// QDBusConnection::asyncCall#$
    {10, 152, 146},	// QDBusConnection::baseService
    {10, 160, 180},	// QDBusConnection::call#
    {10, 161, 181},	// QDBusConnection::call#$
    {10, 162, 153},	// QDBusConnection::call#$$
    {10, 184, 179},	// QDBusConnection::callWithCallback##$
    {10, 185, -1},	// QDBusConnection::callWithCallback##$$
    {10, 186, 151},	// QDBusConnection::callWithCallback##$$$
    {10, 194, 155},	// QDBusConnection::connect$$$$#$
    {10, 195, 156},	// QDBusConnection::connect$$$$$#$
    {10, 196, 157},	// QDBusConnection::connect$$$$?$#$
    {10, 200, -4},	// QDBusConnection::connectToBus$$
    {10, 202, 171},	// QDBusConnection::connectToPeer$$
    {10, 204, 149},	// QDBusConnection::connectionCapabilities
    {10, 224, 158},	// QDBusConnection::disconnect$$$$#$
    {10, 225, 159},	// QDBusConnection::disconnect$$$$$#$
    {10, 226, 160},	// QDBusConnection::disconnect$$$$?$#$
    {10, 228, 172},	// QDBusConnection::disconnectFromBus$
    {10, 230, 173},	// QDBusConnection::disconnectFromPeer$
    {10, 255, 167},	// QDBusConnection::interface
    {10, 259, 168},	// QDBusConnection::internalPointer
    {10, 266, 145},	// QDBusConnection::isConnected
    {10, 275, 147},	// QDBusConnection::lastError
    {10, 276, 174},	// QDBusConnection::localMachineId
    {10, 282, 148},	// QDBusConnection::name
    {10, 286, 163},	// QDBusConnection::objectRegisteredAt$
    {10, 298, 144},	// QDBusConnection::operator=#
    {10, 321, 183},	// QDBusConnection::registerObject$#
    {10, 322, 161},	// QDBusConnection::registerObject$#$
    {10, 324, 165},	// QDBusConnection::registerService$
    {10, 328, 185},	// QDBusConnection::registerVirtualObject$#
    {10, 329, 164},	// QDBusConnection::registerVirtualObject$#$
    {10, 335, 150},	// QDBusConnection::send#
    {10, 339, 177},	// QDBusConnection::sender
    {10, 353, 175},	// QDBusConnection::sessionBus
    {10, 377, 186},	// QDBusConnection::staticMetaObject
    {10, 378, 176},	// QDBusConnection::systemBus
    {10, 394, 184},	// QDBusConnection::unregisterObject$
    {10, 395, 162},	// QDBusConnection::unregisterObject$$
    {10, 397, 166},	// QDBusConnection::unregisterService$
    {10, 405, 213},	// QDBusConnection::~QDBusConnection
    {11, 4, 247},	// QDBusConnectionInterface::AllowReplacement
    {11, 12, 246},	// QDBusConnectionInterface::DontAllowReplacement
    {11, 13, 243},	// QDBusConnectionInterface::DontQueueService
    {11, 48, 233},	// QDBusConnectionInterface::NameAcquired$
    {11, 50, 234},	// QDBusConnectionInterface::NameLost$
    {11, 52, 235},	// QDBusConnectionInterface::NameOwnerChanged$$$
    {11, 102, 244},	// QDBusConnectionInterface::QueueService
    {11, 103, 245},	// QDBusConnectionInterface::ReplaceExistingService
    {11, 105, 248},	// QDBusConnectionInterface::ServiceNotRegistered
    {11, 106, 250},	// QDBusConnectionInterface::ServiceQueued
    {11, 107, 249},	// QDBusConnectionInterface::ServiceRegistered
    {11, 190, 232},	// QDBusConnectionInterface::callWithCallbackFailed##
    {11, 198, 236},	// QDBusConnectionInterface::connectNotify$
    {11, 232, 237},	// QDBusConnectionInterface::disconnectNotify$
    {11, 272, 222},	// QDBusConnectionInterface::isServiceRegistered$
    {11, 281, 214},	// QDBusConnectionInterface::metaObject
    {11, 315, 220},	// QDBusConnectionInterface::qt_metacall$$?
    {11, 317, 215},	// QDBusConnectionInterface::qt_metacast$
    {11, 324, 240},	// QDBusConnectionInterface::registerService$
    {11, 325, 241},	// QDBusConnectionInterface::registerService$$
    {11, 326, 225},	// QDBusConnectionInterface::registerService$$$
    {11, 330, 221},	// QDBusConnectionInterface::registeredServiceNames
    {11, 342, 223},	// QDBusConnectionInterface::serviceOwner$
    {11, 344, 231},	// QDBusConnectionInterface::serviceOwnerChanged$$$
    {11, 346, 226},	// QDBusConnectionInterface::servicePid$
    {11, 348, 229},	// QDBusConnectionInterface::serviceRegistered$
    {11, 350, 227},	// QDBusConnectionInterface::serviceUid$
    {11, 352, 230},	// QDBusConnectionInterface::serviceUnregistered$
    {11, 376, 228},	// QDBusConnectionInterface::startService$
    {11, 377, 242},	// QDBusConnectionInterface::staticMetaObject
    {11, 383, 238},	// QDBusConnectionInterface::tr$
    {11, 384, 216},	// QDBusConnectionInterface::tr$$
    {11, 385, 218},	// QDBusConnectionInterface::tr$$$
    {11, 387, 239},	// QDBusConnectionInterface::trUtf8$
    {11, 388, 217},	// QDBusConnectionInterface::trUtf8$$
    {11, 389, 219},	// QDBusConnectionInterface::trUtf8$$$
    {11, 397, 224},	// QDBusConnectionInterface::unregisterService$
    {12, 70, 251},	// QDBusContext::QDBusContext
    {12, 71, 259},	// QDBusContext::QDBusContext#
    {12, 191, 252},	// QDBusContext::calledFromDBus
    {12, 203, 253},	// QDBusContext::connection
    {12, 267, 255},	// QDBusContext::isDelayedReply
    {12, 280, 254},	// QDBusContext::message
    {12, 337, -118},	// QDBusContext::sendErrorReply$
    {12, 338, -121},	// QDBusContext::sendErrorReply$$
    {12, 363, 256},	// QDBusContext::setDelayedReply$
    {12, 406, 262},	// QDBusContext::~QDBusContext
    {13, 1, 283},	// QDBusError::AccessDenied
    {13, 3, 287},	// QDBusError::AddressInUse
    {13, 7, 280},	// QDBusError::BadAddress
    {13, 11, 288},	// QDBusError::Disconnected
    {13, 33, 276},	// QDBusError::Failed
    {13, 34, 294},	// QDBusError::InternalError
    {13, 35, 289},	// QDBusError::InvalidArgs
    {13, 36, 298},	// QDBusError::InvalidInterface
    {13, 37, 299},	// QDBusError::InvalidMember
    {13, 39, 297},	// QDBusError::InvalidObjectPath
    {13, 40, 296},	// QDBusError::InvalidService
    {13, 41, 292},	// QDBusError::InvalidSignature
    {13, 42, 300},	// QDBusError::LastErrorType
    {13, 43, 282},	// QDBusError::LimitsExceeded
    {13, 54, 274},	// QDBusError::NoError
    {13, 55, 277},	// QDBusError::NoMemory
    {13, 56, 286},	// QDBusError::NoNetwork
    {13, 57, 279},	// QDBusError::NoReply
    {13, 58, 284},	// QDBusError::NoServer
    {13, 59, 281},	// QDBusError::NotSupported
    {13, 60, 275},	// QDBusError::Other
    {13, 72, 273},	// QDBusError::QDBusError
    {13, 73, -124},	// QDBusError::QDBusError#
    {13, 74, 265},	// QDBusError::QDBusError$$
    {13, 108, 278},	// QDBusError::ServiceUnknown
    {13, 115, 291},	// QDBusError::TimedOut
    {13, 116, 285},	// QDBusError::Timeout
    {13, 118, 293},	// QDBusError::UnknownInterface
    {13, 119, 290},	// QDBusError::UnknownMethod
    {13, 120, 295},	// QDBusError::UnknownObject
    {13, 241, 272},	// QDBusError::errorString$
    {13, 274, 271},	// QDBusError::isValid
    {13, 280, 270},	// QDBusError::message
    {13, 282, 269},	// QDBusError::name
    {13, 298, 267},	// QDBusError::operator=#
    {13, 390, 268},	// QDBusError::type
    {13, 407, 301},	// QDBusError::~QDBusError
    {14, 76, 306},	// QDBusInterface::QDBusInterface$$
    {14, 77, 307},	// QDBusInterface::QDBusInterface$$$
    {14, 78, 308},	// QDBusInterface::QDBusInterface$$$#
    {14, 79, 302},	// QDBusInterface::QDBusInterface$$$##
    {14, 281, 303},	// QDBusInterface::metaObject
    {14, 315, 305},	// QDBusInterface::qt_metacall$$?
    {14, 317, 304},	// QDBusInterface::qt_metacast$
    {14, 408, 309},	// QDBusInterface::~QDBusInterface
    {15, 14, 343},	// QDBusMessage::ErrorMessage
    {15, 38, 340},	// QDBusMessage::InvalidMessage
    {15, 46, 341},	// QDBusMessage::MethodCallMessage
    {15, 80, 310},	// QDBusMessage::QDBusMessage
    {15, 81, 311},	// QDBusMessage::QDBusMessage#
    {15, 104, 342},	// QDBusMessage::ReplyMessage
    {15, 110, 344},	// QDBusMessage::SignalMessage
    {15, 133, 337},	// QDBusMessage::arguments
    {15, 151, 335},	// QDBusMessage::autoStartService
    {15, 206, 316},	// QDBusMessage::createError#
    {15, 207, -7},	// QDBusMessage::createError$$
    {15, 209, 321},	// QDBusMessage::createErrorReply#
    {15, 210, -10},	// QDBusMessage::createErrorReply$$
    {15, 212, 314},	// QDBusMessage::createMethodCall$$$$
    {15, 213, 339},	// QDBusMessage::createReply
    {15, 214, 319},	// QDBusMessage::createReply#
    {15, 215, 318},	// QDBusMessage::createReply?
    {15, 217, 313},	// QDBusMessage::createSignal$$$
    {15, 238, 328},	// QDBusMessage::errorMessage
    {15, 239, 327},	// QDBusMessage::errorName
    {15, 255, 325},	// QDBusMessage::interface
    {15, 267, 333},	// QDBusMessage::isDelayedReply
    {15, 270, 331},	// QDBusMessage::isReplyRequired
    {15, 279, 326},	// QDBusMessage::member
    {15, 292, 338},	// QDBusMessage::operator<<#
    {15, 298, 312},	// QDBusMessage::operator=#
    {15, 309, 324},	// QDBusMessage::path
    {15, 340, 323},	// QDBusMessage::service
    {15, 355, 336},	// QDBusMessage::setArguments?
    {15, 359, 334},	// QDBusMessage::setAutoStartService$
    {15, 363, 332},	// QDBusMessage::setDelayedReply$
    {15, 372, 330},	// QDBusMessage::signature
    {15, 390, 329},	// QDBusMessage::type
    {15, 409, 345},	// QDBusMessage::~QDBusMessage
    {16, 82, 351},	// QDBusMetaType::QDBusMetaType
    {16, 83, 352},	// QDBusMetaType::QDBusMetaType#
    {16, 222, 348},	// QDBusMetaType::demarshall#$$
    {16, 278, 347},	// QDBusMetaType::marshall#$$
    {16, 319, 346},	// QDBusMetaType::registerMarshallOperators$$$
    {16, 374, 349},	// QDBusMetaType::signatureToType$
    {16, 392, 350},	// QDBusMetaType::typeToSignature$
    {16, 410, 353},	// QDBusMetaType::~QDBusMetaType
    {17, 85, 354},	// QDBusPendingCall::QDBusPendingCall#
    {17, 237, 360},	// QDBusPendingCall::error
    {17, 248, 363},	// QDBusPendingCall::fromCompletedCall#
    {17, 250, 362},	// QDBusPendingCall::fromError#
    {17, 268, 358},	// QDBusPendingCall::isError
    {17, 269, 356},	// QDBusPendingCall::isFinished
    {17, 274, 359},	// QDBusPendingCall::isValid
    {17, 298, 355},	// QDBusPendingCall::operator=#
    {17, 333, 361},	// QDBusPendingCall::reply
    {17, 398, 357},	// QDBusPendingCall::waitForFinished
    {17, 411, 364},	// QDBusPendingCall::~QDBusPendingCall
    {18, 87, 377},	// QDBusPendingCallWatcher::QDBusPendingCallWatcher#
    {18, 88, 372},	// QDBusPendingCallWatcher::QDBusPendingCallWatcher##
    {18, 246, 374},	// QDBusPendingCallWatcher::finished#
    {18, 281, 365},	// QDBusPendingCallWatcher::metaObject
    {18, 315, 371},	// QDBusPendingCallWatcher::qt_metacall$$?
    {18, 317, 366},	// QDBusPendingCallWatcher::qt_metacast$
    {18, 377, 378},	// QDBusPendingCallWatcher::staticMetaObject
    {18, 383, 375},	// QDBusPendingCallWatcher::tr$
    {18, 384, 367},	// QDBusPendingCallWatcher::tr$$
    {18, 385, 369},	// QDBusPendingCallWatcher::tr$$$
    {18, 387, 376},	// QDBusPendingCallWatcher::trUtf8$
    {18, 388, 368},	// QDBusPendingCallWatcher::trUtf8$$
    {18, 389, 370},	// QDBusPendingCallWatcher::trUtf8$$$
    {18, 398, 373},	// QDBusPendingCallWatcher::waitForFinished
    {18, 412, 379},	// QDBusPendingCallWatcher::~QDBusPendingCallWatcher
    {19, 89, 394},	// QDBusServer::QDBusServer
    {19, 90, 395},	// QDBusServer::QDBusServer$
    {19, 91, 387},	// QDBusServer::QDBusServer$#
    {19, 130, 390},	// QDBusServer::address
    {19, 266, 388},	// QDBusServer::isConnected
    {19, 275, 389},	// QDBusServer::lastError
    {19, 281, 380},	// QDBusServer::metaObject
    {19, 284, 391},	// QDBusServer::newConnection#
    {19, 315, 386},	// QDBusServer::qt_metacall$$?
    {19, 317, 381},	// QDBusServer::qt_metacast$
    {19, 377, 396},	// QDBusServer::staticMetaObject
    {19, 383, 392},	// QDBusServer::tr$
    {19, 384, 382},	// QDBusServer::tr$$
    {19, 385, 384},	// QDBusServer::tr$$$
    {19, 387, 393},	// QDBusServer::trUtf8$
    {19, 388, 383},	// QDBusServer::trUtf8$$
    {19, 389, 385},	// QDBusServer::trUtf8$$$
    {19, 413, 397},	// QDBusServer::~QDBusServer
    {20, 92, 420},	// QDBusServiceWatcher::QDBusServiceWatcher
    {20, 93, 405},	// QDBusServiceWatcher::QDBusServiceWatcher#
    {20, 94, 421},	// QDBusServiceWatcher::QDBusServiceWatcher$#
    {20, 95, 422},	// QDBusServiceWatcher::QDBusServiceWatcher$#$
    {20, 96, 406},	// QDBusServiceWatcher::QDBusServiceWatcher$#$#
    {20, 125, 426},	// QDBusServiceWatcher::WatchForOwnerChange
    {20, 126, 424},	// QDBusServiceWatcher::WatchForRegistration
    {20, 127, 425},	// QDBusServiceWatcher::WatchForUnregistration
    {20, 129, 409},	// QDBusServiceWatcher::addWatchedService$
    {20, 203, 413},	// QDBusServiceWatcher::connection
    {20, 281, 398},	// QDBusServiceWatcher::metaObject
    {20, 315, 404},	// QDBusServiceWatcher::qt_metacall$$?
    {20, 317, 399},	// QDBusServiceWatcher::qt_metacast$
    {20, 332, 410},	// QDBusServiceWatcher::removeWatchedService$
    {20, 344, 417},	// QDBusServiceWatcher::serviceOwnerChanged$$$
    {20, 348, 415},	// QDBusServiceWatcher::serviceRegistered$
    {20, 352, 416},	// QDBusServiceWatcher::serviceUnregistered$
    {20, 361, 414},	// QDBusServiceWatcher::setConnection#
    {20, 369, 412},	// QDBusServiceWatcher::setWatchMode$
    {20, 371, 408},	// QDBusServiceWatcher::setWatchedServices?
    {20, 377, 423},	// QDBusServiceWatcher::staticMetaObject
    {20, 383, 418},	// QDBusServiceWatcher::tr$
    {20, 384, 400},	// QDBusServiceWatcher::tr$$
    {20, 385, 402},	// QDBusServiceWatcher::tr$$$
    {20, 387, 419},	// QDBusServiceWatcher::trUtf8$
    {20, 388, 401},	// QDBusServiceWatcher::trUtf8$$
    {20, 389, 403},	// QDBusServiceWatcher::trUtf8$$$
    {20, 399, 411},	// QDBusServiceWatcher::watchMode
    {20, 400, 407},	// QDBusServiceWatcher::watchedServices
    {20, 414, 427},	// QDBusServiceWatcher::~QDBusServiceWatcher
    {21, 97, 428},	// QDBusUnixFileDescriptor::QDBusUnixFileDescriptor
    {21, 98, 430},	// QDBusUnixFileDescriptor::QDBusUnixFileDescriptor#
    {21, 99, 429},	// QDBusUnixFileDescriptor::QDBusUnixFileDescriptor$
    {21, 244, 433},	// QDBusUnixFileDescriptor::fileDescriptor
    {21, 252, 435},	// QDBusUnixFileDescriptor::giveFileDescriptor$
    {21, 273, 437},	// QDBusUnixFileDescriptor::isSupported
    {21, 274, 432},	// QDBusUnixFileDescriptor::isValid
    {21, 298, 431},	// QDBusUnixFileDescriptor::operator=#
    {21, 365, 434},	// QDBusUnixFileDescriptor::setFileDescriptor$
    {21, 379, 436},	// QDBusUnixFileDescriptor::takeFileDescriptor
    {21, 415, 438},	// QDBusUnixFileDescriptor::~QDBusUnixFileDescriptor
    {23, 100, 451},	// QDBusVirtualObject::QDBusVirtualObject
    {23, 101, 446},	// QDBusVirtualObject::QDBusVirtualObject#
    {23, 254, 448},	// QDBusVirtualObject::handleMessage##
    {23, 265, 447},	// QDBusVirtualObject::introspect$
    {23, 281, 439},	// QDBusVirtualObject::metaObject
    {23, 315, 445},	// QDBusVirtualObject::qt_metacall$$?
    {23, 317, 440},	// QDBusVirtualObject::qt_metacast$
    {23, 377, 452},	// QDBusVirtualObject::staticMetaObject
    {23, 383, 449},	// QDBusVirtualObject::tr$
    {23, 384, 441},	// QDBusVirtualObject::tr$$
    {23, 385, 443},	// QDBusVirtualObject::tr$$$
    {23, 387, 450},	// QDBusVirtualObject::trUtf8$
    {23, 388, 442},	// QDBusVirtualObject::trUtf8$$
    {23, 389, 444},	// QDBusVirtualObject::trUtf8$$$
    {23, 416, 453},	// QDBusVirtualObject::~QDBusVirtualObject
    {28, 288, -65},	// QGlobalSpace::operator!=$$
    {28, 290, -68},	// QGlobalSpace::operator<$$
    {28, 293, -71},	// QGlobalSpace::operator<<##
    {28, 294, -85},	// QGlobalSpace::operator<<#?
    {28, 300, 494},	// QGlobalSpace::operator==##
    {28, 301, -89},	// QGlobalSpace::operator==$$
    {28, 304, -92},	// QGlobalSpace::operator>>##
    {28, 308, -105},	// QGlobalSpace::operator|$$
    {28, 311, 474},	// QGlobalSpace::qDBusReplyFill###
    {28, 313, -115},	// QGlobalSpace::qHash$
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();

static bool initialized = false;
Smoke *qtdbus_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qtdbus_Smoke() {
    init_qtcore_Smoke();
    if (initialized) return;
    qtdbus_Smoke = new Smoke(
        "qtdbus",
        __smokeqtdbus::classes, 43,
        __smokeqtdbus::methods, 510,
        __smokeqtdbus::methodMaps, 424,
        __smokeqtdbus::methodNames, 416,
        __smokeqtdbus::types, 218,
        __smokeqtdbus::inheritanceList,
        __smokeqtdbus::argumentList,
        __smokeqtdbus::ambiguousMethodList,
        __smokeqtdbus::cast );
    initialized = true;
}

void delete_qtdbus_Smoke() { delete qtdbus_Smoke; }

}
