#include <qimageblitz_includes.h>

#include <smoke.h>
#include <qimageblitz_smoke.h>

namespace __smokeqimageblitz {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //Blitz
      switch(to) {
        case 1: return (void*)(Blitz*)xptr;
        default: return xptr;
      }
    case 2:   //QBool
      switch(to) {
        case 2: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 3:   //QColor
      switch(to) {
        case 3: return (void*)(QColor*)xptr;
        default: return xptr;
      }
    case 5:   //QImage
      switch(to) {
        case 5: return (void*)(QImage*)xptr;
        default: return xptr;
      }
    case 6:   //QIncompatibleFlag
      switch(to) {
        case 6: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 7:   //QRegExp
      switch(to) {
        case 7: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 8:   //QSize
      switch(to) {
        case 8: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
};

// These are the xenum functions for manipulating enum pointers
void xenum_QGlobalSpace(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Blitz(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_Blitz(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "Blitz", false, 0, xcall_Blitz, xenum_Blitz, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Blitz) },	//1
    { "QBool", true, 0, 0, 0, 0, 0 },	//2
    { "QColor", true, 0, 0, 0, 0, 0 },	//3
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, xenum_QGlobalSpace, Smoke::cf_namespace, 0 },	//4
    { "QImage", true, 0, 0, 0, 0, 0 },	//5
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//6
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//7
    { "QSize", true, 0, 0, 0, 0, 0 },	//8
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "Blitz*", 1, Smoke::t_class|Smoke::tf_ptr },	//1
    { "Blitz::EffectQuality", 1, Smoke::t_enum|Smoke::tf_stack },	//2
    { "Blitz::GradientType", 1, Smoke::t_enum|Smoke::tf_stack },	//3
    { "Blitz::ModulationType", 1, Smoke::t_enum|Smoke::tf_stack },	//4
    { "Blitz::RGBChannel", 1, Smoke::t_enum|Smoke::tf_stack },	//5
    { "Blitz::ScaleFilterType", 1, Smoke::t_enum|Smoke::tf_stack },	//6
    { "QBool", 2, Smoke::t_class|Smoke::tf_stack },	//7
    { "QFlags<QtConcurrent::ReduceOptions::enum_type>", 0, Smoke::t_uint|Smoke::tf_stack },	//8
    { "QImage", 5, Smoke::t_class|Smoke::tf_stack },	//9
    { "QImage&", 5, Smoke::t_class|Smoke::tf_ref },	//10
    { "QImage::InvertMode", 5, Smoke::t_enum|Smoke::tf_stack },	//11
    { "QIncompatibleFlag", 6, Smoke::t_class|Smoke::tf_stack },	//12
    { "QRegExp&", 7, Smoke::t_class|Smoke::tf_ref },	//13
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//14
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//15
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//16
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//17
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//18
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//19
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//20
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//21
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//22
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//23
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//24
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//25
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//26
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//27
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//28
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//29
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//30
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//31
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//32
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//33
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//34
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//35
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//36
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//37
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//38
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//39
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//40
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//41
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//42
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//43
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//44
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//45
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//46
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//47
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//48
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//49
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//50
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//51
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//52
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//53
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//54
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//55
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//56
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//57
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//58
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//59
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//60
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//61
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//62
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//63
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//64
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//65
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//66
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//67
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//68
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//69
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//70
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//71
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//72
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//73
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//74
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//75
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//76
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//77
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//78
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//79
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//80
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//81
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//82
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//83
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//84
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//85
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//86
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//87
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//88
    { "QtConcurrent::ReduceOption", 0, Smoke::t_enum|Smoke::tf_stack },	//89
    { "QtConcurrent::ReduceOptions::enum_type", 0, Smoke::t_voidp|Smoke::tf_stack },	//90
    { "QtConcurrent::ThreadFunctionResult", 0, Smoke::t_enum|Smoke::tf_stack },	//91
    { "QtMsgType", 4, Smoke::t_enum|Smoke::tf_stack },	//92
    { "QtValidLicenseForActiveQtModule", 4, Smoke::t_enum|Smoke::tf_stack },	//93
    { "QtValidLicenseForCoreModule", 4, Smoke::t_enum|Smoke::tf_stack },	//94
    { "QtValidLicenseForDBusModule", 4, Smoke::t_enum|Smoke::tf_stack },	//95
    { "QtValidLicenseForDeclarativeModule", 4, Smoke::t_enum|Smoke::tf_stack },	//96
    { "QtValidLicenseForGuiModule", 4, Smoke::t_enum|Smoke::tf_stack },	//97
    { "QtValidLicenseForHelpModule", 4, Smoke::t_enum|Smoke::tf_stack },	//98
    { "QtValidLicenseForMultimediaModule", 4, Smoke::t_enum|Smoke::tf_stack },	//99
    { "QtValidLicenseForNetworkModule", 4, Smoke::t_enum|Smoke::tf_stack },	//100
    { "QtValidLicenseForOpenGLModule", 4, Smoke::t_enum|Smoke::tf_stack },	//101
    { "QtValidLicenseForOpenVGModule", 4, Smoke::t_enum|Smoke::tf_stack },	//102
    { "QtValidLicenseForQt3SupportLightModule", 4, Smoke::t_enum|Smoke::tf_stack },	//103
    { "QtValidLicenseForQt3SupportModule", 4, Smoke::t_enum|Smoke::tf_stack },	//104
    { "QtValidLicenseForScriptModule", 4, Smoke::t_enum|Smoke::tf_stack },	//105
    { "QtValidLicenseForScriptToolsModule", 4, Smoke::t_enum|Smoke::tf_stack },	//106
    { "QtValidLicenseForSqlModule", 4, Smoke::t_enum|Smoke::tf_stack },	//107
    { "QtValidLicenseForSvgModule", 4, Smoke::t_enum|Smoke::tf_stack },	//108
    { "QtValidLicenseForTestModule", 4, Smoke::t_enum|Smoke::tf_stack },	//109
    { "QtValidLicenseForXmlModule", 4, Smoke::t_enum|Smoke::tf_stack },	//110
    { "QtValidLicenseForXmlPatternsModule", 4, Smoke::t_enum|Smoke::tf_stack },	//111
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//112
    { "const Blitz&", 1, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//113
    { "const QColor&", 3, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//114
    { "const QRegExp&", 7, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//115
    { "const QSize&", 8, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//116
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//117
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//118
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//119
    { "float", 0, Smoke::t_float|Smoke::tf_stack },	//120
    { "float*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//121
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//122
    { "int*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//123
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//124
    { "std::bidirectional_iterator_tag", 0, Smoke::t_voidp|Smoke::tf_stack },	//125
    { "std::forward_iterator_tag", 0, Smoke::t_voidp|Smoke::tf_stack },	//126
    { "std::random_access_iterator_tag", 0, Smoke::t_voidp|Smoke::tf_stack },	//127
    { "unsigned char", 0, Smoke::t_uchar|Smoke::tf_stack },	//128
    { "unsigned int", 0, Smoke::t_uint|Smoke::tf_stack },	//129
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//130
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    10, 11, 0,	//1  QImage&, QImage::InvertMode
    10, 112, 0,	//4  QImage&, bool
    10, 116, 22, 0,	//7  QImage&, const QSize&, Qt::AspectRatioMode
    10, 122, 122, 22, 0,	//11  QImage&, int, int, Qt::AspectRatioMode
    10, 116, 120, 6, 22, 0,	//16  QImage&, const QSize&, float, Blitz::ScaleFilterType, Qt::AspectRatioMode
    10, 122, 122, 120, 6, 22, 0,	//22  QImage&, int, int, float, Blitz::ScaleFilterType, Qt::AspectRatioMode
    10, 122, 121, 0,	//29  QImage&, int, float*
    10, 122, 123, 122, 0,	//33  QImage&, int, int*, int
    10, 122, 0,	//38  QImage&, int
    10, 120, 120, 0,	//41  QImage&, float, float
    10, 0,	//45  QImage&
    10, 120, 2, 0,	//47  QImage&, float, Blitz::EffectQuality
    10, 120, 120, 2, 0,	//51  QImage&, float, float, Blitz::EffectQuality
    10, 112, 122, 0,	//56  QImage&, bool, int
    10, 120, 0,	//60  QImage&, float
    10, 120, 5, 0,	//63  QImage&, float, Blitz::RGBChannel
    10, 120, 114, 0,	//67  QImage&, float, const QColor&
    10, 114, 114, 0,	//71  QImage&, const QColor&, const QColor&
    10, 128, 5, 129, 129, 0,	//75  QImage&, unsigned char, Blitz::RGBChannel, unsigned int, unsigned int
    10, 120, 120, 129, 0,	//81  QImage&, float, float, unsigned int
    116, 114, 114, 3, 0,	//86  const QSize&, const QColor&, const QColor&, Blitz::GradientType
    116, 128, 128, 3, 0,	//91  const QSize&, unsigned char, unsigned char, Blitz::GradientType
    116, 114, 114, 3, 122, 122, 0,	//96  const QSize&, const QColor&, const QColor&, Blitz::GradientType, int, int
    116, 128, 128, 3, 122, 122, 0,	//103  const QSize&, unsigned char, unsigned char, Blitz::GradientType, int, int
    10, 10, 112, 4, 122, 5, 0,	//110  QImage&, QImage&, bool, Blitz::ModulationType, int, Blitz::RGBChannel
    113, 0,	//117  const Blitz&
    10, 116, 0,	//119  QImage&, const QSize&
    10, 122, 122, 0,	//122  QImage&, int, int
    10, 116, 120, 0,	//126  QImage&, const QSize&, float
    10, 116, 120, 6, 0,	//130  QImage&, const QSize&, float, Blitz::ScaleFilterType
    10, 122, 122, 120, 0,	//135  QImage&, int, int, float
    10, 122, 122, 120, 6, 0,	//140  QImage&, int, int, float, Blitz::ScaleFilterType
    10, 122, 123, 0,	//146  QImage&, int, int*
    10, 128, 0,	//150  QImage&, unsigned char
    10, 128, 5, 0,	//153  QImage&, unsigned char, Blitz::RGBChannel
    10, 128, 5, 129, 0,	//157  QImage&, unsigned char, Blitz::RGBChannel, unsigned int
    116, 114, 114, 3, 122, 0,	//162  const QSize&, const QColor&, const QColor&, Blitz::GradientType, int
    116, 128, 128, 3, 122, 0,	//168  const QSize&, unsigned char, unsigned char, Blitz::GradientType, int
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "All",	//1
    "Alpha",	//2
    "BesselFilter",	//3
    "BlackmanFilter",	//4
    "Blitz",	//5
    "Blitz#",	//6
    "Blue",	//7
    "BoxFilter",	//8
    "Brightness",	//9
    "CatromFilter",	//10
    "Contrast",	//11
    "CrossDiagonalGradient",	//12
    "CubicFilter",	//13
    "DiagonalGradient",	//14
    "EllipticGradient",	//15
    "GaussianFilter",	//16
    "Grayscale",	//17
    "Green",	//18
    "HammingFilter",	//19
    "HanningFilter",	//20
    "HermiteFilter",	//21
    "High",	//22
    "HorizontalGradient",	//23
    "HueShift",	//24
    "Intensity",	//25
    "LanczosFilter",	//26
    "LicensedActiveQt",	//27
    "LicensedCore",	//28
    "LicensedDBus",	//29
    "LicensedDeclarative",	//30
    "LicensedGui",	//31
    "LicensedHelp",	//32
    "LicensedMultimedia",	//33
    "LicensedNetwork",	//34
    "LicensedOpenGL",	//35
    "LicensedOpenVG",	//36
    "LicensedQt3Support",	//37
    "LicensedQt3SupportLight",	//38
    "LicensedScript",	//39
    "LicensedScriptTools",	//40
    "LicensedSql",	//41
    "LicensedSvg",	//42
    "LicensedTest",	//43
    "LicensedXml",	//44
    "LicensedXmlPatterns",	//45
    "Low",	//46
    "MitchellFilter",	//47
    "PipeCrossGradient",	//48
    "PointFilter",	//49
    "PyramidGradient",	//50
    "Q_COMPLEX_TYPE",	//51
    "Q_DUMMY_TYPE",	//52
    "Q_MOVABLE_TYPE",	//53
    "Q_PRIMITIVE_TYPE",	//54
    "Q_STATIC_TYPE",	//55
    "QtCriticalMsg",	//56
    "QtDebugMsg",	//57
    "QtFatalMsg",	//58
    "QtSystemMsg",	//59
    "QtWarningMsg",	//60
    "QuadraticFilter",	//61
    "RectangleGradient",	//62
    "Red",	//63
    "Saturation",	//64
    "SincFilter",	//65
    "TriangleFilter",	//66
    "UndefinedFilter",	//67
    "VerticalGradient",	//68
    "antialias",	//69
    "antialias#",	//70
    "blur",	//71
    "blur#",	//72
    "blur#$",	//73
    "channelIntensity",	//74
    "channelIntensity#$$",	//75
    "charcoal",	//76
    "charcoal#",	//77
    "contrast",	//78
    "contrast#$",	//79
    "contrast#$$",	//80
    "convolve",	//81
    "convolve#$$",	//82
    "convolveEdge",	//83
    "convolveEdge#",	//84
    "convolveEdge#$",	//85
    "convolveEdge#$$",	//86
    "convolveInteger",	//87
    "convolveInteger#$$",	//88
    "convolveInteger#$$$",	//89
    "desaturate",	//90
    "desaturate#",	//91
    "desaturate#$",	//92
    "despeckle",	//93
    "despeckle#",	//94
    "edge",	//95
    "edge#",	//96
    "emboss",	//97
    "emboss#",	//98
    "emboss#$",	//99
    "emboss#$$",	//100
    "emboss#$$$",	//101
    "equalize",	//102
    "equalize#",	//103
    "fade",	//104
    "fade#$#",	//105
    "flatten",	//106
    "flatten###",	//107
    "gaussianBlur",	//108
    "gaussianBlur#",	//109
    "gaussianBlur#$",	//110
    "gaussianBlur#$$",	//111
    "gaussianSharpen",	//112
    "gaussianSharpen#",	//113
    "gaussianSharpen#$",	//114
    "gaussianSharpen#$$",	//115
    "gaussianSharpen#$$$",	//116
    "gradient",	//117
    "gradient###$",	//118
    "grayGradient",	//119
    "grayGradient#$$$",	//120
    "grayUnbalancedGradient",	//121
    "grayUnbalancedGradient#$$$",	//122
    "grayUnbalancedGradient#$$$$",	//123
    "grayUnbalancedGradient#$$$$$",	//124
    "grayscale",	//125
    "grayscale#",	//126
    "grayscale#$",	//127
    "implode",	//128
    "implode#",	//129
    "implode#$",	//130
    "intensity",	//131
    "intensity#$",	//132
    "invert",	//133
    "invert#",	//134
    "invert#$",	//135
    "modulate",	//136
    "modulate##$$$$",	//137
    "normalize",	//138
    "normalize#",	//139
    "oilPaint",	//140
    "oilPaint#",	//141
    "oilPaint#$",	//142
    "oilPaint#$$",	//143
    "sharpen",	//144
    "sharpen#",	//145
    "sharpen#$",	//146
    "smoothScale",	//147
    "smoothScale##",	//148
    "smoothScale##$",	//149
    "smoothScale#$$",	//150
    "smoothScale#$$$",	//151
    "smoothScaleFilter",	//152
    "smoothScaleFilter##",	//153
    "smoothScaleFilter##$",	//154
    "smoothScaleFilter##$$",	//155
    "smoothScaleFilter##$$$",	//156
    "smoothScaleFilter#$$",	//157
    "smoothScaleFilter#$$$",	//158
    "smoothScaleFilter#$$$$",	//159
    "smoothScaleFilter#$$$$$",	//160
    "swirl",	//161
    "swirl#",	//162
    "swirl#$",	//163
    "threshold",	//164
    "threshold#",	//165
    "threshold#$",	//166
    "threshold#$$",	//167
    "threshold#$$$",	//168
    "threshold#$$$$",	//169
    "unbalancedGradient",	//170
    "unbalancedGradient###$",	//171
    "unbalancedGradient###$$",	//172
    "unbalancedGradient###$$$",	//173
    "wave",	//174
    "wave#",	//175
    "wave#$",	//176
    "wave#$$",	//177
    "wave#$$$",	//178
    "~Blitz",	//179
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {1, 133, 1, 2, Smoke::mf_static, 112, 1},	//1 Blitz::invert(QImage&, QImage::InvertMode)
    {1, 125, 4, 2, Smoke::mf_static, 112, 2},	//2 Blitz::grayscale(QImage&, bool)
    {1, 147, 7, 3, Smoke::mf_static, 9, 3},	//3 Blitz::smoothScale(QImage&, const QSize&, Qt::AspectRatioMode)
    {1, 147, 11, 4, Smoke::mf_static, 9, 4},	//4 Blitz::smoothScale(QImage&, int, int, Qt::AspectRatioMode)
    {1, 152, 16, 5, Smoke::mf_static, 9, 5},	//5 Blitz::smoothScaleFilter(QImage&, const QSize&, float, Blitz::ScaleFilterType, Qt::AspectRatioMode)
    {1, 152, 22, 6, Smoke::mf_static, 9, 6},	//6 Blitz::smoothScaleFilter(QImage&, int, int, float, Blitz::ScaleFilterType, Qt::AspectRatioMode)
    {1, 81, 29, 3, Smoke::mf_static, 9, 7},	//7 Blitz::convolve(QImage&, int, float*)
    {1, 87, 33, 4, Smoke::mf_static, 9, 8},	//8 Blitz::convolveInteger(QImage&, int, int*, int)
    {1, 71, 38, 2, Smoke::mf_static, 9, 9},	//9 Blitz::blur(QImage&, int)
    {1, 108, 41, 3, Smoke::mf_static, 9, 10},	//10 Blitz::gaussianBlur(QImage&, float, float)
    {1, 95, 45, 1, Smoke::mf_static, 9, 11},	//11 Blitz::edge(QImage&)
    {1, 83, 47, 3, Smoke::mf_static, 9, 12},	//12 Blitz::convolveEdge(QImage&, float, Blitz::EffectQuality)
    {1, 112, 51, 4, Smoke::mf_static, 9, 13},	//13 Blitz::gaussianSharpen(QImage&, float, float, Blitz::EffectQuality)
    {1, 144, 38, 2, Smoke::mf_static, 9, 14},	//14 Blitz::sharpen(QImage&, int)
    {1, 97, 51, 4, Smoke::mf_static, 9, 15},	//15 Blitz::emboss(QImage&, float, float, Blitz::EffectQuality)
    {1, 69, 45, 1, Smoke::mf_static, 9, 16},	//16 Blitz::antialias(QImage&)
    {1, 93, 45, 1, Smoke::mf_static, 10, 17},	//17 Blitz::despeckle(QImage&)
    {1, 78, 56, 3, Smoke::mf_static, 10, 18},	//18 Blitz::contrast(QImage&, bool, int)
    {1, 102, 45, 1, Smoke::mf_static, 112, 19},	//19 Blitz::equalize(QImage&)
    {1, 138, 45, 1, Smoke::mf_static, 112, 20},	//20 Blitz::normalize(QImage&)
    {1, 131, 60, 2, Smoke::mf_static, 10, 21},	//21 Blitz::intensity(QImage&, float)
    {1, 74, 63, 3, Smoke::mf_static, 10, 22},	//22 Blitz::channelIntensity(QImage&, float, Blitz::RGBChannel)
    {1, 90, 60, 2, Smoke::mf_static, 10, 23},	//23 Blitz::desaturate(QImage&, float)
    {1, 104, 67, 3, Smoke::mf_static, 10, 24},	//24 Blitz::fade(QImage&, float, const QColor&)
    {1, 106, 71, 3, Smoke::mf_static, 10, 25},	//25 Blitz::flatten(QImage&, const QColor&, const QColor&)
    {1, 164, 75, 5, Smoke::mf_static, 9, 26},	//26 Blitz::threshold(QImage&, unsigned char, Blitz::RGBChannel, unsigned int, unsigned int)
    {1, 161, 60, 2, Smoke::mf_static, 9, 27},	//27 Blitz::swirl(QImage&, float)
    {1, 128, 60, 2, Smoke::mf_static, 9, 28},	//28 Blitz::implode(QImage&, float)
    {1, 174, 81, 4, Smoke::mf_static, 9, 29},	//29 Blitz::wave(QImage&, float, float, unsigned int)
    {1, 140, 47, 3, Smoke::mf_static, 9, 30},	//30 Blitz::oilPaint(QImage&, float, Blitz::EffectQuality)
    {1, 76, 45, 1, Smoke::mf_static, 9, 31},	//31 Blitz::charcoal(QImage&)
    {1, 117, 86, 4, Smoke::mf_static, 9, 32},	//32 Blitz::gradient(const QSize&, const QColor&, const QColor&, Blitz::GradientType)
    {1, 119, 91, 4, Smoke::mf_static, 9, 33},	//33 Blitz::grayGradient(const QSize&, unsigned char, unsigned char, Blitz::GradientType)
    {1, 170, 96, 6, Smoke::mf_static, 9, 34},	//34 Blitz::unbalancedGradient(const QSize&, const QColor&, const QColor&, Blitz::GradientType, int, int)
    {1, 121, 103, 6, Smoke::mf_static, 9, 35},	//35 Blitz::grayUnbalancedGradient(const QSize&, unsigned char, unsigned char, Blitz::GradientType, int, int)
    {1, 136, 110, 6, Smoke::mf_static, 10, 36},	//36 Blitz::modulate(QImage&, QImage&, bool, Blitz::ModulationType, int, Blitz::RGBChannel)
    {1, 5, 0, 0, Smoke::mf_ctor, 1, 37},	//37 Blitz::Blitz()
    {1, 5, 117, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 1, 38},	//38 Blitz::Blitz(const Blitz&)
    {1, 133, 45, 1, Smoke::mf_static, 112, 39},	//39 Blitz::invert(QImage&)
    {1, 125, 45, 1, Smoke::mf_static, 112, 40},	//40 Blitz::grayscale(QImage&)
    {1, 147, 119, 2, Smoke::mf_static, 9, 41},	//41 Blitz::smoothScale(QImage&, const QSize&)
    {1, 147, 122, 3, Smoke::mf_static, 9, 42},	//42 Blitz::smoothScale(QImage&, int, int)
    {1, 152, 119, 2, Smoke::mf_static, 9, 43},	//43 Blitz::smoothScaleFilter(QImage&, const QSize&)
    {1, 152, 126, 3, Smoke::mf_static, 9, 44},	//44 Blitz::smoothScaleFilter(QImage&, const QSize&, float)
    {1, 152, 130, 4, Smoke::mf_static, 9, 45},	//45 Blitz::smoothScaleFilter(QImage&, const QSize&, float, Blitz::ScaleFilterType)
    {1, 152, 122, 3, Smoke::mf_static, 9, 46},	//46 Blitz::smoothScaleFilter(QImage&, int, int)
    {1, 152, 135, 4, Smoke::mf_static, 9, 47},	//47 Blitz::smoothScaleFilter(QImage&, int, int, float)
    {1, 152, 140, 5, Smoke::mf_static, 9, 48},	//48 Blitz::smoothScaleFilter(QImage&, int, int, float, Blitz::ScaleFilterType)
    {1, 87, 146, 3, Smoke::mf_static, 9, 49},	//49 Blitz::convolveInteger(QImage&, int, int*)
    {1, 71, 45, 1, Smoke::mf_static, 9, 50},	//50 Blitz::blur(QImage&)
    {1, 108, 45, 1, Smoke::mf_static, 9, 51},	//51 Blitz::gaussianBlur(QImage&)
    {1, 108, 60, 2, Smoke::mf_static, 9, 52},	//52 Blitz::gaussianBlur(QImage&, float)
    {1, 83, 45, 1, Smoke::mf_static, 9, 53},	//53 Blitz::convolveEdge(QImage&)
    {1, 83, 60, 2, Smoke::mf_static, 9, 54},	//54 Blitz::convolveEdge(QImage&, float)
    {1, 112, 45, 1, Smoke::mf_static, 9, 55},	//55 Blitz::gaussianSharpen(QImage&)
    {1, 112, 60, 2, Smoke::mf_static, 9, 56},	//56 Blitz::gaussianSharpen(QImage&, float)
    {1, 112, 41, 3, Smoke::mf_static, 9, 57},	//57 Blitz::gaussianSharpen(QImage&, float, float)
    {1, 144, 45, 1, Smoke::mf_static, 9, 58},	//58 Blitz::sharpen(QImage&)
    {1, 97, 45, 1, Smoke::mf_static, 9, 59},	//59 Blitz::emboss(QImage&)
    {1, 97, 60, 2, Smoke::mf_static, 9, 60},	//60 Blitz::emboss(QImage&, float)
    {1, 97, 41, 3, Smoke::mf_static, 9, 61},	//61 Blitz::emboss(QImage&, float, float)
    {1, 78, 4, 2, Smoke::mf_static, 10, 62},	//62 Blitz::contrast(QImage&, bool)
    {1, 90, 45, 1, Smoke::mf_static, 10, 63},	//63 Blitz::desaturate(QImage&)
    {1, 164, 45, 1, Smoke::mf_static, 9, 64},	//64 Blitz::threshold(QImage&)
    {1, 164, 150, 2, Smoke::mf_static, 9, 65},	//65 Blitz::threshold(QImage&, unsigned char)
    {1, 164, 153, 3, Smoke::mf_static, 9, 66},	//66 Blitz::threshold(QImage&, unsigned char, Blitz::RGBChannel)
    {1, 164, 157, 4, Smoke::mf_static, 9, 67},	//67 Blitz::threshold(QImage&, unsigned char, Blitz::RGBChannel, unsigned int)
    {1, 161, 45, 1, Smoke::mf_static, 9, 68},	//68 Blitz::swirl(QImage&)
    {1, 128, 45, 1, Smoke::mf_static, 9, 69},	//69 Blitz::implode(QImage&)
    {1, 174, 45, 1, Smoke::mf_static, 9, 70},	//70 Blitz::wave(QImage&)
    {1, 174, 60, 2, Smoke::mf_static, 9, 71},	//71 Blitz::wave(QImage&, float)
    {1, 174, 41, 3, Smoke::mf_static, 9, 72},	//72 Blitz::wave(QImage&, float, float)
    {1, 140, 45, 1, Smoke::mf_static, 9, 73},	//73 Blitz::oilPaint(QImage&)
    {1, 140, 60, 2, Smoke::mf_static, 9, 74},	//74 Blitz::oilPaint(QImage&, float)
    {1, 170, 86, 4, Smoke::mf_static, 9, 75},	//75 Blitz::unbalancedGradient(const QSize&, const QColor&, const QColor&, Blitz::GradientType)
    {1, 170, 162, 5, Smoke::mf_static, 9, 76},	//76 Blitz::unbalancedGradient(const QSize&, const QColor&, const QColor&, Blitz::GradientType, int)
    {1, 121, 91, 4, Smoke::mf_static, 9, 77},	//77 Blitz::grayUnbalancedGradient(const QSize&, unsigned char, unsigned char, Blitz::GradientType)
    {1, 121, 168, 5, Smoke::mf_static, 9, 78},	//78 Blitz::grayUnbalancedGradient(const QSize&, unsigned char, unsigned char, Blitz::GradientType, int)
    {1, 68, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 79},	//79 Blitz::VerticalGradient (enum)
    {1, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 80},	//80 Blitz::HorizontalGradient (enum)
    {1, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 81},	//81 Blitz::DiagonalGradient (enum)
    {1, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 82},	//82 Blitz::CrossDiagonalGradient (enum)
    {1, 50, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 83},	//83 Blitz::PyramidGradient (enum)
    {1, 62, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 84},	//84 Blitz::RectangleGradient (enum)
    {1, 48, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 85},	//85 Blitz::PipeCrossGradient (enum)
    {1, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 86},	//86 Blitz::EllipticGradient (enum)
    {1, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 87},	//87 Blitz::Grayscale (enum)
    {1, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 88},	//88 Blitz::Brightness (enum)
    {1, 63, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 89},	//89 Blitz::Red (enum)
    {1, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 90},	//90 Blitz::Green (enum)
    {1, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 91},	//91 Blitz::Blue (enum)
    {1, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 92},	//92 Blitz::Alpha (enum)
    {1, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 93},	//93 Blitz::All (enum)
    {1, 46, 0, 0, Smoke::mf_static|Smoke::mf_enum, 2, 94},	//94 Blitz::Low (enum)
    {1, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 2, 95},	//95 Blitz::High (enum)
    {1, 67, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 96},	//96 Blitz::UndefinedFilter (enum)
    {1, 49, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 97},	//97 Blitz::PointFilter (enum)
    {1, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 98},	//98 Blitz::BoxFilter (enum)
    {1, 66, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 99},	//99 Blitz::TriangleFilter (enum)
    {1, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 100},	//100 Blitz::HermiteFilter (enum)
    {1, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 101},	//101 Blitz::HanningFilter (enum)
    {1, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 102},	//102 Blitz::HammingFilter (enum)
    {1, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 103},	//103 Blitz::BlackmanFilter (enum)
    {1, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 104},	//104 Blitz::GaussianFilter (enum)
    {1, 61, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 105},	//105 Blitz::QuadraticFilter (enum)
    {1, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 106},	//106 Blitz::CubicFilter (enum)
    {1, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 107},	//107 Blitz::CatromFilter (enum)
    {1, 47, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 108},	//108 Blitz::MitchellFilter (enum)
    {1, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 109},	//109 Blitz::LanczosFilter (enum)
    {1, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 110},	//110 Blitz::BesselFilter (enum)
    {1, 65, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 111},	//111 Blitz::SincFilter (enum)
    {1, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 112},	//112 Blitz::Intensity (enum)
    {1, 64, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 113},	//113 Blitz::Saturation (enum)
    {1, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 114},	//114 Blitz::HueShift (enum)
    {1, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 115},	//115 Blitz::Contrast (enum)
    {1, 179, 0, 0, Smoke::mf_dtor, 0, 116 },	//116 Blitz::~Blitz()
    {4, 51, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 1},	//117 QGlobalSpace::Q_COMPLEX_TYPE (enum)
    {4, 54, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 2},	//118 QGlobalSpace::Q_PRIMITIVE_TYPE (enum)
    {4, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 3},	//119 QGlobalSpace::Q_STATIC_TYPE (enum)
    {4, 53, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 4},	//120 QGlobalSpace::Q_MOVABLE_TYPE (enum)
    {4, 52, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 5},	//121 QGlobalSpace::Q_DUMMY_TYPE (enum)
    {4, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 6},	//122 QGlobalSpace::LicensedGui (enum)
    {4, 44, 0, 0, Smoke::mf_static|Smoke::mf_enum, 110, 7},	//123 QGlobalSpace::LicensedXml (enum)
    {4, 38, 0, 0, Smoke::mf_static|Smoke::mf_enum, 103, 8},	//124 QGlobalSpace::LicensedQt3SupportLight (enum)
    {4, 39, 0, 0, Smoke::mf_static|Smoke::mf_enum, 105, 9},	//125 QGlobalSpace::LicensedScript (enum)
    {4, 36, 0, 0, Smoke::mf_static|Smoke::mf_enum, 102, 10},	//126 QGlobalSpace::LicensedOpenVG (enum)
    {4, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 11},	//127 QGlobalSpace::LicensedDBus (enum)
    {4, 43, 0, 0, Smoke::mf_static|Smoke::mf_enum, 109, 12},	//128 QGlobalSpace::LicensedTest (enum)
    {4, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 93, 13},	//129 QGlobalSpace::LicensedActiveQt (enum)
    {4, 40, 0, 0, Smoke::mf_static|Smoke::mf_enum, 106, 14},	//130 QGlobalSpace::LicensedScriptTools (enum)
    {4, 42, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 15},	//131 QGlobalSpace::LicensedSvg (enum)
    {4, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 16},	//132 QGlobalSpace::LicensedDeclarative (enum)
    {4, 41, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 17},	//133 QGlobalSpace::LicensedSql (enum)
    {4, 35, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 18},	//134 QGlobalSpace::LicensedOpenGL (enum)
    {4, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 19},	//135 QGlobalSpace::LicensedCore (enum)
    {4, 57, 0, 0, Smoke::mf_static|Smoke::mf_enum, 92, 20},	//136 QGlobalSpace::QtDebugMsg (enum)
    {4, 60, 0, 0, Smoke::mf_static|Smoke::mf_enum, 92, 21},	//137 QGlobalSpace::QtWarningMsg (enum)
    {4, 56, 0, 0, Smoke::mf_static|Smoke::mf_enum, 92, 22},	//138 QGlobalSpace::QtCriticalMsg (enum)
    {4, 58, 0, 0, Smoke::mf_static|Smoke::mf_enum, 92, 23},	//139 QGlobalSpace::QtFatalMsg (enum)
    {4, 59, 0, 0, Smoke::mf_static|Smoke::mf_enum, 92, 24},	//140 QGlobalSpace::QtSystemMsg (enum)
    {4, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 98, 25},	//141 QGlobalSpace::LicensedHelp (enum)
    {4, 33, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 26},	//142 QGlobalSpace::LicensedMultimedia (enum)
    {4, 37, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 27},	//143 QGlobalSpace::LicensedQt3Support (enum)
    {4, 45, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 28},	//144 QGlobalSpace::LicensedXmlPatterns (enum)
    {4, 34, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 29},	//145 QGlobalSpace::LicensedNetwork (enum)
};

static Smoke::Index ambiguousMethodList[] = {
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {1, 1, 93},	// Blitz::All
    {1, 2, 92},	// Blitz::Alpha
    {1, 3, 110},	// Blitz::BesselFilter
    {1, 4, 103},	// Blitz::BlackmanFilter
    {1, 5, 37},	// Blitz::Blitz
    {1, 6, 38},	// Blitz::Blitz#
    {1, 7, 91},	// Blitz::Blue
    {1, 8, 98},	// Blitz::BoxFilter
    {1, 9, 88},	// Blitz::Brightness
    {1, 10, 107},	// Blitz::CatromFilter
    {1, 11, 115},	// Blitz::Contrast
    {1, 12, 82},	// Blitz::CrossDiagonalGradient
    {1, 13, 106},	// Blitz::CubicFilter
    {1, 14, 81},	// Blitz::DiagonalGradient
    {1, 15, 86},	// Blitz::EllipticGradient
    {1, 16, 104},	// Blitz::GaussianFilter
    {1, 17, 87},	// Blitz::Grayscale
    {1, 18, 90},	// Blitz::Green
    {1, 19, 102},	// Blitz::HammingFilter
    {1, 20, 101},	// Blitz::HanningFilter
    {1, 21, 100},	// Blitz::HermiteFilter
    {1, 22, 95},	// Blitz::High
    {1, 23, 80},	// Blitz::HorizontalGradient
    {1, 24, 114},	// Blitz::HueShift
    {1, 25, 112},	// Blitz::Intensity
    {1, 26, 109},	// Blitz::LanczosFilter
    {1, 46, 94},	// Blitz::Low
    {1, 47, 108},	// Blitz::MitchellFilter
    {1, 48, 85},	// Blitz::PipeCrossGradient
    {1, 49, 97},	// Blitz::PointFilter
    {1, 50, 83},	// Blitz::PyramidGradient
    {1, 61, 105},	// Blitz::QuadraticFilter
    {1, 62, 84},	// Blitz::RectangleGradient
    {1, 63, 89},	// Blitz::Red
    {1, 64, 113},	// Blitz::Saturation
    {1, 65, 111},	// Blitz::SincFilter
    {1, 66, 99},	// Blitz::TriangleFilter
    {1, 67, 96},	// Blitz::UndefinedFilter
    {1, 68, 79},	// Blitz::VerticalGradient
    {1, 70, 16},	// Blitz::antialias#
    {1, 72, 50},	// Blitz::blur#
    {1, 73, 9},	// Blitz::blur#$
    {1, 75, 22},	// Blitz::channelIntensity#$$
    {1, 77, 31},	// Blitz::charcoal#
    {1, 79, 62},	// Blitz::contrast#$
    {1, 80, 18},	// Blitz::contrast#$$
    {1, 82, 7},	// Blitz::convolve#$$
    {1, 84, 53},	// Blitz::convolveEdge#
    {1, 85, 54},	// Blitz::convolveEdge#$
    {1, 86, 12},	// Blitz::convolveEdge#$$
    {1, 88, 49},	// Blitz::convolveInteger#$$
    {1, 89, 8},	// Blitz::convolveInteger#$$$
    {1, 91, 63},	// Blitz::desaturate#
    {1, 92, 23},	// Blitz::desaturate#$
    {1, 94, 17},	// Blitz::despeckle#
    {1, 96, 11},	// Blitz::edge#
    {1, 98, 59},	// Blitz::emboss#
    {1, 99, 60},	// Blitz::emboss#$
    {1, 100, 61},	// Blitz::emboss#$$
    {1, 101, 15},	// Blitz::emboss#$$$
    {1, 103, 19},	// Blitz::equalize#
    {1, 105, 24},	// Blitz::fade#$#
    {1, 107, 25},	// Blitz::flatten###
    {1, 109, 51},	// Blitz::gaussianBlur#
    {1, 110, 52},	// Blitz::gaussianBlur#$
    {1, 111, 10},	// Blitz::gaussianBlur#$$
    {1, 113, 55},	// Blitz::gaussianSharpen#
    {1, 114, 56},	// Blitz::gaussianSharpen#$
    {1, 115, 57},	// Blitz::gaussianSharpen#$$
    {1, 116, 13},	// Blitz::gaussianSharpen#$$$
    {1, 118, 32},	// Blitz::gradient###$
    {1, 120, 33},	// Blitz::grayGradient#$$$
    {1, 122, 77},	// Blitz::grayUnbalancedGradient#$$$
    {1, 123, 78},	// Blitz::grayUnbalancedGradient#$$$$
    {1, 124, 35},	// Blitz::grayUnbalancedGradient#$$$$$
    {1, 126, 40},	// Blitz::grayscale#
    {1, 127, 2},	// Blitz::grayscale#$
    {1, 129, 69},	// Blitz::implode#
    {1, 130, 28},	// Blitz::implode#$
    {1, 132, 21},	// Blitz::intensity#$
    {1, 134, 39},	// Blitz::invert#
    {1, 135, 1},	// Blitz::invert#$
    {1, 137, 36},	// Blitz::modulate##$$$$
    {1, 139, 20},	// Blitz::normalize#
    {1, 141, 73},	// Blitz::oilPaint#
    {1, 142, 74},	// Blitz::oilPaint#$
    {1, 143, 30},	// Blitz::oilPaint#$$
    {1, 145, 58},	// Blitz::sharpen#
    {1, 146, 14},	// Blitz::sharpen#$
    {1, 148, 41},	// Blitz::smoothScale##
    {1, 149, 3},	// Blitz::smoothScale##$
    {1, 150, 42},	// Blitz::smoothScale#$$
    {1, 151, 4},	// Blitz::smoothScale#$$$
    {1, 153, 43},	// Blitz::smoothScaleFilter##
    {1, 154, 44},	// Blitz::smoothScaleFilter##$
    {1, 155, 45},	// Blitz::smoothScaleFilter##$$
    {1, 156, 5},	// Blitz::smoothScaleFilter##$$$
    {1, 157, 46},	// Blitz::smoothScaleFilter#$$
    {1, 158, 47},	// Blitz::smoothScaleFilter#$$$
    {1, 159, 48},	// Blitz::smoothScaleFilter#$$$$
    {1, 160, 6},	// Blitz::smoothScaleFilter#$$$$$
    {1, 162, 68},	// Blitz::swirl#
    {1, 163, 27},	// Blitz::swirl#$
    {1, 165, 64},	// Blitz::threshold#
    {1, 166, 65},	// Blitz::threshold#$
    {1, 167, 66},	// Blitz::threshold#$$
    {1, 168, 67},	// Blitz::threshold#$$$
    {1, 169, 26},	// Blitz::threshold#$$$$
    {1, 171, 75},	// Blitz::unbalancedGradient###$
    {1, 172, 76},	// Blitz::unbalancedGradient###$$
    {1, 173, 34},	// Blitz::unbalancedGradient###$$$
    {1, 175, 70},	// Blitz::wave#
    {1, 176, 71},	// Blitz::wave#$
    {1, 177, 72},	// Blitz::wave#$$
    {1, 178, 29},	// Blitz::wave#$$$
    {1, 179, 116},	// Blitz::~Blitz
    {4, 27, 129},	// QGlobalSpace::LicensedActiveQt
    {4, 28, 135},	// QGlobalSpace::LicensedCore
    {4, 29, 127},	// QGlobalSpace::LicensedDBus
    {4, 30, 132},	// QGlobalSpace::LicensedDeclarative
    {4, 31, 122},	// QGlobalSpace::LicensedGui
    {4, 32, 141},	// QGlobalSpace::LicensedHelp
    {4, 33, 142},	// QGlobalSpace::LicensedMultimedia
    {4, 34, 145},	// QGlobalSpace::LicensedNetwork
    {4, 35, 134},	// QGlobalSpace::LicensedOpenGL
    {4, 36, 126},	// QGlobalSpace::LicensedOpenVG
    {4, 37, 143},	// QGlobalSpace::LicensedQt3Support
    {4, 38, 124},	// QGlobalSpace::LicensedQt3SupportLight
    {4, 39, 125},	// QGlobalSpace::LicensedScript
    {4, 40, 130},	// QGlobalSpace::LicensedScriptTools
    {4, 41, 133},	// QGlobalSpace::LicensedSql
    {4, 42, 131},	// QGlobalSpace::LicensedSvg
    {4, 43, 128},	// QGlobalSpace::LicensedTest
    {4, 44, 123},	// QGlobalSpace::LicensedXml
    {4, 45, 144},	// QGlobalSpace::LicensedXmlPatterns
    {4, 51, 117},	// QGlobalSpace::Q_COMPLEX_TYPE
    {4, 52, 121},	// QGlobalSpace::Q_DUMMY_TYPE
    {4, 53, 120},	// QGlobalSpace::Q_MOVABLE_TYPE
    {4, 54, 118},	// QGlobalSpace::Q_PRIMITIVE_TYPE
    {4, 55, 119},	// QGlobalSpace::Q_STATIC_TYPE
    {4, 56, 138},	// QGlobalSpace::QtCriticalMsg
    {4, 57, 136},	// QGlobalSpace::QtDebugMsg
    {4, 58, 139},	// QGlobalSpace::QtFatalMsg
    {4, 59, 140},	// QGlobalSpace::QtSystemMsg
    {4, 60, 137},	// QGlobalSpace::QtWarningMsg
};

}

extern "C" {

static bool initialized = false;
Smoke *qimageblitz_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qimageblitz_Smoke() {
    if (initialized) return;
    qimageblitz_Smoke = new Smoke(
        "qimageblitz",
        __smokeqimageblitz::classes, 8,
        __smokeqimageblitz::methods, 146,
        __smokeqimageblitz::methodMaps, 146,
        __smokeqimageblitz::methodNames, 179,
        __smokeqimageblitz::types, 130,
        __smokeqimageblitz::inheritanceList,
        __smokeqimageblitz::argumentList,
        __smokeqimageblitz::ambiguousMethodList,
        __smokeqimageblitz::cast );
    initialized = true;
}

void delete_qimageblitz_Smoke() { delete qimageblitz_Smoke; }

}
