#include <qtxml_includes.h>

#include <smoke.h>
#include <qtxml_smoke.h>

namespace __smokeqtxml {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QBool
      switch(to) {
        case 1: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 2:   //QByteArray
      switch(to) {
        case 2: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 3:   //QChar
      switch(to) {
        case 3: return (void*)(QChar*)xptr;
        default: return xptr;
      }
    case 4:   //QDomAttr
      switch(to) {
        case 16: return (void*)(QDomNode*)(QDomAttr*)xptr;
        case 4: return (void*)(QDomAttr*)xptr;
        default: return xptr;
      }
    case 5:   //QDomCDATASection
      switch(to) {
        case 21: return (void*)(QDomText*)(QDomCDATASection*)xptr;
        case 6: return (void*)(QDomCharacterData*)(QDomCDATASection*)xptr;
        case 16: return (void*)(QDomNode*)(QDomCDATASection*)xptr;
        case 5: return (void*)(QDomCDATASection*)xptr;
        default: return xptr;
      }
    case 6:   //QDomCharacterData
      switch(to) {
        case 16: return (void*)(QDomNode*)(QDomCharacterData*)xptr;
        case 6: return (void*)(QDomCharacterData*)xptr;
        case 21: return (void*)(QDomText*)(QDomCharacterData*)xptr;
        case 5: return (void*)(QDomCDATASection*)(QDomCharacterData*)xptr;
        case 7: return (void*)(QDomComment*)(QDomCharacterData*)xptr;
        default: return xptr;
      }
    case 7:   //QDomComment
      switch(to) {
        case 6: return (void*)(QDomCharacterData*)(QDomComment*)xptr;
        case 16: return (void*)(QDomNode*)(QDomComment*)xptr;
        case 7: return (void*)(QDomComment*)xptr;
        default: return xptr;
      }
    case 8:   //QDomDocument
      switch(to) {
        case 16: return (void*)(QDomNode*)(QDomDocument*)xptr;
        case 8: return (void*)(QDomDocument*)xptr;
        default: return xptr;
      }
    case 9:   //QDomDocumentFragment
      switch(to) {
        case 16: return (void*)(QDomNode*)(QDomDocumentFragment*)xptr;
        case 9: return (void*)(QDomDocumentFragment*)xptr;
        default: return xptr;
      }
    case 10:   //QDomDocumentType
      switch(to) {
        case 16: return (void*)(QDomNode*)(QDomDocumentType*)xptr;
        case 10: return (void*)(QDomDocumentType*)xptr;
        default: return xptr;
      }
    case 11:   //QDomElement
      switch(to) {
        case 16: return (void*)(QDomNode*)(QDomElement*)xptr;
        case 11: return (void*)(QDomElement*)xptr;
        default: return xptr;
      }
    case 12:   //QDomEntity
      switch(to) {
        case 16: return (void*)(QDomNode*)(QDomEntity*)xptr;
        case 12: return (void*)(QDomEntity*)xptr;
        default: return xptr;
      }
    case 13:   //QDomEntityReference
      switch(to) {
        case 16: return (void*)(QDomNode*)(QDomEntityReference*)xptr;
        case 13: return (void*)(QDomEntityReference*)xptr;
        default: return xptr;
      }
    case 14:   //QDomImplementation
      switch(to) {
        case 14: return (void*)(QDomImplementation*)xptr;
        default: return xptr;
      }
    case 15:   //QDomNamedNodeMap
      switch(to) {
        case 15: return (void*)(QDomNamedNodeMap*)xptr;
        default: return xptr;
      }
    case 16:   //QDomNode
      switch(to) {
        case 16: return (void*)(QDomNode*)xptr;
        case 21: return (void*)(QDomText*)(QDomNode*)xptr;
        case 19: return (void*)(QDomNotation*)(QDomNode*)xptr;
        case 9: return (void*)(QDomDocumentFragment*)(QDomNode*)xptr;
        case 11: return (void*)(QDomElement*)(QDomNode*)xptr;
        case 4: return (void*)(QDomAttr*)(QDomNode*)xptr;
        case 5: return (void*)(QDomCDATASection*)(QDomNode*)xptr;
        case 12: return (void*)(QDomEntity*)(QDomNode*)xptr;
        case 10: return (void*)(QDomDocumentType*)(QDomNode*)xptr;
        case 6: return (void*)(QDomCharacterData*)(QDomNode*)xptr;
        case 20: return (void*)(QDomProcessingInstruction*)(QDomNode*)xptr;
        case 7: return (void*)(QDomComment*)(QDomNode*)xptr;
        case 13: return (void*)(QDomEntityReference*)(QDomNode*)xptr;
        case 8: return (void*)(QDomDocument*)(QDomNode*)xptr;
        default: return xptr;
      }
    case 17:   //QDomNodeList
      switch(to) {
        case 17: return (void*)(QDomNodeList*)xptr;
        default: return xptr;
      }
    case 18:   //QDomNodePrivate
      switch(to) {
        case 18: return (void*)(QDomNodePrivate*)xptr;
        default: return xptr;
      }
    case 19:   //QDomNotation
      switch(to) {
        case 16: return (void*)(QDomNode*)(QDomNotation*)xptr;
        case 19: return (void*)(QDomNotation*)xptr;
        default: return xptr;
      }
    case 20:   //QDomProcessingInstruction
      switch(to) {
        case 16: return (void*)(QDomNode*)(QDomProcessingInstruction*)xptr;
        case 20: return (void*)(QDomProcessingInstruction*)xptr;
        default: return xptr;
      }
    case 21:   //QDomText
      switch(to) {
        case 6: return (void*)(QDomCharacterData*)(QDomText*)xptr;
        case 16: return (void*)(QDomNode*)(QDomText*)xptr;
        case 21: return (void*)(QDomText*)xptr;
        case 5: return (void*)(QDomCDATASection*)(QDomText*)xptr;
        default: return xptr;
      }
    case 23:   //QIODevice
      switch(to) {
        case 23: return (void*)(QIODevice*)xptr;
        default: return xptr;
      }
    case 24:   //QLatin1String
      switch(to) {
        case 24: return (void*)(QLatin1String*)xptr;
        default: return xptr;
      }
    case 25:   //QRegExp
      switch(to) {
        case 25: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 26:   //QTextCodec
      switch(to) {
        case 26: return (void*)(QTextCodec*)xptr;
        default: return xptr;
      }
    case 27:   //QTextStream
      switch(to) {
        case 27: return (void*)(QTextStream*)xptr;
        default: return xptr;
      }
    case 28:   //QXmlAttributes
      switch(to) {
        case 28: return (void*)(QXmlAttributes*)xptr;
        default: return xptr;
      }
    case 29:   //QXmlContentHandler
      switch(to) {
        case 29: return (void*)(QXmlContentHandler*)xptr;
        case 32: return (void*)(QXmlDefaultHandler*)(QXmlContentHandler*)xptr;
        default: return xptr;
      }
    case 30:   //QXmlDTDHandler
      switch(to) {
        case 30: return (void*)(QXmlDTDHandler*)xptr;
        case 32: return (void*)(QXmlDefaultHandler*)(QXmlDTDHandler*)xptr;
        default: return xptr;
      }
    case 31:   //QXmlDeclHandler
      switch(to) {
        case 31: return (void*)(QXmlDeclHandler*)xptr;
        case 32: return (void*)(QXmlDefaultHandler*)(QXmlDeclHandler*)xptr;
        default: return xptr;
      }
    case 32:   //QXmlDefaultHandler
      switch(to) {
        case 29: return (void*)(QXmlContentHandler*)(QXmlDefaultHandler*)xptr;
        case 34: return (void*)(QXmlErrorHandler*)(QXmlDefaultHandler*)xptr;
        case 30: return (void*)(QXmlDTDHandler*)(QXmlDefaultHandler*)xptr;
        case 33: return (void*)(QXmlEntityResolver*)(QXmlDefaultHandler*)xptr;
        case 36: return (void*)(QXmlLexicalHandler*)(QXmlDefaultHandler*)xptr;
        case 31: return (void*)(QXmlDeclHandler*)(QXmlDefaultHandler*)xptr;
        case 32: return (void*)(QXmlDefaultHandler*)xptr;
        default: return xptr;
      }
    case 33:   //QXmlEntityResolver
      switch(to) {
        case 33: return (void*)(QXmlEntityResolver*)xptr;
        case 32: return (void*)(QXmlDefaultHandler*)(QXmlEntityResolver*)xptr;
        default: return xptr;
      }
    case 34:   //QXmlErrorHandler
      switch(to) {
        case 34: return (void*)(QXmlErrorHandler*)xptr;
        case 32: return (void*)(QXmlDefaultHandler*)(QXmlErrorHandler*)xptr;
        default: return xptr;
      }
    case 35:   //QXmlInputSource
      switch(to) {
        case 35: return (void*)(QXmlInputSource*)xptr;
        default: return xptr;
      }
    case 36:   //QXmlLexicalHandler
      switch(to) {
        case 36: return (void*)(QXmlLexicalHandler*)xptr;
        case 32: return (void*)(QXmlDefaultHandler*)(QXmlLexicalHandler*)xptr;
        default: return xptr;
      }
    case 37:   //QXmlLocator
      switch(to) {
        case 37: return (void*)(QXmlLocator*)xptr;
        default: return xptr;
      }
    case 38:   //QXmlNamespaceSupport
      switch(to) {
        case 38: return (void*)(QXmlNamespaceSupport*)xptr;
        default: return xptr;
      }
    case 39:   //QXmlParseException
      switch(to) {
        case 39: return (void*)(QXmlParseException*)xptr;
        default: return xptr;
      }
    case 40:   //QXmlReader
      switch(to) {
        case 40: return (void*)(QXmlReader*)xptr;
        case 41: return (void*)(QXmlSimpleReader*)(QXmlReader*)xptr;
        default: return xptr;
      }
    case 41:   //QXmlSimpleReader
      switch(to) {
        case 40: return (void*)(QXmlReader*)(QXmlSimpleReader*)xptr;
        case 41: return (void*)(QXmlSimpleReader*)xptr;
        default: return xptr;
      }
    case 42:   //QXmlStreamAttribute
      switch(to) {
        case 42: return (void*)(QXmlStreamAttribute*)xptr;
        default: return xptr;
      }
    case 43:   //QXmlStreamAttributes
      switch(to) {
        case 43: return (void*)(QXmlStreamAttributes*)xptr;
        default: return xptr;
      }
    case 44:   //QXmlStreamReader
      switch(to) {
        case 44: return (void*)(QXmlStreamReader*)xptr;
        default: return xptr;
      }
    case 45:   //QXmlStreamWriter
      switch(to) {
        case 45: return (void*)(QXmlStreamWriter*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    16, 0,	// 1: QDomNode
    21, 0,	// 3: QDomText
    6, 0,	// 5: QDomCharacterData
    29, 34, 30, 33, 36, 31, 0,	// 7: QXmlContentHandler, QXmlErrorHandler, QXmlDTDHandler, QXmlEntityResolver, QXmlLexicalHandler, QXmlDeclHandler
    40, 0,	// 14: QXmlReader
};

// These are the xenum functions for manipulating enum pointers
void xenum_QDomImplementation(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QDomNode(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QDomAttr(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomCDATASection(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomCharacterData(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomComment(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomDocument(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomDocumentFragment(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomDocumentType(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomElement(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomEntity(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomEntityReference(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomImplementation(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomNamedNodeMap(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomNode(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomNodeList(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomNotation(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomProcessingInstruction(Smoke::Index, void*, Smoke::Stack);
void xcall_QDomText(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlAttributes(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlContentHandler(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlDTDHandler(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlDeclHandler(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlDefaultHandler(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlEntityResolver(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlErrorHandler(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlInputSource(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlLexicalHandler(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlLocator(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlNamespaceSupport(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlParseException(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlReader(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlSimpleReader(Smoke::Index, void*, Smoke::Stack);
void xcall_QXmlStreamWriter(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QBool", true, 0, 0, 0, 0, 0 },	//1
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//2
    { "QChar", true, 0, 0, 0, 0, 0 },	//3
    { "QDomAttr", false, 1, xcall_QDomAttr, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomAttr) },	//4
    { "QDomCDATASection", false, 3, xcall_QDomCDATASection, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomCDATASection) },	//5
    { "QDomCharacterData", false, 1, xcall_QDomCharacterData, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomCharacterData) },	//6
    { "QDomComment", false, 5, xcall_QDomComment, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomComment) },	//7
    { "QDomDocument", false, 1, xcall_QDomDocument, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomDocument) },	//8
    { "QDomDocumentFragment", false, 1, xcall_QDomDocumentFragment, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomDocumentFragment) },	//9
    { "QDomDocumentType", false, 1, xcall_QDomDocumentType, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomDocumentType) },	//10
    { "QDomElement", false, 1, xcall_QDomElement, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomElement) },	//11
    { "QDomEntity", false, 1, xcall_QDomEntity, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomEntity) },	//12
    { "QDomEntityReference", false, 1, xcall_QDomEntityReference, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomEntityReference) },	//13
    { "QDomImplementation", false, 0, xcall_QDomImplementation, xenum_QDomImplementation, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomImplementation) },	//14
    { "QDomNamedNodeMap", false, 0, xcall_QDomNamedNodeMap, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomNamedNodeMap) },	//15
    { "QDomNode", false, 0, xcall_QDomNode, xenum_QDomNode, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomNode) },	//16
    { "QDomNodeList", false, 0, xcall_QDomNodeList, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomNodeList) },	//17
    { "QDomNodePrivate", true, 0, 0, 0, 0, 0 },	//18
    { "QDomNotation", false, 1, xcall_QDomNotation, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomNotation) },	//19
    { "QDomProcessingInstruction", false, 1, xcall_QDomProcessingInstruction, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomProcessingInstruction) },	//20
    { "QDomText", false, 5, xcall_QDomText, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QDomText) },	//21
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//22
    { "QIODevice", true, 0, 0, 0, 0, 0 },	//23
    { "QLatin1String", true, 0, 0, 0, 0, 0 },	//24
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//25
    { "QTextCodec", true, 0, 0, 0, 0, 0 },	//26
    { "QTextStream", true, 0, 0, 0, 0, 0 },	//27
    { "QXmlAttributes", false, 0, xcall_QXmlAttributes, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QXmlAttributes) },	//28
    { "QXmlContentHandler", false, 0, xcall_QXmlContentHandler, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QXmlContentHandler) },	//29
    { "QXmlDTDHandler", false, 0, xcall_QXmlDTDHandler, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QXmlDTDHandler) },	//30
    { "QXmlDeclHandler", false, 0, xcall_QXmlDeclHandler, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QXmlDeclHandler) },	//31
    { "QXmlDefaultHandler", false, 7, xcall_QXmlDefaultHandler, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QXmlDefaultHandler) },	//32
    { "QXmlEntityResolver", false, 0, xcall_QXmlEntityResolver, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QXmlEntityResolver) },	//33
    { "QXmlErrorHandler", false, 0, xcall_QXmlErrorHandler, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QXmlErrorHandler) },	//34
    { "QXmlInputSource", false, 0, xcall_QXmlInputSource, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QXmlInputSource) },	//35
    { "QXmlLexicalHandler", false, 0, xcall_QXmlLexicalHandler, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QXmlLexicalHandler) },	//36
    { "QXmlLocator", false, 0, xcall_QXmlLocator, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QXmlLocator) },	//37
    { "QXmlNamespaceSupport", false, 0, xcall_QXmlNamespaceSupport, 0, Smoke::cf_constructor, sizeof(QXmlNamespaceSupport) },	//38
    { "QXmlParseException", false, 0, xcall_QXmlParseException, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QXmlParseException) },	//39
    { "QXmlReader", false, 0, xcall_QXmlReader, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QXmlReader) },	//40
    { "QXmlSimpleReader", false, 14, xcall_QXmlSimpleReader, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QXmlSimpleReader) },	//41
    { "QXmlStreamAttribute", true, 0, 0, 0, 0, 0 },	//42
    { "QXmlStreamAttributes", true, 0, 0, 0, 0, 0 },	//43
    { "QXmlStreamReader", true, 0, 0, 0, 0, 0 },	//44
    { "QXmlStreamWriter", false, 0, xcall_QXmlStreamWriter, 0, Smoke::cf_constructor, sizeof(QXmlStreamWriter) },	//45
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QBool", 1, Smoke::t_class|Smoke::tf_stack },	//1
    { "QByteArray", 2, Smoke::t_class|Smoke::tf_stack },	//2
    { "QByteArray*", 2, Smoke::t_class|Smoke::tf_ptr },	//3
    { "QChar", 3, Smoke::t_class|Smoke::tf_stack },	//4
    { "QDomAttr", 4, Smoke::t_class|Smoke::tf_stack },	//5
    { "QDomAttr&", 4, Smoke::t_class|Smoke::tf_ref },	//6
    { "QDomAttr*", 4, Smoke::t_class|Smoke::tf_ptr },	//7
    { "QDomCDATASection", 5, Smoke::t_class|Smoke::tf_stack },	//8
    { "QDomCDATASection&", 5, Smoke::t_class|Smoke::tf_ref },	//9
    { "QDomCDATASection*", 5, Smoke::t_class|Smoke::tf_ptr },	//10
    { "QDomCharacterData", 6, Smoke::t_class|Smoke::tf_stack },	//11
    { "QDomCharacterData&", 6, Smoke::t_class|Smoke::tf_ref },	//12
    { "QDomCharacterData*", 6, Smoke::t_class|Smoke::tf_ptr },	//13
    { "QDomComment", 7, Smoke::t_class|Smoke::tf_stack },	//14
    { "QDomComment&", 7, Smoke::t_class|Smoke::tf_ref },	//15
    { "QDomComment*", 7, Smoke::t_class|Smoke::tf_ptr },	//16
    { "QDomDocument", 8, Smoke::t_class|Smoke::tf_stack },	//17
    { "QDomDocument&", 8, Smoke::t_class|Smoke::tf_ref },	//18
    { "QDomDocument*", 8, Smoke::t_class|Smoke::tf_ptr },	//19
    { "QDomDocumentFragment", 9, Smoke::t_class|Smoke::tf_stack },	//20
    { "QDomDocumentFragment&", 9, Smoke::t_class|Smoke::tf_ref },	//21
    { "QDomDocumentFragment*", 9, Smoke::t_class|Smoke::tf_ptr },	//22
    { "QDomDocumentType", 10, Smoke::t_class|Smoke::tf_stack },	//23
    { "QDomDocumentType&", 10, Smoke::t_class|Smoke::tf_ref },	//24
    { "QDomDocumentType*", 10, Smoke::t_class|Smoke::tf_ptr },	//25
    { "QDomElement", 11, Smoke::t_class|Smoke::tf_stack },	//26
    { "QDomElement&", 11, Smoke::t_class|Smoke::tf_ref },	//27
    { "QDomElement*", 11, Smoke::t_class|Smoke::tf_ptr },	//28
    { "QDomEntity", 12, Smoke::t_class|Smoke::tf_stack },	//29
    { "QDomEntity&", 12, Smoke::t_class|Smoke::tf_ref },	//30
    { "QDomEntity*", 12, Smoke::t_class|Smoke::tf_ptr },	//31
    { "QDomEntityReference", 13, Smoke::t_class|Smoke::tf_stack },	//32
    { "QDomEntityReference&", 13, Smoke::t_class|Smoke::tf_ref },	//33
    { "QDomEntityReference*", 13, Smoke::t_class|Smoke::tf_ptr },	//34
    { "QDomImplementation", 14, Smoke::t_class|Smoke::tf_stack },	//35
    { "QDomImplementation&", 14, Smoke::t_class|Smoke::tf_ref },	//36
    { "QDomImplementation*", 14, Smoke::t_class|Smoke::tf_ptr },	//37
    { "QDomImplementation::InvalidDataPolicy", 14, Smoke::t_enum|Smoke::tf_stack },	//38
    { "QDomNamedNodeMap", 15, Smoke::t_class|Smoke::tf_stack },	//39
    { "QDomNamedNodeMap&", 15, Smoke::t_class|Smoke::tf_ref },	//40
    { "QDomNamedNodeMap*", 15, Smoke::t_class|Smoke::tf_ptr },	//41
    { "QDomNode", 16, Smoke::t_class|Smoke::tf_stack },	//42
    { "QDomNode&", 16, Smoke::t_class|Smoke::tf_ref },	//43
    { "QDomNode*", 16, Smoke::t_class|Smoke::tf_ptr },	//44
    { "QDomNode::EncodingPolicy", 16, Smoke::t_enum|Smoke::tf_stack },	//45
    { "QDomNode::NodeType", 16, Smoke::t_enum|Smoke::tf_stack },	//46
    { "QDomNodeList", 17, Smoke::t_class|Smoke::tf_stack },	//47
    { "QDomNodeList&", 17, Smoke::t_class|Smoke::tf_ref },	//48
    { "QDomNodeList*", 17, Smoke::t_class|Smoke::tf_ptr },	//49
    { "QDomNodePrivate*", 18, Smoke::t_class|Smoke::tf_ptr },	//50
    { "QDomNotation", 19, Smoke::t_class|Smoke::tf_stack },	//51
    { "QDomNotation&", 19, Smoke::t_class|Smoke::tf_ref },	//52
    { "QDomNotation*", 19, Smoke::t_class|Smoke::tf_ptr },	//53
    { "QDomProcessingInstruction", 20, Smoke::t_class|Smoke::tf_stack },	//54
    { "QDomProcessingInstruction&", 20, Smoke::t_class|Smoke::tf_ref },	//55
    { "QDomProcessingInstruction*", 20, Smoke::t_class|Smoke::tf_ptr },	//56
    { "QDomText", 21, Smoke::t_class|Smoke::tf_stack },	//57
    { "QDomText&", 21, Smoke::t_class|Smoke::tf_ref },	//58
    { "QDomText*", 21, Smoke::t_class|Smoke::tf_ptr },	//59
    { "QIODevice*", 23, Smoke::t_class|Smoke::tf_ptr },	//60
    { "QRegExp&", 25, Smoke::t_class|Smoke::tf_ref },	//61
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//62
    { "QString&", 0, Smoke::t_voidp|Smoke::tf_ref },	//63
    { "QString*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//64
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//65
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//66
    { "QTextCodec*", 26, Smoke::t_class|Smoke::tf_ptr },	//67
    { "QTextStream&", 27, Smoke::t_class|Smoke::tf_ref },	//68
    { "QXmlAttributes*", 28, Smoke::t_class|Smoke::tf_ptr },	//69
    { "QXmlContentHandler*", 29, Smoke::t_class|Smoke::tf_ptr },	//70
    { "QXmlDTDHandler*", 30, Smoke::t_class|Smoke::tf_ptr },	//71
    { "QXmlDeclHandler*", 31, Smoke::t_class|Smoke::tf_ptr },	//72
    { "QXmlDefaultHandler*", 32, Smoke::t_class|Smoke::tf_ptr },	//73
    { "QXmlEntityResolver*", 33, Smoke::t_class|Smoke::tf_ptr },	//74
    { "QXmlErrorHandler*", 34, Smoke::t_class|Smoke::tf_ptr },	//75
    { "QXmlInputSource*", 35, Smoke::t_class|Smoke::tf_ptr },	//76
    { "QXmlInputSource*&", 35, Smoke::t_class|Smoke::tf_ref|Smoke::tf_ptr },	//77
    { "QXmlLexicalHandler*", 36, Smoke::t_class|Smoke::tf_ptr },	//78
    { "QXmlLocator*", 37, Smoke::t_class|Smoke::tf_ptr },	//79
    { "QXmlNamespaceSupport*", 38, Smoke::t_class|Smoke::tf_ptr },	//80
    { "QXmlParseException*", 39, Smoke::t_class|Smoke::tf_ptr },	//81
    { "QXmlReader*", 40, Smoke::t_class|Smoke::tf_ptr },	//82
    { "QXmlSimpleReader*", 41, Smoke::t_class|Smoke::tf_ptr },	//83
    { "QXmlStreamWriter*", 45, Smoke::t_class|Smoke::tf_ptr },	//84
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//85
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//86
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//87
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//88
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//89
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//90
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//91
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//92
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//93
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//94
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//95
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//96
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//97
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//98
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//99
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//100
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//101
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//102
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//103
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//104
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//105
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//106
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//107
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//108
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//109
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//110
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//111
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//112
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//113
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//114
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//115
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//116
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//117
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//118
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//119
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//120
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//121
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//122
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//123
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//124
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//125
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//126
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//127
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//128
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//129
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//130
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//131
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//132
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//133
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//134
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//135
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//136
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//137
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//138
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//139
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//140
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//141
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//142
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//143
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//144
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//145
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//146
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//147
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//148
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//149
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//150
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//151
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//152
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//153
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//154
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//155
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//156
    { "QtConcurrent::ReduceOption", 0, Smoke::t_enum|Smoke::tf_stack },	//157
    { "QtConcurrent::ThreadFunctionResult", 0, Smoke::t_enum|Smoke::tf_stack },	//158
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//159
    { "bool*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//160
    { "const QByteArray&", 2, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//161
    { "const QDomAttr&", 4, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//162
    { "const QDomCDATASection&", 5, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//163
    { "const QDomCharacterData&", 6, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//164
    { "const QDomComment&", 7, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//165
    { "const QDomDocument&", 8, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//166
    { "const QDomDocumentFragment&", 9, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//167
    { "const QDomDocumentType&", 10, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//168
    { "const QDomElement&", 11, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//169
    { "const QDomEntity&", 12, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//170
    { "const QDomEntityReference&", 13, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//171
    { "const QDomImplementation&", 14, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//172
    { "const QDomNamedNodeMap&", 15, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//173
    { "const QDomNode&", 16, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//174
    { "const QDomNodeList&", 17, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//175
    { "const QDomNotation&", 19, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//176
    { "const QDomProcessingInstruction&", 20, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//177
    { "const QDomText&", 21, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//178
    { "const QLatin1String&", 24, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//179
    { "const QRegExp&", 25, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//180
    { "const QString", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//181
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//182
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//183
    { "const QXmlAttributes&", 28, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//184
    { "const QXmlContentHandler&", 29, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//185
    { "const QXmlDTDHandler&", 30, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//186
    { "const QXmlDeclHandler&", 31, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//187
    { "const QXmlEntityResolver&", 33, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//188
    { "const QXmlErrorHandler&", 34, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//189
    { "const QXmlInputSource&", 35, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//190
    { "const QXmlInputSource*", 35, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//191
    { "const QXmlLexicalHandler&", 36, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//192
    { "const QXmlLocator&", 37, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//193
    { "const QXmlParseException&", 39, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//194
    { "const QXmlReader&", 40, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//195
    { "const QXmlStreamAttribute&", 42, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//196
    { "const QXmlStreamAttributes&", 43, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//197
    { "const QXmlStreamReader&", 44, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//198
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//199
    { "const unsigned short", 0, Smoke::t_ushort|Smoke::tf_stack|Smoke::tf_const },	//200
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//201
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//202
    { "float", 0, Smoke::t_float|Smoke::tf_stack },	//203
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//204
    { "int*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//205
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//206
    { "long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//207
    { "unsigned int", 0, Smoke::t_uint|Smoke::tf_stack },	//208
    { "unsigned long", 0, Smoke::t_ulong|Smoke::tf_stack },	//209
    { "unsigned long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//210
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//211
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//212
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    162, 0,	//1  const QDomAttr&
    182, 0,	//3  const QString&
    163, 0,	//5  const QDomCDATASection&
    164, 0,	//7  const QDomCharacterData&
    209, 209, 0,	//9  unsigned long, unsigned long
    209, 182, 0,	//12  unsigned long, const QString&
    209, 209, 182, 0,	//15  unsigned long, unsigned long, const QString&
    165, 0,	//19  const QDomComment&
    168, 0,	//21  const QDomDocumentType&
    166, 0,	//23  const QDomDocument&
    182, 182, 0,	//25  const QString&, const QString&
    174, 159, 0,	//28  const QDomNode&, bool
    161, 159, 64, 205, 205, 0,	//31  const QByteArray&, bool, QString*, int*, int*
    182, 159, 64, 205, 205, 0,	//37  const QString&, bool, QString*, int*, int*
    60, 159, 64, 205, 205, 0,	//43  QIODevice*, bool, QString*, int*, int*
    76, 159, 64, 205, 205, 0,	//49  QXmlInputSource*, bool, QString*, int*, int*
    161, 64, 205, 205, 0,	//55  const QByteArray&, QString*, int*, int*
    182, 64, 205, 205, 0,	//60  const QString&, QString*, int*, int*
    60, 64, 205, 205, 0,	//65  QIODevice*, QString*, int*, int*
    76, 82, 64, 205, 205, 0,	//70  QXmlInputSource*, QXmlReader*, QString*, int*, int*
    204, 0,	//76  int
    161, 159, 0,	//78  const QByteArray&, bool
    161, 159, 64, 0,	//81  const QByteArray&, bool, QString*
    161, 159, 64, 205, 0,	//85  const QByteArray&, bool, QString*, int*
    182, 159, 0,	//90  const QString&, bool
    182, 159, 64, 0,	//93  const QString&, bool, QString*
    182, 159, 64, 205, 0,	//97  const QString&, bool, QString*, int*
    60, 159, 0,	//102  QIODevice*, bool
    60, 159, 64, 0,	//105  QIODevice*, bool, QString*
    60, 159, 64, 205, 0,	//109  QIODevice*, bool, QString*, int*
    76, 159, 0,	//114  QXmlInputSource*, bool
    76, 159, 64, 0,	//117  QXmlInputSource*, bool, QString*
    76, 159, 64, 205, 0,	//121  QXmlInputSource*, bool, QString*, int*
    161, 0,	//126  const QByteArray&
    161, 64, 0,	//128  const QByteArray&, QString*
    161, 64, 205, 0,	//131  const QByteArray&, QString*, int*
    182, 64, 0,	//135  const QString&, QString*
    182, 64, 205, 0,	//138  const QString&, QString*, int*
    60, 0,	//142  QIODevice*
    60, 64, 0,	//144  QIODevice*, QString*
    60, 64, 205, 0,	//147  QIODevice*, QString*, int*
    76, 82, 0,	//151  QXmlInputSource*, QXmlReader*
    76, 82, 64, 0,	//154  QXmlInputSource*, QXmlReader*, QString*
    76, 82, 64, 205, 0,	//158  QXmlInputSource*, QXmlReader*, QString*, int*
    167, 0,	//163  const QDomDocumentFragment&
    169, 0,	//165  const QDomElement&
    182, 207, 0,	//167  const QString&, long long
    182, 210, 0,	//170  const QString&, unsigned long long
    182, 204, 0,	//173  const QString&, int
    182, 208, 0,	//176  const QString&, unsigned int
    182, 203, 0,	//179  const QString&, float
    182, 202, 0,	//182  const QString&, double
    181, 182, 182, 0,	//185  const QString, const QString&, const QString&
    181, 182, 204, 0,	//189  const QString, const QString&, int
    181, 182, 208, 0,	//193  const QString, const QString&, unsigned int
    181, 182, 207, 0,	//197  const QString, const QString&, long long
    181, 182, 210, 0,	//201  const QString, const QString&, unsigned long long
    181, 182, 202, 0,	//205  const QString, const QString&, double
    181, 182, 0,	//209  const QString, const QString&
    170, 0,	//212  const QDomEntity&
    171, 0,	//214  const QDomEntityReference&
    172, 0,	//216  const QDomImplementation&
    182, 182, 182, 0,	//218  const QString&, const QString&, const QString&
    182, 182, 168, 0,	//222  const QString&, const QString&, const QDomDocumentType&
    38, 0,	//226  QDomImplementation::InvalidDataPolicy
    173, 0,	//228  const QDomNamedNodeMap&
    174, 0,	//230  const QDomNode&
    174, 174, 0,	//232  const QDomNode&, const QDomNode&
    159, 0,	//235  bool
    68, 204, 0,	//237  QTextStream&, int
    68, 204, 45, 0,	//240  QTextStream&, int, QDomNode::EncodingPolicy
    50, 0,	//244  QDomNodePrivate*
    175, 0,	//246  const QDomNodeList&
    176, 0,	//248  const QDomNotation&
    177, 0,	//250  const QDomProcessingInstruction&
    178, 0,	//252  const QDomText&
    68, 174, 0,	//254  QTextStream&, const QDomNode&
    179, 0,	//257  const QLatin1String&
    182, 182, 182, 182, 0,	//259  const QString&, const QString&, const QString&, const QString&
    184, 0,	//264  const QXmlAttributes&
    79, 0,	//266  QXmlLocator*
    182, 182, 182, 184, 0,	//268  const QString&, const QString&, const QString&, const QXmlAttributes&
    185, 0,	//273  const QXmlContentHandler&
    186, 0,	//275  const QXmlDTDHandler&
    182, 182, 182, 182, 182, 0,	//277  const QString&, const QString&, const QString&, const QString&, const QString&
    187, 0,	//283  const QXmlDeclHandler&
    194, 0,	//285  const QXmlParseException&
    182, 182, 77, 0,	//287  const QString&, const QString&, QXmlInputSource*&
    188, 0,	//291  const QXmlEntityResolver&
    189, 0,	//293  const QXmlErrorHandler&
    190, 0,	//295  const QXmlInputSource&
    192, 0,	//297  const QXmlLexicalHandler&
    193, 0,	//299  const QXmlLocator&
    182, 63, 63, 0,	//301  const QString&, QString&, QString&
    182, 159, 63, 63, 0,	//305  const QString&, bool, QString&, QString&
    182, 204, 204, 182, 182, 0,	//310  const QString&, int, int, const QString&, const QString&
    182, 204, 204, 0,	//316  const QString&, int, int
    182, 204, 204, 182, 0,	//320  const QString&, int, int, const QString&
    182, 160, 0,	//325  const QString&, bool*
    182, 211, 0,	//328  const QString&, void*
    74, 0,	//331  QXmlEntityResolver*
    71, 0,	//333  QXmlDTDHandler*
    70, 0,	//335  QXmlContentHandler*
    75, 0,	//337  QXmlErrorHandler*
    78, 0,	//339  QXmlLexicalHandler*
    72, 0,	//341  QXmlDeclHandler*
    191, 0,	//343  const QXmlInputSource*
    195, 0,	//345  const QXmlReader&
    191, 159, 0,	//347  const QXmlInputSource*, bool
    3, 0,	//350  QByteArray*
    64, 0,	//352  QString*
    67, 0,	//354  QTextCodec*
    199, 0,	//356  const char*
    196, 0,	//358  const QXmlStreamAttribute&
    197, 0,	//360  const QXmlStreamAttributes&
    198, 0,	//362  const QXmlStreamReader&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "AcceptInvalidChars",	//1
    "AttributeNode",	//2
    "BaseNode",	//3
    "CDATASectionNode",	//4
    "CharacterDataNode",	//5
    "CommentNode",	//6
    "DTDHandler",	//7
    "DocumentFragmentNode",	//8
    "DocumentNode",	//9
    "DocumentTypeNode",	//10
    "DropInvalidChars",	//11
    "ElementNode",	//12
    "EncodingFromDocument",	//13
    "EncodingFromTextStream",	//14
    "EndOfData",	//15
    "EndOfDocument",	//16
    "EntityNode",	//17
    "EntityReferenceNode",	//18
    "NotationNode",	//19
    "ProcessingInstructionNode",	//20
    "QDomAttr",	//21
    "QDomAttr#",	//22
    "QDomCDATASection",	//23
    "QDomCDATASection#",	//24
    "QDomCharacterData",	//25
    "QDomCharacterData#",	//26
    "QDomComment",	//27
    "QDomComment#",	//28
    "QDomDocument",	//29
    "QDomDocument#",	//30
    "QDomDocument$",	//31
    "QDomDocumentFragment",	//32
    "QDomDocumentFragment#",	//33
    "QDomDocumentType",	//34
    "QDomDocumentType#",	//35
    "QDomElement",	//36
    "QDomElement#",	//37
    "QDomEntity",	//38
    "QDomEntity#",	//39
    "QDomEntityReference",	//40
    "QDomEntityReference#",	//41
    "QDomImplementation",	//42
    "QDomImplementation#",	//43
    "QDomNamedNodeMap",	//44
    "QDomNamedNodeMap#",	//45
    "QDomNode",	//46
    "QDomNode#",	//47
    "QDomNodeList",	//48
    "QDomNodeList#",	//49
    "QDomNotation",	//50
    "QDomNotation#",	//51
    "QDomProcessingInstruction",	//52
    "QDomProcessingInstruction#",	//53
    "QDomText",	//54
    "QDomText#",	//55
    "QXmlAttributes",	//56
    "QXmlAttributes#",	//57
    "QXmlContentHandler",	//58
    "QXmlContentHandler#",	//59
    "QXmlDTDHandler",	//60
    "QXmlDTDHandler#",	//61
    "QXmlDeclHandler",	//62
    "QXmlDeclHandler#",	//63
    "QXmlDefaultHandler",	//64
    "QXmlEntityResolver",	//65
    "QXmlEntityResolver#",	//66
    "QXmlErrorHandler",	//67
    "QXmlErrorHandler#",	//68
    "QXmlInputSource",	//69
    "QXmlInputSource#",	//70
    "QXmlLexicalHandler",	//71
    "QXmlLexicalHandler#",	//72
    "QXmlLocator",	//73
    "QXmlLocator#",	//74
    "QXmlNamespaceSupport",	//75
    "QXmlParseException",	//76
    "QXmlParseException#",	//77
    "QXmlParseException$",	//78
    "QXmlParseException$$",	//79
    "QXmlParseException$$$",	//80
    "QXmlParseException$$$$",	//81
    "QXmlParseException$$$$$",	//82
    "QXmlReader",	//83
    "QXmlReader#",	//84
    "QXmlSimpleReader",	//85
    "QXmlStreamWriter",	//86
    "QXmlStreamWriter#",	//87
    "QXmlStreamWriter$",	//88
    "ReturnNullNode",	//89
    "TextNode",	//90
    "append",	//91
    "append$$$$",	//92
    "appendChild",	//93
    "appendChild#",	//94
    "appendData",	//95
    "appendData$",	//96
    "at",	//97
    "at$",	//98
    "attribute",	//99
    "attribute$",	//100
    "attribute$$",	//101
    "attributeDecl",	//102
    "attributeDecl$$$$$",	//103
    "attributeNS",	//104
    "attributeNS$$",	//105
    "attributeNS$$$",	//106
    "attributeNode",	//107
    "attributeNode$",	//108
    "attributeNodeNS",	//109
    "attributeNodeNS$$",	//110
    "attributes",	//111
    "autoFormatting",	//112
    "autoFormattingIndent",	//113
    "characters",	//114
    "characters$",	//115
    "childNodes",	//116
    "clear",	//117
    "cloneNode",	//118
    "cloneNode$",	//119
    "codec",	//120
    "columnNumber",	//121
    "comment",	//122
    "comment$",	//123
    "contains",	//124
    "contains$",	//125
    "contentHandler",	//126
    "count",	//127
    "createAttribute",	//128
    "createAttribute$",	//129
    "createAttributeNS",	//130
    "createAttributeNS$$",	//131
    "createCDATASection",	//132
    "createCDATASection$",	//133
    "createComment",	//134
    "createComment$",	//135
    "createDocument",	//136
    "createDocument$$#",	//137
    "createDocumentFragment",	//138
    "createDocumentType",	//139
    "createDocumentType$$$",	//140
    "createElement",	//141
    "createElement$",	//142
    "createElementNS",	//143
    "createElementNS$$",	//144
    "createEntityReference",	//145
    "createEntityReference$",	//146
    "createProcessingInstruction",	//147
    "createProcessingInstruction$$",	//148
    "createTextNode",	//149
    "createTextNode$",	//150
    "data",	//151
    "declHandler",	//152
    "deleteData",	//153
    "deleteData$$",	//154
    "device",	//155
    "doctype",	//156
    "documentElement",	//157
    "elementById",	//158
    "elementById$",	//159
    "elementsByTagName",	//160
    "elementsByTagName$",	//161
    "elementsByTagNameNS",	//162
    "elementsByTagNameNS$$",	//163
    "endCDATA",	//164
    "endDTD",	//165
    "endDocument",	//166
    "endElement",	//167
    "endElement$$$",	//168
    "endEntity",	//169
    "endEntity$",	//170
    "endPrefixMapping",	//171
    "endPrefixMapping$",	//172
    "entities",	//173
    "entityResolver",	//174
    "error",	//175
    "error#",	//176
    "errorHandler",	//177
    "errorString",	//178
    "externalEntityDecl",	//179
    "externalEntityDecl$$$",	//180
    "fatalError",	//181
    "fatalError#",	//182
    "feature",	//183
    "feature$",	//184
    "feature$$",	//185
    "fetchData",	//186
    "firstChild",	//187
    "firstChildElement",	//188
    "firstChildElement$",	//189
    "fromRawData",	//190
    "fromRawData#",	//191
    "fromRawData#$",	//192
    "hasAttribute",	//193
    "hasAttribute$",	//194
    "hasAttributeNS",	//195
    "hasAttributeNS$$",	//196
    "hasAttributes",	//197
    "hasChildNodes",	//198
    "hasError",	//199
    "hasFeature",	//200
    "hasFeature$",	//201
    "hasFeature$$",	//202
    "hasProperty",	//203
    "hasProperty$",	//204
    "ignorableWhitespace",	//205
    "ignorableWhitespace$",	//206
    "impl",	//207
    "implementation",	//208
    "importNode",	//209
    "importNode#$",	//210
    "index",	//211
    "index#",	//212
    "index$",	//213
    "index$$",	//214
    "insertAfter",	//215
    "insertAfter##",	//216
    "insertBefore",	//217
    "insertBefore##",	//218
    "insertData",	//219
    "insertData$$",	//220
    "internalEntityDecl",	//221
    "internalEntityDecl$$",	//222
    "internalSubset",	//223
    "invalidDataPolicy",	//224
    "isAttr",	//225
    "isCDATASection",	//226
    "isCharacterData",	//227
    "isComment",	//228
    "isDocument",	//229
    "isDocumentFragment",	//230
    "isDocumentType",	//231
    "isElement",	//232
    "isEmpty",	//233
    "isEntity",	//234
    "isEntityReference",	//235
    "isNotation",	//236
    "isNull",	//237
    "isProcessingInstruction",	//238
    "isSupported",	//239
    "isSupported$$",	//240
    "isText",	//241
    "item",	//242
    "item$",	//243
    "lastChild",	//244
    "lastChildElement",	//245
    "lastChildElement$",	//246
    "length",	//247
    "lexicalHandler",	//248
    "lineNumber",	//249
    "localName",	//250
    "localName$",	//251
    "message",	//252
    "name",	//253
    "namedItem",	//254
    "namedItem$",	//255
    "namedItemNS",	//256
    "namedItemNS$$",	//257
    "namespaceURI",	//258
    "next",	//259
    "nextSibling",	//260
    "nextSiblingElement",	//261
    "nextSiblingElement$",	//262
    "nodeName",	//263
    "nodeType",	//264
    "nodeValue",	//265
    "normalize",	//266
    "notationDecl",	//267
    "notationDecl$$$",	//268
    "notationName",	//269
    "notations",	//270
    "operator!=",	//271
    "operator!=#",	//272
    "operator<<",	//273
    "operator<<##",	//274
    "operator=",	//275
    "operator=#",	//276
    "operator==",	//277
    "operator==#",	//278
    "ownerDocument",	//279
    "ownerElement",	//280
    "parentNode",	//281
    "parse",	//282
    "parse#",	//283
    "parse#$",	//284
    "parseContinue",	//285
    "popContext",	//286
    "prefix",	//287
    "prefix$",	//288
    "prefixes",	//289
    "prefixes$",	//290
    "previousSibling",	//291
    "previousSiblingElement",	//292
    "previousSiblingElement$",	//293
    "processName",	//294
    "processName$$$$",	//295
    "processingInstruction",	//296
    "processingInstruction$$",	//297
    "property",	//298
    "property$",	//299
    "property$$",	//300
    "publicId",	//301
    "pushContext",	//302
    "qName",	//303
    "qName$",	//304
    "removeAttribute",	//305
    "removeAttribute$",	//306
    "removeAttributeNS",	//307
    "removeAttributeNS$$",	//308
    "removeAttributeNode",	//309
    "removeAttributeNode#",	//310
    "removeChild",	//311
    "removeChild#",	//312
    "removeNamedItem",	//313
    "removeNamedItem$",	//314
    "removeNamedItemNS",	//315
    "removeNamedItemNS$$",	//316
    "replaceChild",	//317
    "replaceChild##",	//318
    "replaceData",	//319
    "replaceData$$$",	//320
    "reset",	//321
    "resolveEntity",	//322
    "resolveEntity$$#",	//323
    "save",	//324
    "save#$",	//325
    "save#$$",	//326
    "setAttribute",	//327
    "setAttribute$$",	//328
    "setAttributeNS",	//329
    "setAttributeNS$$$",	//330
    "setAttributeNode",	//331
    "setAttributeNode#",	//332
    "setAttributeNodeNS",	//333
    "setAttributeNodeNS#",	//334
    "setAutoFormatting",	//335
    "setAutoFormatting$",	//336
    "setAutoFormattingIndent",	//337
    "setAutoFormattingIndent$",	//338
    "setCodec",	//339
    "setCodec#",	//340
    "setCodec$",	//341
    "setContent",	//342
    "setContent#",	//343
    "setContent##",	//344
    "setContent##$",	//345
    "setContent##$$",	//346
    "setContent##$$$",	//347
    "setContent#$",	//348
    "setContent#$$",	//349
    "setContent#$$$",	//350
    "setContent#$$$$",	//351
    "setContent$",	//352
    "setContent$$",	//353
    "setContent$$$",	//354
    "setContent$$$$",	//355
    "setContent$$$$$",	//356
    "setContentHandler",	//357
    "setContentHandler#",	//358
    "setDTDHandler",	//359
    "setDTDHandler#",	//360
    "setData",	//361
    "setData#",	//362
    "setData$",	//363
    "setDeclHandler",	//364
    "setDeclHandler#",	//365
    "setDevice",	//366
    "setDevice#",	//367
    "setDocumentLocator",	//368
    "setDocumentLocator#",	//369
    "setEntityResolver",	//370
    "setEntityResolver#",	//371
    "setErrorHandler",	//372
    "setErrorHandler#",	//373
    "setFeature",	//374
    "setFeature$$",	//375
    "setImpl",	//376
    "setImpl#",	//377
    "setInvalidDataPolicy",	//378
    "setInvalidDataPolicy$",	//379
    "setLexicalHandler",	//380
    "setLexicalHandler#",	//381
    "setNamedItem",	//382
    "setNamedItem#",	//383
    "setNamedItemNS",	//384
    "setNamedItemNS#",	//385
    "setNodeValue",	//386
    "setNodeValue$",	//387
    "setPrefix",	//388
    "setPrefix$",	//389
    "setPrefix$$",	//390
    "setProperty",	//391
    "setProperty$$",	//392
    "setTagName",	//393
    "setTagName$",	//394
    "setValue",	//395
    "setValue$",	//396
    "size",	//397
    "skippedEntity",	//398
    "skippedEntity$",	//399
    "specified",	//400
    "splitName",	//401
    "splitName$$$",	//402
    "splitText",	//403
    "splitText$",	//404
    "startCDATA",	//405
    "startDTD",	//406
    "startDTD$$$",	//407
    "startDocument",	//408
    "startElement",	//409
    "startElement$$$#",	//410
    "startEntity",	//411
    "startEntity$",	//412
    "startPrefixMapping",	//413
    "startPrefixMapping$$",	//414
    "substringData",	//415
    "substringData$$",	//416
    "systemId",	//417
    "tagName",	//418
    "target",	//419
    "text",	//420
    "toAttr",	//421
    "toByteArray",	//422
    "toByteArray$",	//423
    "toCDATASection",	//424
    "toCharacterData",	//425
    "toComment",	//426
    "toDocument",	//427
    "toDocumentFragment",	//428
    "toDocumentType",	//429
    "toElement",	//430
    "toEntity",	//431
    "toEntityReference",	//432
    "toNotation",	//433
    "toProcessingInstruction",	//434
    "toString",	//435
    "toString$",	//436
    "toText",	//437
    "type",	//438
    "type$",	//439
    "type$$",	//440
    "unparsedEntityDecl",	//441
    "unparsedEntityDecl$$$$",	//442
    "uri",	//443
    "uri$",	//444
    "value",	//445
    "value#",	//446
    "value$",	//447
    "value$$",	//448
    "warning",	//449
    "warning#",	//450
    "writeAttribute",	//451
    "writeAttribute#",	//452
    "writeAttribute$$",	//453
    "writeAttribute$$$",	//454
    "writeAttributes",	//455
    "writeAttributes#",	//456
    "writeCDATA",	//457
    "writeCDATA$",	//458
    "writeCharacters",	//459
    "writeCharacters$",	//460
    "writeComment",	//461
    "writeComment$",	//462
    "writeCurrentToken",	//463
    "writeCurrentToken#",	//464
    "writeDTD",	//465
    "writeDTD$",	//466
    "writeDefaultNamespace",	//467
    "writeDefaultNamespace$",	//468
    "writeEmptyElement",	//469
    "writeEmptyElement$",	//470
    "writeEmptyElement$$",	//471
    "writeEndDocument",	//472
    "writeEndElement",	//473
    "writeEntityReference",	//474
    "writeEntityReference$",	//475
    "writeNamespace",	//476
    "writeNamespace$",	//477
    "writeNamespace$$",	//478
    "writeProcessingInstruction",	//479
    "writeProcessingInstruction$",	//480
    "writeProcessingInstruction$$",	//481
    "writeStartDocument",	//482
    "writeStartDocument$",	//483
    "writeStartDocument$$",	//484
    "writeStartElement",	//485
    "writeStartElement$",	//486
    "writeStartElement$$",	//487
    "writeTextElement",	//488
    "writeTextElement$$",	//489
    "writeTextElement$$$",	//490
    "~QDomAttr",	//491
    "~QDomCDATASection",	//492
    "~QDomCharacterData",	//493
    "~QDomComment",	//494
    "~QDomDocument",	//495
    "~QDomDocumentFragment",	//496
    "~QDomDocumentType",	//497
    "~QDomElement",	//498
    "~QDomEntity",	//499
    "~QDomEntityReference",	//500
    "~QDomImplementation",	//501
    "~QDomNamedNodeMap",	//502
    "~QDomNode",	//503
    "~QDomNodeList",	//504
    "~QDomNotation",	//505
    "~QDomProcessingInstruction",	//506
    "~QDomText",	//507
    "~QXmlAttributes",	//508
    "~QXmlContentHandler",	//509
    "~QXmlDTDHandler",	//510
    "~QXmlDeclHandler",	//511
    "~QXmlDefaultHandler",	//512
    "~QXmlEntityResolver",	//513
    "~QXmlErrorHandler",	//514
    "~QXmlInputSource",	//515
    "~QXmlLexicalHandler",	//516
    "~QXmlLocator",	//517
    "~QXmlNamespaceSupport",	//518
    "~QXmlParseException",	//519
    "~QXmlReader",	//520
    "~QXmlSimpleReader",	//521
    "~QXmlStreamWriter",	//522
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {4, 21, 0, 0, Smoke::mf_ctor, 7, 1},	//1 QDomAttr::QDomAttr()
    {4, 21, 1, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 7, 2},	//2 QDomAttr::QDomAttr(const QDomAttr&)
    {4, 275, 1, 1, 0, 6, 3},	//3 QDomAttr::operator=(const QDomAttr&)
    {4, 253, 0, 0, Smoke::mf_const, 62, 4},	//4 QDomAttr::name() const
    {4, 400, 0, 0, Smoke::mf_const, 159, 5},	//5 QDomAttr::specified() const
    {4, 280, 0, 0, Smoke::mf_const, 26, 6},	//6 QDomAttr::ownerElement() const
    {4, 445, 0, 0, Smoke::mf_const, 62, 7},	//7 QDomAttr::value() const
    {4, 395, 3, 1, 0, 0, 8},	//8 QDomAttr::setValue(const QString&)
    {4, 264, 0, 0, Smoke::mf_const, 46, 9},	//9 QDomAttr::nodeType() const
    {4, 491, 0, 0, Smoke::mf_dtor, 0, 10 },	//10 QDomAttr::~QDomAttr()
    {5, 23, 0, 0, Smoke::mf_ctor, 10, 1},	//11 QDomCDATASection::QDomCDATASection()
    {5, 23, 5, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 10, 2},	//12 QDomCDATASection::QDomCDATASection(const QDomCDATASection&)
    {5, 275, 5, 1, 0, 9, 3},	//13 QDomCDATASection::operator=(const QDomCDATASection&)
    {5, 264, 0, 0, Smoke::mf_const, 46, 4},	//14 QDomCDATASection::nodeType() const
    {5, 492, 0, 0, Smoke::mf_dtor, 0, 5 },	//15 QDomCDATASection::~QDomCDATASection()
    {6, 25, 0, 0, Smoke::mf_ctor, 13, 1},	//16 QDomCharacterData::QDomCharacterData()
    {6, 25, 7, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 13, 2},	//17 QDomCharacterData::QDomCharacterData(const QDomCharacterData&)
    {6, 275, 7, 1, 0, 12, 3},	//18 QDomCharacterData::operator=(const QDomCharacterData&)
    {6, 415, 9, 2, 0, 62, 4},	//19 QDomCharacterData::substringData(unsigned long, unsigned long)
    {6, 95, 3, 1, 0, 0, 5},	//20 QDomCharacterData::appendData(const QString&)
    {6, 219, 12, 2, 0, 0, 6},	//21 QDomCharacterData::insertData(unsigned long, const QString&)
    {6, 153, 9, 2, 0, 0, 7},	//22 QDomCharacterData::deleteData(unsigned long, unsigned long)
    {6, 319, 15, 3, 0, 0, 8},	//23 QDomCharacterData::replaceData(unsigned long, unsigned long, const QString&)
    {6, 247, 0, 0, Smoke::mf_const, 208, 9},	//24 QDomCharacterData::length() const
    {6, 151, 0, 0, Smoke::mf_const, 62, 10},	//25 QDomCharacterData::data() const
    {6, 361, 3, 1, 0, 0, 11},	//26 QDomCharacterData::setData(const QString&)
    {6, 264, 0, 0, Smoke::mf_const, 46, 12},	//27 QDomCharacterData::nodeType() const
    {6, 493, 0, 0, Smoke::mf_dtor, 0, 13 },	//28 QDomCharacterData::~QDomCharacterData()
    {7, 27, 0, 0, Smoke::mf_ctor, 16, 1},	//29 QDomComment::QDomComment()
    {7, 27, 19, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 16, 2},	//30 QDomComment::QDomComment(const QDomComment&)
    {7, 275, 19, 1, 0, 15, 3},	//31 QDomComment::operator=(const QDomComment&)
    {7, 264, 0, 0, Smoke::mf_const, 46, 4},	//32 QDomComment::nodeType() const
    {7, 494, 0, 0, Smoke::mf_dtor, 0, 5 },	//33 QDomComment::~QDomComment()
    {8, 29, 0, 0, Smoke::mf_ctor, 19, 1},	//34 QDomDocument::QDomDocument()
    {8, 29, 3, 1, Smoke::mf_ctor, 19, 2},	//35 QDomDocument::QDomDocument(const QString&)
    {8, 29, 21, 1, Smoke::mf_ctor, 19, 3},	//36 QDomDocument::QDomDocument(const QDomDocumentType&)
    {8, 29, 23, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 19, 4},	//37 QDomDocument::QDomDocument(const QDomDocument&)
    {8, 275, 23, 1, 0, 18, 5},	//38 QDomDocument::operator=(const QDomDocument&)
    {8, 141, 3, 1, 0, 26, 6},	//39 QDomDocument::createElement(const QString&)
    {8, 138, 0, 0, 0, 20, 7},	//40 QDomDocument::createDocumentFragment()
    {8, 149, 3, 1, 0, 57, 8},	//41 QDomDocument::createTextNode(const QString&)
    {8, 134, 3, 1, 0, 14, 9},	//42 QDomDocument::createComment(const QString&)
    {8, 132, 3, 1, 0, 8, 10},	//43 QDomDocument::createCDATASection(const QString&)
    {8, 147, 25, 2, 0, 54, 11},	//44 QDomDocument::createProcessingInstruction(const QString&, const QString&)
    {8, 128, 3, 1, 0, 5, 12},	//45 QDomDocument::createAttribute(const QString&)
    {8, 145, 3, 1, 0, 32, 13},	//46 QDomDocument::createEntityReference(const QString&)
    {8, 160, 3, 1, Smoke::mf_const, 47, 14},	//47 QDomDocument::elementsByTagName(const QString&) const
    {8, 209, 28, 2, 0, 42, 15},	//48 QDomDocument::importNode(const QDomNode&, bool)
    {8, 143, 25, 2, 0, 26, 16},	//49 QDomDocument::createElementNS(const QString&, const QString&)
    {8, 130, 25, 2, 0, 5, 17},	//50 QDomDocument::createAttributeNS(const QString&, const QString&)
    {8, 162, 25, 2, 0, 47, 18},	//51 QDomDocument::elementsByTagNameNS(const QString&, const QString&)
    {8, 158, 3, 1, 0, 26, 19},	//52 QDomDocument::elementById(const QString&)
    {8, 156, 0, 0, Smoke::mf_const, 23, 20},	//53 QDomDocument::doctype() const
    {8, 208, 0, 0, Smoke::mf_const, 35, 21},	//54 QDomDocument::implementation() const
    {8, 157, 0, 0, Smoke::mf_const, 26, 22},	//55 QDomDocument::documentElement() const
    {8, 264, 0, 0, Smoke::mf_const, 46, 23},	//56 QDomDocument::nodeType() const
    {8, 342, 31, 5, 0, 159, 24},	//57 QDomDocument::setContent(const QByteArray&, bool, QString*, int*, int*)
    {8, 342, 37, 5, 0, 159, 25},	//58 QDomDocument::setContent(const QString&, bool, QString*, int*, int*)
    {8, 342, 43, 5, 0, 159, 26},	//59 QDomDocument::setContent(QIODevice*, bool, QString*, int*, int*)
    {8, 342, 49, 5, 0, 159, 27},	//60 QDomDocument::setContent(QXmlInputSource*, bool, QString*, int*, int*)
    {8, 342, 55, 4, 0, 159, 28},	//61 QDomDocument::setContent(const QByteArray&, QString*, int*, int*)
    {8, 342, 60, 4, 0, 159, 29},	//62 QDomDocument::setContent(const QString&, QString*, int*, int*)
    {8, 342, 65, 4, 0, 159, 30},	//63 QDomDocument::setContent(QIODevice*, QString*, int*, int*)
    {8, 342, 70, 5, 0, 159, 31},	//64 QDomDocument::setContent(QXmlInputSource*, QXmlReader*, QString*, int*, int*)
    {8, 435, 76, 1, Smoke::mf_const, 62, 32},	//65 QDomDocument::toString(int) const
    {8, 422, 76, 1, Smoke::mf_const, 2, 33},	//66 QDomDocument::toByteArray(int) const
    {8, 342, 78, 2, 0, 159, 34},	//67 QDomDocument::setContent(const QByteArray&, bool)
    {8, 342, 81, 3, 0, 159, 35},	//68 QDomDocument::setContent(const QByteArray&, bool, QString*)
    {8, 342, 85, 4, 0, 159, 36},	//69 QDomDocument::setContent(const QByteArray&, bool, QString*, int*)
    {8, 342, 90, 2, 0, 159, 37},	//70 QDomDocument::setContent(const QString&, bool)
    {8, 342, 93, 3, 0, 159, 38},	//71 QDomDocument::setContent(const QString&, bool, QString*)
    {8, 342, 97, 4, 0, 159, 39},	//72 QDomDocument::setContent(const QString&, bool, QString*, int*)
    {8, 342, 102, 2, 0, 159, 40},	//73 QDomDocument::setContent(QIODevice*, bool)
    {8, 342, 105, 3, 0, 159, 41},	//74 QDomDocument::setContent(QIODevice*, bool, QString*)
    {8, 342, 109, 4, 0, 159, 42},	//75 QDomDocument::setContent(QIODevice*, bool, QString*, int*)
    {8, 342, 114, 2, 0, 159, 43},	//76 QDomDocument::setContent(QXmlInputSource*, bool)
    {8, 342, 117, 3, 0, 159, 44},	//77 QDomDocument::setContent(QXmlInputSource*, bool, QString*)
    {8, 342, 121, 4, 0, 159, 45},	//78 QDomDocument::setContent(QXmlInputSource*, bool, QString*, int*)
    {8, 342, 126, 1, 0, 159, 46},	//79 QDomDocument::setContent(const QByteArray&)
    {8, 342, 128, 2, 0, 159, 47},	//80 QDomDocument::setContent(const QByteArray&, QString*)
    {8, 342, 131, 3, 0, 159, 48},	//81 QDomDocument::setContent(const QByteArray&, QString*, int*)
    {8, 342, 3, 1, 0, 159, 49},	//82 QDomDocument::setContent(const QString&)
    {8, 342, 135, 2, 0, 159, 50},	//83 QDomDocument::setContent(const QString&, QString*)
    {8, 342, 138, 3, 0, 159, 51},	//84 QDomDocument::setContent(const QString&, QString*, int*)
    {8, 342, 142, 1, 0, 159, 52},	//85 QDomDocument::setContent(QIODevice*)
    {8, 342, 144, 2, 0, 159, 53},	//86 QDomDocument::setContent(QIODevice*, QString*)
    {8, 342, 147, 3, 0, 159, 54},	//87 QDomDocument::setContent(QIODevice*, QString*, int*)
    {8, 342, 151, 2, 0, 159, 55},	//88 QDomDocument::setContent(QXmlInputSource*, QXmlReader*)
    {8, 342, 154, 3, 0, 159, 56},	//89 QDomDocument::setContent(QXmlInputSource*, QXmlReader*, QString*)
    {8, 342, 158, 4, 0, 159, 57},	//90 QDomDocument::setContent(QXmlInputSource*, QXmlReader*, QString*, int*)
    {8, 435, 0, 0, Smoke::mf_const, 62, 58},	//91 QDomDocument::toString() const
    {8, 422, 0, 0, Smoke::mf_const, 2, 59},	//92 QDomDocument::toByteArray() const
    {8, 495, 0, 0, Smoke::mf_dtor, 0, 60 },	//93 QDomDocument::~QDomDocument()
    {9, 32, 0, 0, Smoke::mf_ctor, 22, 1},	//94 QDomDocumentFragment::QDomDocumentFragment()
    {9, 32, 163, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 22, 2},	//95 QDomDocumentFragment::QDomDocumentFragment(const QDomDocumentFragment&)
    {9, 275, 163, 1, 0, 21, 3},	//96 QDomDocumentFragment::operator=(const QDomDocumentFragment&)
    {9, 264, 0, 0, Smoke::mf_const, 46, 4},	//97 QDomDocumentFragment::nodeType() const
    {9, 496, 0, 0, Smoke::mf_dtor, 0, 5 },	//98 QDomDocumentFragment::~QDomDocumentFragment()
    {10, 34, 0, 0, Smoke::mf_ctor, 25, 1},	//99 QDomDocumentType::QDomDocumentType()
    {10, 34, 21, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 25, 2},	//100 QDomDocumentType::QDomDocumentType(const QDomDocumentType&)
    {10, 275, 21, 1, 0, 24, 3},	//101 QDomDocumentType::operator=(const QDomDocumentType&)
    {10, 253, 0, 0, Smoke::mf_const, 62, 4},	//102 QDomDocumentType::name() const
    {10, 173, 0, 0, Smoke::mf_const, 39, 5},	//103 QDomDocumentType::entities() const
    {10, 270, 0, 0, Smoke::mf_const, 39, 6},	//104 QDomDocumentType::notations() const
    {10, 301, 0, 0, Smoke::mf_const, 62, 7},	//105 QDomDocumentType::publicId() const
    {10, 417, 0, 0, Smoke::mf_const, 62, 8},	//106 QDomDocumentType::systemId() const
    {10, 223, 0, 0, Smoke::mf_const, 62, 9},	//107 QDomDocumentType::internalSubset() const
    {10, 264, 0, 0, Smoke::mf_const, 46, 10},	//108 QDomDocumentType::nodeType() const
    {10, 497, 0, 0, Smoke::mf_dtor, 0, 11 },	//109 QDomDocumentType::~QDomDocumentType()
    {11, 36, 0, 0, Smoke::mf_ctor, 28, 1},	//110 QDomElement::QDomElement()
    {11, 36, 165, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 28, 2},	//111 QDomElement::QDomElement(const QDomElement&)
    {11, 275, 165, 1, 0, 27, 3},	//112 QDomElement::operator=(const QDomElement&)
    {11, 99, 25, 2, Smoke::mf_const, 62, 4},	//113 QDomElement::attribute(const QString&, const QString&) const
    {11, 327, 25, 2, 0, 0, 5},	//114 QDomElement::setAttribute(const QString&, const QString&)
    {11, 327, 167, 2, 0, 0, 6},	//115 QDomElement::setAttribute(const QString&, long long)
    {11, 327, 170, 2, 0, 0, 7},	//116 QDomElement::setAttribute(const QString&, unsigned long long)
    {11, 327, 173, 2, 0, 0, 8},	//117 QDomElement::setAttribute(const QString&, int)
    {11, 327, 176, 2, 0, 0, 9},	//118 QDomElement::setAttribute(const QString&, unsigned int)
    {11, 327, 179, 2, 0, 0, 10},	//119 QDomElement::setAttribute(const QString&, float)
    {11, 327, 182, 2, 0, 0, 11},	//120 QDomElement::setAttribute(const QString&, double)
    {11, 305, 3, 1, 0, 0, 12},	//121 QDomElement::removeAttribute(const QString&)
    {11, 107, 3, 1, 0, 5, 13},	//122 QDomElement::attributeNode(const QString&)
    {11, 331, 1, 1, 0, 5, 14},	//123 QDomElement::setAttributeNode(const QDomAttr&)
    {11, 309, 1, 1, 0, 5, 15},	//124 QDomElement::removeAttributeNode(const QDomAttr&)
    {11, 160, 3, 1, Smoke::mf_const, 47, 16},	//125 QDomElement::elementsByTagName(const QString&) const
    {11, 193, 3, 1, Smoke::mf_const, 159, 17},	//126 QDomElement::hasAttribute(const QString&) const
    {11, 104, 185, 3, Smoke::mf_const, 62, 18},	//127 QDomElement::attributeNS(const QString, const QString&, const QString&) const
    {11, 329, 185, 3, 0, 0, 19},	//128 QDomElement::setAttributeNS(const QString, const QString&, const QString&)
    {11, 329, 189, 3, 0, 0, 20},	//129 QDomElement::setAttributeNS(const QString, const QString&, int)
    {11, 329, 193, 3, 0, 0, 21},	//130 QDomElement::setAttributeNS(const QString, const QString&, unsigned int)
    {11, 329, 197, 3, 0, 0, 22},	//131 QDomElement::setAttributeNS(const QString, const QString&, long long)
    {11, 329, 201, 3, 0, 0, 23},	//132 QDomElement::setAttributeNS(const QString, const QString&, unsigned long long)
    {11, 329, 205, 3, 0, 0, 24},	//133 QDomElement::setAttributeNS(const QString, const QString&, double)
    {11, 307, 25, 2, 0, 0, 25},	//134 QDomElement::removeAttributeNS(const QString&, const QString&)
    {11, 109, 25, 2, 0, 5, 26},	//135 QDomElement::attributeNodeNS(const QString&, const QString&)
    {11, 333, 1, 1, 0, 5, 27},	//136 QDomElement::setAttributeNodeNS(const QDomAttr&)
    {11, 162, 25, 2, Smoke::mf_const, 47, 28},	//137 QDomElement::elementsByTagNameNS(const QString&, const QString&) const
    {11, 195, 25, 2, Smoke::mf_const, 159, 29},	//138 QDomElement::hasAttributeNS(const QString&, const QString&) const
    {11, 418, 0, 0, Smoke::mf_const, 62, 30},	//139 QDomElement::tagName() const
    {11, 393, 3, 1, 0, 0, 31},	//140 QDomElement::setTagName(const QString&)
    {11, 111, 0, 0, Smoke::mf_const, 39, 32},	//141 QDomElement::attributes() const
    {11, 264, 0, 0, Smoke::mf_const, 46, 33},	//142 QDomElement::nodeType() const
    {11, 420, 0, 0, Smoke::mf_const, 62, 34},	//143 QDomElement::text() const
    {11, 99, 3, 1, Smoke::mf_const, 62, 35},	//144 QDomElement::attribute(const QString&) const
    {11, 104, 209, 2, Smoke::mf_const, 62, 36},	//145 QDomElement::attributeNS(const QString, const QString&) const
    {11, 498, 0, 0, Smoke::mf_dtor, 0, 37 },	//146 QDomElement::~QDomElement()
    {12, 38, 0, 0, Smoke::mf_ctor, 31, 1},	//147 QDomEntity::QDomEntity()
    {12, 38, 212, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 31, 2},	//148 QDomEntity::QDomEntity(const QDomEntity&)
    {12, 275, 212, 1, 0, 30, 3},	//149 QDomEntity::operator=(const QDomEntity&)
    {12, 301, 0, 0, Smoke::mf_const, 62, 4},	//150 QDomEntity::publicId() const
    {12, 417, 0, 0, Smoke::mf_const, 62, 5},	//151 QDomEntity::systemId() const
    {12, 269, 0, 0, Smoke::mf_const, 62, 6},	//152 QDomEntity::notationName() const
    {12, 264, 0, 0, Smoke::mf_const, 46, 7},	//153 QDomEntity::nodeType() const
    {12, 499, 0, 0, Smoke::mf_dtor, 0, 8 },	//154 QDomEntity::~QDomEntity()
    {13, 40, 0, 0, Smoke::mf_ctor, 34, 1},	//155 QDomEntityReference::QDomEntityReference()
    {13, 40, 214, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 34, 2},	//156 QDomEntityReference::QDomEntityReference(const QDomEntityReference&)
    {13, 275, 214, 1, 0, 33, 3},	//157 QDomEntityReference::operator=(const QDomEntityReference&)
    {13, 264, 0, 0, Smoke::mf_const, 46, 4},	//158 QDomEntityReference::nodeType() const
    {13, 500, 0, 0, Smoke::mf_dtor, 0, 5 },	//159 QDomEntityReference::~QDomEntityReference()
    {14, 42, 0, 0, Smoke::mf_ctor, 37, 1},	//160 QDomImplementation::QDomImplementation()
    {14, 42, 216, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 37, 2},	//161 QDomImplementation::QDomImplementation(const QDomImplementation&)
    {14, 275, 216, 1, 0, 36, 3},	//162 QDomImplementation::operator=(const QDomImplementation&)
    {14, 277, 216, 1, Smoke::mf_const, 159, 4},	//163 QDomImplementation::operator==(const QDomImplementation&) const
    {14, 271, 216, 1, Smoke::mf_const, 159, 5},	//164 QDomImplementation::operator!=(const QDomImplementation&) const
    {14, 200, 25, 2, Smoke::mf_const, 159, 6},	//165 QDomImplementation::hasFeature(const QString&, const QString&) const
    {14, 139, 218, 3, 0, 23, 7},	//166 QDomImplementation::createDocumentType(const QString&, const QString&, const QString&)
    {14, 136, 222, 3, 0, 17, 8},	//167 QDomImplementation::createDocument(const QString&, const QString&, const QDomDocumentType&)
    {14, 224, 0, 0, Smoke::mf_static, 38, 9},	//168 QDomImplementation::invalidDataPolicy()
    {14, 378, 226, 1, Smoke::mf_static, 0, 10},	//169 QDomImplementation::setInvalidDataPolicy(QDomImplementation::InvalidDataPolicy)
    {14, 237, 0, 0, 0, 159, 11},	//170 QDomImplementation::isNull()
    {14, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 38, 12},	//171 QDomImplementation::AcceptInvalidChars (enum)
    {14, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 38, 13},	//172 QDomImplementation::DropInvalidChars (enum)
    {14, 89, 0, 0, Smoke::mf_static|Smoke::mf_enum, 38, 14},	//173 QDomImplementation::ReturnNullNode (enum)
    {14, 501, 0, 0, Smoke::mf_dtor, 0, 15 },	//174 QDomImplementation::~QDomImplementation()
    {15, 44, 0, 0, Smoke::mf_ctor, 41, 1},	//175 QDomNamedNodeMap::QDomNamedNodeMap()
    {15, 44, 228, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 41, 2},	//176 QDomNamedNodeMap::QDomNamedNodeMap(const QDomNamedNodeMap&)
    {15, 275, 228, 1, 0, 40, 3},	//177 QDomNamedNodeMap::operator=(const QDomNamedNodeMap&)
    {15, 277, 228, 1, Smoke::mf_const, 159, 4},	//178 QDomNamedNodeMap::operator==(const QDomNamedNodeMap&) const
    {15, 271, 228, 1, Smoke::mf_const, 159, 5},	//179 QDomNamedNodeMap::operator!=(const QDomNamedNodeMap&) const
    {15, 254, 3, 1, Smoke::mf_const, 42, 6},	//180 QDomNamedNodeMap::namedItem(const QString&) const
    {15, 382, 230, 1, 0, 42, 7},	//181 QDomNamedNodeMap::setNamedItem(const QDomNode&)
    {15, 313, 3, 1, 0, 42, 8},	//182 QDomNamedNodeMap::removeNamedItem(const QString&)
    {15, 242, 76, 1, Smoke::mf_const, 42, 9},	//183 QDomNamedNodeMap::item(int) const
    {15, 256, 25, 2, Smoke::mf_const, 42, 10},	//184 QDomNamedNodeMap::namedItemNS(const QString&, const QString&) const
    {15, 384, 230, 1, 0, 42, 11},	//185 QDomNamedNodeMap::setNamedItemNS(const QDomNode&)
    {15, 315, 25, 2, 0, 42, 12},	//186 QDomNamedNodeMap::removeNamedItemNS(const QString&, const QString&)
    {15, 247, 0, 0, Smoke::mf_const, 208, 13},	//187 QDomNamedNodeMap::length() const
    {15, 127, 0, 0, Smoke::mf_const, 204, 14},	//188 QDomNamedNodeMap::count() const
    {15, 397, 0, 0, Smoke::mf_const, 204, 15},	//189 QDomNamedNodeMap::size() const
    {15, 233, 0, 0, Smoke::mf_const, 159, 16},	//190 QDomNamedNodeMap::isEmpty() const
    {15, 124, 3, 1, Smoke::mf_const, 159, 17},	//191 QDomNamedNodeMap::contains(const QString&) const
    {15, 502, 0, 0, Smoke::mf_dtor, 0, 18 },	//192 QDomNamedNodeMap::~QDomNamedNodeMap()
    {16, 46, 0, 0, Smoke::mf_ctor, 44, 1},	//193 QDomNode::QDomNode()
    {16, 46, 230, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 44, 2},	//194 QDomNode::QDomNode(const QDomNode&)
    {16, 275, 230, 1, 0, 43, 3},	//195 QDomNode::operator=(const QDomNode&)
    {16, 277, 230, 1, Smoke::mf_const, 159, 4},	//196 QDomNode::operator==(const QDomNode&) const
    {16, 271, 230, 1, Smoke::mf_const, 159, 5},	//197 QDomNode::operator!=(const QDomNode&) const
    {16, 217, 232, 2, 0, 42, 6},	//198 QDomNode::insertBefore(const QDomNode&, const QDomNode&)
    {16, 215, 232, 2, 0, 42, 7},	//199 QDomNode::insertAfter(const QDomNode&, const QDomNode&)
    {16, 317, 232, 2, 0, 42, 8},	//200 QDomNode::replaceChild(const QDomNode&, const QDomNode&)
    {16, 311, 230, 1, 0, 42, 9},	//201 QDomNode::removeChild(const QDomNode&)
    {16, 93, 230, 1, 0, 42, 10},	//202 QDomNode::appendChild(const QDomNode&)
    {16, 198, 0, 0, Smoke::mf_const, 159, 11},	//203 QDomNode::hasChildNodes() const
    {16, 118, 235, 1, Smoke::mf_const, 42, 12},	//204 QDomNode::cloneNode(bool) const
    {16, 266, 0, 0, 0, 0, 13},	//205 QDomNode::normalize()
    {16, 239, 25, 2, Smoke::mf_const, 159, 14},	//206 QDomNode::isSupported(const QString&, const QString&) const
    {16, 263, 0, 0, Smoke::mf_const, 62, 15},	//207 QDomNode::nodeName() const
    {16, 264, 0, 0, Smoke::mf_const, 46, 16},	//208 QDomNode::nodeType() const
    {16, 281, 0, 0, Smoke::mf_const, 42, 17},	//209 QDomNode::parentNode() const
    {16, 116, 0, 0, Smoke::mf_const, 47, 18},	//210 QDomNode::childNodes() const
    {16, 187, 0, 0, Smoke::mf_const, 42, 19},	//211 QDomNode::firstChild() const
    {16, 244, 0, 0, Smoke::mf_const, 42, 20},	//212 QDomNode::lastChild() const
    {16, 291, 0, 0, Smoke::mf_const, 42, 21},	//213 QDomNode::previousSibling() const
    {16, 260, 0, 0, Smoke::mf_const, 42, 22},	//214 QDomNode::nextSibling() const
    {16, 111, 0, 0, Smoke::mf_const, 39, 23},	//215 QDomNode::attributes() const
    {16, 279, 0, 0, Smoke::mf_const, 17, 24},	//216 QDomNode::ownerDocument() const
    {16, 258, 0, 0, Smoke::mf_const, 62, 25},	//217 QDomNode::namespaceURI() const
    {16, 250, 0, 0, Smoke::mf_const, 62, 26},	//218 QDomNode::localName() const
    {16, 197, 0, 0, Smoke::mf_const, 159, 27},	//219 QDomNode::hasAttributes() const
    {16, 265, 0, 0, Smoke::mf_const, 62, 28},	//220 QDomNode::nodeValue() const
    {16, 386, 3, 1, 0, 0, 29},	//221 QDomNode::setNodeValue(const QString&)
    {16, 287, 0, 0, Smoke::mf_const, 62, 30},	//222 QDomNode::prefix() const
    {16, 388, 3, 1, 0, 0, 31},	//223 QDomNode::setPrefix(const QString&)
    {16, 225, 0, 0, Smoke::mf_const, 159, 32},	//224 QDomNode::isAttr() const
    {16, 226, 0, 0, Smoke::mf_const, 159, 33},	//225 QDomNode::isCDATASection() const
    {16, 230, 0, 0, Smoke::mf_const, 159, 34},	//226 QDomNode::isDocumentFragment() const
    {16, 229, 0, 0, Smoke::mf_const, 159, 35},	//227 QDomNode::isDocument() const
    {16, 231, 0, 0, Smoke::mf_const, 159, 36},	//228 QDomNode::isDocumentType() const
    {16, 232, 0, 0, Smoke::mf_const, 159, 37},	//229 QDomNode::isElement() const
    {16, 235, 0, 0, Smoke::mf_const, 159, 38},	//230 QDomNode::isEntityReference() const
    {16, 241, 0, 0, Smoke::mf_const, 159, 39},	//231 QDomNode::isText() const
    {16, 234, 0, 0, Smoke::mf_const, 159, 40},	//232 QDomNode::isEntity() const
    {16, 236, 0, 0, Smoke::mf_const, 159, 41},	//233 QDomNode::isNotation() const
    {16, 238, 0, 0, Smoke::mf_const, 159, 42},	//234 QDomNode::isProcessingInstruction() const
    {16, 227, 0, 0, Smoke::mf_const, 159, 43},	//235 QDomNode::isCharacterData() const
    {16, 228, 0, 0, Smoke::mf_const, 159, 44},	//236 QDomNode::isComment() const
    {16, 254, 3, 1, Smoke::mf_const, 42, 45},	//237 QDomNode::namedItem(const QString&) const
    {16, 237, 0, 0, Smoke::mf_const, 159, 46},	//238 QDomNode::isNull() const
    {16, 117, 0, 0, 0, 0, 47},	//239 QDomNode::clear()
    {16, 421, 0, 0, Smoke::mf_const, 5, 48},	//240 QDomNode::toAttr() const
    {16, 424, 0, 0, Smoke::mf_const, 8, 49},	//241 QDomNode::toCDATASection() const
    {16, 428, 0, 0, Smoke::mf_const, 20, 50},	//242 QDomNode::toDocumentFragment() const
    {16, 427, 0, 0, Smoke::mf_const, 17, 51},	//243 QDomNode::toDocument() const
    {16, 429, 0, 0, Smoke::mf_const, 23, 52},	//244 QDomNode::toDocumentType() const
    {16, 430, 0, 0, Smoke::mf_const, 26, 53},	//245 QDomNode::toElement() const
    {16, 432, 0, 0, Smoke::mf_const, 32, 54},	//246 QDomNode::toEntityReference() const
    {16, 437, 0, 0, Smoke::mf_const, 57, 55},	//247 QDomNode::toText() const
    {16, 431, 0, 0, Smoke::mf_const, 29, 56},	//248 QDomNode::toEntity() const
    {16, 433, 0, 0, Smoke::mf_const, 51, 57},	//249 QDomNode::toNotation() const
    {16, 434, 0, 0, Smoke::mf_const, 54, 58},	//250 QDomNode::toProcessingInstruction() const
    {16, 425, 0, 0, Smoke::mf_const, 11, 59},	//251 QDomNode::toCharacterData() const
    {16, 426, 0, 0, Smoke::mf_const, 14, 60},	//252 QDomNode::toComment() const
    {16, 324, 237, 2, Smoke::mf_const, 0, 61},	//253 QDomNode::save(QTextStream&, int) const
    {16, 324, 240, 3, Smoke::mf_const, 0, 62},	//254 QDomNode::save(QTextStream&, int, QDomNode::EncodingPolicy) const
    {16, 188, 3, 1, Smoke::mf_const, 26, 63},	//255 QDomNode::firstChildElement(const QString&) const
    {16, 245, 3, 1, Smoke::mf_const, 26, 64},	//256 QDomNode::lastChildElement(const QString&) const
    {16, 292, 3, 1, Smoke::mf_const, 26, 65},	//257 QDomNode::previousSiblingElement(const QString&) const
    {16, 261, 3, 1, Smoke::mf_const, 26, 66},	//258 QDomNode::nextSiblingElement(const QString&) const
    {16, 249, 0, 0, Smoke::mf_const, 204, 67},	//259 QDomNode::lineNumber() const
    {16, 121, 0, 0, Smoke::mf_const, 204, 68},	//260 QDomNode::columnNumber() const
    {16, 118, 0, 0, Smoke::mf_const, 42, 69},	//261 QDomNode::cloneNode() const
    {16, 188, 0, 0, Smoke::mf_const, 26, 70},	//262 QDomNode::firstChildElement() const
    {16, 245, 0, 0, Smoke::mf_const, 26, 71},	//263 QDomNode::lastChildElement() const
    {16, 292, 0, 0, Smoke::mf_const, 26, 72},	//264 QDomNode::previousSiblingElement() const
    {16, 261, 0, 0, Smoke::mf_const, 26, 73},	//265 QDomNode::nextSiblingElement() const
    {16, 207, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 50, 74},	//266 QDomNode::impl() const
    {16, 376, 244, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 75},	//267 QDomNode::setImpl(QDomNodePrivate*)
    {16, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 76},	//268 QDomNode::ElementNode (enum)
    {16, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 77},	//269 QDomNode::AttributeNode (enum)
    {16, 90, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 78},	//270 QDomNode::TextNode (enum)
    {16, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 79},	//271 QDomNode::CDATASectionNode (enum)
    {16, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 80},	//272 QDomNode::EntityReferenceNode (enum)
    {16, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 81},	//273 QDomNode::EntityNode (enum)
    {16, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 82},	//274 QDomNode::ProcessingInstructionNode (enum)
    {16, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 83},	//275 QDomNode::CommentNode (enum)
    {16, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 84},	//276 QDomNode::DocumentNode (enum)
    {16, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 85},	//277 QDomNode::DocumentTypeNode (enum)
    {16, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 86},	//278 QDomNode::DocumentFragmentNode (enum)
    {16, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 87},	//279 QDomNode::NotationNode (enum)
    {16, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 88},	//280 QDomNode::BaseNode (enum)
    {16, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 89},	//281 QDomNode::CharacterDataNode (enum)
    {16, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 90},	//282 QDomNode::EncodingFromDocument (enum)
    {16, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 91},	//283 QDomNode::EncodingFromTextStream (enum)
    {16, 503, 0, 0, Smoke::mf_dtor, 0, 92 },	//284 QDomNode::~QDomNode()
    {17, 48, 0, 0, Smoke::mf_ctor, 49, 1},	//285 QDomNodeList::QDomNodeList()
    {17, 48, 246, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 49, 2},	//286 QDomNodeList::QDomNodeList(const QDomNodeList&)
    {17, 275, 246, 1, 0, 48, 3},	//287 QDomNodeList::operator=(const QDomNodeList&)
    {17, 277, 246, 1, Smoke::mf_const, 159, 4},	//288 QDomNodeList::operator==(const QDomNodeList&) const
    {17, 271, 246, 1, Smoke::mf_const, 159, 5},	//289 QDomNodeList::operator!=(const QDomNodeList&) const
    {17, 242, 76, 1, Smoke::mf_const, 42, 6},	//290 QDomNodeList::item(int) const
    {17, 97, 76, 1, Smoke::mf_const, 42, 7},	//291 QDomNodeList::at(int) const
    {17, 247, 0, 0, Smoke::mf_const, 208, 8},	//292 QDomNodeList::length() const
    {17, 127, 0, 0, Smoke::mf_const, 204, 9},	//293 QDomNodeList::count() const
    {17, 397, 0, 0, Smoke::mf_const, 204, 10},	//294 QDomNodeList::size() const
    {17, 233, 0, 0, Smoke::mf_const, 159, 11},	//295 QDomNodeList::isEmpty() const
    {17, 504, 0, 0, Smoke::mf_dtor, 0, 12 },	//296 QDomNodeList::~QDomNodeList()
    {19, 50, 0, 0, Smoke::mf_ctor, 53, 1},	//297 QDomNotation::QDomNotation()
    {19, 50, 248, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 53, 2},	//298 QDomNotation::QDomNotation(const QDomNotation&)
    {19, 275, 248, 1, 0, 52, 3},	//299 QDomNotation::operator=(const QDomNotation&)
    {19, 301, 0, 0, Smoke::mf_const, 62, 4},	//300 QDomNotation::publicId() const
    {19, 417, 0, 0, Smoke::mf_const, 62, 5},	//301 QDomNotation::systemId() const
    {19, 264, 0, 0, Smoke::mf_const, 46, 6},	//302 QDomNotation::nodeType() const
    {19, 505, 0, 0, Smoke::mf_dtor, 0, 7 },	//303 QDomNotation::~QDomNotation()
    {20, 52, 0, 0, Smoke::mf_ctor, 56, 1},	//304 QDomProcessingInstruction::QDomProcessingInstruction()
    {20, 52, 250, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 56, 2},	//305 QDomProcessingInstruction::QDomProcessingInstruction(const QDomProcessingInstruction&)
    {20, 275, 250, 1, 0, 55, 3},	//306 QDomProcessingInstruction::operator=(const QDomProcessingInstruction&)
    {20, 419, 0, 0, Smoke::mf_const, 62, 4},	//307 QDomProcessingInstruction::target() const
    {20, 151, 0, 0, Smoke::mf_const, 62, 5},	//308 QDomProcessingInstruction::data() const
    {20, 361, 3, 1, 0, 0, 6},	//309 QDomProcessingInstruction::setData(const QString&)
    {20, 264, 0, 0, Smoke::mf_const, 46, 7},	//310 QDomProcessingInstruction::nodeType() const
    {20, 506, 0, 0, Smoke::mf_dtor, 0, 8 },	//311 QDomProcessingInstruction::~QDomProcessingInstruction()
    {21, 54, 0, 0, Smoke::mf_ctor, 59, 1},	//312 QDomText::QDomText()
    {21, 54, 252, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 59, 2},	//313 QDomText::QDomText(const QDomText&)
    {21, 275, 252, 1, 0, 58, 3},	//314 QDomText::operator=(const QDomText&)
    {21, 403, 76, 1, 0, 57, 4},	//315 QDomText::splitText(int)
    {21, 264, 0, 0, Smoke::mf_const, 46, 5},	//316 QDomText::nodeType() const
    {21, 507, 0, 0, Smoke::mf_dtor, 0, 6 },	//317 QDomText::~QDomText()
    {22, 273, 254, 2, Smoke::mf_static, 68, 1},	//318 QGlobalSpace::operator<<(QTextStream&, const QDomNode&)
    {28, 56, 0, 0, Smoke::mf_ctor, 69, 1},	//319 QXmlAttributes::QXmlAttributes()
    {28, 211, 3, 1, Smoke::mf_const, 204, 2},	//320 QXmlAttributes::index(const QString&) const
    {28, 211, 257, 1, Smoke::mf_const, 204, 3},	//321 QXmlAttributes::index(const QLatin1String&) const
    {28, 211, 25, 2, Smoke::mf_const, 204, 4},	//322 QXmlAttributes::index(const QString&, const QString&) const
    {28, 247, 0, 0, Smoke::mf_const, 204, 5},	//323 QXmlAttributes::length() const
    {28, 127, 0, 0, Smoke::mf_const, 204, 6},	//324 QXmlAttributes::count() const
    {28, 250, 76, 1, Smoke::mf_const, 62, 7},	//325 QXmlAttributes::localName(int) const
    {28, 303, 76, 1, Smoke::mf_const, 62, 8},	//326 QXmlAttributes::qName(int) const
    {28, 443, 76, 1, Smoke::mf_const, 62, 9},	//327 QXmlAttributes::uri(int) const
    {28, 438, 76, 1, Smoke::mf_const, 62, 10},	//328 QXmlAttributes::type(int) const
    {28, 438, 3, 1, Smoke::mf_const, 62, 11},	//329 QXmlAttributes::type(const QString&) const
    {28, 438, 25, 2, Smoke::mf_const, 62, 12},	//330 QXmlAttributes::type(const QString&, const QString&) const
    {28, 445, 76, 1, Smoke::mf_const, 62, 13},	//331 QXmlAttributes::value(int) const
    {28, 445, 3, 1, Smoke::mf_const, 62, 14},	//332 QXmlAttributes::value(const QString&) const
    {28, 445, 257, 1, Smoke::mf_const, 62, 15},	//333 QXmlAttributes::value(const QLatin1String&) const
    {28, 445, 25, 2, Smoke::mf_const, 62, 16},	//334 QXmlAttributes::value(const QString&, const QString&) const
    {28, 117, 0, 0, 0, 0, 17},	//335 QXmlAttributes::clear()
    {28, 91, 259, 4, 0, 0, 18},	//336 QXmlAttributes::append(const QString&, const QString&, const QString&, const QString&)
    {28, 56, 264, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 69, 19},	//337 QXmlAttributes::QXmlAttributes(const QXmlAttributes&)
    {28, 508, 0, 0, Smoke::mf_dtor, 0, 20 },	//338 QXmlAttributes::~QXmlAttributes()
    {29, 368, 266, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 1},	//339 QXmlContentHandler::setDocumentLocator(QXmlLocator*) [pure virtual]
    {29, 408, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 2},	//340 QXmlContentHandler::startDocument() [pure virtual]
    {29, 166, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 3},	//341 QXmlContentHandler::endDocument() [pure virtual]
    {29, 413, 25, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 4},	//342 QXmlContentHandler::startPrefixMapping(const QString&, const QString&) [pure virtual]
    {29, 171, 3, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 5},	//343 QXmlContentHandler::endPrefixMapping(const QString&) [pure virtual]
    {29, 409, 268, 4, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 6},	//344 QXmlContentHandler::startElement(const QString&, const QString&, const QString&, const QXmlAttributes&) [pure virtual]
    {29, 167, 218, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 7},	//345 QXmlContentHandler::endElement(const QString&, const QString&, const QString&) [pure virtual]
    {29, 114, 3, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 8},	//346 QXmlContentHandler::characters(const QString&) [pure virtual]
    {29, 205, 3, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 9},	//347 QXmlContentHandler::ignorableWhitespace(const QString&) [pure virtual]
    {29, 296, 25, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 10},	//348 QXmlContentHandler::processingInstruction(const QString&, const QString&) [pure virtual]
    {29, 398, 3, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 11},	//349 QXmlContentHandler::skippedEntity(const QString&) [pure virtual]
    {29, 178, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 62, 12},	//350 QXmlContentHandler::errorString() const [pure virtual]
    {29, 58, 0, 0, Smoke::mf_ctor, 70, 13},	//351 QXmlContentHandler::QXmlContentHandler()
    {29, 58, 273, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 70, 14},	//352 QXmlContentHandler::QXmlContentHandler(const QXmlContentHandler&)
    {29, 509, 0, 0, Smoke::mf_dtor, 0, 15 },	//353 QXmlContentHandler::~QXmlContentHandler()
    {30, 267, 218, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 1},	//354 QXmlDTDHandler::notationDecl(const QString&, const QString&, const QString&) [pure virtual]
    {30, 441, 259, 4, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 2},	//355 QXmlDTDHandler::unparsedEntityDecl(const QString&, const QString&, const QString&, const QString&) [pure virtual]
    {30, 178, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 62, 3},	//356 QXmlDTDHandler::errorString() const [pure virtual]
    {30, 60, 0, 0, Smoke::mf_ctor, 71, 4},	//357 QXmlDTDHandler::QXmlDTDHandler()
    {30, 60, 275, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 71, 5},	//358 QXmlDTDHandler::QXmlDTDHandler(const QXmlDTDHandler&)
    {30, 510, 0, 0, Smoke::mf_dtor, 0, 6 },	//359 QXmlDTDHandler::~QXmlDTDHandler()
    {31, 102, 277, 5, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 1},	//360 QXmlDeclHandler::attributeDecl(const QString&, const QString&, const QString&, const QString&, const QString&) [pure virtual]
    {31, 221, 25, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 2},	//361 QXmlDeclHandler::internalEntityDecl(const QString&, const QString&) [pure virtual]
    {31, 179, 218, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 3},	//362 QXmlDeclHandler::externalEntityDecl(const QString&, const QString&, const QString&) [pure virtual]
    {31, 178, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 62, 4},	//363 QXmlDeclHandler::errorString() const [pure virtual]
    {31, 62, 0, 0, Smoke::mf_ctor, 72, 5},	//364 QXmlDeclHandler::QXmlDeclHandler()
    {31, 62, 283, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 72, 6},	//365 QXmlDeclHandler::QXmlDeclHandler(const QXmlDeclHandler&)
    {31, 511, 0, 0, Smoke::mf_dtor, 0, 7 },	//366 QXmlDeclHandler::~QXmlDeclHandler()
    {32, 64, 0, 0, Smoke::mf_ctor, 73, 1},	//367 QXmlDefaultHandler::QXmlDefaultHandler()
    {32, 368, 266, 1, Smoke::mf_virtual, 0, 2},	//368 QXmlDefaultHandler::setDocumentLocator(QXmlLocator*)
    {32, 408, 0, 0, Smoke::mf_virtual, 159, 3},	//369 QXmlDefaultHandler::startDocument()
    {32, 166, 0, 0, Smoke::mf_virtual, 159, 4},	//370 QXmlDefaultHandler::endDocument()
    {32, 413, 25, 2, Smoke::mf_virtual, 159, 5},	//371 QXmlDefaultHandler::startPrefixMapping(const QString&, const QString&)
    {32, 171, 3, 1, Smoke::mf_virtual, 159, 6},	//372 QXmlDefaultHandler::endPrefixMapping(const QString&)
    {32, 409, 268, 4, Smoke::mf_virtual, 159, 7},	//373 QXmlDefaultHandler::startElement(const QString&, const QString&, const QString&, const QXmlAttributes&)
    {32, 167, 218, 3, Smoke::mf_virtual, 159, 8},	//374 QXmlDefaultHandler::endElement(const QString&, const QString&, const QString&)
    {32, 114, 3, 1, Smoke::mf_virtual, 159, 9},	//375 QXmlDefaultHandler::characters(const QString&)
    {32, 205, 3, 1, Smoke::mf_virtual, 159, 10},	//376 QXmlDefaultHandler::ignorableWhitespace(const QString&)
    {32, 296, 25, 2, Smoke::mf_virtual, 159, 11},	//377 QXmlDefaultHandler::processingInstruction(const QString&, const QString&)
    {32, 398, 3, 1, Smoke::mf_virtual, 159, 12},	//378 QXmlDefaultHandler::skippedEntity(const QString&)
    {32, 449, 285, 1, Smoke::mf_virtual, 159, 13},	//379 QXmlDefaultHandler::warning(const QXmlParseException&)
    {32, 175, 285, 1, Smoke::mf_virtual, 159, 14},	//380 QXmlDefaultHandler::error(const QXmlParseException&)
    {32, 181, 285, 1, Smoke::mf_virtual, 159, 15},	//381 QXmlDefaultHandler::fatalError(const QXmlParseException&)
    {32, 267, 218, 3, Smoke::mf_virtual, 159, 16},	//382 QXmlDefaultHandler::notationDecl(const QString&, const QString&, const QString&)
    {32, 441, 259, 4, Smoke::mf_virtual, 159, 17},	//383 QXmlDefaultHandler::unparsedEntityDecl(const QString&, const QString&, const QString&, const QString&)
    {32, 322, 287, 3, Smoke::mf_virtual, 159, 18},	//384 QXmlDefaultHandler::resolveEntity(const QString&, const QString&, QXmlInputSource*&)
    {32, 406, 218, 3, Smoke::mf_virtual, 159, 19},	//385 QXmlDefaultHandler::startDTD(const QString&, const QString&, const QString&)
    {32, 165, 0, 0, Smoke::mf_virtual, 159, 20},	//386 QXmlDefaultHandler::endDTD()
    {32, 411, 3, 1, Smoke::mf_virtual, 159, 21},	//387 QXmlDefaultHandler::startEntity(const QString&)
    {32, 169, 3, 1, Smoke::mf_virtual, 159, 22},	//388 QXmlDefaultHandler::endEntity(const QString&)
    {32, 405, 0, 0, Smoke::mf_virtual, 159, 23},	//389 QXmlDefaultHandler::startCDATA()
    {32, 164, 0, 0, Smoke::mf_virtual, 159, 24},	//390 QXmlDefaultHandler::endCDATA()
    {32, 122, 3, 1, Smoke::mf_virtual, 159, 25},	//391 QXmlDefaultHandler::comment(const QString&)
    {32, 102, 277, 5, Smoke::mf_virtual, 159, 26},	//392 QXmlDefaultHandler::attributeDecl(const QString&, const QString&, const QString&, const QString&, const QString&)
    {32, 221, 25, 2, Smoke::mf_virtual, 159, 27},	//393 QXmlDefaultHandler::internalEntityDecl(const QString&, const QString&)
    {32, 179, 218, 3, Smoke::mf_virtual, 159, 28},	//394 QXmlDefaultHandler::externalEntityDecl(const QString&, const QString&, const QString&)
    {32, 178, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 62, 29},	//395 QXmlDefaultHandler::errorString() const
    {32, 512, 0, 0, Smoke::mf_dtor, 0, 30 },	//396 QXmlDefaultHandler::~QXmlDefaultHandler()
    {33, 322, 287, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 1},	//397 QXmlEntityResolver::resolveEntity(const QString&, const QString&, QXmlInputSource*&) [pure virtual]
    {33, 178, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 62, 2},	//398 QXmlEntityResolver::errorString() const [pure virtual]
    {33, 65, 0, 0, Smoke::mf_ctor, 74, 3},	//399 QXmlEntityResolver::QXmlEntityResolver()
    {33, 65, 291, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 74, 4},	//400 QXmlEntityResolver::QXmlEntityResolver(const QXmlEntityResolver&)
    {33, 513, 0, 0, Smoke::mf_dtor, 0, 5 },	//401 QXmlEntityResolver::~QXmlEntityResolver()
    {34, 449, 285, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 1},	//402 QXmlErrorHandler::warning(const QXmlParseException&) [pure virtual]
    {34, 175, 285, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 2},	//403 QXmlErrorHandler::error(const QXmlParseException&) [pure virtual]
    {34, 181, 285, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 3},	//404 QXmlErrorHandler::fatalError(const QXmlParseException&) [pure virtual]
    {34, 178, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 62, 4},	//405 QXmlErrorHandler::errorString() const [pure virtual]
    {34, 67, 0, 0, Smoke::mf_ctor, 75, 5},	//406 QXmlErrorHandler::QXmlErrorHandler()
    {34, 67, 293, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 75, 6},	//407 QXmlErrorHandler::QXmlErrorHandler(const QXmlErrorHandler&)
    {34, 514, 0, 0, Smoke::mf_dtor, 0, 7 },	//408 QXmlErrorHandler::~QXmlErrorHandler()
    {35, 69, 0, 0, Smoke::mf_ctor, 76, 1},	//409 QXmlInputSource::QXmlInputSource()
    {35, 69, 142, 1, Smoke::mf_ctor, 76, 2},	//410 QXmlInputSource::QXmlInputSource(QIODevice*)
    {35, 361, 3, 1, Smoke::mf_virtual, 0, 3},	//411 QXmlInputSource::setData(const QString&)
    {35, 361, 126, 1, Smoke::mf_virtual, 0, 4},	//412 QXmlInputSource::setData(const QByteArray&)
    {35, 186, 0, 0, Smoke::mf_virtual, 0, 5},	//413 QXmlInputSource::fetchData()
    {35, 151, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 62, 6},	//414 QXmlInputSource::data() const
    {35, 259, 0, 0, Smoke::mf_virtual, 4, 7},	//415 QXmlInputSource::next()
    {35, 321, 0, 0, Smoke::mf_virtual, 0, 8},	//416 QXmlInputSource::reset()
    {35, 190, 78, 2, Smoke::mf_protected|Smoke::mf_virtual, 62, 9},	//417 QXmlInputSource::fromRawData(const QByteArray&, bool)
    {35, 69, 295, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 76, 10},	//418 QXmlInputSource::QXmlInputSource(const QXmlInputSource&)
    {35, 190, 126, 1, Smoke::mf_protected, 62, 11},	//419 QXmlInputSource::fromRawData(const QByteArray&)
    {35, 15, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 200, 12},	//420 QXmlInputSource::EndOfData() const
    {35, 16, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 200, 13},	//421 QXmlInputSource::EndOfDocument() const
    {35, 515, 0, 0, Smoke::mf_dtor, 0, 14 },	//422 QXmlInputSource::~QXmlInputSource()
    {36, 406, 218, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 1},	//423 QXmlLexicalHandler::startDTD(const QString&, const QString&, const QString&) [pure virtual]
    {36, 165, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 2},	//424 QXmlLexicalHandler::endDTD() [pure virtual]
    {36, 411, 3, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 3},	//425 QXmlLexicalHandler::startEntity(const QString&) [pure virtual]
    {36, 169, 3, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 4},	//426 QXmlLexicalHandler::endEntity(const QString&) [pure virtual]
    {36, 405, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 5},	//427 QXmlLexicalHandler::startCDATA() [pure virtual]
    {36, 164, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 6},	//428 QXmlLexicalHandler::endCDATA() [pure virtual]
    {36, 122, 3, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 7},	//429 QXmlLexicalHandler::comment(const QString&) [pure virtual]
    {36, 178, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 62, 8},	//430 QXmlLexicalHandler::errorString() const [pure virtual]
    {36, 71, 0, 0, Smoke::mf_ctor, 78, 9},	//431 QXmlLexicalHandler::QXmlLexicalHandler()
    {36, 71, 297, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 78, 10},	//432 QXmlLexicalHandler::QXmlLexicalHandler(const QXmlLexicalHandler&)
    {36, 516, 0, 0, Smoke::mf_dtor, 0, 11 },	//433 QXmlLexicalHandler::~QXmlLexicalHandler()
    {37, 73, 0, 0, Smoke::mf_ctor, 79, 1},	//434 QXmlLocator::QXmlLocator()
    {37, 121, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 204, 2},	//435 QXmlLocator::columnNumber() const [pure virtual]
    {37, 249, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 204, 3},	//436 QXmlLocator::lineNumber() const [pure virtual]
    {37, 73, 299, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 79, 4},	//437 QXmlLocator::QXmlLocator(const QXmlLocator&)
    {37, 517, 0, 0, Smoke::mf_dtor, 0, 5 },	//438 QXmlLocator::~QXmlLocator()
    {38, 75, 0, 0, Smoke::mf_ctor, 80, 1},	//439 QXmlNamespaceSupport::QXmlNamespaceSupport()
    {38, 388, 25, 2, 0, 0, 2},	//440 QXmlNamespaceSupport::setPrefix(const QString&, const QString&)
    {38, 287, 3, 1, Smoke::mf_const, 62, 3},	//441 QXmlNamespaceSupport::prefix(const QString&) const
    {38, 443, 3, 1, Smoke::mf_const, 62, 4},	//442 QXmlNamespaceSupport::uri(const QString&) const
    {38, 401, 301, 3, Smoke::mf_const, 0, 5},	//443 QXmlNamespaceSupport::splitName(const QString&, QString&, QString&) const
    {38, 294, 305, 4, Smoke::mf_const, 0, 6},	//444 QXmlNamespaceSupport::processName(const QString&, bool, QString&, QString&) const
    {38, 289, 0, 0, Smoke::mf_const, 65, 7},	//445 QXmlNamespaceSupport::prefixes() const
    {38, 289, 3, 1, Smoke::mf_const, 65, 8},	//446 QXmlNamespaceSupport::prefixes(const QString&) const
    {38, 302, 0, 0, 0, 0, 9},	//447 QXmlNamespaceSupport::pushContext()
    {38, 286, 0, 0, 0, 0, 10},	//448 QXmlNamespaceSupport::popContext()
    {38, 321, 0, 0, 0, 0, 11},	//449 QXmlNamespaceSupport::reset()
    {38, 518, 0, 0, Smoke::mf_dtor, 0, 12 },	//450 QXmlNamespaceSupport::~QXmlNamespaceSupport()
    {39, 76, 310, 5, Smoke::mf_ctor, 81, 1},	//451 QXmlParseException::QXmlParseException(const QString&, int, int, const QString&, const QString&)
    {39, 76, 285, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 81, 2},	//452 QXmlParseException::QXmlParseException(const QXmlParseException&)
    {39, 121, 0, 0, Smoke::mf_const, 204, 3},	//453 QXmlParseException::columnNumber() const
    {39, 249, 0, 0, Smoke::mf_const, 204, 4},	//454 QXmlParseException::lineNumber() const
    {39, 301, 0, 0, Smoke::mf_const, 62, 5},	//455 QXmlParseException::publicId() const
    {39, 417, 0, 0, Smoke::mf_const, 62, 6},	//456 QXmlParseException::systemId() const
    {39, 252, 0, 0, Smoke::mf_const, 62, 7},	//457 QXmlParseException::message() const
    {39, 76, 0, 0, Smoke::mf_ctor, 81, 8},	//458 QXmlParseException::QXmlParseException()
    {39, 76, 3, 1, Smoke::mf_ctor, 81, 9},	//459 QXmlParseException::QXmlParseException(const QString&)
    {39, 76, 173, 2, Smoke::mf_ctor, 81, 10},	//460 QXmlParseException::QXmlParseException(const QString&, int)
    {39, 76, 316, 3, Smoke::mf_ctor, 81, 11},	//461 QXmlParseException::QXmlParseException(const QString&, int, int)
    {39, 76, 320, 4, Smoke::mf_ctor, 81, 12},	//462 QXmlParseException::QXmlParseException(const QString&, int, int, const QString&)
    {39, 519, 0, 0, Smoke::mf_dtor, 0, 13 },	//463 QXmlParseException::~QXmlParseException()
    {40, 183, 325, 2, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 1},	//464 QXmlReader::feature(const QString&, bool*) const [pure virtual]
    {40, 374, 90, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 2},	//465 QXmlReader::setFeature(const QString&, bool) [pure virtual]
    {40, 200, 3, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 3},	//466 QXmlReader::hasFeature(const QString&) const [pure virtual]
    {40, 298, 325, 2, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 211, 4},	//467 QXmlReader::property(const QString&, bool*) const [pure virtual]
    {40, 391, 328, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 5},	//468 QXmlReader::setProperty(const QString&, void*) [pure virtual]
    {40, 203, 3, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 6},	//469 QXmlReader::hasProperty(const QString&) const [pure virtual]
    {40, 370, 331, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 7},	//470 QXmlReader::setEntityResolver(QXmlEntityResolver*) [pure virtual]
    {40, 174, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 74, 8},	//471 QXmlReader::entityResolver() const [pure virtual]
    {40, 359, 333, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 9},	//472 QXmlReader::setDTDHandler(QXmlDTDHandler*) [pure virtual]
    {40, 7, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 71, 10},	//473 QXmlReader::DTDHandler() const [pure virtual]
    {40, 357, 335, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 11},	//474 QXmlReader::setContentHandler(QXmlContentHandler*) [pure virtual]
    {40, 126, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 70, 12},	//475 QXmlReader::contentHandler() const [pure virtual]
    {40, 372, 337, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 13},	//476 QXmlReader::setErrorHandler(QXmlErrorHandler*) [pure virtual]
    {40, 177, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 75, 14},	//477 QXmlReader::errorHandler() const [pure virtual]
    {40, 380, 339, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 15},	//478 QXmlReader::setLexicalHandler(QXmlLexicalHandler*) [pure virtual]
    {40, 248, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 78, 16},	//479 QXmlReader::lexicalHandler() const [pure virtual]
    {40, 364, 341, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 17},	//480 QXmlReader::setDeclHandler(QXmlDeclHandler*) [pure virtual]
    {40, 152, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 72, 18},	//481 QXmlReader::declHandler() const [pure virtual]
    {40, 282, 295, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 19},	//482 QXmlReader::parse(const QXmlInputSource&) [pure virtual]
    {40, 282, 343, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 20},	//483 QXmlReader::parse(const QXmlInputSource*) [pure virtual]
    {40, 83, 0, 0, Smoke::mf_ctor, 82, 21},	//484 QXmlReader::QXmlReader()
    {40, 83, 345, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 82, 22},	//485 QXmlReader::QXmlReader(const QXmlReader&)
    {40, 183, 3, 1, Smoke::mf_const, 159, 23},	//486 QXmlReader::feature(const QString&) const
    {40, 298, 3, 1, Smoke::mf_const, 211, 24},	//487 QXmlReader::property(const QString&) const
    {40, 520, 0, 0, Smoke::mf_dtor, 0, 25 },	//488 QXmlReader::~QXmlReader()
    {41, 85, 0, 0, Smoke::mf_ctor, 83, 1},	//489 QXmlSimpleReader::QXmlSimpleReader()
    {41, 183, 325, 2, Smoke::mf_const|Smoke::mf_virtual, 159, 2},	//490 QXmlSimpleReader::feature(const QString&, bool*) const
    {41, 374, 90, 2, Smoke::mf_virtual, 0, 3},	//491 QXmlSimpleReader::setFeature(const QString&, bool)
    {41, 200, 3, 1, Smoke::mf_const|Smoke::mf_virtual, 159, 4},	//492 QXmlSimpleReader::hasFeature(const QString&) const
    {41, 298, 325, 2, Smoke::mf_const|Smoke::mf_virtual, 211, 5},	//493 QXmlSimpleReader::property(const QString&, bool*) const
    {41, 391, 328, 2, Smoke::mf_virtual, 0, 6},	//494 QXmlSimpleReader::setProperty(const QString&, void*)
    {41, 203, 3, 1, Smoke::mf_const|Smoke::mf_virtual, 159, 7},	//495 QXmlSimpleReader::hasProperty(const QString&) const
    {41, 370, 331, 1, Smoke::mf_virtual, 0, 8},	//496 QXmlSimpleReader::setEntityResolver(QXmlEntityResolver*)
    {41, 174, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 74, 9},	//497 QXmlSimpleReader::entityResolver() const
    {41, 359, 333, 1, Smoke::mf_virtual, 0, 10},	//498 QXmlSimpleReader::setDTDHandler(QXmlDTDHandler*)
    {41, 7, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 71, 11},	//499 QXmlSimpleReader::DTDHandler() const
    {41, 357, 335, 1, Smoke::mf_virtual, 0, 12},	//500 QXmlSimpleReader::setContentHandler(QXmlContentHandler*)
    {41, 126, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 70, 13},	//501 QXmlSimpleReader::contentHandler() const
    {41, 372, 337, 1, Smoke::mf_virtual, 0, 14},	//502 QXmlSimpleReader::setErrorHandler(QXmlErrorHandler*)
    {41, 177, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 75, 15},	//503 QXmlSimpleReader::errorHandler() const
    {41, 380, 339, 1, Smoke::mf_virtual, 0, 16},	//504 QXmlSimpleReader::setLexicalHandler(QXmlLexicalHandler*)
    {41, 248, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 78, 17},	//505 QXmlSimpleReader::lexicalHandler() const
    {41, 364, 341, 1, Smoke::mf_virtual, 0, 18},	//506 QXmlSimpleReader::setDeclHandler(QXmlDeclHandler*)
    {41, 152, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 72, 19},	//507 QXmlSimpleReader::declHandler() const
    {41, 282, 295, 1, Smoke::mf_virtual, 159, 20},	//508 QXmlSimpleReader::parse(const QXmlInputSource&)
    {41, 282, 343, 1, Smoke::mf_virtual, 159, 21},	//509 QXmlSimpleReader::parse(const QXmlInputSource*)
    {41, 282, 347, 2, Smoke::mf_virtual, 159, 22},	//510 QXmlSimpleReader::parse(const QXmlInputSource*, bool)
    {41, 285, 0, 0, Smoke::mf_virtual, 159, 23},	//511 QXmlSimpleReader::parseContinue()
    {41, 183, 3, 1, Smoke::mf_const, 159, 24},	//512 QXmlSimpleReader::feature(const QString&) const
    {41, 298, 3, 1, Smoke::mf_const, 211, 25},	//513 QXmlSimpleReader::property(const QString&) const
    {41, 521, 0, 0, Smoke::mf_dtor, 0, 26 },	//514 QXmlSimpleReader::~QXmlSimpleReader()
    {45, 86, 0, 0, Smoke::mf_ctor, 84, 1},	//515 QXmlStreamWriter::QXmlStreamWriter()
    {45, 86, 142, 1, Smoke::mf_ctor, 84, 2},	//516 QXmlStreamWriter::QXmlStreamWriter(QIODevice*)
    {45, 86, 350, 1, Smoke::mf_ctor, 84, 3},	//517 QXmlStreamWriter::QXmlStreamWriter(QByteArray*)
    {45, 86, 352, 1, Smoke::mf_ctor, 84, 4},	//518 QXmlStreamWriter::QXmlStreamWriter(QString*)
    {45, 366, 142, 1, 0, 0, 5},	//519 QXmlStreamWriter::setDevice(QIODevice*)
    {45, 155, 0, 0, Smoke::mf_const, 60, 6},	//520 QXmlStreamWriter::device() const
    {45, 339, 354, 1, 0, 0, 7},	//521 QXmlStreamWriter::setCodec(QTextCodec*)
    {45, 339, 356, 1, 0, 0, 8},	//522 QXmlStreamWriter::setCodec(const char*)
    {45, 120, 0, 0, Smoke::mf_const, 67, 9},	//523 QXmlStreamWriter::codec() const
    {45, 335, 235, 1, 0, 0, 10},	//524 QXmlStreamWriter::setAutoFormatting(bool)
    {45, 112, 0, 0, Smoke::mf_const, 159, 11},	//525 QXmlStreamWriter::autoFormatting() const
    {45, 337, 76, 1, 0, 0, 12},	//526 QXmlStreamWriter::setAutoFormattingIndent(int)
    {45, 113, 0, 0, Smoke::mf_const, 204, 13},	//527 QXmlStreamWriter::autoFormattingIndent() const
    {45, 451, 25, 2, 0, 0, 14},	//528 QXmlStreamWriter::writeAttribute(const QString&, const QString&)
    {45, 451, 218, 3, 0, 0, 15},	//529 QXmlStreamWriter::writeAttribute(const QString&, const QString&, const QString&)
    {45, 451, 358, 1, 0, 0, 16},	//530 QXmlStreamWriter::writeAttribute(const QXmlStreamAttribute&)
    {45, 455, 360, 1, 0, 0, 17},	//531 QXmlStreamWriter::writeAttributes(const QXmlStreamAttributes&)
    {45, 457, 3, 1, 0, 0, 18},	//532 QXmlStreamWriter::writeCDATA(const QString&)
    {45, 459, 3, 1, 0, 0, 19},	//533 QXmlStreamWriter::writeCharacters(const QString&)
    {45, 461, 3, 1, 0, 0, 20},	//534 QXmlStreamWriter::writeComment(const QString&)
    {45, 465, 3, 1, 0, 0, 21},	//535 QXmlStreamWriter::writeDTD(const QString&)
    {45, 469, 3, 1, 0, 0, 22},	//536 QXmlStreamWriter::writeEmptyElement(const QString&)
    {45, 469, 25, 2, 0, 0, 23},	//537 QXmlStreamWriter::writeEmptyElement(const QString&, const QString&)
    {45, 488, 25, 2, 0, 0, 24},	//538 QXmlStreamWriter::writeTextElement(const QString&, const QString&)
    {45, 488, 218, 3, 0, 0, 25},	//539 QXmlStreamWriter::writeTextElement(const QString&, const QString&, const QString&)
    {45, 472, 0, 0, 0, 0, 26},	//540 QXmlStreamWriter::writeEndDocument()
    {45, 473, 0, 0, 0, 0, 27},	//541 QXmlStreamWriter::writeEndElement()
    {45, 474, 3, 1, 0, 0, 28},	//542 QXmlStreamWriter::writeEntityReference(const QString&)
    {45, 476, 25, 2, 0, 0, 29},	//543 QXmlStreamWriter::writeNamespace(const QString&, const QString&)
    {45, 467, 3, 1, 0, 0, 30},	//544 QXmlStreamWriter::writeDefaultNamespace(const QString&)
    {45, 479, 25, 2, 0, 0, 31},	//545 QXmlStreamWriter::writeProcessingInstruction(const QString&, const QString&)
    {45, 482, 0, 0, 0, 0, 32},	//546 QXmlStreamWriter::writeStartDocument()
    {45, 482, 3, 1, 0, 0, 33},	//547 QXmlStreamWriter::writeStartDocument(const QString&)
    {45, 482, 90, 2, 0, 0, 34},	//548 QXmlStreamWriter::writeStartDocument(const QString&, bool)
    {45, 485, 3, 1, 0, 0, 35},	//549 QXmlStreamWriter::writeStartElement(const QString&)
    {45, 485, 25, 2, 0, 0, 36},	//550 QXmlStreamWriter::writeStartElement(const QString&, const QString&)
    {45, 463, 362, 1, 0, 0, 37},	//551 QXmlStreamWriter::writeCurrentToken(const QXmlStreamReader&)
    {45, 199, 0, 0, Smoke::mf_const, 159, 38},	//552 QXmlStreamWriter::hasError() const
    {45, 476, 3, 1, 0, 0, 39},	//553 QXmlStreamWriter::writeNamespace(const QString&)
    {45, 479, 3, 1, 0, 0, 40},	//554 QXmlStreamWriter::writeProcessingInstruction(const QString&)
    {45, 522, 0, 0, Smoke::mf_dtor, 0, 41 },	//555 QXmlStreamWriter::~QXmlStreamWriter()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    328,  // QXmlAttributes::type(int) const
    329,  // QXmlAttributes::type(const QString&) const
    0,
    331,  // QXmlAttributes::value(int) const
    332,  // QXmlAttributes::value(const QString&) const
    0,
    36,  // QDomDocument::QDomDocument(const QDomDocumentType&)
    37,  // QDomDocument::QDomDocument(const QDomDocument&)
    0,
    79,  // QDomDocument::setContent(const QByteArray&)
    85,  // QDomDocument::setContent(QIODevice*)
    0,
    67,  // QDomDocument::setContent(const QByteArray&, bool)
    73,  // QDomDocument::setContent(QIODevice*, bool)
    76,  // QDomDocument::setContent(QXmlInputSource*, bool)
    80,  // QDomDocument::setContent(const QByteArray&, QString*)
    86,  // QDomDocument::setContent(QIODevice*, QString*)
    0,
    68,  // QDomDocument::setContent(const QByteArray&, bool, QString*)
    74,  // QDomDocument::setContent(QIODevice*, bool, QString*)
    77,  // QDomDocument::setContent(QXmlInputSource*, bool, QString*)
    81,  // QDomDocument::setContent(const QByteArray&, QString*, int*)
    87,  // QDomDocument::setContent(QIODevice*, QString*, int*)
    0,
    61,  // QDomDocument::setContent(const QByteArray&, QString*, int*, int*)
    63,  // QDomDocument::setContent(QIODevice*, QString*, int*, int*)
    69,  // QDomDocument::setContent(const QByteArray&, bool, QString*, int*)
    75,  // QDomDocument::setContent(QIODevice*, bool, QString*, int*)
    78,  // QDomDocument::setContent(QXmlInputSource*, bool, QString*, int*)
    0,
    57,  // QDomDocument::setContent(const QByteArray&, bool, QString*, int*, int*)
    59,  // QDomDocument::setContent(QIODevice*, bool, QString*, int*, int*)
    60,  // QDomDocument::setContent(QXmlInputSource*, bool, QString*, int*, int*)
    0,
    70,  // QDomDocument::setContent(const QString&, bool)
    83,  // QDomDocument::setContent(const QString&, QString*)
    0,
    71,  // QDomDocument::setContent(const QString&, bool, QString*)
    84,  // QDomDocument::setContent(const QString&, QString*, int*)
    0,
    62,  // QDomDocument::setContent(const QString&, QString*, int*, int*)
    72,  // QDomDocument::setContent(const QString&, bool, QString*, int*)
    0,
    516,  // QXmlStreamWriter::QXmlStreamWriter(QIODevice*)
    517,  // QXmlStreamWriter::QXmlStreamWriter(QByteArray*)
    0,
    114,  // QDomElement::setAttribute(const QString&, const QString&)
    115,  // QDomElement::setAttribute(const QString&, long long)
    116,  // QDomElement::setAttribute(const QString&, unsigned long long)
    117,  // QDomElement::setAttribute(const QString&, int)
    118,  // QDomElement::setAttribute(const QString&, unsigned int)
    119,  // QDomElement::setAttribute(const QString&, float)
    120,  // QDomElement::setAttribute(const QString&, double)
    0,
    128,  // QDomElement::setAttributeNS(const QString, const QString&, const QString&)
    129,  // QDomElement::setAttributeNS(const QString, const QString&, int)
    130,  // QDomElement::setAttributeNS(const QString, const QString&, unsigned int)
    131,  // QDomElement::setAttributeNS(const QString, const QString&, long long)
    132,  // QDomElement::setAttributeNS(const QString, const QString&, unsigned long long)
    133,  // QDomElement::setAttributeNS(const QString, const QString&, double)
    0,
    508,  // QXmlSimpleReader::parse(const QXmlInputSource&)
    509,  // QXmlSimpleReader::parse(const QXmlInputSource*)
    0,
    482,  // QXmlReader::parse(const QXmlInputSource&)
    483,  // QXmlReader::parse(const QXmlInputSource*)
    0,
    410,  // QXmlInputSource::QXmlInputSource(QIODevice*)
    418,  // QXmlInputSource::QXmlInputSource(const QXmlInputSource&)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {4, 21, 1},	// QDomAttr::QDomAttr
    {4, 22, 2},	// QDomAttr::QDomAttr#
    {4, 253, 4},	// QDomAttr::name
    {4, 264, 9},	// QDomAttr::nodeType
    {4, 276, 3},	// QDomAttr::operator=#
    {4, 280, 6},	// QDomAttr::ownerElement
    {4, 396, 8},	// QDomAttr::setValue$
    {4, 400, 5},	// QDomAttr::specified
    {4, 445, 7},	// QDomAttr::value
    {4, 491, 10},	// QDomAttr::~QDomAttr
    {5, 23, 11},	// QDomCDATASection::QDomCDATASection
    {5, 24, 12},	// QDomCDATASection::QDomCDATASection#
    {5, 264, 14},	// QDomCDATASection::nodeType
    {5, 276, 13},	// QDomCDATASection::operator=#
    {5, 492, 15},	// QDomCDATASection::~QDomCDATASection
    {6, 25, 16},	// QDomCharacterData::QDomCharacterData
    {6, 26, 17},	// QDomCharacterData::QDomCharacterData#
    {6, 96, 20},	// QDomCharacterData::appendData$
    {6, 151, 25},	// QDomCharacterData::data
    {6, 154, 22},	// QDomCharacterData::deleteData$$
    {6, 220, 21},	// QDomCharacterData::insertData$$
    {6, 247, 24},	// QDomCharacterData::length
    {6, 264, 27},	// QDomCharacterData::nodeType
    {6, 276, 18},	// QDomCharacterData::operator=#
    {6, 320, 23},	// QDomCharacterData::replaceData$$$
    {6, 363, 26},	// QDomCharacterData::setData$
    {6, 416, 19},	// QDomCharacterData::substringData$$
    {6, 493, 28},	// QDomCharacterData::~QDomCharacterData
    {7, 27, 29},	// QDomComment::QDomComment
    {7, 28, 30},	// QDomComment::QDomComment#
    {7, 264, 32},	// QDomComment::nodeType
    {7, 276, 31},	// QDomComment::operator=#
    {7, 494, 33},	// QDomComment::~QDomComment
    {8, 29, 34},	// QDomDocument::QDomDocument
    {8, 30, -7},	// QDomDocument::QDomDocument#
    {8, 31, 35},	// QDomDocument::QDomDocument$
    {8, 129, 45},	// QDomDocument::createAttribute$
    {8, 131, 50},	// QDomDocument::createAttributeNS$$
    {8, 133, 43},	// QDomDocument::createCDATASection$
    {8, 135, 42},	// QDomDocument::createComment$
    {8, 138, 40},	// QDomDocument::createDocumentFragment
    {8, 142, 39},	// QDomDocument::createElement$
    {8, 144, 49},	// QDomDocument::createElementNS$$
    {8, 146, 46},	// QDomDocument::createEntityReference$
    {8, 148, 44},	// QDomDocument::createProcessingInstruction$$
    {8, 150, 41},	// QDomDocument::createTextNode$
    {8, 156, 53},	// QDomDocument::doctype
    {8, 157, 55},	// QDomDocument::documentElement
    {8, 159, 52},	// QDomDocument::elementById$
    {8, 161, 47},	// QDomDocument::elementsByTagName$
    {8, 163, 51},	// QDomDocument::elementsByTagNameNS$$
    {8, 208, 54},	// QDomDocument::implementation
    {8, 210, 48},	// QDomDocument::importNode#$
    {8, 264, 56},	// QDomDocument::nodeType
    {8, 276, 38},	// QDomDocument::operator=#
    {8, 343, -10},	// QDomDocument::setContent#
    {8, 344, 88},	// QDomDocument::setContent##
    {8, 345, 89},	// QDomDocument::setContent##$
    {8, 346, 90},	// QDomDocument::setContent##$$
    {8, 347, 64},	// QDomDocument::setContent##$$$
    {8, 348, -13},	// QDomDocument::setContent#$
    {8, 349, -19},	// QDomDocument::setContent#$$
    {8, 350, -25},	// QDomDocument::setContent#$$$
    {8, 351, -31},	// QDomDocument::setContent#$$$$
    {8, 352, 82},	// QDomDocument::setContent$
    {8, 353, -35},	// QDomDocument::setContent$$
    {8, 354, -38},	// QDomDocument::setContent$$$
    {8, 355, -41},	// QDomDocument::setContent$$$$
    {8, 356, 58},	// QDomDocument::setContent$$$$$
    {8, 422, 92},	// QDomDocument::toByteArray
    {8, 423, 66},	// QDomDocument::toByteArray$
    {8, 435, 91},	// QDomDocument::toString
    {8, 436, 65},	// QDomDocument::toString$
    {8, 495, 93},	// QDomDocument::~QDomDocument
    {9, 32, 94},	// QDomDocumentFragment::QDomDocumentFragment
    {9, 33, 95},	// QDomDocumentFragment::QDomDocumentFragment#
    {9, 264, 97},	// QDomDocumentFragment::nodeType
    {9, 276, 96},	// QDomDocumentFragment::operator=#
    {9, 496, 98},	// QDomDocumentFragment::~QDomDocumentFragment
    {10, 34, 99},	// QDomDocumentType::QDomDocumentType
    {10, 35, 100},	// QDomDocumentType::QDomDocumentType#
    {10, 173, 103},	// QDomDocumentType::entities
    {10, 223, 107},	// QDomDocumentType::internalSubset
    {10, 253, 102},	// QDomDocumentType::name
    {10, 264, 108},	// QDomDocumentType::nodeType
    {10, 270, 104},	// QDomDocumentType::notations
    {10, 276, 101},	// QDomDocumentType::operator=#
    {10, 301, 105},	// QDomDocumentType::publicId
    {10, 417, 106},	// QDomDocumentType::systemId
    {10, 497, 109},	// QDomDocumentType::~QDomDocumentType
    {11, 36, 110},	// QDomElement::QDomElement
    {11, 37, 111},	// QDomElement::QDomElement#
    {11, 100, 144},	// QDomElement::attribute$
    {11, 101, 113},	// QDomElement::attribute$$
    {11, 105, 145},	// QDomElement::attributeNS$$
    {11, 106, 127},	// QDomElement::attributeNS$$$
    {11, 108, 122},	// QDomElement::attributeNode$
    {11, 110, 135},	// QDomElement::attributeNodeNS$$
    {11, 111, 141},	// QDomElement::attributes
    {11, 161, 125},	// QDomElement::elementsByTagName$
    {11, 163, 137},	// QDomElement::elementsByTagNameNS$$
    {11, 194, 126},	// QDomElement::hasAttribute$
    {11, 196, 138},	// QDomElement::hasAttributeNS$$
    {11, 264, 142},	// QDomElement::nodeType
    {11, 276, 112},	// QDomElement::operator=#
    {11, 306, 121},	// QDomElement::removeAttribute$
    {11, 308, 134},	// QDomElement::removeAttributeNS$$
    {11, 310, 124},	// QDomElement::removeAttributeNode#
    {11, 328, -47},	// QDomElement::setAttribute$$
    {11, 330, -55},	// QDomElement::setAttributeNS$$$
    {11, 332, 123},	// QDomElement::setAttributeNode#
    {11, 334, 136},	// QDomElement::setAttributeNodeNS#
    {11, 394, 140},	// QDomElement::setTagName$
    {11, 418, 139},	// QDomElement::tagName
    {11, 420, 143},	// QDomElement::text
    {11, 498, 146},	// QDomElement::~QDomElement
    {12, 38, 147},	// QDomEntity::QDomEntity
    {12, 39, 148},	// QDomEntity::QDomEntity#
    {12, 264, 153},	// QDomEntity::nodeType
    {12, 269, 152},	// QDomEntity::notationName
    {12, 276, 149},	// QDomEntity::operator=#
    {12, 301, 150},	// QDomEntity::publicId
    {12, 417, 151},	// QDomEntity::systemId
    {12, 499, 154},	// QDomEntity::~QDomEntity
    {13, 40, 155},	// QDomEntityReference::QDomEntityReference
    {13, 41, 156},	// QDomEntityReference::QDomEntityReference#
    {13, 264, 158},	// QDomEntityReference::nodeType
    {13, 276, 157},	// QDomEntityReference::operator=#
    {13, 500, 159},	// QDomEntityReference::~QDomEntityReference
    {14, 1, 171},	// QDomImplementation::AcceptInvalidChars
    {14, 11, 172},	// QDomImplementation::DropInvalidChars
    {14, 42, 160},	// QDomImplementation::QDomImplementation
    {14, 43, 161},	// QDomImplementation::QDomImplementation#
    {14, 89, 173},	// QDomImplementation::ReturnNullNode
    {14, 137, 167},	// QDomImplementation::createDocument$$#
    {14, 140, 166},	// QDomImplementation::createDocumentType$$$
    {14, 202, 165},	// QDomImplementation::hasFeature$$
    {14, 224, 168},	// QDomImplementation::invalidDataPolicy
    {14, 237, 170},	// QDomImplementation::isNull
    {14, 272, 164},	// QDomImplementation::operator!=#
    {14, 276, 162},	// QDomImplementation::operator=#
    {14, 278, 163},	// QDomImplementation::operator==#
    {14, 379, 169},	// QDomImplementation::setInvalidDataPolicy$
    {14, 501, 174},	// QDomImplementation::~QDomImplementation
    {15, 44, 175},	// QDomNamedNodeMap::QDomNamedNodeMap
    {15, 45, 176},	// QDomNamedNodeMap::QDomNamedNodeMap#
    {15, 125, 191},	// QDomNamedNodeMap::contains$
    {15, 127, 188},	// QDomNamedNodeMap::count
    {15, 233, 190},	// QDomNamedNodeMap::isEmpty
    {15, 243, 183},	// QDomNamedNodeMap::item$
    {15, 247, 187},	// QDomNamedNodeMap::length
    {15, 255, 180},	// QDomNamedNodeMap::namedItem$
    {15, 257, 184},	// QDomNamedNodeMap::namedItemNS$$
    {15, 272, 179},	// QDomNamedNodeMap::operator!=#
    {15, 276, 177},	// QDomNamedNodeMap::operator=#
    {15, 278, 178},	// QDomNamedNodeMap::operator==#
    {15, 314, 182},	// QDomNamedNodeMap::removeNamedItem$
    {15, 316, 186},	// QDomNamedNodeMap::removeNamedItemNS$$
    {15, 383, 181},	// QDomNamedNodeMap::setNamedItem#
    {15, 385, 185},	// QDomNamedNodeMap::setNamedItemNS#
    {15, 397, 189},	// QDomNamedNodeMap::size
    {15, 502, 192},	// QDomNamedNodeMap::~QDomNamedNodeMap
    {16, 2, 269},	// QDomNode::AttributeNode
    {16, 3, 280},	// QDomNode::BaseNode
    {16, 4, 271},	// QDomNode::CDATASectionNode
    {16, 5, 281},	// QDomNode::CharacterDataNode
    {16, 6, 275},	// QDomNode::CommentNode
    {16, 8, 278},	// QDomNode::DocumentFragmentNode
    {16, 9, 276},	// QDomNode::DocumentNode
    {16, 10, 277},	// QDomNode::DocumentTypeNode
    {16, 12, 268},	// QDomNode::ElementNode
    {16, 13, 282},	// QDomNode::EncodingFromDocument
    {16, 14, 283},	// QDomNode::EncodingFromTextStream
    {16, 17, 273},	// QDomNode::EntityNode
    {16, 18, 272},	// QDomNode::EntityReferenceNode
    {16, 19, 279},	// QDomNode::NotationNode
    {16, 20, 274},	// QDomNode::ProcessingInstructionNode
    {16, 46, 193},	// QDomNode::QDomNode
    {16, 47, 194},	// QDomNode::QDomNode#
    {16, 90, 270},	// QDomNode::TextNode
    {16, 94, 202},	// QDomNode::appendChild#
    {16, 111, 215},	// QDomNode::attributes
    {16, 116, 210},	// QDomNode::childNodes
    {16, 117, 239},	// QDomNode::clear
    {16, 118, 261},	// QDomNode::cloneNode
    {16, 119, 204},	// QDomNode::cloneNode$
    {16, 121, 260},	// QDomNode::columnNumber
    {16, 187, 211},	// QDomNode::firstChild
    {16, 188, 262},	// QDomNode::firstChildElement
    {16, 189, 255},	// QDomNode::firstChildElement$
    {16, 197, 219},	// QDomNode::hasAttributes
    {16, 198, 203},	// QDomNode::hasChildNodes
    {16, 207, 266},	// QDomNode::impl
    {16, 216, 199},	// QDomNode::insertAfter##
    {16, 218, 198},	// QDomNode::insertBefore##
    {16, 225, 224},	// QDomNode::isAttr
    {16, 226, 225},	// QDomNode::isCDATASection
    {16, 227, 235},	// QDomNode::isCharacterData
    {16, 228, 236},	// QDomNode::isComment
    {16, 229, 227},	// QDomNode::isDocument
    {16, 230, 226},	// QDomNode::isDocumentFragment
    {16, 231, 228},	// QDomNode::isDocumentType
    {16, 232, 229},	// QDomNode::isElement
    {16, 234, 232},	// QDomNode::isEntity
    {16, 235, 230},	// QDomNode::isEntityReference
    {16, 236, 233},	// QDomNode::isNotation
    {16, 237, 238},	// QDomNode::isNull
    {16, 238, 234},	// QDomNode::isProcessingInstruction
    {16, 240, 206},	// QDomNode::isSupported$$
    {16, 241, 231},	// QDomNode::isText
    {16, 244, 212},	// QDomNode::lastChild
    {16, 245, 263},	// QDomNode::lastChildElement
    {16, 246, 256},	// QDomNode::lastChildElement$
    {16, 249, 259},	// QDomNode::lineNumber
    {16, 250, 218},	// QDomNode::localName
    {16, 255, 237},	// QDomNode::namedItem$
    {16, 258, 217},	// QDomNode::namespaceURI
    {16, 260, 214},	// QDomNode::nextSibling
    {16, 261, 265},	// QDomNode::nextSiblingElement
    {16, 262, 258},	// QDomNode::nextSiblingElement$
    {16, 263, 207},	// QDomNode::nodeName
    {16, 264, 208},	// QDomNode::nodeType
    {16, 265, 220},	// QDomNode::nodeValue
    {16, 266, 205},	// QDomNode::normalize
    {16, 272, 197},	// QDomNode::operator!=#
    {16, 276, 195},	// QDomNode::operator=#
    {16, 278, 196},	// QDomNode::operator==#
    {16, 279, 216},	// QDomNode::ownerDocument
    {16, 281, 209},	// QDomNode::parentNode
    {16, 287, 222},	// QDomNode::prefix
    {16, 291, 213},	// QDomNode::previousSibling
    {16, 292, 264},	// QDomNode::previousSiblingElement
    {16, 293, 257},	// QDomNode::previousSiblingElement$
    {16, 312, 201},	// QDomNode::removeChild#
    {16, 318, 200},	// QDomNode::replaceChild##
    {16, 325, 253},	// QDomNode::save#$
    {16, 326, 254},	// QDomNode::save#$$
    {16, 377, 267},	// QDomNode::setImpl#
    {16, 387, 221},	// QDomNode::setNodeValue$
    {16, 389, 223},	// QDomNode::setPrefix$
    {16, 421, 240},	// QDomNode::toAttr
    {16, 424, 241},	// QDomNode::toCDATASection
    {16, 425, 251},	// QDomNode::toCharacterData
    {16, 426, 252},	// QDomNode::toComment
    {16, 427, 243},	// QDomNode::toDocument
    {16, 428, 242},	// QDomNode::toDocumentFragment
    {16, 429, 244},	// QDomNode::toDocumentType
    {16, 430, 245},	// QDomNode::toElement
    {16, 431, 248},	// QDomNode::toEntity
    {16, 432, 246},	// QDomNode::toEntityReference
    {16, 433, 249},	// QDomNode::toNotation
    {16, 434, 250},	// QDomNode::toProcessingInstruction
    {16, 437, 247},	// QDomNode::toText
    {16, 503, 284},	// QDomNode::~QDomNode
    {17, 48, 285},	// QDomNodeList::QDomNodeList
    {17, 49, 286},	// QDomNodeList::QDomNodeList#
    {17, 98, 291},	// QDomNodeList::at$
    {17, 127, 293},	// QDomNodeList::count
    {17, 233, 295},	// QDomNodeList::isEmpty
    {17, 243, 290},	// QDomNodeList::item$
    {17, 247, 292},	// QDomNodeList::length
    {17, 272, 289},	// QDomNodeList::operator!=#
    {17, 276, 287},	// QDomNodeList::operator=#
    {17, 278, 288},	// QDomNodeList::operator==#
    {17, 397, 294},	// QDomNodeList::size
    {17, 504, 296},	// QDomNodeList::~QDomNodeList
    {19, 50, 297},	// QDomNotation::QDomNotation
    {19, 51, 298},	// QDomNotation::QDomNotation#
    {19, 264, 302},	// QDomNotation::nodeType
    {19, 276, 299},	// QDomNotation::operator=#
    {19, 301, 300},	// QDomNotation::publicId
    {19, 417, 301},	// QDomNotation::systemId
    {19, 505, 303},	// QDomNotation::~QDomNotation
    {20, 52, 304},	// QDomProcessingInstruction::QDomProcessingInstruction
    {20, 53, 305},	// QDomProcessingInstruction::QDomProcessingInstruction#
    {20, 151, 308},	// QDomProcessingInstruction::data
    {20, 264, 310},	// QDomProcessingInstruction::nodeType
    {20, 276, 306},	// QDomProcessingInstruction::operator=#
    {20, 363, 309},	// QDomProcessingInstruction::setData$
    {20, 419, 307},	// QDomProcessingInstruction::target
    {20, 506, 311},	// QDomProcessingInstruction::~QDomProcessingInstruction
    {21, 54, 312},	// QDomText::QDomText
    {21, 55, 313},	// QDomText::QDomText#
    {21, 264, 316},	// QDomText::nodeType
    {21, 276, 314},	// QDomText::operator=#
    {21, 404, 315},	// QDomText::splitText$
    {21, 507, 317},	// QDomText::~QDomText
    {22, 274, 318},	// QGlobalSpace::operator<<##
    {28, 56, 319},	// QXmlAttributes::QXmlAttributes
    {28, 57, 337},	// QXmlAttributes::QXmlAttributes#
    {28, 92, 336},	// QXmlAttributes::append$$$$
    {28, 117, 335},	// QXmlAttributes::clear
    {28, 127, 324},	// QXmlAttributes::count
    {28, 212, 321},	// QXmlAttributes::index#
    {28, 213, 320},	// QXmlAttributes::index$
    {28, 214, 322},	// QXmlAttributes::index$$
    {28, 247, 323},	// QXmlAttributes::length
    {28, 251, 325},	// QXmlAttributes::localName$
    {28, 304, 326},	// QXmlAttributes::qName$
    {28, 439, -1},	// QXmlAttributes::type$
    {28, 440, 330},	// QXmlAttributes::type$$
    {28, 444, 327},	// QXmlAttributes::uri$
    {28, 446, 333},	// QXmlAttributes::value#
    {28, 447, -4},	// QXmlAttributes::value$
    {28, 448, 334},	// QXmlAttributes::value$$
    {28, 508, 338},	// QXmlAttributes::~QXmlAttributes
    {29, 58, 351},	// QXmlContentHandler::QXmlContentHandler
    {29, 59, 352},	// QXmlContentHandler::QXmlContentHandler#
    {29, 115, 346},	// QXmlContentHandler::characters$
    {29, 166, 341},	// QXmlContentHandler::endDocument
    {29, 168, 345},	// QXmlContentHandler::endElement$$$
    {29, 172, 343},	// QXmlContentHandler::endPrefixMapping$
    {29, 178, 350},	// QXmlContentHandler::errorString
    {29, 206, 347},	// QXmlContentHandler::ignorableWhitespace$
    {29, 297, 348},	// QXmlContentHandler::processingInstruction$$
    {29, 369, 339},	// QXmlContentHandler::setDocumentLocator#
    {29, 399, 349},	// QXmlContentHandler::skippedEntity$
    {29, 408, 340},	// QXmlContentHandler::startDocument
    {29, 410, 344},	// QXmlContentHandler::startElement$$$#
    {29, 414, 342},	// QXmlContentHandler::startPrefixMapping$$
    {29, 509, 353},	// QXmlContentHandler::~QXmlContentHandler
    {30, 60, 357},	// QXmlDTDHandler::QXmlDTDHandler
    {30, 61, 358},	// QXmlDTDHandler::QXmlDTDHandler#
    {30, 178, 356},	// QXmlDTDHandler::errorString
    {30, 268, 354},	// QXmlDTDHandler::notationDecl$$$
    {30, 442, 355},	// QXmlDTDHandler::unparsedEntityDecl$$$$
    {30, 510, 359},	// QXmlDTDHandler::~QXmlDTDHandler
    {31, 62, 364},	// QXmlDeclHandler::QXmlDeclHandler
    {31, 63, 365},	// QXmlDeclHandler::QXmlDeclHandler#
    {31, 103, 360},	// QXmlDeclHandler::attributeDecl$$$$$
    {31, 178, 363},	// QXmlDeclHandler::errorString
    {31, 180, 362},	// QXmlDeclHandler::externalEntityDecl$$$
    {31, 222, 361},	// QXmlDeclHandler::internalEntityDecl$$
    {31, 511, 366},	// QXmlDeclHandler::~QXmlDeclHandler
    {32, 64, 367},	// QXmlDefaultHandler::QXmlDefaultHandler
    {32, 103, 392},	// QXmlDefaultHandler::attributeDecl$$$$$
    {32, 115, 375},	// QXmlDefaultHandler::characters$
    {32, 123, 391},	// QXmlDefaultHandler::comment$
    {32, 164, 390},	// QXmlDefaultHandler::endCDATA
    {32, 165, 386},	// QXmlDefaultHandler::endDTD
    {32, 166, 370},	// QXmlDefaultHandler::endDocument
    {32, 168, 374},	// QXmlDefaultHandler::endElement$$$
    {32, 170, 388},	// QXmlDefaultHandler::endEntity$
    {32, 172, 372},	// QXmlDefaultHandler::endPrefixMapping$
    {32, 176, 380},	// QXmlDefaultHandler::error#
    {32, 178, 395},	// QXmlDefaultHandler::errorString
    {32, 180, 394},	// QXmlDefaultHandler::externalEntityDecl$$$
    {32, 182, 381},	// QXmlDefaultHandler::fatalError#
    {32, 206, 376},	// QXmlDefaultHandler::ignorableWhitespace$
    {32, 222, 393},	// QXmlDefaultHandler::internalEntityDecl$$
    {32, 268, 382},	// QXmlDefaultHandler::notationDecl$$$
    {32, 297, 377},	// QXmlDefaultHandler::processingInstruction$$
    {32, 323, 384},	// QXmlDefaultHandler::resolveEntity$$#
    {32, 369, 368},	// QXmlDefaultHandler::setDocumentLocator#
    {32, 399, 378},	// QXmlDefaultHandler::skippedEntity$
    {32, 405, 389},	// QXmlDefaultHandler::startCDATA
    {32, 407, 385},	// QXmlDefaultHandler::startDTD$$$
    {32, 408, 369},	// QXmlDefaultHandler::startDocument
    {32, 410, 373},	// QXmlDefaultHandler::startElement$$$#
    {32, 412, 387},	// QXmlDefaultHandler::startEntity$
    {32, 414, 371},	// QXmlDefaultHandler::startPrefixMapping$$
    {32, 442, 383},	// QXmlDefaultHandler::unparsedEntityDecl$$$$
    {32, 450, 379},	// QXmlDefaultHandler::warning#
    {32, 512, 396},	// QXmlDefaultHandler::~QXmlDefaultHandler
    {33, 65, 399},	// QXmlEntityResolver::QXmlEntityResolver
    {33, 66, 400},	// QXmlEntityResolver::QXmlEntityResolver#
    {33, 178, 398},	// QXmlEntityResolver::errorString
    {33, 323, 397},	// QXmlEntityResolver::resolveEntity$$#
    {33, 513, 401},	// QXmlEntityResolver::~QXmlEntityResolver
    {34, 67, 406},	// QXmlErrorHandler::QXmlErrorHandler
    {34, 68, 407},	// QXmlErrorHandler::QXmlErrorHandler#
    {34, 176, 403},	// QXmlErrorHandler::error#
    {34, 178, 405},	// QXmlErrorHandler::errorString
    {34, 182, 404},	// QXmlErrorHandler::fatalError#
    {34, 450, 402},	// QXmlErrorHandler::warning#
    {34, 514, 408},	// QXmlErrorHandler::~QXmlErrorHandler
    {35, 15, 420},	// QXmlInputSource::EndOfData
    {35, 16, 421},	// QXmlInputSource::EndOfDocument
    {35, 69, 409},	// QXmlInputSource::QXmlInputSource
    {35, 70, -68},	// QXmlInputSource::QXmlInputSource#
    {35, 151, 414},	// QXmlInputSource::data
    {35, 186, 413},	// QXmlInputSource::fetchData
    {35, 191, 419},	// QXmlInputSource::fromRawData#
    {35, 192, 417},	// QXmlInputSource::fromRawData#$
    {35, 259, 415},	// QXmlInputSource::next
    {35, 321, 416},	// QXmlInputSource::reset
    {35, 362, 412},	// QXmlInputSource::setData#
    {35, 363, 411},	// QXmlInputSource::setData$
    {35, 515, 422},	// QXmlInputSource::~QXmlInputSource
    {36, 71, 431},	// QXmlLexicalHandler::QXmlLexicalHandler
    {36, 72, 432},	// QXmlLexicalHandler::QXmlLexicalHandler#
    {36, 123, 429},	// QXmlLexicalHandler::comment$
    {36, 164, 428},	// QXmlLexicalHandler::endCDATA
    {36, 165, 424},	// QXmlLexicalHandler::endDTD
    {36, 170, 426},	// QXmlLexicalHandler::endEntity$
    {36, 178, 430},	// QXmlLexicalHandler::errorString
    {36, 405, 427},	// QXmlLexicalHandler::startCDATA
    {36, 407, 423},	// QXmlLexicalHandler::startDTD$$$
    {36, 412, 425},	// QXmlLexicalHandler::startEntity$
    {36, 516, 433},	// QXmlLexicalHandler::~QXmlLexicalHandler
    {37, 73, 434},	// QXmlLocator::QXmlLocator
    {37, 74, 437},	// QXmlLocator::QXmlLocator#
    {37, 121, 435},	// QXmlLocator::columnNumber
    {37, 249, 436},	// QXmlLocator::lineNumber
    {37, 517, 438},	// QXmlLocator::~QXmlLocator
    {38, 75, 439},	// QXmlNamespaceSupport::QXmlNamespaceSupport
    {38, 286, 448},	// QXmlNamespaceSupport::popContext
    {38, 288, 441},	// QXmlNamespaceSupport::prefix$
    {38, 289, 445},	// QXmlNamespaceSupport::prefixes
    {38, 290, 446},	// QXmlNamespaceSupport::prefixes$
    {38, 295, 444},	// QXmlNamespaceSupport::processName$$$$
    {38, 302, 447},	// QXmlNamespaceSupport::pushContext
    {38, 321, 449},	// QXmlNamespaceSupport::reset
    {38, 390, 440},	// QXmlNamespaceSupport::setPrefix$$
    {38, 402, 443},	// QXmlNamespaceSupport::splitName$$$
    {38, 444, 442},	// QXmlNamespaceSupport::uri$
    {38, 518, 450},	// QXmlNamespaceSupport::~QXmlNamespaceSupport
    {39, 76, 458},	// QXmlParseException::QXmlParseException
    {39, 77, 452},	// QXmlParseException::QXmlParseException#
    {39, 78, 459},	// QXmlParseException::QXmlParseException$
    {39, 79, 460},	// QXmlParseException::QXmlParseException$$
    {39, 80, 461},	// QXmlParseException::QXmlParseException$$$
    {39, 81, 462},	// QXmlParseException::QXmlParseException$$$$
    {39, 82, 451},	// QXmlParseException::QXmlParseException$$$$$
    {39, 121, 453},	// QXmlParseException::columnNumber
    {39, 249, 454},	// QXmlParseException::lineNumber
    {39, 252, 457},	// QXmlParseException::message
    {39, 301, 455},	// QXmlParseException::publicId
    {39, 417, 456},	// QXmlParseException::systemId
    {39, 519, 463},	// QXmlParseException::~QXmlParseException
    {40, 7, 473},	// QXmlReader::DTDHandler
    {40, 83, 484},	// QXmlReader::QXmlReader
    {40, 84, 485},	// QXmlReader::QXmlReader#
    {40, 126, 475},	// QXmlReader::contentHandler
    {40, 152, 481},	// QXmlReader::declHandler
    {40, 174, 471},	// QXmlReader::entityResolver
    {40, 177, 477},	// QXmlReader::errorHandler
    {40, 184, 486},	// QXmlReader::feature$
    {40, 185, 464},	// QXmlReader::feature$$
    {40, 201, 466},	// QXmlReader::hasFeature$
    {40, 204, 469},	// QXmlReader::hasProperty$
    {40, 248, 479},	// QXmlReader::lexicalHandler
    {40, 283, -65},	// QXmlReader::parse#
    {40, 299, 487},	// QXmlReader::property$
    {40, 300, 467},	// QXmlReader::property$$
    {40, 358, 474},	// QXmlReader::setContentHandler#
    {40, 360, 472},	// QXmlReader::setDTDHandler#
    {40, 365, 480},	// QXmlReader::setDeclHandler#
    {40, 371, 470},	// QXmlReader::setEntityResolver#
    {40, 373, 476},	// QXmlReader::setErrorHandler#
    {40, 375, 465},	// QXmlReader::setFeature$$
    {40, 381, 478},	// QXmlReader::setLexicalHandler#
    {40, 392, 468},	// QXmlReader::setProperty$$
    {40, 520, 488},	// QXmlReader::~QXmlReader
    {41, 7, 499},	// QXmlSimpleReader::DTDHandler
    {41, 85, 489},	// QXmlSimpleReader::QXmlSimpleReader
    {41, 126, 501},	// QXmlSimpleReader::contentHandler
    {41, 152, 507},	// QXmlSimpleReader::declHandler
    {41, 174, 497},	// QXmlSimpleReader::entityResolver
    {41, 177, 503},	// QXmlSimpleReader::errorHandler
    {41, 184, 512},	// QXmlSimpleReader::feature$
    {41, 185, 490},	// QXmlSimpleReader::feature$$
    {41, 201, 492},	// QXmlSimpleReader::hasFeature$
    {41, 204, 495},	// QXmlSimpleReader::hasProperty$
    {41, 248, 505},	// QXmlSimpleReader::lexicalHandler
    {41, 283, -62},	// QXmlSimpleReader::parse#
    {41, 284, 510},	// QXmlSimpleReader::parse#$
    {41, 285, 511},	// QXmlSimpleReader::parseContinue
    {41, 299, 513},	// QXmlSimpleReader::property$
    {41, 300, 493},	// QXmlSimpleReader::property$$
    {41, 358, 500},	// QXmlSimpleReader::setContentHandler#
    {41, 360, 498},	// QXmlSimpleReader::setDTDHandler#
    {41, 365, 506},	// QXmlSimpleReader::setDeclHandler#
    {41, 371, 496},	// QXmlSimpleReader::setEntityResolver#
    {41, 373, 502},	// QXmlSimpleReader::setErrorHandler#
    {41, 375, 491},	// QXmlSimpleReader::setFeature$$
    {41, 381, 504},	// QXmlSimpleReader::setLexicalHandler#
    {41, 392, 494},	// QXmlSimpleReader::setProperty$$
    {41, 521, 514},	// QXmlSimpleReader::~QXmlSimpleReader
    {45, 86, 515},	// QXmlStreamWriter::QXmlStreamWriter
    {45, 87, -44},	// QXmlStreamWriter::QXmlStreamWriter#
    {45, 88, 518},	// QXmlStreamWriter::QXmlStreamWriter$
    {45, 112, 525},	// QXmlStreamWriter::autoFormatting
    {45, 113, 527},	// QXmlStreamWriter::autoFormattingIndent
    {45, 120, 523},	// QXmlStreamWriter::codec
    {45, 155, 520},	// QXmlStreamWriter::device
    {45, 199, 552},	// QXmlStreamWriter::hasError
    {45, 336, 524},	// QXmlStreamWriter::setAutoFormatting$
    {45, 338, 526},	// QXmlStreamWriter::setAutoFormattingIndent$
    {45, 340, 521},	// QXmlStreamWriter::setCodec#
    {45, 341, 522},	// QXmlStreamWriter::setCodec$
    {45, 367, 519},	// QXmlStreamWriter::setDevice#
    {45, 452, 530},	// QXmlStreamWriter::writeAttribute#
    {45, 453, 528},	// QXmlStreamWriter::writeAttribute$$
    {45, 454, 529},	// QXmlStreamWriter::writeAttribute$$$
    {45, 456, 531},	// QXmlStreamWriter::writeAttributes#
    {45, 458, 532},	// QXmlStreamWriter::writeCDATA$
    {45, 460, 533},	// QXmlStreamWriter::writeCharacters$
    {45, 462, 534},	// QXmlStreamWriter::writeComment$
    {45, 464, 551},	// QXmlStreamWriter::writeCurrentToken#
    {45, 466, 535},	// QXmlStreamWriter::writeDTD$
    {45, 468, 544},	// QXmlStreamWriter::writeDefaultNamespace$
    {45, 470, 536},	// QXmlStreamWriter::writeEmptyElement$
    {45, 471, 537},	// QXmlStreamWriter::writeEmptyElement$$
    {45, 472, 540},	// QXmlStreamWriter::writeEndDocument
    {45, 473, 541},	// QXmlStreamWriter::writeEndElement
    {45, 475, 542},	// QXmlStreamWriter::writeEntityReference$
    {45, 477, 553},	// QXmlStreamWriter::writeNamespace$
    {45, 478, 543},	// QXmlStreamWriter::writeNamespace$$
    {45, 480, 554},	// QXmlStreamWriter::writeProcessingInstruction$
    {45, 481, 545},	// QXmlStreamWriter::writeProcessingInstruction$$
    {45, 482, 546},	// QXmlStreamWriter::writeStartDocument
    {45, 483, 547},	// QXmlStreamWriter::writeStartDocument$
    {45, 484, 548},	// QXmlStreamWriter::writeStartDocument$$
    {45, 486, 549},	// QXmlStreamWriter::writeStartElement$
    {45, 487, 550},	// QXmlStreamWriter::writeStartElement$$
    {45, 489, 538},	// QXmlStreamWriter::writeTextElement$$
    {45, 490, 539},	// QXmlStreamWriter::writeTextElement$$$
    {45, 522, 555},	// QXmlStreamWriter::~QXmlStreamWriter
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();

static bool initialized = false;
Smoke *qtxml_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qtxml_Smoke() {
    init_qtcore_Smoke();
    if (initialized) return;
    qtxml_Smoke = new Smoke(
        "qtxml",
        __smokeqtxml::classes, 45,
        __smokeqtxml::methods, 556,
        __smokeqtxml::methodMaps, 520,
        __smokeqtxml::methodNames, 522,
        __smokeqtxml::types, 212,
        __smokeqtxml::inheritanceList,
        __smokeqtxml::argumentList,
        __smokeqtxml::ambiguousMethodList,
        __smokeqtxml::cast );
    initialized = true;
}

void delete_qtxml_Smoke() { delete qtxml_Smoke; }

}
