#include <qtsvg_includes.h>

#include <smoke.h>
#include <qtsvg_smoke.h>

namespace __smokeqtsvg {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QActionEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QActionEvent*)xptr;
        case 1: return (void*)(QActionEvent*)xptr;
        default: return xptr;
      }
    case 2:   //QBool
      switch(to) {
        case 2: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 3:   //QByteArray
      switch(to) {
        case 3: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 4:   //QChildEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 4: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 5:   //QCloseEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QCloseEvent*)xptr;
        case 5: return (void*)(QCloseEvent*)xptr;
        default: return xptr;
      }
    case 6:   //QContextMenuEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QContextMenuEvent*)xptr;
        case 6: return (void*)(QContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 7:   //QDragEnterEvent
      switch(to) {
        case 9: return (void*)(QDragMoveEvent*)(QDragEnterEvent*)xptr;
        case 10: return (void*)(QDropEvent*)(QDragEnterEvent*)xptr;
        case 11: return (void*)(QEvent*)(QDragEnterEvent*)xptr;
        case 7: return (void*)(QDragEnterEvent*)xptr;
        default: return xptr;
      }
    case 8:   //QDragLeaveEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QDragLeaveEvent*)xptr;
        case 8: return (void*)(QDragLeaveEvent*)xptr;
        default: return xptr;
      }
    case 9:   //QDragMoveEvent
      switch(to) {
        case 10: return (void*)(QDropEvent*)(QDragMoveEvent*)xptr;
        case 11: return (void*)(QEvent*)(QDragMoveEvent*)xptr;
        case 9: return (void*)(QDragMoveEvent*)xptr;
        default: return xptr;
      }
    case 10:   //QDropEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QDropEvent*)xptr;
        case 10: return (void*)(QDropEvent*)xptr;
        default: return xptr;
      }
    case 11:   //QEvent
      switch(to) {
        case 11: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 12:   //QFocusEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QFocusEvent*)xptr;
        case 12: return (void*)(QFocusEvent*)xptr;
        default: return xptr;
      }
    case 13:   //QFont
      switch(to) {
        case 13: return (void*)(QFont*)xptr;
        default: return xptr;
      }
    case 15:   //QGraphicsItem
      switch(to) {
        case 15: return (void*)(QGraphicsItem*)xptr;
        case 22: return (void*)(QGraphicsSvgItem*)(QGraphicsItem*)xptr;
        default: return xptr;
      }
    case 16:   //QGraphicsObject
      switch(to) {
        case 31: return (void*)(QObject*)(QGraphicsObject*)xptr;
        case 15: return (void*)(QGraphicsItem*)(QGraphicsObject*)xptr;
        case 16: return (void*)(QGraphicsObject*)xptr;
        case 22: return (void*)(QGraphicsSvgItem*)(QGraphicsObject*)xptr;
        default: return xptr;
      }
    case 17:   //QGraphicsSceneContextMenuEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QGraphicsSceneContextMenuEvent*)xptr;
        case 17: return (void*)(QGraphicsSceneContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 18:   //QGraphicsSceneDragDropEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QGraphicsSceneDragDropEvent*)xptr;
        case 18: return (void*)(QGraphicsSceneDragDropEvent*)xptr;
        default: return xptr;
      }
    case 19:   //QGraphicsSceneHoverEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QGraphicsSceneHoverEvent*)xptr;
        case 19: return (void*)(QGraphicsSceneHoverEvent*)xptr;
        default: return xptr;
      }
    case 20:   //QGraphicsSceneMouseEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QGraphicsSceneMouseEvent*)xptr;
        case 20: return (void*)(QGraphicsSceneMouseEvent*)xptr;
        default: return xptr;
      }
    case 21:   //QGraphicsSceneWheelEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QGraphicsSceneWheelEvent*)xptr;
        case 21: return (void*)(QGraphicsSceneWheelEvent*)xptr;
        default: return xptr;
      }
    case 22:   //QGraphicsSvgItem
      switch(to) {
        case 16: return (void*)(QGraphicsObject*)(QGraphicsSvgItem*)xptr;
        case 31: return (void*)(QObject*)(QGraphicsSvgItem*)xptr;
        case 15: return (void*)(QGraphicsItem*)(QGraphicsSvgItem*)xptr;
        case 22: return (void*)(QGraphicsSvgItem*)xptr;
        default: return xptr;
      }
    case 23:   //QHideEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QHideEvent*)xptr;
        case 23: return (void*)(QHideEvent*)xptr;
        default: return xptr;
      }
    case 24:   //QIODevice
      switch(to) {
        case 31: return (void*)(QObject*)(QIODevice*)xptr;
        case 24: return (void*)(QIODevice*)xptr;
        default: return xptr;
      }
    case 25:   //QInputMethodEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QInputMethodEvent*)xptr;
        case 25: return (void*)(QInputMethodEvent*)xptr;
        default: return xptr;
      }
    case 26:   //QKeyEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QKeyEvent*)xptr;
        case 26: return (void*)(QKeyEvent*)xptr;
        default: return xptr;
      }
    case 27:   //QMatrix
      switch(to) {
        case 27: return (void*)(QMatrix*)xptr;
        default: return xptr;
      }
    case 28:   //QMetaObject
      switch(to) {
        case 28: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 29:   //QMouseEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QMouseEvent*)xptr;
        case 29: return (void*)(QMouseEvent*)xptr;
        default: return xptr;
      }
    case 30:   //QMoveEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QMoveEvent*)xptr;
        case 30: return (void*)(QMoveEvent*)xptr;
        default: return xptr;
      }
    case 31:   //QObject
      switch(to) {
        case 31: return (void*)(QObject*)xptr;
        case 22: return (void*)(QGraphicsSvgItem*)(QObject*)xptr;
        case 48: return (void*)(QSvgRenderer*)(QObject*)xptr;
        case 49: return (void*)(QSvgWidget*)(QObject*)xptr;
        default: return xptr;
      }
    case 32:   //QPaintDevice
      switch(to) {
        case 32: return (void*)(QPaintDevice*)xptr;
        case 47: return (void*)(QSvgGenerator*)(QPaintDevice*)xptr;
        case 49: return (void*)(QSvgWidget*)(QPaintDevice*)xptr;
        default: return xptr;
      }
    case 33:   //QPaintEngine
      switch(to) {
        case 33: return (void*)(QPaintEngine*)xptr;
        default: return xptr;
      }
    case 34:   //QPaintEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QPaintEvent*)xptr;
        case 34: return (void*)(QPaintEvent*)xptr;
        default: return xptr;
      }
    case 35:   //QPainter
      switch(to) {
        case 35: return (void*)(QPainter*)xptr;
        default: return xptr;
      }
    case 36:   //QPainterPath
      switch(to) {
        case 36: return (void*)(QPainterPath*)xptr;
        default: return xptr;
      }
    case 37:   //QPalette
      switch(to) {
        case 37: return (void*)(QPalette*)xptr;
        default: return xptr;
      }
    case 38:   //QPointF
      switch(to) {
        case 38: return (void*)(QPointF*)xptr;
        default: return xptr;
      }
    case 39:   //QRect
      switch(to) {
        case 39: return (void*)(QRect*)xptr;
        default: return xptr;
      }
    case 40:   //QRectF
      switch(to) {
        case 40: return (void*)(QRectF*)xptr;
        default: return xptr;
      }
    case 41:   //QRegExp
      switch(to) {
        case 41: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 42:   //QResizeEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QResizeEvent*)xptr;
        case 42: return (void*)(QResizeEvent*)xptr;
        default: return xptr;
      }
    case 43:   //QShowEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QShowEvent*)xptr;
        case 43: return (void*)(QShowEvent*)xptr;
        default: return xptr;
      }
    case 44:   //QSize
      switch(to) {
        case 44: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 45:   //QStyle
      switch(to) {
        case 31: return (void*)(QObject*)(QStyle*)xptr;
        case 45: return (void*)(QStyle*)xptr;
        default: return xptr;
      }
    case 46:   //QStyleOptionGraphicsItem
      switch(to) {
        case 46: return (void*)(QStyleOptionGraphicsItem*)xptr;
        default: return xptr;
      }
    case 47:   //QSvgGenerator
      switch(to) {
        case 32: return (void*)(QPaintDevice*)(QSvgGenerator*)xptr;
        case 47: return (void*)(QSvgGenerator*)xptr;
        default: return xptr;
      }
    case 48:   //QSvgRenderer
      switch(to) {
        case 31: return (void*)(QObject*)(QSvgRenderer*)xptr;
        case 48: return (void*)(QSvgRenderer*)xptr;
        default: return xptr;
      }
    case 49:   //QSvgWidget
      switch(to) {
        case 55: return (void*)(QWidget*)(QSvgWidget*)xptr;
        case 31: return (void*)(QObject*)(QSvgWidget*)xptr;
        case 32: return (void*)(QPaintDevice*)(QSvgWidget*)xptr;
        case 49: return (void*)(QSvgWidget*)xptr;
        default: return xptr;
      }
    case 50:   //QTabletEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QTabletEvent*)xptr;
        case 50: return (void*)(QTabletEvent*)xptr;
        default: return xptr;
      }
    case 51:   //QTextCodec
      switch(to) {
        case 51: return (void*)(QTextCodec*)xptr;
        default: return xptr;
      }
    case 52:   //QTimerEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 52: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 53:   //QVariant
      switch(to) {
        case 53: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 54:   //QWheelEvent
      switch(to) {
        case 11: return (void*)(QEvent*)(QWheelEvent*)xptr;
        case 54: return (void*)(QWheelEvent*)xptr;
        default: return xptr;
      }
    case 55:   //QWidget
      switch(to) {
        case 31: return (void*)(QObject*)(QWidget*)xptr;
        case 32: return (void*)(QPaintDevice*)(QWidget*)xptr;
        case 55: return (void*)(QWidget*)xptr;
        case 49: return (void*)(QSvgWidget*)(QWidget*)xptr;
        default: return xptr;
      }
    case 56:   //QXmlStreamReader
      switch(to) {
        case 56: return (void*)(QXmlStreamReader*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    16, 0,	// 1: QGraphicsObject
    32, 0,	// 3: QPaintDevice
    31, 0,	// 5: QObject
    55, 0,	// 7: QWidget
};

// These are the xenum functions for manipulating enum pointers

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_QGraphicsSvgItem(Smoke::Index, void*, Smoke::Stack);
void xcall_QSvgGenerator(Smoke::Index, void*, Smoke::Stack);
void xcall_QSvgRenderer(Smoke::Index, void*, Smoke::Stack);
void xcall_QSvgWidget(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QActionEvent", true, 0, 0, 0, 0, 0 },	//1
    { "QBool", true, 0, 0, 0, 0, 0 },	//2
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//3
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//4
    { "QCloseEvent", true, 0, 0, 0, 0, 0 },	//5
    { "QContextMenuEvent", true, 0, 0, 0, 0, 0 },	//6
    { "QDragEnterEvent", true, 0, 0, 0, 0, 0 },	//7
    { "QDragLeaveEvent", true, 0, 0, 0, 0, 0 },	//8
    { "QDragMoveEvent", true, 0, 0, 0, 0, 0 },	//9
    { "QDropEvent", true, 0, 0, 0, 0, 0 },	//10
    { "QEvent", true, 0, 0, 0, 0, 0 },	//11
    { "QFocusEvent", true, 0, 0, 0, 0, 0 },	//12
    { "QFont", true, 0, 0, 0, 0, 0 },	//13
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//14
    { "QGraphicsItem", true, 0, 0, 0, 0, 0 },	//15
    { "QGraphicsObject", true, 0, 0, 0, 0, 0 },	//16
    { "QGraphicsSceneContextMenuEvent", true, 0, 0, 0, 0, 0 },	//17
    { "QGraphicsSceneDragDropEvent", true, 0, 0, 0, 0, 0 },	//18
    { "QGraphicsSceneHoverEvent", true, 0, 0, 0, 0, 0 },	//19
    { "QGraphicsSceneMouseEvent", true, 0, 0, 0, 0, 0 },	//20
    { "QGraphicsSceneWheelEvent", true, 0, 0, 0, 0, 0 },	//21
    { "QGraphicsSvgItem", false, 1, xcall_QGraphicsSvgItem, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QGraphicsSvgItem) },	//22
    { "QHideEvent", true, 0, 0, 0, 0, 0 },	//23
    { "QIODevice", true, 0, 0, 0, 0, 0 },	//24
    { "QInputMethodEvent", true, 0, 0, 0, 0, 0 },	//25
    { "QKeyEvent", true, 0, 0, 0, 0, 0 },	//26
    { "QMatrix", true, 0, 0, 0, 0, 0 },	//27
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//28
    { "QMouseEvent", true, 0, 0, 0, 0, 0 },	//29
    { "QMoveEvent", true, 0, 0, 0, 0, 0 },	//30
    { "QObject", true, 0, 0, 0, 0, 0 },	//31
    { "QPaintDevice", true, 0, 0, 0, 0, 0 },	//32
    { "QPaintEngine", true, 0, 0, 0, 0, 0 },	//33
    { "QPaintEvent", true, 0, 0, 0, 0, 0 },	//34
    { "QPainter", true, 0, 0, 0, 0, 0 },	//35
    { "QPainterPath", true, 0, 0, 0, 0, 0 },	//36
    { "QPalette", true, 0, 0, 0, 0, 0 },	//37
    { "QPointF", true, 0, 0, 0, 0, 0 },	//38
    { "QRect", true, 0, 0, 0, 0, 0 },	//39
    { "QRectF", true, 0, 0, 0, 0, 0 },	//40
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//41
    { "QResizeEvent", true, 0, 0, 0, 0, 0 },	//42
    { "QShowEvent", true, 0, 0, 0, 0, 0 },	//43
    { "QSize", true, 0, 0, 0, 0, 0 },	//44
    { "QStyle", true, 0, 0, 0, 0, 0 },	//45
    { "QStyleOptionGraphicsItem", true, 0, 0, 0, 0, 0 },	//46
    { "QSvgGenerator", false, 3, xcall_QSvgGenerator, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QSvgGenerator) },	//47
    { "QSvgRenderer", false, 5, xcall_QSvgRenderer, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QSvgRenderer) },	//48
    { "QSvgWidget", false, 7, xcall_QSvgWidget, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QSvgWidget) },	//49
    { "QTabletEvent", true, 0, 0, 0, 0, 0 },	//50
    { "QTextCodec", true, 0, 0, 0, 0, 0 },	//51
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//52
    { "QVariant", true, 0, 0, 0, 0, 0 },	//53
    { "QWheelEvent", true, 0, 0, 0, 0, 0 },	//54
    { "QWidget", true, 0, 0, 0, 0, 0 },	//55
    { "QXmlStreamReader", true, 0, 0, 0, 0, 0 },	//56
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QAccessible2::BoundaryType", 0, Smoke::t_enum|Smoke::tf_stack },	//1
    { "QAccessible2::CoordinateType", 0, Smoke::t_enum|Smoke::tf_stack },	//2
    { "QAccessible2::InterfaceType", 0, Smoke::t_enum|Smoke::tf_stack },	//3
    { "QAccessible2::TableModelChangeType", 0, Smoke::t_enum|Smoke::tf_stack },	//4
    { "QActionEvent*", 1, Smoke::t_class|Smoke::tf_ptr },	//5
    { "QBool", 2, Smoke::t_class|Smoke::tf_stack },	//6
    { "QByteArray", 3, Smoke::t_class|Smoke::tf_stack },	//7
    { "QChildEvent*", 4, Smoke::t_class|Smoke::tf_ptr },	//8
    { "QCloseEvent*", 5, Smoke::t_class|Smoke::tf_ptr },	//9
    { "QContextMenuEvent*", 6, Smoke::t_class|Smoke::tf_ptr },	//10
    { "QDragEnterEvent*", 7, Smoke::t_class|Smoke::tf_ptr },	//11
    { "QDragLeaveEvent*", 8, Smoke::t_class|Smoke::tf_ptr },	//12
    { "QDragMoveEvent*", 9, Smoke::t_class|Smoke::tf_ptr },	//13
    { "QDrawBorderPixmap::DrawingHint", 0, Smoke::t_enum|Smoke::tf_stack },	//14
    { "QDropEvent*", 10, Smoke::t_class|Smoke::tf_ptr },	//15
    { "QEvent*", 11, Smoke::t_class|Smoke::tf_ptr },	//16
    { "QFocusEvent*", 12, Smoke::t_class|Smoke::tf_ptr },	//17
    { "QGraphicsItem*", 15, Smoke::t_class|Smoke::tf_ptr },	//18
    { "QGraphicsItem::Extension", 15, Smoke::t_enum|Smoke::tf_stack },	//19
    { "QGraphicsItem::GraphicsItemChange", 15, Smoke::t_enum|Smoke::tf_stack },	//20
    { "QGraphicsSceneContextMenuEvent*", 17, Smoke::t_class|Smoke::tf_ptr },	//21
    { "QGraphicsSceneDragDropEvent*", 18, Smoke::t_class|Smoke::tf_ptr },	//22
    { "QGraphicsSceneHoverEvent*", 19, Smoke::t_class|Smoke::tf_ptr },	//23
    { "QGraphicsSceneMouseEvent*", 20, Smoke::t_class|Smoke::tf_ptr },	//24
    { "QGraphicsSceneWheelEvent*", 21, Smoke::t_class|Smoke::tf_ptr },	//25
    { "QGraphicsSvgItem*", 22, Smoke::t_class|Smoke::tf_ptr },	//26
    { "QHideEvent*", 23, Smoke::t_class|Smoke::tf_ptr },	//27
    { "QIODevice*", 24, Smoke::t_class|Smoke::tf_ptr },	//28
    { "QInputMethodEvent*", 25, Smoke::t_class|Smoke::tf_ptr },	//29
    { "QKeyEvent*", 26, Smoke::t_class|Smoke::tf_ptr },	//30
    { "QMatrix", 27, Smoke::t_class|Smoke::tf_stack },	//31
    { "QMetaObject::Call", 28, Smoke::t_enum|Smoke::tf_stack },	//32
    { "QMouseEvent*", 29, Smoke::t_class|Smoke::tf_ptr },	//33
    { "QMoveEvent*", 30, Smoke::t_class|Smoke::tf_ptr },	//34
    { "QObject*", 31, Smoke::t_class|Smoke::tf_ptr },	//35
    { "QPaintDevice::PaintDeviceMetric", 32, Smoke::t_enum|Smoke::tf_stack },	//36
    { "QPaintEngine*", 33, Smoke::t_class|Smoke::tf_ptr },	//37
    { "QPaintEvent*", 34, Smoke::t_class|Smoke::tf_ptr },	//38
    { "QPainter*", 35, Smoke::t_class|Smoke::tf_ptr },	//39
    { "QPainterPath", 36, Smoke::t_class|Smoke::tf_stack },	//40
    { "QRect", 39, Smoke::t_class|Smoke::tf_stack },	//41
    { "QRectF", 40, Smoke::t_class|Smoke::tf_stack },	//42
    { "QRegExp&", 41, Smoke::t_class|Smoke::tf_ref },	//43
    { "QResizeEvent*", 42, Smoke::t_class|Smoke::tf_ptr },	//44
    { "QShowEvent*", 43, Smoke::t_class|Smoke::tf_ptr },	//45
    { "QSize", 44, Smoke::t_class|Smoke::tf_stack },	//46
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//47
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//48
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//49
    { "QStyle&", 45, Smoke::t_class|Smoke::tf_ref },	//50
    { "QSvgGenerator*", 47, Smoke::t_class|Smoke::tf_ptr },	//51
    { "QSvgRenderer*", 48, Smoke::t_class|Smoke::tf_ptr },	//52
    { "QSvgWidget*", 49, Smoke::t_class|Smoke::tf_ptr },	//53
    { "QTabletEvent*", 50, Smoke::t_class|Smoke::tf_ptr },	//54
    { "QTextCodec*", 51, Smoke::t_class|Smoke::tf_ptr },	//55
    { "QTimerEvent*", 52, Smoke::t_class|Smoke::tf_ptr },	//56
    { "QVariant", 53, Smoke::t_class|Smoke::tf_stack },	//57
    { "QWheelEvent*", 54, Smoke::t_class|Smoke::tf_ptr },	//58
    { "QWidget*", 55, Smoke::t_class|Smoke::tf_ptr },	//59
    { "QXmlStreamReader*", 56, Smoke::t_class|Smoke::tf_ptr },	//60
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//61
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//62
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//63
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//64
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//65
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//66
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//67
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//68
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//69
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//70
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//71
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//72
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//73
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//74
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//75
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//76
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//77
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//78
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//79
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//80
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//81
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//82
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//83
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//84
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//85
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//86
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//87
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//88
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//89
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//90
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//91
    { "Qt::HitTestAccuracy", 0, Smoke::t_enum|Smoke::tf_stack },	//92
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//93
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//94
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//95
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//96
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//97
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//98
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//99
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//100
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//101
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//102
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//103
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//104
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//105
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//106
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//107
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//108
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//109
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//110
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//111
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//112
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//113
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//114
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//115
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//116
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//117
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//118
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//119
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//120
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//121
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//122
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//123
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//124
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//125
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//126
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//127
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//128
    { "Qt::WhiteSpaceMode", 0, Smoke::t_enum|Smoke::tf_stack },	//129
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//130
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//131
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//132
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//133
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//134
    { "QtConcurrent::ReduceOption", 0, Smoke::t_enum|Smoke::tf_stack },	//135
    { "QtConcurrent::ThreadFunctionResult", 0, Smoke::t_enum|Smoke::tf_stack },	//136
    { "_XEvent*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//137
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//138
    { "const QByteArray&", 3, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//139
    { "const QFont&", 13, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//140
    { "const QGraphicsItem*", 15, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//141
    { "const QMetaObject&", 28, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//142
    { "const QMetaObject*", 28, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//143
    { "const QPainterPath&", 36, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//144
    { "const QPalette&", 37, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//145
    { "const QPointF&", 38, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//146
    { "const QRect&", 39, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//147
    { "const QRectF&", 40, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//148
    { "const QRegExp&", 41, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//149
    { "const QSize&", 44, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//150
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//151
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//152
    { "const QStyleOptionGraphicsItem*", 46, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//153
    { "const QVariant&", 53, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//154
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//155
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//156
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//157
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//158
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//159
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//160
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//161
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    157, 0,	//1  int
    146, 0,	//3  const QPointF&
    141, 99, 0,	//5  const QGraphicsItem*, Qt::ItemSelectionMode
    144, 99, 0,	//8  const QPainterPath&, Qt::ItemSelectionMode
    141, 0,	//11  const QGraphicsItem*
    18, 16, 0,	//13  QGraphicsItem*, QEvent*
    16, 0,	//16  QEvent*
    21, 0,	//18  QGraphicsSceneContextMenuEvent*
    22, 0,	//20  QGraphicsSceneDragDropEvent*
    17, 0,	//22  QFocusEvent*
    23, 0,	//24  QGraphicsSceneHoverEvent*
    30, 0,	//26  QKeyEvent*
    24, 0,	//28  QGraphicsSceneMouseEvent*
    25, 0,	//30  QGraphicsSceneWheelEvent*
    29, 0,	//32  QInputMethodEvent*
    96, 0,	//34  Qt::InputMethodQuery
    20, 154, 0,	//36  QGraphicsItem::GraphicsItemChange, const QVariant&
    19, 0,	//39  QGraphicsItem::Extension
    19, 154, 0,	//41  QGraphicsItem::Extension, const QVariant&
    154, 0,	//44  const QVariant&
    155, 0,	//46  const char*
    155, 155, 0,	//48  const char*, const char*
    155, 155, 157, 0,	//51  const char*, const char*, int
    32, 157, 160, 0,	//55  QMetaObject::Call, int, void**
    18, 0,	//59  QGraphicsItem*
    151, 18, 0,	//61  const QString&, QGraphicsItem*
    52, 0,	//64  QSvgRenderer*
    151, 0,	//66  const QString&
    138, 0,	//68  bool
    150, 0,	//70  const QSize&
    39, 153, 59, 0,	//72  QPainter*, const QStyleOptionGraphicsItem*, QWidget*
    39, 153, 0,	//76  QPainter*, const QStyleOptionGraphicsItem*
    35, 16, 0,	//79  QObject*, QEvent*
    56, 0,	//82  QTimerEvent*
    8, 0,	//84  QChildEvent*
    147, 0,	//86  const QRect&
    148, 0,	//88  const QRectF&
    28, 0,	//90  QIODevice*
    36, 0,	//92  QPaintDevice::PaintDeviceMetric
    35, 0,	//94  QObject*
    151, 35, 0,	//96  const QString&, QObject*
    139, 35, 0,	//99  const QByteArray&, QObject*
    60, 35, 0,	//102  QXmlStreamReader*, QObject*
    139, 0,	//105  const QByteArray&
    60, 0,	//107  QXmlStreamReader*
    39, 0,	//109  QPainter*
    39, 148, 0,	//111  QPainter*, const QRectF&
    39, 151, 148, 0,	//114  QPainter*, const QString&, const QRectF&
    39, 151, 0,	//118  QPainter*, const QString&
    59, 0,	//121  QWidget*
    151, 59, 0,	//123  const QString&, QWidget*
    38, 0,	//126  QPaintEvent*
    33, 0,	//128  QMouseEvent*
    58, 0,	//130  QWheelEvent*
    34, 0,	//132  QMoveEvent*
    44, 0,	//134  QResizeEvent*
    9, 0,	//136  QCloseEvent*
    10, 0,	//138  QContextMenuEvent*
    54, 0,	//140  QTabletEvent*
    5, 0,	//142  QActionEvent*
    11, 0,	//144  QDragEnterEvent*
    13, 0,	//146  QDragMoveEvent*
    12, 0,	//148  QDragLeaveEvent*
    15, 0,	//150  QDropEvent*
    45, 0,	//152  QShowEvent*
    27, 0,	//154  QHideEvent*
    137, 0,	//156  _XEvent*
    50, 0,	//158  QStyle&
    145, 0,	//160  const QPalette&
    140, 0,	//162  const QFont&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "DeviceCoordinateCache",	//1
    "DrawChildren",	//2
    "DrawWindowBackground",	//3
    "IgnoreMask",	//4
    "ItemAcceptsInputMethod",	//5
    "ItemChildAddedChange",	//6
    "ItemChildRemovedChange",	//7
    "ItemClipsChildrenToShape",	//8
    "ItemClipsToShape",	//9
    "ItemCoordinateCache",	//10
    "ItemCursorChange",	//11
    "ItemCursorHasChanged",	//12
    "ItemDoesntPropagateOpacityToChildren",	//13
    "ItemEnabledChange",	//14
    "ItemEnabledHasChanged",	//15
    "ItemFlagsChange",	//16
    "ItemFlagsHaveChanged",	//17
    "ItemHasNoContents",	//18
    "ItemIgnoresParentOpacity",	//19
    "ItemIgnoresTransformations",	//20
    "ItemIsFocusScope",	//21
    "ItemIsFocusable",	//22
    "ItemIsMovable",	//23
    "ItemIsPanel",	//24
    "ItemIsSelectable",	//25
    "ItemMatrixChange",	//26
    "ItemNegativeZStacksBehindParent",	//27
    "ItemOpacityChange",	//28
    "ItemOpacityHasChanged",	//29
    "ItemParentChange",	//30
    "ItemParentHasChanged",	//31
    "ItemPositionChange",	//32
    "ItemPositionHasChanged",	//33
    "ItemRotationChange",	//34
    "ItemRotationHasChanged",	//35
    "ItemScaleChange",	//36
    "ItemScaleHasChanged",	//37
    "ItemSceneChange",	//38
    "ItemSceneHasChanged",	//39
    "ItemScenePositionHasChanged",	//40
    "ItemSelectedChange",	//41
    "ItemSelectedHasChanged",	//42
    "ItemSendsGeometryChanges",	//43
    "ItemSendsScenePositionChanges",	//44
    "ItemStacksBehindParent",	//45
    "ItemStopsClickFocusPropagation",	//46
    "ItemStopsFocusHandling",	//47
    "ItemToolTipChange",	//48
    "ItemToolTipHasChanged",	//49
    "ItemTransformChange",	//50
    "ItemTransformHasChanged",	//51
    "ItemTransformOriginPointChange",	//52
    "ItemTransformOriginPointHasChanged",	//53
    "ItemUsesExtendedStyleOption",	//54
    "ItemVisibleChange",	//55
    "ItemVisibleHasChanged",	//56
    "ItemZValueChange",	//57
    "ItemZValueHasChanged",	//58
    "NoCache",	//59
    "NonModal",	//60
    "PanelModal",	//61
    "PdmDepth",	//62
    "PdmDpiX",	//63
    "PdmDpiY",	//64
    "PdmHeight",	//65
    "PdmHeightMM",	//66
    "PdmNumColors",	//67
    "PdmPhysicalDpiX",	//68
    "PdmPhysicalDpiY",	//69
    "PdmWidth",	//70
    "PdmWidthMM",	//71
    "QGraphicsSvgItem",	//72
    "QGraphicsSvgItem#",	//73
    "QGraphicsSvgItem$",	//74
    "QGraphicsSvgItem$#",	//75
    "QSvgGenerator",	//76
    "QSvgRenderer",	//77
    "QSvgRenderer#",	//78
    "QSvgRenderer##",	//79
    "QSvgRenderer$",	//80
    "QSvgRenderer$#",	//81
    "QSvgWidget",	//82
    "QSvgWidget#",	//83
    "QSvgWidget$",	//84
    "QSvgWidget$#",	//85
    "SceneModal",	//86
    "Type",	//87
    "UserExtension",	//88
    "UserType",	//89
    "actionEvent",	//90
    "advance",	//91
    "animated",	//92
    "animationDuration",	//93
    "boundingRect",	//94
    "boundsOnElement",	//95
    "boundsOnElement$",	//96
    "changeEvent",	//97
    "childEvent",	//98
    "closeEvent",	//99
    "collidesWithItem",	//100
    "collidesWithPath",	//101
    "connectNotify",	//102
    "contains",	//103
    "contextMenuEvent",	//104
    "currentFrame",	//105
    "customEvent",	//106
    "defaultSize",	//107
    "description",	//108
    "devType",	//109
    "disconnectNotify",	//110
    "dragEnterEvent",	//111
    "dragLeaveEvent",	//112
    "dragMoveEvent",	//113
    "dropEvent",	//114
    "elementExists",	//115
    "elementExists$",	//116
    "elementId",	//117
    "enabledChange",	//118
    "enterEvent",	//119
    "event",	//120
    "eventFilter",	//121
    "extension",	//122
    "fileName",	//123
    "focusInEvent",	//124
    "focusNextPrevChild",	//125
    "focusOutEvent",	//126
    "fontChange",	//127
    "framesPerSecond",	//128
    "heightForWidth",	//129
    "hideEvent",	//130
    "hoverEnterEvent",	//131
    "hoverLeaveEvent",	//132
    "hoverMoveEvent",	//133
    "inputMethodEvent",	//134
    "inputMethodQuery",	//135
    "isCachingEnabled",	//136
    "isObscuredBy",	//137
    "isValid",	//138
    "itemChange",	//139
    "keyPressEvent",	//140
    "keyReleaseEvent",	//141
    "languageChange",	//142
    "leaveEvent",	//143
    "load",	//144
    "load#",	//145
    "load$",	//146
    "matrixForElement",	//147
    "matrixForElement$",	//148
    "maximumCacheSize",	//149
    "metaObject",	//150
    "metric",	//151
    "metric$",	//152
    "minimumSizeHint",	//153
    "mouseDoubleClickEvent",	//154
    "mouseMoveEvent",	//155
    "mousePressEvent",	//156
    "mouseReleaseEvent",	//157
    "moveEvent",	//158
    "opaqueArea",	//159
    "outputDevice",	//160
    "paint",	//161
    "paint##",	//162
    "paint###",	//163
    "paintEngine",	//164
    "paintEvent",	//165
    "paintEvent#",	//166
    "paletteChange",	//167
    "qt_metacall",	//168
    "qt_metacall$$?",	//169
    "qt_metacast",	//170
    "qt_metacast$",	//171
    "render",	//172
    "render#",	//173
    "render##",	//174
    "render#$",	//175
    "render#$#",	//176
    "renderer",	//177
    "repaintNeeded",	//178
    "resizeEvent",	//179
    "resolution",	//180
    "sceneEvent",	//181
    "sceneEventFilter",	//182
    "setCachingEnabled",	//183
    "setCachingEnabled$",	//184
    "setCurrentFrame",	//185
    "setCurrentFrame$",	//186
    "setDescription",	//187
    "setDescription$",	//188
    "setElementId",	//189
    "setElementId$",	//190
    "setExtension",	//191
    "setFileName",	//192
    "setFileName$",	//193
    "setFramesPerSecond",	//194
    "setFramesPerSecond$",	//195
    "setMaximumCacheSize",	//196
    "setMaximumCacheSize#",	//197
    "setOutputDevice",	//198
    "setOutputDevice#",	//199
    "setResolution",	//200
    "setResolution$",	//201
    "setSharedRenderer",	//202
    "setSharedRenderer#",	//203
    "setSize",	//204
    "setSize#",	//205
    "setTitle",	//206
    "setTitle$",	//207
    "setViewBox",	//208
    "setViewBox#",	//209
    "setVisible",	//210
    "shape",	//211
    "showEvent",	//212
    "size",	//213
    "sizeHint",	//214
    "staticMetaObject",	//215
    "styleChange",	//216
    "supportsExtension",	//217
    "tabletEvent",	//218
    "timerEvent",	//219
    "title",	//220
    "tr",	//221
    "tr$",	//222
    "tr$$",	//223
    "tr$$$",	//224
    "trUtf8",	//225
    "trUtf8$",	//226
    "trUtf8$$",	//227
    "trUtf8$$$",	//228
    "type",	//229
    "viewBox",	//230
    "viewBoxF",	//231
    "wheelEvent",	//232
    "windowActivationChange",	//233
    "x11Event",	//234
    "~QGraphicsSvgItem",	//235
    "~QSvgGenerator",	//236
    "~QSvgRenderer",	//237
    "~QSvgWidget",	//238
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {15, 91, 1, 1, Smoke::mf_virtual, 0, 0},	//1 QGraphicsItem::advance(int)
    {15, 211, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 40, 0},	//2 QGraphicsItem::shape() const
    {15, 103, 3, 1, Smoke::mf_const|Smoke::mf_virtual, 138, 0},	//3 QGraphicsItem::contains(const QPointF&) const
    {15, 100, 5, 2, Smoke::mf_const|Smoke::mf_virtual, 138, 0},	//4 QGraphicsItem::collidesWithItem(const QGraphicsItem*, Qt::ItemSelectionMode) const
    {15, 101, 8, 2, Smoke::mf_const|Smoke::mf_virtual, 138, 0},	//5 QGraphicsItem::collidesWithPath(const QPainterPath&, Qt::ItemSelectionMode) const
    {15, 137, 11, 1, Smoke::mf_const|Smoke::mf_virtual, 138, 0},	//6 QGraphicsItem::isObscuredBy(const QGraphicsItem*) const
    {15, 159, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 40, 0},	//7 QGraphicsItem::opaqueArea() const
    {15, 182, 13, 2, Smoke::mf_protected|Smoke::mf_virtual, 138, 0},	//8 QGraphicsItem::sceneEventFilter(QGraphicsItem*, QEvent*)
    {15, 181, 16, 1, Smoke::mf_protected|Smoke::mf_virtual, 138, 0},	//9 QGraphicsItem::sceneEvent(QEvent*)
    {15, 104, 18, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//10 QGraphicsItem::contextMenuEvent(QGraphicsSceneContextMenuEvent*)
    {15, 111, 20, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//11 QGraphicsItem::dragEnterEvent(QGraphicsSceneDragDropEvent*)
    {15, 112, 20, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//12 QGraphicsItem::dragLeaveEvent(QGraphicsSceneDragDropEvent*)
    {15, 113, 20, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//13 QGraphicsItem::dragMoveEvent(QGraphicsSceneDragDropEvent*)
    {15, 114, 20, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//14 QGraphicsItem::dropEvent(QGraphicsSceneDragDropEvent*)
    {15, 124, 22, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//15 QGraphicsItem::focusInEvent(QFocusEvent*)
    {15, 126, 22, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//16 QGraphicsItem::focusOutEvent(QFocusEvent*)
    {15, 131, 24, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//17 QGraphicsItem::hoverEnterEvent(QGraphicsSceneHoverEvent*)
    {15, 133, 24, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//18 QGraphicsItem::hoverMoveEvent(QGraphicsSceneHoverEvent*)
    {15, 132, 24, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//19 QGraphicsItem::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
    {15, 140, 26, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//20 QGraphicsItem::keyPressEvent(QKeyEvent*)
    {15, 141, 26, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//21 QGraphicsItem::keyReleaseEvent(QKeyEvent*)
    {15, 156, 28, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//22 QGraphicsItem::mousePressEvent(QGraphicsSceneMouseEvent*)
    {15, 155, 28, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//23 QGraphicsItem::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {15, 157, 28, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//24 QGraphicsItem::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {15, 154, 28, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//25 QGraphicsItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
    {15, 232, 30, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//26 QGraphicsItem::wheelEvent(QGraphicsSceneWheelEvent*)
    {15, 134, 32, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//27 QGraphicsItem::inputMethodEvent(QInputMethodEvent*)
    {15, 135, 34, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 57, 0},	//28 QGraphicsItem::inputMethodQuery(Qt::InputMethodQuery) const
    {15, 139, 36, 2, Smoke::mf_protected|Smoke::mf_virtual, 57, 0},	//29 QGraphicsItem::itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)
    {15, 217, 39, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 138, 0},	//30 QGraphicsItem::supportsExtension(QGraphicsItem::Extension) const
    {15, 191, 41, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//31 QGraphicsItem::setExtension(QGraphicsItem::Extension, const QVariant&)
    {15, 122, 44, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 57, 0},	//32 QGraphicsItem::extension(const QVariant&) const
    {15, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 33},	//33 QGraphicsItem::ItemPositionChange (enum)
    {15, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 34},	//34 QGraphicsItem::ItemMatrixChange (enum)
    {15, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 35},	//35 QGraphicsItem::ItemVisibleChange (enum)
    {15, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 36},	//36 QGraphicsItem::ItemEnabledChange (enum)
    {15, 41, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 37},	//37 QGraphicsItem::ItemSelectedChange (enum)
    {15, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 38},	//38 QGraphicsItem::ItemParentChange (enum)
    {15, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 39},	//39 QGraphicsItem::ItemChildAddedChange (enum)
    {15, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 40},	//40 QGraphicsItem::ItemChildRemovedChange (enum)
    {15, 50, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 41},	//41 QGraphicsItem::ItemTransformChange (enum)
    {15, 33, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 42},	//42 QGraphicsItem::ItemPositionHasChanged (enum)
    {15, 51, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 43},	//43 QGraphicsItem::ItemTransformHasChanged (enum)
    {15, 38, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 44},	//44 QGraphicsItem::ItemSceneChange (enum)
    {15, 56, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 45},	//45 QGraphicsItem::ItemVisibleHasChanged (enum)
    {15, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 46},	//46 QGraphicsItem::ItemEnabledHasChanged (enum)
    {15, 42, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 47},	//47 QGraphicsItem::ItemSelectedHasChanged (enum)
    {15, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 48},	//48 QGraphicsItem::ItemParentHasChanged (enum)
    {15, 39, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 49},	//49 QGraphicsItem::ItemSceneHasChanged (enum)
    {15, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 50},	//50 QGraphicsItem::ItemCursorChange (enum)
    {15, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 51},	//51 QGraphicsItem::ItemCursorHasChanged (enum)
    {15, 48, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 52},	//52 QGraphicsItem::ItemToolTipChange (enum)
    {15, 49, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 53},	//53 QGraphicsItem::ItemToolTipHasChanged (enum)
    {15, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 54},	//54 QGraphicsItem::ItemFlagsChange (enum)
    {15, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 55},	//55 QGraphicsItem::ItemFlagsHaveChanged (enum)
    {15, 57, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 56},	//56 QGraphicsItem::ItemZValueChange (enum)
    {15, 58, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 57},	//57 QGraphicsItem::ItemZValueHasChanged (enum)
    {15, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 58},	//58 QGraphicsItem::ItemOpacityChange (enum)
    {15, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 59},	//59 QGraphicsItem::ItemOpacityHasChanged (enum)
    {15, 40, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 60},	//60 QGraphicsItem::ItemScenePositionHasChanged (enum)
    {15, 34, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 61},	//61 QGraphicsItem::ItemRotationChange (enum)
    {15, 35, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 62},	//62 QGraphicsItem::ItemRotationHasChanged (enum)
    {15, 36, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 63},	//63 QGraphicsItem::ItemScaleChange (enum)
    {15, 37, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 64},	//64 QGraphicsItem::ItemScaleHasChanged (enum)
    {15, 52, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 65},	//65 QGraphicsItem::ItemTransformOriginPointChange (enum)
    {15, 53, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 66},	//66 QGraphicsItem::ItemTransformOriginPointHasChanged (enum)
    {15, 87, 0, 0, Smoke::mf_static|Smoke::mf_enum, 158, 67},	//67 QGraphicsItem::Type (enum)
    {15, 89, 0, 0, Smoke::mf_static|Smoke::mf_enum, 158, 68},	//68 QGraphicsItem::UserType (enum)
    {15, 88, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 69},	//69 QGraphicsItem::UserExtension (enum)
    {22, 150, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 143, 1},	//70 QGraphicsSvgItem::metaObject() const
    {22, 170, 46, 1, Smoke::mf_virtual, 159, 2},	//71 QGraphicsSvgItem::qt_metacast(const char*)
    {22, 221, 48, 2, Smoke::mf_static, 47, 3},	//72 QGraphicsSvgItem::tr(const char*, const char*)
    {22, 225, 48, 2, Smoke::mf_static, 47, 4},	//73 QGraphicsSvgItem::trUtf8(const char*, const char*)
    {22, 221, 51, 3, Smoke::mf_static, 47, 5},	//74 QGraphicsSvgItem::tr(const char*, const char*, int)
    {22, 225, 51, 3, Smoke::mf_static, 47, 6},	//75 QGraphicsSvgItem::trUtf8(const char*, const char*, int)
    {22, 168, 55, 3, Smoke::mf_virtual, 157, 7},	//76 QGraphicsSvgItem::qt_metacall(QMetaObject::Call, int, void**)
    {22, 72, 59, 1, Smoke::mf_ctor, 26, 8},	//77 QGraphicsSvgItem::QGraphicsSvgItem(QGraphicsItem*)
    {22, 72, 61, 2, Smoke::mf_ctor, 26, 9},	//78 QGraphicsSvgItem::QGraphicsSvgItem(const QString&, QGraphicsItem*)
    {22, 202, 64, 1, 0, 0, 10},	//79 QGraphicsSvgItem::setSharedRenderer(QSvgRenderer*)
    {22, 177, 0, 0, Smoke::mf_const, 52, 11},	//80 QGraphicsSvgItem::renderer() const
    {22, 189, 66, 1, Smoke::mf_property, 0, 12},	//81 QGraphicsSvgItem::setElementId(const QString&)
    {22, 117, 0, 0, Smoke::mf_const|Smoke::mf_property, 47, 13},	//82 QGraphicsSvgItem::elementId() const
    {22, 183, 68, 1, 0, 0, 14},	//83 QGraphicsSvgItem::setCachingEnabled(bool)
    {22, 136, 0, 0, Smoke::mf_const, 138, 15},	//84 QGraphicsSvgItem::isCachingEnabled() const
    {22, 196, 70, 1, Smoke::mf_property, 0, 16},	//85 QGraphicsSvgItem::setMaximumCacheSize(const QSize&)
    {22, 149, 0, 0, Smoke::mf_const|Smoke::mf_property, 46, 17},	//86 QGraphicsSvgItem::maximumCacheSize() const
    {22, 94, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 42, 18},	//87 QGraphicsSvgItem::boundingRect() const
    {22, 161, 72, 3, Smoke::mf_virtual, 0, 19},	//88 QGraphicsSvgItem::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {22, 229, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 157, 20},	//89 QGraphicsSvgItem::type() const
    {22, 221, 46, 1, Smoke::mf_static, 47, 21},	//90 QGraphicsSvgItem::tr(const char*)
    {22, 225, 46, 1, Smoke::mf_static, 47, 22},	//91 QGraphicsSvgItem::trUtf8(const char*)
    {22, 72, 0, 0, Smoke::mf_ctor, 26, 23},	//92 QGraphicsSvgItem::QGraphicsSvgItem()
    {22, 72, 66, 1, Smoke::mf_ctor, 26, 24},	//93 QGraphicsSvgItem::QGraphicsSvgItem(const QString&)
    {22, 161, 76, 2, 0, 0, 25},	//94 QGraphicsSvgItem::paint(QPainter*, const QStyleOptionGraphicsItem*)
    {22, 215, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 142, 26},	//95 QGraphicsSvgItem::staticMetaObject() const
    {22, 87, 0, 0, Smoke::mf_static|Smoke::mf_enum, 158, 27},	//96 QGraphicsSvgItem::Type (enum)
    {22, 235, 0, 0, Smoke::mf_dtor, 0, 28 },	//97 QGraphicsSvgItem::~QGraphicsSvgItem()
    {31, 120, 16, 1, Smoke::mf_virtual, 138, 0},	//98 QObject::event(QEvent*)
    {31, 121, 79, 2, Smoke::mf_virtual, 138, 0},	//99 QObject::eventFilter(QObject*, QEvent*)
    {31, 219, 82, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//100 QObject::timerEvent(QTimerEvent*)
    {31, 98, 84, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//101 QObject::childEvent(QChildEvent*)
    {31, 106, 16, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//102 QObject::customEvent(QEvent*)
    {31, 102, 46, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//103 QObject::connectNotify(const char*)
    {31, 110, 46, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//104 QObject::disconnectNotify(const char*)
    {32, 109, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 157, 0},	//105 QPaintDevice::devType() const
    {32, 70, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 2},	//106 QPaintDevice::PdmWidth (enum)
    {32, 65, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 3},	//107 QPaintDevice::PdmHeight (enum)
    {32, 71, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 4},	//108 QPaintDevice::PdmWidthMM (enum)
    {32, 66, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 5},	//109 QPaintDevice::PdmHeightMM (enum)
    {32, 67, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 6},	//110 QPaintDevice::PdmNumColors (enum)
    {32, 62, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 7},	//111 QPaintDevice::PdmDepth (enum)
    {32, 63, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 8},	//112 QPaintDevice::PdmDpiX (enum)
    {32, 64, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 9},	//113 QPaintDevice::PdmDpiY (enum)
    {32, 68, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 10},	//114 QPaintDevice::PdmPhysicalDpiX (enum)
    {32, 69, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 11},	//115 QPaintDevice::PdmPhysicalDpiY (enum)
    {47, 76, 0, 0, Smoke::mf_ctor, 51, 1},	//116 QSvgGenerator::QSvgGenerator()
    {47, 220, 0, 0, Smoke::mf_const|Smoke::mf_property, 47, 2},	//117 QSvgGenerator::title() const
    {47, 206, 66, 1, Smoke::mf_property, 0, 3},	//118 QSvgGenerator::setTitle(const QString&)
    {47, 108, 0, 0, Smoke::mf_const|Smoke::mf_property, 47, 4},	//119 QSvgGenerator::description() const
    {47, 187, 66, 1, Smoke::mf_property, 0, 5},	//120 QSvgGenerator::setDescription(const QString&)
    {47, 213, 0, 0, Smoke::mf_const|Smoke::mf_property, 46, 6},	//121 QSvgGenerator::size() const
    {47, 204, 70, 1, Smoke::mf_property, 0, 7},	//122 QSvgGenerator::setSize(const QSize&)
    {47, 230, 0, 0, Smoke::mf_const, 41, 8},	//123 QSvgGenerator::viewBox() const
    {47, 231, 0, 0, Smoke::mf_const|Smoke::mf_property, 42, 9},	//124 QSvgGenerator::viewBoxF() const
    {47, 208, 86, 1, 0, 0, 10},	//125 QSvgGenerator::setViewBox(const QRect&)
    {47, 208, 88, 1, Smoke::mf_property, 0, 11},	//126 QSvgGenerator::setViewBox(const QRectF&)
    {47, 123, 0, 0, Smoke::mf_const|Smoke::mf_property, 47, 12},	//127 QSvgGenerator::fileName() const
    {47, 192, 66, 1, Smoke::mf_property, 0, 13},	//128 QSvgGenerator::setFileName(const QString&)
    {47, 160, 0, 0, Smoke::mf_const|Smoke::mf_property, 28, 14},	//129 QSvgGenerator::outputDevice() const
    {47, 198, 90, 1, Smoke::mf_property, 0, 15},	//130 QSvgGenerator::setOutputDevice(QIODevice*)
    {47, 200, 1, 1, Smoke::mf_property, 0, 16},	//131 QSvgGenerator::setResolution(int)
    {47, 180, 0, 0, Smoke::mf_const|Smoke::mf_property, 157, 17},	//132 QSvgGenerator::resolution() const
    {47, 164, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 37, 18},	//133 QSvgGenerator::paintEngine() const
    {47, 151, 92, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 157, 19},	//134 QSvgGenerator::metric(QPaintDevice::PaintDeviceMetric) const
    {47, 236, 0, 0, Smoke::mf_dtor, 0, 20 },	//135 QSvgGenerator::~QSvgGenerator()
    {48, 150, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 143, 1},	//136 QSvgRenderer::metaObject() const
    {48, 170, 46, 1, Smoke::mf_virtual, 159, 2},	//137 QSvgRenderer::qt_metacast(const char*)
    {48, 221, 48, 2, Smoke::mf_static, 47, 3},	//138 QSvgRenderer::tr(const char*, const char*)
    {48, 225, 48, 2, Smoke::mf_static, 47, 4},	//139 QSvgRenderer::trUtf8(const char*, const char*)
    {48, 221, 51, 3, Smoke::mf_static, 47, 5},	//140 QSvgRenderer::tr(const char*, const char*, int)
    {48, 225, 51, 3, Smoke::mf_static, 47, 6},	//141 QSvgRenderer::trUtf8(const char*, const char*, int)
    {48, 168, 55, 3, Smoke::mf_virtual, 157, 7},	//142 QSvgRenderer::qt_metacall(QMetaObject::Call, int, void**)
    {48, 77, 94, 1, Smoke::mf_ctor, 52, 8},	//143 QSvgRenderer::QSvgRenderer(QObject*)
    {48, 77, 96, 2, Smoke::mf_ctor, 52, 9},	//144 QSvgRenderer::QSvgRenderer(const QString&, QObject*)
    {48, 77, 99, 2, Smoke::mf_ctor, 52, 10},	//145 QSvgRenderer::QSvgRenderer(const QByteArray&, QObject*)
    {48, 77, 102, 2, Smoke::mf_ctor, 52, 11},	//146 QSvgRenderer::QSvgRenderer(QXmlStreamReader*, QObject*)
    {48, 138, 0, 0, Smoke::mf_const, 138, 12},	//147 QSvgRenderer::isValid() const
    {48, 107, 0, 0, Smoke::mf_const, 46, 13},	//148 QSvgRenderer::defaultSize() const
    {48, 230, 0, 0, Smoke::mf_const, 41, 14},	//149 QSvgRenderer::viewBox() const
    {48, 231, 0, 0, Smoke::mf_const|Smoke::mf_property, 42, 15},	//150 QSvgRenderer::viewBoxF() const
    {48, 208, 86, 1, 0, 0, 16},	//151 QSvgRenderer::setViewBox(const QRect&)
    {48, 208, 88, 1, Smoke::mf_property, 0, 17},	//152 QSvgRenderer::setViewBox(const QRectF&)
    {48, 92, 0, 0, Smoke::mf_const, 138, 18},	//153 QSvgRenderer::animated() const
    {48, 128, 0, 0, Smoke::mf_const|Smoke::mf_property, 157, 19},	//154 QSvgRenderer::framesPerSecond() const
    {48, 194, 1, 1, Smoke::mf_property, 0, 20},	//155 QSvgRenderer::setFramesPerSecond(int)
    {48, 105, 0, 0, Smoke::mf_const|Smoke::mf_property, 157, 21},	//156 QSvgRenderer::currentFrame() const
    {48, 185, 1, 1, Smoke::mf_property, 0, 22},	//157 QSvgRenderer::setCurrentFrame(int)
    {48, 93, 0, 0, Smoke::mf_const, 157, 23},	//158 QSvgRenderer::animationDuration() const
    {48, 95, 66, 1, Smoke::mf_const, 42, 24},	//159 QSvgRenderer::boundsOnElement(const QString&) const
    {48, 115, 66, 1, Smoke::mf_const, 138, 25},	//160 QSvgRenderer::elementExists(const QString&) const
    {48, 147, 66, 1, Smoke::mf_const, 31, 26},	//161 QSvgRenderer::matrixForElement(const QString&) const
    {48, 144, 66, 1, Smoke::mf_slot, 138, 27},	//162 QSvgRenderer::load(const QString&)
    {48, 144, 105, 1, Smoke::mf_slot, 138, 28},	//163 QSvgRenderer::load(const QByteArray&)
    {48, 144, 107, 1, Smoke::mf_slot, 138, 29},	//164 QSvgRenderer::load(QXmlStreamReader*)
    {48, 172, 109, 1, Smoke::mf_slot, 0, 30},	//165 QSvgRenderer::render(QPainter*)
    {48, 172, 111, 2, Smoke::mf_slot, 0, 31},	//166 QSvgRenderer::render(QPainter*, const QRectF&)
    {48, 172, 114, 3, Smoke::mf_slot, 0, 32},	//167 QSvgRenderer::render(QPainter*, const QString&, const QRectF&)
    {48, 178, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 33},	//168 QSvgRenderer::repaintNeeded()
    {48, 221, 46, 1, Smoke::mf_static, 47, 34},	//169 QSvgRenderer::tr(const char*)
    {48, 225, 46, 1, Smoke::mf_static, 47, 35},	//170 QSvgRenderer::trUtf8(const char*)
    {48, 77, 0, 0, Smoke::mf_ctor, 52, 36},	//171 QSvgRenderer::QSvgRenderer()
    {48, 77, 66, 1, Smoke::mf_ctor, 52, 37},	//172 QSvgRenderer::QSvgRenderer(const QString&)
    {48, 77, 105, 1, Smoke::mf_ctor, 52, 38},	//173 QSvgRenderer::QSvgRenderer(const QByteArray&)
    {48, 77, 107, 1, Smoke::mf_ctor, 52, 39},	//174 QSvgRenderer::QSvgRenderer(QXmlStreamReader*)
    {48, 172, 118, 2, Smoke::mf_slot, 0, 40},	//175 QSvgRenderer::render(QPainter*, const QString&)
    {48, 215, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 142, 41},	//176 QSvgRenderer::staticMetaObject() const
    {48, 237, 0, 0, Smoke::mf_dtor, 0, 42 },	//177 QSvgRenderer::~QSvgRenderer()
    {49, 150, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 143, 1},	//178 QSvgWidget::metaObject() const
    {49, 170, 46, 1, Smoke::mf_virtual, 159, 2},	//179 QSvgWidget::qt_metacast(const char*)
    {49, 221, 48, 2, Smoke::mf_static, 47, 3},	//180 QSvgWidget::tr(const char*, const char*)
    {49, 225, 48, 2, Smoke::mf_static, 47, 4},	//181 QSvgWidget::trUtf8(const char*, const char*)
    {49, 221, 51, 3, Smoke::mf_static, 47, 5},	//182 QSvgWidget::tr(const char*, const char*, int)
    {49, 225, 51, 3, Smoke::mf_static, 47, 6},	//183 QSvgWidget::trUtf8(const char*, const char*, int)
    {49, 168, 55, 3, Smoke::mf_virtual, 157, 7},	//184 QSvgWidget::qt_metacall(QMetaObject::Call, int, void**)
    {49, 82, 121, 1, Smoke::mf_ctor, 53, 8},	//185 QSvgWidget::QSvgWidget(QWidget*)
    {49, 82, 123, 2, Smoke::mf_ctor, 53, 9},	//186 QSvgWidget::QSvgWidget(const QString&, QWidget*)
    {49, 177, 0, 0, Smoke::mf_const, 52, 10},	//187 QSvgWidget::renderer() const
    {49, 214, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 46, 11},	//188 QSvgWidget::sizeHint() const
    {49, 144, 66, 1, Smoke::mf_slot, 0, 12},	//189 QSvgWidget::load(const QString&)
    {49, 144, 105, 1, Smoke::mf_slot, 0, 13},	//190 QSvgWidget::load(const QByteArray&)
    {49, 165, 126, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 14},	//191 QSvgWidget::paintEvent(QPaintEvent*)
    {49, 221, 46, 1, Smoke::mf_static, 47, 15},	//192 QSvgWidget::tr(const char*)
    {49, 225, 46, 1, Smoke::mf_static, 47, 16},	//193 QSvgWidget::trUtf8(const char*)
    {49, 82, 0, 0, Smoke::mf_ctor, 53, 17},	//194 QSvgWidget::QSvgWidget()
    {49, 82, 66, 1, Smoke::mf_ctor, 53, 18},	//195 QSvgWidget::QSvgWidget(const QString&)
    {49, 215, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 142, 19},	//196 QSvgWidget::staticMetaObject() const
    {49, 238, 0, 0, Smoke::mf_dtor, 0, 20 },	//197 QSvgWidget::~QSvgWidget()
    {55, 109, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 157, 0},	//198 QWidget::devType() const
    {55, 210, 68, 1, Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//199 QWidget::setVisible(bool)
    {55, 153, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 46, 0},	//200 QWidget::minimumSizeHint() const
    {55, 129, 1, 1, Smoke::mf_const|Smoke::mf_virtual, 157, 0},	//201 QWidget::heightForWidth(int) const
    {55, 164, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 37, 0},	//202 QWidget::paintEngine() const
    {55, 120, 16, 1, Smoke::mf_protected|Smoke::mf_virtual, 138, 0},	//203 QWidget::event(QEvent*)
    {55, 156, 128, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//204 QWidget::mousePressEvent(QMouseEvent*)
    {55, 157, 128, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//205 QWidget::mouseReleaseEvent(QMouseEvent*)
    {55, 154, 128, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//206 QWidget::mouseDoubleClickEvent(QMouseEvent*)
    {55, 155, 128, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//207 QWidget::mouseMoveEvent(QMouseEvent*)
    {55, 232, 130, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//208 QWidget::wheelEvent(QWheelEvent*)
    {55, 140, 26, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//209 QWidget::keyPressEvent(QKeyEvent*)
    {55, 141, 26, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//210 QWidget::keyReleaseEvent(QKeyEvent*)
    {55, 124, 22, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//211 QWidget::focusInEvent(QFocusEvent*)
    {55, 126, 22, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//212 QWidget::focusOutEvent(QFocusEvent*)
    {55, 119, 16, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//213 QWidget::enterEvent(QEvent*)
    {55, 143, 16, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//214 QWidget::leaveEvent(QEvent*)
    {55, 158, 132, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//215 QWidget::moveEvent(QMoveEvent*)
    {55, 179, 134, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//216 QWidget::resizeEvent(QResizeEvent*)
    {55, 99, 136, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//217 QWidget::closeEvent(QCloseEvent*)
    {55, 104, 138, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//218 QWidget::contextMenuEvent(QContextMenuEvent*)
    {55, 218, 140, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//219 QWidget::tabletEvent(QTabletEvent*)
    {55, 90, 142, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//220 QWidget::actionEvent(QActionEvent*)
    {55, 111, 144, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//221 QWidget::dragEnterEvent(QDragEnterEvent*)
    {55, 113, 146, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//222 QWidget::dragMoveEvent(QDragMoveEvent*)
    {55, 112, 148, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//223 QWidget::dragLeaveEvent(QDragLeaveEvent*)
    {55, 114, 150, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//224 QWidget::dropEvent(QDropEvent*)
    {55, 212, 152, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//225 QWidget::showEvent(QShowEvent*)
    {55, 130, 154, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//226 QWidget::hideEvent(QHideEvent*)
    {55, 234, 156, 1, Smoke::mf_protected|Smoke::mf_virtual, 138, 0},	//227 QWidget::x11Event(_XEvent*)
    {55, 97, 16, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//228 QWidget::changeEvent(QEvent*)
    {55, 151, 92, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 157, 0},	//229 QWidget::metric(QPaintDevice::PaintDeviceMetric) const
    {55, 134, 32, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//230 QWidget::inputMethodEvent(QInputMethodEvent*)
    {55, 135, 34, 1, Smoke::mf_const|Smoke::mf_virtual, 57, 0},	//231 QWidget::inputMethodQuery(Qt::InputMethodQuery) const
    {55, 125, 68, 1, Smoke::mf_protected|Smoke::mf_virtual, 138, 0},	//232 QWidget::focusNextPrevChild(bool)
    {55, 216, 158, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//233 QWidget::styleChange(QStyle&)
    {55, 118, 68, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//234 QWidget::enabledChange(bool)
    {55, 167, 160, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//235 QWidget::paletteChange(const QPalette&)
    {55, 127, 162, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//236 QWidget::fontChange(const QFont&)
    {55, 233, 68, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//237 QWidget::windowActivationChange(bool)
    {55, 142, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//238 QWidget::languageChange()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    125,  // QSvgGenerator::setViewBox(const QRect&)
    126,  // QSvgGenerator::setViewBox(const QRectF&)
    0,
    143,  // QSvgRenderer::QSvgRenderer(QObject*)
    173,  // QSvgRenderer::QSvgRenderer(const QByteArray&)
    174,  // QSvgRenderer::QSvgRenderer(QXmlStreamReader*)
    0,
    145,  // QSvgRenderer::QSvgRenderer(const QByteArray&, QObject*)
    146,  // QSvgRenderer::QSvgRenderer(QXmlStreamReader*, QObject*)
    0,
    163,  // QSvgRenderer::load(const QByteArray&)
    164,  // QSvgRenderer::load(QXmlStreamReader*)
    0,
    151,  // QSvgRenderer::setViewBox(const QRect&)
    152,  // QSvgRenderer::setViewBox(const QRectF&)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {22, 72, 92},	// QGraphicsSvgItem::QGraphicsSvgItem
    {22, 73, 77},	// QGraphicsSvgItem::QGraphicsSvgItem#
    {22, 74, 93},	// QGraphicsSvgItem::QGraphicsSvgItem$
    {22, 75, 78},	// QGraphicsSvgItem::QGraphicsSvgItem$#
    {22, 87, 96},	// QGraphicsSvgItem::Type
    {22, 94, 87},	// QGraphicsSvgItem::boundingRect
    {22, 117, 82},	// QGraphicsSvgItem::elementId
    {22, 136, 84},	// QGraphicsSvgItem::isCachingEnabled
    {22, 149, 86},	// QGraphicsSvgItem::maximumCacheSize
    {22, 150, 70},	// QGraphicsSvgItem::metaObject
    {22, 162, 94},	// QGraphicsSvgItem::paint##
    {22, 163, 88},	// QGraphicsSvgItem::paint###
    {22, 169, 76},	// QGraphicsSvgItem::qt_metacall$$?
    {22, 171, 71},	// QGraphicsSvgItem::qt_metacast$
    {22, 177, 80},	// QGraphicsSvgItem::renderer
    {22, 184, 83},	// QGraphicsSvgItem::setCachingEnabled$
    {22, 190, 81},	// QGraphicsSvgItem::setElementId$
    {22, 197, 85},	// QGraphicsSvgItem::setMaximumCacheSize#
    {22, 203, 79},	// QGraphicsSvgItem::setSharedRenderer#
    {22, 215, 95},	// QGraphicsSvgItem::staticMetaObject
    {22, 222, 90},	// QGraphicsSvgItem::tr$
    {22, 223, 72},	// QGraphicsSvgItem::tr$$
    {22, 224, 74},	// QGraphicsSvgItem::tr$$$
    {22, 226, 91},	// QGraphicsSvgItem::trUtf8$
    {22, 227, 73},	// QGraphicsSvgItem::trUtf8$$
    {22, 228, 75},	// QGraphicsSvgItem::trUtf8$$$
    {22, 229, 89},	// QGraphicsSvgItem::type
    {22, 235, 97},	// QGraphicsSvgItem::~QGraphicsSvgItem
    {47, 76, 116},	// QSvgGenerator::QSvgGenerator
    {47, 108, 119},	// QSvgGenerator::description
    {47, 123, 127},	// QSvgGenerator::fileName
    {47, 152, 134},	// QSvgGenerator::metric$
    {47, 160, 129},	// QSvgGenerator::outputDevice
    {47, 164, 133},	// QSvgGenerator::paintEngine
    {47, 180, 132},	// QSvgGenerator::resolution
    {47, 188, 120},	// QSvgGenerator::setDescription$
    {47, 193, 128},	// QSvgGenerator::setFileName$
    {47, 199, 130},	// QSvgGenerator::setOutputDevice#
    {47, 201, 131},	// QSvgGenerator::setResolution$
    {47, 205, 122},	// QSvgGenerator::setSize#
    {47, 207, 118},	// QSvgGenerator::setTitle$
    {47, 209, -1},	// QSvgGenerator::setViewBox#
    {47, 213, 121},	// QSvgGenerator::size
    {47, 220, 117},	// QSvgGenerator::title
    {47, 230, 123},	// QSvgGenerator::viewBox
    {47, 231, 124},	// QSvgGenerator::viewBoxF
    {47, 236, 135},	// QSvgGenerator::~QSvgGenerator
    {48, 77, 171},	// QSvgRenderer::QSvgRenderer
    {48, 78, -4},	// QSvgRenderer::QSvgRenderer#
    {48, 79, -8},	// QSvgRenderer::QSvgRenderer##
    {48, 80, 172},	// QSvgRenderer::QSvgRenderer$
    {48, 81, 144},	// QSvgRenderer::QSvgRenderer$#
    {48, 92, 153},	// QSvgRenderer::animated
    {48, 93, 158},	// QSvgRenderer::animationDuration
    {48, 96, 159},	// QSvgRenderer::boundsOnElement$
    {48, 105, 156},	// QSvgRenderer::currentFrame
    {48, 107, 148},	// QSvgRenderer::defaultSize
    {48, 116, 160},	// QSvgRenderer::elementExists$
    {48, 128, 154},	// QSvgRenderer::framesPerSecond
    {48, 138, 147},	// QSvgRenderer::isValid
    {48, 145, -11},	// QSvgRenderer::load#
    {48, 146, 162},	// QSvgRenderer::load$
    {48, 148, 161},	// QSvgRenderer::matrixForElement$
    {48, 150, 136},	// QSvgRenderer::metaObject
    {48, 169, 142},	// QSvgRenderer::qt_metacall$$?
    {48, 171, 137},	// QSvgRenderer::qt_metacast$
    {48, 173, 165},	// QSvgRenderer::render#
    {48, 174, 166},	// QSvgRenderer::render##
    {48, 175, 175},	// QSvgRenderer::render#$
    {48, 176, 167},	// QSvgRenderer::render#$#
    {48, 178, 168},	// QSvgRenderer::repaintNeeded
    {48, 186, 157},	// QSvgRenderer::setCurrentFrame$
    {48, 195, 155},	// QSvgRenderer::setFramesPerSecond$
    {48, 209, -14},	// QSvgRenderer::setViewBox#
    {48, 215, 176},	// QSvgRenderer::staticMetaObject
    {48, 222, 169},	// QSvgRenderer::tr$
    {48, 223, 138},	// QSvgRenderer::tr$$
    {48, 224, 140},	// QSvgRenderer::tr$$$
    {48, 226, 170},	// QSvgRenderer::trUtf8$
    {48, 227, 139},	// QSvgRenderer::trUtf8$$
    {48, 228, 141},	// QSvgRenderer::trUtf8$$$
    {48, 230, 149},	// QSvgRenderer::viewBox
    {48, 231, 150},	// QSvgRenderer::viewBoxF
    {48, 237, 177},	// QSvgRenderer::~QSvgRenderer
    {49, 82, 194},	// QSvgWidget::QSvgWidget
    {49, 83, 185},	// QSvgWidget::QSvgWidget#
    {49, 84, 195},	// QSvgWidget::QSvgWidget$
    {49, 85, 186},	// QSvgWidget::QSvgWidget$#
    {49, 145, 190},	// QSvgWidget::load#
    {49, 146, 189},	// QSvgWidget::load$
    {49, 150, 178},	// QSvgWidget::metaObject
    {49, 166, 191},	// QSvgWidget::paintEvent#
    {49, 169, 184},	// QSvgWidget::qt_metacall$$?
    {49, 171, 179},	// QSvgWidget::qt_metacast$
    {49, 177, 187},	// QSvgWidget::renderer
    {49, 214, 188},	// QSvgWidget::sizeHint
    {49, 215, 196},	// QSvgWidget::staticMetaObject
    {49, 222, 192},	// QSvgWidget::tr$
    {49, 223, 180},	// QSvgWidget::tr$$
    {49, 224, 182},	// QSvgWidget::tr$$$
    {49, 226, 193},	// QSvgWidget::trUtf8$
    {49, 227, 181},	// QSvgWidget::trUtf8$$
    {49, 228, 183},	// QSvgWidget::trUtf8$$$
    {49, 238, 197},	// QSvgWidget::~QSvgWidget
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();
SMOKE_IMPORT void init_qtgui_Smoke();

static bool initialized = false;
Smoke *qtsvg_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qtsvg_Smoke() {
    init_qtcore_Smoke();
    init_qtgui_Smoke();
    if (initialized) return;
    qtsvg_Smoke = new Smoke(
        "qtsvg",
        __smokeqtsvg::classes, 56,
        __smokeqtsvg::methods, 239,
        __smokeqtsvg::methodMaps, 105,
        __smokeqtsvg::methodNames, 238,
        __smokeqtsvg::types, 161,
        __smokeqtsvg::inheritanceList,
        __smokeqtsvg::argumentList,
        __smokeqtsvg::ambiguousMethodList,
        __smokeqtsvg::cast );
    initialized = true;
}

void delete_qtsvg_Smoke() { delete qtsvg_Smoke; }

}
