#include <qtsql_includes.h>

#include <smoke.h>
#include <qtsql_smoke.h>

namespace __smokeqtsql {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QAbstractItemModel
      switch(to) {
        case 15: return (void*)(QObject*)(QAbstractItemModel*)xptr;
        case 1: return (void*)(QAbstractItemModel*)xptr;
        case 35: return (void*)(QSqlRelationalTableModel*)(QAbstractItemModel*)xptr;
        case 37: return (void*)(QSqlTableModel*)(QAbstractItemModel*)xptr;
        case 31: return (void*)(QSqlQueryModel*)(QAbstractItemModel*)xptr;
        default: return xptr;
      }
    case 2:   //QAbstractTableModel
      switch(to) {
        case 1: return (void*)(QAbstractItemModel*)(QAbstractTableModel*)xptr;
        case 15: return (void*)(QObject*)(QAbstractTableModel*)xptr;
        case 2: return (void*)(QAbstractTableModel*)xptr;
        case 35: return (void*)(QSqlRelationalTableModel*)(QAbstractTableModel*)xptr;
        case 37: return (void*)(QSqlTableModel*)(QAbstractTableModel*)xptr;
        case 31: return (void*)(QSqlQueryModel*)(QAbstractTableModel*)xptr;
        default: return xptr;
      }
    case 3:   //QBool
      switch(to) {
        case 3: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 4:   //QByteArray
      switch(to) {
        case 4: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 5:   //QChildEvent
      switch(to) {
        case 7: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 5: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 6:   //QDebug
      switch(to) {
        case 6: return (void*)(QDebug*)xptr;
        default: return xptr;
      }
    case 7:   //QEvent
      switch(to) {
        case 7: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 8:   //QFactoryInterface
      switch(to) {
        case 8: return (void*)(QFactoryInterface*)xptr;
        case 25: return (void*)(QSqlDriverFactoryInterface*)(QFactoryInterface*)xptr;
        case 26: return (void*)(QSqlDriverPlugin*)(QFactoryInterface*)xptr;
        default: return xptr;
      }
    case 10:   //QIncompatibleFlag
      switch(to) {
        case 10: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 11:   //QItemDelegate
      switch(to) {
        case 15: return (void*)(QObject*)(QItemDelegate*)xptr;
        case 11: return (void*)(QItemDelegate*)xptr;
        case 34: return (void*)(QSqlRelationalDelegate*)(QItemDelegate*)xptr;
        default: return xptr;
      }
    case 12:   //QMetaObject
      switch(to) {
        case 12: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 13:   //QMimeData
      switch(to) {
        case 15: return (void*)(QObject*)(QMimeData*)xptr;
        case 13: return (void*)(QMimeData*)xptr;
        default: return xptr;
      }
    case 14:   //QModelIndex
      switch(to) {
        case 14: return (void*)(QModelIndex*)xptr;
        default: return xptr;
      }
    case 15:   //QObject
      switch(to) {
        case 15: return (void*)(QObject*)xptr;
        case 34: return (void*)(QSqlRelationalDelegate*)(QObject*)xptr;
        case 35: return (void*)(QSqlRelationalTableModel*)(QObject*)xptr;
        case 23: return (void*)(QSqlDriver*)(QObject*)xptr;
        case 26: return (void*)(QSqlDriverPlugin*)(QObject*)xptr;
        case 37: return (void*)(QSqlTableModel*)(QObject*)xptr;
        case 31: return (void*)(QSqlQueryModel*)(QObject*)xptr;
        default: return xptr;
      }
    case 16:   //QPainter
      switch(to) {
        case 16: return (void*)(QPainter*)xptr;
        default: return xptr;
      }
    case 17:   //QPixmap
      switch(to) {
        case 17: return (void*)(QPixmap*)xptr;
        default: return xptr;
      }
    case 18:   //QRect
      switch(to) {
        case 18: return (void*)(QRect*)xptr;
        default: return xptr;
      }
    case 19:   //QRegExp
      switch(to) {
        case 19: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 20:   //QSize
      switch(to) {
        case 20: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 22:   //QSqlDatabase
      switch(to) {
        case 22: return (void*)(QSqlDatabase*)xptr;
        default: return xptr;
      }
    case 23:   //QSqlDriver
      switch(to) {
        case 15: return (void*)(QObject*)(QSqlDriver*)xptr;
        case 23: return (void*)(QSqlDriver*)xptr;
        default: return xptr;
      }
    case 24:   //QSqlDriverCreatorBase
      switch(to) {
        case 24: return (void*)(QSqlDriverCreatorBase*)xptr;
        default: return xptr;
      }
    case 25:   //QSqlDriverFactoryInterface
      switch(to) {
        case 8: return (void*)(QFactoryInterface*)(QSqlDriverFactoryInterface*)xptr;
        case 25: return (void*)(QSqlDriverFactoryInterface*)xptr;
        case 26: return (void*)(QSqlDriverPlugin*)(QSqlDriverFactoryInterface*)xptr;
        default: return xptr;
      }
    case 26:   //QSqlDriverPlugin
      switch(to) {
        case 15: return (void*)(QObject*)(QSqlDriverPlugin*)xptr;
        case 25: return (void*)(QSqlDriverFactoryInterface*)(QSqlDriverPlugin*)xptr;
        case 8: return (void*)(QFactoryInterface*)(QSqlDriverPlugin*)xptr;
        case 26: return (void*)(QSqlDriverPlugin*)xptr;
        default: return xptr;
      }
    case 27:   //QSqlError
      switch(to) {
        case 27: return (void*)(QSqlError*)xptr;
        default: return xptr;
      }
    case 28:   //QSqlField
      switch(to) {
        case 28: return (void*)(QSqlField*)xptr;
        default: return xptr;
      }
    case 29:   //QSqlIndex
      switch(to) {
        case 32: return (void*)(QSqlRecord*)(QSqlIndex*)xptr;
        case 29: return (void*)(QSqlIndex*)xptr;
        default: return xptr;
      }
    case 30:   //QSqlQuery
      switch(to) {
        case 30: return (void*)(QSqlQuery*)xptr;
        default: return xptr;
      }
    case 31:   //QSqlQueryModel
      switch(to) {
        case 2: return (void*)(QAbstractTableModel*)(QSqlQueryModel*)xptr;
        case 1: return (void*)(QAbstractItemModel*)(QSqlQueryModel*)xptr;
        case 15: return (void*)(QObject*)(QSqlQueryModel*)xptr;
        case 31: return (void*)(QSqlQueryModel*)xptr;
        case 35: return (void*)(QSqlRelationalTableModel*)(QSqlQueryModel*)xptr;
        case 37: return (void*)(QSqlTableModel*)(QSqlQueryModel*)xptr;
        default: return xptr;
      }
    case 32:   //QSqlRecord
      switch(to) {
        case 32: return (void*)(QSqlRecord*)xptr;
        case 29: return (void*)(QSqlIndex*)(QSqlRecord*)xptr;
        default: return xptr;
      }
    case 33:   //QSqlRelation
      switch(to) {
        case 33: return (void*)(QSqlRelation*)xptr;
        default: return xptr;
      }
    case 34:   //QSqlRelationalDelegate
      switch(to) {
        case 11: return (void*)(QItemDelegate*)(QSqlRelationalDelegate*)xptr;
        case 15: return (void*)(QObject*)(QSqlRelationalDelegate*)xptr;
        case 34: return (void*)(QSqlRelationalDelegate*)xptr;
        default: return xptr;
      }
    case 35:   //QSqlRelationalTableModel
      switch(to) {
        case 37: return (void*)(QSqlTableModel*)(QSqlRelationalTableModel*)xptr;
        case 31: return (void*)(QSqlQueryModel*)(QSqlRelationalTableModel*)xptr;
        case 2: return (void*)(QAbstractTableModel*)(QSqlRelationalTableModel*)xptr;
        case 1: return (void*)(QAbstractItemModel*)(QSqlRelationalTableModel*)xptr;
        case 15: return (void*)(QObject*)(QSqlRelationalTableModel*)xptr;
        case 35: return (void*)(QSqlRelationalTableModel*)xptr;
        default: return xptr;
      }
    case 36:   //QSqlResult
      switch(to) {
        case 36: return (void*)(QSqlResult*)xptr;
        default: return xptr;
      }
    case 37:   //QSqlTableModel
      switch(to) {
        case 31: return (void*)(QSqlQueryModel*)(QSqlTableModel*)xptr;
        case 2: return (void*)(QAbstractTableModel*)(QSqlTableModel*)xptr;
        case 1: return (void*)(QAbstractItemModel*)(QSqlTableModel*)xptr;
        case 15: return (void*)(QObject*)(QSqlTableModel*)xptr;
        case 37: return (void*)(QSqlTableModel*)xptr;
        case 35: return (void*)(QSqlRelationalTableModel*)(QSqlTableModel*)xptr;
        default: return xptr;
      }
    case 38:   //QStyleOptionViewItem
      switch(to) {
        case 38: return (void*)(QStyleOptionViewItem*)xptr;
        default: return xptr;
      }
    case 39:   //QTextCodec
      switch(to) {
        case 39: return (void*)(QTextCodec*)xptr;
        default: return xptr;
      }
    case 40:   //QTimerEvent
      switch(to) {
        case 7: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 40: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 41:   //QVariant
      switch(to) {
        case 41: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 42:   //QWidget
      switch(to) {
        case 15: return (void*)(QObject*)(QWidget*)xptr;
        case 42: return (void*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    15, 0,	// 1: QObject
    8, 0,	// 3: QFactoryInterface
    15, 25, 0,	// 5: QObject, QSqlDriverFactoryInterface
    32, 0,	// 8: QSqlRecord
    2, 0,	// 10: QAbstractTableModel
    11, 0,	// 12: QItemDelegate
    37, 0,	// 14: QSqlTableModel
    31, 0,	// 16: QSqlQueryModel
};

// These are the xenum functions for manipulating enum pointers
void xenum_QSqlField(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QSqlError(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QSqlResult(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QSqlDriver(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QSqlRelationalTableModel(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QSql(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QSqlTableModel(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QSqlQuery(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_QSql(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlDatabase(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlDriver(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlDriverCreatorBase(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlDriverFactoryInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlDriverPlugin(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlError(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlField(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlIndex(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlQuery(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlQueryModel(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlRecord(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlRelation(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlRelationalDelegate(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlRelationalTableModel(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlResult(Smoke::Index, void*, Smoke::Stack);
void xcall_QSqlTableModel(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QAbstractItemModel", true, 0, 0, 0, 0, 0 },	//1
    { "QAbstractTableModel", true, 0, 0, 0, 0, 0 },	//2
    { "QBool", true, 0, 0, 0, 0, 0 },	//3
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//4
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//5
    { "QDebug", true, 0, 0, 0, 0, 0 },	//6
    { "QEvent", true, 0, 0, 0, 0, 0 },	//7
    { "QFactoryInterface", true, 0, 0, 0, 0, 0 },	//8
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//9
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//10
    { "QItemDelegate", true, 0, 0, 0, 0, 0 },	//11
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//12
    { "QMimeData", true, 0, 0, 0, 0, 0 },	//13
    { "QModelIndex", true, 0, 0, 0, 0, 0 },	//14
    { "QObject", true, 0, 0, 0, 0, 0 },	//15
    { "QPainter", true, 0, 0, 0, 0, 0 },	//16
    { "QPixmap", true, 0, 0, 0, 0, 0 },	//17
    { "QRect", true, 0, 0, 0, 0, 0 },	//18
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//19
    { "QSize", true, 0, 0, 0, 0, 0 },	//20
    { "QSql", false, 0, xcall_QSql, xenum_QSql, Smoke::cf_namespace, 0 },	//21
    { "QSqlDatabase", false, 0, xcall_QSqlDatabase, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QSqlDatabase) },	//22
    { "QSqlDriver", false, 1, xcall_QSqlDriver, xenum_QSqlDriver, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QSqlDriver) },	//23
    { "QSqlDriverCreatorBase", false, 0, xcall_QSqlDriverCreatorBase, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QSqlDriverCreatorBase) },	//24
    { "QSqlDriverFactoryInterface", false, 3, xcall_QSqlDriverFactoryInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QSqlDriverFactoryInterface) },	//25
    { "QSqlDriverPlugin", false, 5, xcall_QSqlDriverPlugin, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QSqlDriverPlugin) },	//26
    { "QSqlError", false, 0, xcall_QSqlError, xenum_QSqlError, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QSqlError) },	//27
    { "QSqlField", false, 0, xcall_QSqlField, xenum_QSqlField, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QSqlField) },	//28
    { "QSqlIndex", false, 8, xcall_QSqlIndex, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QSqlIndex) },	//29
    { "QSqlQuery", false, 0, xcall_QSqlQuery, xenum_QSqlQuery, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QSqlQuery) },	//30
    { "QSqlQueryModel", false, 10, xcall_QSqlQueryModel, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QSqlQueryModel) },	//31
    { "QSqlRecord", false, 0, xcall_QSqlRecord, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QSqlRecord) },	//32
    { "QSqlRelation", false, 0, xcall_QSqlRelation, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QSqlRelation) },	//33
    { "QSqlRelationalDelegate", false, 12, xcall_QSqlRelationalDelegate, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QSqlRelationalDelegate) },	//34
    { "QSqlRelationalTableModel", false, 14, xcall_QSqlRelationalTableModel, xenum_QSqlRelationalTableModel, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QSqlRelationalTableModel) },	//35
    { "QSqlResult", false, 0, xcall_QSqlResult, xenum_QSqlResult, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QSqlResult) },	//36
    { "QSqlTableModel", false, 16, xcall_QSqlTableModel, xenum_QSqlTableModel, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QSqlTableModel) },	//37
    { "QStyleOptionViewItem", true, 0, 0, 0, 0, 0 },	//38
    { "QTextCodec", true, 0, 0, 0, 0, 0 },	//39
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//40
    { "QVariant", true, 0, 0, 0, 0, 0 },	//41
    { "QWidget", true, 0, 0, 0, 0, 0 },	//42
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QAbstractItemModel*", 1, Smoke::t_class|Smoke::tf_ptr },	//1
    { "QAccessible2::BoundaryType", 0, Smoke::t_enum|Smoke::tf_stack },	//2
    { "QAccessible2::CoordinateType", 0, Smoke::t_enum|Smoke::tf_stack },	//3
    { "QAccessible2::InterfaceType", 0, Smoke::t_enum|Smoke::tf_stack },	//4
    { "QAccessible2::TableModelChangeType", 0, Smoke::t_enum|Smoke::tf_stack },	//5
    { "QBool", 3, Smoke::t_class|Smoke::tf_stack },	//6
    { "QChildEvent*", 5, Smoke::t_class|Smoke::tf_ptr },	//7
    { "QDebug", 6, Smoke::t_class|Smoke::tf_stack },	//8
    { "QDrawBorderPixmap::DrawingHint", 0, Smoke::t_enum|Smoke::tf_stack },	//9
    { "QEvent*", 7, Smoke::t_class|Smoke::tf_ptr },	//10
    { "QFlags<QSql::ParamTypeFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//11
    { "QFlags<Qt::DropAction>", 0, Smoke::t_uint|Smoke::tf_stack },	//12
    { "QFlags<Qt::ItemFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//13
    { "QFlags<Qt::MatchFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//14
    { "QIncompatibleFlag", 10, Smoke::t_class|Smoke::tf_stack },	//15
    { "QList<QModelIndex>", 0, Smoke::t_voidp|Smoke::tf_stack },	//16
    { "QMap<QString,QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack },	//17
    { "QMap<int,QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack },	//18
    { "QMetaObject::Call", 12, Smoke::t_enum|Smoke::tf_stack },	//19
    { "QMimeData*", 13, Smoke::t_class|Smoke::tf_ptr },	//20
    { "QModelIndex", 14, Smoke::t_class|Smoke::tf_stack },	//21
    { "QObject*", 15, Smoke::t_class|Smoke::tf_ptr },	//22
    { "QPainter*", 16, Smoke::t_class|Smoke::tf_ptr },	//23
    { "QRegExp&", 19, Smoke::t_class|Smoke::tf_ref },	//24
    { "QSize", 20, Smoke::t_class|Smoke::tf_stack },	//25
    { "QSql::Location", 21, Smoke::t_enum|Smoke::tf_stack },	//26
    { "QSql::NumericalPrecisionPolicy", 21, Smoke::t_enum|Smoke::tf_stack },	//27
    { "QSql::ParamTypeFlag", 21, Smoke::t_enum|Smoke::tf_stack },	//28
    { "QSql::TableType", 21, Smoke::t_enum|Smoke::tf_stack },	//29
    { "QSqlDatabase", 22, Smoke::t_class|Smoke::tf_stack },	//30
    { "QSqlDatabase&", 22, Smoke::t_class|Smoke::tf_ref },	//31
    { "QSqlDatabase*", 22, Smoke::t_class|Smoke::tf_ptr },	//32
    { "QSqlDriver*", 23, Smoke::t_class|Smoke::tf_ptr },	//33
    { "QSqlDriver::DriverFeature", 23, Smoke::t_enum|Smoke::tf_stack },	//34
    { "QSqlDriver::IdentifierType", 23, Smoke::t_enum|Smoke::tf_stack },	//35
    { "QSqlDriver::StatementType", 23, Smoke::t_enum|Smoke::tf_stack },	//36
    { "QSqlDriverCreatorBase*", 24, Smoke::t_class|Smoke::tf_ptr },	//37
    { "QSqlDriverFactoryInterface*", 25, Smoke::t_class|Smoke::tf_ptr },	//38
    { "QSqlDriverPlugin*", 26, Smoke::t_class|Smoke::tf_ptr },	//39
    { "QSqlError", 27, Smoke::t_class|Smoke::tf_stack },	//40
    { "QSqlError&", 27, Smoke::t_class|Smoke::tf_ref },	//41
    { "QSqlError*", 27, Smoke::t_class|Smoke::tf_ptr },	//42
    { "QSqlError::ErrorType", 27, Smoke::t_enum|Smoke::tf_stack },	//43
    { "QSqlField", 28, Smoke::t_class|Smoke::tf_stack },	//44
    { "QSqlField&", 28, Smoke::t_class|Smoke::tf_ref },	//45
    { "QSqlField*", 28, Smoke::t_class|Smoke::tf_ptr },	//46
    { "QSqlField::RequiredStatus", 28, Smoke::t_enum|Smoke::tf_stack },	//47
    { "QSqlIndex", 29, Smoke::t_class|Smoke::tf_stack },	//48
    { "QSqlIndex&", 29, Smoke::t_class|Smoke::tf_ref },	//49
    { "QSqlIndex*", 29, Smoke::t_class|Smoke::tf_ptr },	//50
    { "QSqlQuery", 30, Smoke::t_class|Smoke::tf_stack },	//51
    { "QSqlQuery&", 30, Smoke::t_class|Smoke::tf_ref },	//52
    { "QSqlQuery*", 30, Smoke::t_class|Smoke::tf_ptr },	//53
    { "QSqlQuery::BatchExecutionMode", 30, Smoke::t_enum|Smoke::tf_stack },	//54
    { "QSqlQueryModel*", 31, Smoke::t_class|Smoke::tf_ptr },	//55
    { "QSqlRecord", 32, Smoke::t_class|Smoke::tf_stack },	//56
    { "QSqlRecord&", 32, Smoke::t_class|Smoke::tf_ref },	//57
    { "QSqlRecord*", 32, Smoke::t_class|Smoke::tf_ptr },	//58
    { "QSqlRelation", 33, Smoke::t_class|Smoke::tf_stack },	//59
    { "QSqlRelation*", 33, Smoke::t_class|Smoke::tf_ptr },	//60
    { "QSqlRelationalDelegate*", 34, Smoke::t_class|Smoke::tf_ptr },	//61
    { "QSqlRelationalTableModel*", 35, Smoke::t_class|Smoke::tf_ptr },	//62
    { "QSqlRelationalTableModel::JoinMode", 35, Smoke::t_enum|Smoke::tf_stack },	//63
    { "QSqlResult*", 36, Smoke::t_class|Smoke::tf_ptr },	//64
    { "QSqlResult::BindingSyntax", 36, Smoke::t_enum|Smoke::tf_stack },	//65
    { "QSqlResult::VirtualHookOperation", 36, Smoke::t_enum|Smoke::tf_stack },	//66
    { "QSqlTableModel*", 37, Smoke::t_class|Smoke::tf_ptr },	//67
    { "QSqlTableModel::EditStrategy", 37, Smoke::t_enum|Smoke::tf_stack },	//68
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//69
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//70
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//71
    { "QTextCodec*", 39, Smoke::t_class|Smoke::tf_ptr },	//72
    { "QTimerEvent*", 40, Smoke::t_class|Smoke::tf_ptr },	//73
    { "QVariant", 41, Smoke::t_class|Smoke::tf_stack },	//74
    { "QVariant::Type", 41, Smoke::t_enum|Smoke::tf_stack },	//75
    { "QVector<QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref },	//76
    { "QWidget*", 42, Smoke::t_class|Smoke::tf_ptr },	//77
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//78
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//79
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//80
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//81
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//82
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//83
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//84
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//85
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//86
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//87
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//88
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//89
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//90
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//91
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//92
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//93
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//94
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//95
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//96
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//97
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//98
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//99
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//100
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//101
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//102
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//103
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//104
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//105
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//106
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//107
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//108
    { "Qt::HitTestAccuracy", 0, Smoke::t_enum|Smoke::tf_stack },	//109
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//110
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//111
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//112
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//113
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//114
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//115
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//116
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//117
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//118
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//119
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//120
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//121
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//122
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//123
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//124
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//125
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//126
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//127
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//128
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//129
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//130
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//131
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//132
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//133
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//134
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//135
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//136
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//137
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//138
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//139
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//140
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//141
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//142
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//143
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//144
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//145
    { "Qt::WhiteSpaceMode", 0, Smoke::t_enum|Smoke::tf_stack },	//146
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//147
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//148
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//149
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//150
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//151
    { "QtConcurrent::ReduceOption", 0, Smoke::t_enum|Smoke::tf_stack },	//152
    { "QtConcurrent::ThreadFunctionResult", 0, Smoke::t_enum|Smoke::tf_stack },	//153
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//154
    { "const QByteArray&", 4, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//155
    { "const QList<QModelIndex>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//156
    { "const QMap<int,QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//157
    { "const QMetaObject&", 12, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//158
    { "const QMetaObject*", 12, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//159
    { "const QMimeData*", 13, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//160
    { "const QModelIndex&", 14, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//161
    { "const QPixmap&", 17, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//162
    { "const QRect&", 18, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//163
    { "const QRegExp&", 19, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//164
    { "const QSqlDatabase&", 22, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//165
    { "const QSqlDriver*", 23, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//166
    { "const QSqlDriverCreatorBase&", 24, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//167
    { "const QSqlDriverFactoryInterface&", 25, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//168
    { "const QSqlError&", 27, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//169
    { "const QSqlField&", 28, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//170
    { "const QSqlIndex&", 29, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//171
    { "const QSqlQuery&", 30, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//172
    { "const QSqlRecord&", 32, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//173
    { "const QSqlRelation&", 33, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//174
    { "const QSqlResult*", 36, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//175
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//176
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//177
    { "const QStyleOptionViewItem&", 38, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//178
    { "const QVariant&", 41, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//179
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//180
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//181
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//182
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//183
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//184
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//185
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//186
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    161, 179, 182, 0,	//1  const QModelIndex&, const QVariant&, int
    161, 0,	//5  const QModelIndex&
    161, 157, 0,	//7  const QModelIndex&, const QMap<int,QVariant>&
    156, 0,	//10  const QList<QModelIndex>&
    182, 182, 161, 0,	//12  int, int, const QModelIndex&
    182, 133, 0,	//16  int, Qt::SortOrder
    161, 182, 179, 182, 14, 0,	//19  const QModelIndex&, int, const QVariant&, int, QFlags<Qt::MatchFlag>
    160, 100, 182, 182, 161, 0,	//25  const QMimeData*, Qt::DropAction, int, int, const QModelIndex&
    28, 182, 0,	//31  QSql::ParamTypeFlag, int
    28, 28, 0,	//34  QSql::ParamTypeFlag, QSql::ParamTypeFlag
    8, 170, 0,	//37  QDebug, const QSqlField&
    8, 165, 0,	//40  QDebug, const QSqlDatabase&
    8, 173, 0,	//43  QDebug, const QSqlRecord&
    28, 11, 0,	//46  QSql::ParamTypeFlag, QFlags<QSql::ParamTypeFlag>
    8, 169, 0,	//49  QDebug, const QSqlError&
    180, 0,	//52  const char*
    19, 182, 185, 0,	//54  QMetaObject::Call, int, void**
    23, 178, 161, 0,	//58  QPainter*, const QStyleOptionViewItem&, const QModelIndex&
    178, 161, 0,	//62  const QStyleOptionViewItem&, const QModelIndex&
    77, 178, 161, 0,	//65  QWidget*, const QStyleOptionViewItem&, const QModelIndex&
    23, 178, 163, 176, 0,	//69  QPainter*, const QStyleOptionViewItem&, const QRect&, const QString&
    23, 178, 163, 162, 0,	//74  QPainter*, const QStyleOptionViewItem&, const QRect&, const QPixmap&
    23, 178, 163, 0,	//79  QPainter*, const QStyleOptionViewItem&, const QRect&
    23, 178, 163, 88, 0,	//83  QPainter*, const QStyleOptionViewItem&, const QRect&, Qt::CheckState
    22, 10, 0,	//88  QObject*, QEvent*
    10, 1, 178, 161, 0,	//91  QEvent*, QAbstractItemModel*, const QStyleOptionViewItem&, const QModelIndex&
    10, 0,	//96  QEvent*
    73, 0,	//98  QTimerEvent*
    7, 0,	//100  QChildEvent*
    165, 0,	//102  const QSqlDatabase&
    176, 176, 0,	//104  const QString&, const QString&
    29, 0,	//107  QSql::TableType
    176, 0,	//109  const QString&
    182, 0,	//111  int
    27, 0,	//113  QSql::NumericalPrecisionPolicy
    33, 176, 0,	//115  QSqlDriver*, const QString&
    165, 176, 0,	//118  const QSqlDatabase&, const QString&
    176, 154, 0,	//121  const QString&, bool
    176, 37, 0,	//124  const QString&, QSqlDriverCreatorBase*
    33, 0,	//127  QSqlDriver*
    180, 180, 0,	//129  const char*, const char*
    180, 180, 182, 0,	//132  const char*, const char*, int
    22, 0,	//136  QObject*
    170, 154, 0,	//138  const QSqlField&, bool
    176, 35, 0,	//141  const QString&, QSqlDriver::IdentifierType
    36, 176, 173, 154, 0,	//144  QSqlDriver::StatementType, const QString&, const QSqlRecord&, bool
    34, 0,	//149  QSqlDriver::DriverFeature
    176, 176, 176, 176, 182, 176, 0,	//151  const QString&, const QString&, const QString&, const QString&, int, const QString&
    154, 0,	//158  bool
    169, 0,	//160  const QSqlError&
    170, 0,	//162  const QSqlField&
    176, 176, 176, 0,	//164  const QString&, const QString&, const QString&
    176, 176, 176, 176, 0,	//168  const QString&, const QString&, const QString&, const QString&
    176, 176, 176, 176, 182, 0,	//173  const QString&, const QString&, const QString&, const QString&, int
    167, 0,	//179  const QSqlDriverCreatorBase&
    168, 0,	//181  const QSqlDriverFactoryInterface&
    176, 176, 43, 182, 0,	//183  const QString&, const QString&, QSqlError::ErrorType, int
    43, 0,	//188  QSqlError::ErrorType
    176, 176, 43, 0,	//190  const QString&, const QString&, QSqlError::ErrorType
    176, 75, 0,	//194  const QString&, QVariant::Type
    179, 0,	//197  const QVariant&
    75, 0,	//199  QVariant::Type
    47, 0,	//201  QSqlField::RequiredStatus
    171, 0,	//203  const QSqlIndex&
    182, 154, 0,	//205  int, bool
    64, 0,	//208  QSqlResult*
    176, 30, 0,	//210  const QString&, QSqlDatabase
    30, 0,	//213  QSqlDatabase
    172, 0,	//215  const QSqlQuery&
    54, 0,	//217  QSqlQuery::BatchExecutionMode
    176, 179, 11, 0,	//219  const QString&, const QVariant&, QFlags<QSql::ParamTypeFlag>
    182, 179, 11, 0,	//223  int, const QVariant&, QFlags<QSql::ParamTypeFlag>
    179, 11, 0,	//227  const QVariant&, QFlags<QSql::ParamTypeFlag>
    176, 179, 0,	//230  const QString&, const QVariant&
    182, 179, 0,	//233  int, const QVariant&
    161, 182, 0,	//236  const QModelIndex&, int
    182, 125, 182, 0,	//239  int, Qt::Orientation, int
    182, 125, 179, 182, 0,	//243  int, Qt::Orientation, const QVariant&, int
    176, 165, 0,	//248  const QString&, const QSqlDatabase&
    182, 125, 0,	//251  int, Qt::Orientation
    182, 125, 179, 0,	//254  int, Qt::Orientation, const QVariant&
    182, 182, 0,	//258  int, int
    173, 0,	//261  const QSqlRecord&
    182, 170, 0,	//263  int, const QSqlField&
    174, 0,	//266  const QSqlRelation&
    77, 161, 0,	//268  QWidget*, const QModelIndex&
    77, 1, 161, 0,	//271  QWidget*, QAbstractItemModel*, const QModelIndex&
    22, 30, 0,	//275  QObject*, QSqlDatabase
    182, 174, 0,	//278  int, const QSqlRelation&
    63, 0,	//281  QSqlRelationalTableModel::JoinMode
    182, 173, 0,	//283  int, const QSqlRecord&
    161, 179, 0,	//286  const QModelIndex&, const QVariant&
    166, 0,	//289  const QSqlDriver*
    182, 184, 0,	//291  int, void*
    68, 0,	//294  QSqlTableModel::EditStrategy
    182, 57, 0,	//296  int, QSqlRecord&
    57, 0,	//299  QSqlRecord&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "AfterLastRow",	//1
    "AllTables",	//2
    "BLOB",	//3
    "BatchOperation",	//4
    "BatchOperations",	//5
    "BeforeFirstRow",	//6
    "Binary",	//7
    "ConnectionError",	//8
    "DeleteStatement",	//9
    "DetachFromResultSet",	//10
    "EventNotifications",	//11
    "FieldName",	//12
    "FinishQuery",	//13
    "HighPrecision",	//14
    "In",	//15
    "InOut",	//16
    "InnerJoin",	//17
    "InsertStatement",	//18
    "LastInsertId",	//19
    "LeftJoin",	//20
    "LowPrecisionDouble",	//21
    "LowPrecisionInt32",	//22
    "LowPrecisionInt64",	//23
    "LowPrecisionNumbers",	//24
    "MultipleResultSets",	//25
    "NamedBinding",	//26
    "NamedPlaceholders",	//27
    "NextResult",	//28
    "NoError",	//29
    "OnFieldChange",	//30
    "OnManualSubmit",	//31
    "OnRowChange",	//32
    "Optional",	//33
    "Out",	//34
    "PositionalBinding",	//35
    "PositionalPlaceholders",	//36
    "PreparedQueries",	//37
    "QSqlDatabase",	//38
    "QSqlDatabase#",	//39
    "QSqlDatabase$",	//40
    "QSqlDriver",	//41
    "QSqlDriver#",	//42
    "QSqlDriverCreatorBase",	//43
    "QSqlDriverCreatorBase#",	//44
    "QSqlDriverFactoryInterface",	//45
    "QSqlDriverFactoryInterface#",	//46
    "QSqlDriverPlugin",	//47
    "QSqlDriverPlugin#",	//48
    "QSqlError",	//49
    "QSqlError#",	//50
    "QSqlError$",	//51
    "QSqlError$$",	//52
    "QSqlError$$$",	//53
    "QSqlError$$$$",	//54
    "QSqlField",	//55
    "QSqlField#",	//56
    "QSqlField$",	//57
    "QSqlField$$",	//58
    "QSqlIndex",	//59
    "QSqlIndex#",	//60
    "QSqlIndex$",	//61
    "QSqlIndex$$",	//62
    "QSqlQuery",	//63
    "QSqlQuery#",	//64
    "QSqlQuery$",	//65
    "QSqlQuery$#",	//66
    "QSqlQueryModel",	//67
    "QSqlQueryModel#",	//68
    "QSqlRecord",	//69
    "QSqlRecord#",	//70
    "QSqlRelation",	//71
    "QSqlRelation#",	//72
    "QSqlRelation$$$",	//73
    "QSqlRelationalDelegate",	//74
    "QSqlRelationalDelegate#",	//75
    "QSqlRelationalTableModel",	//76
    "QSqlRelationalTableModel#",	//77
    "QSqlRelationalTableModel##",	//78
    "QSqlResult",	//79
    "QSqlResult#",	//80
    "QSqlTableModel",	//81
    "QSqlTableModel#",	//82
    "QSqlTableModel##",	//83
    "QuerySize",	//84
    "Required",	//85
    "SelectStatement",	//86
    "SetNumericalPrecision",	//87
    "SimpleLocking",	//88
    "StatementError",	//89
    "SystemTables",	//90
    "TableName",	//91
    "Tables",	//92
    "TransactionError",	//93
    "Transactions",	//94
    "Unicode",	//95
    "Unknown",	//96
    "UnknownError",	//97
    "UpdateStatement",	//98
    "ValuesAsColumns",	//99
    "ValuesAsRows",	//100
    "Views",	//101
    "WhereStatement",	//102
    "addBindValue",	//103
    "addBindValue#",	//104
    "addBindValue#$",	//105
    "addDatabase",	//106
    "addDatabase#",	//107
    "addDatabase#$",	//108
    "addDatabase$",	//109
    "addDatabase$$",	//110
    "append",	//111
    "append#",	//112
    "append#$",	//113
    "at",	//114
    "beforeDelete",	//115
    "beforeDelete$",	//116
    "beforeInsert",	//117
    "beforeInsert#",	//118
    "beforeUpdate",	//119
    "beforeUpdate$#",	//120
    "beginTransaction",	//121
    "bindValue",	//122
    "bindValue$#",	//123
    "bindValue$#$",	//124
    "bindValueType",	//125
    "bindValueType$",	//126
    "bindingSyntax",	//127
    "boundValue",	//128
    "boundValue$",	//129
    "boundValueCount",	//130
    "boundValueName",	//131
    "boundValueName$",	//132
    "boundValues",	//133
    "buddy",	//134
    "canFetchMore",	//135
    "canFetchMore#",	//136
    "childEvent",	//137
    "clear",	//138
    "clearValues",	//139
    "cloneDatabase",	//140
    "cloneDatabase#$",	//141
    "close",	//142
    "columnCount",	//143
    "columnCount#",	//144
    "commit",	//145
    "commitTransaction",	//146
    "connectNotify",	//147
    "connectOptions",	//148
    "connectionName",	//149
    "connectionNames",	//150
    "contains",	//151
    "contains$",	//152
    "count",	//153
    "create",	//154
    "create$",	//155
    "createEditor",	//156
    "createEditor###",	//157
    "createObject",	//158
    "createResult",	//159
    "cursorName",	//160
    "customEvent",	//161
    "data",	//162
    "data#",	//163
    "data#$",	//164
    "data$",	//165
    "database",	//166
    "database$",	//167
    "database$$",	//168
    "databaseName",	//169
    "databaseText",	//170
    "defaultConnection",	//171
    "defaultValue",	//172
    "deleteRowFromTable",	//173
    "deleteRowFromTable$",	//174
    "detachFromResultSet",	//175
    "disconnectNotify",	//176
    "displayColumn",	//177
    "drawCheck",	//178
    "drawDecoration",	//179
    "drawDisplay",	//180
    "drawFocus",	//181
    "driver",	//182
    "driverName",	//183
    "driverText",	//184
    "drivers",	//185
    "dropMimeData",	//186
    "editStrategy",	//187
    "editorEvent",	//188
    "escapeIdentifier",	//189
    "escapeIdentifier$$",	//190
    "event",	//191
    "eventFilter",	//192
    "exec",	//193
    "exec$",	//194
    "execBatch",	//195
    "execBatch$",	//196
    "executedQuery",	//197
    "fetch",	//198
    "fetch$",	//199
    "fetchFirst",	//200
    "fetchLast",	//201
    "fetchMore",	//202
    "fetchMore#",	//203
    "fetchNext",	//204
    "fetchPrevious",	//205
    "field",	//206
    "field$",	//207
    "fieldIndex",	//208
    "fieldIndex$",	//209
    "fieldName",	//210
    "fieldName$",	//211
    "filter",	//212
    "finish",	//213
    "first",	//214
    "flags",	//215
    "flags#",	//216
    "formatValue",	//217
    "formatValue#",	//218
    "formatValue#$",	//219
    "handle",	//220
    "hasFeature",	//221
    "hasFeature$",	//222
    "hasOutValues",	//223
    "headerData",	//224
    "headerData$$",	//225
    "headerData$$$",	//226
    "hostName",	//227
    "index",	//228
    "indexColumn",	//229
    "indexInQuery",	//230
    "indexInQuery#",	//231
    "indexOf",	//232
    "indexOf$",	//233
    "insert",	//234
    "insert$#",	//235
    "insertColumns",	//236
    "insertColumns$$",	//237
    "insertColumns$$#",	//238
    "insertRecord",	//239
    "insertRecord$#",	//240
    "insertRowIntoTable",	//241
    "insertRowIntoTable#",	//242
    "insertRows",	//243
    "insertRows$$",	//244
    "insertRows$$#",	//245
    "isActive",	//246
    "isAutoValue",	//247
    "isDescending",	//248
    "isDescending$",	//249
    "isDirty",	//250
    "isDirty#",	//251
    "isDriverAvailable",	//252
    "isDriverAvailable$",	//253
    "isEmpty",	//254
    "isForwardOnly",	//255
    "isGenerated",	//256
    "isGenerated$",	//257
    "isIdentifierEscaped",	//258
    "isIdentifierEscaped$$",	//259
    "isIdentifierEscapedImplementation",	//260
    "isIdentifierEscapedImplementation$$",	//261
    "isNull",	//262
    "isNull$",	//263
    "isOpen",	//264
    "isOpenError",	//265
    "isReadOnly",	//266
    "isSelect",	//267
    "isValid",	//268
    "itemData",	//269
    "keys",	//270
    "last",	//271
    "lastError",	//272
    "lastInsertId",	//273
    "lastQuery",	//274
    "length",	//275
    "match",	//276
    "metaObject",	//277
    "mimeData",	//278
    "mimeTypes",	//279
    "name",	//280
    "next",	//281
    "nextResult",	//282
    "notification",	//283
    "notification$",	//284
    "numRowsAffected",	//285
    "number",	//286
    "numericalPrecisionPolicy",	//287
    "open",	//288
    "open$",	//289
    "open$$",	//290
    "open$$$",	//291
    "open$$$$",	//292
    "open$$$$$",	//293
    "open$$$$$$",	//294
    "operator!=",	//295
    "operator!=#",	//296
    "operator<<",	//297
    "operator<<##",	//298
    "operator=",	//299
    "operator=#",	//300
    "operator==",	//301
    "operator==#",	//302
    "operator|",	//303
    "operator|$$",	//304
    "orderByClause",	//305
    "paint",	//306
    "password",	//307
    "port",	//308
    "precision",	//309
    "prepare",	//310
    "prepare$",	//311
    "previous",	//312
    "primaryIndex",	//313
    "primaryIndex$",	//314
    "primaryKey",	//315
    "primeInsert",	//316
    "primeInsert$#",	//317
    "qt_metacall",	//318
    "qt_metacall$$?",	//319
    "qt_metacast",	//320
    "qt_metacast$",	//321
    "query",	//322
    "queryChange",	//323
    "record",	//324
    "record$",	//325
    "registerSqlDriver",	//326
    "registerSqlDriver$#",	//327
    "relation",	//328
    "relation$",	//329
    "relationModel",	//330
    "relationModel$",	//331
    "remove",	//332
    "remove$",	//333
    "removeColumns",	//334
    "removeColumns$$",	//335
    "removeColumns$$#",	//336
    "removeDatabase",	//337
    "removeDatabase$",	//338
    "removeRows",	//339
    "removeRows$$",	//340
    "removeRows$$#",	//341
    "replace",	//342
    "replace$#",	//343
    "requiredStatus",	//344
    "reset",	//345
    "reset$",	//346
    "result",	//347
    "revert",	//348
    "revertAll",	//349
    "revertRow",	//350
    "revertRow$",	//351
    "rollback",	//352
    "rollbackTransaction",	//353
    "rowCount",	//354
    "rowCount#",	//355
    "savePrepare",	//356
    "savePrepare$",	//357
    "seek",	//358
    "seek$",	//359
    "seek$$",	//360
    "select",	//361
    "selectStatement",	//362
    "setActive",	//363
    "setActive$",	//364
    "setAt",	//365
    "setAt$",	//366
    "setAutoValue",	//367
    "setAutoValue$",	//368
    "setConnectOptions",	//369
    "setConnectOptions$",	//370
    "setCursorName",	//371
    "setCursorName$",	//372
    "setData",	//373
    "setData##",	//374
    "setData##$",	//375
    "setDatabaseName",	//376
    "setDatabaseName$",	//377
    "setDatabaseText",	//378
    "setDatabaseText$",	//379
    "setDefaultConnection",	//380
    "setDefaultConnection$",	//381
    "setDefaultValue",	//382
    "setDefaultValue#",	//383
    "setDescending",	//384
    "setDescending$$",	//385
    "setDriverText",	//386
    "setDriverText$",	//387
    "setEditStrategy",	//388
    "setEditStrategy$",	//389
    "setEditorData",	//390
    "setEditorData##",	//391
    "setFilter",	//392
    "setFilter$",	//393
    "setForwardOnly",	//394
    "setForwardOnly$",	//395
    "setGenerated",	//396
    "setGenerated$",	//397
    "setGenerated$$",	//398
    "setHeaderData",	//399
    "setHeaderData$$#",	//400
    "setHeaderData$$#$",	//401
    "setHostName",	//402
    "setHostName$",	//403
    "setItemData",	//404
    "setJoinMode",	//405
    "setJoinMode$",	//406
    "setLastError",	//407
    "setLastError#",	//408
    "setLength",	//409
    "setLength$",	//410
    "setModelData",	//411
    "setModelData###",	//412
    "setName",	//413
    "setName$",	//414
    "setNull",	//415
    "setNull$",	//416
    "setNumber",	//417
    "setNumber$",	//418
    "setNumericalPrecisionPolicy",	//419
    "setNumericalPrecisionPolicy$",	//420
    "setOpen",	//421
    "setOpen$",	//422
    "setOpenError",	//423
    "setOpenError$",	//424
    "setPassword",	//425
    "setPassword$",	//426
    "setPort",	//427
    "setPort$",	//428
    "setPrecision",	//429
    "setPrecision$",	//430
    "setPrimaryKey",	//431
    "setPrimaryKey#",	//432
    "setQuery",	//433
    "setQuery#",	//434
    "setQuery$",	//435
    "setQuery$#",	//436
    "setReadOnly",	//437
    "setReadOnly$",	//438
    "setRecord",	//439
    "setRecord$#",	//440
    "setRelation",	//441
    "setRelation$#",	//442
    "setRequired",	//443
    "setRequired$",	//444
    "setRequiredStatus",	//445
    "setRequiredStatus$",	//446
    "setSelect",	//447
    "setSelect$",	//448
    "setSort",	//449
    "setSort$$",	//450
    "setSqlType",	//451
    "setSqlType$",	//452
    "setTable",	//453
    "setTable$",	//454
    "setType",	//455
    "setType$",	//456
    "setUserName",	//457
    "setUserName$",	//458
    "setValue",	//459
    "setValue#",	//460
    "setValue$#",	//461
    "size",	//462
    "sizeHint",	//463
    "sort",	//464
    "sort$$",	//465
    "span",	//466
    "sqlStatement",	//467
    "sqlStatement$$#$",	//468
    "staticMetaObject",	//469
    "stripDelimiters",	//470
    "stripDelimiters$$",	//471
    "stripDelimitersImplementation",	//472
    "stripDelimitersImplementation$$",	//473
    "submit",	//474
    "submitAll",	//475
    "subscribeToNotification",	//476
    "subscribeToNotification$",	//477
    "subscribeToNotificationImplementation",	//478
    "subscribeToNotificationImplementation$",	//479
    "subscribedToNotifications",	//480
    "subscribedToNotificationsImplementation",	//481
    "supportedDropActions",	//482
    "tableName",	//483
    "tables",	//484
    "tables$",	//485
    "text",	//486
    "timerEvent",	//487
    "tr",	//488
    "tr$",	//489
    "tr$$",	//490
    "tr$$$",	//491
    "trUtf8",	//492
    "trUtf8$",	//493
    "trUtf8$$",	//494
    "trUtf8$$$",	//495
    "transaction",	//496
    "type",	//497
    "typeID",	//498
    "unsubscribeFromNotification",	//499
    "unsubscribeFromNotification$",	//500
    "unsubscribeFromNotificationImplementation",	//501
    "unsubscribeFromNotificationImplementation$",	//502
    "updateEditorGeometry",	//503
    "updateRowInTable",	//504
    "updateRowInTable$#",	//505
    "userName",	//506
    "value",	//507
    "value$",	//508
    "virtual_hook",	//509
    "virtual_hook$$",	//510
    "~QSqlDatabase",	//511
    "~QSqlDriver",	//512
    "~QSqlDriverCreatorBase",	//513
    "~QSqlDriverFactoryInterface",	//514
    "~QSqlDriverPlugin",	//515
    "~QSqlError",	//516
    "~QSqlField",	//517
    "~QSqlIndex",	//518
    "~QSqlQuery",	//519
    "~QSqlQueryModel",	//520
    "~QSqlRecord",	//521
    "~QSqlRelation",	//522
    "~QSqlRelationalDelegate",	//523
    "~QSqlRelationalTableModel",	//524
    "~QSqlResult",	//525
    "~QSqlTableModel",	//526
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {1, 373, 1, 3, Smoke::mf_virtual, 154, 0},	//1 QAbstractItemModel::setData(const QModelIndex&, const QVariant&, int)
    {1, 269, 5, 1, Smoke::mf_const|Smoke::mf_virtual, 18, 0},	//2 QAbstractItemModel::itemData(const QModelIndex&) const
    {1, 404, 7, 2, Smoke::mf_virtual, 154, 0},	//3 QAbstractItemModel::setItemData(const QModelIndex&, const QMap<int,QVariant>&)
    {1, 279, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 70, 0},	//4 QAbstractItemModel::mimeTypes() const
    {1, 278, 10, 1, Smoke::mf_const|Smoke::mf_virtual, 20, 0},	//5 QAbstractItemModel::mimeData(const QList<QModelIndex>&) const
    {1, 482, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 12, 0},	//6 QAbstractItemModel::supportedDropActions() const
    {1, 243, 12, 3, Smoke::mf_virtual, 154, 0},	//7 QAbstractItemModel::insertRows(int, int, const QModelIndex&)
    {1, 339, 12, 3, Smoke::mf_virtual, 154, 0},	//8 QAbstractItemModel::removeRows(int, int, const QModelIndex&)
    {1, 215, 5, 1, Smoke::mf_const|Smoke::mf_virtual, 13, 0},	//9 QAbstractItemModel::flags(const QModelIndex&) const
    {1, 464, 16, 2, Smoke::mf_virtual, 0, 0},	//10 QAbstractItemModel::sort(int, Qt::SortOrder)
    {1, 134, 5, 1, Smoke::mf_const|Smoke::mf_virtual, 21, 0},	//11 QAbstractItemModel::buddy(const QModelIndex&) const
    {1, 276, 19, 5, Smoke::mf_const|Smoke::mf_virtual, 16, 0},	//12 QAbstractItemModel::match(const QModelIndex&, int, const QVariant&, int, QFlags<Qt::MatchFlag>) const
    {1, 466, 5, 1, Smoke::mf_const|Smoke::mf_virtual, 25, 0},	//13 QAbstractItemModel::span(const QModelIndex&) const
    {1, 474, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 154, 0},	//14 QAbstractItemModel::submit()
    {1, 348, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//15 QAbstractItemModel::revert()
    {2, 228, 12, 3, Smoke::mf_const|Smoke::mf_virtual, 21, 0},	//16 QAbstractTableModel::index(int, int, const QModelIndex&) const
    {2, 186, 25, 5, Smoke::mf_virtual, 154, 0},	//17 QAbstractTableModel::dropMimeData(const QMimeData*, Qt::DropAction, int, int, const QModelIndex&)
    {8, 270, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 70, 0},	//18 QFactoryInterface::keys() const [pure virtual]
    {9, 303, 31, 2, Smoke::mf_static, 15, 1},	//19 QGlobalSpace::operator|(QSql::ParamTypeFlag, int)
    {9, 303, 34, 2, Smoke::mf_static, 11, 2},	//20 QGlobalSpace::operator|(QSql::ParamTypeFlag, QSql::ParamTypeFlag)
    {9, 297, 37, 2, Smoke::mf_static, 8, 3},	//21 QGlobalSpace::operator<<(QDebug, const QSqlField&)
    {9, 297, 40, 2, Smoke::mf_static, 8, 4},	//22 QGlobalSpace::operator<<(QDebug, const QSqlDatabase&)
    {9, 297, 43, 2, Smoke::mf_static, 8, 5},	//23 QGlobalSpace::operator<<(QDebug, const QSqlRecord&)
    {9, 303, 46, 2, Smoke::mf_static, 11, 6},	//24 QGlobalSpace::operator|(QSql::ParamTypeFlag, QFlags<QSql::ParamTypeFlag>)
    {9, 297, 49, 2, Smoke::mf_static, 8, 7},	//25 QGlobalSpace::operator<<(QDebug, const QSqlError&)
    {11, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 159, 0},	//26 QItemDelegate::metaObject() const
    {11, 320, 52, 1, Smoke::mf_virtual, 184, 0},	//27 QItemDelegate::qt_metacast(const char*)
    {11, 318, 54, 3, Smoke::mf_virtual, 182, 0},	//28 QItemDelegate::qt_metacall(QMetaObject::Call, int, void**)
    {11, 306, 58, 3, Smoke::mf_const|Smoke::mf_virtual, 0, 0},	//29 QItemDelegate::paint(QPainter*, const QStyleOptionViewItem&, const QModelIndex&) const
    {11, 463, 62, 2, Smoke::mf_const|Smoke::mf_virtual, 25, 0},	//30 QItemDelegate::sizeHint(const QStyleOptionViewItem&, const QModelIndex&) const
    {11, 503, 65, 3, Smoke::mf_const|Smoke::mf_virtual, 0, 0},	//31 QItemDelegate::updateEditorGeometry(QWidget*, const QStyleOptionViewItem&, const QModelIndex&) const
    {11, 180, 69, 4, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//32 QItemDelegate::drawDisplay(QPainter*, const QStyleOptionViewItem&, const QRect&, const QString&) const
    {11, 179, 74, 4, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//33 QItemDelegate::drawDecoration(QPainter*, const QStyleOptionViewItem&, const QRect&, const QPixmap&) const
    {11, 181, 79, 3, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//34 QItemDelegate::drawFocus(QPainter*, const QStyleOptionViewItem&, const QRect&) const
    {11, 178, 83, 4, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//35 QItemDelegate::drawCheck(QPainter*, const QStyleOptionViewItem&, const QRect&, Qt::CheckState) const
    {11, 192, 88, 2, Smoke::mf_protected|Smoke::mf_virtual, 154, 0},	//36 QItemDelegate::eventFilter(QObject*, QEvent*)
    {11, 188, 91, 4, Smoke::mf_protected|Smoke::mf_virtual, 154, 0},	//37 QItemDelegate::editorEvent(QEvent*, QAbstractItemModel*, const QStyleOptionViewItem&, const QModelIndex&)
    {15, 191, 96, 1, Smoke::mf_virtual, 154, 0},	//38 QObject::event(QEvent*)
    {15, 192, 88, 2, Smoke::mf_virtual, 154, 0},	//39 QObject::eventFilter(QObject*, QEvent*)
    {15, 487, 98, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//40 QObject::timerEvent(QTimerEvent*)
    {15, 137, 100, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//41 QObject::childEvent(QChildEvent*)
    {15, 161, 96, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//42 QObject::customEvent(QEvent*)
    {15, 147, 52, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//43 QObject::connectNotify(const char*)
    {15, 176, 52, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//44 QObject::disconnectNotify(const char*)
    {21, 92, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 1},	//45 QSql::Tables (enum)
    {21, 90, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 2},	//46 QSql::SystemTables (enum)
    {21, 101, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 3},	//47 QSql::Views (enum)
    {21, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 4},	//48 QSql::AllTables (enum)
    {21, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 5},	//49 QSql::In (enum)
    {21, 34, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 6},	//50 QSql::Out (enum)
    {21, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 7},	//51 QSql::InOut (enum)
    {21, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 8},	//52 QSql::Binary (enum)
    {21, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 9},	//53 QSql::LowPrecisionInt32 (enum)
    {21, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 10},	//54 QSql::LowPrecisionInt64 (enum)
    {21, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 11},	//55 QSql::LowPrecisionDouble (enum)
    {21, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 12},	//56 QSql::HighPrecision (enum)
    {21, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 13},	//57 QSql::BeforeFirstRow (enum)
    {21, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 14},	//58 QSql::AfterLastRow (enum)
    {22, 38, 0, 0, Smoke::mf_ctor, 32, 1},	//59 QSqlDatabase::QSqlDatabase()
    {22, 38, 102, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 32, 2},	//60 QSqlDatabase::QSqlDatabase(const QSqlDatabase&)
    {22, 299, 102, 1, 0, 31, 3},	//61 QSqlDatabase::operator=(const QSqlDatabase&)
    {22, 288, 0, 0, 0, 154, 4},	//62 QSqlDatabase::open()
    {22, 288, 104, 2, 0, 154, 5},	//63 QSqlDatabase::open(const QString&, const QString&)
    {22, 142, 0, 0, 0, 0, 6},	//64 QSqlDatabase::close()
    {22, 264, 0, 0, Smoke::mf_const, 154, 7},	//65 QSqlDatabase::isOpen() const
    {22, 265, 0, 0, Smoke::mf_const, 154, 8},	//66 QSqlDatabase::isOpenError() const
    {22, 484, 107, 1, Smoke::mf_const, 70, 9},	//67 QSqlDatabase::tables(QSql::TableType) const
    {22, 313, 109, 1, Smoke::mf_const, 48, 10},	//68 QSqlDatabase::primaryIndex(const QString&) const
    {22, 324, 109, 1, Smoke::mf_const, 56, 11},	//69 QSqlDatabase::record(const QString&) const
    {22, 193, 109, 1, Smoke::mf_const, 51, 12},	//70 QSqlDatabase::exec(const QString&) const
    {22, 272, 0, 0, Smoke::mf_const, 40, 13},	//71 QSqlDatabase::lastError() const
    {22, 268, 0, 0, Smoke::mf_const, 154, 14},	//72 QSqlDatabase::isValid() const
    {22, 496, 0, 0, 0, 154, 15},	//73 QSqlDatabase::transaction()
    {22, 145, 0, 0, 0, 154, 16},	//74 QSqlDatabase::commit()
    {22, 352, 0, 0, 0, 154, 17},	//75 QSqlDatabase::rollback()
    {22, 376, 109, 1, 0, 0, 18},	//76 QSqlDatabase::setDatabaseName(const QString&)
    {22, 457, 109, 1, 0, 0, 19},	//77 QSqlDatabase::setUserName(const QString&)
    {22, 425, 109, 1, 0, 0, 20},	//78 QSqlDatabase::setPassword(const QString&)
    {22, 402, 109, 1, 0, 0, 21},	//79 QSqlDatabase::setHostName(const QString&)
    {22, 427, 111, 1, 0, 0, 22},	//80 QSqlDatabase::setPort(int)
    {22, 369, 109, 1, 0, 0, 23},	//81 QSqlDatabase::setConnectOptions(const QString&)
    {22, 169, 0, 0, Smoke::mf_const, 69, 24},	//82 QSqlDatabase::databaseName() const
    {22, 506, 0, 0, Smoke::mf_const, 69, 25},	//83 QSqlDatabase::userName() const
    {22, 307, 0, 0, Smoke::mf_const, 69, 26},	//84 QSqlDatabase::password() const
    {22, 227, 0, 0, Smoke::mf_const, 69, 27},	//85 QSqlDatabase::hostName() const
    {22, 183, 0, 0, Smoke::mf_const, 69, 28},	//86 QSqlDatabase::driverName() const
    {22, 308, 0, 0, Smoke::mf_const, 182, 29},	//87 QSqlDatabase::port() const
    {22, 148, 0, 0, Smoke::mf_const, 69, 30},	//88 QSqlDatabase::connectOptions() const
    {22, 149, 0, 0, Smoke::mf_const, 69, 31},	//89 QSqlDatabase::connectionName() const
    {22, 419, 113, 1, 0, 0, 32},	//90 QSqlDatabase::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
    {22, 287, 0, 0, Smoke::mf_const, 27, 33},	//91 QSqlDatabase::numericalPrecisionPolicy() const
    {22, 182, 0, 0, Smoke::mf_const, 33, 34},	//92 QSqlDatabase::driver() const
    {22, 106, 104, 2, Smoke::mf_static, 30, 35},	//93 QSqlDatabase::addDatabase(const QString&, const QString&)
    {22, 106, 115, 2, Smoke::mf_static, 30, 36},	//94 QSqlDatabase::addDatabase(QSqlDriver*, const QString&)
    {22, 140, 118, 2, Smoke::mf_static, 30, 37},	//95 QSqlDatabase::cloneDatabase(const QSqlDatabase&, const QString&)
    {22, 166, 121, 2, Smoke::mf_static, 30, 38},	//96 QSqlDatabase::database(const QString&, bool)
    {22, 337, 109, 1, Smoke::mf_static, 0, 39},	//97 QSqlDatabase::removeDatabase(const QString&)
    {22, 151, 109, 1, Smoke::mf_static, 154, 40},	//98 QSqlDatabase::contains(const QString&)
    {22, 185, 0, 0, Smoke::mf_static, 70, 41},	//99 QSqlDatabase::drivers()
    {22, 150, 0, 0, Smoke::mf_static, 70, 42},	//100 QSqlDatabase::connectionNames()
    {22, 326, 124, 2, Smoke::mf_static, 0, 43},	//101 QSqlDatabase::registerSqlDriver(const QString&, QSqlDriverCreatorBase*)
    {22, 252, 109, 1, Smoke::mf_static, 154, 44},	//102 QSqlDatabase::isDriverAvailable(const QString&)
    {22, 38, 109, 1, Smoke::mf_ctor|Smoke::mf_protected, 32, 45},	//103 QSqlDatabase::QSqlDatabase(const QString&)
    {22, 38, 127, 1, Smoke::mf_ctor|Smoke::mf_protected, 32, 46},	//104 QSqlDatabase::QSqlDatabase(QSqlDriver*)
    {22, 484, 0, 0, Smoke::mf_const, 70, 47},	//105 QSqlDatabase::tables() const
    {22, 193, 0, 0, Smoke::mf_const, 51, 48},	//106 QSqlDatabase::exec() const
    {22, 369, 0, 0, 0, 0, 49},	//107 QSqlDatabase::setConnectOptions()
    {22, 106, 109, 1, Smoke::mf_static, 30, 50},	//108 QSqlDatabase::addDatabase(const QString&)
    {22, 106, 127, 1, Smoke::mf_static, 30, 51},	//109 QSqlDatabase::addDatabase(QSqlDriver*)
    {22, 166, 0, 0, Smoke::mf_static, 30, 52},	//110 QSqlDatabase::database()
    {22, 166, 109, 1, Smoke::mf_static, 30, 53},	//111 QSqlDatabase::database(const QString&)
    {22, 151, 0, 0, Smoke::mf_static, 154, 54},	//112 QSqlDatabase::contains()
    {22, 171, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 180, 55},	//113 QSqlDatabase::defaultConnection() const
    {22, 380, 52, 1, Smoke::mf_static|Smoke::mf_attribute, 0, 56},	//114 QSqlDatabase::setDefaultConnection(const char*)
    {22, 511, 0, 0, Smoke::mf_dtor, 0, 57 },	//115 QSqlDatabase::~QSqlDatabase()
    {23, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 159, 1},	//116 QSqlDriver::metaObject() const
    {23, 320, 52, 1, Smoke::mf_virtual, 184, 2},	//117 QSqlDriver::qt_metacast(const char*)
    {23, 488, 129, 2, Smoke::mf_static, 69, 3},	//118 QSqlDriver::tr(const char*, const char*)
    {23, 492, 129, 2, Smoke::mf_static, 69, 4},	//119 QSqlDriver::trUtf8(const char*, const char*)
    {23, 488, 132, 3, Smoke::mf_static, 69, 5},	//120 QSqlDriver::tr(const char*, const char*, int)
    {23, 492, 132, 3, Smoke::mf_static, 69, 6},	//121 QSqlDriver::trUtf8(const char*, const char*, int)
    {23, 318, 54, 3, Smoke::mf_virtual, 182, 7},	//122 QSqlDriver::qt_metacall(QMetaObject::Call, int, void**)
    {23, 41, 136, 1, Smoke::mf_ctor, 33, 8},	//123 QSqlDriver::QSqlDriver(QObject*)
    {23, 264, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 154, 9},	//124 QSqlDriver::isOpen() const
    {23, 265, 0, 0, Smoke::mf_const, 154, 10},	//125 QSqlDriver::isOpenError() const
    {23, 121, 0, 0, Smoke::mf_virtual, 154, 11},	//126 QSqlDriver::beginTransaction()
    {23, 146, 0, 0, Smoke::mf_virtual, 154, 12},	//127 QSqlDriver::commitTransaction()
    {23, 353, 0, 0, Smoke::mf_virtual, 154, 13},	//128 QSqlDriver::rollbackTransaction()
    {23, 484, 107, 1, Smoke::mf_const|Smoke::mf_virtual, 70, 14},	//129 QSqlDriver::tables(QSql::TableType) const
    {23, 313, 109, 1, Smoke::mf_const|Smoke::mf_virtual, 48, 15},	//130 QSqlDriver::primaryIndex(const QString&) const
    {23, 324, 109, 1, Smoke::mf_const|Smoke::mf_virtual, 56, 16},	//131 QSqlDriver::record(const QString&) const
    {23, 217, 138, 2, Smoke::mf_const|Smoke::mf_virtual, 69, 17},	//132 QSqlDriver::formatValue(const QSqlField&, bool) const
    {23, 189, 141, 2, Smoke::mf_const|Smoke::mf_virtual, 69, 18},	//133 QSqlDriver::escapeIdentifier(const QString&, QSqlDriver::IdentifierType) const
    {23, 467, 144, 4, Smoke::mf_const|Smoke::mf_virtual, 69, 19},	//134 QSqlDriver::sqlStatement(QSqlDriver::StatementType, const QString&, const QSqlRecord&, bool) const
    {23, 272, 0, 0, Smoke::mf_const, 40, 20},	//135 QSqlDriver::lastError() const
    {23, 220, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 74, 21},	//136 QSqlDriver::handle() const
    {23, 221, 149, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 154, 22},	//137 QSqlDriver::hasFeature(QSqlDriver::DriverFeature) const [pure virtual]
    {23, 142, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 23},	//138 QSqlDriver::close() [pure virtual]
    {23, 159, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 64, 24},	//139 QSqlDriver::createResult() const [pure virtual]
    {23, 288, 151, 6, Smoke::mf_virtual|Smoke::mf_purevirtual, 154, 25},	//140 QSqlDriver::open(const QString&, const QString&, const QString&, const QString&, int, const QString&) [pure virtual]
    {23, 476, 109, 1, 0, 154, 26},	//141 QSqlDriver::subscribeToNotification(const QString&)
    {23, 499, 109, 1, 0, 154, 27},	//142 QSqlDriver::unsubscribeFromNotification(const QString&)
    {23, 480, 0, 0, Smoke::mf_const, 70, 28},	//143 QSqlDriver::subscribedToNotifications() const
    {23, 258, 141, 2, Smoke::mf_const, 154, 29},	//144 QSqlDriver::isIdentifierEscaped(const QString&, QSqlDriver::IdentifierType) const
    {23, 470, 141, 2, Smoke::mf_const, 69, 30},	//145 QSqlDriver::stripDelimiters(const QString&, QSqlDriver::IdentifierType) const
    {23, 419, 113, 1, 0, 0, 31},	//146 QSqlDriver::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
    {23, 287, 0, 0, Smoke::mf_const, 27, 32},	//147 QSqlDriver::numericalPrecisionPolicy() const
    {23, 283, 109, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 33},	//148 QSqlDriver::notification(const QString&)
    {23, 421, 158, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 34},	//149 QSqlDriver::setOpen(bool)
    {23, 423, 158, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 35},	//150 QSqlDriver::setOpenError(bool)
    {23, 407, 160, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 36},	//151 QSqlDriver::setLastError(const QSqlError&)
    {23, 478, 109, 1, Smoke::mf_protected|Smoke::mf_slot, 154, 37},	//152 QSqlDriver::subscribeToNotificationImplementation(const QString&)
    {23, 501, 109, 1, Smoke::mf_protected|Smoke::mf_slot, 154, 38},	//153 QSqlDriver::unsubscribeFromNotificationImplementation(const QString&)
    {23, 481, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_slot, 70, 39},	//154 QSqlDriver::subscribedToNotificationsImplementation() const
    {23, 260, 141, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_slot, 154, 40},	//155 QSqlDriver::isIdentifierEscapedImplementation(const QString&, QSqlDriver::IdentifierType) const
    {23, 472, 141, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_slot, 69, 41},	//156 QSqlDriver::stripDelimitersImplementation(const QString&, QSqlDriver::IdentifierType) const
    {23, 488, 52, 1, Smoke::mf_static, 69, 42},	//157 QSqlDriver::tr(const char*)
    {23, 492, 52, 1, Smoke::mf_static, 69, 43},	//158 QSqlDriver::trUtf8(const char*)
    {23, 41, 0, 0, Smoke::mf_ctor, 33, 44},	//159 QSqlDriver::QSqlDriver()
    {23, 217, 162, 1, Smoke::mf_const, 69, 45},	//160 QSqlDriver::formatValue(const QSqlField&) const
    {23, 288, 109, 1, 0, 154, 46},	//161 QSqlDriver::open(const QString&)
    {23, 288, 104, 2, 0, 154, 47},	//162 QSqlDriver::open(const QString&, const QString&)
    {23, 288, 164, 3, 0, 154, 48},	//163 QSqlDriver::open(const QString&, const QString&, const QString&)
    {23, 288, 168, 4, 0, 154, 49},	//164 QSqlDriver::open(const QString&, const QString&, const QString&, const QString&)
    {23, 288, 173, 5, 0, 154, 50},	//165 QSqlDriver::open(const QString&, const QString&, const QString&, const QString&, int)
    {23, 469, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 158, 51},	//166 QSqlDriver::staticMetaObject() const
    {23, 94, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 52},	//167 QSqlDriver::Transactions (enum)
    {23, 84, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 53},	//168 QSqlDriver::QuerySize (enum)
    {23, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 54},	//169 QSqlDriver::BLOB (enum)
    {23, 95, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 55},	//170 QSqlDriver::Unicode (enum)
    {23, 37, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 56},	//171 QSqlDriver::PreparedQueries (enum)
    {23, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 57},	//172 QSqlDriver::NamedPlaceholders (enum)
    {23, 36, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 58},	//173 QSqlDriver::PositionalPlaceholders (enum)
    {23, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 59},	//174 QSqlDriver::LastInsertId (enum)
    {23, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 60},	//175 QSqlDriver::BatchOperations (enum)
    {23, 88, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 61},	//176 QSqlDriver::SimpleLocking (enum)
    {23, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 62},	//177 QSqlDriver::LowPrecisionNumbers (enum)
    {23, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 63},	//178 QSqlDriver::EventNotifications (enum)
    {23, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 64},	//179 QSqlDriver::FinishQuery (enum)
    {23, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 65},	//180 QSqlDriver::MultipleResultSets (enum)
    {23, 102, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 66},	//181 QSqlDriver::WhereStatement (enum)
    {23, 86, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 67},	//182 QSqlDriver::SelectStatement (enum)
    {23, 98, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 68},	//183 QSqlDriver::UpdateStatement (enum)
    {23, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 69},	//184 QSqlDriver::InsertStatement (enum)
    {23, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 70},	//185 QSqlDriver::DeleteStatement (enum)
    {23, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 35, 71},	//186 QSqlDriver::FieldName (enum)
    {23, 91, 0, 0, Smoke::mf_static|Smoke::mf_enum, 35, 72},	//187 QSqlDriver::TableName (enum)
    {23, 512, 0, 0, Smoke::mf_dtor, 0, 73 },	//188 QSqlDriver::~QSqlDriver()
    {24, 158, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 33, 1},	//189 QSqlDriverCreatorBase::createObject() const [pure virtual]
    {24, 43, 0, 0, Smoke::mf_ctor, 37, 2},	//190 QSqlDriverCreatorBase::QSqlDriverCreatorBase()
    {24, 43, 179, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 37, 3},	//191 QSqlDriverCreatorBase::QSqlDriverCreatorBase(const QSqlDriverCreatorBase&)
    {24, 513, 0, 0, Smoke::mf_dtor, 0, 4 },	//192 QSqlDriverCreatorBase::~QSqlDriverCreatorBase()
    {25, 154, 109, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 33, 1},	//193 QSqlDriverFactoryInterface::create(const QString&) [pure virtual]
    {25, 45, 0, 0, Smoke::mf_ctor, 38, 2},	//194 QSqlDriverFactoryInterface::QSqlDriverFactoryInterface()
    {25, 45, 181, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 38, 3},	//195 QSqlDriverFactoryInterface::QSqlDriverFactoryInterface(const QSqlDriverFactoryInterface&)
    {25, 514, 0, 0, Smoke::mf_dtor, 0, 4 },	//196 QSqlDriverFactoryInterface::~QSqlDriverFactoryInterface()
    {26, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 159, 1},	//197 QSqlDriverPlugin::metaObject() const
    {26, 320, 52, 1, Smoke::mf_virtual, 184, 2},	//198 QSqlDriverPlugin::qt_metacast(const char*)
    {26, 488, 129, 2, Smoke::mf_static, 69, 3},	//199 QSqlDriverPlugin::tr(const char*, const char*)
    {26, 492, 129, 2, Smoke::mf_static, 69, 4},	//200 QSqlDriverPlugin::trUtf8(const char*, const char*)
    {26, 488, 132, 3, Smoke::mf_static, 69, 5},	//201 QSqlDriverPlugin::tr(const char*, const char*, int)
    {26, 492, 132, 3, Smoke::mf_static, 69, 6},	//202 QSqlDriverPlugin::trUtf8(const char*, const char*, int)
    {26, 318, 54, 3, Smoke::mf_virtual, 182, 7},	//203 QSqlDriverPlugin::qt_metacall(QMetaObject::Call, int, void**)
    {26, 47, 136, 1, Smoke::mf_ctor, 39, 8},	//204 QSqlDriverPlugin::QSqlDriverPlugin(QObject*)
    {26, 270, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 70, 9},	//205 QSqlDriverPlugin::keys() const [pure virtual]
    {26, 154, 109, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 33, 10},	//206 QSqlDriverPlugin::create(const QString&) [pure virtual]
    {26, 488, 52, 1, Smoke::mf_static, 69, 11},	//207 QSqlDriverPlugin::tr(const char*)
    {26, 492, 52, 1, Smoke::mf_static, 69, 12},	//208 QSqlDriverPlugin::trUtf8(const char*)
    {26, 47, 0, 0, Smoke::mf_ctor, 39, 13},	//209 QSqlDriverPlugin::QSqlDriverPlugin()
    {26, 469, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 158, 14},	//210 QSqlDriverPlugin::staticMetaObject() const
    {26, 515, 0, 0, Smoke::mf_dtor, 0, 15 },	//211 QSqlDriverPlugin::~QSqlDriverPlugin()
    {27, 49, 183, 4, Smoke::mf_ctor, 42, 1},	//212 QSqlError::QSqlError(const QString&, const QString&, QSqlError::ErrorType, int)
    {27, 49, 160, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 42, 2},	//213 QSqlError::QSqlError(const QSqlError&)
    {27, 299, 160, 1, 0, 41, 3},	//214 QSqlError::operator=(const QSqlError&)
    {27, 184, 0, 0, Smoke::mf_const, 69, 4},	//215 QSqlError::driverText() const
    {27, 386, 109, 1, 0, 0, 5},	//216 QSqlError::setDriverText(const QString&)
    {27, 170, 0, 0, Smoke::mf_const, 69, 6},	//217 QSqlError::databaseText() const
    {27, 378, 109, 1, 0, 0, 7},	//218 QSqlError::setDatabaseText(const QString&)
    {27, 497, 0, 0, Smoke::mf_const, 43, 8},	//219 QSqlError::type() const
    {27, 455, 188, 1, 0, 0, 9},	//220 QSqlError::setType(QSqlError::ErrorType)
    {27, 286, 0, 0, Smoke::mf_const, 182, 10},	//221 QSqlError::number() const
    {27, 417, 111, 1, 0, 0, 11},	//222 QSqlError::setNumber(int)
    {27, 486, 0, 0, Smoke::mf_const, 69, 12},	//223 QSqlError::text() const
    {27, 268, 0, 0, Smoke::mf_const, 154, 13},	//224 QSqlError::isValid() const
    {27, 49, 0, 0, Smoke::mf_ctor, 42, 14},	//225 QSqlError::QSqlError()
    {27, 49, 109, 1, Smoke::mf_ctor, 42, 15},	//226 QSqlError::QSqlError(const QString&)
    {27, 49, 104, 2, Smoke::mf_ctor, 42, 16},	//227 QSqlError::QSqlError(const QString&, const QString&)
    {27, 49, 190, 3, Smoke::mf_ctor, 42, 17},	//228 QSqlError::QSqlError(const QString&, const QString&, QSqlError::ErrorType)
    {27, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 18},	//229 QSqlError::NoError (enum)
    {27, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 19},	//230 QSqlError::ConnectionError (enum)
    {27, 89, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 20},	//231 QSqlError::StatementError (enum)
    {27, 93, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 21},	//232 QSqlError::TransactionError (enum)
    {27, 97, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 22},	//233 QSqlError::UnknownError (enum)
    {27, 516, 0, 0, Smoke::mf_dtor, 0, 23 },	//234 QSqlError::~QSqlError()
    {28, 55, 194, 2, Smoke::mf_ctor, 46, 1},	//235 QSqlField::QSqlField(const QString&, QVariant::Type)
    {28, 55, 162, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 46, 2},	//236 QSqlField::QSqlField(const QSqlField&)
    {28, 299, 162, 1, 0, 45, 3},	//237 QSqlField::operator=(const QSqlField&)
    {28, 301, 162, 1, Smoke::mf_const, 154, 4},	//238 QSqlField::operator==(const QSqlField&) const
    {28, 295, 162, 1, Smoke::mf_const, 154, 5},	//239 QSqlField::operator!=(const QSqlField&) const
    {28, 459, 197, 1, 0, 0, 6},	//240 QSqlField::setValue(const QVariant&)
    {28, 507, 0, 0, Smoke::mf_const, 74, 7},	//241 QSqlField::value() const
    {28, 413, 109, 1, 0, 0, 8},	//242 QSqlField::setName(const QString&)
    {28, 280, 0, 0, Smoke::mf_const, 69, 9},	//243 QSqlField::name() const
    {28, 262, 0, 0, Smoke::mf_const, 154, 10},	//244 QSqlField::isNull() const
    {28, 437, 158, 1, 0, 0, 11},	//245 QSqlField::setReadOnly(bool)
    {28, 266, 0, 0, Smoke::mf_const, 154, 12},	//246 QSqlField::isReadOnly() const
    {28, 138, 0, 0, 0, 0, 13},	//247 QSqlField::clear()
    {28, 497, 0, 0, Smoke::mf_const, 75, 14},	//248 QSqlField::type() const
    {28, 247, 0, 0, Smoke::mf_const, 154, 15},	//249 QSqlField::isAutoValue() const
    {28, 455, 199, 1, 0, 0, 16},	//250 QSqlField::setType(QVariant::Type)
    {28, 445, 201, 1, 0, 0, 17},	//251 QSqlField::setRequiredStatus(QSqlField::RequiredStatus)
    {28, 443, 158, 1, 0, 0, 18},	//252 QSqlField::setRequired(bool)
    {28, 409, 111, 1, 0, 0, 19},	//253 QSqlField::setLength(int)
    {28, 429, 111, 1, 0, 0, 20},	//254 QSqlField::setPrecision(int)
    {28, 382, 197, 1, 0, 0, 21},	//255 QSqlField::setDefaultValue(const QVariant&)
    {28, 451, 111, 1, 0, 0, 22},	//256 QSqlField::setSqlType(int)
    {28, 396, 158, 1, 0, 0, 23},	//257 QSqlField::setGenerated(bool)
    {28, 367, 158, 1, 0, 0, 24},	//258 QSqlField::setAutoValue(bool)
    {28, 344, 0, 0, Smoke::mf_const, 47, 25},	//259 QSqlField::requiredStatus() const
    {28, 275, 0, 0, Smoke::mf_const, 182, 26},	//260 QSqlField::length() const
    {28, 309, 0, 0, Smoke::mf_const, 182, 27},	//261 QSqlField::precision() const
    {28, 172, 0, 0, Smoke::mf_const, 74, 28},	//262 QSqlField::defaultValue() const
    {28, 498, 0, 0, Smoke::mf_const, 182, 29},	//263 QSqlField::typeID() const
    {28, 256, 0, 0, Smoke::mf_const, 154, 30},	//264 QSqlField::isGenerated() const
    {28, 268, 0, 0, Smoke::mf_const, 154, 31},	//265 QSqlField::isValid() const
    {28, 55, 0, 0, Smoke::mf_ctor, 46, 32},	//266 QSqlField::QSqlField()
    {28, 55, 109, 1, Smoke::mf_ctor, 46, 33},	//267 QSqlField::QSqlField(const QString&)
    {28, 96, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 34},	//268 QSqlField::Unknown (enum)
    {28, 33, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 35},	//269 QSqlField::Optional (enum)
    {28, 85, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 36},	//270 QSqlField::Required (enum)
    {28, 517, 0, 0, Smoke::mf_dtor, 0, 37 },	//271 QSqlField::~QSqlField()
    {29, 59, 104, 2, Smoke::mf_ctor, 50, 1},	//272 QSqlIndex::QSqlIndex(const QString&, const QString&)
    {29, 59, 203, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 50, 2},	//273 QSqlIndex::QSqlIndex(const QSqlIndex&)
    {29, 299, 203, 1, 0, 49, 3},	//274 QSqlIndex::operator=(const QSqlIndex&)
    {29, 371, 109, 1, 0, 0, 4},	//275 QSqlIndex::setCursorName(const QString&)
    {29, 160, 0, 0, Smoke::mf_const, 69, 5},	//276 QSqlIndex::cursorName() const
    {29, 413, 109, 1, 0, 0, 6},	//277 QSqlIndex::setName(const QString&)
    {29, 280, 0, 0, Smoke::mf_const, 69, 7},	//278 QSqlIndex::name() const
    {29, 111, 162, 1, 0, 0, 8},	//279 QSqlIndex::append(const QSqlField&)
    {29, 111, 138, 2, 0, 0, 9},	//280 QSqlIndex::append(const QSqlField&, bool)
    {29, 248, 111, 1, Smoke::mf_const, 154, 10},	//281 QSqlIndex::isDescending(int) const
    {29, 384, 205, 2, 0, 0, 11},	//282 QSqlIndex::setDescending(int, bool)
    {29, 59, 0, 0, Smoke::mf_ctor, 50, 12},	//283 QSqlIndex::QSqlIndex()
    {29, 59, 109, 1, Smoke::mf_ctor, 50, 13},	//284 QSqlIndex::QSqlIndex(const QString&)
    {29, 518, 0, 0, Smoke::mf_dtor, 0, 14 },	//285 QSqlIndex::~QSqlIndex()
    {30, 63, 208, 1, Smoke::mf_ctor, 53, 1},	//286 QSqlQuery::QSqlQuery(QSqlResult*)
    {30, 63, 210, 2, Smoke::mf_ctor, 53, 2},	//287 QSqlQuery::QSqlQuery(const QString&, QSqlDatabase)
    {30, 63, 213, 1, Smoke::mf_ctor, 53, 3},	//288 QSqlQuery::QSqlQuery(QSqlDatabase)
    {30, 63, 215, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 53, 4},	//289 QSqlQuery::QSqlQuery(const QSqlQuery&)
    {30, 299, 215, 1, 0, 52, 5},	//290 QSqlQuery::operator=(const QSqlQuery&)
    {30, 268, 0, 0, Smoke::mf_const, 154, 6},	//291 QSqlQuery::isValid() const
    {30, 246, 0, 0, Smoke::mf_const, 154, 7},	//292 QSqlQuery::isActive() const
    {30, 262, 111, 1, Smoke::mf_const, 154, 8},	//293 QSqlQuery::isNull(int) const
    {30, 114, 0, 0, Smoke::mf_const, 182, 9},	//294 QSqlQuery::at() const
    {30, 274, 0, 0, Smoke::mf_const, 69, 10},	//295 QSqlQuery::lastQuery() const
    {30, 285, 0, 0, Smoke::mf_const, 182, 11},	//296 QSqlQuery::numRowsAffected() const
    {30, 272, 0, 0, Smoke::mf_const, 40, 12},	//297 QSqlQuery::lastError() const
    {30, 267, 0, 0, Smoke::mf_const, 154, 13},	//298 QSqlQuery::isSelect() const
    {30, 462, 0, 0, Smoke::mf_const, 182, 14},	//299 QSqlQuery::size() const
    {30, 182, 0, 0, Smoke::mf_const, 166, 15},	//300 QSqlQuery::driver() const
    {30, 347, 0, 0, Smoke::mf_const, 175, 16},	//301 QSqlQuery::result() const
    {30, 255, 0, 0, Smoke::mf_const, 154, 17},	//302 QSqlQuery::isForwardOnly() const
    {30, 324, 0, 0, Smoke::mf_const, 56, 18},	//303 QSqlQuery::record() const
    {30, 394, 158, 1, 0, 0, 19},	//304 QSqlQuery::setForwardOnly(bool)
    {30, 193, 109, 1, 0, 154, 20},	//305 QSqlQuery::exec(const QString&)
    {30, 507, 111, 1, Smoke::mf_const, 74, 21},	//306 QSqlQuery::value(int) const
    {30, 419, 113, 1, 0, 0, 22},	//307 QSqlQuery::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
    {30, 287, 0, 0, Smoke::mf_const, 27, 23},	//308 QSqlQuery::numericalPrecisionPolicy() const
    {30, 358, 205, 2, 0, 154, 24},	//309 QSqlQuery::seek(int, bool)
    {30, 281, 0, 0, 0, 154, 25},	//310 QSqlQuery::next()
    {30, 312, 0, 0, 0, 154, 26},	//311 QSqlQuery::previous()
    {30, 214, 0, 0, 0, 154, 27},	//312 QSqlQuery::first()
    {30, 271, 0, 0, 0, 154, 28},	//313 QSqlQuery::last()
    {30, 138, 0, 0, 0, 0, 29},	//314 QSqlQuery::clear()
    {30, 193, 0, 0, 0, 154, 30},	//315 QSqlQuery::exec()
    {30, 195, 217, 1, 0, 154, 31},	//316 QSqlQuery::execBatch(QSqlQuery::BatchExecutionMode)
    {30, 310, 109, 1, 0, 154, 32},	//317 QSqlQuery::prepare(const QString&)
    {30, 122, 219, 3, 0, 0, 33},	//318 QSqlQuery::bindValue(const QString&, const QVariant&, QFlags<QSql::ParamTypeFlag>)
    {30, 122, 223, 3, 0, 0, 34},	//319 QSqlQuery::bindValue(int, const QVariant&, QFlags<QSql::ParamTypeFlag>)
    {30, 103, 227, 2, 0, 0, 35},	//320 QSqlQuery::addBindValue(const QVariant&, QFlags<QSql::ParamTypeFlag>)
    {30, 128, 109, 1, Smoke::mf_const, 74, 36},	//321 QSqlQuery::boundValue(const QString&) const
    {30, 128, 111, 1, Smoke::mf_const, 74, 37},	//322 QSqlQuery::boundValue(int) const
    {30, 133, 0, 0, Smoke::mf_const, 17, 38},	//323 QSqlQuery::boundValues() const
    {30, 197, 0, 0, Smoke::mf_const, 69, 39},	//324 QSqlQuery::executedQuery() const
    {30, 273, 0, 0, Smoke::mf_const, 74, 40},	//325 QSqlQuery::lastInsertId() const
    {30, 213, 0, 0, 0, 0, 41},	//326 QSqlQuery::finish()
    {30, 282, 0, 0, 0, 154, 42},	//327 QSqlQuery::nextResult()
    {30, 63, 0, 0, Smoke::mf_ctor, 53, 43},	//328 QSqlQuery::QSqlQuery()
    {30, 63, 109, 1, Smoke::mf_ctor, 53, 44},	//329 QSqlQuery::QSqlQuery(const QString&)
    {30, 358, 111, 1, 0, 154, 45},	//330 QSqlQuery::seek(int)
    {30, 195, 0, 0, 0, 154, 46},	//331 QSqlQuery::execBatch()
    {30, 122, 230, 2, 0, 0, 47},	//332 QSqlQuery::bindValue(const QString&, const QVariant&)
    {30, 122, 233, 2, 0, 0, 48},	//333 QSqlQuery::bindValue(int, const QVariant&)
    {30, 103, 197, 1, 0, 0, 49},	//334 QSqlQuery::addBindValue(const QVariant&)
    {30, 100, 0, 0, Smoke::mf_static|Smoke::mf_enum, 54, 50},	//335 QSqlQuery::ValuesAsRows (enum)
    {30, 99, 0, 0, Smoke::mf_static|Smoke::mf_enum, 54, 51},	//336 QSqlQuery::ValuesAsColumns (enum)
    {30, 519, 0, 0, Smoke::mf_dtor, 0, 52 },	//337 QSqlQuery::~QSqlQuery()
    {31, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 159, 1},	//338 QSqlQueryModel::metaObject() const
    {31, 320, 52, 1, Smoke::mf_virtual, 184, 2},	//339 QSqlQueryModel::qt_metacast(const char*)
    {31, 488, 129, 2, Smoke::mf_static, 69, 3},	//340 QSqlQueryModel::tr(const char*, const char*)
    {31, 492, 129, 2, Smoke::mf_static, 69, 4},	//341 QSqlQueryModel::trUtf8(const char*, const char*)
    {31, 488, 132, 3, Smoke::mf_static, 69, 5},	//342 QSqlQueryModel::tr(const char*, const char*, int)
    {31, 492, 132, 3, Smoke::mf_static, 69, 6},	//343 QSqlQueryModel::trUtf8(const char*, const char*, int)
    {31, 318, 54, 3, Smoke::mf_virtual, 182, 7},	//344 QSqlQueryModel::qt_metacall(QMetaObject::Call, int, void**)
    {31, 67, 136, 1, Smoke::mf_ctor, 55, 8},	//345 QSqlQueryModel::QSqlQueryModel(QObject*)
    {31, 354, 5, 1, Smoke::mf_const|Smoke::mf_virtual, 182, 9},	//346 QSqlQueryModel::rowCount(const QModelIndex&) const
    {31, 143, 5, 1, Smoke::mf_const|Smoke::mf_virtual, 182, 10},	//347 QSqlQueryModel::columnCount(const QModelIndex&) const
    {31, 324, 111, 1, Smoke::mf_const, 56, 11},	//348 QSqlQueryModel::record(int) const
    {31, 324, 0, 0, Smoke::mf_const, 56, 12},	//349 QSqlQueryModel::record() const
    {31, 162, 236, 2, Smoke::mf_const|Smoke::mf_virtual, 74, 13},	//350 QSqlQueryModel::data(const QModelIndex&, int) const
    {31, 224, 239, 3, Smoke::mf_const|Smoke::mf_virtual, 74, 14},	//351 QSqlQueryModel::headerData(int, Qt::Orientation, int) const
    {31, 399, 243, 4, Smoke::mf_virtual, 154, 15},	//352 QSqlQueryModel::setHeaderData(int, Qt::Orientation, const QVariant&, int)
    {31, 236, 12, 3, Smoke::mf_virtual, 154, 16},	//353 QSqlQueryModel::insertColumns(int, int, const QModelIndex&)
    {31, 334, 12, 3, Smoke::mf_virtual, 154, 17},	//354 QSqlQueryModel::removeColumns(int, int, const QModelIndex&)
    {31, 433, 215, 1, 0, 0, 18},	//355 QSqlQueryModel::setQuery(const QSqlQuery&)
    {31, 433, 248, 2, 0, 0, 19},	//356 QSqlQueryModel::setQuery(const QString&, const QSqlDatabase&)
    {31, 322, 0, 0, Smoke::mf_const, 51, 20},	//357 QSqlQueryModel::query() const
    {31, 138, 0, 0, Smoke::mf_virtual, 0, 21},	//358 QSqlQueryModel::clear()
    {31, 272, 0, 0, Smoke::mf_const, 40, 22},	//359 QSqlQueryModel::lastError() const
    {31, 202, 5, 1, Smoke::mf_virtual, 0, 23},	//360 QSqlQueryModel::fetchMore(const QModelIndex&)
    {31, 135, 5, 1, Smoke::mf_const|Smoke::mf_virtual, 154, 24},	//361 QSqlQueryModel::canFetchMore(const QModelIndex&) const
    {31, 323, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 25},	//362 QSqlQueryModel::queryChange()
    {31, 230, 5, 1, Smoke::mf_const|Smoke::mf_protected, 21, 26},	//363 QSqlQueryModel::indexInQuery(const QModelIndex&) const
    {31, 407, 160, 1, Smoke::mf_protected, 0, 27},	//364 QSqlQueryModel::setLastError(const QSqlError&)
    {31, 488, 52, 1, Smoke::mf_static, 69, 28},	//365 QSqlQueryModel::tr(const char*)
    {31, 492, 52, 1, Smoke::mf_static, 69, 29},	//366 QSqlQueryModel::trUtf8(const char*)
    {31, 67, 0, 0, Smoke::mf_ctor, 55, 30},	//367 QSqlQueryModel::QSqlQueryModel()
    {31, 354, 0, 0, Smoke::mf_const, 182, 31},	//368 QSqlQueryModel::rowCount() const
    {31, 143, 0, 0, Smoke::mf_const, 182, 32},	//369 QSqlQueryModel::columnCount() const
    {31, 162, 5, 1, Smoke::mf_const, 74, 33},	//370 QSqlQueryModel::data(const QModelIndex&) const
    {31, 224, 251, 2, Smoke::mf_const, 74, 34},	//371 QSqlQueryModel::headerData(int, Qt::Orientation) const
    {31, 399, 254, 3, 0, 154, 35},	//372 QSqlQueryModel::setHeaderData(int, Qt::Orientation, const QVariant&)
    {31, 236, 258, 2, 0, 154, 36},	//373 QSqlQueryModel::insertColumns(int, int)
    {31, 334, 258, 2, 0, 154, 37},	//374 QSqlQueryModel::removeColumns(int, int)
    {31, 433, 109, 1, 0, 0, 38},	//375 QSqlQueryModel::setQuery(const QString&)
    {31, 202, 0, 0, 0, 0, 39},	//376 QSqlQueryModel::fetchMore()
    {31, 135, 0, 0, Smoke::mf_const, 154, 40},	//377 QSqlQueryModel::canFetchMore() const
    {31, 469, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 158, 41},	//378 QSqlQueryModel::staticMetaObject() const
    {31, 520, 0, 0, Smoke::mf_dtor, 0, 42 },	//379 QSqlQueryModel::~QSqlQueryModel()
    {32, 69, 0, 0, Smoke::mf_ctor, 58, 1},	//380 QSqlRecord::QSqlRecord()
    {32, 69, 261, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 58, 2},	//381 QSqlRecord::QSqlRecord(const QSqlRecord&)
    {32, 299, 261, 1, 0, 57, 3},	//382 QSqlRecord::operator=(const QSqlRecord&)
    {32, 301, 261, 1, Smoke::mf_const, 154, 4},	//383 QSqlRecord::operator==(const QSqlRecord&) const
    {32, 295, 261, 1, Smoke::mf_const, 154, 5},	//384 QSqlRecord::operator!=(const QSqlRecord&) const
    {32, 507, 111, 1, Smoke::mf_const, 74, 6},	//385 QSqlRecord::value(int) const
    {32, 507, 109, 1, Smoke::mf_const, 74, 7},	//386 QSqlRecord::value(const QString&) const
    {32, 459, 233, 2, 0, 0, 8},	//387 QSqlRecord::setValue(int, const QVariant&)
    {32, 459, 230, 2, 0, 0, 9},	//388 QSqlRecord::setValue(const QString&, const QVariant&)
    {32, 415, 111, 1, 0, 0, 10},	//389 QSqlRecord::setNull(int)
    {32, 415, 109, 1, 0, 0, 11},	//390 QSqlRecord::setNull(const QString&)
    {32, 262, 111, 1, Smoke::mf_const, 154, 12},	//391 QSqlRecord::isNull(int) const
    {32, 262, 109, 1, Smoke::mf_const, 154, 13},	//392 QSqlRecord::isNull(const QString&) const
    {32, 232, 109, 1, Smoke::mf_const, 182, 14},	//393 QSqlRecord::indexOf(const QString&) const
    {32, 210, 111, 1, Smoke::mf_const, 69, 15},	//394 QSqlRecord::fieldName(int) const
    {32, 206, 111, 1, Smoke::mf_const, 44, 16},	//395 QSqlRecord::field(int) const
    {32, 206, 109, 1, Smoke::mf_const, 44, 17},	//396 QSqlRecord::field(const QString&) const
    {32, 256, 111, 1, Smoke::mf_const, 154, 18},	//397 QSqlRecord::isGenerated(int) const
    {32, 256, 109, 1, Smoke::mf_const, 154, 19},	//398 QSqlRecord::isGenerated(const QString&) const
    {32, 396, 121, 2, 0, 0, 20},	//399 QSqlRecord::setGenerated(const QString&, bool)
    {32, 396, 205, 2, 0, 0, 21},	//400 QSqlRecord::setGenerated(int, bool)
    {32, 111, 162, 1, 0, 0, 22},	//401 QSqlRecord::append(const QSqlField&)
    {32, 342, 263, 2, 0, 0, 23},	//402 QSqlRecord::replace(int, const QSqlField&)
    {32, 234, 263, 2, 0, 0, 24},	//403 QSqlRecord::insert(int, const QSqlField&)
    {32, 332, 111, 1, 0, 0, 25},	//404 QSqlRecord::remove(int)
    {32, 254, 0, 0, Smoke::mf_const, 154, 26},	//405 QSqlRecord::isEmpty() const
    {32, 151, 109, 1, Smoke::mf_const, 154, 27},	//406 QSqlRecord::contains(const QString&) const
    {32, 138, 0, 0, 0, 0, 28},	//407 QSqlRecord::clear()
    {32, 139, 0, 0, 0, 0, 29},	//408 QSqlRecord::clearValues()
    {32, 153, 0, 0, Smoke::mf_const, 182, 30},	//409 QSqlRecord::count() const
    {32, 521, 0, 0, Smoke::mf_dtor, 0, 31 },	//410 QSqlRecord::~QSqlRecord()
    {33, 71, 0, 0, Smoke::mf_ctor, 60, 1},	//411 QSqlRelation::QSqlRelation()
    {33, 71, 164, 3, Smoke::mf_ctor, 60, 2},	//412 QSqlRelation::QSqlRelation(const QString&, const QString&, const QString&)
    {33, 483, 0, 0, Smoke::mf_const, 69, 3},	//413 QSqlRelation::tableName() const
    {33, 229, 0, 0, Smoke::mf_const, 69, 4},	//414 QSqlRelation::indexColumn() const
    {33, 177, 0, 0, Smoke::mf_const, 69, 5},	//415 QSqlRelation::displayColumn() const
    {33, 268, 0, 0, Smoke::mf_const, 154, 6},	//416 QSqlRelation::isValid() const
    {33, 71, 266, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 60, 7},	//417 QSqlRelation::QSqlRelation(const QSqlRelation&)
    {33, 522, 0, 0, Smoke::mf_dtor, 0, 8 },	//418 QSqlRelation::~QSqlRelation()
    {34, 74, 136, 1, Smoke::mf_ctor|Smoke::mf_explicit, 61, 1},	//419 QSqlRelationalDelegate::QSqlRelationalDelegate(QObject*)
    {34, 156, 65, 3, Smoke::mf_const|Smoke::mf_virtual, 77, 2},	//420 QSqlRelationalDelegate::createEditor(QWidget*, const QStyleOptionViewItem&, const QModelIndex&) const
    {34, 390, 268, 2, Smoke::mf_const|Smoke::mf_virtual, 0, 3},	//421 QSqlRelationalDelegate::setEditorData(QWidget*, const QModelIndex&) const
    {34, 411, 271, 3, Smoke::mf_const|Smoke::mf_virtual, 0, 4},	//422 QSqlRelationalDelegate::setModelData(QWidget*, QAbstractItemModel*, const QModelIndex&) const
    {34, 74, 0, 0, Smoke::mf_ctor|Smoke::mf_explicit, 61, 5},	//423 QSqlRelationalDelegate::QSqlRelationalDelegate()
    {34, 523, 0, 0, Smoke::mf_dtor, 0, 6 },	//424 QSqlRelationalDelegate::~QSqlRelationalDelegate()
    {35, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 159, 1},	//425 QSqlRelationalTableModel::metaObject() const
    {35, 320, 52, 1, Smoke::mf_virtual, 184, 2},	//426 QSqlRelationalTableModel::qt_metacast(const char*)
    {35, 488, 129, 2, Smoke::mf_static, 69, 3},	//427 QSqlRelationalTableModel::tr(const char*, const char*)
    {35, 492, 129, 2, Smoke::mf_static, 69, 4},	//428 QSqlRelationalTableModel::trUtf8(const char*, const char*)
    {35, 488, 132, 3, Smoke::mf_static, 69, 5},	//429 QSqlRelationalTableModel::tr(const char*, const char*, int)
    {35, 492, 132, 3, Smoke::mf_static, 69, 6},	//430 QSqlRelationalTableModel::trUtf8(const char*, const char*, int)
    {35, 318, 54, 3, Smoke::mf_virtual, 182, 7},	//431 QSqlRelationalTableModel::qt_metacall(QMetaObject::Call, int, void**)
    {35, 76, 275, 2, Smoke::mf_ctor, 62, 8},	//432 QSqlRelationalTableModel::QSqlRelationalTableModel(QObject*, QSqlDatabase)
    {35, 162, 236, 2, Smoke::mf_const|Smoke::mf_virtual, 74, 9},	//433 QSqlRelationalTableModel::data(const QModelIndex&, int) const
    {35, 373, 1, 3, Smoke::mf_virtual, 154, 10},	//434 QSqlRelationalTableModel::setData(const QModelIndex&, const QVariant&, int)
    {35, 334, 12, 3, Smoke::mf_virtual, 154, 11},	//435 QSqlRelationalTableModel::removeColumns(int, int, const QModelIndex&)
    {35, 138, 0, 0, Smoke::mf_virtual, 0, 12},	//436 QSqlRelationalTableModel::clear()
    {35, 361, 0, 0, Smoke::mf_virtual, 154, 13},	//437 QSqlRelationalTableModel::select()
    {35, 453, 109, 1, Smoke::mf_virtual, 0, 14},	//438 QSqlRelationalTableModel::setTable(const QString&)
    {35, 441, 278, 2, Smoke::mf_virtual, 0, 15},	//439 QSqlRelationalTableModel::setRelation(int, const QSqlRelation&)
    {35, 328, 111, 1, Smoke::mf_const, 59, 16},	//440 QSqlRelationalTableModel::relation(int) const
    {35, 330, 111, 1, Smoke::mf_const|Smoke::mf_virtual, 67, 17},	//441 QSqlRelationalTableModel::relationModel(int) const
    {35, 405, 281, 1, 0, 0, 18},	//442 QSqlRelationalTableModel::setJoinMode(QSqlRelationalTableModel::JoinMode)
    {35, 350, 111, 1, Smoke::mf_virtual|Smoke::mf_slot, 0, 19},	//443 QSqlRelationalTableModel::revertRow(int)
    {35, 362, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 69, 20},	//444 QSqlRelationalTableModel::selectStatement() const
    {35, 504, 283, 2, Smoke::mf_protected|Smoke::mf_virtual, 154, 21},	//445 QSqlRelationalTableModel::updateRowInTable(int, const QSqlRecord&)
    {35, 241, 261, 1, Smoke::mf_protected|Smoke::mf_virtual, 154, 22},	//446 QSqlRelationalTableModel::insertRowIntoTable(const QSqlRecord&)
    {35, 305, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 69, 23},	//447 QSqlRelationalTableModel::orderByClause() const
    {35, 488, 52, 1, Smoke::mf_static, 69, 24},	//448 QSqlRelationalTableModel::tr(const char*)
    {35, 492, 52, 1, Smoke::mf_static, 69, 25},	//449 QSqlRelationalTableModel::trUtf8(const char*)
    {35, 76, 0, 0, Smoke::mf_ctor, 62, 26},	//450 QSqlRelationalTableModel::QSqlRelationalTableModel()
    {35, 76, 136, 1, Smoke::mf_ctor, 62, 27},	//451 QSqlRelationalTableModel::QSqlRelationalTableModel(QObject*)
    {35, 162, 5, 1, Smoke::mf_const, 74, 28},	//452 QSqlRelationalTableModel::data(const QModelIndex&) const
    {35, 373, 286, 2, 0, 154, 29},	//453 QSqlRelationalTableModel::setData(const QModelIndex&, const QVariant&)
    {35, 334, 258, 2, 0, 154, 30},	//454 QSqlRelationalTableModel::removeColumns(int, int)
    {35, 469, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 158, 31},	//455 QSqlRelationalTableModel::staticMetaObject() const
    {35, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 63, 32},	//456 QSqlRelationalTableModel::InnerJoin (enum)
    {35, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 63, 33},	//457 QSqlRelationalTableModel::LeftJoin (enum)
    {35, 524, 0, 0, Smoke::mf_dtor, 0, 34 },	//458 QSqlRelationalTableModel::~QSqlRelationalTableModel()
    {36, 220, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 74, 1},	//459 QSqlResult::handle() const
    {36, 79, 289, 1, Smoke::mf_ctor|Smoke::mf_protected, 64, 2},	//460 QSqlResult::QSqlResult(const QSqlDriver*)
    {36, 114, 0, 0, Smoke::mf_const|Smoke::mf_protected, 182, 3},	//461 QSqlResult::at() const
    {36, 274, 0, 0, Smoke::mf_const|Smoke::mf_protected, 69, 4},	//462 QSqlResult::lastQuery() const
    {36, 272, 0, 0, Smoke::mf_const|Smoke::mf_protected, 40, 5},	//463 QSqlResult::lastError() const
    {36, 268, 0, 0, Smoke::mf_const|Smoke::mf_protected, 154, 6},	//464 QSqlResult::isValid() const
    {36, 246, 0, 0, Smoke::mf_const|Smoke::mf_protected, 154, 7},	//465 QSqlResult::isActive() const
    {36, 267, 0, 0, Smoke::mf_const|Smoke::mf_protected, 154, 8},	//466 QSqlResult::isSelect() const
    {36, 255, 0, 0, Smoke::mf_const|Smoke::mf_protected, 154, 9},	//467 QSqlResult::isForwardOnly() const
    {36, 182, 0, 0, Smoke::mf_const|Smoke::mf_protected, 166, 10},	//468 QSqlResult::driver() const
    {36, 365, 111, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 11},	//469 QSqlResult::setAt(int)
    {36, 363, 158, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 12},	//470 QSqlResult::setActive(bool)
    {36, 407, 160, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 13},	//471 QSqlResult::setLastError(const QSqlError&)
    {36, 433, 109, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 14},	//472 QSqlResult::setQuery(const QString&)
    {36, 447, 158, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 15},	//473 QSqlResult::setSelect(bool)
    {36, 394, 158, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 16},	//474 QSqlResult::setForwardOnly(bool)
    {36, 193, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 154, 17},	//475 QSqlResult::exec()
    {36, 310, 109, 1, Smoke::mf_protected|Smoke::mf_virtual, 154, 18},	//476 QSqlResult::prepare(const QString&)
    {36, 356, 109, 1, Smoke::mf_protected|Smoke::mf_virtual, 154, 19},	//477 QSqlResult::savePrepare(const QString&)
    {36, 122, 223, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 20},	//478 QSqlResult::bindValue(int, const QVariant&, QFlags<QSql::ParamTypeFlag>)
    {36, 122, 219, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 21},	//479 QSqlResult::bindValue(const QString&, const QVariant&, QFlags<QSql::ParamTypeFlag>)
    {36, 103, 227, 2, Smoke::mf_protected, 0, 22},	//480 QSqlResult::addBindValue(const QVariant&, QFlags<QSql::ParamTypeFlag>)
    {36, 128, 109, 1, Smoke::mf_const|Smoke::mf_protected, 74, 23},	//481 QSqlResult::boundValue(const QString&) const
    {36, 128, 111, 1, Smoke::mf_const|Smoke::mf_protected, 74, 24},	//482 QSqlResult::boundValue(int) const
    {36, 125, 109, 1, Smoke::mf_const|Smoke::mf_protected, 11, 25},	//483 QSqlResult::bindValueType(const QString&) const
    {36, 125, 111, 1, Smoke::mf_const|Smoke::mf_protected, 11, 26},	//484 QSqlResult::bindValueType(int) const
    {36, 130, 0, 0, Smoke::mf_const|Smoke::mf_protected, 182, 27},	//485 QSqlResult::boundValueCount() const
    {36, 133, 0, 0, Smoke::mf_const|Smoke::mf_protected, 76, 28},	//486 QSqlResult::boundValues() const
    {36, 197, 0, 0, Smoke::mf_const|Smoke::mf_protected, 69, 29},	//487 QSqlResult::executedQuery() const
    {36, 131, 111, 1, Smoke::mf_const|Smoke::mf_protected, 69, 30},	//488 QSqlResult::boundValueName(int) const
    {36, 138, 0, 0, Smoke::mf_protected, 0, 31},	//489 QSqlResult::clear()
    {36, 223, 0, 0, Smoke::mf_const|Smoke::mf_protected, 154, 32},	//490 QSqlResult::hasOutValues() const
    {36, 127, 0, 0, Smoke::mf_const|Smoke::mf_protected, 65, 33},	//491 QSqlResult::bindingSyntax() const
    {36, 162, 111, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 74, 34},	//492 QSqlResult::data(int) [pure virtual]
    {36, 262, 111, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 154, 35},	//493 QSqlResult::isNull(int) [pure virtual]
    {36, 345, 109, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 154, 36},	//494 QSqlResult::reset(const QString&) [pure virtual]
    {36, 198, 111, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 154, 37},	//495 QSqlResult::fetch(int) [pure virtual]
    {36, 204, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 154, 38},	//496 QSqlResult::fetchNext()
    {36, 205, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 154, 39},	//497 QSqlResult::fetchPrevious()
    {36, 200, 0, 0, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 154, 40},	//498 QSqlResult::fetchFirst() [pure virtual]
    {36, 201, 0, 0, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 154, 41},	//499 QSqlResult::fetchLast() [pure virtual]
    {36, 462, 0, 0, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 182, 42},	//500 QSqlResult::size() [pure virtual]
    {36, 285, 0, 0, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 182, 43},	//501 QSqlResult::numRowsAffected() [pure virtual]
    {36, 324, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 56, 44},	//502 QSqlResult::record() const
    {36, 273, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 74, 45},	//503 QSqlResult::lastInsertId() const
    {36, 509, 291, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 46},	//504 QSqlResult::virtual_hook(int, void*)
    {36, 195, 158, 1, Smoke::mf_protected, 154, 47},	//505 QSqlResult::execBatch(bool)
    {36, 175, 0, 0, Smoke::mf_protected, 0, 48},	//506 QSqlResult::detachFromResultSet()
    {36, 419, 113, 1, Smoke::mf_protected, 0, 49},	//507 QSqlResult::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy)
    {36, 287, 0, 0, Smoke::mf_const|Smoke::mf_protected, 27, 50},	//508 QSqlResult::numericalPrecisionPolicy() const
    {36, 282, 0, 0, Smoke::mf_protected, 154, 51},	//509 QSqlResult::nextResult()
    {36, 195, 0, 0, Smoke::mf_protected, 154, 52},	//510 QSqlResult::execBatch()
    {36, 35, 0, 0, Smoke::mf_static|Smoke::mf_enum, 65, 53},	//511 QSqlResult::PositionalBinding (enum)
    {36, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 65, 54},	//512 QSqlResult::NamedBinding (enum)
    {36, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 55},	//513 QSqlResult::BatchOperation (enum)
    {36, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 56},	//514 QSqlResult::DetachFromResultSet (enum)
    {36, 87, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 57},	//515 QSqlResult::SetNumericalPrecision (enum)
    {36, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 58},	//516 QSqlResult::NextResult (enum)
    {36, 525, 0, 0, Smoke::mf_dtor, 0, 59 },	//517 QSqlResult::~QSqlResult()
    {37, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 159, 1},	//518 QSqlTableModel::metaObject() const
    {37, 320, 52, 1, Smoke::mf_virtual, 184, 2},	//519 QSqlTableModel::qt_metacast(const char*)
    {37, 488, 129, 2, Smoke::mf_static, 69, 3},	//520 QSqlTableModel::tr(const char*, const char*)
    {37, 492, 129, 2, Smoke::mf_static, 69, 4},	//521 QSqlTableModel::trUtf8(const char*, const char*)
    {37, 488, 132, 3, Smoke::mf_static, 69, 5},	//522 QSqlTableModel::tr(const char*, const char*, int)
    {37, 492, 132, 3, Smoke::mf_static, 69, 6},	//523 QSqlTableModel::trUtf8(const char*, const char*, int)
    {37, 318, 54, 3, Smoke::mf_virtual, 182, 7},	//524 QSqlTableModel::qt_metacall(QMetaObject::Call, int, void**)
    {37, 81, 275, 2, Smoke::mf_ctor, 67, 8},	//525 QSqlTableModel::QSqlTableModel(QObject*, QSqlDatabase)
    {37, 361, 0, 0, Smoke::mf_virtual, 154, 9},	//526 QSqlTableModel::select()
    {37, 453, 109, 1, Smoke::mf_virtual, 0, 10},	//527 QSqlTableModel::setTable(const QString&)
    {37, 483, 0, 0, Smoke::mf_const, 69, 11},	//528 QSqlTableModel::tableName() const
    {37, 215, 5, 1, Smoke::mf_const|Smoke::mf_virtual, 13, 12},	//529 QSqlTableModel::flags(const QModelIndex&) const
    {37, 162, 236, 2, Smoke::mf_const|Smoke::mf_virtual, 74, 13},	//530 QSqlTableModel::data(const QModelIndex&, int) const
    {37, 373, 1, 3, Smoke::mf_virtual, 154, 14},	//531 QSqlTableModel::setData(const QModelIndex&, const QVariant&, int)
    {37, 224, 239, 3, Smoke::mf_const|Smoke::mf_virtual, 74, 15},	//532 QSqlTableModel::headerData(int, Qt::Orientation, int) const
    {37, 250, 5, 1, Smoke::mf_const, 154, 16},	//533 QSqlTableModel::isDirty(const QModelIndex&) const
    {37, 138, 0, 0, Smoke::mf_virtual, 0, 17},	//534 QSqlTableModel::clear()
    {37, 388, 294, 1, Smoke::mf_virtual, 0, 18},	//535 QSqlTableModel::setEditStrategy(QSqlTableModel::EditStrategy)
    {37, 187, 0, 0, Smoke::mf_const, 68, 19},	//536 QSqlTableModel::editStrategy() const
    {37, 315, 0, 0, Smoke::mf_const, 48, 20},	//537 QSqlTableModel::primaryKey() const
    {37, 166, 0, 0, Smoke::mf_const, 30, 21},	//538 QSqlTableModel::database() const
    {37, 208, 109, 1, Smoke::mf_const, 182, 22},	//539 QSqlTableModel::fieldIndex(const QString&) const
    {37, 464, 16, 2, Smoke::mf_virtual, 0, 23},	//540 QSqlTableModel::sort(int, Qt::SortOrder)
    {37, 449, 16, 2, Smoke::mf_virtual, 0, 24},	//541 QSqlTableModel::setSort(int, Qt::SortOrder)
    {37, 212, 0, 0, Smoke::mf_const, 69, 25},	//542 QSqlTableModel::filter() const
    {37, 392, 109, 1, Smoke::mf_virtual, 0, 26},	//543 QSqlTableModel::setFilter(const QString&)
    {37, 354, 5, 1, Smoke::mf_const|Smoke::mf_virtual, 182, 27},	//544 QSqlTableModel::rowCount(const QModelIndex&) const
    {37, 334, 12, 3, Smoke::mf_virtual, 154, 28},	//545 QSqlTableModel::removeColumns(int, int, const QModelIndex&)
    {37, 339, 12, 3, Smoke::mf_virtual, 154, 29},	//546 QSqlTableModel::removeRows(int, int, const QModelIndex&)
    {37, 243, 12, 3, Smoke::mf_virtual, 154, 30},	//547 QSqlTableModel::insertRows(int, int, const QModelIndex&)
    {37, 239, 283, 2, 0, 154, 31},	//548 QSqlTableModel::insertRecord(int, const QSqlRecord&)
    {37, 439, 283, 2, 0, 154, 32},	//549 QSqlTableModel::setRecord(int, const QSqlRecord&)
    {37, 350, 111, 1, Smoke::mf_virtual, 0, 33},	//550 QSqlTableModel::revertRow(int)
    {37, 474, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 154, 34},	//551 QSqlTableModel::submit()
    {37, 348, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 35},	//552 QSqlTableModel::revert()
    {37, 475, 0, 0, Smoke::mf_slot, 154, 36},	//553 QSqlTableModel::submitAll()
    {37, 349, 0, 0, Smoke::mf_slot, 0, 37},	//554 QSqlTableModel::revertAll()
    {37, 316, 296, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 38},	//555 QSqlTableModel::primeInsert(int, QSqlRecord&)
    {37, 117, 299, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 39},	//556 QSqlTableModel::beforeInsert(QSqlRecord&)
    {37, 119, 296, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 40},	//557 QSqlTableModel::beforeUpdate(int, QSqlRecord&)
    {37, 115, 111, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 41},	//558 QSqlTableModel::beforeDelete(int)
    {37, 504, 283, 2, Smoke::mf_protected|Smoke::mf_virtual, 154, 42},	//559 QSqlTableModel::updateRowInTable(int, const QSqlRecord&)
    {37, 241, 261, 1, Smoke::mf_protected|Smoke::mf_virtual, 154, 43},	//560 QSqlTableModel::insertRowIntoTable(const QSqlRecord&)
    {37, 173, 111, 1, Smoke::mf_protected|Smoke::mf_virtual, 154, 44},	//561 QSqlTableModel::deleteRowFromTable(int)
    {37, 305, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 69, 45},	//562 QSqlTableModel::orderByClause() const
    {37, 362, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 69, 46},	//563 QSqlTableModel::selectStatement() const
    {37, 431, 203, 1, Smoke::mf_protected, 0, 47},	//564 QSqlTableModel::setPrimaryKey(const QSqlIndex&)
    {37, 433, 215, 1, Smoke::mf_protected, 0, 48},	//565 QSqlTableModel::setQuery(const QSqlQuery&)
    {37, 230, 5, 1, Smoke::mf_const|Smoke::mf_protected, 21, 49},	//566 QSqlTableModel::indexInQuery(const QModelIndex&) const
    {37, 488, 52, 1, Smoke::mf_static, 69, 50},	//567 QSqlTableModel::tr(const char*)
    {37, 492, 52, 1, Smoke::mf_static, 69, 51},	//568 QSqlTableModel::trUtf8(const char*)
    {37, 81, 0, 0, Smoke::mf_ctor, 67, 52},	//569 QSqlTableModel::QSqlTableModel()
    {37, 81, 136, 1, Smoke::mf_ctor, 67, 53},	//570 QSqlTableModel::QSqlTableModel(QObject*)
    {37, 162, 5, 1, Smoke::mf_const, 74, 54},	//571 QSqlTableModel::data(const QModelIndex&) const
    {37, 373, 286, 2, 0, 154, 55},	//572 QSqlTableModel::setData(const QModelIndex&, const QVariant&)
    {37, 224, 251, 2, Smoke::mf_const, 74, 56},	//573 QSqlTableModel::headerData(int, Qt::Orientation) const
    {37, 354, 0, 0, Smoke::mf_const, 182, 57},	//574 QSqlTableModel::rowCount() const
    {37, 334, 258, 2, 0, 154, 58},	//575 QSqlTableModel::removeColumns(int, int)
    {37, 339, 258, 2, 0, 154, 59},	//576 QSqlTableModel::removeRows(int, int)
    {37, 243, 258, 2, 0, 154, 60},	//577 QSqlTableModel::insertRows(int, int)
    {37, 469, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 158, 61},	//578 QSqlTableModel::staticMetaObject() const
    {37, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 62},	//579 QSqlTableModel::OnFieldChange (enum)
    {37, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 63},	//580 QSqlTableModel::OnRowChange (enum)
    {37, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 64},	//581 QSqlTableModel::OnManualSubmit (enum)
    {37, 526, 0, 0, Smoke::mf_dtor, 0, 65 },	//582 QSqlTableModel::~QSqlTableModel()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    60,  // QSqlDatabase::QSqlDatabase(const QSqlDatabase&)
    104,  // QSqlDatabase::QSqlDatabase(QSqlDriver*)
    0,
    478,  // QSqlResult::bindValue(int, const QVariant&, QFlags<QSql::ParamTypeFlag>)
    479,  // QSqlResult::bindValue(const QString&, const QVariant&, QFlags<QSql::ParamTypeFlag>)
    0,
    483,  // QSqlResult::bindValueType(const QString&) const
    484,  // QSqlResult::bindValueType(int) const
    0,
    481,  // QSqlResult::boundValue(const QString&) const
    482,  // QSqlResult::boundValue(int) const
    0,
    395,  // QSqlRecord::field(int) const
    396,  // QSqlRecord::field(const QString&) const
    0,
    397,  // QSqlRecord::isGenerated(int) const
    398,  // QSqlRecord::isGenerated(const QString&) const
    0,
    391,  // QSqlRecord::isNull(int) const
    392,  // QSqlRecord::isNull(const QString&) const
    0,
    399,  // QSqlRecord::setGenerated(const QString&, bool)
    400,  // QSqlRecord::setGenerated(int, bool)
    0,
    389,  // QSqlRecord::setNull(int)
    390,  // QSqlRecord::setNull(const QString&)
    0,
    387,  // QSqlRecord::setValue(int, const QVariant&)
    388,  // QSqlRecord::setValue(const QString&, const QVariant&)
    0,
    385,  // QSqlRecord::value(int) const
    386,  // QSqlRecord::value(const QString&) const
    0,
    286,  // QSqlQuery::QSqlQuery(QSqlResult*)
    288,  // QSqlQuery::QSqlQuery(QSqlDatabase)
    289,  // QSqlQuery::QSqlQuery(const QSqlQuery&)
    0,
    332,  // QSqlQuery::bindValue(const QString&, const QVariant&)
    333,  // QSqlQuery::bindValue(int, const QVariant&)
    0,
    318,  // QSqlQuery::bindValue(const QString&, const QVariant&, QFlags<QSql::ParamTypeFlag>)
    319,  // QSqlQuery::bindValue(int, const QVariant&, QFlags<QSql::ParamTypeFlag>)
    0,
    321,  // QSqlQuery::boundValue(const QString&) const
    322,  // QSqlQuery::boundValue(int) const
    0,
    21,  // QGlobalSpace::operator<<(QDebug, const QSqlField&)
    22,  // QGlobalSpace::operator<<(QDebug, const QSqlDatabase&)
    23,  // QGlobalSpace::operator<<(QDebug, const QSqlRecord&)
    25,  // QGlobalSpace::operator<<(QDebug, const QSqlError&)
    0,
    19,  // QGlobalSpace::operator|(QSql::ParamTypeFlag, int)
    20,  // QGlobalSpace::operator|(QSql::ParamTypeFlag, QSql::ParamTypeFlag)
    24,  // QGlobalSpace::operator|(QSql::ParamTypeFlag, QFlags<QSql::ParamTypeFlag>)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {9, 298, -47},	// QGlobalSpace::operator<<##
    {9, 304, -52},	// QGlobalSpace::operator|$$
    {21, 1, 58},	// QSql::AfterLastRow
    {21, 2, 48},	// QSql::AllTables
    {21, 6, 57},	// QSql::BeforeFirstRow
    {21, 7, 52},	// QSql::Binary
    {21, 14, 56},	// QSql::HighPrecision
    {21, 15, 49},	// QSql::In
    {21, 16, 51},	// QSql::InOut
    {21, 21, 55},	// QSql::LowPrecisionDouble
    {21, 22, 53},	// QSql::LowPrecisionInt32
    {21, 23, 54},	// QSql::LowPrecisionInt64
    {21, 34, 50},	// QSql::Out
    {21, 90, 46},	// QSql::SystemTables
    {21, 92, 45},	// QSql::Tables
    {21, 101, 47},	// QSql::Views
    {22, 38, 59},	// QSqlDatabase::QSqlDatabase
    {22, 39, -1},	// QSqlDatabase::QSqlDatabase#
    {22, 40, 103},	// QSqlDatabase::QSqlDatabase$
    {22, 107, 109},	// QSqlDatabase::addDatabase#
    {22, 108, 94},	// QSqlDatabase::addDatabase#$
    {22, 109, 108},	// QSqlDatabase::addDatabase$
    {22, 110, 93},	// QSqlDatabase::addDatabase$$
    {22, 141, 95},	// QSqlDatabase::cloneDatabase#$
    {22, 142, 64},	// QSqlDatabase::close
    {22, 145, 74},	// QSqlDatabase::commit
    {22, 148, 88},	// QSqlDatabase::connectOptions
    {22, 149, 89},	// QSqlDatabase::connectionName
    {22, 150, 100},	// QSqlDatabase::connectionNames
    {22, 151, 112},	// QSqlDatabase::contains
    {22, 152, 98},	// QSqlDatabase::contains$
    {22, 166, 110},	// QSqlDatabase::database
    {22, 167, 111},	// QSqlDatabase::database$
    {22, 168, 96},	// QSqlDatabase::database$$
    {22, 169, 82},	// QSqlDatabase::databaseName
    {22, 171, 113},	// QSqlDatabase::defaultConnection
    {22, 182, 92},	// QSqlDatabase::driver
    {22, 183, 86},	// QSqlDatabase::driverName
    {22, 185, 99},	// QSqlDatabase::drivers
    {22, 193, 106},	// QSqlDatabase::exec
    {22, 194, 70},	// QSqlDatabase::exec$
    {22, 227, 85},	// QSqlDatabase::hostName
    {22, 253, 102},	// QSqlDatabase::isDriverAvailable$
    {22, 264, 65},	// QSqlDatabase::isOpen
    {22, 265, 66},	// QSqlDatabase::isOpenError
    {22, 268, 72},	// QSqlDatabase::isValid
    {22, 272, 71},	// QSqlDatabase::lastError
    {22, 287, 91},	// QSqlDatabase::numericalPrecisionPolicy
    {22, 288, 62},	// QSqlDatabase::open
    {22, 290, 63},	// QSqlDatabase::open$$
    {22, 300, 61},	// QSqlDatabase::operator=#
    {22, 307, 84},	// QSqlDatabase::password
    {22, 308, 87},	// QSqlDatabase::port
    {22, 314, 68},	// QSqlDatabase::primaryIndex$
    {22, 325, 69},	// QSqlDatabase::record$
    {22, 327, 101},	// QSqlDatabase::registerSqlDriver$#
    {22, 338, 97},	// QSqlDatabase::removeDatabase$
    {22, 352, 75},	// QSqlDatabase::rollback
    {22, 369, 107},	// QSqlDatabase::setConnectOptions
    {22, 370, 81},	// QSqlDatabase::setConnectOptions$
    {22, 377, 76},	// QSqlDatabase::setDatabaseName$
    {22, 381, 114},	// QSqlDatabase::setDefaultConnection$
    {22, 403, 79},	// QSqlDatabase::setHostName$
    {22, 420, 90},	// QSqlDatabase::setNumericalPrecisionPolicy$
    {22, 426, 78},	// QSqlDatabase::setPassword$
    {22, 428, 80},	// QSqlDatabase::setPort$
    {22, 458, 77},	// QSqlDatabase::setUserName$
    {22, 484, 105},	// QSqlDatabase::tables
    {22, 485, 67},	// QSqlDatabase::tables$
    {22, 496, 73},	// QSqlDatabase::transaction
    {22, 506, 83},	// QSqlDatabase::userName
    {22, 511, 115},	// QSqlDatabase::~QSqlDatabase
    {23, 3, 169},	// QSqlDriver::BLOB
    {23, 5, 175},	// QSqlDriver::BatchOperations
    {23, 9, 185},	// QSqlDriver::DeleteStatement
    {23, 11, 178},	// QSqlDriver::EventNotifications
    {23, 12, 186},	// QSqlDriver::FieldName
    {23, 13, 179},	// QSqlDriver::FinishQuery
    {23, 18, 184},	// QSqlDriver::InsertStatement
    {23, 19, 174},	// QSqlDriver::LastInsertId
    {23, 24, 177},	// QSqlDriver::LowPrecisionNumbers
    {23, 25, 180},	// QSqlDriver::MultipleResultSets
    {23, 27, 172},	// QSqlDriver::NamedPlaceholders
    {23, 36, 173},	// QSqlDriver::PositionalPlaceholders
    {23, 37, 171},	// QSqlDriver::PreparedQueries
    {23, 41, 159},	// QSqlDriver::QSqlDriver
    {23, 42, 123},	// QSqlDriver::QSqlDriver#
    {23, 84, 168},	// QSqlDriver::QuerySize
    {23, 86, 182},	// QSqlDriver::SelectStatement
    {23, 88, 176},	// QSqlDriver::SimpleLocking
    {23, 91, 187},	// QSqlDriver::TableName
    {23, 94, 167},	// QSqlDriver::Transactions
    {23, 95, 170},	// QSqlDriver::Unicode
    {23, 98, 183},	// QSqlDriver::UpdateStatement
    {23, 102, 181},	// QSqlDriver::WhereStatement
    {23, 121, 126},	// QSqlDriver::beginTransaction
    {23, 142, 138},	// QSqlDriver::close
    {23, 146, 127},	// QSqlDriver::commitTransaction
    {23, 159, 139},	// QSqlDriver::createResult
    {23, 190, 133},	// QSqlDriver::escapeIdentifier$$
    {23, 218, 160},	// QSqlDriver::formatValue#
    {23, 219, 132},	// QSqlDriver::formatValue#$
    {23, 220, 136},	// QSqlDriver::handle
    {23, 222, 137},	// QSqlDriver::hasFeature$
    {23, 259, 144},	// QSqlDriver::isIdentifierEscaped$$
    {23, 261, 155},	// QSqlDriver::isIdentifierEscapedImplementation$$
    {23, 264, 124},	// QSqlDriver::isOpen
    {23, 265, 125},	// QSqlDriver::isOpenError
    {23, 272, 135},	// QSqlDriver::lastError
    {23, 277, 116},	// QSqlDriver::metaObject
    {23, 284, 148},	// QSqlDriver::notification$
    {23, 287, 147},	// QSqlDriver::numericalPrecisionPolicy
    {23, 289, 161},	// QSqlDriver::open$
    {23, 290, 162},	// QSqlDriver::open$$
    {23, 291, 163},	// QSqlDriver::open$$$
    {23, 292, 164},	// QSqlDriver::open$$$$
    {23, 293, 165},	// QSqlDriver::open$$$$$
    {23, 294, 140},	// QSqlDriver::open$$$$$$
    {23, 314, 130},	// QSqlDriver::primaryIndex$
    {23, 319, 122},	// QSqlDriver::qt_metacall$$?
    {23, 321, 117},	// QSqlDriver::qt_metacast$
    {23, 325, 131},	// QSqlDriver::record$
    {23, 353, 128},	// QSqlDriver::rollbackTransaction
    {23, 408, 151},	// QSqlDriver::setLastError#
    {23, 420, 146},	// QSqlDriver::setNumericalPrecisionPolicy$
    {23, 422, 149},	// QSqlDriver::setOpen$
    {23, 424, 150},	// QSqlDriver::setOpenError$
    {23, 468, 134},	// QSqlDriver::sqlStatement$$#$
    {23, 469, 166},	// QSqlDriver::staticMetaObject
    {23, 471, 145},	// QSqlDriver::stripDelimiters$$
    {23, 473, 156},	// QSqlDriver::stripDelimitersImplementation$$
    {23, 477, 141},	// QSqlDriver::subscribeToNotification$
    {23, 479, 152},	// QSqlDriver::subscribeToNotificationImplementation$
    {23, 480, 143},	// QSqlDriver::subscribedToNotifications
    {23, 481, 154},	// QSqlDriver::subscribedToNotificationsImplementation
    {23, 485, 129},	// QSqlDriver::tables$
    {23, 489, 157},	// QSqlDriver::tr$
    {23, 490, 118},	// QSqlDriver::tr$$
    {23, 491, 120},	// QSqlDriver::tr$$$
    {23, 493, 158},	// QSqlDriver::trUtf8$
    {23, 494, 119},	// QSqlDriver::trUtf8$$
    {23, 495, 121},	// QSqlDriver::trUtf8$$$
    {23, 500, 142},	// QSqlDriver::unsubscribeFromNotification$
    {23, 502, 153},	// QSqlDriver::unsubscribeFromNotificationImplementation$
    {23, 512, 188},	// QSqlDriver::~QSqlDriver
    {24, 43, 190},	// QSqlDriverCreatorBase::QSqlDriverCreatorBase
    {24, 44, 191},	// QSqlDriverCreatorBase::QSqlDriverCreatorBase#
    {24, 158, 189},	// QSqlDriverCreatorBase::createObject
    {24, 513, 192},	// QSqlDriverCreatorBase::~QSqlDriverCreatorBase
    {25, 45, 194},	// QSqlDriverFactoryInterface::QSqlDriverFactoryInterface
    {25, 46, 195},	// QSqlDriverFactoryInterface::QSqlDriverFactoryInterface#
    {25, 155, 193},	// QSqlDriverFactoryInterface::create$
    {25, 514, 196},	// QSqlDriverFactoryInterface::~QSqlDriverFactoryInterface
    {26, 47, 209},	// QSqlDriverPlugin::QSqlDriverPlugin
    {26, 48, 204},	// QSqlDriverPlugin::QSqlDriverPlugin#
    {26, 155, 206},	// QSqlDriverPlugin::create$
    {26, 270, 205},	// QSqlDriverPlugin::keys
    {26, 277, 197},	// QSqlDriverPlugin::metaObject
    {26, 319, 203},	// QSqlDriverPlugin::qt_metacall$$?
    {26, 321, 198},	// QSqlDriverPlugin::qt_metacast$
    {26, 469, 210},	// QSqlDriverPlugin::staticMetaObject
    {26, 489, 207},	// QSqlDriverPlugin::tr$
    {26, 490, 199},	// QSqlDriverPlugin::tr$$
    {26, 491, 201},	// QSqlDriverPlugin::tr$$$
    {26, 493, 208},	// QSqlDriverPlugin::trUtf8$
    {26, 494, 200},	// QSqlDriverPlugin::trUtf8$$
    {26, 495, 202},	// QSqlDriverPlugin::trUtf8$$$
    {26, 515, 211},	// QSqlDriverPlugin::~QSqlDriverPlugin
    {27, 8, 230},	// QSqlError::ConnectionError
    {27, 29, 229},	// QSqlError::NoError
    {27, 49, 225},	// QSqlError::QSqlError
    {27, 50, 213},	// QSqlError::QSqlError#
    {27, 51, 226},	// QSqlError::QSqlError$
    {27, 52, 227},	// QSqlError::QSqlError$$
    {27, 53, 228},	// QSqlError::QSqlError$$$
    {27, 54, 212},	// QSqlError::QSqlError$$$$
    {27, 89, 231},	// QSqlError::StatementError
    {27, 93, 232},	// QSqlError::TransactionError
    {27, 97, 233},	// QSqlError::UnknownError
    {27, 170, 217},	// QSqlError::databaseText
    {27, 184, 215},	// QSqlError::driverText
    {27, 268, 224},	// QSqlError::isValid
    {27, 286, 221},	// QSqlError::number
    {27, 300, 214},	// QSqlError::operator=#
    {27, 379, 218},	// QSqlError::setDatabaseText$
    {27, 387, 216},	// QSqlError::setDriverText$
    {27, 418, 222},	// QSqlError::setNumber$
    {27, 456, 220},	// QSqlError::setType$
    {27, 486, 223},	// QSqlError::text
    {27, 497, 219},	// QSqlError::type
    {27, 516, 234},	// QSqlError::~QSqlError
    {28, 33, 269},	// QSqlField::Optional
    {28, 55, 266},	// QSqlField::QSqlField
    {28, 56, 236},	// QSqlField::QSqlField#
    {28, 57, 267},	// QSqlField::QSqlField$
    {28, 58, 235},	// QSqlField::QSqlField$$
    {28, 85, 270},	// QSqlField::Required
    {28, 96, 268},	// QSqlField::Unknown
    {28, 138, 247},	// QSqlField::clear
    {28, 172, 262},	// QSqlField::defaultValue
    {28, 247, 249},	// QSqlField::isAutoValue
    {28, 256, 264},	// QSqlField::isGenerated
    {28, 262, 244},	// QSqlField::isNull
    {28, 266, 246},	// QSqlField::isReadOnly
    {28, 268, 265},	// QSqlField::isValid
    {28, 275, 260},	// QSqlField::length
    {28, 280, 243},	// QSqlField::name
    {28, 296, 239},	// QSqlField::operator!=#
    {28, 300, 237},	// QSqlField::operator=#
    {28, 302, 238},	// QSqlField::operator==#
    {28, 309, 261},	// QSqlField::precision
    {28, 344, 259},	// QSqlField::requiredStatus
    {28, 368, 258},	// QSqlField::setAutoValue$
    {28, 383, 255},	// QSqlField::setDefaultValue#
    {28, 397, 257},	// QSqlField::setGenerated$
    {28, 410, 253},	// QSqlField::setLength$
    {28, 414, 242},	// QSqlField::setName$
    {28, 430, 254},	// QSqlField::setPrecision$
    {28, 438, 245},	// QSqlField::setReadOnly$
    {28, 444, 252},	// QSqlField::setRequired$
    {28, 446, 251},	// QSqlField::setRequiredStatus$
    {28, 452, 256},	// QSqlField::setSqlType$
    {28, 456, 250},	// QSqlField::setType$
    {28, 460, 240},	// QSqlField::setValue#
    {28, 497, 248},	// QSqlField::type
    {28, 498, 263},	// QSqlField::typeID
    {28, 507, 241},	// QSqlField::value
    {28, 517, 271},	// QSqlField::~QSqlField
    {29, 59, 283},	// QSqlIndex::QSqlIndex
    {29, 60, 273},	// QSqlIndex::QSqlIndex#
    {29, 61, 284},	// QSqlIndex::QSqlIndex$
    {29, 62, 272},	// QSqlIndex::QSqlIndex$$
    {29, 112, 279},	// QSqlIndex::append#
    {29, 113, 280},	// QSqlIndex::append#$
    {29, 160, 276},	// QSqlIndex::cursorName
    {29, 249, 281},	// QSqlIndex::isDescending$
    {29, 280, 278},	// QSqlIndex::name
    {29, 300, 274},	// QSqlIndex::operator=#
    {29, 372, 275},	// QSqlIndex::setCursorName$
    {29, 385, 282},	// QSqlIndex::setDescending$$
    {29, 414, 277},	// QSqlIndex::setName$
    {29, 518, 285},	// QSqlIndex::~QSqlIndex
    {30, 63, 328},	// QSqlQuery::QSqlQuery
    {30, 64, -34},	// QSqlQuery::QSqlQuery#
    {30, 65, 329},	// QSqlQuery::QSqlQuery$
    {30, 66, 287},	// QSqlQuery::QSqlQuery$#
    {30, 99, 336},	// QSqlQuery::ValuesAsColumns
    {30, 100, 335},	// QSqlQuery::ValuesAsRows
    {30, 104, 334},	// QSqlQuery::addBindValue#
    {30, 105, 320},	// QSqlQuery::addBindValue#$
    {30, 114, 294},	// QSqlQuery::at
    {30, 123, -38},	// QSqlQuery::bindValue$#
    {30, 124, -41},	// QSqlQuery::bindValue$#$
    {30, 129, -44},	// QSqlQuery::boundValue$
    {30, 133, 323},	// QSqlQuery::boundValues
    {30, 138, 314},	// QSqlQuery::clear
    {30, 182, 300},	// QSqlQuery::driver
    {30, 193, 315},	// QSqlQuery::exec
    {30, 194, 305},	// QSqlQuery::exec$
    {30, 195, 331},	// QSqlQuery::execBatch
    {30, 196, 316},	// QSqlQuery::execBatch$
    {30, 197, 324},	// QSqlQuery::executedQuery
    {30, 213, 326},	// QSqlQuery::finish
    {30, 214, 312},	// QSqlQuery::first
    {30, 246, 292},	// QSqlQuery::isActive
    {30, 255, 302},	// QSqlQuery::isForwardOnly
    {30, 263, 293},	// QSqlQuery::isNull$
    {30, 267, 298},	// QSqlQuery::isSelect
    {30, 268, 291},	// QSqlQuery::isValid
    {30, 271, 313},	// QSqlQuery::last
    {30, 272, 297},	// QSqlQuery::lastError
    {30, 273, 325},	// QSqlQuery::lastInsertId
    {30, 274, 295},	// QSqlQuery::lastQuery
    {30, 281, 310},	// QSqlQuery::next
    {30, 282, 327},	// QSqlQuery::nextResult
    {30, 285, 296},	// QSqlQuery::numRowsAffected
    {30, 287, 308},	// QSqlQuery::numericalPrecisionPolicy
    {30, 300, 290},	// QSqlQuery::operator=#
    {30, 311, 317},	// QSqlQuery::prepare$
    {30, 312, 311},	// QSqlQuery::previous
    {30, 324, 303},	// QSqlQuery::record
    {30, 347, 301},	// QSqlQuery::result
    {30, 359, 330},	// QSqlQuery::seek$
    {30, 360, 309},	// QSqlQuery::seek$$
    {30, 395, 304},	// QSqlQuery::setForwardOnly$
    {30, 420, 307},	// QSqlQuery::setNumericalPrecisionPolicy$
    {30, 462, 299},	// QSqlQuery::size
    {30, 508, 306},	// QSqlQuery::value$
    {30, 519, 337},	// QSqlQuery::~QSqlQuery
    {31, 67, 367},	// QSqlQueryModel::QSqlQueryModel
    {31, 68, 345},	// QSqlQueryModel::QSqlQueryModel#
    {31, 135, 377},	// QSqlQueryModel::canFetchMore
    {31, 136, 361},	// QSqlQueryModel::canFetchMore#
    {31, 138, 358},	// QSqlQueryModel::clear
    {31, 143, 369},	// QSqlQueryModel::columnCount
    {31, 144, 347},	// QSqlQueryModel::columnCount#
    {31, 163, 370},	// QSqlQueryModel::data#
    {31, 164, 350},	// QSqlQueryModel::data#$
    {31, 202, 376},	// QSqlQueryModel::fetchMore
    {31, 203, 360},	// QSqlQueryModel::fetchMore#
    {31, 225, 371},	// QSqlQueryModel::headerData$$
    {31, 226, 351},	// QSqlQueryModel::headerData$$$
    {31, 231, 363},	// QSqlQueryModel::indexInQuery#
    {31, 237, 373},	// QSqlQueryModel::insertColumns$$
    {31, 238, 353},	// QSqlQueryModel::insertColumns$$#
    {31, 272, 359},	// QSqlQueryModel::lastError
    {31, 277, 338},	// QSqlQueryModel::metaObject
    {31, 319, 344},	// QSqlQueryModel::qt_metacall$$?
    {31, 321, 339},	// QSqlQueryModel::qt_metacast$
    {31, 322, 357},	// QSqlQueryModel::query
    {31, 323, 362},	// QSqlQueryModel::queryChange
    {31, 324, 349},	// QSqlQueryModel::record
    {31, 325, 348},	// QSqlQueryModel::record$
    {31, 335, 374},	// QSqlQueryModel::removeColumns$$
    {31, 336, 354},	// QSqlQueryModel::removeColumns$$#
    {31, 354, 368},	// QSqlQueryModel::rowCount
    {31, 355, 346},	// QSqlQueryModel::rowCount#
    {31, 400, 372},	// QSqlQueryModel::setHeaderData$$#
    {31, 401, 352},	// QSqlQueryModel::setHeaderData$$#$
    {31, 408, 364},	// QSqlQueryModel::setLastError#
    {31, 434, 355},	// QSqlQueryModel::setQuery#
    {31, 435, 375},	// QSqlQueryModel::setQuery$
    {31, 436, 356},	// QSqlQueryModel::setQuery$#
    {31, 469, 378},	// QSqlQueryModel::staticMetaObject
    {31, 489, 365},	// QSqlQueryModel::tr$
    {31, 490, 340},	// QSqlQueryModel::tr$$
    {31, 491, 342},	// QSqlQueryModel::tr$$$
    {31, 493, 366},	// QSqlQueryModel::trUtf8$
    {31, 494, 341},	// QSqlQueryModel::trUtf8$$
    {31, 495, 343},	// QSqlQueryModel::trUtf8$$$
    {31, 520, 379},	// QSqlQueryModel::~QSqlQueryModel
    {32, 69, 380},	// QSqlRecord::QSqlRecord
    {32, 70, 381},	// QSqlRecord::QSqlRecord#
    {32, 112, 401},	// QSqlRecord::append#
    {32, 138, 407},	// QSqlRecord::clear
    {32, 139, 408},	// QSqlRecord::clearValues
    {32, 152, 406},	// QSqlRecord::contains$
    {32, 153, 409},	// QSqlRecord::count
    {32, 207, -13},	// QSqlRecord::field$
    {32, 211, 394},	// QSqlRecord::fieldName$
    {32, 233, 393},	// QSqlRecord::indexOf$
    {32, 235, 403},	// QSqlRecord::insert$#
    {32, 254, 405},	// QSqlRecord::isEmpty
    {32, 257, -16},	// QSqlRecord::isGenerated$
    {32, 263, -19},	// QSqlRecord::isNull$
    {32, 296, 384},	// QSqlRecord::operator!=#
    {32, 300, 382},	// QSqlRecord::operator=#
    {32, 302, 383},	// QSqlRecord::operator==#
    {32, 333, 404},	// QSqlRecord::remove$
    {32, 343, 402},	// QSqlRecord::replace$#
    {32, 398, -22},	// QSqlRecord::setGenerated$$
    {32, 416, -25},	// QSqlRecord::setNull$
    {32, 461, -28},	// QSqlRecord::setValue$#
    {32, 508, -31},	// QSqlRecord::value$
    {32, 521, 410},	// QSqlRecord::~QSqlRecord
    {33, 71, 411},	// QSqlRelation::QSqlRelation
    {33, 72, 417},	// QSqlRelation::QSqlRelation#
    {33, 73, 412},	// QSqlRelation::QSqlRelation$$$
    {33, 177, 415},	// QSqlRelation::displayColumn
    {33, 229, 414},	// QSqlRelation::indexColumn
    {33, 268, 416},	// QSqlRelation::isValid
    {33, 483, 413},	// QSqlRelation::tableName
    {33, 522, 418},	// QSqlRelation::~QSqlRelation
    {34, 74, 423},	// QSqlRelationalDelegate::QSqlRelationalDelegate
    {34, 75, 419},	// QSqlRelationalDelegate::QSqlRelationalDelegate#
    {34, 157, 420},	// QSqlRelationalDelegate::createEditor###
    {34, 391, 421},	// QSqlRelationalDelegate::setEditorData##
    {34, 412, 422},	// QSqlRelationalDelegate::setModelData###
    {34, 523, 424},	// QSqlRelationalDelegate::~QSqlRelationalDelegate
    {35, 17, 456},	// QSqlRelationalTableModel::InnerJoin
    {35, 20, 457},	// QSqlRelationalTableModel::LeftJoin
    {35, 76, 450},	// QSqlRelationalTableModel::QSqlRelationalTableModel
    {35, 77, 451},	// QSqlRelationalTableModel::QSqlRelationalTableModel#
    {35, 78, 432},	// QSqlRelationalTableModel::QSqlRelationalTableModel##
    {35, 138, 436},	// QSqlRelationalTableModel::clear
    {35, 163, 452},	// QSqlRelationalTableModel::data#
    {35, 164, 433},	// QSqlRelationalTableModel::data#$
    {35, 242, 446},	// QSqlRelationalTableModel::insertRowIntoTable#
    {35, 277, 425},	// QSqlRelationalTableModel::metaObject
    {35, 305, 447},	// QSqlRelationalTableModel::orderByClause
    {35, 319, 431},	// QSqlRelationalTableModel::qt_metacall$$?
    {35, 321, 426},	// QSqlRelationalTableModel::qt_metacast$
    {35, 329, 440},	// QSqlRelationalTableModel::relation$
    {35, 331, 441},	// QSqlRelationalTableModel::relationModel$
    {35, 335, 454},	// QSqlRelationalTableModel::removeColumns$$
    {35, 336, 435},	// QSqlRelationalTableModel::removeColumns$$#
    {35, 351, 443},	// QSqlRelationalTableModel::revertRow$
    {35, 361, 437},	// QSqlRelationalTableModel::select
    {35, 362, 444},	// QSqlRelationalTableModel::selectStatement
    {35, 374, 453},	// QSqlRelationalTableModel::setData##
    {35, 375, 434},	// QSqlRelationalTableModel::setData##$
    {35, 406, 442},	// QSqlRelationalTableModel::setJoinMode$
    {35, 442, 439},	// QSqlRelationalTableModel::setRelation$#
    {35, 454, 438},	// QSqlRelationalTableModel::setTable$
    {35, 469, 455},	// QSqlRelationalTableModel::staticMetaObject
    {35, 489, 448},	// QSqlRelationalTableModel::tr$
    {35, 490, 427},	// QSqlRelationalTableModel::tr$$
    {35, 491, 429},	// QSqlRelationalTableModel::tr$$$
    {35, 493, 449},	// QSqlRelationalTableModel::trUtf8$
    {35, 494, 428},	// QSqlRelationalTableModel::trUtf8$$
    {35, 495, 430},	// QSqlRelationalTableModel::trUtf8$$$
    {35, 505, 445},	// QSqlRelationalTableModel::updateRowInTable$#
    {35, 524, 458},	// QSqlRelationalTableModel::~QSqlRelationalTableModel
    {36, 4, 513},	// QSqlResult::BatchOperation
    {36, 10, 514},	// QSqlResult::DetachFromResultSet
    {36, 26, 512},	// QSqlResult::NamedBinding
    {36, 28, 516},	// QSqlResult::NextResult
    {36, 35, 511},	// QSqlResult::PositionalBinding
    {36, 80, 460},	// QSqlResult::QSqlResult#
    {36, 87, 515},	// QSqlResult::SetNumericalPrecision
    {36, 105, 480},	// QSqlResult::addBindValue#$
    {36, 114, 461},	// QSqlResult::at
    {36, 124, -4},	// QSqlResult::bindValue$#$
    {36, 126, -7},	// QSqlResult::bindValueType$
    {36, 127, 491},	// QSqlResult::bindingSyntax
    {36, 129, -10},	// QSqlResult::boundValue$
    {36, 130, 485},	// QSqlResult::boundValueCount
    {36, 132, 488},	// QSqlResult::boundValueName$
    {36, 133, 486},	// QSqlResult::boundValues
    {36, 138, 489},	// QSqlResult::clear
    {36, 165, 492},	// QSqlResult::data$
    {36, 175, 506},	// QSqlResult::detachFromResultSet
    {36, 182, 468},	// QSqlResult::driver
    {36, 193, 475},	// QSqlResult::exec
    {36, 195, 510},	// QSqlResult::execBatch
    {36, 196, 505},	// QSqlResult::execBatch$
    {36, 197, 487},	// QSqlResult::executedQuery
    {36, 199, 495},	// QSqlResult::fetch$
    {36, 200, 498},	// QSqlResult::fetchFirst
    {36, 201, 499},	// QSqlResult::fetchLast
    {36, 204, 496},	// QSqlResult::fetchNext
    {36, 205, 497},	// QSqlResult::fetchPrevious
    {36, 220, 459},	// QSqlResult::handle
    {36, 223, 490},	// QSqlResult::hasOutValues
    {36, 246, 465},	// QSqlResult::isActive
    {36, 255, 467},	// QSqlResult::isForwardOnly
    {36, 263, 493},	// QSqlResult::isNull$
    {36, 267, 466},	// QSqlResult::isSelect
    {36, 268, 464},	// QSqlResult::isValid
    {36, 272, 463},	// QSqlResult::lastError
    {36, 273, 503},	// QSqlResult::lastInsertId
    {36, 274, 462},	// QSqlResult::lastQuery
    {36, 282, 509},	// QSqlResult::nextResult
    {36, 285, 501},	// QSqlResult::numRowsAffected
    {36, 287, 508},	// QSqlResult::numericalPrecisionPolicy
    {36, 311, 476},	// QSqlResult::prepare$
    {36, 324, 502},	// QSqlResult::record
    {36, 346, 494},	// QSqlResult::reset$
    {36, 357, 477},	// QSqlResult::savePrepare$
    {36, 364, 470},	// QSqlResult::setActive$
    {36, 366, 469},	// QSqlResult::setAt$
    {36, 395, 474},	// QSqlResult::setForwardOnly$
    {36, 408, 471},	// QSqlResult::setLastError#
    {36, 420, 507},	// QSqlResult::setNumericalPrecisionPolicy$
    {36, 435, 472},	// QSqlResult::setQuery$
    {36, 448, 473},	// QSqlResult::setSelect$
    {36, 462, 500},	// QSqlResult::size
    {36, 510, 504},	// QSqlResult::virtual_hook$$
    {36, 525, 517},	// QSqlResult::~QSqlResult
    {37, 30, 579},	// QSqlTableModel::OnFieldChange
    {37, 31, 581},	// QSqlTableModel::OnManualSubmit
    {37, 32, 580},	// QSqlTableModel::OnRowChange
    {37, 81, 569},	// QSqlTableModel::QSqlTableModel
    {37, 82, 570},	// QSqlTableModel::QSqlTableModel#
    {37, 83, 525},	// QSqlTableModel::QSqlTableModel##
    {37, 116, 558},	// QSqlTableModel::beforeDelete$
    {37, 118, 556},	// QSqlTableModel::beforeInsert#
    {37, 120, 557},	// QSqlTableModel::beforeUpdate$#
    {37, 138, 534},	// QSqlTableModel::clear
    {37, 163, 571},	// QSqlTableModel::data#
    {37, 164, 530},	// QSqlTableModel::data#$
    {37, 166, 538},	// QSqlTableModel::database
    {37, 174, 561},	// QSqlTableModel::deleteRowFromTable$
    {37, 187, 536},	// QSqlTableModel::editStrategy
    {37, 209, 539},	// QSqlTableModel::fieldIndex$
    {37, 212, 542},	// QSqlTableModel::filter
    {37, 216, 529},	// QSqlTableModel::flags#
    {37, 225, 573},	// QSqlTableModel::headerData$$
    {37, 226, 532},	// QSqlTableModel::headerData$$$
    {37, 231, 566},	// QSqlTableModel::indexInQuery#
    {37, 240, 548},	// QSqlTableModel::insertRecord$#
    {37, 242, 560},	// QSqlTableModel::insertRowIntoTable#
    {37, 244, 577},	// QSqlTableModel::insertRows$$
    {37, 245, 547},	// QSqlTableModel::insertRows$$#
    {37, 251, 533},	// QSqlTableModel::isDirty#
    {37, 277, 518},	// QSqlTableModel::metaObject
    {37, 305, 562},	// QSqlTableModel::orderByClause
    {37, 315, 537},	// QSqlTableModel::primaryKey
    {37, 317, 555},	// QSqlTableModel::primeInsert$#
    {37, 319, 524},	// QSqlTableModel::qt_metacall$$?
    {37, 321, 519},	// QSqlTableModel::qt_metacast$
    {37, 335, 575},	// QSqlTableModel::removeColumns$$
    {37, 336, 545},	// QSqlTableModel::removeColumns$$#
    {37, 340, 576},	// QSqlTableModel::removeRows$$
    {37, 341, 546},	// QSqlTableModel::removeRows$$#
    {37, 348, 552},	// QSqlTableModel::revert
    {37, 349, 554},	// QSqlTableModel::revertAll
    {37, 351, 550},	// QSqlTableModel::revertRow$
    {37, 354, 574},	// QSqlTableModel::rowCount
    {37, 355, 544},	// QSqlTableModel::rowCount#
    {37, 361, 526},	// QSqlTableModel::select
    {37, 362, 563},	// QSqlTableModel::selectStatement
    {37, 374, 572},	// QSqlTableModel::setData##
    {37, 375, 531},	// QSqlTableModel::setData##$
    {37, 389, 535},	// QSqlTableModel::setEditStrategy$
    {37, 393, 543},	// QSqlTableModel::setFilter$
    {37, 432, 564},	// QSqlTableModel::setPrimaryKey#
    {37, 434, 565},	// QSqlTableModel::setQuery#
    {37, 440, 549},	// QSqlTableModel::setRecord$#
    {37, 450, 541},	// QSqlTableModel::setSort$$
    {37, 454, 527},	// QSqlTableModel::setTable$
    {37, 465, 540},	// QSqlTableModel::sort$$
    {37, 469, 578},	// QSqlTableModel::staticMetaObject
    {37, 474, 551},	// QSqlTableModel::submit
    {37, 475, 553},	// QSqlTableModel::submitAll
    {37, 483, 528},	// QSqlTableModel::tableName
    {37, 489, 567},	// QSqlTableModel::tr$
    {37, 490, 520},	// QSqlTableModel::tr$$
    {37, 491, 522},	// QSqlTableModel::tr$$$
    {37, 493, 568},	// QSqlTableModel::trUtf8$
    {37, 494, 521},	// QSqlTableModel::trUtf8$$
    {37, 495, 523},	// QSqlTableModel::trUtf8$$$
    {37, 505, 559},	// QSqlTableModel::updateRowInTable$#
    {37, 526, 582},	// QSqlTableModel::~QSqlTableModel
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();
SMOKE_IMPORT void init_qtgui_Smoke();

static bool initialized = false;
Smoke *qtsql_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qtsql_Smoke() {
    init_qtcore_Smoke();
    init_qtgui_Smoke();
    if (initialized) return;
    qtsql_Smoke = new Smoke(
        "qtsql",
        __smokeqtsql::classes, 42,
        __smokeqtsql::methods, 583,
        __smokeqtsql::methodMaps, 525,
        __smokeqtsql::methodNames, 526,
        __smokeqtsql::types, 186,
        __smokeqtsql::inheritanceList,
        __smokeqtsql::argumentList,
        __smokeqtsql::ambiguousMethodList,
        __smokeqtsql::cast );
    initialized = true;
}

void delete_qtsql_Smoke() { delete qtsql_Smoke; }

}
