#include <qtopengl_includes.h>

#include <smoke.h>
#include <qtopengl_smoke.h>

namespace __smokeqtopengl {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QActionEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QActionEvent*)xptr;
        case 1: return (void*)(QActionEvent*)xptr;
        default: return xptr;
      }
    case 2:   //QBool
      switch(to) {
        case 2: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 3:   //QByteArray
      switch(to) {
        case 3: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 4:   //QChildEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 4: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 5:   //QCloseEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QCloseEvent*)xptr;
        case 5: return (void*)(QCloseEvent*)xptr;
        default: return xptr;
      }
    case 6:   //QColor
      switch(to) {
        case 6: return (void*)(QColor*)xptr;
        default: return xptr;
      }
    case 7:   //QContextMenuEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QContextMenuEvent*)xptr;
        case 7: return (void*)(QContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 8:   //QDebug
      switch(to) {
        case 8: return (void*)(QDebug*)xptr;
        default: return xptr;
      }
    case 9:   //QDragEnterEvent
      switch(to) {
        case 11: return (void*)(QDragMoveEvent*)(QDragEnterEvent*)xptr;
        case 12: return (void*)(QDropEvent*)(QDragEnterEvent*)xptr;
        case 13: return (void*)(QEvent*)(QDragEnterEvent*)xptr;
        case 9: return (void*)(QDragEnterEvent*)xptr;
        default: return xptr;
      }
    case 10:   //QDragLeaveEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QDragLeaveEvent*)xptr;
        case 10: return (void*)(QDragLeaveEvent*)xptr;
        default: return xptr;
      }
    case 11:   //QDragMoveEvent
      switch(to) {
        case 12: return (void*)(QDropEvent*)(QDragMoveEvent*)xptr;
        case 13: return (void*)(QEvent*)(QDragMoveEvent*)xptr;
        case 11: return (void*)(QDragMoveEvent*)xptr;
        default: return xptr;
      }
    case 12:   //QDropEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QDropEvent*)xptr;
        case 12: return (void*)(QDropEvent*)xptr;
        default: return xptr;
      }
    case 13:   //QEvent
      switch(to) {
        case 13: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 14:   //QFocusEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QFocusEvent*)xptr;
        case 14: return (void*)(QFocusEvent*)xptr;
        default: return xptr;
      }
    case 15:   //QFont
      switch(to) {
        case 15: return (void*)(QFont*)xptr;
        default: return xptr;
      }
    case 17:   //QGLBuffer
      switch(to) {
        case 17: return (void*)(QGLBuffer*)xptr;
        default: return xptr;
      }
    case 18:   //QGLColormap
      switch(to) {
        case 18: return (void*)(QGLColormap*)xptr;
        default: return xptr;
      }
    case 19:   //QGLContext
      switch(to) {
        case 19: return (void*)(QGLContext*)xptr;
        default: return xptr;
      }
    case 20:   //QGLFormat
      switch(to) {
        case 20: return (void*)(QGLFormat*)xptr;
        default: return xptr;
      }
    case 21:   //QGLFramebufferObject
      switch(to) {
        case 38: return (void*)(QPaintDevice*)(QGLFramebufferObject*)xptr;
        case 21: return (void*)(QGLFramebufferObject*)xptr;
        default: return xptr;
      }
    case 22:   //QGLFramebufferObjectFormat
      switch(to) {
        case 22: return (void*)(QGLFramebufferObjectFormat*)xptr;
        default: return xptr;
      }
    case 23:   //QGLPixelBuffer
      switch(to) {
        case 38: return (void*)(QPaintDevice*)(QGLPixelBuffer*)xptr;
        case 23: return (void*)(QGLPixelBuffer*)xptr;
        default: return xptr;
      }
    case 24:   //QGLShader
      switch(to) {
        case 37: return (void*)(QObject*)(QGLShader*)xptr;
        case 24: return (void*)(QGLShader*)xptr;
        default: return xptr;
      }
    case 25:   //QGLShaderProgram
      switch(to) {
        case 37: return (void*)(QObject*)(QGLShaderProgram*)xptr;
        case 25: return (void*)(QGLShaderProgram*)xptr;
        default: return xptr;
      }
    case 26:   //QGLWidget
      switch(to) {
        case 62: return (void*)(QWidget*)(QGLWidget*)xptr;
        case 37: return (void*)(QObject*)(QGLWidget*)xptr;
        case 38: return (void*)(QPaintDevice*)(QGLWidget*)xptr;
        case 26: return (void*)(QGLWidget*)xptr;
        default: return xptr;
      }
    case 28:   //QHideEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QHideEvent*)xptr;
        case 28: return (void*)(QHideEvent*)xptr;
        default: return xptr;
      }
    case 29:   //QImage
      switch(to) {
        case 38: return (void*)(QPaintDevice*)(QImage*)xptr;
        case 29: return (void*)(QImage*)xptr;
        default: return xptr;
      }
    case 30:   //QIncompatibleFlag
      switch(to) {
        case 30: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 31:   //QInputMethodEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QInputMethodEvent*)xptr;
        case 31: return (void*)(QInputMethodEvent*)xptr;
        default: return xptr;
      }
    case 32:   //QKeyEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QKeyEvent*)xptr;
        case 32: return (void*)(QKeyEvent*)xptr;
        default: return xptr;
      }
    case 33:   //QMatrix4x4
      switch(to) {
        case 33: return (void*)(QMatrix4x4*)xptr;
        default: return xptr;
      }
    case 34:   //QMetaObject
      switch(to) {
        case 34: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 35:   //QMouseEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QMouseEvent*)xptr;
        case 35: return (void*)(QMouseEvent*)xptr;
        default: return xptr;
      }
    case 36:   //QMoveEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QMoveEvent*)xptr;
        case 36: return (void*)(QMoveEvent*)xptr;
        default: return xptr;
      }
    case 37:   //QObject
      switch(to) {
        case 37: return (void*)(QObject*)xptr;
        case 25: return (void*)(QGLShaderProgram*)(QObject*)xptr;
        case 26: return (void*)(QGLWidget*)(QObject*)xptr;
        case 24: return (void*)(QGLShader*)(QObject*)xptr;
        default: return xptr;
      }
    case 38:   //QPaintDevice
      switch(to) {
        case 38: return (void*)(QPaintDevice*)xptr;
        case 21: return (void*)(QGLFramebufferObject*)(QPaintDevice*)xptr;
        case 26: return (void*)(QGLWidget*)(QPaintDevice*)xptr;
        case 23: return (void*)(QGLPixelBuffer*)(QPaintDevice*)xptr;
        default: return xptr;
      }
    case 39:   //QPaintEngine
      switch(to) {
        case 39: return (void*)(QPaintEngine*)xptr;
        default: return xptr;
      }
    case 40:   //QPaintEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QPaintEvent*)xptr;
        case 40: return (void*)(QPaintEvent*)xptr;
        default: return xptr;
      }
    case 41:   //QPalette
      switch(to) {
        case 41: return (void*)(QPalette*)xptr;
        default: return xptr;
      }
    case 42:   //QPixmap
      switch(to) {
        case 38: return (void*)(QPaintDevice*)(QPixmap*)xptr;
        case 42: return (void*)(QPixmap*)xptr;
        default: return xptr;
      }
    case 43:   //QPoint
      switch(to) {
        case 43: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 44:   //QPointF
      switch(to) {
        case 44: return (void*)(QPointF*)xptr;
        default: return xptr;
      }
    case 45:   //QRect
      switch(to) {
        case 45: return (void*)(QRect*)xptr;
        default: return xptr;
      }
    case 46:   //QRectF
      switch(to) {
        case 46: return (void*)(QRectF*)xptr;
        default: return xptr;
      }
    case 47:   //QRegExp
      switch(to) {
        case 47: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 48:   //QResizeEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QResizeEvent*)xptr;
        case 48: return (void*)(QResizeEvent*)xptr;
        default: return xptr;
      }
    case 49:   //QShowEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QShowEvent*)xptr;
        case 49: return (void*)(QShowEvent*)xptr;
        default: return xptr;
      }
    case 50:   //QSize
      switch(to) {
        case 50: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 51:   //QSizeF
      switch(to) {
        case 51: return (void*)(QSizeF*)xptr;
        default: return xptr;
      }
    case 52:   //QStyle
      switch(to) {
        case 37: return (void*)(QObject*)(QStyle*)xptr;
        case 52: return (void*)(QStyle*)xptr;
        default: return xptr;
      }
    case 53:   //QTabletEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QTabletEvent*)xptr;
        case 53: return (void*)(QTabletEvent*)xptr;
        default: return xptr;
      }
    case 54:   //QTextCodec
      switch(to) {
        case 54: return (void*)(QTextCodec*)xptr;
        default: return xptr;
      }
    case 55:   //QTimerEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 55: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 56:   //QTransform
      switch(to) {
        case 56: return (void*)(QTransform*)xptr;
        default: return xptr;
      }
    case 57:   //QVariant
      switch(to) {
        case 57: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 58:   //QVector2D
      switch(to) {
        case 58: return (void*)(QVector2D*)xptr;
        default: return xptr;
      }
    case 59:   //QVector3D
      switch(to) {
        case 59: return (void*)(QVector3D*)xptr;
        default: return xptr;
      }
    case 60:   //QVector4D
      switch(to) {
        case 60: return (void*)(QVector4D*)xptr;
        default: return xptr;
      }
    case 61:   //QWheelEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QWheelEvent*)xptr;
        case 61: return (void*)(QWheelEvent*)xptr;
        default: return xptr;
      }
    case 62:   //QWidget
      switch(to) {
        case 37: return (void*)(QObject*)(QWidget*)xptr;
        case 38: return (void*)(QPaintDevice*)(QWidget*)xptr;
        case 62: return (void*)(QWidget*)xptr;
        case 26: return (void*)(QGLWidget*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    38, 0,	// 1: QPaintDevice
    37, 0,	// 3: QObject
    62, 0,	// 5: QWidget
};

// These are the xenum functions for manipulating enum pointers
void xenum_QGLBuffer(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QGLContext(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QGLShader(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QGLFramebufferObject(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QGLFormat(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QGL(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QGL(Smoke::Index, void*, Smoke::Stack);
void xcall_QGLBuffer(Smoke::Index, void*, Smoke::Stack);
void xcall_QGLColormap(Smoke::Index, void*, Smoke::Stack);
void xcall_QGLContext(Smoke::Index, void*, Smoke::Stack);
void xcall_QGLFormat(Smoke::Index, void*, Smoke::Stack);
void xcall_QGLFramebufferObject(Smoke::Index, void*, Smoke::Stack);
void xcall_QGLFramebufferObjectFormat(Smoke::Index, void*, Smoke::Stack);
void xcall_QGLPixelBuffer(Smoke::Index, void*, Smoke::Stack);
void xcall_QGLShader(Smoke::Index, void*, Smoke::Stack);
void xcall_QGLShaderProgram(Smoke::Index, void*, Smoke::Stack);
void xcall_QGLWidget(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QActionEvent", true, 0, 0, 0, 0, 0 },	//1
    { "QBool", true, 0, 0, 0, 0, 0 },	//2
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//3
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//4
    { "QCloseEvent", true, 0, 0, 0, 0, 0 },	//5
    { "QColor", true, 0, 0, 0, 0, 0 },	//6
    { "QContextMenuEvent", true, 0, 0, 0, 0, 0 },	//7
    { "QDebug", true, 0, 0, 0, 0, 0 },	//8
    { "QDragEnterEvent", true, 0, 0, 0, 0, 0 },	//9
    { "QDragLeaveEvent", true, 0, 0, 0, 0, 0 },	//10
    { "QDragMoveEvent", true, 0, 0, 0, 0, 0 },	//11
    { "QDropEvent", true, 0, 0, 0, 0, 0 },	//12
    { "QEvent", true, 0, 0, 0, 0, 0 },	//13
    { "QFocusEvent", true, 0, 0, 0, 0, 0 },	//14
    { "QFont", true, 0, 0, 0, 0, 0 },	//15
    { "QGL", false, 0, xcall_QGL, xenum_QGL, Smoke::cf_namespace, 0 },	//16
    { "QGLBuffer", false, 0, xcall_QGLBuffer, xenum_QGLBuffer, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QGLBuffer) },	//17
    { "QGLColormap", false, 0, xcall_QGLColormap, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QGLColormap) },	//18
    { "QGLContext", false, 0, xcall_QGLContext, xenum_QGLContext, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QGLContext) },	//19
    { "QGLFormat", false, 0, xcall_QGLFormat, xenum_QGLFormat, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QGLFormat) },	//20
    { "QGLFramebufferObject", false, 1, xcall_QGLFramebufferObject, xenum_QGLFramebufferObject, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QGLFramebufferObject) },	//21
    { "QGLFramebufferObjectFormat", false, 0, xcall_QGLFramebufferObjectFormat, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QGLFramebufferObjectFormat) },	//22
    { "QGLPixelBuffer", false, 1, xcall_QGLPixelBuffer, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QGLPixelBuffer) },	//23
    { "QGLShader", false, 3, xcall_QGLShader, xenum_QGLShader, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QGLShader) },	//24
    { "QGLShaderProgram", false, 3, xcall_QGLShaderProgram, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QGLShaderProgram) },	//25
    { "QGLWidget", false, 5, xcall_QGLWidget, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QGLWidget) },	//26
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//27
    { "QHideEvent", true, 0, 0, 0, 0, 0 },	//28
    { "QImage", true, 0, 0, 0, 0, 0 },	//29
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//30
    { "QInputMethodEvent", true, 0, 0, 0, 0, 0 },	//31
    { "QKeyEvent", true, 0, 0, 0, 0, 0 },	//32
    { "QMatrix4x4", true, 0, 0, 0, 0, 0 },	//33
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//34
    { "QMouseEvent", true, 0, 0, 0, 0, 0 },	//35
    { "QMoveEvent", true, 0, 0, 0, 0, 0 },	//36
    { "QObject", true, 0, 0, 0, 0, 0 },	//37
    { "QPaintDevice", true, 0, 0, 0, 0, 0 },	//38
    { "QPaintEngine", true, 0, 0, 0, 0, 0 },	//39
    { "QPaintEvent", true, 0, 0, 0, 0, 0 },	//40
    { "QPalette", true, 0, 0, 0, 0, 0 },	//41
    { "QPixmap", true, 0, 0, 0, 0, 0 },	//42
    { "QPoint", true, 0, 0, 0, 0, 0 },	//43
    { "QPointF", true, 0, 0, 0, 0, 0 },	//44
    { "QRect", true, 0, 0, 0, 0, 0 },	//45
    { "QRectF", true, 0, 0, 0, 0, 0 },	//46
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//47
    { "QResizeEvent", true, 0, 0, 0, 0, 0 },	//48
    { "QShowEvent", true, 0, 0, 0, 0, 0 },	//49
    { "QSize", true, 0, 0, 0, 0, 0 },	//50
    { "QSizeF", true, 0, 0, 0, 0, 0 },	//51
    { "QStyle", true, 0, 0, 0, 0, 0 },	//52
    { "QTabletEvent", true, 0, 0, 0, 0, 0 },	//53
    { "QTextCodec", true, 0, 0, 0, 0, 0 },	//54
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//55
    { "QTransform", true, 0, 0, 0, 0, 0 },	//56
    { "QVariant", true, 0, 0, 0, 0, 0 },	//57
    { "QVector2D", true, 0, 0, 0, 0, 0 },	//58
    { "QVector3D", true, 0, 0, 0, 0, 0 },	//59
    { "QVector4D", true, 0, 0, 0, 0, 0 },	//60
    { "QWheelEvent", true, 0, 0, 0, 0, 0 },	//61
    { "QWidget", true, 0, 0, 0, 0, 0 },	//62
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "2", 0, Smoke::t_voidp|Smoke::tf_stack },	//1
    { "3", 0, Smoke::t_voidp|Smoke::tf_stack },	//2
    { "4", 0, Smoke::t_voidp|Smoke::tf_stack },	//3
    { "GLbitfield", 0, Smoke::t_voidp|Smoke::tf_stack },	//4
    { "GLenum", 0, Smoke::t_voidp|Smoke::tf_stack },	//5
    { "GLfloat", 0, Smoke::t_voidp|Smoke::tf_stack },	//6
    { "GLint", 0, Smoke::t_voidp|Smoke::tf_stack },	//7
    { "GLuint", 0, Smoke::t_voidp|Smoke::tf_stack },	//8
    { "QAccessible2::BoundaryType", 0, Smoke::t_enum|Smoke::tf_stack },	//9
    { "QAccessible2::CoordinateType", 0, Smoke::t_enum|Smoke::tf_stack },	//10
    { "QAccessible2::InterfaceType", 0, Smoke::t_enum|Smoke::tf_stack },	//11
    { "QAccessible2::TableModelChangeType", 0, Smoke::t_enum|Smoke::tf_stack },	//12
    { "QActionEvent*", 1, Smoke::t_class|Smoke::tf_ptr },	//13
    { "QBool", 2, Smoke::t_class|Smoke::tf_stack },	//14
    { "QByteArray", 3, Smoke::t_class|Smoke::tf_stack },	//15
    { "QChildEvent*", 4, Smoke::t_class|Smoke::tf_ptr },	//16
    { "QCloseEvent*", 5, Smoke::t_class|Smoke::tf_ptr },	//17
    { "QColor", 6, Smoke::t_class|Smoke::tf_stack },	//18
    { "QContextMenuEvent*", 7, Smoke::t_class|Smoke::tf_ptr },	//19
    { "QDebug", 8, Smoke::t_class|Smoke::tf_stack },	//20
    { "QDragEnterEvent*", 9, Smoke::t_class|Smoke::tf_ptr },	//21
    { "QDragLeaveEvent*", 10, Smoke::t_class|Smoke::tf_ptr },	//22
    { "QDragMoveEvent*", 11, Smoke::t_class|Smoke::tf_ptr },	//23
    { "QDrawBorderPixmap::DrawingHint", 0, Smoke::t_enum|Smoke::tf_stack },	//24
    { "QDropEvent*", 12, Smoke::t_class|Smoke::tf_ptr },	//25
    { "QEvent*", 13, Smoke::t_class|Smoke::tf_ptr },	//26
    { "QFlags<QGL::FormatOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//27
    { "QFlags<QGLContext::BindOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//28
    { "QFlags<QGLFormat::OpenGLVersionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//29
    { "QFlags<QGLFunctions::OpenGLFeature>", 0, Smoke::t_uint|Smoke::tf_stack },	//30
    { "QFlags<QGLShader::ShaderTypeBit>", 0, Smoke::t_uint|Smoke::tf_stack },	//31
    { "QFlags<Qt::WindowType>", 0, Smoke::t_uint|Smoke::tf_stack },	//32
    { "QFocusEvent*", 14, Smoke::t_class|Smoke::tf_ptr },	//33
    { "QGL::FormatOption", 16, Smoke::t_enum|Smoke::tf_stack },	//34
    { "QGLBuffer&", 17, Smoke::t_class|Smoke::tf_ref },	//35
    { "QGLBuffer*", 17, Smoke::t_class|Smoke::tf_ptr },	//36
    { "QGLBuffer::Access", 17, Smoke::t_enum|Smoke::tf_stack },	//37
    { "QGLBuffer::Type", 17, Smoke::t_enum|Smoke::tf_stack },	//38
    { "QGLBuffer::UsagePattern", 17, Smoke::t_enum|Smoke::tf_stack },	//39
    { "QGLColormap&", 18, Smoke::t_class|Smoke::tf_ref },	//40
    { "QGLColormap*", 18, Smoke::t_class|Smoke::tf_ptr },	//41
    { "QGLContext*", 19, Smoke::t_class|Smoke::tf_ptr },	//42
    { "QGLContext::BindOption", 19, Smoke::t_enum|Smoke::tf_stack },	//43
    { "QGLFormat", 20, Smoke::t_class|Smoke::tf_stack },	//44
    { "QGLFormat&", 20, Smoke::t_class|Smoke::tf_ref },	//45
    { "QGLFormat*", 20, Smoke::t_class|Smoke::tf_ptr },	//46
    { "QGLFormat::OpenGLContextProfile", 20, Smoke::t_enum|Smoke::tf_stack },	//47
    { "QGLFormat::OpenGLVersionFlag", 20, Smoke::t_enum|Smoke::tf_stack },	//48
    { "QGLFramebufferObject*", 21, Smoke::t_class|Smoke::tf_ptr },	//49
    { "QGLFramebufferObject::Attachment", 21, Smoke::t_enum|Smoke::tf_stack },	//50
    { "QGLFramebufferObjectFormat", 22, Smoke::t_class|Smoke::tf_stack },	//51
    { "QGLFramebufferObjectFormat&", 22, Smoke::t_class|Smoke::tf_ref },	//52
    { "QGLFramebufferObjectFormat*", 22, Smoke::t_class|Smoke::tf_ptr },	//53
    { "QGLFunctions::OpenGLFeature", 0, Smoke::t_enum|Smoke::tf_stack },	//54
    { "QGLPixelBuffer*", 23, Smoke::t_class|Smoke::tf_ptr },	//55
    { "QGLShader*", 24, Smoke::t_class|Smoke::tf_ptr },	//56
    { "QGLShader::ShaderTypeBit", 24, Smoke::t_enum|Smoke::tf_stack },	//57
    { "QGLShaderProgram*", 25, Smoke::t_class|Smoke::tf_ptr },	//58
    { "QGLWidget*", 26, Smoke::t_class|Smoke::tf_ptr },	//59
    { "QHideEvent*", 28, Smoke::t_class|Smoke::tf_ptr },	//60
    { "QImage", 29, Smoke::t_class|Smoke::tf_stack },	//61
    { "QIncompatibleFlag", 30, Smoke::t_class|Smoke::tf_stack },	//62
    { "QInputMethodEvent*", 31, Smoke::t_class|Smoke::tf_ptr },	//63
    { "QKeyEvent*", 32, Smoke::t_class|Smoke::tf_ptr },	//64
    { "QList<QGLShader*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//65
    { "QMetaObject::Call", 34, Smoke::t_enum|Smoke::tf_stack },	//66
    { "QMouseEvent*", 35, Smoke::t_class|Smoke::tf_ptr },	//67
    { "QMoveEvent*", 36, Smoke::t_class|Smoke::tf_ptr },	//68
    { "QObject*", 37, Smoke::t_class|Smoke::tf_ptr },	//69
    { "QPaintDevice*", 38, Smoke::t_class|Smoke::tf_ptr },	//70
    { "QPaintDevice::PaintDeviceMetric", 38, Smoke::t_enum|Smoke::tf_stack },	//71
    { "QPaintEngine*", 39, Smoke::t_class|Smoke::tf_ptr },	//72
    { "QPaintEngine::Type", 39, Smoke::t_enum|Smoke::tf_stack },	//73
    { "QPaintEvent*", 40, Smoke::t_class|Smoke::tf_ptr },	//74
    { "QPixmap", 42, Smoke::t_class|Smoke::tf_stack },	//75
    { "QRegExp&", 47, Smoke::t_class|Smoke::tf_ref },	//76
    { "QResizeEvent*", 48, Smoke::t_class|Smoke::tf_ptr },	//77
    { "QShowEvent*", 49, Smoke::t_class|Smoke::tf_ptr },	//78
    { "QSize", 50, Smoke::t_class|Smoke::tf_stack },	//79
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//80
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//81
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//82
    { "QStyle&", 52, Smoke::t_class|Smoke::tf_ref },	//83
    { "QTabletEvent*", 53, Smoke::t_class|Smoke::tf_ptr },	//84
    { "QTextCodec*", 54, Smoke::t_class|Smoke::tf_ptr },	//85
    { "QTimerEvent*", 55, Smoke::t_class|Smoke::tf_ptr },	//86
    { "QVariant", 57, Smoke::t_class|Smoke::tf_stack },	//87
    { "QWheelEvent*", 61, Smoke::t_class|Smoke::tf_ptr },	//88
    { "QWidget*", 62, Smoke::t_class|Smoke::tf_ptr },	//89
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//90
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//91
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//92
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//93
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//94
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//95
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//96
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//97
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//98
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//99
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//100
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//101
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//102
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//103
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//104
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//105
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//106
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//107
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//108
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//109
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//110
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//111
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//112
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//113
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//114
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//115
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//116
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//117
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//118
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//119
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//120
    { "Qt::HitTestAccuracy", 0, Smoke::t_enum|Smoke::tf_stack },	//121
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//122
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//123
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//124
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//125
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//126
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//127
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//128
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//129
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//130
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//131
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//132
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//133
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//134
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//135
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//136
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//137
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//138
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//139
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//140
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//141
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//142
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//143
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//144
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//145
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//146
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//147
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//148
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//149
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//150
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//151
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//152
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//153
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//154
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//155
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//156
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//157
    { "Qt::WhiteSpaceMode", 0, Smoke::t_enum|Smoke::tf_stack },	//158
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//159
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//160
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//161
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//162
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//163
    { "QtConcurrent::ReduceOption", 0, Smoke::t_enum|Smoke::tf_stack },	//164
    { "QtConcurrent::ThreadFunctionResult", 0, Smoke::t_enum|Smoke::tf_stack },	//165
    { "_XEvent*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//166
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//167
    { "const GLfloat*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//168
    { "const GLfloat[2][2]", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//169
    { "const GLfloat[3][3]", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//170
    { "const GLfloat[4][4]", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//171
    { "const GLint*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//172
    { "const GLuint*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//173
    { "const QByteArray&", 3, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//174
    { "const QColor&", 6, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//175
    { "const QFont&", 15, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//176
    { "const QGLBuffer&", 17, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//177
    { "const QGLColormap&", 18, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//178
    { "const QGLContext*", 19, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//179
    { "const QGLFormat&", 20, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//180
    { "const QGLFramebufferObjectFormat&", 22, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//181
    { "const QGLWidget*", 26, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//182
    { "const QGenericMatrix<2,2,double>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//183
    { "const QGenericMatrix<2,2,double>*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//184
    { "const QGenericMatrix<2,3,double>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//185
    { "const QGenericMatrix<2,3,double>*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//186
    { "const QGenericMatrix<2,4,double>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//187
    { "const QGenericMatrix<2,4,double>*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//188
    { "const QGenericMatrix<3,2,double>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//189
    { "const QGenericMatrix<3,2,double>*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//190
    { "const QGenericMatrix<3,3,double>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//191
    { "const QGenericMatrix<3,3,double>*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//192
    { "const QGenericMatrix<3,4,double>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//193
    { "const QGenericMatrix<3,4,double>*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//194
    { "const QGenericMatrix<4,2,double>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//195
    { "const QGenericMatrix<4,2,double>*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//196
    { "const QGenericMatrix<4,3,double>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//197
    { "const QGenericMatrix<4,3,double>*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//198
    { "const QImage&", 29, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//199
    { "const QMatrix4x4&", 33, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//200
    { "const QMatrix4x4*", 33, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//201
    { "const QMetaObject&", 34, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//202
    { "const QMetaObject*", 34, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//203
    { "const QPalette&", 41, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//204
    { "const QPixmap&", 42, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//205
    { "const QPoint&", 43, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//206
    { "const QPointF&", 44, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//207
    { "const QRect&", 45, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//208
    { "const QRectF&", 46, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//209
    { "const QRegExp&", 47, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//210
    { "const QSize&", 50, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//211
    { "const QSizeF&", 51, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//212
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//213
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//214
    { "const QTransform&", 56, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//215
    { "const QVector2D&", 58, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//216
    { "const QVector2D*", 58, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//217
    { "const QVector3D&", 59, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//218
    { "const QVector3D*", 59, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//219
    { "const QVector4D&", 60, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//220
    { "const QVector4D*", 60, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//221
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//222
    { "const unsigned int*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//223
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//224
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//225
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//226
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//227
    { "unsigned int", 0, Smoke::t_uint|Smoke::tf_stack },	//228
    { "unsigned long", 0, Smoke::t_ulong|Smoke::tf_stack },	//229
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//230
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//231
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//232
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    73, 0,	//1  QPaintEngine::Type
    38, 0,	//3  QGLBuffer::Type
    177, 0,	//5  const QGLBuffer&
    39, 0,	//7  QGLBuffer::UsagePattern
    226, 230, 226, 0,	//9  int, void*, int
    226, 224, 226, 0,	//13  int, const void*, int
    224, 226, 0,	//17  const void*, int
    226, 0,	//20  int
    37, 0,	//22  QGLBuffer::Access
    178, 0,	//24  const QGLColormap&
    226, 223, 226, 0,	//26  int, const unsigned int*, int
    226, 228, 0,	//30  int, unsigned int
    226, 175, 0,	//33  int, const QColor&
    228, 0,	//36  unsigned int
    229, 0,	//38  unsigned long
    226, 223, 0,	//40  int, const unsigned int*
    180, 70, 0,	//43  const QGLFormat&, QPaintDevice*
    180, 0,	//46  const QGLFormat&
    179, 0,	//48  const QGLContext*
    179, 179, 0,	//50  const QGLContext*, const QGLContext*
    199, 5, 7, 28, 0,	//53  const QImage&, GLenum, GLint, QFlags<QGLContext::BindOption>
    205, 5, 7, 28, 0,	//58  const QPixmap&, GLenum, GLint, QFlags<QGLContext::BindOption>
    199, 5, 7, 0,	//63  const QImage&, GLenum, GLint
    205, 5, 7, 0,	//67  const QPixmap&, GLenum, GLint
    213, 0,	//71  const QString&
    8, 0,	//73  GLuint
    209, 8, 5, 0,	//75  const QRectF&, GLuint, GLenum
    207, 8, 5, 0,	//79  const QPointF&, GLuint, GLenum
    180, 226, 0,	//83  const QGLFormat&, int
    167, 0,	//86  bool
    176, 226, 0,	//88  const QFont&, int
    175, 0,	//91  const QColor&
    70, 0,	//93  QPaintDevice*
    199, 0,	//95  const QImage&
    199, 5, 0,	//97  const QImage&, GLenum
    205, 0,	//100  const QPixmap&
    205, 5, 0,	//102  const QPixmap&, GLenum
    209, 8, 0,	//105  const QRectF&, GLuint
    207, 8, 0,	//108  const QPointF&, GLuint
    42, 0,	//111  QGLContext*
    27, 226, 0,	//113  QFlags<QGL::FormatOption>, int
    27, 0,	//116  QFlags<QGL::FormatOption>
    226, 226, 0,	//118  int, int
    47, 0,	//121  QGLFormat::OpenGLContextProfile
    211, 5, 0,	//123  const QSize&, GLenum
    226, 226, 5, 0,	//126  int, int, GLenum
    211, 50, 5, 5, 0,	//130  const QSize&, QGLFramebufferObject::Attachment, GLenum, GLenum
    226, 226, 50, 5, 5, 0,	//135  int, int, QGLFramebufferObject::Attachment, GLenum, GLenum
    211, 181, 0,	//141  const QSize&, const QGLFramebufferObjectFormat&
    226, 226, 181, 0,	//144  int, int, const QGLFramebufferObjectFormat&
    49, 208, 49, 208, 4, 5, 0,	//148  QGLFramebufferObject*, const QRect&, QGLFramebufferObject*, const QRect&, GLbitfield, GLenum
    71, 0,	//155  QPaintDevice::PaintDeviceMetric
    211, 0,	//157  const QSize&
    211, 50, 0,	//159  const QSize&, QGLFramebufferObject::Attachment
    211, 50, 5, 0,	//162  const QSize&, QGLFramebufferObject::Attachment, GLenum
    226, 226, 50, 0,	//166  int, int, QGLFramebufferObject::Attachment
    226, 226, 50, 5, 0,	//170  int, int, QGLFramebufferObject::Attachment, GLenum
    49, 208, 49, 208, 0,	//175  QGLFramebufferObject*, const QRect&, QGLFramebufferObject*, const QRect&
    49, 208, 49, 208, 4, 0,	//180  QGLFramebufferObject*, const QRect&, QGLFramebufferObject*, const QRect&, GLbitfield
    181, 0,	//186  const QGLFramebufferObjectFormat&
    50, 0,	//188  QGLFramebufferObject::Attachment
    5, 0,	//190  GLenum
    211, 180, 59, 0,	//192  const QSize&, const QGLFormat&, QGLWidget*
    226, 226, 180, 59, 0,	//196  int, int, const QGLFormat&, QGLWidget*
    211, 180, 0,	//201  const QSize&, const QGLFormat&
    226, 226, 180, 0,	//204  int, int, const QGLFormat&
    222, 0,	//208  const char*
    222, 222, 0,	//210  const char*, const char*
    222, 222, 226, 0,	//213  const char*, const char*, int
    66, 226, 231, 0,	//217  QMetaObject::Call, int, void**
    31, 69, 0,	//221  QFlags<QGLShader::ShaderTypeBit>, QObject*
    31, 179, 69, 0,	//224  QFlags<QGLShader::ShaderTypeBit>, const QGLContext*, QObject*
    174, 0,	//228  const QByteArray&
    31, 179, 0,	//230  QFlags<QGLShader::ShaderTypeBit>, const QGLContext*
    31, 0,	//233  QFlags<QGLShader::ShaderTypeBit>
    69, 0,	//235  QObject*
    179, 69, 0,	//237  const QGLContext*, QObject*
    56, 0,	//240  QGLShader*
    31, 222, 0,	//242  QFlags<QGLShader::ShaderTypeBit>, const char*
    31, 174, 0,	//245  QFlags<QGLShader::ShaderTypeBit>, const QByteArray&
    31, 213, 0,	//248  QFlags<QGLShader::ShaderTypeBit>, const QString&
    222, 226, 0,	//251  const char*, int
    174, 226, 0,	//254  const QByteArray&, int
    213, 226, 0,	//257  const QString&, int
    226, 6, 0,	//260  int, GLfloat
    226, 6, 6, 0,	//263  int, GLfloat, GLfloat
    226, 6, 6, 6, 0,	//267  int, GLfloat, GLfloat, GLfloat
    226, 6, 6, 6, 6, 0,	//272  int, GLfloat, GLfloat, GLfloat, GLfloat
    226, 216, 0,	//278  int, const QVector2D&
    226, 218, 0,	//281  int, const QVector3D&
    226, 220, 0,	//284  int, const QVector4D&
    226, 168, 226, 226, 0,	//287  int, const GLfloat*, int, int
    222, 6, 0,	//292  const char*, GLfloat
    222, 6, 6, 0,	//295  const char*, GLfloat, GLfloat
    222, 6, 6, 6, 0,	//299  const char*, GLfloat, GLfloat, GLfloat
    222, 6, 6, 6, 6, 0,	//304  const char*, GLfloat, GLfloat, GLfloat, GLfloat
    222, 216, 0,	//310  const char*, const QVector2D&
    222, 218, 0,	//313  const char*, const QVector3D&
    222, 220, 0,	//316  const char*, const QVector4D&
    222, 175, 0,	//319  const char*, const QColor&
    222, 168, 226, 226, 0,	//322  const char*, const GLfloat*, int, int
    226, 217, 226, 0,	//327  int, const QVector2D*, int
    226, 219, 226, 0,	//331  int, const QVector3D*, int
    226, 221, 226, 0,	//335  int, const QVector4D*, int
    226, 5, 224, 226, 226, 0,	//339  int, GLenum, const void*, int, int
    222, 217, 226, 0,	//345  const char*, const QVector2D*, int
    222, 219, 226, 0,	//349  const char*, const QVector3D*, int
    222, 221, 226, 0,	//353  const char*, const QVector4D*, int
    222, 5, 224, 226, 226, 0,	//357  const char*, GLenum, const void*, int, int
    226, 5, 226, 226, 226, 0,	//363  int, GLenum, int, int, int
    222, 5, 226, 226, 226, 0,	//369  const char*, GLenum, int, int, int
    226, 7, 0,	//375  int, GLint
    226, 8, 0,	//378  int, GLuint
    226, 206, 0,	//381  int, const QPoint&
    226, 207, 0,	//384  int, const QPointF&
    226, 211, 0,	//387  int, const QSize&
    226, 212, 0,	//390  int, const QSizeF&
    226, 183, 0,	//393  int, const QGenericMatrix<2,2,double>&
    226, 185, 0,	//396  int, const QGenericMatrix<2,3,double>&
    226, 187, 0,	//399  int, const QGenericMatrix<2,4,double>&
    226, 189, 0,	//402  int, const QGenericMatrix<3,2,double>&
    226, 191, 0,	//405  int, const QGenericMatrix<3,3,double>&
    226, 193, 0,	//408  int, const QGenericMatrix<3,4,double>&
    226, 195, 0,	//411  int, const QGenericMatrix<4,2,double>&
    226, 197, 0,	//414  int, const QGenericMatrix<4,3,double>&
    226, 200, 0,	//417  int, const QMatrix4x4&
    226, 169, 0,	//420  int, const GLfloat[2][2]
    226, 170, 0,	//423  int, const GLfloat[3][3]
    226, 171, 0,	//426  int, const GLfloat[4][4]
    226, 215, 0,	//429  int, const QTransform&
    222, 7, 0,	//432  const char*, GLint
    222, 8, 0,	//435  const char*, GLuint
    222, 206, 0,	//438  const char*, const QPoint&
    222, 207, 0,	//441  const char*, const QPointF&
    222, 211, 0,	//444  const char*, const QSize&
    222, 212, 0,	//447  const char*, const QSizeF&
    222, 183, 0,	//450  const char*, const QGenericMatrix<2,2,double>&
    222, 185, 0,	//453  const char*, const QGenericMatrix<2,3,double>&
    222, 187, 0,	//456  const char*, const QGenericMatrix<2,4,double>&
    222, 189, 0,	//459  const char*, const QGenericMatrix<3,2,double>&
    222, 191, 0,	//462  const char*, const QGenericMatrix<3,3,double>&
    222, 193, 0,	//465  const char*, const QGenericMatrix<3,4,double>&
    222, 195, 0,	//468  const char*, const QGenericMatrix<4,2,double>&
    222, 197, 0,	//471  const char*, const QGenericMatrix<4,3,double>&
    222, 200, 0,	//474  const char*, const QMatrix4x4&
    222, 169, 0,	//477  const char*, const GLfloat[2][2]
    222, 170, 0,	//480  const char*, const GLfloat[3][3]
    222, 171, 0,	//483  const char*, const GLfloat[4][4]
    222, 215, 0,	//486  const char*, const QTransform&
    226, 172, 226, 0,	//489  int, const GLint*, int
    226, 173, 226, 0,	//493  int, const GLuint*, int
    226, 184, 226, 0,	//497  int, const QGenericMatrix<2,2,double>*, int
    226, 186, 226, 0,	//501  int, const QGenericMatrix<2,3,double>*, int
    226, 188, 226, 0,	//505  int, const QGenericMatrix<2,4,double>*, int
    226, 190, 226, 0,	//509  int, const QGenericMatrix<3,2,double>*, int
    226, 192, 226, 0,	//513  int, const QGenericMatrix<3,3,double>*, int
    226, 194, 226, 0,	//517  int, const QGenericMatrix<3,4,double>*, int
    226, 196, 226, 0,	//521  int, const QGenericMatrix<4,2,double>*, int
    226, 198, 226, 0,	//525  int, const QGenericMatrix<4,3,double>*, int
    226, 201, 226, 0,	//529  int, const QMatrix4x4*, int
    222, 172, 226, 0,	//533  const char*, const GLint*, int
    222, 173, 226, 0,	//537  const char*, const GLuint*, int
    222, 184, 226, 0,	//541  const char*, const QGenericMatrix<2,2,double>*, int
    222, 186, 226, 0,	//545  const char*, const QGenericMatrix<2,3,double>*, int
    222, 188, 226, 0,	//549  const char*, const QGenericMatrix<2,4,double>*, int
    222, 190, 226, 0,	//553  const char*, const QGenericMatrix<3,2,double>*, int
    222, 192, 226, 0,	//557  const char*, const QGenericMatrix<3,3,double>*, int
    222, 194, 226, 0,	//561  const char*, const QGenericMatrix<3,4,double>*, int
    222, 196, 226, 0,	//565  const char*, const QGenericMatrix<4,2,double>*, int
    222, 198, 226, 0,	//569  const char*, const QGenericMatrix<4,3,double>*, int
    222, 201, 226, 0,	//573  const char*, const QMatrix4x4*, int
    226, 168, 226, 0,	//577  int, const GLfloat*, int
    226, 217, 0,	//581  int, const QVector2D*
    226, 219, 0,	//584  int, const QVector3D*
    226, 221, 0,	//587  int, const QVector4D*
    226, 5, 224, 226, 0,	//590  int, GLenum, const void*, int
    222, 168, 226, 0,	//595  const char*, const GLfloat*, int
    222, 217, 0,	//599  const char*, const QVector2D*
    222, 219, 0,	//602  const char*, const QVector3D*
    222, 221, 0,	//605  const char*, const QVector4D*
    222, 5, 224, 226, 0,	//608  const char*, GLenum, const void*, int
    226, 5, 226, 226, 0,	//613  int, GLenum, int, int
    222, 5, 226, 226, 0,	//618  const char*, GLenum, int, int
    89, 182, 32, 0,	//623  QWidget*, const QGLWidget*, QFlags<Qt::WindowType>
    42, 89, 182, 32, 0,	//627  QGLContext*, QWidget*, const QGLWidget*, QFlags<Qt::WindowType>
    180, 89, 182, 32, 0,	//632  const QGLFormat&, QWidget*, const QGLWidget*, QFlags<Qt::WindowType>
    42, 179, 167, 0,	//637  QGLContext*, const QGLContext*, bool
    226, 226, 167, 0,	//641  int, int, bool
    226, 226, 213, 176, 226, 0,	//645  int, int, const QString&, const QFont&, int
    225, 225, 225, 213, 176, 226, 0,	//651  double, double, double, const QString&, const QFont&, int
    26, 0,	//658  QEvent*
    74, 0,	//660  QPaintEvent*
    77, 0,	//662  QResizeEvent*
    89, 0,	//664  QWidget*
    89, 182, 0,	//666  QWidget*, const QGLWidget*
    42, 89, 0,	//669  QGLContext*, QWidget*
    42, 89, 182, 0,	//672  QGLContext*, QWidget*, const QGLWidget*
    180, 89, 0,	//676  const QGLFormat&, QWidget*
    180, 89, 182, 0,	//679  const QGLFormat&, QWidget*, const QGLWidget*
    42, 179, 0,	//683  QGLContext*, const QGLContext*
    226, 226, 213, 0,	//686  int, int, const QString&
    226, 226, 213, 176, 0,	//690  int, int, const QString&, const QFont&
    225, 225, 225, 213, 0,	//695  double, double, double, const QString&
    225, 225, 225, 213, 176, 0,	//700  double, double, double, const QString&, const QFont&
    176, 0,	//706  const QFont&
    180, 180, 0,	//708  const QGLFormat&, const QGLFormat&
    54, 54, 0,	//711  QGLFunctions::OpenGLFeature, QGLFunctions::OpenGLFeature
    57, 57, 0,	//714  QGLShader::ShaderTypeBit, QGLShader::ShaderTypeBit
    20, 180, 0,	//717  QDebug, const QGLFormat&
    48, 48, 0,	//720  QGLFormat::OpenGLVersionFlag, QGLFormat::OpenGLVersionFlag
    34, 226, 0,	//723  QGL::FormatOption, int
    34, 34, 0,	//726  QGL::FormatOption, QGL::FormatOption
    43, 43, 0,	//729  QGLContext::BindOption, QGLContext::BindOption
    57, 226, 0,	//732  QGLShader::ShaderTypeBit, int
    54, 30, 0,	//735  QGLFunctions::OpenGLFeature, QFlags<QGLFunctions::OpenGLFeature>
    48, 29, 0,	//738  QGLFormat::OpenGLVersionFlag, QFlags<QGLFormat::OpenGLVersionFlag>
    34, 27, 0,	//741  QGL::FormatOption, QFlags<QGL::FormatOption>
    48, 226, 0,	//744  QGLFormat::OpenGLVersionFlag, int
    54, 226, 0,	//747  QGLFunctions::OpenGLFeature, int
    43, 28, 0,	//750  QGLContext::BindOption, QFlags<QGLContext::BindOption>
    43, 226, 0,	//753  QGLContext::BindOption, int
    57, 31, 0,	//756  QGLShader::ShaderTypeBit, QFlags<QGLShader::ShaderTypeBit>
    69, 26, 0,	//759  QObject*, QEvent*
    86, 0,	//762  QTimerEvent*
    16, 0,	//764  QChildEvent*
    67, 0,	//766  QMouseEvent*
    88, 0,	//768  QWheelEvent*
    64, 0,	//770  QKeyEvent*
    33, 0,	//772  QFocusEvent*
    68, 0,	//774  QMoveEvent*
    17, 0,	//776  QCloseEvent*
    19, 0,	//778  QContextMenuEvent*
    84, 0,	//780  QTabletEvent*
    13, 0,	//782  QActionEvent*
    21, 0,	//784  QDragEnterEvent*
    23, 0,	//786  QDragMoveEvent*
    22, 0,	//788  QDragLeaveEvent*
    25, 0,	//790  QDropEvent*
    78, 0,	//792  QShowEvent*
    60, 0,	//794  QHideEvent*
    166, 0,	//796  _XEvent*
    63, 0,	//798  QInputMethodEvent*
    125, 0,	//800  Qt::InputMethodQuery
    83, 0,	//802  QStyle&
    204, 0,	//804  const QPalette&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "AccumBuffer",	//1
    "AlphaChannel",	//2
    "CanFlipNativePixmapBindOption",	//3
    "ColorIndex",	//4
    "CombinedDepthStencil",	//5
    "CompatibilityProfile",	//6
    "CoreProfile",	//7
    "DefaultBindOption",	//8
    "DeprecatedFunctions",	//9
    "Depth",	//10
    "DepthBuffer",	//11
    "DirectRendering",	//12
    "DoubleBuffer",	//13
    "DrawChildren",	//14
    "DrawWindowBackground",	//15
    "DynamicCopy",	//16
    "DynamicDraw",	//17
    "DynamicRead",	//18
    "Fragment",	//19
    "Geometry",	//20
    "HasOverlay",	//21
    "IgnoreMask",	//22
    "IndexBuffer",	//23
    "IndirectRendering",	//24
    "InternalBindOption",	//25
    "InvertedYBindOption",	//26
    "LinearFilteringBindOption",	//27
    "MemoryManagedBindOption",	//28
    "MipmapBindOption",	//29
    "NoAccumBuffer",	//30
    "NoAlphaChannel",	//31
    "NoAttachment",	//32
    "NoBindOption",	//33
    "NoDeprecatedFunctions",	//34
    "NoDepthBuffer",	//35
    "NoOverlay",	//36
    "NoProfile",	//37
    "NoSampleBuffers",	//38
    "NoStencilBuffer",	//39
    "NoStereoBuffers",	//40
    "OpenGL_ES_CommonLite_Version_1_0",	//41
    "OpenGL_ES_CommonLite_Version_1_1",	//42
    "OpenGL_ES_Common_Version_1_0",	//43
    "OpenGL_ES_Common_Version_1_1",	//44
    "OpenGL_ES_Version_2_0",	//45
    "OpenGL_Version_1_1",	//46
    "OpenGL_Version_1_2",	//47
    "OpenGL_Version_1_3",	//48
    "OpenGL_Version_1_4",	//49
    "OpenGL_Version_1_5",	//50
    "OpenGL_Version_2_0",	//51
    "OpenGL_Version_2_1",	//52
    "OpenGL_Version_3_0",	//53
    "OpenGL_Version_3_1",	//54
    "OpenGL_Version_3_2",	//55
    "OpenGL_Version_3_3",	//56
    "OpenGL_Version_4_0",	//57
    "OpenGL_Version_None",	//58
    "PixelPackBuffer",	//59
    "PixelUnpackBuffer",	//60
    "PremultipliedAlphaBindOption",	//61
    "QGLBuffer",	//62
    "QGLBuffer#",	//63
    "QGLBuffer$",	//64
    "QGLColormap",	//65
    "QGLColormap#",	//66
    "QGLContext",	//67
    "QGLContext#",	//68
    "QGLContext##",	//69
    "QGLFormat",	//70
    "QGLFormat#",	//71
    "QGLFormat$",	//72
    "QGLFormat$$",	//73
    "QGLFramebufferObject",	//74
    "QGLFramebufferObject#",	//75
    "QGLFramebufferObject##",	//76
    "QGLFramebufferObject#$",	//77
    "QGLFramebufferObject#$?",	//78
    "QGLFramebufferObject#$??",	//79
    "QGLFramebufferObject#?",	//80
    "QGLFramebufferObject$$",	//81
    "QGLFramebufferObject$$#",	//82
    "QGLFramebufferObject$$$",	//83
    "QGLFramebufferObject$$$?",	//84
    "QGLFramebufferObject$$$??",	//85
    "QGLFramebufferObject$$?",	//86
    "QGLFramebufferObjectFormat",	//87
    "QGLFramebufferObjectFormat#",	//88
    "QGLPixelBuffer",	//89
    "QGLPixelBuffer#",	//90
    "QGLPixelBuffer##",	//91
    "QGLPixelBuffer###",	//92
    "QGLPixelBuffer$$",	//93
    "QGLPixelBuffer$$#",	//94
    "QGLPixelBuffer$$##",	//95
    "QGLShader",	//96
    "QGLShader$",	//97
    "QGLShader$#",	//98
    "QGLShader$##",	//99
    "QGLShaderProgram",	//100
    "QGLShaderProgram#",	//101
    "QGLShaderProgram##",	//102
    "QGLWidget",	//103
    "QGLWidget#",	//104
    "QGLWidget##",	//105
    "QGLWidget###",	//106
    "QGLWidget###$",	//107
    "QGLWidget##$",	//108
    "ReadOnly",	//109
    "ReadWrite",	//110
    "Rgba",	//111
    "SampleBuffers",	//112
    "SingleBuffer",	//113
    "StaticCopy",	//114
    "StaticDraw",	//115
    "StaticRead",	//116
    "StencilBuffer",	//117
    "StereoBuffers",	//118
    "StreamCopy",	//119
    "StreamDraw",	//120
    "StreamRead",	//121
    "Vertex",	//122
    "VertexBuffer",	//123
    "WriteOnly",	//124
    "accum",	//125
    "accumBufferSize",	//126
    "actionEvent",	//127
    "addShader",	//128
    "addShader#",	//129
    "addShaderFromSourceCode",	//130
    "addShaderFromSourceCode$#",	//131
    "addShaderFromSourceCode$$",	//132
    "addShaderFromSourceFile",	//133
    "addShaderFromSourceFile$$",	//134
    "allocate",	//135
    "allocate$",	//136
    "allocate$$",	//137
    "alpha",	//138
    "alphaBufferSize",	//139
    "areSharing",	//140
    "areSharing##",	//141
    "attachment",	//142
    "attributeLocation",	//143
    "attributeLocation#",	//144
    "attributeLocation$",	//145
    "autoBufferSwap",	//146
    "bind",	//147
    "bindAttributeLocation",	//148
    "bindAttributeLocation#$",	//149
    "bindAttributeLocation$$",	//150
    "bindDefault",	//151
    "bindTexture",	//152
    "bindTexture#",	//153
    "bindTexture#?",	//154
    "bindTexture#??",	//155
    "bindTexture#??$",	//156
    "bindTexture$",	//157
    "bindToDynamicTexture",	//158
    "bindToDynamicTexture?",	//159
    "blitFramebuffer",	//160
    "blitFramebuffer####",	//161
    "blitFramebuffer####?",	//162
    "blitFramebuffer####??",	//163
    "blueBufferSize",	//164
    "bufferId",	//165
    "changeEvent",	//166
    "childEvent",	//167
    "chooseContext",	//168
    "chooseContext#",	//169
    "chooseVisual",	//170
    "closeEvent",	//171
    "colorIndex",	//172
    "colorIndex#",	//173
    "colormap",	//174
    "compileSourceCode",	//175
    "compileSourceCode#",	//176
    "compileSourceCode$",	//177
    "compileSourceFile",	//178
    "compileSourceFile$",	//179
    "connectNotify",	//180
    "context",	//181
    "contextMenuEvent",	//182
    "convertToGLFormat",	//183
    "convertToGLFormat#",	//184
    "create",	//185
    "create#",	//186
    "currentContext",	//187
    "currentCtx",	//188
    "customEvent",	//189
    "defaultFormat",	//190
    "defaultOverlayFormat",	//191
    "deleteTexture",	//192
    "deleteTexture?",	//193
    "depth",	//194
    "depthBufferSize",	//195
    "destroy",	//196
    "detach",	//197
    "devType",	//198
    "device",	//199
    "deviceIsPixmap",	//200
    "directRendering",	//201
    "disableAttributeArray",	//202
    "disableAttributeArray$",	//203
    "disconnectNotify",	//204
    "doneCurrent",	//205
    "doubleBuffer",	//206
    "dragEnterEvent",	//207
    "dragLeaveEvent",	//208
    "dragMoveEvent",	//209
    "drawTexture",	//210
    "drawTexture#?",	//211
    "drawTexture#??",	//212
    "dropEvent",	//213
    "enableAttributeArray",	//214
    "enableAttributeArray$",	//215
    "enabledChange",	//216
    "enterEvent",	//217
    "entryColor",	//218
    "entryColor$",	//219
    "entryRgb",	//220
    "entryRgb$",	//221
    "event",	//222
    "event#",	//223
    "eventFilter",	//224
    "find",	//225
    "find$",	//226
    "findNearest",	//227
    "findNearest$",	//228
    "focusInEvent",	//229
    "focusNextPrevChild",	//230
    "focusOutEvent",	//231
    "fontChange",	//232
    "fontDisplayListBase",	//233
    "fontDisplayListBase#",	//234
    "fontDisplayListBase#$",	//235
    "format",	//236
    "generateDynamicTexture",	//237
    "generateFontDisplayLists",	//238
    "generateFontDisplayLists#$",	//239
    "geometryInputType",	//240
    "geometryOutputType",	//241
    "geometryOutputVertexCount",	//242
    "getProcAddress",	//243
    "getProcAddress$",	//244
    "glDraw",	//245
    "glInit",	//246
    "grabFrameBuffer",	//247
    "grabFrameBuffer$",	//248
    "greenBufferSize",	//249
    "handle",	//250
    "hasOpenGL",	//251
    "hasOpenGLFramebufferBlit",	//252
    "hasOpenGLFramebufferObjects",	//253
    "hasOpenGLOverlays",	//254
    "hasOpenGLPbuffers",	//255
    "hasOpenGLShaderPrograms",	//256
    "hasOpenGLShaderPrograms#",	//257
    "hasOpenGLShaders",	//258
    "hasOpenGLShaders$",	//259
    "hasOpenGLShaders$#",	//260
    "hasOverlay",	//261
    "heightForWidth",	//262
    "hideEvent",	//263
    "initializeGL",	//264
    "initializeOverlayGL",	//265
    "initialized",	//266
    "inputMethodEvent",	//267
    "inputMethodQuery",	//268
    "internalTextureFormat",	//269
    "isBound",	//270
    "isCompiled",	//271
    "isCreated",	//272
    "isEmpty",	//273
    "isLinked",	//274
    "isSharing",	//275
    "isValid",	//276
    "keyPressEvent",	//277
    "keyReleaseEvent",	//278
    "languageChange",	//279
    "leaveEvent",	//280
    "link",	//281
    "log",	//282
    "majorVersion",	//283
    "makeCurrent",	//284
    "makeOverlayCurrent",	//285
    "map",	//286
    "map$",	//287
    "maxGeometryOutputVertices",	//288
    "metaObject",	//289
    "metric",	//290
    "metric$",	//291
    "minimumSizeHint",	//292
    "minorVersion",	//293
    "mipmap",	//294
    "mouseDoubleClickEvent",	//295
    "mouseMoveEvent",	//296
    "mousePressEvent",	//297
    "mouseReleaseEvent",	//298
    "moveEvent",	//299
    "openGLVersionFlags",	//300
    "operator!=",	//301
    "operator!=#",	//302
    "operator!=##",	//303
    "operator<<",	//304
    "operator<<##",	//305
    "operator=",	//306
    "operator=#",	//307
    "operator==",	//308
    "operator==#",	//309
    "operator==##",	//310
    "operator|",	//311
    "operator|$$",	//312
    "overlayContext",	//313
    "overlayTransparentColor",	//314
    "paintEngine",	//315
    "paintEvent",	//316
    "paintEvent#",	//317
    "paintGL",	//318
    "paintOverlayGL",	//319
    "paletteChange",	//320
    "plane",	//321
    "profile",	//322
    "programId",	//323
    "qglClearColor",	//324
    "qglClearColor#",	//325
    "qglColor",	//326
    "qglColor#",	//327
    "qt_metacall",	//328
    "qt_metacall$$?",	//329
    "qt_metacast",	//330
    "qt_metacast$",	//331
    "read",	//332
    "read$$$",	//333
    "redBufferSize",	//334
    "release",	//335
    "release$",	//336
    "releaseFromDynamicTexture",	//337
    "removeAllShaders",	//338
    "removeShader",	//339
    "removeShader#",	//340
    "renderPixmap",	//341
    "renderPixmap$",	//342
    "renderPixmap$$",	//343
    "renderPixmap$$$",	//344
    "renderText",	//345
    "renderText$$$",	//346
    "renderText$$$#",	//347
    "renderText$$$#$",	//348
    "renderText$$$$",	//349
    "renderText$$$$#",	//350
    "renderText$$$$#$",	//351
    "requestedFormat",	//352
    "reset",	//353
    "resizeEvent",	//354
    "resizeEvent#",	//355
    "resizeGL",	//356
    "resizeGL$$",	//357
    "resizeOverlayGL",	//358
    "resizeOverlayGL$$",	//359
    "rgba",	//360
    "sampleBuffers",	//361
    "samples",	//362
    "setAccum",	//363
    "setAccum$",	//364
    "setAccumBufferSize",	//365
    "setAccumBufferSize$",	//366
    "setAlpha",	//367
    "setAlpha$",	//368
    "setAlphaBufferSize",	//369
    "setAlphaBufferSize$",	//370
    "setAttachment",	//371
    "setAttachment$",	//372
    "setAttributeArray",	//373
    "setAttributeArray$#",	//374
    "setAttributeArray$#$",	//375
    "setAttributeArray$?$",	//376
    "setAttributeArray$?$$",	//377
    "setAttributeArray$?$$$",	//378
    "setAttributeBuffer",	//379
    "setAttributeBuffer$?$$",	//380
    "setAttributeBuffer$?$$$",	//381
    "setAttributeValue",	//382
    "setAttributeValue$#",	//383
    "setAttributeValue$?",	//384
    "setAttributeValue$?$$",	//385
    "setAttributeValue$??",	//386
    "setAttributeValue$???",	//387
    "setAttributeValue$????",	//388
    "setAutoBufferSwap",	//389
    "setAutoBufferSwap$",	//390
    "setBlueBufferSize",	//391
    "setBlueBufferSize$",	//392
    "setColormap",	//393
    "setColormap#",	//394
    "setContext",	//395
    "setContext#",	//396
    "setContext##",	//397
    "setContext##$",	//398
    "setCurrentCtx",	//399
    "setCurrentCtx#",	//400
    "setDefaultFormat",	//401
    "setDefaultFormat#",	//402
    "setDefaultOverlayFormat",	//403
    "setDefaultOverlayFormat#",	//404
    "setDepth",	//405
    "setDepth$",	//406
    "setDepthBufferSize",	//407
    "setDepthBufferSize$",	//408
    "setDevice",	//409
    "setDevice#",	//410
    "setDirectRendering",	//411
    "setDirectRendering$",	//412
    "setDoubleBuffer",	//413
    "setDoubleBuffer$",	//414
    "setEntries",	//415
    "setEntries$$",	//416
    "setEntries$$$",	//417
    "setEntry",	//418
    "setEntry$#",	//419
    "setEntry$$",	//420
    "setFormat",	//421
    "setFormat#",	//422
    "setGeometryInputType",	//423
    "setGeometryInputType?",	//424
    "setGeometryOutputType",	//425
    "setGeometryOutputType?",	//426
    "setGeometryOutputVertexCount",	//427
    "setGeometryOutputVertexCount$",	//428
    "setGreenBufferSize",	//429
    "setGreenBufferSize$",	//430
    "setHandle",	//431
    "setHandle$",	//432
    "setInitialized",	//433
    "setInitialized$",	//434
    "setInternalTextureFormat",	//435
    "setInternalTextureFormat?",	//436
    "setMipmap",	//437
    "setMipmap$",	//438
    "setMouseTracking",	//439
    "setMouseTracking$",	//440
    "setOption",	//441
    "setOption$",	//442
    "setOverlay",	//443
    "setOverlay$",	//444
    "setPlane",	//445
    "setPlane$",	//446
    "setPreferredPaintEngine",	//447
    "setPreferredPaintEngine$",	//448
    "setProfile",	//449
    "setProfile$",	//450
    "setRedBufferSize",	//451
    "setRedBufferSize$",	//452
    "setRgba",	//453
    "setRgba$",	//454
    "setSampleBuffers",	//455
    "setSampleBuffers$",	//456
    "setSamples",	//457
    "setSamples$",	//458
    "setStencil",	//459
    "setStencil$",	//460
    "setStencilBufferSize",	//461
    "setStencilBufferSize$",	//462
    "setStereo",	//463
    "setStereo$",	//464
    "setSwapInterval",	//465
    "setSwapInterval$",	//466
    "setTextureCacheLimit",	//467
    "setTextureCacheLimit$",	//468
    "setTextureTarget",	//469
    "setTextureTarget?",	//470
    "setUniformValue",	//471
    "setUniformValue$#",	//472
    "setUniformValue$?",	//473
    "setUniformValue$??",	//474
    "setUniformValue$???",	//475
    "setUniformValue$????",	//476
    "setUniformValueArray",	//477
    "setUniformValueArray$#$",	//478
    "setUniformValueArray$?$",	//479
    "setUniformValueArray$?$$",	//480
    "setUsagePattern",	//481
    "setUsagePattern$",	//482
    "setValid",	//483
    "setValid$",	//484
    "setVersion",	//485
    "setVersion$$",	//486
    "setVisible",	//487
    "setWindowCreated",	//488
    "setWindowCreated$",	//489
    "shaderId",	//490
    "shaderType",	//491
    "shaders",	//492
    "showEvent",	//493
    "size",	//494
    "sizeHint",	//495
    "sourceCode",	//496
    "staticMetaObject",	//497
    "stencil",	//498
    "stencilBufferSize",	//499
    "stereo",	//500
    "styleChange",	//501
    "swapBuffers",	//502
    "swapInterval",	//503
    "tabletEvent",	//504
    "testOption",	//505
    "testOption$",	//506
    "texture",	//507
    "textureCacheLimit",	//508
    "textureTarget",	//509
    "timerEvent",	//510
    "toImage",	//511
    "tr",	//512
    "tr$",	//513
    "tr$$",	//514
    "tr$$$",	//515
    "trUtf8",	//516
    "trUtf8$",	//517
    "trUtf8$$",	//518
    "trUtf8$$$",	//519
    "tryVisual",	//520
    "tryVisual#",	//521
    "tryVisual#$",	//522
    "type",	//523
    "uniformLocation",	//524
    "uniformLocation#",	//525
    "uniformLocation$",	//526
    "unmap",	//527
    "updateDynamicTexture",	//528
    "updateDynamicTexture?",	//529
    "updateGL",	//530
    "updateOverlayGL",	//531
    "usagePattern",	//532
    "wheelEvent",	//533
    "windowActivationChange",	//534
    "windowCreated",	//535
    "write",	//536
    "write$$$",	//537
    "x11Event",	//538
    "~QGLBuffer",	//539
    "~QGLColormap",	//540
    "~QGLContext",	//541
    "~QGLFormat",	//542
    "~QGLFramebufferObject",	//543
    "~QGLFramebufferObjectFormat",	//544
    "~QGLPixelBuffer",	//545
    "~QGLShader",	//546
    "~QGLShaderProgram",	//547
    "~QGLWidget",	//548
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {16, 447, 1, 1, Smoke::mf_static, 0, 1},	//1 QGL::setPreferredPaintEngine(QPaintEngine::Type)
    {16, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 2},	//2 QGL::DoubleBuffer (enum)
    {16, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 3},	//3 QGL::DepthBuffer (enum)
    {16, 111, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 4},	//4 QGL::Rgba (enum)
    {16, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 5},	//5 QGL::AlphaChannel (enum)
    {16, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 6},	//6 QGL::AccumBuffer (enum)
    {16, 117, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 7},	//7 QGL::StencilBuffer (enum)
    {16, 118, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 8},	//8 QGL::StereoBuffers (enum)
    {16, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 9},	//9 QGL::DirectRendering (enum)
    {16, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 10},	//10 QGL::HasOverlay (enum)
    {16, 112, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 11},	//11 QGL::SampleBuffers (enum)
    {16, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 12},	//12 QGL::DeprecatedFunctions (enum)
    {16, 113, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 13},	//13 QGL::SingleBuffer (enum)
    {16, 35, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 14},	//14 QGL::NoDepthBuffer (enum)
    {16, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 15},	//15 QGL::ColorIndex (enum)
    {16, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 16},	//16 QGL::NoAlphaChannel (enum)
    {16, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 17},	//17 QGL::NoAccumBuffer (enum)
    {16, 39, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 18},	//18 QGL::NoStencilBuffer (enum)
    {16, 40, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 19},	//19 QGL::NoStereoBuffers (enum)
    {16, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 20},	//20 QGL::IndirectRendering (enum)
    {16, 36, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 21},	//21 QGL::NoOverlay (enum)
    {16, 38, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 22},	//22 QGL::NoSampleBuffers (enum)
    {16, 34, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 23},	//23 QGL::NoDeprecatedFunctions (enum)
    {17, 62, 0, 0, Smoke::mf_ctor, 36, 1},	//24 QGLBuffer::QGLBuffer()
    {17, 62, 3, 1, Smoke::mf_ctor, 36, 2},	//25 QGLBuffer::QGLBuffer(QGLBuffer::Type)
    {17, 62, 5, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 36, 3},	//26 QGLBuffer::QGLBuffer(const QGLBuffer&)
    {17, 306, 5, 1, 0, 35, 4},	//27 QGLBuffer::operator=(const QGLBuffer&)
    {17, 523, 0, 0, Smoke::mf_const, 38, 5},	//28 QGLBuffer::type() const
    {17, 532, 0, 0, Smoke::mf_const, 39, 6},	//29 QGLBuffer::usagePattern() const
    {17, 481, 7, 1, 0, 0, 7},	//30 QGLBuffer::setUsagePattern(QGLBuffer::UsagePattern)
    {17, 185, 0, 0, 0, 167, 8},	//31 QGLBuffer::create()
    {17, 272, 0, 0, Smoke::mf_const, 167, 9},	//32 QGLBuffer::isCreated() const
    {17, 196, 0, 0, 0, 0, 10},	//33 QGLBuffer::destroy()
    {17, 147, 0, 0, 0, 167, 11},	//34 QGLBuffer::bind()
    {17, 335, 0, 0, 0, 0, 12},	//35 QGLBuffer::release()
    {17, 335, 3, 1, Smoke::mf_static, 0, 13},	//36 QGLBuffer::release(QGLBuffer::Type)
    {17, 165, 0, 0, Smoke::mf_const, 8, 14},	//37 QGLBuffer::bufferId() const
    {17, 494, 0, 0, Smoke::mf_const, 226, 15},	//38 QGLBuffer::size() const
    {17, 332, 9, 3, 0, 167, 16},	//39 QGLBuffer::read(int, void*, int)
    {17, 536, 13, 3, 0, 0, 17},	//40 QGLBuffer::write(int, const void*, int)
    {17, 135, 17, 2, 0, 0, 18},	//41 QGLBuffer::allocate(const void*, int)
    {17, 135, 20, 1, 0, 0, 19},	//42 QGLBuffer::allocate(int)
    {17, 286, 22, 1, 0, 230, 20},	//43 QGLBuffer::map(QGLBuffer::Access)
    {17, 527, 0, 0, 0, 167, 21},	//44 QGLBuffer::unmap()
    {17, 123, 0, 0, Smoke::mf_static|Smoke::mf_enum, 38, 22},	//45 QGLBuffer::VertexBuffer (enum)
    {17, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 38, 23},	//46 QGLBuffer::IndexBuffer (enum)
    {17, 59, 0, 0, Smoke::mf_static|Smoke::mf_enum, 38, 24},	//47 QGLBuffer::PixelPackBuffer (enum)
    {17, 60, 0, 0, Smoke::mf_static|Smoke::mf_enum, 38, 25},	//48 QGLBuffer::PixelUnpackBuffer (enum)
    {17, 120, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 26},	//49 QGLBuffer::StreamDraw (enum)
    {17, 121, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 27},	//50 QGLBuffer::StreamRead (enum)
    {17, 119, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 28},	//51 QGLBuffer::StreamCopy (enum)
    {17, 115, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 29},	//52 QGLBuffer::StaticDraw (enum)
    {17, 116, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 30},	//53 QGLBuffer::StaticRead (enum)
    {17, 114, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 31},	//54 QGLBuffer::StaticCopy (enum)
    {17, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 32},	//55 QGLBuffer::DynamicDraw (enum)
    {17, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 33},	//56 QGLBuffer::DynamicRead (enum)
    {17, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 34},	//57 QGLBuffer::DynamicCopy (enum)
    {17, 109, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 35},	//58 QGLBuffer::ReadOnly (enum)
    {17, 124, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 36},	//59 QGLBuffer::WriteOnly (enum)
    {17, 110, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 37},	//60 QGLBuffer::ReadWrite (enum)
    {17, 539, 0, 0, Smoke::mf_dtor, 0, 38 },	//61 QGLBuffer::~QGLBuffer()
    {18, 65, 0, 0, Smoke::mf_ctor, 41, 1},	//62 QGLColormap::QGLColormap()
    {18, 65, 24, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 41, 2},	//63 QGLColormap::QGLColormap(const QGLColormap&)
    {18, 306, 24, 1, 0, 40, 3},	//64 QGLColormap::operator=(const QGLColormap&)
    {18, 273, 0, 0, Smoke::mf_const, 167, 4},	//65 QGLColormap::isEmpty() const
    {18, 494, 0, 0, Smoke::mf_const, 226, 5},	//66 QGLColormap::size() const
    {18, 197, 0, 0, 0, 0, 6},	//67 QGLColormap::detach()
    {18, 415, 26, 3, 0, 0, 7},	//68 QGLColormap::setEntries(int, const unsigned int*, int)
    {18, 418, 30, 2, 0, 0, 8},	//69 QGLColormap::setEntry(int, unsigned int)
    {18, 418, 33, 2, 0, 0, 9},	//70 QGLColormap::setEntry(int, const QColor&)
    {18, 220, 20, 1, Smoke::mf_const, 228, 10},	//71 QGLColormap::entryRgb(int) const
    {18, 218, 20, 1, Smoke::mf_const, 18, 11},	//72 QGLColormap::entryColor(int) const
    {18, 225, 36, 1, Smoke::mf_const, 226, 12},	//73 QGLColormap::find(unsigned int) const
    {18, 227, 36, 1, Smoke::mf_const, 226, 13},	//74 QGLColormap::findNearest(unsigned int) const
    {18, 250, 0, 0, Smoke::mf_protected, 229, 14},	//75 QGLColormap::handle()
    {18, 431, 38, 1, Smoke::mf_protected, 0, 15},	//76 QGLColormap::setHandle(unsigned long)
    {18, 415, 40, 2, 0, 0, 16},	//77 QGLColormap::setEntries(int, const unsigned int*)
    {18, 540, 0, 0, Smoke::mf_dtor, 0, 17 },	//78 QGLColormap::~QGLColormap()
    {19, 67, 43, 2, Smoke::mf_ctor, 42, 1},	//79 QGLContext::QGLContext(const QGLFormat&, QPaintDevice*)
    {19, 67, 46, 1, Smoke::mf_ctor, 42, 2},	//80 QGLContext::QGLContext(const QGLFormat&)
    {19, 185, 48, 1, Smoke::mf_virtual, 167, 3},	//81 QGLContext::create(const QGLContext*)
    {19, 276, 0, 0, Smoke::mf_const, 167, 4},	//82 QGLContext::isValid() const
    {19, 275, 0, 0, Smoke::mf_const, 167, 5},	//83 QGLContext::isSharing() const
    {19, 353, 0, 0, 0, 0, 6},	//84 QGLContext::reset()
    {19, 140, 50, 2, Smoke::mf_static, 167, 7},	//85 QGLContext::areSharing(const QGLContext*, const QGLContext*)
    {19, 236, 0, 0, Smoke::mf_const, 44, 8},	//86 QGLContext::format() const
    {19, 352, 0, 0, Smoke::mf_const, 44, 9},	//87 QGLContext::requestedFormat() const
    {19, 421, 46, 1, 0, 0, 10},	//88 QGLContext::setFormat(const QGLFormat&)
    {19, 284, 0, 0, Smoke::mf_virtual, 0, 11},	//89 QGLContext::makeCurrent()
    {19, 205, 0, 0, Smoke::mf_virtual, 0, 12},	//90 QGLContext::doneCurrent()
    {19, 502, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 0, 13},	//91 QGLContext::swapBuffers() const
    {19, 152, 53, 4, 0, 8, 14},	//92 QGLContext::bindTexture(const QImage&, GLenum, GLint, QFlags<QGLContext::BindOption>)
    {19, 152, 58, 4, 0, 8, 15},	//93 QGLContext::bindTexture(const QPixmap&, GLenum, GLint, QFlags<QGLContext::BindOption>)
    {19, 152, 63, 3, 0, 8, 16},	//94 QGLContext::bindTexture(const QImage&, GLenum, GLint)
    {19, 152, 67, 3, 0, 8, 17},	//95 QGLContext::bindTexture(const QPixmap&, GLenum, GLint)
    {19, 152, 71, 1, 0, 8, 18},	//96 QGLContext::bindTexture(const QString&)
    {19, 192, 73, 1, 0, 0, 19},	//97 QGLContext::deleteTexture(GLuint)
    {19, 210, 75, 3, 0, 0, 20},	//98 QGLContext::drawTexture(const QRectF&, GLuint, GLenum)
    {19, 210, 79, 3, 0, 0, 21},	//99 QGLContext::drawTexture(const QPointF&, GLuint, GLenum)
    {19, 467, 20, 1, Smoke::mf_static, 0, 22},	//100 QGLContext::setTextureCacheLimit(int)
    {19, 508, 0, 0, Smoke::mf_static, 226, 23},	//101 QGLContext::textureCacheLimit()
    {19, 243, 71, 1, Smoke::mf_const, 230, 24},	//102 QGLContext::getProcAddress(const QString&) const
    {19, 199, 0, 0, Smoke::mf_const, 70, 25},	//103 QGLContext::device() const
    {19, 314, 0, 0, Smoke::mf_const, 18, 26},	//104 QGLContext::overlayTransparentColor() const
    {19, 187, 0, 0, Smoke::mf_static, 179, 27},	//105 QGLContext::currentContext()
    {19, 168, 48, 1, Smoke::mf_protected|Smoke::mf_virtual, 167, 28},	//106 QGLContext::chooseContext(const QGLContext*)
    {19, 520, 83, 2, Smoke::mf_protected|Smoke::mf_virtual, 230, 29},	//107 QGLContext::tryVisual(const QGLFormat&, int)
    {19, 170, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 230, 30},	//108 QGLContext::chooseVisual()
    {19, 200, 0, 0, Smoke::mf_const|Smoke::mf_protected, 167, 31},	//109 QGLContext::deviceIsPixmap() const
    {19, 535, 0, 0, Smoke::mf_const|Smoke::mf_protected, 167, 32},	//110 QGLContext::windowCreated() const
    {19, 488, 86, 1, Smoke::mf_protected, 0, 33},	//111 QGLContext::setWindowCreated(bool)
    {19, 266, 0, 0, Smoke::mf_const|Smoke::mf_protected, 167, 34},	//112 QGLContext::initialized() const
    {19, 433, 86, 1, Smoke::mf_protected, 0, 35},	//113 QGLContext::setInitialized(bool)
    {19, 238, 88, 2, Smoke::mf_protected, 0, 36},	//114 QGLContext::generateFontDisplayLists(const QFont&, int)
    {19, 172, 91, 1, Smoke::mf_const|Smoke::mf_protected, 228, 37},	//115 QGLContext::colorIndex(const QColor&) const
    {19, 483, 86, 1, Smoke::mf_protected, 0, 38},	//116 QGLContext::setValid(bool)
    {19, 409, 93, 1, Smoke::mf_protected, 0, 39},	//117 QGLContext::setDevice(QPaintDevice*)
    {19, 185, 0, 0, 0, 167, 40},	//118 QGLContext::create()
    {19, 152, 95, 1, 0, 8, 41},	//119 QGLContext::bindTexture(const QImage&)
    {19, 152, 97, 2, 0, 8, 42},	//120 QGLContext::bindTexture(const QImage&, GLenum)
    {19, 152, 100, 1, 0, 8, 43},	//121 QGLContext::bindTexture(const QPixmap&)
    {19, 152, 102, 2, 0, 8, 44},	//122 QGLContext::bindTexture(const QPixmap&, GLenum)
    {19, 210, 105, 2, 0, 0, 45},	//123 QGLContext::drawTexture(const QRectF&, GLuint)
    {19, 210, 108, 2, 0, 0, 46},	//124 QGLContext::drawTexture(const QPointF&, GLuint)
    {19, 168, 0, 0, Smoke::mf_protected, 167, 47},	//125 QGLContext::chooseContext()
    {19, 520, 46, 1, Smoke::mf_protected, 230, 48},	//126 QGLContext::tryVisual(const QGLFormat&)
    {19, 188, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_protected|Smoke::mf_attribute, 42, 49},	//127 QGLContext::currentCtx() const
    {19, 399, 111, 1, Smoke::mf_static|Smoke::mf_protected|Smoke::mf_attribute, 0, 50},	//128 QGLContext::setCurrentCtx(QGLContext*)
    {19, 33, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 51},	//129 QGLContext::NoBindOption (enum)
    {19, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 52},	//130 QGLContext::InvertedYBindOption (enum)
    {19, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 53},	//131 QGLContext::MipmapBindOption (enum)
    {19, 61, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 54},	//132 QGLContext::PremultipliedAlphaBindOption (enum)
    {19, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 55},	//133 QGLContext::LinearFilteringBindOption (enum)
    {19, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 56},	//134 QGLContext::MemoryManagedBindOption (enum)
    {19, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 57},	//135 QGLContext::CanFlipNativePixmapBindOption (enum)
    {19, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 58},	//136 QGLContext::DefaultBindOption (enum)
    {19, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 59},	//137 QGLContext::InternalBindOption (enum)
    {19, 541, 0, 0, Smoke::mf_dtor, 0, 60 },	//138 QGLContext::~QGLContext()
    {20, 70, 0, 0, Smoke::mf_ctor, 46, 1},	//139 QGLFormat::QGLFormat()
    {20, 70, 113, 2, Smoke::mf_ctor, 46, 2},	//140 QGLFormat::QGLFormat(QFlags<QGL::FormatOption>, int)
    {20, 70, 46, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 46, 3},	//141 QGLFormat::QGLFormat(const QGLFormat&)
    {20, 306, 46, 1, 0, 45, 4},	//142 QGLFormat::operator=(const QGLFormat&)
    {20, 407, 20, 1, 0, 0, 5},	//143 QGLFormat::setDepthBufferSize(int)
    {20, 195, 0, 0, Smoke::mf_const, 226, 6},	//144 QGLFormat::depthBufferSize() const
    {20, 365, 20, 1, 0, 0, 7},	//145 QGLFormat::setAccumBufferSize(int)
    {20, 126, 0, 0, Smoke::mf_const, 226, 8},	//146 QGLFormat::accumBufferSize() const
    {20, 451, 20, 1, 0, 0, 9},	//147 QGLFormat::setRedBufferSize(int)
    {20, 334, 0, 0, Smoke::mf_const, 226, 10},	//148 QGLFormat::redBufferSize() const
    {20, 429, 20, 1, 0, 0, 11},	//149 QGLFormat::setGreenBufferSize(int)
    {20, 249, 0, 0, Smoke::mf_const, 226, 12},	//150 QGLFormat::greenBufferSize() const
    {20, 391, 20, 1, 0, 0, 13},	//151 QGLFormat::setBlueBufferSize(int)
    {20, 164, 0, 0, Smoke::mf_const, 226, 14},	//152 QGLFormat::blueBufferSize() const
    {20, 369, 20, 1, 0, 0, 15},	//153 QGLFormat::setAlphaBufferSize(int)
    {20, 139, 0, 0, Smoke::mf_const, 226, 16},	//154 QGLFormat::alphaBufferSize() const
    {20, 461, 20, 1, 0, 0, 17},	//155 QGLFormat::setStencilBufferSize(int)
    {20, 499, 0, 0, Smoke::mf_const, 226, 18},	//156 QGLFormat::stencilBufferSize() const
    {20, 455, 86, 1, 0, 0, 19},	//157 QGLFormat::setSampleBuffers(bool)
    {20, 361, 0, 0, Smoke::mf_const, 167, 20},	//158 QGLFormat::sampleBuffers() const
    {20, 457, 20, 1, 0, 0, 21},	//159 QGLFormat::setSamples(int)
    {20, 362, 0, 0, Smoke::mf_const, 226, 22},	//160 QGLFormat::samples() const
    {20, 465, 20, 1, 0, 0, 23},	//161 QGLFormat::setSwapInterval(int)
    {20, 503, 0, 0, Smoke::mf_const, 226, 24},	//162 QGLFormat::swapInterval() const
    {20, 206, 0, 0, Smoke::mf_const, 167, 25},	//163 QGLFormat::doubleBuffer() const
    {20, 413, 86, 1, 0, 0, 26},	//164 QGLFormat::setDoubleBuffer(bool)
    {20, 194, 0, 0, Smoke::mf_const, 167, 27},	//165 QGLFormat::depth() const
    {20, 405, 86, 1, 0, 0, 28},	//166 QGLFormat::setDepth(bool)
    {20, 360, 0, 0, Smoke::mf_const, 167, 29},	//167 QGLFormat::rgba() const
    {20, 453, 86, 1, 0, 0, 30},	//168 QGLFormat::setRgba(bool)
    {20, 138, 0, 0, Smoke::mf_const, 167, 31},	//169 QGLFormat::alpha() const
    {20, 367, 86, 1, 0, 0, 32},	//170 QGLFormat::setAlpha(bool)
    {20, 125, 0, 0, Smoke::mf_const, 167, 33},	//171 QGLFormat::accum() const
    {20, 363, 86, 1, 0, 0, 34},	//172 QGLFormat::setAccum(bool)
    {20, 498, 0, 0, Smoke::mf_const, 167, 35},	//173 QGLFormat::stencil() const
    {20, 459, 86, 1, 0, 0, 36},	//174 QGLFormat::setStencil(bool)
    {20, 500, 0, 0, Smoke::mf_const, 167, 37},	//175 QGLFormat::stereo() const
    {20, 463, 86, 1, 0, 0, 38},	//176 QGLFormat::setStereo(bool)
    {20, 201, 0, 0, Smoke::mf_const, 167, 39},	//177 QGLFormat::directRendering() const
    {20, 411, 86, 1, 0, 0, 40},	//178 QGLFormat::setDirectRendering(bool)
    {20, 261, 0, 0, Smoke::mf_const, 167, 41},	//179 QGLFormat::hasOverlay() const
    {20, 443, 86, 1, 0, 0, 42},	//180 QGLFormat::setOverlay(bool)
    {20, 321, 0, 0, Smoke::mf_const, 226, 43},	//181 QGLFormat::plane() const
    {20, 445, 20, 1, 0, 0, 44},	//182 QGLFormat::setPlane(int)
    {20, 441, 116, 1, 0, 0, 45},	//183 QGLFormat::setOption(QFlags<QGL::FormatOption>)
    {20, 505, 116, 1, Smoke::mf_const, 167, 46},	//184 QGLFormat::testOption(QFlags<QGL::FormatOption>) const
    {20, 190, 0, 0, Smoke::mf_static, 44, 47},	//185 QGLFormat::defaultFormat()
    {20, 401, 46, 1, Smoke::mf_static, 0, 48},	//186 QGLFormat::setDefaultFormat(const QGLFormat&)
    {20, 191, 0, 0, Smoke::mf_static, 44, 49},	//187 QGLFormat::defaultOverlayFormat()
    {20, 403, 46, 1, Smoke::mf_static, 0, 50},	//188 QGLFormat::setDefaultOverlayFormat(const QGLFormat&)
    {20, 251, 0, 0, Smoke::mf_static, 167, 51},	//189 QGLFormat::hasOpenGL()
    {20, 254, 0, 0, Smoke::mf_static, 167, 52},	//190 QGLFormat::hasOpenGLOverlays()
    {20, 485, 118, 2, 0, 0, 53},	//191 QGLFormat::setVersion(int, int)
    {20, 283, 0, 0, Smoke::mf_const, 226, 54},	//192 QGLFormat::majorVersion() const
    {20, 293, 0, 0, Smoke::mf_const, 226, 55},	//193 QGLFormat::minorVersion() const
    {20, 449, 121, 1, 0, 0, 56},	//194 QGLFormat::setProfile(QGLFormat::OpenGLContextProfile)
    {20, 322, 0, 0, Smoke::mf_const, 47, 57},	//195 QGLFormat::profile() const
    {20, 300, 0, 0, Smoke::mf_static, 29, 58},	//196 QGLFormat::openGLVersionFlags()
    {20, 70, 116, 1, Smoke::mf_ctor, 46, 59},	//197 QGLFormat::QGLFormat(QFlags<QGL::FormatOption>)
    {20, 37, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 60},	//198 QGLFormat::NoProfile (enum)
    {20, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 61},	//199 QGLFormat::CoreProfile (enum)
    {20, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 62},	//200 QGLFormat::CompatibilityProfile (enum)
    {20, 58, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 63},	//201 QGLFormat::OpenGL_Version_None (enum)
    {20, 46, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 64},	//202 QGLFormat::OpenGL_Version_1_1 (enum)
    {20, 47, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 65},	//203 QGLFormat::OpenGL_Version_1_2 (enum)
    {20, 48, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 66},	//204 QGLFormat::OpenGL_Version_1_3 (enum)
    {20, 49, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 67},	//205 QGLFormat::OpenGL_Version_1_4 (enum)
    {20, 50, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 68},	//206 QGLFormat::OpenGL_Version_1_5 (enum)
    {20, 51, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 69},	//207 QGLFormat::OpenGL_Version_2_0 (enum)
    {20, 52, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 70},	//208 QGLFormat::OpenGL_Version_2_1 (enum)
    {20, 43, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 71},	//209 QGLFormat::OpenGL_ES_Common_Version_1_0 (enum)
    {20, 41, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 72},	//210 QGLFormat::OpenGL_ES_CommonLite_Version_1_0 (enum)
    {20, 44, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 73},	//211 QGLFormat::OpenGL_ES_Common_Version_1_1 (enum)
    {20, 42, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 74},	//212 QGLFormat::OpenGL_ES_CommonLite_Version_1_1 (enum)
    {20, 45, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 75},	//213 QGLFormat::OpenGL_ES_Version_2_0 (enum)
    {20, 53, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 76},	//214 QGLFormat::OpenGL_Version_3_0 (enum)
    {20, 54, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 77},	//215 QGLFormat::OpenGL_Version_3_1 (enum)
    {20, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 78},	//216 QGLFormat::OpenGL_Version_3_2 (enum)
    {20, 56, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 79},	//217 QGLFormat::OpenGL_Version_3_3 (enum)
    {20, 57, 0, 0, Smoke::mf_static|Smoke::mf_enum, 48, 80},	//218 QGLFormat::OpenGL_Version_4_0 (enum)
    {20, 542, 0, 0, Smoke::mf_dtor, 0, 81 },	//219 QGLFormat::~QGLFormat()
    {21, 74, 123, 2, Smoke::mf_ctor, 49, 1},	//220 QGLFramebufferObject::QGLFramebufferObject(const QSize&, GLenum)
    {21, 74, 126, 3, Smoke::mf_ctor, 49, 2},	//221 QGLFramebufferObject::QGLFramebufferObject(int, int, GLenum)
    {21, 74, 130, 4, Smoke::mf_ctor, 49, 3},	//222 QGLFramebufferObject::QGLFramebufferObject(const QSize&, QGLFramebufferObject::Attachment, GLenum, GLenum)
    {21, 74, 135, 5, Smoke::mf_ctor, 49, 4},	//223 QGLFramebufferObject::QGLFramebufferObject(int, int, QGLFramebufferObject::Attachment, GLenum, GLenum)
    {21, 74, 141, 2, Smoke::mf_ctor, 49, 5},	//224 QGLFramebufferObject::QGLFramebufferObject(const QSize&, const QGLFramebufferObjectFormat&)
    {21, 74, 144, 3, Smoke::mf_ctor, 49, 6},	//225 QGLFramebufferObject::QGLFramebufferObject(int, int, const QGLFramebufferObjectFormat&)
    {21, 236, 0, 0, Smoke::mf_const, 51, 7},	//226 QGLFramebufferObject::format() const
    {21, 276, 0, 0, Smoke::mf_const, 167, 8},	//227 QGLFramebufferObject::isValid() const
    {21, 270, 0, 0, Smoke::mf_const, 167, 9},	//228 QGLFramebufferObject::isBound() const
    {21, 147, 0, 0, 0, 167, 10},	//229 QGLFramebufferObject::bind()
    {21, 335, 0, 0, 0, 167, 11},	//230 QGLFramebufferObject::release()
    {21, 507, 0, 0, Smoke::mf_const, 8, 12},	//231 QGLFramebufferObject::texture() const
    {21, 494, 0, 0, Smoke::mf_const, 79, 13},	//232 QGLFramebufferObject::size() const
    {21, 511, 0, 0, Smoke::mf_const, 61, 14},	//233 QGLFramebufferObject::toImage() const
    {21, 142, 0, 0, Smoke::mf_const, 50, 15},	//234 QGLFramebufferObject::attachment() const
    {21, 315, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 72, 16},	//235 QGLFramebufferObject::paintEngine() const
    {21, 250, 0, 0, Smoke::mf_const, 8, 17},	//236 QGLFramebufferObject::handle() const
    {21, 151, 0, 0, Smoke::mf_static, 167, 18},	//237 QGLFramebufferObject::bindDefault()
    {21, 253, 0, 0, Smoke::mf_static, 167, 19},	//238 QGLFramebufferObject::hasOpenGLFramebufferObjects()
    {21, 210, 75, 3, 0, 0, 20},	//239 QGLFramebufferObject::drawTexture(const QRectF&, GLuint, GLenum)
    {21, 210, 79, 3, 0, 0, 21},	//240 QGLFramebufferObject::drawTexture(const QPointF&, GLuint, GLenum)
    {21, 252, 0, 0, Smoke::mf_static, 167, 22},	//241 QGLFramebufferObject::hasOpenGLFramebufferBlit()
    {21, 160, 148, 6, Smoke::mf_static, 0, 23},	//242 QGLFramebufferObject::blitFramebuffer(QGLFramebufferObject*, const QRect&, QGLFramebufferObject*, const QRect&, GLbitfield, GLenum)
    {21, 290, 155, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 226, 24},	//243 QGLFramebufferObject::metric(QPaintDevice::PaintDeviceMetric) const
    {21, 198, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 226, 25},	//244 QGLFramebufferObject::devType() const
    {21, 74, 157, 1, Smoke::mf_ctor, 49, 26},	//245 QGLFramebufferObject::QGLFramebufferObject(const QSize&)
    {21, 74, 118, 2, Smoke::mf_ctor, 49, 27},	//246 QGLFramebufferObject::QGLFramebufferObject(int, int)
    {21, 74, 159, 2, Smoke::mf_ctor, 49, 28},	//247 QGLFramebufferObject::QGLFramebufferObject(const QSize&, QGLFramebufferObject::Attachment)
    {21, 74, 162, 3, Smoke::mf_ctor, 49, 29},	//248 QGLFramebufferObject::QGLFramebufferObject(const QSize&, QGLFramebufferObject::Attachment, GLenum)
    {21, 74, 166, 3, Smoke::mf_ctor, 49, 30},	//249 QGLFramebufferObject::QGLFramebufferObject(int, int, QGLFramebufferObject::Attachment)
    {21, 74, 170, 4, Smoke::mf_ctor, 49, 31},	//250 QGLFramebufferObject::QGLFramebufferObject(int, int, QGLFramebufferObject::Attachment, GLenum)
    {21, 210, 105, 2, 0, 0, 32},	//251 QGLFramebufferObject::drawTexture(const QRectF&, GLuint)
    {21, 210, 108, 2, 0, 0, 33},	//252 QGLFramebufferObject::drawTexture(const QPointF&, GLuint)
    {21, 160, 175, 4, Smoke::mf_static, 0, 34},	//253 QGLFramebufferObject::blitFramebuffer(QGLFramebufferObject*, const QRect&, QGLFramebufferObject*, const QRect&)
    {21, 160, 180, 5, Smoke::mf_static, 0, 35},	//254 QGLFramebufferObject::blitFramebuffer(QGLFramebufferObject*, const QRect&, QGLFramebufferObject*, const QRect&, GLbitfield)
    {21, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 50, 36},	//255 QGLFramebufferObject::NoAttachment (enum)
    {21, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 50, 37},	//256 QGLFramebufferObject::CombinedDepthStencil (enum)
    {21, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 50, 38},	//257 QGLFramebufferObject::Depth (enum)
    {21, 543, 0, 0, Smoke::mf_dtor, 0, 39 },	//258 QGLFramebufferObject::~QGLFramebufferObject()
    {22, 87, 0, 0, Smoke::mf_ctor, 53, 1},	//259 QGLFramebufferObjectFormat::QGLFramebufferObjectFormat()
    {22, 87, 186, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 53, 2},	//260 QGLFramebufferObjectFormat::QGLFramebufferObjectFormat(const QGLFramebufferObjectFormat&)
    {22, 306, 186, 1, 0, 52, 3},	//261 QGLFramebufferObjectFormat::operator=(const QGLFramebufferObjectFormat&)
    {22, 457, 20, 1, 0, 0, 4},	//262 QGLFramebufferObjectFormat::setSamples(int)
    {22, 362, 0, 0, Smoke::mf_const, 226, 5},	//263 QGLFramebufferObjectFormat::samples() const
    {22, 437, 86, 1, 0, 0, 6},	//264 QGLFramebufferObjectFormat::setMipmap(bool)
    {22, 294, 0, 0, Smoke::mf_const, 167, 7},	//265 QGLFramebufferObjectFormat::mipmap() const
    {22, 371, 188, 1, 0, 0, 8},	//266 QGLFramebufferObjectFormat::setAttachment(QGLFramebufferObject::Attachment)
    {22, 142, 0, 0, Smoke::mf_const, 50, 9},	//267 QGLFramebufferObjectFormat::attachment() const
    {22, 469, 190, 1, 0, 0, 10},	//268 QGLFramebufferObjectFormat::setTextureTarget(GLenum)
    {22, 509, 0, 0, Smoke::mf_const, 5, 11},	//269 QGLFramebufferObjectFormat::textureTarget() const
    {22, 435, 190, 1, 0, 0, 12},	//270 QGLFramebufferObjectFormat::setInternalTextureFormat(GLenum)
    {22, 269, 0, 0, Smoke::mf_const, 5, 13},	//271 QGLFramebufferObjectFormat::internalTextureFormat() const
    {22, 308, 186, 1, Smoke::mf_const, 167, 14},	//272 QGLFramebufferObjectFormat::operator==(const QGLFramebufferObjectFormat&) const
    {22, 301, 186, 1, Smoke::mf_const, 167, 15},	//273 QGLFramebufferObjectFormat::operator!=(const QGLFramebufferObjectFormat&) const
    {22, 544, 0, 0, Smoke::mf_dtor, 0, 16 },	//274 QGLFramebufferObjectFormat::~QGLFramebufferObjectFormat()
    {23, 89, 192, 3, Smoke::mf_ctor, 55, 1},	//275 QGLPixelBuffer::QGLPixelBuffer(const QSize&, const QGLFormat&, QGLWidget*)
    {23, 89, 196, 4, Smoke::mf_ctor, 55, 2},	//276 QGLPixelBuffer::QGLPixelBuffer(int, int, const QGLFormat&, QGLWidget*)
    {23, 276, 0, 0, Smoke::mf_const, 167, 3},	//277 QGLPixelBuffer::isValid() const
    {23, 284, 0, 0, 0, 167, 4},	//278 QGLPixelBuffer::makeCurrent()
    {23, 205, 0, 0, 0, 167, 5},	//279 QGLPixelBuffer::doneCurrent()
    {23, 237, 0, 0, Smoke::mf_const, 8, 6},	//280 QGLPixelBuffer::generateDynamicTexture() const
    {23, 158, 73, 1, 0, 167, 7},	//281 QGLPixelBuffer::bindToDynamicTexture(GLuint)
    {23, 337, 0, 0, 0, 0, 8},	//282 QGLPixelBuffer::releaseFromDynamicTexture()
    {23, 528, 73, 1, Smoke::mf_const, 0, 9},	//283 QGLPixelBuffer::updateDynamicTexture(GLuint) const
    {23, 152, 97, 2, 0, 8, 10},	//284 QGLPixelBuffer::bindTexture(const QImage&, GLenum)
    {23, 152, 102, 2, 0, 8, 11},	//285 QGLPixelBuffer::bindTexture(const QPixmap&, GLenum)
    {23, 152, 71, 1, 0, 8, 12},	//286 QGLPixelBuffer::bindTexture(const QString&)
    {23, 192, 73, 1, 0, 0, 13},	//287 QGLPixelBuffer::deleteTexture(GLuint)
    {23, 210, 75, 3, 0, 0, 14},	//288 QGLPixelBuffer::drawTexture(const QRectF&, GLuint, GLenum)
    {23, 210, 79, 3, 0, 0, 15},	//289 QGLPixelBuffer::drawTexture(const QPointF&, GLuint, GLenum)
    {23, 494, 0, 0, Smoke::mf_const, 79, 16},	//290 QGLPixelBuffer::size() const
    {23, 250, 0, 0, Smoke::mf_const, 229, 17},	//291 QGLPixelBuffer::handle() const
    {23, 511, 0, 0, Smoke::mf_const, 61, 18},	//292 QGLPixelBuffer::toImage() const
    {23, 315, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 72, 19},	//293 QGLPixelBuffer::paintEngine() const
    {23, 236, 0, 0, Smoke::mf_const, 44, 20},	//294 QGLPixelBuffer::format() const
    {23, 255, 0, 0, Smoke::mf_static, 167, 21},	//295 QGLPixelBuffer::hasOpenGLPbuffers()
    {23, 290, 155, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 226, 22},	//296 QGLPixelBuffer::metric(QPaintDevice::PaintDeviceMetric) const
    {23, 198, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 226, 23},	//297 QGLPixelBuffer::devType() const
    {23, 89, 157, 1, Smoke::mf_ctor, 55, 24},	//298 QGLPixelBuffer::QGLPixelBuffer(const QSize&)
    {23, 89, 201, 2, Smoke::mf_ctor, 55, 25},	//299 QGLPixelBuffer::QGLPixelBuffer(const QSize&, const QGLFormat&)
    {23, 89, 118, 2, Smoke::mf_ctor, 55, 26},	//300 QGLPixelBuffer::QGLPixelBuffer(int, int)
    {23, 89, 204, 3, Smoke::mf_ctor, 55, 27},	//301 QGLPixelBuffer::QGLPixelBuffer(int, int, const QGLFormat&)
    {23, 152, 95, 1, 0, 8, 28},	//302 QGLPixelBuffer::bindTexture(const QImage&)
    {23, 152, 100, 1, 0, 8, 29},	//303 QGLPixelBuffer::bindTexture(const QPixmap&)
    {23, 210, 105, 2, 0, 0, 30},	//304 QGLPixelBuffer::drawTexture(const QRectF&, GLuint)
    {23, 210, 108, 2, 0, 0, 31},	//305 QGLPixelBuffer::drawTexture(const QPointF&, GLuint)
    {23, 545, 0, 0, Smoke::mf_dtor, 0, 32 },	//306 QGLPixelBuffer::~QGLPixelBuffer()
    {24, 289, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 203, 1},	//307 QGLShader::metaObject() const
    {24, 330, 208, 1, Smoke::mf_virtual, 230, 2},	//308 QGLShader::qt_metacast(const char*)
    {24, 512, 210, 2, Smoke::mf_static, 80, 3},	//309 QGLShader::tr(const char*, const char*)
    {24, 516, 210, 2, Smoke::mf_static, 80, 4},	//310 QGLShader::trUtf8(const char*, const char*)
    {24, 512, 213, 3, Smoke::mf_static, 80, 5},	//311 QGLShader::tr(const char*, const char*, int)
    {24, 516, 213, 3, Smoke::mf_static, 80, 6},	//312 QGLShader::trUtf8(const char*, const char*, int)
    {24, 328, 217, 3, Smoke::mf_virtual, 226, 7},	//313 QGLShader::qt_metacall(QMetaObject::Call, int, void**)
    {24, 96, 221, 2, Smoke::mf_ctor, 56, 8},	//314 QGLShader::QGLShader(QFlags<QGLShader::ShaderTypeBit>, QObject*)
    {24, 96, 224, 3, Smoke::mf_ctor, 56, 9},	//315 QGLShader::QGLShader(QFlags<QGLShader::ShaderTypeBit>, const QGLContext*, QObject*)
    {24, 491, 0, 0, Smoke::mf_const, 31, 10},	//316 QGLShader::shaderType() const
    {24, 175, 208, 1, 0, 167, 11},	//317 QGLShader::compileSourceCode(const char*)
    {24, 175, 228, 1, 0, 167, 12},	//318 QGLShader::compileSourceCode(const QByteArray&)
    {24, 175, 71, 1, 0, 167, 13},	//319 QGLShader::compileSourceCode(const QString&)
    {24, 178, 71, 1, 0, 167, 14},	//320 QGLShader::compileSourceFile(const QString&)
    {24, 496, 0, 0, Smoke::mf_const, 15, 15},	//321 QGLShader::sourceCode() const
    {24, 271, 0, 0, Smoke::mf_const, 167, 16},	//322 QGLShader::isCompiled() const
    {24, 282, 0, 0, Smoke::mf_const, 80, 17},	//323 QGLShader::log() const
    {24, 490, 0, 0, Smoke::mf_const, 8, 18},	//324 QGLShader::shaderId() const
    {24, 258, 230, 2, Smoke::mf_static, 167, 19},	//325 QGLShader::hasOpenGLShaders(QFlags<QGLShader::ShaderTypeBit>, const QGLContext*)
    {24, 512, 208, 1, Smoke::mf_static, 80, 20},	//326 QGLShader::tr(const char*)
    {24, 516, 208, 1, Smoke::mf_static, 80, 21},	//327 QGLShader::trUtf8(const char*)
    {24, 96, 233, 1, Smoke::mf_ctor, 56, 22},	//328 QGLShader::QGLShader(QFlags<QGLShader::ShaderTypeBit>)
    {24, 96, 230, 2, Smoke::mf_ctor, 56, 23},	//329 QGLShader::QGLShader(QFlags<QGLShader::ShaderTypeBit>, const QGLContext*)
    {24, 258, 233, 1, Smoke::mf_static, 167, 24},	//330 QGLShader::hasOpenGLShaders(QFlags<QGLShader::ShaderTypeBit>)
    {24, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 202, 25},	//331 QGLShader::staticMetaObject() const
    {24, 122, 0, 0, Smoke::mf_static|Smoke::mf_enum, 57, 26},	//332 QGLShader::Vertex (enum)
    {24, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 57, 27},	//333 QGLShader::Fragment (enum)
    {24, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 57, 28},	//334 QGLShader::Geometry (enum)
    {24, 546, 0, 0, Smoke::mf_dtor, 0, 29 },	//335 QGLShader::~QGLShader()
    {25, 289, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 203, 1},	//336 QGLShaderProgram::metaObject() const
    {25, 330, 208, 1, Smoke::mf_virtual, 230, 2},	//337 QGLShaderProgram::qt_metacast(const char*)
    {25, 512, 210, 2, Smoke::mf_static, 80, 3},	//338 QGLShaderProgram::tr(const char*, const char*)
    {25, 516, 210, 2, Smoke::mf_static, 80, 4},	//339 QGLShaderProgram::trUtf8(const char*, const char*)
    {25, 512, 213, 3, Smoke::mf_static, 80, 5},	//340 QGLShaderProgram::tr(const char*, const char*, int)
    {25, 516, 213, 3, Smoke::mf_static, 80, 6},	//341 QGLShaderProgram::trUtf8(const char*, const char*, int)
    {25, 328, 217, 3, Smoke::mf_virtual, 226, 7},	//342 QGLShaderProgram::qt_metacall(QMetaObject::Call, int, void**)
    {25, 100, 235, 1, Smoke::mf_ctor, 58, 8},	//343 QGLShaderProgram::QGLShaderProgram(QObject*)
    {25, 100, 237, 2, Smoke::mf_ctor, 58, 9},	//344 QGLShaderProgram::QGLShaderProgram(const QGLContext*, QObject*)
    {25, 128, 240, 1, 0, 167, 10},	//345 QGLShaderProgram::addShader(QGLShader*)
    {25, 339, 240, 1, 0, 0, 11},	//346 QGLShaderProgram::removeShader(QGLShader*)
    {25, 492, 0, 0, Smoke::mf_const, 65, 12},	//347 QGLShaderProgram::shaders() const
    {25, 130, 242, 2, 0, 167, 13},	//348 QGLShaderProgram::addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>, const char*)
    {25, 130, 245, 2, 0, 167, 14},	//349 QGLShaderProgram::addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>, const QByteArray&)
    {25, 130, 248, 2, 0, 167, 15},	//350 QGLShaderProgram::addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>, const QString&)
    {25, 133, 248, 2, 0, 167, 16},	//351 QGLShaderProgram::addShaderFromSourceFile(QFlags<QGLShader::ShaderTypeBit>, const QString&)
    {25, 338, 0, 0, 0, 0, 17},	//352 QGLShaderProgram::removeAllShaders()
    {25, 281, 0, 0, Smoke::mf_virtual, 167, 18},	//353 QGLShaderProgram::link()
    {25, 274, 0, 0, Smoke::mf_const, 167, 19},	//354 QGLShaderProgram::isLinked() const
    {25, 282, 0, 0, Smoke::mf_const, 80, 20},	//355 QGLShaderProgram::log() const
    {25, 147, 0, 0, 0, 167, 21},	//356 QGLShaderProgram::bind()
    {25, 335, 0, 0, 0, 0, 22},	//357 QGLShaderProgram::release()
    {25, 323, 0, 0, Smoke::mf_const, 8, 23},	//358 QGLShaderProgram::programId() const
    {25, 288, 0, 0, Smoke::mf_const, 226, 24},	//359 QGLShaderProgram::maxGeometryOutputVertices() const
    {25, 427, 20, 1, 0, 0, 25},	//360 QGLShaderProgram::setGeometryOutputVertexCount(int)
    {25, 242, 0, 0, Smoke::mf_const, 226, 26},	//361 QGLShaderProgram::geometryOutputVertexCount() const
    {25, 423, 190, 1, 0, 0, 27},	//362 QGLShaderProgram::setGeometryInputType(GLenum)
    {25, 240, 0, 0, Smoke::mf_const, 5, 28},	//363 QGLShaderProgram::geometryInputType() const
    {25, 425, 190, 1, 0, 0, 29},	//364 QGLShaderProgram::setGeometryOutputType(GLenum)
    {25, 241, 0, 0, Smoke::mf_const, 5, 30},	//365 QGLShaderProgram::geometryOutputType() const
    {25, 148, 251, 2, 0, 0, 31},	//366 QGLShaderProgram::bindAttributeLocation(const char*, int)
    {25, 148, 254, 2, 0, 0, 32},	//367 QGLShaderProgram::bindAttributeLocation(const QByteArray&, int)
    {25, 148, 257, 2, 0, 0, 33},	//368 QGLShaderProgram::bindAttributeLocation(const QString&, int)
    {25, 143, 208, 1, Smoke::mf_const, 226, 34},	//369 QGLShaderProgram::attributeLocation(const char*) const
    {25, 143, 228, 1, Smoke::mf_const, 226, 35},	//370 QGLShaderProgram::attributeLocation(const QByteArray&) const
    {25, 143, 71, 1, Smoke::mf_const, 226, 36},	//371 QGLShaderProgram::attributeLocation(const QString&) const
    {25, 382, 260, 2, 0, 0, 37},	//372 QGLShaderProgram::setAttributeValue(int, GLfloat)
    {25, 382, 263, 3, 0, 0, 38},	//373 QGLShaderProgram::setAttributeValue(int, GLfloat, GLfloat)
    {25, 382, 267, 4, 0, 0, 39},	//374 QGLShaderProgram::setAttributeValue(int, GLfloat, GLfloat, GLfloat)
    {25, 382, 272, 5, 0, 0, 40},	//375 QGLShaderProgram::setAttributeValue(int, GLfloat, GLfloat, GLfloat, GLfloat)
    {25, 382, 278, 2, 0, 0, 41},	//376 QGLShaderProgram::setAttributeValue(int, const QVector2D&)
    {25, 382, 281, 2, 0, 0, 42},	//377 QGLShaderProgram::setAttributeValue(int, const QVector3D&)
    {25, 382, 284, 2, 0, 0, 43},	//378 QGLShaderProgram::setAttributeValue(int, const QVector4D&)
    {25, 382, 33, 2, 0, 0, 44},	//379 QGLShaderProgram::setAttributeValue(int, const QColor&)
    {25, 382, 287, 4, 0, 0, 45},	//380 QGLShaderProgram::setAttributeValue(int, const GLfloat*, int, int)
    {25, 382, 292, 2, 0, 0, 46},	//381 QGLShaderProgram::setAttributeValue(const char*, GLfloat)
    {25, 382, 295, 3, 0, 0, 47},	//382 QGLShaderProgram::setAttributeValue(const char*, GLfloat, GLfloat)
    {25, 382, 299, 4, 0, 0, 48},	//383 QGLShaderProgram::setAttributeValue(const char*, GLfloat, GLfloat, GLfloat)
    {25, 382, 304, 5, 0, 0, 49},	//384 QGLShaderProgram::setAttributeValue(const char*, GLfloat, GLfloat, GLfloat, GLfloat)
    {25, 382, 310, 2, 0, 0, 50},	//385 QGLShaderProgram::setAttributeValue(const char*, const QVector2D&)
    {25, 382, 313, 2, 0, 0, 51},	//386 QGLShaderProgram::setAttributeValue(const char*, const QVector3D&)
    {25, 382, 316, 2, 0, 0, 52},	//387 QGLShaderProgram::setAttributeValue(const char*, const QVector4D&)
    {25, 382, 319, 2, 0, 0, 53},	//388 QGLShaderProgram::setAttributeValue(const char*, const QColor&)
    {25, 382, 322, 4, 0, 0, 54},	//389 QGLShaderProgram::setAttributeValue(const char*, const GLfloat*, int, int)
    {25, 373, 287, 4, 0, 0, 55},	//390 QGLShaderProgram::setAttributeArray(int, const GLfloat*, int, int)
    {25, 373, 327, 3, 0, 0, 56},	//391 QGLShaderProgram::setAttributeArray(int, const QVector2D*, int)
    {25, 373, 331, 3, 0, 0, 57},	//392 QGLShaderProgram::setAttributeArray(int, const QVector3D*, int)
    {25, 373, 335, 3, 0, 0, 58},	//393 QGLShaderProgram::setAttributeArray(int, const QVector4D*, int)
    {25, 373, 339, 5, 0, 0, 59},	//394 QGLShaderProgram::setAttributeArray(int, GLenum, const void*, int, int)
    {25, 373, 322, 4, 0, 0, 60},	//395 QGLShaderProgram::setAttributeArray(const char*, const GLfloat*, int, int)
    {25, 373, 345, 3, 0, 0, 61},	//396 QGLShaderProgram::setAttributeArray(const char*, const QVector2D*, int)
    {25, 373, 349, 3, 0, 0, 62},	//397 QGLShaderProgram::setAttributeArray(const char*, const QVector3D*, int)
    {25, 373, 353, 3, 0, 0, 63},	//398 QGLShaderProgram::setAttributeArray(const char*, const QVector4D*, int)
    {25, 373, 357, 5, 0, 0, 64},	//399 QGLShaderProgram::setAttributeArray(const char*, GLenum, const void*, int, int)
    {25, 379, 363, 5, 0, 0, 65},	//400 QGLShaderProgram::setAttributeBuffer(int, GLenum, int, int, int)
    {25, 379, 369, 5, 0, 0, 66},	//401 QGLShaderProgram::setAttributeBuffer(const char*, GLenum, int, int, int)
    {25, 214, 20, 1, 0, 0, 67},	//402 QGLShaderProgram::enableAttributeArray(int)
    {25, 214, 208, 1, 0, 0, 68},	//403 QGLShaderProgram::enableAttributeArray(const char*)
    {25, 202, 20, 1, 0, 0, 69},	//404 QGLShaderProgram::disableAttributeArray(int)
    {25, 202, 208, 1, 0, 0, 70},	//405 QGLShaderProgram::disableAttributeArray(const char*)
    {25, 524, 208, 1, Smoke::mf_const, 226, 71},	//406 QGLShaderProgram::uniformLocation(const char*) const
    {25, 524, 228, 1, Smoke::mf_const, 226, 72},	//407 QGLShaderProgram::uniformLocation(const QByteArray&) const
    {25, 524, 71, 1, Smoke::mf_const, 226, 73},	//408 QGLShaderProgram::uniformLocation(const QString&) const
    {25, 471, 260, 2, 0, 0, 74},	//409 QGLShaderProgram::setUniformValue(int, GLfloat)
    {25, 471, 375, 2, 0, 0, 75},	//410 QGLShaderProgram::setUniformValue(int, GLint)
    {25, 471, 378, 2, 0, 0, 76},	//411 QGLShaderProgram::setUniformValue(int, GLuint)
    {25, 471, 263, 3, 0, 0, 77},	//412 QGLShaderProgram::setUniformValue(int, GLfloat, GLfloat)
    {25, 471, 267, 4, 0, 0, 78},	//413 QGLShaderProgram::setUniformValue(int, GLfloat, GLfloat, GLfloat)
    {25, 471, 272, 5, 0, 0, 79},	//414 QGLShaderProgram::setUniformValue(int, GLfloat, GLfloat, GLfloat, GLfloat)
    {25, 471, 278, 2, 0, 0, 80},	//415 QGLShaderProgram::setUniformValue(int, const QVector2D&)
    {25, 471, 281, 2, 0, 0, 81},	//416 QGLShaderProgram::setUniformValue(int, const QVector3D&)
    {25, 471, 284, 2, 0, 0, 82},	//417 QGLShaderProgram::setUniformValue(int, const QVector4D&)
    {25, 471, 33, 2, 0, 0, 83},	//418 QGLShaderProgram::setUniformValue(int, const QColor&)
    {25, 471, 381, 2, 0, 0, 84},	//419 QGLShaderProgram::setUniformValue(int, const QPoint&)
    {25, 471, 384, 2, 0, 0, 85},	//420 QGLShaderProgram::setUniformValue(int, const QPointF&)
    {25, 471, 387, 2, 0, 0, 86},	//421 QGLShaderProgram::setUniformValue(int, const QSize&)
    {25, 471, 390, 2, 0, 0, 87},	//422 QGLShaderProgram::setUniformValue(int, const QSizeF&)
    {25, 471, 393, 2, 0, 0, 88},	//423 QGLShaderProgram::setUniformValue(int, const QGenericMatrix<2,2,double>&)
    {25, 471, 396, 2, 0, 0, 89},	//424 QGLShaderProgram::setUniformValue(int, const QGenericMatrix<2,3,double>&)
    {25, 471, 399, 2, 0, 0, 90},	//425 QGLShaderProgram::setUniformValue(int, const QGenericMatrix<2,4,double>&)
    {25, 471, 402, 2, 0, 0, 91},	//426 QGLShaderProgram::setUniformValue(int, const QGenericMatrix<3,2,double>&)
    {25, 471, 405, 2, 0, 0, 92},	//427 QGLShaderProgram::setUniformValue(int, const QGenericMatrix<3,3,double>&)
    {25, 471, 408, 2, 0, 0, 93},	//428 QGLShaderProgram::setUniformValue(int, const QGenericMatrix<3,4,double>&)
    {25, 471, 411, 2, 0, 0, 94},	//429 QGLShaderProgram::setUniformValue(int, const QGenericMatrix<4,2,double>&)
    {25, 471, 414, 2, 0, 0, 95},	//430 QGLShaderProgram::setUniformValue(int, const QGenericMatrix<4,3,double>&)
    {25, 471, 417, 2, 0, 0, 96},	//431 QGLShaderProgram::setUniformValue(int, const QMatrix4x4&)
    {25, 471, 420, 2, 0, 0, 97},	//432 QGLShaderProgram::setUniformValue(int, const GLfloat[2][2])
    {25, 471, 423, 2, 0, 0, 98},	//433 QGLShaderProgram::setUniformValue(int, const GLfloat[3][3])
    {25, 471, 426, 2, 0, 0, 99},	//434 QGLShaderProgram::setUniformValue(int, const GLfloat[4][4])
    {25, 471, 429, 2, 0, 0, 100},	//435 QGLShaderProgram::setUniformValue(int, const QTransform&)
    {25, 471, 292, 2, 0, 0, 101},	//436 QGLShaderProgram::setUniformValue(const char*, GLfloat)
    {25, 471, 432, 2, 0, 0, 102},	//437 QGLShaderProgram::setUniformValue(const char*, GLint)
    {25, 471, 435, 2, 0, 0, 103},	//438 QGLShaderProgram::setUniformValue(const char*, GLuint)
    {25, 471, 295, 3, 0, 0, 104},	//439 QGLShaderProgram::setUniformValue(const char*, GLfloat, GLfloat)
    {25, 471, 299, 4, 0, 0, 105},	//440 QGLShaderProgram::setUniformValue(const char*, GLfloat, GLfloat, GLfloat)
    {25, 471, 304, 5, 0, 0, 106},	//441 QGLShaderProgram::setUniformValue(const char*, GLfloat, GLfloat, GLfloat, GLfloat)
    {25, 471, 310, 2, 0, 0, 107},	//442 QGLShaderProgram::setUniformValue(const char*, const QVector2D&)
    {25, 471, 313, 2, 0, 0, 108},	//443 QGLShaderProgram::setUniformValue(const char*, const QVector3D&)
    {25, 471, 316, 2, 0, 0, 109},	//444 QGLShaderProgram::setUniformValue(const char*, const QVector4D&)
    {25, 471, 319, 2, 0, 0, 110},	//445 QGLShaderProgram::setUniformValue(const char*, const QColor&)
    {25, 471, 438, 2, 0, 0, 111},	//446 QGLShaderProgram::setUniformValue(const char*, const QPoint&)
    {25, 471, 441, 2, 0, 0, 112},	//447 QGLShaderProgram::setUniformValue(const char*, const QPointF&)
    {25, 471, 444, 2, 0, 0, 113},	//448 QGLShaderProgram::setUniformValue(const char*, const QSize&)
    {25, 471, 447, 2, 0, 0, 114},	//449 QGLShaderProgram::setUniformValue(const char*, const QSizeF&)
    {25, 471, 450, 2, 0, 0, 115},	//450 QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<2,2,double>&)
    {25, 471, 453, 2, 0, 0, 116},	//451 QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<2,3,double>&)
    {25, 471, 456, 2, 0, 0, 117},	//452 QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<2,4,double>&)
    {25, 471, 459, 2, 0, 0, 118},	//453 QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<3,2,double>&)
    {25, 471, 462, 2, 0, 0, 119},	//454 QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<3,3,double>&)
    {25, 471, 465, 2, 0, 0, 120},	//455 QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<3,4,double>&)
    {25, 471, 468, 2, 0, 0, 121},	//456 QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<4,2,double>&)
    {25, 471, 471, 2, 0, 0, 122},	//457 QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<4,3,double>&)
    {25, 471, 474, 2, 0, 0, 123},	//458 QGLShaderProgram::setUniformValue(const char*, const QMatrix4x4&)
    {25, 471, 477, 2, 0, 0, 124},	//459 QGLShaderProgram::setUniformValue(const char*, const GLfloat[2][2])
    {25, 471, 480, 2, 0, 0, 125},	//460 QGLShaderProgram::setUniformValue(const char*, const GLfloat[3][3])
    {25, 471, 483, 2, 0, 0, 126},	//461 QGLShaderProgram::setUniformValue(const char*, const GLfloat[4][4])
    {25, 471, 486, 2, 0, 0, 127},	//462 QGLShaderProgram::setUniformValue(const char*, const QTransform&)
    {25, 477, 287, 4, 0, 0, 128},	//463 QGLShaderProgram::setUniformValueArray(int, const GLfloat*, int, int)
    {25, 477, 489, 3, 0, 0, 129},	//464 QGLShaderProgram::setUniformValueArray(int, const GLint*, int)
    {25, 477, 493, 3, 0, 0, 130},	//465 QGLShaderProgram::setUniformValueArray(int, const GLuint*, int)
    {25, 477, 327, 3, 0, 0, 131},	//466 QGLShaderProgram::setUniformValueArray(int, const QVector2D*, int)
    {25, 477, 331, 3, 0, 0, 132},	//467 QGLShaderProgram::setUniformValueArray(int, const QVector3D*, int)
    {25, 477, 335, 3, 0, 0, 133},	//468 QGLShaderProgram::setUniformValueArray(int, const QVector4D*, int)
    {25, 477, 497, 3, 0, 0, 134},	//469 QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<2,2,double>*, int)
    {25, 477, 501, 3, 0, 0, 135},	//470 QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<2,3,double>*, int)
    {25, 477, 505, 3, 0, 0, 136},	//471 QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<2,4,double>*, int)
    {25, 477, 509, 3, 0, 0, 137},	//472 QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<3,2,double>*, int)
    {25, 477, 513, 3, 0, 0, 138},	//473 QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<3,3,double>*, int)
    {25, 477, 517, 3, 0, 0, 139},	//474 QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<3,4,double>*, int)
    {25, 477, 521, 3, 0, 0, 140},	//475 QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<4,2,double>*, int)
    {25, 477, 525, 3, 0, 0, 141},	//476 QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<4,3,double>*, int)
    {25, 477, 529, 3, 0, 0, 142},	//477 QGLShaderProgram::setUniformValueArray(int, const QMatrix4x4*, int)
    {25, 477, 322, 4, 0, 0, 143},	//478 QGLShaderProgram::setUniformValueArray(const char*, const GLfloat*, int, int)
    {25, 477, 533, 3, 0, 0, 144},	//479 QGLShaderProgram::setUniformValueArray(const char*, const GLint*, int)
    {25, 477, 537, 3, 0, 0, 145},	//480 QGLShaderProgram::setUniformValueArray(const char*, const GLuint*, int)
    {25, 477, 345, 3, 0, 0, 146},	//481 QGLShaderProgram::setUniformValueArray(const char*, const QVector2D*, int)
    {25, 477, 349, 3, 0, 0, 147},	//482 QGLShaderProgram::setUniformValueArray(const char*, const QVector3D*, int)
    {25, 477, 353, 3, 0, 0, 148},	//483 QGLShaderProgram::setUniformValueArray(const char*, const QVector4D*, int)
    {25, 477, 541, 3, 0, 0, 149},	//484 QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<2,2,double>*, int)
    {25, 477, 545, 3, 0, 0, 150},	//485 QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<2,3,double>*, int)
    {25, 477, 549, 3, 0, 0, 151},	//486 QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<2,4,double>*, int)
    {25, 477, 553, 3, 0, 0, 152},	//487 QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<3,2,double>*, int)
    {25, 477, 557, 3, 0, 0, 153},	//488 QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<3,3,double>*, int)
    {25, 477, 561, 3, 0, 0, 154},	//489 QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<3,4,double>*, int)
    {25, 477, 565, 3, 0, 0, 155},	//490 QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<4,2,double>*, int)
    {25, 477, 569, 3, 0, 0, 156},	//491 QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<4,3,double>*, int)
    {25, 477, 573, 3, 0, 0, 157},	//492 QGLShaderProgram::setUniformValueArray(const char*, const QMatrix4x4*, int)
    {25, 256, 48, 1, Smoke::mf_static, 167, 158},	//493 QGLShaderProgram::hasOpenGLShaderPrograms(const QGLContext*)
    {25, 512, 208, 1, Smoke::mf_static, 80, 159},	//494 QGLShaderProgram::tr(const char*)
    {25, 516, 208, 1, Smoke::mf_static, 80, 160},	//495 QGLShaderProgram::trUtf8(const char*)
    {25, 100, 0, 0, Smoke::mf_ctor, 58, 161},	//496 QGLShaderProgram::QGLShaderProgram()
    {25, 100, 48, 1, Smoke::mf_ctor, 58, 162},	//497 QGLShaderProgram::QGLShaderProgram(const QGLContext*)
    {25, 373, 577, 3, 0, 0, 163},	//498 QGLShaderProgram::setAttributeArray(int, const GLfloat*, int)
    {25, 373, 581, 2, 0, 0, 164},	//499 QGLShaderProgram::setAttributeArray(int, const QVector2D*)
    {25, 373, 584, 2, 0, 0, 165},	//500 QGLShaderProgram::setAttributeArray(int, const QVector3D*)
    {25, 373, 587, 2, 0, 0, 166},	//501 QGLShaderProgram::setAttributeArray(int, const QVector4D*)
    {25, 373, 590, 4, 0, 0, 167},	//502 QGLShaderProgram::setAttributeArray(int, GLenum, const void*, int)
    {25, 373, 595, 3, 0, 0, 168},	//503 QGLShaderProgram::setAttributeArray(const char*, const GLfloat*, int)
    {25, 373, 599, 2, 0, 0, 169},	//504 QGLShaderProgram::setAttributeArray(const char*, const QVector2D*)
    {25, 373, 602, 2, 0, 0, 170},	//505 QGLShaderProgram::setAttributeArray(const char*, const QVector3D*)
    {25, 373, 605, 2, 0, 0, 171},	//506 QGLShaderProgram::setAttributeArray(const char*, const QVector4D*)
    {25, 373, 608, 4, 0, 0, 172},	//507 QGLShaderProgram::setAttributeArray(const char*, GLenum, const void*, int)
    {25, 379, 613, 4, 0, 0, 173},	//508 QGLShaderProgram::setAttributeBuffer(int, GLenum, int, int)
    {25, 379, 618, 4, 0, 0, 174},	//509 QGLShaderProgram::setAttributeBuffer(const char*, GLenum, int, int)
    {25, 256, 0, 0, Smoke::mf_static, 167, 175},	//510 QGLShaderProgram::hasOpenGLShaderPrograms()
    {25, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 202, 176},	//511 QGLShaderProgram::staticMetaObject() const
    {25, 547, 0, 0, Smoke::mf_dtor, 0, 177 },	//512 QGLShaderProgram::~QGLShaderProgram()
    {26, 289, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 203, 1},	//513 QGLWidget::metaObject() const
    {26, 330, 208, 1, Smoke::mf_virtual, 230, 2},	//514 QGLWidget::qt_metacast(const char*)
    {26, 512, 210, 2, Smoke::mf_static, 80, 3},	//515 QGLWidget::tr(const char*, const char*)
    {26, 516, 210, 2, Smoke::mf_static, 80, 4},	//516 QGLWidget::trUtf8(const char*, const char*)
    {26, 512, 213, 3, Smoke::mf_static, 80, 5},	//517 QGLWidget::tr(const char*, const char*, int)
    {26, 516, 213, 3, Smoke::mf_static, 80, 6},	//518 QGLWidget::trUtf8(const char*, const char*, int)
    {26, 328, 217, 3, Smoke::mf_virtual, 226, 7},	//519 QGLWidget::qt_metacall(QMetaObject::Call, int, void**)
    {26, 103, 623, 3, Smoke::mf_ctor, 59, 8},	//520 QGLWidget::QGLWidget(QWidget*, const QGLWidget*, QFlags<Qt::WindowType>)
    {26, 103, 627, 4, Smoke::mf_ctor, 59, 9},	//521 QGLWidget::QGLWidget(QGLContext*, QWidget*, const QGLWidget*, QFlags<Qt::WindowType>)
    {26, 103, 632, 4, Smoke::mf_ctor, 59, 10},	//522 QGLWidget::QGLWidget(const QGLFormat&, QWidget*, const QGLWidget*, QFlags<Qt::WindowType>)
    {26, 326, 91, 1, Smoke::mf_const, 0, 11},	//523 QGLWidget::qglColor(const QColor&) const
    {26, 324, 91, 1, Smoke::mf_const, 0, 12},	//524 QGLWidget::qglClearColor(const QColor&) const
    {26, 276, 0, 0, Smoke::mf_const, 167, 13},	//525 QGLWidget::isValid() const
    {26, 275, 0, 0, Smoke::mf_const, 167, 14},	//526 QGLWidget::isSharing() const
    {26, 284, 0, 0, 0, 0, 15},	//527 QGLWidget::makeCurrent()
    {26, 205, 0, 0, 0, 0, 16},	//528 QGLWidget::doneCurrent()
    {26, 206, 0, 0, Smoke::mf_const, 167, 17},	//529 QGLWidget::doubleBuffer() const
    {26, 502, 0, 0, 0, 0, 18},	//530 QGLWidget::swapBuffers()
    {26, 236, 0, 0, Smoke::mf_const, 44, 19},	//531 QGLWidget::format() const
    {26, 421, 46, 1, 0, 0, 20},	//532 QGLWidget::setFormat(const QGLFormat&)
    {26, 181, 0, 0, Smoke::mf_const, 179, 21},	//533 QGLWidget::context() const
    {26, 395, 637, 3, 0, 0, 22},	//534 QGLWidget::setContext(QGLContext*, const QGLContext*, bool)
    {26, 341, 641, 3, 0, 75, 23},	//535 QGLWidget::renderPixmap(int, int, bool)
    {26, 247, 86, 1, 0, 61, 24},	//536 QGLWidget::grabFrameBuffer(bool)
    {26, 285, 0, 0, 0, 0, 25},	//537 QGLWidget::makeOverlayCurrent()
    {26, 313, 0, 0, Smoke::mf_const, 179, 26},	//538 QGLWidget::overlayContext() const
    {26, 183, 95, 1, Smoke::mf_static, 61, 27},	//539 QGLWidget::convertToGLFormat(const QImage&)
    {26, 439, 86, 1, 0, 0, 28},	//540 QGLWidget::setMouseTracking(bool)
    {26, 174, 0, 0, Smoke::mf_const, 178, 29},	//541 QGLWidget::colormap() const
    {26, 393, 24, 1, 0, 0, 30},	//542 QGLWidget::setColormap(const QGLColormap&)
    {26, 345, 645, 5, 0, 0, 31},	//543 QGLWidget::renderText(int, int, const QString&, const QFont&, int)
    {26, 345, 651, 6, 0, 0, 32},	//544 QGLWidget::renderText(double, double, double, const QString&, const QFont&, int)
    {26, 315, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 72, 33},	//545 QGLWidget::paintEngine() const
    {26, 152, 53, 4, 0, 8, 34},	//546 QGLWidget::bindTexture(const QImage&, GLenum, GLint, QFlags<QGLContext::BindOption>)
    {26, 152, 58, 4, 0, 8, 35},	//547 QGLWidget::bindTexture(const QPixmap&, GLenum, GLint, QFlags<QGLContext::BindOption>)
    {26, 152, 63, 3, 0, 8, 36},	//548 QGLWidget::bindTexture(const QImage&, GLenum, GLint)
    {26, 152, 67, 3, 0, 8, 37},	//549 QGLWidget::bindTexture(const QPixmap&, GLenum, GLint)
    {26, 152, 71, 1, 0, 8, 38},	//550 QGLWidget::bindTexture(const QString&)
    {26, 192, 73, 1, 0, 0, 39},	//551 QGLWidget::deleteTexture(GLuint)
    {26, 210, 75, 3, 0, 0, 40},	//552 QGLWidget::drawTexture(const QRectF&, GLuint, GLenum)
    {26, 210, 79, 3, 0, 0, 41},	//553 QGLWidget::drawTexture(const QPointF&, GLuint, GLenum)
    {26, 530, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 42},	//554 QGLWidget::updateGL()
    {26, 531, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 43},	//555 QGLWidget::updateOverlayGL()
    {26, 222, 658, 1, Smoke::mf_protected|Smoke::mf_virtual, 167, 44},	//556 QGLWidget::event(QEvent*)
    {26, 264, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 45},	//557 QGLWidget::initializeGL()
    {26, 356, 118, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 46},	//558 QGLWidget::resizeGL(int, int)
    {26, 318, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 47},	//559 QGLWidget::paintGL()
    {26, 265, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 48},	//560 QGLWidget::initializeOverlayGL()
    {26, 358, 118, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 49},	//561 QGLWidget::resizeOverlayGL(int, int)
    {26, 319, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 50},	//562 QGLWidget::paintOverlayGL()
    {26, 389, 86, 1, Smoke::mf_protected, 0, 51},	//563 QGLWidget::setAutoBufferSwap(bool)
    {26, 146, 0, 0, Smoke::mf_const|Smoke::mf_protected, 167, 52},	//564 QGLWidget::autoBufferSwap() const
    {26, 316, 660, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 53},	//565 QGLWidget::paintEvent(QPaintEvent*)
    {26, 354, 662, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 54},	//566 QGLWidget::resizeEvent(QResizeEvent*)
    {26, 246, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 55},	//567 QGLWidget::glInit()
    {26, 245, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 56},	//568 QGLWidget::glDraw()
    {26, 233, 88, 2, Smoke::mf_protected, 226, 57},	//569 QGLWidget::fontDisplayListBase(const QFont&, int)
    {26, 512, 208, 1, Smoke::mf_static, 80, 58},	//570 QGLWidget::tr(const char*)
    {26, 516, 208, 1, Smoke::mf_static, 80, 59},	//571 QGLWidget::trUtf8(const char*)
    {26, 103, 0, 0, Smoke::mf_ctor, 59, 60},	//572 QGLWidget::QGLWidget()
    {26, 103, 664, 1, Smoke::mf_ctor, 59, 61},	//573 QGLWidget::QGLWidget(QWidget*)
    {26, 103, 666, 2, Smoke::mf_ctor, 59, 62},	//574 QGLWidget::QGLWidget(QWidget*, const QGLWidget*)
    {26, 103, 111, 1, Smoke::mf_ctor, 59, 63},	//575 QGLWidget::QGLWidget(QGLContext*)
    {26, 103, 669, 2, Smoke::mf_ctor, 59, 64},	//576 QGLWidget::QGLWidget(QGLContext*, QWidget*)
    {26, 103, 672, 3, Smoke::mf_ctor, 59, 65},	//577 QGLWidget::QGLWidget(QGLContext*, QWidget*, const QGLWidget*)
    {26, 103, 46, 1, Smoke::mf_ctor, 59, 66},	//578 QGLWidget::QGLWidget(const QGLFormat&)
    {26, 103, 676, 2, Smoke::mf_ctor, 59, 67},	//579 QGLWidget::QGLWidget(const QGLFormat&, QWidget*)
    {26, 103, 679, 3, Smoke::mf_ctor, 59, 68},	//580 QGLWidget::QGLWidget(const QGLFormat&, QWidget*, const QGLWidget*)
    {26, 395, 111, 1, 0, 0, 69},	//581 QGLWidget::setContext(QGLContext*)
    {26, 395, 683, 2, 0, 0, 70},	//582 QGLWidget::setContext(QGLContext*, const QGLContext*)
    {26, 341, 0, 0, 0, 75, 71},	//583 QGLWidget::renderPixmap()
    {26, 341, 20, 1, 0, 75, 72},	//584 QGLWidget::renderPixmap(int)
    {26, 341, 118, 2, 0, 75, 73},	//585 QGLWidget::renderPixmap(int, int)
    {26, 247, 0, 0, 0, 61, 74},	//586 QGLWidget::grabFrameBuffer()
    {26, 345, 686, 3, 0, 0, 75},	//587 QGLWidget::renderText(int, int, const QString&)
    {26, 345, 690, 4, 0, 0, 76},	//588 QGLWidget::renderText(int, int, const QString&, const QFont&)
    {26, 345, 695, 4, 0, 0, 77},	//589 QGLWidget::renderText(double, double, double, const QString&)
    {26, 345, 700, 5, 0, 0, 78},	//590 QGLWidget::renderText(double, double, double, const QString&, const QFont&)
    {26, 152, 95, 1, 0, 8, 79},	//591 QGLWidget::bindTexture(const QImage&)
    {26, 152, 97, 2, 0, 8, 80},	//592 QGLWidget::bindTexture(const QImage&, GLenum)
    {26, 152, 100, 1, 0, 8, 81},	//593 QGLWidget::bindTexture(const QPixmap&)
    {26, 152, 102, 2, 0, 8, 82},	//594 QGLWidget::bindTexture(const QPixmap&, GLenum)
    {26, 210, 105, 2, 0, 0, 83},	//595 QGLWidget::drawTexture(const QRectF&, GLuint)
    {26, 210, 108, 2, 0, 0, 84},	//596 QGLWidget::drawTexture(const QPointF&, GLuint)
    {26, 233, 706, 1, Smoke::mf_protected, 226, 85},	//597 QGLWidget::fontDisplayListBase(const QFont&)
    {26, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 202, 86},	//598 QGLWidget::staticMetaObject() const
    {26, 548, 0, 0, Smoke::mf_dtor, 0, 87 },	//599 QGLWidget::~QGLWidget()
    {27, 308, 708, 2, Smoke::mf_static, 167, 1},	//600 QGlobalSpace::operator==(const QGLFormat&, const QGLFormat&)
    {27, 311, 711, 2, Smoke::mf_static, 30, 2},	//601 QGlobalSpace::operator|(QGLFunctions::OpenGLFeature, QGLFunctions::OpenGLFeature)
    {27, 311, 714, 2, Smoke::mf_static, 31, 3},	//602 QGlobalSpace::operator|(QGLShader::ShaderTypeBit, QGLShader::ShaderTypeBit)
    {27, 304, 717, 2, Smoke::mf_static, 20, 4},	//603 QGlobalSpace::operator<<(QDebug, const QGLFormat&)
    {27, 311, 720, 2, Smoke::mf_static, 29, 5},	//604 QGlobalSpace::operator|(QGLFormat::OpenGLVersionFlag, QGLFormat::OpenGLVersionFlag)
    {27, 311, 723, 2, Smoke::mf_static, 62, 6},	//605 QGlobalSpace::operator|(QGL::FormatOption, int)
    {27, 311, 726, 2, Smoke::mf_static, 27, 7},	//606 QGlobalSpace::operator|(QGL::FormatOption, QGL::FormatOption)
    {27, 311, 729, 2, Smoke::mf_static, 28, 8},	//607 QGlobalSpace::operator|(QGLContext::BindOption, QGLContext::BindOption)
    {27, 301, 708, 2, Smoke::mf_static, 167, 9},	//608 QGlobalSpace::operator!=(const QGLFormat&, const QGLFormat&)
    {27, 311, 732, 2, Smoke::mf_static, 62, 10},	//609 QGlobalSpace::operator|(QGLShader::ShaderTypeBit, int)
    {27, 311, 735, 2, Smoke::mf_static, 30, 11},	//610 QGlobalSpace::operator|(QGLFunctions::OpenGLFeature, QFlags<QGLFunctions::OpenGLFeature>)
    {27, 311, 738, 2, Smoke::mf_static, 29, 12},	//611 QGlobalSpace::operator|(QGLFormat::OpenGLVersionFlag, QFlags<QGLFormat::OpenGLVersionFlag>)
    {27, 311, 741, 2, Smoke::mf_static, 27, 13},	//612 QGlobalSpace::operator|(QGL::FormatOption, QFlags<QGL::FormatOption>)
    {27, 311, 744, 2, Smoke::mf_static, 62, 14},	//613 QGlobalSpace::operator|(QGLFormat::OpenGLVersionFlag, int)
    {27, 311, 747, 2, Smoke::mf_static, 62, 15},	//614 QGlobalSpace::operator|(QGLFunctions::OpenGLFeature, int)
    {27, 311, 750, 2, Smoke::mf_static, 28, 16},	//615 QGlobalSpace::operator|(QGLContext::BindOption, QFlags<QGLContext::BindOption>)
    {27, 311, 753, 2, Smoke::mf_static, 62, 17},	//616 QGlobalSpace::operator|(QGLContext::BindOption, int)
    {27, 311, 756, 2, Smoke::mf_static, 31, 18},	//617 QGlobalSpace::operator|(QGLShader::ShaderTypeBit, QFlags<QGLShader::ShaderTypeBit>)
    {37, 222, 658, 1, Smoke::mf_virtual, 167, 0},	//618 QObject::event(QEvent*)
    {37, 224, 759, 2, Smoke::mf_virtual, 167, 0},	//619 QObject::eventFilter(QObject*, QEvent*)
    {37, 510, 762, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//620 QObject::timerEvent(QTimerEvent*)
    {37, 167, 764, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//621 QObject::childEvent(QChildEvent*)
    {37, 189, 658, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//622 QObject::customEvent(QEvent*)
    {37, 180, 208, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//623 QObject::connectNotify(const char*)
    {37, 204, 208, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//624 QObject::disconnectNotify(const char*)
    {62, 198, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 226, 0},	//625 QWidget::devType() const
    {62, 487, 86, 1, Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//626 QWidget::setVisible(bool)
    {62, 495, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 79, 0},	//627 QWidget::sizeHint() const
    {62, 292, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 79, 0},	//628 QWidget::minimumSizeHint() const
    {62, 262, 20, 1, Smoke::mf_const|Smoke::mf_virtual, 226, 0},	//629 QWidget::heightForWidth(int) const
    {62, 297, 766, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//630 QWidget::mousePressEvent(QMouseEvent*)
    {62, 298, 766, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//631 QWidget::mouseReleaseEvent(QMouseEvent*)
    {62, 295, 766, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//632 QWidget::mouseDoubleClickEvent(QMouseEvent*)
    {62, 296, 766, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//633 QWidget::mouseMoveEvent(QMouseEvent*)
    {62, 533, 768, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//634 QWidget::wheelEvent(QWheelEvent*)
    {62, 277, 770, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//635 QWidget::keyPressEvent(QKeyEvent*)
    {62, 278, 770, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//636 QWidget::keyReleaseEvent(QKeyEvent*)
    {62, 229, 772, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//637 QWidget::focusInEvent(QFocusEvent*)
    {62, 231, 772, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//638 QWidget::focusOutEvent(QFocusEvent*)
    {62, 217, 658, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//639 QWidget::enterEvent(QEvent*)
    {62, 280, 658, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//640 QWidget::leaveEvent(QEvent*)
    {62, 299, 774, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//641 QWidget::moveEvent(QMoveEvent*)
    {62, 171, 776, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//642 QWidget::closeEvent(QCloseEvent*)
    {62, 182, 778, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//643 QWidget::contextMenuEvent(QContextMenuEvent*)
    {62, 504, 780, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//644 QWidget::tabletEvent(QTabletEvent*)
    {62, 127, 782, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//645 QWidget::actionEvent(QActionEvent*)
    {62, 207, 784, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//646 QWidget::dragEnterEvent(QDragEnterEvent*)
    {62, 209, 786, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//647 QWidget::dragMoveEvent(QDragMoveEvent*)
    {62, 208, 788, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//648 QWidget::dragLeaveEvent(QDragLeaveEvent*)
    {62, 213, 790, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//649 QWidget::dropEvent(QDropEvent*)
    {62, 493, 792, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//650 QWidget::showEvent(QShowEvent*)
    {62, 263, 794, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//651 QWidget::hideEvent(QHideEvent*)
    {62, 538, 796, 1, Smoke::mf_protected|Smoke::mf_virtual, 167, 0},	//652 QWidget::x11Event(_XEvent*)
    {62, 166, 658, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//653 QWidget::changeEvent(QEvent*)
    {62, 290, 155, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 226, 0},	//654 QWidget::metric(QPaintDevice::PaintDeviceMetric) const
    {62, 267, 798, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//655 QWidget::inputMethodEvent(QInputMethodEvent*)
    {62, 268, 800, 1, Smoke::mf_const|Smoke::mf_virtual, 87, 0},	//656 QWidget::inputMethodQuery(Qt::InputMethodQuery) const
    {62, 230, 86, 1, Smoke::mf_protected|Smoke::mf_virtual, 167, 0},	//657 QWidget::focusNextPrevChild(bool)
    {62, 501, 802, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//658 QWidget::styleChange(QStyle&)
    {62, 216, 86, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//659 QWidget::enabledChange(bool)
    {62, 320, 804, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//660 QWidget::paletteChange(const QPalette&)
    {62, 232, 706, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//661 QWidget::fontChange(const QFont&)
    {62, 534, 86, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//662 QWidget::windowActivationChange(bool)
    {62, 279, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//663 QWidget::languageChange()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    601,  // QGlobalSpace::operator|(QGLFunctions::OpenGLFeature, QGLFunctions::OpenGLFeature)
    602,  // QGlobalSpace::operator|(QGLShader::ShaderTypeBit, QGLShader::ShaderTypeBit)
    604,  // QGlobalSpace::operator|(QGLFormat::OpenGLVersionFlag, QGLFormat::OpenGLVersionFlag)
    605,  // QGlobalSpace::operator|(QGL::FormatOption, int)
    606,  // QGlobalSpace::operator|(QGL::FormatOption, QGL::FormatOption)
    607,  // QGlobalSpace::operator|(QGLContext::BindOption, QGLContext::BindOption)
    609,  // QGlobalSpace::operator|(QGLShader::ShaderTypeBit, int)
    610,  // QGlobalSpace::operator|(QGLFunctions::OpenGLFeature, QFlags<QGLFunctions::OpenGLFeature>)
    611,  // QGlobalSpace::operator|(QGLFormat::OpenGLVersionFlag, QFlags<QGLFormat::OpenGLVersionFlag>)
    612,  // QGlobalSpace::operator|(QGL::FormatOption, QFlags<QGL::FormatOption>)
    613,  // QGlobalSpace::operator|(QGLFormat::OpenGLVersionFlag, int)
    614,  // QGlobalSpace::operator|(QGLFunctions::OpenGLFeature, int)
    615,  // QGlobalSpace::operator|(QGLContext::BindOption, QFlags<QGLContext::BindOption>)
    616,  // QGlobalSpace::operator|(QGLContext::BindOption, int)
    617,  // QGlobalSpace::operator|(QGLShader::ShaderTypeBit, QFlags<QGLShader::ShaderTypeBit>)
    0,
    119,  // QGLContext::bindTexture(const QImage&)
    121,  // QGLContext::bindTexture(const QPixmap&)
    0,
    120,  // QGLContext::bindTexture(const QImage&, GLenum)
    122,  // QGLContext::bindTexture(const QPixmap&, GLenum)
    0,
    94,  // QGLContext::bindTexture(const QImage&, GLenum, GLint)
    95,  // QGLContext::bindTexture(const QPixmap&, GLenum, GLint)
    0,
    92,  // QGLContext::bindTexture(const QImage&, GLenum, GLint, QFlags<QGLContext::BindOption>)
    93,  // QGLContext::bindTexture(const QPixmap&, GLenum, GLint, QFlags<QGLContext::BindOption>)
    0,
    123,  // QGLContext::drawTexture(const QRectF&, GLuint)
    124,  // QGLContext::drawTexture(const QPointF&, GLuint)
    0,
    98,  // QGLContext::drawTexture(const QRectF&, GLuint, GLenum)
    99,  // QGLContext::drawTexture(const QPointF&, GLuint, GLenum)
    0,
    302,  // QGLPixelBuffer::bindTexture(const QImage&)
    303,  // QGLPixelBuffer::bindTexture(const QPixmap&)
    0,
    284,  // QGLPixelBuffer::bindTexture(const QImage&, GLenum)
    285,  // QGLPixelBuffer::bindTexture(const QPixmap&, GLenum)
    0,
    304,  // QGLPixelBuffer::drawTexture(const QRectF&, GLuint)
    305,  // QGLPixelBuffer::drawTexture(const QPointF&, GLuint)
    0,
    288,  // QGLPixelBuffer::drawTexture(const QRectF&, GLuint, GLenum)
    289,  // QGLPixelBuffer::drawTexture(const QPointF&, GLuint, GLenum)
    0,
    573,  // QGLWidget::QGLWidget(QWidget*)
    575,  // QGLWidget::QGLWidget(QGLContext*)
    578,  // QGLWidget::QGLWidget(const QGLFormat&)
    0,
    574,  // QGLWidget::QGLWidget(QWidget*, const QGLWidget*)
    576,  // QGLWidget::QGLWidget(QGLContext*, QWidget*)
    579,  // QGLWidget::QGLWidget(const QGLFormat&, QWidget*)
    0,
    577,  // QGLWidget::QGLWidget(QGLContext*, QWidget*, const QGLWidget*)
    580,  // QGLWidget::QGLWidget(const QGLFormat&, QWidget*, const QGLWidget*)
    0,
    521,  // QGLWidget::QGLWidget(QGLContext*, QWidget*, const QGLWidget*, QFlags<Qt::WindowType>)
    522,  // QGLWidget::QGLWidget(const QGLFormat&, QWidget*, const QGLWidget*, QFlags<Qt::WindowType>)
    0,
    591,  // QGLWidget::bindTexture(const QImage&)
    593,  // QGLWidget::bindTexture(const QPixmap&)
    0,
    592,  // QGLWidget::bindTexture(const QImage&, GLenum)
    594,  // QGLWidget::bindTexture(const QPixmap&, GLenum)
    0,
    548,  // QGLWidget::bindTexture(const QImage&, GLenum, GLint)
    549,  // QGLWidget::bindTexture(const QPixmap&, GLenum, GLint)
    0,
    546,  // QGLWidget::bindTexture(const QImage&, GLenum, GLint, QFlags<QGLContext::BindOption>)
    547,  // QGLWidget::bindTexture(const QPixmap&, GLenum, GLint, QFlags<QGLContext::BindOption>)
    0,
    595,  // QGLWidget::drawTexture(const QRectF&, GLuint)
    596,  // QGLWidget::drawTexture(const QPointF&, GLuint)
    0,
    552,  // QGLWidget::drawTexture(const QRectF&, GLuint, GLenum)
    553,  // QGLWidget::drawTexture(const QPointF&, GLuint, GLenum)
    0,
    314,  // QGLShader::QGLShader(QFlags<QGLShader::ShaderTypeBit>, QObject*)
    329,  // QGLShader::QGLShader(QFlags<QGLShader::ShaderTypeBit>, const QGLContext*)
    0,
    317,  // QGLShader::compileSourceCode(const char*)
    319,  // QGLShader::compileSourceCode(const QString&)
    0,
    343,  // QGLShaderProgram::QGLShaderProgram(QObject*)
    497,  // QGLShaderProgram::QGLShaderProgram(const QGLContext*)
    0,
    348,  // QGLShaderProgram::addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>, const char*)
    350,  // QGLShaderProgram::addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>, const QString&)
    0,
    369,  // QGLShaderProgram::attributeLocation(const char*) const
    371,  // QGLShaderProgram::attributeLocation(const QString&) const
    0,
    366,  // QGLShaderProgram::bindAttributeLocation(const char*, int)
    368,  // QGLShaderProgram::bindAttributeLocation(const QString&, int)
    0,
    404,  // QGLShaderProgram::disableAttributeArray(int)
    405,  // QGLShaderProgram::disableAttributeArray(const char*)
    0,
    402,  // QGLShaderProgram::enableAttributeArray(int)
    403,  // QGLShaderProgram::enableAttributeArray(const char*)
    0,
    499,  // QGLShaderProgram::setAttributeArray(int, const QVector2D*)
    500,  // QGLShaderProgram::setAttributeArray(int, const QVector3D*)
    501,  // QGLShaderProgram::setAttributeArray(int, const QVector4D*)
    504,  // QGLShaderProgram::setAttributeArray(const char*, const QVector2D*)
    505,  // QGLShaderProgram::setAttributeArray(const char*, const QVector3D*)
    506,  // QGLShaderProgram::setAttributeArray(const char*, const QVector4D*)
    0,
    391,  // QGLShaderProgram::setAttributeArray(int, const QVector2D*, int)
    392,  // QGLShaderProgram::setAttributeArray(int, const QVector3D*, int)
    393,  // QGLShaderProgram::setAttributeArray(int, const QVector4D*, int)
    396,  // QGLShaderProgram::setAttributeArray(const char*, const QVector2D*, int)
    397,  // QGLShaderProgram::setAttributeArray(const char*, const QVector3D*, int)
    398,  // QGLShaderProgram::setAttributeArray(const char*, const QVector4D*, int)
    0,
    498,  // QGLShaderProgram::setAttributeArray(int, const GLfloat*, int)
    503,  // QGLShaderProgram::setAttributeArray(const char*, const GLfloat*, int)
    0,
    390,  // QGLShaderProgram::setAttributeArray(int, const GLfloat*, int, int)
    395,  // QGLShaderProgram::setAttributeArray(const char*, const GLfloat*, int, int)
    502,  // QGLShaderProgram::setAttributeArray(int, GLenum, const void*, int)
    507,  // QGLShaderProgram::setAttributeArray(const char*, GLenum, const void*, int)
    0,
    394,  // QGLShaderProgram::setAttributeArray(int, GLenum, const void*, int, int)
    399,  // QGLShaderProgram::setAttributeArray(const char*, GLenum, const void*, int, int)
    0,
    508,  // QGLShaderProgram::setAttributeBuffer(int, GLenum, int, int)
    509,  // QGLShaderProgram::setAttributeBuffer(const char*, GLenum, int, int)
    0,
    400,  // QGLShaderProgram::setAttributeBuffer(int, GLenum, int, int, int)
    401,  // QGLShaderProgram::setAttributeBuffer(const char*, GLenum, int, int, int)
    0,
    376,  // QGLShaderProgram::setAttributeValue(int, const QVector2D&)
    377,  // QGLShaderProgram::setAttributeValue(int, const QVector3D&)
    378,  // QGLShaderProgram::setAttributeValue(int, const QVector4D&)
    379,  // QGLShaderProgram::setAttributeValue(int, const QColor&)
    385,  // QGLShaderProgram::setAttributeValue(const char*, const QVector2D&)
    386,  // QGLShaderProgram::setAttributeValue(const char*, const QVector3D&)
    387,  // QGLShaderProgram::setAttributeValue(const char*, const QVector4D&)
    388,  // QGLShaderProgram::setAttributeValue(const char*, const QColor&)
    0,
    372,  // QGLShaderProgram::setAttributeValue(int, GLfloat)
    381,  // QGLShaderProgram::setAttributeValue(const char*, GLfloat)
    0,
    380,  // QGLShaderProgram::setAttributeValue(int, const GLfloat*, int, int)
    389,  // QGLShaderProgram::setAttributeValue(const char*, const GLfloat*, int, int)
    0,
    373,  // QGLShaderProgram::setAttributeValue(int, GLfloat, GLfloat)
    382,  // QGLShaderProgram::setAttributeValue(const char*, GLfloat, GLfloat)
    0,
    374,  // QGLShaderProgram::setAttributeValue(int, GLfloat, GLfloat, GLfloat)
    383,  // QGLShaderProgram::setAttributeValue(const char*, GLfloat, GLfloat, GLfloat)
    0,
    375,  // QGLShaderProgram::setAttributeValue(int, GLfloat, GLfloat, GLfloat, GLfloat)
    384,  // QGLShaderProgram::setAttributeValue(const char*, GLfloat, GLfloat, GLfloat, GLfloat)
    0,
    415,  // QGLShaderProgram::setUniformValue(int, const QVector2D&)
    416,  // QGLShaderProgram::setUniformValue(int, const QVector3D&)
    417,  // QGLShaderProgram::setUniformValue(int, const QVector4D&)
    418,  // QGLShaderProgram::setUniformValue(int, const QColor&)
    419,  // QGLShaderProgram::setUniformValue(int, const QPoint&)
    420,  // QGLShaderProgram::setUniformValue(int, const QPointF&)
    421,  // QGLShaderProgram::setUniformValue(int, const QSize&)
    422,  // QGLShaderProgram::setUniformValue(int, const QSizeF&)
    431,  // QGLShaderProgram::setUniformValue(int, const QMatrix4x4&)
    435,  // QGLShaderProgram::setUniformValue(int, const QTransform&)
    442,  // QGLShaderProgram::setUniformValue(const char*, const QVector2D&)
    443,  // QGLShaderProgram::setUniformValue(const char*, const QVector3D&)
    444,  // QGLShaderProgram::setUniformValue(const char*, const QVector4D&)
    445,  // QGLShaderProgram::setUniformValue(const char*, const QColor&)
    446,  // QGLShaderProgram::setUniformValue(const char*, const QPoint&)
    447,  // QGLShaderProgram::setUniformValue(const char*, const QPointF&)
    448,  // QGLShaderProgram::setUniformValue(const char*, const QSize&)
    449,  // QGLShaderProgram::setUniformValue(const char*, const QSizeF&)
    458,  // QGLShaderProgram::setUniformValue(const char*, const QMatrix4x4&)
    462,  // QGLShaderProgram::setUniformValue(const char*, const QTransform&)
    0,
    409,  // QGLShaderProgram::setUniformValue(int, GLfloat)
    410,  // QGLShaderProgram::setUniformValue(int, GLint)
    411,  // QGLShaderProgram::setUniformValue(int, GLuint)
    423,  // QGLShaderProgram::setUniformValue(int, const QGenericMatrix<2,2,double>&)
    424,  // QGLShaderProgram::setUniformValue(int, const QGenericMatrix<2,3,double>&)
    425,  // QGLShaderProgram::setUniformValue(int, const QGenericMatrix<2,4,double>&)
    426,  // QGLShaderProgram::setUniformValue(int, const QGenericMatrix<3,2,double>&)
    427,  // QGLShaderProgram::setUniformValue(int, const QGenericMatrix<3,3,double>&)
    428,  // QGLShaderProgram::setUniformValue(int, const QGenericMatrix<3,4,double>&)
    429,  // QGLShaderProgram::setUniformValue(int, const QGenericMatrix<4,2,double>&)
    430,  // QGLShaderProgram::setUniformValue(int, const QGenericMatrix<4,3,double>&)
    432,  // QGLShaderProgram::setUniformValue(int, const GLfloat[2][2])
    433,  // QGLShaderProgram::setUniformValue(int, const GLfloat[3][3])
    434,  // QGLShaderProgram::setUniformValue(int, const GLfloat[4][4])
    436,  // QGLShaderProgram::setUniformValue(const char*, GLfloat)
    437,  // QGLShaderProgram::setUniformValue(const char*, GLint)
    438,  // QGLShaderProgram::setUniformValue(const char*, GLuint)
    450,  // QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<2,2,double>&)
    451,  // QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<2,3,double>&)
    452,  // QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<2,4,double>&)
    453,  // QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<3,2,double>&)
    454,  // QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<3,3,double>&)
    455,  // QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<3,4,double>&)
    456,  // QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<4,2,double>&)
    457,  // QGLShaderProgram::setUniformValue(const char*, const QGenericMatrix<4,3,double>&)
    459,  // QGLShaderProgram::setUniformValue(const char*, const GLfloat[2][2])
    460,  // QGLShaderProgram::setUniformValue(const char*, const GLfloat[3][3])
    461,  // QGLShaderProgram::setUniformValue(const char*, const GLfloat[4][4])
    0,
    412,  // QGLShaderProgram::setUniformValue(int, GLfloat, GLfloat)
    439,  // QGLShaderProgram::setUniformValue(const char*, GLfloat, GLfloat)
    0,
    413,  // QGLShaderProgram::setUniformValue(int, GLfloat, GLfloat, GLfloat)
    440,  // QGLShaderProgram::setUniformValue(const char*, GLfloat, GLfloat, GLfloat)
    0,
    414,  // QGLShaderProgram::setUniformValue(int, GLfloat, GLfloat, GLfloat, GLfloat)
    441,  // QGLShaderProgram::setUniformValue(const char*, GLfloat, GLfloat, GLfloat, GLfloat)
    0,
    466,  // QGLShaderProgram::setUniformValueArray(int, const QVector2D*, int)
    467,  // QGLShaderProgram::setUniformValueArray(int, const QVector3D*, int)
    468,  // QGLShaderProgram::setUniformValueArray(int, const QVector4D*, int)
    477,  // QGLShaderProgram::setUniformValueArray(int, const QMatrix4x4*, int)
    481,  // QGLShaderProgram::setUniformValueArray(const char*, const QVector2D*, int)
    482,  // QGLShaderProgram::setUniformValueArray(const char*, const QVector3D*, int)
    483,  // QGLShaderProgram::setUniformValueArray(const char*, const QVector4D*, int)
    492,  // QGLShaderProgram::setUniformValueArray(const char*, const QMatrix4x4*, int)
    0,
    464,  // QGLShaderProgram::setUniformValueArray(int, const GLint*, int)
    465,  // QGLShaderProgram::setUniformValueArray(int, const GLuint*, int)
    469,  // QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<2,2,double>*, int)
    470,  // QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<2,3,double>*, int)
    471,  // QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<2,4,double>*, int)
    472,  // QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<3,2,double>*, int)
    473,  // QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<3,3,double>*, int)
    474,  // QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<3,4,double>*, int)
    475,  // QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<4,2,double>*, int)
    476,  // QGLShaderProgram::setUniformValueArray(int, const QGenericMatrix<4,3,double>*, int)
    479,  // QGLShaderProgram::setUniformValueArray(const char*, const GLint*, int)
    480,  // QGLShaderProgram::setUniformValueArray(const char*, const GLuint*, int)
    484,  // QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<2,2,double>*, int)
    485,  // QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<2,3,double>*, int)
    486,  // QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<2,4,double>*, int)
    487,  // QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<3,2,double>*, int)
    488,  // QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<3,3,double>*, int)
    489,  // QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<3,4,double>*, int)
    490,  // QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<4,2,double>*, int)
    491,  // QGLShaderProgram::setUniformValueArray(const char*, const QGenericMatrix<4,3,double>*, int)
    0,
    463,  // QGLShaderProgram::setUniformValueArray(int, const GLfloat*, int, int)
    478,  // QGLShaderProgram::setUniformValueArray(const char*, const GLfloat*, int, int)
    0,
    406,  // QGLShaderProgram::uniformLocation(const char*) const
    408,  // QGLShaderProgram::uniformLocation(const QString&) const
    0,
    251,  // QGLFramebufferObject::drawTexture(const QRectF&, GLuint)
    252,  // QGLFramebufferObject::drawTexture(const QPointF&, GLuint)
    0,
    239,  // QGLFramebufferObject::drawTexture(const QRectF&, GLuint, GLenum)
    240,  // QGLFramebufferObject::drawTexture(const QPointF&, GLuint, GLenum)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {16, 1, 6},	// QGL::AccumBuffer
    {16, 2, 5},	// QGL::AlphaChannel
    {16, 4, 15},	// QGL::ColorIndex
    {16, 9, 12},	// QGL::DeprecatedFunctions
    {16, 11, 3},	// QGL::DepthBuffer
    {16, 12, 9},	// QGL::DirectRendering
    {16, 13, 2},	// QGL::DoubleBuffer
    {16, 21, 10},	// QGL::HasOverlay
    {16, 24, 20},	// QGL::IndirectRendering
    {16, 30, 17},	// QGL::NoAccumBuffer
    {16, 31, 16},	// QGL::NoAlphaChannel
    {16, 34, 23},	// QGL::NoDeprecatedFunctions
    {16, 35, 14},	// QGL::NoDepthBuffer
    {16, 36, 21},	// QGL::NoOverlay
    {16, 38, 22},	// QGL::NoSampleBuffers
    {16, 39, 18},	// QGL::NoStencilBuffer
    {16, 40, 19},	// QGL::NoStereoBuffers
    {16, 111, 4},	// QGL::Rgba
    {16, 112, 11},	// QGL::SampleBuffers
    {16, 113, 13},	// QGL::SingleBuffer
    {16, 117, 7},	// QGL::StencilBuffer
    {16, 118, 8},	// QGL::StereoBuffers
    {16, 448, 1},	// QGL::setPreferredPaintEngine$
    {17, 16, 57},	// QGLBuffer::DynamicCopy
    {17, 17, 55},	// QGLBuffer::DynamicDraw
    {17, 18, 56},	// QGLBuffer::DynamicRead
    {17, 23, 46},	// QGLBuffer::IndexBuffer
    {17, 59, 47},	// QGLBuffer::PixelPackBuffer
    {17, 60, 48},	// QGLBuffer::PixelUnpackBuffer
    {17, 62, 24},	// QGLBuffer::QGLBuffer
    {17, 63, 26},	// QGLBuffer::QGLBuffer#
    {17, 64, 25},	// QGLBuffer::QGLBuffer$
    {17, 109, 58},	// QGLBuffer::ReadOnly
    {17, 110, 60},	// QGLBuffer::ReadWrite
    {17, 114, 54},	// QGLBuffer::StaticCopy
    {17, 115, 52},	// QGLBuffer::StaticDraw
    {17, 116, 53},	// QGLBuffer::StaticRead
    {17, 119, 51},	// QGLBuffer::StreamCopy
    {17, 120, 49},	// QGLBuffer::StreamDraw
    {17, 121, 50},	// QGLBuffer::StreamRead
    {17, 123, 45},	// QGLBuffer::VertexBuffer
    {17, 124, 59},	// QGLBuffer::WriteOnly
    {17, 136, 42},	// QGLBuffer::allocate$
    {17, 137, 41},	// QGLBuffer::allocate$$
    {17, 147, 34},	// QGLBuffer::bind
    {17, 165, 37},	// QGLBuffer::bufferId
    {17, 185, 31},	// QGLBuffer::create
    {17, 196, 33},	// QGLBuffer::destroy
    {17, 272, 32},	// QGLBuffer::isCreated
    {17, 287, 43},	// QGLBuffer::map$
    {17, 307, 27},	// QGLBuffer::operator=#
    {17, 333, 39},	// QGLBuffer::read$$$
    {17, 335, 35},	// QGLBuffer::release
    {17, 336, 36},	// QGLBuffer::release$
    {17, 482, 30},	// QGLBuffer::setUsagePattern$
    {17, 494, 38},	// QGLBuffer::size
    {17, 523, 28},	// QGLBuffer::type
    {17, 527, 44},	// QGLBuffer::unmap
    {17, 532, 29},	// QGLBuffer::usagePattern
    {17, 537, 40},	// QGLBuffer::write$$$
    {17, 539, 61},	// QGLBuffer::~QGLBuffer
    {18, 65, 62},	// QGLColormap::QGLColormap
    {18, 66, 63},	// QGLColormap::QGLColormap#
    {18, 197, 67},	// QGLColormap::detach
    {18, 219, 72},	// QGLColormap::entryColor$
    {18, 221, 71},	// QGLColormap::entryRgb$
    {18, 226, 73},	// QGLColormap::find$
    {18, 228, 74},	// QGLColormap::findNearest$
    {18, 250, 75},	// QGLColormap::handle
    {18, 273, 65},	// QGLColormap::isEmpty
    {18, 307, 64},	// QGLColormap::operator=#
    {18, 416, 77},	// QGLColormap::setEntries$$
    {18, 417, 68},	// QGLColormap::setEntries$$$
    {18, 419, 70},	// QGLColormap::setEntry$#
    {18, 420, 69},	// QGLColormap::setEntry$$
    {18, 432, 76},	// QGLColormap::setHandle$
    {18, 494, 66},	// QGLColormap::size
    {18, 540, 78},	// QGLColormap::~QGLColormap
    {19, 3, 135},	// QGLContext::CanFlipNativePixmapBindOption
    {19, 8, 136},	// QGLContext::DefaultBindOption
    {19, 25, 137},	// QGLContext::InternalBindOption
    {19, 26, 130},	// QGLContext::InvertedYBindOption
    {19, 27, 133},	// QGLContext::LinearFilteringBindOption
    {19, 28, 134},	// QGLContext::MemoryManagedBindOption
    {19, 29, 131},	// QGLContext::MipmapBindOption
    {19, 33, 129},	// QGLContext::NoBindOption
    {19, 61, 132},	// QGLContext::PremultipliedAlphaBindOption
    {19, 68, 80},	// QGLContext::QGLContext#
    {19, 69, 79},	// QGLContext::QGLContext##
    {19, 141, 85},	// QGLContext::areSharing##
    {19, 153, -17},	// QGLContext::bindTexture#
    {19, 154, -20},	// QGLContext::bindTexture#?
    {19, 155, -23},	// QGLContext::bindTexture#??
    {19, 156, -26},	// QGLContext::bindTexture#??$
    {19, 157, 96},	// QGLContext::bindTexture$
    {19, 168, 125},	// QGLContext::chooseContext
    {19, 169, 106},	// QGLContext::chooseContext#
    {19, 170, 108},	// QGLContext::chooseVisual
    {19, 173, 115},	// QGLContext::colorIndex#
    {19, 185, 118},	// QGLContext::create
    {19, 186, 81},	// QGLContext::create#
    {19, 187, 105},	// QGLContext::currentContext
    {19, 188, 127},	// QGLContext::currentCtx
    {19, 193, 97},	// QGLContext::deleteTexture?
    {19, 199, 103},	// QGLContext::device
    {19, 200, 109},	// QGLContext::deviceIsPixmap
    {19, 205, 90},	// QGLContext::doneCurrent
    {19, 211, -29},	// QGLContext::drawTexture#?
    {19, 212, -32},	// QGLContext::drawTexture#??
    {19, 236, 86},	// QGLContext::format
    {19, 239, 114},	// QGLContext::generateFontDisplayLists#$
    {19, 244, 102},	// QGLContext::getProcAddress$
    {19, 266, 112},	// QGLContext::initialized
    {19, 275, 83},	// QGLContext::isSharing
    {19, 276, 82},	// QGLContext::isValid
    {19, 284, 89},	// QGLContext::makeCurrent
    {19, 314, 104},	// QGLContext::overlayTransparentColor
    {19, 352, 87},	// QGLContext::requestedFormat
    {19, 353, 84},	// QGLContext::reset
    {19, 400, 128},	// QGLContext::setCurrentCtx#
    {19, 410, 117},	// QGLContext::setDevice#
    {19, 422, 88},	// QGLContext::setFormat#
    {19, 434, 113},	// QGLContext::setInitialized$
    {19, 468, 100},	// QGLContext::setTextureCacheLimit$
    {19, 484, 116},	// QGLContext::setValid$
    {19, 489, 111},	// QGLContext::setWindowCreated$
    {19, 502, 91},	// QGLContext::swapBuffers
    {19, 508, 101},	// QGLContext::textureCacheLimit
    {19, 521, 126},	// QGLContext::tryVisual#
    {19, 522, 107},	// QGLContext::tryVisual#$
    {19, 535, 110},	// QGLContext::windowCreated
    {19, 541, 138},	// QGLContext::~QGLContext
    {20, 6, 200},	// QGLFormat::CompatibilityProfile
    {20, 7, 199},	// QGLFormat::CoreProfile
    {20, 37, 198},	// QGLFormat::NoProfile
    {20, 41, 210},	// QGLFormat::OpenGL_ES_CommonLite_Version_1_0
    {20, 42, 212},	// QGLFormat::OpenGL_ES_CommonLite_Version_1_1
    {20, 43, 209},	// QGLFormat::OpenGL_ES_Common_Version_1_0
    {20, 44, 211},	// QGLFormat::OpenGL_ES_Common_Version_1_1
    {20, 45, 213},	// QGLFormat::OpenGL_ES_Version_2_0
    {20, 46, 202},	// QGLFormat::OpenGL_Version_1_1
    {20, 47, 203},	// QGLFormat::OpenGL_Version_1_2
    {20, 48, 204},	// QGLFormat::OpenGL_Version_1_3
    {20, 49, 205},	// QGLFormat::OpenGL_Version_1_4
    {20, 50, 206},	// QGLFormat::OpenGL_Version_1_5
    {20, 51, 207},	// QGLFormat::OpenGL_Version_2_0
    {20, 52, 208},	// QGLFormat::OpenGL_Version_2_1
    {20, 53, 214},	// QGLFormat::OpenGL_Version_3_0
    {20, 54, 215},	// QGLFormat::OpenGL_Version_3_1
    {20, 55, 216},	// QGLFormat::OpenGL_Version_3_2
    {20, 56, 217},	// QGLFormat::OpenGL_Version_3_3
    {20, 57, 218},	// QGLFormat::OpenGL_Version_4_0
    {20, 58, 201},	// QGLFormat::OpenGL_Version_None
    {20, 70, 139},	// QGLFormat::QGLFormat
    {20, 71, 141},	// QGLFormat::QGLFormat#
    {20, 72, 197},	// QGLFormat::QGLFormat$
    {20, 73, 140},	// QGLFormat::QGLFormat$$
    {20, 125, 171},	// QGLFormat::accum
    {20, 126, 146},	// QGLFormat::accumBufferSize
    {20, 138, 169},	// QGLFormat::alpha
    {20, 139, 154},	// QGLFormat::alphaBufferSize
    {20, 164, 152},	// QGLFormat::blueBufferSize
    {20, 190, 185},	// QGLFormat::defaultFormat
    {20, 191, 187},	// QGLFormat::defaultOverlayFormat
    {20, 194, 165},	// QGLFormat::depth
    {20, 195, 144},	// QGLFormat::depthBufferSize
    {20, 201, 177},	// QGLFormat::directRendering
    {20, 206, 163},	// QGLFormat::doubleBuffer
    {20, 249, 150},	// QGLFormat::greenBufferSize
    {20, 251, 189},	// QGLFormat::hasOpenGL
    {20, 254, 190},	// QGLFormat::hasOpenGLOverlays
    {20, 261, 179},	// QGLFormat::hasOverlay
    {20, 283, 192},	// QGLFormat::majorVersion
    {20, 293, 193},	// QGLFormat::minorVersion
    {20, 300, 196},	// QGLFormat::openGLVersionFlags
    {20, 307, 142},	// QGLFormat::operator=#
    {20, 321, 181},	// QGLFormat::plane
    {20, 322, 195},	// QGLFormat::profile
    {20, 334, 148},	// QGLFormat::redBufferSize
    {20, 360, 167},	// QGLFormat::rgba
    {20, 361, 158},	// QGLFormat::sampleBuffers
    {20, 362, 160},	// QGLFormat::samples
    {20, 364, 172},	// QGLFormat::setAccum$
    {20, 366, 145},	// QGLFormat::setAccumBufferSize$
    {20, 368, 170},	// QGLFormat::setAlpha$
    {20, 370, 153},	// QGLFormat::setAlphaBufferSize$
    {20, 392, 151},	// QGLFormat::setBlueBufferSize$
    {20, 402, 186},	// QGLFormat::setDefaultFormat#
    {20, 404, 188},	// QGLFormat::setDefaultOverlayFormat#
    {20, 406, 166},	// QGLFormat::setDepth$
    {20, 408, 143},	// QGLFormat::setDepthBufferSize$
    {20, 412, 178},	// QGLFormat::setDirectRendering$
    {20, 414, 164},	// QGLFormat::setDoubleBuffer$
    {20, 430, 149},	// QGLFormat::setGreenBufferSize$
    {20, 442, 183},	// QGLFormat::setOption$
    {20, 444, 180},	// QGLFormat::setOverlay$
    {20, 446, 182},	// QGLFormat::setPlane$
    {20, 450, 194},	// QGLFormat::setProfile$
    {20, 452, 147},	// QGLFormat::setRedBufferSize$
    {20, 454, 168},	// QGLFormat::setRgba$
    {20, 456, 157},	// QGLFormat::setSampleBuffers$
    {20, 458, 159},	// QGLFormat::setSamples$
    {20, 460, 174},	// QGLFormat::setStencil$
    {20, 462, 155},	// QGLFormat::setStencilBufferSize$
    {20, 464, 176},	// QGLFormat::setStereo$
    {20, 466, 161},	// QGLFormat::setSwapInterval$
    {20, 486, 191},	// QGLFormat::setVersion$$
    {20, 498, 173},	// QGLFormat::stencil
    {20, 499, 156},	// QGLFormat::stencilBufferSize
    {20, 500, 175},	// QGLFormat::stereo
    {20, 503, 162},	// QGLFormat::swapInterval
    {20, 506, 184},	// QGLFormat::testOption$
    {20, 542, 219},	// QGLFormat::~QGLFormat
    {21, 5, 256},	// QGLFramebufferObject::CombinedDepthStencil
    {21, 10, 257},	// QGLFramebufferObject::Depth
    {21, 32, 255},	// QGLFramebufferObject::NoAttachment
    {21, 75, 245},	// QGLFramebufferObject::QGLFramebufferObject#
    {21, 76, 224},	// QGLFramebufferObject::QGLFramebufferObject##
    {21, 77, 247},	// QGLFramebufferObject::QGLFramebufferObject#$
    {21, 78, 248},	// QGLFramebufferObject::QGLFramebufferObject#$?
    {21, 79, 222},	// QGLFramebufferObject::QGLFramebufferObject#$??
    {21, 80, 220},	// QGLFramebufferObject::QGLFramebufferObject#?
    {21, 81, 246},	// QGLFramebufferObject::QGLFramebufferObject$$
    {21, 82, 225},	// QGLFramebufferObject::QGLFramebufferObject$$#
    {21, 83, 249},	// QGLFramebufferObject::QGLFramebufferObject$$$
    {21, 84, 250},	// QGLFramebufferObject::QGLFramebufferObject$$$?
    {21, 85, 223},	// QGLFramebufferObject::QGLFramebufferObject$$$??
    {21, 86, 221},	// QGLFramebufferObject::QGLFramebufferObject$$?
    {21, 142, 234},	// QGLFramebufferObject::attachment
    {21, 147, 229},	// QGLFramebufferObject::bind
    {21, 151, 237},	// QGLFramebufferObject::bindDefault
    {21, 161, 253},	// QGLFramebufferObject::blitFramebuffer####
    {21, 162, 254},	// QGLFramebufferObject::blitFramebuffer####?
    {21, 163, 242},	// QGLFramebufferObject::blitFramebuffer####??
    {21, 198, 244},	// QGLFramebufferObject::devType
    {21, 211, -253},	// QGLFramebufferObject::drawTexture#?
    {21, 212, -256},	// QGLFramebufferObject::drawTexture#??
    {21, 236, 226},	// QGLFramebufferObject::format
    {21, 250, 236},	// QGLFramebufferObject::handle
    {21, 252, 241},	// QGLFramebufferObject::hasOpenGLFramebufferBlit
    {21, 253, 238},	// QGLFramebufferObject::hasOpenGLFramebufferObjects
    {21, 270, 228},	// QGLFramebufferObject::isBound
    {21, 276, 227},	// QGLFramebufferObject::isValid
    {21, 291, 243},	// QGLFramebufferObject::metric$
    {21, 315, 235},	// QGLFramebufferObject::paintEngine
    {21, 335, 230},	// QGLFramebufferObject::release
    {21, 494, 232},	// QGLFramebufferObject::size
    {21, 507, 231},	// QGLFramebufferObject::texture
    {21, 511, 233},	// QGLFramebufferObject::toImage
    {21, 543, 258},	// QGLFramebufferObject::~QGLFramebufferObject
    {22, 87, 259},	// QGLFramebufferObjectFormat::QGLFramebufferObjectFormat
    {22, 88, 260},	// QGLFramebufferObjectFormat::QGLFramebufferObjectFormat#
    {22, 142, 267},	// QGLFramebufferObjectFormat::attachment
    {22, 269, 271},	// QGLFramebufferObjectFormat::internalTextureFormat
    {22, 294, 265},	// QGLFramebufferObjectFormat::mipmap
    {22, 302, 273},	// QGLFramebufferObjectFormat::operator!=#
    {22, 307, 261},	// QGLFramebufferObjectFormat::operator=#
    {22, 309, 272},	// QGLFramebufferObjectFormat::operator==#
    {22, 362, 263},	// QGLFramebufferObjectFormat::samples
    {22, 372, 266},	// QGLFramebufferObjectFormat::setAttachment$
    {22, 436, 270},	// QGLFramebufferObjectFormat::setInternalTextureFormat?
    {22, 438, 264},	// QGLFramebufferObjectFormat::setMipmap$
    {22, 458, 262},	// QGLFramebufferObjectFormat::setSamples$
    {22, 470, 268},	// QGLFramebufferObjectFormat::setTextureTarget?
    {22, 509, 269},	// QGLFramebufferObjectFormat::textureTarget
    {22, 544, 274},	// QGLFramebufferObjectFormat::~QGLFramebufferObjectFormat
    {23, 90, 298},	// QGLPixelBuffer::QGLPixelBuffer#
    {23, 91, 299},	// QGLPixelBuffer::QGLPixelBuffer##
    {23, 92, 275},	// QGLPixelBuffer::QGLPixelBuffer###
    {23, 93, 300},	// QGLPixelBuffer::QGLPixelBuffer$$
    {23, 94, 301},	// QGLPixelBuffer::QGLPixelBuffer$$#
    {23, 95, 276},	// QGLPixelBuffer::QGLPixelBuffer$$##
    {23, 153, -35},	// QGLPixelBuffer::bindTexture#
    {23, 154, -38},	// QGLPixelBuffer::bindTexture#?
    {23, 157, 286},	// QGLPixelBuffer::bindTexture$
    {23, 159, 281},	// QGLPixelBuffer::bindToDynamicTexture?
    {23, 193, 287},	// QGLPixelBuffer::deleteTexture?
    {23, 198, 297},	// QGLPixelBuffer::devType
    {23, 205, 279},	// QGLPixelBuffer::doneCurrent
    {23, 211, -41},	// QGLPixelBuffer::drawTexture#?
    {23, 212, -44},	// QGLPixelBuffer::drawTexture#??
    {23, 236, 294},	// QGLPixelBuffer::format
    {23, 237, 280},	// QGLPixelBuffer::generateDynamicTexture
    {23, 250, 291},	// QGLPixelBuffer::handle
    {23, 255, 295},	// QGLPixelBuffer::hasOpenGLPbuffers
    {23, 276, 277},	// QGLPixelBuffer::isValid
    {23, 284, 278},	// QGLPixelBuffer::makeCurrent
    {23, 291, 296},	// QGLPixelBuffer::metric$
    {23, 315, 293},	// QGLPixelBuffer::paintEngine
    {23, 337, 282},	// QGLPixelBuffer::releaseFromDynamicTexture
    {23, 494, 290},	// QGLPixelBuffer::size
    {23, 511, 292},	// QGLPixelBuffer::toImage
    {23, 529, 283},	// QGLPixelBuffer::updateDynamicTexture?
    {23, 545, 306},	// QGLPixelBuffer::~QGLPixelBuffer
    {24, 19, 333},	// QGLShader::Fragment
    {24, 20, 334},	// QGLShader::Geometry
    {24, 97, 328},	// QGLShader::QGLShader$
    {24, 98, -79},	// QGLShader::QGLShader$#
    {24, 99, 315},	// QGLShader::QGLShader$##
    {24, 122, 332},	// QGLShader::Vertex
    {24, 176, 318},	// QGLShader::compileSourceCode#
    {24, 177, -82},	// QGLShader::compileSourceCode$
    {24, 179, 320},	// QGLShader::compileSourceFile$
    {24, 259, 330},	// QGLShader::hasOpenGLShaders$
    {24, 260, 325},	// QGLShader::hasOpenGLShaders$#
    {24, 271, 322},	// QGLShader::isCompiled
    {24, 282, 323},	// QGLShader::log
    {24, 289, 307},	// QGLShader::metaObject
    {24, 329, 313},	// QGLShader::qt_metacall$$?
    {24, 331, 308},	// QGLShader::qt_metacast$
    {24, 490, 324},	// QGLShader::shaderId
    {24, 491, 316},	// QGLShader::shaderType
    {24, 496, 321},	// QGLShader::sourceCode
    {24, 497, 331},	// QGLShader::staticMetaObject
    {24, 513, 326},	// QGLShader::tr$
    {24, 514, 309},	// QGLShader::tr$$
    {24, 515, 311},	// QGLShader::tr$$$
    {24, 517, 327},	// QGLShader::trUtf8$
    {24, 518, 310},	// QGLShader::trUtf8$$
    {24, 519, 312},	// QGLShader::trUtf8$$$
    {24, 546, 335},	// QGLShader::~QGLShader
    {25, 100, 496},	// QGLShaderProgram::QGLShaderProgram
    {25, 101, -85},	// QGLShaderProgram::QGLShaderProgram#
    {25, 102, 344},	// QGLShaderProgram::QGLShaderProgram##
    {25, 129, 345},	// QGLShaderProgram::addShader#
    {25, 131, 349},	// QGLShaderProgram::addShaderFromSourceCode$#
    {25, 132, -88},	// QGLShaderProgram::addShaderFromSourceCode$$
    {25, 134, 351},	// QGLShaderProgram::addShaderFromSourceFile$$
    {25, 144, 370},	// QGLShaderProgram::attributeLocation#
    {25, 145, -91},	// QGLShaderProgram::attributeLocation$
    {25, 147, 356},	// QGLShaderProgram::bind
    {25, 149, 367},	// QGLShaderProgram::bindAttributeLocation#$
    {25, 150, -94},	// QGLShaderProgram::bindAttributeLocation$$
    {25, 203, -97},	// QGLShaderProgram::disableAttributeArray$
    {25, 215, -100},	// QGLShaderProgram::enableAttributeArray$
    {25, 240, 363},	// QGLShaderProgram::geometryInputType
    {25, 241, 365},	// QGLShaderProgram::geometryOutputType
    {25, 242, 361},	// QGLShaderProgram::geometryOutputVertexCount
    {25, 256, 510},	// QGLShaderProgram::hasOpenGLShaderPrograms
    {25, 257, 493},	// QGLShaderProgram::hasOpenGLShaderPrograms#
    {25, 274, 354},	// QGLShaderProgram::isLinked
    {25, 281, 353},	// QGLShaderProgram::link
    {25, 282, 355},	// QGLShaderProgram::log
    {25, 288, 359},	// QGLShaderProgram::maxGeometryOutputVertices
    {25, 289, 336},	// QGLShaderProgram::metaObject
    {25, 323, 358},	// QGLShaderProgram::programId
    {25, 329, 342},	// QGLShaderProgram::qt_metacall$$?
    {25, 331, 337},	// QGLShaderProgram::qt_metacast$
    {25, 335, 357},	// QGLShaderProgram::release
    {25, 338, 352},	// QGLShaderProgram::removeAllShaders
    {25, 340, 346},	// QGLShaderProgram::removeShader#
    {25, 374, -103},	// QGLShaderProgram::setAttributeArray$#
    {25, 375, -110},	// QGLShaderProgram::setAttributeArray$#$
    {25, 376, -117},	// QGLShaderProgram::setAttributeArray$?$
    {25, 377, -120},	// QGLShaderProgram::setAttributeArray$?$$
    {25, 378, -125},	// QGLShaderProgram::setAttributeArray$?$$$
    {25, 380, -128},	// QGLShaderProgram::setAttributeBuffer$?$$
    {25, 381, -131},	// QGLShaderProgram::setAttributeBuffer$?$$$
    {25, 383, -134},	// QGLShaderProgram::setAttributeValue$#
    {25, 384, -143},	// QGLShaderProgram::setAttributeValue$?
    {25, 385, -146},	// QGLShaderProgram::setAttributeValue$?$$
    {25, 386, -149},	// QGLShaderProgram::setAttributeValue$??
    {25, 387, -152},	// QGLShaderProgram::setAttributeValue$???
    {25, 388, -155},	// QGLShaderProgram::setAttributeValue$????
    {25, 424, 362},	// QGLShaderProgram::setGeometryInputType?
    {25, 426, 364},	// QGLShaderProgram::setGeometryOutputType?
    {25, 428, 360},	// QGLShaderProgram::setGeometryOutputVertexCount$
    {25, 472, -158},	// QGLShaderProgram::setUniformValue$#
    {25, 473, -179},	// QGLShaderProgram::setUniformValue$?
    {25, 474, -208},	// QGLShaderProgram::setUniformValue$??
    {25, 475, -211},	// QGLShaderProgram::setUniformValue$???
    {25, 476, -214},	// QGLShaderProgram::setUniformValue$????
    {25, 478, -217},	// QGLShaderProgram::setUniformValueArray$#$
    {25, 479, -226},	// QGLShaderProgram::setUniformValueArray$?$
    {25, 480, -247},	// QGLShaderProgram::setUniformValueArray$?$$
    {25, 492, 347},	// QGLShaderProgram::shaders
    {25, 497, 511},	// QGLShaderProgram::staticMetaObject
    {25, 513, 494},	// QGLShaderProgram::tr$
    {25, 514, 338},	// QGLShaderProgram::tr$$
    {25, 515, 340},	// QGLShaderProgram::tr$$$
    {25, 517, 495},	// QGLShaderProgram::trUtf8$
    {25, 518, 339},	// QGLShaderProgram::trUtf8$$
    {25, 519, 341},	// QGLShaderProgram::trUtf8$$$
    {25, 525, 407},	// QGLShaderProgram::uniformLocation#
    {25, 526, -250},	// QGLShaderProgram::uniformLocation$
    {25, 547, 512},	// QGLShaderProgram::~QGLShaderProgram
    {26, 103, 572},	// QGLWidget::QGLWidget
    {26, 104, -47},	// QGLWidget::QGLWidget#
    {26, 105, -51},	// QGLWidget::QGLWidget##
    {26, 106, -55},	// QGLWidget::QGLWidget###
    {26, 107, -58},	// QGLWidget::QGLWidget###$
    {26, 108, 520},	// QGLWidget::QGLWidget##$
    {26, 146, 564},	// QGLWidget::autoBufferSwap
    {26, 153, -61},	// QGLWidget::bindTexture#
    {26, 154, -64},	// QGLWidget::bindTexture#?
    {26, 155, -67},	// QGLWidget::bindTexture#??
    {26, 156, -70},	// QGLWidget::bindTexture#??$
    {26, 157, 550},	// QGLWidget::bindTexture$
    {26, 174, 541},	// QGLWidget::colormap
    {26, 181, 533},	// QGLWidget::context
    {26, 184, 539},	// QGLWidget::convertToGLFormat#
    {26, 193, 551},	// QGLWidget::deleteTexture?
    {26, 205, 528},	// QGLWidget::doneCurrent
    {26, 206, 529},	// QGLWidget::doubleBuffer
    {26, 211, -73},	// QGLWidget::drawTexture#?
    {26, 212, -76},	// QGLWidget::drawTexture#??
    {26, 223, 556},	// QGLWidget::event#
    {26, 234, 597},	// QGLWidget::fontDisplayListBase#
    {26, 235, 569},	// QGLWidget::fontDisplayListBase#$
    {26, 236, 531},	// QGLWidget::format
    {26, 245, 568},	// QGLWidget::glDraw
    {26, 246, 567},	// QGLWidget::glInit
    {26, 247, 586},	// QGLWidget::grabFrameBuffer
    {26, 248, 536},	// QGLWidget::grabFrameBuffer$
    {26, 264, 557},	// QGLWidget::initializeGL
    {26, 265, 560},	// QGLWidget::initializeOverlayGL
    {26, 275, 526},	// QGLWidget::isSharing
    {26, 276, 525},	// QGLWidget::isValid
    {26, 284, 527},	// QGLWidget::makeCurrent
    {26, 285, 537},	// QGLWidget::makeOverlayCurrent
    {26, 289, 513},	// QGLWidget::metaObject
    {26, 313, 538},	// QGLWidget::overlayContext
    {26, 315, 545},	// QGLWidget::paintEngine
    {26, 317, 565},	// QGLWidget::paintEvent#
    {26, 318, 559},	// QGLWidget::paintGL
    {26, 319, 562},	// QGLWidget::paintOverlayGL
    {26, 325, 524},	// QGLWidget::qglClearColor#
    {26, 327, 523},	// QGLWidget::qglColor#
    {26, 329, 519},	// QGLWidget::qt_metacall$$?
    {26, 331, 514},	// QGLWidget::qt_metacast$
    {26, 341, 583},	// QGLWidget::renderPixmap
    {26, 342, 584},	// QGLWidget::renderPixmap$
    {26, 343, 585},	// QGLWidget::renderPixmap$$
    {26, 344, 535},	// QGLWidget::renderPixmap$$$
    {26, 346, 587},	// QGLWidget::renderText$$$
    {26, 347, 588},	// QGLWidget::renderText$$$#
    {26, 348, 543},	// QGLWidget::renderText$$$#$
    {26, 349, 589},	// QGLWidget::renderText$$$$
    {26, 350, 590},	// QGLWidget::renderText$$$$#
    {26, 351, 544},	// QGLWidget::renderText$$$$#$
    {26, 355, 566},	// QGLWidget::resizeEvent#
    {26, 357, 558},	// QGLWidget::resizeGL$$
    {26, 359, 561},	// QGLWidget::resizeOverlayGL$$
    {26, 390, 563},	// QGLWidget::setAutoBufferSwap$
    {26, 394, 542},	// QGLWidget::setColormap#
    {26, 396, 581},	// QGLWidget::setContext#
    {26, 397, 582},	// QGLWidget::setContext##
    {26, 398, 534},	// QGLWidget::setContext##$
    {26, 422, 532},	// QGLWidget::setFormat#
    {26, 440, 540},	// QGLWidget::setMouseTracking$
    {26, 497, 598},	// QGLWidget::staticMetaObject
    {26, 502, 530},	// QGLWidget::swapBuffers
    {26, 513, 570},	// QGLWidget::tr$
    {26, 514, 515},	// QGLWidget::tr$$
    {26, 515, 517},	// QGLWidget::tr$$$
    {26, 517, 571},	// QGLWidget::trUtf8$
    {26, 518, 516},	// QGLWidget::trUtf8$$
    {26, 519, 518},	// QGLWidget::trUtf8$$$
    {26, 530, 554},	// QGLWidget::updateGL
    {26, 531, 555},	// QGLWidget::updateOverlayGL
    {26, 548, 599},	// QGLWidget::~QGLWidget
    {27, 303, 608},	// QGlobalSpace::operator!=##
    {27, 305, 603},	// QGlobalSpace::operator<<##
    {27, 310, 600},	// QGlobalSpace::operator==##
    {27, 312, -1},	// QGlobalSpace::operator|$$
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();
SMOKE_IMPORT void init_qtgui_Smoke();

static bool initialized = false;
Smoke *qtopengl_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qtopengl_Smoke() {
    init_qtcore_Smoke();
    init_qtgui_Smoke();
    if (initialized) return;
    qtopengl_Smoke = new Smoke(
        "qtopengl",
        __smokeqtopengl::classes, 62,
        __smokeqtopengl::methods, 664,
        __smokeqtopengl::methodMaps, 466,
        __smokeqtopengl::methodNames, 548,
        __smokeqtopengl::types, 232,
        __smokeqtopengl::inheritanceList,
        __smokeqtopengl::argumentList,
        __smokeqtopengl::ambiguousMethodList,
        __smokeqtopengl::cast );
    initialized = true;
}

void delete_qtopengl_Smoke() { delete qtopengl_Smoke; }

}
