#include <phonon_includes.h>

#include <smoke.h>
#include <phonon_smoke.h>

namespace __smokephonon {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 2:   //Phonon::AbstractAudioOutput
      switch(to) {
        case 60: return (void*)(QObject*)(Phonon::AbstractAudioOutput*)xptr;
        case 17: return (void*)(Phonon::MediaNode*)(Phonon::AbstractAudioOutput*)xptr;
        case 2: return (void*)(Phonon::AbstractAudioOutput*)xptr;
        case 8: return (void*)(Phonon::AudioDataOutput*)(Phonon::AbstractAudioOutput*)xptr;
        case 9: return (void*)(Phonon::AudioOutput*)(Phonon::AbstractAudioOutput*)xptr;
        default: return xptr;
      }
    case 3:   //Phonon::AbstractAudioOutputPrivate
      switch(to) {
        case 3: return (void*)(Phonon::AbstractAudioOutputPrivate*)xptr;
        default: return xptr;
      }
    case 4:   //Phonon::AbstractMediaStream
      switch(to) {
        case 60: return (void*)(QObject*)(Phonon::AbstractMediaStream*)xptr;
        case 4: return (void*)(Phonon::AbstractMediaStream*)xptr;
        default: return xptr;
      }
    case 5:   //Phonon::AbstractMediaStreamPrivate
      switch(to) {
        case 5: return (void*)(Phonon::AbstractMediaStreamPrivate*)xptr;
        default: return xptr;
      }
    case 6:   //Phonon::AbstractVideoOutput
      switch(to) {
        case 17: return (void*)(Phonon::MediaNode*)(Phonon::AbstractVideoOutput*)xptr;
        case 6: return (void*)(Phonon::AbstractVideoOutput*)xptr;
        case 30: return (void*)(Phonon::VideoWidget*)(Phonon::AbstractVideoOutput*)xptr;
        default: return xptr;
      }
    case 7:   //Phonon::AbstractVideoOutputPrivate
      switch(to) {
        case 7: return (void*)(Phonon::AbstractVideoOutputPrivate*)xptr;
        default: return xptr;
      }
    case 8:   //Phonon::AudioDataOutput
      switch(to) {
        case 2: return (void*)(Phonon::AbstractAudioOutput*)(Phonon::AudioDataOutput*)xptr;
        case 60: return (void*)(QObject*)(Phonon::AudioDataOutput*)xptr;
        case 17: return (void*)(Phonon::MediaNode*)(Phonon::AudioDataOutput*)xptr;
        case 8: return (void*)(Phonon::AudioDataOutput*)xptr;
        default: return xptr;
      }
    case 9:   //Phonon::AudioOutput
      switch(to) {
        case 2: return (void*)(Phonon::AbstractAudioOutput*)(Phonon::AudioOutput*)xptr;
        case 60: return (void*)(QObject*)(Phonon::AudioOutput*)xptr;
        case 17: return (void*)(Phonon::MediaNode*)(Phonon::AudioOutput*)xptr;
        case 9: return (void*)(Phonon::AudioOutput*)xptr;
        default: return xptr;
      }
    case 10:   //Phonon::BackendCapabilities::Notifier
      switch(to) {
        case 60: return (void*)(QObject*)(Phonon::BackendCapabilities::Notifier*)xptr;
        case 10: return (void*)(Phonon::BackendCapabilities::Notifier*)xptr;
        default: return xptr;
      }
    case 12:   //Phonon::Effect
      switch(to) {
        case 60: return (void*)(QObject*)(Phonon::Effect*)xptr;
        case 17: return (void*)(Phonon::MediaNode*)(Phonon::Effect*)xptr;
        case 12: return (void*)(Phonon::Effect*)xptr;
        case 32: return (void*)(Phonon::VolumeFaderEffect*)(Phonon::Effect*)xptr;
        default: return xptr;
      }
    case 13:   //Phonon::EffectParameter
      switch(to) {
        case 13: return (void*)(Phonon::EffectParameter*)xptr;
        default: return xptr;
      }
    case 14:   //Phonon::EffectPrivate
      switch(to) {
        case 14: return (void*)(Phonon::EffectPrivate*)xptr;
        default: return xptr;
      }
    case 15:   //Phonon::EffectWidget
      switch(to) {
        case 75: return (void*)(QWidget*)(Phonon::EffectWidget*)xptr;
        case 60: return (void*)(QObject*)(Phonon::EffectWidget*)xptr;
        case 15: return (void*)(Phonon::EffectWidget*)xptr;
        default: return xptr;
      }
    case 16:   //Phonon::MediaController
      switch(to) {
        case 60: return (void*)(QObject*)(Phonon::MediaController*)xptr;
        case 16: return (void*)(Phonon::MediaController*)xptr;
        default: return xptr;
      }
    case 17:   //Phonon::MediaNode
      switch(to) {
        case 17: return (void*)(Phonon::MediaNode*)xptr;
        case 6: return (void*)(Phonon::AbstractVideoOutput*)(Phonon::MediaNode*)xptr;
        case 2: return (void*)(Phonon::AbstractAudioOutput*)(Phonon::MediaNode*)xptr;
        case 8: return (void*)(Phonon::AudioDataOutput*)(Phonon::MediaNode*)xptr;
        case 9: return (void*)(Phonon::AudioOutput*)(Phonon::MediaNode*)xptr;
        case 12: return (void*)(Phonon::Effect*)(Phonon::MediaNode*)xptr;
        case 32: return (void*)(Phonon::VolumeFaderEffect*)(Phonon::MediaNode*)xptr;
        case 19: return (void*)(Phonon::MediaObject*)(Phonon::MediaNode*)xptr;
        case 30: return (void*)(Phonon::VideoWidget*)(Phonon::MediaNode*)xptr;
        default: return xptr;
      }
    case 18:   //Phonon::MediaNodePrivate
      switch(to) {
        case 18: return (void*)(Phonon::MediaNodePrivate*)xptr;
        default: return xptr;
      }
    case 19:   //Phonon::MediaObject
      switch(to) {
        case 60: return (void*)(QObject*)(Phonon::MediaObject*)xptr;
        case 17: return (void*)(Phonon::MediaNode*)(Phonon::MediaObject*)xptr;
        case 19: return (void*)(Phonon::MediaObject*)xptr;
        default: return xptr;
      }
    case 20:   //Phonon::MediaSource
      switch(to) {
        case 20: return (void*)(Phonon::MediaSource*)xptr;
        default: return xptr;
      }
    case 21:   //Phonon::MediaSourcePrivate
      switch(to) {
        case 21: return (void*)(Phonon::MediaSourcePrivate*)xptr;
        default: return xptr;
      }
    case 22:   //Phonon::Mrl
      switch(to) {
        case 72: return (void*)(QUrl*)(Phonon::Mrl*)xptr;
        case 22: return (void*)(Phonon::Mrl*)xptr;
        default: return xptr;
      }
    case 23:   //Phonon::ObjectDescriptionData
      switch(to) {
        case 66: return (void*)(QSharedData*)(Phonon::ObjectDescriptionData*)xptr;
        case 23: return (void*)(Phonon::ObjectDescriptionData*)xptr;
        default: return xptr;
      }
    case 24:   //Phonon::ObjectDescriptionModelData
      switch(to) {
        case 24: return (void*)(Phonon::ObjectDescriptionModelData*)xptr;
        default: return xptr;
      }
    case 25:   //Phonon::ObjectDescriptionPrivate
      switch(to) {
        case 25: return (void*)(Phonon::ObjectDescriptionPrivate*)xptr;
        default: return xptr;
      }
    case 26:   //Phonon::Path
      switch(to) {
        case 26: return (void*)(Phonon::Path*)xptr;
        default: return xptr;
      }
    case 27:   //Phonon::SeekSlider
      switch(to) {
        case 75: return (void*)(QWidget*)(Phonon::SeekSlider*)xptr;
        case 60: return (void*)(QObject*)(Phonon::SeekSlider*)xptr;
        case 27: return (void*)(Phonon::SeekSlider*)xptr;
        default: return xptr;
      }
    case 28:   //Phonon::StreamInterface
      switch(to) {
        case 28: return (void*)(Phonon::StreamInterface*)xptr;
        default: return xptr;
      }
    case 29:   //Phonon::VideoPlayer
      switch(to) {
        case 75: return (void*)(QWidget*)(Phonon::VideoPlayer*)xptr;
        case 60: return (void*)(QObject*)(Phonon::VideoPlayer*)xptr;
        case 29: return (void*)(Phonon::VideoPlayer*)xptr;
        default: return xptr;
      }
    case 30:   //Phonon::VideoWidget
      switch(to) {
        case 75: return (void*)(QWidget*)(Phonon::VideoWidget*)xptr;
        case 60: return (void*)(QObject*)(Phonon::VideoWidget*)xptr;
        case 6: return (void*)(Phonon::AbstractVideoOutput*)(Phonon::VideoWidget*)xptr;
        case 17: return (void*)(Phonon::MediaNode*)(Phonon::VideoWidget*)xptr;
        case 30: return (void*)(Phonon::VideoWidget*)xptr;
        default: return xptr;
      }
    case 31:   //Phonon::VideoWidgetPrivate
      switch(to) {
        case 31: return (void*)(Phonon::VideoWidgetPrivate*)xptr;
        default: return xptr;
      }
    case 32:   //Phonon::VolumeFaderEffect
      switch(to) {
        case 12: return (void*)(Phonon::Effect*)(Phonon::VolumeFaderEffect*)xptr;
        case 60: return (void*)(QObject*)(Phonon::VolumeFaderEffect*)xptr;
        case 17: return (void*)(Phonon::MediaNode*)(Phonon::VolumeFaderEffect*)xptr;
        case 32: return (void*)(Phonon::VolumeFaderEffect*)xptr;
        default: return xptr;
      }
    case 33:   //Phonon::VolumeSlider
      switch(to) {
        case 75: return (void*)(QWidget*)(Phonon::VolumeSlider*)xptr;
        case 60: return (void*)(QObject*)(Phonon::VolumeSlider*)xptr;
        case 33: return (void*)(Phonon::VolumeSlider*)xptr;
        default: return xptr;
      }
    case 34:   //QAbstractListModel
      switch(to) {
        case 60: return (void*)(QObject*)(QAbstractListModel*)xptr;
        case 34: return (void*)(QAbstractListModel*)xptr;
        default: return xptr;
      }
    case 35:   //QActionEvent
      switch(to) {
        case 35: return (void*)(QActionEvent*)xptr;
        default: return xptr;
      }
    case 36:   //QBool
      switch(to) {
        case 36: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 37:   //QByteArray
      switch(to) {
        case 37: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 38:   //QChildEvent
      switch(to) {
        case 38: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 39:   //QCloseEvent
      switch(to) {
        case 39: return (void*)(QCloseEvent*)xptr;
        default: return xptr;
      }
    case 40:   //QContextMenuEvent
      switch(to) {
        case 40: return (void*)(QContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 41:   //QDebug
      switch(to) {
        case 41: return (void*)(QDebug*)xptr;
        default: return xptr;
      }
    case 42:   //QDragEnterEvent
      switch(to) {
        case 42: return (void*)(QDragEnterEvent*)xptr;
        default: return xptr;
      }
    case 43:   //QDragLeaveEvent
      switch(to) {
        case 43: return (void*)(QDragLeaveEvent*)xptr;
        default: return xptr;
      }
    case 44:   //QDragMoveEvent
      switch(to) {
        case 44: return (void*)(QDragMoveEvent*)xptr;
        default: return xptr;
      }
    case 45:   //QDropEvent
      switch(to) {
        case 45: return (void*)(QDropEvent*)xptr;
        default: return xptr;
      }
    case 46:   //QEvent
      switch(to) {
        case 46: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 47:   //QFocusEvent
      switch(to) {
        case 47: return (void*)(QFocusEvent*)xptr;
        default: return xptr;
      }
    case 48:   //QFont
      switch(to) {
        case 48: return (void*)(QFont*)xptr;
        default: return xptr;
      }
    case 50:   //QHideEvent
      switch(to) {
        case 50: return (void*)(QHideEvent*)xptr;
        default: return xptr;
      }
    case 51:   //QIODevice
      switch(to) {
        case 60: return (void*)(QObject*)(QIODevice*)xptr;
        case 51: return (void*)(QIODevice*)xptr;
        default: return xptr;
      }
    case 52:   //QImage
      switch(to) {
        case 52: return (void*)(QImage*)xptr;
        default: return xptr;
      }
    case 53:   //QInputMethodEvent
      switch(to) {
        case 53: return (void*)(QInputMethodEvent*)xptr;
        default: return xptr;
      }
    case 54:   //QKeyEvent
      switch(to) {
        case 54: return (void*)(QKeyEvent*)xptr;
        default: return xptr;
      }
    case 55:   //QMetaObject
      switch(to) {
        case 55: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 56:   //QMimeData
      switch(to) {
        case 56: return (void*)(QMimeData*)xptr;
        default: return xptr;
      }
    case 57:   //QModelIndex
      switch(to) {
        case 57: return (void*)(QModelIndex*)xptr;
        default: return xptr;
      }
    case 58:   //QMouseEvent
      switch(to) {
        case 58: return (void*)(QMouseEvent*)xptr;
        default: return xptr;
      }
    case 59:   //QMoveEvent
      switch(to) {
        case 59: return (void*)(QMoveEvent*)xptr;
        default: return xptr;
      }
    case 60:   //QObject
      switch(to) {
        case 60: return (void*)(QObject*)xptr;
        case 27: return (void*)(Phonon::SeekSlider*)(QObject*)xptr;
        case 29: return (void*)(Phonon::VideoPlayer*)(QObject*)xptr;
        case 2: return (void*)(Phonon::AbstractAudioOutput*)(QObject*)xptr;
        case 8: return (void*)(Phonon::AudioDataOutput*)(QObject*)xptr;
        case 9: return (void*)(Phonon::AudioOutput*)(QObject*)xptr;
        case 12: return (void*)(Phonon::Effect*)(QObject*)xptr;
        case 32: return (void*)(Phonon::VolumeFaderEffect*)(QObject*)xptr;
        case 33: return (void*)(Phonon::VolumeSlider*)(QObject*)xptr;
        case 15: return (void*)(Phonon::EffectWidget*)(QObject*)xptr;
        case 19: return (void*)(Phonon::MediaObject*)(QObject*)xptr;
        case 16: return (void*)(Phonon::MediaController*)(QObject*)xptr;
        case 30: return (void*)(Phonon::VideoWidget*)(QObject*)xptr;
        case 4: return (void*)(Phonon::AbstractMediaStream*)(QObject*)xptr;
        default: return xptr;
      }
    case 61:   //QPaintEngine
      switch(to) {
        case 61: return (void*)(QPaintEngine*)xptr;
        default: return xptr;
      }
    case 62:   //QPaintEvent
      switch(to) {
        case 62: return (void*)(QPaintEvent*)xptr;
        default: return xptr;
      }
    case 63:   //QPalette
      switch(to) {
        case 63: return (void*)(QPalette*)xptr;
        default: return xptr;
      }
    case 64:   //QRegExp
      switch(to) {
        case 64: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 65:   //QResizeEvent
      switch(to) {
        case 65: return (void*)(QResizeEvent*)xptr;
        default: return xptr;
      }
    case 66:   //QSharedData
      switch(to) {
        case 66: return (void*)(QSharedData*)xptr;
        case 23: return (void*)(Phonon::ObjectDescriptionData*)(QSharedData*)xptr;
        default: return xptr;
      }
    case 67:   //QShowEvent
      switch(to) {
        case 67: return (void*)(QShowEvent*)xptr;
        default: return xptr;
      }
    case 68:   //QSize
      switch(to) {
        case 68: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 69:   //QStyle
      switch(to) {
        case 69: return (void*)(QStyle*)xptr;
        default: return xptr;
      }
    case 70:   //QTabletEvent
      switch(to) {
        case 70: return (void*)(QTabletEvent*)xptr;
        default: return xptr;
      }
    case 71:   //QTimerEvent
      switch(to) {
        case 71: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 72:   //QUrl
      switch(to) {
        case 72: return (void*)(QUrl*)xptr;
        case 22: return (void*)(Phonon::Mrl*)(QUrl*)xptr;
        default: return xptr;
      }
    case 73:   //QVariant
      switch(to) {
        case 73: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 74:   //QWheelEvent
      switch(to) {
        case 74: return (void*)(QWheelEvent*)xptr;
        default: return xptr;
      }
    case 75:   //QWidget
      switch(to) {
        case 60: return (void*)(QObject*)(QWidget*)xptr;
        case 75: return (void*)(QWidget*)xptr;
        case 27: return (void*)(Phonon::SeekSlider*)(QWidget*)xptr;
        case 29: return (void*)(Phonon::VideoPlayer*)(QWidget*)xptr;
        case 33: return (void*)(Phonon::VolumeSlider*)(QWidget*)xptr;
        case 15: return (void*)(Phonon::EffectWidget*)(QWidget*)xptr;
        case 30: return (void*)(Phonon::VideoWidget*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    60, 17, 0,	// 1: QObject, Phonon::MediaNode
    60, 0,	// 4: QObject
    17, 0,	// 6: Phonon::MediaNode
    2, 0,	// 8: Phonon::AbstractAudioOutput
    75, 0,	// 10: QWidget
    72, 0,	// 12: QUrl
    66, 0,	// 14: QSharedData
    75, 6, 0,	// 16: QWidget, Phonon::AbstractVideoOutput
    12, 0,	// 19: Phonon::Effect
};

// These are the xenum functions for manipulating enum pointers
void xenum_Phonon(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Phonon__EffectParameter(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Phonon__VolumeFaderEffect(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Phonon__VideoWidget(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Phonon__Capture(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Phonon__MediaController(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Phonon__MediaSource(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Phonon__AudioDataOutput(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_Phonon(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__AbstractAudioOutput(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__AbstractMediaStream(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__AbstractVideoOutput(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__AudioDataOutput(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__AudioOutput(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__Capture(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__Effect(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__EffectParameter(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__EffectWidget(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__MediaController(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__MediaNode(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__MediaObject(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__MediaSource(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__Mrl(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__ObjectDescriptionData(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__ObjectDescriptionModelData(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__Path(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__SeekSlider(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__StreamInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__VideoPlayer(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__VideoWidget(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__VolumeFaderEffect(Smoke::Index, void*, Smoke::Stack);
void xcall_Phonon__VolumeSlider(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "Phonon", false, 0, xcall_Phonon, xenum_Phonon, Smoke::cf_namespace, 0 },	//1
    { "Phonon::AbstractAudioOutput", false, 1, xcall_Phonon__AbstractAudioOutput, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::AbstractAudioOutput) },	//2
    { "Phonon::AbstractAudioOutputPrivate", true, 0, 0, 0, 0, 0 },	//3
    { "Phonon::AbstractMediaStream", false, 4, xcall_Phonon__AbstractMediaStream, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::AbstractMediaStream) },	//4
    { "Phonon::AbstractMediaStreamPrivate", true, 0, 0, 0, 0, 0 },	//5
    { "Phonon::AbstractVideoOutput", false, 6, xcall_Phonon__AbstractVideoOutput, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(Phonon::AbstractVideoOutput) },	//6
    { "Phonon::AbstractVideoOutputPrivate", true, 0, 0, 0, 0, 0 },	//7
    { "Phonon::AudioDataOutput", false, 8, xcall_Phonon__AudioDataOutput, xenum_Phonon__AudioDataOutput, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::AudioDataOutput) },	//8
    { "Phonon::AudioOutput", false, 8, xcall_Phonon__AudioOutput, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::AudioOutput) },	//9
    { "Phonon::BackendCapabilities::Notifier", true, 0, 0, 0, 0, 0 },	//10
    { "Phonon::Capture", false, 0, xcall_Phonon__Capture, xenum_Phonon__Capture, Smoke::cf_namespace, 0 },	//11
    { "Phonon::Effect", false, 1, xcall_Phonon__Effect, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::Effect) },	//12
    { "Phonon::EffectParameter", false, 0, xcall_Phonon__EffectParameter, xenum_Phonon__EffectParameter, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Phonon::EffectParameter) },	//13
    { "Phonon::EffectPrivate", true, 0, 0, 0, 0, 0 },	//14
    { "Phonon::EffectWidget", false, 10, xcall_Phonon__EffectWidget, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::EffectWidget) },	//15
    { "Phonon::MediaController", false, 4, xcall_Phonon__MediaController, xenum_Phonon__MediaController, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::MediaController) },	//16
    { "Phonon::MediaNode", false, 0, xcall_Phonon__MediaNode, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(Phonon::MediaNode) },	//17
    { "Phonon::MediaNodePrivate", true, 0, 0, 0, 0, 0 },	//18
    { "Phonon::MediaObject", false, 1, xcall_Phonon__MediaObject, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::MediaObject) },	//19
    { "Phonon::MediaSource", false, 0, xcall_Phonon__MediaSource, xenum_Phonon__MediaSource, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Phonon::MediaSource) },	//20
    { "Phonon::MediaSourcePrivate", true, 0, 0, 0, 0, 0 },	//21
    { "Phonon::Mrl", false, 12, xcall_Phonon__Mrl, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Phonon::Mrl) },	//22
    { "Phonon::ObjectDescriptionData", false, 14, xcall_Phonon__ObjectDescriptionData, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Phonon::ObjectDescriptionData) },	//23
    { "Phonon::ObjectDescriptionModelData", false, 0, xcall_Phonon__ObjectDescriptionModelData, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Phonon::ObjectDescriptionModelData) },	//24
    { "Phonon::ObjectDescriptionPrivate", true, 0, 0, 0, 0, 0 },	//25
    { "Phonon::Path", false, 0, xcall_Phonon__Path, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Phonon::Path) },	//26
    { "Phonon::SeekSlider", false, 10, xcall_Phonon__SeekSlider, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::SeekSlider) },	//27
    { "Phonon::StreamInterface", false, 0, xcall_Phonon__StreamInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(Phonon::StreamInterface) },	//28
    { "Phonon::VideoPlayer", false, 10, xcall_Phonon__VideoPlayer, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::VideoPlayer) },	//29
    { "Phonon::VideoWidget", false, 16, xcall_Phonon__VideoWidget, xenum_Phonon__VideoWidget, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::VideoWidget) },	//30
    { "Phonon::VideoWidgetPrivate", true, 0, 0, 0, 0, 0 },	//31
    { "Phonon::VolumeFaderEffect", false, 19, xcall_Phonon__VolumeFaderEffect, xenum_Phonon__VolumeFaderEffect, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::VolumeFaderEffect) },	//32
    { "Phonon::VolumeSlider", false, 10, xcall_Phonon__VolumeSlider, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Phonon::VolumeSlider) },	//33
    { "QAbstractListModel", true, 0, 0, 0, 0, 0 },	//34
    { "QActionEvent", true, 0, 0, 0, 0, 0 },	//35
    { "QBool", true, 0, 0, 0, 0, 0 },	//36
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//37
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//38
    { "QCloseEvent", true, 0, 0, 0, 0, 0 },	//39
    { "QContextMenuEvent", true, 0, 0, 0, 0, 0 },	//40
    { "QDebug", true, 0, 0, 0, 0, 0 },	//41
    { "QDragEnterEvent", true, 0, 0, 0, 0, 0 },	//42
    { "QDragLeaveEvent", true, 0, 0, 0, 0, 0 },	//43
    { "QDragMoveEvent", true, 0, 0, 0, 0, 0 },	//44
    { "QDropEvent", true, 0, 0, 0, 0, 0 },	//45
    { "QEvent", true, 0, 0, 0, 0, 0 },	//46
    { "QFocusEvent", true, 0, 0, 0, 0, 0 },	//47
    { "QFont", true, 0, 0, 0, 0, 0 },	//48
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//49
    { "QHideEvent", true, 0, 0, 0, 0, 0 },	//50
    { "QIODevice", true, 0, 0, 0, 0, 0 },	//51
    { "QImage", true, 0, 0, 0, 0, 0 },	//52
    { "QInputMethodEvent", true, 0, 0, 0, 0, 0 },	//53
    { "QKeyEvent", true, 0, 0, 0, 0, 0 },	//54
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//55
    { "QMimeData", true, 0, 0, 0, 0, 0 },	//56
    { "QModelIndex", true, 0, 0, 0, 0, 0 },	//57
    { "QMouseEvent", true, 0, 0, 0, 0, 0 },	//58
    { "QMoveEvent", true, 0, 0, 0, 0, 0 },	//59
    { "QObject", true, 0, 0, 0, 0, 0 },	//60
    { "QPaintEngine", true, 0, 0, 0, 0, 0 },	//61
    { "QPaintEvent", true, 0, 0, 0, 0, 0 },	//62
    { "QPalette", true, 0, 0, 0, 0, 0 },	//63
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//64
    { "QResizeEvent", true, 0, 0, 0, 0, 0 },	//65
    { "QSharedData", true, 0, 0, 0, 0, 0 },	//66
    { "QShowEvent", true, 0, 0, 0, 0, 0 },	//67
    { "QSize", true, 0, 0, 0, 0, 0 },	//68
    { "QStyle", true, 0, 0, 0, 0, 0 },	//69
    { "QTabletEvent", true, 0, 0, 0, 0, 0 },	//70
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//71
    { "QUrl", true, 0, 0, 0, 0, 0 },	//72
    { "QVariant", true, 0, 0, 0, 0, 0 },	//73
    { "QWheelEvent", true, 0, 0, 0, 0, 0 },	//74
    { "QWidget", true, 0, 0, 0, 0, 0 },	//75
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "Phonon::AbstractAudioOutput*", 2, Smoke::t_class|Smoke::tf_ptr },	//1
    { "Phonon::AbstractAudioOutputPrivate&", 3, Smoke::t_class|Smoke::tf_ref },	//2
    { "Phonon::AbstractMediaStream*", 4, Smoke::t_class|Smoke::tf_ptr },	//3
    { "Phonon::AbstractMediaStreamPrivate&", 5, Smoke::t_class|Smoke::tf_ref },	//4
    { "Phonon::AbstractVideoOutput*", 6, Smoke::t_class|Smoke::tf_ptr },	//5
    { "Phonon::AbstractVideoOutputPrivate&", 7, Smoke::t_class|Smoke::tf_ref },	//6
    { "Phonon::AudioCaptureDevice", 0, Smoke::t_voidp|Smoke::tf_stack },	//7
    { "Phonon::AudioCaptureDeviceType", 0, Smoke::t_voidp|Smoke::tf_stack },	//8
    { "Phonon::AudioChannelType", 0, Smoke::t_voidp|Smoke::tf_stack },	//9
    { "Phonon::AudioDataOutput*", 8, Smoke::t_class|Smoke::tf_ptr },	//10
    { "Phonon::AudioDataOutput::Channel", 8, Smoke::t_enum|Smoke::tf_stack },	//11
    { "Phonon::AudioOutput*", 9, Smoke::t_class|Smoke::tf_ptr },	//12
    { "Phonon::AudioOutputDevice", 0, Smoke::t_voidp|Smoke::tf_stack },	//13
    { "Phonon::AudioOutputDeviceType", 0, Smoke::t_voidp|Smoke::tf_stack },	//14
    { "Phonon::BackendCapabilities::Notifier*", 10, Smoke::t_class|Smoke::tf_ptr },	//15
    { "Phonon::Capture::DeviceType", 11, Smoke::t_enum|Smoke::tf_stack },	//16
    { "Phonon::CaptureCategory", 1, Smoke::t_enum|Smoke::tf_stack },	//17
    { "Phonon::Category", 1, Smoke::t_enum|Smoke::tf_stack },	//18
    { "Phonon::DiscType", 1, Smoke::t_enum|Smoke::tf_stack },	//19
    { "Phonon::Effect*", 12, Smoke::t_class|Smoke::tf_ptr },	//20
    { "Phonon::EffectDescription", 0, Smoke::t_voidp|Smoke::tf_stack },	//21
    { "Phonon::EffectParameter", 13, Smoke::t_class|Smoke::tf_stack },	//22
    { "Phonon::EffectParameter&", 13, Smoke::t_class|Smoke::tf_ref },	//23
    { "Phonon::EffectParameter*", 13, Smoke::t_class|Smoke::tf_ptr },	//24
    { "Phonon::EffectParameter::Hint", 13, Smoke::t_enum|Smoke::tf_stack },	//25
    { "Phonon::EffectPrivate&", 14, Smoke::t_class|Smoke::tf_ref },	//26
    { "Phonon::EffectType", 0, Smoke::t_voidp|Smoke::tf_stack },	//27
    { "Phonon::EffectWidget*", 15, Smoke::t_class|Smoke::tf_ptr },	//28
    { "Phonon::ErrorType", 1, Smoke::t_enum|Smoke::tf_stack },	//29
    { "Phonon::MediaController*", 16, Smoke::t_class|Smoke::tf_ptr },	//30
    { "Phonon::MediaController::Feature", 16, Smoke::t_enum|Smoke::tf_stack },	//31
    { "Phonon::MediaController::NavigationMenu", 16, Smoke::t_enum|Smoke::tf_stack },	//32
    { "Phonon::MediaNode*", 17, Smoke::t_class|Smoke::tf_ptr },	//33
    { "Phonon::MediaNodePrivate&", 18, Smoke::t_class|Smoke::tf_ref },	//34
    { "Phonon::MediaObject*", 19, Smoke::t_class|Smoke::tf_ptr },	//35
    { "Phonon::MediaSource", 20, Smoke::t_class|Smoke::tf_stack },	//36
    { "Phonon::MediaSource&", 20, Smoke::t_class|Smoke::tf_ref },	//37
    { "Phonon::MediaSource*", 20, Smoke::t_class|Smoke::tf_ptr },	//38
    { "Phonon::MediaSource::Type", 20, Smoke::t_enum|Smoke::tf_stack },	//39
    { "Phonon::MediaSourcePrivate&", 21, Smoke::t_class|Smoke::tf_ref },	//40
    { "Phonon::MetaData", 1, Smoke::t_enum|Smoke::tf_stack },	//41
    { "Phonon::Mrl", 22, Smoke::t_class|Smoke::tf_stack },	//42
    { "Phonon::Mrl&", 22, Smoke::t_class|Smoke::tf_ref },	//43
    { "Phonon::Mrl*", 22, Smoke::t_class|Smoke::tf_ptr },	//44
    { "Phonon::ObjectDescription<Phonon::AudioCaptureDeviceType>", 0, Smoke::t_voidp|Smoke::tf_stack },	//45
    { "Phonon::ObjectDescription<Phonon::AudioChannelType>", 0, Smoke::t_voidp|Smoke::tf_stack },	//46
    { "Phonon::ObjectDescription<Phonon::AudioOutputDeviceType>", 0, Smoke::t_voidp|Smoke::tf_stack },	//47
    { "Phonon::ObjectDescription<Phonon::EffectType>", 0, Smoke::t_voidp|Smoke::tf_stack },	//48
    { "Phonon::ObjectDescription<Phonon::SubtitleType>", 0, Smoke::t_voidp|Smoke::tf_stack },	//49
    { "Phonon::ObjectDescription<Phonon::VideoCaptureDeviceType>", 0, Smoke::t_voidp|Smoke::tf_stack },	//50
    { "Phonon::ObjectDescriptionData", 23, Smoke::t_class|Smoke::tf_stack },	//51
    { "Phonon::ObjectDescriptionData*", 23, Smoke::t_class|Smoke::tf_ptr },	//52
    { "Phonon::ObjectDescriptionModelData*", 24, Smoke::t_class|Smoke::tf_ptr },	//53
    { "Phonon::ObjectDescriptionPrivate*", 25, Smoke::t_class|Smoke::tf_ptr },	//54
    { "Phonon::ObjectDescriptionType", 1, Smoke::t_enum|Smoke::tf_stack },	//55
    { "Phonon::Path", 26, Smoke::t_class|Smoke::tf_stack },	//56
    { "Phonon::Path&", 26, Smoke::t_class|Smoke::tf_ref },	//57
    { "Phonon::Path*", 26, Smoke::t_class|Smoke::tf_ptr },	//58
    { "Phonon::SeekSlider*", 27, Smoke::t_class|Smoke::tf_ptr },	//59
    { "Phonon::State", 1, Smoke::t_enum|Smoke::tf_stack },	//60
    { "Phonon::StreamInterface*", 28, Smoke::t_class|Smoke::tf_ptr },	//61
    { "Phonon::SubtitleType", 0, Smoke::t_voidp|Smoke::tf_stack },	//62
    { "Phonon::VideoCaptureDevice", 0, Smoke::t_voidp|Smoke::tf_stack },	//63
    { "Phonon::VideoCaptureDeviceType", 0, Smoke::t_voidp|Smoke::tf_stack },	//64
    { "Phonon::VideoPlayer*", 29, Smoke::t_class|Smoke::tf_ptr },	//65
    { "Phonon::VideoWidget*", 30, Smoke::t_class|Smoke::tf_ptr },	//66
    { "Phonon::VideoWidget::AspectRatio", 30, Smoke::t_enum|Smoke::tf_stack },	//67
    { "Phonon::VideoWidget::ScaleMode", 30, Smoke::t_enum|Smoke::tf_stack },	//68
    { "Phonon::VideoWidgetPrivate&", 31, Smoke::t_class|Smoke::tf_ref },	//69
    { "Phonon::VolumeFaderEffect*", 32, Smoke::t_class|Smoke::tf_ptr },	//70
    { "Phonon::VolumeFaderEffect::FadeCurve", 32, Smoke::t_enum|Smoke::tf_stack },	//71
    { "Phonon::VolumeSlider*", 33, Smoke::t_class|Smoke::tf_ptr },	//72
    { "QAbstractListModel*", 34, Smoke::t_class|Smoke::tf_ptr },	//73
    { "QActionEvent*", 35, Smoke::t_class|Smoke::tf_ptr },	//74
    { "QBool", 36, Smoke::t_class|Smoke::tf_stack },	//75
    { "QByteArray", 37, Smoke::t_class|Smoke::tf_stack },	//76
    { "QChildEvent*", 38, Smoke::t_class|Smoke::tf_ptr },	//77
    { "QCloseEvent*", 39, Smoke::t_class|Smoke::tf_ptr },	//78
    { "QContextMenuEvent*", 40, Smoke::t_class|Smoke::tf_ptr },	//79
    { "QDebug", 41, Smoke::t_class|Smoke::tf_stack },	//80
    { "QDragEnterEvent*", 42, Smoke::t_class|Smoke::tf_ptr },	//81
    { "QDragLeaveEvent*", 43, Smoke::t_class|Smoke::tf_ptr },	//82
    { "QDragMoveEvent*", 44, Smoke::t_class|Smoke::tf_ptr },	//83
    { "QDropEvent*", 45, Smoke::t_class|Smoke::tf_ptr },	//84
    { "QEvent*", 46, Smoke::t_class|Smoke::tf_ptr },	//85
    { "QExplicitlySharedDataPointer<Phonon::ObjectDescriptionData>", 0, Smoke::t_voidp|Smoke::tf_stack },	//86
    { "QFlags<Phonon::EffectParameter::Hint>", 0, Smoke::t_uint|Smoke::tf_stack },	//87
    { "QFlags<Phonon::MediaController::Feature>", 0, Smoke::t_uint|Smoke::tf_stack },	//88
    { "QFlags<QUrl::FormattingOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//89
    { "QFlags<Qt::DropAction>", 0, Smoke::t_uint|Smoke::tf_stack },	//90
    { "QFlags<Qt::ItemFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//91
    { "QFocusEvent*", 47, Smoke::t_class|Smoke::tf_ptr },	//92
    { "QFont", 48, Smoke::t_class|Smoke::tf_stack },	//93
    { "QHideEvent*", 50, Smoke::t_class|Smoke::tf_ptr },	//94
    { "QIODevice*", 51, Smoke::t_class|Smoke::tf_ptr },	//95
    { "QImage", 52, Smoke::t_class|Smoke::tf_stack },	//96
    { "QInputMethodEvent*", 53, Smoke::t_class|Smoke::tf_ptr },	//97
    { "QKeyEvent*", 54, Smoke::t_class|Smoke::tf_ptr },	//98
    { "QList<Phonon::AudioCaptureDevice>", 0, Smoke::t_voidp|Smoke::tf_stack },	//99
    { "QList<Phonon::AudioOutputDevice>", 0, Smoke::t_voidp|Smoke::tf_stack },	//100
    { "QList<Phonon::Effect*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//101
    { "QList<Phonon::EffectDescription>", 0, Smoke::t_voidp|Smoke::tf_stack },	//102
    { "QList<Phonon::EffectParameter>", 0, Smoke::t_voidp|Smoke::tf_stack },	//103
    { "QList<Phonon::MediaController::NavigationMenu>", 0, Smoke::t_voidp|Smoke::tf_stack },	//104
    { "QList<Phonon::MediaSource>", 0, Smoke::t_voidp|Smoke::tf_stack },	//105
    { "QList<Phonon::ObjectDescription<Phonon::AudioChannelType> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//106
    { "QList<Phonon::ObjectDescription<Phonon::SubtitleType> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//107
    { "QList<Phonon::Path>", 0, Smoke::t_voidp|Smoke::tf_stack },	//108
    { "QList<Phonon::VideoCaptureDevice>", 0, Smoke::t_voidp|Smoke::tf_stack },	//109
    { "QList<QByteArray>", 0, Smoke::t_voidp|Smoke::tf_stack },	//110
    { "QList<QExplicitlySharedDataPointer<Phonon::ObjectDescriptionData> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//111
    { "QList<QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack },	//112
    { "QList<int>", 0, Smoke::t_voidp|Smoke::tf_stack },	//113
    { "QMap<Phonon::AudioDataOutput::Channel,QVector<qint16> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//114
    { "QMetaObject::Call", 55, Smoke::t_enum|Smoke::tf_stack },	//115
    { "QMimeData*", 56, Smoke::t_class|Smoke::tf_ptr },	//116
    { "QModelIndex", 57, Smoke::t_class|Smoke::tf_stack },	//117
    { "QMouseEvent*", 58, Smoke::t_class|Smoke::tf_ptr },	//118
    { "QMoveEvent*", 59, Smoke::t_class|Smoke::tf_ptr },	//119
    { "QMultiMap<QString,QString>", 0, Smoke::t_voidp|Smoke::tf_stack },	//120
    { "QObject*", 60, Smoke::t_class|Smoke::tf_ptr },	//121
    { "QPaintDevice::PaintDeviceMetric", 0, Smoke::t_enum|Smoke::tf_stack },	//122
    { "QPaintEngine*", 61, Smoke::t_class|Smoke::tf_ptr },	//123
    { "QPaintEvent*", 62, Smoke::t_class|Smoke::tf_ptr },	//124
    { "QPair<QByteArray,QString>", 0, Smoke::t_voidp|Smoke::tf_stack },	//125
    { "QRegExp&", 64, Smoke::t_class|Smoke::tf_ref },	//126
    { "QResizeEvent*", 65, Smoke::t_class|Smoke::tf_ptr },	//127
    { "QShowEvent*", 67, Smoke::t_class|Smoke::tf_ptr },	//128
    { "QSize", 68, Smoke::t_class|Smoke::tf_stack },	//129
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//130
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//131
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//132
    { "QStyle&", 69, Smoke::t_class|Smoke::tf_ref },	//133
    { "QTabletEvent*", 70, Smoke::t_class|Smoke::tf_ptr },	//134
    { "QTimerEvent*", 71, Smoke::t_class|Smoke::tf_ptr },	//135
    { "QUrl", 72, Smoke::t_class|Smoke::tf_stack },	//136
    { "QUrl::FormattingOption", 72, Smoke::t_enum|Smoke::tf_stack },	//137
    { "QVariant", 73, Smoke::t_class|Smoke::tf_stack },	//138
    { "QVariant::Type", 73, Smoke::t_enum|Smoke::tf_stack },	//139
    { "QVector<qint16>", 0, Smoke::t_voidp|Smoke::tf_stack },	//140
    { "QWheelEvent*", 74, Smoke::t_class|Smoke::tf_ptr },	//141
    { "QWidget*", 75, Smoke::t_class|Smoke::tf_ptr },	//142
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//143
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//144
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//145
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//146
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//147
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//148
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//149
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//150
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//151
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//152
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//153
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//154
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//155
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//156
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//157
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//158
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//159
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//160
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//161
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//162
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//163
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//164
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//165
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//166
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//167
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//168
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//169
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//170
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//171
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//172
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//173
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//174
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//175
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//176
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//177
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//178
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//179
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//180
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//181
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//182
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//183
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//184
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//185
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//186
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//187
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//188
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//189
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//190
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//191
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//192
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//193
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//194
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//195
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//196
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//197
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//198
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//199
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//200
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//201
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//202
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//203
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//204
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//205
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//206
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//207
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//208
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//209
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//210
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//211
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//212
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//213
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//214
    { "_XEvent*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//215
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//216
    { "const Phonon::AbstractVideoOutput&", 6, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//217
    { "const Phonon::AudioOutputDevice&", 0, Smoke::t_voidp|Smoke::tf_stack },	//218
    { "const Phonon::Capture::DeviceType&", 11, Smoke::t_enum|Smoke::tf_ref|Smoke::tf_const },	//219
    { "const Phonon::CaptureCategory&", 1, Smoke::t_enum|Smoke::tf_ref|Smoke::tf_const },	//220
    { "const Phonon::Category&", 1, Smoke::t_enum|Smoke::tf_ref|Smoke::tf_const },	//221
    { "const Phonon::DiscType&", 1, Smoke::t_enum|Smoke::tf_ref|Smoke::tf_const },	//222
    { "const Phonon::EffectParameter&", 13, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//223
    { "const Phonon::ErrorType&", 1, Smoke::t_enum|Smoke::tf_ref|Smoke::tf_const },	//224
    { "const Phonon::MediaNode&", 17, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//225
    { "const Phonon::MediaSource&", 20, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//226
    { "const Phonon::MetaData&", 1, Smoke::t_enum|Smoke::tf_ref|Smoke::tf_const },	//227
    { "const Phonon::Mrl&", 22, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//228
    { "const Phonon::ObjectDescription<Phonon::AudioCaptureDeviceType>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//229
    { "const Phonon::ObjectDescription<Phonon::AudioChannelType>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//230
    { "const Phonon::ObjectDescription<Phonon::EffectType>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//231
    { "const Phonon::ObjectDescription<Phonon::SubtitleType>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//232
    { "const Phonon::ObjectDescription<Phonon::VideoCaptureDeviceType>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//233
    { "const Phonon::ObjectDescriptionData&", 23, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//234
    { "const Phonon::ObjectDescriptionModelData&", 24, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//235
    { "const Phonon::Path&", 26, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//236
    { "const Phonon::State&", 1, Smoke::t_enum|Smoke::tf_ref|Smoke::tf_const },	//237
    { "const Phonon::StreamInterface&", 28, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//238
    { "const QByteArray&", 37, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//239
    { "const QFont&", 48, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//240
    { "const QHash<QByteArray,QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//241
    { "const QList<Phonon::MediaSource>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//242
    { "const QList<QExplicitlySharedDataPointer<Phonon::ObjectDescriptionData> >&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//243
    { "const QList<QModelIndex>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//244
    { "const QList<QPair<QByteArray,QString> >&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//245
    { "const QList<QUrl>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//246
    { "const QList<QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//247
    { "const QMap<Phonon::AudioDataOutput::Channel,QVector<qint16> >&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//248
    { "const QMetaObject&", 55, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//249
    { "const QMetaObject*", 55, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//250
    { "const QMimeData*", 56, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//251
    { "const QModelIndex&", 57, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//252
    { "const QPair<QByteArray,QString>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//253
    { "const QPalette&", 63, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//254
    { "const QRegExp&", 64, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//255
    { "const QSize&", 68, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//256
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//257
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//258
    { "const QUrl&", 72, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//259
    { "const QVariant&", 73, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//260
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//261
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//262
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//263
    { "float", 0, Smoke::t_float|Smoke::tf_stack },	//264
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//265
    { "long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//266
    { "qint16", 0, Smoke::t_short|Smoke::tf_stack },	//267
    { "qint32", 0, Smoke::t_int|Smoke::tf_stack },	//268
    { "qint64", 0, Smoke::t_voidp|Smoke::tf_stack },	//269
    { "qreal", 0, Smoke::t_double|Smoke::tf_stack },	//270
    { "unsigned int", 0, Smoke::t_uint|Smoke::tf_stack },	//271
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//272
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//273
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//274
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    80, 226, 0,	//1  QDebug, const Phonon::MediaSource&
    18, 0,	//4  Phonon::Category
    80, 224, 0,	//6  QDebug, const Phonon::ErrorType&
    223, 0,	//9  const Phonon::EffectParameter&
    17, 0,	//11  Phonon::CaptureCategory
    80, 219, 0,	//13  QDebug, const Phonon::Capture::DeviceType&
    80, 221, 0,	//16  QDebug, const Phonon::Category&
    33, 33, 0,	//19  Phonon::MediaNode*, Phonon::MediaNode*
    18, 226, 0,	//22  Phonon::Category, const Phonon::MediaSource&
    80, 227, 0,	//25  QDebug, const Phonon::MetaData&
    80, 220, 0,	//28  QDebug, const Phonon::CaptureCategory&
    80, 237, 0,	//31  QDebug, const Phonon::State&
    80, 222, 0,	//34  QDebug, const Phonon::DiscType&
    261, 0,	//37  const char*
    261, 261, 0,	//39  const char*, const char*
    261, 261, 265, 0,	//42  const char*, const char*, int
    115, 265, 273, 0,	//46  QMetaObject::Call, int, void**
    2, 121, 0,	//50  Phonon::AbstractAudioOutputPrivate&, QObject*
    121, 0,	//53  QObject*
    266, 0,	//55  long long
    216, 0,	//57  bool
    239, 0,	//59  const QByteArray&
    29, 257, 0,	//61  Phonon::ErrorType, const QString&
    4, 121, 0,	//64  Phonon::AbstractMediaStreamPrivate&, QObject*
    6, 0,	//67  Phonon::AbstractVideoOutputPrivate&
    217, 0,	//69  const Phonon::AbstractVideoOutput&
    265, 0,	//71  int
    248, 0,	//73  const QMap<Phonon::AudioDataOutput::Channel,QVector<qint16> >&
    18, 121, 0,	//75  Phonon::Category, QObject*
    257, 0,	//78  const QString&
    270, 0,	//80  qreal
    218, 0,	//82  const Phonon::AudioOutputDevice&
    231, 121, 0,	//84  const Phonon::ObjectDescription<Phonon::EffectType>&, QObject*
    223, 260, 0,	//87  const Phonon::EffectParameter&, const QVariant&
    26, 121, 0,	//90  Phonon::EffectPrivate&, QObject*
    231, 0,	//93  const Phonon::ObjectDescription<Phonon::EffectType>&
    265, 257, 87, 260, 260, 260, 247, 257, 0,	//95  int, const QString&, QFlags<Phonon::EffectParameter::Hint>, const QVariant&, const QVariant&, const QVariant&, const QList<QVariant>&, const QString&
    265, 257, 87, 260, 0,	//104  int, const QString&, QFlags<Phonon::EffectParameter::Hint>, const QVariant&
    265, 257, 87, 260, 260, 0,	//109  int, const QString&, QFlags<Phonon::EffectParameter::Hint>, const QVariant&, const QVariant&
    265, 257, 87, 260, 260, 260, 0,	//115  int, const QString&, QFlags<Phonon::EffectParameter::Hint>, const QVariant&, const QVariant&, const QVariant&
    265, 257, 87, 260, 260, 260, 247, 0,	//122  int, const QString&, QFlags<Phonon::EffectParameter::Hint>, const QVariant&, const QVariant&, const QVariant&, const QList<QVariant>&
    20, 142, 0,	//130  Phonon::Effect*, QWidget*
    20, 0,	//133  Phonon::Effect*
    35, 0,	//135  Phonon::MediaObject*
    32, 0,	//137  Phonon::MediaController::NavigationMenu
    230, 0,	//139  const Phonon::ObjectDescription<Phonon::AudioChannelType>&
    232, 0,	//141  const Phonon::ObjectDescription<Phonon::SubtitleType>&
    259, 0,	//143  const QUrl&
    240, 0,	//145  const QFont&
    104, 0,	//147  QList<Phonon::MediaController::NavigationMenu>
    34, 0,	//149  Phonon::MediaNodePrivate&
    225, 0,	//151  const Phonon::MediaNode&
    41, 0,	//153  Phonon::MetaData
    226, 0,	//155  const Phonon::MediaSource&
    242, 0,	//157  const QList<Phonon::MediaSource>&
    246, 0,	//159  const QList<QUrl>&
    268, 0,	//161  qint32
    269, 0,	//163  qint64
    60, 60, 0,	//165  Phonon::State, Phonon::State
    19, 257, 0,	//168  Phonon::DiscType, const QString&
    229, 0,	//171  const Phonon::ObjectDescription<Phonon::AudioCaptureDeviceType>&
    233, 0,	//173  const Phonon::ObjectDescription<Phonon::VideoCaptureDeviceType>&
    16, 17, 0,	//175  Phonon::Capture::DeviceType, Phonon::CaptureCategory
    3, 0,	//178  Phonon::AbstractMediaStream*
    95, 0,	//180  QIODevice*
    40, 0,	//182  Phonon::MediaSourcePrivate&
    253, 0,	//184  const QPair<QByteArray,QString>&
    19, 0,	//186  Phonon::DiscType
    16, 0,	//188  Phonon::Capture::DeviceType
    228, 0,	//190  const Phonon::Mrl&
    89, 0,	//192  QFlags<QUrl::FormattingOption>
    234, 0,	//194  const Phonon::ObjectDescriptionData&
    55, 265, 0,	//196  Phonon::ObjectDescriptionType, int
    54, 0,	//199  Phonon::ObjectDescriptionPrivate*
    265, 241, 0,	//201  int, const QHash<QByteArray,QVariant>&
    252, 0,	//204  const QModelIndex&
    252, 265, 0,	//206  const QModelIndex&, int
    55, 244, 0,	//209  Phonon::ObjectDescriptionType, const QList<QModelIndex>&
    243, 0,	//212  const QList<QExplicitlySharedDataPointer<Phonon::ObjectDescriptionData> >&
    55, 251, 165, 265, 265, 252, 0,	//214  Phonon::ObjectDescriptionType, const QMimeData*, Qt::DropAction, int, int, const QModelIndex&
    265, 265, 252, 0,	//221  int, int, const QModelIndex&
    55, 0,	//225  Phonon::ObjectDescriptionType
    73, 0,	//227  QAbstractListModel*
    235, 0,	//229  const Phonon::ObjectDescriptionModelData&
    265, 265, 0,	//231  int, int
    236, 0,	//234  const Phonon::Path&
    231, 20, 0,	//236  const Phonon::ObjectDescription<Phonon::EffectType>&, Phonon::Effect*
    20, 20, 0,	//239  Phonon::Effect*, Phonon::Effect*
    142, 0,	//242  QWidget*
    35, 142, 0,	//244  Phonon::MediaObject*, QWidget*
    189, 0,	//247  Qt::Orientation
    256, 0,	//249  const QSize&
    238, 0,	//251  const Phonon::StreamInterface&
    18, 142, 0,	//253  Phonon::Category, QWidget*
    264, 0,	//256  float
    85, 0,	//258  QEvent*
    67, 0,	//260  Phonon::VideoWidget::AspectRatio
    68, 0,	//262  Phonon::VideoWidget::ScaleMode
    69, 142, 0,	//264  Phonon::VideoWidgetPrivate&, QWidget*
    118, 0,	//267  QMouseEvent*
    263, 0,	//269  double
    71, 0,	//271  Phonon::VolumeFaderEffect::FadeCurve
    264, 265, 0,	//273  float, int
    12, 142, 0,	//276  Phonon::AudioOutput*, QWidget*
    12, 0,	//279  Phonon::AudioOutput*
    121, 85, 0,	//281  QObject*, QEvent*
    135, 0,	//284  QTimerEvent*
    77, 0,	//286  QChildEvent*
    141, 0,	//288  QWheelEvent*
    98, 0,	//290  QKeyEvent*
    92, 0,	//292  QFocusEvent*
    124, 0,	//294  QPaintEvent*
    119, 0,	//296  QMoveEvent*
    127, 0,	//298  QResizeEvent*
    78, 0,	//300  QCloseEvent*
    79, 0,	//302  QContextMenuEvent*
    134, 0,	//304  QTabletEvent*
    74, 0,	//306  QActionEvent*
    81, 0,	//308  QDragEnterEvent*
    83, 0,	//310  QDragMoveEvent*
    82, 0,	//312  QDragLeaveEvent*
    84, 0,	//314  QDropEvent*
    128, 0,	//316  QShowEvent*
    94, 0,	//318  QHideEvent*
    215, 0,	//320  _XEvent*
    122, 0,	//322  QPaintDevice::PaintDeviceMetric
    97, 0,	//324  QInputMethodEvent*
    177, 0,	//326  Qt::InputMethodQuery
    133, 0,	//328  QStyle&
    254, 0,	//330  const QPalette&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "AbstractAudioOutput",	//1
    "AbstractAudioOutput##",	//2
    "AbstractMediaStream",	//3
    "AbstractMediaStream#",	//4
    "AbstractMediaStream##",	//5
    "AbstractVideoOutput",	//6
    "AbstractVideoOutput#",	//7
    "AccessibilityCategory",	//8
    "AlbumMetaData",	//9
    "AngleMenu",	//10
    "Angles",	//11
    "ArtistMetaData",	//12
    "AspectRatio16_9",	//13
    "AspectRatio4_3",	//14
    "AspectRatioAuto",	//15
    "AspectRatioWidget",	//16
    "AudioCaptureDeviceType",	//17
    "AudioChannelType",	//18
    "AudioChannels",	//19
    "AudioDataOutput",	//20
    "AudioDataOutput#",	//21
    "AudioMenu",	//22
    "AudioOutput",	//23
    "AudioOutput#",	//24
    "AudioOutput$",	//25
    "AudioOutput$#",	//26
    "AudioOutputDeviceType",	//27
    "AudioType",	//28
    "AudioVideoCapture",	//29
    "BluRay",	//30
    "BufferingState",	//31
    "CaptureDevice",	//32
    "Cd",	//33
    "CenterChannel",	//34
    "ChapterMenu",	//35
    "Chapters",	//36
    "CommunicationCaptureCategory",	//37
    "CommunicationCategory",	//38
    "ControlCaptureCategory",	//39
    "DateMetaData",	//40
    "DescriptionMetaData",	//41
    "Disc",	//42
    "DrawChildren",	//43
    "DrawWindowBackground",	//44
    "Dvd",	//45
    "Effect",	//46
    "Effect##",	//47
    "Effect?",	//48
    "Effect?#",	//49
    "EffectParameter",	//50
    "EffectParameter#",	//51
    "EffectParameter$$$#",	//52
    "EffectParameter$$$##",	//53
    "EffectParameter$$$###",	//54
    "EffectParameter$$$###?",	//55
    "EffectParameter$$$###?$",	//56
    "EffectType",	//57
    "EffectWidget",	//58
    "EffectWidget#",	//59
    "EffectWidget##",	//60
    "Empty",	//61
    "ErrorState",	//62
    "Fade12Decibel",	//63
    "Fade3Decibel",	//64
    "Fade6Decibel",	//65
    "Fade9Decibel",	//66
    "FatalError",	//67
    "FitInView",	//68
    "GameCategory",	//69
    "GenreMetaData",	//70
    "IgnoreMask",	//71
    "IntegerHint",	//72
    "Invalid",	//73
    "LastCategory",	//74
    "LeftChannel",	//75
    "LeftSurroundChannel",	//76
    "LoadingState",	//77
    "LocalFile",	//78
    "LogarithmicHint",	//79
    "MediaController",	//80
    "MediaController#",	//81
    "MediaNode",	//82
    "MediaNode#",	//83
    "MediaObject",	//84
    "MediaObject#",	//85
    "MediaSource",	//86
    "MediaSource#",	//87
    "MediaSource$",	//88
    "MediaSource$$",	//89
    "MediaSource?",	//90
    "Mrl",	//91
    "Mrl#",	//92
    "Mrl$",	//93
    "MusicBrainzDiscIdMetaData",	//94
    "MusicCategory",	//95
    "Navigations",	//96
    "NoCaptureCategory",	//97
    "NoCategory",	//98
    "NoDisc",	//99
    "NoError",	//100
    "NormalError",	//101
    "NotificationCategory",	//102
    "ObjectDescriptionData",	//103
    "ObjectDescriptionData#",	//104
    "ObjectDescriptionData$?",	//105
    "ObjectDescriptionModelData",	//106
    "ObjectDescriptionModelData#",	//107
    "Path",	//108
    "Path#",	//109
    "PausedState",	//110
    "PlayingState",	//111
    "RecordingCaptureCategory",	//112
    "RightChannel",	//113
    "RightSurroundChannel",	//114
    "RootMenu",	//115
    "ScaleAndCrop",	//116
    "SeekSlider",	//117
    "SeekSlider#",	//118
    "SeekSlider##",	//119
    "StoppedState",	//120
    "Stream",	//121
    "StreamInterface",	//122
    "StreamInterface#",	//123
    "SubtitleMenu",	//124
    "SubtitleType",	//125
    "Subtitles",	//126
    "SubwooferChannel",	//127
    "TitleMenu",	//128
    "TitleMetaData",	//129
    "Titles",	//130
    "ToggledHint",	//131
    "TracknumberMetaData",	//132
    "Url",	//133
    "Vcd",	//134
    "VideoCaptureDeviceType",	//135
    "VideoCategory",	//136
    "VideoPlayer",	//137
    "VideoPlayer#",	//138
    "VideoPlayer$",	//139
    "VideoPlayer$#",	//140
    "VideoType",	//141
    "VideoWidget",	//142
    "VideoWidget#",	//143
    "VideoWidget##",	//144
    "VolumeFaderEffect",	//145
    "VolumeFaderEffect#",	//146
    "VolumeSlider",	//147
    "VolumeSlider#",	//148
    "VolumeSlider##",	//149
    "aboutToFinish",	//150
    "actionEvent",	//151
    "angleChanged",	//152
    "angleChanged$",	//153
    "aspectRatio",	//154
    "audioCaptureDevice",	//155
    "audioDeviceAccessList",	//156
    "audioOutput",	//157
    "autoDelete",	//158
    "autoplayTitles",	//159
    "availableAngles",	//160
    "availableAnglesChanged",	//161
    "availableAnglesChanged$",	//162
    "availableAudioChannels",	//163
    "availableAudioChannelsChanged",	//164
    "availableChapters",	//165
    "availableChaptersChanged",	//166
    "availableChaptersChanged$",	//167
    "availableMenus",	//168
    "availableMenusChanged",	//169
    "availableMenusChanged?",	//170
    "availableSubtitles",	//171
    "availableSubtitlesChanged",	//172
    "availableTitles",	//173
    "availableTitlesChanged",	//174
    "availableTitlesChanged$",	//175
    "brightness",	//176
    "bufferStatus",	//177
    "bufferStatus$",	//178
    "category",	//179
    "categoryToString",	//180
    "categoryToString$",	//181
    "changeEvent",	//182
    "chapterChanged",	//183
    "chapterChanged$",	//184
    "childEvent",	//185
    "clear",	//186
    "clearQueue",	//187
    "closeEvent",	//188
    "connectNotify",	//189
    "connectToSource",	//190
    "connectToSource#",	//191
    "contextMenuEvent",	//192
    "contrast",	//193
    "createPath",	//194
    "createPath##",	//195
    "createPlayer",	//196
    "createPlayer$",	//197
    "createPlayer$#",	//198
    "currentAngle",	//199
    "currentAudioChannel",	//200
    "currentChapter",	//201
    "currentSource",	//202
    "currentSourceChanged",	//203
    "currentSourceChanged#",	//204
    "currentSubtitle",	//205
    "currentTime",	//206
    "currentTitle",	//207
    "customEvent",	//208
    "data",	//209
    "data#",	//210
    "data#$",	//211
    "dataReady",	//212
    "dataReady?",	//213
    "dataSize",	//214
    "defaultValue",	//215
    "description",	//216
    "devType",	//217
    "deviceAccessList",	//218
    "deviceName",	//219
    "discType",	//220
    "disconnect",	//221
    "disconnectNotify",	//222
    "dragEnterEvent",	//223
    "dragLeaveEvent",	//224
    "dragMoveEvent",	//225
    "dropEvent",	//226
    "dropMimeData",	//227
    "dropMimeData$#$$$#",	//228
    "effects",	//229
    "enabledChange",	//230
    "endOfData",	//231
    "endOfMedia",	//232
    "endOfMedia$",	//233
    "enoughData",	//234
    "enqueue",	//235
    "enqueue#",	//236
    "enqueue?",	//237
    "enterEvent",	//238
    "enterFullScreen",	//239
    "error",	//240
    "error$$",	//241
    "errorString",	//242
    "errorType",	//243
    "event",	//244
    "event#",	//245
    "eventFilter",	//246
    "exitFullScreen",	//247
    "fadeCurve",	//248
    "fadeIn",	//249
    "fadeIn$",	//250
    "fadeOut",	//251
    "fadeOut$",	//252
    "fadeTo",	//253
    "fadeTo$$",	//254
    "fileName",	//255
    "finished",	//256
    "flags",	//257
    "flags#",	//258
    "focusInEvent",	//259
    "focusNextPrevChild",	//260
    "focusOutEvent",	//261
    "fontChange",	//262
    "fromIndex",	//263
    "fromIndex$$",	//264
    "hasTracking",	//265
    "hasVideo",	//266
    "hasVideoChanged",	//267
    "hasVideoChanged$",	//268
    "heightForWidth",	//269
    "hideEvent",	//270
    "hue",	//271
    "iconSize",	//272
    "id",	//273
    "index",	//274
    "inputMethodEvent",	//275
    "inputMethodQuery",	//276
    "inputPaths",	//277
    "insertEffect",	//278
    "insertEffect#",	//279
    "insertEffect##",	//280
    "insertEffect?",	//281
    "insertEffect?#",	//282
    "isIconVisible",	//283
    "isLogarithmicControl",	//284
    "isMuteVisible",	//285
    "isMuted",	//286
    "isPaused",	//287
    "isPlaying",	//288
    "isSeekable",	//289
    "isValid",	//290
    "keyPressEvent",	//291
    "keyReleaseEvent",	//292
    "languageChange",	//293
    "leaveEvent",	//294
    "load",	//295
    "load#",	//296
    "maximumValue",	//297
    "maximumVolume",	//298
    "mediaObject",	//299
    "metaData",	//300
    "metaData$",	//301
    "metaDataChanged",	//302
    "metaObject",	//303
    "metric",	//304
    "mimeData",	//305
    "mimeData$?",	//306
    "mimeTypes",	//307
    "mimeTypes$",	//308
    "minimumSizeHint",	//309
    "minimumValue",	//310
    "modelData",	//311
    "modelData#",	//312
    "mouseDoubleClickEvent",	//313
    "mouseMoveEvent",	//314
    "mouseMoveEvent#",	//315
    "mousePressEvent",	//316
    "mouseReleaseEvent",	//317
    "moveDown",	//318
    "moveDown#",	//319
    "moveEvent",	//320
    "moveUp",	//321
    "moveUp#",	//322
    "mrl",	//323
    "mutedChanged",	//324
    "mutedChanged$",	//325
    "name",	//326
    "navigationMenuToString",	//327
    "navigationMenuToString$",	//328
    "needData",	//329
    "nextTitle",	//330
    "operator!=",	//331
    "operator!=#",	//332
    "operator<",	//333
    "operator<#",	//334
    "operator<<",	//335
    "operator<<##",	//336
    "operator<<#$",	//337
    "operator=",	//338
    "operator=#",	//339
    "operator=$",	//340
    "operator==",	//341
    "operator==#",	//342
    "operator>",	//343
    "operator>#",	//344
    "orientation",	//345
    "outputDevice",	//346
    "outputDeviceChanged",	//347
    "outputDeviceChanged?",	//348
    "outputPaths",	//349
    "pageStep",	//350
    "paintEngine",	//351
    "paintEvent",	//352
    "paletteChange",	//353
    "parameterValue",	//354
    "parameterValue#",	//355
    "parameters",	//356
    "pause",	//357
    "phononVersion",	//358
    "play",	//359
    "play#",	//360
    "possibleValues",	//361
    "prefinishMark",	//362
    "prefinishMarkReached",	//363
    "prefinishMarkReached$",	//364
    "previousTitle",	//365
    "property",	//366
    "property$",	//367
    "propertyNames",	//368
    "qHash",	//369
    "qHash#",	//370
    "qt_metacall",	//371
    "qt_metacall$$?",	//372
    "qt_metacast",	//373
    "qt_metacast$",	//374
    "queue",	//375
    "reconnect",	//376
    "reconnect##",	//377
    "registerMetaTypes",	//378
    "remainingTime",	//379
    "removeEffect",	//380
    "removeEffect#",	//381
    "removeRows",	//382
    "removeRows$$",	//383
    "removeRows$$#",	//384
    "reset",	//385
    "resizeEvent",	//386
    "rowCount",	//387
    "rowCount#",	//388
    "sampleRate",	//389
    "saturation",	//390
    "scaleMode",	//391
    "seek",	//392
    "seek$",	//393
    "seekStream",	//394
    "seekStream$",	//395
    "seekableChanged",	//396
    "seekableChanged$",	//397
    "setAspectRatio",	//398
    "setAspectRatio$",	//399
    "setAudioOutput",	//400
    "setAudioOutput#",	//401
    "setAutoDelete",	//402
    "setAutoDelete$",	//403
    "setAutoplayTitles",	//404
    "setAutoplayTitles$",	//405
    "setBrightness",	//406
    "setBrightness$",	//407
    "setContrast",	//408
    "setContrast$",	//409
    "setCurrentAngle",	//410
    "setCurrentAngle$",	//411
    "setCurrentAudioChannel",	//412
    "setCurrentAudioChannel?",	//413
    "setCurrentChapter",	//414
    "setCurrentChapter$",	//415
    "setCurrentMenu",	//416
    "setCurrentMenu$",	//417
    "setCurrentSource",	//418
    "setCurrentSource#",	//419
    "setCurrentSubtitle",	//420
    "setCurrentSubtitle#",	//421
    "setCurrentSubtitle?",	//422
    "setCurrentTitle",	//423
    "setCurrentTitle$",	//424
    "setDataSize",	//425
    "setDataSize$",	//426
    "setFadeCurve",	//427
    "setFadeCurve$",	//428
    "setFullScreen",	//429
    "setFullScreen$",	//430
    "setHue",	//431
    "setHue$",	//432
    "setIconSize",	//433
    "setIconSize#",	//434
    "setIconVisible",	//435
    "setIconVisible$",	//436
    "setMaximumVolume",	//437
    "setMaximumVolume$",	//438
    "setMediaObject",	//439
    "setMediaObject#",	//440
    "setModelData",	//441
    "setModelData?",	//442
    "setMuteVisible",	//443
    "setMuteVisible$",	//444
    "setMuted",	//445
    "setMuted$",	//446
    "setName",	//447
    "setName$",	//448
    "setOrientation",	//449
    "setOrientation$",	//450
    "setOutputDevice",	//451
    "setOutputDevice?",	//452
    "setPageStep",	//453
    "setPageStep$",	//454
    "setParameterValue",	//455
    "setParameterValue##",	//456
    "setPrefinishMark",	//457
    "setPrefinishMark$",	//458
    "setQueue",	//459
    "setQueue?",	//460
    "setSaturation",	//461
    "setSaturation$",	//462
    "setScaleMode",	//463
    "setScaleMode$",	//464
    "setSingleStep",	//465
    "setSingleStep$",	//466
    "setStreamSeekable",	//467
    "setStreamSeekable$",	//468
    "setStreamSize",	//469
    "setStreamSize$",	//470
    "setSubtitleAutodetect",	//471
    "setSubtitleAutodetect$",	//472
    "setSubtitleEncoding",	//473
    "setSubtitleEncoding$",	//474
    "setSubtitleFont",	//475
    "setSubtitleFont#",	//476
    "setTickInterval",	//477
    "setTickInterval$",	//478
    "setTracking",	//479
    "setTracking$",	//480
    "setTransitionTime",	//481
    "setTransitionTime$",	//482
    "setVisible",	//483
    "setVolume",	//484
    "setVolume$",	//485
    "setVolumeDecibel",	//486
    "setVolumeDecibel$",	//487
    "showEvent",	//488
    "singleStep",	//489
    "sink",	//490
    "sizeHint",	//491
    "snapshot",	//492
    "source",	//493
    "state",	//494
    "stateChanged",	//495
    "stateChanged$$",	//496
    "staticMetaObject",	//497
    "stop",	//498
    "stream",	//499
    "streamSeekable",	//500
    "streamSize",	//501
    "styleChange",	//502
    "subtitleAutodetect",	//503
    "subtitleEncoding",	//504
    "subtitleFont",	//505
    "supportedDropActions",	//506
    "supportedFeatures",	//507
    "tabletEvent",	//508
    "tick",	//509
    "tick$",	//510
    "tickInterval",	//511
    "timerEvent",	//512
    "titleChanged",	//513
    "titleChanged$",	//514
    "toEncoded",	//515
    "toEncoded$",	//516
    "totalTime",	//517
    "totalTimeChanged",	//518
    "totalTimeChanged$",	//519
    "tr",	//520
    "tr$",	//521
    "tr$$",	//522
    "tr$$$",	//523
    "trUtf8",	//524
    "trUtf8$",	//525
    "trUtf8$$",	//526
    "trUtf8$$$",	//527
    "transitionTime",	//528
    "tupleIndexAtPositionIndex",	//529
    "tupleIndexAtPositionIndex$",	//530
    "tupleIndexOrder",	//531
    "type",	//532
    "url",	//533
    "videoCaptureDevice",	//534
    "videoDeviceAccessList",	//535
    "videoWidget",	//536
    "volume",	//537
    "volumeChanged",	//538
    "volumeChanged$",	//539
    "volumeDecibel",	//540
    "wheelEvent",	//541
    "windowActivationChange",	//542
    "writeData",	//543
    "writeData#",	//544
    "x11Event",	//545
    "~AbstractAudioOutput",	//546
    "~AbstractMediaStream",	//547
    "~AbstractVideoOutput",	//548
    "~AudioDataOutput",	//549
    "~AudioOutput",	//550
    "~Effect",	//551
    "~EffectParameter",	//552
    "~EffectWidget",	//553
    "~MediaController",	//554
    "~MediaNode",	//555
    "~MediaObject",	//556
    "~MediaSource",	//557
    "~Mrl",	//558
    "~ObjectDescriptionData",	//559
    "~ObjectDescriptionModelData",	//560
    "~Path",	//561
    "~SeekSlider",	//562
    "~StreamInterface",	//563
    "~VideoPlayer",	//564
    "~VideoWidget",	//565
    "~VolumeFaderEffect",	//566
    "~VolumeSlider",	//567
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {1, 335, 1, 2, Smoke::mf_static, 80, 1},	//1 Phonon::operator<<(QDebug, const Phonon::MediaSource&)
    {1, 180, 4, 1, Smoke::mf_static, 130, 2},	//2 Phonon::categoryToString(Phonon::Category)
    {1, 358, 0, 0, Smoke::mf_static, 261, 3},	//3 Phonon::phononVersion()
    {1, 335, 6, 2, Smoke::mf_static, 80, 4},	//4 Phonon::operator<<(QDebug, const Phonon::ErrorType&)
    {1, 369, 9, 1, Smoke::mf_static, 271, 5},	//5 Phonon::qHash(const Phonon::EffectParameter&)
    {1, 378, 0, 0, Smoke::mf_static, 0, 6},	//6 Phonon::registerMetaTypes()
    {1, 180, 11, 1, Smoke::mf_static, 130, 7},	//7 Phonon::categoryToString(Phonon::CaptureCategory)
    {1, 335, 13, 2, Smoke::mf_static, 80, 8},	//8 Phonon::operator<<(QDebug, const Phonon::Capture::DeviceType&)
    {1, 335, 16, 2, Smoke::mf_static, 80, 9},	//9 Phonon::operator<<(QDebug, const Phonon::Category&)
    {1, 194, 19, 2, Smoke::mf_static, 56, 10},	//10 Phonon::createPath(Phonon::MediaNode*, Phonon::MediaNode*)
    {1, 196, 22, 2, Smoke::mf_static, 35, 11},	//11 Phonon::createPlayer(Phonon::Category, const Phonon::MediaSource&)
    {1, 196, 4, 1, Smoke::mf_static, 35, 12},	//12 Phonon::createPlayer(Phonon::Category)
    {1, 335, 25, 2, Smoke::mf_static, 80, 13},	//13 Phonon::operator<<(QDebug, const Phonon::MetaData&)
    {1, 335, 28, 2, Smoke::mf_static, 80, 14},	//14 Phonon::operator<<(QDebug, const Phonon::CaptureCategory&)
    {1, 335, 31, 2, Smoke::mf_static, 80, 15},	//15 Phonon::operator<<(QDebug, const Phonon::State&)
    {1, 335, 34, 2, Smoke::mf_static, 80, 16},	//16 Phonon::operator<<(QDebug, const Phonon::DiscType&)
    {1, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 17},	//17 Phonon::ArtistMetaData (enum)
    {1, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 18},	//18 Phonon::AlbumMetaData (enum)
    {1, 129, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 19},	//19 Phonon::TitleMetaData (enum)
    {1, 40, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 20},	//20 Phonon::DateMetaData (enum)
    {1, 70, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 21},	//21 Phonon::GenreMetaData (enum)
    {1, 132, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 22},	//22 Phonon::TracknumberMetaData (enum)
    {1, 41, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 23},	//23 Phonon::DescriptionMetaData (enum)
    {1, 94, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 24},	//24 Phonon::MusicBrainzDiscIdMetaData (enum)
    {1, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 55, 25},	//25 Phonon::AudioOutputDeviceType (enum)
    {1, 57, 0, 0, Smoke::mf_static|Smoke::mf_enum, 55, 26},	//26 Phonon::EffectType (enum)
    {1, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 55, 27},	//27 Phonon::AudioChannelType (enum)
    {1, 125, 0, 0, Smoke::mf_static|Smoke::mf_enum, 55, 28},	//28 Phonon::SubtitleType (enum)
    {1, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 55, 29},	//29 Phonon::AudioCaptureDeviceType (enum)
    {1, 135, 0, 0, Smoke::mf_static|Smoke::mf_enum, 55, 30},	//30 Phonon::VideoCaptureDeviceType (enum)
    {1, 99, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 31},	//31 Phonon::NoDisc (enum)
    {1, 33, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 32},	//32 Phonon::Cd (enum)
    {1, 45, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 33},	//33 Phonon::Dvd (enum)
    {1, 134, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 34},	//34 Phonon::Vcd (enum)
    {1, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 35},	//35 Phonon::BluRay (enum)
    {1, 97, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 36},	//36 Phonon::NoCaptureCategory (enum)
    {1, 37, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 37},	//37 Phonon::CommunicationCaptureCategory (enum)
    {1, 112, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 38},	//38 Phonon::RecordingCaptureCategory (enum)
    {1, 39, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 39},	//39 Phonon::ControlCaptureCategory (enum)
    {1, 100, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 40},	//40 Phonon::NoError (enum)
    {1, 101, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 41},	//41 Phonon::NormalError (enum)
    {1, 67, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 42},	//42 Phonon::FatalError (enum)
    {1, 98, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 43},	//43 Phonon::NoCategory (enum)
    {1, 102, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 44},	//44 Phonon::NotificationCategory (enum)
    {1, 95, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 45},	//45 Phonon::MusicCategory (enum)
    {1, 136, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 46},	//46 Phonon::VideoCategory (enum)
    {1, 38, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 47},	//47 Phonon::CommunicationCategory (enum)
    {1, 69, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 48},	//48 Phonon::GameCategory (enum)
    {1, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 49},	//49 Phonon::AccessibilityCategory (enum)
    {1, 74, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 50},	//50 Phonon::LastCategory (enum)
    {1, 77, 0, 0, Smoke::mf_static|Smoke::mf_enum, 60, 51},	//51 Phonon::LoadingState (enum)
    {1, 120, 0, 0, Smoke::mf_static|Smoke::mf_enum, 60, 52},	//52 Phonon::StoppedState (enum)
    {1, 111, 0, 0, Smoke::mf_static|Smoke::mf_enum, 60, 53},	//53 Phonon::PlayingState (enum)
    {1, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 60, 54},	//54 Phonon::BufferingState (enum)
    {1, 110, 0, 0, Smoke::mf_static|Smoke::mf_enum, 60, 55},	//55 Phonon::PausedState (enum)
    {1, 62, 0, 0, Smoke::mf_static|Smoke::mf_enum, 60, 56},	//56 Phonon::ErrorState (enum)
    {2, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//57 Phonon::AbstractAudioOutput::metaObject() const
    {2, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//58 Phonon::AbstractAudioOutput::qt_metacast(const char*)
    {2, 520, 39, 2, Smoke::mf_static, 130, 3},	//59 Phonon::AbstractAudioOutput::tr(const char*, const char*)
    {2, 524, 39, 2, Smoke::mf_static, 130, 4},	//60 Phonon::AbstractAudioOutput::trUtf8(const char*, const char*)
    {2, 520, 42, 3, Smoke::mf_static, 130, 5},	//61 Phonon::AbstractAudioOutput::tr(const char*, const char*, int)
    {2, 524, 42, 3, Smoke::mf_static, 130, 6},	//62 Phonon::AbstractAudioOutput::trUtf8(const char*, const char*, int)
    {2, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//63 Phonon::AbstractAudioOutput::qt_metacall(QMetaObject::Call, int, void**)
    {2, 1, 50, 2, Smoke::mf_ctor|Smoke::mf_protected, 1, 8},	//64 Phonon::AbstractAudioOutput::AbstractAudioOutput(Phonon::AbstractAudioOutputPrivate&, QObject*)
    {2, 520, 37, 1, Smoke::mf_static, 130, 9},	//65 Phonon::AbstractAudioOutput::tr(const char*)
    {2, 524, 37, 1, Smoke::mf_static, 130, 10},	//66 Phonon::AbstractAudioOutput::trUtf8(const char*)
    {2, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 11},	//67 Phonon::AbstractAudioOutput::staticMetaObject() const
    {2, 546, 0, 0, Smoke::mf_dtor, 0, 12 },	//68 Phonon::AbstractAudioOutput::~AbstractAudioOutput()
    {4, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//69 Phonon::AbstractMediaStream::metaObject() const
    {4, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//70 Phonon::AbstractMediaStream::qt_metacast(const char*)
    {4, 520, 39, 2, Smoke::mf_static, 130, 3},	//71 Phonon::AbstractMediaStream::tr(const char*, const char*)
    {4, 524, 39, 2, Smoke::mf_static, 130, 4},	//72 Phonon::AbstractMediaStream::trUtf8(const char*, const char*)
    {4, 520, 42, 3, Smoke::mf_static, 130, 5},	//73 Phonon::AbstractMediaStream::tr(const char*, const char*, int)
    {4, 524, 42, 3, Smoke::mf_static, 130, 6},	//74 Phonon::AbstractMediaStream::trUtf8(const char*, const char*, int)
    {4, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//75 Phonon::AbstractMediaStream::qt_metacall(QMetaObject::Call, int, void**)
    {4, 3, 53, 1, Smoke::mf_ctor|Smoke::mf_protected, 3, 8},	//76 Phonon::AbstractMediaStream::AbstractMediaStream(QObject*)
    {4, 501, 0, 0, Smoke::mf_const|Smoke::mf_protected, 266, 9},	//77 Phonon::AbstractMediaStream::streamSize() const
    {4, 469, 55, 1, Smoke::mf_protected, 0, 10},	//78 Phonon::AbstractMediaStream::setStreamSize(long long)
    {4, 500, 0, 0, Smoke::mf_const|Smoke::mf_protected, 216, 11},	//79 Phonon::AbstractMediaStream::streamSeekable() const
    {4, 467, 57, 1, Smoke::mf_protected, 0, 12},	//80 Phonon::AbstractMediaStream::setStreamSeekable(bool)
    {4, 543, 59, 1, Smoke::mf_protected, 0, 13},	//81 Phonon::AbstractMediaStream::writeData(const QByteArray&)
    {4, 231, 0, 0, Smoke::mf_protected, 0, 14},	//82 Phonon::AbstractMediaStream::endOfData()
    {4, 240, 61, 2, Smoke::mf_protected, 0, 15},	//83 Phonon::AbstractMediaStream::error(Phonon::ErrorType, const QString&)
    {4, 385, 0, 0, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 16},	//84 Phonon::AbstractMediaStream::reset() [pure virtual]
    {4, 329, 0, 0, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 17},	//85 Phonon::AbstractMediaStream::needData() [pure virtual]
    {4, 234, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 18},	//86 Phonon::AbstractMediaStream::enoughData()
    {4, 394, 55, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 19},	//87 Phonon::AbstractMediaStream::seekStream(long long)
    {4, 3, 64, 2, Smoke::mf_ctor|Smoke::mf_protected, 3, 20},	//88 Phonon::AbstractMediaStream::AbstractMediaStream(Phonon::AbstractMediaStreamPrivate&, QObject*)
    {4, 520, 37, 1, Smoke::mf_static, 130, 21},	//89 Phonon::AbstractMediaStream::tr(const char*)
    {4, 524, 37, 1, Smoke::mf_static, 130, 22},	//90 Phonon::AbstractMediaStream::trUtf8(const char*)
    {4, 3, 0, 0, Smoke::mf_ctor|Smoke::mf_protected, 3, 23},	//91 Phonon::AbstractMediaStream::AbstractMediaStream()
    {4, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 24},	//92 Phonon::AbstractMediaStream::staticMetaObject() const
    {4, 547, 0, 0, Smoke::mf_dtor, 0, 25 },	//93 Phonon::AbstractMediaStream::~AbstractMediaStream()
    {6, 6, 67, 1, Smoke::mf_ctor|Smoke::mf_protected, 5, 1},	//94 Phonon::AbstractVideoOutput::AbstractVideoOutput(Phonon::AbstractVideoOutputPrivate&)
    {6, 6, 69, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 5, 2},	//95 Phonon::AbstractVideoOutput::AbstractVideoOutput(const Phonon::AbstractVideoOutput&)
    {6, 548, 0, 0, Smoke::mf_dtor, 0, 3 },	//96 Phonon::AbstractVideoOutput::~AbstractVideoOutput()
    {8, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//97 Phonon::AudioDataOutput::metaObject() const
    {8, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//98 Phonon::AudioDataOutput::qt_metacast(const char*)
    {8, 520, 39, 2, Smoke::mf_static, 130, 3},	//99 Phonon::AudioDataOutput::tr(const char*, const char*)
    {8, 524, 39, 2, Smoke::mf_static, 130, 4},	//100 Phonon::AudioDataOutput::trUtf8(const char*, const char*)
    {8, 520, 42, 3, Smoke::mf_static, 130, 5},	//101 Phonon::AudioDataOutput::tr(const char*, const char*, int)
    {8, 524, 42, 3, Smoke::mf_static, 130, 6},	//102 Phonon::AudioDataOutput::trUtf8(const char*, const char*, int)
    {8, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//103 Phonon::AudioDataOutput::qt_metacall(QMetaObject::Call, int, void**)
    {8, 20, 53, 1, Smoke::mf_ctor, 10, 8},	//104 Phonon::AudioDataOutput::AudioDataOutput(QObject*)
    {8, 214, 0, 0, Smoke::mf_const|Smoke::mf_property, 265, 9},	//105 Phonon::AudioDataOutput::dataSize() const
    {8, 389, 0, 0, Smoke::mf_const, 265, 10},	//106 Phonon::AudioDataOutput::sampleRate() const
    {8, 425, 71, 1, Smoke::mf_property|Smoke::mf_slot, 0, 11},	//107 Phonon::AudioDataOutput::setDataSize(int)
    {8, 212, 73, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//108 Phonon::AudioDataOutput::dataReady(const QMap<Phonon::AudioDataOutput::Channel,QVector<qint16> >&)
    {8, 232, 71, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//109 Phonon::AudioDataOutput::endOfMedia(int)
    {8, 520, 37, 1, Smoke::mf_static, 130, 14},	//110 Phonon::AudioDataOutput::tr(const char*)
    {8, 524, 37, 1, Smoke::mf_static, 130, 15},	//111 Phonon::AudioDataOutput::trUtf8(const char*)
    {8, 20, 0, 0, Smoke::mf_ctor, 10, 16},	//112 Phonon::AudioDataOutput::AudioDataOutput()
    {8, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 17},	//113 Phonon::AudioDataOutput::staticMetaObject() const
    {8, 75, 0, 0, Smoke::mf_static|Smoke::mf_enum, 11, 18},	//114 Phonon::AudioDataOutput::LeftChannel (enum)
    {8, 113, 0, 0, Smoke::mf_static|Smoke::mf_enum, 11, 19},	//115 Phonon::AudioDataOutput::RightChannel (enum)
    {8, 34, 0, 0, Smoke::mf_static|Smoke::mf_enum, 11, 20},	//116 Phonon::AudioDataOutput::CenterChannel (enum)
    {8, 76, 0, 0, Smoke::mf_static|Smoke::mf_enum, 11, 21},	//117 Phonon::AudioDataOutput::LeftSurroundChannel (enum)
    {8, 114, 0, 0, Smoke::mf_static|Smoke::mf_enum, 11, 22},	//118 Phonon::AudioDataOutput::RightSurroundChannel (enum)
    {8, 127, 0, 0, Smoke::mf_static|Smoke::mf_enum, 11, 23},	//119 Phonon::AudioDataOutput::SubwooferChannel (enum)
    {8, 549, 0, 0, Smoke::mf_dtor, 0, 24 },	//120 Phonon::AudioDataOutput::~AudioDataOutput()
    {9, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//121 Phonon::AudioOutput::metaObject() const
    {9, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//122 Phonon::AudioOutput::qt_metacast(const char*)
    {9, 520, 39, 2, Smoke::mf_static, 130, 3},	//123 Phonon::AudioOutput::tr(const char*, const char*)
    {9, 524, 39, 2, Smoke::mf_static, 130, 4},	//124 Phonon::AudioOutput::trUtf8(const char*, const char*)
    {9, 520, 42, 3, Smoke::mf_static, 130, 5},	//125 Phonon::AudioOutput::tr(const char*, const char*, int)
    {9, 524, 42, 3, Smoke::mf_static, 130, 6},	//126 Phonon::AudioOutput::trUtf8(const char*, const char*, int)
    {9, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//127 Phonon::AudioOutput::qt_metacall(QMetaObject::Call, int, void**)
    {9, 23, 75, 2, Smoke::mf_ctor, 12, 8},	//128 Phonon::AudioOutput::AudioOutput(Phonon::Category, QObject*)
    {9, 23, 53, 1, Smoke::mf_ctor, 12, 9},	//129 Phonon::AudioOutput::AudioOutput(QObject*)
    {9, 326, 0, 0, Smoke::mf_const|Smoke::mf_property, 130, 10},	//130 Phonon::AudioOutput::name() const
    {9, 537, 0, 0, Smoke::mf_const, 263, 11},	//131 Phonon::AudioOutput::volume() const
    {9, 540, 0, 0, Smoke::mf_const, 263, 12},	//132 Phonon::AudioOutput::volumeDecibel() const
    {9, 179, 0, 0, Smoke::mf_const, 18, 13},	//133 Phonon::AudioOutput::category() const
    {9, 346, 0, 0, Smoke::mf_const, 47, 14},	//134 Phonon::AudioOutput::outputDevice() const
    {9, 286, 0, 0, Smoke::mf_const|Smoke::mf_property, 216, 15},	//135 Phonon::AudioOutput::isMuted() const
    {9, 447, 78, 1, Smoke::mf_property|Smoke::mf_slot, 0, 16},	//136 Phonon::AudioOutput::setName(const QString&)
    {9, 484, 80, 1, Smoke::mf_property|Smoke::mf_slot, 0, 17},	//137 Phonon::AudioOutput::setVolume(qreal)
    {9, 486, 80, 1, Smoke::mf_property|Smoke::mf_slot, 0, 18},	//138 Phonon::AudioOutput::setVolumeDecibel(qreal)
    {9, 451, 82, 1, Smoke::mf_property|Smoke::mf_slot, 216, 19},	//139 Phonon::AudioOutput::setOutputDevice(const Phonon::AudioOutputDevice&)
    {9, 445, 57, 1, Smoke::mf_property|Smoke::mf_slot, 0, 20},	//140 Phonon::AudioOutput::setMuted(bool)
    {9, 538, 80, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 21},	//141 Phonon::AudioOutput::volumeChanged(qreal)
    {9, 324, 57, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 22},	//142 Phonon::AudioOutput::mutedChanged(bool)
    {9, 347, 82, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 23},	//143 Phonon::AudioOutput::outputDeviceChanged(const Phonon::AudioOutputDevice&)
    {9, 520, 37, 1, Smoke::mf_static, 130, 24},	//144 Phonon::AudioOutput::tr(const char*)
    {9, 524, 37, 1, Smoke::mf_static, 130, 25},	//145 Phonon::AudioOutput::trUtf8(const char*)
    {9, 23, 4, 1, Smoke::mf_ctor, 12, 26},	//146 Phonon::AudioOutput::AudioOutput(Phonon::Category)
    {9, 23, 0, 0, Smoke::mf_ctor, 12, 27},	//147 Phonon::AudioOutput::AudioOutput()
    {9, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 28},	//148 Phonon::AudioOutput::staticMetaObject() const
    {9, 550, 0, 0, Smoke::mf_dtor, 0, 29 },	//149 Phonon::AudioOutput::~AudioOutput()
    {11, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 1},	//150 Phonon::Capture::AudioType (enum)
    {11, 141, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 2},	//151 Phonon::Capture::VideoType (enum)
    {12, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//152 Phonon::Effect::metaObject() const
    {12, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//153 Phonon::Effect::qt_metacast(const char*)
    {12, 520, 39, 2, Smoke::mf_static, 130, 3},	//154 Phonon::Effect::tr(const char*, const char*)
    {12, 524, 39, 2, Smoke::mf_static, 130, 4},	//155 Phonon::Effect::trUtf8(const char*, const char*)
    {12, 520, 42, 3, Smoke::mf_static, 130, 5},	//156 Phonon::Effect::tr(const char*, const char*, int)
    {12, 524, 42, 3, Smoke::mf_static, 130, 6},	//157 Phonon::Effect::trUtf8(const char*, const char*, int)
    {12, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//158 Phonon::Effect::qt_metacall(QMetaObject::Call, int, void**)
    {12, 46, 84, 2, Smoke::mf_ctor, 20, 8},	//159 Phonon::Effect::Effect(const Phonon::ObjectDescription<Phonon::EffectType>&, QObject*)
    {12, 216, 0, 0, Smoke::mf_const, 48, 9},	//160 Phonon::Effect::description() const
    {12, 356, 0, 0, Smoke::mf_const, 103, 10},	//161 Phonon::Effect::parameters() const
    {12, 354, 9, 1, Smoke::mf_const, 138, 11},	//162 Phonon::Effect::parameterValue(const Phonon::EffectParameter&) const
    {12, 455, 87, 2, 0, 0, 12},	//163 Phonon::Effect::setParameterValue(const Phonon::EffectParameter&, const QVariant&)
    {12, 46, 90, 2, Smoke::mf_ctor|Smoke::mf_protected, 20, 13},	//164 Phonon::Effect::Effect(Phonon::EffectPrivate&, QObject*)
    {12, 520, 37, 1, Smoke::mf_static, 130, 14},	//165 Phonon::Effect::tr(const char*)
    {12, 524, 37, 1, Smoke::mf_static, 130, 15},	//166 Phonon::Effect::trUtf8(const char*)
    {12, 46, 93, 1, Smoke::mf_ctor, 20, 16},	//167 Phonon::Effect::Effect(const Phonon::ObjectDescription<Phonon::EffectType>&)
    {12, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 17},	//168 Phonon::Effect::staticMetaObject() const
    {12, 551, 0, 0, Smoke::mf_dtor, 0, 18 },	//169 Phonon::Effect::~Effect()
    {13, 50, 0, 0, Smoke::mf_ctor, 24, 1},	//170 Phonon::EffectParameter::EffectParameter()
    {13, 326, 0, 0, Smoke::mf_const, 257, 2},	//171 Phonon::EffectParameter::name() const
    {13, 216, 0, 0, Smoke::mf_const, 257, 3},	//172 Phonon::EffectParameter::description() const
    {13, 532, 0, 0, Smoke::mf_const, 139, 4},	//173 Phonon::EffectParameter::type() const
    {13, 284, 0, 0, Smoke::mf_const, 216, 5},	//174 Phonon::EffectParameter::isLogarithmicControl() const
    {13, 310, 0, 0, Smoke::mf_const, 138, 6},	//175 Phonon::EffectParameter::minimumValue() const
    {13, 297, 0, 0, Smoke::mf_const, 138, 7},	//176 Phonon::EffectParameter::maximumValue() const
    {13, 215, 0, 0, Smoke::mf_const, 138, 8},	//177 Phonon::EffectParameter::defaultValue() const
    {13, 361, 0, 0, Smoke::mf_const, 112, 9},	//178 Phonon::EffectParameter::possibleValues() const
    {13, 333, 9, 1, Smoke::mf_const, 216, 10},	//179 Phonon::EffectParameter::operator<(const Phonon::EffectParameter&) const
    {13, 343, 9, 1, Smoke::mf_const, 216, 11},	//180 Phonon::EffectParameter::operator>(const Phonon::EffectParameter&) const
    {13, 341, 9, 1, Smoke::mf_const, 216, 12},	//181 Phonon::EffectParameter::operator==(const Phonon::EffectParameter&) const
    {13, 50, 9, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 24, 13},	//182 Phonon::EffectParameter::EffectParameter(const Phonon::EffectParameter&)
    {13, 338, 9, 1, 0, 23, 14},	//183 Phonon::EffectParameter::operator=(const Phonon::EffectParameter&)
    {13, 50, 95, 8, Smoke::mf_ctor, 24, 15},	//184 Phonon::EffectParameter::EffectParameter(int, const QString&, QFlags<Phonon::EffectParameter::Hint>, const QVariant&, const QVariant&, const QVariant&, const QList<QVariant>&, const QString&)
    {13, 273, 0, 0, Smoke::mf_const, 265, 16},	//185 Phonon::EffectParameter::id() const
    {13, 50, 104, 4, Smoke::mf_ctor, 24, 17},	//186 Phonon::EffectParameter::EffectParameter(int, const QString&, QFlags<Phonon::EffectParameter::Hint>, const QVariant&)
    {13, 50, 109, 5, Smoke::mf_ctor, 24, 18},	//187 Phonon::EffectParameter::EffectParameter(int, const QString&, QFlags<Phonon::EffectParameter::Hint>, const QVariant&, const QVariant&)
    {13, 50, 115, 6, Smoke::mf_ctor, 24, 19},	//188 Phonon::EffectParameter::EffectParameter(int, const QString&, QFlags<Phonon::EffectParameter::Hint>, const QVariant&, const QVariant&, const QVariant&)
    {13, 50, 122, 7, Smoke::mf_ctor, 24, 20},	//189 Phonon::EffectParameter::EffectParameter(int, const QString&, QFlags<Phonon::EffectParameter::Hint>, const QVariant&, const QVariant&, const QVariant&, const QList<QVariant>&)
    {13, 131, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 21},	//190 Phonon::EffectParameter::ToggledHint (enum)
    {13, 79, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 22},	//191 Phonon::EffectParameter::LogarithmicHint (enum)
    {13, 72, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 23},	//192 Phonon::EffectParameter::IntegerHint (enum)
    {13, 552, 0, 0, Smoke::mf_dtor, 0, 24 },	//193 Phonon::EffectParameter::~EffectParameter()
    {15, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//194 Phonon::EffectWidget::metaObject() const
    {15, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//195 Phonon::EffectWidget::qt_metacast(const char*)
    {15, 520, 39, 2, Smoke::mf_static, 130, 3},	//196 Phonon::EffectWidget::tr(const char*, const char*)
    {15, 524, 39, 2, Smoke::mf_static, 130, 4},	//197 Phonon::EffectWidget::trUtf8(const char*, const char*)
    {15, 520, 42, 3, Smoke::mf_static, 130, 5},	//198 Phonon::EffectWidget::tr(const char*, const char*, int)
    {15, 524, 42, 3, Smoke::mf_static, 130, 6},	//199 Phonon::EffectWidget::trUtf8(const char*, const char*, int)
    {15, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//200 Phonon::EffectWidget::qt_metacall(QMetaObject::Call, int, void**)
    {15, 58, 130, 2, Smoke::mf_ctor, 28, 8},	//201 Phonon::EffectWidget::EffectWidget(Phonon::Effect*, QWidget*)
    {15, 520, 37, 1, Smoke::mf_static, 130, 9},	//202 Phonon::EffectWidget::tr(const char*)
    {15, 524, 37, 1, Smoke::mf_static, 130, 10},	//203 Phonon::EffectWidget::trUtf8(const char*)
    {15, 58, 133, 1, Smoke::mf_ctor, 28, 11},	//204 Phonon::EffectWidget::EffectWidget(Phonon::Effect*)
    {15, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 12},	//205 Phonon::EffectWidget::staticMetaObject() const
    {15, 553, 0, 0, Smoke::mf_dtor, 0, 13 },	//206 Phonon::EffectWidget::~EffectWidget()
    {16, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//207 Phonon::MediaController::metaObject() const
    {16, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//208 Phonon::MediaController::qt_metacast(const char*)
    {16, 520, 39, 2, Smoke::mf_static, 130, 3},	//209 Phonon::MediaController::tr(const char*, const char*)
    {16, 524, 39, 2, Smoke::mf_static, 130, 4},	//210 Phonon::MediaController::trUtf8(const char*, const char*)
    {16, 520, 42, 3, Smoke::mf_static, 130, 5},	//211 Phonon::MediaController::tr(const char*, const char*, int)
    {16, 524, 42, 3, Smoke::mf_static, 130, 6},	//212 Phonon::MediaController::trUtf8(const char*, const char*, int)
    {16, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//213 Phonon::MediaController::qt_metacall(QMetaObject::Call, int, void**)
    {16, 80, 135, 1, Smoke::mf_ctor, 30, 8},	//214 Phonon::MediaController::MediaController(Phonon::MediaObject*)
    {16, 507, 0, 0, Smoke::mf_const, 88, 9},	//215 Phonon::MediaController::supportedFeatures() const
    {16, 160, 0, 0, Smoke::mf_const, 265, 10},	//216 Phonon::MediaController::availableAngles() const
    {16, 199, 0, 0, Smoke::mf_const, 265, 11},	//217 Phonon::MediaController::currentAngle() const
    {16, 165, 0, 0, Smoke::mf_const, 265, 12},	//218 Phonon::MediaController::availableChapters() const
    {16, 201, 0, 0, Smoke::mf_const, 265, 13},	//219 Phonon::MediaController::currentChapter() const
    {16, 327, 137, 1, Smoke::mf_static, 130, 14},	//220 Phonon::MediaController::navigationMenuToString(Phonon::MediaController::NavigationMenu)
    {16, 168, 0, 0, Smoke::mf_const, 104, 15},	//221 Phonon::MediaController::availableMenus() const
    {16, 173, 0, 0, Smoke::mf_const, 265, 16},	//222 Phonon::MediaController::availableTitles() const
    {16, 207, 0, 0, Smoke::mf_const, 265, 17},	//223 Phonon::MediaController::currentTitle() const
    {16, 159, 0, 0, Smoke::mf_const, 216, 18},	//224 Phonon::MediaController::autoplayTitles() const
    {16, 200, 0, 0, Smoke::mf_const, 46, 19},	//225 Phonon::MediaController::currentAudioChannel() const
    {16, 205, 0, 0, Smoke::mf_const, 49, 20},	//226 Phonon::MediaController::currentSubtitle() const
    {16, 503, 0, 0, Smoke::mf_const, 216, 21},	//227 Phonon::MediaController::subtitleAutodetect() const
    {16, 504, 0, 0, Smoke::mf_const, 130, 22},	//228 Phonon::MediaController::subtitleEncoding() const
    {16, 505, 0, 0, Smoke::mf_const, 93, 23},	//229 Phonon::MediaController::subtitleFont() const
    {16, 163, 0, 0, Smoke::mf_const, 106, 24},	//230 Phonon::MediaController::availableAudioChannels() const
    {16, 171, 0, 0, Smoke::mf_const, 107, 25},	//231 Phonon::MediaController::availableSubtitles() const
    {16, 412, 139, 1, 0, 0, 26},	//232 Phonon::MediaController::setCurrentAudioChannel(const Phonon::ObjectDescription<Phonon::AudioChannelType>&)
    {16, 416, 137, 1, 0, 0, 27},	//233 Phonon::MediaController::setCurrentMenu(Phonon::MediaController::NavigationMenu)
    {16, 420, 141, 1, 0, 0, 28},	//234 Phonon::MediaController::setCurrentSubtitle(const Phonon::ObjectDescription<Phonon::SubtitleType>&)
    {16, 420, 143, 1, 0, 0, 29},	//235 Phonon::MediaController::setCurrentSubtitle(const QUrl&)
    {16, 471, 57, 1, 0, 0, 30},	//236 Phonon::MediaController::setSubtitleAutodetect(bool)
    {16, 473, 78, 1, 0, 0, 31},	//237 Phonon::MediaController::setSubtitleEncoding(const QString&)
    {16, 475, 145, 1, 0, 0, 32},	//238 Phonon::MediaController::setSubtitleFont(const QFont&)
    {16, 410, 71, 1, Smoke::mf_slot, 0, 33},	//239 Phonon::MediaController::setCurrentAngle(int)
    {16, 414, 71, 1, Smoke::mf_slot, 0, 34},	//240 Phonon::MediaController::setCurrentChapter(int)
    {16, 423, 71, 1, Smoke::mf_slot, 0, 35},	//241 Phonon::MediaController::setCurrentTitle(int)
    {16, 404, 57, 1, Smoke::mf_slot, 0, 36},	//242 Phonon::MediaController::setAutoplayTitles(bool)
    {16, 330, 0, 0, Smoke::mf_slot, 0, 37},	//243 Phonon::MediaController::nextTitle()
    {16, 365, 0, 0, Smoke::mf_slot, 0, 38},	//244 Phonon::MediaController::previousTitle()
    {16, 161, 71, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 39},	//245 Phonon::MediaController::availableAnglesChanged(int)
    {16, 164, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 40},	//246 Phonon::MediaController::availableAudioChannelsChanged()
    {16, 166, 71, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 41},	//247 Phonon::MediaController::availableChaptersChanged(int)
    {16, 169, 147, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 42},	//248 Phonon::MediaController::availableMenusChanged(QList<Phonon::MediaController::NavigationMenu>)
    {16, 172, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 43},	//249 Phonon::MediaController::availableSubtitlesChanged()
    {16, 174, 71, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 44},	//250 Phonon::MediaController::availableTitlesChanged(int)
    {16, 152, 71, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 45},	//251 Phonon::MediaController::angleChanged(int)
    {16, 183, 71, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 46},	//252 Phonon::MediaController::chapterChanged(int)
    {16, 513, 71, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 47},	//253 Phonon::MediaController::titleChanged(int)
    {16, 520, 37, 1, Smoke::mf_static, 130, 48},	//254 Phonon::MediaController::tr(const char*)
    {16, 524, 37, 1, Smoke::mf_static, 130, 49},	//255 Phonon::MediaController::trUtf8(const char*)
    {16, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 50},	//256 Phonon::MediaController::staticMetaObject() const
    {16, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 31, 51},	//257 Phonon::MediaController::Angles (enum)
    {16, 36, 0, 0, Smoke::mf_static|Smoke::mf_enum, 31, 52},	//258 Phonon::MediaController::Chapters (enum)
    {16, 96, 0, 0, Smoke::mf_static|Smoke::mf_enum, 31, 53},	//259 Phonon::MediaController::Navigations (enum)
    {16, 130, 0, 0, Smoke::mf_static|Smoke::mf_enum, 31, 54},	//260 Phonon::MediaController::Titles (enum)
    {16, 126, 0, 0, Smoke::mf_static|Smoke::mf_enum, 31, 55},	//261 Phonon::MediaController::Subtitles (enum)
    {16, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 31, 56},	//262 Phonon::MediaController::AudioChannels (enum)
    {16, 115, 0, 0, Smoke::mf_static|Smoke::mf_enum, 32, 57},	//263 Phonon::MediaController::RootMenu (enum)
    {16, 128, 0, 0, Smoke::mf_static|Smoke::mf_enum, 32, 58},	//264 Phonon::MediaController::TitleMenu (enum)
    {16, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 32, 59},	//265 Phonon::MediaController::AudioMenu (enum)
    {16, 124, 0, 0, Smoke::mf_static|Smoke::mf_enum, 32, 60},	//266 Phonon::MediaController::SubtitleMenu (enum)
    {16, 35, 0, 0, Smoke::mf_static|Smoke::mf_enum, 32, 61},	//267 Phonon::MediaController::ChapterMenu (enum)
    {16, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 32, 62},	//268 Phonon::MediaController::AngleMenu (enum)
    {16, 554, 0, 0, Smoke::mf_dtor, 0, 63 },	//269 Phonon::MediaController::~MediaController()
    {17, 290, 0, 0, Smoke::mf_const, 216, 1},	//270 Phonon::MediaNode::isValid() const
    {17, 277, 0, 0, Smoke::mf_const, 108, 2},	//271 Phonon::MediaNode::inputPaths() const
    {17, 349, 0, 0, Smoke::mf_const, 108, 3},	//272 Phonon::MediaNode::outputPaths() const
    {17, 82, 149, 1, Smoke::mf_ctor|Smoke::mf_protected, 33, 4},	//273 Phonon::MediaNode::MediaNode(Phonon::MediaNodePrivate&)
    {17, 82, 151, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 33, 5},	//274 Phonon::MediaNode::MediaNode(const Phonon::MediaNode&)
    {17, 555, 0, 0, Smoke::mf_dtor, 0, 6 },	//275 Phonon::MediaNode::~MediaNode()
    {19, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//276 Phonon::MediaObject::metaObject() const
    {19, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//277 Phonon::MediaObject::qt_metacast(const char*)
    {19, 520, 39, 2, Smoke::mf_static, 130, 3},	//278 Phonon::MediaObject::tr(const char*, const char*)
    {19, 524, 39, 2, Smoke::mf_static, 130, 4},	//279 Phonon::MediaObject::trUtf8(const char*, const char*)
    {19, 520, 42, 3, Smoke::mf_static, 130, 5},	//280 Phonon::MediaObject::tr(const char*, const char*, int)
    {19, 524, 42, 3, Smoke::mf_static, 130, 6},	//281 Phonon::MediaObject::trUtf8(const char*, const char*, int)
    {19, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//282 Phonon::MediaObject::qt_metacall(QMetaObject::Call, int, void**)
    {19, 84, 53, 1, Smoke::mf_ctor, 35, 8},	//283 Phonon::MediaObject::MediaObject(QObject*)
    {19, 494, 0, 0, Smoke::mf_const, 60, 9},	//284 Phonon::MediaObject::state() const
    {19, 266, 0, 0, Smoke::mf_const, 216, 10},	//285 Phonon::MediaObject::hasVideo() const
    {19, 289, 0, 0, Smoke::mf_const, 216, 11},	//286 Phonon::MediaObject::isSeekable() const
    {19, 511, 0, 0, Smoke::mf_const, 265, 12},	//287 Phonon::MediaObject::tickInterval() const
    {19, 300, 78, 1, Smoke::mf_const, 131, 13},	//288 Phonon::MediaObject::metaData(const QString&) const
    {19, 300, 153, 1, Smoke::mf_const, 131, 14},	//289 Phonon::MediaObject::metaData(Phonon::MetaData) const
    {19, 300, 0, 0, Smoke::mf_const, 120, 15},	//290 Phonon::MediaObject::metaData() const
    {19, 242, 0, 0, Smoke::mf_const, 130, 16},	//291 Phonon::MediaObject::errorString() const
    {19, 243, 0, 0, Smoke::mf_const, 29, 17},	//292 Phonon::MediaObject::errorType() const
    {19, 202, 0, 0, Smoke::mf_const, 36, 18},	//293 Phonon::MediaObject::currentSource() const
    {19, 418, 155, 1, 0, 0, 19},	//294 Phonon::MediaObject::setCurrentSource(const Phonon::MediaSource&)
    {19, 375, 0, 0, Smoke::mf_const, 105, 20},	//295 Phonon::MediaObject::queue() const
    {19, 459, 157, 1, 0, 0, 21},	//296 Phonon::MediaObject::setQueue(const QList<Phonon::MediaSource>&)
    {19, 459, 159, 1, 0, 0, 22},	//297 Phonon::MediaObject::setQueue(const QList<QUrl>&)
    {19, 235, 155, 1, 0, 0, 23},	//298 Phonon::MediaObject::enqueue(const Phonon::MediaSource&)
    {19, 235, 157, 1, 0, 0, 24},	//299 Phonon::MediaObject::enqueue(const QList<Phonon::MediaSource>&)
    {19, 235, 159, 1, 0, 0, 25},	//300 Phonon::MediaObject::enqueue(const QList<QUrl>&)
    {19, 187, 0, 0, 0, 0, 26},	//301 Phonon::MediaObject::clearQueue()
    {19, 206, 0, 0, Smoke::mf_const, 266, 27},	//302 Phonon::MediaObject::currentTime() const
    {19, 517, 0, 0, Smoke::mf_const, 266, 28},	//303 Phonon::MediaObject::totalTime() const
    {19, 379, 0, 0, Smoke::mf_const, 266, 29},	//304 Phonon::MediaObject::remainingTime() const
    {19, 362, 0, 0, Smoke::mf_const, 265, 30},	//305 Phonon::MediaObject::prefinishMark() const
    {19, 457, 71, 1, 0, 0, 31},	//306 Phonon::MediaObject::setPrefinishMark(int)
    {19, 528, 0, 0, Smoke::mf_const, 265, 32},	//307 Phonon::MediaObject::transitionTime() const
    {19, 481, 71, 1, 0, 0, 33},	//308 Phonon::MediaObject::setTransitionTime(int)
    {19, 477, 161, 1, Smoke::mf_property|Smoke::mf_slot, 0, 34},	//309 Phonon::MediaObject::setTickInterval(qint32)
    {19, 359, 0, 0, Smoke::mf_slot, 0, 35},	//310 Phonon::MediaObject::play()
    {19, 357, 0, 0, Smoke::mf_slot, 0, 36},	//311 Phonon::MediaObject::pause()
    {19, 498, 0, 0, Smoke::mf_slot, 0, 37},	//312 Phonon::MediaObject::stop()
    {19, 392, 163, 1, Smoke::mf_slot, 0, 38},	//313 Phonon::MediaObject::seek(qint64)
    {19, 186, 0, 0, Smoke::mf_slot, 0, 39},	//314 Phonon::MediaObject::clear()
    {19, 495, 165, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 40},	//315 Phonon::MediaObject::stateChanged(Phonon::State, Phonon::State)
    {19, 509, 163, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 41},	//316 Phonon::MediaObject::tick(qint64)
    {19, 302, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 42},	//317 Phonon::MediaObject::metaDataChanged()
    {19, 396, 57, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 43},	//318 Phonon::MediaObject::seekableChanged(bool)
    {19, 267, 57, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 44},	//319 Phonon::MediaObject::hasVideoChanged(bool)
    {19, 177, 71, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 45},	//320 Phonon::MediaObject::bufferStatus(int)
    {19, 256, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 46},	//321 Phonon::MediaObject::finished()
    {19, 203, 155, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 47},	//322 Phonon::MediaObject::currentSourceChanged(const Phonon::MediaSource&)
    {19, 150, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 48},	//323 Phonon::MediaObject::aboutToFinish()
    {19, 363, 161, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 49},	//324 Phonon::MediaObject::prefinishMarkReached(qint32)
    {19, 518, 163, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 50},	//325 Phonon::MediaObject::totalTimeChanged(qint64)
    {19, 520, 37, 1, Smoke::mf_static, 130, 51},	//326 Phonon::MediaObject::tr(const char*)
    {19, 524, 37, 1, Smoke::mf_static, 130, 52},	//327 Phonon::MediaObject::trUtf8(const char*)
    {19, 84, 0, 0, Smoke::mf_ctor, 35, 53},	//328 Phonon::MediaObject::MediaObject()
    {19, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 54},	//329 Phonon::MediaObject::staticMetaObject() const
    {19, 556, 0, 0, Smoke::mf_dtor, 0, 55 },	//330 Phonon::MediaObject::~MediaObject()
    {20, 86, 0, 0, Smoke::mf_ctor, 38, 1},	//331 Phonon::MediaSource::MediaSource()
    {20, 86, 78, 1, Smoke::mf_ctor, 38, 2},	//332 Phonon::MediaSource::MediaSource(const QString&)
    {20, 86, 143, 1, Smoke::mf_ctor, 38, 3},	//333 Phonon::MediaSource::MediaSource(const QUrl&)
    {20, 86, 168, 2, Smoke::mf_ctor, 38, 4},	//334 Phonon::MediaSource::MediaSource(Phonon::DiscType, const QString&)
    {20, 86, 171, 1, Smoke::mf_ctor, 38, 5},	//335 Phonon::MediaSource::MediaSource(const Phonon::ObjectDescription<Phonon::AudioCaptureDeviceType>&)
    {20, 86, 173, 1, Smoke::mf_ctor, 38, 6},	//336 Phonon::MediaSource::MediaSource(const Phonon::ObjectDescription<Phonon::VideoCaptureDeviceType>&)
    {20, 86, 175, 2, Smoke::mf_ctor, 38, 7},	//337 Phonon::MediaSource::MediaSource(Phonon::Capture::DeviceType, Phonon::CaptureCategory)
    {20, 86, 11, 1, Smoke::mf_ctor, 38, 8},	//338 Phonon::MediaSource::MediaSource(Phonon::CaptureCategory)
    {20, 86, 178, 1, Smoke::mf_ctor, 38, 9},	//339 Phonon::MediaSource::MediaSource(Phonon::AbstractMediaStream*)
    {20, 86, 180, 1, Smoke::mf_ctor, 38, 10},	//340 Phonon::MediaSource::MediaSource(QIODevice*)
    {20, 86, 155, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 38, 11},	//341 Phonon::MediaSource::MediaSource(const Phonon::MediaSource&)
    {20, 338, 155, 1, 0, 37, 12},	//342 Phonon::MediaSource::operator=(const Phonon::MediaSource&)
    {20, 341, 155, 1, Smoke::mf_const, 216, 13},	//343 Phonon::MediaSource::operator==(const Phonon::MediaSource&) const
    {20, 402, 57, 1, 0, 0, 14},	//344 Phonon::MediaSource::setAutoDelete(bool)
    {20, 158, 0, 0, Smoke::mf_const, 216, 15},	//345 Phonon::MediaSource::autoDelete() const
    {20, 532, 0, 0, Smoke::mf_const, 39, 16},	//346 Phonon::MediaSource::type() const
    {20, 255, 0, 0, Smoke::mf_const, 130, 17},	//347 Phonon::MediaSource::fileName() const
    {20, 323, 0, 0, Smoke::mf_const, 42, 18},	//348 Phonon::MediaSource::mrl() const
    {20, 533, 0, 0, Smoke::mf_const, 136, 19},	//349 Phonon::MediaSource::url() const
    {20, 220, 0, 0, Smoke::mf_const, 19, 20},	//350 Phonon::MediaSource::discType() const
    {20, 218, 0, 0, Smoke::mf_const, 245, 21},	//351 Phonon::MediaSource::deviceAccessList() const
    {20, 535, 0, 0, Smoke::mf_const, 245, 22},	//352 Phonon::MediaSource::videoDeviceAccessList() const
    {20, 156, 0, 0, Smoke::mf_const, 245, 23},	//353 Phonon::MediaSource::audioDeviceAccessList() const
    {20, 219, 0, 0, Smoke::mf_const, 130, 24},	//354 Phonon::MediaSource::deviceName() const
    {20, 499, 0, 0, Smoke::mf_const, 3, 25},	//355 Phonon::MediaSource::stream() const
    {20, 155, 0, 0, Smoke::mf_const, 45, 26},	//356 Phonon::MediaSource::audioCaptureDevice() const
    {20, 534, 0, 0, Smoke::mf_const, 50, 27},	//357 Phonon::MediaSource::videoCaptureDevice() const
    {20, 86, 182, 1, Smoke::mf_ctor|Smoke::mf_protected, 38, 28},	//358 Phonon::MediaSource::MediaSource(Phonon::MediaSourcePrivate&)
    {20, 86, 184, 1, Smoke::mf_ctor|Smoke::mf_protected, 38, 29},	//359 Phonon::MediaSource::MediaSource(const QPair<QByteArray,QString>&)
    {20, 86, 186, 1, Smoke::mf_ctor, 38, 30},	//360 Phonon::MediaSource::MediaSource(Phonon::DiscType)
    {20, 86, 188, 1, Smoke::mf_ctor, 38, 31},	//361 Phonon::MediaSource::MediaSource(Phonon::Capture::DeviceType)
    {20, 73, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 32},	//362 Phonon::MediaSource::Invalid (enum)
    {20, 78, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 33},	//363 Phonon::MediaSource::LocalFile (enum)
    {20, 133, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 34},	//364 Phonon::MediaSource::Url (enum)
    {20, 42, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 35},	//365 Phonon::MediaSource::Disc (enum)
    {20, 121, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 36},	//366 Phonon::MediaSource::Stream (enum)
    {20, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 37},	//367 Phonon::MediaSource::CaptureDevice (enum)
    {20, 61, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 38},	//368 Phonon::MediaSource::Empty (enum)
    {20, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 39},	//369 Phonon::MediaSource::AudioVideoCapture (enum)
    {20, 557, 0, 0, Smoke::mf_dtor, 0, 40 },	//370 Phonon::MediaSource::~MediaSource()
    {22, 91, 0, 0, Smoke::mf_ctor, 44, 1},	//371 Phonon::Mrl::Mrl()
    {22, 91, 190, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 44, 2},	//372 Phonon::Mrl::Mrl(const Phonon::Mrl&)
    {22, 91, 143, 1, Smoke::mf_ctor, 44, 3},	//373 Phonon::Mrl::Mrl(const QUrl&)
    {22, 91, 78, 1, Smoke::mf_ctor, 44, 4},	//374 Phonon::Mrl::Mrl(const QString&)
    {22, 338, 190, 1, 0, 43, 5},	//375 Phonon::Mrl::operator=(const Phonon::Mrl&)
    {22, 338, 78, 1, 0, 43, 6},	//376 Phonon::Mrl::operator=(const QString&)
    {22, 515, 192, 1, Smoke::mf_const, 76, 7},	//377 Phonon::Mrl::toEncoded(QFlags<QUrl::FormattingOption>) const
    {22, 515, 0, 0, Smoke::mf_const, 76, 8},	//378 Phonon::Mrl::toEncoded() const
    {22, 558, 0, 0, Smoke::mf_dtor, 0, 9 },	//379 Phonon::Mrl::~Mrl()
    {23, 341, 194, 1, Smoke::mf_const, 216, 1},	//380 Phonon::ObjectDescriptionData::operator==(const Phonon::ObjectDescriptionData&) const
    {23, 326, 0, 0, Smoke::mf_const, 130, 2},	//381 Phonon::ObjectDescriptionData::name() const
    {23, 216, 0, 0, Smoke::mf_const, 130, 3},	//382 Phonon::ObjectDescriptionData::description() const
    {23, 366, 37, 1, Smoke::mf_const, 138, 4},	//383 Phonon::ObjectDescriptionData::property(const char*) const
    {23, 368, 0, 0, Smoke::mf_const, 110, 5},	//384 Phonon::ObjectDescriptionData::propertyNames() const
    {23, 290, 0, 0, Smoke::mf_const, 216, 6},	//385 Phonon::ObjectDescriptionData::isValid() const
    {23, 274, 0, 0, Smoke::mf_const, 265, 7},	//386 Phonon::ObjectDescriptionData::index() const
    {23, 263, 196, 2, Smoke::mf_static, 52, 8},	//387 Phonon::ObjectDescriptionData::fromIndex(Phonon::ObjectDescriptionType, int)
    {23, 103, 199, 1, Smoke::mf_ctor, 52, 9},	//388 Phonon::ObjectDescriptionData::ObjectDescriptionData(Phonon::ObjectDescriptionPrivate*)
    {23, 103, 201, 2, Smoke::mf_ctor, 52, 10},	//389 Phonon::ObjectDescriptionData::ObjectDescriptionData(int, const QHash<QByteArray,QVariant>&)
    {23, 103, 194, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 52, 11},	//390 Phonon::ObjectDescriptionData::ObjectDescriptionData(const Phonon::ObjectDescriptionData&)
    {23, 103, 0, 0, Smoke::mf_ctor, 52, 12},	//391 Phonon::ObjectDescriptionData::ObjectDescriptionData()
    {23, 559, 0, 0, Smoke::mf_dtor, 0, 13 },	//392 Phonon::ObjectDescriptionData::~ObjectDescriptionData()
    {24, 387, 204, 1, Smoke::mf_const, 265, 1},	//393 Phonon::ObjectDescriptionModelData::rowCount(const QModelIndex&) const
    {24, 209, 206, 2, Smoke::mf_const, 138, 2},	//394 Phonon::ObjectDescriptionModelData::data(const QModelIndex&, int) const
    {24, 257, 204, 1, Smoke::mf_const, 91, 3},	//395 Phonon::ObjectDescriptionModelData::flags(const QModelIndex&) const
    {24, 531, 0, 0, Smoke::mf_const, 113, 4},	//396 Phonon::ObjectDescriptionModelData::tupleIndexOrder() const
    {24, 529, 71, 1, Smoke::mf_const, 265, 5},	//397 Phonon::ObjectDescriptionModelData::tupleIndexAtPositionIndex(int) const
    {24, 305, 209, 2, Smoke::mf_const, 116, 6},	//398 Phonon::ObjectDescriptionModelData::mimeData(Phonon::ObjectDescriptionType, const QList<QModelIndex>&) const
    {24, 321, 204, 1, 0, 0, 7},	//399 Phonon::ObjectDescriptionModelData::moveUp(const QModelIndex&)
    {24, 318, 204, 1, 0, 0, 8},	//400 Phonon::ObjectDescriptionModelData::moveDown(const QModelIndex&)
    {24, 441, 212, 1, 0, 0, 9},	//401 Phonon::ObjectDescriptionModelData::setModelData(const QList<QExplicitlySharedDataPointer<Phonon::ObjectDescriptionData> >&)
    {24, 311, 0, 0, Smoke::mf_const, 111, 10},	//402 Phonon::ObjectDescriptionModelData::modelData() const
    {24, 311, 204, 1, Smoke::mf_const, 86, 11},	//403 Phonon::ObjectDescriptionModelData::modelData(const QModelIndex&) const
    {24, 506, 0, 0, Smoke::mf_const, 90, 12},	//404 Phonon::ObjectDescriptionModelData::supportedDropActions() const
    {24, 227, 214, 6, 0, 216, 13},	//405 Phonon::ObjectDescriptionModelData::dropMimeData(Phonon::ObjectDescriptionType, const QMimeData*, Qt::DropAction, int, int, const QModelIndex&)
    {24, 382, 221, 3, 0, 216, 14},	//406 Phonon::ObjectDescriptionModelData::removeRows(int, int, const QModelIndex&)
    {24, 307, 225, 1, Smoke::mf_const, 131, 15},	//407 Phonon::ObjectDescriptionModelData::mimeTypes(Phonon::ObjectDescriptionType) const
    {24, 106, 227, 1, Smoke::mf_ctor, 53, 16},	//408 Phonon::ObjectDescriptionModelData::ObjectDescriptionModelData(QAbstractListModel*)
    {24, 106, 229, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 53, 17},	//409 Phonon::ObjectDescriptionModelData::ObjectDescriptionModelData(const Phonon::ObjectDescriptionModelData&)
    {24, 387, 0, 0, Smoke::mf_const, 265, 18},	//410 Phonon::ObjectDescriptionModelData::rowCount() const
    {24, 209, 204, 1, Smoke::mf_const, 138, 19},	//411 Phonon::ObjectDescriptionModelData::data(const QModelIndex&) const
    {24, 382, 231, 2, 0, 216, 20},	//412 Phonon::ObjectDescriptionModelData::removeRows(int, int)
    {24, 560, 0, 0, Smoke::mf_dtor, 0, 21 },	//413 Phonon::ObjectDescriptionModelData::~ObjectDescriptionModelData()
    {26, 108, 0, 0, Smoke::mf_ctor, 58, 1},	//414 Phonon::Path::Path()
    {26, 108, 234, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 58, 2},	//415 Phonon::Path::Path(const Phonon::Path&)
    {26, 290, 0, 0, Smoke::mf_const, 216, 3},	//416 Phonon::Path::isValid() const
    {26, 278, 236, 2, 0, 20, 4},	//417 Phonon::Path::insertEffect(const Phonon::ObjectDescription<Phonon::EffectType>&, Phonon::Effect*)
    {26, 278, 239, 2, 0, 216, 5},	//418 Phonon::Path::insertEffect(Phonon::Effect*, Phonon::Effect*)
    {26, 380, 133, 1, 0, 216, 6},	//419 Phonon::Path::removeEffect(Phonon::Effect*)
    {26, 229, 0, 0, Smoke::mf_const, 101, 7},	//420 Phonon::Path::effects() const
    {26, 376, 19, 2, 0, 216, 8},	//421 Phonon::Path::reconnect(Phonon::MediaNode*, Phonon::MediaNode*)
    {26, 221, 0, 0, 0, 216, 9},	//422 Phonon::Path::disconnect()
    {26, 338, 234, 1, 0, 57, 10},	//423 Phonon::Path::operator=(const Phonon::Path&)
    {26, 341, 234, 1, Smoke::mf_const, 216, 11},	//424 Phonon::Path::operator==(const Phonon::Path&) const
    {26, 331, 234, 1, Smoke::mf_const, 216, 12},	//425 Phonon::Path::operator!=(const Phonon::Path&) const
    {26, 493, 0, 0, Smoke::mf_const, 33, 13},	//426 Phonon::Path::source() const
    {26, 490, 0, 0, Smoke::mf_const, 33, 14},	//427 Phonon::Path::sink() const
    {26, 278, 93, 1, 0, 20, 15},	//428 Phonon::Path::insertEffect(const Phonon::ObjectDescription<Phonon::EffectType>&)
    {26, 278, 133, 1, 0, 216, 16},	//429 Phonon::Path::insertEffect(Phonon::Effect*)
    {26, 561, 0, 0, Smoke::mf_dtor, 0, 17 },	//430 Phonon::Path::~Path()
    {27, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//431 Phonon::SeekSlider::metaObject() const
    {27, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//432 Phonon::SeekSlider::qt_metacast(const char*)
    {27, 520, 39, 2, Smoke::mf_static, 130, 3},	//433 Phonon::SeekSlider::tr(const char*, const char*)
    {27, 524, 39, 2, Smoke::mf_static, 130, 4},	//434 Phonon::SeekSlider::trUtf8(const char*, const char*)
    {27, 520, 42, 3, Smoke::mf_static, 130, 5},	//435 Phonon::SeekSlider::tr(const char*, const char*, int)
    {27, 524, 42, 3, Smoke::mf_static, 130, 6},	//436 Phonon::SeekSlider::trUtf8(const char*, const char*, int)
    {27, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//437 Phonon::SeekSlider::qt_metacall(QMetaObject::Call, int, void**)
    {27, 117, 242, 1, Smoke::mf_ctor, 59, 8},	//438 Phonon::SeekSlider::SeekSlider(QWidget*)
    {27, 117, 244, 2, Smoke::mf_ctor, 59, 9},	//439 Phonon::SeekSlider::SeekSlider(Phonon::MediaObject*, QWidget*)
    {27, 265, 0, 0, Smoke::mf_const|Smoke::mf_property, 216, 10},	//440 Phonon::SeekSlider::hasTracking() const
    {27, 479, 57, 1, Smoke::mf_property, 0, 11},	//441 Phonon::SeekSlider::setTracking(bool)
    {27, 350, 0, 0, Smoke::mf_const|Smoke::mf_property, 265, 12},	//442 Phonon::SeekSlider::pageStep() const
    {27, 453, 71, 1, Smoke::mf_property, 0, 13},	//443 Phonon::SeekSlider::setPageStep(int)
    {27, 489, 0, 0, Smoke::mf_const|Smoke::mf_property, 265, 14},	//444 Phonon::SeekSlider::singleStep() const
    {27, 465, 71, 1, Smoke::mf_property, 0, 15},	//445 Phonon::SeekSlider::setSingleStep(int)
    {27, 345, 0, 0, Smoke::mf_const|Smoke::mf_property, 189, 16},	//446 Phonon::SeekSlider::orientation() const
    {27, 283, 0, 0, Smoke::mf_const|Smoke::mf_property, 216, 17},	//447 Phonon::SeekSlider::isIconVisible() const
    {27, 272, 0, 0, Smoke::mf_const|Smoke::mf_property, 129, 18},	//448 Phonon::SeekSlider::iconSize() const
    {27, 299, 0, 0, Smoke::mf_const, 35, 19},	//449 Phonon::SeekSlider::mediaObject() const
    {27, 449, 247, 1, Smoke::mf_property|Smoke::mf_slot, 0, 20},	//450 Phonon::SeekSlider::setOrientation(Qt::Orientation)
    {27, 435, 57, 1, Smoke::mf_property|Smoke::mf_slot, 0, 21},	//451 Phonon::SeekSlider::setIconVisible(bool)
    {27, 433, 249, 1, Smoke::mf_property|Smoke::mf_slot, 0, 22},	//452 Phonon::SeekSlider::setIconSize(const QSize&)
    {27, 439, 135, 1, Smoke::mf_slot, 0, 23},	//453 Phonon::SeekSlider::setMediaObject(Phonon::MediaObject*)
    {27, 520, 37, 1, Smoke::mf_static, 130, 24},	//454 Phonon::SeekSlider::tr(const char*)
    {27, 524, 37, 1, Smoke::mf_static, 130, 25},	//455 Phonon::SeekSlider::trUtf8(const char*)
    {27, 117, 0, 0, Smoke::mf_ctor, 59, 26},	//456 Phonon::SeekSlider::SeekSlider()
    {27, 117, 135, 1, Smoke::mf_ctor, 59, 27},	//457 Phonon::SeekSlider::SeekSlider(Phonon::MediaObject*)
    {27, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 28},	//458 Phonon::SeekSlider::staticMetaObject() const
    {27, 562, 0, 0, Smoke::mf_dtor, 0, 29 },	//459 Phonon::SeekSlider::~SeekSlider()
    {28, 543, 59, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 1},	//460 Phonon::StreamInterface::writeData(const QByteArray&) [pure virtual]
    {28, 231, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 2},	//461 Phonon::StreamInterface::endOfData() [pure virtual]
    {28, 469, 55, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 3},	//462 Phonon::StreamInterface::setStreamSize(long long) [pure virtual]
    {28, 467, 57, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 4},	//463 Phonon::StreamInterface::setStreamSeekable(bool) [pure virtual]
    {28, 190, 155, 1, 0, 0, 5},	//464 Phonon::StreamInterface::connectToSource(const Phonon::MediaSource&)
    {28, 329, 0, 0, 0, 0, 6},	//465 Phonon::StreamInterface::needData()
    {28, 234, 0, 0, 0, 0, 7},	//466 Phonon::StreamInterface::enoughData()
    {28, 394, 55, 1, 0, 0, 8},	//467 Phonon::StreamInterface::seekStream(long long)
    {28, 385, 0, 0, 0, 0, 9},	//468 Phonon::StreamInterface::reset()
    {28, 122, 0, 0, Smoke::mf_ctor|Smoke::mf_protected, 61, 10},	//469 Phonon::StreamInterface::StreamInterface()
    {28, 122, 251, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 61, 11},	//470 Phonon::StreamInterface::StreamInterface(const Phonon::StreamInterface&)
    {28, 563, 0, 0, Smoke::mf_dtor, 0, 12 },	//471 Phonon::StreamInterface::~StreamInterface()
    {29, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//472 Phonon::VideoPlayer::metaObject() const
    {29, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//473 Phonon::VideoPlayer::qt_metacast(const char*)
    {29, 520, 39, 2, Smoke::mf_static, 130, 3},	//474 Phonon::VideoPlayer::tr(const char*, const char*)
    {29, 524, 39, 2, Smoke::mf_static, 130, 4},	//475 Phonon::VideoPlayer::trUtf8(const char*, const char*)
    {29, 520, 42, 3, Smoke::mf_static, 130, 5},	//476 Phonon::VideoPlayer::tr(const char*, const char*, int)
    {29, 524, 42, 3, Smoke::mf_static, 130, 6},	//477 Phonon::VideoPlayer::trUtf8(const char*, const char*, int)
    {29, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//478 Phonon::VideoPlayer::qt_metacall(QMetaObject::Call, int, void**)
    {29, 137, 253, 2, Smoke::mf_ctor, 65, 8},	//479 Phonon::VideoPlayer::VideoPlayer(Phonon::Category, QWidget*)
    {29, 137, 242, 1, Smoke::mf_ctor, 65, 9},	//480 Phonon::VideoPlayer::VideoPlayer(QWidget*)
    {29, 517, 0, 0, Smoke::mf_const, 266, 10},	//481 Phonon::VideoPlayer::totalTime() const
    {29, 206, 0, 0, Smoke::mf_const, 266, 11},	//482 Phonon::VideoPlayer::currentTime() const
    {29, 537, 0, 0, Smoke::mf_const, 264, 12},	//483 Phonon::VideoPlayer::volume() const
    {29, 288, 0, 0, Smoke::mf_const, 216, 13},	//484 Phonon::VideoPlayer::isPlaying() const
    {29, 287, 0, 0, Smoke::mf_const, 216, 14},	//485 Phonon::VideoPlayer::isPaused() const
    {29, 299, 0, 0, Smoke::mf_const, 35, 15},	//486 Phonon::VideoPlayer::mediaObject() const
    {29, 157, 0, 0, Smoke::mf_const, 12, 16},	//487 Phonon::VideoPlayer::audioOutput() const
    {29, 536, 0, 0, Smoke::mf_const, 66, 17},	//488 Phonon::VideoPlayer::videoWidget() const
    {29, 295, 155, 1, Smoke::mf_slot, 0, 18},	//489 Phonon::VideoPlayer::load(const Phonon::MediaSource&)
    {29, 359, 155, 1, Smoke::mf_slot, 0, 19},	//490 Phonon::VideoPlayer::play(const Phonon::MediaSource&)
    {29, 359, 0, 0, Smoke::mf_slot, 0, 20},	//491 Phonon::VideoPlayer::play()
    {29, 357, 0, 0, Smoke::mf_slot, 0, 21},	//492 Phonon::VideoPlayer::pause()
    {29, 498, 0, 0, Smoke::mf_slot, 0, 22},	//493 Phonon::VideoPlayer::stop()
    {29, 392, 163, 1, Smoke::mf_slot, 0, 23},	//494 Phonon::VideoPlayer::seek(qint64)
    {29, 484, 256, 1, Smoke::mf_slot, 0, 24},	//495 Phonon::VideoPlayer::setVolume(float)
    {29, 256, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 25},	//496 Phonon::VideoPlayer::finished()
    {29, 244, 258, 1, Smoke::mf_protected|Smoke::mf_virtual, 216, 26},	//497 Phonon::VideoPlayer::event(QEvent*)
    {29, 520, 37, 1, Smoke::mf_static, 130, 27},	//498 Phonon::VideoPlayer::tr(const char*)
    {29, 524, 37, 1, Smoke::mf_static, 130, 28},	//499 Phonon::VideoPlayer::trUtf8(const char*)
    {29, 137, 4, 1, Smoke::mf_ctor, 65, 29},	//500 Phonon::VideoPlayer::VideoPlayer(Phonon::Category)
    {29, 137, 0, 0, Smoke::mf_ctor, 65, 30},	//501 Phonon::VideoPlayer::VideoPlayer()
    {29, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 31},	//502 Phonon::VideoPlayer::staticMetaObject() const
    {29, 564, 0, 0, Smoke::mf_dtor, 0, 32 },	//503 Phonon::VideoPlayer::~VideoPlayer()
    {30, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//504 Phonon::VideoWidget::metaObject() const
    {30, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//505 Phonon::VideoWidget::qt_metacast(const char*)
    {30, 520, 39, 2, Smoke::mf_static, 130, 3},	//506 Phonon::VideoWidget::tr(const char*, const char*)
    {30, 524, 39, 2, Smoke::mf_static, 130, 4},	//507 Phonon::VideoWidget::trUtf8(const char*, const char*)
    {30, 520, 42, 3, Smoke::mf_static, 130, 5},	//508 Phonon::VideoWidget::tr(const char*, const char*, int)
    {30, 524, 42, 3, Smoke::mf_static, 130, 6},	//509 Phonon::VideoWidget::trUtf8(const char*, const char*, int)
    {30, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//510 Phonon::VideoWidget::qt_metacall(QMetaObject::Call, int, void**)
    {30, 142, 242, 1, Smoke::mf_ctor, 66, 8},	//511 Phonon::VideoWidget::VideoWidget(QWidget*)
    {30, 154, 0, 0, Smoke::mf_const|Smoke::mf_property, 67, 9},	//512 Phonon::VideoWidget::aspectRatio() const
    {30, 391, 0, 0, Smoke::mf_const|Smoke::mf_property, 68, 10},	//513 Phonon::VideoWidget::scaleMode() const
    {30, 176, 0, 0, Smoke::mf_const, 263, 11},	//514 Phonon::VideoWidget::brightness() const
    {30, 193, 0, 0, Smoke::mf_const, 263, 12},	//515 Phonon::VideoWidget::contrast() const
    {30, 271, 0, 0, Smoke::mf_const, 263, 13},	//516 Phonon::VideoWidget::hue() const
    {30, 390, 0, 0, Smoke::mf_const, 263, 14},	//517 Phonon::VideoWidget::saturation() const
    {30, 492, 0, 0, Smoke::mf_const, 96, 15},	//518 Phonon::VideoWidget::snapshot() const
    {30, 429, 57, 1, Smoke::mf_property|Smoke::mf_slot, 0, 16},	//519 Phonon::VideoWidget::setFullScreen(bool)
    {30, 247, 0, 0, Smoke::mf_slot, 0, 17},	//520 Phonon::VideoWidget::exitFullScreen()
    {30, 239, 0, 0, Smoke::mf_slot, 0, 18},	//521 Phonon::VideoWidget::enterFullScreen()
    {30, 398, 260, 1, Smoke::mf_property|Smoke::mf_slot, 0, 19},	//522 Phonon::VideoWidget::setAspectRatio(Phonon::VideoWidget::AspectRatio)
    {30, 463, 262, 1, Smoke::mf_property|Smoke::mf_slot, 0, 20},	//523 Phonon::VideoWidget::setScaleMode(Phonon::VideoWidget::ScaleMode)
    {30, 406, 80, 1, Smoke::mf_property|Smoke::mf_slot, 0, 21},	//524 Phonon::VideoWidget::setBrightness(qreal)
    {30, 408, 80, 1, Smoke::mf_property|Smoke::mf_slot, 0, 22},	//525 Phonon::VideoWidget::setContrast(qreal)
    {30, 431, 80, 1, Smoke::mf_property|Smoke::mf_slot, 0, 23},	//526 Phonon::VideoWidget::setHue(qreal)
    {30, 461, 80, 1, Smoke::mf_property|Smoke::mf_slot, 0, 24},	//527 Phonon::VideoWidget::setSaturation(qreal)
    {30, 142, 264, 2, Smoke::mf_ctor|Smoke::mf_protected, 66, 25},	//528 Phonon::VideoWidget::VideoWidget(Phonon::VideoWidgetPrivate&, QWidget*)
    {30, 314, 267, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 26},	//529 Phonon::VideoWidget::mouseMoveEvent(QMouseEvent*)
    {30, 244, 258, 1, Smoke::mf_protected|Smoke::mf_virtual, 216, 27},	//530 Phonon::VideoWidget::event(QEvent*)
    {30, 520, 37, 1, Smoke::mf_static, 130, 28},	//531 Phonon::VideoWidget::tr(const char*)
    {30, 524, 37, 1, Smoke::mf_static, 130, 29},	//532 Phonon::VideoWidget::trUtf8(const char*)
    {30, 142, 0, 0, Smoke::mf_ctor, 66, 30},	//533 Phonon::VideoWidget::VideoWidget()
    {30, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 31},	//534 Phonon::VideoWidget::staticMetaObject() const
    {30, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 32},	//535 Phonon::VideoWidget::AspectRatioAuto (enum)
    {30, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 33},	//536 Phonon::VideoWidget::AspectRatioWidget (enum)
    {30, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 34},	//537 Phonon::VideoWidget::AspectRatio4_3 (enum)
    {30, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 35},	//538 Phonon::VideoWidget::AspectRatio16_9 (enum)
    {30, 68, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 36},	//539 Phonon::VideoWidget::FitInView (enum)
    {30, 116, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 37},	//540 Phonon::VideoWidget::ScaleAndCrop (enum)
    {30, 565, 0, 0, Smoke::mf_dtor, 0, 38 },	//541 Phonon::VideoWidget::~VideoWidget()
    {32, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//542 Phonon::VolumeFaderEffect::metaObject() const
    {32, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//543 Phonon::VolumeFaderEffect::qt_metacast(const char*)
    {32, 520, 39, 2, Smoke::mf_static, 130, 3},	//544 Phonon::VolumeFaderEffect::tr(const char*, const char*)
    {32, 524, 39, 2, Smoke::mf_static, 130, 4},	//545 Phonon::VolumeFaderEffect::trUtf8(const char*, const char*)
    {32, 520, 42, 3, Smoke::mf_static, 130, 5},	//546 Phonon::VolumeFaderEffect::tr(const char*, const char*, int)
    {32, 524, 42, 3, Smoke::mf_static, 130, 6},	//547 Phonon::VolumeFaderEffect::trUtf8(const char*, const char*, int)
    {32, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//548 Phonon::VolumeFaderEffect::qt_metacall(QMetaObject::Call, int, void**)
    {32, 145, 53, 1, Smoke::mf_ctor, 70, 8},	//549 Phonon::VolumeFaderEffect::VolumeFaderEffect(QObject*)
    {32, 537, 0, 0, Smoke::mf_const|Smoke::mf_property, 264, 9},	//550 Phonon::VolumeFaderEffect::volume() const
    {32, 540, 0, 0, Smoke::mf_const|Smoke::mf_property, 263, 10},	//551 Phonon::VolumeFaderEffect::volumeDecibel() const
    {32, 248, 0, 0, Smoke::mf_const|Smoke::mf_property, 71, 11},	//552 Phonon::VolumeFaderEffect::fadeCurve() const
    {32, 249, 71, 1, Smoke::mf_slot, 0, 12},	//553 Phonon::VolumeFaderEffect::fadeIn(int)
    {32, 251, 71, 1, Smoke::mf_slot, 0, 13},	//554 Phonon::VolumeFaderEffect::fadeOut(int)
    {32, 484, 256, 1, Smoke::mf_property|Smoke::mf_slot, 0, 14},	//555 Phonon::VolumeFaderEffect::setVolume(float)
    {32, 486, 269, 1, Smoke::mf_property|Smoke::mf_slot, 0, 15},	//556 Phonon::VolumeFaderEffect::setVolumeDecibel(double)
    {32, 427, 271, 1, Smoke::mf_property|Smoke::mf_slot, 0, 16},	//557 Phonon::VolumeFaderEffect::setFadeCurve(Phonon::VolumeFaderEffect::FadeCurve)
    {32, 253, 273, 2, Smoke::mf_slot, 0, 17},	//558 Phonon::VolumeFaderEffect::fadeTo(float, int)
    {32, 520, 37, 1, Smoke::mf_static, 130, 18},	//559 Phonon::VolumeFaderEffect::tr(const char*)
    {32, 524, 37, 1, Smoke::mf_static, 130, 19},	//560 Phonon::VolumeFaderEffect::trUtf8(const char*)
    {32, 145, 0, 0, Smoke::mf_ctor, 70, 20},	//561 Phonon::VolumeFaderEffect::VolumeFaderEffect()
    {32, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 21},	//562 Phonon::VolumeFaderEffect::staticMetaObject() const
    {32, 64, 0, 0, Smoke::mf_static|Smoke::mf_enum, 71, 22},	//563 Phonon::VolumeFaderEffect::Fade3Decibel (enum)
    {32, 65, 0, 0, Smoke::mf_static|Smoke::mf_enum, 71, 23},	//564 Phonon::VolumeFaderEffect::Fade6Decibel (enum)
    {32, 66, 0, 0, Smoke::mf_static|Smoke::mf_enum, 71, 24},	//565 Phonon::VolumeFaderEffect::Fade9Decibel (enum)
    {32, 63, 0, 0, Smoke::mf_static|Smoke::mf_enum, 71, 25},	//566 Phonon::VolumeFaderEffect::Fade12Decibel (enum)
    {32, 566, 0, 0, Smoke::mf_dtor, 0, 26 },	//567 Phonon::VolumeFaderEffect::~VolumeFaderEffect()
    {33, 303, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 250, 1},	//568 Phonon::VolumeSlider::metaObject() const
    {33, 373, 37, 1, Smoke::mf_virtual, 272, 2},	//569 Phonon::VolumeSlider::qt_metacast(const char*)
    {33, 520, 39, 2, Smoke::mf_static, 130, 3},	//570 Phonon::VolumeSlider::tr(const char*, const char*)
    {33, 524, 39, 2, Smoke::mf_static, 130, 4},	//571 Phonon::VolumeSlider::trUtf8(const char*, const char*)
    {33, 520, 42, 3, Smoke::mf_static, 130, 5},	//572 Phonon::VolumeSlider::tr(const char*, const char*, int)
    {33, 524, 42, 3, Smoke::mf_static, 130, 6},	//573 Phonon::VolumeSlider::trUtf8(const char*, const char*, int)
    {33, 371, 46, 3, Smoke::mf_virtual, 265, 7},	//574 Phonon::VolumeSlider::qt_metacall(QMetaObject::Call, int, void**)
    {33, 147, 242, 1, Smoke::mf_ctor, 72, 8},	//575 Phonon::VolumeSlider::VolumeSlider(QWidget*)
    {33, 147, 276, 2, Smoke::mf_ctor, 72, 9},	//576 Phonon::VolumeSlider::VolumeSlider(Phonon::AudioOutput*, QWidget*)
    {33, 265, 0, 0, Smoke::mf_const|Smoke::mf_property, 216, 10},	//577 Phonon::VolumeSlider::hasTracking() const
    {33, 479, 57, 1, Smoke::mf_property, 0, 11},	//578 Phonon::VolumeSlider::setTracking(bool)
    {33, 350, 0, 0, Smoke::mf_const|Smoke::mf_property, 265, 12},	//579 Phonon::VolumeSlider::pageStep() const
    {33, 453, 71, 1, Smoke::mf_property, 0, 13},	//580 Phonon::VolumeSlider::setPageStep(int)
    {33, 489, 0, 0, Smoke::mf_const|Smoke::mf_property, 265, 14},	//581 Phonon::VolumeSlider::singleStep() const
    {33, 465, 71, 1, Smoke::mf_property, 0, 15},	//582 Phonon::VolumeSlider::setSingleStep(int)
    {33, 285, 0, 0, Smoke::mf_const|Smoke::mf_property, 216, 16},	//583 Phonon::VolumeSlider::isMuteVisible() const
    {33, 272, 0, 0, Smoke::mf_const|Smoke::mf_property, 129, 17},	//584 Phonon::VolumeSlider::iconSize() const
    {33, 298, 0, 0, Smoke::mf_const, 263, 18},	//585 Phonon::VolumeSlider::maximumVolume() const
    {33, 345, 0, 0, Smoke::mf_const|Smoke::mf_property, 189, 19},	//586 Phonon::VolumeSlider::orientation() const
    {33, 157, 0, 0, Smoke::mf_const, 12, 20},	//587 Phonon::VolumeSlider::audioOutput() const
    {33, 437, 80, 1, Smoke::mf_property|Smoke::mf_slot, 0, 21},	//588 Phonon::VolumeSlider::setMaximumVolume(qreal)
    {33, 449, 247, 1, Smoke::mf_property|Smoke::mf_slot, 0, 22},	//589 Phonon::VolumeSlider::setOrientation(Qt::Orientation)
    {33, 443, 57, 1, Smoke::mf_property|Smoke::mf_slot, 0, 23},	//590 Phonon::VolumeSlider::setMuteVisible(bool)
    {33, 433, 249, 1, Smoke::mf_property|Smoke::mf_slot, 0, 24},	//591 Phonon::VolumeSlider::setIconSize(const QSize&)
    {33, 400, 279, 1, Smoke::mf_slot, 0, 25},	//592 Phonon::VolumeSlider::setAudioOutput(Phonon::AudioOutput*)
    {33, 520, 37, 1, Smoke::mf_static, 130, 26},	//593 Phonon::VolumeSlider::tr(const char*)
    {33, 524, 37, 1, Smoke::mf_static, 130, 27},	//594 Phonon::VolumeSlider::trUtf8(const char*)
    {33, 147, 0, 0, Smoke::mf_ctor, 72, 28},	//595 Phonon::VolumeSlider::VolumeSlider()
    {33, 147, 279, 1, Smoke::mf_ctor, 72, 29},	//596 Phonon::VolumeSlider::VolumeSlider(Phonon::AudioOutput*)
    {33, 497, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 249, 30},	//597 Phonon::VolumeSlider::staticMetaObject() const
    {33, 567, 0, 0, Smoke::mf_dtor, 0, 31 },	//598 Phonon::VolumeSlider::~VolumeSlider()
    {60, 244, 258, 1, Smoke::mf_virtual, 216, 0},	//599 QObject::event(QEvent*)
    {60, 246, 281, 2, Smoke::mf_virtual, 216, 0},	//600 QObject::eventFilter(QObject*, QEvent*)
    {60, 512, 284, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//601 QObject::timerEvent(QTimerEvent*)
    {60, 185, 286, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//602 QObject::childEvent(QChildEvent*)
    {60, 208, 258, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//603 QObject::customEvent(QEvent*)
    {60, 189, 37, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//604 QObject::connectNotify(const char*)
    {60, 222, 37, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//605 QObject::disconnectNotify(const char*)
    {75, 217, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 265, 0},	//606 QWidget::devType() const
    {75, 483, 57, 1, Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//607 QWidget::setVisible(bool)
    {75, 491, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 129, 0},	//608 QWidget::sizeHint() const
    {75, 309, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 129, 0},	//609 QWidget::minimumSizeHint() const
    {75, 269, 71, 1, Smoke::mf_const|Smoke::mf_virtual, 265, 0},	//610 QWidget::heightForWidth(int) const
    {75, 351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 123, 0},	//611 QWidget::paintEngine() const
    {75, 244, 258, 1, Smoke::mf_protected|Smoke::mf_virtual, 216, 0},	//612 QWidget::event(QEvent*)
    {75, 316, 267, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//613 QWidget::mousePressEvent(QMouseEvent*)
    {75, 317, 267, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//614 QWidget::mouseReleaseEvent(QMouseEvent*)
    {75, 313, 267, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//615 QWidget::mouseDoubleClickEvent(QMouseEvent*)
    {75, 314, 267, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//616 QWidget::mouseMoveEvent(QMouseEvent*)
    {75, 541, 288, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//617 QWidget::wheelEvent(QWheelEvent*)
    {75, 291, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//618 QWidget::keyPressEvent(QKeyEvent*)
    {75, 292, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//619 QWidget::keyReleaseEvent(QKeyEvent*)
    {75, 259, 292, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//620 QWidget::focusInEvent(QFocusEvent*)
    {75, 261, 292, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//621 QWidget::focusOutEvent(QFocusEvent*)
    {75, 238, 258, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//622 QWidget::enterEvent(QEvent*)
    {75, 294, 258, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//623 QWidget::leaveEvent(QEvent*)
    {75, 352, 294, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//624 QWidget::paintEvent(QPaintEvent*)
    {75, 320, 296, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//625 QWidget::moveEvent(QMoveEvent*)
    {75, 386, 298, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//626 QWidget::resizeEvent(QResizeEvent*)
    {75, 188, 300, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//627 QWidget::closeEvent(QCloseEvent*)
    {75, 192, 302, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//628 QWidget::contextMenuEvent(QContextMenuEvent*)
    {75, 508, 304, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//629 QWidget::tabletEvent(QTabletEvent*)
    {75, 151, 306, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//630 QWidget::actionEvent(QActionEvent*)
    {75, 223, 308, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//631 QWidget::dragEnterEvent(QDragEnterEvent*)
    {75, 225, 310, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//632 QWidget::dragMoveEvent(QDragMoveEvent*)
    {75, 224, 312, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//633 QWidget::dragLeaveEvent(QDragLeaveEvent*)
    {75, 226, 314, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//634 QWidget::dropEvent(QDropEvent*)
    {75, 488, 316, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//635 QWidget::showEvent(QShowEvent*)
    {75, 270, 318, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//636 QWidget::hideEvent(QHideEvent*)
    {75, 545, 320, 1, Smoke::mf_protected|Smoke::mf_virtual, 216, 0},	//637 QWidget::x11Event(_XEvent*)
    {75, 182, 258, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//638 QWidget::changeEvent(QEvent*)
    {75, 304, 322, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 265, 0},	//639 QWidget::metric(QPaintDevice::PaintDeviceMetric) const
    {75, 275, 324, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//640 QWidget::inputMethodEvent(QInputMethodEvent*)
    {75, 276, 326, 1, Smoke::mf_const|Smoke::mf_virtual, 138, 0},	//641 QWidget::inputMethodQuery(Qt::InputMethodQuery) const
    {75, 260, 57, 1, Smoke::mf_protected|Smoke::mf_virtual, 216, 0},	//642 QWidget::focusNextPrevChild(bool)
    {75, 502, 328, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//643 QWidget::styleChange(QStyle&)
    {75, 230, 57, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//644 QWidget::enabledChange(bool)
    {75, 353, 330, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//645 QWidget::paletteChange(const QPalette&)
    {75, 262, 145, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//646 QWidget::fontChange(const QFont&)
    {75, 542, 57, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//647 QWidget::windowActivationChange(bool)
    {75, 293, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//648 QWidget::languageChange()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    408,  // Phonon::ObjectDescriptionModelData::ObjectDescriptionModelData(QAbstractListModel*)
    409,  // Phonon::ObjectDescriptionModelData::ObjectDescriptionModelData(const Phonon::ObjectDescriptionModelData&)
    0,
    94,  // Phonon::AbstractVideoOutput::AbstractVideoOutput(Phonon::AbstractVideoOutputPrivate&)
    95,  // Phonon::AbstractVideoOutput::AbstractVideoOutput(const Phonon::AbstractVideoOutput&)
    0,
    372,  // Phonon::Mrl::Mrl(const Phonon::Mrl&)
    373,  // Phonon::Mrl::Mrl(const QUrl&)
    0,
    333,  // Phonon::MediaSource::MediaSource(const QUrl&)
    339,  // Phonon::MediaSource::MediaSource(Phonon::AbstractMediaStream*)
    340,  // Phonon::MediaSource::MediaSource(QIODevice*)
    341,  // Phonon::MediaSource::MediaSource(const Phonon::MediaSource&)
    358,  // Phonon::MediaSource::MediaSource(Phonon::MediaSourcePrivate&)
    0,
    332,  // Phonon::MediaSource::MediaSource(const QString&)
    338,  // Phonon::MediaSource::MediaSource(Phonon::CaptureCategory)
    360,  // Phonon::MediaSource::MediaSource(Phonon::DiscType)
    361,  // Phonon::MediaSource::MediaSource(Phonon::Capture::DeviceType)
    0,
    334,  // Phonon::MediaSource::MediaSource(Phonon::DiscType, const QString&)
    337,  // Phonon::MediaSource::MediaSource(Phonon::Capture::DeviceType, Phonon::CaptureCategory)
    0,
    335,  // Phonon::MediaSource::MediaSource(const Phonon::ObjectDescription<Phonon::AudioCaptureDeviceType>&)
    336,  // Phonon::MediaSource::MediaSource(const Phonon::ObjectDescription<Phonon::VideoCaptureDeviceType>&)
    359,  // Phonon::MediaSource::MediaSource(const QPair<QByteArray,QString>&)
    0,
    273,  // Phonon::MediaNode::MediaNode(Phonon::MediaNodePrivate&)
    274,  // Phonon::MediaNode::MediaNode(const Phonon::MediaNode&)
    0,
    2,  // Phonon::categoryToString(Phonon::Category)
    7,  // Phonon::categoryToString(Phonon::CaptureCategory)
    0,
    4,  // Phonon::operator<<(QDebug, const Phonon::ErrorType&)
    8,  // Phonon::operator<<(QDebug, const Phonon::Capture::DeviceType&)
    9,  // Phonon::operator<<(QDebug, const Phonon::Category&)
    13,  // Phonon::operator<<(QDebug, const Phonon::MetaData&)
    14,  // Phonon::operator<<(QDebug, const Phonon::CaptureCategory&)
    15,  // Phonon::operator<<(QDebug, const Phonon::State&)
    16,  // Phonon::operator<<(QDebug, const Phonon::DiscType&)
    0,
    438,  // Phonon::SeekSlider::SeekSlider(QWidget*)
    457,  // Phonon::SeekSlider::SeekSlider(Phonon::MediaObject*)
    0,
    575,  // Phonon::VolumeSlider::VolumeSlider(QWidget*)
    596,  // Phonon::VolumeSlider::VolumeSlider(Phonon::AudioOutput*)
    0,
    388,  // Phonon::ObjectDescriptionData::ObjectDescriptionData(Phonon::ObjectDescriptionPrivate*)
    390,  // Phonon::ObjectDescriptionData::ObjectDescriptionData(const Phonon::ObjectDescriptionData&)
    0,
    299,  // Phonon::MediaObject::enqueue(const QList<Phonon::MediaSource>&)
    300,  // Phonon::MediaObject::enqueue(const QList<QUrl>&)
    0,
    288,  // Phonon::MediaObject::metaData(const QString&) const
    289,  // Phonon::MediaObject::metaData(Phonon::MetaData) const
    0,
    296,  // Phonon::MediaObject::setQueue(const QList<Phonon::MediaSource>&)
    297,  // Phonon::MediaObject::setQueue(const QList<QUrl>&)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {1, 8, 49},	// Phonon::AccessibilityCategory
    {1, 9, 18},	// Phonon::AlbumMetaData
    {1, 12, 17},	// Phonon::ArtistMetaData
    {1, 17, 29},	// Phonon::AudioCaptureDeviceType
    {1, 18, 27},	// Phonon::AudioChannelType
    {1, 27, 25},	// Phonon::AudioOutputDeviceType
    {1, 30, 35},	// Phonon::BluRay
    {1, 31, 54},	// Phonon::BufferingState
    {1, 33, 32},	// Phonon::Cd
    {1, 37, 37},	// Phonon::CommunicationCaptureCategory
    {1, 38, 47},	// Phonon::CommunicationCategory
    {1, 39, 39},	// Phonon::ControlCaptureCategory
    {1, 40, 20},	// Phonon::DateMetaData
    {1, 41, 23},	// Phonon::DescriptionMetaData
    {1, 45, 33},	// Phonon::Dvd
    {1, 57, 26},	// Phonon::EffectType
    {1, 62, 56},	// Phonon::ErrorState
    {1, 67, 42},	// Phonon::FatalError
    {1, 69, 48},	// Phonon::GameCategory
    {1, 70, 21},	// Phonon::GenreMetaData
    {1, 74, 50},	// Phonon::LastCategory
    {1, 77, 51},	// Phonon::LoadingState
    {1, 94, 24},	// Phonon::MusicBrainzDiscIdMetaData
    {1, 95, 45},	// Phonon::MusicCategory
    {1, 97, 36},	// Phonon::NoCaptureCategory
    {1, 98, 43},	// Phonon::NoCategory
    {1, 99, 31},	// Phonon::NoDisc
    {1, 100, 40},	// Phonon::NoError
    {1, 101, 41},	// Phonon::NormalError
    {1, 102, 44},	// Phonon::NotificationCategory
    {1, 110, 55},	// Phonon::PausedState
    {1, 111, 53},	// Phonon::PlayingState
    {1, 112, 38},	// Phonon::RecordingCaptureCategory
    {1, 120, 52},	// Phonon::StoppedState
    {1, 125, 28},	// Phonon::SubtitleType
    {1, 129, 19},	// Phonon::TitleMetaData
    {1, 132, 22},	// Phonon::TracknumberMetaData
    {1, 134, 34},	// Phonon::Vcd
    {1, 135, 30},	// Phonon::VideoCaptureDeviceType
    {1, 136, 46},	// Phonon::VideoCategory
    {1, 181, -31},	// Phonon::categoryToString$
    {1, 195, 10},	// Phonon::createPath##
    {1, 197, 12},	// Phonon::createPlayer$
    {1, 198, 11},	// Phonon::createPlayer$#
    {1, 336, 1},	// Phonon::operator<<##
    {1, 337, -34},	// Phonon::operator<<#$
    {1, 358, 3},	// Phonon::phononVersion
    {1, 370, 5},	// Phonon::qHash#
    {1, 378, 6},	// Phonon::registerMetaTypes
    {2, 2, 64},	// Phonon::AbstractAudioOutput::AbstractAudioOutput##
    {2, 303, 57},	// Phonon::AbstractAudioOutput::metaObject
    {2, 372, 63},	// Phonon::AbstractAudioOutput::qt_metacall$$?
    {2, 374, 58},	// Phonon::AbstractAudioOutput::qt_metacast$
    {2, 497, 67},	// Phonon::AbstractAudioOutput::staticMetaObject
    {2, 521, 65},	// Phonon::AbstractAudioOutput::tr$
    {2, 522, 59},	// Phonon::AbstractAudioOutput::tr$$
    {2, 523, 61},	// Phonon::AbstractAudioOutput::tr$$$
    {2, 525, 66},	// Phonon::AbstractAudioOutput::trUtf8$
    {2, 526, 60},	// Phonon::AbstractAudioOutput::trUtf8$$
    {2, 527, 62},	// Phonon::AbstractAudioOutput::trUtf8$$$
    {2, 546, 68},	// Phonon::AbstractAudioOutput::~AbstractAudioOutput
    {4, 3, 91},	// Phonon::AbstractMediaStream::AbstractMediaStream
    {4, 4, 76},	// Phonon::AbstractMediaStream::AbstractMediaStream#
    {4, 5, 88},	// Phonon::AbstractMediaStream::AbstractMediaStream##
    {4, 231, 82},	// Phonon::AbstractMediaStream::endOfData
    {4, 234, 86},	// Phonon::AbstractMediaStream::enoughData
    {4, 241, 83},	// Phonon::AbstractMediaStream::error$$
    {4, 303, 69},	// Phonon::AbstractMediaStream::metaObject
    {4, 329, 85},	// Phonon::AbstractMediaStream::needData
    {4, 372, 75},	// Phonon::AbstractMediaStream::qt_metacall$$?
    {4, 374, 70},	// Phonon::AbstractMediaStream::qt_metacast$
    {4, 385, 84},	// Phonon::AbstractMediaStream::reset
    {4, 395, 87},	// Phonon::AbstractMediaStream::seekStream$
    {4, 468, 80},	// Phonon::AbstractMediaStream::setStreamSeekable$
    {4, 470, 78},	// Phonon::AbstractMediaStream::setStreamSize$
    {4, 497, 92},	// Phonon::AbstractMediaStream::staticMetaObject
    {4, 500, 79},	// Phonon::AbstractMediaStream::streamSeekable
    {4, 501, 77},	// Phonon::AbstractMediaStream::streamSize
    {4, 521, 89},	// Phonon::AbstractMediaStream::tr$
    {4, 522, 71},	// Phonon::AbstractMediaStream::tr$$
    {4, 523, 73},	// Phonon::AbstractMediaStream::tr$$$
    {4, 525, 90},	// Phonon::AbstractMediaStream::trUtf8$
    {4, 526, 72},	// Phonon::AbstractMediaStream::trUtf8$$
    {4, 527, 74},	// Phonon::AbstractMediaStream::trUtf8$$$
    {4, 544, 81},	// Phonon::AbstractMediaStream::writeData#
    {4, 547, 93},	// Phonon::AbstractMediaStream::~AbstractMediaStream
    {6, 7, -4},	// Phonon::AbstractVideoOutput::AbstractVideoOutput#
    {6, 548, 96},	// Phonon::AbstractVideoOutput::~AbstractVideoOutput
    {8, 20, 112},	// Phonon::AudioDataOutput::AudioDataOutput
    {8, 21, 104},	// Phonon::AudioDataOutput::AudioDataOutput#
    {8, 34, 116},	// Phonon::AudioDataOutput::CenterChannel
    {8, 75, 114},	// Phonon::AudioDataOutput::LeftChannel
    {8, 76, 117},	// Phonon::AudioDataOutput::LeftSurroundChannel
    {8, 113, 115},	// Phonon::AudioDataOutput::RightChannel
    {8, 114, 118},	// Phonon::AudioDataOutput::RightSurroundChannel
    {8, 127, 119},	// Phonon::AudioDataOutput::SubwooferChannel
    {8, 213, 108},	// Phonon::AudioDataOutput::dataReady?
    {8, 214, 105},	// Phonon::AudioDataOutput::dataSize
    {8, 233, 109},	// Phonon::AudioDataOutput::endOfMedia$
    {8, 303, 97},	// Phonon::AudioDataOutput::metaObject
    {8, 372, 103},	// Phonon::AudioDataOutput::qt_metacall$$?
    {8, 374, 98},	// Phonon::AudioDataOutput::qt_metacast$
    {8, 389, 106},	// Phonon::AudioDataOutput::sampleRate
    {8, 426, 107},	// Phonon::AudioDataOutput::setDataSize$
    {8, 497, 113},	// Phonon::AudioDataOutput::staticMetaObject
    {8, 521, 110},	// Phonon::AudioDataOutput::tr$
    {8, 522, 99},	// Phonon::AudioDataOutput::tr$$
    {8, 523, 101},	// Phonon::AudioDataOutput::tr$$$
    {8, 525, 111},	// Phonon::AudioDataOutput::trUtf8$
    {8, 526, 100},	// Phonon::AudioDataOutput::trUtf8$$
    {8, 527, 102},	// Phonon::AudioDataOutput::trUtf8$$$
    {8, 549, 120},	// Phonon::AudioDataOutput::~AudioDataOutput
    {9, 23, 147},	// Phonon::AudioOutput::AudioOutput
    {9, 24, 129},	// Phonon::AudioOutput::AudioOutput#
    {9, 25, 146},	// Phonon::AudioOutput::AudioOutput$
    {9, 26, 128},	// Phonon::AudioOutput::AudioOutput$#
    {9, 179, 133},	// Phonon::AudioOutput::category
    {9, 286, 135},	// Phonon::AudioOutput::isMuted
    {9, 303, 121},	// Phonon::AudioOutput::metaObject
    {9, 325, 142},	// Phonon::AudioOutput::mutedChanged$
    {9, 326, 130},	// Phonon::AudioOutput::name
    {9, 346, 134},	// Phonon::AudioOutput::outputDevice
    {9, 348, 143},	// Phonon::AudioOutput::outputDeviceChanged?
    {9, 372, 127},	// Phonon::AudioOutput::qt_metacall$$?
    {9, 374, 122},	// Phonon::AudioOutput::qt_metacast$
    {9, 446, 140},	// Phonon::AudioOutput::setMuted$
    {9, 448, 136},	// Phonon::AudioOutput::setName$
    {9, 452, 139},	// Phonon::AudioOutput::setOutputDevice?
    {9, 485, 137},	// Phonon::AudioOutput::setVolume$
    {9, 487, 138},	// Phonon::AudioOutput::setVolumeDecibel$
    {9, 497, 148},	// Phonon::AudioOutput::staticMetaObject
    {9, 521, 144},	// Phonon::AudioOutput::tr$
    {9, 522, 123},	// Phonon::AudioOutput::tr$$
    {9, 523, 125},	// Phonon::AudioOutput::tr$$$
    {9, 525, 145},	// Phonon::AudioOutput::trUtf8$
    {9, 526, 124},	// Phonon::AudioOutput::trUtf8$$
    {9, 527, 126},	// Phonon::AudioOutput::trUtf8$$$
    {9, 537, 131},	// Phonon::AudioOutput::volume
    {9, 539, 141},	// Phonon::AudioOutput::volumeChanged$
    {9, 540, 132},	// Phonon::AudioOutput::volumeDecibel
    {9, 550, 149},	// Phonon::AudioOutput::~AudioOutput
    {11, 28, 150},	// Phonon::Capture::AudioType
    {11, 141, 151},	// Phonon::Capture::VideoType
    {12, 47, 164},	// Phonon::Effect::Effect##
    {12, 48, 167},	// Phonon::Effect::Effect?
    {12, 49, 159},	// Phonon::Effect::Effect?#
    {12, 216, 160},	// Phonon::Effect::description
    {12, 303, 152},	// Phonon::Effect::metaObject
    {12, 355, 162},	// Phonon::Effect::parameterValue#
    {12, 356, 161},	// Phonon::Effect::parameters
    {12, 372, 158},	// Phonon::Effect::qt_metacall$$?
    {12, 374, 153},	// Phonon::Effect::qt_metacast$
    {12, 456, 163},	// Phonon::Effect::setParameterValue##
    {12, 497, 168},	// Phonon::Effect::staticMetaObject
    {12, 521, 165},	// Phonon::Effect::tr$
    {12, 522, 154},	// Phonon::Effect::tr$$
    {12, 523, 156},	// Phonon::Effect::tr$$$
    {12, 525, 166},	// Phonon::Effect::trUtf8$
    {12, 526, 155},	// Phonon::Effect::trUtf8$$
    {12, 527, 157},	// Phonon::Effect::trUtf8$$$
    {12, 551, 169},	// Phonon::Effect::~Effect
    {13, 50, 170},	// Phonon::EffectParameter::EffectParameter
    {13, 51, 182},	// Phonon::EffectParameter::EffectParameter#
    {13, 52, 186},	// Phonon::EffectParameter::EffectParameter$$$#
    {13, 53, 187},	// Phonon::EffectParameter::EffectParameter$$$##
    {13, 54, 188},	// Phonon::EffectParameter::EffectParameter$$$###
    {13, 55, 189},	// Phonon::EffectParameter::EffectParameter$$$###?
    {13, 56, 184},	// Phonon::EffectParameter::EffectParameter$$$###?$
    {13, 72, 192},	// Phonon::EffectParameter::IntegerHint
    {13, 79, 191},	// Phonon::EffectParameter::LogarithmicHint
    {13, 131, 190},	// Phonon::EffectParameter::ToggledHint
    {13, 215, 177},	// Phonon::EffectParameter::defaultValue
    {13, 216, 172},	// Phonon::EffectParameter::description
    {13, 273, 185},	// Phonon::EffectParameter::id
    {13, 284, 174},	// Phonon::EffectParameter::isLogarithmicControl
    {13, 297, 176},	// Phonon::EffectParameter::maximumValue
    {13, 310, 175},	// Phonon::EffectParameter::minimumValue
    {13, 326, 171},	// Phonon::EffectParameter::name
    {13, 334, 179},	// Phonon::EffectParameter::operator<#
    {13, 339, 183},	// Phonon::EffectParameter::operator=#
    {13, 342, 181},	// Phonon::EffectParameter::operator==#
    {13, 344, 180},	// Phonon::EffectParameter::operator>#
    {13, 361, 178},	// Phonon::EffectParameter::possibleValues
    {13, 532, 173},	// Phonon::EffectParameter::type
    {13, 552, 193},	// Phonon::EffectParameter::~EffectParameter
    {15, 59, 204},	// Phonon::EffectWidget::EffectWidget#
    {15, 60, 201},	// Phonon::EffectWidget::EffectWidget##
    {15, 303, 194},	// Phonon::EffectWidget::metaObject
    {15, 372, 200},	// Phonon::EffectWidget::qt_metacall$$?
    {15, 374, 195},	// Phonon::EffectWidget::qt_metacast$
    {15, 497, 205},	// Phonon::EffectWidget::staticMetaObject
    {15, 521, 202},	// Phonon::EffectWidget::tr$
    {15, 522, 196},	// Phonon::EffectWidget::tr$$
    {15, 523, 198},	// Phonon::EffectWidget::tr$$$
    {15, 525, 203},	// Phonon::EffectWidget::trUtf8$
    {15, 526, 197},	// Phonon::EffectWidget::trUtf8$$
    {15, 527, 199},	// Phonon::EffectWidget::trUtf8$$$
    {15, 553, 206},	// Phonon::EffectWidget::~EffectWidget
    {16, 10, 268},	// Phonon::MediaController::AngleMenu
    {16, 11, 257},	// Phonon::MediaController::Angles
    {16, 19, 262},	// Phonon::MediaController::AudioChannels
    {16, 22, 265},	// Phonon::MediaController::AudioMenu
    {16, 35, 267},	// Phonon::MediaController::ChapterMenu
    {16, 36, 258},	// Phonon::MediaController::Chapters
    {16, 81, 214},	// Phonon::MediaController::MediaController#
    {16, 96, 259},	// Phonon::MediaController::Navigations
    {16, 115, 263},	// Phonon::MediaController::RootMenu
    {16, 124, 266},	// Phonon::MediaController::SubtitleMenu
    {16, 126, 261},	// Phonon::MediaController::Subtitles
    {16, 128, 264},	// Phonon::MediaController::TitleMenu
    {16, 130, 260},	// Phonon::MediaController::Titles
    {16, 153, 251},	// Phonon::MediaController::angleChanged$
    {16, 159, 224},	// Phonon::MediaController::autoplayTitles
    {16, 160, 216},	// Phonon::MediaController::availableAngles
    {16, 162, 245},	// Phonon::MediaController::availableAnglesChanged$
    {16, 163, 230},	// Phonon::MediaController::availableAudioChannels
    {16, 164, 246},	// Phonon::MediaController::availableAudioChannelsChanged
    {16, 165, 218},	// Phonon::MediaController::availableChapters
    {16, 167, 247},	// Phonon::MediaController::availableChaptersChanged$
    {16, 168, 221},	// Phonon::MediaController::availableMenus
    {16, 170, 248},	// Phonon::MediaController::availableMenusChanged?
    {16, 171, 231},	// Phonon::MediaController::availableSubtitles
    {16, 172, 249},	// Phonon::MediaController::availableSubtitlesChanged
    {16, 173, 222},	// Phonon::MediaController::availableTitles
    {16, 175, 250},	// Phonon::MediaController::availableTitlesChanged$
    {16, 184, 252},	// Phonon::MediaController::chapterChanged$
    {16, 199, 217},	// Phonon::MediaController::currentAngle
    {16, 200, 225},	// Phonon::MediaController::currentAudioChannel
    {16, 201, 219},	// Phonon::MediaController::currentChapter
    {16, 205, 226},	// Phonon::MediaController::currentSubtitle
    {16, 207, 223},	// Phonon::MediaController::currentTitle
    {16, 303, 207},	// Phonon::MediaController::metaObject
    {16, 328, 220},	// Phonon::MediaController::navigationMenuToString$
    {16, 330, 243},	// Phonon::MediaController::nextTitle
    {16, 365, 244},	// Phonon::MediaController::previousTitle
    {16, 372, 213},	// Phonon::MediaController::qt_metacall$$?
    {16, 374, 208},	// Phonon::MediaController::qt_metacast$
    {16, 405, 242},	// Phonon::MediaController::setAutoplayTitles$
    {16, 411, 239},	// Phonon::MediaController::setCurrentAngle$
    {16, 413, 232},	// Phonon::MediaController::setCurrentAudioChannel?
    {16, 415, 240},	// Phonon::MediaController::setCurrentChapter$
    {16, 417, 233},	// Phonon::MediaController::setCurrentMenu$
    {16, 421, 235},	// Phonon::MediaController::setCurrentSubtitle#
    {16, 422, 234},	// Phonon::MediaController::setCurrentSubtitle?
    {16, 424, 241},	// Phonon::MediaController::setCurrentTitle$
    {16, 472, 236},	// Phonon::MediaController::setSubtitleAutodetect$
    {16, 474, 237},	// Phonon::MediaController::setSubtitleEncoding$
    {16, 476, 238},	// Phonon::MediaController::setSubtitleFont#
    {16, 497, 256},	// Phonon::MediaController::staticMetaObject
    {16, 503, 227},	// Phonon::MediaController::subtitleAutodetect
    {16, 504, 228},	// Phonon::MediaController::subtitleEncoding
    {16, 505, 229},	// Phonon::MediaController::subtitleFont
    {16, 507, 215},	// Phonon::MediaController::supportedFeatures
    {16, 514, 253},	// Phonon::MediaController::titleChanged$
    {16, 521, 254},	// Phonon::MediaController::tr$
    {16, 522, 209},	// Phonon::MediaController::tr$$
    {16, 523, 211},	// Phonon::MediaController::tr$$$
    {16, 525, 255},	// Phonon::MediaController::trUtf8$
    {16, 526, 210},	// Phonon::MediaController::trUtf8$$
    {16, 527, 212},	// Phonon::MediaController::trUtf8$$$
    {16, 554, 269},	// Phonon::MediaController::~MediaController
    {17, 83, -28},	// Phonon::MediaNode::MediaNode#
    {17, 277, 271},	// Phonon::MediaNode::inputPaths
    {17, 290, 270},	// Phonon::MediaNode::isValid
    {17, 349, 272},	// Phonon::MediaNode::outputPaths
    {17, 555, 275},	// Phonon::MediaNode::~MediaNode
    {19, 84, 328},	// Phonon::MediaObject::MediaObject
    {19, 85, 283},	// Phonon::MediaObject::MediaObject#
    {19, 150, 323},	// Phonon::MediaObject::aboutToFinish
    {19, 178, 320},	// Phonon::MediaObject::bufferStatus$
    {19, 186, 314},	// Phonon::MediaObject::clear
    {19, 187, 301},	// Phonon::MediaObject::clearQueue
    {19, 202, 293},	// Phonon::MediaObject::currentSource
    {19, 204, 322},	// Phonon::MediaObject::currentSourceChanged#
    {19, 206, 302},	// Phonon::MediaObject::currentTime
    {19, 236, 298},	// Phonon::MediaObject::enqueue#
    {19, 237, -51},	// Phonon::MediaObject::enqueue?
    {19, 242, 291},	// Phonon::MediaObject::errorString
    {19, 243, 292},	// Phonon::MediaObject::errorType
    {19, 256, 321},	// Phonon::MediaObject::finished
    {19, 266, 285},	// Phonon::MediaObject::hasVideo
    {19, 268, 319},	// Phonon::MediaObject::hasVideoChanged$
    {19, 289, 286},	// Phonon::MediaObject::isSeekable
    {19, 300, 290},	// Phonon::MediaObject::metaData
    {19, 301, -54},	// Phonon::MediaObject::metaData$
    {19, 302, 317},	// Phonon::MediaObject::metaDataChanged
    {19, 303, 276},	// Phonon::MediaObject::metaObject
    {19, 357, 311},	// Phonon::MediaObject::pause
    {19, 359, 310},	// Phonon::MediaObject::play
    {19, 362, 305},	// Phonon::MediaObject::prefinishMark
    {19, 364, 324},	// Phonon::MediaObject::prefinishMarkReached$
    {19, 372, 282},	// Phonon::MediaObject::qt_metacall$$?
    {19, 374, 277},	// Phonon::MediaObject::qt_metacast$
    {19, 375, 295},	// Phonon::MediaObject::queue
    {19, 379, 304},	// Phonon::MediaObject::remainingTime
    {19, 393, 313},	// Phonon::MediaObject::seek$
    {19, 397, 318},	// Phonon::MediaObject::seekableChanged$
    {19, 419, 294},	// Phonon::MediaObject::setCurrentSource#
    {19, 458, 306},	// Phonon::MediaObject::setPrefinishMark$
    {19, 460, -57},	// Phonon::MediaObject::setQueue?
    {19, 478, 309},	// Phonon::MediaObject::setTickInterval$
    {19, 482, 308},	// Phonon::MediaObject::setTransitionTime$
    {19, 494, 284},	// Phonon::MediaObject::state
    {19, 496, 315},	// Phonon::MediaObject::stateChanged$$
    {19, 497, 329},	// Phonon::MediaObject::staticMetaObject
    {19, 498, 312},	// Phonon::MediaObject::stop
    {19, 510, 316},	// Phonon::MediaObject::tick$
    {19, 511, 287},	// Phonon::MediaObject::tickInterval
    {19, 517, 303},	// Phonon::MediaObject::totalTime
    {19, 519, 325},	// Phonon::MediaObject::totalTimeChanged$
    {19, 521, 326},	// Phonon::MediaObject::tr$
    {19, 522, 278},	// Phonon::MediaObject::tr$$
    {19, 523, 280},	// Phonon::MediaObject::tr$$$
    {19, 525, 327},	// Phonon::MediaObject::trUtf8$
    {19, 526, 279},	// Phonon::MediaObject::trUtf8$$
    {19, 527, 281},	// Phonon::MediaObject::trUtf8$$$
    {19, 528, 307},	// Phonon::MediaObject::transitionTime
    {19, 556, 330},	// Phonon::MediaObject::~MediaObject
    {20, 29, 369},	// Phonon::MediaSource::AudioVideoCapture
    {20, 32, 367},	// Phonon::MediaSource::CaptureDevice
    {20, 42, 365},	// Phonon::MediaSource::Disc
    {20, 61, 368},	// Phonon::MediaSource::Empty
    {20, 73, 362},	// Phonon::MediaSource::Invalid
    {20, 78, 363},	// Phonon::MediaSource::LocalFile
    {20, 86, 331},	// Phonon::MediaSource::MediaSource
    {20, 87, -10},	// Phonon::MediaSource::MediaSource#
    {20, 88, -16},	// Phonon::MediaSource::MediaSource$
    {20, 89, -21},	// Phonon::MediaSource::MediaSource$$
    {20, 90, -24},	// Phonon::MediaSource::MediaSource?
    {20, 121, 366},	// Phonon::MediaSource::Stream
    {20, 133, 364},	// Phonon::MediaSource::Url
    {20, 155, 356},	// Phonon::MediaSource::audioCaptureDevice
    {20, 156, 353},	// Phonon::MediaSource::audioDeviceAccessList
    {20, 158, 345},	// Phonon::MediaSource::autoDelete
    {20, 218, 351},	// Phonon::MediaSource::deviceAccessList
    {20, 219, 354},	// Phonon::MediaSource::deviceName
    {20, 220, 350},	// Phonon::MediaSource::discType
    {20, 255, 347},	// Phonon::MediaSource::fileName
    {20, 323, 348},	// Phonon::MediaSource::mrl
    {20, 339, 342},	// Phonon::MediaSource::operator=#
    {20, 342, 343},	// Phonon::MediaSource::operator==#
    {20, 403, 344},	// Phonon::MediaSource::setAutoDelete$
    {20, 499, 355},	// Phonon::MediaSource::stream
    {20, 532, 346},	// Phonon::MediaSource::type
    {20, 533, 349},	// Phonon::MediaSource::url
    {20, 534, 357},	// Phonon::MediaSource::videoCaptureDevice
    {20, 535, 352},	// Phonon::MediaSource::videoDeviceAccessList
    {20, 557, 370},	// Phonon::MediaSource::~MediaSource
    {22, 91, 371},	// Phonon::Mrl::Mrl
    {22, 92, -7},	// Phonon::Mrl::Mrl#
    {22, 93, 374},	// Phonon::Mrl::Mrl$
    {22, 339, 375},	// Phonon::Mrl::operator=#
    {22, 340, 376},	// Phonon::Mrl::operator=$
    {22, 515, 378},	// Phonon::Mrl::toEncoded
    {22, 516, 377},	// Phonon::Mrl::toEncoded$
    {22, 558, 379},	// Phonon::Mrl::~Mrl
    {23, 103, 391},	// Phonon::ObjectDescriptionData::ObjectDescriptionData
    {23, 104, -48},	// Phonon::ObjectDescriptionData::ObjectDescriptionData#
    {23, 105, 389},	// Phonon::ObjectDescriptionData::ObjectDescriptionData$?
    {23, 216, 382},	// Phonon::ObjectDescriptionData::description
    {23, 264, 387},	// Phonon::ObjectDescriptionData::fromIndex$$
    {23, 274, 386},	// Phonon::ObjectDescriptionData::index
    {23, 290, 385},	// Phonon::ObjectDescriptionData::isValid
    {23, 326, 381},	// Phonon::ObjectDescriptionData::name
    {23, 342, 380},	// Phonon::ObjectDescriptionData::operator==#
    {23, 367, 383},	// Phonon::ObjectDescriptionData::property$
    {23, 368, 384},	// Phonon::ObjectDescriptionData::propertyNames
    {23, 559, 392},	// Phonon::ObjectDescriptionData::~ObjectDescriptionData
    {24, 107, -1},	// Phonon::ObjectDescriptionModelData::ObjectDescriptionModelData#
    {24, 210, 411},	// Phonon::ObjectDescriptionModelData::data#
    {24, 211, 394},	// Phonon::ObjectDescriptionModelData::data#$
    {24, 228, 405},	// Phonon::ObjectDescriptionModelData::dropMimeData$#$$$#
    {24, 258, 395},	// Phonon::ObjectDescriptionModelData::flags#
    {24, 306, 398},	// Phonon::ObjectDescriptionModelData::mimeData$?
    {24, 308, 407},	// Phonon::ObjectDescriptionModelData::mimeTypes$
    {24, 311, 402},	// Phonon::ObjectDescriptionModelData::modelData
    {24, 312, 403},	// Phonon::ObjectDescriptionModelData::modelData#
    {24, 319, 400},	// Phonon::ObjectDescriptionModelData::moveDown#
    {24, 322, 399},	// Phonon::ObjectDescriptionModelData::moveUp#
    {24, 383, 412},	// Phonon::ObjectDescriptionModelData::removeRows$$
    {24, 384, 406},	// Phonon::ObjectDescriptionModelData::removeRows$$#
    {24, 387, 410},	// Phonon::ObjectDescriptionModelData::rowCount
    {24, 388, 393},	// Phonon::ObjectDescriptionModelData::rowCount#
    {24, 442, 401},	// Phonon::ObjectDescriptionModelData::setModelData?
    {24, 506, 404},	// Phonon::ObjectDescriptionModelData::supportedDropActions
    {24, 530, 397},	// Phonon::ObjectDescriptionModelData::tupleIndexAtPositionIndex$
    {24, 531, 396},	// Phonon::ObjectDescriptionModelData::tupleIndexOrder
    {24, 560, 413},	// Phonon::ObjectDescriptionModelData::~ObjectDescriptionModelData
    {26, 108, 414},	// Phonon::Path::Path
    {26, 109, 415},	// Phonon::Path::Path#
    {26, 221, 422},	// Phonon::Path::disconnect
    {26, 229, 420},	// Phonon::Path::effects
    {26, 279, 429},	// Phonon::Path::insertEffect#
    {26, 280, 418},	// Phonon::Path::insertEffect##
    {26, 281, 428},	// Phonon::Path::insertEffect?
    {26, 282, 417},	// Phonon::Path::insertEffect?#
    {26, 290, 416},	// Phonon::Path::isValid
    {26, 332, 425},	// Phonon::Path::operator!=#
    {26, 339, 423},	// Phonon::Path::operator=#
    {26, 342, 424},	// Phonon::Path::operator==#
    {26, 377, 421},	// Phonon::Path::reconnect##
    {26, 381, 419},	// Phonon::Path::removeEffect#
    {26, 490, 427},	// Phonon::Path::sink
    {26, 493, 426},	// Phonon::Path::source
    {26, 561, 430},	// Phonon::Path::~Path
    {27, 117, 456},	// Phonon::SeekSlider::SeekSlider
    {27, 118, -42},	// Phonon::SeekSlider::SeekSlider#
    {27, 119, 439},	// Phonon::SeekSlider::SeekSlider##
    {27, 265, 440},	// Phonon::SeekSlider::hasTracking
    {27, 272, 448},	// Phonon::SeekSlider::iconSize
    {27, 283, 447},	// Phonon::SeekSlider::isIconVisible
    {27, 299, 449},	// Phonon::SeekSlider::mediaObject
    {27, 303, 431},	// Phonon::SeekSlider::metaObject
    {27, 345, 446},	// Phonon::SeekSlider::orientation
    {27, 350, 442},	// Phonon::SeekSlider::pageStep
    {27, 372, 437},	// Phonon::SeekSlider::qt_metacall$$?
    {27, 374, 432},	// Phonon::SeekSlider::qt_metacast$
    {27, 434, 452},	// Phonon::SeekSlider::setIconSize#
    {27, 436, 451},	// Phonon::SeekSlider::setIconVisible$
    {27, 440, 453},	// Phonon::SeekSlider::setMediaObject#
    {27, 450, 450},	// Phonon::SeekSlider::setOrientation$
    {27, 454, 443},	// Phonon::SeekSlider::setPageStep$
    {27, 466, 445},	// Phonon::SeekSlider::setSingleStep$
    {27, 480, 441},	// Phonon::SeekSlider::setTracking$
    {27, 489, 444},	// Phonon::SeekSlider::singleStep
    {27, 497, 458},	// Phonon::SeekSlider::staticMetaObject
    {27, 521, 454},	// Phonon::SeekSlider::tr$
    {27, 522, 433},	// Phonon::SeekSlider::tr$$
    {27, 523, 435},	// Phonon::SeekSlider::tr$$$
    {27, 525, 455},	// Phonon::SeekSlider::trUtf8$
    {27, 526, 434},	// Phonon::SeekSlider::trUtf8$$
    {27, 527, 436},	// Phonon::SeekSlider::trUtf8$$$
    {27, 562, 459},	// Phonon::SeekSlider::~SeekSlider
    {28, 122, 469},	// Phonon::StreamInterface::StreamInterface
    {28, 123, 470},	// Phonon::StreamInterface::StreamInterface#
    {28, 191, 464},	// Phonon::StreamInterface::connectToSource#
    {28, 231, 461},	// Phonon::StreamInterface::endOfData
    {28, 234, 466},	// Phonon::StreamInterface::enoughData
    {28, 329, 465},	// Phonon::StreamInterface::needData
    {28, 385, 468},	// Phonon::StreamInterface::reset
    {28, 395, 467},	// Phonon::StreamInterface::seekStream$
    {28, 468, 463},	// Phonon::StreamInterface::setStreamSeekable$
    {28, 470, 462},	// Phonon::StreamInterface::setStreamSize$
    {28, 544, 460},	// Phonon::StreamInterface::writeData#
    {28, 563, 471},	// Phonon::StreamInterface::~StreamInterface
    {29, 137, 501},	// Phonon::VideoPlayer::VideoPlayer
    {29, 138, 480},	// Phonon::VideoPlayer::VideoPlayer#
    {29, 139, 500},	// Phonon::VideoPlayer::VideoPlayer$
    {29, 140, 479},	// Phonon::VideoPlayer::VideoPlayer$#
    {29, 157, 487},	// Phonon::VideoPlayer::audioOutput
    {29, 206, 482},	// Phonon::VideoPlayer::currentTime
    {29, 245, 497},	// Phonon::VideoPlayer::event#
    {29, 256, 496},	// Phonon::VideoPlayer::finished
    {29, 287, 485},	// Phonon::VideoPlayer::isPaused
    {29, 288, 484},	// Phonon::VideoPlayer::isPlaying
    {29, 296, 489},	// Phonon::VideoPlayer::load#
    {29, 299, 486},	// Phonon::VideoPlayer::mediaObject
    {29, 303, 472},	// Phonon::VideoPlayer::metaObject
    {29, 357, 492},	// Phonon::VideoPlayer::pause
    {29, 359, 491},	// Phonon::VideoPlayer::play
    {29, 360, 490},	// Phonon::VideoPlayer::play#
    {29, 372, 478},	// Phonon::VideoPlayer::qt_metacall$$?
    {29, 374, 473},	// Phonon::VideoPlayer::qt_metacast$
    {29, 393, 494},	// Phonon::VideoPlayer::seek$
    {29, 485, 495},	// Phonon::VideoPlayer::setVolume$
    {29, 497, 502},	// Phonon::VideoPlayer::staticMetaObject
    {29, 498, 493},	// Phonon::VideoPlayer::stop
    {29, 517, 481},	// Phonon::VideoPlayer::totalTime
    {29, 521, 498},	// Phonon::VideoPlayer::tr$
    {29, 522, 474},	// Phonon::VideoPlayer::tr$$
    {29, 523, 476},	// Phonon::VideoPlayer::tr$$$
    {29, 525, 499},	// Phonon::VideoPlayer::trUtf8$
    {29, 526, 475},	// Phonon::VideoPlayer::trUtf8$$
    {29, 527, 477},	// Phonon::VideoPlayer::trUtf8$$$
    {29, 536, 488},	// Phonon::VideoPlayer::videoWidget
    {29, 537, 483},	// Phonon::VideoPlayer::volume
    {29, 564, 503},	// Phonon::VideoPlayer::~VideoPlayer
    {30, 13, 538},	// Phonon::VideoWidget::AspectRatio16_9
    {30, 14, 537},	// Phonon::VideoWidget::AspectRatio4_3
    {30, 15, 535},	// Phonon::VideoWidget::AspectRatioAuto
    {30, 16, 536},	// Phonon::VideoWidget::AspectRatioWidget
    {30, 68, 539},	// Phonon::VideoWidget::FitInView
    {30, 116, 540},	// Phonon::VideoWidget::ScaleAndCrop
    {30, 142, 533},	// Phonon::VideoWidget::VideoWidget
    {30, 143, 511},	// Phonon::VideoWidget::VideoWidget#
    {30, 144, 528},	// Phonon::VideoWidget::VideoWidget##
    {30, 154, 512},	// Phonon::VideoWidget::aspectRatio
    {30, 176, 514},	// Phonon::VideoWidget::brightness
    {30, 193, 515},	// Phonon::VideoWidget::contrast
    {30, 239, 521},	// Phonon::VideoWidget::enterFullScreen
    {30, 245, 530},	// Phonon::VideoWidget::event#
    {30, 247, 520},	// Phonon::VideoWidget::exitFullScreen
    {30, 271, 516},	// Phonon::VideoWidget::hue
    {30, 303, 504},	// Phonon::VideoWidget::metaObject
    {30, 315, 529},	// Phonon::VideoWidget::mouseMoveEvent#
    {30, 372, 510},	// Phonon::VideoWidget::qt_metacall$$?
    {30, 374, 505},	// Phonon::VideoWidget::qt_metacast$
    {30, 390, 517},	// Phonon::VideoWidget::saturation
    {30, 391, 513},	// Phonon::VideoWidget::scaleMode
    {30, 399, 522},	// Phonon::VideoWidget::setAspectRatio$
    {30, 407, 524},	// Phonon::VideoWidget::setBrightness$
    {30, 409, 525},	// Phonon::VideoWidget::setContrast$
    {30, 430, 519},	// Phonon::VideoWidget::setFullScreen$
    {30, 432, 526},	// Phonon::VideoWidget::setHue$
    {30, 462, 527},	// Phonon::VideoWidget::setSaturation$
    {30, 464, 523},	// Phonon::VideoWidget::setScaleMode$
    {30, 492, 518},	// Phonon::VideoWidget::snapshot
    {30, 497, 534},	// Phonon::VideoWidget::staticMetaObject
    {30, 521, 531},	// Phonon::VideoWidget::tr$
    {30, 522, 506},	// Phonon::VideoWidget::tr$$
    {30, 523, 508},	// Phonon::VideoWidget::tr$$$
    {30, 525, 532},	// Phonon::VideoWidget::trUtf8$
    {30, 526, 507},	// Phonon::VideoWidget::trUtf8$$
    {30, 527, 509},	// Phonon::VideoWidget::trUtf8$$$
    {30, 565, 541},	// Phonon::VideoWidget::~VideoWidget
    {32, 63, 566},	// Phonon::VolumeFaderEffect::Fade12Decibel
    {32, 64, 563},	// Phonon::VolumeFaderEffect::Fade3Decibel
    {32, 65, 564},	// Phonon::VolumeFaderEffect::Fade6Decibel
    {32, 66, 565},	// Phonon::VolumeFaderEffect::Fade9Decibel
    {32, 145, 561},	// Phonon::VolumeFaderEffect::VolumeFaderEffect
    {32, 146, 549},	// Phonon::VolumeFaderEffect::VolumeFaderEffect#
    {32, 248, 552},	// Phonon::VolumeFaderEffect::fadeCurve
    {32, 250, 553},	// Phonon::VolumeFaderEffect::fadeIn$
    {32, 252, 554},	// Phonon::VolumeFaderEffect::fadeOut$
    {32, 254, 558},	// Phonon::VolumeFaderEffect::fadeTo$$
    {32, 303, 542},	// Phonon::VolumeFaderEffect::metaObject
    {32, 372, 548},	// Phonon::VolumeFaderEffect::qt_metacall$$?
    {32, 374, 543},	// Phonon::VolumeFaderEffect::qt_metacast$
    {32, 428, 557},	// Phonon::VolumeFaderEffect::setFadeCurve$
    {32, 485, 555},	// Phonon::VolumeFaderEffect::setVolume$
    {32, 487, 556},	// Phonon::VolumeFaderEffect::setVolumeDecibel$
    {32, 497, 562},	// Phonon::VolumeFaderEffect::staticMetaObject
    {32, 521, 559},	// Phonon::VolumeFaderEffect::tr$
    {32, 522, 544},	// Phonon::VolumeFaderEffect::tr$$
    {32, 523, 546},	// Phonon::VolumeFaderEffect::tr$$$
    {32, 525, 560},	// Phonon::VolumeFaderEffect::trUtf8$
    {32, 526, 545},	// Phonon::VolumeFaderEffect::trUtf8$$
    {32, 527, 547},	// Phonon::VolumeFaderEffect::trUtf8$$$
    {32, 537, 550},	// Phonon::VolumeFaderEffect::volume
    {32, 540, 551},	// Phonon::VolumeFaderEffect::volumeDecibel
    {32, 566, 567},	// Phonon::VolumeFaderEffect::~VolumeFaderEffect
    {33, 147, 595},	// Phonon::VolumeSlider::VolumeSlider
    {33, 148, -45},	// Phonon::VolumeSlider::VolumeSlider#
    {33, 149, 576},	// Phonon::VolumeSlider::VolumeSlider##
    {33, 157, 587},	// Phonon::VolumeSlider::audioOutput
    {33, 265, 577},	// Phonon::VolumeSlider::hasTracking
    {33, 272, 584},	// Phonon::VolumeSlider::iconSize
    {33, 285, 583},	// Phonon::VolumeSlider::isMuteVisible
    {33, 298, 585},	// Phonon::VolumeSlider::maximumVolume
    {33, 303, 568},	// Phonon::VolumeSlider::metaObject
    {33, 345, 586},	// Phonon::VolumeSlider::orientation
    {33, 350, 579},	// Phonon::VolumeSlider::pageStep
    {33, 372, 574},	// Phonon::VolumeSlider::qt_metacall$$?
    {33, 374, 569},	// Phonon::VolumeSlider::qt_metacast$
    {33, 401, 592},	// Phonon::VolumeSlider::setAudioOutput#
    {33, 434, 591},	// Phonon::VolumeSlider::setIconSize#
    {33, 438, 588},	// Phonon::VolumeSlider::setMaximumVolume$
    {33, 444, 590},	// Phonon::VolumeSlider::setMuteVisible$
    {33, 450, 589},	// Phonon::VolumeSlider::setOrientation$
    {33, 454, 580},	// Phonon::VolumeSlider::setPageStep$
    {33, 466, 582},	// Phonon::VolumeSlider::setSingleStep$
    {33, 480, 578},	// Phonon::VolumeSlider::setTracking$
    {33, 489, 581},	// Phonon::VolumeSlider::singleStep
    {33, 497, 597},	// Phonon::VolumeSlider::staticMetaObject
    {33, 521, 593},	// Phonon::VolumeSlider::tr$
    {33, 522, 570},	// Phonon::VolumeSlider::tr$$
    {33, 523, 572},	// Phonon::VolumeSlider::tr$$$
    {33, 525, 594},	// Phonon::VolumeSlider::trUtf8$
    {33, 526, 571},	// Phonon::VolumeSlider::trUtf8$$
    {33, 527, 573},	// Phonon::VolumeSlider::trUtf8$$$
    {33, 567, 598},	// Phonon::VolumeSlider::~VolumeSlider
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();
SMOKE_IMPORT void init_qtgui_Smoke();

static bool initialized = false;
Smoke *phonon_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_phonon_Smoke() {
    init_qtcore_Smoke();
    init_qtgui_Smoke();
    if (initialized) return;
    phonon_Smoke = new Smoke(
        "phonon",
        __smokephonon::classes, 75,
        __smokephonon::methods, 649,
        __smokephonon::methodMaps, 572,
        __smokephonon::methodNames, 567,
        __smokephonon::types, 274,
        __smokephonon::inheritanceList,
        __smokephonon::argumentList,
        __smokephonon::ambiguousMethodList,
        __smokephonon::cast );
    initialized = true;
}

void delete_phonon_Smoke() { delete phonon_Smoke; }

}
