/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.22 from the
 * contents of GstStructure.xs. Do not edit this file, edit GstStructure.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "xs/GstStructure.xs"
/*
 * Copyright (C) 2005 by the gtk2-perl team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * $Id$
 */

#include "gst2perl.h"

/* ------------------------------------------------------------------------- */

/* SvGstStructure returns a newly allocated structure which does *not* get
 * freed when the next LEAVE is reached.  So the caller must take ownership. */
GstStructure *
SvGstStructure (SV *sv)
{
	GstStructure *structure;
	HV *hv;
	SV **name, **fields;

	if (!gperl_sv_is_hash_ref (sv))
		croak ("GstStructure must be a hash reference");

	hv = (HV *) SvRV (sv);

	name = hv_fetch (hv, "name", 4, 0);
	if (!name || !gperl_sv_is_defined (*name))
		croak ("GstStructure must contain a 'name' key");

	/* This leaks the structure when we croak further down, but I think
	 * that's ok since errors here are rather fatal. */
	structure = gst_structure_empty_new (SvPV_nolen (*name));

	fields = hv_fetch (hv, "fields", 6, 0);
	if (fields && gperl_sv_is_defined (*fields)) {
		AV *fields_av;
		int i;

		if (!SvRV (*fields) || SvTYPE (SvRV (*fields)) != SVt_PVAV)
			croak ("The value of the 'fields' key must be an array reference");

		fields_av = (AV *) SvRV (*fields);

		for (i = 0; i <= av_len (fields_av); i++) {
			SV **field, **field_name, **field_type, **field_value;
			AV *field_av;

			field = av_fetch (fields_av, i, 0);

			if (!field || !gperl_sv_is_array_ref (*field))
				croak ("The 'fields' array must contain array references");

			field_av = (AV *) SvRV (*field);

			if (av_len (field_av) != 2)
				croak ("The arrays in the 'fields' array must contain three values: name, type, and value");

			field_name = av_fetch (field_av, 0, 0);
			field_type = av_fetch (field_av, 1, 0);
			field_value = av_fetch (field_av, 2, 0);

			if (field_name && gperl_sv_is_defined (*field_name) &&
			    field_type && gperl_sv_is_defined (*field_type) &&
			    field_value && gperl_sv_is_defined (*field_value)) {
				GValue value = { 0, };

				const char *package = SvPV_nolen (*field_type);
				GType type = gperl_type_from_package (package);
				if (!type)
					croak ("unregistered package %s encountered", package);

				g_value_init (&value, type);
				gperl_value_from_sv (&value, *field_value);
				gst_structure_set_value (structure, SvGChar (*field_name), &value);

				g_value_unset (&value);
			}
		}
	}

	return structure;
}

static gboolean
fill_av (GQuark field_id,
         const GValue *value,
         gpointer user_data)
{
	AV *field, *fields = (AV *) user_data;

	const gchar *id = g_quark_to_string (field_id);
	const char *type = gperl_package_from_type (G_VALUE_TYPE (value));

	/* Use the C name if there's no Perl name. */
	if (!type)
		type = g_type_name (G_VALUE_TYPE (value));

	field = newAV ();

	av_push (field, newSVGChar (id));
	av_push (field, newSVpv (type, 0));
	av_push (field, gperl_sv_from_value (value));

	av_push (fields, newRV_noinc ((SV *) field));

	return TRUE;
}

SV *
newSVGstStructure (const GstStructure *structure)
{
	HV *hv;
	AV *av;
	const gchar *name;

	if (!structure)
		return &PL_sv_undef;

	hv = newHV ();
	av = newAV ();

	name = gst_structure_get_name (structure);
	hv_store (hv, "name", 4, newSVGChar (name), 0);

	gst_structure_foreach (structure, fill_av, av);
	hv_store (hv, "fields", 6, newRV_noinc ((SV *) av), 0);

	return newRV_noinc ((SV *) hv);
}

/* ------------------------------------------------------------------------- */

#line 157 "xs/GstStructure.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)    S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage        S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 299 "xs/GstStructure.c"

XS_EUPXS(XS_GStreamer__Structure_to_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_GStreamer__Structure_to_string)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "structure");
    {
	gchar_own *	RETVAL;
	const GstStructure *	structure = SvGstStructure (ST(0))
;

	RETVAL = gst_structure_to_string(structure);
	ST(0) = sv_newmortal();
	/* used when we can directly own the returned string. */
	/* we have to copy in the case when perl's malloc != gtk's malloc,
         * so best copy all the time. */
	sv_setpv ((SV*)ST(0), RETVAL);
	SvUTF8_on (ST(0));
        g_free (RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_GStreamer__Structure_from_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_GStreamer__Structure_from_string)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "string");
    {
	const gchar *	string;
#line 175 "xs/GstStructure.xs"
	gchar *end = NULL;
#line 335 "xs/GstStructure.c"
	GstStructure *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(0));
	string = (const gchar *)SvPV_nolen (ST(0))
;
#line 177 "xs/GstStructure.xs"
	RETVAL = gst_structure_from_string (string, &end);
#line 344 "xs/GstStructure.c"
	ST(0) = newSVGstStructure (RETVAL);
	sv_2mortal(ST(0));
#line 181 "xs/GstStructure.xs"
	if (RETVAL)
		gst_structure_free (RETVAL);
#line 350 "xs/GstStructure.c"
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_GStreamer__Structure); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_GStreamer__Structure)
{
    dVAR; dXSARGS;
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK;

        newXS("GStreamer::Structure::to_string", XS_GStreamer__Structure_to_string, file);
        newXS("GStreamer::Structure::from_string", XS_GStreamer__Structure_from_string, file);
#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

