/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.22 from the
 * contents of Cairo.xs. Do not edit this file, edit Cairo.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "Cairo.xs"
/*
 * Copyright (c) 2004-2013 by the cairo perl team (see the file README)
 *
 * Licensed under the LGPL, see LICENSE file for more information.
 *
 * $Id$
 *
 */

#include <cairo-perl.h>
#include <cairo-perl-private.h>

#define NEED_newRV_noinc_GLOBAL
#include "ppport.h"

/* ------------------------------------------------------------------------- */

static void
call_xs (pTHX_ void (*subaddr) (pTHX_ CV *), CV * cv, SV ** mark)
{
	dSP;
	PUSHMARK (mark);
	(*subaddr) (aTHX_ cv);
	PUTBACK;	/* forget return values */
}

#ifndef XS_EXTERNAL
# define XS_EXTERNAL(name) XS(name)
#endif
#define CAIRO_PERL_CALL_BOOT(name)				\
	{							\
		extern XS_EXTERNAL (name);			\
		call_xs (aTHX_ name, cv, mark);	\
	}

/* ------------------------------------------------------------------------- */

/* Copied from Glib/Glib.xs. */
void *
cairo_perl_alloc_temp (int nbytes)
{
	dTHR;
	SV * s;

	if (nbytes <= 0) return NULL;

	s = sv_2mortal (NEWSV (0, nbytes));
	memset (SvPVX (s), 0, nbytes);
	return SvPVX (s);
}

/* Copied from Glib/GType.xs. */
void
cairo_perl_set_isa (const char *child_package,
                    const char *parent_package)
{
	char *child_isa_full;
	AV *isa;

	New (0, child_isa_full, strlen(child_package) + 5 + 1, char);
	child_isa_full = strcpy (child_isa_full, child_package);
	child_isa_full = strcat (child_isa_full, "::ISA");
	isa = get_av (child_isa_full, TRUE); /* create on demand */
	Safefree (child_isa_full);

	av_push (isa, newSVpv (parent_package, 0));
}

/* Copied from Glib/Glib.xs. */
cairo_bool_t
cairo_perl_sv_is_defined (SV *sv)
{
	/* This is adapted from PP(pp_defined) in perl's pp.c */

	if (!sv || !SvANY(sv))
		return FALSE;

	switch (SvTYPE(sv)) {
	    case SVt_PVAV:
		if (AvMAX(sv) >= 0 || SvGMAGICAL(sv)
		    || (SvRMAGICAL(sv) && mg_find(sv, PERL_MAGIC_tied)))
			return TRUE;
		break;
	    case SVt_PVHV:
		if (HvARRAY(sv) || SvGMAGICAL(sv)
		    || (SvRMAGICAL(sv) && mg_find(sv, PERL_MAGIC_tied)))
			return TRUE;
		break;
	    case SVt_PVCV:
		if (CvROOT(sv) || CvXSUB(sv))
			return TRUE;
		break;
	    default:
		if (SvGMAGICAL(sv))
			mg_get(sv);
		if (SvOK(sv))
			return TRUE;
	}

	return FALSE;
}

/* ------------------------------------------------------------------------- */

void *
cairo_object_from_sv (SV *sv, const char *package)
{
	if (!cairo_perl_sv_is_ref (sv) || !sv_derived_from (sv, package))
		croak("Cannot convert scalar %p to an object of type %s",
		      sv, package);
	return INT2PTR (void *, SvIV ((SV *) SvRV (sv)));
}

SV *
cairo_object_to_sv (void *object, const char *package)
{
	SV *sv = newSV (0);
	sv_setref_pv(sv, package, object);
	return sv;
}

/* ------------------------------------------------------------------------- */

void *
cairo_struct_from_sv (SV *sv, const char *package)
{
	if (!cairo_perl_sv_is_ref (sv) || !sv_derived_from (sv, package))
		croak("Cannot convert scalar %p to a struct of type %s",
		      sv, package);
	return INT2PTR (void *, SvIV ((SV *) SvRV (sv)));
}

SV *
cairo_struct_to_sv (void *object, const char *package)
{
	SV *sv = newSV (0);
	sv_setref_pv(sv, package, object);
	return sv;
}

/* ------------------------------------------------------------------------- */

SV *
newSVCairoFontExtents (cairo_font_extents_t *extents)
{
	HV *hv;
	double value;

	if (!extents)
		return &PL_sv_undef;

	hv = newHV ();

	value = extents->ascent;
	hv_store (hv, "ascent", 6, newSVnv (value), 0);

	value = extents->descent;
	hv_store (hv, "descent", 7, newSVnv (value), 0);

	value = extents->height;
	hv_store (hv, "height", 6, newSVnv (value), 0);

	value = extents->max_x_advance;
	hv_store (hv, "max_x_advance", 13, newSVnv (value), 0);

	value = extents->max_y_advance;
	hv_store (hv, "max_y_advance", 13, newSVnv (value), 0);

	return newRV_noinc ((SV *) hv);
}

/* ------------------------------------------------------------------------- */

SV *
newSVCairoTextExtents (cairo_text_extents_t *extents)
{
	HV *hv;
	double value;

	if (!extents)
		return &PL_sv_undef;

	hv = newHV ();

	value = extents->x_bearing;
	hv_store (hv, "x_bearing", 9, newSVnv (value), 0);

	value = extents->y_bearing;
	hv_store (hv, "y_bearing", 9, newSVnv (value), 0);

	value = extents->width;
	hv_store (hv, "width", 5, newSVnv (value), 0);

	value = extents->height;
	hv_store (hv, "height", 6, newSVnv (value), 0);

	value = extents->x_advance;
	hv_store (hv, "x_advance", 9, newSVnv (value), 0);

	value = extents->y_advance;
	hv_store (hv, "y_advance", 9, newSVnv (value), 0);

	return newRV_noinc ((SV *) hv);
}

/* ------------------------------------------------------------------------- */

SV *
newSVCairoGlyph (cairo_glyph_t *glyph)
{
	HV *hv;
	unsigned long index;
	double value;

	if (!glyph)
		return &PL_sv_undef;

	hv = newHV ();

	index = glyph->index;
	hv_store (hv, "index", 5, newSVuv (index), 0);

	value = glyph->x;
	hv_store (hv, "x", 1, newSVnv (value), 0);

	value = glyph->y;
	hv_store (hv, "y", 1, newSVnv (value), 0);

	return newRV_noinc ((SV *) hv);
}

cairo_glyph_t *
SvCairoGlyph (SV *sv)
{
	HV *hv;
	SV **value;
	cairo_glyph_t *glyph;

	if (!cairo_perl_sv_is_hash_ref (sv))
		croak ("cairo_glyph_t must be a hash reference");

	hv = (HV *) SvRV (sv);
	glyph = cairo_perl_alloc_temp (sizeof (cairo_glyph_t));

	value = hv_fetch (hv, "index", 5, 0);
	if (value && SvOK (*value))
		glyph->index = SvUV (*value);

	value = hv_fetch (hv, "x", 1, 0);
	if (value && SvOK (*value))
		glyph->x = SvNV (*value);

	value = hv_fetch (hv, "y", 1, 0);
	if (value && SvOK (*value))
		glyph->y = SvNV (*value);

	return glyph;
}

/* ------------------------------------------------------------------------- */

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 4, 0)

SV *
newSVCairoRectangle (cairo_rectangle_t *rectangle)
{
	HV *hv;

	if (!rectangle)
		return &PL_sv_undef;

	hv = newHV ();

	hv_store (hv, "x", 1, newSVnv (rectangle->x), 0);
	hv_store (hv, "y", 1, newSVnv (rectangle->y), 0);
	hv_store (hv, "width", 5, newSVnv (rectangle->width), 0);
	hv_store (hv, "height", 6, newSVnv (rectangle->height), 0);

	return newRV_noinc ((SV *) hv);
}

cairo_rectangle_t *
SvCairoRectangle (SV *sv)
{
	HV *hv;
	SV **value;
	cairo_rectangle_t *rectangle;

	if (!cairo_perl_sv_is_hash_ref (sv))
		croak ("cairo_rectangle_t must be a hash reference");

	hv = (HV *) SvRV (sv);
	rectangle = cairo_perl_alloc_temp (sizeof (cairo_rectangle_t));

	value = hv_fetchs (hv, "x", 0);
	if (value && SvOK (*value))
		rectangle->x = SvNV (*value);

	value = hv_fetchs (hv, "y", 0);
	if (value && SvOK (*value))
		rectangle->y = SvNV (*value);

	value = hv_fetchs (hv, "width", 0);
	if (value && SvOK (*value))
		rectangle->width = SvNV (*value);

	value = hv_fetchs (hv, "height", 0);
	if (value && SvOK (*value))
		rectangle->height = SvNV (*value);

	return rectangle;
}

#endif

/* ------------------------------------------------------------------------- */

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 10, 0)

SV *
newSVCairoRectangleInt (cairo_rectangle_int_t *rectangle)
{
	HV *hv;

	if (!rectangle)
		return &PL_sv_undef;

	hv = newHV ();

	hv_store (hv, "x", 1, newSViv (rectangle->x), 0);
	hv_store (hv, "y", 1, newSViv (rectangle->y), 0);
	hv_store (hv, "width", 5, newSViv (rectangle->width), 0);
	hv_store (hv, "height", 6, newSViv (rectangle->height), 0);

	return newRV_noinc ((SV *) hv);
}

cairo_rectangle_int_t *
SvCairoRectangleInt (SV *sv)
{
	HV *hv;
	SV **value;
	cairo_rectangle_int_t *rectangle;

	if (!cairo_perl_sv_is_hash_ref (sv))
		croak ("cairo_rectangle_int_t must be a hash reference");

	hv = (HV *) SvRV (sv);
	rectangle = cairo_perl_alloc_temp (sizeof (cairo_rectangle_t));

	value = hv_fetchs (hv, "x", 0);
	if (value && SvOK (*value))
		rectangle->x = SvIV (*value);

	value = hv_fetchs (hv, "y", 0);
	if (value && SvOK (*value))
		rectangle->y = SvIV (*value);

	value = hv_fetchs (hv, "width", 0);
	if (value && SvOK (*value))
		rectangle->width = SvIV (*value);

	value = hv_fetchs (hv, "height", 0);
	if (value && SvOK (*value))
		rectangle->height = SvIV (*value);

	return rectangle;
}

#endif

/* ------------------------------------------------------------------------- */

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 8, 0)

SV *
newSVCairoTextCluster (cairo_text_cluster_t *cluster)
{
	HV *hv;

	if (!cluster)
		return &PL_sv_undef;

	hv = newHV ();

	hv_store (hv, "num_bytes", 9, newSViv (cluster->num_bytes), 0);
	hv_store (hv, "num_glyphs", 10, newSVnv (cluster->num_glyphs), 0);

	return newRV_noinc ((SV *) hv);
}

cairo_text_cluster_t *
SvCairoTextCluster (SV *sv)
{
	HV *hv;
	SV **value;
	cairo_text_cluster_t *cluster;

	if (!cairo_perl_sv_is_hash_ref (sv))
		croak ("cairo_text_cluster_t must be a hash reference");

	hv = (HV *) SvRV (sv);
	cluster = cairo_perl_alloc_temp (sizeof (cairo_text_cluster_t));

	value = hv_fetch (hv, "num_bytes", 9, 0);
	if (value && SvOK (*value))
		cluster->num_bytes = SvIV (*value);

	value = hv_fetch (hv, "num_glyphs", 10, 0);
	if (value && SvOK (*value))
		cluster->num_glyphs = SvIV (*value);

	return cluster;
}

#endif

/* ------------------------------------------------------------------------- */

#line 430 "Cairo.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)    S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage        S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 572 "Cairo.c"

XS_EUPXS(XS_Cairo_LIB_VERSION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo_LIB_VERSION)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
	int	RETVAL;
	dXSTARG;
#line 431 "Cairo.xs"
	PERL_UNUSED_VAR (items);
	RETVAL = CAIRO_VERSION;
#line 585 "Cairo.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo_LIB_VERSION_ENCODE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo_LIB_VERSION_ENCODE)
{
    dVAR; dXSARGS;
    dXSI32;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 440 "Cairo.xs"
	int major, minor, micro;
#line 601 "Cairo.c"
	int	RETVAL;
	dXSTARG;
#line 442 "Cairo.xs"
	PERL_UNUSED_VAR (ix);
	if (items == 3) {
		major = SvIV (ST (0));
		minor = SvIV (ST (1));
		micro = SvIV (ST (2));
	} else if (items == 4) {
		major = SvIV (ST (1));
		minor = SvIV (ST (2));
		micro = SvIV (ST (3));
	} else {
		croak ("Usage: Cairo::LIB_VERSION_ENCODE (major, minor, micro) or Cairo->LIB_VERSION_ENCODE (major, minor, micro)");
	}

	RETVAL = CAIRO_VERSION_ENCODE (major, minor, micro);
#line 619 "Cairo.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo_version)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "class=NULL");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = cairo_version(/* void */);
	XSprePUSH; PUSHi((IV)RETVAL);
#line 466 "Cairo.xs"
	PERL_UNUSED_VAR (ix);
#line 641 "Cairo.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo_version_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo_version_string)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "class=NULL");
    {
	const char *	RETVAL;
	dXSTARG;

	RETVAL = cairo_version_string(/* void */);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
#line 475 "Cairo.xs"
	PERL_UNUSED_VAR (ix);
#line 662 "Cairo.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_create); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_create)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, target");
    {
	cairo_t_noinc *	RETVAL;
	cairo_surface_t *	target = SvCairoSurface (ST(1))
;

	RETVAL = cairo_create(target);
	ST(0) = newSVCairo_noinc (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
#line 487 "Cairo.xs"
	cairo_destroy (cr);
#line 698 "Cairo.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_save); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_save)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_save(cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_restore); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_restore)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_restore(cr);
    }
    XSRETURN_EMPTY;
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 2, 0)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Cairo__Context_push_group); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_push_group)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_push_group(cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_push_group_with_content); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_push_group_with_content)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, content");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	cairo_content_t	content = SvCairoContent (ST(1))
;

	cairo_push_group_with_content(cr, content);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_pop_group); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_pop_group)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_pattern_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_pop_group(cr);
	ST(0) = newSVCairoPattern (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_pop_group_to_source); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_pop_group_to_source)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_pop_group_to_source(cr);
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Cairo__Context_set_operator); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_operator)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, op");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	cairo_operator_t	op = SvCairoOperator (ST(1))
;

	cairo_set_operator(cr, op);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_source_rgb); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_source_rgb)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "cr, red, green, blue");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	red = (double)SvNV(ST(1))
;
	double	green = (double)SvNV(ST(2))
;
	double	blue = (double)SvNV(ST(3))
;

	cairo_set_source_rgb(cr, red, green, blue);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_source_rgba); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_source_rgba)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "cr, red, green, blue, alpha");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	red = (double)SvNV(ST(1))
;
	double	green = (double)SvNV(ST(2))
;
	double	blue = (double)SvNV(ST(3))
;
	double	alpha = (double)SvNV(ST(4))
;

	cairo_set_source_rgba(cr, red, green, blue, alpha);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_source); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_source)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, source");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	cairo_pattern_t *	source = SvCairoPattern (ST(1))
;

	cairo_set_source(cr, source);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_source_surface); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_source_surface)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "cr, surface, x, y");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	cairo_surface_t *	surface = SvCairoSurface (ST(1))
;
	double	x = (double)SvNV(ST(2))
;
	double	y = (double)SvNV(ST(3))
;

	cairo_set_source_surface(cr, surface, x, y);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_tolerance); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_tolerance)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, tolerance");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	tolerance = (double)SvNV(ST(1))
;

	cairo_set_tolerance(cr, tolerance);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_antialias); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_antialias)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, antialias");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	cairo_antialias_t	antialias = SvCairoAntialias (ST(1))
;

	cairo_set_antialias(cr, antialias);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_fill_rule); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_fill_rule)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, fill_rule");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	cairo_fill_rule_t	fill_rule = SvCairoFillRule (ST(1))
;

	cairo_set_fill_rule(cr, fill_rule);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_line_width); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_line_width)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, width");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	width = (double)SvNV(ST(1))
;

	cairo_set_line_width(cr, width);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_line_cap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_line_cap)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, line_cap");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	cairo_line_cap_t	line_cap = SvCairoLineCap (ST(1))
;

	cairo_set_line_cap(cr, line_cap);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_line_join); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_line_join)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, line_join");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	cairo_line_join_t	line_join = SvCairoLineJoin (ST(1))
;

	cairo_set_line_join(cr, line_join);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_dash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_dash)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "cr, offset, ...");
    {
#line 530 "Cairo.xs"
	int i, n;
	double *pts;
#line 1031 "Cairo.c"
	cairo_t *	cr = SvCairo (ST(0))
;
	double	offset = (double)SvNV(ST(1))
;
#line 533 "Cairo.xs"
#define FIRST 2
	n = (items - FIRST);
	if (n == 0) {
		pts = NULL;
	} else {
		New (0, pts, n, double);
		if (!pts)
			croak ("malloc failure for (%d) elements", n);
		for (i = FIRST ; i < items ; i++)
			pts[i - FIRST] = SvNV (ST (i));
	}
#undef FIRST
	cairo_set_dash (cr, pts, n, offset);
#line 1050 "Cairo.c"
#line 547 "Cairo.xs"
	if (pts)
		Safefree (pts);
#line 1054 "Cairo.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_miter_limit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_miter_limit)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, limit");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	limit = (double)SvNV(ST(1))
;

	cairo_set_miter_limit(cr, limit);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_translate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_translate)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, tx, ty");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	tx = (double)SvNV(ST(1))
;
	double	ty = (double)SvNV(ST(2))
;

	cairo_translate(cr, tx, ty);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_scale); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_scale)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, sx, sy");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	sx = (double)SvNV(ST(1))
;
	double	sy = (double)SvNV(ST(2))
;

	cairo_scale(cr, sx, sy);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_rotate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_rotate)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, angle");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	angle = (double)SvNV(ST(1))
;

	cairo_rotate(cr, angle);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_transform); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_transform)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, matrix");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	const cairo_matrix_t *	matrix = SvCairoMatrix (ST(1))
;

	cairo_transform(cr, matrix);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_matrix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_matrix)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, matrix");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	const cairo_matrix_t *	matrix = SvCairoMatrix (ST(1))
;

	cairo_set_matrix(cr, matrix);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_identity_matrix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_identity_matrix)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_identity_matrix(cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_user_to_device); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_user_to_device)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, x, y");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x = (double)SvNV(ST(1))
;
	double	y = (double)SvNV(ST(2))
;

	cairo_user_to_device(cr, &x, &y);
	XSprePUSH;	EXTEND(SP,2);
	PUSHs(sv_newmortal());
	sv_setnv(ST(0), (double)x);
	PUSHs(sv_newmortal());
	sv_setnv(ST(1), (double)y);
    }
    XSRETURN(2);
}


XS_EUPXS(XS_Cairo__Context_user_to_device_distance); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_user_to_device_distance)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, dx, dy");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	dx = (double)SvNV(ST(1))
;
	double	dy = (double)SvNV(ST(2))
;

	cairo_user_to_device_distance(cr, &dx, &dy);
	XSprePUSH;	EXTEND(SP,2);
	PUSHs(sv_newmortal());
	sv_setnv(ST(0), (double)dx);
	PUSHs(sv_newmortal());
	sv_setnv(ST(1), (double)dy);
    }
    XSRETURN(2);
}


XS_EUPXS(XS_Cairo__Context_device_to_user); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_device_to_user)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, x, y");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x = (double)SvNV(ST(1))
;
	double	y = (double)SvNV(ST(2))
;

	cairo_device_to_user(cr, &x, &y);
	XSprePUSH;	EXTEND(SP,2);
	PUSHs(sv_newmortal());
	sv_setnv(ST(0), (double)x);
	PUSHs(sv_newmortal());
	sv_setnv(ST(1), (double)y);
    }
    XSRETURN(2);
}


XS_EUPXS(XS_Cairo__Context_device_to_user_distance); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_device_to_user_distance)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, dx, dy");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	dx = (double)SvNV(ST(1))
;
	double	dy = (double)SvNV(ST(2))
;

	cairo_device_to_user_distance(cr, &dx, &dy);
	XSprePUSH;	EXTEND(SP,2);
	PUSHs(sv_newmortal());
	sv_setnv(ST(0), (double)dx);
	PUSHs(sv_newmortal());
	sv_setnv(ST(1), (double)dy);
    }
    XSRETURN(2);
}


XS_EUPXS(XS_Cairo__Context_new_path); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_new_path)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_new_path(cr);
    }
    XSRETURN_EMPTY;
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 2, 0)
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Cairo__Context_new_sub_path); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_new_sub_path)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_new_sub_path(cr);
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Cairo__Context_move_to); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_move_to)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, x, y");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x = (double)SvNV(ST(1))
;
	double	y = (double)SvNV(ST(2))
;

	cairo_move_to(cr, x, y);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_line_to); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_line_to)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, x, y");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x = (double)SvNV(ST(1))
;
	double	y = (double)SvNV(ST(2))
;

	cairo_line_to(cr, x, y);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_curve_to); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_curve_to)
{
    dVAR; dXSARGS;
    if (items != 7)
       croak_xs_usage(cv,  "cr, x1, y1, x2, y2, x3, y3");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x1 = (double)SvNV(ST(1))
;
	double	y1 = (double)SvNV(ST(2))
;
	double	x2 = (double)SvNV(ST(3))
;
	double	y2 = (double)SvNV(ST(4))
;
	double	x3 = (double)SvNV(ST(5))
;
	double	y3 = (double)SvNV(ST(6))
;

	cairo_curve_to(cr, x1, y1, x2, y2, x3, y3);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_arc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_arc)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "cr, xc, yc, radius, angle1, angle2");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	xc = (double)SvNV(ST(1))
;
	double	yc = (double)SvNV(ST(2))
;
	double	radius = (double)SvNV(ST(3))
;
	double	angle1 = (double)SvNV(ST(4))
;
	double	angle2 = (double)SvNV(ST(5))
;

	cairo_arc(cr, xc, yc, radius, angle1, angle2);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_arc_negative); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_arc_negative)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "cr, xc, yc, radius, angle1, angle2");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	xc = (double)SvNV(ST(1))
;
	double	yc = (double)SvNV(ST(2))
;
	double	radius = (double)SvNV(ST(3))
;
	double	angle1 = (double)SvNV(ST(4))
;
	double	angle2 = (double)SvNV(ST(5))
;

	cairo_arc_negative(cr, xc, yc, radius, angle1, angle2);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_rel_move_to); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_rel_move_to)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, dx, dy");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	dx = (double)SvNV(ST(1))
;
	double	dy = (double)SvNV(ST(2))
;

	cairo_rel_move_to(cr, dx, dy);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_rel_line_to); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_rel_line_to)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, dx, dy");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	dx = (double)SvNV(ST(1))
;
	double	dy = (double)SvNV(ST(2))
;

	cairo_rel_line_to(cr, dx, dy);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_rel_curve_to); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_rel_curve_to)
{
    dVAR; dXSARGS;
    if (items != 7)
       croak_xs_usage(cv,  "cr, dx1, dy1, dx2, dy2, dx3, dy3");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	dx1 = (double)SvNV(ST(1))
;
	double	dy1 = (double)SvNV(ST(2))
;
	double	dx2 = (double)SvNV(ST(3))
;
	double	dy2 = (double)SvNV(ST(4))
;
	double	dx3 = (double)SvNV(ST(5))
;
	double	dy3 = (double)SvNV(ST(6))
;

	cairo_rel_curve_to(cr, dx1, dy1, dx2, dy2, dx3, dy3);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_rectangle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_rectangle)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "cr, x, y, width, height");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x = (double)SvNV(ST(1))
;
	double	y = (double)SvNV(ST(2))
;
	double	width = (double)SvNV(ST(3))
;
	double	height = (double)SvNV(ST(4))
;

	cairo_rectangle(cr, x, y, width, height);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_close_path); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_close_path)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_close_path(cr);
    }
    XSRETURN_EMPTY;
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 6, 0)
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Cairo__Context_path_extents); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_path_extents)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x1;
	double	y1;
	double	x2;
	double	y2;

	cairo_path_extents(cr, &x1, &y1, &x2, &y2);
	XSprePUSH;	EXTEND(SP,4);
	PUSHs(sv_newmortal());
	sv_setnv(ST(0), (double)x1);
	PUSHs(sv_newmortal());
	sv_setnv(ST(1), (double)y1);
	PUSHs(sv_newmortal());
	sv_setnv(ST(2), (double)x2);
	PUSHs(sv_newmortal());
	sv_setnv(ST(3), (double)y2);
    }
    XSRETURN(4);
}

#endif

XS_EUPXS(XS_Cairo__Context_paint); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_paint)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_paint(cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_paint_with_alpha); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_paint_with_alpha)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, alpha");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	alpha = (double)SvNV(ST(1))
;

	cairo_paint_with_alpha(cr, alpha);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_mask); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_mask)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, pattern");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	cairo_pattern_t *	pattern = SvCairoPattern (ST(1))
;

	cairo_mask(cr, pattern);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_mask_surface); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_mask_surface)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "cr, surface, surface_x, surface_y");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	cairo_surface_t *	surface = SvCairoSurface (ST(1))
;
	double	surface_x = (double)SvNV(ST(2))
;
	double	surface_y = (double)SvNV(ST(3))
;

	cairo_mask_surface(cr, surface, surface_x, surface_y);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_stroke); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_stroke)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_stroke(cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_stroke_preserve); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_stroke_preserve)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_stroke_preserve(cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_fill); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_fill)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_fill(cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_fill_preserve); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_fill_preserve)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_fill_preserve(cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_copy_page); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_copy_page)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_copy_page(cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_show_page); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_show_page)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_show_page(cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_in_stroke); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_in_stroke)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, x, y");
    {
	int	RETVAL;
	dXSTARG;
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x = (double)SvNV(ST(1))
;
	double	y = (double)SvNV(ST(2))
;

	RETVAL = cairo_in_stroke(cr, x, y);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_in_fill); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_in_fill)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, x, y");
    {
	int	RETVAL;
	dXSTARG;
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x = (double)SvNV(ST(1))
;
	double	y = (double)SvNV(ST(2))
;

	RETVAL = cairo_in_fill(cr, x, y);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_stroke_extents); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_stroke_extents)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x1;
	double	y1;
	double	x2;
	double	y2;

	cairo_stroke_extents(cr, &x1, &y1, &x2, &y2);
	XSprePUSH;	EXTEND(SP,4);
	PUSHs(sv_newmortal());
	sv_setnv(ST(0), (double)x1);
	PUSHs(sv_newmortal());
	sv_setnv(ST(1), (double)y1);
	PUSHs(sv_newmortal());
	sv_setnv(ST(2), (double)x2);
	PUSHs(sv_newmortal());
	sv_setnv(ST(3), (double)y2);
    }
    XSRETURN(4);
}


XS_EUPXS(XS_Cairo__Context_fill_extents); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_fill_extents)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x1;
	double	y1;
	double	x2;
	double	y2;

	cairo_fill_extents(cr, &x1, &y1, &x2, &y2);
	XSprePUSH;	EXTEND(SP,4);
	PUSHs(sv_newmortal());
	sv_setnv(ST(0), (double)x1);
	PUSHs(sv_newmortal());
	sv_setnv(ST(1), (double)y1);
	PUSHs(sv_newmortal());
	sv_setnv(ST(2), (double)x2);
	PUSHs(sv_newmortal());
	sv_setnv(ST(3), (double)y2);
    }
    XSRETURN(4);
}


XS_EUPXS(XS_Cairo__Context_clip); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_clip)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_clip(cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_clip_preserve); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_clip_preserve)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_clip_preserve(cr);
    }
    XSRETURN_EMPTY;
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 4, 0)
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Cairo__Context_copy_clip_rectangle_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_copy_clip_rectangle_list)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 643 "Cairo.xs"
	cairo_rectangle_list_t *list;
	int i;
#line 1906 "Cairo.c"
	cairo_t *	cr = SvCairo (ST(0))
;
#line 646 "Cairo.xs"
	list = cairo_copy_clip_rectangle_list (cr);
	CAIRO_PERL_CHECK_STATUS (list->status);
	EXTEND (sp, list->num_rectangles);
	for (i = 0; i < list->num_rectangles; i++)
		PUSHs (sv_2mortal (newSVCairoRectangle (&(list->rectangles[i]))));
	cairo_rectangle_list_destroy (list);
#line 1916 "Cairo.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Cairo__Context_clip_extents); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_clip_extents)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x1;
	double	y1;
	double	x2;
	double	y2;

	cairo_clip_extents(cr, &x1, &y1, &x2, &y2);
	XSprePUSH;	EXTEND(SP,4);
	PUSHs(sv_newmortal());
	sv_setnv(ST(0), (double)x1);
	PUSHs(sv_newmortal());
	sv_setnv(ST(1), (double)y1);
	PUSHs(sv_newmortal());
	sv_setnv(ST(2), (double)x2);
	PUSHs(sv_newmortal());
	sv_setnv(ST(3), (double)y2);
    }
    XSRETURN(4);
}

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 10, 0)
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Cairo__Context_in_clip); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_in_clip)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "cr, x, y");
    {
	cairo_bool_t	RETVAL;
	dXSTARG;
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x = (double)SvNV(ST(1))
;
	double	y = (double)SvNV(ST(2))
;

	RETVAL = cairo_in_clip(cr, x, y);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Cairo__Context_reset_clip); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_reset_clip)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;

	cairo_reset_clip(cr);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_select_font_face); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_select_font_face)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "cr, family, slant, weight");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	const char_utf8 *	family;
	cairo_font_slant_t	slant = SvCairoFontSlant (ST(2))
;
	cairo_font_weight_t	weight = SvCairoFontWeight (ST(3))
;

	sv_utf8_upgrade (ST(1));
	family = (const char_utf8 *) SvPV_nolen (ST(1))
;

	cairo_select_font_face(cr, family, slant, weight);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_font_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_font_size)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, size");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	size = (double)SvNV(ST(1))
;

	cairo_set_font_size(cr, size);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_set_font_matrix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_font_matrix)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, matrix");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	const cairo_matrix_t *	matrix = SvCairoMatrix (ST(1))
;

	cairo_set_font_matrix(cr, matrix);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_get_font_matrix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_font_matrix)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
#line 674 "Cairo.xs"
	cairo_matrix_t matrix;
#line 2066 "Cairo.c"
	cairo_matrix_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;
#line 676 "Cairo.xs"
	cairo_get_font_matrix (cr, &matrix);
	RETVAL = cairo_perl_copy_matrix (&matrix);
#line 2073 "Cairo.c"
	ST(0) = newSVCairoMatrix (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_set_font_options); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_font_options)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, options");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	const cairo_font_options_t *	options = SvCairoFontOptions (ST(1))
;

	cairo_set_font_options(cr, options);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_get_font_options); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_font_options)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_font_options_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;
#line 686 "Cairo.xs"
	RETVAL = cairo_font_options_create ();
	cairo_get_font_options (cr, RETVAL);
#line 2112 "Cairo.c"
	ST(0) = newSVCairoFontOptions (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 2, 0)
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_Cairo__Context_set_scaled_font); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_scaled_font)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, scaled_font");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	const cairo_scaled_font_t *	scaled_font = SvCairoScaledFont (ST(1))
;

	cairo_set_scaled_font(cr, scaled_font);
    }
    XSRETURN_EMPTY;
}

#endif
#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 4, 0)
#define XSubPPtmpAAAG 1


XS_EUPXS(XS_Cairo__Context_get_scaled_font); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_scaled_font)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_scaled_font_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_scaled_font(cr);
	ST(0) = newSVCairoScaledFont (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Cairo__Context_show_text); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_show_text)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, utf8");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	const char_utf8 *	utf8;

	sv_utf8_upgrade (ST(1));
	utf8 = (const char_utf8 *) SvPV_nolen (ST(1))
;

	cairo_show_text(cr, utf8);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_show_glyphs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_show_glyphs)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "cr, ...");
    {
#line 708 "Cairo.xs"
	cairo_glyph_t * glyphs = NULL;
	int num_glyphs, i;
#line 2196 "Cairo.c"
	cairo_t *	cr = SvCairo (ST(0))
;
#line 711 "Cairo.xs"
	num_glyphs = items - 1;
	Newz (0, glyphs, num_glyphs, cairo_glyph_t);
	for (i = 1; i < items; i++)
		glyphs[i - 1] = *SvCairoGlyph (ST (i));
	cairo_show_glyphs (cr, glyphs, num_glyphs);
	Safefree (glyphs);
#line 2206 "Cairo.c"
    }
    XSRETURN_EMPTY;
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 8, 0)
#define XSubPPtmpAAAH 1


XS_EUPXS(XS_Cairo__Context_show_text_glyphs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_show_text_glyphs)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "cr, utf8_sv, glyphs_sv, clusters_sv, cluster_flags");
    {
#line 724 "Cairo.xs"
	const char *utf8 = NULL;
	STRLEN utf8_len = 0;
	cairo_glyph_t * glyphs = NULL;
	cairo_text_cluster_t * clusters = NULL;
	int i, num_glyphs, num_clusters;
	AV *glyphs_av, *clusters_av;
#line 2229 "Cairo.c"
	cairo_t *	cr = SvCairo (ST(0))
;
	SV *	utf8_sv = ST(1)
;
	SV *	glyphs_sv = ST(2)
;
	SV *	clusters_sv = ST(3)
;
	cairo_text_cluster_flags_t	cluster_flags = SvCairoTextClusterFlags (ST(4))
;
#line 731 "Cairo.xs"
	if (!cairo_perl_sv_is_array_ref (glyphs_sv))
		croak ("glyphs must be an array ref");
	if (!cairo_perl_sv_is_array_ref (clusters_sv))
		croak ("text clusters must be an array ref");

	sv_utf8_upgrade (utf8_sv);
	utf8 = SvPV (utf8_sv, utf8_len);

	glyphs_av = (AV *) SvRV (glyphs_sv);
	num_glyphs = av_len (glyphs_av) + 1;
	glyphs = cairo_glyph_allocate (num_glyphs);
	for (i = 0; i < num_glyphs; i++) {
		SV **value = av_fetch (glyphs_av, i, 0);
		if (value)
			glyphs[i] = *SvCairoGlyph (*value);
	}

	clusters_av = (AV *) SvRV (clusters_sv);
	num_clusters = av_len (clusters_av) + 1;
	clusters = cairo_text_cluster_allocate (num_clusters);
	for (i = 0; i < num_clusters; i++) {
		SV **value = av_fetch (clusters_av, i, 0);
		if (value)
			clusters[i] = *SvCairoTextCluster (*value);
	}

	cairo_show_text_glyphs (cr,
	                        utf8, (int) utf8_len,
	                        glyphs, num_glyphs,
	                        clusters, num_clusters, cluster_flags);

	cairo_text_cluster_free (clusters);
	cairo_glyph_free (glyphs);
#line 2274 "Cairo.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Cairo__Context_get_font_face); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_font_face)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_font_face_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_font_face(cr);
	ST(0) = newSVCairoFontFace (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_font_extents); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_font_extents)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
#line 772 "Cairo.xs"
	cairo_font_extents_t extents;
#line 2309 "Cairo.c"
	cairo_font_extents_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;
#line 774 "Cairo.xs"
	cairo_font_extents (cr, &extents);
	RETVAL = &extents;
#line 2316 "Cairo.c"
	ST(0) = newSVCairoFontExtents (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_set_font_face); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_set_font_face)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, font_face");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	cairo_font_face_t *	font_face = SvCairoFontFace (ST(1))
;

	cairo_set_font_face(cr, font_face);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_text_extents); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_text_extents)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, utf8");
    {
#line 784 "Cairo.xs"
	cairo_text_extents_t extents;
#line 2351 "Cairo.c"
	cairo_text_extents_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;
	const char_utf8 *	utf8;

	sv_utf8_upgrade (ST(1));
	utf8 = (const char_utf8 *) SvPV_nolen (ST(1))
;
#line 786 "Cairo.xs"
	cairo_text_extents (cr, utf8, &extents);
	RETVAL = &extents;
#line 2363 "Cairo.c"
	ST(0) = newSVCairoTextExtents (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_glyph_extents); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_glyph_extents)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "cr, ...");
    {
#line 794 "Cairo.xs"
	cairo_text_extents_t extents;
	cairo_glyph_t * glyphs = NULL;
	int num_glyphs, i;
#line 2382 "Cairo.c"
	cairo_text_extents_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;
#line 798 "Cairo.xs"
	num_glyphs = items - 1;
	Newz (0, glyphs, num_glyphs, cairo_glyph_t);
	for (i = 1; i < items; i++)
		glyphs[i - 1] = *SvCairoGlyph (ST (i));
	cairo_glyph_extents (cr, glyphs, num_glyphs, &extents);
	RETVAL = &extents;
	Safefree (glyphs);
#line 2394 "Cairo.c"
	ST(0) = newSVCairoTextExtents (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_text_path); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_text_path)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, utf8");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	const char_utf8 *	utf8;

	sv_utf8_upgrade (ST(1));
	utf8 = (const char_utf8 *) SvPV_nolen (ST(1))
;

	cairo_text_path(cr, utf8);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_glyph_path); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_glyph_path)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "cr, ...");
    {
#line 813 "Cairo.xs"
	cairo_glyph_t * glyphs = NULL;
	int num_glyphs, i;
#line 2433 "Cairo.c"
	cairo_t *	cr = SvCairo (ST(0))
;
#line 816 "Cairo.xs"
	num_glyphs = items - 1;
	Newz (0, glyphs, num_glyphs, cairo_glyph_t);
	for (i = 1; i < items; i++)
		glyphs[i - 1] = *SvCairoGlyph (ST (i));
	cairo_glyph_path (cr, glyphs, num_glyphs);
	Safefree (glyphs);
#line 2443 "Cairo.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_get_operator); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_operator)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_operator_t	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_operator(cr);
	ST(0) = newSVCairoOperator (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_get_source); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_source)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_pattern_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_source(cr);
	ST(0) = newSVCairoPattern (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_get_tolerance); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_tolerance)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	double	RETVAL;
	dXSTARG;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_tolerance(cr);
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_get_antialias); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_antialias)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_antialias_t	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_antialias(cr);
	ST(0) = newSVCairoAntialias (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 6, 0)
#define XSubPPtmpAAAI 1


XS_EUPXS(XS_Cairo__Context_has_current_point); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_has_current_point)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_bool_t	RETVAL;
	dXSTARG;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_has_current_point(cr);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Cairo__Context_get_current_point); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_current_point)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	double	x;
	double	y;

	cairo_get_current_point(cr, &x, &y);
	XSprePUSH;	EXTEND(SP,2);
	PUSHs(sv_newmortal());
	sv_setnv(ST(0), (double)x);
	PUSHs(sv_newmortal());
	sv_setnv(ST(1), (double)y);
    }
    XSRETURN(2);
}


XS_EUPXS(XS_Cairo__Context_get_fill_rule); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_fill_rule)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_fill_rule_t	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_fill_rule(cr);
	ST(0) = newSVCairoFillRule (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_get_line_width); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_line_width)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	double	RETVAL;
	dXSTARG;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_line_width(cr);
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_get_line_cap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_line_cap)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_line_cap_t	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_line_cap(cr);
	ST(0) = newSVCairoLineCap (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_get_line_join); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_line_join)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_line_join_t	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_line_join(cr);
	ST(0) = newSVCairoLineJoin (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_get_miter_limit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_miter_limit)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	double	RETVAL;
	dXSTARG;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_miter_limit(cr);
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 4, 0)
#define XSubPPtmpAAAJ 1


XS_EUPXS(XS_Cairo__Context_get_dash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_dash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 855 "Cairo.xs"
	int count, i;
	double *dashes, offset;
#line 2681 "Cairo.c"
	cairo_t *	cr = SvCairo (ST(0))
;
#line 858 "Cairo.xs"
	count = cairo_get_dash_count (cr);
	if (count == 0) {
		dashes = NULL;
	} else {
		New (0, dashes, count, double);
		if (!dashes)
			croak ("malloc failure for (%d) elements", count);
	}
	cairo_get_dash (cr, dashes, &offset);
	EXTEND (sp, count + 1);
	PUSHs (sv_2mortal (newSVnv (offset)));
	for (i = 0; i < count; i++)
		PUSHs (sv_2mortal (newSVnv (dashes[i])));
	Safefree (dashes);
#line 2699 "Cairo.c"
	PUTBACK;
	return;
    }
}

#endif

XS_EUPXS(XS_Cairo__Context_get_matrix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_matrix)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
#line 878 "Cairo.xs"
	cairo_matrix_t matrix;
#line 2716 "Cairo.c"
	cairo_matrix_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;
#line 880 "Cairo.xs"
	cairo_get_matrix (cr, &matrix);
	RETVAL = cairo_perl_copy_matrix (&matrix);
#line 2723 "Cairo.c"
	ST(0) = newSVCairoMatrix (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_get_target); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_target)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_surface_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_target(cr);
	ST(0) = newSVCairoSurface (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#if CAIRO_VERSION >= CAIRO_VERSION_ENCODE(1, 2, 0)
#define XSubPPtmpAAAK 1


XS_EUPXS(XS_Cairo__Context_get_group_target); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_get_group_target)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_surface_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_get_group_target(cr);
	ST(0) = newSVCairoSurface (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Cairo__Context_copy_path); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_copy_path)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_path_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_copy_path(cr);
	ST(0) = newSVCairoPath (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_copy_path_flat); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_copy_path_flat)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_path_t *	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_copy_path_flat(cr);
	ST(0) = newSVCairoPath (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo__Context_append_path); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_append_path)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cr, path");
    {
	cairo_t *	cr = SvCairo (ST(0))
;
	cairo_path_t *	path = SvCairoPath (ST(1))
;

	cairo_append_path(cr, path);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Cairo__Context_status); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo__Context_status)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cr");
    {
	cairo_status_t	RETVAL;
	cairo_t *	cr = SvCairo (ST(0))
;

	RETVAL = cairo_status(cr);
	ST(0) = newSVCairoStatus (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo_HAS_PS_SURFACE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo_HAS_PS_SURFACE)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 908 "Cairo.xs"
#ifdef CAIRO_HAS_PS_SURFACE
	RETVAL = TRUE;
#else
	RETVAL = FALSE;
#endif
#line 2862 "Cairo.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo_HAS_PDF_SURFACE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo_HAS_PDF_SURFACE)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 919 "Cairo.xs"
#ifdef CAIRO_HAS_PDF_SURFACE
	RETVAL = TRUE;
#else
	RETVAL = FALSE;
#endif
#line 2883 "Cairo.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo_HAS_SVG_SURFACE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo_HAS_SVG_SURFACE)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 930 "Cairo.xs"
#ifdef CAIRO_HAS_SVG_SURFACE
	RETVAL = TRUE;
#else
	RETVAL = FALSE;
#endif
#line 2904 "Cairo.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo_HAS_RECORDING_SURFACE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo_HAS_RECORDING_SURFACE)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 941 "Cairo.xs"
#ifdef CAIRO_HAS_RECORDING_SURFACE
	RETVAL = TRUE;
#else
	RETVAL = FALSE;
#endif
#line 2925 "Cairo.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo_HAS_FT_FONT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo_HAS_FT_FONT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 952 "Cairo.xs"
#ifdef CAIRO_HAS_FT_FONT
	RETVAL = TRUE;
#else
	RETVAL = FALSE;
#endif
#line 2946 "Cairo.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Cairo_HAS_PNG_FUNCTIONS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Cairo_HAS_PNG_FUNCTIONS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 963 "Cairo.xs"
#ifdef CAIRO_HAS_PNG_FUNCTIONS
	RETVAL = TRUE;
#else
	RETVAL = FALSE;
#endif
#line 2967 "Cairo.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Cairo); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Cairo)
{
    dVAR; dXSARGS;
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK;

    {
        CV * cv;

        newXS("Cairo::LIB_VERSION", XS_Cairo_LIB_VERSION, file);
        cv = newXS("Cairo::LIB_VERSION_ENCODE", XS_Cairo_LIB_VERSION_ENCODE, file);
        XSANY.any_i32 = 0;
        cv = newXS("Cairo::VERSION_ENCODE", XS_Cairo_LIB_VERSION_ENCODE, file);
        XSANY.any_i32 = 1;
        cv = newXS("Cairo::lib_version", XS_Cairo_version, file);
        XSANY.any_i32 = 1;
        cv = newXS("Cairo::version", XS_Cairo_version, file);
        XSANY.any_i32 = 0;
        cv = newXS("Cairo::lib_version_string", XS_Cairo_version_string, file);
        XSANY.any_i32 = 1;
        cv = newXS("Cairo::version_string", XS_Cairo_version_string, file);
        XSANY.any_i32 = 0;
        newXS("Cairo::Context::create", XS_Cairo__Context_create, file);
        newXS("Cairo::Context::DESTROY", XS_Cairo__Context_DESTROY, file);
        newXS("Cairo::Context::save", XS_Cairo__Context_save, file);
        newXS("Cairo::Context::restore", XS_Cairo__Context_restore, file);
#if XSubPPtmpAAAA
        newXS("Cairo::Context::push_group", XS_Cairo__Context_push_group, file);
        newXS("Cairo::Context::push_group_with_content", XS_Cairo__Context_push_group_with_content, file);
        newXS("Cairo::Context::pop_group", XS_Cairo__Context_pop_group, file);
        newXS("Cairo::Context::pop_group_to_source", XS_Cairo__Context_pop_group_to_source, file);
#endif
        newXS("Cairo::Context::set_operator", XS_Cairo__Context_set_operator, file);
        newXS("Cairo::Context::set_source_rgb", XS_Cairo__Context_set_source_rgb, file);
        newXS("Cairo::Context::set_source_rgba", XS_Cairo__Context_set_source_rgba, file);
        newXS("Cairo::Context::set_source", XS_Cairo__Context_set_source, file);
        newXS("Cairo::Context::set_source_surface", XS_Cairo__Context_set_source_surface, file);
        newXS("Cairo::Context::set_tolerance", XS_Cairo__Context_set_tolerance, file);
        newXS("Cairo::Context::set_antialias", XS_Cairo__Context_set_antialias, file);
        newXS("Cairo::Context::set_fill_rule", XS_Cairo__Context_set_fill_rule, file);
        newXS("Cairo::Context::set_line_width", XS_Cairo__Context_set_line_width, file);
        newXS("Cairo::Context::set_line_cap", XS_Cairo__Context_set_line_cap, file);
        newXS("Cairo::Context::set_line_join", XS_Cairo__Context_set_line_join, file);
        newXS("Cairo::Context::set_dash", XS_Cairo__Context_set_dash, file);
        newXS("Cairo::Context::set_miter_limit", XS_Cairo__Context_set_miter_limit, file);
        newXS("Cairo::Context::translate", XS_Cairo__Context_translate, file);
        newXS("Cairo::Context::scale", XS_Cairo__Context_scale, file);
        newXS("Cairo::Context::rotate", XS_Cairo__Context_rotate, file);
        newXS("Cairo::Context::transform", XS_Cairo__Context_transform, file);
        newXS("Cairo::Context::set_matrix", XS_Cairo__Context_set_matrix, file);
        newXS("Cairo::Context::identity_matrix", XS_Cairo__Context_identity_matrix, file);
        newXS("Cairo::Context::user_to_device", XS_Cairo__Context_user_to_device, file);
        newXS("Cairo::Context::user_to_device_distance", XS_Cairo__Context_user_to_device_distance, file);
        newXS("Cairo::Context::device_to_user", XS_Cairo__Context_device_to_user, file);
        newXS("Cairo::Context::device_to_user_distance", XS_Cairo__Context_device_to_user_distance, file);
        newXS("Cairo::Context::new_path", XS_Cairo__Context_new_path, file);
#if XSubPPtmpAAAB
        newXS("Cairo::Context::new_sub_path", XS_Cairo__Context_new_sub_path, file);
#endif
        newXS("Cairo::Context::move_to", XS_Cairo__Context_move_to, file);
        newXS("Cairo::Context::line_to", XS_Cairo__Context_line_to, file);
        newXS("Cairo::Context::curve_to", XS_Cairo__Context_curve_to, file);
        newXS("Cairo::Context::arc", XS_Cairo__Context_arc, file);
        newXS("Cairo::Context::arc_negative", XS_Cairo__Context_arc_negative, file);
        newXS("Cairo::Context::rel_move_to", XS_Cairo__Context_rel_move_to, file);
        newXS("Cairo::Context::rel_line_to", XS_Cairo__Context_rel_line_to, file);
        newXS("Cairo::Context::rel_curve_to", XS_Cairo__Context_rel_curve_to, file);
        newXS("Cairo::Context::rectangle", XS_Cairo__Context_rectangle, file);
        newXS("Cairo::Context::close_path", XS_Cairo__Context_close_path, file);
#if XSubPPtmpAAAC
        newXS("Cairo::Context::path_extents", XS_Cairo__Context_path_extents, file);
#endif
        newXS("Cairo::Context::paint", XS_Cairo__Context_paint, file);
        newXS("Cairo::Context::paint_with_alpha", XS_Cairo__Context_paint_with_alpha, file);
        newXS("Cairo::Context::mask", XS_Cairo__Context_mask, file);
        newXS("Cairo::Context::mask_surface", XS_Cairo__Context_mask_surface, file);
        newXS("Cairo::Context::stroke", XS_Cairo__Context_stroke, file);
        newXS("Cairo::Context::stroke_preserve", XS_Cairo__Context_stroke_preserve, file);
        newXS("Cairo::Context::fill", XS_Cairo__Context_fill, file);
        newXS("Cairo::Context::fill_preserve", XS_Cairo__Context_fill_preserve, file);
        newXS("Cairo::Context::copy_page", XS_Cairo__Context_copy_page, file);
        newXS("Cairo::Context::show_page", XS_Cairo__Context_show_page, file);
        newXS("Cairo::Context::in_stroke", XS_Cairo__Context_in_stroke, file);
        newXS("Cairo::Context::in_fill", XS_Cairo__Context_in_fill, file);
        newXS("Cairo::Context::stroke_extents", XS_Cairo__Context_stroke_extents, file);
        newXS("Cairo::Context::fill_extents", XS_Cairo__Context_fill_extents, file);
        newXS("Cairo::Context::clip", XS_Cairo__Context_clip, file);
        newXS("Cairo::Context::clip_preserve", XS_Cairo__Context_clip_preserve, file);
#if XSubPPtmpAAAD
        newXS("Cairo::Context::copy_clip_rectangle_list", XS_Cairo__Context_copy_clip_rectangle_list, file);
        newXS("Cairo::Context::clip_extents", XS_Cairo__Context_clip_extents, file);
#endif
#if XSubPPtmpAAAE
        newXS("Cairo::Context::in_clip", XS_Cairo__Context_in_clip, file);
#endif
        newXS("Cairo::Context::reset_clip", XS_Cairo__Context_reset_clip, file);
        newXS("Cairo::Context::select_font_face", XS_Cairo__Context_select_font_face, file);
        newXS("Cairo::Context::set_font_size", XS_Cairo__Context_set_font_size, file);
        newXS("Cairo::Context::set_font_matrix", XS_Cairo__Context_set_font_matrix, file);
        newXS("Cairo::Context::get_font_matrix", XS_Cairo__Context_get_font_matrix, file);
        newXS("Cairo::Context::set_font_options", XS_Cairo__Context_set_font_options, file);
        newXS("Cairo::Context::get_font_options", XS_Cairo__Context_get_font_options, file);
#if XSubPPtmpAAAF
        newXS("Cairo::Context::set_scaled_font", XS_Cairo__Context_set_scaled_font, file);
#endif
#if XSubPPtmpAAAG
        newXS("Cairo::Context::get_scaled_font", XS_Cairo__Context_get_scaled_font, file);
#endif
        newXS("Cairo::Context::show_text", XS_Cairo__Context_show_text, file);
        newXS("Cairo::Context::show_glyphs", XS_Cairo__Context_show_glyphs, file);
#if XSubPPtmpAAAH
        newXS("Cairo::Context::show_text_glyphs", XS_Cairo__Context_show_text_glyphs, file);
#endif
        newXS("Cairo::Context::get_font_face", XS_Cairo__Context_get_font_face, file);
        newXS("Cairo::Context::font_extents", XS_Cairo__Context_font_extents, file);
        newXS("Cairo::Context::set_font_face", XS_Cairo__Context_set_font_face, file);
        newXS("Cairo::Context::text_extents", XS_Cairo__Context_text_extents, file);
        newXS("Cairo::Context::glyph_extents", XS_Cairo__Context_glyph_extents, file);
        newXS("Cairo::Context::text_path", XS_Cairo__Context_text_path, file);
        newXS("Cairo::Context::glyph_path", XS_Cairo__Context_glyph_path, file);
        newXS("Cairo::Context::get_operator", XS_Cairo__Context_get_operator, file);
        newXS("Cairo::Context::get_source", XS_Cairo__Context_get_source, file);
        newXS("Cairo::Context::get_tolerance", XS_Cairo__Context_get_tolerance, file);
        newXS("Cairo::Context::get_antialias", XS_Cairo__Context_get_antialias, file);
#if XSubPPtmpAAAI
        newXS("Cairo::Context::has_current_point", XS_Cairo__Context_has_current_point, file);
#endif
        newXS("Cairo::Context::get_current_point", XS_Cairo__Context_get_current_point, file);
        newXS("Cairo::Context::get_fill_rule", XS_Cairo__Context_get_fill_rule, file);
        newXS("Cairo::Context::get_line_width", XS_Cairo__Context_get_line_width, file);
        newXS("Cairo::Context::get_line_cap", XS_Cairo__Context_get_line_cap, file);
        newXS("Cairo::Context::get_line_join", XS_Cairo__Context_get_line_join, file);
        newXS("Cairo::Context::get_miter_limit", XS_Cairo__Context_get_miter_limit, file);
#if XSubPPtmpAAAJ
        newXS("Cairo::Context::get_dash", XS_Cairo__Context_get_dash, file);
#endif
        newXS("Cairo::Context::get_matrix", XS_Cairo__Context_get_matrix, file);
        newXS("Cairo::Context::get_target", XS_Cairo__Context_get_target, file);
#if XSubPPtmpAAAK
        newXS("Cairo::Context::get_group_target", XS_Cairo__Context_get_group_target, file);
#endif
        newXS("Cairo::Context::copy_path", XS_Cairo__Context_copy_path, file);
        newXS("Cairo::Context::copy_path_flat", XS_Cairo__Context_copy_path_flat, file);
        newXS("Cairo::Context::append_path", XS_Cairo__Context_append_path, file);
        newXS("Cairo::Context::status", XS_Cairo__Context_status, file);
        newXS("Cairo::HAS_PS_SURFACE", XS_Cairo_HAS_PS_SURFACE, file);
        newXS("Cairo::HAS_PDF_SURFACE", XS_Cairo_HAS_PDF_SURFACE, file);
        newXS("Cairo::HAS_SVG_SURFACE", XS_Cairo_HAS_SVG_SURFACE, file);
        newXS("Cairo::HAS_RECORDING_SURFACE", XS_Cairo_HAS_RECORDING_SURFACE, file);
        newXS("Cairo::HAS_FT_FONT", XS_Cairo_HAS_FT_FONT, file);
        newXS("Cairo::HAS_PNG_FUNCTIONS", XS_Cairo_HAS_PNG_FUNCTIONS, file);
    }

    /* Initialisation Section */

#line 423 "Cairo.xs"
#include "cairo-perl-boot.xsh"
#if CAIRO_PERL_DEBUG
	call_atexit ((ATEXIT_t) cairo_debug_reset_static_data, NULL);
#endif

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#if XSubPPtmpAAAG
#endif
#if XSubPPtmpAAAH
#endif
#if XSubPPtmpAAAI
#endif
#if XSubPPtmpAAAJ
#endif
#if XSubPPtmpAAAK
#endif
#line 3170 "Cairo.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

