function resu = df_mapper2(func, df, varargin)
  %# resu = df_mapper2(func, df)
  %# small interface to iterate some vector func over the elements of a
  %# dataframe. This one is specifically adapted to all functions where
  %# the first argument, if numeric, is 'dim'.

  %% Copyright (C) 2009-2015 Pascal Dupuis <cdemills@gmail.com>
  %%
  %% This file is part of Octave.
  %%
  %% Octave is free software; you can redistribute it and/or
  %% modify it under the terms of the GNU General Public
  %% License as published by the Free Software Foundation;
  %% either version 2, or (at your option) any later version.
  %%
  %% Octave is distributed in the hope that it will be useful,
  %% but WITHOUT ANY WARRANTY; without even the implied
  %% warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  %% PURPOSE.  See the GNU General Public License for more
  %% details.
  %%
  %% You should have received a copy of the GNU General Public
  %% License along with Octave; see the file COPYING.  If not,
  %% write to the Free Software Foundation, 51 Franklin Street -
  %% Fifth Floor, Boston, MA 02110-1301, USA.
  
  %#
  %# $Id$
  %#

  dim = []; resu = []; vout = varargin;
  
  %# take care of constructs as min(x, [], dim);  sum(x, 2, "native")
  for indi = (nargin-2:-1:1)
    if (isscalar (varargin{indi}))
      if (isnumeric (varargin{indi}))
        dim = varargin{indi}; 
        %# the "third" dim is the second on stored data
        if (3 == dim) vout(indi-2) = 2; endif
      endif
    endif
    break;
  endfor

  if (isempty (dim))
    %# iterates on the first non-singleton dim
    dim = find (df._cnt > 1)(1);
  endif
    
  switch (dim)
    case {1}
      resu = df_colmeta (df); %# don't copy all the information
      for indi = (1:df._cnt(2))
        resu._data{indi} = feval (func, df._data{indi}(:, df._rep{indi}), ...
                                  vout{:});
        resu._rep{indi} = 1:size (resu._data{indi}, 2);
      endfor
      resu._cnt(1) = max (cellfun ('size', resu._data, 1));
      if (resu._cnt(1) == df._cnt(1))
        %# the func was not contracting
        resu._ridx = df._ridx;
        resu._name{1} = resu._name{1}; resu._over{1} = resu._over{1};
      else
        %# select the first value
        if (~isempty (resu._name{1}))
          resu._name{1} = resu._name{1}(1);
        endif
        if (~isempty (resu._over{1}))
          resu._over{1} = resu._over{1}(1);
        endif
      endif
    case {2}
      switch func
        case @sum
          contract = true; func = @plus;
        case @cumsum
          contract = false; func = @plus;  
        case @prod
          contract = true; func = @times;
        case @cumprod
          contract = false; func = @times;
        case @any
          contract = true; func = @or;
        case @all
          contract = true; func = @and;    
        otherwise
          error ('Operation not implemented');
      endswitch
      if (contract)
        resu = df_allmeta (df, [df._cnt(1) 1]);
      else
        resu = df_allmeta(df);
      endif  
      resu._data{1} = df._data{1}(:, df._rep{1});
      resu._rep{1} = df._rep{1};
      if (contract) 
        for indi = (2:df._cnt(2))
          %# this call is "unfolding"
          resu._data{1} =  feval (func, resu._data{1}(:, df._rep{1}), ...
                                                 df._data{indi}(:, df._rep{indi}));
          resu._rep{1} = 1:size (resu._data{1}, 2);
        endfor
      else
        for indi = (2:df._cnt(2))
          resu._data{indi} =  feval (func, resu._data{indi-1}(:, df._rep{indi-1}), ...
                                                    df._data{indi}(:, df._rep{indi}));
          resu._rep{indi} = 1:size (resu._data{indi}, 2);                             
        endfor
      endif      
      %# type may have changed
      resu._type = cellfun(@(x) class(x(1)), resu._data, "UniformOutput", false);
    case {3}
      resu = df_allmeta(df); 
      for indi = (1:df._cnt(2))
        resu._data{indi} = feval (func, df._data{indi}(:, df._rep{indi}), ...
                                  vout{:});
        resu._rep{indi} = 1:size (resu._data{indi}, 2);
      endfor
    otherwise
      error ("Invalid dimension %d", dim); 
  endswitch

  resu = df_thirddim (resu);

endfunction
