#ifndef _OPTIONS_H
#define _OPTIONS_H 1

/* For communication from `frotz_getopt' to the caller.
   When `frotz_getopt' finds an option that takes an argument,
   the argument value is returned here.
   Also, when `ordering' is RETURN_IN_ORDER,
   each non-option ARGV-element is returned here.  */

extern char *optarg;

/* Index in ARGV of the next element to be scanned.
   This is used for communication to and from the caller
   and for communication between successive calls to `frotz_getopt'.

   On entry to `frotz_getopt', zero means this is the first call; initialize.

   When `frotz_getopt' returns EOF, this is the index of the first of the
   non-option elements that the caller should itself scan.

   Otherwise, `optind' communicates from one call to the next
   how much of ARGV has been scanned so far.  */

extern int optind;

/* Callers store zero here to inhibit the error message `frotz_getopt' prints
   for unrecognized options.  */

extern int opterr;

/* Set to an option character which was unrecognized.  */

extern int optopt;

extern int frotz_getopt (int argc, char *const *argv, const char *shortopts);

#endif /* _GETOPT_H */
