dnl ACCONFIG TEMPLATE
dnl #undef ID3_ICONV_FORMAT_UTF16BE
dnl #undef ID3_ICONV_FORMAT_UTF16
dnl #undef ID3_ICONV_FORMAT_UTF8
dnl #undef ID3_ICONV_FORMAT_ASCII
dnl END ACCONFIG

AC_DEFUN(ID3_CHECK_ICONV_FORMAT,[
  if eval "test \"x\$$1\" = \"xno\""; then
    AC_MSG_CHECKING(whether iconv supports $2)
    AC_TRY_RUN([#include <iconv.h>
        int main() { return iconv_open("$2", "$2") == -1; } ],
      [ eval $1=yes
        AC_MSG_RESULT(yes)
        AC_DEFINE_UNQUOTED($1, "$2") ],
      [ AC_MSG_RESULT(no) ],
      [ AC_MSG_WARN(Don't cross-compile) ])
  fi
])

AC_DEFUN([ID3_UNICODE],[
  if test "x$ac_cv_header_iconv_h" = "xyes"; then
    ID3_ICONV_FORMAT_UTF8=no
    ID3_ICONV_FORMAT_UTF16=no
    ID3_ICONV_FORMAT_UTF16BE=no
    ID3_ICONV_FORMAT_ASCII=no

    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF8,    UTF-8)
    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF8,    UTF8)
#    ID3_CLEAR_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF8)

    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF16BE, UTF-16BE)
    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF16BE, UTF16BE)
    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF16BE, UCS-2BE)
    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF16BE, UCS2BE)
    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF16BE, UNICODEBIG)
#    ID3_CLEAR_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF16BE)

    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF16,   UTF-16)
    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF16,   UTF16)
    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF16,   UNICODE)
#    ID3_CLEAR_ICONV_FORMAT(ID3_ICONV_FORMAT_UTF16)

    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_ASCII,   ISO-8859-1)
    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_ASCII,   ASCII)
    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_ASCII,   US-ASCII)
    ID3_CHECK_ICONV_FORMAT(ID3_ICONV_FORMAT_ASCII,   US)
#    ID3_CLEAR_ICONV_FORMAT(ID3_ICONV_FORMAT_ASCII)
  fi
])

