// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libgnomevfsmm/uri.h>
#include <libgnomevfsmm/private/uri_p.h>

/* $Id: uri.ccg,v 1.8 2006/10/31 09:06:50 murrayc Exp $ */
// -*- C++ -*- // this is for the .ccg, I realize gensig puts one in

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfsmm/private.h>
#include <libgnomevfs/gnome-vfs-utils.h> //For gnome_vfs_get_volume_free_space().

namespace Gnome
{

namespace Vfs
{

// static
Glib::RefPtr<Uri> Uri::create(const Glib::ustring& uri)
{
  // See the comment at the top of this file, if you want to know why the cast works.
  
  return Glib::RefPtr<Uri>(reinterpret_cast<Uri*>(gnome_vfs_uri_new(uri.c_str())));
}
  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<FileInfo> Uri::get_file_info(FileInfoOptions options) const throw(exception)
#else
Glib::RefPtr<FileInfo> Uri::get_file_info(FileInfoOptions options, std::auto_ptr<Gnome::Vfs::exception>& error) const
#endif
{
  GnomeVFSFileInfo* file_info = gnome_vfs_file_info_new();
  GnomeVFSResult result = gnome_vfs_get_file_info_uri(const_cast<GnomeVFSURI*>(gobj()), file_info, static_cast<GnomeVFSFileInfoOptions>(options));
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  handle_result(result);
  #else
  handle_result(result, error);
  #endif
  return Glib::wrap(file_info);
}


#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Uri::create_symbolic_link(const Glib::ustring& target_reference) throw(exception)
#else
void Uri::create_symbolic_link(const Glib::ustring& target_reference, std::auto_ptr<Gnome::Vfs::exception>& error)
#endif
{
  GnomeVFSResult result = gnome_vfs_create_symbolic_link(gobj(), target_reference.c_str());
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  handle_result(result);
  #else
  handle_result(result, error);
  #endif
}

bool Uri::uri_exists() const
{
  return gnome_vfs_uri_exists(const_cast<GnomeVFSURI*>(gobj()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
FileSize Uri::get_volume_free_space() const throw(exception)  
#else
FileSize Uri::get_volume_free_space(std::auto_ptr<Gnome::Vfs::exception>& error) const
#endif
{
  GnomeVFSFileSize free_space = 0;
  GnomeVFSResult result = gnome_vfs_get_volume_free_space(const_cast<GnomeVFSURI*>(gobj()), &free_space);
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  handle_result(result);
  #else
  handle_result(result, error);
  #endif
  return free_space;
}
  

} //namespace Vfs

} //namespace Gnome


namespace
{
} // anonymous namespace


/* Why reinterpret_cast<Uri*>(gobject) is needed:
 *
 * A Uri instance is in fact always a GnomeVFSURI instance.
 * Unfortunately, GnomeVFSURI cannot be a member of Uri,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because Uri does not have any member data, and
 * it is impossible to derive from it.  This is ensured by not implementing
 * the (protected) default constructor.  The ctor is protected rather than
 * private just to avoid a compile warning.
 */

namespace Glib
{

Glib::RefPtr<Gnome::Vfs::Uri> wrap(GnomeVFSURI* object, bool take_copy)
{
  if(take_copy && object)
    gnome_vfs_uri_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gnome::Vfs::Uri>(reinterpret_cast<Gnome::Vfs::Uri*>(object));
}

} // namespace Glib


namespace Gnome
{

namespace Vfs
{


void Uri::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gnome_vfs_uri_ref(reinterpret_cast<GnomeVFSURI*>(const_cast<Uri*>(this)));
}

void Uri::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gnome_vfs_uri_unref(reinterpret_cast<GnomeVFSURI*>(const_cast<Uri*>(this)));
}

GnomeVFSURI* Uri::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GnomeVFSURI*>(this);
}

const GnomeVFSURI* Uri::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GnomeVFSURI*>(this);
}

GnomeVFSURI* Uri::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  GnomeVFSURI *const gobject = reinterpret_cast<GnomeVFSURI*>(const_cast<Uri*>(this));
  gnome_vfs_uri_ref(gobject);
  return gobject;
}


Glib::RefPtr<Uri> Uri::resolve_relative(const Glib::ustring& relative_reference)
{
  return Glib::wrap(gnome_vfs_uri_resolve_relative(gobj(), relative_reference.c_str()));
}

Glib::RefPtr<Uri> Uri::append_string(const Glib::ustring& uri_fragment)
{
  return Glib::wrap(gnome_vfs_uri_append_string(gobj(), uri_fragment.c_str()));
}

Glib::RefPtr<Uri> Uri::append_path(const Glib::ustring& path)
{
  return Glib::wrap(gnome_vfs_uri_append_path(gobj(), path.c_str()));
}

Glib::RefPtr<Uri> Uri::append_file_name(const Glib::ustring& filename)
{
  return Glib::wrap(gnome_vfs_uri_append_file_name(gobj(), filename.c_str()));
}

Glib::ustring Uri::to_string(URIHideOptions hide_options) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_vfs_uri_to_string(const_cast<GnomeVFSURI*>(gobj()), (GnomeVFSURIHideOptions)(hide_options)));
}

Glib::RefPtr<Uri> Uri::dup()
{
  return Glib::wrap(gnome_vfs_uri_dup(gobj()));
}

bool Uri::is_local() const
{
  return gnome_vfs_uri_is_local(const_cast<GnomeVFSURI*>(gobj()));
}

bool Uri::has_parent() const
{
  return gnome_vfs_uri_has_parent(const_cast<GnomeVFSURI*>(gobj()));
}

Glib::RefPtr<Uri> Uri::get_parent()
{
  return Glib::wrap(gnome_vfs_uri_get_parent(gobj()));
}

Glib::RefPtr<const Uri> Uri::get_parent() const
{
  return Glib::wrap(gnome_vfs_uri_get_parent(const_cast<GnomeVFSURI*>(gobj())));
}

Glib::ustring Uri::get_host_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_vfs_uri_get_host_name(const_cast<GnomeVFSURI*>(gobj())));
}

Glib::ustring Uri::get_scheme() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_vfs_uri_get_scheme(const_cast<GnomeVFSURI*>(gobj())));
}

guint Uri::get_host_port() const
{
  return gnome_vfs_uri_get_host_port(const_cast<GnomeVFSURI*>(gobj()));
}

Glib::ustring Uri::get_user_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_vfs_uri_get_user_name(const_cast<GnomeVFSURI*>(gobj())));
}

Glib::ustring Uri::get_password() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_vfs_uri_get_password(const_cast<GnomeVFSURI*>(gobj())));
}

void Uri::set_host_name(const Glib::ustring& host_name)
{
gnome_vfs_uri_set_host_name(gobj(), host_name.c_str()); 
}

void Uri::set_host_port(guint host_port)
{
gnome_vfs_uri_set_host_port(gobj(), host_port); 
}

void Uri::set_user_name(const Glib::ustring& user_name)
{
gnome_vfs_uri_set_user_name(gobj(), user_name.c_str()); 
}

void Uri::set_password(const Glib::ustring& password)
{
gnome_vfs_uri_set_password(gobj(), password.c_str()); 
}

bool Uri::equal(const Glib::RefPtr<const Uri>& uri) const
{
  return gnome_vfs_uri_equal(const_cast<GnomeVFSURI*>(gobj()), Glib::unwrap(uri));
}


bool operator==(const Uri& lhs, const Uri& rhs)
{
  return (gnome_vfs_uri_equal(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator!=(const Uri& lhs, const Uri& rhs)
{
  return (gnome_vfs_uri_equal(lhs.gobj(), rhs.gobj()) == 0);
}


bool Uri::is_parent(const Glib::RefPtr<const Uri>& possible_child, bool recursive) const
{
  return gnome_vfs_uri_is_parent(const_cast<GnomeVFSURI*>(gobj()), Glib::unwrap(possible_child), static_cast<int>(recursive));
}

Glib::ustring Uri::get_path() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_vfs_uri_get_path(const_cast<GnomeVFSURI*>(gobj())));
}

Glib::ustring Uri::get_fragment_identifier() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_vfs_uri_get_fragment_identifier(const_cast<GnomeVFSURI*>(gobj())));
}

Glib::ustring Uri::extract_dirname() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_vfs_uri_extract_dirname(const_cast<GnomeVFSURI*>(gobj())));
}

Glib::ustring Uri::extract_short_name() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_vfs_uri_extract_short_name(const_cast<GnomeVFSURI*>(gobj())));
}

Glib::ustring Uri::extract_short_path_name() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_vfs_uri_extract_short_path_name(const_cast<GnomeVFSURI*>(gobj())));
}

Glib::ustring Uri::make_full_from_relative(const Glib::ustring& base_uri, const Glib::ustring& relative_uri)
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_vfs_uri_make_full_from_relative(base_uri.c_str(), relative_uri.c_str()));
}


Glib::ustring Uri::format_for_display(const Glib::ustring& uri)
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_vfs_format_uri_for_display(uri.c_str()));
}


Glib::ustring Uri::make_from_input(const Glib::ustring& uri)
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_vfs_make_uri_from_input(uri.c_str()));
}


Glib::ustring Uri::make_from_input(const Glib::ustring& uri, MakeURIDirs dirs)
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_vfs_make_uri_from_input_with_dirs(uri.c_str(), ((GnomeVFSMakeURIDirs)(dirs))));
}


Glib::ustring Uri::make_canonical_strip_fragment(const Glib::ustring& uri)
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_vfs_make_uri_canonical_strip_fragment(uri.c_str()));
}


bool Uri::uris_match(const Glib::ustring& uri_1, const Glib::ustring& uri_2)
{
  return gnome_vfs_uris_match(uri_1.c_str(), uri_2.c_str());
}


Glib::ustring Uri::get_scheme(const Glib::ustring& uri)
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_vfs_get_uri_scheme(uri.c_str()));
}


Glib::ustring Uri::make_from_shell_arg(const Glib::ustring& uri)
{
  return Glib::convert_return_gchar_ptr_to_ustring(gnome_vfs_make_uri_from_shell_arg(uri.c_str()));
}


} // namespace Vfs

} // namespace Gnome


