pragma Ada_95;
pragma Source_File_Name (ada_main, Spec_File_Name => "b_gnatb.ads");
pragma Source_File_Name (ada_main, Body_File_Name => "b_gnatb.adb");

package body ada_main is
   pragma Warnings (Off);

   E036 : Short_Integer; pragma Import (Ada, E036, "system__os_lib_E");
   E014 : Short_Integer; pragma Import (Ada, E014, "system__soft_links_E");
   E127 : Short_Integer; pragma Import (Ada, E127, "gnat__byte_order_mark_E");
   E020 : Short_Integer; pragma Import (Ada, E020, "system__exception_table_E");
   E034 : Short_Integer; pragma Import (Ada, E034, "ada__command_line__response_file_E");
   E010 : Short_Integer; pragma Import (Ada, E010, "system__secondary_stack_E");
   E052 : Short_Integer; pragma Import (Ada, E052, "types_E");
   E164 : Short_Integer; pragma Import (Ada, E164, "bcheck_E");
   E168 : Short_Integer; pragma Import (Ada, E168, "bindgen_E");
   E174 : Short_Integer; pragma Import (Ada, E174, "bindusg_E");
   E101 : Short_Integer; pragma Import (Ada, E101, "casing_E");
   E111 : Short_Integer; pragma Import (Ada, E111, "elists_E");
   E002 : Short_Integer; pragma Import (Ada, E002, "gnatbind_E");
   E065 : Short_Integer; pragma Import (Ada, E065, "gnatvsn_E");
   E048 : Short_Integer; pragma Import (Ada, E048, "hostparm_E");
   E113 : Short_Integer; pragma Import (Ada, E113, "nlists_E");
   E063 : Short_Integer; pragma Import (Ada, E063, "opt_E");
   E061 : Short_Integer; pragma Import (Ada, E061, "csets_E");
   E047 : Short_Integer; pragma Import (Ada, E047, "output_E");
   E097 : Short_Integer; pragma Import (Ada, E097, "rident_E");
   E094 : Short_Integer; pragma Import (Ada, E094, "sdefault_E");
   E121 : Short_Integer; pragma Import (Ada, E121, "stand_E");
   E160 : Short_Integer; pragma Import (Ada, E160, "styleg_E");
   E154 : Short_Integer; pragma Import (Ada, E154, "scng_E");
   E148 : Short_Integer; pragma Import (Ada, E148, "stylesw_E");
   E176 : Short_Integer; pragma Import (Ada, E176, "switch_E");
   E178 : Short_Integer; pragma Import (Ada, E178, "switch__b_E");
   E067 : Short_Integer; pragma Import (Ada, E067, "tree_io_E");
   E138 : Short_Integer; pragma Import (Ada, E138, "erroutc_E");
   E085 : Short_Integer; pragma Import (Ada, E085, "namet_E");
   E043 : Short_Integer; pragma Import (Ada, E043, "ali_E");
   E103 : Short_Integer; pragma Import (Ada, E103, "ali__util_E");
   E166 : Short_Integer; pragma Import (Ada, E166, "binde_E");
   E131 : Short_Integer; pragma Import (Ada, E131, "binderr_E");
   E045 : Short_Integer; pragma Import (Ada, E045, "butil_E");
   E076 : Short_Integer; pragma Import (Ada, E076, "fmap_E");
   E099 : Short_Integer; pragma Import (Ada, E099, "fname_E");
   E150 : Short_Integer; pragma Import (Ada, E150, "fname__uf_E");
   E142 : Short_Integer; pragma Import (Ada, E142, "lib_E");
   E073 : Short_Integer; pragma Import (Ada, E073, "osint_E");
   E172 : Short_Integer; pragma Import (Ada, E172, "osint__b_E");
   E146 : Short_Integer; pragma Import (Ada, E146, "sem_aux_E");
   E125 : Short_Integer; pragma Import (Ada, E125, "sinput_E");
   E162 : Short_Integer; pragma Import (Ada, E162, "sinput__c_E");
   E123 : Short_Integer; pragma Import (Ada, E123, "snames_E");
   E107 : Short_Integer; pragma Import (Ada, E107, "aspects_E");
   E140 : Short_Integer; pragma Import (Ada, E140, "stringt_E");
   E059 : Short_Integer; pragma Import (Ada, E059, "targparm_E");
   E117 : Short_Integer; pragma Import (Ada, E117, "uintp_E");
   E132 : Short_Integer; pragma Import (Ada, E132, "err_vars_E");
   E136 : Short_Integer; pragma Import (Ada, E136, "errout_E");
   E134 : Short_Integer; pragma Import (Ada, E134, "restrict_E");
   E144 : Short_Integer; pragma Import (Ada, E144, "uname_E");
   E119 : Short_Integer; pragma Import (Ada, E119, "urealp_E");
   E109 : Short_Integer; pragma Import (Ada, E109, "einfo_E");
   E129 : Short_Integer; pragma Import (Ada, E129, "scans_E");
   E115 : Short_Integer; pragma Import (Ada, E115, "sinfo_E");
   E105 : Short_Integer; pragma Import (Ada, E105, "atree_E");
   E088 : Short_Integer; pragma Import (Ada, E088, "widechar_E");

   Local_Priority_Specific_Dispatching : constant String := "";
   Local_Interrupt_States : constant String := "";

   Is_Elaborated : Boolean := False;

   procedure adafinal is
      procedure s_stalib_adafinal;
      pragma Import (C, s_stalib_adafinal, "system__standard_library__adafinal");
   begin
      if not Is_Elaborated then
         return;
      end if;
      Is_Elaborated := False;
      s_stalib_adafinal;
   end adafinal;

   type No_Param_Proc is access procedure;

   procedure adainit is
      Main_Priority : Integer;
      pragma Import (C, Main_Priority, "__gl_main_priority");
      Time_Slice_Value : Integer;
      pragma Import (C, Time_Slice_Value, "__gl_time_slice_val");
      WC_Encoding : Character;
      pragma Import (C, WC_Encoding, "__gl_wc_encoding");
      Locking_Policy : Character;
      pragma Import (C, Locking_Policy, "__gl_locking_policy");
      Queuing_Policy : Character;
      pragma Import (C, Queuing_Policy, "__gl_queuing_policy");
      Task_Dispatching_Policy : Character;
      pragma Import (C, Task_Dispatching_Policy, "__gl_task_dispatching_policy");
      Priority_Specific_Dispatching : System.Address;
      pragma Import (C, Priority_Specific_Dispatching, "__gl_priority_specific_dispatching");
      Num_Specific_Dispatching : Integer;
      pragma Import (C, Num_Specific_Dispatching, "__gl_num_specific_dispatching");
      Main_CPU : Integer;
      pragma Import (C, Main_CPU, "__gl_main_cpu");
      Interrupt_States : System.Address;
      pragma Import (C, Interrupt_States, "__gl_interrupt_states");
      Num_Interrupt_States : Integer;
      pragma Import (C, Num_Interrupt_States, "__gl_num_interrupt_states");
      Unreserve_All_Interrupts : Integer;
      pragma Import (C, Unreserve_All_Interrupts, "__gl_unreserve_all_interrupts");
      Detect_Blocking : Integer;
      pragma Import (C, Detect_Blocking, "__gl_detect_blocking");
      Default_Stack_Size : Integer;
      pragma Import (C, Default_Stack_Size, "__gl_default_stack_size");
      Leap_Seconds_Support : Integer;
      pragma Import (C, Leap_Seconds_Support, "__gl_leap_seconds_support");

      procedure Install_Handler;
      pragma Import (C, Install_Handler, "__gnat_install_handler");

      Handler_Installed : Integer;
      pragma Import (C, Handler_Installed, "__gnat_handler_installed");

      Finalize_Library_Objects : No_Param_Proc;
      pragma Import (C, Finalize_Library_Objects, "__gnat_finalize_library_objects");
   begin
      if Is_Elaborated then
         return;
      end if;
      Is_Elaborated := True;
      Main_Priority := -1;
      Time_Slice_Value := -1;
      WC_Encoding := 'b';
      Locking_Policy := ' ';
      Queuing_Policy := ' ';
      Task_Dispatching_Policy := ' ';
      Priority_Specific_Dispatching :=
        Local_Priority_Specific_Dispatching'Address;
      Num_Specific_Dispatching := 0;
      Main_CPU := -1;
      Interrupt_States := Local_Interrupt_States'Address;
      Num_Interrupt_States := 0;
      Unreserve_All_Interrupts := 0;
      Detect_Blocking := 0;
      Default_Stack_Size := -1;
      Leap_Seconds_Support := 0;

      if Handler_Installed = 0 then
         Install_Handler;
      end if;

      Finalize_Library_Objects := null;

      System.Soft_Links'Elab_Spec;
      E127 := E127 + 1;
      System.Exception_Table'Elab_Body;
      E020 := E020 + 1;
      Ada.Command_Line.Response_File'Elab_Spec;
      System.Soft_Links'Elab_Body;
      E014 := E014 + 1;
      System.Os_Lib'Elab_Body;
      E036 := E036 + 1;
      System.Secondary_Stack'Elab_Body;
      E010 := E010 + 1;
      E034 := E034 + 1;
      Types'Elab_Spec;
      E052 := E052 + 1;
      E065 := E065 + 1;
      Hostparm'Elab_Spec;
      E048 := E048 + 1;
      Opt'Elab_Spec;
      Csets'Elab_Body;
      E061 := E061 + 1;
      Output'Elab_Spec;
      E047 := E047 + 1;
      Rident'Elab_Spec;
      E097 := E097 + 1;
      E148 := E148 + 1;
      Tree_Io'Elab_Spec;
      E067 := E067 + 1;
      E121 := E121 + 1;
      E063 := E063 + 1;
      Elists'Elab_Body;
      E111 := E111 + 1;
      Erroutc'Elab_Spec;
      Namet'Elab_Spec;
      ALI'ELAB_SPEC;
      ALI.UTIL'ELAB_SPEC;
      Binde'Elab_Spec;
      E131 := E131 + 1;
      Fname'Elab_Body;
      E099 := E099 + 1;
      Lib'Elab_Spec;
      Osint'Elab_Spec;
      Fmap'Elab_Body;
      E076 := E076 + 1;
      ALI'ELAB_BODY;
      E043 := E043 + 1;
      E178 := E178 + 1;
      E176 := E176 + 1;
      E094 := E094 + 1;
      E174 := E174 + 1;
      E164 := E164 + 1;
      Sem_Aux'Elab_Spec;
      Sinput'Elab_Spec;
      E162 := E162 + 1;
      Snames'Elab_Body;
      E123 := E123 + 1;
      Aspects'Elab_Spec;
      Stringt'Elab_Body;
      E140 := E140 + 1;
      Targparm'Elab_Spec;
      Targparm'Elab_Body;
      E059 := E059 + 1;
      Osint'Elab_Body;
      E073 := E073 + 1;
      E045 := E045 + 1;
      Binde'Elab_Body;
      E166 := E166 + 1;
      E002 := E002 + 1;
      Bindgen'Elab_Body;
      E168 := E168 + 1;
      Uintp'Elab_Spec;
      Uintp'Elab_Body;
      E117 := E117 + 1;
      Err_Vars'Elab_Spec;
      E132 := E132 + 1;
      Errout'Elab_Spec;
      Restrict'Elab_Spec;
      Urealp'Elab_Body;
      E119 := E119 + 1;
      Scans'Elab_Spec;
      E129 := E129 + 1;
      Atree'Elab_Spec;
      Atree'Elab_Body;
      E105 := E105 + 1;
      E115 := E115 + 1;
      Einfo'Elab_Body;
      E109 := E109 + 1;
      E144 := E144 + 1;
      Restrict'Elab_Body;
      E134 := E134 + 1;
      Errout'Elab_Body;
      E136 := E136 + 1;
      Aspects'Elab_Body;
      E107 := E107 + 1;
      E146 := E146 + 1;
      E138 := E138 + 1;
      E160 := E160 + 1;
      Nlists'Elab_Body;
      E113 := E113 + 1;
      E088 := E088 + 1;
      E125 := E125 + 1;
      E142 := E142 + 1;
      Fname.Uf'Elab_Body;
      E150 := E150 + 1;
      Namet'Elab_Body;
      E085 := E085 + 1;
      Osint.B'Elab_Body;
      E172 := E172 + 1;
      E154 := E154 + 1;
      E101 := E101 + 1;
      ALI.UTIL'ELAB_BODY;
      E103 := E103 + 1;
   end adainit;

   procedure Ada_Main_Program;
   pragma Import (Ada, Ada_Main_Program, "_ada_gnatbind");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer
   is
      procedure Initialize (Addr : System.Address);
      pragma Import (C, Initialize, "__gnat_initialize");

      procedure Finalize;
      pragma Import (C, Finalize, "__gnat_finalize");
      SEH : aliased array (1 .. 2) of Integer;

      Ensure_Reference : aliased System.Address := Ada_Main_Program_Name'Address;
      pragma Volatile (Ensure_Reference);

   begin
      gnat_argc := argc;
      gnat_argv := argv;
      gnat_envp := envp;

      Initialize (SEH'Address);
      adainit;
      Ada_Main_Program;
      adafinal;
      Finalize;
      return (gnat_exit_status);
   end;

--  BEGIN Object file/option list
   --   ada/ada.o
   --   ada/gnat.o
   --   ada/g-hesora.o
   --   ada/interfac.o
   --   ada/system.o
   --   ada/s-addope.o
   --   ada/s-casuti.o
   --   ada/g-htable.o
   --   ada/s-imenne.o
   --   ada/s-parame.o
   --   ada/s-crtl.o
   --   ada/s-excdeb.o
   --   ada/s-stoele.o
   --   ada/s-stache.o
   --   ada/s-strhas.o
   --   ada/s-htable.o
   --   ada/s-string.o
   --   ada/s-traent.o
   --   ada/s-unstyp.o
   --   ada/s-utf_32.o
   --   ada/s-wchcon.o
   --   ada/s-wchjis.o
   --   ada/s-wchcnv.o
   --   ada/a-elchha.o
   --   ada/g-byorma.o
   --   ada/s-carun8.o
   --   ada/s-conca2.o
   --   ada/s-crc32.o
   --   ada/s-exctab.o
   --   ada/s-memory.o
   --   ada/s-stalib.o
   --   ada/s-soflin.o
   --   ada/a-except.o
   --   ada/s-os_lib.o
   --   ada/a-comlin.o
   --   ada/s-secsta.o
   --   ada/a-clrefi.o
   --   ada/debug.o
   --   ada/types.o
   --   ada/alloc.o
   --   ada/gnatvsn.o
   --   ada/hostparm.o
   --   ada/krunch.o
   --   ada/csets.o
   --   ada/output.o
   --   ada/rident.o
   --   ada/stylesw.o
   --   ada/tree_io.o
   --   ada/stand.o
   --   ada/opt.o
   --   ada/table.o
   --   ada/elists.o
   --   ada/binderr.o
   --   ada/fname.o
   --   ada/fmap.o
   --   ada/ali.o
   --   ada/switch-b.o
   --   ada/switch.o
   --   ada/sdefault.o
   --   ada/bindusg.o
   --   ada/bcheck.o
   --   ada/sinput-c.o
   --   ada/snames.o
   --   ada/stringt.o
   --   ada/targparm.o
   --   ada/osint.o
   --   ada/butil.o
   --   ada/binde.o
   --   ada/gnatbind.o
   --   ada/bindgen.o
   --   ada/uintp.o
   --   ada/err_vars.o
   --   ada/urealp.o
   --   ada/scans.o
   --   ada/atree.o
   --   ada/sinfo.o
   --   ada/einfo.o
   --   ada/uname.o
   --   ada/restrict.o
   --   ada/errout.o
   --   ada/aspects.o
   --   ada/sem_aux.o
   --   ada/erroutc.o
   --   ada/styleg.o
   --   ada/nlists.o
   --   ada/widechar.o
   --   ada/sinput.o
   --   ada/lib.o
   --   ada/fname-uf.o
   --   ada/namet.o
   --   ada/osint-b.o
   --   ada/scng.o
   --   ada/casing.o
   --   ada/ali-util.o
   --   -L./
   --   -Lada/
   --   -L/cygdrive/i/szsz/tmpp/cygwin64/mingw64-i686/mingw64-i686-gcc-4.9.2-1.i686/src/gcc-4.9.2/gcc/ada/
   --   -L/cygdrive/i/szsz/tmpp/cygwin64/mingw64-i686/mingw64-i686-gcc-4.9.2-1.i686/src/gcc-4.9.2/gcc/ada/gcc-interface/
   --   -L/usr/lib/gcc/i686-pc-cygwin/4.9.2/adalib/
   --   -static
   --   -lgnat
--  END Object file/option list   

end ada_main;
