#|  Logiweb, a system for electronic distribution of mathematics
    Copyright (C) 2004-2010 Klaus Grue

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Contact: Klaus Grue, DIKU, Universitetsparken 1, DK2100 Copenhagen,
    Denmark, grue@diku.dk, http://logiweb.eu/, http://www.diku.dk/~grue/

    Logiweb is a system for distribution of mathematical definitions,
    lemmas, and proofs. For more on Logiweb, consult http://logiweb.eu/.
|#

(in-package "COMMON-LISP-USER")

(defc gcc-args
 (list "-fPIC" "-Wall" "-g" "logiweb.c" "-shared"
  "-Wl,-soname,logiweb.so" "-o" "logiweb.so" "-lc"))

(deff compile-foreign ()
 (:unless (needs-update "logiweb.so" "logiweb.c") 0)
 (gcc-with-message gcc-args))

(defc compile-result (compile-foreign))

(etst compile-result 0)

(defmacro foreign (return-type name &rest argument-types)
 `(ffi:def-call-out ,name
   (:library "logiweb.so")
   (:language :stdc)
   (:arguments ,@argument-types)
   (:return-type ,return-type)))

(defmacro void (name &rest argument-types)
 `(foreign nil ,name ,@argument-types))

; General interface
(void buffer_rewind)
(foreign ffi:int int_get)
(foreign ffi:uchar char_get)
(void int_put (value ffi:int))
(void char_put (value ffi:uchar))

; Time function
(void unix_gettimeofday)

; Socket interface
(void fd_close)
(void host_ip)
(void udp_open)
(void udp_bind)
(void udp_recvfrom)
(void udp_sendto)
(void tcp_open)
(void tcp_accept)
(void tcp_recv)
(void tcp_send)
(void tcp_query)
(void inet_select)

; File interface
(void file_open)
(void file_read)

; Demonizer
(void unix_demonize)

; Test of dynamically loaded function:
; (void hello)
; (hello)

