/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|*Assembly Matcher Source Fragment                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  unsigned ComputeAvailableFeatures(uint64_t FeatureBits) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  bool mnemonicIsValid(StringRef Mnemonic, unsigned VariantID) override;
  unsigned MatchInstructionImpl(
                           const OperandVector &Operands,
                                MCInst &Inst,
                                unsigned &ErrorInfo, bool matchingInlineAsm,
                                unsigned VariantID = 0);
#endif // GET_ASSEMBLER_HEADER_INFO


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Flags for subtarget features that participate in instruction matching.
enum SubtargetFeatureFlag : uint8_t {
  Feature_HasAVX512 = (1U << 0),
  Feature_HasVLX = (1U << 1),
  Feature_Not64BitMode = (1U << 6),
  Feature_In64BitMode = (1U << 4),
  Feature_In16BitMode = (1U << 2),
  Feature_Not16BitMode = (1U << 5),
  Feature_In32BitMode = (1U << 3),
  Feature_None = 0
};

static unsigned MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 33 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 1;	 // "ah"
      case 'l':	 // 1 string to match.
        return 2;	 // "al"
      case 'x':	 // 1 string to match.
        return 3;	 // "ax"
      }
      break;
    case 'b':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 4;	 // "bh"
      case 'l':	 // 1 string to match.
        return 5;	 // "bl"
      case 'p':	 // 1 string to match.
        return 6;	 // "bp"
      case 'x':	 // 1 string to match.
        return 8;	 // "bx"
      }
      break;
    case 'c':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 9;	 // "ch"
      case 'l':	 // 1 string to match.
        return 10;	 // "cl"
      case 's':	 // 1 string to match.
        return 11;	 // "cs"
      case 'x':	 // 1 string to match.
        return 12;	 // "cx"
      }
      break;
    case 'd':	 // 5 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 13;	 // "dh"
      case 'i':	 // 1 string to match.
        return 14;	 // "di"
      case 'l':	 // 1 string to match.
        return 16;	 // "dl"
      case 's':	 // 1 string to match.
        return 17;	 // "ds"
      case 'x':	 // 1 string to match.
        return 18;	 // "dx"
      }
      break;
    case 'e':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return 28;	 // "es"
    case 'f':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return 32;	 // "fs"
    case 'g':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return 33;	 // "gs"
    case 'i':	 // 1 string to match.
      if (Name[1] != 'p')
        break;
      return 34;	 // "ip"
    case 'k':	 // 8 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return 81;	 // "k0"
      case '1':	 // 1 string to match.
        return 82;	 // "k1"
      case '2':	 // 1 string to match.
        return 83;	 // "k2"
      case '3':	 // 1 string to match.
        return 84;	 // "k3"
      case '4':	 // 1 string to match.
        return 85;	 // "k4"
      case '5':	 // 1 string to match.
        return 86;	 // "k5"
      case '6':	 // 1 string to match.
        return 87;	 // "k6"
      case '7':	 // 1 string to match.
        return 88;	 // "k7"
      }
      break;
    case 'r':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case '8':	 // 1 string to match.
        return 97;	 // "r8"
      case '9':	 // 1 string to match.
        return 98;	 // "r9"
      }
      break;
    case 's':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        return 45;	 // "si"
      case 'p':	 // 1 string to match.
        return 47;	 // "sp"
      case 's':	 // 1 string to match.
        return 49;	 // "ss"
      }
      break;
    }
    break;
  case 3:	 // 69 strings to match.
    switch (Name[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(Name.data()+1, "pl", 2))
        break;
      return 7;	 // "bpl"
    case 'c':	 // 10 strings to match.
      if (Name[1] != 'r')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 50;	 // "cr0"
      case '1':	 // 1 string to match.
        return 51;	 // "cr1"
      case '2':	 // 1 string to match.
        return 52;	 // "cr2"
      case '3':	 // 1 string to match.
        return 53;	 // "cr3"
      case '4':	 // 1 string to match.
        return 54;	 // "cr4"
      case '5':	 // 1 string to match.
        return 55;	 // "cr5"
      case '6':	 // 1 string to match.
        return 56;	 // "cr6"
      case '7':	 // 1 string to match.
        return 57;	 // "cr7"
      case '8':	 // 1 string to match.
        return 58;	 // "cr8"
      case '9':	 // 1 string to match.
        return 59;	 // "cr9"
      }
      break;
    case 'd':	 // 9 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return 15;	 // "dil"
      case 'r':	 // 8 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 66;	 // "dr0"
        case '1':	 // 1 string to match.
          return 67;	 // "dr1"
        case '2':	 // 1 string to match.
          return 68;	 // "dr2"
        case '3':	 // 1 string to match.
          return 69;	 // "dr3"
        case '4':	 // 1 string to match.
          return 70;	 // "dr4"
        case '5':	 // 1 string to match.
          return 71;	 // "dr5"
        case '6':	 // 1 string to match.
          return 72;	 // "dr6"
        case '7':	 // 1 string to match.
          return 73;	 // "dr7"
        }
        break;
      }
      break;
    case 'e':	 // 10 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 19;	 // "eax"
      case 'b':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 20;	 // "ebp"
        case 'x':	 // 1 string to match.
          return 21;	 // "ebx"
        }
        break;
      case 'c':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 22;	 // "ecx"
      case 'd':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 23;	 // "edi"
        case 'x':	 // 1 string to match.
          return 24;	 // "edx"
        }
        break;
      case 'i':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 26;	 // "eip"
        case 'z':	 // 1 string to match.
          return 27;	 // "eiz"
        }
        break;
      case 's':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 29;	 // "esi"
        case 'p':	 // 1 string to match.
          return 30;	 // "esp"
        }
        break;
      }
      break;
    case 'f':	 // 7 strings to match.
      if (Name[1] != 'p')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 74;	 // "fp0"
      case '1':	 // 1 string to match.
        return 75;	 // "fp1"
      case '2':	 // 1 string to match.
        return 76;	 // "fp2"
      case '3':	 // 1 string to match.
        return 77;	 // "fp3"
      case '4':	 // 1 string to match.
        return 78;	 // "fp4"
      case '5':	 // 1 string to match.
        return 79;	 // "fp5"
      case '6':	 // 1 string to match.
        return 80;	 // "fp6"
      }
      break;
    case 'm':	 // 8 strings to match.
      if (Name[1] != 'm')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 89;	 // "mm0"
      case '1':	 // 1 string to match.
        return 90;	 // "mm1"
      case '2':	 // 1 string to match.
        return 91;	 // "mm2"
      case '3':	 // 1 string to match.
        return 92;	 // "mm3"
      case '4':	 // 1 string to match.
        return 93;	 // "mm4"
      case '5':	 // 1 string to match.
        return 94;	 // "mm5"
      case '6':	 // 1 string to match.
        return 95;	 // "mm6"
      case '7':	 // 1 string to match.
        return 96;	 // "mm7"
      }
      break;
    case 'r':	 // 22 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 6 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 99;	 // "r10"
        case '1':	 // 1 string to match.
          return 100;	 // "r11"
        case '2':	 // 1 string to match.
          return 101;	 // "r12"
        case '3':	 // 1 string to match.
          return 102;	 // "r13"
        case '4':	 // 1 string to match.
          return 103;	 // "r14"
        case '5':	 // 1 string to match.
          return 104;	 // "r15"
        }
        break;
      case '8':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 209;	 // "r8b"
        case 'd':	 // 1 string to match.
          return 217;	 // "r8d"
        case 'w':	 // 1 string to match.
          return 225;	 // "r8w"
        }
        break;
      case '9':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 210;	 // "r9b"
        case 'd':	 // 1 string to match.
          return 218;	 // "r9d"
        case 'w':	 // 1 string to match.
          return 226;	 // "r9w"
        }
        break;
      case 'a':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 35;	 // "rax"
      case 'b':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 36;	 // "rbp"
        case 'x':	 // 1 string to match.
          return 37;	 // "rbx"
        }
        break;
      case 'c':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 38;	 // "rcx"
      case 'd':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 39;	 // "rdi"
        case 'x':	 // 1 string to match.
          return 40;	 // "rdx"
        }
        break;
      case 'i':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 41;	 // "rip"
        case 'z':	 // 1 string to match.
          return 42;	 // "riz"
        }
        break;
      case 's':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 43;	 // "rsi"
        case 'p':	 // 1 string to match.
          return 44;	 // "rsp"
        }
        break;
      }
      break;
    case 's':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return 46;	 // "sil"
      case 'p':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return 48;	 // "spl"
      }
      break;
    }
    break;
  case 4:	 // 55 strings to match.
    switch (Name[0]) {
    default: break;
    case 'c':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "r1", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 60;	 // "cr10"
      case '1':	 // 1 string to match.
        return 61;	 // "cr11"
      case '2':	 // 1 string to match.
        return 62;	 // "cr12"
      case '3':	 // 1 string to match.
        return 63;	 // "cr13"
      case '4':	 // 1 string to match.
        return 64;	 // "cr14"
      case '5':	 // 1 string to match.
        return 65;	 // "cr15"
      }
      break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "psw", 3))
        break;
      return 31;	 // "fpsw"
    case 'r':	 // 18 strings to match.
      if (Name[1] != '1')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 211;	 // "r10b"
        case 'd':	 // 1 string to match.
          return 219;	 // "r10d"
        case 'w':	 // 1 string to match.
          return 227;	 // "r10w"
        }
        break;
      case '1':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 212;	 // "r11b"
        case 'd':	 // 1 string to match.
          return 220;	 // "r11d"
        case 'w':	 // 1 string to match.
          return 228;	 // "r11w"
        }
        break;
      case '2':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 213;	 // "r12b"
        case 'd':	 // 1 string to match.
          return 221;	 // "r12d"
        case 'w':	 // 1 string to match.
          return 229;	 // "r12w"
        }
        break;
      case '3':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 214;	 // "r13b"
        case 'd':	 // 1 string to match.
          return 222;	 // "r13d"
        case 'w':	 // 1 string to match.
          return 230;	 // "r13w"
        }
        break;
      case '4':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 215;	 // "r14b"
        case 'd':	 // 1 string to match.
          return 223;	 // "r14d"
        case 'w':	 // 1 string to match.
          return 231;	 // "r14w"
        }
        break;
      case '5':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 216;	 // "r15b"
        case 'd':	 // 1 string to match.
          return 224;	 // "r15d"
        case 'w':	 // 1 string to match.
          return 232;	 // "r15w"
        }
        break;
      }
      break;
    case 'x':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 113;	 // "xmm0"
      case '1':	 // 1 string to match.
        return 114;	 // "xmm1"
      case '2':	 // 1 string to match.
        return 115;	 // "xmm2"
      case '3':	 // 1 string to match.
        return 116;	 // "xmm3"
      case '4':	 // 1 string to match.
        return 117;	 // "xmm4"
      case '5':	 // 1 string to match.
        return 118;	 // "xmm5"
      case '6':	 // 1 string to match.
        return 119;	 // "xmm6"
      case '7':	 // 1 string to match.
        return 120;	 // "xmm7"
      case '8':	 // 1 string to match.
        return 121;	 // "xmm8"
      case '9':	 // 1 string to match.
        return 122;	 // "xmm9"
      }
      break;
    case 'y':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 145;	 // "ymm0"
      case '1':	 // 1 string to match.
        return 146;	 // "ymm1"
      case '2':	 // 1 string to match.
        return 147;	 // "ymm2"
      case '3':	 // 1 string to match.
        return 148;	 // "ymm3"
      case '4':	 // 1 string to match.
        return 149;	 // "ymm4"
      case '5':	 // 1 string to match.
        return 150;	 // "ymm5"
      case '6':	 // 1 string to match.
        return 151;	 // "ymm6"
      case '7':	 // 1 string to match.
        return 152;	 // "ymm7"
      case '8':	 // 1 string to match.
        return 153;	 // "ymm8"
      case '9':	 // 1 string to match.
        return 154;	 // "ymm9"
      }
      break;
    case 'z':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 177;	 // "zmm0"
      case '1':	 // 1 string to match.
        return 178;	 // "zmm1"
      case '2':	 // 1 string to match.
        return 179;	 // "zmm2"
      case '3':	 // 1 string to match.
        return 180;	 // "zmm3"
      case '4':	 // 1 string to match.
        return 181;	 // "zmm4"
      case '5':	 // 1 string to match.
        return 182;	 // "zmm5"
      case '6':	 // 1 string to match.
        return 183;	 // "zmm6"
      case '7':	 // 1 string to match.
        return 184;	 // "zmm7"
      case '8':	 // 1 string to match.
        return 185;	 // "zmm8"
      case '9':	 // 1 string to match.
        return 186;	 // "zmm9"
      }
      break;
    }
    break;
  case 5:	 // 75 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "lags", 4))
        break;
      return 25;	 // "flags"
    case 's':	 // 8 strings to match.
      if (memcmp(Name.data()+1, "t(", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 105;	 // "st(0)"
      case '1':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 106;	 // "st(1)"
      case '2':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 107;	 // "st(2)"
      case '3':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 108;	 // "st(3)"
      case '4':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 109;	 // "st(4)"
      case '5':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 110;	 // "st(5)"
      case '6':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 111;	 // "st(6)"
      case '7':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 112;	 // "st(7)"
      }
      break;
    case 'x':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 123;	 // "xmm10"
        case '1':	 // 1 string to match.
          return 124;	 // "xmm11"
        case '2':	 // 1 string to match.
          return 125;	 // "xmm12"
        case '3':	 // 1 string to match.
          return 126;	 // "xmm13"
        case '4':	 // 1 string to match.
          return 127;	 // "xmm14"
        case '5':	 // 1 string to match.
          return 128;	 // "xmm15"
        case '6':	 // 1 string to match.
          return 129;	 // "xmm16"
        case '7':	 // 1 string to match.
          return 130;	 // "xmm17"
        case '8':	 // 1 string to match.
          return 131;	 // "xmm18"
        case '9':	 // 1 string to match.
          return 132;	 // "xmm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 133;	 // "xmm20"
        case '1':	 // 1 string to match.
          return 134;	 // "xmm21"
        case '2':	 // 1 string to match.
          return 135;	 // "xmm22"
        case '3':	 // 1 string to match.
          return 136;	 // "xmm23"
        case '4':	 // 1 string to match.
          return 137;	 // "xmm24"
        case '5':	 // 1 string to match.
          return 138;	 // "xmm25"
        case '6':	 // 1 string to match.
          return 139;	 // "xmm26"
        case '7':	 // 1 string to match.
          return 140;	 // "xmm27"
        case '8':	 // 1 string to match.
          return 141;	 // "xmm28"
        case '9':	 // 1 string to match.
          return 142;	 // "xmm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 143;	 // "xmm30"
        case '1':	 // 1 string to match.
          return 144;	 // "xmm31"
        }
        break;
      }
      break;
    case 'y':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 155;	 // "ymm10"
        case '1':	 // 1 string to match.
          return 156;	 // "ymm11"
        case '2':	 // 1 string to match.
          return 157;	 // "ymm12"
        case '3':	 // 1 string to match.
          return 158;	 // "ymm13"
        case '4':	 // 1 string to match.
          return 159;	 // "ymm14"
        case '5':	 // 1 string to match.
          return 160;	 // "ymm15"
        case '6':	 // 1 string to match.
          return 161;	 // "ymm16"
        case '7':	 // 1 string to match.
          return 162;	 // "ymm17"
        case '8':	 // 1 string to match.
          return 163;	 // "ymm18"
        case '9':	 // 1 string to match.
          return 164;	 // "ymm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 165;	 // "ymm20"
        case '1':	 // 1 string to match.
          return 166;	 // "ymm21"
        case '2':	 // 1 string to match.
          return 167;	 // "ymm22"
        case '3':	 // 1 string to match.
          return 168;	 // "ymm23"
        case '4':	 // 1 string to match.
          return 169;	 // "ymm24"
        case '5':	 // 1 string to match.
          return 170;	 // "ymm25"
        case '6':	 // 1 string to match.
          return 171;	 // "ymm26"
        case '7':	 // 1 string to match.
          return 172;	 // "ymm27"
        case '8':	 // 1 string to match.
          return 173;	 // "ymm28"
        case '9':	 // 1 string to match.
          return 174;	 // "ymm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 175;	 // "ymm30"
        case '1':	 // 1 string to match.
          return 176;	 // "ymm31"
        }
        break;
      }
      break;
    case 'z':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 187;	 // "zmm10"
        case '1':	 // 1 string to match.
          return 188;	 // "zmm11"
        case '2':	 // 1 string to match.
          return 189;	 // "zmm12"
        case '3':	 // 1 string to match.
          return 190;	 // "zmm13"
        case '4':	 // 1 string to match.
          return 191;	 // "zmm14"
        case '5':	 // 1 string to match.
          return 192;	 // "zmm15"
        case '6':	 // 1 string to match.
          return 193;	 // "zmm16"
        case '7':	 // 1 string to match.
          return 194;	 // "zmm17"
        case '8':	 // 1 string to match.
          return 195;	 // "zmm18"
        case '9':	 // 1 string to match.
          return 196;	 // "zmm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 197;	 // "zmm20"
        case '1':	 // 1 string to match.
          return 198;	 // "zmm21"
        case '2':	 // 1 string to match.
          return 199;	 // "zmm22"
        case '3':	 // 1 string to match.
          return 200;	 // "zmm23"
        case '4':	 // 1 string to match.
          return 201;	 // "zmm24"
        case '5':	 // 1 string to match.
          return 202;	 // "zmm25"
        case '6':	 // 1 string to match.
          return 203;	 // "zmm26"
        case '7':	 // 1 string to match.
          return 204;	 // "zmm27"
        case '8':	 // 1 string to match.
          return 205;	 // "zmm28"
        case '9':	 // 1 string to match.
          return 206;	 // "zmm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 207;	 // "zmm30"
        case '1':	 // 1 string to match.
          return 208;	 // "zmm31"
        }
        break;
      }
      break;
    }
    break;
  }
  return 0;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(unsigned Val) {
  switch(Val) {
  case Feature_HasAVX512: return "AVX-512 ISA";
  case Feature_HasVLX: return "AVX-512 VLX ISA";
  case Feature_Not64BitMode: return "Not 64-bit mode";
  case Feature_In64BitMode: return "64-bit mode";
  case Feature_In16BitMode: return "16-bit mode";
  case Feature_Not16BitMode: return "Not 16-bit mode";
  case Feature_In32BitMode: return "32-bit mode";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, unsigned Features, unsigned VariantID) {
  switch (VariantID) {
    case 0:
      switch (Mnemonic.size()) {
      default: break;
      case 3:	 // 6 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 4 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'b':	 // 1 string to match.
            if (Mnemonic[2] != 'w')
              break;
            Mnemonic = "cbtw";	 // "cbw"
            return;
          case 'd':	 // 1 string to match.
            if (Mnemonic[2] != 'q')
              break;
            Mnemonic = "cltd";	 // "cdq"
            return;
          case 'q':	 // 1 string to match.
            if (Mnemonic[2] != 'o')
              break;
            Mnemonic = "cqto";	 // "cqo"
            return;
          case 'w':	 // 1 string to match.
            if (Mnemonic[2] != 'd')
              break;
            Mnemonic = "cwtd";	 // "cwd"
            return;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "op", 2))
            break;
          if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "pop"
            Mnemonic = "popw";
          else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
            Mnemonic = "popl";
          else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
            Mnemonic = "popq";
          return;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "et", 2))
            break;
          if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "ret"
            Mnemonic = "retw";
          else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
            Mnemonic = "retl";
          else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
            Mnemonic = "retq";
          return;
        }
        break;
      case 4:	 // 19 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "ll", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "call"
              Mnemonic = "callw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "calll";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "callq";
            return;
          case 'd':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "qe", 2))
              break;
            Mnemonic = "cltq";	 // "cdqe"
            return;
          case 'w':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "de", 2))
              break;
            Mnemonic = "cwtl";	 // "cwde"
            return;
          }
          break;
        case 'i':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ret", 3))
            break;
          if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "iret"
            Mnemonic = "iretw";
          else if ((Features & Feature_Not16BitMode) == Feature_Not16BitMode)
            Mnemonic = "iretl";
          return;
        case 'l':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "lgdt"
              Mnemonic = "lgdtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "lgdtl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "lgdtq";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "lidt"
              Mnemonic = "lidtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "lidtl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "lidtq";
            return;
          case 'r':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "et", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "lret"
              Mnemonic = "lretw";
            else if ((Features & Feature_Not16BitMode) == Feature_Not16BitMode)
              Mnemonic = "lretl";
            return;
          }
          break;
        case 'p':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 2 strings to match.
            if (Mnemonic[2] != 'p')
              break;
            switch (Mnemonic[3]) {
            default: break;
            case 'a':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "popa"
                Mnemonic = "popaw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "popal";
              return;
            case 'f':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "popf"
                Mnemonic = "popfw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "popfl";
              else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
                Mnemonic = "popfq";
              return;
            }
            break;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "push"
              Mnemonic = "pushw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "pushl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "pushq";
            return;
          }
          break;
        case 'r':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "ep", 2))
            break;
          switch (Mnemonic[3]) {
          default: break;
          case 'e':	 // 1 string to match.
            Mnemonic = "rep";	 // "repe"
            return;
          case 'z':	 // 1 string to match.
            Mnemonic = "rep";	 // "repz"
            return;
          }
          break;
        case 's':	 // 6 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'a':	 // 4 strings to match.
            if (Mnemonic[2] != 'l')
              break;
            switch (Mnemonic[3]) {
            default: break;
            case 'b':	 // 1 string to match.
              Mnemonic = "shlb";	 // "salb"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "shll";	 // "sall"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "shlq";	 // "salq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "shlw";	 // "salw"
              return;
            }
            break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "sgdt"
              Mnemonic = "sgdtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "sgdtl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "sgdtq";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "sidt"
              Mnemonic = "sidtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "sidtl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "sidtq";
            return;
          }
          break;
        case 'u':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "d2a", 3))
            break;
          Mnemonic = "ud2";	 // "ud2a"
          return;
        }
        break;
      case 5:	 // 12 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'f':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "ldq", 3))
              break;
            Mnemonic = "fildll";	 // "fildq"
            return;
          case 'w':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "ait", 3))
              break;
            Mnemonic = "wait";	 // "fwait"
            return;
          }
          break;
        case 'l':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "oopz", 4))
            break;
          Mnemonic = "loope";	 // "loopz"
          return;
        case 'p':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "pfd", 3))
              break;
            Mnemonic = "popfl";	 // "popfd"
            return;
          case 'u':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2))
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'a':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "pusha"
                Mnemonic = "pushaw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "pushal";
              return;
            case 'f':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "pushf"
                Mnemonic = "pushfw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "pushfl";
              else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
                Mnemonic = "pushfq";
              return;
            }
            break;
          }
          break;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "epnz", 4))
            break;
          Mnemonic = "repne";	 // "repnz"
          return;
        case 's':	 // 4 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3))
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'b':	 // 1 string to match.
            Mnemonic = "movsb";	 // "smovb"
            return;
          case 'l':	 // 1 string to match.
            Mnemonic = "movsl";	 // "smovl"
            return;
          case 'q':	 // 1 string to match.
            Mnemonic = "movsq";	 // "smovq"
            return;
          case 'w':	 // 1 string to match.
            Mnemonic = "movsw";	 // "smovw"
            return;
          }
          break;
        case 'v':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "errw", 4))
            break;
          Mnemonic = "verr";	 // "verrw"
          return;
        }
        break;
      case 6:	 // 16 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 6 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3))
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'c':	 // 3 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovbl";	 // "cmovcl"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovbq";	 // "cmovcq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovbw";	 // "cmovcw"
              return;
            }
            break;
          case 'z':	 // 3 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovel";	 // "cmovzl"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmoveq";	 // "cmovzq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovew";	 // "cmovzw"
              return;
            }
            break;
          }
          break;
        case 'f':	 // 5 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 3 strings to match.
            switch (Mnemonic[2]) {
            default: break;
            case 'm':	 // 2 strings to match.
              if (memcmp(Mnemonic.data()+3, "ov", 2))
                break;
              switch (Mnemonic[5]) {
              default: break;
              case 'a':	 // 1 string to match.
                Mnemonic = "fcmovnbe";	 // "fcmova"
                return;
              case 'z':	 // 1 string to match.
                Mnemonic = "fcmove";	 // "fcmovz"
                return;
              }
              break;
            case 'o':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+3, "mip", 3))
                break;
              Mnemonic = "fcompi";	 // "fcomip"
              return;
            }
            break;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "stpq", 4))
              break;
            Mnemonic = "fistpll";	 // "fistpq"
            return;
          case 'l':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dcww", 4))
              break;
            Mnemonic = "fldcw";	 // "fldcww"
            return;
          }
          break;
        case 'l':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'e':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "ave", 3))
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'l':	 // 1 string to match.
              if ((Features & Feature_Not64BitMode) == Feature_Not64BitMode)	 // "leavel"
                Mnemonic = "leave";
              return;
            case 'q':	 // 1 string to match.
              if ((Features & Feature_In64BitMode) == Feature_In64BitMode)	 // "leaveq"
                Mnemonic = "leave";
              return;
            }
            break;
          case 'o':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "opnz", 4))
              break;
            Mnemonic = "loopne";	 // "loopnz"
            return;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ushfd", 5))
            break;
          Mnemonic = "pushfl";	 // "pushfd"
          return;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ysret", 5))
            break;
          Mnemonic = "sysretl";	 // "sysret"
          return;
        }
        break;
      case 7:	 // 31 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 24 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3))
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'n':	 // 18 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovbel";	 // "cmovnal"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovbeq";	 // "cmovnaq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovbew";	 // "cmovnaw"
                return;
              }
              break;
            case 'b':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovael";	 // "cmovnbl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovaeq";	 // "cmovnbq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovaew";	 // "cmovnbw"
                return;
              }
              break;
            case 'c':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovael";	 // "cmovncl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovaeq";	 // "cmovncq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovaew";	 // "cmovncw"
                return;
              }
              break;
            case 'g':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovlel";	 // "cmovngl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovleq";	 // "cmovngq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovlew";	 // "cmovngw"
                return;
              }
              break;
            case 'l':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovgel";	 // "cmovnll"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovgeq";	 // "cmovnlq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovgew";	 // "cmovnlw"
                return;
              }
              break;
            case 'z':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovnel";	 // "cmovnzl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovneq";	 // "cmovnzq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovnew";	 // "cmovnzw"
                return;
              }
              break;
            }
            break;
          case 'p':	 // 6 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'e':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovpl";	 // "cmovpel"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovpq";	 // "cmovpeq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovpw";	 // "cmovpew"
                return;
              }
              break;
            case 'o':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovnpl";	 // "cmovpol"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovnpq";	 // "cmovpoq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovnpw";	 // "cmovpow"
                return;
              }
              break;
            }
            break;
          }
          break;
        case 'f':	 // 6 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "mov", 3))
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Mnemonic[6] != 'e')
                break;
              Mnemonic = "fcmovnb";	 // "fcmovae"
              return;
            case 'n':	 // 1 string to match.
              if (Mnemonic[6] != 'a')
                break;
              Mnemonic = "fcmovbe";	 // "fcmovna"
              return;
            }
            break;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "sttpq", 5))
              break;
            Mnemonic = "fisttpll";	 // "fisttpq"
            return;
          case 'n':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "st", 2))
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'c':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+5, "ww", 2))
                break;
              Mnemonic = "fnstcw";	 // "fnstcww"
              return;
            case 's':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+5, "ww", 2))
                break;
              Mnemonic = "fnstsw";	 // "fnstsww"
              return;
            }
            break;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "comip", 5))
              break;
            Mnemonic = "fucompi";	 // "fucomip"
            return;
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ysexit", 6))
            break;
          Mnemonic = "sysexitl";	 // "sysexit"
          return;
        }
        break;
      case 8:	 // 13 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 12 strings to match.
          if (memcmp(Mnemonic.data()+1, "movn", 4))
            break;
          switch (Mnemonic[5]) {
          default: break;
          case 'a':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovbl";	 // "cmovnael"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovbq";	 // "cmovnaeq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovbw";	 // "cmovnaew"
              return;
            }
            break;
          case 'b':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmoval";	 // "cmovnbel"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovaq";	 // "cmovnbeq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovaw";	 // "cmovnbew"
              return;
            }
            break;
          case 'g':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovll";	 // "cmovngel"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovlq";	 // "cmovngeq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovlw";	 // "cmovngew"
              return;
            }
            break;
          case 'l':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovgl";	 // "cmovnlel"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovgq";	 // "cmovnleq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovgw";	 // "cmovnlew"
              return;
            }
            break;
          }
          break;
        case 'f':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "cmovnae", 7))
            break;
          Mnemonic = "fcmovb";	 // "fcmovnae"
          return;
        }
        break;
      }
    break;
    case 1:
      switch (Mnemonic.size()) {
      default: break;
      case 4:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "popa", 4))
          break;
        if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "popa"
          Mnemonic = "popaw";
        else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
          Mnemonic = "popal";
        return;
      case 5:	 // 4 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3))
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'c':	 // 1 string to match.
            Mnemonic = "cmovb";	 // "cmovc"
            return;
          case 'z':	 // 1 string to match.
            Mnemonic = "cmove";	 // "cmovz"
            return;
          }
          break;
        case 'p':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "pad", 3))
              break;
            if ((Features & Feature_Not64BitMode) == Feature_Not64BitMode)	 // "popad"
              Mnemonic = "popal";
            return;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "sha", 3))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "pusha"
              Mnemonic = "pushaw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "pushal";
            return;
          }
          break;
        }
        break;
      case 6:	 // 9 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 8 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3))
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'n':	 // 6 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              Mnemonic = "cmovbe";	 // "cmovna"
              return;
            case 'b':	 // 1 string to match.
              Mnemonic = "cmovae";	 // "cmovnb"
              return;
            case 'c':	 // 1 string to match.
              Mnemonic = "cmovae";	 // "cmovnc"
              return;
            case 'g':	 // 1 string to match.
              Mnemonic = "cmovle";	 // "cmovng"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovge";	 // "cmovnl"
              return;
            case 'z':	 // 1 string to match.
              Mnemonic = "cmovne";	 // "cmovnz"
              return;
            }
            break;
          case 'p':	 // 2 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'e':	 // 1 string to match.
              Mnemonic = "cmovp";	 // "cmovpe"
              return;
            case 'o':	 // 1 string to match.
              Mnemonic = "cmovnp";	 // "cmovpo"
              return;
            }
            break;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ushad", 5))
            break;
          if ((Features & Feature_Not64BitMode) == Feature_Not64BitMode)	 // "pushad"
            Mnemonic = "pushal";
          return;
        }
        break;
      case 7:	 // 4 strings to match.
        if (memcmp(Mnemonic.data()+0, "cmovn", 5))
          break;
        switch (Mnemonic[5]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (Mnemonic[6] != 'e')
            break;
          Mnemonic = "cmovb";	 // "cmovnae"
          return;
        case 'b':	 // 1 string to match.
          if (Mnemonic[6] != 'e')
            break;
          Mnemonic = "cmova";	 // "cmovnbe"
          return;
        case 'g':	 // 1 string to match.
          if (Mnemonic[6] != 'e')
            break;
          Mnemonic = "cmovl";	 // "cmovnge"
          return;
        case 'l':	 // 1 string to match.
          if (Mnemonic[6] != 'e')
            break;
          Mnemonic = "cmovg";	 // "cmovnle"
          return;
        }
        break;
      }
    break;
  }
  switch (Mnemonic.size()) {
  default: break;
  case 2:	 // 2 strings to match.
    if (Mnemonic[0] != 'j')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'c':	 // 1 string to match.
      Mnemonic = "jb";	 // "jc"
      return;
    case 'z':	 // 1 string to match.
      Mnemonic = "je";	 // "jz"
      return;
    }
    break;
  case 3:	 // 8 strings to match.
    if (Mnemonic[0] != 'j')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'n':	 // 6 strings to match.
      switch (Mnemonic[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        Mnemonic = "jbe";	 // "jna"
        return;
      case 'b':	 // 1 string to match.
        Mnemonic = "jae";	 // "jnb"
        return;
      case 'c':	 // 1 string to match.
        Mnemonic = "jae";	 // "jnc"
        return;
      case 'g':	 // 1 string to match.
        Mnemonic = "jle";	 // "jng"
        return;
      case 'l':	 // 1 string to match.
        Mnemonic = "jge";	 // "jnl"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "jne";	 // "jnz"
        return;
      }
      break;
    case 'p':	 // 2 strings to match.
      switch (Mnemonic[2]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "jp";	 // "jpe"
        return;
      case 'o':	 // 1 string to match.
        Mnemonic = "jnp";	 // "jpo"
        return;
      }
      break;
    }
    break;
  case 4:	 // 6 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'j':	 // 4 strings to match.
      if (Mnemonic[1] != 'n')
        break;
      switch (Mnemonic[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jb";	 // "jnae"
        return;
      case 'b':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "ja";	 // "jnbe"
        return;
      case 'g':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jl";	 // "jnge"
        return;
      case 'l':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jg";	 // "jnle"
        return;
      }
      break;
    case 's':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+1, "et", 2))
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'c':	 // 1 string to match.
        Mnemonic = "setb";	 // "setc"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "sete";	 // "setz"
        return;
      }
      break;
    }
    break;
  case 5:	 // 8 strings to match.
    if (memcmp(Mnemonic.data()+0, "set", 3))
      break;
    switch (Mnemonic[3]) {
    default: break;
    case 'n':	 // 6 strings to match.
      switch (Mnemonic[4]) {
      default: break;
      case 'a':	 // 1 string to match.
        Mnemonic = "setbe";	 // "setna"
        return;
      case 'b':	 // 1 string to match.
        Mnemonic = "setae";	 // "setnb"
        return;
      case 'c':	 // 1 string to match.
        Mnemonic = "setae";	 // "setnc"
        return;
      case 'g':	 // 1 string to match.
        Mnemonic = "setle";	 // "setng"
        return;
      case 'l':	 // 1 string to match.
        Mnemonic = "setge";	 // "setnl"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "setne";	 // "setnz"
        return;
      }
      break;
    case 'p':	 // 2 strings to match.
      switch (Mnemonic[4]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "setp";	 // "setpe"
        return;
      case 'o':	 // 1 string to match.
        Mnemonic = "setnp";	 // "setpo"
        return;
      }
      break;
    }
    break;
  case 6:	 // 4 strings to match.
    if (memcmp(Mnemonic.data()+0, "setn", 4))
      break;
    switch (Mnemonic[4]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (Mnemonic[5] != 'e')
        break;
      Mnemonic = "setb";	 // "setnae"
      return;
    case 'b':	 // 1 string to match.
      if (Mnemonic[5] != 'e')
        break;
      Mnemonic = "seta";	 // "setnbe"
      return;
    case 'g':	 // 1 string to match.
      if (Mnemonic[5] != 'e')
        break;
      Mnemonic = "setl";	 // "setnge"
      return;
    case 'l':	 // 1 string to match.
      if (Mnemonic[5] != 'e')
        break;
      Mnemonic = "setg";	 // "setnle"
      return;
    }
    break;
  }
}

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_imm_10,
  CVT_95_addImmOperands,
  CVT_95_Reg,
  CVT_95_addMemOperands,
  CVT_95_addAbsMemOperands,
  CVT_95_addDstIdxOperands,
  CVT_95_addSrcIdxOperands,
  CVT_95_addGR32orGR64Operands,
  CVT_regST0,
  CVT_regST1,
  CVT_95_addMemOffsOperands,
  CVT_imm_17,
  CVT_imm_1,
  CVT_imm_16,
  CVT_imm_0,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert_NoOperands,
  Convert__imm_10,
  Convert__Imm1_0,
  Convert__Imm1_1,
  Convert__Reg1_0__Tie0__Reg1_1,
  Convert__Reg1_0__Tie0__Imm1_1,
  Convert__Reg1_0__Tie0__Mem85_1,
  Convert__Reg1_0__Tie0__ImmSExti16i81_1,
  Convert__Reg1_0__Tie0__Mem165_1,
  Convert__Reg1_0__Tie0__ImmSExti32i81_1,
  Convert__Reg1_0__Tie0__Mem325_1,
  Convert__ImmSExti64i321_1,
  Convert__Reg1_0__Tie0__ImmSExti64i81_1,
  Convert__Reg1_0__Tie0__ImmSExti64i321_1,
  Convert__Reg1_0__Tie0__Mem645_1,
  Convert__Mem165_0__Reg1_1,
  Convert__Mem165_0__ImmSExti16i81_1,
  Convert__Mem165_0__Imm1_1,
  Convert__Mem325_0__Reg1_1,
  Convert__Mem325_0__ImmSExti32i81_1,
  Convert__Mem325_0__Imm1_1,
  Convert__Mem645_0__Reg1_1,
  Convert__Mem645_0__ImmSExti64i81_1,
  Convert__Mem645_0__ImmSExti64i321_1,
  Convert__Mem85_0__Reg1_1,
  Convert__Mem85_0__Imm1_1,
  Convert__Reg1_1__Tie0__Reg1_0,
  Convert__Mem85_1__Reg1_0,
  Convert__Reg1_1__Tie0__Imm1_0,
  Convert__Mem85_1__Imm1_0,
  Convert__Reg1_1__Tie0__Mem85_0,
  Convert__Mem325_1__Reg1_0,
  Convert__Reg1_1__Tie0__ImmSExti32i81_0,
  Convert__Mem325_1__ImmSExti32i81_0,
  Convert__Mem325_1__Imm1_0,
  Convert__Reg1_1__Tie0__Mem325_0,
  Convert__Mem645_1__Reg1_0,
  Convert__Reg1_1__Tie0__ImmSExti64i81_0,
  Convert__Mem645_1__ImmSExti64i81_0,
  Convert__ImmSExti64i321_0,
  Convert__Reg1_1__Tie0__ImmSExti64i321_0,
  Convert__Mem645_1__ImmSExti64i321_0,
  Convert__Reg1_1__Tie0__Mem645_0,
  Convert__Mem165_1__Reg1_0,
  Convert__Reg1_1__Tie0__ImmSExti16i81_0,
  Convert__Mem165_1__ImmSExti16i81_0,
  Convert__Mem165_1__Imm1_0,
  Convert__Reg1_1__Tie0__Mem165_0,
  Convert__Reg1_0__Reg1_1,
  Convert__Reg1_0__Mem325_1,
  Convert__Reg1_0__Mem645_1,
  Convert__Reg1_1__Reg1_0,
  Convert__Reg1_1__Mem325_0,
  Convert__Reg1_1__Mem645_0,
  Convert__Reg1_0__Tie0__Mem1285_1,
  Convert__Reg1_1__Tie0__Mem1285_0,
  Convert__Reg1_0__Mem1285_1,
  Convert__Reg1_1__Mem1285_0,
  Convert__Reg1_0__Reg1_1__Imm1_2,
  Convert__Reg1_0__Mem1285_1__Imm1_2,
  Convert__Reg1_2__Reg1_1__Imm1_0,
  Convert__Reg1_2__Mem1285_1__Imm1_0,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_1__Mem325_2,
  Convert__Reg1_0__Reg1_1__Mem645_2,
  Convert__Reg1_2__Reg1_1__Reg1_0,
  Convert__Reg1_2__Reg1_1__Mem325_0,
  Convert__Reg1_2__Reg1_1__Mem645_0,
  Convert__Reg1_0__Mem325_1__Reg1_2,
  Convert__Reg1_0__Mem325_1__Imm1_2,
  Convert__Reg1_0__Reg1_1__ImmSExti64i321_2,
  Convert__Reg1_0__Mem645_1__Reg1_2,
  Convert__Reg1_0__Mem645_1__ImmSExti64i321_2,
  Convert__Reg1_2__Reg1_1__ImmSExti64i321_0,
  Convert__Reg1_2__Mem645_1__ImmSExti64i321_0,
  Convert__Reg1_2__Mem325_1__Imm1_0,
  Convert__Reg1_2__Mem325_1__Reg1_0,
  Convert__Reg1_2__Mem645_1__Reg1_0,
  Convert__Reg1_0__Tie0__Reg1_1__ImmZExtu32u81_2,
  Convert__Reg1_0__Tie0__Mem1285_1__ImmZExtu32u81_2,
  Convert__Reg1_2__Tie0__Reg1_1__ImmZExtu32u81_0,
  Convert__Reg1_2__Tie0__Mem1285_1__ImmZExtu32u81_0,
  Convert__Reg1_2__Tie0__Reg1_1,
  Convert__Reg1_2__Tie0__Mem1285_1,
  Convert__Reg1_0__Mem165_1,
  Convert__Reg1_1__Mem165_0,
  Convert__Reg1_0__Tie0,
  Convert__Reg1_0__ImmSExti16i81_1,
  Convert__Reg1_0__ImmSExti32i81_1,
  Convert__Reg1_0__ImmSExti64i81_1,
  Convert__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_0,
  Convert__AbsMem1_0,
  Convert__Mem165_0,
  Convert__Mem325_0,
  Convert__Mem645_0,
  Convert__Mem165_1,
  Convert__Imm1_1__Imm1_0,
  Convert__Reg1_1,
  Convert__Mem325_1,
  Convert__Mem645_1,
  Convert__Mem85_0,
  Convert__Reg1_0__Tie0__Reg1_0,
  Convert__Reg1_0__Imm1_1,
  Convert__Reg1_0__Mem85_1,
  Convert__Reg1_0__ImmSExti64i321_1,
  Convert__Reg1_3__Tie0__Reg1_2__Imm1_0,
  Convert__Reg1_2__Tie0__Reg1_3__Imm1_0,
  Convert__Reg1_2__Tie0__Mem1285_3__Imm1_0,
  Convert__Reg1_3__Tie0__Mem1285_2__Imm1_0,
  Convert__Reg1_2__Tie0__Mem645_3__Imm1_0,
  Convert__Reg1_3__Tie0__Mem645_2__Imm1_0,
  Convert__Reg1_3__Tie0__Mem325_2__Imm1_0,
  Convert__Reg1_2__Tie0__Mem325_3__Imm1_0,
  Convert__Reg1_1__Imm1_0,
  Convert__Reg1_1__Mem85_0,
  Convert__Reg1_0__Tie0__Reg1_1__Imm1_2,
  Convert__Reg1_0__Tie0__Mem1285_1__Imm1_2,
  Convert__Reg1_2__Tie0__Reg1_1__Imm1_0,
  Convert__Reg1_2__Tie0__Mem1285_1__Imm1_0,
  Convert__Reg1_1__ImmSExti64i321_0,
  Convert__DstIdx81_0__SrcIdx82_1,
  Convert__DstIdx81_1__SrcIdx82_0,
  Convert__DstIdx321_1__SrcIdx322_0,
  Convert__Reg1_0__Tie0__Mem645_1__Imm1_2,
  Convert__Reg1_2__Tie0__Mem645_1__Imm1_0,
  Convert__DstIdx321_0__SrcIdx322_1,
  Convert__DstIdx641_0__SrcIdx642_1,
  Convert__DstIdx641_1__SrcIdx642_0,
  Convert__Reg1_0__Tie0__Mem325_1__Imm1_2,
  Convert__Reg1_2__Tie0__Mem325_1__Imm1_0,
  Convert__DstIdx161_0__SrcIdx162_1,
  Convert__DstIdx161_1__SrcIdx162_0,
  Convert__Mem1285_0,
  Convert__Mem85_1,
  Convert__Imm1_0__Imm1_1,
  Convert__GR32orGR641_2__Reg1_1__ImmSExti32i81_0,
  Convert__Mem325_2__Reg1_1__ImmSExti32i81_0,
  Convert__GR32orGR641_0__Reg1_1__ImmSExti32i81_2,
  Convert__Mem325_0__Reg1_1__ImmSExti32i81_2,
  Convert__Reg1_0__Tie0__Imm1_1__Imm1_2,
  Convert__Reg1_2__Tie0__Imm1_1__Imm1_0,
  Convert__regST0,
  Convert__regST1,
  Convert__Mem805_0,
  Convert__Mem5_0,
  Convert__Reg1_0__Reg1_1__ImmSExti16i81_2,
  Convert__Reg1_0__Mem165_1__ImmSExti16i81_2,
  Convert__Reg1_0__Mem165_1__Imm1_2,
  Convert__Reg1_0__Reg1_1__ImmSExti32i81_2,
  Convert__Reg1_0__Mem325_1__ImmSExti32i81_2,
  Convert__Reg1_0__Reg1_1__ImmSExti64i81_2,
  Convert__Reg1_0__Mem645_1__ImmSExti64i81_2,
  Convert__Reg1_1__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_1__Reg1_1__Imm1_0,
  Convert__Reg1_2__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_2__Mem325_1__ImmSExti32i81_0,
  Convert__Reg1_1__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_1__Reg1_1__ImmSExti64i321_0,
  Convert__Reg1_2__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_2__Mem645_1__ImmSExti64i81_0,
  Convert__Reg1_1__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_2__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_2__Mem165_1__ImmSExti16i81_0,
  Convert__Reg1_2__Mem165_1__Imm1_0,
  Convert__DstIdx81_1,
  Convert__DstIdx81_0,
  Convert__DstIdx321_0,
  Convert__Reg1_0__Tie0__Mem325_1__ImmZExtu32u81_2,
  Convert__Reg1_2__Tie0__Mem325_1__ImmZExtu32u81_0,
  Convert__Reg1_0__Tie0__Reg1_1__Imm1_2__Imm1_3,
  Convert__Reg1_3__Tie0__Reg1_2__Imm1_1__Imm1_0,
  Convert__DstIdx321_1,
  Convert__DstIdx161_1,
  Convert__DstIdx161_0,
  Convert__Mem5_1,
  Convert__Reg1_0__Mem5_1,
  Convert__Reg1_1__Mem5_0,
  Convert__SrcIdx82_1,
  Convert__SrcIdx162_1,
  Convert__SrcIdx322_1,
  Convert__SrcIdx642_1,
  Convert__SrcIdx162_0,
  Convert__SrcIdx322_0,
  Convert__SrcIdx642_0,
  Convert__SrcIdx82_0,
  Convert__MemOffs82_1,
  Convert__MemOffs162_1,
  Convert__MemOffs322_1,
  Convert__MemOffs162_0,
  Convert__MemOffs322_0,
  Convert__MemOffs82_0,
  Convert__MemOffs642_1,
  Convert__MemOffs642_0,
  Convert__Mem1285_1__Reg1_0,
  Convert__Mem1285_0__Reg1_1,
  Convert__GR32orGR641_1__Reg1_0,
  Convert__GR32orGR641_0__Reg1_1,
  Convert__Reg1_1__Tie0__Reg1_0__imm_17,
  Convert__Reg1_0__Tie0__Reg1_1__imm_17,
  Convert__Reg1_0__Tie0__Mem1285_1__imm_17,
  Convert__Reg1_1__Tie0__Mem1285_0__imm_17,
  Convert__Reg1_1__Tie0__Reg1_0__imm_1,
  Convert__Reg1_0__Tie0__Reg1_1__imm_1,
  Convert__Reg1_0__Tie0__Mem1285_1__imm_1,
  Convert__Reg1_1__Tie0__Mem1285_0__imm_1,
  Convert__Reg1_1__Tie0__Reg1_0__imm_16,
  Convert__Reg1_0__Tie0__Reg1_1__imm_16,
  Convert__Reg1_0__Tie0__Mem1285_1__imm_16,
  Convert__Reg1_1__Tie0__Mem1285_0__imm_16,
  Convert__Reg1_1__Tie0__Reg1_0__imm_0,
  Convert__Reg1_0__Tie0__Reg1_1__imm_0,
  Convert__Reg1_0__Tie0__Mem1285_1__imm_0,
  Convert__Reg1_1__Tie0__Mem1285_0__imm_0,
  Convert__Mem85_2__Reg1_1__ImmSExti32i81_0,
  Convert__Mem85_0__Reg1_1__ImmSExti32i81_2,
  Convert__Mem645_2__Reg1_1__ImmSExti32i81_0,
  Convert__Mem645_0__Reg1_1__ImmSExti32i81_2,
  Convert__Mem165_2__Reg1_1__ImmSExti32i81_0,
  Convert__Mem165_0__Reg1_1__ImmSExti32i81_2,
  Convert__Reg1_0__Tie0__GR32orGR641_1__ImmSExti32i81_2,
  Convert__Reg1_0__Tie0__Mem85_1__ImmSExti32i81_2,
  Convert__Reg1_2__Tie0__GR32orGR641_1__ImmSExti32i81_0,
  Convert__Reg1_2__Tie0__Mem85_1__ImmSExti32i81_0,
  Convert__Reg1_0__Tie0__Reg1_1__ImmSExti32i81_2,
  Convert__Reg1_0__Tie0__Mem325_1__ImmSExti32i81_2,
  Convert__Reg1_2__Tie0__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_2__Tie0__Mem325_1__ImmSExti32i81_0,
  Convert__Reg1_0__Tie0__Mem645_1__ImmSExti32i81_2,
  Convert__Reg1_2__Tie0__Mem645_1__ImmSExti32i81_0,
  Convert__Reg1_0__Tie0__Mem165_1__ImmSExti32i81_2,
  Convert__Reg1_2__Tie0__Mem165_1__ImmSExti32i81_0,
  Convert__Reg1_0__Mem645_1__Imm1_2,
  Convert__Reg1_2__Mem645_1__Imm1_0,
  Convert__ImmSExti64i81_0,
  Convert__ImmSExti16i81_0,
  Convert__ImmSExti32i81_0,
  Convert__Mem645_0__Imm1_1,
  Convert__Reg1_1__Tie0,
  Convert__Mem645_1__Imm1_0,
  Convert__Reg1_0__Mem1285_1__ImmSExti32i81_2,
  Convert__Reg1_2__Mem1285_1__ImmSExti32i81_0,
  Convert__DstIdx641_1,
  Convert__DstIdx641_0,
  Convert__Mem165_0__Reg1_1__Imm1_2,
  Convert__Mem325_0__Reg1_1__Imm1_2,
  Convert__Mem645_0__Reg1_1__Imm1_2,
  Convert__Mem325_2__Reg1_1,
  Convert__Mem325_2__Reg1_1__Imm1_0,
  Convert__Mem645_2__Reg1_1,
  Convert__Mem645_2__Reg1_1__Imm1_0,
  Convert__Mem165_2__Reg1_1,
  Convert__Mem165_2__Reg1_1__Imm1_0,
  Convert__Reg1_0__Reg1_1__Mem1285_2,
  Convert__Reg1_0__Reg1_1__Mem2565_2,
  Convert__Reg1_0__Reg1_1__Mem5125_2,
  Convert__Reg1_2__Reg1_1__Mem1285_0,
  Convert__Reg1_2__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Reg1_1__Mem5125_0,
  Convert__Reg1_3__Reg1_2__Mem645_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5,
  Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6,
  Convert__Reg1_3__Reg1_2__Mem325_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6,
  Convert__Reg1_0__Reg1_1__Reg1_2__Imm1_3,
  Convert__Reg1_0__Reg1_1__Mem5125_2__Imm1_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0,
  Convert__Reg1_3__Reg1_2__Mem5125_1__Imm1_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__ImmZExtu32u81_3,
  Convert__Reg1_0__Reg1_1__Mem1285_2__ImmZExtu32u81_3,
  Convert__Reg1_0__Reg1_1__Mem2565_2__ImmZExtu32u81_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0,
  Convert__Reg1_3__Reg1_2__Mem1285_1__ImmZExtu32u81_0,
  Convert__Reg1_3__Reg1_2__Mem2565_1__ImmZExtu32u81_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0,
  Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0,
  Convert__Reg1_0__Reg1_2__Mem1285_5,
  Convert__Reg1_1__Reg1_3__Mem1285_0,
  Convert__Reg1_0__Mem2565_1,
  Convert__Reg1_1__Mem2565_0,
  Convert__Reg1_0__Reg1_2__Mem2565_5,
  Convert__Reg1_1__Reg1_3__Mem2565_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem1285_4__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem2565_4__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem645_4__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem645_2__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem325_2__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem325_4__Imm1_0,
  Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem5125_4__Imm1_0,
  Convert__Reg1_0__Reg1_1__Mem1285_2__Imm1_3,
  Convert__Reg1_0__Reg1_1__Mem2565_2__Imm1_3,
  Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0,
  Convert__Reg1_3__Reg1_2__Mem2565_1__Imm1_0,
  Convert__Reg1_0__Reg1_1__Mem645_2__Imm1_3,
  Convert__Reg1_3__Reg1_2__Mem645_1__Imm1_0,
  Convert__Reg1_0__Reg1_1__Mem325_2__Imm1_3,
  Convert__Reg1_3__Reg1_2__Mem325_1__Imm1_0,
  Convert__Reg1_0__Mem5125_1,
  Convert__Reg1_1__Mem5125_0,
  Convert__Mem1285_2__Reg1_1__ImmSExti32i81_0,
  Convert__Mem2565_2__Reg1_1__ImmSExti32i81_0,
  Convert__Mem1285_0__Reg1_1__ImmSExti32i81_2,
  Convert__Mem2565_0__Reg1_1__ImmSExti32i81_2,
  Convert__Mem1285_2__Reg1_1__Imm1_0,
  Convert__Mem1285_0__Reg1_1__Imm1_2,
  Convert__Mem2565_2__Reg1_1__Imm1_0,
  Convert__Mem2565_0__Reg1_1__Imm1_2,
  Convert__Reg1_0__Reg1_1__ImmZExtu32u81_2,
  Convert__Reg1_2__Reg1_1__ImmZExtu32u81_0,
  Convert__Mem325_2__Reg1_1__ImmZExtu32u81_0,
  Convert__Mem325_0__Reg1_1__ImmZExtu32u81_2,
  Convert__Reg1_2__Tie0__Reg1_1__Reg1_0,
  Convert__Reg1_0__Tie0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Tie0__Reg1_1__Mem1285_2,
  Convert__Reg1_0__Tie0__Reg1_1__Mem2565_2,
  Convert__Reg1_0__Tie0__Reg1_1__Mem5125_2,
  Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0,
  Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Tie0__Reg1_1__Mem645_2,
  Convert__Reg1_3__Tie0__Reg1_2__Mem645_0,
  Convert__Reg1_0__Tie0__Reg1_1__Mem325_2,
  Convert__Reg1_3__Tie0__Reg1_2__Mem325_0,
  Convert__Reg1_2__Tie0__Reg1_1__Mem645_0,
  Convert__Reg1_2__Tie0__Reg1_1__Mem325_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem645_3,
  Convert__Reg1_0__Reg1_1__Mem645_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem325_3,
  Convert__Reg1_0__Reg1_1__Mem325_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0,
  Convert__Reg1_2__Reg1_0__Tie0__MemVX645_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__MemVX645_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVY645_4,
  Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVY645_0,
  Convert__Reg1_2__Reg1_0__Tie0__MemVX325_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__MemVX325_1__Tie1,
  Convert__Reg1_2__Reg1_0__Tie0__MemVY325_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__MemVY325_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVZ325_4,
  Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ325_0,
  Convert__Reg1_1__MemVY325_3,
  Convert__Reg1_2__MemVY325_0,
  Convert__Reg1_1__MemVZ325_3,
  Convert__Reg1_2__MemVZ325_0,
  Convert__Reg1_1__MemVZ645_3,
  Convert__Reg1_2__MemVZ645_0,
  Convert__Reg1_2__Reg1_0__Tie0__MemVY645_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__MemVY645_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVZ645_4,
  Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ645_0,
  Convert__Reg1_0__Reg1_1__Mem325_2__ImmZExtu32u81_3,
  Convert__Reg1_3__Reg1_2__Mem325_1__ImmZExtu32u81_0,
  Convert__Mem1285_2__Reg1_1__Reg1_0,
  Convert__Mem2565_2__Reg1_1__Reg1_0,
  Convert__Mem1285_0__Reg1_1__Reg1_2,
  Convert__Mem2565_0__Reg1_1__Reg1_2,
  Convert__Mem2565_1__Reg1_0,
  Convert__Mem5125_1__Reg1_0,
  Convert__Mem2565_0__Reg1_1,
  Convert__Mem5125_0__Reg1_1,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4,
  Convert__Reg1_0__Tie0__Reg1_2__Mem5125_4,
  Convert__Reg1_1__Tie0__Reg1_3__Reg1_0,
  Convert__Mem5125_1__Reg1_3__Reg1_0,
  Convert__Mem5125_0__Reg1_2__Reg1_4,
  Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Reg1_5,
  Convert__Reg1_0__Reg1_2__Mem5125_5,
  Convert__Reg1_1__Reg1_3__Reg1_0,
  Convert__Mem5125_0__Reg1_2__Reg1_5,
  Convert__Reg1_1__Reg1_3__Mem5125_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Reg1_5,
  Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0,
  Convert__Reg1_2__Mem325_0,
  Convert__Reg1_0__Reg1_2__Reg1_4,
  Convert__Reg1_0__Reg1_2__Mem5125_4,
  Convert__Reg1_0__Reg1_2__Mem325_4,
  Convert__Reg1_2__Reg1_4__Mem325_0,
  Convert__Reg1_0__Reg1_2__Mem325_5,
  Convert__Reg1_2__Mem645_0,
  Convert__Reg1_0__Reg1_2__Mem645_4,
  Convert__Reg1_2__Reg1_4__Mem645_0,
  Convert__Reg1_0__Reg1_2__Mem645_5,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem5125_5,
  Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem325_5,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem645_5,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0,
  Convert__Reg1_1__Reg1_3__Mem325_0,
  Convert__Reg1_1__Reg1_3__Mem645_0,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_17,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_17,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_17,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_17,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_1,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_1,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_1,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_16,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_16,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_16,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_16,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_0,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_0,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__Imm1_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5__Imm1_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__Imm1_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__Imm1_0,
  Convert__Reg1_0__Tie0__Reg1_2__Mem325_4,
  Convert__Reg1_2__Tie0__Reg1_4__Mem325_0,
  Convert__Reg1_0__Tie0__Reg1_2__Mem645_4,
  Convert__Reg1_2__Tie0__Reg1_4__Mem645_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Reg1_6,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem5125_6,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__Imm1_4,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3__Imm1_4,
  Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3__Imm1_4,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3__Imm1_4,
  Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3__Imm1_4,
  Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem1285_2__Reg1_1__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem2565_2__Reg1_1__Imm1_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Mem1285_1__Imm1_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Mem2565_1__Imm1_0,
  Convert__Reg1_0__Mem2565_1__Imm1_2,
  Convert__Reg1_0__Mem5125_1__Imm1_2,
  Convert__Reg1_2__Mem2565_1__Imm1_0,
  Convert__Reg1_2__Mem5125_1__Imm1_0,
  Convert__Reg1_0__Reg1_1__GR32orGR641_2__ImmSExti32i81_3,
  Convert__Reg1_0__Reg1_1__Mem85_2__ImmSExti32i81_3,
  Convert__Reg1_3__Reg1_2__GR32orGR641_1__ImmSExti32i81_0,
  Convert__Reg1_3__Reg1_2__Mem85_1__ImmSExti32i81_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__ImmSExti32i81_3,
  Convert__Reg1_0__Reg1_1__Mem325_2__ImmSExti32i81_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_3__Reg1_2__Mem325_1__ImmSExti32i81_0,
  Convert__Reg1_0__Reg1_1__Mem645_2__ImmSExti32i81_3,
  Convert__Reg1_3__Reg1_2__Mem645_1__ImmSExti32i81_0,
  Convert__Reg1_0__Reg1_1__Mem165_2__ImmSExti32i81_3,
  Convert__Reg1_3__Reg1_2__Mem165_1__ImmSExti32i81_0,
  Convert__Mem1285_1__Reg1_3__Reg1_0,
  Convert__Mem1285_0__Reg1_2__Reg1_4,
  Convert__Mem2565_1__Reg1_3__Reg1_0,
  Convert__Mem2565_0__Reg1_2__Reg1_4,
  Convert__Reg1_0__Reg1_2__Mem1285_4,
  Convert__Reg1_0__Reg1_2__Mem2565_4,
  Convert__Reg1_2__Mem1285_1__Reg1_0,
  Convert__Reg1_0__Mem1285_1__Reg1_2,
  Convert__Reg1_3__MemVZ325_1__Tie0__Reg1_0,
  Convert__Reg1_2__MemVZ325_0__Tie0__Reg1_4,
  Convert__Reg1_3__MemVY645_1__Tie0__Reg1_0,
  Convert__Reg1_2__MemVY645_0__Tie0__Reg1_4,
  Convert__Reg1_3__MemVZ645_1__Tie0__Reg1_0,
  Convert__Reg1_2__MemVZ645_0__Tie0__Reg1_4,
  Convert__Reg1_0__Reg1_2__Reg1_4__Imm1_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5,
  Convert__Reg1_0__Reg1_2__Mem5125_4__Imm1_5,
  Convert__Reg1_2__Reg1_4__Reg1_1__Imm1_0,
  Convert__Reg1_2__Reg1_4__Mem5125_1__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0,
  Convert__Reg1_2__Reg1_1,
  Convert__Reg1_3__Reg1_2__Reg1_1,
  Convert__Reg1_0__Mem5125_1__ImmSExti32i81_2,
  Convert__Reg1_2__Mem5125_1__ImmSExti32i81_0,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_0,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_0,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_0,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_0,
  Convert__Reg1_0__Mem2565_1__ImmSExti32i81_2,
  Convert__Reg1_2__Mem2565_1__ImmSExti32i81_0,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][11] = {
  // Convert_NoOperands
  { CVT_Done },
  // Convert__imm_10
  { CVT_imm_10, 0, CVT_Done },
  // Convert__Imm1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Imm1_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem85_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem165_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem325_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__ImmSExti64i321_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem645_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem165_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem165_0__ImmSExti16i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem165_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem325_0__ImmSExti32i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem645_0__ImmSExti64i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__ImmSExti64i321_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem85_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem85_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem85_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__Imm1_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem85_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem85_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem325_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem325_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem645_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti64i321_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem645_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem165_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem165_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Mem325_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem645_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Mem325_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem645_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem1285_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem1285_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem1285_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem1285_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem1285_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem325_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti64i321_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmSExti64i321_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmSExti64i321_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__ImmZExtu32u81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1__ImmZExtu32u81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__ImmZExtu32u81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem1285_1__ImmZExtu32u81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem1285_1
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem165_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem165_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_Done },
  // Convert__Reg1_0__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__AbsMem1_0
  { CVT_95_addAbsMemOperands, 1, CVT_Done },
  // Convert__Mem165_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem325_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem645_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem165_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Imm1_1__Imm1_0
  { CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1
  { CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem325_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem645_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem85_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_0
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Imm1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem85_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_2__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_3__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem1285_3__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Mem1285_2__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem645_3__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Mem645_2__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Mem325_2__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem325_3__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem85_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Imm1_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1__Imm1_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem1285_1__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx81_0__SrcIdx82_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__DstIdx81_1__SrcIdx82_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx321_1__SrcIdx322_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem645_1__Imm1_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem645_1__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx321_0__SrcIdx322_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__DstIdx641_0__SrcIdx642_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__DstIdx641_1__SrcIdx642_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem325_1__Imm1_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem325_1__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx161_0__SrcIdx162_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__DstIdx161_1__SrcIdx162_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__Mem1285_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem85_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Imm1_0__Imm1_1
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR32orGR641_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_addGR32orGR64Operands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__GR32orGR641_0__Reg1_1__ImmSExti32i81_2
  { CVT_95_addGR32orGR64Operands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem325_0__Reg1_1__ImmSExti32i81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Imm1_1__Imm1_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Imm1_1__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regST0
  { CVT_regST0, 0, CVT_Done },
  // Convert__regST1
  { CVT_regST1, 0, CVT_Done },
  // Convert__Mem805_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem5_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti16i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem165_1__ImmSExti16i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem165_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti64i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmSExti64i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmSExti64i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmSExti16i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx81_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__DstIdx81_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx321_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem325_1__ImmZExtu32u81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem325_1__ImmZExtu32u81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Imm1_2__Imm1_3
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_2__Imm1_1__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx321_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__DstIdx161_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__DstIdx161_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__Mem5_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem5_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem5_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__SrcIdx82_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx162_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx322_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx642_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx162_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx322_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx642_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx82_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__MemOffs82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs642_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs642_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__Mem1285_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__GR32orGR641_1__Reg1_0
  { CVT_95_addGR32orGR64Operands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__GR32orGR641_0__Reg1_1
  { CVT_95_addGR32orGR64Operands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_0__imm_17
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_imm_17, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__imm_17
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_imm_17, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1__imm_17
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_imm_17, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem1285_0__imm_17
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_imm_17, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_0__imm_1
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_imm_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__imm_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_imm_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1__imm_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_imm_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem1285_0__imm_1
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_imm_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_0__imm_16
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_imm_16, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__imm_16
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_imm_16, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1__imm_16
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_imm_16, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem1285_0__imm_16
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_imm_16, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_0__imm_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_imm_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__imm_0
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_imm_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1__imm_0
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_imm_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem1285_0__imm_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_imm_0, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem85_0__Reg1_1__ImmSExti32i81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_0__Reg1_1__ImmSExti32i81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_0__Reg1_1__ImmSExti32i81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__GR32orGR641_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem85_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__GR32orGR641_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem85_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem325_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem325_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem645_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem645_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem165_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem165_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem645_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem645_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti64i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti16i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti32i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_Done },
  // Convert__Mem645_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem1285_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem1285_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx641_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__DstIdx641_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__Mem165_0__Reg1_1__Imm1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem325_0__Reg1_1__Imm1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem645_0__Reg1_1__Imm1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem325_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem325_2__Reg1_1__Imm1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem645_2__Reg1_1__Imm1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem165_2__Reg1_1__Imm1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Imm1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__Imm1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem5125_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__ImmZExtu32u81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__ImmZExtu32u81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__ImmZExtu32u81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem1285_1__ImmZExtu32u81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem2565_1__ImmZExtu32u81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem1285_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem2565_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem2565_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem2565_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem1285_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem2565_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem645_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem645_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem325_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem325_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem5125_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__Imm1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__Imm1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem2565_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__Imm1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__Imm1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem5125_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem5125_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem1285_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1__ImmSExti32i81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem2565_0__Reg1_1__ImmSExti32i81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem1285_2__Reg1_1__Imm1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1__Imm1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem2565_2__Reg1_1__Imm1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem2565_0__Reg1_1__Imm1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmZExtu32u81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmZExtu32u81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmZExtu32u81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_0__Reg1_1__ImmZExtu32u81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Mem1285_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Mem2565_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Mem5125_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Mem645_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Mem325_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem645_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem325_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0__MemVX645_1__Tie1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__MemVX645_1__Tie1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVY645_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVY645_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0__MemVX325_1__Tie1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__MemVX325_1__Tie1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0__MemVY325_1__Tie1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__MemVY325_1__Tie1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVZ325_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ325_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemVY325_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__MemVY325_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemVZ325_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__MemVZ325_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemVZ645_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__MemVZ645_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0__MemVY645_1__Tie1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__MemVY645_1__Tie1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVZ645_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ645_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__ImmZExtu32u81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_1__ImmZExtu32u81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_2__Reg1_1__Reg1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_1__Reg1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1__Reg1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Mem2565_0__Reg1_1__Reg1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Mem2565_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5125_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem5125_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem5125_4
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_3__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5125_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5125_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5125_0__Reg1_2__Reg1_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem5125_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Reg1_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Mem645_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem5125_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem325_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem645_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem325_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem645_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__Imm1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5__Imm1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem325_4
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem645_4
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Reg1_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem5125_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__Imm1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3__Imm1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3__Imm1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3__Imm1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3__Imm1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem1285_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem2565_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Mem1285_1__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Mem2565_1__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem2565_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem5125_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem2565_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem5125_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__GR32orGR641_2__ImmSExti32i81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addGR32orGR64Operands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem85_2__ImmSExti32i81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__GR32orGR641_1__ImmSExti32i81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem85_1__ImmSExti32i81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__ImmSExti32i81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__ImmSExti32i81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_1__ImmSExti32i81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__ImmSExti32i81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_1__ImmSExti32i81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__ImmSExti32i81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem165_1__ImmSExti32i81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem2565_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_2__Mem1285_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Mem1285_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_3__MemVZ325_1__Tie0__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__MemVZ325_0__Tie0__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, 0, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_3__MemVY645_1__Tie0__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__MemVY645_0__Tie0__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, 0, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_3__MemVZ645_1__Tie0__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__MemVZ645_0__Tie0__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, 0, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Imm1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_4__Imm1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem5125_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Mem5125_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem5125_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_0, 0, CVT_Done },
  // Convert__Reg1_0__Mem2565_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem2565_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
};

void X86AsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p+= 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied:
      Inst.addOperand(Inst.getOperand(*(p + 1)));
      break;
    case CVT_imm_10:
      Inst.addOperand(MCOperand::CreateImm(10));
      break;
    case CVT_95_addImmOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addImmOperands(Inst, 1);
      break;
    case CVT_95_Reg:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addRegOperands(Inst, 1);
      break;
    case CVT_95_addMemOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addMemOperands(Inst, 5);
      break;
    case CVT_95_addAbsMemOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addAbsMemOperands(Inst, 1);
      break;
    case CVT_95_addDstIdxOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addDstIdxOperands(Inst, 1);
      break;
    case CVT_95_addSrcIdxOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addSrcIdxOperands(Inst, 2);
      break;
    case CVT_95_addGR32orGR64Operands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addGR32orGR64Operands(Inst, 1);
      break;
    case CVT_regST0:
      Inst.addOperand(MCOperand::CreateReg(X86::ST0));
      break;
    case CVT_regST1:
      Inst.addOperand(MCOperand::CreateReg(X86::ST1));
      break;
    case CVT_95_addMemOffsOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addMemOffsOperands(Inst, 2);
      break;
    case CVT_imm_17:
      Inst.addOperand(MCOperand::CreateImm(17));
      break;
    case CVT_imm_1:
      Inst.addOperand(MCOperand::CreateImm(1));
      break;
    case CVT_imm_16:
      Inst.addOperand(MCOperand::CreateImm(16));
      break;
    case CVT_imm_0:
      Inst.addOperand(MCOperand::CreateImm(0));
      break;
    }
  }
}

void X86AsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p+= 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_imm_10:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 5;
      break;
    case CVT_95_addAbsMemOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addDstIdxOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addSrcIdxOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addGR32orGR64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regST0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regST1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addMemOffsOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_imm_17:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_16:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  MCK__STAR_, // '*'
  MCK_d, // 'd'
  MCK_pd, // 'pd'
  MCK_ps, // 'ps'
  MCK_q, // 'q'
  MCK_sd, // 'sd'
  MCK_ss, // 'ss'
  MCK_ud, // 'ud'
  MCK_uq, // 'uq'
  MCK__123_, // '{'
  MCK__123_1to16_125_, // '{1to16}'
  MCK__123_1to8_125_, // '{1to8}'
  MCK__123_sae_125_, // '{sae}'
  MCK__123_z_125_, // '{z}'
  MCK__125_, // '}'
  MCK_AL, // register class 'AL'
  MCK_CL, // register class 'CL'
  MCK_GR8_ABCD_L, // register class 'GR8_ABCD_L'
  MCK_GR8_ABCD_H, // register class 'GR8_ABCD_H'
  MCK_GR8_NOREX, // register class 'GR8_NOREX'
  MCK_GR8, // register class 'GR8'
  MCK_AX, // register class 'AX'
  MCK_DX, // register class 'DX'
  MCK_GR16_ABCD, // register class 'GR16_ABCD'
  MCK_GR16_NOREX, // register class 'GR16_NOREX'
  MCK_GR16, // register class 'GR16'
  MCK_EAX, // register class 'EAX'
  MCK_EDX, // register class 'EDX'
  MCK_ECX, // register class 'ECX'
  MCK_Reg20, // derived register class
  MCK_Reg21, // derived register class
  MCK_Reg22, // derived register class
  MCK_Reg23, // derived register class
  MCK_Reg25, // derived register class
  MCK_GR32_AD, // register class 'GR32_AD'
  MCK_GR32_NOAX, // register class 'GR32_NOAX'
  MCK_GR32_TC, // register class 'GR32_TC'
  MCK_GR32_ABCD, // register class 'GR32_ABCD'
  MCK_GR32_NOREX_NOSP, // register class 'GR32_NOREX_NOSP'
  MCK_GR32_NOREX, // register class 'GR32_NOREX'
  MCK_GR32_NOSP, // register class 'GR32_NOSP'
  MCK_GR32, // register class 'GR32'
  MCK_RAX, // register class 'RAX'
  MCK_RDX, // register class 'RDX'
  MCK_RCX, // register class 'RCX'
  MCK_Reg43, // derived register class
  MCK_Reg51, // derived register class
  MCK_Reg29, // derived register class
  MCK_Reg50, // derived register class
  MCK_Reg28, // derived register class
  MCK_Reg49, // derived register class
  MCK_Reg48, // derived register class
  MCK_Reg47, // derived register class
  MCK_Reg37, // derived register class
  MCK_Reg38, // derived register class
  MCK_Reg40, // derived register class
  MCK_Reg44, // derived register class
  MCK_Reg45, // derived register class
  MCK_Reg46, // derived register class
  MCK_GR64_ABCD, // register class 'GR64_ABCD'
  MCK_GR64_NOREX_NOSP, // register class 'GR64_NOREX_NOSP'
  MCK_Reg32, // derived register class
  MCK_Reg33, // derived register class
  MCK_GR64_NOREX, // register class 'GR64_NOREX'
  MCK_GR64_TCW64, // register class 'GR64_TCW64'
  MCK_GR64_NOSP, // register class 'GR64_NOSP'
  MCK_GR64_TC, // register class 'GR64_TC'
  MCK_GR64, // register class 'GR64'
  MCK_VR64, // register class 'VR64'
  MCK_RFP32, // register class 'RFP32,RFP64,RFP80'
  MCK_XMM0, // register class 'XMM0'
  MCK_FR32, // register class 'FR32,FR64,VR128'
  MCK_FR32X, // register class 'FR32X,FR64X,VR128X'
  MCK_VR256, // register class 'VR256'
  MCK_VR256X, // register class 'VR256X'
  MCK_Reg60, // derived register class
  MCK_VR512, // register class 'VR512'
  MCK_VK16WM, // register class 'VK16WM,VK1WM,VK2WM,VK4WM,VK8WM,VK32WM,VK64WM'
  MCK_VK1, // register class 'VK1,VK16,VK2,VK4,VK8,VK32,VK64'
  MCK_ST0, // register class 'ST0'
  MCK_RST, // register class 'RST'
  MCK_FPCCR, // register class 'FPCCR'
  MCK_CCR, // register class 'CCR'
  MCK_CS, // register class 'CS'
  MCK_DS, // register class 'DS'
  MCK_SS, // register class 'SS'
  MCK_ES, // register class 'ES'
  MCK_FS, // register class 'FS'
  MCK_GS, // register class 'GS'
  MCK_SEGMENT_REG, // register class 'SEGMENT_REG'
  MCK_DEBUG_REG, // register class 'DEBUG_REG'
  MCK_CONTROL_REG, // register class 'CONTROL_REG'
  MCK_ImmSExti64i8, // user defined class 'ImmSExti64i8AsmOperand'
  MCK_ImmSExti16i8, // user defined class 'ImmSExti16i8AsmOperand'
  MCK_ImmSExti32i8, // user defined class 'ImmSExti32i8AsmOperand'
  MCK_ImmSExti64i32, // user defined class 'ImmSExti64i32AsmOperand'
  MCK_ImmZExtu32u8, // user defined class 'ImmZExtu32u8AsmOperand'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_AbsMem, // user defined class 'X86AbsMemAsmOperand'
  MCK_DstIdx16, // user defined class 'X86DstIdx16Operand'
  MCK_DstIdx32, // user defined class 'X86DstIdx32Operand'
  MCK_DstIdx64, // user defined class 'X86DstIdx64Operand'
  MCK_DstIdx8, // user defined class 'X86DstIdx8Operand'
  MCK_GR32orGR64, // user defined class 'X86GR32orGR64AsmOperand'
  MCK_Mem128, // user defined class 'X86Mem128AsmOperand'
  MCK_Mem16, // user defined class 'X86Mem16AsmOperand'
  MCK_Mem256, // user defined class 'X86Mem256AsmOperand'
  MCK_Mem32, // user defined class 'X86Mem32AsmOperand'
  MCK_Mem512, // user defined class 'X86Mem512AsmOperand'
  MCK_Mem64, // user defined class 'X86Mem64AsmOperand'
  MCK_Mem80, // user defined class 'X86Mem80AsmOperand'
  MCK_Mem, // user defined class 'X86MemAsmOperand'
  MCK_MemOffs16, // user defined class 'X86MemOffs16AsmOperand'
  MCK_MemOffs32, // user defined class 'X86MemOffs32AsmOperand'
  MCK_MemOffs64, // user defined class 'X86MemOffs64AsmOperand'
  MCK_MemOffs8, // user defined class 'X86MemOffs8AsmOperand'
  MCK_MemVX32, // user defined class 'X86MemVX32Operand'
  MCK_MemVX64, // user defined class 'X86MemVX64Operand'
  MCK_MemVY32, // user defined class 'X86MemVY32Operand'
  MCK_MemVY64, // user defined class 'X86MemVY64Operand'
  MCK_MemVZ32, // user defined class 'X86MemVZ32Operand'
  MCK_MemVZ64, // user defined class 'X86MemVZ64Operand'
  MCK_SrcIdx16, // user defined class 'X86SrcIdx16Operand'
  MCK_SrcIdx32, // user defined class 'X86SrcIdx32Operand'
  MCK_SrcIdx64, // user defined class 'X86SrcIdx64Operand'
  MCK_SrcIdx8, // user defined class 'X86SrcIdx8Operand'
  MCK_Mem8, // user defined class 'X86Mem8AsmOperand'
  NumMatchClassKinds
};

}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 5 strings to match.
    switch (Name[0]) {
    default: break;
    case '*':	 // 1 string to match.
      return MCK__STAR_;	 // "*"
    case 'd':	 // 1 string to match.
      return MCK_d;	 // "d"
    case 'q':	 // 1 string to match.
      return MCK_q;	 // "q"
    case '{':	 // 1 string to match.
      return MCK__123_;	 // "{"
    case '}':	 // 1 string to match.
      return MCK__125_;	 // "}"
    }
    break;
  case 2:	 // 6 strings to match.
    switch (Name[0]) {
    default: break;
    case 'p':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        return MCK_pd;	 // "pd"
      case 's':	 // 1 string to match.
        return MCK_ps;	 // "ps"
      }
      break;
    case 's':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        return MCK_sd;	 // "sd"
      case 's':	 // 1 string to match.
        return MCK_ss;	 // "ss"
      }
      break;
    case 'u':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        return MCK_ud;	 // "ud"
      case 'q':	 // 1 string to match.
        return MCK_uq;	 // "uq"
      }
      break;
    }
    break;
  case 3:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{z}", 3))
      break;
    return MCK__123_z_125_;	 // "{z}"
  case 5:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{sae}", 5))
      break;
    return MCK__123_sae_125_;	 // "{sae}"
  case 6:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{1to8}", 6))
      break;
    return MCK__123_1to8_125_;	 // "{1to8}"
  case 7:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{1to16}", 7))
      break;
    return MCK__123_1to16_125_;	 // "{1to16}"
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  switch (A) {
  default:
    return false;

  case MCK_AL:
    switch (B) {
    default: return false;
    case MCK_GR8_ABCD_L: return true;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_CL:
    switch (B) {
    default: return false;
    case MCK_GR8_ABCD_L: return true;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_GR8_ABCD_L:
    switch (B) {
    default: return false;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_GR8_ABCD_H:
    switch (B) {
    default: return false;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_GR8_NOREX:
    return B == MCK_GR8;

  case MCK_AX:
    switch (B) {
    default: return false;
    case MCK_GR16_ABCD: return true;
    case MCK_GR16_NOREX: return true;
    case MCK_GR16: return true;
    }

  case MCK_DX:
    switch (B) {
    default: return false;
    case MCK_GR16_ABCD: return true;
    case MCK_GR16_NOREX: return true;
    case MCK_GR16: return true;
    }

  case MCK_GR16_ABCD:
    switch (B) {
    default: return false;
    case MCK_GR16_NOREX: return true;
    case MCK_GR16: return true;
    }

  case MCK_GR16_NOREX:
    return B == MCK_GR16;

  case MCK_EAX:
    switch (B) {
    default: return false;
    case MCK_GR32_AD: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_EDX:
    switch (B) {
    default: return false;
    case MCK_Reg20: return true;
    case MCK_Reg21: return true;
    case MCK_Reg22: return true;
    case MCK_Reg23: return true;
    case MCK_Reg25: return true;
    case MCK_GR32_AD: return true;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_ECX:
    switch (B) {
    default: return false;
    case MCK_Reg20: return true;
    case MCK_Reg21: return true;
    case MCK_Reg22: return true;
    case MCK_Reg23: return true;
    case MCK_Reg25: return true;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_Reg20:
    switch (B) {
    default: return false;
    case MCK_Reg21: return true;
    case MCK_Reg22: return true;
    case MCK_Reg23: return true;
    case MCK_Reg25: return true;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_Reg21:
    switch (B) {
    default: return false;
    case MCK_Reg22: return true;
    case MCK_Reg23: return true;
    case MCK_Reg25: return true;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_Reg22:
    switch (B) {
    default: return false;
    case MCK_Reg23: return true;
    case MCK_Reg25: return true;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_Reg23:
    switch (B) {
    default: return false;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32: return true;
    }

  case MCK_Reg25:
    switch (B) {
    default: return false;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_GR32_AD:
    switch (B) {
    default: return false;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_GR32_NOAX:
    return B == MCK_GR32;

  case MCK_GR32_TC:
    switch (B) {
    default: return false;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_GR32_ABCD:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_GR32_NOREX_NOSP:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_GR32_NOREX:
    return B == MCK_GR32;

  case MCK_GR32_NOSP:
    return B == MCK_GR32;

  case MCK_RAX:
    switch (B) {
    default: return false;
    case MCK_Reg29: return true;
    case MCK_Reg28: return true;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_RDX:
    switch (B) {
    default: return false;
    case MCK_Reg43: return true;
    case MCK_Reg51: return true;
    case MCK_Reg29: return true;
    case MCK_Reg50: return true;
    case MCK_Reg28: return true;
    case MCK_Reg49: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_Reg44: return true;
    case MCK_Reg45: return true;
    case MCK_Reg46: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_RCX:
    switch (B) {
    default: return false;
    case MCK_Reg43: return true;
    case MCK_Reg51: return true;
    case MCK_Reg29: return true;
    case MCK_Reg50: return true;
    case MCK_Reg49: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_Reg44: return true;
    case MCK_Reg45: return true;
    case MCK_Reg46: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg43:
    switch (B) {
    default: return false;
    case MCK_Reg51: return true;
    case MCK_Reg29: return true;
    case MCK_Reg50: return true;
    case MCK_Reg49: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_Reg44: return true;
    case MCK_Reg45: return true;
    case MCK_Reg46: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg51:
    switch (B) {
    default: return false;
    case MCK_Reg50: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_Reg38: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg29:
    switch (B) {
    default: return false;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg50:
    switch (B) {
    default: return false;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_Reg38: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg28:
    switch (B) {
    default: return false;
    case MCK_Reg29: return true;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg49:
    switch (B) {
    default: return false;
    case MCK_Reg50: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_Reg45: return true;
    case MCK_Reg46: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg48:
    switch (B) {
    default: return false;
    case MCK_Reg47: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg47:
    switch (B) {
    default: return false;
    case MCK_Reg33: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg37:
    switch (B) {
    default: return false;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg38:
    switch (B) {
    default: return false;
    case MCK_Reg33: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg40:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg44:
    switch (B) {
    default: return false;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_Reg45: return true;
    case MCK_Reg46: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg45:
    switch (B) {
    default: return false;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_Reg46: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg46:
    switch (B) {
    default: return false;
    case MCK_Reg47: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR64_ABCD:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR64_NOREX_NOSP:
    switch (B) {
    default: return false;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg32:
    switch (B) {
    default: return false;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg33:
    return B == MCK_GR64;

  case MCK_GR64_NOREX:
    return B == MCK_GR64;

  case MCK_GR64_TCW64:
    switch (B) {
    default: return false;
    case MCK_Reg38: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR64_NOSP:
    switch (B) {
    default: return false;
    case MCK_Reg33: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR64_TC:
    return B == MCK_GR64;

  case MCK_XMM0:
    switch (B) {
    default: return false;
    case MCK_FR32: return true;
    case MCK_FR32X: return true;
    }

  case MCK_FR32:
    return B == MCK_FR32X;

  case MCK_VR256:
    return B == MCK_VR256X;

  case MCK_Reg60:
    return B == MCK_VR512;

  case MCK_VK16WM:
    return B == MCK_VK1;

  case MCK_ST0:
    return B == MCK_RST;

  case MCK_CS:
    return B == MCK_SEGMENT_REG;

  case MCK_DS:
    return B == MCK_SEGMENT_REG;

  case MCK_SS:
    return B == MCK_SEGMENT_REG;

  case MCK_ES:
    return B == MCK_SEGMENT_REG;

  case MCK_FS:
    return B == MCK_SEGMENT_REG;

  case MCK_GS:
    return B == MCK_SEGMENT_REG;

  case MCK_ImmSExti64i8:
    switch (B) {
    default: return false;
    case MCK_ImmSExti16i8: return true;
    case MCK_ImmSExti32i8: return true;
    case MCK_ImmSExti64i32: return true;
    case MCK_Imm: return true;
    }

  case MCK_ImmSExti16i8:
    switch (B) {
    default: return false;
    case MCK_ImmSExti64i32: return true;
    case MCK_Imm: return true;
    }

  case MCK_ImmSExti32i8:
    return B == MCK_Imm;

  case MCK_ImmSExti64i32:
    return B == MCK_Imm;

  case MCK_ImmZExtu32u8:
    return B == MCK_Imm;

  case MCK_AbsMem:
    return B == MCK_Mem;

  case MCK_DstIdx16:
    return B == MCK_Mem16;

  case MCK_DstIdx32:
    return B == MCK_Mem32;

  case MCK_DstIdx64:
    return B == MCK_Mem64;

  case MCK_DstIdx8:
    return B == MCK_Mem8;

  case MCK_MemOffs16:
    return B == MCK_Mem16;

  case MCK_MemOffs32:
    return B == MCK_Mem32;

  case MCK_MemOffs64:
    return B == MCK_Mem64;

  case MCK_MemOffs8:
    return B == MCK_Mem8;

  case MCK_SrcIdx16:
    return B == MCK_Mem16;

  case MCK_SrcIdx32:
    return B == MCK_Mem32;

  case MCK_SrcIdx64:
    return B == MCK_Mem64;

  case MCK_SrcIdx8:
    return B == MCK_Mem8;
  }
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  X86Operand &Operand = (X86Operand&)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken())
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  // 'ImmSExti64i8' class
  if (Kind == MCK_ImmSExti64i8) {
    if (Operand.isImmSExti64i8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'ImmSExti16i8' class
  if (Kind == MCK_ImmSExti16i8) {
    if (Operand.isImmSExti16i8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'ImmSExti32i8' class
  if (Kind == MCK_ImmSExti32i8) {
    if (Operand.isImmSExti32i8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'ImmSExti64i32' class
  if (Kind == MCK_ImmSExti64i32) {
    if (Operand.isImmSExti64i32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'ImmZExtu32u8' class
  if (Kind == MCK_ImmZExtu32u8) {
    if (Operand.isImmZExtu32u8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Imm' class
  if (Kind == MCK_Imm) {
    if (Operand.isImm())
      return MCTargetAsmParser::Match_Success;
  }

  // 'AbsMem' class
  if (Kind == MCK_AbsMem) {
    if (Operand.isAbsMem())
      return MCTargetAsmParser::Match_Success;
  }

  // 'DstIdx16' class
  if (Kind == MCK_DstIdx16) {
    if (Operand.isDstIdx16())
      return MCTargetAsmParser::Match_Success;
  }

  // 'DstIdx32' class
  if (Kind == MCK_DstIdx32) {
    if (Operand.isDstIdx32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'DstIdx64' class
  if (Kind == MCK_DstIdx64) {
    if (Operand.isDstIdx64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'DstIdx8' class
  if (Kind == MCK_DstIdx8) {
    if (Operand.isDstIdx8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'GR32orGR64' class
  if (Kind == MCK_GR32orGR64) {
    if (Operand.isGR32orGR64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem128' class
  if (Kind == MCK_Mem128) {
    if (Operand.isMem128())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem16' class
  if (Kind == MCK_Mem16) {
    if (Operand.isMem16())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem256' class
  if (Kind == MCK_Mem256) {
    if (Operand.isMem256())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem32' class
  if (Kind == MCK_Mem32) {
    if (Operand.isMem32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem512' class
  if (Kind == MCK_Mem512) {
    if (Operand.isMem512())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem64' class
  if (Kind == MCK_Mem64) {
    if (Operand.isMem64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem80' class
  if (Kind == MCK_Mem80) {
    if (Operand.isMem80())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem' class
  if (Kind == MCK_Mem) {
    if (Operand.isMem())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs16' class
  if (Kind == MCK_MemOffs16) {
    if (Operand.isMemOffs16())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs32' class
  if (Kind == MCK_MemOffs32) {
    if (Operand.isMemOffs32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs64' class
  if (Kind == MCK_MemOffs64) {
    if (Operand.isMemOffs64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs8' class
  if (Kind == MCK_MemOffs8) {
    if (Operand.isMemOffs8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVX32' class
  if (Kind == MCK_MemVX32) {
    if (Operand.isMemVX32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVX64' class
  if (Kind == MCK_MemVX64) {
    if (Operand.isMemVX64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVY32' class
  if (Kind == MCK_MemVY32) {
    if (Operand.isMemVY32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVY64' class
  if (Kind == MCK_MemVY64) {
    if (Operand.isMemVY64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVZ32' class
  if (Kind == MCK_MemVZ32) {
    if (Operand.isMemVZ32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVZ64' class
  if (Kind == MCK_MemVZ64) {
    if (Operand.isMemVZ64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'SrcIdx16' class
  if (Kind == MCK_SrcIdx16) {
    if (Operand.isSrcIdx16())
      return MCTargetAsmParser::Match_Success;
  }

  // 'SrcIdx32' class
  if (Kind == MCK_SrcIdx32) {
    if (Operand.isSrcIdx32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'SrcIdx64' class
  if (Kind == MCK_SrcIdx64) {
    if (Operand.isSrcIdx64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'SrcIdx8' class
  if (Kind == MCK_SrcIdx8) {
    if (Operand.isSrcIdx8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem8' class
  if (Kind == MCK_Mem8) {
    if (Operand.isMem8())
      return MCTargetAsmParser::Match_Success;
  }

  if (Operand.isReg()) {
    MatchClassKind OpKind;
    switch (Operand.getReg()) {
    default: OpKind = InvalidMatchClass; break;
    case X86::AL: OpKind = MCK_AL; break;
    case X86::DL: OpKind = MCK_GR8_ABCD_L; break;
    case X86::CL: OpKind = MCK_CL; break;
    case X86::BL: OpKind = MCK_GR8_ABCD_L; break;
    case X86::AH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::DH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::CH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::BH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::SIL: OpKind = MCK_GR8; break;
    case X86::DIL: OpKind = MCK_GR8; break;
    case X86::BPL: OpKind = MCK_GR8; break;
    case X86::SPL: OpKind = MCK_GR8; break;
    case X86::R8B: OpKind = MCK_GR8; break;
    case X86::R9B: OpKind = MCK_GR8; break;
    case X86::R10B: OpKind = MCK_GR8; break;
    case X86::R11B: OpKind = MCK_GR8; break;
    case X86::R12B: OpKind = MCK_GR8; break;
    case X86::R13B: OpKind = MCK_GR8; break;
    case X86::R14B: OpKind = MCK_GR8; break;
    case X86::R15B: OpKind = MCK_GR8; break;
    case X86::AX: OpKind = MCK_AX; break;
    case X86::DX: OpKind = MCK_DX; break;
    case X86::CX: OpKind = MCK_GR16_ABCD; break;
    case X86::BX: OpKind = MCK_GR16_ABCD; break;
    case X86::SI: OpKind = MCK_GR16_NOREX; break;
    case X86::DI: OpKind = MCK_GR16_NOREX; break;
    case X86::BP: OpKind = MCK_GR16_NOREX; break;
    case X86::SP: OpKind = MCK_GR16_NOREX; break;
    case X86::R8W: OpKind = MCK_GR16; break;
    case X86::R9W: OpKind = MCK_GR16; break;
    case X86::R10W: OpKind = MCK_GR16; break;
    case X86::R11W: OpKind = MCK_GR16; break;
    case X86::R12W: OpKind = MCK_GR16; break;
    case X86::R13W: OpKind = MCK_GR16; break;
    case X86::R14W: OpKind = MCK_GR16; break;
    case X86::R15W: OpKind = MCK_GR16; break;
    case X86::EAX: OpKind = MCK_EAX; break;
    case X86::EDX: OpKind = MCK_EDX; break;
    case X86::ECX: OpKind = MCK_ECX; break;
    case X86::EBX: OpKind = MCK_Reg21; break;
    case X86::ESI: OpKind = MCK_Reg22; break;
    case X86::EDI: OpKind = MCK_Reg22; break;
    case X86::EBP: OpKind = MCK_Reg22; break;
    case X86::ESP: OpKind = MCK_Reg23; break;
    case X86::R8D: OpKind = MCK_Reg25; break;
    case X86::R9D: OpKind = MCK_Reg25; break;
    case X86::R10D: OpKind = MCK_Reg25; break;
    case X86::R11D: OpKind = MCK_Reg25; break;
    case X86::R12D: OpKind = MCK_Reg25; break;
    case X86::R13D: OpKind = MCK_Reg25; break;
    case X86::R14D: OpKind = MCK_Reg25; break;
    case X86::R15D: OpKind = MCK_Reg25; break;
    case X86::RAX: OpKind = MCK_RAX; break;
    case X86::RDX: OpKind = MCK_RDX; break;
    case X86::RCX: OpKind = MCK_RCX; break;
    case X86::RBX: OpKind = MCK_Reg44; break;
    case X86::RSI: OpKind = MCK_Reg49; break;
    case X86::RDI: OpKind = MCK_Reg49; break;
    case X86::RBP: OpKind = MCK_Reg45; break;
    case X86::RSP: OpKind = MCK_Reg46; break;
    case X86::R8: OpKind = MCK_Reg51; break;
    case X86::R9: OpKind = MCK_Reg51; break;
    case X86::R10: OpKind = MCK_Reg48; break;
    case X86::R11: OpKind = MCK_Reg51; break;
    case X86::R12: OpKind = MCK_Reg48; break;
    case X86::R13: OpKind = MCK_Reg48; break;
    case X86::R14: OpKind = MCK_Reg48; break;
    case X86::R15: OpKind = MCK_Reg48; break;
    case X86::RIP: OpKind = MCK_Reg40; break;
    case X86::MM0: OpKind = MCK_VR64; break;
    case X86::MM1: OpKind = MCK_VR64; break;
    case X86::MM2: OpKind = MCK_VR64; break;
    case X86::MM3: OpKind = MCK_VR64; break;
    case X86::MM4: OpKind = MCK_VR64; break;
    case X86::MM5: OpKind = MCK_VR64; break;
    case X86::MM6: OpKind = MCK_VR64; break;
    case X86::MM7: OpKind = MCK_VR64; break;
    case X86::FP0: OpKind = MCK_RFP32; break;
    case X86::FP1: OpKind = MCK_RFP32; break;
    case X86::FP2: OpKind = MCK_RFP32; break;
    case X86::FP3: OpKind = MCK_RFP32; break;
    case X86::FP4: OpKind = MCK_RFP32; break;
    case X86::FP5: OpKind = MCK_RFP32; break;
    case X86::FP6: OpKind = MCK_RFP32; break;
    case X86::XMM0: OpKind = MCK_XMM0; break;
    case X86::XMM1: OpKind = MCK_FR32; break;
    case X86::XMM2: OpKind = MCK_FR32; break;
    case X86::XMM3: OpKind = MCK_FR32; break;
    case X86::XMM4: OpKind = MCK_FR32; break;
    case X86::XMM5: OpKind = MCK_FR32; break;
    case X86::XMM6: OpKind = MCK_FR32; break;
    case X86::XMM7: OpKind = MCK_FR32; break;
    case X86::XMM8: OpKind = MCK_FR32; break;
    case X86::XMM9: OpKind = MCK_FR32; break;
    case X86::XMM10: OpKind = MCK_FR32; break;
    case X86::XMM11: OpKind = MCK_FR32; break;
    case X86::XMM12: OpKind = MCK_FR32; break;
    case X86::XMM13: OpKind = MCK_FR32; break;
    case X86::XMM14: OpKind = MCK_FR32; break;
    case X86::XMM15: OpKind = MCK_FR32; break;
    case X86::XMM16: OpKind = MCK_FR32X; break;
    case X86::XMM17: OpKind = MCK_FR32X; break;
    case X86::XMM18: OpKind = MCK_FR32X; break;
    case X86::XMM19: OpKind = MCK_FR32X; break;
    case X86::XMM20: OpKind = MCK_FR32X; break;
    case X86::XMM21: OpKind = MCK_FR32X; break;
    case X86::XMM22: OpKind = MCK_FR32X; break;
    case X86::XMM23: OpKind = MCK_FR32X; break;
    case X86::XMM24: OpKind = MCK_FR32X; break;
    case X86::XMM25: OpKind = MCK_FR32X; break;
    case X86::XMM26: OpKind = MCK_FR32X; break;
    case X86::XMM27: OpKind = MCK_FR32X; break;
    case X86::XMM28: OpKind = MCK_FR32X; break;
    case X86::XMM29: OpKind = MCK_FR32X; break;
    case X86::XMM30: OpKind = MCK_FR32X; break;
    case X86::XMM31: OpKind = MCK_FR32X; break;
    case X86::YMM0: OpKind = MCK_VR256; break;
    case X86::YMM1: OpKind = MCK_VR256; break;
    case X86::YMM2: OpKind = MCK_VR256; break;
    case X86::YMM3: OpKind = MCK_VR256; break;
    case X86::YMM4: OpKind = MCK_VR256; break;
    case X86::YMM5: OpKind = MCK_VR256; break;
    case X86::YMM6: OpKind = MCK_VR256; break;
    case X86::YMM7: OpKind = MCK_VR256; break;
    case X86::YMM8: OpKind = MCK_VR256; break;
    case X86::YMM9: OpKind = MCK_VR256; break;
    case X86::YMM10: OpKind = MCK_VR256; break;
    case X86::YMM11: OpKind = MCK_VR256; break;
    case X86::YMM12: OpKind = MCK_VR256; break;
    case X86::YMM13: OpKind = MCK_VR256; break;
    case X86::YMM14: OpKind = MCK_VR256; break;
    case X86::YMM15: OpKind = MCK_VR256; break;
    case X86::YMM16: OpKind = MCK_VR256X; break;
    case X86::YMM17: OpKind = MCK_VR256X; break;
    case X86::YMM18: OpKind = MCK_VR256X; break;
    case X86::YMM19: OpKind = MCK_VR256X; break;
    case X86::YMM20: OpKind = MCK_VR256X; break;
    case X86::YMM21: OpKind = MCK_VR256X; break;
    case X86::YMM22: OpKind = MCK_VR256X; break;
    case X86::YMM23: OpKind = MCK_VR256X; break;
    case X86::YMM24: OpKind = MCK_VR256X; break;
    case X86::YMM25: OpKind = MCK_VR256X; break;
    case X86::YMM26: OpKind = MCK_VR256X; break;
    case X86::YMM27: OpKind = MCK_VR256X; break;
    case X86::YMM28: OpKind = MCK_VR256X; break;
    case X86::YMM29: OpKind = MCK_VR256X; break;
    case X86::YMM30: OpKind = MCK_VR256X; break;
    case X86::YMM31: OpKind = MCK_VR256X; break;
    case X86::ZMM0: OpKind = MCK_Reg60; break;
    case X86::ZMM1: OpKind = MCK_Reg60; break;
    case X86::ZMM2: OpKind = MCK_Reg60; break;
    case X86::ZMM3: OpKind = MCK_Reg60; break;
    case X86::ZMM4: OpKind = MCK_Reg60; break;
    case X86::ZMM5: OpKind = MCK_Reg60; break;
    case X86::ZMM6: OpKind = MCK_Reg60; break;
    case X86::ZMM7: OpKind = MCK_Reg60; break;
    case X86::ZMM8: OpKind = MCK_Reg60; break;
    case X86::ZMM9: OpKind = MCK_Reg60; break;
    case X86::ZMM10: OpKind = MCK_Reg60; break;
    case X86::ZMM11: OpKind = MCK_Reg60; break;
    case X86::ZMM12: OpKind = MCK_Reg60; break;
    case X86::ZMM13: OpKind = MCK_Reg60; break;
    case X86::ZMM14: OpKind = MCK_Reg60; break;
    case X86::ZMM15: OpKind = MCK_Reg60; break;
    case X86::ZMM16: OpKind = MCK_VR512; break;
    case X86::ZMM17: OpKind = MCK_VR512; break;
    case X86::ZMM18: OpKind = MCK_VR512; break;
    case X86::ZMM19: OpKind = MCK_VR512; break;
    case X86::ZMM20: OpKind = MCK_VR512; break;
    case X86::ZMM21: OpKind = MCK_VR512; break;
    case X86::ZMM22: OpKind = MCK_VR512; break;
    case X86::ZMM23: OpKind = MCK_VR512; break;
    case X86::ZMM24: OpKind = MCK_VR512; break;
    case X86::ZMM25: OpKind = MCK_VR512; break;
    case X86::ZMM26: OpKind = MCK_VR512; break;
    case X86::ZMM27: OpKind = MCK_VR512; break;
    case X86::ZMM28: OpKind = MCK_VR512; break;
    case X86::ZMM29: OpKind = MCK_VR512; break;
    case X86::ZMM30: OpKind = MCK_VR512; break;
    case X86::ZMM31: OpKind = MCK_VR512; break;
    case X86::K0: OpKind = MCK_VK1; break;
    case X86::K1: OpKind = MCK_VK16WM; break;
    case X86::K2: OpKind = MCK_VK16WM; break;
    case X86::K3: OpKind = MCK_VK16WM; break;
    case X86::K4: OpKind = MCK_VK16WM; break;
    case X86::K5: OpKind = MCK_VK16WM; break;
    case X86::K6: OpKind = MCK_VK16WM; break;
    case X86::K7: OpKind = MCK_VK16WM; break;
    case X86::ST0: OpKind = MCK_ST0; break;
    case X86::ST1: OpKind = MCK_RST; break;
    case X86::ST2: OpKind = MCK_RST; break;
    case X86::ST3: OpKind = MCK_RST; break;
    case X86::ST4: OpKind = MCK_RST; break;
    case X86::ST5: OpKind = MCK_RST; break;
    case X86::ST6: OpKind = MCK_RST; break;
    case X86::ST7: OpKind = MCK_RST; break;
    case X86::FPSW: OpKind = MCK_FPCCR; break;
    case X86::EFLAGS: OpKind = MCK_CCR; break;
    case X86::CS: OpKind = MCK_CS; break;
    case X86::DS: OpKind = MCK_DS; break;
    case X86::SS: OpKind = MCK_SS; break;
    case X86::ES: OpKind = MCK_ES; break;
    case X86::FS: OpKind = MCK_FS; break;
    case X86::GS: OpKind = MCK_GS; break;
    case X86::DR0: OpKind = MCK_DEBUG_REG; break;
    case X86::DR1: OpKind = MCK_DEBUG_REG; break;
    case X86::DR2: OpKind = MCK_DEBUG_REG; break;
    case X86::DR3: OpKind = MCK_DEBUG_REG; break;
    case X86::DR4: OpKind = MCK_DEBUG_REG; break;
    case X86::DR5: OpKind = MCK_DEBUG_REG; break;
    case X86::DR6: OpKind = MCK_DEBUG_REG; break;
    case X86::DR7: OpKind = MCK_DEBUG_REG; break;
    case X86::CR0: OpKind = MCK_CONTROL_REG; break;
    case X86::CR1: OpKind = MCK_CONTROL_REG; break;
    case X86::CR2: OpKind = MCK_CONTROL_REG; break;
    case X86::CR3: OpKind = MCK_CONTROL_REG; break;
    case X86::CR4: OpKind = MCK_CONTROL_REG; break;
    case X86::CR5: OpKind = MCK_CONTROL_REG; break;
    case X86::CR6: OpKind = MCK_CONTROL_REG; break;
    case X86::CR7: OpKind = MCK_CONTROL_REG; break;
    case X86::CR8: OpKind = MCK_CONTROL_REG; break;
    case X86::CR9: OpKind = MCK_CONTROL_REG; break;
    case X86::CR10: OpKind = MCK_CONTROL_REG; break;
    case X86::CR11: OpKind = MCK_CONTROL_REG; break;
    case X86::CR12: OpKind = MCK_CONTROL_REG; break;
    case X86::CR13: OpKind = MCK_CONTROL_REG; break;
    case X86::CR14: OpKind = MCK_CONTROL_REG; break;
    case X86::CR15: OpKind = MCK_CONTROL_REG; break;
    }
    return isSubclass(OpKind, Kind) ? MCTargetAsmParser::Match_Success :
                                      MCTargetAsmParser::Match_InvalidOperand;
  }

  return MCTargetAsmParser::Match_InvalidOperand;
}

unsigned X86AsmParser::
ComputeAvailableFeatures(uint64_t FB) const {
  unsigned Features = 0;
  if (((FB & X86::FeatureAVX512) != 0))
    Features |= Feature_HasAVX512;
  if (((FB & X86::FeatureVLX) != 0))
    Features |= Feature_HasVLX;
  if (((FB & X86::Mode64Bit) == 0))
    Features |= Feature_Not64BitMode;
  if (((FB & X86::Mode64Bit) != 0))
    Features |= Feature_In64BitMode;
  if (((FB & X86::Mode16Bit) != 0))
    Features |= Feature_In16BitMode;
  if (((FB & X86::Mode16Bit) == 0))
    Features |= Feature_Not16BitMode;
  if (((FB & X86::Mode32Bit) != 0))
    Features |= Feature_In32BitMode;
  return Features;
}

static const char *const MnemonicTable =
    "\003aaa\003aad\003aam\003aas\003adc\004adcb\004adcl\004adcq\004adcw\004"
    "adcx\005adcxl\005adcxq\003add\004addb\004addl\005addpd\005addps\004addq"
    "\005addsd\005addss\010addsubpd\010addsubps\004addw\004adox\005adoxl\005"
    "adoxq\006aesdec\naesdeclast\006aesenc\naesenclast\006aesimc\017aeskeyge"
    "nassist\003and\004andb\004andl\004andn\005andnl\006andnpd\006andnps\005"
    "andnq\005andpd\005andps\004andq\004andw\004arpl\005bextr\006bextrl\006b"
    "extrq\007blcfill\004blci\005blcic\006blcmsk\004blcs\007blendpd\007blend"
    "ps\010blendvpd\010blendvps\007blsfill\004blsi\005blsic\005blsil\005blsi"
    "q\006blsmsk\007blsmskl\007blsmskq\004blsr\005blsrl\005blsrq\005bound\003"
    "bsf\004bsfl\004bsfq\004bsfw\003bsr\004bsrl\004bsrq\004bsrw\005bswap\006"
    "bswapl\006bswapq\002bt\003btc\004btcl\004btcq\004btcw\003btl\003btq\003"
    "btr\004btrl\004btrq\004btrw\003bts\004btsl\004btsq\004btsw\003btw\004bz"
    "hi\005bzhil\005bzhiq\004call\005calll\005callq\005callw\004cbtw\003cbw\003"
    "cdq\004cdqe\004clac\003clc\003cld\007clflush\004clgi\003cli\004clrb\004"
    "clrl\004clrq\004clrw\004cltd\004cltq\004clts\003cmc\005cmova\006cmovae\007"
    "cmovael\007cmovaeq\007cmovaew\006cmoval\006cmovaq\006cmovaw\005cmovb\006"
    "cmovbe\007cmovbel\007cmovbeq\007cmovbew\006cmovbl\006cmovbq\006cmovbw\005"
    "cmove\006cmovel\006cmoveq\006cmovew\005cmovg\006cmovge\007cmovgel\007cm"
    "ovgeq\007cmovgew\006cmovgl\006cmovgq\006cmovgw\005cmovl\006cmovle\007cm"
    "ovlel\007cmovleq\007cmovlew\006cmovll\006cmovlq\006cmovlw\006cmovne\007"
    "cmovnel\007cmovneq\007cmovnew\006cmovno\007cmovnol\007cmovnoq\007cmovno"
    "w\006cmovnp\007cmovnpl\007cmovnpq\007cmovnpw\006cmovns\007cmovnsl\007cm"
    "ovnsq\007cmovnsw\005cmovo\006cmovol\006cmovoq\006cmovow\005cmovp\006cmo"
    "vpl\006cmovpq\006cmovpw\005cmovs\006cmovsl\006cmovsq\006cmovsw\003cmp\004"
    "cmpb\004cmpl\005cmppd\005cmpps\004cmpq\005cmpsb\005cmpsd\005cmpsl\005cm"
    "psq\005cmpss\005cmpsw\004cmpw\007cmpxchg\ncmpxchg16b\tcmpxchg8b\010cmpx"
    "chgb\010cmpxchgl\010cmpxchgq\010cmpxchgw\006comisd\006comiss\005cpuid\003"
    "cqo\004cqto\005crc32\006crc32b\006crc32l\006crc32q\006crc32w\002cs\010c"
    "vtdq2pd\010cvtdq2ps\010cvtpd2dq\010cvtpd2pi\010cvtpd2ps\010cvtpi2pd\010"
    "cvtpi2ps\010cvtps2dq\010cvtps2pd\010cvtps2pi\010cvtsd2si\tcvtsd2sil\tcv"
    "tsd2siq\010cvtsd2ss\010cvtsi2sd\tcvtsi2sdl\tcvtsi2sdq\010cvtsi2ss\tcvts"
    "i2ssl\tcvtsi2ssq\010cvtss2sd\010cvtss2si\tcvtss2sil\tcvtss2siq\tcvttpd2"
    "dq\tcvttpd2pi\tcvttps2dq\tcvttps2pi\tcvttsd2si\ncvttsd2sil\ncvttsd2siq\t"
    "cvttss2si\ncvttss2sil\ncvttss2siq\003cwd\004cwde\004cwtd\004cwtl\003daa"
    "\003das\006data16\003dec\004decb\004decl\004decq\004decw\003div\004divb"
    "\004divl\005divpd\005divps\004divq\005divsd\005divss\004divw\004dppd\004"
    "dpps\002ds\004emms\005enter\002es\textractps\005extrq\005f2xm1\004fabs\004"
    "fadd\005faddl\005faddp\005fadds\004fbld\005fbstp\004fchs\006fcmovb\007f"
    "cmovbe\006fcmove\007fcmovnb\010fcmovnbe\007fcmovne\007fcmovnu\006fcmovu"
    "\004fcom\005fcomi\005fcoml\005fcomp\006fcompi\006fcompl\006fcompp\006fc"
    "omps\005fcoms\004fcos\007fdecstp\004fdiv\005fdivl\005fdivp\005fdivr\006"
    "fdivrl\006fdivrp\006fdivrs\005fdivs\005femms\005ffree\005fiadd\006fiadd"
    "l\006fiadds\005ficom\006ficoml\006ficomp\007ficompl\007ficomps\006ficom"
    "s\005fidiv\006fidivl\006fidivr\007fidivrl\007fidivrs\006fidivs\004fild\005"
    "fildl\006fildll\005filds\005fimul\006fimull\006fimuls\007fincstp\004fis"
    "t\005fistl\005fistp\006fistpl\007fistpll\006fistps\005fists\006fisttp\007"
    "fisttpl\010fisttpll\007fisttps\005fisub\006fisubl\006fisubr\007fisubrl\007"
    "fisubrs\006fisubs\003fld\004fld1\005fldcw\006fldenv\004fldl\006fldl2e\006"
    "fldl2t\006fldlg2\006fldln2\005fldpi\004flds\004fldt\004fldz\004fmul\005"
    "fmull\005fmulp\005fmuls\006fnclex\006fninit\004fnop\006fnsave\006fnstcw"
    "\007fnstenv\006fnstsw\006fpatan\005fprem\006fprem1\005fptan\007frndint\006"
    "frstor\002fs\006fscale\004fsin\007fsincos\005fsqrt\003fst\004fstl\004fs"
    "tp\005fstpl\005fstps\005fstpt\004fsts\004fsub\005fsubl\005fsubp\005fsub"
    "r\006fsubrl\006fsubrp\006fsubrs\005fsubs\004ftst\005fucom\006fucomi\006"
    "fucomp\007fucompi\007fucompp\004fxam\004fxch\007fxrstor\tfxrstor64\010f"
    "xrstorq\006fxsave\010fxsave64\007fxsaveq\007fxtract\005fyl2x\007fyl2xp1"
    "\002gs\006haddpd\006haddps\003hlt\006hsubpd\006hsubps\004idiv\005idivb\005"
    "idivl\005idivq\005idivw\004imul\005imulb\005imull\005imulq\005imulw\002"
    "in\003inb\003inc\004incb\004incl\004incq\004incw\003inl\004insb\004insd"
    "\010insertps\007insertq\004insl\004insw\003int\004int3\004into\004invd\006"
    "invept\006invlpg\007invlpga\007invpcid\007invvpid\003inw\004iret\005ire"
    "td\005iretl\005iretq\005iretw\002ja\003jae\002jb\003jbe\004jcxz\002je\005"
    "jecxz\002jg\003jge\002jl\003jle\003jmp\004jmpl\004jmpq\004jmpw\003jne\003"
    "jno\003jnp\003jns\002jo\002jp\005jrcxz\002js\006kandnw\005kandw\005kmov"
    "w\005knotw\010kortestw\004korw\010kshiftlw\010kshiftrw\010kunpckbw\006k"
    "xnorw\005kxorw\004lahf\003lar\004larl\004larq\004larw\005lcall\006lcall"
    "l\006lcallq\006lcallw\005lddqu\007ldmxcsr\003lds\004ldsl\004ldsw\003lea"
    "\004leal\004leaq\005leave\004leaw\003les\004lesl\004lesw\006lfence\003l"
    "fs\004lfsl\004lfsq\004lfsw\004lgdt\005lgdtl\005lgdtq\005lgdtw\003lgs\004"
    "lgsl\004lgsq\004lgsw\004lidt\005lidtl\005lidtq\005lidtw\004ljmp\005ljmp"
    "l\005ljmpq\005ljmpw\004lldt\005lldtw\004lmsw\005lmsww\004lock\004lods\005"
    "lodsb\005lodsd\005lodsl\005lodsq\005lodsw\004loop\005loope\006loopne\005"
    "lretl\005lretq\005lretw\003lsl\004lsll\004lslq\004lslw\003lss\004lssl\004"
    "lssq\004lssw\003ltr\004ltrw\005lzcnt\006lzcntl\006lzcntq\006lzcntw\nmas"
    "kmovdqu\010maskmovq\005maxpd\005maxps\005maxsd\005maxss\006mfence\005mi"
    "npd\005minps\005minsd\005minss\007monitor\007montmul\003mov\006movabs\007"
    "movabsb\007movabsl\007movabsq\007movabsw\006movapd\006movaps\004movb\005"
    "movbe\006movbel\006movbeq\006movbew\004movd\007movddup\007movdq2q\006mo"
    "vdqa\006movdqu\007movhlps\006movhpd\006movhps\004movl\007movlhps\006mov"
    "lpd\006movlps\010movmskpd\010movmskps\007movntdq\010movntdqa\006movnti\007"
    "movntil\007movntiq\007movntpd\007movntps\006movntq\007movntsd\007movnts"
    "s\004movq\007movq2dq\005movsb\006movsbl\006movsbq\006movsbw\005movsd\010"
    "movshdup\005movsl\010movsldup\006movslq\005movsq\005movss\005movsw\006m"
    "ovswl\006movswq\005movsx\006movsxd\006movupd\006movups\004movw\006movzb"
    "l\006movzbq\006movzbw\006movzwl\006movzwq\005movzx\007mpsadbw\003mul\004"
    "mulb\004mull\005mulpd\005mulps\004mulq\005mulsd\005mulss\004mulw\004mul"
    "x\005mulxl\005mulxq\005mwait\003neg\004negb\004negl\004negq\004negw\003"
    "nop\004nopl\004nopw\003not\004notb\004notl\004notq\004notw\002or\003orb"
    "\003orl\004orpd\004orps\003orq\003orw\003out\004outb\004outl\005outsb\005"
    "outsd\005outsl\005outsw\004outw\005pabsb\005pabsd\005pabsw\010packssdw\010"
    "packsswb\010packusdw\010packuswb\005paddb\005paddd\005paddq\006paddsb\006"
    "paddsw\007paddusb\007paddusw\005paddw\007palignr\004pand\005pandn\005pa"
    "use\005pavgb\007pavgusb\005pavgw\010pblendvb\007pblendw\014pclmulhqhqdq"
    "\014pclmulhqlqdq\014pclmullqhqdq\014pclmullqlqdq\tpclmulqdq\007pcmpeqb\007"
    "pcmpeqd\007pcmpeqq\007pcmpeqw\tpcmpestri\tpcmpestrm\007pcmpgtb\007pcmpg"
    "td\007pcmpgtq\007pcmpgtw\tpcmpistri\tpcmpistrm\004pdep\005pdepl\005pdep"
    "q\004pext\005pextl\005pextq\006pextrb\006pextrd\006pextrq\006pextrw\005"
    "pf2id\005pf2iw\005pfacc\005pfadd\007pfcmpeq\007pfcmpge\007pfcmpgt\005pf"
    "max\005pfmin\005pfmul\006pfnacc\007pfpnacc\005pfrcp\010pfrcpit1\010pfrc"
    "pit2\010pfrsqit1\007pfrsqrt\005pfsub\006pfsubr\006phaddd\007phaddsw\006"
    "phaddw\nphminposuw\006phsubd\007phsubsw\006phsubw\005pi2fd\005pi2fw\006"
    "pinsrb\006pinsrd\006pinsrq\006pinsrw\tpmaddubsw\007pmaddwd\006pmaxsb\006"
    "pmaxsd\006pmaxsw\006pmaxub\006pmaxud\006pmaxuw\006pminsb\006pminsd\006p"
    "minsw\006pminub\006pminud\006pminuw\010pmovmskb\010pmovsxbd\010pmovsxbq"
    "\010pmovsxbw\010pmovsxdq\010pmovsxwd\010pmovsxwq\010pmovzxbd\010pmovzxb"
    "q\010pmovzxbw\010pmovzxdq\010pmovzxwd\010pmovzxwq\006pmuldq\010pmulhrsw"
    "\007pmulhrw\007pmulhuw\006pmulhw\006pmulld\006pmullw\007pmuludq\003pop\005"
    "popal\005popaw\006popcnt\007popcntl\007popcntq\007popcntw\004popf\005po"
    "pfd\005popfl\005popfq\005popfw\004popl\004popq\004popw\003por\010prefet"
    "ch\013prefetchnta\nprefetcht0\nprefetcht1\nprefetcht2\tprefetchw\006psa"
    "dbw\006pshufb\006pshufd\007pshufhw\007pshuflw\006pshufw\006psignb\006ps"
    "ignd\006psignw\005pslld\006pslldq\005psllq\005psllw\005psrad\005psraw\005"
    "psrld\006psrldq\005psrlq\005psrlw\005psubb\005psubd\005psubq\006psubsb\006"
    "psubsw\007psubusb\007psubusw\005psubw\006pswapd\005ptest\tpunpckhbw\tpu"
    "npckhdq\npunpckhqdq\tpunpckhwd\tpunpcklbw\tpunpckldq\npunpcklqdq\tpunpc"
    "klwd\004push\006pushal\006pushaw\005pushf\006pushfd\006pushfl\006pushfq"
    "\006pushfw\005pushl\005pushq\005pushw\004pxor\003rcl\004rclb\004rcll\004"
    "rclq\004rclw\005rcpps\005rcpss\003rcr\004rcrb\004rcrl\004rcrq\004rcrw\010"
    "rdfsbase\trdfsbasel\trdfsbaseq\010rdgsbase\trdgsbasel\trdgsbaseq\005rdm"
    "sr\005rdpmc\006rdrand\007rdrandl\007rdrandq\007rdrandw\006rdseed\007rds"
    "eedl\007rdseedq\007rdseedw\005rdtsc\006rdtscp\003rep\005repne\003ret\004"
    "retf\005retfq\004retl\004retq\004retw\005rex64\003rol\004rolb\004roll\004"
    "rolq\004rolw\003ror\004rorb\004rorl\004rorq\004rorw\004rorx\005rorxl\005"
    "rorxq\007roundpd\007roundps\007roundsd\007roundss\003rsm\007rsqrtps\007"
    "rsqrtss\004sahf\003sar\004sarb\004sarl\004sarq\004sarw\004sarx\005sarxl"
    "\005sarxq\003sbb\004sbbb\004sbbl\004sbbq\004sbbw\004scas\005scasb\005sc"
    "asd\005scasl\005scasq\005scasw\004seta\005setae\004setb\005setbe\004set"
    "e\004setg\005setge\004setl\005setle\005setne\005setno\005setnp\005setns"
    "\004seto\004setp\004sets\006sfence\004sgdt\005sgdtl\005sgdtq\005sgdtw\010"
    "sha1msg1\010sha1msg2\tsha1nexte\tsha1rnds4\nsha256msg1\nsha256msg2\013s"
    "ha256rnds2\003shl\004shlb\004shld\005shldl\005shldq\005shldw\004shll\004"
    "shlq\004shlw\004shlx\005shlxl\005shlxq\003shr\004shrb\004shrd\005shrdl\005"
    "shrdq\005shrdw\004shrl\004shrq\004shrw\004shrx\005shrxl\005shrxq\006shu"
    "fpd\006shufps\004sidt\005sidtl\005sidtq\005sidtw\006skinit\004sldt\005s"
    "ldtl\005sldtq\005sldtw\004smsw\005smswl\005smswq\005smsww\006sqrtpd\006"
    "sqrtps\006sqrtsd\006sqrtss\002ss\004stac\003stc\003std\004stgi\003sti\007"
    "stmxcsr\004stos\005stosb\005stosd\005stosl\005stosq\005stosw\003str\004"
    "strl\004strq\004strw\003sub\004subb\004subl\005subpd\005subps\004subq\005"
    "subsd\005subss\004subw\006swapgs\007syscall\010sysenter\007sysexit\010s"
    "ysexitl\010sysexitq\006sysret\007sysretl\007sysretq\006t1mskc\004test\005"
    "testb\005testl\005testq\005testw\005tzcnt\006tzcntl\006tzcntq\006tzcntw"
    "\005tzmsk\007ucomisd\007ucomiss\003ud2\004ud2b\010unpckhpd\010unpckhps\010"
    "unpcklpd\010unpcklps\006vaddpd\006vaddps\006vaddsd\006vaddss\tvaddsubpd"
    "\tvaddsubps\007vaesdec\013vaesdeclast\007vaesenc\013vaesenclast\007vaes"
    "imc\020vaeskeygenassist\007valignd\007valignq\007vandnpd\007vandnps\006"
    "vandpd\006vandps\tvblendmpd\tvblendmps\010vblendpd\010vblendps\tvblendv"
    "pd\tvblendvps\016vbroadcastf128\016vbroadcasti128\017vbroadcasti32x4\017"
    "vbroadcasti64x4\014vbroadcastsd\014vbroadcastss\004vcmp\006vcmppd\006vc"
    "mpps\006vcmpsd\006vcmpss\007vcomisd\007vcomiss\tvcvtdq2pd\tvcvtdq2ps\tv"
    "cvtpd2dq\nvcvtpd2dqx\nvcvtpd2dqy\tvcvtpd2ps\nvcvtpd2psx\nvcvtpd2psy\nvc"
    "vtpd2udq\tvcvtph2ps\tvcvtps2dq\tvcvtps2pd\tvcvtps2ph\nvcvtps2udq\tvcvts"
    "d2si\nvcvtsd2sil\nvcvtsd2siq\tvcvtsd2ss\nvcvtsd2usi\tvcvtsi2sd\nvcvtsi2"
    "sdl\nvcvtsi2sdq\tvcvtsi2ss\nvcvtsi2ssl\nvcvtsi2ssq\tvcvtss2sd\tvcvtss2s"
    "i\nvcvtss2sil\nvcvtss2siq\nvcvtss2usi\nvcvttpd2dq\013vcvttpd2dqx\013vcv"
    "ttpd2dqy\013vcvttpd2udq\nvcvttps2dq\013vcvttps2udq\nvcvttsd2si\013vcvtt"
    "sd2sil\013vcvttsd2siq\013vcvttsd2usi\nvcvttss2si\013vcvttss2sil\013vcvt"
    "tss2siq\013vcvttss2usi\nvcvtudq2pd\nvcvtudq2ps\nvcvtusi2sd\013vcvtusi2s"
    "dl\013vcvtusi2sdq\nvcvtusi2ss\013vcvtusi2ssl\013vcvtusi2ssq\006vdivpd\006"
    "vdivps\006vdivsd\006vdivss\005vdppd\005vdpps\004verr\004verw\014vextrac"
    "tf128\015vextractf32x4\015vextractf64x4\014vextracti128\015vextracti32x"
    "4\015vextracti64x4\nvextractps\013vfmadd132pd\013vfmadd132ps\013vfmadd1"
    "32sd\013vfmadd132ss\013vfmadd213pd\013vfmadd213ps\013vfmadd213sd\013vfm"
    "add213ss\013vfmadd231pd\013vfmadd231ps\013vfmadd231sd\013vfmadd231ss\010"
    "vfmaddpd\010vfmaddps\010vfmaddsd\010vfmaddss\016vfmaddsub132pd\016vfmad"
    "dsub132ps\016vfmaddsub213pd\016vfmaddsub213ps\016vfmaddsub231pd\016vfma"
    "ddsub231ps\013vfmaddsubpd\013vfmaddsubps\013vfmsub132pd\013vfmsub132ps\013"
    "vfmsub132sd\013vfmsub132ss\013vfmsub213pd\013vfmsub213ps\013vfmsub213sd"
    "\013vfmsub213ss\013vfmsub231pd\013vfmsub231ps\013vfmsub231sd\013vfmsub2"
    "31ss\016vfmsubadd132pd\016vfmsubadd132ps\016vfmsubadd213pd\016vfmsubadd"
    "213ps\016vfmsubadd231pd\016vfmsubadd231ps\013vfmsubaddpd\013vfmsubaddps"
    "\010vfmsubpd\010vfmsubps\010vfmsubsd\010vfmsubss\014vfnmadd132pd\014vfn"
    "madd132ps\014vfnmadd132sd\014vfnmadd132ss\014vfnmadd213pd\014vfnmadd213"
    "ps\014vfnmadd213sd\014vfnmadd213ss\014vfnmadd231pd\014vfnmadd231ps\014v"
    "fnmadd231sd\014vfnmadd231ss\tvfnmaddpd\tvfnmaddps\tvfnmaddsd\tvfnmaddss"
    "\014vfnmsub132pd\014vfnmsub132ps\014vfnmsub132sd\014vfnmsub132ss\014vfn"
    "msub213pd\014vfnmsub213ps\014vfnmsub213sd\014vfnmsub213ss\014vfnmsub231"
    "pd\014vfnmsub231ps\014vfnmsub231sd\014vfnmsub231ss\tvfnmsubpd\tvfnmsubp"
    "s\tvfnmsubsd\tvfnmsubss\007vfrczpd\007vfrczps\007vfrczsd\007vfrczss\nvg"
    "atherdpd\nvgatherdps\015vgatherpf0dpd\015vgatherpf0dps\015vgatherpf0qpd"
    "\015vgatherpf0qps\015vgatherpf1dpd\015vgatherpf1dps\015vgatherpf1qpd\015"
    "vgatherpf1qps\nvgatherqpd\nvgatherqps\007vhaddpd\007vhaddps\007vhsubpd\007"
    "vhsubps\013vinsertf128\014vinsertf32x4\014vinsertf64x4\013vinserti128\014"
    "vinserti32x4\014vinserti64x4\tvinsertps\006vlddqu\010vldmxcsr\013vmaskm"
    "ovdqu\nvmaskmovpd\nvmaskmovps\006vmaxpd\006vmaxps\006vmaxsd\006vmaxss\006"
    "vmcall\007vmclear\006vmfunc\006vminpd\006vminps\006vminsd\006vminss\010"
    "vmlaunch\006vmload\007vmmcall\007vmovapd\007vmovaps\005vmovd\010vmovddu"
    "p\007vmovdqa\tvmovdqa32\tvmovdqa64\007vmovdqu\tvmovdqu32\tvmovdqu64\010"
    "vmovhlps\007vmovhpd\007vmovhps\010vmovlhps\007vmovlpd\007vmovlps\tvmovm"
    "skpd\tvmovmskps\010vmovntdq\tvmovntdqa\010vmovntpd\010vmovntps\005vmovq"
    "\006vmovsd\tvmovshdup\tvmovsldup\006vmovss\007vmovupd\007vmovups\010vmp"
    "sadbw\007vmptrld\007vmptrst\006vmread\007vmreadl\007vmreadq\010vmresume"
    "\005vmrun\006vmsave\006vmulpd\006vmulps\006vmulsd\006vmulss\007vmwrite\010"
    "vmwritel\010vmwriteq\006vmxoff\005vmxon\005vorpd\005vorps\006vpabsb\006"
    "vpabsd\006vpabsq\006vpabsw\tvpackssdw\tvpacksswb\tvpackusdw\tvpackuswb\006"
    "vpaddb\006vpaddd\006vpaddq\007vpaddsb\007vpaddsw\010vpaddusb\010vpaddus"
    "w\006vpaddw\010vpalignr\005vpand\006vpandd\006vpandn\007vpandnd\007vpan"
    "dnq\006vpandq\006vpavgb\006vpavgw\010vpblendd\tvpblendmd\tvpblendmq\tvp"
    "blendvb\010vpblendw\014vpbroadcastb\014vpbroadcastd\017vpbroadcastmb2q\017"
    "vpbroadcastmw2d\014vpbroadcastq\014vpbroadcastw\015vpclmulhqhqdq\015vpc"
    "lmulhqlqdq\015vpclmullqhqdq\015vpclmullqlqdq\nvpclmulqdq\006vpcmov\005v"
    "pcmp\006vpcmpd\010vpcmpeqb\010vpcmpeqd\010vpcmpeqq\010vpcmpeqw\nvpcmpes"
    "tri\nvpcmpestrm\010vpcmpgtb\010vpcmpgtd\010vpcmpgtq\010vpcmpgtw\nvpcmpi"
    "stri\nvpcmpistrm\006vpcmpq\007vpcmpud\007vpcmpuq\006vpcomb\006vpcomd\006"
    "vpcomq\007vpcomub\007vpcomud\007vpcomuq\007vpcomuw\006vpcomw\013vpconfl"
    "ictd\013vpconflictq\nvperm2f128\nvperm2i128\006vpermd\010vpermi2d\tvper"
    "mi2pd\tvpermi2ps\010vpermi2q\nvpermil2pd\nvpermil2ps\tvpermilpd\tvpermi"
    "lps\007vpermpd\007vpermps\006vpermq\010vpermt2d\tvpermt2pd\tvpermt2ps\010"
    "vpermt2q\007vpextrb\007vpextrd\007vpextrq\007vpextrw\nvpgatherdd\nvpgat"
    "herdq\nvpgatherqd\nvpgatherqq\010vphaddbd\010vphaddbq\010vphaddbw\007vp"
    "haddd\010vphadddq\010vphaddsw\tvphaddubd\tvphaddubq\tvphaddubw\tvphaddu"
    "dq\tvphadduwd\tvphadduwq\007vphaddw\010vphaddwd\010vphaddwq\013vphminpo"
    "suw\010vphsubbw\007vphsubd\010vphsubdq\010vphsubsw\007vphsubw\010vphsub"
    "wd\007vpinsrb\007vpinsrd\007vpinsrq\007vpinsrw\010vplzcntd\010vplzcntq\010"
    "vpmacsdd\tvpmacsdqh\tvpmacsdql\tvpmacssdd\nvpmacssdqh\nvpmacssdql\tvpma"
    "csswd\tvpmacssww\010vpmacswd\010vpmacsww\nvpmadcsswd\tvpmadcswd\nvpmadd"
    "ubsw\010vpmaddwd\nvpmaskmovd\nvpmaskmovq\007vpmaxsb\007vpmaxsd\007vpmax"
    "sq\007vpmaxsw\007vpmaxub\007vpmaxud\007vpmaxuq\007vpmaxuw\007vpminsb\007"
    "vpminsd\007vpminsq\007vpminsw\007vpminub\007vpminud\007vpminuq\007vpmin"
    "uw\007vpmovdb\007vpmovdw\tvpmovmskb\007vpmovqb\007vpmovqd\007vpmovqw\010"
    "vpmovsdb\010vpmovsdw\010vpmovsqb\010vpmovsqd\010vpmovsqw\tvpmovsxbd\tvp"
    "movsxbq\tvpmovsxbw\tvpmovsxdq\tvpmovsxwd\tvpmovsxwq\tvpmovusdb\tvpmovus"
    "dw\tvpmovusqb\tvpmovusqd\tvpmovusqw\tvpmovzxbd\tvpmovzxbq\tvpmovzxbw\tv"
    "pmovzxdq\tvpmovzxwd\tvpmovzxwq\007vpmuldq\tvpmulhrsw\010vpmulhuw\007vpm"
    "ulhw\007vpmulld\007vpmullw\010vpmuludq\004vpor\005vpord\005vporq\006vpp"
    "erm\006vprotb\006vprotd\006vprotq\006vprotw\007vpsadbw\013vpscatterdd\013"
    "vpscatterdq\013vpscatterqd\013vpscatterqq\006vpshab\006vpshad\006vpshaq"
    "\006vpshaw\006vpshlb\006vpshld\006vpshlq\006vpshlw\007vpshufb\007vpshuf"
    "d\010vpshufhw\010vpshuflw\007vpsignb\007vpsignd\007vpsignw\006vpslld\007"
    "vpslldq\006vpsllq\007vpsllvd\007vpsllvq\006vpsllw\006vpsrad\006vpsraq\007"
    "vpsravd\007vpsravq\006vpsraw\006vpsrld\007vpsrldq\006vpsrlq\007vpsrlvd\007"
    "vpsrlvq\006vpsrlw\006vpsubb\006vpsubd\006vpsubq\007vpsubsb\007vpsubsw\010"
    "vpsubusb\010vpsubusw\006vpsubw\006vptest\010vptestmd\010vptestmq\tvptes"
    "tnmd\tvptestnmq\nvpunpckhbw\nvpunpckhdq\013vpunpckhqdq\nvpunpckhwd\nvpu"
    "npcklbw\nvpunpckldq\013vpunpcklqdq\nvpunpcklwd\005vpxor\006vpxord\006vp"
    "xorq\010vrcp14pd\010vrcp14ps\010vrcp14sd\010vrcp14ss\010vrcp28pd\010vrc"
    "p28ps\010vrcp28sd\010vrcp28ss\006vrcpps\006vrcpss\013vrndscalepd\013vrn"
    "dscaleps\013vrndscalesd\013vrndscaless\010vroundpd\010vroundps\010vroun"
    "dsd\010vroundss\nvrsqrt14pd\nvrsqrt14ps\nvrsqrt14sd\nvrsqrt14ss\nvrsqrt"
    "28pd\nvrsqrt28ps\nvrsqrt28sd\nvrsqrt28ss\010vrsqrtps\010vrsqrtss\013vsc"
    "atterdpd\013vscatterdps\016vscatterpf0dpd\016vscatterpf0dps\016vscatter"
    "pf0qpd\016vscatterpf0qps\016vscatterpf1dpd\016vscatterpf1dps\016vscatte"
    "rpf1qpd\016vscatterpf1qps\013vscatterqpd\013vscatterqps\007vshufpd\007v"
    "shufps\007vsqrtpd\007vsqrtps\007vsqrtsd\007vsqrtss\010vstmxcsr\006vsubp"
    "d\006vsubps\006vsubsd\006vsubss\007vtestpd\007vtestps\010vucomisd\010vu"
    "comiss\tvunpckhpd\tvunpckhps\tvunpcklpd\tvunpcklps\006vxorpd\006vxorps\010"
    "vzeroall\nvzeroupper\004wait\006wbinvd\010wrfsbase\twrfsbasel\twrfsbase"
    "q\010wrgsbase\twrgsbasel\twrgsbaseq\005wrmsr\006xabort\010xacquire\004x"
    "add\005xaddb\005xaddl\005xaddq\005xaddw\006xbegin\004xchg\005xchgb\005x"
    "chgl\005xchgq\005xchgw\txcryptcbc\txcryptcfb\txcryptctr\txcryptecb\txcr"
    "yptofb\004xend\006xgetbv\005xlatb\003xor\004xorb\004xorl\005xorpd\005xo"
    "rps\004xorq\004xorw\010xrelease\006xrstor\010xrstor64\007xrstorq\005xsa"
    "ve\007xsave64\010xsaveopt\nxsaveopt64\txsaveoptq\006xsaveq\006xsetbv\005"
    "xsha1\007xsha256\006xstore\txstorerng\005xtest";

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint8_t RequiredFeatures;
    uint8_t Classes[8];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace.

static const MatchEntry MatchTable0[] = {
  { 0 /* aaa */, X86::AAA, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 4 /* aad */, X86::AAD8i8, Convert__imm_10, 0, {  }, },
  { 4 /* aad */, X86::AAD8i8, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 8 /* aam */, X86::AAM8i8, Convert__imm_10, 0, {  }, },
  { 8 /* aam */, X86::AAM8i8, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 12 /* aas */, X86::AAS, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 20 /* adcb */, X86::ADC8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 20 /* adcb */, X86::ADC8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 20 /* adcb */, X86::ADC8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 20 /* adcb */, X86::ADC8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 20 /* adcb */, X86::ADC8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 20 /* adcb */, X86::ADC8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 25 /* adcl */, X86::ADC32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 25 /* adcl */, X86::ADC32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 25 /* adcl */, X86::ADC32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 25 /* adcl */, X86::ADC32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 25 /* adcl */, X86::ADC32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 25 /* adcl */, X86::ADC32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 25 /* adcl */, X86::ADC32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 25 /* adcl */, X86::ADC32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 30 /* adcq */, X86::ADC64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 30 /* adcq */, X86::ADC64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 30 /* adcq */, X86::ADC64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 30 /* adcq */, X86::ADC64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 30 /* adcq */, X86::ADC64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 30 /* adcq */, X86::ADC64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 30 /* adcq */, X86::ADC64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 30 /* adcq */, X86::ADC64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 35 /* adcw */, X86::ADC16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 35 /* adcw */, X86::ADC16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 35 /* adcw */, X86::ADC16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 35 /* adcw */, X86::ADC16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 35 /* adcw */, X86::ADC16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 35 /* adcw */, X86::ADC16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 35 /* adcw */, X86::ADC16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 35 /* adcw */, X86::ADC16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 45 /* adcxl */, X86::ADCX32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 45 /* adcxl */, X86::ADCX32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 51 /* adcxq */, X86::ADCX64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 51 /* adcxq */, X86::ADCX64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 61 /* addb */, X86::ADD8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 61 /* addb */, X86::ADD8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 61 /* addb */, X86::ADD8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 61 /* addb */, X86::ADD8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 61 /* addb */, X86::ADD8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 61 /* addb */, X86::ADD8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 66 /* addl */, X86::ADD32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 66 /* addl */, X86::ADD32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 66 /* addl */, X86::ADD32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 66 /* addl */, X86::ADD32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 66 /* addl */, X86::ADD32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 66 /* addl */, X86::ADD32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 66 /* addl */, X86::ADD32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 66 /* addl */, X86::ADD32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 71 /* addpd */, X86::ADDPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 71 /* addpd */, X86::ADDPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 77 /* addps */, X86::ADDPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 77 /* addps */, X86::ADDPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 83 /* addq */, X86::ADD64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 83 /* addq */, X86::ADD64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 83 /* addq */, X86::ADD64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 83 /* addq */, X86::ADD64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 83 /* addq */, X86::ADD64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 83 /* addq */, X86::ADD64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 83 /* addq */, X86::ADD64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 83 /* addq */, X86::ADD64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 88 /* addsd */, X86::ADDSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 88 /* addsd */, X86::ADDSDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 94 /* addss */, X86::ADDSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 94 /* addss */, X86::ADDSSrm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 100 /* addsubpd */, X86::ADDSUBPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 100 /* addsubpd */, X86::ADDSUBPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 109 /* addsubps */, X86::ADDSUBPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 109 /* addsubps */, X86::ADDSUBPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 118 /* addw */, X86::ADD16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 118 /* addw */, X86::ADD16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 118 /* addw */, X86::ADD16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 118 /* addw */, X86::ADD16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 118 /* addw */, X86::ADD16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 118 /* addw */, X86::ADD16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 118 /* addw */, X86::ADD16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 118 /* addw */, X86::ADD16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 128 /* adoxl */, X86::ADOX32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 128 /* adoxl */, X86::ADOX32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 134 /* adoxq */, X86::ADOX64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 134 /* adoxq */, X86::ADOX64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 140 /* aesdec */, X86::AESDECrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 140 /* aesdec */, X86::AESDECrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 147 /* aesdeclast */, X86::AESDECLASTrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 147 /* aesdeclast */, X86::AESDECLASTrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 158 /* aesenc */, X86::AESENCrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 158 /* aesenc */, X86::AESENCrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 165 /* aesenclast */, X86::AESENCLASTrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 165 /* aesenclast */, X86::AESENCLASTrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 176 /* aesimc */, X86::AESIMCrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 176 /* aesimc */, X86::AESIMCrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 183 /* aeskeygenassist */, X86::AESKEYGENASSIST128rr, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 183 /* aeskeygenassist */, X86::AESKEYGENASSIST128rm, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 203 /* andb */, X86::AND8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 203 /* andb */, X86::AND8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 203 /* andb */, X86::AND8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 203 /* andb */, X86::AND8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 203 /* andb */, X86::AND8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 203 /* andb */, X86::AND8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 208 /* andl */, X86::AND32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 208 /* andl */, X86::AND32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 208 /* andl */, X86::AND32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 208 /* andl */, X86::AND32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 208 /* andl */, X86::AND32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 208 /* andl */, X86::AND32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 208 /* andl */, X86::AND32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 208 /* andl */, X86::AND32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 218 /* andnl */, X86::ANDN32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 218 /* andnl */, X86::ANDN32rm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 224 /* andnpd */, X86::ANDNPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 224 /* andnpd */, X86::ANDNPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 231 /* andnps */, X86::ANDNPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 231 /* andnps */, X86::ANDNPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 238 /* andnq */, X86::ANDN64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 238 /* andnq */, X86::ANDN64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 244 /* andpd */, X86::ANDPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 244 /* andpd */, X86::ANDPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 250 /* andps */, X86::ANDPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 250 /* andps */, X86::ANDPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 256 /* andq */, X86::AND64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 256 /* andq */, X86::AND64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 256 /* andq */, X86::AND64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 256 /* andq */, X86::AND64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 256 /* andq */, X86::AND64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 256 /* andq */, X86::AND64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 256 /* andq */, X86::AND64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 256 /* andq */, X86::AND64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 261 /* andw */, X86::AND16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 261 /* andw */, X86::AND16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 261 /* andw */, X86::AND16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 261 /* andw */, X86::AND16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 261 /* andw */, X86::AND16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 261 /* andw */, X86::AND16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 261 /* andw */, X86::AND16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 261 /* andw */, X86::AND16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 266 /* arpl */, X86::ARPL16rr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 266 /* arpl */, X86::ARPL16mr, Convert__Mem165_1__Reg1_0, Feature_Not64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 271 /* bextr */, X86::BEXTRI64ri, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 271 /* bextr */, X86::BEXTRI64mi, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 271 /* bextr */, X86::BEXTRI32ri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 271 /* bextr */, X86::BEXTRI32mi, Convert__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 277 /* bextrl */, X86::BEXTR32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 277 /* bextrl */, X86::BEXTR32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 284 /* bextrq */, X86::BEXTR64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 284 /* bextrq */, X86::BEXTR64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 291 /* blcfill */, X86::BLCFILL32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 291 /* blcfill */, X86::BLCFILL64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 291 /* blcfill */, X86::BLCFILL32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 291 /* blcfill */, X86::BLCFILL64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 299 /* blci */, X86::BLCI32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 299 /* blci */, X86::BLCI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 299 /* blci */, X86::BLCI32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 299 /* blci */, X86::BLCI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 304 /* blcic */, X86::BLCIC32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 304 /* blcic */, X86::BLCIC64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 304 /* blcic */, X86::BLCIC32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 304 /* blcic */, X86::BLCIC64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 310 /* blcmsk */, X86::BLCMSK32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 310 /* blcmsk */, X86::BLCMSK64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 310 /* blcmsk */, X86::BLCMSK32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 310 /* blcmsk */, X86::BLCMSK64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 317 /* blcs */, X86::BLCS32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 317 /* blcs */, X86::BLCS64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 317 /* blcs */, X86::BLCS32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 317 /* blcs */, X86::BLCS64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 322 /* blendpd */, X86::BLENDPDrri, Convert__Reg1_2__Tie0__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32 }, },
  { 322 /* blendpd */, X86::BLENDPDrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32 }, },
  { 330 /* blendps */, X86::BLENDPSrri, Convert__Reg1_2__Tie0__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32 }, },
  { 330 /* blendps */, X86::BLENDPSrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32 }, },
  { 338 /* blendvpd */, X86::BLENDVPDrr0, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 338 /* blendvpd */, X86::BLENDVPDrm0, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 338 /* blendvpd */, X86::BLENDVPDrr0, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_XMM0, MCK_FR32, MCK_FR32 }, },
  { 338 /* blendvpd */, X86::BLENDVPDrm0, Convert__Reg1_2__Tie0__Mem1285_1, 0, { MCK_XMM0, MCK_Mem128, MCK_FR32 }, },
  { 347 /* blendvps */, X86::BLENDVPSrr0, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 347 /* blendvps */, X86::BLENDVPSrm0, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 347 /* blendvps */, X86::BLENDVPSrr0, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_XMM0, MCK_FR32, MCK_FR32 }, },
  { 347 /* blendvps */, X86::BLENDVPSrm0, Convert__Reg1_2__Tie0__Mem1285_1, 0, { MCK_XMM0, MCK_Mem128, MCK_FR32 }, },
  { 356 /* blsfill */, X86::BLSFILL32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 356 /* blsfill */, X86::BLSFILL64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 356 /* blsfill */, X86::BLSFILL32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 356 /* blsfill */, X86::BLSFILL64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 369 /* blsic */, X86::BLSIC32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 369 /* blsic */, X86::BLSIC64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 369 /* blsic */, X86::BLSIC32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 369 /* blsic */, X86::BLSIC64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 375 /* blsil */, X86::BLSI32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 375 /* blsil */, X86::BLSI32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 381 /* blsiq */, X86::BLSI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 381 /* blsiq */, X86::BLSI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 394 /* blsmskl */, X86::BLSMSK32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 394 /* blsmskl */, X86::BLSMSK32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 402 /* blsmskq */, X86::BLSMSK64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 402 /* blsmskq */, X86::BLSMSK64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 415 /* blsrl */, X86::BLSR32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 415 /* blsrl */, X86::BLSR32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 421 /* blsrq */, X86::BLSR64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 421 /* blsrq */, X86::BLSR64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 427 /* bound */, X86::BOUNDS16rm, Convert__Reg1_1__Mem165_0, Feature_Not64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 427 /* bound */, X86::BOUNDS32rm, Convert__Reg1_1__Mem325_0, Feature_Not64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 437 /* bsfl */, X86::BSF32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 437 /* bsfl */, X86::BSF32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 442 /* bsfq */, X86::BSF64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 442 /* bsfq */, X86::BSF64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 447 /* bsfw */, X86::BSF16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 447 /* bsfw */, X86::BSF16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 456 /* bsrl */, X86::BSR32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 456 /* bsrl */, X86::BSR32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 461 /* bsrq */, X86::BSR64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 461 /* bsrq */, X86::BSR64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 466 /* bsrw */, X86::BSR16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 466 /* bsrw */, X86::BSR16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 477 /* bswapl */, X86::BSWAP32r, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 484 /* bswapq */, X86::BSWAP64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 491 /* bt */, X86::BT32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 494 /* btc */, X86::BTC32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 498 /* btcl */, X86::BTC32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 498 /* btcl */, X86::BTC32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 498 /* btcl */, X86::BTC32ri8, Convert__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 498 /* btcl */, X86::BTC32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 503 /* btcq */, X86::BTC64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 503 /* btcq */, X86::BTC64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 503 /* btcq */, X86::BTC64ri8, Convert__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 503 /* btcq */, X86::BTC64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 508 /* btcw */, X86::BTC16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 508 /* btcw */, X86::BTC16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 508 /* btcw */, X86::BTC16ri8, Convert__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 508 /* btcw */, X86::BTC16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 513 /* btl */, X86::BT32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 513 /* btl */, X86::BT32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 513 /* btl */, X86::BT32ri8, Convert__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 513 /* btl */, X86::BT32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 517 /* btq */, X86::BT64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 517 /* btq */, X86::BT64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 517 /* btq */, X86::BT64ri8, Convert__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 517 /* btq */, X86::BT64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 521 /* btr */, X86::BTR32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 525 /* btrl */, X86::BTR32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 525 /* btrl */, X86::BTR32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 525 /* btrl */, X86::BTR32ri8, Convert__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 525 /* btrl */, X86::BTR32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 530 /* btrq */, X86::BTR64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 530 /* btrq */, X86::BTR64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 530 /* btrq */, X86::BTR64ri8, Convert__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 530 /* btrq */, X86::BTR64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 535 /* btrw */, X86::BTR16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 535 /* btrw */, X86::BTR16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 535 /* btrw */, X86::BTR16ri8, Convert__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 535 /* btrw */, X86::BTR16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 540 /* bts */, X86::BTS32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 544 /* btsl */, X86::BTS32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 544 /* btsl */, X86::BTS32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 544 /* btsl */, X86::BTS32ri8, Convert__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 544 /* btsl */, X86::BTS32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 549 /* btsq */, X86::BTS64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 549 /* btsq */, X86::BTS64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 549 /* btsq */, X86::BTS64ri8, Convert__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 549 /* btsq */, X86::BTS64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 554 /* btsw */, X86::BTS16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 554 /* btsw */, X86::BTS16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 554 /* btsw */, X86::BTS16ri8, Convert__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 554 /* btsw */, X86::BTS16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 559 /* btw */, X86::BT16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 559 /* btw */, X86::BT16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 559 /* btw */, X86::BT16ri8, Convert__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 559 /* btw */, X86::BT16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 568 /* bzhil */, X86::BZHI32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 568 /* bzhil */, X86::BZHI32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 574 /* bzhiq */, X86::BZHI64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 574 /* bzhiq */, X86::BZHI64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 580 /* call */, X86::CALL64m, Convert__Mem165_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 580 /* call */, X86::CALL32m, Convert__Mem165_1, Feature_In32BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 580 /* call */, X86::CALL16m, Convert__Mem165_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 580 /* call */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 580 /* call */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, Feature_Not16BitMode, { MCK_Imm, MCK_Imm }, },
  { 585 /* calll */, X86::CALLpcrel32, Convert__AbsMem1_0, Feature_Not64BitMode, { MCK_AbsMem }, },
  { 585 /* calll */, X86::CALL32r, Convert__Reg1_1, Feature_Not64BitMode, { MCK__STAR_, MCK_GR32 }, },
  { 585 /* calll */, X86::CALL32m, Convert__Mem325_1, Feature_Not64BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 585 /* calll */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 591 /* callq */, X86::CALL64pcrel32, Convert__AbsMem1_0, Feature_In64BitMode, { MCK_AbsMem }, },
  { 591 /* callq */, X86::CALL64r, Convert__Reg1_1, Feature_In64BitMode, { MCK__STAR_, MCK_GR64 }, },
  { 591 /* callq */, X86::CALL64m, Convert__Mem645_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 597 /* callw */, X86::CALLpcrel16, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 597 /* callw */, X86::CALL16r, Convert__Reg1_1, Feature_Not64BitMode, { MCK__STAR_, MCK_GR16 }, },
  { 597 /* callw */, X86::CALL16m, Convert__Mem165_1, Feature_Not64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 597 /* callw */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 603 /* cbtw */, X86::CBW, Convert_NoOperands, 0, {  }, },
  { 621 /* clac */, X86::CLAC, Convert_NoOperands, 0, {  }, },
  { 626 /* clc */, X86::CLC, Convert_NoOperands, 0, {  }, },
  { 630 /* cld */, X86::CLD, Convert_NoOperands, 0, {  }, },
  { 634 /* clflush */, X86::CLFLUSH, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 642 /* clgi */, X86::CLGI, Convert_NoOperands, 0, {  }, },
  { 647 /* cli */, X86::CLI, Convert_NoOperands, 0, {  }, },
  { 651 /* clrb */, X86::XOR8rr, Convert__Reg1_0__Tie0__Reg1_0, 0, { MCK_GR8 }, },
  { 656 /* clrl */, X86::XOR32rr, Convert__Reg1_0__Tie0__Reg1_0, 0, { MCK_GR32 }, },
  { 661 /* clrq */, X86::XOR64rr, Convert__Reg1_0__Tie0__Reg1_0, 0, { MCK_GR64 }, },
  { 666 /* clrw */, X86::XOR16rr, Convert__Reg1_0__Tie0__Reg1_0, 0, { MCK_GR16 }, },
  { 671 /* cltd */, X86::CDQ, Convert_NoOperands, 0, {  }, },
  { 676 /* cltq */, X86::CDQE, Convert_NoOperands, 0, {  }, },
  { 681 /* clts */, X86::CLTS, Convert_NoOperands, 0, {  }, },
  { 686 /* cmc */, X86::CMC, Convert_NoOperands, 0, {  }, },
  { 703 /* cmovael */, X86::CMOVAE32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 703 /* cmovael */, X86::CMOVAE32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 711 /* cmovaeq */, X86::CMOVAE64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 711 /* cmovaeq */, X86::CMOVAE64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 719 /* cmovaew */, X86::CMOVAE16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 719 /* cmovaew */, X86::CMOVAE16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 727 /* cmoval */, X86::CMOVA32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 727 /* cmoval */, X86::CMOVA32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 734 /* cmovaq */, X86::CMOVA64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 734 /* cmovaq */, X86::CMOVA64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 741 /* cmovaw */, X86::CMOVA16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 741 /* cmovaw */, X86::CMOVA16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 761 /* cmovbel */, X86::CMOVBE32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 761 /* cmovbel */, X86::CMOVBE32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 769 /* cmovbeq */, X86::CMOVBE64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 769 /* cmovbeq */, X86::CMOVBE64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 777 /* cmovbew */, X86::CMOVBE16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 777 /* cmovbew */, X86::CMOVBE16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 785 /* cmovbl */, X86::CMOVB32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 785 /* cmovbl */, X86::CMOVB32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 792 /* cmovbq */, X86::CMOVB64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 792 /* cmovbq */, X86::CMOVB64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 799 /* cmovbw */, X86::CMOVB16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 799 /* cmovbw */, X86::CMOVB16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 812 /* cmovel */, X86::CMOVE32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 812 /* cmovel */, X86::CMOVE32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 819 /* cmoveq */, X86::CMOVE64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 819 /* cmoveq */, X86::CMOVE64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 826 /* cmovew */, X86::CMOVE16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 826 /* cmovew */, X86::CMOVE16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 846 /* cmovgel */, X86::CMOVGE32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 846 /* cmovgel */, X86::CMOVGE32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 854 /* cmovgeq */, X86::CMOVGE64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 854 /* cmovgeq */, X86::CMOVGE64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 862 /* cmovgew */, X86::CMOVGE16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 862 /* cmovgew */, X86::CMOVGE16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 870 /* cmovgl */, X86::CMOVG32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 870 /* cmovgl */, X86::CMOVG32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 877 /* cmovgq */, X86::CMOVG64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 877 /* cmovgq */, X86::CMOVG64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 884 /* cmovgw */, X86::CMOVG16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 884 /* cmovgw */, X86::CMOVG16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 904 /* cmovlel */, X86::CMOVLE32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 904 /* cmovlel */, X86::CMOVLE32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 912 /* cmovleq */, X86::CMOVLE64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 912 /* cmovleq */, X86::CMOVLE64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 920 /* cmovlew */, X86::CMOVLE16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 920 /* cmovlew */, X86::CMOVLE16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 928 /* cmovll */, X86::CMOVL32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 928 /* cmovll */, X86::CMOVL32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 935 /* cmovlq */, X86::CMOVL64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 935 /* cmovlq */, X86::CMOVL64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 942 /* cmovlw */, X86::CMOVL16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 942 /* cmovlw */, X86::CMOVL16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 956 /* cmovnel */, X86::CMOVNE32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 956 /* cmovnel */, X86::CMOVNE32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 964 /* cmovneq */, X86::CMOVNE64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 964 /* cmovneq */, X86::CMOVNE64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 972 /* cmovnew */, X86::CMOVNE16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 972 /* cmovnew */, X86::CMOVNE16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 987 /* cmovnol */, X86::CMOVNO32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 987 /* cmovnol */, X86::CMOVNO32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 995 /* cmovnoq */, X86::CMOVNO64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 995 /* cmovnoq */, X86::CMOVNO64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1003 /* cmovnow */, X86::CMOVNO16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1003 /* cmovnow */, X86::CMOVNO16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1018 /* cmovnpl */, X86::CMOVNP32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1018 /* cmovnpl */, X86::CMOVNP32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1026 /* cmovnpq */, X86::CMOVNP64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1026 /* cmovnpq */, X86::CMOVNP64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1034 /* cmovnpw */, X86::CMOVNP16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1034 /* cmovnpw */, X86::CMOVNP16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1049 /* cmovnsl */, X86::CMOVNS32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1049 /* cmovnsl */, X86::CMOVNS32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1057 /* cmovnsq */, X86::CMOVNS64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1057 /* cmovnsq */, X86::CMOVNS64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1065 /* cmovnsw */, X86::CMOVNS16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1065 /* cmovnsw */, X86::CMOVNS16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1079 /* cmovol */, X86::CMOVO32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1079 /* cmovol */, X86::CMOVO32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1086 /* cmovoq */, X86::CMOVO64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1086 /* cmovoq */, X86::CMOVO64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1093 /* cmovow */, X86::CMOVO16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1093 /* cmovow */, X86::CMOVO16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1106 /* cmovpl */, X86::CMOVP32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1106 /* cmovpl */, X86::CMOVP32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1113 /* cmovpq */, X86::CMOVP64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1113 /* cmovpq */, X86::CMOVP64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1120 /* cmovpw */, X86::CMOVP16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1120 /* cmovpw */, X86::CMOVP16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1133 /* cmovsl */, X86::CMOVS32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1133 /* cmovsl */, X86::CMOVS32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1140 /* cmovsq */, X86::CMOVS64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1140 /* cmovsq */, X86::CMOVS64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1147 /* cmovsw */, X86::CMOVS16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1147 /* cmovsw */, X86::CMOVS16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1154 /* cmp */, X86::CMPPDrri, Convert__Reg1_3__Tie0__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_FR32, MCK_FR32 }, },
  { 1154 /* cmp */, X86::CMPPDrmi, Convert__Reg1_3__Tie0__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem128, MCK_FR32 }, },
  { 1154 /* cmp */, X86::CMPPSrri, Convert__Reg1_3__Tie0__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_FR32, MCK_FR32 }, },
  { 1154 /* cmp */, X86::CMPPSrmi, Convert__Reg1_3__Tie0__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem128, MCK_FR32 }, },
  { 1154 /* cmp */, X86::CMPSDrr, Convert__Reg1_3__Tie0__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_FR32, MCK_FR32 }, },
  { 1154 /* cmp */, X86::CMPSDrm, Convert__Reg1_3__Tie0__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_Mem64, MCK_FR32 }, },
  { 1154 /* cmp */, X86::CMPSSrr, Convert__Reg1_3__Tie0__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_FR32, MCK_FR32 }, },
  { 1154 /* cmp */, X86::CMPSSrm, Convert__Reg1_3__Tie0__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_Mem32, MCK_FR32 }, },
  { 1158 /* cmpb */, X86::CMP8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 1158 /* cmpb */, X86::CMP8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 1158 /* cmpb */, X86::CMP8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 1158 /* cmpb */, X86::CMP8ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 1158 /* cmpb */, X86::CMP8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 1158 /* cmpb */, X86::CMP8rm, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 1163 /* cmpl */, X86::CMP32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1163 /* cmpl */, X86::CMP32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1163 /* cmpl */, X86::CMP32ri8, Convert__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1163 /* cmpl */, X86::CMP32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1163 /* cmpl */, X86::CMP32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 1163 /* cmpl */, X86::CMP32ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 1163 /* cmpl */, X86::CMP32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 1163 /* cmpl */, X86::CMP32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1168 /* cmppd */, X86::CMPPDrri_alt, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 1168 /* cmppd */, X86::CMPPDrmi_alt, Convert__Reg1_2__Tie0__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 1174 /* cmpps */, X86::CMPPSrri_alt, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 1174 /* cmpps */, X86::CMPPSrmi_alt, Convert__Reg1_2__Tie0__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 1180 /* cmpq */, X86::CMP64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1180 /* cmpq */, X86::CMP64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1180 /* cmpq */, X86::CMP64ri8, Convert__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1180 /* cmpq */, X86::CMP64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1180 /* cmpq */, X86::CMP64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 1180 /* cmpq */, X86::CMP64ri32, Convert__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1180 /* cmpq */, X86::CMP64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1180 /* cmpq */, X86::CMP64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1185 /* cmpsb */, X86::CMPSB, Convert__DstIdx81_0__SrcIdx82_1, 0, { MCK_DstIdx8, MCK_SrcIdx8 }, },
  { 1191 /* cmpsd */, X86::CMPSDrr_alt, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 1191 /* cmpsd */, X86::CMPSDrm_alt, Convert__Reg1_2__Tie0__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64, MCK_FR32 }, },
  { 1197 /* cmpsl */, X86::CMPSL, Convert__DstIdx321_0__SrcIdx322_1, 0, { MCK_DstIdx32, MCK_SrcIdx32 }, },
  { 1203 /* cmpsq */, X86::CMPSQ, Convert__DstIdx641_0__SrcIdx642_1, 0, { MCK_DstIdx64, MCK_SrcIdx64 }, },
  { 1209 /* cmpss */, X86::CMPSSrr_alt, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 1209 /* cmpss */, X86::CMPSSrm_alt, Convert__Reg1_2__Tie0__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_FR32 }, },
  { 1215 /* cmpsw */, X86::CMPSW, Convert__DstIdx161_0__SrcIdx162_1, 0, { MCK_DstIdx16, MCK_SrcIdx16 }, },
  { 1221 /* cmpw */, X86::CMP16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1221 /* cmpw */, X86::CMP16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 1221 /* cmpw */, X86::CMP16ri8, Convert__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1221 /* cmpw */, X86::CMP16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1221 /* cmpw */, X86::CMP16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 1221 /* cmpw */, X86::CMP16ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 1221 /* cmpw */, X86::CMP16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 1221 /* cmpw */, X86::CMP16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1234 /* cmpxchg16b */, X86::CMPXCHG16B, Convert__Mem1285_0, 0, { MCK_Mem128 }, },
  { 1245 /* cmpxchg8b */, X86::CMPXCHG8B, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1255 /* cmpxchgb */, X86::CMPXCHG8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 1255 /* cmpxchgb */, X86::CMPXCHG8rm, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 1264 /* cmpxchgl */, X86::CMPXCHG32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1264 /* cmpxchgl */, X86::CMPXCHG32rm, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1273 /* cmpxchgq */, X86::CMPXCHG64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1273 /* cmpxchgq */, X86::CMPXCHG64rm, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1282 /* cmpxchgw */, X86::CMPXCHG16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1282 /* cmpxchgw */, X86::CMPXCHG16rm, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 1291 /* comisd */, X86::COMISDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1291 /* comisd */, X86::COMISDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1298 /* comiss */, X86::COMISSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1298 /* comiss */, X86::COMISSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1305 /* cpuid */, X86::CPUID32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 1305 /* cpuid */, X86::CPUID64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 1315 /* cqto */, X86::CQO, Convert_NoOperands, 0, {  }, },
  { 1326 /* crc32b */, X86::CRC32r32r8, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 1326 /* crc32b */, X86::CRC32r64r8, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 1326 /* crc32b */, X86::CRC32r32m8, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR32 }, },
  { 1326 /* crc32b */, X86::CRC32r64m8, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR64 }, },
  { 1333 /* crc32l */, X86::CRC32r32r32, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1333 /* crc32l */, X86::CRC32r32m32, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1340 /* crc32q */, X86::CRC32r64r64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1340 /* crc32q */, X86::CRC32r64m64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1347 /* crc32w */, X86::CRC32r32r16, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 1347 /* crc32w */, X86::CRC32r32m16, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 1354 /* cs */, X86::CS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1357 /* cvtdq2pd */, X86::CVTDQ2PDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1357 /* cvtdq2pd */, X86::CVTDQ2PDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1366 /* cvtdq2ps */, X86::CVTDQ2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1366 /* cvtdq2ps */, X86::CVTDQ2PSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1375 /* cvtpd2dq */, X86::CVTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1375 /* cvtpd2dq */, X86::CVTPD2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1384 /* cvtpd2pi */, X86::MMX_CVTPD2PIirr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 1384 /* cvtpd2pi */, X86::MMX_CVTPD2PIirm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR64 }, },
  { 1393 /* cvtpd2ps */, X86::CVTPD2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1393 /* cvtpd2ps */, X86::CVTPD2PSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1402 /* cvtpi2pd */, X86::MMX_CVTPI2PDirr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_FR32 }, },
  { 1402 /* cvtpi2pd */, X86::MMX_CVTPI2PDirm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1411 /* cvtpi2ps */, X86::MMX_CVTPI2PSirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_FR32 }, },
  { 1411 /* cvtpi2ps */, X86::MMX_CVTPI2PSirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1420 /* cvtps2dq */, X86::CVTPS2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1420 /* cvtps2dq */, X86::CVTPS2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1429 /* cvtps2pd */, X86::CVTPS2PDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1429 /* cvtps2pd */, X86::CVTPS2PDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1438 /* cvtps2pi */, X86::MMX_CVTPS2PIirr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 1438 /* cvtps2pi */, X86::MMX_CVTPS2PIirm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 1447 /* cvtsd2si */, X86::CVTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1447 /* cvtsd2si */, X86::CVTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1447 /* cvtsd2si */, X86::CVTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 1447 /* cvtsd2si */, X86::CVTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1456 /* cvtsd2sil */, X86::CVTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1456 /* cvtsd2sil */, X86::CVTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 1466 /* cvtsd2siq */, X86::CVTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1466 /* cvtsd2siq */, X86::CVTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1476 /* cvtsd2ss */, X86::CVTSD2SSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1476 /* cvtsd2ss */, X86::CVTSD2SSrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1485 /* cvtsi2sd */, X86::CVTSI2SDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1494 /* cvtsi2sdl */, X86::CVTSI2SDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32 }, },
  { 1494 /* cvtsi2sdl */, X86::CVTSI2SDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1504 /* cvtsi2sdq */, X86::CVTSI2SD64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 1504 /* cvtsi2sdq */, X86::CVTSI2SD64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1514 /* cvtsi2ss */, X86::CVTSI2SSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1523 /* cvtsi2ssl */, X86::CVTSI2SSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32 }, },
  { 1523 /* cvtsi2ssl */, X86::CVTSI2SSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1533 /* cvtsi2ssq */, X86::CVTSI2SS64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 1533 /* cvtsi2ssq */, X86::CVTSI2SS64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1543 /* cvtss2sd */, X86::CVTSS2SDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1543 /* cvtss2sd */, X86::CVTSS2SDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1552 /* cvtss2si */, X86::CVTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1552 /* cvtss2si */, X86::CVTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1552 /* cvtss2si */, X86::CVTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1552 /* cvtss2si */, X86::CVTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 1561 /* cvtss2sil */, X86::CVTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1561 /* cvtss2sil */, X86::CVTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1571 /* cvtss2siq */, X86::CVTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1571 /* cvtss2siq */, X86::CVTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 1581 /* cvttpd2dq */, X86::CVTTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1581 /* cvttpd2dq */, X86::CVTTPD2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1591 /* cvttpd2pi */, X86::MMX_CVTTPD2PIirr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 1591 /* cvttpd2pi */, X86::MMX_CVTTPD2PIirm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR64 }, },
  { 1601 /* cvttps2dq */, X86::CVTTPS2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1601 /* cvttps2dq */, X86::CVTTPS2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1611 /* cvttps2pi */, X86::MMX_CVTTPS2PIirr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 1611 /* cvttps2pi */, X86::MMX_CVTTPS2PIirm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 1621 /* cvttsd2si */, X86::CVTTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1621 /* cvttsd2si */, X86::CVTTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1621 /* cvttsd2si */, X86::CVTTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 1621 /* cvttsd2si */, X86::CVTTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1631 /* cvttsd2sil */, X86::CVTTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1631 /* cvttsd2sil */, X86::CVTTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 1642 /* cvttsd2siq */, X86::CVTTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1642 /* cvttsd2siq */, X86::CVTTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1653 /* cvttss2si */, X86::CVTTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1653 /* cvttss2si */, X86::CVTTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1653 /* cvttss2si */, X86::CVTTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1653 /* cvttss2si */, X86::CVTTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 1663 /* cvttss2sil */, X86::CVTTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1663 /* cvttss2sil */, X86::CVTTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1674 /* cvttss2siq */, X86::CVTTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1674 /* cvttss2siq */, X86::CVTTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 1694 /* cwtd */, X86::CWD, Convert_NoOperands, 0, {  }, },
  { 1699 /* cwtl */, X86::CWDE, Convert_NoOperands, 0, {  }, },
  { 1704 /* daa */, X86::DAA, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 1708 /* das */, X86::DAS, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 1712 /* data16 */, X86::DATA16_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1723 /* decb */, X86::DEC8r, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 1723 /* decb */, X86::DEC8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 1728 /* decl */, X86::DEC32r, Convert__Reg1_0__Tie0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 1728 /* decl */, X86::DEC64_32r, Convert__Reg1_0__Tie0, Feature_In64BitMode, { MCK_GR32 }, },
  { 1728 /* decl */, X86::DEC32m, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 1728 /* decl */, X86::DEC64_32m, Convert__Mem325_0, Feature_In64BitMode, { MCK_Mem32 }, },
  { 1733 /* decq */, X86::DEC64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 1733 /* decq */, X86::DEC64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1738 /* decw */, X86::DEC16r, Convert__Reg1_0__Tie0, Feature_Not64BitMode, { MCK_GR16 }, },
  { 1738 /* decw */, X86::DEC64_16r, Convert__Reg1_0__Tie0, Feature_In64BitMode, { MCK_GR16 }, },
  { 1738 /* decw */, X86::DEC16m, Convert__Mem165_0, Feature_Not64BitMode, { MCK_Mem16 }, },
  { 1738 /* decw */, X86::DEC64_16m, Convert__Mem165_0, Feature_In64BitMode, { MCK_Mem16 }, },
  { 1747 /* divb */, X86::DIV8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 1747 /* divb */, X86::DIV8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 1747 /* divb */, X86::DIV8r, Convert__Reg1_0, 0, { MCK_GR8, MCK_AL }, },
  { 1747 /* divb */, X86::DIV8m, Convert__Mem85_0, 0, { MCK_Mem8, MCK_AL }, },
  { 1752 /* divl */, X86::DIV32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 1752 /* divl */, X86::DIV32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1752 /* divl */, X86::DIV32r, Convert__Reg1_0, 0, { MCK_GR32, MCK_EAX }, },
  { 1752 /* divl */, X86::DIV32m, Convert__Mem325_0, 0, { MCK_Mem32, MCK_EAX }, },
  { 1757 /* divpd */, X86::DIVPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1757 /* divpd */, X86::DIVPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1763 /* divps */, X86::DIVPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1763 /* divps */, X86::DIVPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1769 /* divq */, X86::DIV64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 1769 /* divq */, X86::DIV64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1769 /* divq */, X86::DIV64r, Convert__Reg1_0, 0, { MCK_GR64, MCK_RAX }, },
  { 1769 /* divq */, X86::DIV64m, Convert__Mem645_0, 0, { MCK_Mem64, MCK_RAX }, },
  { 1774 /* divsd */, X86::DIVSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1774 /* divsd */, X86::DIVSDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1780 /* divss */, X86::DIVSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1780 /* divss */, X86::DIVSSrm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1786 /* divw */, X86::DIV16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 1786 /* divw */, X86::DIV16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 1786 /* divw */, X86::DIV16r, Convert__Reg1_0, 0, { MCK_GR16, MCK_AX }, },
  { 1786 /* divw */, X86::DIV16m, Convert__Mem165_0, 0, { MCK_Mem16, MCK_AX }, },
  { 1791 /* dppd */, X86::DPPDrri, Convert__Reg1_2__Tie0__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32 }, },
  { 1791 /* dppd */, X86::DPPDrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32 }, },
  { 1796 /* dpps */, X86::DPPSrri, Convert__Reg1_2__Tie0__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32 }, },
  { 1796 /* dpps */, X86::DPPSrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32 }, },
  { 1801 /* ds */, X86::DS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1804 /* emms */, X86::MMX_EMMS, Convert_NoOperands, 0, {  }, },
  { 1809 /* enter */, X86::ENTER, Convert__Imm1_0__Imm1_1, 0, { MCK_Imm, MCK_Imm }, },
  { 1815 /* es */, X86::ES_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1818 /* extractps */, X86::EXTRACTPSrr, Convert__GR32orGR641_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_GR32orGR64 }, },
  { 1818 /* extractps */, X86::EXTRACTPSmr, Convert__Mem325_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_Mem32 }, },
  { 1828 /* extrq */, X86::EXTRQ, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1828 /* extrq */, X86::EXTRQI, Convert__Reg1_2__Tie0__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm, MCK_FR32 }, },
  { 1834 /* f2xm1 */, X86::F2XM1, Convert_NoOperands, 0, {  }, },
  { 1840 /* fabs */, X86::ABS_F, Convert_NoOperands, 0, {  }, },
  { 1845 /* fadd */, X86::ADD_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1845 /* fadd */, X86::ADD_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 1845 /* fadd */, X86::ADD_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1845 /* fadd */, X86::ADD_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1850 /* faddl */, X86::ADD_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1856 /* faddp */, X86::ADD_FPrST0, Convert__regST1, 0, {  }, },
  { 1856 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1856 /* faddp */, X86::ADD_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 1856 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1856 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1862 /* fadds */, X86::ADD_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1868 /* fbld */, X86::FBLDm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1873 /* fbstp */, X86::FBSTPm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1879 /* fchs */, X86::CHS_F, Convert_NoOperands, 0, {  }, },
  { 1884 /* fcmovb */, X86::CMOVB_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1891 /* fcmovbe */, X86::CMOVBE_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1899 /* fcmove */, X86::CMOVE_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1906 /* fcmovnb */, X86::CMOVNB_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1914 /* fcmovnbe */, X86::CMOVNBE_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1923 /* fcmovne */, X86::CMOVNE_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1931 /* fcmovnu */, X86::CMOVNP_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1939 /* fcmovu */, X86::CMOVP_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1946 /* fcom */, X86::COM_FST0r, Convert__regST1, 0, {  }, },
  { 1946 /* fcom */, X86::COM_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1951 /* fcomi */, X86::COM_FIr, Convert__regST1, 0, {  }, },
  { 1951 /* fcomi */, X86::COM_FIr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1951 /* fcomi */, X86::COM_FIr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 1951 /* fcomi */, X86::COM_FIr, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1957 /* fcoml */, X86::FCOM64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1963 /* fcomp */, X86::COMP_FST0r, Convert__regST1, 0, {  }, },
  { 1963 /* fcomp */, X86::COMP_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1969 /* fcompi */, X86::COM_FIPr, Convert__regST1, 0, {  }, },
  { 1969 /* fcompi */, X86::COM_FIPr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1969 /* fcompi */, X86::COM_FIPr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 1969 /* fcompi */, X86::COM_FIPr, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1976 /* fcompl */, X86::FCOMP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1983 /* fcompp */, X86::FCOMPP, Convert_NoOperands, 0, {  }, },
  { 1990 /* fcomps */, X86::FCOMP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1997 /* fcoms */, X86::FCOM32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2003 /* fcos */, X86::COS_F, Convert_NoOperands, 0, {  }, },
  { 2008 /* fdecstp */, X86::FDECSTP, Convert_NoOperands, 0, {  }, },
  { 2016 /* fdiv */, X86::DIV_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2016 /* fdiv */, X86::DIV_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2016 /* fdiv */, X86::DIVR_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2016 /* fdiv */, X86::DIV_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2021 /* fdivl */, X86::DIV_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2027 /* fdivp */, X86::DIVR_FPrST0, Convert__regST1, 0, {  }, },
  { 2027 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2027 /* fdivp */, X86::DIVR_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2027 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2027 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2033 /* fdivr */, X86::DIVR_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2033 /* fdivr */, X86::DIVR_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2033 /* fdivr */, X86::DIV_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2033 /* fdivr */, X86::DIVR_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2039 /* fdivrl */, X86::DIVR_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2046 /* fdivrp */, X86::DIV_FPrST0, Convert__regST1, 0, {  }, },
  { 2046 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2046 /* fdivrp */, X86::DIV_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2046 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2046 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2053 /* fdivrs */, X86::DIVR_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2060 /* fdivs */, X86::DIV_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2066 /* femms */, X86::FEMMS, Convert_NoOperands, 0, {  }, },
  { 2072 /* ffree */, X86::FFREE, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2084 /* fiaddl */, X86::ADD_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2091 /* fiadds */, X86::ADD_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2104 /* ficoml */, X86::FICOM32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2118 /* ficompl */, X86::FICOMP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2126 /* ficomps */, X86::FICOMP16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2134 /* ficoms */, X86::FICOM16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2147 /* fidivl */, X86::DIV_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2161 /* fidivrl */, X86::DIVR_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2169 /* fidivrs */, X86::DIVR_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2177 /* fidivs */, X86::DIV_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2189 /* fildl */, X86::ILD_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2195 /* fildll */, X86::ILD_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2202 /* filds */, X86::ILD_F16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2214 /* fimull */, X86::MUL_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2221 /* fimuls */, X86::MUL_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2228 /* fincstp */, X86::FINCSTP, Convert_NoOperands, 0, {  }, },
  { 2241 /* fistl */, X86::IST_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2253 /* fistpl */, X86::IST_FP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2260 /* fistpll */, X86::IST_FP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2268 /* fistps */, X86::IST_FP16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2275 /* fists */, X86::IST_F16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2288 /* fisttpl */, X86::ISTT_FP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2296 /* fisttpll */, X86::ISTT_FP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2305 /* fisttps */, X86::ISTT_FP16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2319 /* fisubl */, X86::SUB_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2333 /* fisubrl */, X86::SUBR_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2341 /* fisubrs */, X86::SUBR_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2349 /* fisubs */, X86::SUB_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2356 /* fld */, X86::LD_Frr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2360 /* fld1 */, X86::LD_F1, Convert_NoOperands, 0, {  }, },
  { 2365 /* fldcw */, X86::FLDCW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2371 /* fldenv */, X86::FLDENVm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2378 /* fldl */, X86::LD_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2383 /* fldl2e */, X86::FLDL2E, Convert_NoOperands, 0, {  }, },
  { 2390 /* fldl2t */, X86::FLDL2T, Convert_NoOperands, 0, {  }, },
  { 2397 /* fldlg2 */, X86::FLDLG2, Convert_NoOperands, 0, {  }, },
  { 2404 /* fldln2 */, X86::FLDLN2, Convert_NoOperands, 0, {  }, },
  { 2411 /* fldpi */, X86::FLDPI, Convert_NoOperands, 0, {  }, },
  { 2417 /* flds */, X86::LD_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2422 /* fldt */, X86::LD_F80m, Convert__Mem805_0, 0, { MCK_Mem80 }, },
  { 2427 /* fldz */, X86::LD_F0, Convert_NoOperands, 0, {  }, },
  { 2432 /* fmul */, X86::MUL_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2432 /* fmul */, X86::MUL_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2432 /* fmul */, X86::MUL_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2432 /* fmul */, X86::MUL_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2437 /* fmull */, X86::MUL_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2443 /* fmulp */, X86::MUL_FPrST0, Convert__regST1, 0, {  }, },
  { 2443 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2443 /* fmulp */, X86::MUL_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2443 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2443 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2449 /* fmuls */, X86::MUL_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2455 /* fnclex */, X86::FNCLEX, Convert_NoOperands, 0, {  }, },
  { 2462 /* fninit */, X86::FNINIT, Convert_NoOperands, 0, {  }, },
  { 2469 /* fnop */, X86::FNOP, Convert_NoOperands, 0, {  }, },
  { 2474 /* fnsave */, X86::FSAVEm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2481 /* fnstcw */, X86::FNSTCW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2488 /* fnstenv */, X86::FSTENVm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2496 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, {  }, },
  { 2496 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, { MCK_AL }, },
  { 2496 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, { MCK_AX }, },
  { 2496 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, { MCK_EAX }, },
  { 2496 /* fnstsw */, X86::FNSTSWm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2503 /* fpatan */, X86::FPATAN, Convert_NoOperands, 0, {  }, },
  { 2510 /* fprem */, X86::FPREM, Convert_NoOperands, 0, {  }, },
  { 2516 /* fprem1 */, X86::FPREM1, Convert_NoOperands, 0, {  }, },
  { 2523 /* fptan */, X86::FPTAN, Convert_NoOperands, 0, {  }, },
  { 2529 /* frndint */, X86::FRNDINT, Convert_NoOperands, 0, {  }, },
  { 2537 /* frstor */, X86::FRSTORm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2544 /* fs */, X86::FS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 2547 /* fscale */, X86::FSCALE, Convert_NoOperands, 0, {  }, },
  { 2554 /* fsin */, X86::SIN_F, Convert_NoOperands, 0, {  }, },
  { 2559 /* fsincos */, X86::FSINCOS, Convert_NoOperands, 0, {  }, },
  { 2567 /* fsqrt */, X86::SQRT_F, Convert_NoOperands, 0, {  }, },
  { 2573 /* fst */, X86::ST_Frr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2577 /* fstl */, X86::ST_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2582 /* fstp */, X86::ST_FPrr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2587 /* fstpl */, X86::ST_FP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2593 /* fstps */, X86::ST_FP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2599 /* fstpt */, X86::ST_FP80m, Convert__Mem805_0, 0, { MCK_Mem80 }, },
  { 2605 /* fsts */, X86::ST_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2610 /* fsub */, X86::SUB_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2610 /* fsub */, X86::SUB_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2610 /* fsub */, X86::SUBR_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2610 /* fsub */, X86::SUB_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2615 /* fsubl */, X86::SUB_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2621 /* fsubp */, X86::SUBR_FPrST0, Convert__regST1, 0, {  }, },
  { 2621 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2621 /* fsubp */, X86::SUBR_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2621 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2621 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2627 /* fsubr */, X86::SUBR_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2627 /* fsubr */, X86::SUBR_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2627 /* fsubr */, X86::SUB_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2627 /* fsubr */, X86::SUBR_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2633 /* fsubrl */, X86::SUBR_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2640 /* fsubrp */, X86::SUB_FPrST0, Convert__regST1, 0, {  }, },
  { 2640 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2640 /* fsubrp */, X86::SUB_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2640 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2640 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2647 /* fsubrs */, X86::SUBR_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2654 /* fsubs */, X86::SUB_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2660 /* ftst */, X86::TST_F, Convert_NoOperands, 0, {  }, },
  { 2665 /* fucom */, X86::UCOM_Fr, Convert__regST1, 0, {  }, },
  { 2665 /* fucom */, X86::UCOM_Fr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2671 /* fucomi */, X86::UCOM_FIr, Convert__regST1, 0, {  }, },
  { 2671 /* fucomi */, X86::UCOM_FIr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2671 /* fucomi */, X86::UCOM_FIr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2671 /* fucomi */, X86::UCOM_FIr, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2678 /* fucomp */, X86::UCOM_FPr, Convert__regST1, 0, {  }, },
  { 2678 /* fucomp */, X86::UCOM_FPr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2685 /* fucompi */, X86::UCOM_FIPr, Convert__regST1, 0, {  }, },
  { 2685 /* fucompi */, X86::UCOM_FIPr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2685 /* fucompi */, X86::UCOM_FIPr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2685 /* fucompi */, X86::UCOM_FIPr, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2693 /* fucompp */, X86::UCOM_FPPr, Convert_NoOperands, 0, {  }, },
  { 2701 /* fxam */, X86::FXAM, Convert_NoOperands, 0, {  }, },
  { 2706 /* fxch */, X86::XCH_F, Convert__regST1, 0, {  }, },
  { 2706 /* fxch */, X86::XCH_F, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2711 /* fxrstor */, X86::FXRSTOR, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 2729 /* fxrstorq */, X86::FXRSTOR64, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 2738 /* fxsave */, X86::FXSAVE, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 2754 /* fxsaveq */, X86::FXSAVE64, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 2762 /* fxtract */, X86::FXTRACT, Convert_NoOperands, 0, {  }, },
  { 2770 /* fyl2x */, X86::FYL2X, Convert_NoOperands, 0, {  }, },
  { 2776 /* fyl2xp1 */, X86::FYL2XP1, Convert_NoOperands, 0, {  }, },
  { 2784 /* gs */, X86::GS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 2787 /* haddpd */, X86::HADDPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 2787 /* haddpd */, X86::HADDPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 2794 /* haddps */, X86::HADDPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 2794 /* haddps */, X86::HADDPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 2801 /* hlt */, X86::HLT, Convert_NoOperands, 0, {  }, },
  { 2805 /* hsubpd */, X86::HSUBPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 2805 /* hsubpd */, X86::HSUBPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 2812 /* hsubps */, X86::HSUBPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 2812 /* hsubps */, X86::HSUBPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 2824 /* idivb */, X86::IDIV8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 2824 /* idivb */, X86::IDIV8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 2824 /* idivb */, X86::IDIV8r, Convert__Reg1_0, 0, { MCK_GR8, MCK_AL }, },
  { 2824 /* idivb */, X86::IDIV8m, Convert__Mem85_0, 0, { MCK_Mem8, MCK_AL }, },
  { 2830 /* idivl */, X86::IDIV32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 2830 /* idivl */, X86::IDIV32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2830 /* idivl */, X86::IDIV32r, Convert__Reg1_0, 0, { MCK_GR32, MCK_EAX }, },
  { 2830 /* idivl */, X86::IDIV32m, Convert__Mem325_0, 0, { MCK_Mem32, MCK_EAX }, },
  { 2836 /* idivq */, X86::IDIV64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 2836 /* idivq */, X86::IDIV64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2836 /* idivq */, X86::IDIV64r, Convert__Reg1_0, 0, { MCK_GR64, MCK_RAX }, },
  { 2836 /* idivq */, X86::IDIV64m, Convert__Mem645_0, 0, { MCK_Mem64, MCK_RAX }, },
  { 2842 /* idivw */, X86::IDIV16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 2842 /* idivw */, X86::IDIV16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2842 /* idivw */, X86::IDIV16r, Convert__Reg1_0, 0, { MCK_GR16, MCK_AX }, },
  { 2842 /* idivw */, X86::IDIV16m, Convert__Mem165_0, 0, { MCK_Mem16, MCK_AX }, },
  { 2853 /* imulb */, X86::IMUL8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 2853 /* imulb */, X86::IMUL8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 2859 /* imull */, X86::IMUL32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 2859 /* imull */, X86::IMUL32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2859 /* imull */, X86::IMUL32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 2859 /* imull */, X86::IMUL32rri8, Convert__Reg1_1__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 2859 /* imull */, X86::IMUL32rri, Convert__Reg1_1__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 2859 /* imull */, X86::IMUL32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 2859 /* imull */, X86::IMUL32rri8, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32, MCK_GR32 }, },
  { 2859 /* imull */, X86::IMUL32rmi8, Convert__Reg1_2__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32, MCK_GR32 }, },
  { 2859 /* imull */, X86::IMUL32rri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 2859 /* imull */, X86::IMUL32rmi, Convert__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 2865 /* imulq */, X86::IMUL64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 2865 /* imulq */, X86::IMUL64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2865 /* imulq */, X86::IMUL64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 2865 /* imulq */, X86::IMUL64rri8, Convert__Reg1_1__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 2865 /* imulq */, X86::IMUL64rri32, Convert__Reg1_1__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 2865 /* imulq */, X86::IMUL64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 2865 /* imulq */, X86::IMUL64rri8, Convert__Reg1_2__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64, MCK_GR64 }, },
  { 2865 /* imulq */, X86::IMUL64rmi8, Convert__Reg1_2__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64, MCK_GR64 }, },
  { 2865 /* imulq */, X86::IMUL64rri32, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 2865 /* imulq */, X86::IMUL64rmi32, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 2871 /* imulw */, X86::IMUL16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 2871 /* imulw */, X86::IMUL16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2871 /* imulw */, X86::IMUL16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 2871 /* imulw */, X86::IMUL16rri8, Convert__Reg1_1__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 2871 /* imulw */, X86::IMUL16rri, Convert__Reg1_1__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 2871 /* imulw */, X86::IMUL16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 2871 /* imulw */, X86::IMUL16rri8, Convert__Reg1_2__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16, MCK_GR16 }, },
  { 2871 /* imulw */, X86::IMUL16rmi8, Convert__Reg1_2__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16, MCK_GR16 }, },
  { 2871 /* imulw */, X86::IMUL16rri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 2871 /* imulw */, X86::IMUL16rmi, Convert__Reg1_2__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16, MCK_GR16 }, },
  { 2880 /* inb */, X86::IN8rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 2880 /* inb */, X86::IN8ri, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 2880 /* inb */, X86::IN8rr, Convert_NoOperands, 0, { MCK_DX, MCK_AL }, },
  { 2880 /* inb */, X86::IN8ri, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 2888 /* incb */, X86::INC8r, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 2888 /* incb */, X86::INC8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 2893 /* incl */, X86::INC32r, Convert__Reg1_0__Tie0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 2893 /* incl */, X86::INC64_32r, Convert__Reg1_0__Tie0, Feature_In64BitMode, { MCK_GR32 }, },
  { 2893 /* incl */, X86::INC32m, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 2893 /* incl */, X86::INC64_32m, Convert__Mem325_0, Feature_In64BitMode, { MCK_Mem32 }, },
  { 2898 /* incq */, X86::INC64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 2898 /* incq */, X86::INC64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2903 /* incw */, X86::INC16r, Convert__Reg1_0__Tie0, Feature_Not64BitMode, { MCK_GR16 }, },
  { 2903 /* incw */, X86::INC64_16r, Convert__Reg1_0__Tie0, Feature_In64BitMode, { MCK_GR16 }, },
  { 2903 /* incw */, X86::INC16m, Convert__Mem165_0, Feature_Not64BitMode, { MCK_Mem16 }, },
  { 2903 /* incw */, X86::INC64_16m, Convert__Mem165_0, Feature_In64BitMode, { MCK_Mem16 }, },
  { 2908 /* inl */, X86::IN32rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 2908 /* inl */, X86::IN32ri, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 2908 /* inl */, X86::IN32rr, Convert_NoOperands, 0, { MCK_DX, MCK_EAX }, },
  { 2908 /* inl */, X86::IN32ri, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 2912 /* insb */, X86::INSB, Convert__DstIdx81_1, 0, { MCK_DX, MCK_DstIdx8 }, },
  { 2922 /* insertps */, X86::INSERTPSrr, Convert__Reg1_2__Tie0__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32 }, },
  { 2922 /* insertps */, X86::INSERTPSrm, Convert__Reg1_2__Tie0__Mem325_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem32, MCK_FR32 }, },
  { 2931 /* insertq */, X86::INSERTQ, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 2931 /* insertq */, X86::INSERTQI, Convert__Reg1_3__Tie0__Reg1_2__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 2939 /* insl */, X86::INSL, Convert__DstIdx321_1, 0, { MCK_DX, MCK_DstIdx32 }, },
  { 2944 /* insw */, X86::INSW, Convert__DstIdx161_1, 0, { MCK_DX, MCK_DstIdx16 }, },
  { 2949 /* int */, X86::INT, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 2953 /* int3 */, X86::INT3, Convert_NoOperands, 0, {  }, },
  { 2958 /* into */, X86::INTO, Convert_NoOperands, 0, {  }, },
  { 2963 /* invd */, X86::INVD, Convert_NoOperands, 0, {  }, },
  { 2968 /* invept */, X86::INVEPT32, Convert__Reg1_1__Mem1285_0, Feature_Not64BitMode, { MCK_Mem128, MCK_GR32 }, },
  { 2968 /* invept */, X86::INVEPT64, Convert__Reg1_1__Mem1285_0, Feature_In64BitMode, { MCK_Mem128, MCK_GR64 }, },
  { 2975 /* invlpg */, X86::INVLPG, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 2982 /* invlpga */, X86::INVLPGA32, Convert_NoOperands, Feature_Not64BitMode, { MCK_ECX, MCK_EAX }, },
  { 2982 /* invlpga */, X86::INVLPGA64, Convert_NoOperands, Feature_In64BitMode, { MCK_ECX, MCK_RAX }, },
  { 2990 /* invpcid */, X86::INVPCID32, Convert__Reg1_1__Mem1285_0, Feature_Not64BitMode, { MCK_Mem128, MCK_GR32 }, },
  { 2990 /* invpcid */, X86::INVPCID64, Convert__Reg1_1__Mem1285_0, Feature_In64BitMode, { MCK_Mem128, MCK_GR64 }, },
  { 2998 /* invvpid */, X86::INVVPID32, Convert__Reg1_1__Mem1285_0, Feature_Not64BitMode, { MCK_Mem128, MCK_GR32 }, },
  { 2998 /* invvpid */, X86::INVVPID64, Convert__Reg1_1__Mem1285_0, Feature_In64BitMode, { MCK_Mem128, MCK_GR64 }, },
  { 3006 /* inw */, X86::IN16rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 3006 /* inw */, X86::IN16ri, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 3006 /* inw */, X86::IN16rr, Convert_NoOperands, 0, { MCK_DX, MCK_AX }, },
  { 3006 /* inw */, X86::IN16ri, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 3021 /* iretl */, X86::IRET32, Convert_NoOperands, 0, {  }, },
  { 3027 /* iretq */, X86::IRET64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 3033 /* iretw */, X86::IRET16, Convert_NoOperands, 0, {  }, },
  { 3039 /* ja */, X86::JA_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3039 /* ja */, X86::JA_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3039 /* ja */, X86::JA_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3042 /* jae */, X86::JAE_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3042 /* jae */, X86::JAE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3042 /* jae */, X86::JAE_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3046 /* jb */, X86::JB_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3046 /* jb */, X86::JB_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3046 /* jb */, X86::JB_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3049 /* jbe */, X86::JBE_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3049 /* jbe */, X86::JBE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3049 /* jbe */, X86::JBE_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3053 /* jcxz */, X86::JCXZ, Convert__AbsMem1_0, Feature_Not64BitMode, { MCK_AbsMem }, },
  { 3058 /* je */, X86::JE_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3058 /* je */, X86::JE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3058 /* je */, X86::JE_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3061 /* jecxz */, X86::JECXZ_32, Convert__AbsMem1_0, Feature_Not64BitMode, { MCK_AbsMem }, },
  { 3061 /* jecxz */, X86::JECXZ_64, Convert__AbsMem1_0, Feature_In64BitMode, { MCK_AbsMem }, },
  { 3067 /* jg */, X86::JG_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3067 /* jg */, X86::JG_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3067 /* jg */, X86::JG_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3070 /* jge */, X86::JGE_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3070 /* jge */, X86::JGE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3070 /* jge */, X86::JGE_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3074 /* jl */, X86::JL_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3074 /* jl */, X86::JL_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3074 /* jl */, X86::JL_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3077 /* jle */, X86::JLE_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3077 /* jle */, X86::JLE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3077 /* jle */, X86::JLE_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3081 /* jmp */, X86::JMP_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3081 /* jmp */, X86::JMP_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3081 /* jmp */, X86::JMP_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3081 /* jmp */, X86::JMP64m, Convert__Mem165_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3081 /* jmp */, X86::JMP32m, Convert__Mem165_1, Feature_In32BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3081 /* jmp */, X86::JMP16m, Convert__Mem165_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3081 /* jmp */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3081 /* jmp */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, Feature_Not16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3085 /* jmpl */, X86::JMP32r, Convert__Reg1_1, Feature_Not64BitMode, { MCK__STAR_, MCK_GR32 }, },
  { 3085 /* jmpl */, X86::JMP32m, Convert__Mem325_1, Feature_Not64BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 3085 /* jmpl */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 3090 /* jmpq */, X86::JMP64r, Convert__Reg1_1, Feature_In64BitMode, { MCK__STAR_, MCK_GR64 }, },
  { 3090 /* jmpq */, X86::JMP64m, Convert__Mem645_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 3095 /* jmpw */, X86::JMP16r, Convert__Reg1_1, Feature_Not64BitMode, { MCK__STAR_, MCK_GR16 }, },
  { 3095 /* jmpw */, X86::JMP16m, Convert__Mem165_1, Feature_Not64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3095 /* jmpw */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 3100 /* jne */, X86::JNE_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3100 /* jne */, X86::JNE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3100 /* jne */, X86::JNE_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3104 /* jno */, X86::JNO_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3104 /* jno */, X86::JNO_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3104 /* jno */, X86::JNO_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3108 /* jnp */, X86::JNP_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3108 /* jnp */, X86::JNP_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3108 /* jnp */, X86::JNP_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3112 /* jns */, X86::JNS_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3112 /* jns */, X86::JNS_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3112 /* jns */, X86::JNS_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3116 /* jo */, X86::JO_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3116 /* jo */, X86::JO_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3116 /* jo */, X86::JO_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3119 /* jp */, X86::JP_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3119 /* jp */, X86::JP_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3119 /* jp */, X86::JP_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3122 /* jrcxz */, X86::JRCXZ, Convert__AbsMem1_0, Feature_In64BitMode, { MCK_AbsMem }, },
  { 3128 /* js */, X86::JS_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3128 /* js */, X86::JS_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3128 /* js */, X86::JS_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3131 /* kandnw */, X86::KANDNWrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3138 /* kandw */, X86::KANDWrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3144 /* kmovw */, X86::KMOVWkr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_VK1 }, },
  { 3144 /* kmovw */, X86::KMOVWrk, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_GR32 }, },
  { 3144 /* kmovw */, X86::KMOVWkk, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1 }, },
  { 3144 /* kmovw */, X86::KMOVWmk, Convert__Mem165_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_Mem16 }, },
  { 3144 /* kmovw */, X86::KMOVWkm, Convert__Reg1_1__Mem165_0, Feature_HasAVX512, { MCK_Mem16, MCK_VK1 }, },
  { 3150 /* knotw */, X86::KNOTWrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1 }, },
  { 3156 /* kortestw */, X86::KORTESTWrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1 }, },
  { 3165 /* korw */, X86::KORWrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3170 /* kshiftlw */, X86::KSHIFTLWri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VK1, MCK_VK1 }, },
  { 3179 /* kshiftrw */, X86::KSHIFTRWri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VK1, MCK_VK1 }, },
  { 3188 /* kunpckbw */, X86::KUNPCKBWrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3197 /* kxnorw */, X86::KXNORWrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3204 /* kxorw */, X86::KXORWrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3210 /* lahf */, X86::LAHF, Convert_NoOperands, 0, {  }, },
  { 3219 /* larl */, X86::LAR32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 3219 /* larl */, X86::LAR32rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 3224 /* larq */, X86::LAR64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR64 }, },
  { 3224 /* larq */, X86::LAR64rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR64 }, },
  { 3229 /* larw */, X86::LAR16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 3229 /* larw */, X86::LAR16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 3234 /* lcall */, X86::FARCALL32m, Convert__Mem5_1, Feature_Not16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3234 /* lcall */, X86::FARCALL16m, Convert__Mem5_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3234 /* lcall */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, Feature_Not16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3234 /* lcall */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3240 /* lcalll */, X86::FARCALL32m, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3240 /* lcalll */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 3247 /* lcallq */, X86::FARCALL64, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3254 /* lcallw */, X86::FARCALL16m, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3254 /* lcallw */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 3261 /* lddqu */, X86::LDDQUrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3267 /* ldmxcsr */, X86::LDMXCSR, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 3279 /* ldsl */, X86::LDS32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 3284 /* ldsw */, X86::LDS16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3293 /* leal */, X86::LEA32r, Convert__Reg1_1__Mem325_0, Feature_Not64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 3293 /* leal */, X86::LEA64_32r, Convert__Reg1_1__Mem5_0, Feature_In64BitMode, { MCK_Mem, MCK_GR32 }, },
  { 3298 /* leaq */, X86::LEA64r, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR64 }, },
  { 3303 /* leave */, X86::LEAVE, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 3303 /* leave */, X86::LEAVE64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 3309 /* leaw */, X86::LEA16r, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR16 }, },
  { 3318 /* lesl */, X86::LES32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 3323 /* lesw */, X86::LES16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3328 /* lfence */, X86::LFENCE, Convert_NoOperands, 0, {  }, },
  { 3339 /* lfsl */, X86::LFS32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 3344 /* lfsq */, X86::LFS64rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR64 }, },
  { 3349 /* lfsw */, X86::LFS16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3359 /* lgdtl */, X86::LGDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3365 /* lgdtq */, X86::LGDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 3371 /* lgdtw */, X86::LGDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3381 /* lgsl */, X86::LGS32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 3386 /* lgsq */, X86::LGS64rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR64 }, },
  { 3391 /* lgsw */, X86::LGS16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3401 /* lidtl */, X86::LIDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3407 /* lidtq */, X86::LIDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 3413 /* lidtw */, X86::LIDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3419 /* ljmp */, X86::FARJMP32m, Convert__Mem5_1, Feature_Not16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3419 /* ljmp */, X86::FARJMP16m, Convert__Mem5_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3419 /* ljmp */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, Feature_Not16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3419 /* ljmp */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3424 /* ljmpl */, X86::FARJMP32m, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3424 /* ljmpl */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 3430 /* ljmpq */, X86::FARJMP64, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3436 /* ljmpw */, X86::FARJMP16m, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3436 /* ljmpw */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 3447 /* lldtw */, X86::LLDT16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 3447 /* lldtw */, X86::LLDT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 3458 /* lmsww */, X86::LMSW16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 3458 /* lmsww */, X86::LMSW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 3464 /* lock */, X86::LOCK_PREFIX, Convert_NoOperands, 0, {  }, },
  { 3469 /* lods */, X86::LODSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_AX }, },
  { 3469 /* lods */, X86::LODSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_EAX }, },
  { 3469 /* lods */, X86::LODSQ, Convert__SrcIdx642_0, Feature_In64BitMode, { MCK_SrcIdx64, MCK_RAX }, },
  { 3469 /* lods */, X86::LODSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_AL }, },
  { 3474 /* lodsb */, X86::LODSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8 }, },
  { 3474 /* lodsb */, X86::LODSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_AL }, },
  { 3486 /* lodsl */, X86::LODSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32 }, },
  { 3486 /* lodsl */, X86::LODSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_EAX }, },
  { 3492 /* lodsq */, X86::LODSQ, Convert__SrcIdx642_0, Feature_In64BitMode, { MCK_SrcIdx64 }, },
  { 3492 /* lodsq */, X86::LODSQ, Convert__SrcIdx642_0, 0, { MCK_SrcIdx64, MCK_RAX }, },
  { 3498 /* lodsw */, X86::LODSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16 }, },
  { 3498 /* lodsw */, X86::LODSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_AX }, },
  { 3504 /* loop */, X86::LOOP, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3509 /* loope */, X86::LOOPE, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3515 /* loopne */, X86::LOOPNE, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3522 /* lretl */, X86::LRETL, Convert_NoOperands, 0, {  }, },
  { 3522 /* lretl */, X86::LRETIL, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 3528 /* lretq */, X86::LRETQ, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 3528 /* lretq */, X86::LRETIQ, Convert__Imm1_0, Feature_In64BitMode, { MCK_Imm }, },
  { 3534 /* lretw */, X86::LRETW, Convert_NoOperands, 0, {  }, },
  { 3534 /* lretw */, X86::LRETIW, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 3544 /* lsll */, X86::LSL32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 3544 /* lsll */, X86::LSL32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 3549 /* lslq */, X86::LSL64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 3549 /* lslq */, X86::LSL64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 3554 /* lslw */, X86::LSL16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 3554 /* lslw */, X86::LSL16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 3563 /* lssl */, X86::LSS32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 3568 /* lssq */, X86::LSS64rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR64 }, },
  { 3573 /* lssw */, X86::LSS16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3582 /* ltrw */, X86::LTRr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 3582 /* ltrw */, X86::LTRm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 3593 /* lzcntl */, X86::LZCNT32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 3593 /* lzcntl */, X86::LZCNT32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 3600 /* lzcntq */, X86::LZCNT64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 3600 /* lzcntq */, X86::LZCNT64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 3607 /* lzcntw */, X86::LZCNT16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 3607 /* lzcntw */, X86::LZCNT16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 3614 /* maskmovdqu */, X86::MASKMOVDQU, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_FR32, MCK_FR32 }, },
  { 3614 /* maskmovdqu */, X86::MASKMOVDQU64, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_FR32, MCK_FR32 }, },
  { 3625 /* maskmovq */, X86::MMX_MASKMOVQ, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_VR64, MCK_VR64 }, },
  { 3625 /* maskmovq */, X86::MMX_MASKMOVQ64, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_VR64, MCK_VR64 }, },
  { 3634 /* maxpd */, X86::MAXPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3634 /* maxpd */, X86::MAXPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3640 /* maxps */, X86::MAXPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3640 /* maxps */, X86::MAXPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3646 /* maxsd */, X86::MAXSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3646 /* maxsd */, X86::MAXSDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3652 /* maxss */, X86::MAXSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3652 /* maxss */, X86::MAXSSrm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 3658 /* mfence */, X86::MFENCE, Convert_NoOperands, 0, {  }, },
  { 3665 /* minpd */, X86::MINPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3665 /* minpd */, X86::MINPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3671 /* minps */, X86::MINPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3671 /* minps */, X86::MINPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3677 /* minsd */, X86::MINSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3677 /* minsd */, X86::MINSDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3683 /* minss */, X86::MINSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3683 /* minss */, X86::MINSSrm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 3689 /* monitor */, X86::MONITORrrr, Convert_NoOperands, 0, {  }, },
  { 3689 /* monitor */, X86::MONITORrrr, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX, MCK_ECX, MCK_EDX }, },
  { 3689 /* monitor */, X86::MONITORrrr, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX, MCK_RCX, MCK_RDX }, },
  { 3697 /* montmul */, X86::MONTMUL, Convert_NoOperands, 0, {  }, },
  { 3705 /* mov */, X86::MOV32ms, Convert__Mem325_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_Mem32 }, },
  { 3705 /* mov */, X86::MOV32sm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_SEGMENT_REG }, },
  { 3716 /* movabsb */, X86::MOV64ao8, Convert__MemOffs82_1, Feature_In64BitMode, { MCK_AL, MCK_MemOffs8 }, },
  { 3716 /* movabsb */, X86::MOV64o8a, Convert__MemOffs82_0, Feature_In64BitMode, { MCK_MemOffs8, MCK_AL }, },
  { 3724 /* movabsl */, X86::MOV64ao32, Convert__MemOffs322_1, Feature_In64BitMode, { MCK_EAX, MCK_MemOffs32 }, },
  { 3724 /* movabsl */, X86::MOV64o32a, Convert__MemOffs322_0, Feature_In64BitMode, { MCK_MemOffs32, MCK_EAX }, },
  { 3732 /* movabsq */, X86::MOV64ao64, Convert__MemOffs642_1, Feature_In64BitMode, { MCK_RAX, MCK_MemOffs64 }, },
  { 3732 /* movabsq */, X86::MOV64ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 3732 /* movabsq */, X86::MOV64o64a, Convert__MemOffs642_0, Feature_In64BitMode, { MCK_MemOffs64, MCK_RAX }, },
  { 3740 /* movabsw */, X86::MOV64ao16, Convert__MemOffs162_1, Feature_In64BitMode, { MCK_AX, MCK_MemOffs16 }, },
  { 3740 /* movabsw */, X86::MOV64o16a, Convert__MemOffs162_0, Feature_In64BitMode, { MCK_MemOffs16, MCK_AX }, },
  { 3748 /* movapd */, X86::MOVAPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3748 /* movapd */, X86::MOVAPDmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3748 /* movapd */, X86::MOVAPDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3755 /* movaps */, X86::MOVAPSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3755 /* movaps */, X86::MOVAPSmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3755 /* movaps */, X86::MOVAPSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3762 /* movb */, X86::MOV8ao8, Convert__MemOffs82_1, Feature_In32BitMode, { MCK_AL, MCK_MemOffs8 }, },
  { 3762 /* movb */, X86::MOV8ao8_16, Convert__MemOffs82_1, Feature_In16BitMode, { MCK_AL, MCK_MemOffs8 }, },
  { 3762 /* movb */, X86::MOV8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 3762 /* movb */, X86::MOV8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 3762 /* movb */, X86::MOV8ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 3762 /* movb */, X86::MOV8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 3762 /* movb */, X86::MOV8o8a, Convert__MemOffs82_0, Feature_In32BitMode, { MCK_MemOffs8, MCK_AL }, },
  { 3762 /* movb */, X86::MOV8o8a_16, Convert__MemOffs82_0, Feature_In16BitMode, { MCK_MemOffs8, MCK_AL }, },
  { 3762 /* movb */, X86::MOV8rm, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 3773 /* movbel */, X86::MOVBE32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 3773 /* movbel */, X86::MOVBE32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 3780 /* movbeq */, X86::MOVBE64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 3780 /* movbeq */, X86::MOVBE64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 3787 /* movbew */, X86::MOVBE16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 3787 /* movbew */, X86::MOVBE16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 3794 /* movd */, X86::MMX_MOVD64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_VR64 }, },
  { 3794 /* movd */, X86::MOVDI2PDIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32 }, },
  { 3794 /* movd */, X86::MMX_MOVD64to64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_VR64 }, },
  { 3794 /* movd */, X86::MOV64toPQIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 3794 /* movd */, X86::MMX_MOVD64grr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_GR32 }, },
  { 3794 /* movd */, X86::MMX_MOVD64from64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_GR64 }, },
  { 3794 /* movd */, X86::MMX_MOVD64mr, Convert__Mem325_1__Reg1_0, 0, { MCK_VR64, MCK_Mem32 }, },
  { 3794 /* movd */, X86::MOVPDI2DIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 3794 /* movd */, X86::MOVPQIto64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 3794 /* movd */, X86::MOVPDI2DImr, Convert__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32 }, },
  { 3794 /* movd */, X86::MMX_MOVD64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR64 }, },
  { 3794 /* movd */, X86::MOVDI2PDIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 3799 /* movddup */, X86::MOVDDUPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3799 /* movddup */, X86::MOVDDUPrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3807 /* movdq2q */, X86::MMX_MOVDQ2Qrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 3815 /* movdqa */, X86::MOVDQArr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3815 /* movdqa */, X86::MOVDQAmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3815 /* movdqa */, X86::MOVDQArm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3822 /* movdqu */, X86::MOVDQUrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3822 /* movdqu */, X86::MOVDQUmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3822 /* movdqu */, X86::MOVDQUrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3829 /* movhlps */, X86::MOVHLPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3837 /* movhpd */, X86::MOVHPDmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3837 /* movhpd */, X86::MOVHPDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3844 /* movhps */, X86::MOVHPSmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3844 /* movhps */, X86::MOVHPSrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3851 /* movl */, X86::MOV32ao32, Convert__MemOffs322_1, Feature_In32BitMode, { MCK_EAX, MCK_MemOffs32 }, },
  { 3851 /* movl */, X86::MOV32ao32_16, Convert__MemOffs322_1, Feature_In16BitMode, { MCK_EAX, MCK_MemOffs32 }, },
  { 3851 /* movl */, X86::MOV32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 3851 /* movl */, X86::MOV32sr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_SEGMENT_REG }, },
  { 3851 /* movl */, X86::MOV32dr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_DEBUG_REG }, },
  { 3851 /* movl */, X86::MOV32cr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_CONTROL_REG }, },
  { 3851 /* movl */, X86::MOV32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 3851 /* movl */, X86::MOV32rs, Convert__Reg1_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_GR32 }, },
  { 3851 /* movl */, X86::MOV32ms, Convert__Mem325_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_Mem32 }, },
  { 3851 /* movl */, X86::MOV32rd, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_DEBUG_REG, MCK_GR32 }, },
  { 3851 /* movl */, X86::MOV32rc, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_CONTROL_REG, MCK_GR32 }, },
  { 3851 /* movl */, X86::MOV32ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 3851 /* movl */, X86::MOV32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 3851 /* movl */, X86::MOV32o32a, Convert__MemOffs322_0, Feature_In32BitMode, { MCK_MemOffs32, MCK_EAX }, },
  { 3851 /* movl */, X86::MOV32o32a_16, Convert__MemOffs322_0, Feature_In16BitMode, { MCK_MemOffs32, MCK_EAX }, },
  { 3851 /* movl */, X86::MOV32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 3851 /* movl */, X86::MOV32sm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_SEGMENT_REG }, },
  { 3856 /* movlhps */, X86::MOVLHPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3864 /* movlpd */, X86::MOVLPDmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3864 /* movlpd */, X86::MOVLPDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3871 /* movlps */, X86::MOVLPSmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3871 /* movlps */, X86::MOVLPSrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3878 /* movmskpd */, X86::MOVMSKPDrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_FR32, MCK_GR32orGR64 }, },
  { 3887 /* movmskps */, X86::MOVMSKPSrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_FR32, MCK_GR32orGR64 }, },
  { 3896 /* movntdq */, X86::MOVNTDQmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3904 /* movntdqa */, X86::MOVNTDQArm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3920 /* movntil */, X86::MOVNTImr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 3928 /* movntiq */, X86::MOVNTI_64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 3936 /* movntpd */, X86::MOVNTPDmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3944 /* movntps */, X86::MOVNTPSmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3952 /* movntq */, X86::MMX_MOVNTQmr, Convert__Mem645_1__Reg1_0, 0, { MCK_VR64, MCK_Mem64 }, },
  { 3959 /* movntsd */, X86::MOVNTSD, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3967 /* movntss */, X86::MOVNTSS, Convert__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32 }, },
  { 3975 /* movq */, X86::MOV64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 3975 /* movq */, X86::MMX_MOVD64to64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_VR64 }, },
  { 3975 /* movq */, X86::MOV64toPQIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 3975 /* movq */, X86::MOV64sr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_SEGMENT_REG }, },
  { 3975 /* movq */, X86::MOV64dr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_DEBUG_REG }, },
  { 3975 /* movq */, X86::MOV64cr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_CONTROL_REG }, },
  { 3975 /* movq */, X86::MOV64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 3975 /* movq */, X86::MMX_MOVD64from64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_GR64 }, },
  { 3975 /* movq */, X86::MMX_MOVQ64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 3975 /* movq */, X86::MMX_MOVQ64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_VR64, MCK_Mem64 }, },
  { 3975 /* movq */, X86::MOVPQIto64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 3975 /* movq */, X86::MOVZPQILo2PQIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3975 /* movq */, X86::MOVPQI2QImr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3975 /* movq */, X86::MOV64rs, Convert__Reg1_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_GR64 }, },
  { 3975 /* movq */, X86::MOV64ms, Convert__Mem645_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_Mem64 }, },
  { 3975 /* movq */, X86::MOV64rd, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_DEBUG_REG, MCK_GR64 }, },
  { 3975 /* movq */, X86::MOV64rc, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_CONTROL_REG, MCK_GR64 }, },
  { 3975 /* movq */, X86::MOV64ri32, Convert__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3975 /* movq */, X86::MOV64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3975 /* movq */, X86::MOV64ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 3975 /* movq */, X86::MOV64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 3975 /* movq */, X86::MMX_MOVQ64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 3975 /* movq */, X86::MOVQI2PQIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3975 /* movq */, X86::MOV64sm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_SEGMENT_REG }, },
  { 3980 /* movq2dq */, X86::MMX_MOVQ2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_FR32 }, },
  { 3988 /* movsb */, X86::MOVSB, Convert__DstIdx81_1__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_DstIdx8 }, },
  { 3994 /* movsbl */, X86::MOVSX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 3994 /* movsbl */, X86::MOVSX32rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR32 }, },
  { 4001 /* movsbq */, X86::MOVSX64rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4001 /* movsbq */, X86::MOVSX64rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR64 }, },
  { 4008 /* movsbw */, X86::MOVSX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4008 /* movsbw */, X86::MOVSX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4015 /* movsd */, X86::MOVSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4015 /* movsd */, X86::MOVSDmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4015 /* movsd */, X86::MOVSDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4021 /* movshdup */, X86::MOVSHDUPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4021 /* movshdup */, X86::MOVSHDUPrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4030 /* movsl */, X86::MOVSL, Convert__DstIdx321_1__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_DstIdx32 }, },
  { 4036 /* movsldup */, X86::MOVSLDUPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4036 /* movsldup */, X86::MOVSLDUPrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4045 /* movslq */, X86::MOVSX64rr32, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR64 }, },
  { 4045 /* movslq */, X86::MOVSX64rm32, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 4052 /* movsq */, X86::MOVSQ, Convert__DstIdx641_1__SrcIdx642_0, 0, { MCK_SrcIdx64, MCK_DstIdx64 }, },
  { 4058 /* movss */, X86::MOVSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4058 /* movss */, X86::MOVSSmr, Convert__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32 }, },
  { 4058 /* movss */, X86::MOVSSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 4064 /* movsw */, X86::MOVSW, Convert__DstIdx161_1__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_DstIdx16 }, },
  { 4070 /* movswl */, X86::MOVSX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4070 /* movswl */, X86::MOVSX32rm16, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 4077 /* movswq */, X86::MOVSX64rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4077 /* movswq */, X86::MOVSX64rm16, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR64 }, },
  { 4084 /* movsx */, X86::MOVSX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4084 /* movsx */, X86::MOVSX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4084 /* movsx */, X86::MOVSX64rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4084 /* movsx */, X86::MOVSX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4084 /* movsx */, X86::MOVSX64rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4084 /* movsx */, X86::MOVSX64rr32, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR64 }, },
  { 4084 /* movsx */, X86::MOVSX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4097 /* movupd */, X86::MOVUPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4097 /* movupd */, X86::MOVUPDmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4097 /* movupd */, X86::MOVUPDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4104 /* movups */, X86::MOVUPSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4104 /* movups */, X86::MOVUPSmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4104 /* movups */, X86::MOVUPSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4111 /* movw */, X86::MOV16ao16, Convert__MemOffs162_1, Feature_In32BitMode, { MCK_AX, MCK_MemOffs16 }, },
  { 4111 /* movw */, X86::MOV16ao16_16, Convert__MemOffs162_1, Feature_In16BitMode, { MCK_AX, MCK_MemOffs16 }, },
  { 4111 /* movw */, X86::MOV16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 4111 /* movw */, X86::MOV16sr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_SEGMENT_REG }, },
  { 4111 /* movw */, X86::MOV16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 4111 /* movw */, X86::MOV16rs, Convert__Reg1_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_GR16 }, },
  { 4111 /* movw */, X86::MOV16ms, Convert__Mem165_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_Mem16 }, },
  { 4111 /* movw */, X86::MOV16ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 4111 /* movw */, X86::MOV16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 4111 /* movw */, X86::MOV16o16a, Convert__MemOffs162_0, Feature_In32BitMode, { MCK_MemOffs16, MCK_AX }, },
  { 4111 /* movw */, X86::MOV16o16a_16, Convert__MemOffs162_0, Feature_In16BitMode, { MCK_MemOffs16, MCK_AX }, },
  { 4111 /* movw */, X86::MOV16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 4111 /* movw */, X86::MOV16sm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_SEGMENT_REG }, },
  { 4116 /* movzbl */, X86::MOVZX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4116 /* movzbl */, X86::MOVZX32rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR32 }, },
  { 4123 /* movzbq */, X86::MOVZX64rr8_Q, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4123 /* movzbq */, X86::MOVZX64rm8_Q, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR64 }, },
  { 4130 /* movzbw */, X86::MOVZX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4130 /* movzbw */, X86::MOVZX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4137 /* movzwl */, X86::MOVZX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4137 /* movzwl */, X86::MOVZX32rm16, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 4144 /* movzwq */, X86::MOVZX64rr16_Q, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4144 /* movzwq */, X86::MOVZX64rm16_Q, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR64 }, },
  { 4151 /* movzx */, X86::MOVZX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4151 /* movzx */, X86::MOVZX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4151 /* movzx */, X86::MOVZX64rr8_Q, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4151 /* movzx */, X86::MOVZX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4151 /* movzx */, X86::MOVZX64rr16_Q, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4151 /* movzx */, X86::MOVZX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4157 /* mpsadbw */, X86::MPSADBWrri, Convert__Reg1_2__Tie0__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32 }, },
  { 4157 /* mpsadbw */, X86::MPSADBWrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32 }, },
  { 4169 /* mulb */, X86::MUL8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 4169 /* mulb */, X86::MUL8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 4174 /* mull */, X86::MUL32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 4174 /* mull */, X86::MUL32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4179 /* mulpd */, X86::MULPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4179 /* mulpd */, X86::MULPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4185 /* mulps */, X86::MULPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4185 /* mulps */, X86::MULPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4191 /* mulq */, X86::MUL64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 4191 /* mulq */, X86::MUL64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 4196 /* mulsd */, X86::MULSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4196 /* mulsd */, X86::MULSDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4202 /* mulss */, X86::MULSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4202 /* mulss */, X86::MULSSrm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 4208 /* mulw */, X86::MUL16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 4208 /* mulw */, X86::MUL16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4218 /* mulxl */, X86::MULX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 4218 /* mulxl */, X86::MULX32rm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 4224 /* mulxq */, X86::MULX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4224 /* mulxq */, X86::MULX64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 4230 /* mwait */, X86::MWAITrr, Convert_NoOperands, 0, {  }, },
  { 4230 /* mwait */, X86::MWAITrr, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX, MCK_ECX }, },
  { 4230 /* mwait */, X86::MWAITrr, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX, MCK_RCX }, },
  { 4240 /* negb */, X86::NEG8r, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 4240 /* negb */, X86::NEG8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 4245 /* negl */, X86::NEG32r, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 4245 /* negl */, X86::NEG32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4250 /* negq */, X86::NEG64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 4250 /* negq */, X86::NEG64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 4255 /* negw */, X86::NEG16r, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 4255 /* negw */, X86::NEG16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4260 /* nop */, X86::NOOP, Convert_NoOperands, 0, {  }, },
  { 4264 /* nopl */, X86::NOOPL, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4269 /* nopw */, X86::NOOPW, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4278 /* notb */, X86::NOT8r, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 4278 /* notb */, X86::NOT8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 4283 /* notl */, X86::NOT32r, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 4283 /* notl */, X86::NOT32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4288 /* notq */, X86::NOT64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 4288 /* notq */, X86::NOT64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 4293 /* notw */, X86::NOT16r, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 4293 /* notw */, X86::NOT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4301 /* orb */, X86::OR8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 4301 /* orb */, X86::OR8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 4301 /* orb */, X86::OR8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 4301 /* orb */, X86::OR8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 4301 /* orb */, X86::OR8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 4301 /* orb */, X86::OR8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 4305 /* orl */, X86::OR32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 4305 /* orl */, X86::OR32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 4305 /* orl */, X86::OR32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 4305 /* orl */, X86::OR32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 4305 /* orl */, X86::OR32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 4305 /* orl */, X86::OR32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 4305 /* orl */, X86::OR32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 4305 /* orl */, X86::OR32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 4309 /* orpd */, X86::ORPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4309 /* orpd */, X86::ORPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4314 /* orps */, X86::ORPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4314 /* orps */, X86::ORPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4319 /* orq */, X86::OR64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 4319 /* orq */, X86::OR64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 4319 /* orq */, X86::OR64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 4319 /* orq */, X86::OR64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 4319 /* orq */, X86::OR64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 4319 /* orq */, X86::OR64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4319 /* orq */, X86::OR64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4319 /* orq */, X86::OR64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 4323 /* orw */, X86::OR16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 4323 /* orw */, X86::OR16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 4323 /* orw */, X86::OR16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 4323 /* orw */, X86::OR16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 4323 /* orw */, X86::OR16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 4323 /* orw */, X86::OR16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 4323 /* orw */, X86::OR16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 4323 /* orw */, X86::OR16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 4331 /* outb */, X86::OUT8rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 4331 /* outb */, X86::OUT8ir, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 4331 /* outb */, X86::OUT8rr, Convert_NoOperands, 0, { MCK_AL, MCK_DX }, },
  { 4331 /* outb */, X86::OUT8ir, Convert__Imm1_1, 0, { MCK_AL, MCK_Imm }, },
  { 4336 /* outl */, X86::OUT32rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 4336 /* outl */, X86::OUT32ir, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 4336 /* outl */, X86::OUT32rr, Convert_NoOperands, 0, { MCK_EAX, MCK_DX }, },
  { 4336 /* outl */, X86::OUT32ir, Convert__Imm1_1, 0, { MCK_EAX, MCK_Imm }, },
  { 4341 /* outsb */, X86::OUTSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_DX }, },
  { 4353 /* outsl */, X86::OUTSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_DX }, },
  { 4359 /* outsw */, X86::OUTSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_DX }, },
  { 4365 /* outw */, X86::OUT16rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 4365 /* outw */, X86::OUT16ir, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 4365 /* outw */, X86::OUT16rr, Convert_NoOperands, 0, { MCK_AX, MCK_DX }, },
  { 4365 /* outw */, X86::OUT16ir, Convert__Imm1_1, 0, { MCK_AX, MCK_Imm }, },
  { 4370 /* pabsb */, X86::MMX_PABSBrr64, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4370 /* pabsb */, X86::PABSBrr128, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4370 /* pabsb */, X86::PABSBrm128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4370 /* pabsb */, X86::MMX_PABSBrm64, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4376 /* pabsd */, X86::MMX_PABSDrr64, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4376 /* pabsd */, X86::PABSDrr128, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4376 /* pabsd */, X86::PABSDrm128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4376 /* pabsd */, X86::MMX_PABSDrm64, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4382 /* pabsw */, X86::MMX_PABSWrr64, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4382 /* pabsw */, X86::PABSWrr128, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4382 /* pabsw */, X86::PABSWrm128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4382 /* pabsw */, X86::MMX_PABSWrm64, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4388 /* packssdw */, X86::MMX_PACKSSDWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4388 /* packssdw */, X86::PACKSSDWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4388 /* packssdw */, X86::PACKSSDWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4388 /* packssdw */, X86::MMX_PACKSSDWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4397 /* packsswb */, X86::MMX_PACKSSWBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4397 /* packsswb */, X86::PACKSSWBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4397 /* packsswb */, X86::PACKSSWBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4397 /* packsswb */, X86::MMX_PACKSSWBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4406 /* packusdw */, X86::PACKUSDWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4406 /* packusdw */, X86::PACKUSDWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4415 /* packuswb */, X86::MMX_PACKUSWBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4415 /* packuswb */, X86::PACKUSWBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4415 /* packuswb */, X86::PACKUSWBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4415 /* packuswb */, X86::MMX_PACKUSWBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4424 /* paddb */, X86::MMX_PADDBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4424 /* paddb */, X86::PADDBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4424 /* paddb */, X86::PADDBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4424 /* paddb */, X86::MMX_PADDBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4430 /* paddd */, X86::MMX_PADDDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4430 /* paddd */, X86::PADDDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4430 /* paddd */, X86::PADDDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4430 /* paddd */, X86::MMX_PADDDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4436 /* paddq */, X86::MMX_PADDQirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4436 /* paddq */, X86::PADDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4436 /* paddq */, X86::PADDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4436 /* paddq */, X86::MMX_PADDQirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4442 /* paddsb */, X86::MMX_PADDSBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4442 /* paddsb */, X86::PADDSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4442 /* paddsb */, X86::PADDSBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4442 /* paddsb */, X86::MMX_PADDSBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4449 /* paddsw */, X86::MMX_PADDSWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4449 /* paddsw */, X86::PADDSWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4449 /* paddsw */, X86::PADDSWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4449 /* paddsw */, X86::MMX_PADDSWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4456 /* paddusb */, X86::MMX_PADDUSBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4456 /* paddusb */, X86::PADDUSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4456 /* paddusb */, X86::PADDUSBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4456 /* paddusb */, X86::MMX_PADDUSBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4464 /* paddusw */, X86::MMX_PADDUSWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4464 /* paddusw */, X86::PADDUSWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4464 /* paddusw */, X86::PADDUSWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4464 /* paddusw */, X86::MMX_PADDUSWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4472 /* paddw */, X86::MMX_PADDWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4472 /* paddw */, X86::PADDWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4472 /* paddw */, X86::PADDWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4472 /* paddw */, X86::MMX_PADDWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4478 /* palignr */, X86::MMX_PALIGNR64irr, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR64, MCK_VR64 }, },
  { 4478 /* palignr */, X86::PALIGNR128rr, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 4478 /* palignr */, X86::PALIGNR128rm, Convert__Reg1_2__Tie0__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 4478 /* palignr */, X86::MMX_PALIGNR64irm, Convert__Reg1_2__Tie0__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64, MCK_VR64 }, },
  { 4486 /* pand */, X86::MMX_PANDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4486 /* pand */, X86::PANDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4486 /* pand */, X86::PANDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4486 /* pand */, X86::MMX_PANDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4491 /* pandn */, X86::MMX_PANDNirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4491 /* pandn */, X86::PANDNrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4491 /* pandn */, X86::PANDNrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4491 /* pandn */, X86::MMX_PANDNirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4497 /* pause */, X86::PAUSE, Convert_NoOperands, 0, {  }, },
  { 4503 /* pavgb */, X86::MMX_PAVGBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4503 /* pavgb */, X86::PAVGBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4503 /* pavgb */, X86::PAVGBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4503 /* pavgb */, X86::MMX_PAVGBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4509 /* pavgusb */, X86::PAVGUSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4509 /* pavgusb */, X86::PAVGUSBrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4517 /* pavgw */, X86::MMX_PAVGWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4517 /* pavgw */, X86::PAVGWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4517 /* pavgw */, X86::PAVGWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4517 /* pavgw */, X86::MMX_PAVGWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4523 /* pblendvb */, X86::PBLENDVBrr0, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4523 /* pblendvb */, X86::PBLENDVBrm0, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4523 /* pblendvb */, X86::PBLENDVBrr0, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_XMM0, MCK_FR32, MCK_FR32 }, },
  { 4523 /* pblendvb */, X86::PBLENDVBrm0, Convert__Reg1_2__Tie0__Mem1285_1, 0, { MCK_XMM0, MCK_Mem128, MCK_FR32 }, },
  { 4532 /* pblendw */, X86::PBLENDWrri, Convert__Reg1_2__Tie0__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32 }, },
  { 4532 /* pblendw */, X86::PBLENDWrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32 }, },
  { 4540 /* pclmulhqhqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0__Reg1_0__imm_17, 0, { MCK_FR32, MCK_FR32 }, },
  { 4540 /* pclmulhqhqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0__Mem1285_0__imm_17, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4553 /* pclmulhqlqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0__Reg1_0__imm_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4553 /* pclmulhqlqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0__Mem1285_0__imm_1, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4566 /* pclmullqhqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0__Reg1_0__imm_16, 0, { MCK_FR32, MCK_FR32 }, },
  { 4566 /* pclmullqhqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0__Mem1285_0__imm_16, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4579 /* pclmullqlqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0__Reg1_0__imm_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4579 /* pclmullqlqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0__Mem1285_0__imm_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4592 /* pclmulqdq */, X86::PCLMULQDQrr, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 4592 /* pclmulqdq */, X86::PCLMULQDQrm, Convert__Reg1_2__Tie0__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 4602 /* pcmpeqb */, X86::MMX_PCMPEQBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4602 /* pcmpeqb */, X86::PCMPEQBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4602 /* pcmpeqb */, X86::PCMPEQBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4602 /* pcmpeqb */, X86::MMX_PCMPEQBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4610 /* pcmpeqd */, X86::MMX_PCMPEQDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4610 /* pcmpeqd */, X86::PCMPEQDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4610 /* pcmpeqd */, X86::PCMPEQDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4610 /* pcmpeqd */, X86::MMX_PCMPEQDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4618 /* pcmpeqq */, X86::PCMPEQQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4618 /* pcmpeqq */, X86::PCMPEQQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4626 /* pcmpeqw */, X86::MMX_PCMPEQWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4626 /* pcmpeqw */, X86::PCMPEQWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4626 /* pcmpeqw */, X86::PCMPEQWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4626 /* pcmpeqw */, X86::MMX_PCMPEQWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4634 /* pcmpestri */, X86::PCMPESTRIrr, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 4634 /* pcmpestri */, X86::PCMPESTRIrm, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 4644 /* pcmpestrm */, X86::PCMPESTRM128rr, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 4644 /* pcmpestrm */, X86::PCMPESTRM128rm, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 4654 /* pcmpgtb */, X86::MMX_PCMPGTBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4654 /* pcmpgtb */, X86::PCMPGTBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4654 /* pcmpgtb */, X86::PCMPGTBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4654 /* pcmpgtb */, X86::MMX_PCMPGTBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4662 /* pcmpgtd */, X86::MMX_PCMPGTDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4662 /* pcmpgtd */, X86::PCMPGTDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4662 /* pcmpgtd */, X86::PCMPGTDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4662 /* pcmpgtd */, X86::MMX_PCMPGTDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4670 /* pcmpgtq */, X86::PCMPGTQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4670 /* pcmpgtq */, X86::PCMPGTQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4678 /* pcmpgtw */, X86::MMX_PCMPGTWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4678 /* pcmpgtw */, X86::PCMPGTWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4678 /* pcmpgtw */, X86::PCMPGTWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4678 /* pcmpgtw */, X86::MMX_PCMPGTWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4686 /* pcmpistri */, X86::PCMPISTRIrr, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 4686 /* pcmpistri */, X86::PCMPISTRIrm, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 4696 /* pcmpistrm */, X86::PCMPISTRM128rr, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 4696 /* pcmpistrm */, X86::PCMPISTRM128rm, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 4711 /* pdepl */, X86::PDEP32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 4711 /* pdepl */, X86::PDEP32rm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 4717 /* pdepq */, X86::PDEP64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4717 /* pdepq */, X86::PDEP64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 4728 /* pextl */, X86::PEXT32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 4728 /* pextl */, X86::PEXT32rm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 4734 /* pextq */, X86::PEXT64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4734 /* pextq */, X86::PEXT64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 4740 /* pextrb */, X86::PEXTRBrr, Convert__GR32orGR641_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_GR32orGR64 }, },
  { 4740 /* pextrb */, X86::PEXTRBmr, Convert__Mem85_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_Mem8 }, },
  { 4747 /* pextrd */, X86::PEXTRDrr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_GR32 }, },
  { 4747 /* pextrd */, X86::PEXTRDmr, Convert__Mem325_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_Mem32 }, },
  { 4754 /* pextrq */, X86::PEXTRQrr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_GR64 }, },
  { 4754 /* pextrq */, X86::PEXTRQmr, Convert__Mem645_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_Mem64 }, },
  { 4761 /* pextrw */, X86::MMX_PEXTRWirri, Convert__GR32orGR641_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR64, MCK_GR32orGR64 }, },
  { 4761 /* pextrw */, X86::PEXTRWri, Convert__GR32orGR641_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_GR32orGR64 }, },
  { 4761 /* pextrw */, X86::PEXTRWmr, Convert__Mem165_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_Mem16 }, },
  { 4768 /* pf2id */, X86::PF2IDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4768 /* pf2id */, X86::PF2IDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4774 /* pf2iw */, X86::PF2IWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4774 /* pf2iw */, X86::PF2IWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4780 /* pfacc */, X86::PFACCrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4780 /* pfacc */, X86::PFACCrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4786 /* pfadd */, X86::PFADDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4786 /* pfadd */, X86::PFADDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4792 /* pfcmpeq */, X86::PFCMPEQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4792 /* pfcmpeq */, X86::PFCMPEQrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4800 /* pfcmpge */, X86::PFCMPGErr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4800 /* pfcmpge */, X86::PFCMPGErm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4808 /* pfcmpgt */, X86::PFCMPGTrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4808 /* pfcmpgt */, X86::PFCMPGTrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4816 /* pfmax */, X86::PFMAXrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4816 /* pfmax */, X86::PFMAXrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4822 /* pfmin */, X86::PFMINrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4822 /* pfmin */, X86::PFMINrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4828 /* pfmul */, X86::PFMULrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4828 /* pfmul */, X86::PFMULrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4834 /* pfnacc */, X86::PFNACCrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4834 /* pfnacc */, X86::PFNACCrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4841 /* pfpnacc */, X86::PFPNACCrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4841 /* pfpnacc */, X86::PFPNACCrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4849 /* pfrcp */, X86::PFRCPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4849 /* pfrcp */, X86::PFRCPrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4855 /* pfrcpit1 */, X86::PFRCPIT1rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4855 /* pfrcpit1 */, X86::PFRCPIT1rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4864 /* pfrcpit2 */, X86::PFRCPIT2rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4864 /* pfrcpit2 */, X86::PFRCPIT2rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4873 /* pfrsqit1 */, X86::PFRSQIT1rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4873 /* pfrsqit1 */, X86::PFRSQIT1rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4882 /* pfrsqrt */, X86::PFRSQRTrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4882 /* pfrsqrt */, X86::PFRSQRTrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4890 /* pfsub */, X86::PFSUBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4890 /* pfsub */, X86::PFSUBrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4896 /* pfsubr */, X86::PFSUBRrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4896 /* pfsubr */, X86::PFSUBRrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4903 /* phaddd */, X86::MMX_PHADDrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4903 /* phaddd */, X86::PHADDDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4903 /* phaddd */, X86::PHADDDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4903 /* phaddd */, X86::MMX_PHADDrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4910 /* phaddsw */, X86::MMX_PHADDSWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4910 /* phaddsw */, X86::PHADDSWrr128, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4910 /* phaddsw */, X86::PHADDSWrm128, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4910 /* phaddsw */, X86::MMX_PHADDSWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4918 /* phaddw */, X86::MMX_PHADDWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4918 /* phaddw */, X86::PHADDWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4918 /* phaddw */, X86::PHADDWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4918 /* phaddw */, X86::MMX_PHADDWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4925 /* phminposuw */, X86::PHMINPOSUWrr128, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4925 /* phminposuw */, X86::PHMINPOSUWrm128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4936 /* phsubd */, X86::MMX_PHSUBDrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4936 /* phsubd */, X86::PHSUBDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4936 /* phsubd */, X86::PHSUBDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4936 /* phsubd */, X86::MMX_PHSUBDrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4943 /* phsubsw */, X86::MMX_PHSUBSWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4943 /* phsubsw */, X86::PHSUBSWrr128, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4943 /* phsubsw */, X86::PHSUBSWrm128, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4943 /* phsubsw */, X86::MMX_PHSUBSWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4951 /* phsubw */, X86::MMX_PHSUBWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4951 /* phsubw */, X86::PHSUBWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4951 /* phsubw */, X86::PHSUBWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4951 /* phsubw */, X86::MMX_PHSUBWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4958 /* pi2fd */, X86::PI2FDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4958 /* pi2fd */, X86::PI2FDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4964 /* pi2fw */, X86::PI2FWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4964 /* pi2fw */, X86::PI2FWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4970 /* pinsrb */, X86::PINSRBrr, Convert__Reg1_2__Tie0__GR32orGR641_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32orGR64, MCK_FR32 }, },
  { 4970 /* pinsrb */, X86::PINSRBrm, Convert__Reg1_2__Tie0__Mem85_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem8, MCK_FR32 }, },
  { 4977 /* pinsrd */, X86::PINSRDrr, Convert__Reg1_2__Tie0__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32, MCK_FR32 }, },
  { 4977 /* pinsrd */, X86::PINSRDrm, Convert__Reg1_2__Tie0__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32, MCK_FR32 }, },
  { 4984 /* pinsrq */, X86::PINSRQrr, Convert__Reg1_2__Tie0__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR64, MCK_FR32 }, },
  { 4984 /* pinsrq */, X86::PINSRQrm, Convert__Reg1_2__Tie0__Mem645_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem64, MCK_FR32 }, },
  { 4991 /* pinsrw */, X86::MMX_PINSRWirri, Convert__Reg1_2__Tie0__GR32orGR641_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32orGR64, MCK_VR64 }, },
  { 4991 /* pinsrw */, X86::PINSRWrri, Convert__Reg1_2__Tie0__GR32orGR641_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32orGR64, MCK_FR32 }, },
  { 4991 /* pinsrw */, X86::MMX_PINSRWirmi, Convert__Reg1_2__Tie0__Mem165_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem16, MCK_VR64 }, },
  { 4991 /* pinsrw */, X86::PINSRWrmi, Convert__Reg1_2__Tie0__Mem165_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem16, MCK_FR32 }, },
  { 4998 /* pmaddubsw */, X86::MMX_PMADDUBSWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4998 /* pmaddubsw */, X86::PMADDUBSWrr128, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4998 /* pmaddubsw */, X86::PMADDUBSWrm128, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4998 /* pmaddubsw */, X86::MMX_PMADDUBSWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5008 /* pmaddwd */, X86::MMX_PMADDWDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5008 /* pmaddwd */, X86::PMADDWDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5008 /* pmaddwd */, X86::PMADDWDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5008 /* pmaddwd */, X86::MMX_PMADDWDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5016 /* pmaxsb */, X86::PMAXSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5016 /* pmaxsb */, X86::PMAXSBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5023 /* pmaxsd */, X86::PMAXSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5023 /* pmaxsd */, X86::PMAXSDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5030 /* pmaxsw */, X86::MMX_PMAXSWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5030 /* pmaxsw */, X86::PMAXSWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5030 /* pmaxsw */, X86::PMAXSWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5030 /* pmaxsw */, X86::MMX_PMAXSWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5037 /* pmaxub */, X86::MMX_PMAXUBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5037 /* pmaxub */, X86::PMAXUBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5037 /* pmaxub */, X86::PMAXUBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5037 /* pmaxub */, X86::MMX_PMAXUBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5044 /* pmaxud */, X86::PMAXUDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5044 /* pmaxud */, X86::PMAXUDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5051 /* pmaxuw */, X86::PMAXUWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5051 /* pmaxuw */, X86::PMAXUWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5058 /* pminsb */, X86::PMINSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5058 /* pminsb */, X86::PMINSBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5065 /* pminsd */, X86::PMINSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5065 /* pminsd */, X86::PMINSDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5072 /* pminsw */, X86::MMX_PMINSWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5072 /* pminsw */, X86::PMINSWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5072 /* pminsw */, X86::PMINSWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5072 /* pminsw */, X86::MMX_PMINSWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5079 /* pminub */, X86::MMX_PMINUBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5079 /* pminub */, X86::PMINUBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5079 /* pminub */, X86::PMINUBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5079 /* pminub */, X86::MMX_PMINUBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5086 /* pminud */, X86::PMINUDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5086 /* pminud */, X86::PMINUDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5093 /* pminuw */, X86::PMINUWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5093 /* pminuw */, X86::PMINUWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5100 /* pmovmskb */, X86::MMX_PMOVMSKBrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_VR64, MCK_GR32orGR64 }, },
  { 5100 /* pmovmskb */, X86::PMOVMSKBrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_FR32, MCK_GR32orGR64 }, },
  { 5109 /* pmovsxbd */, X86::PMOVSXBDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5109 /* pmovsxbd */, X86::PMOVSXBDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5118 /* pmovsxbq */, X86::PMOVSXBQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5118 /* pmovsxbq */, X86::PMOVSXBQrm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_FR32 }, },
  { 5127 /* pmovsxbw */, X86::PMOVSXBWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5127 /* pmovsxbw */, X86::PMOVSXBWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5136 /* pmovsxdq */, X86::PMOVSXDQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5136 /* pmovsxdq */, X86::PMOVSXDQrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5145 /* pmovsxwd */, X86::PMOVSXWDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5145 /* pmovsxwd */, X86::PMOVSXWDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5154 /* pmovsxwq */, X86::PMOVSXWQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5154 /* pmovsxwq */, X86::PMOVSXWQrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5163 /* pmovzxbd */, X86::PMOVZXBDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5163 /* pmovzxbd */, X86::PMOVZXBDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5172 /* pmovzxbq */, X86::PMOVZXBQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5172 /* pmovzxbq */, X86::PMOVZXBQrm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_FR32 }, },
  { 5181 /* pmovzxbw */, X86::PMOVZXBWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5181 /* pmovzxbw */, X86::PMOVZXBWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5190 /* pmovzxdq */, X86::PMOVZXDQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5190 /* pmovzxdq */, X86::PMOVZXDQrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5199 /* pmovzxwd */, X86::PMOVZXWDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5199 /* pmovzxwd */, X86::PMOVZXWDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5208 /* pmovzxwq */, X86::PMOVZXWQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5208 /* pmovzxwq */, X86::PMOVZXWQrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5217 /* pmuldq */, X86::PMULDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5217 /* pmuldq */, X86::PMULDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5224 /* pmulhrsw */, X86::MMX_PMULHRSWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5224 /* pmulhrsw */, X86::PMULHRSWrr128, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5224 /* pmulhrsw */, X86::PMULHRSWrm128, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5224 /* pmulhrsw */, X86::MMX_PMULHRSWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5233 /* pmulhrw */, X86::PMULHRWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5233 /* pmulhrw */, X86::PMULHRWrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5241 /* pmulhuw */, X86::MMX_PMULHUWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5241 /* pmulhuw */, X86::PMULHUWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5241 /* pmulhuw */, X86::PMULHUWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5241 /* pmulhuw */, X86::MMX_PMULHUWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5249 /* pmulhw */, X86::MMX_PMULHWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5249 /* pmulhw */, X86::PMULHWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5249 /* pmulhw */, X86::PMULHWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5249 /* pmulhw */, X86::MMX_PMULHWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5256 /* pmulld */, X86::PMULLDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5256 /* pmulld */, X86::PMULLDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5263 /* pmullw */, X86::MMX_PMULLWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5263 /* pmullw */, X86::PMULLWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5263 /* pmullw */, X86::PMULLWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5263 /* pmullw */, X86::MMX_PMULLWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5270 /* pmuludq */, X86::MMX_PMULUDQirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5270 /* pmuludq */, X86::PMULUDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5270 /* pmuludq */, X86::PMULUDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5270 /* pmuludq */, X86::MMX_PMULUDQirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5282 /* popal */, X86::POPA32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5288 /* popaw */, X86::POPA16, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5301 /* popcntl */, X86::POPCNT32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 5301 /* popcntl */, X86::POPCNT32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 5309 /* popcntq */, X86::POPCNT64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 5309 /* popcntq */, X86::POPCNT64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 5317 /* popcntw */, X86::POPCNT16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 5317 /* popcntw */, X86::POPCNT16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 5336 /* popfl */, X86::POPF32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5342 /* popfq */, X86::POPF64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 5348 /* popfw */, X86::POPF16, Convert_NoOperands, 0, {  }, },
  { 5354 /* popl */, X86::POP32r, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 5354 /* popl */, X86::POP32rmr, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 5354 /* popl */, X86::POPDS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 5354 /* popl */, X86::POPSS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 5354 /* popl */, X86::POPES32, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 5354 /* popl */, X86::POPFS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_FS }, },
  { 5354 /* popl */, X86::POPGS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_GS }, },
  { 5354 /* popl */, X86::POP32rmm, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 5359 /* popq */, X86::POP64r, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5359 /* popq */, X86::POP64rmr, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5359 /* popq */, X86::POPFS64, Convert_NoOperands, Feature_In64BitMode, { MCK_FS }, },
  { 5359 /* popq */, X86::POPGS64, Convert_NoOperands, Feature_In64BitMode, { MCK_GS }, },
  { 5359 /* popq */, X86::POP64rmm, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 5364 /* popw */, X86::POP16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5364 /* popw */, X86::POP16rmr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5364 /* popw */, X86::POPDS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 5364 /* popw */, X86::POPSS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 5364 /* popw */, X86::POPES16, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 5364 /* popw */, X86::POPFS16, Convert_NoOperands, 0, { MCK_FS }, },
  { 5364 /* popw */, X86::POPGS16, Convert_NoOperands, 0, { MCK_GS }, },
  { 5364 /* popw */, X86::POP16rmm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 5369 /* por */, X86::MMX_PORirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5369 /* por */, X86::PORrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5369 /* por */, X86::PORrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5369 /* por */, X86::MMX_PORirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5373 /* prefetch */, X86::PREFETCH, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5382 /* prefetchnta */, X86::PREFETCHNTA, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5394 /* prefetcht0 */, X86::PREFETCHT0, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5405 /* prefetcht1 */, X86::PREFETCHT1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5416 /* prefetcht2 */, X86::PREFETCHT2, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5427 /* prefetchw */, X86::PREFETCHW, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5437 /* psadbw */, X86::MMX_PSADBWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5437 /* psadbw */, X86::PSADBWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5437 /* psadbw */, X86::PSADBWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5437 /* psadbw */, X86::MMX_PSADBWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5444 /* pshufb */, X86::MMX_PSHUFBrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5444 /* pshufb */, X86::PSHUFBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5444 /* pshufb */, X86::PSHUFBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5444 /* pshufb */, X86::MMX_PSHUFBrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5451 /* pshufd */, X86::PSHUFDri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 5451 /* pshufd */, X86::PSHUFDmi, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 5458 /* pshufhw */, X86::PSHUFHWri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 5458 /* pshufhw */, X86::PSHUFHWmi, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 5466 /* pshuflw */, X86::PSHUFLWri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 5466 /* pshuflw */, X86::PSHUFLWmi, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 5474 /* pshufw */, X86::MMX_PSHUFWri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR64, MCK_VR64 }, },
  { 5474 /* pshufw */, X86::MMX_PSHUFWmi, Convert__Reg1_2__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64, MCK_VR64 }, },
  { 5481 /* psignb */, X86::MMX_PSIGNBrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5481 /* psignb */, X86::PSIGNBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5481 /* psignb */, X86::PSIGNBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5481 /* psignb */, X86::MMX_PSIGNBrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5488 /* psignd */, X86::MMX_PSIGNDrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5488 /* psignd */, X86::PSIGNDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5488 /* psignd */, X86::PSIGNDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5488 /* psignd */, X86::MMX_PSIGNDrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5495 /* psignw */, X86::MMX_PSIGNWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5495 /* psignw */, X86::PSIGNWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5495 /* psignw */, X86::PSIGNWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5495 /* psignw */, X86::MMX_PSIGNWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5502 /* pslld */, X86::MMX_PSLLDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5502 /* pslld */, X86::PSLLDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5502 /* pslld */, X86::MMX_PSLLDri, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR64 }, },
  { 5502 /* pslld */, X86::PSLLDri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_FR32 }, },
  { 5502 /* pslld */, X86::PSLLDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5502 /* pslld */, X86::MMX_PSLLDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5508 /* pslldq */, X86::PSLLDQri, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32 }, },
  { 5515 /* psllq */, X86::MMX_PSLLQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5515 /* psllq */, X86::PSLLQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5515 /* psllq */, X86::MMX_PSLLQri, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR64 }, },
  { 5515 /* psllq */, X86::PSLLQri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_FR32 }, },
  { 5515 /* psllq */, X86::PSLLQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5515 /* psllq */, X86::MMX_PSLLQrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5521 /* psllw */, X86::MMX_PSLLWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5521 /* psllw */, X86::PSLLWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5521 /* psllw */, X86::MMX_PSLLWri, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR64 }, },
  { 5521 /* psllw */, X86::PSLLWri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_FR32 }, },
  { 5521 /* psllw */, X86::PSLLWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5521 /* psllw */, X86::MMX_PSLLWrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5527 /* psrad */, X86::MMX_PSRADrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5527 /* psrad */, X86::PSRADrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5527 /* psrad */, X86::MMX_PSRADri, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR64 }, },
  { 5527 /* psrad */, X86::PSRADri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_FR32 }, },
  { 5527 /* psrad */, X86::PSRADrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5527 /* psrad */, X86::MMX_PSRADrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5533 /* psraw */, X86::MMX_PSRAWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5533 /* psraw */, X86::PSRAWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5533 /* psraw */, X86::MMX_PSRAWri, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR64 }, },
  { 5533 /* psraw */, X86::PSRAWri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_FR32 }, },
  { 5533 /* psraw */, X86::PSRAWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5533 /* psraw */, X86::MMX_PSRAWrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5539 /* psrld */, X86::MMX_PSRLDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5539 /* psrld */, X86::PSRLDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5539 /* psrld */, X86::MMX_PSRLDri, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR64 }, },
  { 5539 /* psrld */, X86::PSRLDri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_FR32 }, },
  { 5539 /* psrld */, X86::PSRLDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5539 /* psrld */, X86::MMX_PSRLDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5545 /* psrldq */, X86::PSRLDQri, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32 }, },
  { 5552 /* psrlq */, X86::MMX_PSRLQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5552 /* psrlq */, X86::PSRLQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5552 /* psrlq */, X86::MMX_PSRLQri, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR64 }, },
  { 5552 /* psrlq */, X86::PSRLQri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_FR32 }, },
  { 5552 /* psrlq */, X86::PSRLQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5552 /* psrlq */, X86::MMX_PSRLQrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5558 /* psrlw */, X86::MMX_PSRLWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5558 /* psrlw */, X86::PSRLWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5558 /* psrlw */, X86::MMX_PSRLWri, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR64 }, },
  { 5558 /* psrlw */, X86::PSRLWri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_FR32 }, },
  { 5558 /* psrlw */, X86::PSRLWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5558 /* psrlw */, X86::MMX_PSRLWrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5564 /* psubb */, X86::MMX_PSUBBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5564 /* psubb */, X86::PSUBBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5564 /* psubb */, X86::PSUBBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5564 /* psubb */, X86::MMX_PSUBBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5570 /* psubd */, X86::MMX_PSUBDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5570 /* psubd */, X86::PSUBDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5570 /* psubd */, X86::PSUBDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5570 /* psubd */, X86::MMX_PSUBDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5576 /* psubq */, X86::MMX_PSUBQirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5576 /* psubq */, X86::PSUBQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5576 /* psubq */, X86::PSUBQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5576 /* psubq */, X86::MMX_PSUBQirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5582 /* psubsb */, X86::MMX_PSUBSBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5582 /* psubsb */, X86::PSUBSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5582 /* psubsb */, X86::PSUBSBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5582 /* psubsb */, X86::MMX_PSUBSBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5589 /* psubsw */, X86::MMX_PSUBSWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5589 /* psubsw */, X86::PSUBSWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5589 /* psubsw */, X86::PSUBSWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5589 /* psubsw */, X86::MMX_PSUBSWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5596 /* psubusb */, X86::MMX_PSUBUSBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5596 /* psubusb */, X86::PSUBUSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5596 /* psubusb */, X86::PSUBUSBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5596 /* psubusb */, X86::MMX_PSUBUSBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5604 /* psubusw */, X86::MMX_PSUBUSWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5604 /* psubusw */, X86::PSUBUSWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5604 /* psubusw */, X86::PSUBUSWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5604 /* psubusw */, X86::MMX_PSUBUSWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5612 /* psubw */, X86::MMX_PSUBWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5612 /* psubw */, X86::PSUBWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5612 /* psubw */, X86::PSUBWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5612 /* psubw */, X86::MMX_PSUBWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5618 /* pswapd */, X86::PSWAPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5618 /* pswapd */, X86::PSWAPDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5625 /* ptest */, X86::PTESTrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5625 /* ptest */, X86::PTESTrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5631 /* punpckhbw */, X86::MMX_PUNPCKHBWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5631 /* punpckhbw */, X86::PUNPCKHBWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5631 /* punpckhbw */, X86::PUNPCKHBWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5631 /* punpckhbw */, X86::MMX_PUNPCKHBWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5641 /* punpckhdq */, X86::MMX_PUNPCKHDQirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5641 /* punpckhdq */, X86::PUNPCKHDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5641 /* punpckhdq */, X86::PUNPCKHDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5641 /* punpckhdq */, X86::MMX_PUNPCKHDQirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5651 /* punpckhqdq */, X86::PUNPCKHQDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5651 /* punpckhqdq */, X86::PUNPCKHQDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5662 /* punpckhwd */, X86::MMX_PUNPCKHWDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5662 /* punpckhwd */, X86::PUNPCKHWDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5662 /* punpckhwd */, X86::PUNPCKHWDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5662 /* punpckhwd */, X86::MMX_PUNPCKHWDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5672 /* punpcklbw */, X86::MMX_PUNPCKLBWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5672 /* punpcklbw */, X86::PUNPCKLBWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5672 /* punpcklbw */, X86::PUNPCKLBWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5672 /* punpcklbw */, X86::MMX_PUNPCKLBWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5682 /* punpckldq */, X86::MMX_PUNPCKLDQirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5682 /* punpckldq */, X86::PUNPCKLDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5682 /* punpckldq */, X86::PUNPCKLDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5682 /* punpckldq */, X86::MMX_PUNPCKLDQirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5692 /* punpcklqdq */, X86::PUNPCKLQDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5692 /* punpcklqdq */, X86::PUNPCKLQDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5703 /* punpcklwd */, X86::MMX_PUNPCKLWDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5703 /* punpcklwd */, X86::PUNPCKLWDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5703 /* punpcklwd */, X86::PUNPCKLWDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5703 /* punpcklwd */, X86::MMX_PUNPCKLWDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5718 /* pushal */, X86::PUSHA32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5725 /* pushaw */, X86::PUSHA16, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5745 /* pushfl */, X86::PUSHF32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5752 /* pushfq */, X86::PUSHF64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 5759 /* pushfw */, X86::PUSHF16, Convert_NoOperands, 0, {  }, },
  { 5766 /* pushl */, X86::PUSH32r, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 5766 /* pushl */, X86::PUSH32rmr, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 5766 /* pushl */, X86::PUSHCS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_CS }, },
  { 5766 /* pushl */, X86::PUSHDS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 5766 /* pushl */, X86::PUSHSS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 5766 /* pushl */, X86::PUSHES32, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 5766 /* pushl */, X86::PUSHFS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_FS }, },
  { 5766 /* pushl */, X86::PUSHGS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_GS }, },
  { 5766 /* pushl */, X86::PUSH32i8, Convert__ImmSExti32i81_0, Feature_Not64BitMode, { MCK_ImmSExti32i8 }, },
  { 5766 /* pushl */, X86::PUSHi32, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 5766 /* pushl */, X86::PUSH32rmm, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 5772 /* pushq */, X86::PUSH64r, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5772 /* pushq */, X86::PUSH64rmr, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5772 /* pushq */, X86::PUSHFS64, Convert_NoOperands, Feature_In64BitMode, { MCK_FS }, },
  { 5772 /* pushq */, X86::PUSHGS64, Convert_NoOperands, Feature_In64BitMode, { MCK_GS }, },
  { 5772 /* pushq */, X86::PUSH64i8, Convert__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8 }, },
  { 5772 /* pushq */, X86::PUSH64i32, Convert__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32 }, },
  { 5772 /* pushq */, X86::PUSH64rmm, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 5778 /* pushw */, X86::PUSH16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5778 /* pushw */, X86::PUSH16rmr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5778 /* pushw */, X86::PUSHCS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_CS }, },
  { 5778 /* pushw */, X86::PUSHDS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 5778 /* pushw */, X86::PUSHSS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 5778 /* pushw */, X86::PUSHES16, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 5778 /* pushw */, X86::PUSHFS16, Convert_NoOperands, 0, { MCK_FS }, },
  { 5778 /* pushw */, X86::PUSHGS16, Convert_NoOperands, 0, { MCK_GS }, },
  { 5778 /* pushw */, X86::PUSH16i8, Convert__ImmSExti16i81_0, Feature_Not64BitMode, { MCK_ImmSExti16i8 }, },
  { 5778 /* pushw */, X86::PUSH64i16, Convert__Imm1_0, Feature_In64BitMode, { MCK_Imm }, },
  { 5778 /* pushw */, X86::PUSHi16, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 5778 /* pushw */, X86::PUSH16rmm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 5784 /* pxor */, X86::MMX_PXORirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5784 /* pxor */, X86::PXORrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5784 /* pxor */, X86::PXORrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5784 /* pxor */, X86::MMX_PXORirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5793 /* rclb */, X86::RCL8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 5793 /* rclb */, X86::RCL8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5793 /* rclb */, X86::RCL8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 5793 /* rclb */, X86::RCL8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 5793 /* rclb */, X86::RCL8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 5793 /* rclb */, X86::RCL8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 5798 /* rcll */, X86::RCL32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 5798 /* rcll */, X86::RCL32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 5798 /* rcll */, X86::RCL32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 5798 /* rcll */, X86::RCL32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 5798 /* rcll */, X86::RCL32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 5798 /* rcll */, X86::RCL32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 5803 /* rclq */, X86::RCL64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 5803 /* rclq */, X86::RCL64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 5803 /* rclq */, X86::RCL64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 5803 /* rclq */, X86::RCL64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 5803 /* rclq */, X86::RCL64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 5803 /* rclq */, X86::RCL64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 5808 /* rclw */, X86::RCL16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 5808 /* rclw */, X86::RCL16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 5808 /* rclw */, X86::RCL16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 5808 /* rclw */, X86::RCL16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 5808 /* rclw */, X86::RCL16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 5808 /* rclw */, X86::RCL16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 5813 /* rcpps */, X86::RCPPSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5813 /* rcpps */, X86::RCPPSm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5819 /* rcpss */, X86::RCPSSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5819 /* rcpss */, X86::RCPSSm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5829 /* rcrb */, X86::RCR8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 5829 /* rcrb */, X86::RCR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5829 /* rcrb */, X86::RCR8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 5829 /* rcrb */, X86::RCR8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 5829 /* rcrb */, X86::RCR8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 5829 /* rcrb */, X86::RCR8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 5834 /* rcrl */, X86::RCR32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 5834 /* rcrl */, X86::RCR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 5834 /* rcrl */, X86::RCR32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 5834 /* rcrl */, X86::RCR32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 5834 /* rcrl */, X86::RCR32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 5834 /* rcrl */, X86::RCR32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 5839 /* rcrq */, X86::RCR64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 5839 /* rcrq */, X86::RCR64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 5839 /* rcrq */, X86::RCR64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 5839 /* rcrq */, X86::RCR64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 5839 /* rcrq */, X86::RCR64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 5839 /* rcrq */, X86::RCR64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 5844 /* rcrw */, X86::RCR16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 5844 /* rcrw */, X86::RCR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 5844 /* rcrw */, X86::RCR16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 5844 /* rcrw */, X86::RCR16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 5844 /* rcrw */, X86::RCR16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 5844 /* rcrw */, X86::RCR16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 5858 /* rdfsbasel */, X86::RDFSBASE, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR32 }, },
  { 5868 /* rdfsbaseq */, X86::RDFSBASE64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5887 /* rdgsbasel */, X86::RDGSBASE, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR32 }, },
  { 5897 /* rdgsbaseq */, X86::RDGSBASE64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5907 /* rdmsr */, X86::RDMSR, Convert_NoOperands, 0, {  }, },
  { 5913 /* rdpmc */, X86::RDPMC, Convert_NoOperands, 0, {  }, },
  { 5926 /* rdrandl */, X86::RDRAND32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 5934 /* rdrandq */, X86::RDRAND64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 5942 /* rdrandw */, X86::RDRAND16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5957 /* rdseedl */, X86::RDSEED32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 5965 /* rdseedq */, X86::RDSEED64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 5973 /* rdseedw */, X86::RDSEED16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5981 /* rdtsc */, X86::RDTSC, Convert_NoOperands, 0, {  }, },
  { 5987 /* rdtscp */, X86::RDTSCP, Convert_NoOperands, 0, {  }, },
  { 5994 /* rep */, X86::REP_PREFIX, Convert_NoOperands, 0, {  }, },
  { 5998 /* repne */, X86::REPNE_PREFIX, Convert_NoOperands, 0, {  }, },
  { 6019 /* retl */, X86::RETL, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 6019 /* retl */, X86::RETIL, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 6024 /* retq */, X86::RETQ, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 6024 /* retq */, X86::RETIQ, Convert__Imm1_0, Feature_In64BitMode, { MCK_Imm }, },
  { 6029 /* retw */, X86::RETW, Convert_NoOperands, 0, {  }, },
  { 6029 /* retw */, X86::RETIW, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 6034 /* rex64 */, X86::REX64_PREFIX, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 6044 /* rolb */, X86::ROL8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 6044 /* rolb */, X86::ROL8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6044 /* rolb */, X86::ROL8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 6044 /* rolb */, X86::ROL8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6044 /* rolb */, X86::ROL8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6044 /* rolb */, X86::ROL8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6049 /* roll */, X86::ROL32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 6049 /* roll */, X86::ROL32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6049 /* roll */, X86::ROL32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 6049 /* roll */, X86::ROL32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6049 /* roll */, X86::ROL32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6049 /* roll */, X86::ROL32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6054 /* rolq */, X86::ROL64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 6054 /* rolq */, X86::ROL64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 6054 /* rolq */, X86::ROL64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 6054 /* rolq */, X86::ROL64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 6054 /* rolq */, X86::ROL64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 6054 /* rolq */, X86::ROL64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 6059 /* rolw */, X86::ROL16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 6059 /* rolw */, X86::ROL16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6059 /* rolw */, X86::ROL16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 6059 /* rolw */, X86::ROL16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6059 /* rolw */, X86::ROL16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6059 /* rolw */, X86::ROL16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6068 /* rorb */, X86::ROR8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 6068 /* rorb */, X86::ROR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6068 /* rorb */, X86::ROR8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 6068 /* rorb */, X86::ROR8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6068 /* rorb */, X86::ROR8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6068 /* rorb */, X86::ROR8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6073 /* rorl */, X86::ROR32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 6073 /* rorl */, X86::ROR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6073 /* rorl */, X86::ROR32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 6073 /* rorl */, X86::ROR32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6073 /* rorl */, X86::ROR32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6073 /* rorl */, X86::ROR32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6078 /* rorq */, X86::ROR64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 6078 /* rorq */, X86::ROR64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 6078 /* rorq */, X86::ROR64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 6078 /* rorq */, X86::ROR64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 6078 /* rorq */, X86::ROR64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 6078 /* rorq */, X86::ROR64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 6083 /* rorw */, X86::ROR16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 6083 /* rorw */, X86::ROR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6083 /* rorw */, X86::ROR16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 6083 /* rorw */, X86::ROR16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6083 /* rorw */, X86::ROR16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6083 /* rorw */, X86::ROR16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6093 /* rorxl */, X86::RORX32ri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 6093 /* rorxl */, X86::RORX32mi, Convert__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 6099 /* rorxq */, X86::RORX64ri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64, MCK_GR64 }, },
  { 6099 /* rorxq */, X86::RORX64mi, Convert__Reg1_2__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64, MCK_GR64 }, },
  { 6105 /* roundpd */, X86::ROUNDPDr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_FR32 }, },
  { 6105 /* roundpd */, X86::ROUNDPDm, Convert__Reg1_2__Mem1285_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem128, MCK_FR32 }, },
  { 6113 /* roundps */, X86::ROUNDPSr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_FR32 }, },
  { 6113 /* roundps */, X86::ROUNDPSm, Convert__Reg1_2__Mem1285_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem128, MCK_FR32 }, },
  { 6121 /* roundsd */, X86::ROUNDSDr, Convert__Reg1_2__Tie0__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_FR32 }, },
  { 6121 /* roundsd */, X86::ROUNDSDm, Convert__Reg1_2__Tie0__Mem645_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem64, MCK_FR32 }, },
  { 6129 /* roundss */, X86::ROUNDSSr, Convert__Reg1_2__Tie0__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_FR32 }, },
  { 6129 /* roundss */, X86::ROUNDSSm, Convert__Reg1_2__Tie0__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32, MCK_FR32 }, },
  { 6137 /* rsm */, X86::RSM, Convert_NoOperands, 0, {  }, },
  { 6141 /* rsqrtps */, X86::RSQRTPSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6141 /* rsqrtps */, X86::RSQRTPSm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6149 /* rsqrtss */, X86::RSQRTSSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6149 /* rsqrtss */, X86::RSQRTSSm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 6157 /* sahf */, X86::SAHF, Convert_NoOperands, 0, {  }, },
  { 6166 /* sarb */, X86::SAR8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 6166 /* sarb */, X86::SAR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6166 /* sarb */, X86::SAR8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 6166 /* sarb */, X86::SAR8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6166 /* sarb */, X86::SAR8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6166 /* sarb */, X86::SAR8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6171 /* sarl */, X86::SAR32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 6171 /* sarl */, X86::SAR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6171 /* sarl */, X86::SAR32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 6171 /* sarl */, X86::SAR32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6171 /* sarl */, X86::SAR32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6171 /* sarl */, X86::SAR32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6176 /* sarq */, X86::SAR64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 6176 /* sarq */, X86::SAR64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 6176 /* sarq */, X86::SAR64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 6176 /* sarq */, X86::SAR64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 6176 /* sarq */, X86::SAR64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 6176 /* sarq */, X86::SAR64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 6181 /* sarw */, X86::SAR16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 6181 /* sarw */, X86::SAR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6181 /* sarw */, X86::SAR16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 6181 /* sarw */, X86::SAR16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6181 /* sarw */, X86::SAR16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6181 /* sarw */, X86::SAR16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6191 /* sarxl */, X86::SARX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 6191 /* sarxl */, X86::SARX32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 6197 /* sarxq */, X86::SARX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 6197 /* sarxq */, X86::SARX64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 6207 /* sbbb */, X86::SBB8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 6207 /* sbbb */, X86::SBB8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 6207 /* sbbb */, X86::SBB8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 6207 /* sbbb */, X86::SBB8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6207 /* sbbb */, X86::SBB8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6207 /* sbbb */, X86::SBB8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 6212 /* sbbl */, X86::SBB32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 6212 /* sbbl */, X86::SBB32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 6212 /* sbbl */, X86::SBB32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 6212 /* sbbl */, X86::SBB32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 6212 /* sbbl */, X86::SBB32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 6212 /* sbbl */, X86::SBB32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6212 /* sbbl */, X86::SBB32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6212 /* sbbl */, X86::SBB32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 6217 /* sbbq */, X86::SBB64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 6217 /* sbbq */, X86::SBB64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 6217 /* sbbq */, X86::SBB64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 6217 /* sbbq */, X86::SBB64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 6217 /* sbbq */, X86::SBB64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 6217 /* sbbq */, X86::SBB64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 6217 /* sbbq */, X86::SBB64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 6217 /* sbbq */, X86::SBB64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 6222 /* sbbw */, X86::SBB16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 6222 /* sbbw */, X86::SBB16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 6222 /* sbbw */, X86::SBB16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 6222 /* sbbw */, X86::SBB16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 6222 /* sbbw */, X86::SBB16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 6222 /* sbbw */, X86::SBB16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6222 /* sbbw */, X86::SBB16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6222 /* sbbw */, X86::SBB16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 6227 /* scas */, X86::SCASW, Convert__DstIdx161_0, 0, { MCK_DstIdx16, MCK_AX }, },
  { 6227 /* scas */, X86::SCASL, Convert__DstIdx321_0, 0, { MCK_DstIdx32, MCK_EAX }, },
  { 6227 /* scas */, X86::SCASQ, Convert__DstIdx641_0, Feature_In64BitMode, { MCK_DstIdx64, MCK_RAX }, },
  { 6227 /* scas */, X86::SCASB, Convert__DstIdx81_0, 0, { MCK_DstIdx8, MCK_AL }, },
  { 6232 /* scasb */, X86::SCASB, Convert__DstIdx81_0, 0, { MCK_DstIdx8 }, },
  { 6232 /* scasb */, X86::SCASB, Convert__DstIdx81_0, 0, { MCK_DstIdx8, MCK_AL }, },
  { 6244 /* scasl */, X86::SCASL, Convert__DstIdx321_0, 0, { MCK_DstIdx32 }, },
  { 6244 /* scasl */, X86::SCASL, Convert__DstIdx321_0, 0, { MCK_DstIdx32, MCK_EAX }, },
  { 6250 /* scasq */, X86::SCASQ, Convert__DstIdx641_0, Feature_In64BitMode, { MCK_DstIdx64 }, },
  { 6250 /* scasq */, X86::SCASQ, Convert__DstIdx641_0, 0, { MCK_DstIdx64, MCK_RAX }, },
  { 6256 /* scasw */, X86::SCASW, Convert__DstIdx161_0, 0, { MCK_DstIdx16 }, },
  { 6256 /* scasw */, X86::SCASW, Convert__DstIdx161_0, 0, { MCK_DstIdx16, MCK_AX }, },
  { 6262 /* seta */, X86::SETAr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6262 /* seta */, X86::SETAm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6267 /* setae */, X86::SETAEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6267 /* setae */, X86::SETAEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6273 /* setb */, X86::SETBr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6273 /* setb */, X86::SETBm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6278 /* setbe */, X86::SETBEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6278 /* setbe */, X86::SETBEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6284 /* sete */, X86::SETEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6284 /* sete */, X86::SETEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6289 /* setg */, X86::SETGr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6289 /* setg */, X86::SETGm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6294 /* setge */, X86::SETGEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6294 /* setge */, X86::SETGEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6300 /* setl */, X86::SETLr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6300 /* setl */, X86::SETLm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6305 /* setle */, X86::SETLEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6305 /* setle */, X86::SETLEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6311 /* setne */, X86::SETNEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6311 /* setne */, X86::SETNEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6317 /* setno */, X86::SETNOr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6317 /* setno */, X86::SETNOm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6323 /* setnp */, X86::SETNPr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6323 /* setnp */, X86::SETNPm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6329 /* setns */, X86::SETNSr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6329 /* setns */, X86::SETNSm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6335 /* seto */, X86::SETOr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6335 /* seto */, X86::SETOm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6340 /* setp */, X86::SETPr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6340 /* setp */, X86::SETPm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6345 /* sets */, X86::SETSr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6345 /* sets */, X86::SETSm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6350 /* sfence */, X86::SFENCE, Convert_NoOperands, 0, {  }, },
  { 6362 /* sgdtl */, X86::SGDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 6368 /* sgdtq */, X86::SGDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 6374 /* sgdtw */, X86::SGDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 6380 /* sha1msg1 */, X86::SHA1MSG1rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6380 /* sha1msg1 */, X86::SHA1MSG1rm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6389 /* sha1msg2 */, X86::SHA1MSG2rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6389 /* sha1msg2 */, X86::SHA1MSG2rm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6398 /* sha1nexte */, X86::SHA1NEXTErr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6398 /* sha1nexte */, X86::SHA1NEXTErm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6408 /* sha1rnds4 */, X86::SHA1RNDS4rri, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 6408 /* sha1rnds4 */, X86::SHA1RNDS4rmi, Convert__Reg1_2__Tie0__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 6418 /* sha256msg1 */, X86::SHA256MSG1rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6418 /* sha256msg1 */, X86::SHA256MSG1rm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6429 /* sha256msg2 */, X86::SHA256MSG2rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6429 /* sha256msg2 */, X86::SHA256MSG2rm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6440 /* sha256rnds2 */, X86::SHA256RNDS2rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6440 /* sha256rnds2 */, X86::SHA256RNDS2rm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6440 /* sha256rnds2 */, X86::SHA256RNDS2rr, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_XMM0, MCK_FR32, MCK_FR32 }, },
  { 6440 /* sha256rnds2 */, X86::SHA256RNDS2rm, Convert__Reg1_2__Tie0__Mem1285_1, 0, { MCK_XMM0, MCK_Mem128, MCK_FR32 }, },
  { 6456 /* shlb */, X86::SHL8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 6456 /* shlb */, X86::SHL8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6456 /* shlb */, X86::SHL8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 6456 /* shlb */, X86::SHL8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6456 /* shlb */, X86::SHL8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6456 /* shlb */, X86::SHL8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6466 /* shldl */, X86::SHLD32rrCL, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 6466 /* shldl */, X86::SHLD32mrCL, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 6466 /* shldl */, X86::SHLD32rrCL, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_CL, MCK_GR32, MCK_GR32 }, },
  { 6466 /* shldl */, X86::SHLD32mrCL, Convert__Mem325_2__Reg1_1, 0, { MCK_CL, MCK_GR32, MCK_Mem32 }, },
  { 6466 /* shldl */, X86::SHLD32rri8, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 6466 /* shldl */, X86::SHLD32mri8, Convert__Mem325_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_Mem32 }, },
  { 6472 /* shldq */, X86::SHLD64rrCL, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 6472 /* shldq */, X86::SHLD64mrCL, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 6472 /* shldq */, X86::SHLD64rrCL, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_CL, MCK_GR64, MCK_GR64 }, },
  { 6472 /* shldq */, X86::SHLD64mrCL, Convert__Mem645_2__Reg1_1, 0, { MCK_CL, MCK_GR64, MCK_Mem64 }, },
  { 6472 /* shldq */, X86::SHLD64rri8, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64, MCK_GR64 }, },
  { 6472 /* shldq */, X86::SHLD64mri8, Convert__Mem645_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64, MCK_Mem64 }, },
  { 6478 /* shldw */, X86::SHLD16rrCL, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 6478 /* shldw */, X86::SHLD16mrCL, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 6478 /* shldw */, X86::SHLD16rrCL, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_CL, MCK_GR16, MCK_GR16 }, },
  { 6478 /* shldw */, X86::SHLD16mrCL, Convert__Mem165_2__Reg1_1, 0, { MCK_CL, MCK_GR16, MCK_Mem16 }, },
  { 6478 /* shldw */, X86::SHLD16rri8, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 6478 /* shldw */, X86::SHLD16mri8, Convert__Mem165_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16, MCK_Mem16 }, },
  { 6484 /* shll */, X86::SHL32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 6484 /* shll */, X86::SHL32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6484 /* shll */, X86::SHL32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 6484 /* shll */, X86::SHL32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6484 /* shll */, X86::SHL32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6484 /* shll */, X86::SHL32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6489 /* shlq */, X86::SHL64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 6489 /* shlq */, X86::SHL64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 6489 /* shlq */, X86::SHL64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 6489 /* shlq */, X86::SHL64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 6489 /* shlq */, X86::SHL64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 6489 /* shlq */, X86::SHL64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 6494 /* shlw */, X86::SHL16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 6494 /* shlw */, X86::SHL16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6494 /* shlw */, X86::SHL16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 6494 /* shlw */, X86::SHL16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6494 /* shlw */, X86::SHL16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6494 /* shlw */, X86::SHL16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6504 /* shlxl */, X86::SHLX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 6504 /* shlxl */, X86::SHLX32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 6510 /* shlxq */, X86::SHLX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 6510 /* shlxq */, X86::SHLX64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 6520 /* shrb */, X86::SHR8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 6520 /* shrb */, X86::SHR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6520 /* shrb */, X86::SHR8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 6520 /* shrb */, X86::SHR8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6520 /* shrb */, X86::SHR8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6520 /* shrb */, X86::SHR8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6530 /* shrdl */, X86::SHRD32rrCL, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 6530 /* shrdl */, X86::SHRD32mrCL, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 6530 /* shrdl */, X86::SHRD32rrCL, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_CL, MCK_GR32, MCK_GR32 }, },
  { 6530 /* shrdl */, X86::SHRD32mrCL, Convert__Mem325_2__Reg1_1, 0, { MCK_CL, MCK_GR32, MCK_Mem32 }, },
  { 6530 /* shrdl */, X86::SHRD32rri8, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 6530 /* shrdl */, X86::SHRD32mri8, Convert__Mem325_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_Mem32 }, },
  { 6536 /* shrdq */, X86::SHRD64rrCL, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 6536 /* shrdq */, X86::SHRD64mrCL, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 6536 /* shrdq */, X86::SHRD64rrCL, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_CL, MCK_GR64, MCK_GR64 }, },
  { 6536 /* shrdq */, X86::SHRD64mrCL, Convert__Mem645_2__Reg1_1, 0, { MCK_CL, MCK_GR64, MCK_Mem64 }, },
  { 6536 /* shrdq */, X86::SHRD64rri8, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64, MCK_GR64 }, },
  { 6536 /* shrdq */, X86::SHRD64mri8, Convert__Mem645_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64, MCK_Mem64 }, },
  { 6542 /* shrdw */, X86::SHRD16rrCL, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 6542 /* shrdw */, X86::SHRD16mrCL, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 6542 /* shrdw */, X86::SHRD16rrCL, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_CL, MCK_GR16, MCK_GR16 }, },
  { 6542 /* shrdw */, X86::SHRD16mrCL, Convert__Mem165_2__Reg1_1, 0, { MCK_CL, MCK_GR16, MCK_Mem16 }, },
  { 6542 /* shrdw */, X86::SHRD16rri8, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 6542 /* shrdw */, X86::SHRD16mri8, Convert__Mem165_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16, MCK_Mem16 }, },
  { 6548 /* shrl */, X86::SHR32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 6548 /* shrl */, X86::SHR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6548 /* shrl */, X86::SHR32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 6548 /* shrl */, X86::SHR32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6548 /* shrl */, X86::SHR32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6548 /* shrl */, X86::SHR32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6553 /* shrq */, X86::SHR64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 6553 /* shrq */, X86::SHR64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 6553 /* shrq */, X86::SHR64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 6553 /* shrq */, X86::SHR64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 6553 /* shrq */, X86::SHR64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 6553 /* shrq */, X86::SHR64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 6558 /* shrw */, X86::SHR16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 6558 /* shrw */, X86::SHR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6558 /* shrw */, X86::SHR16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 6558 /* shrw */, X86::SHR16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6558 /* shrw */, X86::SHR16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6558 /* shrw */, X86::SHR16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6568 /* shrxl */, X86::SHRX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 6568 /* shrxl */, X86::SHRX32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 6574 /* shrxq */, X86::SHRX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 6574 /* shrxq */, X86::SHRX64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 6580 /* shufpd */, X86::SHUFPDrri, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 6580 /* shufpd */, X86::SHUFPDrmi, Convert__Reg1_2__Tie0__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 6587 /* shufps */, X86::SHUFPSrri, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 6587 /* shufps */, X86::SHUFPSrmi, Convert__Reg1_2__Tie0__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 6599 /* sidtl */, X86::SIDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 6605 /* sidtq */, X86::SIDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 6611 /* sidtw */, X86::SIDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 6617 /* skinit */, X86::SKINIT, Convert_NoOperands, 0, { MCK_EAX }, },
  { 6624 /* sldt */, X86::SLDT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6629 /* sldtl */, X86::SLDT32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 6635 /* sldtq */, X86::SLDT64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 6635 /* sldtq */, X86::SLDT64m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6641 /* sldtw */, X86::SLDT16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6641 /* sldtw */, X86::SLDT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6652 /* smswl */, X86::SMSW32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 6658 /* smswq */, X86::SMSW64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 6664 /* smsww */, X86::SMSW16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6664 /* smsww */, X86::SMSW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6670 /* sqrtpd */, X86::SQRTPDr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6670 /* sqrtpd */, X86::SQRTPDm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6677 /* sqrtps */, X86::SQRTPSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6677 /* sqrtps */, X86::SQRTPSm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6684 /* sqrtsd */, X86::SQRTSDr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6684 /* sqrtsd */, X86::SQRTSDm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 6691 /* sqrtss */, X86::SQRTSSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6691 /* sqrtss */, X86::SQRTSSm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 6698 /* ss */, X86::SS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 6701 /* stac */, X86::STAC, Convert_NoOperands, 0, {  }, },
  { 6706 /* stc */, X86::STC, Convert_NoOperands, 0, {  }, },
  { 6710 /* std */, X86::STD, Convert_NoOperands, 0, {  }, },
  { 6714 /* stgi */, X86::STGI, Convert_NoOperands, 0, {  }, },
  { 6719 /* sti */, X86::STI, Convert_NoOperands, 0, {  }, },
  { 6723 /* stmxcsr */, X86::STMXCSR, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6731 /* stos */, X86::STOSB, Convert__DstIdx81_1, 0, { MCK_AL, MCK_DstIdx8 }, },
  { 6731 /* stos */, X86::STOSW, Convert__DstIdx161_1, 0, { MCK_AX, MCK_DstIdx16 }, },
  { 6731 /* stos */, X86::STOSL, Convert__DstIdx321_1, 0, { MCK_EAX, MCK_DstIdx32 }, },
  { 6731 /* stos */, X86::STOSQ, Convert__DstIdx641_1, Feature_In64BitMode, { MCK_RAX, MCK_DstIdx64 }, },
  { 6736 /* stosb */, X86::STOSB, Convert__DstIdx81_0, 0, { MCK_DstIdx8 }, },
  { 6736 /* stosb */, X86::STOSB, Convert__DstIdx81_1, 0, { MCK_AL, MCK_DstIdx8 }, },
  { 6748 /* stosl */, X86::STOSL, Convert__DstIdx321_0, 0, { MCK_DstIdx32 }, },
  { 6748 /* stosl */, X86::STOSL, Convert__DstIdx321_1, 0, { MCK_EAX, MCK_DstIdx32 }, },
  { 6754 /* stosq */, X86::STOSQ, Convert__DstIdx641_0, Feature_In64BitMode, { MCK_DstIdx64 }, },
  { 6754 /* stosq */, X86::STOSQ, Convert__DstIdx641_1, 0, { MCK_RAX, MCK_DstIdx64 }, },
  { 6760 /* stosw */, X86::STOSW, Convert__DstIdx161_0, 0, { MCK_DstIdx16 }, },
  { 6760 /* stosw */, X86::STOSW, Convert__DstIdx161_1, 0, { MCK_AX, MCK_DstIdx16 }, },
  { 6770 /* strl */, X86::STR32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 6775 /* strq */, X86::STR64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 6780 /* strw */, X86::STR16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6780 /* strw */, X86::STRm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6789 /* subb */, X86::SUB8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 6789 /* subb */, X86::SUB8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 6789 /* subb */, X86::SUB8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 6789 /* subb */, X86::SUB8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6789 /* subb */, X86::SUB8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6789 /* subb */, X86::SUB8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 6794 /* subl */, X86::SUB32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 6794 /* subl */, X86::SUB32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 6794 /* subl */, X86::SUB32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 6794 /* subl */, X86::SUB32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 6794 /* subl */, X86::SUB32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 6794 /* subl */, X86::SUB32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6794 /* subl */, X86::SUB32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6794 /* subl */, X86::SUB32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 6799 /* subpd */, X86::SUBPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6799 /* subpd */, X86::SUBPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6805 /* subps */, X86::SUBPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6805 /* subps */, X86::SUBPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6811 /* subq */, X86::SUB64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 6811 /* subq */, X86::SUB64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 6811 /* subq */, X86::SUB64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 6811 /* subq */, X86::SUB64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 6811 /* subq */, X86::SUB64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 6811 /* subq */, X86::SUB64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 6811 /* subq */, X86::SUB64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 6811 /* subq */, X86::SUB64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 6816 /* subsd */, X86::SUBSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6816 /* subsd */, X86::SUBSDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 6822 /* subss */, X86::SUBSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6822 /* subss */, X86::SUBSSrm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 6828 /* subw */, X86::SUB16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 6828 /* subw */, X86::SUB16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 6828 /* subw */, X86::SUB16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 6828 /* subw */, X86::SUB16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 6828 /* subw */, X86::SUB16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 6828 /* subw */, X86::SUB16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6828 /* subw */, X86::SUB16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6828 /* subw */, X86::SUB16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 6833 /* swapgs */, X86::SWAPGS, Convert_NoOperands, 0, {  }, },
  { 6840 /* syscall */, X86::SYSCALL, Convert_NoOperands, 0, {  }, },
  { 6848 /* sysenter */, X86::SYSENTER, Convert_NoOperands, 0, {  }, },
  { 6865 /* sysexitl */, X86::SYSEXIT, Convert_NoOperands, 0, {  }, },
  { 6874 /* sysexitq */, X86::SYSEXIT64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 6890 /* sysretl */, X86::SYSRET, Convert_NoOperands, 0, {  }, },
  { 6898 /* sysretq */, X86::SYSRET64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 6906 /* t1mskc */, X86::T1MSKC32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 6906 /* t1mskc */, X86::T1MSKC64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 6906 /* t1mskc */, X86::T1MSKC32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 6906 /* t1mskc */, X86::T1MSKC64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 6918 /* testb */, X86::TEST8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 6918 /* testb */, X86::TEST8rm, Convert__Reg1_0__Mem85_1, 0, { MCK_GR8, MCK_Mem8 }, },
  { 6918 /* testb */, X86::TEST8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 6918 /* testb */, X86::TEST8ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6918 /* testb */, X86::TEST8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6918 /* testb */, X86::TEST8rm, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 6924 /* testl */, X86::TEST32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 6924 /* testl */, X86::TEST32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 6924 /* testl */, X86::TEST32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 6924 /* testl */, X86::TEST32ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6924 /* testl */, X86::TEST32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6924 /* testl */, X86::TEST32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 6930 /* testq */, X86::TEST64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 6930 /* testq */, X86::TEST64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 6930 /* testq */, X86::TEST64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 6930 /* testq */, X86::TEST64ri32, Convert__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 6930 /* testq */, X86::TEST64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 6930 /* testq */, X86::TEST64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 6936 /* testw */, X86::TEST16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 6936 /* testw */, X86::TEST16rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 6936 /* testw */, X86::TEST16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 6936 /* testw */, X86::TEST16ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6936 /* testw */, X86::TEST16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6936 /* testw */, X86::TEST16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 6948 /* tzcntl */, X86::TZCNT32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 6948 /* tzcntl */, X86::TZCNT32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 6955 /* tzcntq */, X86::TZCNT64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 6955 /* tzcntq */, X86::TZCNT64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 6962 /* tzcntw */, X86::TZCNT16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 6962 /* tzcntw */, X86::TZCNT16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 6969 /* tzmsk */, X86::TZMSK32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 6969 /* tzmsk */, X86::TZMSK64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 6969 /* tzmsk */, X86::TZMSK32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 6969 /* tzmsk */, X86::TZMSK64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 6975 /* ucomisd */, X86::UCOMISDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6975 /* ucomisd */, X86::UCOMISDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 6983 /* ucomiss */, X86::UCOMISSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6983 /* ucomiss */, X86::UCOMISSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 6991 /* ud2 */, X86::TRAP, Convert_NoOperands, 0, {  }, },
  { 6995 /* ud2b */, X86::UD2B, Convert_NoOperands, 0, {  }, },
  { 7000 /* unpckhpd */, X86::UNPCKHPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7000 /* unpckhpd */, X86::UNPCKHPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7009 /* unpckhps */, X86::UNPCKHPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7009 /* unpckhps */, X86::UNPCKHPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7018 /* unpcklpd */, X86::UNPCKLPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7018 /* unpcklpd */, X86::UNPCKLPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7027 /* unpcklps */, X86::UNPCKLPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7027 /* unpcklps */, X86::UNPCKLPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7036 /* vaddpd */, X86::VADDPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7036 /* vaddpd */, X86::VADDPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7036 /* vaddpd */, X86::VADDPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7036 /* vaddpd */, X86::VADDPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7036 /* vaddpd */, X86::VADDPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7036 /* vaddpd */, X86::VADDPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7036 /* vaddpd */, X86::VADDPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 7036 /* vaddpd */, X86::VADDPDZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7036 /* vaddpd */, X86::VADDPDZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7036 /* vaddpd */, X86::VADDPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7036 /* vaddpd */, X86::VADDPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7036 /* vaddpd */, X86::VADDPDZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7036 /* vaddpd */, X86::VADDPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7043 /* vaddps */, X86::VADDPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7043 /* vaddps */, X86::VADDPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7043 /* vaddps */, X86::VADDPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7043 /* vaddps */, X86::VADDPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7043 /* vaddps */, X86::VADDPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7043 /* vaddps */, X86::VADDPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7043 /* vaddps */, X86::VADDPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 7043 /* vaddps */, X86::VADDPSZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7043 /* vaddps */, X86::VADDPSZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7043 /* vaddps */, X86::VADDPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7043 /* vaddps */, X86::VADDPSZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7043 /* vaddps */, X86::VADDPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7043 /* vaddps */, X86::VADDPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7050 /* vaddsd */, X86::VADDSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7050 /* vaddsd */, X86::VADDSDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7050 /* vaddsd */, X86::VADDSDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 7050 /* vaddsd */, X86::VADDSDZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 7057 /* vaddss */, X86::VADDSSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7057 /* vaddss */, X86::VADDSSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7057 /* vaddss */, X86::VADDSSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 7057 /* vaddss */, X86::VADDSSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 7064 /* vaddsubpd */, X86::VADDSUBPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7064 /* vaddsubpd */, X86::VADDSUBPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7064 /* vaddsubpd */, X86::VADDSUBPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7064 /* vaddsubpd */, X86::VADDSUBPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7074 /* vaddsubps */, X86::VADDSUBPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7074 /* vaddsubps */, X86::VADDSUBPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7074 /* vaddsubps */, X86::VADDSUBPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7074 /* vaddsubps */, X86::VADDSUBPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7084 /* vaesdec */, X86::VAESDECrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7084 /* vaesdec */, X86::VAESDECrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7092 /* vaesdeclast */, X86::VAESDECLASTrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7092 /* vaesdeclast */, X86::VAESDECLASTrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7104 /* vaesenc */, X86::VAESENCrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7104 /* vaesenc */, X86::VAESENCrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7112 /* vaesenclast */, X86::VAESENCLASTrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7112 /* vaesenclast */, X86::VAESENCLASTrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7124 /* vaesimc */, X86::VAESIMCrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7124 /* vaesimc */, X86::VAESIMCrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7132 /* vaeskeygenassist */, X86::VAESKEYGENASSIST128rr, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 7132 /* vaeskeygenassist */, X86::VAESKEYGENASSIST128rm, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 7149 /* valignd */, X86::VALIGNDrri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7149 /* valignd */, X86::VALIGNDrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7157 /* valignq */, X86::VALIGNQrri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7157 /* valignq */, X86::VALIGNQrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7165 /* vandnpd */, X86::VANDNPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7165 /* vandnpd */, X86::VANDNPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7165 /* vandnpd */, X86::VANDNPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7165 /* vandnpd */, X86::VANDNPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7173 /* vandnps */, X86::VANDNPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7173 /* vandnps */, X86::VANDNPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7173 /* vandnps */, X86::VANDNPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7173 /* vandnps */, X86::VANDNPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7181 /* vandpd */, X86::VANDPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7181 /* vandpd */, X86::VANDPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7181 /* vandpd */, X86::VANDPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7181 /* vandpd */, X86::VANDPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7188 /* vandps */, X86::VANDPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7188 /* vandps */, X86::VANDPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7188 /* vandps */, X86::VANDPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7188 /* vandps */, X86::VANDPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7195 /* vblendmpd */, X86::VBLENDMPDZrr, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7195 /* vblendmpd */, X86::VBLENDMPDZrm, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7205 /* vblendmps */, X86::VBLENDMPSZrr, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7205 /* vblendmps */, X86::VBLENDMPSZrm, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7215 /* vblendpd */, X86::VBLENDPDrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7215 /* vblendpd */, X86::VBLENDPDYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7215 /* vblendpd */, X86::VBLENDPDrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7215 /* vblendpd */, X86::VBLENDPDYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7224 /* vblendps */, X86::VBLENDPSrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7224 /* vblendps */, X86::VBLENDPSYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7224 /* vblendps */, X86::VBLENDPSrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7224 /* vblendps */, X86::VBLENDPSYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7233 /* vblendvpd */, X86::VBLENDVPDrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7233 /* vblendvpd */, X86::VBLENDVPDrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7233 /* vblendvpd */, X86::VBLENDVPDYrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7233 /* vblendvpd */, X86::VBLENDVPDYrm, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7243 /* vblendvps */, X86::VBLENDVPSrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7243 /* vblendvps */, X86::VBLENDVPSrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7243 /* vblendvps */, X86::VBLENDVPSYrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7243 /* vblendvps */, X86::VBLENDVPSYrm, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7253 /* vbroadcastf128 */, X86::VBROADCASTF128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 7268 /* vbroadcasti128 */, X86::VBROADCASTI128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 7283 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4rm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512 }, },
  { 7283 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4krm, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7299 /* vbroadcasti64x4 */, X86::VBROADCASTI64X4rm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 7299 /* vbroadcasti64x4 */, X86::VBROADCASTI64X4krm, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7315 /* vbroadcastsd */, X86::VBROADCASTSDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 7315 /* vbroadcastsd */, X86::VBROADCASTSDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512 }, },
  { 7315 /* vbroadcastsd */, X86::VBROADCASTSDYrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR256 }, },
  { 7315 /* vbroadcastsd */, X86::VBROADCASTSDZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_VR512 }, },
  { 7328 /* vbroadcastss */, X86::VBROADCASTSSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7328 /* vbroadcastss */, X86::VBROADCASTSSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 7328 /* vbroadcastss */, X86::VBROADCASTSSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512 }, },
  { 7328 /* vbroadcastss */, X86::VBROADCASTSSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 7328 /* vbroadcastss */, X86::VBROADCASTSSYrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR256 }, },
  { 7328 /* vbroadcastss */, X86::VBROADCASTSSZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_VR512 }, },
  { 7341 /* vcmp */, X86::VCMPPDrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7341 /* vcmp */, X86::VCMPPDYrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7341 /* vcmp */, X86::VCMPPDZrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_pd, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7341 /* vcmp */, X86::VCMPPDrmi, Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7341 /* vcmp */, X86::VCMPPDYrmi, Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7341 /* vcmp */, X86::VCMPPDZrmi, Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_pd, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 7341 /* vcmp */, X86::VCMPPSrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7341 /* vcmp */, X86::VCMPPSYrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7341 /* vcmp */, X86::VCMPPSZrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ps, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7341 /* vcmp */, X86::VCMPPSrmi, Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7341 /* vcmp */, X86::VCMPPSYrmi, Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7341 /* vcmp */, X86::VCMPPSZrmi, Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ps, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 7341 /* vcmp */, X86::VCMPSDrr, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7341 /* vcmp */, X86::VCMPSDZrr, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_sd, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 7341 /* vcmp */, X86::VCMPSDrm, Convert__Reg1_4__Reg1_3__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 7341 /* vcmp */, X86::VCMPSDZrm, Convert__Reg1_4__Reg1_3__Mem645_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_sd, MCK_Mem64, MCK_FR32X, MCK_VK1 }, },
  { 7341 /* vcmp */, X86::VCMPSSrr, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7341 /* vcmp */, X86::VCMPSSZrr, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ss, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 7341 /* vcmp */, X86::VCMPSSrm, Convert__Reg1_4__Reg1_3__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 7341 /* vcmp */, X86::VCMPSSZrm, Convert__Reg1_4__Reg1_3__Mem325_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ss, MCK_Mem32, MCK_FR32X, MCK_VK1 }, },
  { 7341 /* vcmp */, X86::VCMPPDZrrib, Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_pd, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7341 /* vcmp */, X86::VCMPPSZrrib, Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ps, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7346 /* vcmppd */, X86::VCMPPDrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7346 /* vcmppd */, X86::VCMPPDYrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7346 /* vcmppd */, X86::VCMPPDZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7346 /* vcmppd */, X86::VCMPPDrmi_alt, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7346 /* vcmppd */, X86::VCMPPDYrmi_alt, Convert__Reg1_3__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7346 /* vcmppd */, X86::VCMPPDZrmi_alt, Convert__Reg1_3__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 7353 /* vcmpps */, X86::VCMPPSrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7353 /* vcmpps */, X86::VCMPPSYrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7353 /* vcmpps */, X86::VCMPPSZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7353 /* vcmpps */, X86::VCMPPSrmi_alt, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7353 /* vcmpps */, X86::VCMPPSYrmi_alt, Convert__Reg1_3__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7353 /* vcmpps */, X86::VCMPPSZrmi_alt, Convert__Reg1_3__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 7360 /* vcmpsd */, X86::VCMPSDrr_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7360 /* vcmpsd */, X86::VCMPSDZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 7360 /* vcmpsd */, X86::VCMPSDrm_alt, Convert__Reg1_3__Reg1_2__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 7360 /* vcmpsd */, X86::VCMPSDZrmi_alt, Convert__Reg1_3__Reg1_2__Mem645_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem64, MCK_FR32X, MCK_VK1 }, },
  { 7367 /* vcmpss */, X86::VCMPSSrr_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7367 /* vcmpss */, X86::VCMPSSZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 7367 /* vcmpss */, X86::VCMPSSrm_alt, Convert__Reg1_3__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 7367 /* vcmpss */, X86::VCMPSSZrmi_alt, Convert__Reg1_3__Reg1_2__Mem325_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem32, MCK_FR32X, MCK_VK1 }, },
  { 7374 /* vcomisd */, X86::VCOMISDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7374 /* vcomisd */, X86::VCOMISDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X }, },
  { 7374 /* vcomisd */, X86::VCOMISDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7374 /* vcomisd */, X86::VCOMISDZrm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X }, },
  { 7382 /* vcomiss */, X86::VCOMISSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7382 /* vcomiss */, X86::VCOMISSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X }, },
  { 7382 /* vcomiss */, X86::VCOMISSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7382 /* vcomiss */, X86::VCOMISSZrm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X }, },
  { 7390 /* vcvtdq2pd */, X86::VCVTDQ2PDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7390 /* vcvtdq2pd */, X86::VCVTDQ2PDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 7390 /* vcvtdq2pd */, X86::VCVTDQ2PDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512 }, },
  { 7390 /* vcvtdq2pd */, X86::VCVTDQ2PDYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 7390 /* vcvtdq2pd */, X86::VCVTDQ2PDZrm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 7390 /* vcvtdq2pd */, X86::VCVTDQ2PDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 7400 /* vcvtdq2ps */, X86::VCVTDQ2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7400 /* vcvtdq2ps */, X86::VCVTDQ2PSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 7400 /* vcvtdq2ps */, X86::VCVTDQ2PSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 7400 /* vcvtdq2ps */, X86::VCVTDQ2PSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7400 /* vcvtdq2ps */, X86::VCVTDQ2PSYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 7400 /* vcvtdq2ps */, X86::VCVTDQ2PSZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 7400 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrb, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 7410 /* vcvtpd2dq */, X86::VCVTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7410 /* vcvtpd2dq */, X86::VCVTPD2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 7410 /* vcvtpd2dq */, X86::VCVTPD2DQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 7410 /* vcvtpd2dq */, X86::VCVTPD2DQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X }, },
  { 7410 /* vcvtpd2dq */, X86::VCVTPD2DQZrrb, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR256X }, },
  { 7420 /* vcvtpd2dqx */, X86::VCVTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7420 /* vcvtpd2dqx */, X86::VCVTPD2DQXrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7431 /* vcvtpd2dqy */, X86::VCVTPD2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 7431 /* vcvtpd2dqy */, X86::VCVTPD2DQYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32 }, },
  { 7442 /* vcvtpd2ps */, X86::VCVTPD2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7442 /* vcvtpd2ps */, X86::VCVTPD2PSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 7442 /* vcvtpd2ps */, X86::VCVTPD2PSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 7442 /* vcvtpd2ps */, X86::VCVTPD2PSZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X }, },
  { 7442 /* vcvtpd2ps */, X86::VCVTPD2PSZrrb, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR256X }, },
  { 7452 /* vcvtpd2psx */, X86::VCVTPD2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7452 /* vcvtpd2psx */, X86::VCVTPD2PSXrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7463 /* vcvtpd2psy */, X86::VCVTPD2PSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 7463 /* vcvtpd2psy */, X86::VCVTPD2PSYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32 }, },
  { 7474 /* vcvtpd2udq */, X86::VCVTPD2UDQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 7474 /* vcvtpd2udq */, X86::VCVTPD2UDQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X }, },
  { 7474 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrb, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR256X }, },
  { 7485 /* vcvtph2ps */, X86::VCVTPH2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7485 /* vcvtph2ps */, X86::VCVTPH2PSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 7485 /* vcvtph2ps */, X86::VCVTPH2PSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512 }, },
  { 7485 /* vcvtph2ps */, X86::VCVTPH2PSYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 7485 /* vcvtph2ps */, X86::VCVTPH2PSZrm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 7485 /* vcvtph2ps */, X86::VCVTPH2PSrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 7495 /* vcvtps2dq */, X86::VCVTPS2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7495 /* vcvtps2dq */, X86::VCVTPS2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 7495 /* vcvtps2dq */, X86::VCVTPS2DQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 7495 /* vcvtps2dq */, X86::VCVTPS2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7495 /* vcvtps2dq */, X86::VCVTPS2DQYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 7495 /* vcvtps2dq */, X86::VCVTPS2DQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 7495 /* vcvtps2dq */, X86::VCVTPS2DQZrrb, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 7505 /* vcvtps2pd */, X86::VCVTPS2PDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7505 /* vcvtps2pd */, X86::VCVTPS2PDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 7505 /* vcvtps2pd */, X86::VCVTPS2PDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512 }, },
  { 7505 /* vcvtps2pd */, X86::VCVTPS2PDYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 7505 /* vcvtps2pd */, X86::VCVTPS2PDZrm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 7505 /* vcvtps2pd */, X86::VCVTPS2PDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 7515 /* vcvtps2ph */, X86::VCVTPS2PHrr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_FR32 }, },
  { 7515 /* vcvtps2ph */, X86::VCVTPS2PHmr, Convert__Mem645_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_Mem64 }, },
  { 7515 /* vcvtps2ph */, X86::VCVTPS2PHYrr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR256, MCK_FR32 }, },
  { 7515 /* vcvtps2ph */, X86::VCVTPS2PHYmr, Convert__Mem1285_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR256, MCK_Mem128 }, },
  { 7515 /* vcvtps2ph */, X86::VCVTPS2PHZrr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, Feature_HasAVX512, { MCK_ImmSExti32i8, MCK_VR512, MCK_VR256X }, },
  { 7515 /* vcvtps2ph */, X86::VCVTPS2PHZmr, Convert__Mem2565_2__Reg1_1__ImmSExti32i81_0, Feature_HasAVX512, { MCK_ImmSExti32i8, MCK_VR512, MCK_Mem256 }, },
  { 7525 /* vcvtps2udq */, X86::VCVTPS2UDQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 7525 /* vcvtps2udq */, X86::VCVTPS2UDQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 7525 /* vcvtps2udq */, X86::VCVTPS2UDQZrrb, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 7536 /* vcvtsd2si */, X86::VCVTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 7536 /* vcvtsd2si */, X86::VCVTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 7536 /* vcvtsd2si */, X86::VCVTSD2SIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 7536 /* vcvtsd2si */, X86::VCVTSD2SI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 7536 /* vcvtsd2si */, X86::VCVTSD2SIZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR32 }, },
  { 7536 /* vcvtsd2si */, X86::VCVTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 7536 /* vcvtsd2si */, X86::VCVTSD2SI64Zrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR64 }, },
  { 7536 /* vcvtsd2si */, X86::VCVTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7546 /* vcvtsd2sil */, X86::VCVTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 7546 /* vcvtsd2sil */, X86::VCVTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 7557 /* vcvtsd2siq */, X86::VCVTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 7557 /* vcvtsd2siq */, X86::VCVTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7568 /* vcvtsd2ss */, X86::VCVTSD2SSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7568 /* vcvtsd2ss */, X86::VCVTSD2SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7568 /* vcvtsd2ss */, X86::VCVTSD2SSrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 7568 /* vcvtsd2ss */, X86::VCVTSD2SSZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 7578 /* vcvtsd2usi */, X86::VCVTSD2USIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 7578 /* vcvtsd2usi */, X86::VCVTSD2USI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 7578 /* vcvtsd2usi */, X86::VCVTSD2USIZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR32 }, },
  { 7578 /* vcvtsd2usi */, X86::VCVTSD2USI64Zrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR64 }, },
  { 7589 /* vcvtsi2sd */, X86::VCVTSI2SDrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 7599 /* vcvtsi2sdl */, X86::VCVTSI2SDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32, MCK_FR32 }, },
  { 7599 /* vcvtsi2sdl */, X86::VCVTSI2SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_FR32X, MCK_FR32X }, },
  { 7599 /* vcvtsi2sdl */, X86::VCVTSI2SDrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 7599 /* vcvtsi2sdl */, X86::VCVTSI2SDZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 7610 /* vcvtsi2sdq */, X86::VCVTSI2SD64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32, MCK_FR32 }, },
  { 7610 /* vcvtsi2sdq */, X86::VCVTSI642SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR64, MCK_FR32X, MCK_FR32X }, },
  { 7610 /* vcvtsi2sdq */, X86::VCVTSI2SD64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 7610 /* vcvtsi2sdq */, X86::VCVTSI642SDZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 7621 /* vcvtsi2ss */, X86::VCVTSI2SSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 7631 /* vcvtsi2ssl */, X86::VCVTSI2SSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32, MCK_FR32 }, },
  { 7631 /* vcvtsi2ssl */, X86::VCVTSI2SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_FR32X, MCK_FR32X }, },
  { 7631 /* vcvtsi2ssl */, X86::VCVTSI2SSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 7631 /* vcvtsi2ssl */, X86::VCVTSI2SSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 7642 /* vcvtsi2ssq */, X86::VCVTSI2SS64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32, MCK_FR32 }, },
  { 7642 /* vcvtsi2ssq */, X86::VCVTSI642SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR64, MCK_FR32X, MCK_FR32X }, },
  { 7642 /* vcvtsi2ssq */, X86::VCVTSI2SS64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 7642 /* vcvtsi2ssq */, X86::VCVTSI642SSZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 7653 /* vcvtss2sd */, X86::VCVTSS2SDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7653 /* vcvtss2sd */, X86::VCVTSS2SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7653 /* vcvtss2sd */, X86::VCVTSS2SDrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 7653 /* vcvtss2sd */, X86::VCVTSS2SDZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 7663 /* vcvtss2si */, X86::VCVTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 7663 /* vcvtss2si */, X86::VCVTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 7663 /* vcvtss2si */, X86::VCVTSS2SIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 7663 /* vcvtss2si */, X86::VCVTSS2SI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 7663 /* vcvtss2si */, X86::VCVTSS2SIZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR32 }, },
  { 7663 /* vcvtss2si */, X86::VCVTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7663 /* vcvtss2si */, X86::VCVTSS2SI64Zrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR64 }, },
  { 7663 /* vcvtss2si */, X86::VCVTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 7673 /* vcvtss2sil */, X86::VCVTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 7673 /* vcvtss2sil */, X86::VCVTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7684 /* vcvtss2siq */, X86::VCVTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 7684 /* vcvtss2siq */, X86::VCVTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 7695 /* vcvtss2usi */, X86::VCVTSS2USIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 7695 /* vcvtss2usi */, X86::VCVTSS2USI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 7695 /* vcvtss2usi */, X86::VCVTSS2USIZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR32 }, },
  { 7695 /* vcvtss2usi */, X86::VCVTSS2USI64Zrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR64 }, },
  { 7706 /* vcvttpd2dq */, X86::VCVTTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7706 /* vcvttpd2dq */, X86::VCVTTPD2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 7706 /* vcvttpd2dq */, X86::VCVTTPD2DQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 7706 /* vcvttpd2dq */, X86::VCVTTPD2DQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X }, },
  { 7717 /* vcvttpd2dqx */, X86::VCVTTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7717 /* vcvttpd2dqx */, X86::VCVTTPD2DQXrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7729 /* vcvttpd2dqy */, X86::VCVTTPD2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 7729 /* vcvttpd2dqy */, X86::VCVTTPD2DQYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32 }, },
  { 7741 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 7741 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X }, },
  { 7753 /* vcvttps2dq */, X86::VCVTTPS2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7753 /* vcvttps2dq */, X86::VCVTTPS2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 7753 /* vcvttps2dq */, X86::VCVTTPS2DQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 7753 /* vcvttps2dq */, X86::VCVTTPS2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7753 /* vcvttps2dq */, X86::VCVTTPS2DQYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 7753 /* vcvttps2dq */, X86::VCVTTPS2DQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 7764 /* vcvttps2udq */, X86::VCVTTPS2UDQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 7764 /* vcvttps2udq */, X86::VCVTTPS2UDQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 7776 /* vcvttsd2si */, X86::VCVTTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 7776 /* vcvttsd2si */, X86::VCVTTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 7776 /* vcvttsd2si */, X86::VCVTTSD2SIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 7776 /* vcvttsd2si */, X86::VCVTTSD2SI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 7776 /* vcvttsd2si */, X86::VCVTTSD2SIZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR32 }, },
  { 7776 /* vcvttsd2si */, X86::VCVTTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 7776 /* vcvttsd2si */, X86::VCVTTSD2SI64Zrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR64 }, },
  { 7776 /* vcvttsd2si */, X86::VCVTTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7787 /* vcvttsd2sil */, X86::VCVTTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 7787 /* vcvttsd2sil */, X86::VCVTTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 7799 /* vcvttsd2siq */, X86::VCVTTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 7799 /* vcvttsd2siq */, X86::VCVTTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7811 /* vcvttsd2usi */, X86::VCVTTSD2USIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 7811 /* vcvttsd2usi */, X86::VCVTTSD2USI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 7811 /* vcvttsd2usi */, X86::VCVTTSD2USIZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR32 }, },
  { 7811 /* vcvttsd2usi */, X86::VCVTTSD2USI64Zrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR64 }, },
  { 7823 /* vcvttss2si */, X86::VCVTTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 7823 /* vcvttss2si */, X86::VCVTTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 7823 /* vcvttss2si */, X86::VCVTTSS2SIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 7823 /* vcvttss2si */, X86::VCVTTSS2SI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 7823 /* vcvttss2si */, X86::VCVTTSS2SIZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR32 }, },
  { 7823 /* vcvttss2si */, X86::VCVTTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7823 /* vcvttss2si */, X86::VCVTTSS2SI64Zrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR64 }, },
  { 7823 /* vcvttss2si */, X86::VCVTTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 7834 /* vcvttss2sil */, X86::VCVTTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 7834 /* vcvttss2sil */, X86::VCVTTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7846 /* vcvttss2siq */, X86::VCVTTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 7846 /* vcvttss2siq */, X86::VCVTTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 7858 /* vcvttss2usi */, X86::VCVTTSS2USIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 7858 /* vcvttss2usi */, X86::VCVTTSS2USI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 7858 /* vcvttss2usi */, X86::VCVTTSS2USIZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR32 }, },
  { 7858 /* vcvttss2usi */, X86::VCVTTSS2USI64Zrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR64 }, },
  { 7870 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512 }, },
  { 7870 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 7881 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 7881 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 7881 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrrb, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 7903 /* vcvtusi2sdl */, X86::VCVTUSI2SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_FR32X, MCK_FR32X }, },
  { 7903 /* vcvtusi2sdl */, X86::VCVTUSI2SDZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 7915 /* vcvtusi2sdq */, X86::VCVTUSI642SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR64, MCK_FR32X, MCK_FR32X }, },
  { 7915 /* vcvtusi2sdq */, X86::VCVTUSI642SDZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 7938 /* vcvtusi2ssl */, X86::VCVTUSI2SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_FR32X, MCK_FR32X }, },
  { 7938 /* vcvtusi2ssl */, X86::VCVTUSI2SSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 7950 /* vcvtusi2ssq */, X86::VCVTUSI642SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR64, MCK_FR32X, MCK_FR32X }, },
  { 7950 /* vcvtusi2ssq */, X86::VCVTUSI642SSZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 7962 /* vdivpd */, X86::VDIVPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7962 /* vdivpd */, X86::VDIVPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7962 /* vdivpd */, X86::VDIVPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7962 /* vdivpd */, X86::VDIVPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7962 /* vdivpd */, X86::VDIVPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7962 /* vdivpd */, X86::VDIVPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7962 /* vdivpd */, X86::VDIVPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 7962 /* vdivpd */, X86::VDIVPDZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7962 /* vdivpd */, X86::VDIVPDZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7962 /* vdivpd */, X86::VDIVPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7962 /* vdivpd */, X86::VDIVPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7962 /* vdivpd */, X86::VDIVPDZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7962 /* vdivpd */, X86::VDIVPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7969 /* vdivps */, X86::VDIVPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7969 /* vdivps */, X86::VDIVPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7969 /* vdivps */, X86::VDIVPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7969 /* vdivps */, X86::VDIVPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7969 /* vdivps */, X86::VDIVPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7969 /* vdivps */, X86::VDIVPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7969 /* vdivps */, X86::VDIVPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 7969 /* vdivps */, X86::VDIVPSZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7969 /* vdivps */, X86::VDIVPSZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7969 /* vdivps */, X86::VDIVPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7969 /* vdivps */, X86::VDIVPSZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 7969 /* vdivps */, X86::VDIVPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7969 /* vdivps */, X86::VDIVPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 7976 /* vdivsd */, X86::VDIVSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7976 /* vdivsd */, X86::VDIVSDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7976 /* vdivsd */, X86::VDIVSDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 7976 /* vdivsd */, X86::VDIVSDZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 7983 /* vdivss */, X86::VDIVSSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7983 /* vdivss */, X86::VDIVSSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7983 /* vdivss */, X86::VDIVSSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 7983 /* vdivss */, X86::VDIVSSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 7990 /* vdppd */, X86::VDPPDrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7990 /* vdppd */, X86::VDPPDrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7996 /* vdpps */, X86::VDPPSrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7996 /* vdpps */, X86::VDPPSYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7996 /* vdpps */, X86::VDPPSrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7996 /* vdpps */, X86::VDPPSYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8002 /* verr */, X86::VERRr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 8002 /* verr */, X86::VERRm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 8007 /* verw */, X86::VERWr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 8007 /* verw */, X86::VERWm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 8012 /* vextractf128 */, X86::VEXTRACTF128rr, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_FR32 }, },
  { 8012 /* vextractf128 */, X86::VEXTRACTF128mr, Convert__Mem1285_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_Mem128 }, },
  { 8025 /* vextractf32x4 */, X86::VEXTRACTF32x4rr, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_FR32X }, },
  { 8025 /* vextractf32x4 */, X86::VEXTRACTF32x4mr, Convert__Mem1285_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_Mem128 }, },
  { 8039 /* vextractf64x4 */, X86::VEXTRACTF64x4rr, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR256X }, },
  { 8039 /* vextractf64x4 */, X86::VEXTRACTF64x4mr, Convert__Mem2565_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_Mem256 }, },
  { 8053 /* vextracti128 */, X86::VEXTRACTI128rr, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_FR32 }, },
  { 8053 /* vextracti128 */, X86::VEXTRACTI128mr, Convert__Mem1285_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_Mem128 }, },
  { 8066 /* vextracti32x4 */, X86::VEXTRACTI32x4rr, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_FR32X }, },
  { 8066 /* vextracti32x4 */, X86::VEXTRACTI32x4mr, Convert__Mem1285_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_Mem128 }, },
  { 8080 /* vextracti64x4 */, X86::VEXTRACTI64x4rr, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR256X }, },
  { 8080 /* vextracti64x4 */, X86::VEXTRACTI64x4mr, Convert__Mem2565_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_Mem256 }, },
  { 8094 /* vextractps */, X86::VEXTRACTPSrr, Convert__GR32orGR641_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_GR32orGR64 }, },
  { 8094 /* vextractps */, X86::VEXTRACTPSmr, Convert__Mem325_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_Mem32 }, },
  { 8094 /* vextractps */, X86::VEXTRACTPSzrr, Convert__Reg1_2__Reg1_1__ImmZExtu32u81_0, Feature_HasAVX512, { MCK_ImmZExtu32u8, MCK_FR32X, MCK_GR32 }, },
  { 8094 /* vextractps */, X86::VEXTRACTPSzmr, Convert__Mem325_2__Reg1_1__ImmZExtu32u81_0, Feature_HasAVX512, { MCK_ImmZExtu32u8, MCK_FR32X, MCK_Mem32 }, },
  { 8105 /* vfmadd132pd */, X86::VFMADDPDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8105 /* vfmadd132pd */, X86::VFMADDPDr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8105 /* vfmadd132pd */, X86::VFMADDPDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8105 /* vfmadd132pd */, X86::VFMADDPDr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8105 /* vfmadd132pd */, X86::VFMADD132PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8105 /* vfmadd132pd */, X86::VFMADD132PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8117 /* vfmadd132ps */, X86::VFMADDPSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8117 /* vfmadd132ps */, X86::VFMADDPSr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8117 /* vfmadd132ps */, X86::VFMADDPSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8117 /* vfmadd132ps */, X86::VFMADDPSr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8117 /* vfmadd132ps */, X86::VFMADD132PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8117 /* vfmadd132ps */, X86::VFMADD132PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8129 /* vfmadd132sd */, X86::VFMADDSDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8129 /* vfmadd132sd */, X86::VFMADDSDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8141 /* vfmadd132ss */, X86::VFMADDSSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8141 /* vfmadd132ss */, X86::VFMADDSSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8153 /* vfmadd213pd */, X86::VFMADDPDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8153 /* vfmadd213pd */, X86::VFMADDPDr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8153 /* vfmadd213pd */, X86::VFMADD213PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8153 /* vfmadd213pd */, X86::VFMADDPDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8153 /* vfmadd213pd */, X86::VFMADDPDr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8153 /* vfmadd213pd */, X86::VFMADD213PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8153 /* vfmadd213pd */, X86::VFMADD213PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8165 /* vfmadd213ps */, X86::VFMADDPSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8165 /* vfmadd213ps */, X86::VFMADDPSr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8165 /* vfmadd213ps */, X86::VFMADD213PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8165 /* vfmadd213ps */, X86::VFMADDPSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8165 /* vfmadd213ps */, X86::VFMADDPSr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8165 /* vfmadd213ps */, X86::VFMADD213PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8165 /* vfmadd213ps */, X86::VFMADD213PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8177 /* vfmadd213sd */, X86::VFMADDSDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8177 /* vfmadd213sd */, X86::VFMADDSDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8177 /* vfmadd213sd */, X86::VFMADDSDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8177 /* vfmadd213sd */, X86::VFMADDSDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8189 /* vfmadd213ss */, X86::VFMADDSSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8189 /* vfmadd213ss */, X86::VFMADDSSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8189 /* vfmadd213ss */, X86::VFMADDSSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8189 /* vfmadd213ss */, X86::VFMADDSSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8201 /* vfmadd231pd */, X86::VFMADDPDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8201 /* vfmadd231pd */, X86::VFMADDPDr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8201 /* vfmadd231pd */, X86::VFMADDPDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8201 /* vfmadd231pd */, X86::VFMADDPDr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8213 /* vfmadd231ps */, X86::VFMADDPSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8213 /* vfmadd231ps */, X86::VFMADDPSr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8213 /* vfmadd231ps */, X86::VFMADDPSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8213 /* vfmadd231ps */, X86::VFMADDPSr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8225 /* vfmadd231sd */, X86::VFMADDSDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8225 /* vfmadd231sd */, X86::VFMADDSDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8237 /* vfmadd231ss */, X86::VFMADDSSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8237 /* vfmadd231ss */, X86::VFMADDSSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8249 /* vfmaddpd */, X86::VFMADDPD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8249 /* vfmaddpd */, X86::VFMADDPD4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8249 /* vfmaddpd */, X86::VFMADDPD4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8249 /* vfmaddpd */, X86::VFMADDPD4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8249 /* vfmaddpd */, X86::VFMADDPD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8249 /* vfmaddpd */, X86::VFMADDPD4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8258 /* vfmaddps */, X86::VFMADDPS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8258 /* vfmaddps */, X86::VFMADDPS4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8258 /* vfmaddps */, X86::VFMADDPS4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8258 /* vfmaddps */, X86::VFMADDPS4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8258 /* vfmaddps */, X86::VFMADDPS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8258 /* vfmaddps */, X86::VFMADDPS4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8267 /* vfmaddsd */, X86::VFMADDSD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8267 /* vfmaddsd */, X86::VFMADDSD4mr, Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8267 /* vfmaddsd */, X86::VFMADDSD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8276 /* vfmaddss */, X86::VFMADDSS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8276 /* vfmaddss */, X86::VFMADDSS4mr, Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8276 /* vfmaddss */, X86::VFMADDSS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8285 /* vfmaddsub132pd */, X86::VFMADDSUBPDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8285 /* vfmaddsub132pd */, X86::VFMADDSUBPDr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8285 /* vfmaddsub132pd */, X86::VFMADDSUBPDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8285 /* vfmaddsub132pd */, X86::VFMADDSUBPDr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8285 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8285 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8300 /* vfmaddsub132ps */, X86::VFMADDSUBPSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8300 /* vfmaddsub132ps */, X86::VFMADDSUBPSr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8300 /* vfmaddsub132ps */, X86::VFMADDSUBPSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8300 /* vfmaddsub132ps */, X86::VFMADDSUBPSr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8300 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8300 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8315 /* vfmaddsub213pd */, X86::VFMADDSUBPDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8315 /* vfmaddsub213pd */, X86::VFMADDSUBPDr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8315 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8315 /* vfmaddsub213pd */, X86::VFMADDSUBPDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8315 /* vfmaddsub213pd */, X86::VFMADDSUBPDr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8315 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8315 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8330 /* vfmaddsub213ps */, X86::VFMADDSUBPSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8330 /* vfmaddsub213ps */, X86::VFMADDSUBPSr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8330 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8330 /* vfmaddsub213ps */, X86::VFMADDSUBPSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8330 /* vfmaddsub213ps */, X86::VFMADDSUBPSr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8330 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8330 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8345 /* vfmaddsub231pd */, X86::VFMADDSUBPDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8345 /* vfmaddsub231pd */, X86::VFMADDSUBPDr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8345 /* vfmaddsub231pd */, X86::VFMADDSUBPDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8345 /* vfmaddsub231pd */, X86::VFMADDSUBPDr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8360 /* vfmaddsub231ps */, X86::VFMADDSUBPSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8360 /* vfmaddsub231ps */, X86::VFMADDSUBPSr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8360 /* vfmaddsub231ps */, X86::VFMADDSUBPSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8360 /* vfmaddsub231ps */, X86::VFMADDSUBPSr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8375 /* vfmaddsubpd */, X86::VFMADDSUBPD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8375 /* vfmaddsubpd */, X86::VFMADDSUBPD4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8375 /* vfmaddsubpd */, X86::VFMADDSUBPD4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8375 /* vfmaddsubpd */, X86::VFMADDSUBPD4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8375 /* vfmaddsubpd */, X86::VFMADDSUBPD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8375 /* vfmaddsubpd */, X86::VFMADDSUBPD4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8387 /* vfmaddsubps */, X86::VFMADDSUBPS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8387 /* vfmaddsubps */, X86::VFMADDSUBPS4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8387 /* vfmaddsubps */, X86::VFMADDSUBPS4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8387 /* vfmaddsubps */, X86::VFMADDSUBPS4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8387 /* vfmaddsubps */, X86::VFMADDSUBPS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8387 /* vfmaddsubps */, X86::VFMADDSUBPS4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8399 /* vfmsub132pd */, X86::VFMSUBPDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8399 /* vfmsub132pd */, X86::VFMSUBPDr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8399 /* vfmsub132pd */, X86::VFMSUBPDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8399 /* vfmsub132pd */, X86::VFMSUBPDr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8399 /* vfmsub132pd */, X86::VFMSUB132PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8399 /* vfmsub132pd */, X86::VFMSUB132PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8411 /* vfmsub132ps */, X86::VFMSUBPSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8411 /* vfmsub132ps */, X86::VFMSUBPSr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8411 /* vfmsub132ps */, X86::VFMSUBPSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8411 /* vfmsub132ps */, X86::VFMSUBPSr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8411 /* vfmsub132ps */, X86::VFMSUB132PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8411 /* vfmsub132ps */, X86::VFMSUB132PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8423 /* vfmsub132sd */, X86::VFMSUBSDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8423 /* vfmsub132sd */, X86::VFMSUBSDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8435 /* vfmsub132ss */, X86::VFMSUBSSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8435 /* vfmsub132ss */, X86::VFMSUBSSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8447 /* vfmsub213pd */, X86::VFMSUBPDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8447 /* vfmsub213pd */, X86::VFMSUBPDr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8447 /* vfmsub213pd */, X86::VFMSUB213PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8447 /* vfmsub213pd */, X86::VFMSUBPDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8447 /* vfmsub213pd */, X86::VFMSUBPDr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8447 /* vfmsub213pd */, X86::VFMSUB213PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8447 /* vfmsub213pd */, X86::VFMSUB213PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8459 /* vfmsub213ps */, X86::VFMSUBPSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8459 /* vfmsub213ps */, X86::VFMSUBPSr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8459 /* vfmsub213ps */, X86::VFMSUB213PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8459 /* vfmsub213ps */, X86::VFMSUBPSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8459 /* vfmsub213ps */, X86::VFMSUBPSr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8459 /* vfmsub213ps */, X86::VFMSUB213PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8459 /* vfmsub213ps */, X86::VFMSUB213PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8471 /* vfmsub213sd */, X86::VFMSUBSDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8471 /* vfmsub213sd */, X86::VFMSUBSDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8471 /* vfmsub213sd */, X86::VFMSUBSDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8471 /* vfmsub213sd */, X86::VFMSUBSDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8483 /* vfmsub213ss */, X86::VFMSUBSSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8483 /* vfmsub213ss */, X86::VFMSUBSSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8483 /* vfmsub213ss */, X86::VFMSUBSSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8483 /* vfmsub213ss */, X86::VFMSUBSSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8495 /* vfmsub231pd */, X86::VFMSUBPDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8495 /* vfmsub231pd */, X86::VFMSUBPDr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8495 /* vfmsub231pd */, X86::VFMSUBPDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8495 /* vfmsub231pd */, X86::VFMSUBPDr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8507 /* vfmsub231ps */, X86::VFMSUBPSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8507 /* vfmsub231ps */, X86::VFMSUBPSr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8507 /* vfmsub231ps */, X86::VFMSUBPSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8507 /* vfmsub231ps */, X86::VFMSUBPSr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8519 /* vfmsub231sd */, X86::VFMSUBSDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8519 /* vfmsub231sd */, X86::VFMSUBSDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8531 /* vfmsub231ss */, X86::VFMSUBSSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8531 /* vfmsub231ss */, X86::VFMSUBSSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8543 /* vfmsubadd132pd */, X86::VFMSUBADDPDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8543 /* vfmsubadd132pd */, X86::VFMSUBADDPDr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8543 /* vfmsubadd132pd */, X86::VFMSUBADDPDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8543 /* vfmsubadd132pd */, X86::VFMSUBADDPDr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8543 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8543 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8558 /* vfmsubadd132ps */, X86::VFMSUBADDPSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8558 /* vfmsubadd132ps */, X86::VFMSUBADDPSr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8558 /* vfmsubadd132ps */, X86::VFMSUBADDPSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8558 /* vfmsubadd132ps */, X86::VFMSUBADDPSr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8558 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8558 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8573 /* vfmsubadd213pd */, X86::VFMSUBADDPDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8573 /* vfmsubadd213pd */, X86::VFMSUBADDPDr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8573 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8573 /* vfmsubadd213pd */, X86::VFMSUBADDPDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8573 /* vfmsubadd213pd */, X86::VFMSUBADDPDr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8573 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8573 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8588 /* vfmsubadd213ps */, X86::VFMSUBADDPSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8588 /* vfmsubadd213ps */, X86::VFMSUBADDPSr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8588 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8588 /* vfmsubadd213ps */, X86::VFMSUBADDPSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8588 /* vfmsubadd213ps */, X86::VFMSUBADDPSr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8588 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8588 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8603 /* vfmsubadd231pd */, X86::VFMSUBADDPDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8603 /* vfmsubadd231pd */, X86::VFMSUBADDPDr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8603 /* vfmsubadd231pd */, X86::VFMSUBADDPDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8603 /* vfmsubadd231pd */, X86::VFMSUBADDPDr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8618 /* vfmsubadd231ps */, X86::VFMSUBADDPSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8618 /* vfmsubadd231ps */, X86::VFMSUBADDPSr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8618 /* vfmsubadd231ps */, X86::VFMSUBADDPSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8618 /* vfmsubadd231ps */, X86::VFMSUBADDPSr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8633 /* vfmsubaddpd */, X86::VFMSUBADDPD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8633 /* vfmsubaddpd */, X86::VFMSUBADDPD4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8633 /* vfmsubaddpd */, X86::VFMSUBADDPD4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8633 /* vfmsubaddpd */, X86::VFMSUBADDPD4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8633 /* vfmsubaddpd */, X86::VFMSUBADDPD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8633 /* vfmsubaddpd */, X86::VFMSUBADDPD4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8645 /* vfmsubaddps */, X86::VFMSUBADDPS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8645 /* vfmsubaddps */, X86::VFMSUBADDPS4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8645 /* vfmsubaddps */, X86::VFMSUBADDPS4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8645 /* vfmsubaddps */, X86::VFMSUBADDPS4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8645 /* vfmsubaddps */, X86::VFMSUBADDPS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8645 /* vfmsubaddps */, X86::VFMSUBADDPS4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8657 /* vfmsubpd */, X86::VFMSUBPD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8657 /* vfmsubpd */, X86::VFMSUBPD4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8657 /* vfmsubpd */, X86::VFMSUBPD4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8657 /* vfmsubpd */, X86::VFMSUBPD4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8657 /* vfmsubpd */, X86::VFMSUBPD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8657 /* vfmsubpd */, X86::VFMSUBPD4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8666 /* vfmsubps */, X86::VFMSUBPS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8666 /* vfmsubps */, X86::VFMSUBPS4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8666 /* vfmsubps */, X86::VFMSUBPS4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8666 /* vfmsubps */, X86::VFMSUBPS4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8666 /* vfmsubps */, X86::VFMSUBPS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8666 /* vfmsubps */, X86::VFMSUBPS4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8675 /* vfmsubsd */, X86::VFMSUBSD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8675 /* vfmsubsd */, X86::VFMSUBSD4mr, Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8675 /* vfmsubsd */, X86::VFMSUBSD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8684 /* vfmsubss */, X86::VFMSUBSS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8684 /* vfmsubss */, X86::VFMSUBSS4mr, Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8684 /* vfmsubss */, X86::VFMSUBSS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8693 /* vfnmadd132pd */, X86::VFNMADDPDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8693 /* vfnmadd132pd */, X86::VFNMADDPDr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8693 /* vfnmadd132pd */, X86::VFNMADDPDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8693 /* vfnmadd132pd */, X86::VFNMADDPDr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8693 /* vfnmadd132pd */, X86::VFNMADD132PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8693 /* vfnmadd132pd */, X86::VFNMADD132PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8706 /* vfnmadd132ps */, X86::VFNMADDPSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8706 /* vfnmadd132ps */, X86::VFNMADDPSr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8706 /* vfnmadd132ps */, X86::VFNMADDPSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8706 /* vfnmadd132ps */, X86::VFNMADDPSr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8706 /* vfnmadd132ps */, X86::VFNMADD132PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8706 /* vfnmadd132ps */, X86::VFNMADD132PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8719 /* vfnmadd132sd */, X86::VFNMADDSDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8719 /* vfnmadd132sd */, X86::VFNMADDSDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8732 /* vfnmadd132ss */, X86::VFNMADDSSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8732 /* vfnmadd132ss */, X86::VFNMADDSSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8745 /* vfnmadd213pd */, X86::VFNMADDPDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8745 /* vfnmadd213pd */, X86::VFNMADDPDr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8745 /* vfnmadd213pd */, X86::VFNMADD213PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8745 /* vfnmadd213pd */, X86::VFNMADDPDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8745 /* vfnmadd213pd */, X86::VFNMADDPDr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8745 /* vfnmadd213pd */, X86::VFNMADD213PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8745 /* vfnmadd213pd */, X86::VFNMADD213PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8758 /* vfnmadd213ps */, X86::VFNMADDPSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8758 /* vfnmadd213ps */, X86::VFNMADDPSr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8758 /* vfnmadd213ps */, X86::VFNMADD213PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8758 /* vfnmadd213ps */, X86::VFNMADDPSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8758 /* vfnmadd213ps */, X86::VFNMADDPSr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8758 /* vfnmadd213ps */, X86::VFNMADD213PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8758 /* vfnmadd213ps */, X86::VFNMADD213PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8771 /* vfnmadd213sd */, X86::VFNMADDSDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8771 /* vfnmadd213sd */, X86::VFNMADDSDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8771 /* vfnmadd213sd */, X86::VFNMADDSDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8771 /* vfnmadd213sd */, X86::VFNMADDSDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8784 /* vfnmadd213ss */, X86::VFNMADDSSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8784 /* vfnmadd213ss */, X86::VFNMADDSSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8784 /* vfnmadd213ss */, X86::VFNMADDSSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8784 /* vfnmadd213ss */, X86::VFNMADDSSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8797 /* vfnmadd231pd */, X86::VFNMADDPDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8797 /* vfnmadd231pd */, X86::VFNMADDPDr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8797 /* vfnmadd231pd */, X86::VFNMADDPDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8797 /* vfnmadd231pd */, X86::VFNMADDPDr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8810 /* vfnmadd231ps */, X86::VFNMADDPSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8810 /* vfnmadd231ps */, X86::VFNMADDPSr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8810 /* vfnmadd231ps */, X86::VFNMADDPSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8810 /* vfnmadd231ps */, X86::VFNMADDPSr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8823 /* vfnmadd231sd */, X86::VFNMADDSDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8823 /* vfnmadd231sd */, X86::VFNMADDSDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8836 /* vfnmadd231ss */, X86::VFNMADDSSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8836 /* vfnmadd231ss */, X86::VFNMADDSSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8849 /* vfnmaddpd */, X86::VFNMADDPD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8849 /* vfnmaddpd */, X86::VFNMADDPD4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8849 /* vfnmaddpd */, X86::VFNMADDPD4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8849 /* vfnmaddpd */, X86::VFNMADDPD4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8849 /* vfnmaddpd */, X86::VFNMADDPD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8849 /* vfnmaddpd */, X86::VFNMADDPD4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8859 /* vfnmaddps */, X86::VFNMADDPS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8859 /* vfnmaddps */, X86::VFNMADDPS4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8859 /* vfnmaddps */, X86::VFNMADDPS4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8859 /* vfnmaddps */, X86::VFNMADDPS4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8859 /* vfnmaddps */, X86::VFNMADDPS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8859 /* vfnmaddps */, X86::VFNMADDPS4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8869 /* vfnmaddsd */, X86::VFNMADDSD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8869 /* vfnmaddsd */, X86::VFNMADDSD4mr, Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8869 /* vfnmaddsd */, X86::VFNMADDSD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8879 /* vfnmaddss */, X86::VFNMADDSS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8879 /* vfnmaddss */, X86::VFNMADDSS4mr, Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8879 /* vfnmaddss */, X86::VFNMADDSS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8889 /* vfnmsub132pd */, X86::VFNMSUBPDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8889 /* vfnmsub132pd */, X86::VFNMSUBPDr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8889 /* vfnmsub132pd */, X86::VFNMSUBPDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8889 /* vfnmsub132pd */, X86::VFNMSUBPDr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8889 /* vfnmsub132pd */, X86::VFNMSUB132PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8889 /* vfnmsub132pd */, X86::VFNMSUB132PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8902 /* vfnmsub132ps */, X86::VFNMSUBPSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8902 /* vfnmsub132ps */, X86::VFNMSUBPSr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8902 /* vfnmsub132ps */, X86::VFNMSUBPSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8902 /* vfnmsub132ps */, X86::VFNMSUBPSr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8902 /* vfnmsub132ps */, X86::VFNMSUB132PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8902 /* vfnmsub132ps */, X86::VFNMSUB132PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8915 /* vfnmsub132sd */, X86::VFNMSUBSDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8915 /* vfnmsub132sd */, X86::VFNMSUBSDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8928 /* vfnmsub132ss */, X86::VFNMSUBSSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8928 /* vfnmsub132ss */, X86::VFNMSUBSSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8941 /* vfnmsub213pd */, X86::VFNMSUBPDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8941 /* vfnmsub213pd */, X86::VFNMSUBPDr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8941 /* vfnmsub213pd */, X86::VFNMSUB213PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8941 /* vfnmsub213pd */, X86::VFNMSUBPDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8941 /* vfnmsub213pd */, X86::VFNMSUBPDr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8941 /* vfnmsub213pd */, X86::VFNMSUB213PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8941 /* vfnmsub213pd */, X86::VFNMSUB213PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8954 /* vfnmsub213ps */, X86::VFNMSUBPSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8954 /* vfnmsub213ps */, X86::VFNMSUBPSr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8954 /* vfnmsub213ps */, X86::VFNMSUB213PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8954 /* vfnmsub213ps */, X86::VFNMSUBPSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8954 /* vfnmsub213ps */, X86::VFNMSUBPSr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8954 /* vfnmsub213ps */, X86::VFNMSUB213PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8954 /* vfnmsub213ps */, X86::VFNMSUB213PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8967 /* vfnmsub213sd */, X86::VFNMSUBSDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8967 /* vfnmsub213sd */, X86::VFNMSUBSDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8967 /* vfnmsub213sd */, X86::VFNMSUBSDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8967 /* vfnmsub213sd */, X86::VFNMSUBSDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8980 /* vfnmsub213ss */, X86::VFNMSUBSSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8980 /* vfnmsub213ss */, X86::VFNMSUBSSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8980 /* vfnmsub213ss */, X86::VFNMSUBSSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8980 /* vfnmsub213ss */, X86::VFNMSUBSSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8993 /* vfnmsub231pd */, X86::VFNMSUBPDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8993 /* vfnmsub231pd */, X86::VFNMSUBPDr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8993 /* vfnmsub231pd */, X86::VFNMSUBPDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8993 /* vfnmsub231pd */, X86::VFNMSUBPDr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9006 /* vfnmsub231ps */, X86::VFNMSUBPSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9006 /* vfnmsub231ps */, X86::VFNMSUBPSr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9006 /* vfnmsub231ps */, X86::VFNMSUBPSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9006 /* vfnmsub231ps */, X86::VFNMSUBPSr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9019 /* vfnmsub231sd */, X86::VFNMSUBSDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9019 /* vfnmsub231sd */, X86::VFNMSUBSDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9032 /* vfnmsub231ss */, X86::VFNMSUBSSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9032 /* vfnmsub231ss */, X86::VFNMSUBSSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9045 /* vfnmsubpd */, X86::VFNMSUBPD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9045 /* vfnmsubpd */, X86::VFNMSUBPD4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9045 /* vfnmsubpd */, X86::VFNMSUBPD4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9045 /* vfnmsubpd */, X86::VFNMSUBPD4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9045 /* vfnmsubpd */, X86::VFNMSUBPD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9045 /* vfnmsubpd */, X86::VFNMSUBPD4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9055 /* vfnmsubps */, X86::VFNMSUBPS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9055 /* vfnmsubps */, X86::VFNMSUBPS4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9055 /* vfnmsubps */, X86::VFNMSUBPS4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9055 /* vfnmsubps */, X86::VFNMSUBPS4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9055 /* vfnmsubps */, X86::VFNMSUBPS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9055 /* vfnmsubps */, X86::VFNMSUBPS4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9065 /* vfnmsubsd */, X86::VFNMSUBSD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9065 /* vfnmsubsd */, X86::VFNMSUBSD4mr, Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9065 /* vfnmsubsd */, X86::VFNMSUBSD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9075 /* vfnmsubss */, X86::VFNMSUBSS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9075 /* vfnmsubss */, X86::VFNMSUBSS4mr, Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9075 /* vfnmsubss */, X86::VFNMSUBSS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9085 /* vfrczpd */, X86::VFRCZPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9085 /* vfrczpd */, X86::VFRCZPDrrY, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9085 /* vfrczpd */, X86::VFRCZPDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9085 /* vfrczpd */, X86::VFRCZPDrmY, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9093 /* vfrczps */, X86::VFRCZPSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9093 /* vfrczps */, X86::VFRCZPSrrY, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9093 /* vfrczps */, X86::VFRCZPSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9093 /* vfrczps */, X86::VFRCZPSrmY, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9101 /* vfrczsd */, X86::VFRCZSDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9101 /* vfrczsd */, X86::VFRCZSDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 9109 /* vfrczss */, X86::VFRCZSSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9109 /* vfrczss */, X86::VFRCZSSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 9117 /* vgatherdpd */, X86::VGATHERDPDrm, Convert__Reg1_2__Reg1_0__Tie0__MemVX645_1__Tie1, 0, { MCK_FR32, MCK_MemVX64, MCK_FR32 }, },
  { 9117 /* vgatherdpd */, X86::VGATHERDPDYrm, Convert__Reg1_2__Reg1_0__Tie0__MemVX645_1__Tie1, 0, { MCK_VR256, MCK_MemVX64, MCK_VR256 }, },
  { 9117 /* vgatherdpd */, X86::VGATHERDPDZrm, Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVY645_0, Feature_HasAVX512, { MCK_MemVY64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9128 /* vgatherdps */, X86::VGATHERDPSrm, Convert__Reg1_2__Reg1_0__Tie0__MemVX325_1__Tie1, 0, { MCK_FR32, MCK_MemVX32, MCK_FR32 }, },
  { 9128 /* vgatherdps */, X86::VGATHERDPSYrm, Convert__Reg1_2__Reg1_0__Tie0__MemVY325_1__Tie1, 0, { MCK_VR256, MCK_MemVY32, MCK_VR256 }, },
  { 9128 /* vgatherdps */, X86::VGATHERDPSZrm, Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ325_0, Feature_HasAVX512, { MCK_MemVZ32, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9139 /* vgatherpf0dpd */, X86::VGATHERPF0DPDm, Convert__Reg1_2__MemVY325_0, 0, { MCK_MemVY32, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9153 /* vgatherpf0dps */, X86::VGATHERPF0DPSm, Convert__Reg1_2__MemVZ325_0, 0, { MCK_MemVZ32, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9167 /* vgatherpf0qpd */, X86::VGATHERPF0QPDm, Convert__Reg1_2__MemVZ645_0, 0, { MCK_MemVZ64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9181 /* vgatherpf0qps */, X86::VGATHERPF0QPSm, Convert__Reg1_2__MemVZ645_0, 0, { MCK_MemVZ64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9195 /* vgatherpf1dpd */, X86::VGATHERPF1DPDm, Convert__Reg1_2__MemVY325_0, 0, { MCK_MemVY32, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9209 /* vgatherpf1dps */, X86::VGATHERPF1DPSm, Convert__Reg1_2__MemVZ325_0, 0, { MCK_MemVZ32, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9223 /* vgatherpf1qpd */, X86::VGATHERPF1QPDm, Convert__Reg1_2__MemVZ645_0, 0, { MCK_MemVZ64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9237 /* vgatherpf1qps */, X86::VGATHERPF1QPSm, Convert__Reg1_2__MemVZ645_0, 0, { MCK_MemVZ64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9251 /* vgatherqpd */, X86::VGATHERQPDrm, Convert__Reg1_2__Reg1_0__Tie0__MemVX645_1__Tie1, 0, { MCK_FR32, MCK_MemVX64, MCK_FR32 }, },
  { 9251 /* vgatherqpd */, X86::VGATHERQPDYrm, Convert__Reg1_2__Reg1_0__Tie0__MemVY645_1__Tie1, 0, { MCK_VR256, MCK_MemVY64, MCK_VR256 }, },
  { 9251 /* vgatherqpd */, X86::VGATHERQPDZrm, Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ645_0, Feature_HasAVX512, { MCK_MemVZ64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9262 /* vgatherqps */, X86::VGATHERQPSrm, Convert__Reg1_2__Reg1_0__Tie0__MemVX325_1__Tie1, 0, { MCK_FR32, MCK_MemVX32, MCK_FR32 }, },
  { 9262 /* vgatherqps */, X86::VGATHERQPSYrm, Convert__Reg1_2__Reg1_0__Tie0__MemVY325_1__Tie1, 0, { MCK_FR32, MCK_MemVY32, MCK_FR32 }, },
  { 9262 /* vgatherqps */, X86::VGATHERQPSZrm, Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ645_0, Feature_HasAVX512, { MCK_MemVZ64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9273 /* vhaddpd */, X86::VHADDPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9273 /* vhaddpd */, X86::VHADDPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9273 /* vhaddpd */, X86::VHADDPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9273 /* vhaddpd */, X86::VHADDPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9281 /* vhaddps */, X86::VHADDPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9281 /* vhaddps */, X86::VHADDPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9281 /* vhaddps */, X86::VHADDPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9281 /* vhaddps */, X86::VHADDPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9289 /* vhsubpd */, X86::VHSUBPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9289 /* vhsubpd */, X86::VHSUBPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9289 /* vhsubpd */, X86::VHSUBPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9289 /* vhsubpd */, X86::VHSUBPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9297 /* vhsubps */, X86::VHSUBPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9297 /* vhsubps */, X86::VHSUBPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9297 /* vhsubps */, X86::VHSUBPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9297 /* vhsubps */, X86::VHSUBPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9305 /* vinsertf128 */, X86::VINSERTF128rr, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_VR256, MCK_VR256 }, },
  { 9305 /* vinsertf128 */, X86::VINSERTF128rm, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_VR256, MCK_VR256 }, },
  { 9317 /* vinsertf32x4 */, X86::VINSERTF32x4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_FR32X, MCK_VR512, MCK_VR512 }, },
  { 9317 /* vinsertf32x4 */, X86::VINSERTF32x4rm, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem128, MCK_VR512, MCK_VR512 }, },
  { 9330 /* vinsertf64x4 */, X86::VINSERTF64x4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR256X, MCK_VR512, MCK_VR512 }, },
  { 9330 /* vinsertf64x4 */, X86::VINSERTF64x4rm, Convert__Reg1_3__Reg1_2__Mem2565_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem256, MCK_VR512, MCK_VR512 }, },
  { 9343 /* vinserti128 */, X86::VINSERTI128rr, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_VR256, MCK_VR256 }, },
  { 9343 /* vinserti128 */, X86::VINSERTI128rm, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_VR256, MCK_VR256 }, },
  { 9355 /* vinserti32x4 */, X86::VINSERTI32x4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_FR32X, MCK_VR512, MCK_VR512 }, },
  { 9355 /* vinserti32x4 */, X86::VINSERTI32x4rm, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem128, MCK_VR512, MCK_VR512 }, },
  { 9368 /* vinserti64x4 */, X86::VINSERTI64x4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR256X, MCK_VR512, MCK_VR512 }, },
  { 9368 /* vinserti64x4 */, X86::VINSERTI64x4rm, Convert__Reg1_3__Reg1_2__Mem2565_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem256, MCK_VR512, MCK_VR512 }, },
  { 9381 /* vinsertps */, X86::VINSERTPSrr, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9381 /* vinsertps */, X86::VINSERTPSzrr, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, Feature_HasAVX512, { MCK_ImmZExtu32u8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9381 /* vinsertps */, X86::VINSERTPSrm, Convert__Reg1_3__Reg1_2__Mem325_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9381 /* vinsertps */, X86::VINSERTPSzrm, Convert__Reg1_3__Reg1_2__Mem325_1__ImmZExtu32u81_0, Feature_HasAVX512, { MCK_ImmZExtu32u8, MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9391 /* vlddqu */, X86::VLDDQUrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9391 /* vlddqu */, X86::VLDDQUYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9398 /* vldmxcsr */, X86::VLDMXCSR, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 9407 /* vmaskmovdqu */, X86::VMASKMOVDQU, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_FR32, MCK_FR32 }, },
  { 9407 /* vmaskmovdqu */, X86::VMASKMOVDQU64, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_FR32, MCK_FR32 }, },
  { 9419 /* vmaskmovpd */, X86::VMASKMOVPDmr, Convert__Mem1285_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_Mem128 }, },
  { 9419 /* vmaskmovpd */, X86::VMASKMOVPDYmr, Convert__Mem2565_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_Mem256 }, },
  { 9419 /* vmaskmovpd */, X86::VMASKMOVPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9419 /* vmaskmovpd */, X86::VMASKMOVPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9430 /* vmaskmovps */, X86::VMASKMOVPSmr, Convert__Mem1285_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_Mem128 }, },
  { 9430 /* vmaskmovps */, X86::VMASKMOVPSYmr, Convert__Mem2565_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_Mem256 }, },
  { 9430 /* vmaskmovps */, X86::VMASKMOVPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9430 /* vmaskmovps */, X86::VMASKMOVPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9441 /* vmaxpd */, X86::VMAXPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9441 /* vmaxpd */, X86::VMAXPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9441 /* vmaxpd */, X86::VMAXPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9441 /* vmaxpd */, X86::VMAXPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9441 /* vmaxpd */, X86::VMAXPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9441 /* vmaxpd */, X86::VMAXPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9441 /* vmaxpd */, X86::VMAXPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9441 /* vmaxpd */, X86::VMAXPDZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9441 /* vmaxpd */, X86::VMAXPDZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9441 /* vmaxpd */, X86::VMAXPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9441 /* vmaxpd */, X86::VMAXPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9441 /* vmaxpd */, X86::VMAXPDZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9441 /* vmaxpd */, X86::VMAXPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9448 /* vmaxps */, X86::VMAXPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9448 /* vmaxps */, X86::VMAXPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9448 /* vmaxps */, X86::VMAXPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9448 /* vmaxps */, X86::VMAXPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9448 /* vmaxps */, X86::VMAXPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9448 /* vmaxps */, X86::VMAXPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9448 /* vmaxps */, X86::VMAXPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9448 /* vmaxps */, X86::VMAXPSZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9448 /* vmaxps */, X86::VMAXPSZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9448 /* vmaxps */, X86::VMAXPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9448 /* vmaxps */, X86::VMAXPSZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9448 /* vmaxps */, X86::VMAXPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9448 /* vmaxps */, X86::VMAXPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9455 /* vmaxsd */, X86::VMAXSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9455 /* vmaxsd */, X86::VMAXSDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9455 /* vmaxsd */, X86::VMAXSDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9455 /* vmaxsd */, X86::VMAXSDZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 9462 /* vmaxss */, X86::VMAXSSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9462 /* vmaxss */, X86::VMAXSSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9462 /* vmaxss */, X86::VMAXSSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9462 /* vmaxss */, X86::VMAXSSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9469 /* vmcall */, X86::VMCALL, Convert_NoOperands, 0, {  }, },
  { 9476 /* vmclear */, X86::VMCLEARm, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 9484 /* vmfunc */, X86::VMFUNC, Convert_NoOperands, 0, {  }, },
  { 9491 /* vminpd */, X86::VMINPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9491 /* vminpd */, X86::VMINPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9491 /* vminpd */, X86::VMINPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9491 /* vminpd */, X86::VMINPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9491 /* vminpd */, X86::VMINPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9491 /* vminpd */, X86::VMINPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9491 /* vminpd */, X86::VMINPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9491 /* vminpd */, X86::VMINPDZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9491 /* vminpd */, X86::VMINPDZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9491 /* vminpd */, X86::VMINPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9491 /* vminpd */, X86::VMINPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9491 /* vminpd */, X86::VMINPDZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9491 /* vminpd */, X86::VMINPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9498 /* vminps */, X86::VMINPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9498 /* vminps */, X86::VMINPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9498 /* vminps */, X86::VMINPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9498 /* vminps */, X86::VMINPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9498 /* vminps */, X86::VMINPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9498 /* vminps */, X86::VMINPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9498 /* vminps */, X86::VMINPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9498 /* vminps */, X86::VMINPSZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9498 /* vminps */, X86::VMINPSZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9498 /* vminps */, X86::VMINPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9498 /* vminps */, X86::VMINPSZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9498 /* vminps */, X86::VMINPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9498 /* vminps */, X86::VMINPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9505 /* vminsd */, X86::VMINSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9505 /* vminsd */, X86::VMINSDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9505 /* vminsd */, X86::VMINSDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9505 /* vminsd */, X86::VMINSDZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 9512 /* vminss */, X86::VMINSSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9512 /* vminss */, X86::VMINSSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9512 /* vminss */, X86::VMINSSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9512 /* vminss */, X86::VMINSSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9519 /* vmlaunch */, X86::VMLAUNCH, Convert_NoOperands, 0, {  }, },
  { 9528 /* vmload */, X86::VMLOAD32, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX }, },
  { 9528 /* vmload */, X86::VMLOAD64, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX }, },
  { 9535 /* vmmcall */, X86::VMMCALL, Convert_NoOperands, 0, {  }, },
  { 9543 /* vmovapd */, X86::VMOVAPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9543 /* vmovapd */, X86::VMOVAPDmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 9543 /* vmovapd */, X86::VMOVAPDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9543 /* vmovapd */, X86::VMOVAPDYmr, Convert__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256 }, },
  { 9543 /* vmovapd */, X86::VMOVAPDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9543 /* vmovapd */, X86::VMOVAPDZrr_alt, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9543 /* vmovapd */, X86::VMOVAPDZmr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 9543 /* vmovapd */, X86::VMOVAPDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9543 /* vmovapd */, X86::VMOVAPDYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9543 /* vmovapd */, X86::VMOVAPDZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9543 /* vmovapd */, X86::VMOVAPDZalt_rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9543 /* vmovapd */, X86::VMOVAPDZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9543 /* vmovapd */, X86::VMOVAPDZmrk, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9543 /* vmovapd */, X86::VMOVAPDZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9543 /* vmovapd */, X86::VMOVAPDZalt_rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9543 /* vmovapd */, X86::VMOVAPDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9543 /* vmovapd */, X86::VMOVAPDZmrkz, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9543 /* vmovapd */, X86::VMOVAPDZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9551 /* vmovaps */, X86::VMOVAPSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9551 /* vmovaps */, X86::VMOVAPSmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 9551 /* vmovaps */, X86::VMOVAPSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9551 /* vmovaps */, X86::VMOVAPSYmr, Convert__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256 }, },
  { 9551 /* vmovaps */, X86::VMOVAPSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9551 /* vmovaps */, X86::VMOVAPSZrr_alt, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9551 /* vmovaps */, X86::VMOVAPSZmr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 9551 /* vmovaps */, X86::VMOVAPSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9551 /* vmovaps */, X86::VMOVAPSYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9551 /* vmovaps */, X86::VMOVAPSZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9551 /* vmovaps */, X86::VMOVAPSZalt_rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9551 /* vmovaps */, X86::VMOVAPSZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9551 /* vmovaps */, X86::VMOVAPSZmrk, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9551 /* vmovaps */, X86::VMOVAPSZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9551 /* vmovaps */, X86::VMOVAPSZalt_rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9551 /* vmovaps */, X86::VMOVAPSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9551 /* vmovaps */, X86::VMOVAPSZmrkz, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9551 /* vmovaps */, X86::VMOVAPSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9559 /* vmovd */, X86::VMOVDI2PDIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32 }, },
  { 9559 /* vmovd */, X86::VMOVDI2PDIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_FR32X }, },
  { 9559 /* vmovd */, X86::VMOV64toPQIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 9559 /* vmovd */, X86::VMOVPDI2DIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 9559 /* vmovd */, X86::VMOVPQIto64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 9559 /* vmovd */, X86::VMOVPDI2DImr, Convert__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32 }, },
  { 9559 /* vmovd */, X86::VMOVPDI2DIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 9559 /* vmovd */, X86::VMOVPDI2DIZmr, Convert__Mem325_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_Mem32 }, },
  { 9559 /* vmovd */, X86::VMOVDI2PDIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 9559 /* vmovd */, X86::VMOVDI2PDIZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X }, },
  { 9565 /* vmovddup */, X86::VMOVDDUPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9565 /* vmovddup */, X86::VMOVDDUPYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9565 /* vmovddup */, X86::VMOVDDUPZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9565 /* vmovddup */, X86::VMOVDDUPYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9565 /* vmovddup */, X86::VMOVDDUPZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9565 /* vmovddup */, X86::VMOVDDUPrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 9574 /* vmovdqa */, X86::VMOVDQArr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9574 /* vmovdqa */, X86::VMOVDQAmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 9574 /* vmovdqa */, X86::VMOVDQAYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9574 /* vmovdqa */, X86::VMOVDQAYmr, Convert__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256 }, },
  { 9574 /* vmovdqa */, X86::VMOVDQArm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9574 /* vmovdqa */, X86::VMOVDQAYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9582 /* vmovdqa32 */, X86::VMOVDQA32rr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9582 /* vmovdqa32 */, X86::VMOVDQA32rr_alt, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9582 /* vmovdqa32 */, X86::VMOVDQA32mr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 9582 /* vmovdqa32 */, X86::VMOVDQA32rm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9582 /* vmovdqa32 */, X86::VMOVDQA32alt_rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9582 /* vmovdqa32 */, X86::VMOVDQA32rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9582 /* vmovdqa32 */, X86::VMOVDQA32mrk, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9582 /* vmovdqa32 */, X86::VMOVDQA32rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9582 /* vmovdqa32 */, X86::VMOVDQA32alt_rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9582 /* vmovdqa32 */, X86::VMOVDQA32rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9582 /* vmovdqa32 */, X86::VMOVDQA32mrkz, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9582 /* vmovdqa32 */, X86::VMOVDQA32rmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9592 /* vmovdqa64 */, X86::VMOVDQA64rr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9592 /* vmovdqa64 */, X86::VMOVDQA64rr_alt, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9592 /* vmovdqa64 */, X86::VMOVDQA64mr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 9592 /* vmovdqa64 */, X86::VMOVDQA64rm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9592 /* vmovdqa64 */, X86::VMOVDQA64alt_rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9592 /* vmovdqa64 */, X86::VMOVDQA64rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9592 /* vmovdqa64 */, X86::VMOVDQA64mrk, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9592 /* vmovdqa64 */, X86::VMOVDQA64rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9592 /* vmovdqa64 */, X86::VMOVDQA64alt_rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9592 /* vmovdqa64 */, X86::VMOVDQA64rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9592 /* vmovdqa64 */, X86::VMOVDQA64mrkz, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9592 /* vmovdqa64 */, X86::VMOVDQA64rmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9602 /* vmovdqu */, X86::VMOVDQUrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9602 /* vmovdqu */, X86::VMOVDQUmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 9602 /* vmovdqu */, X86::VMOVDQUYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9602 /* vmovdqu */, X86::VMOVDQUYmr, Convert__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256 }, },
  { 9602 /* vmovdqu */, X86::VMOVDQUrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9602 /* vmovdqu */, X86::VMOVDQUYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9610 /* vmovdqu32 */, X86::VMOVDQU32rr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9610 /* vmovdqu32 */, X86::VMOVDQU32rr_alt, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9610 /* vmovdqu32 */, X86::VMOVDQU32mr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 9610 /* vmovdqu32 */, X86::VMOVDQU32rm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9610 /* vmovdqu32 */, X86::VMOVDQU32alt_rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9610 /* vmovdqu32 */, X86::VMOVDQU32rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9610 /* vmovdqu32 */, X86::VMOVDQU32mrk, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9610 /* vmovdqu32 */, X86::VMOVDQU32rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9610 /* vmovdqu32 */, X86::VMOVDQU32alt_rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9610 /* vmovdqu32 */, X86::VMOVDQU32rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9610 /* vmovdqu32 */, X86::VMOVDQU32mrkz, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9610 /* vmovdqu32 */, X86::VMOVDQU32rmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vmovdqu64 */, X86::VMOVDQU64rr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9620 /* vmovdqu64 */, X86::VMOVDQU64rr_alt, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9620 /* vmovdqu64 */, X86::VMOVDQU64mr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 9620 /* vmovdqu64 */, X86::VMOVDQU64rm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9620 /* vmovdqu64 */, X86::VMOVDQU64alt_rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vmovdqu64 */, X86::VMOVDQU64rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vmovdqu64 */, X86::VMOVDQU64mrk, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vmovdqu64 */, X86::VMOVDQU64rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9620 /* vmovdqu64 */, X86::VMOVDQU64alt_rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vmovdqu64 */, X86::VMOVDQU64rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vmovdqu64 */, X86::VMOVDQU64mrkz, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9620 /* vmovdqu64 */, X86::VMOVDQU64rmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9630 /* vmovhlps */, X86::VMOVHLPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9630 /* vmovhlps */, X86::VMOVHLPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9639 /* vmovhpd */, X86::VMOVHPDmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 9639 /* vmovhpd */, X86::VMOVHPDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9647 /* vmovhps */, X86::VMOVHPSmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 9647 /* vmovhps */, X86::VMOVHPSrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9655 /* vmovlhps */, X86::VMOVLHPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9655 /* vmovlhps */, X86::VMOVLHPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9664 /* vmovlpd */, X86::VMOVLPDmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 9664 /* vmovlpd */, X86::VMOVLPDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9672 /* vmovlps */, X86::VMOVLPSmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 9672 /* vmovlps */, X86::VMOVLPSrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9680 /* vmovmskpd */, X86::VMOVMSKPDrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_FR32, MCK_GR32orGR64 }, },
  { 9680 /* vmovmskpd */, X86::VMOVMSKPDYrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_VR256, MCK_GR32orGR64 }, },
  { 9690 /* vmovmskps */, X86::VMOVMSKPSrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_FR32, MCK_GR32orGR64 }, },
  { 9690 /* vmovmskps */, X86::VMOVMSKPSYrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_VR256, MCK_GR32orGR64 }, },
  { 9700 /* vmovntdq */, X86::VMOVNTDQmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 9700 /* vmovntdq */, X86::VMOVNTDQYmr, Convert__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256 }, },
  { 9700 /* vmovntdq */, X86::VMOVNTDQZmr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 9709 /* vmovntdqa */, X86::VMOVNTDQArm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9709 /* vmovntdqa */, X86::VMOVNTDQAYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9709 /* vmovntdqa */, X86::VMOVNTDQAZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9719 /* vmovntpd */, X86::VMOVNTPDmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 9719 /* vmovntpd */, X86::VMOVNTPDYmr, Convert__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256 }, },
  { 9719 /* vmovntpd */, X86::VMOVNTPDZmr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 9728 /* vmovntps */, X86::VMOVNTPSmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 9728 /* vmovntps */, X86::VMOVNTPSYmr, Convert__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256 }, },
  { 9728 /* vmovntps */, X86::VMOVNTPSZmr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 9737 /* vmovq */, X86::VMOV64toPQIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 9737 /* vmovq */, X86::VMOV64toPQIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR64, MCK_FR32X }, },
  { 9737 /* vmovq */, X86::VMOVPQIto64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 9737 /* vmovq */, X86::VMOVZPQILo2PQIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9737 /* vmovq */, X86::VMOVSDto64Zmr, Convert__Mem645_1__Reg1_0, Feature_HasAVX512, { MCK_FR32, MCK_Mem64 }, },
  { 9737 /* vmovq */, X86::VMOVPQI2QImr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 9737 /* vmovq */, X86::VMOVPQIto64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512|Feature_In64BitMode, { MCK_FR32X, MCK_GR64 }, },
  { 9737 /* vmovq */, X86::VMOVZPQILo2PQIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X }, },
  { 9737 /* vmovq */, X86::VMOVPQIto64Zmr, Convert__Mem645_1__Reg1_0, Feature_HasAVX512|Feature_In64BitMode, { MCK_FR32X, MCK_Mem64 }, },
  { 9737 /* vmovq */, X86::VMOVZPQILo2PQIZrm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X }, },
  { 9737 /* vmovq */, X86::VMOVQI2PQIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 9737 /* vmovq */, X86::VMOVQI2PQIZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X }, },
  { 9743 /* vmovsd */, X86::VMOVSDmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 9743 /* vmovsd */, X86::VMOVSDZmr, Convert__Mem645_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_Mem64 }, },
  { 9743 /* vmovsd */, X86::VMOVSDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 9743 /* vmovsd */, X86::VMOVSDZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X }, },
  { 9743 /* vmovsd */, X86::VMOVSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9743 /* vmovsd */, X86::VMOVSDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9743 /* vmovsd */, X86::VMOVSDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9750 /* vmovshdup */, X86::VMOVSHDUPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9750 /* vmovshdup */, X86::VMOVSHDUPYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9750 /* vmovshdup */, X86::VMOVSHDUPZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9750 /* vmovshdup */, X86::VMOVSHDUPrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9750 /* vmovshdup */, X86::VMOVSHDUPYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9750 /* vmovshdup */, X86::VMOVSHDUPZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9760 /* vmovsldup */, X86::VMOVSLDUPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9760 /* vmovsldup */, X86::VMOVSLDUPYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9760 /* vmovsldup */, X86::VMOVSLDUPZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9760 /* vmovsldup */, X86::VMOVSLDUPrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9760 /* vmovsldup */, X86::VMOVSLDUPYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9760 /* vmovsldup */, X86::VMOVSLDUPZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9770 /* vmovss */, X86::VMOVSSmr, Convert__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32 }, },
  { 9770 /* vmovss */, X86::VMOVSSZmr, Convert__Mem325_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_Mem32 }, },
  { 9770 /* vmovss */, X86::VMOVSSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 9770 /* vmovss */, X86::VMOVSSZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X }, },
  { 9770 /* vmovss */, X86::VMOVSSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9770 /* vmovss */, X86::VMOVSSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9770 /* vmovss */, X86::VMOVSSZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9777 /* vmovupd */, X86::VMOVUPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9777 /* vmovupd */, X86::VMOVUPDmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 9777 /* vmovupd */, X86::VMOVUPDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9777 /* vmovupd */, X86::VMOVUPDYmr, Convert__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256 }, },
  { 9777 /* vmovupd */, X86::VMOVUPDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9777 /* vmovupd */, X86::VMOVUPDZrr_alt, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9777 /* vmovupd */, X86::VMOVUPDZmr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 9777 /* vmovupd */, X86::VMOVUPDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9777 /* vmovupd */, X86::VMOVUPDYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9777 /* vmovupd */, X86::VMOVUPDZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9777 /* vmovupd */, X86::VMOVUPDZalt_rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9777 /* vmovupd */, X86::VMOVUPDZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9777 /* vmovupd */, X86::VMOVUPDZmrk, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9777 /* vmovupd */, X86::VMOVUPDZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9777 /* vmovupd */, X86::VMOVUPDZalt_rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9777 /* vmovupd */, X86::VMOVUPDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9777 /* vmovupd */, X86::VMOVUPDZmrkz, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9777 /* vmovupd */, X86::VMOVUPDZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9785 /* vmovups */, X86::VMOVUPSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9785 /* vmovups */, X86::VMOVUPSmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 9785 /* vmovups */, X86::VMOVUPSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9785 /* vmovups */, X86::VMOVUPSYmr, Convert__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256 }, },
  { 9785 /* vmovups */, X86::VMOVUPSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9785 /* vmovups */, X86::VMOVUPSZrr_alt, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9785 /* vmovups */, X86::VMOVUPSZmr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 9785 /* vmovups */, X86::VMOVUPSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9785 /* vmovups */, X86::VMOVUPSYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9785 /* vmovups */, X86::VMOVUPSZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9785 /* vmovups */, X86::VMOVUPSZalt_rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9785 /* vmovups */, X86::VMOVUPSZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9785 /* vmovups */, X86::VMOVUPSZmrk, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9785 /* vmovups */, X86::VMOVUPSZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9785 /* vmovups */, X86::VMOVUPSZalt_rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9785 /* vmovups */, X86::VMOVUPSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9785 /* vmovups */, X86::VMOVUPSZmrkz, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9785 /* vmovups */, X86::VMOVUPSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9793 /* vmpsadbw */, X86::VMPSADBWrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9793 /* vmpsadbw */, X86::VMPSADBWYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9793 /* vmpsadbw */, X86::VMPSADBWrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9793 /* vmpsadbw */, X86::VMPSADBWYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9802 /* vmptrld */, X86::VMPTRLDm, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 9810 /* vmptrst */, X86::VMPTRSTm, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 9825 /* vmreadl */, X86::VMREAD32rr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 9825 /* vmreadl */, X86::VMREAD32rm, Convert__Mem325_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 9833 /* vmreadq */, X86::VMREAD64rr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 9833 /* vmreadq */, X86::VMREAD64rm, Convert__Mem645_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 9841 /* vmresume */, X86::VMRESUME, Convert_NoOperands, 0, {  }, },
  { 9850 /* vmrun */, X86::VMRUN32, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX }, },
  { 9850 /* vmrun */, X86::VMRUN64, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX }, },
  { 9856 /* vmsave */, X86::VMSAVE32, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX }, },
  { 9856 /* vmsave */, X86::VMSAVE64, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX }, },
  { 9863 /* vmulpd */, X86::VMULPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9863 /* vmulpd */, X86::VMULPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9863 /* vmulpd */, X86::VMULPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9863 /* vmulpd */, X86::VMULPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9863 /* vmulpd */, X86::VMULPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9863 /* vmulpd */, X86::VMULPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9863 /* vmulpd */, X86::VMULPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9863 /* vmulpd */, X86::VMULPDZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9863 /* vmulpd */, X86::VMULPDZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9863 /* vmulpd */, X86::VMULPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9863 /* vmulpd */, X86::VMULPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9863 /* vmulpd */, X86::VMULPDZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9863 /* vmulpd */, X86::VMULPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9870 /* vmulps */, X86::VMULPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9870 /* vmulps */, X86::VMULPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9870 /* vmulps */, X86::VMULPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9870 /* vmulps */, X86::VMULPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9870 /* vmulps */, X86::VMULPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9870 /* vmulps */, X86::VMULPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9870 /* vmulps */, X86::VMULPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9870 /* vmulps */, X86::VMULPSZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9870 /* vmulps */, X86::VMULPSZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9870 /* vmulps */, X86::VMULPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9870 /* vmulps */, X86::VMULPSZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9870 /* vmulps */, X86::VMULPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9870 /* vmulps */, X86::VMULPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9877 /* vmulsd */, X86::VMULSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9877 /* vmulsd */, X86::VMULSDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9877 /* vmulsd */, X86::VMULSDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9877 /* vmulsd */, X86::VMULSDZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 9884 /* vmulss */, X86::VMULSSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9884 /* vmulss */, X86::VMULSSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9884 /* vmulss */, X86::VMULSSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9884 /* vmulss */, X86::VMULSSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 9899 /* vmwritel */, X86::VMWRITE32rr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 9899 /* vmwritel */, X86::VMWRITE32rm, Convert__Reg1_1__Mem325_0, Feature_Not64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 9908 /* vmwriteq */, X86::VMWRITE64rr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 9908 /* vmwriteq */, X86::VMWRITE64rm, Convert__Reg1_1__Mem645_0, Feature_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 9917 /* vmxoff */, X86::VMXOFF, Convert_NoOperands, 0, {  }, },
  { 9924 /* vmxon */, X86::VMXON, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 9930 /* vorpd */, X86::VORPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9930 /* vorpd */, X86::VORPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9930 /* vorpd */, X86::VORPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9930 /* vorpd */, X86::VORPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9936 /* vorps */, X86::VORPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9936 /* vorps */, X86::VORPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9936 /* vorps */, X86::VORPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9936 /* vorps */, X86::VORPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9942 /* vpabsb */, X86::VPABSBrr128, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9942 /* vpabsb */, X86::VPABSBrr256, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9942 /* vpabsb */, X86::VPABSBrm128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9942 /* vpabsb */, X86::VPABSBrm256, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9949 /* vpabsd */, X86::VPABSDrr128, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9949 /* vpabsd */, X86::VPABSDrr256, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9949 /* vpabsd */, X86::VPABSDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9949 /* vpabsd */, X86::VPABSDrm128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9949 /* vpabsd */, X86::VPABSDrm256, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9949 /* vpabsd */, X86::VPABSDZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9949 /* vpabsd */, X86::VPABSDZrmb, Convert__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 9949 /* vpabsd */, X86::VPABSDZrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9949 /* vpabsd */, X86::VPABSDZrmk, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9949 /* vpabsd */, X86::VPABSDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9949 /* vpabsd */, X86::VPABSDZrmbk, Convert__Reg1_2__Reg1_4__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9949 /* vpabsd */, X86::VPABSDZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9949 /* vpabsd */, X86::VPABSDZrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9956 /* vpabsq */, X86::VPABSQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 9956 /* vpabsq */, X86::VPABSQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 9956 /* vpabsq */, X86::VPABSQZrmb, Convert__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 9956 /* vpabsq */, X86::VPABSQZrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9956 /* vpabsq */, X86::VPABSQZrmk, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9956 /* vpabsq */, X86::VPABSQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9956 /* vpabsq */, X86::VPABSQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9956 /* vpabsq */, X86::VPABSQZrmbk, Convert__Reg1_2__Reg1_4__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 9956 /* vpabsq */, X86::VPABSQZrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 9963 /* vpabsw */, X86::VPABSWrr128, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 9963 /* vpabsw */, X86::VPABSWrr256, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 9963 /* vpabsw */, X86::VPABSWrm128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 9963 /* vpabsw */, X86::VPABSWrm256, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 9970 /* vpackssdw */, X86::VPACKSSDWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9970 /* vpackssdw */, X86::VPACKSSDWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9970 /* vpackssdw */, X86::VPACKSSDWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9970 /* vpackssdw */, X86::VPACKSSDWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9980 /* vpacksswb */, X86::VPACKSSWBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9980 /* vpacksswb */, X86::VPACKSSWBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9980 /* vpacksswb */, X86::VPACKSSWBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9980 /* vpacksswb */, X86::VPACKSSWBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9990 /* vpackusdw */, X86::VPACKUSDWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9990 /* vpackusdw */, X86::VPACKUSDWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9990 /* vpackusdw */, X86::VPACKUSDWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9990 /* vpackusdw */, X86::VPACKUSDWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10000 /* vpackuswb */, X86::VPACKUSWBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10000 /* vpackuswb */, X86::VPACKUSWBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10000 /* vpackuswb */, X86::VPACKUSWBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10000 /* vpackuswb */, X86::VPACKUSWBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10010 /* vpaddb */, X86::VPADDBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10010 /* vpaddb */, X86::VPADDBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10010 /* vpaddb */, X86::VPADDBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10010 /* vpaddb */, X86::VPADDBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10017 /* vpaddd */, X86::VPADDDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10017 /* vpaddd */, X86::VPADDDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10017 /* vpaddd */, X86::VPADDDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10017 /* vpaddd */, X86::VPADDDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10017 /* vpaddd */, X86::VPADDDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10017 /* vpaddd */, X86::VPADDDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10017 /* vpaddd */, X86::VPADDDZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 10017 /* vpaddd */, X86::VPADDDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10017 /* vpaddd */, X86::VPADDDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10017 /* vpaddd */, X86::VPADDDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10017 /* vpaddd */, X86::VPADDDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10017 /* vpaddd */, X86::VPADDDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10017 /* vpaddd */, X86::VPADDDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10024 /* vpaddq */, X86::VPADDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10024 /* vpaddq */, X86::VPADDQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10024 /* vpaddq */, X86::VPADDQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10024 /* vpaddq */, X86::VPADDQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10024 /* vpaddq */, X86::VPADDQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10024 /* vpaddq */, X86::VPADDQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10024 /* vpaddq */, X86::VPADDQZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 10024 /* vpaddq */, X86::VPADDQZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10024 /* vpaddq */, X86::VPADDQZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10024 /* vpaddq */, X86::VPADDQZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10024 /* vpaddq */, X86::VPADDQZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10024 /* vpaddq */, X86::VPADDQZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10024 /* vpaddq */, X86::VPADDQZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10031 /* vpaddsb */, X86::VPADDSBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10031 /* vpaddsb */, X86::VPADDSBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10031 /* vpaddsb */, X86::VPADDSBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10031 /* vpaddsb */, X86::VPADDSBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10039 /* vpaddsw */, X86::VPADDSWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10039 /* vpaddsw */, X86::VPADDSWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10039 /* vpaddsw */, X86::VPADDSWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10039 /* vpaddsw */, X86::VPADDSWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10047 /* vpaddusb */, X86::VPADDUSBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10047 /* vpaddusb */, X86::VPADDUSBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10047 /* vpaddusb */, X86::VPADDUSBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10047 /* vpaddusb */, X86::VPADDUSBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10056 /* vpaddusw */, X86::VPADDUSWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10056 /* vpaddusw */, X86::VPADDUSWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10056 /* vpaddusw */, X86::VPADDUSWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10056 /* vpaddusw */, X86::VPADDUSWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10065 /* vpaddw */, X86::VPADDWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10065 /* vpaddw */, X86::VPADDWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10065 /* vpaddw */, X86::VPADDWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10065 /* vpaddw */, X86::VPADDWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10072 /* vpalignr */, X86::VPALIGNR128rr, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10072 /* vpalignr */, X86::VPALIGNR256rr, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10072 /* vpalignr */, X86::VPALIGNR128rm, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10072 /* vpalignr */, X86::VPALIGNR256rm, Convert__Reg1_3__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10081 /* vpand */, X86::VPANDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10081 /* vpand */, X86::VPANDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10081 /* vpand */, X86::VPANDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10081 /* vpand */, X86::VPANDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10087 /* vpandd */, X86::VPANDDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10087 /* vpandd */, X86::VPANDDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10087 /* vpandd */, X86::VPANDDZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 10087 /* vpandd */, X86::VPANDDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10087 /* vpandd */, X86::VPANDDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10087 /* vpandd */, X86::VPANDDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10087 /* vpandd */, X86::VPANDDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10087 /* vpandd */, X86::VPANDDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10087 /* vpandd */, X86::VPANDDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10094 /* vpandn */, X86::VPANDNrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10094 /* vpandn */, X86::VPANDNYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10094 /* vpandn */, X86::VPANDNrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10094 /* vpandn */, X86::VPANDNYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10101 /* vpandnd */, X86::VPANDNDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10101 /* vpandnd */, X86::VPANDNDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10101 /* vpandnd */, X86::VPANDNDZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 10101 /* vpandnd */, X86::VPANDNDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10101 /* vpandnd */, X86::VPANDNDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10101 /* vpandnd */, X86::VPANDNDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10101 /* vpandnd */, X86::VPANDNDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10101 /* vpandnd */, X86::VPANDNDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10101 /* vpandnd */, X86::VPANDNDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10109 /* vpandnq */, X86::VPANDNQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10109 /* vpandnq */, X86::VPANDNQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10109 /* vpandnq */, X86::VPANDNQZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 10109 /* vpandnq */, X86::VPANDNQZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10109 /* vpandnq */, X86::VPANDNQZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10109 /* vpandnq */, X86::VPANDNQZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10109 /* vpandnq */, X86::VPANDNQZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10109 /* vpandnq */, X86::VPANDNQZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10109 /* vpandnq */, X86::VPANDNQZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10117 /* vpandq */, X86::VPANDQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10117 /* vpandq */, X86::VPANDQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10117 /* vpandq */, X86::VPANDQZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 10117 /* vpandq */, X86::VPANDQZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10117 /* vpandq */, X86::VPANDQZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10117 /* vpandq */, X86::VPANDQZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10117 /* vpandq */, X86::VPANDQZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10117 /* vpandq */, X86::VPANDQZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10117 /* vpandq */, X86::VPANDQZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10124 /* vpavgb */, X86::VPAVGBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10124 /* vpavgb */, X86::VPAVGBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10124 /* vpavgb */, X86::VPAVGBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10124 /* vpavgb */, X86::VPAVGBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10131 /* vpavgw */, X86::VPAVGWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10131 /* vpavgw */, X86::VPAVGWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10131 /* vpavgw */, X86::VPAVGWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10131 /* vpavgw */, X86::VPAVGWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10138 /* vpblendd */, X86::VPBLENDDrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10138 /* vpblendd */, X86::VPBLENDDYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10138 /* vpblendd */, X86::VPBLENDDrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10138 /* vpblendd */, X86::VPBLENDDYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10147 /* vpblendmd */, X86::VPBLENDMDZrr, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10147 /* vpblendmd */, X86::VPBLENDMDZrm, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10157 /* vpblendmq */, X86::VPBLENDMQZrr, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10157 /* vpblendmq */, X86::VPBLENDMQZrm, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10167 /* vpblendvb */, X86::VPBLENDVBrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10167 /* vpblendvb */, X86::VPBLENDVBrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10167 /* vpblendvb */, X86::VPBLENDVBYrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10167 /* vpblendvb */, X86::VPBLENDVBYrm, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10177 /* vpblendw */, X86::VPBLENDWrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10177 /* vpblendw */, X86::VPBLENDWYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10177 /* vpblendw */, X86::VPBLENDWrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10177 /* vpblendw */, X86::VPBLENDWYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmZExtu32u81_0, 0, { MCK_ImmZExtu32u8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10186 /* vpbroadcastb */, X86::VPBROADCASTBrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10186 /* vpbroadcastb */, X86::VPBROADCASTBYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 10186 /* vpbroadcastb */, X86::VPBROADCASTBrm, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_FR32 }, },
  { 10186 /* vpbroadcastb */, X86::VPBROADCASTBYrm, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_VR256 }, },
  { 10199 /* vpbroadcastd */, X86::VPBROADCASTDrZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_VR512 }, },
  { 10199 /* vpbroadcastd */, X86::VPBROADCASTDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10199 /* vpbroadcastd */, X86::VPBROADCASTDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 10199 /* vpbroadcastd */, X86::VPBROADCASTDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512 }, },
  { 10199 /* vpbroadcastd */, X86::VPBROADCASTDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 10199 /* vpbroadcastd */, X86::VPBROADCASTDYrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR256 }, },
  { 10199 /* vpbroadcastd */, X86::VPBROADCASTDZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_VR512 }, },
  { 10199 /* vpbroadcastd */, X86::VPBROADCASTDrZkrr, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10199 /* vpbroadcastd */, X86::VPBROADCASTDZkrr, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10199 /* vpbroadcastd */, X86::VPBROADCASTDZkrm, Convert__Reg1_1__Reg1_3__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10212 /* vpbroadcastmb2q */, X86::VPBROADCASTMB2Qrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VR512 }, },
  { 10228 /* vpbroadcastmw2d */, X86::VPBROADCASTMW2Drr, Convert__Reg1_1__Reg1_0, 0, { MCK_VK1, MCK_VR512 }, },
  { 10244 /* vpbroadcastq */, X86::VPBROADCASTQrZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR64, MCK_VR512 }, },
  { 10244 /* vpbroadcastq */, X86::VPBROADCASTQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10244 /* vpbroadcastq */, X86::VPBROADCASTQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 10244 /* vpbroadcastq */, X86::VPBROADCASTQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512 }, },
  { 10244 /* vpbroadcastq */, X86::VPBROADCASTQrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 10244 /* vpbroadcastq */, X86::VPBROADCASTQYrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR256 }, },
  { 10244 /* vpbroadcastq */, X86::VPBROADCASTQZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_VR512 }, },
  { 10244 /* vpbroadcastq */, X86::VPBROADCASTQrZkrr, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_GR64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10244 /* vpbroadcastq */, X86::VPBROADCASTQZkrr, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10244 /* vpbroadcastq */, X86::VPBROADCASTQZkrm, Convert__Reg1_1__Reg1_3__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10257 /* vpbroadcastw */, X86::VPBROADCASTWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10257 /* vpbroadcastw */, X86::VPBROADCASTWYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 10257 /* vpbroadcastw */, X86::VPBROADCASTWrm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_FR32 }, },
  { 10257 /* vpbroadcastw */, X86::VPBROADCASTWYrm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_VR256 }, },
  { 10270 /* vpclmulhqhqdq */, X86::VPCLMULQDQrr, Convert__Reg1_2__Reg1_1__Reg1_0__imm_17, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10270 /* vpclmulhqhqdq */, X86::VPCLMULQDQrm, Convert__Reg1_2__Reg1_1__Mem1285_0__imm_17, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10284 /* vpclmulhqlqdq */, X86::VPCLMULQDQrr, Convert__Reg1_2__Reg1_1__Reg1_0__imm_1, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10284 /* vpclmulhqlqdq */, X86::VPCLMULQDQrm, Convert__Reg1_2__Reg1_1__Mem1285_0__imm_1, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10298 /* vpclmullqhqdq */, X86::VPCLMULQDQrr, Convert__Reg1_2__Reg1_1__Reg1_0__imm_16, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10298 /* vpclmullqhqdq */, X86::VPCLMULQDQrm, Convert__Reg1_2__Reg1_1__Mem1285_0__imm_16, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10312 /* vpclmullqlqdq */, X86::VPCLMULQDQrr, Convert__Reg1_2__Reg1_1__Reg1_0__imm_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10312 /* vpclmullqlqdq */, X86::VPCLMULQDQrm, Convert__Reg1_2__Reg1_1__Mem1285_0__imm_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10326 /* vpclmulqdq */, X86::VPCLMULQDQrr, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10326 /* vpclmulqdq */, X86::VPCLMULQDQrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10337 /* vpcmov */, X86::VPCMOVrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10337 /* vpcmov */, X86::VPCMOVmr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10337 /* vpcmov */, X86::VPCMOVrrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10337 /* vpcmov */, X86::VPCMOVmrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10337 /* vpcmov */, X86::VPCMOVrm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10337 /* vpcmov */, X86::VPCMOVrmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10344 /* vpcmp */, X86::VPCMPDZrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_d, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 10344 /* vpcmp */, X86::VPCMPDZrmi, Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_d, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 10344 /* vpcmp */, X86::VPCMPQZrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_q, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 10344 /* vpcmp */, X86::VPCMPQZrmi, Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_q, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 10344 /* vpcmp */, X86::VPCMPUDZrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ud, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 10344 /* vpcmp */, X86::VPCMPUDZrmi, Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ud, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 10344 /* vpcmp */, X86::VPCMPUQZrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_uq, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 10344 /* vpcmp */, X86::VPCMPUQZrmi, Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_uq, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 10350 /* vpcmpd */, X86::VPCMPDZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 10350 /* vpcmpd */, X86::VPCMPDZrmi_alt, Convert__Reg1_3__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 10350 /* vpcmpd */, X86::VPCMPDZrrik_alt, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10350 /* vpcmpd */, X86::VPCMPDZrmik_alt, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10357 /* vpcmpeqb */, X86::VPCMPEQBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10357 /* vpcmpeqb */, X86::VPCMPEQBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10357 /* vpcmpeqb */, X86::VPCMPEQBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10357 /* vpcmpeqb */, X86::VPCMPEQBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10366 /* vpcmpeqd */, X86::VPCMPEQDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10366 /* vpcmpeqd */, X86::VPCMPEQDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10366 /* vpcmpeqd */, X86::VPCMPEQDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 10366 /* vpcmpeqd */, X86::VPCMPEQDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10366 /* vpcmpeqd */, X86::VPCMPEQDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10366 /* vpcmpeqd */, X86::VPCMPEQDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 10375 /* vpcmpeqq */, X86::VPCMPEQQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10375 /* vpcmpeqq */, X86::VPCMPEQQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10375 /* vpcmpeqq */, X86::VPCMPEQQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 10375 /* vpcmpeqq */, X86::VPCMPEQQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10375 /* vpcmpeqq */, X86::VPCMPEQQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10375 /* vpcmpeqq */, X86::VPCMPEQQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 10384 /* vpcmpeqw */, X86::VPCMPEQWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10384 /* vpcmpeqw */, X86::VPCMPEQWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10384 /* vpcmpeqw */, X86::VPCMPEQWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10384 /* vpcmpeqw */, X86::VPCMPEQWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10393 /* vpcmpestri */, X86::VPCMPESTRIrr, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 10393 /* vpcmpestri */, X86::VPCMPESTRIrm, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 10404 /* vpcmpestrm */, X86::VPCMPESTRM128rr, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 10404 /* vpcmpestrm */, X86::VPCMPESTRM128rm, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 10415 /* vpcmpgtb */, X86::VPCMPGTBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10415 /* vpcmpgtb */, X86::VPCMPGTBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10415 /* vpcmpgtb */, X86::VPCMPGTBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10415 /* vpcmpgtb */, X86::VPCMPGTBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10424 /* vpcmpgtd */, X86::VPCMPGTDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10424 /* vpcmpgtd */, X86::VPCMPGTDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10424 /* vpcmpgtd */, X86::VPCMPGTDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 10424 /* vpcmpgtd */, X86::VPCMPGTDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10424 /* vpcmpgtd */, X86::VPCMPGTDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10424 /* vpcmpgtd */, X86::VPCMPGTDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 10433 /* vpcmpgtq */, X86::VPCMPGTQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10433 /* vpcmpgtq */, X86::VPCMPGTQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10433 /* vpcmpgtq */, X86::VPCMPGTQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 10433 /* vpcmpgtq */, X86::VPCMPGTQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10433 /* vpcmpgtq */, X86::VPCMPGTQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10433 /* vpcmpgtq */, X86::VPCMPGTQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 10442 /* vpcmpgtw */, X86::VPCMPGTWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10442 /* vpcmpgtw */, X86::VPCMPGTWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10442 /* vpcmpgtw */, X86::VPCMPGTWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10442 /* vpcmpgtw */, X86::VPCMPGTWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10451 /* vpcmpistri */, X86::VPCMPISTRIrr, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 10451 /* vpcmpistri */, X86::VPCMPISTRIrm, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 10462 /* vpcmpistrm */, X86::VPCMPISTRM128rr, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 10462 /* vpcmpistrm */, X86::VPCMPISTRM128rm, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 10473 /* vpcmpq */, X86::VPCMPQZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 10473 /* vpcmpq */, X86::VPCMPQZrmi_alt, Convert__Reg1_3__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 10473 /* vpcmpq */, X86::VPCMPQZrrik_alt, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10473 /* vpcmpq */, X86::VPCMPQZrmik_alt, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10480 /* vpcmpud */, X86::VPCMPUDZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 10480 /* vpcmpud */, X86::VPCMPUDZrmi_alt, Convert__Reg1_3__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 10480 /* vpcmpud */, X86::VPCMPUDZrrik_alt, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10480 /* vpcmpud */, X86::VPCMPUDZrmik_alt, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10488 /* vpcmpuq */, X86::VPCMPUQZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 10488 /* vpcmpuq */, X86::VPCMPUQZrmi_alt, Convert__Reg1_3__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 10488 /* vpcmpuq */, X86::VPCMPUQZrrik_alt, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10488 /* vpcmpuq */, X86::VPCMPUQZrmik_alt, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10496 /* vpcomb */, X86::VPCOMBri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10496 /* vpcomb */, X86::VPCOMBmi, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10503 /* vpcomd */, X86::VPCOMDri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10503 /* vpcomd */, X86::VPCOMDmi, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10510 /* vpcomq */, X86::VPCOMQri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10510 /* vpcomq */, X86::VPCOMQmi, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10517 /* vpcomub */, X86::VPCOMUBri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10517 /* vpcomub */, X86::VPCOMUBmi, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10525 /* vpcomud */, X86::VPCOMUDri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10525 /* vpcomud */, X86::VPCOMUDmi, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10533 /* vpcomuq */, X86::VPCOMUQri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10533 /* vpcomuq */, X86::VPCOMUQmi, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10541 /* vpcomuw */, X86::VPCOMUWri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10541 /* vpcomuw */, X86::VPCOMUWmi, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10549 /* vpcomw */, X86::VPCOMWri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10549 /* vpcomw */, X86::VPCOMWmi, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10556 /* vpconflictd */, X86::VPCONFLICTDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 10556 /* vpconflictd */, X86::VPCONFLICTDrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 10556 /* vpconflictd */, X86::VPCONFLICTDrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 10556 /* vpconflictd */, X86::VPCONFLICTDrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10556 /* vpconflictd */, X86::VPCONFLICTDrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10556 /* vpconflictd */, X86::VPCONFLICTDrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10556 /* vpconflictd */, X86::VPCONFLICTDrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10556 /* vpconflictd */, X86::VPCONFLICTDrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10556 /* vpconflictd */, X86::VPCONFLICTDrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10568 /* vpconflictq */, X86::VPCONFLICTQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 10568 /* vpconflictq */, X86::VPCONFLICTQrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 10568 /* vpconflictq */, X86::VPCONFLICTQrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 10568 /* vpconflictq */, X86::VPCONFLICTQrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10568 /* vpconflictq */, X86::VPCONFLICTQrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10568 /* vpconflictq */, X86::VPCONFLICTQrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10568 /* vpconflictq */, X86::VPCONFLICTQrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10568 /* vpconflictq */, X86::VPCONFLICTQrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10568 /* vpconflictq */, X86::VPCONFLICTQrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10580 /* vperm2f128 */, X86::VPERM2F128rr, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10580 /* vperm2f128 */, X86::VPERM2F128rm, Convert__Reg1_3__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10591 /* vperm2i128 */, X86::VPERM2I128rr, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10591 /* vperm2i128 */, X86::VPERM2I128rm, Convert__Reg1_3__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10602 /* vpermd */, X86::VPERMDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10602 /* vpermd */, X86::VPERMDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10602 /* vpermd */, X86::VPERMDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10602 /* vpermd */, X86::VPERMDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10609 /* vpermi2d */, X86::VPERMI2Drr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10609 /* vpermi2d */, X86::VPERMI2Drm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10609 /* vpermi2d */, X86::VPERMI2Drrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10609 /* vpermi2d */, X86::VPERMI2Drmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10609 /* vpermi2d */, X86::VPERMI2Drrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10609 /* vpermi2d */, X86::VPERMI2Drmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10618 /* vpermi2pd */, X86::VPERMI2PDrr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10618 /* vpermi2pd */, X86::VPERMI2PDrm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10618 /* vpermi2pd */, X86::VPERMI2PDrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10618 /* vpermi2pd */, X86::VPERMI2PDrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10618 /* vpermi2pd */, X86::VPERMI2PDrrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10618 /* vpermi2pd */, X86::VPERMI2PDrmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10628 /* vpermi2ps */, X86::VPERMI2PSrr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10628 /* vpermi2ps */, X86::VPERMI2PSrm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10628 /* vpermi2ps */, X86::VPERMI2PSrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10628 /* vpermi2ps */, X86::VPERMI2PSrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10628 /* vpermi2ps */, X86::VPERMI2PSrrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10628 /* vpermi2ps */, X86::VPERMI2PSrmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10638 /* vpermi2q */, X86::VPERMI2Qrr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10638 /* vpermi2q */, X86::VPERMI2Qrm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10638 /* vpermi2q */, X86::VPERMI2Qrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10638 /* vpermi2q */, X86::VPERMI2Qrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10638 /* vpermi2q */, X86::VPERMI2Qrrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10638 /* vpermi2q */, X86::VPERMI2Qrmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10647 /* vpermil2pd */, X86::VPERMIL2PDrr, Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10647 /* vpermil2pd */, X86::VPERMIL2PDmr, Convert__Reg1_4__Reg1_3__Mem1285_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10647 /* vpermil2pd */, X86::VPERMIL2PDrrY, Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10647 /* vpermil2pd */, X86::VPERMIL2PDmrY, Convert__Reg1_4__Reg1_3__Mem2565_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10647 /* vpermil2pd */, X86::VPERMIL2PDrm, Convert__Reg1_4__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10647 /* vpermil2pd */, X86::VPERMIL2PDrmY, Convert__Reg1_4__Reg1_3__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10658 /* vpermil2ps */, X86::VPERMIL2PSrr, Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10658 /* vpermil2ps */, X86::VPERMIL2PSmr, Convert__Reg1_4__Reg1_3__Mem1285_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10658 /* vpermil2ps */, X86::VPERMIL2PSrrY, Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10658 /* vpermil2ps */, X86::VPERMIL2PSmrY, Convert__Reg1_4__Reg1_3__Mem2565_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10658 /* vpermil2ps */, X86::VPERMIL2PSrm, Convert__Reg1_4__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10658 /* vpermil2ps */, X86::VPERMIL2PSrmY, Convert__Reg1_4__Reg1_3__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10669 /* vpermilpd */, X86::VPERMILPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10669 /* vpermilpd */, X86::VPERMILPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10669 /* vpermilpd */, X86::VPERMILPDri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 10669 /* vpermilpd */, X86::VPERMILPDYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 10669 /* vpermilpd */, X86::VPERMILPDZri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 10669 /* vpermilpd */, X86::VPERMILPDmi, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 10669 /* vpermilpd */, X86::VPERMILPDYmi, Convert__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256 }, },
  { 10669 /* vpermilpd */, X86::VPERMILPDZmi, Convert__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512 }, },
  { 10669 /* vpermilpd */, X86::VPERMILPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10669 /* vpermilpd */, X86::VPERMILPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10679 /* vpermilps */, X86::VPERMILPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10679 /* vpermilps */, X86::VPERMILPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10679 /* vpermilps */, X86::VPERMILPSri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 10679 /* vpermilps */, X86::VPERMILPSYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 10679 /* vpermilps */, X86::VPERMILPSZri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 10679 /* vpermilps */, X86::VPERMILPSmi, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 10679 /* vpermilps */, X86::VPERMILPSYmi, Convert__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256 }, },
  { 10679 /* vpermilps */, X86::VPERMILPSZmi, Convert__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512 }, },
  { 10679 /* vpermilps */, X86::VPERMILPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10679 /* vpermilps */, X86::VPERMILPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10689 /* vpermpd */, X86::VPERMPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10689 /* vpermpd */, X86::VPERMPDYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 10689 /* vpermpd */, X86::VPERMPDZri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 10689 /* vpermpd */, X86::VPERMPDYmi, Convert__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256 }, },
  { 10689 /* vpermpd */, X86::VPERMPDZmi, Convert__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512 }, },
  { 10689 /* vpermpd */, X86::VPERMPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10697 /* vpermps */, X86::VPERMPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10697 /* vpermps */, X86::VPERMPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10697 /* vpermps */, X86::VPERMPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10697 /* vpermps */, X86::VPERMPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10705 /* vpermq */, X86::VPERMQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10705 /* vpermq */, X86::VPERMQYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 10705 /* vpermq */, X86::VPERMQZri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 10705 /* vpermq */, X86::VPERMQYmi, Convert__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256 }, },
  { 10705 /* vpermq */, X86::VPERMQZmi, Convert__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512 }, },
  { 10705 /* vpermq */, X86::VPERMQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10712 /* vpermt2d */, X86::VPERMT2Drr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10712 /* vpermt2d */, X86::VPERMT2Drm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10712 /* vpermt2d */, X86::VPERMT2Drrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10712 /* vpermt2d */, X86::VPERMT2Drmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10712 /* vpermt2d */, X86::VPERMT2Drrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10712 /* vpermt2d */, X86::VPERMT2Drmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10721 /* vpermt2pd */, X86::VPERMT2PDrr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10721 /* vpermt2pd */, X86::VPERMT2PDrm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10721 /* vpermt2pd */, X86::VPERMT2PDrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10721 /* vpermt2pd */, X86::VPERMT2PDrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10721 /* vpermt2pd */, X86::VPERMT2PDrrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10721 /* vpermt2pd */, X86::VPERMT2PDrmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10731 /* vpermt2ps */, X86::VPERMT2PSrr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10731 /* vpermt2ps */, X86::VPERMT2PSrm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10731 /* vpermt2ps */, X86::VPERMT2PSrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10731 /* vpermt2ps */, X86::VPERMT2PSrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10731 /* vpermt2ps */, X86::VPERMT2PSrrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10731 /* vpermt2ps */, X86::VPERMT2PSrmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10741 /* vpermt2q */, X86::VPERMT2Qrr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 10741 /* vpermt2q */, X86::VPERMT2Qrm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 10741 /* vpermt2q */, X86::VPERMT2Qrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10741 /* vpermt2q */, X86::VPERMT2Qrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10741 /* vpermt2q */, X86::VPERMT2Qrrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10741 /* vpermt2q */, X86::VPERMT2Qrmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 10750 /* vpextrb */, X86::VPEXTRBrr, Convert__GR32orGR641_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_GR32orGR64 }, },
  { 10750 /* vpextrb */, X86::VPEXTRBmr, Convert__Mem85_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_Mem8 }, },
  { 10758 /* vpextrd */, X86::VPEXTRDrr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_GR32 }, },
  { 10758 /* vpextrd */, X86::VPEXTRDmr, Convert__Mem325_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_Mem32 }, },
  { 10766 /* vpextrq */, X86::VPEXTRQrr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_GR64 }, },
  { 10766 /* vpextrq */, X86::VPEXTRQmr, Convert__Mem645_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_Mem64 }, },
  { 10774 /* vpextrw */, X86::VPEXTRWri, Convert__GR32orGR641_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_GR32orGR64 }, },
  { 10774 /* vpextrw */, X86::VPEXTRWmr, Convert__Mem165_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_Mem16 }, },
  { 10782 /* vpgatherdd */, X86::VPGATHERDDrm, Convert__Reg1_2__Reg1_0__Tie0__MemVX325_1__Tie1, 0, { MCK_FR32, MCK_MemVX32, MCK_FR32 }, },
  { 10782 /* vpgatherdd */, X86::VPGATHERDDYrm, Convert__Reg1_2__Reg1_0__Tie0__MemVY325_1__Tie1, 0, { MCK_VR256, MCK_MemVY32, MCK_VR256 }, },
  { 10782 /* vpgatherdd */, X86::VPGATHERDDZrm, Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ325_0, Feature_HasAVX512, { MCK_MemVZ32, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10793 /* vpgatherdq */, X86::VPGATHERDQrm, Convert__Reg1_2__Reg1_0__Tie0__MemVX645_1__Tie1, 0, { MCK_FR32, MCK_MemVX64, MCK_FR32 }, },
  { 10793 /* vpgatherdq */, X86::VPGATHERDQYrm, Convert__Reg1_2__Reg1_0__Tie0__MemVX645_1__Tie1, 0, { MCK_VR256, MCK_MemVX64, MCK_VR256 }, },
  { 10793 /* vpgatherdq */, X86::VPGATHERDQZrm, Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVY645_0, Feature_HasAVX512, { MCK_MemVY64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10804 /* vpgatherqd */, X86::VPGATHERQDrm, Convert__Reg1_2__Reg1_0__Tie0__MemVX325_1__Tie1, 0, { MCK_FR32, MCK_MemVX32, MCK_FR32 }, },
  { 10804 /* vpgatherqd */, X86::VPGATHERQDYrm, Convert__Reg1_2__Reg1_0__Tie0__MemVY325_1__Tie1, 0, { MCK_FR32, MCK_MemVY32, MCK_FR32 }, },
  { 10804 /* vpgatherqd */, X86::VPGATHERQDZrm, Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ645_0, Feature_HasAVX512, { MCK_MemVZ64, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10815 /* vpgatherqq */, X86::VPGATHERQQrm, Convert__Reg1_2__Reg1_0__Tie0__MemVX645_1__Tie1, 0, { MCK_FR32, MCK_MemVX64, MCK_FR32 }, },
  { 10815 /* vpgatherqq */, X86::VPGATHERQQYrm, Convert__Reg1_2__Reg1_0__Tie0__MemVY645_1__Tie1, 0, { MCK_VR256, MCK_MemVY64, MCK_VR256 }, },
  { 10815 /* vpgatherqq */, X86::VPGATHERQQZrm, Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ645_0, Feature_HasAVX512, { MCK_MemVZ64, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 10826 /* vphaddbd */, X86::VPHADDBDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10826 /* vphaddbd */, X86::VPHADDBDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10835 /* vphaddbq */, X86::VPHADDBQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10835 /* vphaddbq */, X86::VPHADDBQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10844 /* vphaddbw */, X86::VPHADDBWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10844 /* vphaddbw */, X86::VPHADDBWrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10853 /* vphaddd */, X86::VPHADDDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10853 /* vphaddd */, X86::VPHADDDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10853 /* vphaddd */, X86::VPHADDDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10853 /* vphaddd */, X86::VPHADDDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10861 /* vphadddq */, X86::VPHADDDQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10861 /* vphadddq */, X86::VPHADDDQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10870 /* vphaddsw */, X86::VPHADDSWrr128, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10870 /* vphaddsw */, X86::VPHADDSWrr256, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10870 /* vphaddsw */, X86::VPHADDSWrm128, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10870 /* vphaddsw */, X86::VPHADDSWrm256, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10879 /* vphaddubd */, X86::VPHADDUBDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10879 /* vphaddubd */, X86::VPHADDUBDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10889 /* vphaddubq */, X86::VPHADDUBQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10889 /* vphaddubq */, X86::VPHADDUBQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10899 /* vphaddubw */, X86::VPHADDUBWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10899 /* vphaddubw */, X86::VPHADDUBWrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10909 /* vphaddudq */, X86::VPHADDUDQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10909 /* vphaddudq */, X86::VPHADDUDQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10919 /* vphadduwd */, X86::VPHADDUWDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10919 /* vphadduwd */, X86::VPHADDUWDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10929 /* vphadduwq */, X86::VPHADDUWQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10929 /* vphadduwq */, X86::VPHADDUWQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10939 /* vphaddw */, X86::VPHADDWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10939 /* vphaddw */, X86::VPHADDWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10939 /* vphaddw */, X86::VPHADDWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10939 /* vphaddw */, X86::VPHADDWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10947 /* vphaddwd */, X86::VPHADDWDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10947 /* vphaddwd */, X86::VPHADDWDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10956 /* vphaddwq */, X86::VPHADDWQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10956 /* vphaddwq */, X86::VPHADDWQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10965 /* vphminposuw */, X86::VPHMINPOSUWrr128, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10965 /* vphminposuw */, X86::VPHMINPOSUWrm128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10977 /* vphsubbw */, X86::VPHSUBBWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10977 /* vphsubbw */, X86::VPHSUBBWrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 10986 /* vphsubd */, X86::VPHSUBDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 10986 /* vphsubd */, X86::VPHSUBDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 10986 /* vphsubd */, X86::VPHSUBDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 10986 /* vphsubd */, X86::VPHSUBDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 10994 /* vphsubdq */, X86::VPHSUBDQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 10994 /* vphsubdq */, X86::VPHSUBDQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 11003 /* vphsubsw */, X86::VPHSUBSWrr128, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11003 /* vphsubsw */, X86::VPHSUBSWrr256, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11003 /* vphsubsw */, X86::VPHSUBSWrm128, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11003 /* vphsubsw */, X86::VPHSUBSWrm256, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11012 /* vphsubw */, X86::VPHSUBWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11012 /* vphsubw */, X86::VPHSUBWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11012 /* vphsubw */, X86::VPHSUBWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11012 /* vphsubw */, X86::VPHSUBWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11020 /* vphsubwd */, X86::VPHSUBWDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11020 /* vphsubwd */, X86::VPHSUBWDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 11029 /* vpinsrb */, X86::VPINSRBrr, Convert__Reg1_3__Reg1_2__GR32orGR641_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32orGR64, MCK_FR32, MCK_FR32 }, },
  { 11029 /* vpinsrb */, X86::VPINSRBrm, Convert__Reg1_3__Reg1_2__Mem85_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem8, MCK_FR32, MCK_FR32 }, },
  { 11037 /* vpinsrd */, X86::VPINSRDrr, Convert__Reg1_3__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32, MCK_FR32, MCK_FR32 }, },
  { 11037 /* vpinsrd */, X86::VPINSRDrm, Convert__Reg1_3__Reg1_2__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 11045 /* vpinsrq */, X86::VPINSRQrr, Convert__Reg1_3__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR64, MCK_FR32, MCK_FR32 }, },
  { 11045 /* vpinsrq */, X86::VPINSRQrm, Convert__Reg1_3__Reg1_2__Mem645_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 11053 /* vpinsrw */, X86::VPINSRWrri, Convert__Reg1_3__Reg1_2__GR32orGR641_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32orGR64, MCK_FR32, MCK_FR32 }, },
  { 11053 /* vpinsrw */, X86::VPINSRWrmi, Convert__Reg1_3__Reg1_2__Mem165_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem16, MCK_FR32, MCK_FR32 }, },
  { 11061 /* vplzcntd */, X86::VPLZCNTDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 11061 /* vplzcntd */, X86::VPLZCNTDrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 11061 /* vplzcntd */, X86::VPLZCNTDrmb, Convert__Reg1_2__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512 }, },
  { 11061 /* vplzcntd */, X86::VPLZCNTDrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11061 /* vplzcntd */, X86::VPLZCNTDrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11061 /* vplzcntd */, X86::VPLZCNTDrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11061 /* vplzcntd */, X86::VPLZCNTDrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11061 /* vplzcntd */, X86::VPLZCNTDrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11061 /* vplzcntd */, X86::VPLZCNTDrmbkz, Convert__Reg1_2__Reg1_4__Mem325_0, 0, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11070 /* vplzcntq */, X86::VPLZCNTQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 11070 /* vplzcntq */, X86::VPLZCNTQrm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 11070 /* vplzcntq */, X86::VPLZCNTQrmb, Convert__Reg1_2__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512 }, },
  { 11070 /* vplzcntq */, X86::VPLZCNTQrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11070 /* vplzcntq */, X86::VPLZCNTQrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11070 /* vplzcntq */, X86::VPLZCNTQrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11070 /* vplzcntq */, X86::VPLZCNTQrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11070 /* vplzcntq */, X86::VPLZCNTQrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11070 /* vplzcntq */, X86::VPLZCNTQrmbkz, Convert__Reg1_2__Reg1_4__Mem645_0, 0, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11079 /* vpmacsdd */, X86::VPMACSDDrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11079 /* vpmacsdd */, X86::VPMACSDDrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11088 /* vpmacsdqh */, X86::VPMACSDQHrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11088 /* vpmacsdqh */, X86::VPMACSDQHrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11098 /* vpmacsdql */, X86::VPMACSDQLrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11098 /* vpmacsdql */, X86::VPMACSDQLrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11108 /* vpmacssdd */, X86::VPMACSSDDrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11108 /* vpmacssdd */, X86::VPMACSSDDrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11118 /* vpmacssdqh */, X86::VPMACSSDQHrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11118 /* vpmacssdqh */, X86::VPMACSSDQHrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11129 /* vpmacssdql */, X86::VPMACSSDQLrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11129 /* vpmacssdql */, X86::VPMACSSDQLrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11140 /* vpmacsswd */, X86::VPMACSSWDrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11140 /* vpmacsswd */, X86::VPMACSSWDrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11150 /* vpmacssww */, X86::VPMACSSWWrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11150 /* vpmacssww */, X86::VPMACSSWWrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11160 /* vpmacswd */, X86::VPMACSWDrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11160 /* vpmacswd */, X86::VPMACSWDrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11169 /* vpmacsww */, X86::VPMACSWWrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11169 /* vpmacsww */, X86::VPMACSWWrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11178 /* vpmadcsswd */, X86::VPMADCSSWDrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11178 /* vpmadcsswd */, X86::VPMADCSSWDrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11189 /* vpmadcswd */, X86::VPMADCSWDrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11189 /* vpmadcswd */, X86::VPMADCSWDrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11199 /* vpmaddubsw */, X86::VPMADDUBSWrr128, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11199 /* vpmaddubsw */, X86::VPMADDUBSWrr256, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11199 /* vpmaddubsw */, X86::VPMADDUBSWrm128, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11199 /* vpmaddubsw */, X86::VPMADDUBSWrm256, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11210 /* vpmaddwd */, X86::VPMADDWDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11210 /* vpmaddwd */, X86::VPMADDWDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11210 /* vpmaddwd */, X86::VPMADDWDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11210 /* vpmaddwd */, X86::VPMADDWDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11219 /* vpmaskmovd */, X86::VPMASKMOVDmr, Convert__Mem1285_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_Mem128 }, },
  { 11219 /* vpmaskmovd */, X86::VPMASKMOVDYmr, Convert__Mem2565_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_Mem256 }, },
  { 11219 /* vpmaskmovd */, X86::VPMASKMOVDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11219 /* vpmaskmovd */, X86::VPMASKMOVDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11230 /* vpmaskmovq */, X86::VPMASKMOVQmr, Convert__Mem1285_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_Mem128 }, },
  { 11230 /* vpmaskmovq */, X86::VPMASKMOVQYmr, Convert__Mem2565_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_Mem256 }, },
  { 11230 /* vpmaskmovq */, X86::VPMASKMOVQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11230 /* vpmaskmovq */, X86::VPMASKMOVQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11241 /* vpmaxsb */, X86::VPMAXSBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11241 /* vpmaxsb */, X86::VPMAXSBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11241 /* vpmaxsb */, X86::VPMAXSBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11241 /* vpmaxsb */, X86::VPMAXSBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11249 /* vpmaxsd */, X86::VPMAXSDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11257 /* vpmaxsq */, X86::VPMAXSQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11257 /* vpmaxsq */, X86::VPMAXSQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11257 /* vpmaxsq */, X86::VPMAXSQZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 11257 /* vpmaxsq */, X86::VPMAXSQZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11257 /* vpmaxsq */, X86::VPMAXSQZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11257 /* vpmaxsq */, X86::VPMAXSQZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11257 /* vpmaxsq */, X86::VPMAXSQZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11257 /* vpmaxsq */, X86::VPMAXSQZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11257 /* vpmaxsq */, X86::VPMAXSQZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11265 /* vpmaxsw */, X86::VPMAXSWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11265 /* vpmaxsw */, X86::VPMAXSWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11265 /* vpmaxsw */, X86::VPMAXSWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11265 /* vpmaxsw */, X86::VPMAXSWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11273 /* vpmaxub */, X86::VPMAXUBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11273 /* vpmaxub */, X86::VPMAXUBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11273 /* vpmaxub */, X86::VPMAXUBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11273 /* vpmaxub */, X86::VPMAXUBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11281 /* vpmaxud */, X86::VPMAXUDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11289 /* vpmaxuq */, X86::VPMAXUQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11289 /* vpmaxuq */, X86::VPMAXUQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11289 /* vpmaxuq */, X86::VPMAXUQZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 11289 /* vpmaxuq */, X86::VPMAXUQZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11289 /* vpmaxuq */, X86::VPMAXUQZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11289 /* vpmaxuq */, X86::VPMAXUQZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11289 /* vpmaxuq */, X86::VPMAXUQZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11289 /* vpmaxuq */, X86::VPMAXUQZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11289 /* vpmaxuq */, X86::VPMAXUQZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11297 /* vpmaxuw */, X86::VPMAXUWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11297 /* vpmaxuw */, X86::VPMAXUWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11297 /* vpmaxuw */, X86::VPMAXUWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11297 /* vpmaxuw */, X86::VPMAXUWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11305 /* vpminsb */, X86::VPMINSBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11305 /* vpminsb */, X86::VPMINSBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11305 /* vpminsb */, X86::VPMINSBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11305 /* vpminsb */, X86::VPMINSBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11313 /* vpminsd */, X86::VPMINSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11313 /* vpminsd */, X86::VPMINSDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11313 /* vpminsd */, X86::VPMINSDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11313 /* vpminsd */, X86::VPMINSDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11313 /* vpminsd */, X86::VPMINSDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11313 /* vpminsd */, X86::VPMINSDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11313 /* vpminsd */, X86::VPMINSDZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 11313 /* vpminsd */, X86::VPMINSDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11313 /* vpminsd */, X86::VPMINSDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11313 /* vpminsd */, X86::VPMINSDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11313 /* vpminsd */, X86::VPMINSDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11313 /* vpminsd */, X86::VPMINSDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11313 /* vpminsd */, X86::VPMINSDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11321 /* vpminsq */, X86::VPMINSQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11321 /* vpminsq */, X86::VPMINSQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11321 /* vpminsq */, X86::VPMINSQZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 11321 /* vpminsq */, X86::VPMINSQZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11321 /* vpminsq */, X86::VPMINSQZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11321 /* vpminsq */, X86::VPMINSQZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11321 /* vpminsq */, X86::VPMINSQZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11321 /* vpminsq */, X86::VPMINSQZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11321 /* vpminsq */, X86::VPMINSQZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11329 /* vpminsw */, X86::VPMINSWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11329 /* vpminsw */, X86::VPMINSWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11329 /* vpminsw */, X86::VPMINSWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11329 /* vpminsw */, X86::VPMINSWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11337 /* vpminub */, X86::VPMINUBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11337 /* vpminub */, X86::VPMINUBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11337 /* vpminub */, X86::VPMINUBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11337 /* vpminub */, X86::VPMINUBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11345 /* vpminud */, X86::VPMINUDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11345 /* vpminud */, X86::VPMINUDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11345 /* vpminud */, X86::VPMINUDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11345 /* vpminud */, X86::VPMINUDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11345 /* vpminud */, X86::VPMINUDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11345 /* vpminud */, X86::VPMINUDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11345 /* vpminud */, X86::VPMINUDZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 11345 /* vpminud */, X86::VPMINUDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11345 /* vpminud */, X86::VPMINUDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11345 /* vpminud */, X86::VPMINUDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11345 /* vpminud */, X86::VPMINUDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11345 /* vpminud */, X86::VPMINUDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11345 /* vpminud */, X86::VPMINUDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11353 /* vpminuq */, X86::VPMINUQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11353 /* vpminuq */, X86::VPMINUQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11353 /* vpminuq */, X86::VPMINUQZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 11353 /* vpminuq */, X86::VPMINUQZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11353 /* vpminuq */, X86::VPMINUQZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11353 /* vpminuq */, X86::VPMINUQZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11353 /* vpminuq */, X86::VPMINUQZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11353 /* vpminuq */, X86::VPMINUQZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11353 /* vpminuq */, X86::VPMINUQZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11361 /* vpminuw */, X86::VPMINUWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11361 /* vpminuw */, X86::VPMINUWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11361 /* vpminuw */, X86::VPMINUWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11361 /* vpminuw */, X86::VPMINUWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11369 /* vpmovdb */, X86::VPMOVDBrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X }, },
  { 11369 /* vpmovdb */, X86::VPMOVDBmr, Convert__Mem1285_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128 }, },
  { 11369 /* vpmovdb */, X86::VPMOVDBrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11369 /* vpmovdb */, X86::VPMOVDBmrk, Convert__Mem1285_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11369 /* vpmovdb */, X86::VPMOVDBrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11377 /* vpmovdw */, X86::VPMOVDWrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 11377 /* vpmovdw */, X86::VPMOVDWmr, Convert__Mem2565_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem256 }, },
  { 11377 /* vpmovdw */, X86::VPMOVDWrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11377 /* vpmovdw */, X86::VPMOVDWmrk, Convert__Mem2565_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11377 /* vpmovdw */, X86::VPMOVDWrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11385 /* vpmovmskb */, X86::VPMOVMSKBrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_FR32, MCK_GR32orGR64 }, },
  { 11385 /* vpmovmskb */, X86::VPMOVMSKBYrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_VR256, MCK_GR32orGR64 }, },
  { 11395 /* vpmovqb */, X86::VPMOVQBrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X }, },
  { 11395 /* vpmovqb */, X86::VPMOVQBmr, Convert__Mem1285_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128 }, },
  { 11395 /* vpmovqb */, X86::VPMOVQBrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11395 /* vpmovqb */, X86::VPMOVQBmrk, Convert__Mem1285_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11395 /* vpmovqb */, X86::VPMOVQBrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11403 /* vpmovqd */, X86::VPMOVQDrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 11403 /* vpmovqd */, X86::VPMOVQDmr, Convert__Mem2565_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem256 }, },
  { 11403 /* vpmovqd */, X86::VPMOVQDrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11403 /* vpmovqd */, X86::VPMOVQDmrk, Convert__Mem2565_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11403 /* vpmovqd */, X86::VPMOVQDrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11411 /* vpmovqw */, X86::VPMOVQWrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X }, },
  { 11411 /* vpmovqw */, X86::VPMOVQWmr, Convert__Mem1285_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128 }, },
  { 11411 /* vpmovqw */, X86::VPMOVQWrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11411 /* vpmovqw */, X86::VPMOVQWmrk, Convert__Mem1285_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11411 /* vpmovqw */, X86::VPMOVQWrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11419 /* vpmovsdb */, X86::VPMOVSDBrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X }, },
  { 11419 /* vpmovsdb */, X86::VPMOVSDBmr, Convert__Mem1285_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128 }, },
  { 11419 /* vpmovsdb */, X86::VPMOVSDBrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11419 /* vpmovsdb */, X86::VPMOVSDBmrk, Convert__Mem1285_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11419 /* vpmovsdb */, X86::VPMOVSDBrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11428 /* vpmovsdw */, X86::VPMOVSDWrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 11428 /* vpmovsdw */, X86::VPMOVSDWmr, Convert__Mem2565_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem256 }, },
  { 11428 /* vpmovsdw */, X86::VPMOVSDWrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11428 /* vpmovsdw */, X86::VPMOVSDWmrk, Convert__Mem2565_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11428 /* vpmovsdw */, X86::VPMOVSDWrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11437 /* vpmovsqb */, X86::VPMOVSQBrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X }, },
  { 11437 /* vpmovsqb */, X86::VPMOVSQBmr, Convert__Mem1285_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128 }, },
  { 11437 /* vpmovsqb */, X86::VPMOVSQBrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11437 /* vpmovsqb */, X86::VPMOVSQBmrk, Convert__Mem1285_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11437 /* vpmovsqb */, X86::VPMOVSQBrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11446 /* vpmovsqd */, X86::VPMOVSQDrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 11446 /* vpmovsqd */, X86::VPMOVSQDmr, Convert__Mem2565_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem256 }, },
  { 11446 /* vpmovsqd */, X86::VPMOVSQDrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11446 /* vpmovsqd */, X86::VPMOVSQDmrk, Convert__Mem2565_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11446 /* vpmovsqd */, X86::VPMOVSQDrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11455 /* vpmovsqw */, X86::VPMOVSQWrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X }, },
  { 11455 /* vpmovsqw */, X86::VPMOVSQWmr, Convert__Mem1285_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128 }, },
  { 11455 /* vpmovsqw */, X86::VPMOVSQWrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11455 /* vpmovsqw */, X86::VPMOVSQWmrk, Convert__Mem1285_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11455 /* vpmovsqw */, X86::VPMOVSQWrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11464 /* vpmovsxbd */, X86::VPMOVSXBDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11464 /* vpmovsxbd */, X86::VPMOVSXBDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 11464 /* vpmovsxbd */, X86::VPMOVSXBDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512 }, },
  { 11464 /* vpmovsxbd */, X86::VPMOVSXBDZrm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512 }, },
  { 11464 /* vpmovsxbd */, X86::VPMOVSXBDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 11464 /* vpmovsxbd */, X86::VPMOVSXBDYrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR256 }, },
  { 11464 /* vpmovsxbd */, X86::VPMOVSXBDZrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11464 /* vpmovsxbd */, X86::VPMOVSXBDZrmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11464 /* vpmovsxbd */, X86::VPMOVSXBDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11464 /* vpmovsxbd */, X86::VPMOVSXBDZrmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11474 /* vpmovsxbq */, X86::VPMOVSXBQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11474 /* vpmovsxbq */, X86::VPMOVSXBQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 11474 /* vpmovsxbq */, X86::VPMOVSXBQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512 }, },
  { 11474 /* vpmovsxbq */, X86::VPMOVSXBQZrm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512 }, },
  { 11474 /* vpmovsxbq */, X86::VPMOVSXBQrm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_FR32 }, },
  { 11474 /* vpmovsxbq */, X86::VPMOVSXBQYrm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_VR256 }, },
  { 11474 /* vpmovsxbq */, X86::VPMOVSXBQZrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11474 /* vpmovsxbq */, X86::VPMOVSXBQZrmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11474 /* vpmovsxbq */, X86::VPMOVSXBQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11474 /* vpmovsxbq */, X86::VPMOVSXBQZrmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11484 /* vpmovsxbw */, X86::VPMOVSXBWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11484 /* vpmovsxbw */, X86::VPMOVSXBWYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 11484 /* vpmovsxbw */, X86::VPMOVSXBWYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 11484 /* vpmovsxbw */, X86::VPMOVSXBWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 11494 /* vpmovsxdq */, X86::VPMOVSXDQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11494 /* vpmovsxdq */, X86::VPMOVSXDQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 11494 /* vpmovsxdq */, X86::VPMOVSXDQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512 }, },
  { 11494 /* vpmovsxdq */, X86::VPMOVSXDQYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 11494 /* vpmovsxdq */, X86::VPMOVSXDQZrm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 11494 /* vpmovsxdq */, X86::VPMOVSXDQrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 11494 /* vpmovsxdq */, X86::VPMOVSXDQZrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11494 /* vpmovsxdq */, X86::VPMOVSXDQZrmk, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11494 /* vpmovsxdq */, X86::VPMOVSXDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11494 /* vpmovsxdq */, X86::VPMOVSXDQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11504 /* vpmovsxwd */, X86::VPMOVSXWDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11504 /* vpmovsxwd */, X86::VPMOVSXWDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 11504 /* vpmovsxwd */, X86::VPMOVSXWDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512 }, },
  { 11504 /* vpmovsxwd */, X86::VPMOVSXWDYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 11504 /* vpmovsxwd */, X86::VPMOVSXWDZrm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 11504 /* vpmovsxwd */, X86::VPMOVSXWDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 11504 /* vpmovsxwd */, X86::VPMOVSXWDZrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11504 /* vpmovsxwd */, X86::VPMOVSXWDZrmk, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11504 /* vpmovsxwd */, X86::VPMOVSXWDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11504 /* vpmovsxwd */, X86::VPMOVSXWDZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11514 /* vpmovsxwq */, X86::VPMOVSXWQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11514 /* vpmovsxwq */, X86::VPMOVSXWQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 11514 /* vpmovsxwq */, X86::VPMOVSXWQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512 }, },
  { 11514 /* vpmovsxwq */, X86::VPMOVSXWQZrm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512 }, },
  { 11514 /* vpmovsxwq */, X86::VPMOVSXWQrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 11514 /* vpmovsxwq */, X86::VPMOVSXWQYrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR256 }, },
  { 11514 /* vpmovsxwq */, X86::VPMOVSXWQZrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11514 /* vpmovsxwq */, X86::VPMOVSXWQZrmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11514 /* vpmovsxwq */, X86::VPMOVSXWQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11514 /* vpmovsxwq */, X86::VPMOVSXWQZrmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11524 /* vpmovusdb */, X86::VPMOVUSDBrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X }, },
  { 11524 /* vpmovusdb */, X86::VPMOVUSDBmr, Convert__Mem1285_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128 }, },
  { 11524 /* vpmovusdb */, X86::VPMOVUSDBrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11524 /* vpmovusdb */, X86::VPMOVUSDBmrk, Convert__Mem1285_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11524 /* vpmovusdb */, X86::VPMOVUSDBrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11534 /* vpmovusdw */, X86::VPMOVUSDWrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 11534 /* vpmovusdw */, X86::VPMOVUSDWmr, Convert__Mem2565_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem256 }, },
  { 11534 /* vpmovusdw */, X86::VPMOVUSDWrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11534 /* vpmovusdw */, X86::VPMOVUSDWmrk, Convert__Mem2565_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11534 /* vpmovusdw */, X86::VPMOVUSDWrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11544 /* vpmovusqb */, X86::VPMOVUSQBrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X }, },
  { 11544 /* vpmovusqb */, X86::VPMOVUSQBmr, Convert__Mem1285_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128 }, },
  { 11544 /* vpmovusqb */, X86::VPMOVUSQBrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11544 /* vpmovusqb */, X86::VPMOVUSQBmrk, Convert__Mem1285_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11544 /* vpmovusqb */, X86::VPMOVUSQBrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11554 /* vpmovusqd */, X86::VPMOVUSQDrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 11554 /* vpmovusqd */, X86::VPMOVUSQDmr, Convert__Mem2565_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem256 }, },
  { 11554 /* vpmovusqd */, X86::VPMOVUSQDrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11554 /* vpmovusqd */, X86::VPMOVUSQDmrk, Convert__Mem2565_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem256, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11554 /* vpmovusqd */, X86::VPMOVUSQDrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11564 /* vpmovusqw */, X86::VPMOVUSQWrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X }, },
  { 11564 /* vpmovusqw */, X86::VPMOVUSQWmr, Convert__Mem1285_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128 }, },
  { 11564 /* vpmovusqw */, X86::VPMOVUSQWrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11564 /* vpmovusqw */, X86::VPMOVUSQWmrk, Convert__Mem1285_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem128, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11564 /* vpmovusqw */, X86::VPMOVUSQWrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11574 /* vpmovzxbd */, X86::VPMOVZXBDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11574 /* vpmovzxbd */, X86::VPMOVZXBDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 11574 /* vpmovzxbd */, X86::VPMOVZXBDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512 }, },
  { 11574 /* vpmovzxbd */, X86::VPMOVZXBDZrm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512 }, },
  { 11574 /* vpmovzxbd */, X86::VPMOVZXBDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 11574 /* vpmovzxbd */, X86::VPMOVZXBDYrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR256 }, },
  { 11574 /* vpmovzxbd */, X86::VPMOVZXBDZrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11574 /* vpmovzxbd */, X86::VPMOVZXBDZrmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11574 /* vpmovzxbd */, X86::VPMOVZXBDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11574 /* vpmovzxbd */, X86::VPMOVZXBDZrmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11584 /* vpmovzxbq */, X86::VPMOVZXBQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11584 /* vpmovzxbq */, X86::VPMOVZXBQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 11584 /* vpmovzxbq */, X86::VPMOVZXBQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512 }, },
  { 11584 /* vpmovzxbq */, X86::VPMOVZXBQZrm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512 }, },
  { 11584 /* vpmovzxbq */, X86::VPMOVZXBQrm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_FR32 }, },
  { 11584 /* vpmovzxbq */, X86::VPMOVZXBQYrm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_VR256 }, },
  { 11584 /* vpmovzxbq */, X86::VPMOVZXBQZrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11584 /* vpmovzxbq */, X86::VPMOVZXBQZrmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11584 /* vpmovzxbq */, X86::VPMOVZXBQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11584 /* vpmovzxbq */, X86::VPMOVZXBQZrmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11594 /* vpmovzxbw */, X86::VPMOVZXBWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11594 /* vpmovzxbw */, X86::VPMOVZXBWYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 11594 /* vpmovzxbw */, X86::VPMOVZXBWYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 11594 /* vpmovzxbw */, X86::VPMOVZXBWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 11604 /* vpmovzxdq */, X86::VPMOVZXDQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11604 /* vpmovzxdq */, X86::VPMOVZXDQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 11604 /* vpmovzxdq */, X86::VPMOVZXDQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512 }, },
  { 11604 /* vpmovzxdq */, X86::VPMOVZXDQYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 11604 /* vpmovzxdq */, X86::VPMOVZXDQZrm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 11604 /* vpmovzxdq */, X86::VPMOVZXDQrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 11604 /* vpmovzxdq */, X86::VPMOVZXDQZrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11604 /* vpmovzxdq */, X86::VPMOVZXDQZrmk, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11604 /* vpmovzxdq */, X86::VPMOVZXDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11604 /* vpmovzxdq */, X86::VPMOVZXDQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11614 /* vpmovzxwd */, X86::VPMOVZXWDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11614 /* vpmovzxwd */, X86::VPMOVZXWDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 11614 /* vpmovzxwd */, X86::VPMOVZXWDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512 }, },
  { 11614 /* vpmovzxwd */, X86::VPMOVZXWDYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 11614 /* vpmovzxwd */, X86::VPMOVZXWDZrm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 11614 /* vpmovzxwd */, X86::VPMOVZXWDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 11614 /* vpmovzxwd */, X86::VPMOVZXWDZrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11614 /* vpmovzxwd */, X86::VPMOVZXWDZrmk, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11614 /* vpmovzxwd */, X86::VPMOVZXWDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11614 /* vpmovzxwd */, X86::VPMOVZXWDZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11624 /* vpmovzxwq */, X86::VPMOVZXWQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 11624 /* vpmovzxwq */, X86::VPMOVZXWQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 11624 /* vpmovzxwq */, X86::VPMOVZXWQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512 }, },
  { 11624 /* vpmovzxwq */, X86::VPMOVZXWQZrm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512 }, },
  { 11624 /* vpmovzxwq */, X86::VPMOVZXWQrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 11624 /* vpmovzxwq */, X86::VPMOVZXWQYrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR256 }, },
  { 11624 /* vpmovzxwq */, X86::VPMOVZXWQZrrk, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11624 /* vpmovzxwq */, X86::VPMOVZXWQZrmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11624 /* vpmovzxwq */, X86::VPMOVZXWQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11624 /* vpmovzxwq */, X86::VPMOVZXWQZrmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11634 /* vpmuldq */, X86::VPMULDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11634 /* vpmuldq */, X86::VPMULDQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11634 /* vpmuldq */, X86::VPMULDQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11634 /* vpmuldq */, X86::VPMULDQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11634 /* vpmuldq */, X86::VPMULDQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11634 /* vpmuldq */, X86::VPMULDQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11634 /* vpmuldq */, X86::VPMULDQZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 11634 /* vpmuldq */, X86::VPMULDQZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11634 /* vpmuldq */, X86::VPMULDQZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11634 /* vpmuldq */, X86::VPMULDQZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11634 /* vpmuldq */, X86::VPMULDQZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11634 /* vpmuldq */, X86::VPMULDQZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11634 /* vpmuldq */, X86::VPMULDQZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11642 /* vpmulhrsw */, X86::VPMULHRSWrr128, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11642 /* vpmulhrsw */, X86::VPMULHRSWrr256, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11642 /* vpmulhrsw */, X86::VPMULHRSWrm128, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11642 /* vpmulhrsw */, X86::VPMULHRSWrm256, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11652 /* vpmulhuw */, X86::VPMULHUWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11652 /* vpmulhuw */, X86::VPMULHUWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11652 /* vpmulhuw */, X86::VPMULHUWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11652 /* vpmulhuw */, X86::VPMULHUWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11661 /* vpmulhw */, X86::VPMULHWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11661 /* vpmulhw */, X86::VPMULHWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11661 /* vpmulhw */, X86::VPMULHWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11661 /* vpmulhw */, X86::VPMULHWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11669 /* vpmulld */, X86::VPMULLDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11669 /* vpmulld */, X86::VPMULLDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11669 /* vpmulld */, X86::VPMULLDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11669 /* vpmulld */, X86::VPMULLDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11669 /* vpmulld */, X86::VPMULLDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11669 /* vpmulld */, X86::VPMULLDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11669 /* vpmulld */, X86::VPMULLDZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 11669 /* vpmulld */, X86::VPMULLDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11669 /* vpmulld */, X86::VPMULLDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11669 /* vpmulld */, X86::VPMULLDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11669 /* vpmulld */, X86::VPMULLDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11669 /* vpmulld */, X86::VPMULLDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11669 /* vpmulld */, X86::VPMULLDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11677 /* vpmullw */, X86::VPMULLWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11677 /* vpmullw */, X86::VPMULLWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11677 /* vpmullw */, X86::VPMULLWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11677 /* vpmullw */, X86::VPMULLWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11685 /* vpmuludq */, X86::VPMULUDQZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11694 /* vpor */, X86::VPORrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11694 /* vpor */, X86::VPORYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11694 /* vpor */, X86::VPORrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11694 /* vpor */, X86::VPORYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11699 /* vpord */, X86::VPORDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11699 /* vpord */, X86::VPORDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11699 /* vpord */, X86::VPORDZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 11699 /* vpord */, X86::VPORDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11699 /* vpord */, X86::VPORDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11699 /* vpord */, X86::VPORDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11699 /* vpord */, X86::VPORDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11699 /* vpord */, X86::VPORDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11699 /* vpord */, X86::VPORDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11705 /* vporq */, X86::VPORQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11705 /* vporq */, X86::VPORQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11705 /* vporq */, X86::VPORQZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 11705 /* vporq */, X86::VPORQZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11705 /* vporq */, X86::VPORQZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11705 /* vporq */, X86::VPORQZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11705 /* vporq */, X86::VPORQZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11705 /* vporq */, X86::VPORQZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11705 /* vporq */, X86::VPORQZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 11711 /* vpperm */, X86::VPPERMrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11711 /* vpperm */, X86::VPPERMmr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11711 /* vpperm */, X86::VPPERMrm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11718 /* vprotb */, X86::VPROTBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11718 /* vprotb */, X86::VPROTBmr, Convert__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32 }, },
  { 11718 /* vprotb */, X86::VPROTBri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11718 /* vprotb */, X86::VPROTBmi, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 11718 /* vprotb */, X86::VPROTBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11725 /* vprotd */, X86::VPROTDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11725 /* vprotd */, X86::VPROTDmr, Convert__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32 }, },
  { 11725 /* vprotd */, X86::VPROTDri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11725 /* vprotd */, X86::VPROTDmi, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 11725 /* vprotd */, X86::VPROTDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11732 /* vprotq */, X86::VPROTQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11732 /* vprotq */, X86::VPROTQmr, Convert__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32 }, },
  { 11732 /* vprotq */, X86::VPROTQri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11732 /* vprotq */, X86::VPROTQmi, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 11732 /* vprotq */, X86::VPROTQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11739 /* vprotw */, X86::VPROTWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11739 /* vprotw */, X86::VPROTWmr, Convert__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32 }, },
  { 11739 /* vprotw */, X86::VPROTWri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11739 /* vprotw */, X86::VPROTWmi, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 11739 /* vprotw */, X86::VPROTWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11746 /* vpsadbw */, X86::VPSADBWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11746 /* vpsadbw */, X86::VPSADBWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11746 /* vpsadbw */, X86::VPSADBWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11746 /* vpsadbw */, X86::VPSADBWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11754 /* vpscatterdd */, X86::VPSCATTERDDZmr, Convert__Reg1_3__MemVZ325_1__Tie0__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_MemVZ32, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11766 /* vpscatterdq */, X86::VPSCATTERDQZmr, Convert__Reg1_3__MemVY645_1__Tie0__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_MemVY64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11778 /* vpscatterqd */, X86::VPSCATTERQDZmr, Convert__Reg1_3__MemVZ645_1__Tie0__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_MemVZ64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11790 /* vpscatterqq */, X86::VPSCATTERQQZmr, Convert__Reg1_3__MemVZ645_1__Tie0__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_MemVZ64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11802 /* vpshab */, X86::VPSHABrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11802 /* vpshab */, X86::VPSHABmr, Convert__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32 }, },
  { 11802 /* vpshab */, X86::VPSHABrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11809 /* vpshad */, X86::VPSHADrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11809 /* vpshad */, X86::VPSHADmr, Convert__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32 }, },
  { 11809 /* vpshad */, X86::VPSHADrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11816 /* vpshaq */, X86::VPSHAQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11816 /* vpshaq */, X86::VPSHAQmr, Convert__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32 }, },
  { 11816 /* vpshaq */, X86::VPSHAQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11823 /* vpshaw */, X86::VPSHAWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11823 /* vpshaw */, X86::VPSHAWmr, Convert__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32 }, },
  { 11823 /* vpshaw */, X86::VPSHAWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11830 /* vpshlb */, X86::VPSHLBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11830 /* vpshlb */, X86::VPSHLBmr, Convert__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32 }, },
  { 11830 /* vpshlb */, X86::VPSHLBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11837 /* vpshld */, X86::VPSHLDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11837 /* vpshld */, X86::VPSHLDmr, Convert__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32 }, },
  { 11837 /* vpshld */, X86::VPSHLDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11844 /* vpshlq */, X86::VPSHLQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11844 /* vpshlq */, X86::VPSHLQmr, Convert__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32 }, },
  { 11844 /* vpshlq */, X86::VPSHLQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11851 /* vpshlw */, X86::VPSHLWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11851 /* vpshlw */, X86::VPSHLWmr, Convert__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32 }, },
  { 11851 /* vpshlw */, X86::VPSHLWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11858 /* vpshufb */, X86::VPSHUFBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11858 /* vpshufb */, X86::VPSHUFBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11858 /* vpshufb */, X86::VPSHUFBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11858 /* vpshufb */, X86::VPSHUFBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11866 /* vpshufd */, X86::VPSHUFDri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11866 /* vpshufd */, X86::VPSHUFDYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 11866 /* vpshufd */, X86::VPSHUFDZri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 11866 /* vpshufd */, X86::VPSHUFDmi, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 11866 /* vpshufd */, X86::VPSHUFDYmi, Convert__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256 }, },
  { 11866 /* vpshufd */, X86::VPSHUFDZmi, Convert__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512 }, },
  { 11874 /* vpshufhw */, X86::VPSHUFHWri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11874 /* vpshufhw */, X86::VPSHUFHWYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 11874 /* vpshufhw */, X86::VPSHUFHWmi, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 11874 /* vpshufhw */, X86::VPSHUFHWYmi, Convert__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256 }, },
  { 11883 /* vpshuflw */, X86::VPSHUFLWri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11883 /* vpshuflw */, X86::VPSHUFLWYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 11883 /* vpshuflw */, X86::VPSHUFLWmi, Convert__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32 }, },
  { 11883 /* vpshuflw */, X86::VPSHUFLWYmi, Convert__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256 }, },
  { 11892 /* vpsignb */, X86::VPSIGNBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11892 /* vpsignb */, X86::VPSIGNBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11892 /* vpsignb */, X86::VPSIGNBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11892 /* vpsignb */, X86::VPSIGNBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11900 /* vpsignd */, X86::VPSIGNDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11900 /* vpsignd */, X86::VPSIGNDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11900 /* vpsignd */, X86::VPSIGNDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11900 /* vpsignd */, X86::VPSIGNDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11908 /* vpsignw */, X86::VPSIGNWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11908 /* vpsignw */, X86::VPSIGNWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11908 /* vpsignw */, X86::VPSIGNWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11908 /* vpsignw */, X86::VPSIGNWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11916 /* vpslld */, X86::VPSLLDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11916 /* vpslld */, X86::VPSLLDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256, MCK_VR256 }, },
  { 11916 /* vpslld */, X86::VPSLLDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK_VR512 }, },
  { 11916 /* vpslld */, X86::VPSLLDri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11916 /* vpslld */, X86::VPSLLDYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 11916 /* vpslld */, X86::VPSLLDZri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 11916 /* vpslld */, X86::VPSLLDZmi, Convert__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512 }, },
  { 11916 /* vpslld */, X86::VPSLLDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11916 /* vpslld */, X86::VPSLLDYrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256, MCK_VR256 }, },
  { 11916 /* vpslld */, X86::VPSLLDZrm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK_VR512 }, },
  { 11916 /* vpslld */, X86::VPSLLDZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11916 /* vpslld */, X86::VPSLLDZrik, Convert__Reg1_2__Reg1_4__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11916 /* vpslld */, X86::VPSLLDZmik, Convert__Reg1_2__Reg1_4__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11916 /* vpslld */, X86::VPSLLDZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11923 /* vpslldq */, X86::VPSLLDQri, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_FR32 }, },
  { 11923 /* vpslldq */, X86::VPSLLDQYri, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR256, MCK_VR256 }, },
  { 11931 /* vpsllq */, X86::VPSLLQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11931 /* vpsllq */, X86::VPSLLQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256, MCK_VR256 }, },
  { 11931 /* vpsllq */, X86::VPSLLQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK_VR512 }, },
  { 11931 /* vpsllq */, X86::VPSLLQri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11931 /* vpsllq */, X86::VPSLLQYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 11931 /* vpsllq */, X86::VPSLLQZri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 11931 /* vpsllq */, X86::VPSLLQZmi, Convert__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512 }, },
  { 11931 /* vpsllq */, X86::VPSLLQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11931 /* vpsllq */, X86::VPSLLQYrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256, MCK_VR256 }, },
  { 11931 /* vpsllq */, X86::VPSLLQZrm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK_VR512 }, },
  { 11931 /* vpsllq */, X86::VPSLLQZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11931 /* vpsllq */, X86::VPSLLQZrik, Convert__Reg1_2__Reg1_4__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11931 /* vpsllq */, X86::VPSLLQZmik, Convert__Reg1_2__Reg1_4__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11931 /* vpsllq */, X86::VPSLLQZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11938 /* vpsllvd */, X86::VPSLLVDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11938 /* vpsllvd */, X86::VPSLLVDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11938 /* vpsllvd */, X86::VPSLLVDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11938 /* vpsllvd */, X86::VPSLLVDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11938 /* vpsllvd */, X86::VPSLLVDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11938 /* vpsllvd */, X86::VPSLLVDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11946 /* vpsllvq */, X86::VPSLLVQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11946 /* vpsllvq */, X86::VPSLLVQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11946 /* vpsllvq */, X86::VPSLLVQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11946 /* vpsllvq */, X86::VPSLLVQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11946 /* vpsllvq */, X86::VPSLLVQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11946 /* vpsllvq */, X86::VPSLLVQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11954 /* vpsllw */, X86::VPSLLWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11954 /* vpsllw */, X86::VPSLLWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256, MCK_VR256 }, },
  { 11954 /* vpsllw */, X86::VPSLLWri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11954 /* vpsllw */, X86::VPSLLWYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 11954 /* vpsllw */, X86::VPSLLWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11954 /* vpsllw */, X86::VPSLLWYrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256, MCK_VR256 }, },
  { 11961 /* vpsrad */, X86::VPSRADrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11961 /* vpsrad */, X86::VPSRADYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256, MCK_VR256 }, },
  { 11961 /* vpsrad */, X86::VPSRADZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK_VR512 }, },
  { 11961 /* vpsrad */, X86::VPSRADri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11961 /* vpsrad */, X86::VPSRADYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 11961 /* vpsrad */, X86::VPSRADZri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 11961 /* vpsrad */, X86::VPSRADZmi, Convert__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512 }, },
  { 11961 /* vpsrad */, X86::VPSRADrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11961 /* vpsrad */, X86::VPSRADYrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256, MCK_VR256 }, },
  { 11961 /* vpsrad */, X86::VPSRADZrm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK_VR512 }, },
  { 11961 /* vpsrad */, X86::VPSRADZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11961 /* vpsrad */, X86::VPSRADZrik, Convert__Reg1_2__Reg1_4__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11961 /* vpsrad */, X86::VPSRADZmik, Convert__Reg1_2__Reg1_4__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11961 /* vpsrad */, X86::VPSRADZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11968 /* vpsraq */, X86::VPSRAQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK_VR512 }, },
  { 11968 /* vpsraq */, X86::VPSRAQZri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 11968 /* vpsraq */, X86::VPSRAQZmi, Convert__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512 }, },
  { 11968 /* vpsraq */, X86::VPSRAQZrm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK_VR512 }, },
  { 11968 /* vpsraq */, X86::VPSRAQZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11968 /* vpsraq */, X86::VPSRAQZrik, Convert__Reg1_2__Reg1_4__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11968 /* vpsraq */, X86::VPSRAQZmik, Convert__Reg1_2__Reg1_4__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11968 /* vpsraq */, X86::VPSRAQZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11975 /* vpsravd */, X86::VPSRAVDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11975 /* vpsravd */, X86::VPSRAVDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 11975 /* vpsravd */, X86::VPSRAVDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11975 /* vpsravd */, X86::VPSRAVDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11975 /* vpsravd */, X86::VPSRAVDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 11975 /* vpsravd */, X86::VPSRAVDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11983 /* vpsravq */, X86::VPSRAVQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 11983 /* vpsravq */, X86::VPSRAVQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 11991 /* vpsraw */, X86::VPSRAWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11991 /* vpsraw */, X86::VPSRAWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256, MCK_VR256 }, },
  { 11991 /* vpsraw */, X86::VPSRAWri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11991 /* vpsraw */, X86::VPSRAWYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 11991 /* vpsraw */, X86::VPSRAWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11991 /* vpsraw */, X86::VPSRAWYrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256, MCK_VR256 }, },
  { 11998 /* vpsrld */, X86::VPSRLDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 11998 /* vpsrld */, X86::VPSRLDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256, MCK_VR256 }, },
  { 11998 /* vpsrld */, X86::VPSRLDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK_VR512 }, },
  { 11998 /* vpsrld */, X86::VPSRLDri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 11998 /* vpsrld */, X86::VPSRLDYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 11998 /* vpsrld */, X86::VPSRLDZri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 11998 /* vpsrld */, X86::VPSRLDZmi, Convert__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512 }, },
  { 11998 /* vpsrld */, X86::VPSRLDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 11998 /* vpsrld */, X86::VPSRLDYrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256, MCK_VR256 }, },
  { 11998 /* vpsrld */, X86::VPSRLDZrm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK_VR512 }, },
  { 11998 /* vpsrld */, X86::VPSRLDZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11998 /* vpsrld */, X86::VPSRLDZrik, Convert__Reg1_2__Reg1_4__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11998 /* vpsrld */, X86::VPSRLDZmik, Convert__Reg1_2__Reg1_4__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 11998 /* vpsrld */, X86::VPSRLDZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12005 /* vpsrldq */, X86::VPSRLDQri, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_FR32 }, },
  { 12005 /* vpsrldq */, X86::VPSRLDQYri, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR256, MCK_VR256 }, },
  { 12013 /* vpsrlq */, X86::VPSRLQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12013 /* vpsrlq */, X86::VPSRLQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256, MCK_VR256 }, },
  { 12013 /* vpsrlq */, X86::VPSRLQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK_VR512 }, },
  { 12013 /* vpsrlq */, X86::VPSRLQri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 12013 /* vpsrlq */, X86::VPSRLQYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 12013 /* vpsrlq */, X86::VPSRLQZri, Convert__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512 }, },
  { 12013 /* vpsrlq */, X86::VPSRLQZmi, Convert__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512 }, },
  { 12013 /* vpsrlq */, X86::VPSRLQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12013 /* vpsrlq */, X86::VPSRLQYrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256, MCK_VR256 }, },
  { 12013 /* vpsrlq */, X86::VPSRLQZrm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK_VR512 }, },
  { 12013 /* vpsrlq */, X86::VPSRLQZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12013 /* vpsrlq */, X86::VPSRLQZrik, Convert__Reg1_2__Reg1_4__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12013 /* vpsrlq */, X86::VPSRLQZmik, Convert__Reg1_2__Reg1_4__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12013 /* vpsrlq */, X86::VPSRLQZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12020 /* vpsrlvd */, X86::VPSRLVDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12020 /* vpsrlvd */, X86::VPSRLVDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12020 /* vpsrlvd */, X86::VPSRLVDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12020 /* vpsrlvd */, X86::VPSRLVDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12020 /* vpsrlvd */, X86::VPSRLVDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12020 /* vpsrlvd */, X86::VPSRLVDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12028 /* vpsrlvq */, X86::VPSRLVQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12028 /* vpsrlvq */, X86::VPSRLVQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12028 /* vpsrlvq */, X86::VPSRLVQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12028 /* vpsrlvq */, X86::VPSRLVQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12028 /* vpsrlvq */, X86::VPSRLVQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12028 /* vpsrlvq */, X86::VPSRLVQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12036 /* vpsrlw */, X86::VPSRLWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12036 /* vpsrlw */, X86::VPSRLWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256, MCK_VR256 }, },
  { 12036 /* vpsrlw */, X86::VPSRLWri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32 }, },
  { 12036 /* vpsrlw */, X86::VPSRLWYri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256 }, },
  { 12036 /* vpsrlw */, X86::VPSRLWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12036 /* vpsrlw */, X86::VPSRLWYrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256, MCK_VR256 }, },
  { 12043 /* vpsubb */, X86::VPSUBBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12043 /* vpsubb */, X86::VPSUBBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12043 /* vpsubb */, X86::VPSUBBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12043 /* vpsubb */, X86::VPSUBBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12050 /* vpsubd */, X86::VPSUBDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12050 /* vpsubd */, X86::VPSUBDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12050 /* vpsubd */, X86::VPSUBDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12050 /* vpsubd */, X86::VPSUBDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12050 /* vpsubd */, X86::VPSUBDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12050 /* vpsubd */, X86::VPSUBDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12050 /* vpsubd */, X86::VPSUBDZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 12050 /* vpsubd */, X86::VPSUBDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12050 /* vpsubd */, X86::VPSUBDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12050 /* vpsubd */, X86::VPSUBDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12050 /* vpsubd */, X86::VPSUBDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12050 /* vpsubd */, X86::VPSUBDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12050 /* vpsubd */, X86::VPSUBDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12057 /* vpsubq */, X86::VPSUBQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12057 /* vpsubq */, X86::VPSUBQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12057 /* vpsubq */, X86::VPSUBQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12057 /* vpsubq */, X86::VPSUBQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12057 /* vpsubq */, X86::VPSUBQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12057 /* vpsubq */, X86::VPSUBQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12057 /* vpsubq */, X86::VPSUBQZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 12057 /* vpsubq */, X86::VPSUBQZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12057 /* vpsubq */, X86::VPSUBQZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12057 /* vpsubq */, X86::VPSUBQZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12057 /* vpsubq */, X86::VPSUBQZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12057 /* vpsubq */, X86::VPSUBQZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12057 /* vpsubq */, X86::VPSUBQZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12064 /* vpsubsb */, X86::VPSUBSBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12064 /* vpsubsb */, X86::VPSUBSBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12064 /* vpsubsb */, X86::VPSUBSBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12064 /* vpsubsb */, X86::VPSUBSBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12072 /* vpsubsw */, X86::VPSUBSWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12072 /* vpsubsw */, X86::VPSUBSWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12072 /* vpsubsw */, X86::VPSUBSWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12072 /* vpsubsw */, X86::VPSUBSWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12080 /* vpsubusb */, X86::VPSUBUSBrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12080 /* vpsubusb */, X86::VPSUBUSBYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12080 /* vpsubusb */, X86::VPSUBUSBrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12080 /* vpsubusb */, X86::VPSUBUSBYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12089 /* vpsubusw */, X86::VPSUBUSWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12089 /* vpsubusw */, X86::VPSUBUSWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12089 /* vpsubusw */, X86::VPSUBUSWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12089 /* vpsubusw */, X86::VPSUBUSWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12098 /* vpsubw */, X86::VPSUBWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12098 /* vpsubw */, X86::VPSUBWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12098 /* vpsubw */, X86::VPSUBWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12098 /* vpsubw */, X86::VPSUBWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12105 /* vptest */, X86::VPTESTrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 12105 /* vptest */, X86::VPTESTYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 12105 /* vptest */, X86::VPTESTrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 12105 /* vptest */, X86::VPTESTYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 12112 /* vptestmd */, X86::VPTESTMDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 12112 /* vptestmd */, X86::VPTESTMDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 12121 /* vptestmq */, X86::VPTESTMQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 12121 /* vptestmq */, X86::VPTESTMQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 12130 /* vptestnmd */, X86::VPTESTNMDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 12130 /* vptestnmd */, X86::VPTESTNMDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 12140 /* vptestnmq */, X86::VPTESTNMQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 12140 /* vptestnmq */, X86::VPTESTNMQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 12150 /* vpunpckhbw */, X86::VPUNPCKHBWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12150 /* vpunpckhbw */, X86::VPUNPCKHBWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12150 /* vpunpckhbw */, X86::VPUNPCKHBWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12150 /* vpunpckhbw */, X86::VPUNPCKHBWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12161 /* vpunpckhdq */, X86::VPUNPCKHDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12161 /* vpunpckhdq */, X86::VPUNPCKHDQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12161 /* vpunpckhdq */, X86::VPUNPCKHDQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12161 /* vpunpckhdq */, X86::VPUNPCKHDQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12161 /* vpunpckhdq */, X86::VPUNPCKHDQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12161 /* vpunpckhdq */, X86::VPUNPCKHDQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12172 /* vpunpckhqdq */, X86::VPUNPCKHQDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12172 /* vpunpckhqdq */, X86::VPUNPCKHQDQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12172 /* vpunpckhqdq */, X86::VPUNPCKHQDQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12172 /* vpunpckhqdq */, X86::VPUNPCKHQDQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12172 /* vpunpckhqdq */, X86::VPUNPCKHQDQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12172 /* vpunpckhqdq */, X86::VPUNPCKHQDQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12184 /* vpunpckhwd */, X86::VPUNPCKHWDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12184 /* vpunpckhwd */, X86::VPUNPCKHWDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12184 /* vpunpckhwd */, X86::VPUNPCKHWDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12184 /* vpunpckhwd */, X86::VPUNPCKHWDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12195 /* vpunpcklbw */, X86::VPUNPCKLBWrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12195 /* vpunpcklbw */, X86::VPUNPCKLBWYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12195 /* vpunpcklbw */, X86::VPUNPCKLBWrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12195 /* vpunpcklbw */, X86::VPUNPCKLBWYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12206 /* vpunpckldq */, X86::VPUNPCKLDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12206 /* vpunpckldq */, X86::VPUNPCKLDQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12206 /* vpunpckldq */, X86::VPUNPCKLDQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12206 /* vpunpckldq */, X86::VPUNPCKLDQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12206 /* vpunpckldq */, X86::VPUNPCKLDQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12206 /* vpunpckldq */, X86::VPUNPCKLDQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12217 /* vpunpcklqdq */, X86::VPUNPCKLQDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12217 /* vpunpcklqdq */, X86::VPUNPCKLQDQYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12217 /* vpunpcklqdq */, X86::VPUNPCKLQDQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12217 /* vpunpcklqdq */, X86::VPUNPCKLQDQrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12217 /* vpunpcklqdq */, X86::VPUNPCKLQDQYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12217 /* vpunpcklqdq */, X86::VPUNPCKLQDQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12229 /* vpunpcklwd */, X86::VPUNPCKLWDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12229 /* vpunpcklwd */, X86::VPUNPCKLWDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12229 /* vpunpcklwd */, X86::VPUNPCKLWDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12229 /* vpunpcklwd */, X86::VPUNPCKLWDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12240 /* vpxor */, X86::VPXORrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12240 /* vpxor */, X86::VPXORYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12240 /* vpxor */, X86::VPXORrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12240 /* vpxor */, X86::VPXORYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12246 /* vpxord */, X86::VPXORDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12246 /* vpxord */, X86::VPXORDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12246 /* vpxord */, X86::VPXORDZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 12246 /* vpxord */, X86::VPXORDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12246 /* vpxord */, X86::VPXORDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12246 /* vpxord */, X86::VPXORDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12246 /* vpxord */, X86::VPXORDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12246 /* vpxord */, X86::VPXORDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12246 /* vpxord */, X86::VPXORDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12253 /* vpxorq */, X86::VPXORQZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12253 /* vpxorq */, X86::VPXORQZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12253 /* vpxorq */, X86::VPXORQZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 12253 /* vpxorq */, X86::VPXORQZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12253 /* vpxorq */, X86::VPXORQZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12253 /* vpxorq */, X86::VPXORQZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12253 /* vpxorq */, X86::VPXORQZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12253 /* vpxorq */, X86::VPXORQZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12253 /* vpxorq */, X86::VPXORQZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12260 /* vrcp14pd */, X86::VRCP14PDZr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 12260 /* vrcp14pd */, X86::VRCP14PDZm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 12269 /* vrcp14ps */, X86::VRCP14PSZr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 12269 /* vrcp14ps */, X86::VRCP14PSZm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 12278 /* vrcp14sd */, X86::VRCP14SDrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12278 /* vrcp14sd */, X86::VRCP14SDrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 12287 /* vrcp14ss */, X86::VRCP14SSrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12287 /* vrcp14ss */, X86::VRCP14SSrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 12296 /* vrcp28pd */, X86::VRCP28PDZr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 12296 /* vrcp28pd */, X86::VRCP28PDZm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 12296 /* vrcp28pd */, X86::VRCP28PDZrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 12305 /* vrcp28ps */, X86::VRCP28PSZr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 12305 /* vrcp28ps */, X86::VRCP28PSZm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 12305 /* vrcp28ps */, X86::VRCP28PSZrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 12314 /* vrcp28sd */, X86::VRCP28SDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12314 /* vrcp28sd */, X86::VRCP28SDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 12314 /* vrcp28sd */, X86::VRCP28SDrrb, Convert__Reg1_3__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12323 /* vrcp28ss */, X86::VRCP28SSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12323 /* vrcp28ss */, X86::VRCP28SSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 12323 /* vrcp28ss */, X86::VRCP28SSrrb, Convert__Reg1_3__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12332 /* vrcpps */, X86::VRCPPSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 12332 /* vrcpps */, X86::VRCPPSYr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 12332 /* vrcpps */, X86::VRCPPSm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 12332 /* vrcpps */, X86::VRCPPSYm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 12339 /* vrcpss */, X86::VRCPSSr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12339 /* vrcpss */, X86::VRCPSSm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 12346 /* vrndscalepd */, X86::VRNDSCALEPDZr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, Feature_HasAVX512, { MCK_ImmSExti32i8, MCK_VR512, MCK_VR512 }, },
  { 12346 /* vrndscalepd */, X86::VRNDSCALEPDZm, Convert__Reg1_2__Mem5125_1__ImmSExti32i81_0, Feature_HasAVX512, { MCK_ImmSExti32i8, MCK_Mem512, MCK_VR512 }, },
  { 12358 /* vrndscaleps */, X86::VRNDSCALEPSZr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, Feature_HasAVX512, { MCK_ImmSExti32i8, MCK_VR512, MCK_VR512 }, },
  { 12358 /* vrndscaleps */, X86::VRNDSCALEPSZm, Convert__Reg1_2__Mem5125_1__ImmSExti32i81_0, Feature_HasAVX512, { MCK_ImmSExti32i8, MCK_Mem512, MCK_VR512 }, },
  { 12370 /* vrndscalesd */, X86::VRNDSCALESDr, Convert__Reg1_2__Reg1_1__Reg1_0__imm_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12370 /* vrndscalesd */, X86::VRNDSCALESDm, Convert__Reg1_2__Reg1_1__Mem645_0__imm_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 12382 /* vrndscaless */, X86::VRNDSCALESSr, Convert__Reg1_2__Reg1_1__Reg1_0__imm_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12382 /* vrndscaless */, X86::VRNDSCALESSm, Convert__Reg1_2__Reg1_1__Mem325_0__imm_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 12394 /* vroundpd */, X86::VROUNDPDr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_FR32 }, },
  { 12394 /* vroundpd */, X86::VROUNDYPDr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR256, MCK_VR256 }, },
  { 12394 /* vroundpd */, X86::VROUNDPDm, Convert__Reg1_2__Mem1285_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem128, MCK_FR32 }, },
  { 12394 /* vroundpd */, X86::VROUNDYPDm, Convert__Reg1_2__Mem2565_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem256, MCK_VR256 }, },
  { 12403 /* vroundps */, X86::VROUNDPSr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_FR32 }, },
  { 12403 /* vroundps */, X86::VROUNDYPSr, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_VR256, MCK_VR256 }, },
  { 12403 /* vroundps */, X86::VROUNDPSm, Convert__Reg1_2__Mem1285_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem128, MCK_FR32 }, },
  { 12403 /* vroundps */, X86::VROUNDYPSm, Convert__Reg1_2__Mem2565_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem256, MCK_VR256 }, },
  { 12412 /* vroundsd */, X86::VROUNDSDr, Convert__Reg1_3__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12412 /* vroundsd */, X86::VROUNDSDm, Convert__Reg1_3__Reg1_2__Mem645_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 12421 /* vroundss */, X86::VROUNDSSr, Convert__Reg1_3__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12421 /* vroundss */, X86::VROUNDSSm, Convert__Reg1_3__Reg1_2__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 12430 /* vrsqrt14pd */, X86::VRSQRT14PDZr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 12430 /* vrsqrt14pd */, X86::VRSQRT14PDZm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 12441 /* vrsqrt14ps */, X86::VRSQRT14PSZr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 12441 /* vrsqrt14ps */, X86::VRSQRT14PSZm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 12452 /* vrsqrt14sd */, X86::VRSQRT14SDrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12452 /* vrsqrt14sd */, X86::VRSQRT14SDrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 12463 /* vrsqrt14ss */, X86::VRSQRT14SSrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12463 /* vrsqrt14ss */, X86::VRSQRT14SSrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 12474 /* vrsqrt28pd */, X86::VRSQRT28PDZr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 12474 /* vrsqrt28pd */, X86::VRSQRT28PDZm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 12474 /* vrsqrt28pd */, X86::VRSQRT28PDZrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 12485 /* vrsqrt28ps */, X86::VRSQRT28PSZr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR512, MCK_VR512 }, },
  { 12485 /* vrsqrt28ps */, X86::VRSQRT28PSZm, Convert__Reg1_1__Mem5125_0, 0, { MCK_Mem512, MCK_VR512 }, },
  { 12485 /* vrsqrt28ps */, X86::VRSQRT28PSZrb, Convert__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 12496 /* vrsqrt28sd */, X86::VRSQRT28SDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12496 /* vrsqrt28sd */, X86::VRSQRT28SDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 12496 /* vrsqrt28sd */, X86::VRSQRT28SDrrb, Convert__Reg1_3__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12507 /* vrsqrt28ss */, X86::VRSQRT28SSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12507 /* vrsqrt28ss */, X86::VRSQRT28SSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 12507 /* vrsqrt28ss */, X86::VRSQRT28SSrrb, Convert__Reg1_3__Reg1_2__Reg1_1, 0, { MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12518 /* vrsqrtps */, X86::VRSQRTPSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 12518 /* vrsqrtps */, X86::VRSQRTPSYr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 12518 /* vrsqrtps */, X86::VRSQRTPSm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 12518 /* vrsqrtps */, X86::VRSQRTPSYm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 12527 /* vrsqrtss */, X86::VRSQRTSSr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12527 /* vrsqrtss */, X86::VRSQRTSSm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 12536 /* vscatterdpd */, X86::VSCATTERDPDZmr, Convert__Reg1_3__MemVY645_1__Tie0__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_MemVY64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12548 /* vscatterdps */, X86::VSCATTERDPSZmr, Convert__Reg1_3__MemVZ325_1__Tie0__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_MemVZ32, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12560 /* vscatterpf0dpd */, X86::VSCATTERPF0DPDm, Convert__Reg1_2__MemVY325_0, 0, { MCK_MemVY32, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12575 /* vscatterpf0dps */, X86::VSCATTERPF0DPSm, Convert__Reg1_2__MemVZ325_0, 0, { MCK_MemVZ32, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12590 /* vscatterpf0qpd */, X86::VSCATTERPF0QPDm, Convert__Reg1_2__MemVZ645_0, 0, { MCK_MemVZ64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12605 /* vscatterpf0qps */, X86::VSCATTERPF0QPSm, Convert__Reg1_2__MemVZ645_0, 0, { MCK_MemVZ64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12620 /* vscatterpf1dpd */, X86::VSCATTERPF1DPDm, Convert__Reg1_2__MemVY325_0, 0, { MCK_MemVY32, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12635 /* vscatterpf1dps */, X86::VSCATTERPF1DPSm, Convert__Reg1_2__MemVZ325_0, 0, { MCK_MemVZ32, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12650 /* vscatterpf1qpd */, X86::VSCATTERPF1QPDm, Convert__Reg1_2__MemVZ645_0, 0, { MCK_MemVZ64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12665 /* vscatterpf1qps */, X86::VSCATTERPF1QPSm, Convert__Reg1_2__MemVZ645_0, 0, { MCK_MemVZ64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12680 /* vscatterqpd */, X86::VSCATTERQPDZmr, Convert__Reg1_3__MemVZ645_1__Tie0__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_MemVZ64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12692 /* vscatterqps */, X86::VSCATTERQPSZmr, Convert__Reg1_3__MemVZ645_1__Tie0__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_MemVZ64, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12704 /* vshufpd */, X86::VSHUFPDrri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12704 /* vshufpd */, X86::VSHUFPDYrri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12704 /* vshufpd */, X86::VSHUFPDZrri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12704 /* vshufpd */, X86::VSHUFPDrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12704 /* vshufpd */, X86::VSHUFPDYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12704 /* vshufpd */, X86::VSHUFPDZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12712 /* vshufps */, X86::VSHUFPSrri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12712 /* vshufps */, X86::VSHUFPSYrri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12712 /* vshufps */, X86::VSHUFPSZrri, Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12712 /* vshufps */, X86::VSHUFPSrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0, 0, { MCK_Imm, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12712 /* vshufps */, X86::VSHUFPSYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__Imm1_0, 0, { MCK_Imm, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12712 /* vshufps */, X86::VSHUFPSZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12720 /* vsqrtpd */, X86::VSQRTPDr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 12720 /* vsqrtpd */, X86::VSQRTPDYr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 12720 /* vsqrtpd */, X86::VSQRTPDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 12720 /* vsqrtpd */, X86::VSQRTPDm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 12720 /* vsqrtpd */, X86::VSQRTPDYm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 12720 /* vsqrtpd */, X86::VSQRTPDZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 12728 /* vsqrtps */, X86::VSQRTPSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 12728 /* vsqrtps */, X86::VSQRTPSYr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 12728 /* vsqrtps */, X86::VSQRTPSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 12728 /* vsqrtps */, X86::VSQRTPSm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 12728 /* vsqrtps */, X86::VSQRTPSYm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 12728 /* vsqrtps */, X86::VSQRTPSZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 12736 /* vsqrtsd */, X86::VSQRTSDr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12736 /* vsqrtsd */, X86::VSQRTSDZr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12736 /* vsqrtsd */, X86::VSQRTSDm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 12736 /* vsqrtsd */, X86::VSQRTSDZm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 12744 /* vsqrtss */, X86::VSQRTSSr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12744 /* vsqrtss */, X86::VSQRTSSZr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12744 /* vsqrtss */, X86::VSQRTSSm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 12744 /* vsqrtss */, X86::VSQRTSSZm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 12752 /* vstmxcsr */, X86::VSTMXCSR, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 12761 /* vsubpd */, X86::VSUBPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12761 /* vsubpd */, X86::VSUBPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12761 /* vsubpd */, X86::VSUBPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12761 /* vsubpd */, X86::VSUBPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12761 /* vsubpd */, X86::VSUBPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12761 /* vsubpd */, X86::VSUBPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12761 /* vsubpd */, X86::VSUBPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 12761 /* vsubpd */, X86::VSUBPDZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12761 /* vsubpd */, X86::VSUBPDZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12761 /* vsubpd */, X86::VSUBPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12761 /* vsubpd */, X86::VSUBPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12761 /* vsubpd */, X86::VSUBPDZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12761 /* vsubpd */, X86::VSUBPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12768 /* vsubps */, X86::VSUBPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12768 /* vsubps */, X86::VSUBPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12768 /* vsubps */, X86::VSUBPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12768 /* vsubps */, X86::VSUBPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12768 /* vsubps */, X86::VSUBPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12768 /* vsubps */, X86::VSUBPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12768 /* vsubps */, X86::VSUBPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 12768 /* vsubps */, X86::VSUBPSZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12768 /* vsubps */, X86::VSUBPSZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12768 /* vsubps */, X86::VSUBPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12768 /* vsubps */, X86::VSUBPSZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_ }, },
  { 12768 /* vsubps */, X86::VSUBPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12768 /* vsubps */, X86::VSUBPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK16WM, MCK__125_, MCK__123_z_125_ }, },
  { 12775 /* vsubsd */, X86::VSUBSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12775 /* vsubsd */, X86::VSUBSDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12775 /* vsubsd */, X86::VSUBSDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 12775 /* vsubsd */, X86::VSUBSDZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 12782 /* vsubss */, X86::VSUBSSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12782 /* vsubss */, X86::VSUBSSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 12782 /* vsubss */, X86::VSUBSSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 12782 /* vsubss */, X86::VSUBSSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 12789 /* vtestpd */, X86::VTESTPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 12789 /* vtestpd */, X86::VTESTPDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 12789 /* vtestpd */, X86::VTESTPDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 12789 /* vtestpd */, X86::VTESTPDYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 12797 /* vtestps */, X86::VTESTPSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 12797 /* vtestps */, X86::VTESTPSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 12797 /* vtestps */, X86::VTESTPSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 12797 /* vtestps */, X86::VTESTPSYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 12805 /* vucomisd */, X86::VUCOMISDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 12805 /* vucomisd */, X86::VUCOMISDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X }, },
  { 12805 /* vucomisd */, X86::VUCOMISDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 12805 /* vucomisd */, X86::VUCOMISDZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X }, },
  { 12814 /* vucomiss */, X86::VUCOMISSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 12814 /* vucomiss */, X86::VUCOMISSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X }, },
  { 12814 /* vucomiss */, X86::VUCOMISSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 12814 /* vucomiss */, X86::VUCOMISSZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X }, },
  { 12823 /* vunpckhpd */, X86::VUNPCKHPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12823 /* vunpckhpd */, X86::VUNPCKHPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12823 /* vunpckhpd */, X86::VUNPCKHPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12823 /* vunpckhpd */, X86::VUNPCKHPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12823 /* vunpckhpd */, X86::VUNPCKHPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12823 /* vunpckhpd */, X86::VUNPCKHPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12833 /* vunpckhps */, X86::VUNPCKHPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12833 /* vunpckhps */, X86::VUNPCKHPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12833 /* vunpckhps */, X86::VUNPCKHPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12833 /* vunpckhps */, X86::VUNPCKHPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12833 /* vunpckhps */, X86::VUNPCKHPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12833 /* vunpckhps */, X86::VUNPCKHPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12843 /* vunpcklpd */, X86::VUNPCKLPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12843 /* vunpcklpd */, X86::VUNPCKLPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12843 /* vunpcklpd */, X86::VUNPCKLPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12843 /* vunpcklpd */, X86::VUNPCKLPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12843 /* vunpcklpd */, X86::VUNPCKLPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12843 /* vunpcklpd */, X86::VUNPCKLPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12853 /* vunpcklps */, X86::VUNPCKLPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12853 /* vunpcklps */, X86::VUNPCKLPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12853 /* vunpcklps */, X86::VUNPCKLPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 12853 /* vunpcklps */, X86::VUNPCKLPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12853 /* vunpcklps */, X86::VUNPCKLPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12853 /* vunpcklps */, X86::VUNPCKLPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 12863 /* vxorpd */, X86::VXORPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12863 /* vxorpd */, X86::VXORPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12863 /* vxorpd */, X86::VXORPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12863 /* vxorpd */, X86::VXORPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12870 /* vxorps */, X86::VXORPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 12870 /* vxorps */, X86::VXORPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 12870 /* vxorps */, X86::VXORPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 12870 /* vxorps */, X86::VXORPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 12877 /* vzeroall */, X86::VZEROALL, Convert_NoOperands, 0, {  }, },
  { 12886 /* vzeroupper */, X86::VZEROUPPER, Convert_NoOperands, 0, {  }, },
  { 12897 /* wait */, X86::WAIT, Convert_NoOperands, 0, {  }, },
  { 12902 /* wbinvd */, X86::WBINVD, Convert_NoOperands, 0, {  }, },
  { 12918 /* wrfsbasel */, X86::WRFSBASE, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR32 }, },
  { 12928 /* wrfsbaseq */, X86::WRFSBASE64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 12947 /* wrgsbasel */, X86::WRGSBASE, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR32 }, },
  { 12957 /* wrgsbaseq */, X86::WRGSBASE64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 12967 /* wrmsr */, X86::WRMSR, Convert_NoOperands, 0, {  }, },
  { 12973 /* xabort */, X86::XABORT, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 12980 /* xacquire */, X86::XACQUIRE_PREFIX, Convert_NoOperands, 0, {  }, },
  { 12994 /* xaddb */, X86::XADD8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 12994 /* xaddb */, X86::XADD8rm, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 13000 /* xaddl */, X86::XADD32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 13000 /* xaddl */, X86::XADD32rm, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 13006 /* xaddq */, X86::XADD64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 13006 /* xaddq */, X86::XADD64rm, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 13012 /* xaddw */, X86::XADD16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 13012 /* xaddw */, X86::XADD16rm, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 13018 /* xbegin */, X86::XBEGIN_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 13030 /* xchgb */, X86::XCHG8rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR8, MCK_GR8 }, },
  { 13030 /* xchgb */, X86::XCHG8rm, Convert__Reg1_0__Tie0__Mem85_1, 0, { MCK_GR8, MCK_Mem8 }, },
  { 13030 /* xchgb */, X86::XCHG8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 13036 /* xchgl */, X86::XCHG32ar64, Convert__Reg1_1, Feature_In64BitMode, { MCK_EAX, MCK_GR32_NOAX }, },
  { 13036 /* xchgl */, X86::XCHG32ar, Convert__Reg1_1, Feature_Not64BitMode, { MCK_EAX, MCK_GR32 }, },
  { 13036 /* xchgl */, X86::XCHG32ar64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR32_NOAX, MCK_EAX }, },
  { 13036 /* xchgl */, X86::XCHG32ar, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_EAX }, },
  { 13036 /* xchgl */, X86::XCHG32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 13036 /* xchgl */, X86::XCHG32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 13036 /* xchgl */, X86::XCHG32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 13042 /* xchgq */, X86::XCHG64ar, Convert__Reg1_1, 0, { MCK_RAX, MCK_GR64 }, },
  { 13042 /* xchgq */, X86::XCHG64ar, Convert__Reg1_0, 0, { MCK_GR64, MCK_RAX }, },
  { 13042 /* xchgq */, X86::XCHG64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 13042 /* xchgq */, X86::XCHG64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 13042 /* xchgq */, X86::XCHG64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 13048 /* xchgw */, X86::XCHG16ar, Convert__Reg1_1, 0, { MCK_AX, MCK_GR16 }, },
  { 13048 /* xchgw */, X86::XCHG16ar, Convert__Reg1_0, 0, { MCK_GR16, MCK_AX }, },
  { 13048 /* xchgw */, X86::XCHG16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 13048 /* xchgw */, X86::XCHG16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 13048 /* xchgw */, X86::XCHG16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 13054 /* xcryptcbc */, X86::XCRYPTCBC, Convert_NoOperands, 0, {  }, },
  { 13064 /* xcryptcfb */, X86::XCRYPTCFB, Convert_NoOperands, 0, {  }, },
  { 13074 /* xcryptctr */, X86::XCRYPTCTR, Convert_NoOperands, 0, {  }, },
  { 13084 /* xcryptecb */, X86::XCRYPTECB, Convert_NoOperands, 0, {  }, },
  { 13094 /* xcryptofb */, X86::XCRYPTOFB, Convert_NoOperands, 0, {  }, },
  { 13104 /* xend */, X86::XEND, Convert_NoOperands, 0, {  }, },
  { 13109 /* xgetbv */, X86::XGETBV, Convert_NoOperands, 0, {  }, },
  { 13116 /* xlatb */, X86::XLAT, Convert_NoOperands, 0, {  }, },
  { 13126 /* xorb */, X86::XOR8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 13126 /* xorb */, X86::XOR8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 13126 /* xorb */, X86::XOR8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 13126 /* xorb */, X86::XOR8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 13126 /* xorb */, X86::XOR8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 13126 /* xorb */, X86::XOR8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 13131 /* xorl */, X86::XOR32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 13131 /* xorl */, X86::XOR32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 13131 /* xorl */, X86::XOR32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 13131 /* xorl */, X86::XOR32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 13131 /* xorl */, X86::XOR32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 13131 /* xorl */, X86::XOR32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 13131 /* xorl */, X86::XOR32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 13131 /* xorl */, X86::XOR32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 13136 /* xorpd */, X86::XORPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 13136 /* xorpd */, X86::XORPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 13142 /* xorps */, X86::XORPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 13142 /* xorps */, X86::XORPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 13148 /* xorq */, X86::XOR64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 13148 /* xorq */, X86::XOR64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 13148 /* xorq */, X86::XOR64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 13148 /* xorq */, X86::XOR64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 13148 /* xorq */, X86::XOR64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 13148 /* xorq */, X86::XOR64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 13148 /* xorq */, X86::XOR64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 13148 /* xorq */, X86::XOR64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 13153 /* xorw */, X86::XOR16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 13153 /* xorw */, X86::XOR16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 13153 /* xorw */, X86::XOR16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 13153 /* xorw */, X86::XOR16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 13153 /* xorw */, X86::XOR16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 13153 /* xorw */, X86::XOR16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 13153 /* xorw */, X86::XOR16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 13153 /* xorw */, X86::XOR16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 13158 /* xrelease */, X86::XRELEASE_PREFIX, Convert_NoOperands, 0, {  }, },
  { 13167 /* xrstor */, X86::XRSTOR, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 13183 /* xrstorq */, X86::XRSTOR64, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 13191 /* xsave */, X86::XSAVE, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 13205 /* xsaveopt */, X86::XSAVEOPT, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 13225 /* xsaveoptq */, X86::XSAVEOPT64, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 13235 /* xsaveq */, X86::XSAVE64, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 13242 /* xsetbv */, X86::XSETBV, Convert_NoOperands, 0, {  }, },
  { 13249 /* xsha1 */, X86::XSHA1, Convert_NoOperands, 0, {  }, },
  { 13255 /* xsha256 */, X86::XSHA256, Convert_NoOperands, 0, {  }, },
  { 13263 /* xstore */, X86::XSTORE, Convert_NoOperands, 0, {  }, },
  { 13270 /* xstorerng */, X86::XSTORE, Convert_NoOperands, 0, {  }, },
  { 13280 /* xtest */, X86::XTEST, Convert_NoOperands, 0, {  }, },
};

static const MatchEntry MatchTable1[] = {
  { 0 /* aaa */, X86::AAA, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 4 /* aad */, X86::AAD8i8, Convert__imm_10, 0, {  }, },
  { 4 /* aad */, X86::AAD8i8, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 8 /* aam */, X86::AAM8i8, Convert__imm_10, 0, {  }, },
  { 8 /* aam */, X86::AAM8i8, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 12 /* aas */, X86::AAS, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 16 /* adc */, X86::ADC8i8, Convert__Imm1_1, 0, { MCK_AL, MCK_Imm }, },
  { 16 /* adc */, X86::ADC8rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR8, MCK_GR8 }, },
  { 16 /* adc */, X86::ADC8ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR8, MCK_Imm }, },
  { 16 /* adc */, X86::ADC8rm, Convert__Reg1_0__Tie0__Mem85_1, 0, { MCK_GR8, MCK_Mem8 }, },
  { 16 /* adc */, X86::ADC16i16, Convert__Imm1_1, 0, { MCK_AX, MCK_Imm }, },
  { 16 /* adc */, X86::ADC16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 16 /* adc */, X86::ADC16ri8, Convert__Reg1_0__Tie0__ImmSExti16i81_1, 0, { MCK_GR16, MCK_ImmSExti16i8 }, },
  { 16 /* adc */, X86::ADC16ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR16, MCK_Imm }, },
  { 16 /* adc */, X86::ADC16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 16 /* adc */, X86::ADC32i32, Convert__Imm1_1, 0, { MCK_EAX, MCK_Imm }, },
  { 16 /* adc */, X86::ADC32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 16 /* adc */, X86::ADC32ri8, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_GR32, MCK_ImmSExti32i8 }, },
  { 16 /* adc */, X86::ADC32ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR32, MCK_Imm }, },
  { 16 /* adc */, X86::ADC32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 16 /* adc */, X86::ADC64i32, Convert__ImmSExti64i321_1, 0, { MCK_RAX, MCK_ImmSExti64i32 }, },
  { 16 /* adc */, X86::ADC64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 16 /* adc */, X86::ADC64ri8, Convert__Reg1_0__Tie0__ImmSExti64i81_1, 0, { MCK_GR64, MCK_ImmSExti64i8 }, },
  { 16 /* adc */, X86::ADC64ri32, Convert__Reg1_0__Tie0__ImmSExti64i321_1, 0, { MCK_GR64, MCK_ImmSExti64i32 }, },
  { 16 /* adc */, X86::ADC64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 16 /* adc */, X86::ADC16mr, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 16 /* adc */, X86::ADC16mi8, Convert__Mem165_0__ImmSExti16i81_1, 0, { MCK_Mem16, MCK_ImmSExti16i8 }, },
  { 16 /* adc */, X86::ADC16mi, Convert__Mem165_0__Imm1_1, 0, { MCK_Mem16, MCK_Imm }, },
  { 16 /* adc */, X86::ADC32mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 16 /* adc */, X86::ADC32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 16 /* adc */, X86::ADC32mi, Convert__Mem325_0__Imm1_1, 0, { MCK_Mem32, MCK_Imm }, },
  { 16 /* adc */, X86::ADC64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 16 /* adc */, X86::ADC64mi8, Convert__Mem645_0__ImmSExti64i81_1, 0, { MCK_Mem64, MCK_ImmSExti64i8 }, },
  { 16 /* adc */, X86::ADC64mi32, Convert__Mem645_0__ImmSExti64i321_1, 0, { MCK_Mem64, MCK_ImmSExti64i32 }, },
  { 16 /* adc */, X86::ADC8mr, Convert__Mem85_0__Reg1_1, 0, { MCK_Mem8, MCK_GR8 }, },
  { 16 /* adc */, X86::ADC8mi, Convert__Mem85_0__Imm1_1, 0, { MCK_Mem8, MCK_Imm }, },
  { 40 /* adcx */, X86::ADCX32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 40 /* adcx */, X86::ADCX32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 40 /* adcx */, X86::ADCX64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 40 /* adcx */, X86::ADCX64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 57 /* add */, X86::ADD8i8, Convert__Imm1_1, 0, { MCK_AL, MCK_Imm }, },
  { 57 /* add */, X86::ADD8rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR8, MCK_GR8 }, },
  { 57 /* add */, X86::ADD8ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR8, MCK_Imm }, },
  { 57 /* add */, X86::ADD8rm, Convert__Reg1_0__Tie0__Mem85_1, 0, { MCK_GR8, MCK_Mem8 }, },
  { 57 /* add */, X86::ADD16i16, Convert__Imm1_1, 0, { MCK_AX, MCK_Imm }, },
  { 57 /* add */, X86::ADD16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 57 /* add */, X86::ADD16ri8, Convert__Reg1_0__Tie0__ImmSExti16i81_1, 0, { MCK_GR16, MCK_ImmSExti16i8 }, },
  { 57 /* add */, X86::ADD16ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR16, MCK_Imm }, },
  { 57 /* add */, X86::ADD16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 57 /* add */, X86::ADD32i32, Convert__Imm1_1, 0, { MCK_EAX, MCK_Imm }, },
  { 57 /* add */, X86::ADD32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 57 /* add */, X86::ADD32ri8, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_GR32, MCK_ImmSExti32i8 }, },
  { 57 /* add */, X86::ADD32ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR32, MCK_Imm }, },
  { 57 /* add */, X86::ADD32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 57 /* add */, X86::ADD64i32, Convert__ImmSExti64i321_1, 0, { MCK_RAX, MCK_ImmSExti64i32 }, },
  { 57 /* add */, X86::ADD64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 57 /* add */, X86::ADD64ri8, Convert__Reg1_0__Tie0__ImmSExti64i81_1, 0, { MCK_GR64, MCK_ImmSExti64i8 }, },
  { 57 /* add */, X86::ADD64ri32, Convert__Reg1_0__Tie0__ImmSExti64i321_1, 0, { MCK_GR64, MCK_ImmSExti64i32 }, },
  { 57 /* add */, X86::ADD64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 57 /* add */, X86::ADD16mr, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 57 /* add */, X86::ADD16mi8, Convert__Mem165_0__ImmSExti16i81_1, 0, { MCK_Mem16, MCK_ImmSExti16i8 }, },
  { 57 /* add */, X86::ADD16mi, Convert__Mem165_0__Imm1_1, 0, { MCK_Mem16, MCK_Imm }, },
  { 57 /* add */, X86::ADD32mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 57 /* add */, X86::ADD32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 57 /* add */, X86::ADD32mi, Convert__Mem325_0__Imm1_1, 0, { MCK_Mem32, MCK_Imm }, },
  { 57 /* add */, X86::ADD64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 57 /* add */, X86::ADD64mi8, Convert__Mem645_0__ImmSExti64i81_1, 0, { MCK_Mem64, MCK_ImmSExti64i8 }, },
  { 57 /* add */, X86::ADD64mi32, Convert__Mem645_0__ImmSExti64i321_1, 0, { MCK_Mem64, MCK_ImmSExti64i32 }, },
  { 57 /* add */, X86::ADD8mr, Convert__Mem85_0__Reg1_1, 0, { MCK_Mem8, MCK_GR8 }, },
  { 57 /* add */, X86::ADD8mi, Convert__Mem85_0__Imm1_1, 0, { MCK_Mem8, MCK_Imm }, },
  { 71 /* addpd */, X86::ADDPDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 71 /* addpd */, X86::ADDPDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 77 /* addps */, X86::ADDPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 77 /* addps */, X86::ADDPSrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 88 /* addsd */, X86::ADDSDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 88 /* addsd */, X86::ADDSDrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 94 /* addss */, X86::ADDSSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 94 /* addss */, X86::ADDSSrm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 100 /* addsubpd */, X86::ADDSUBPDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 100 /* addsubpd */, X86::ADDSUBPDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 109 /* addsubps */, X86::ADDSUBPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 109 /* addsubps */, X86::ADDSUBPSrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 123 /* adox */, X86::ADOX32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 123 /* adox */, X86::ADOX32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 123 /* adox */, X86::ADOX64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 123 /* adox */, X86::ADOX64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 140 /* aesdec */, X86::AESDECrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 140 /* aesdec */, X86::AESDECrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 147 /* aesdeclast */, X86::AESDECLASTrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 147 /* aesdeclast */, X86::AESDECLASTrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 158 /* aesenc */, X86::AESENCrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 158 /* aesenc */, X86::AESENCrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 165 /* aesenclast */, X86::AESENCLASTrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 165 /* aesenclast */, X86::AESENCLASTrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 176 /* aesimc */, X86::AESIMCrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 176 /* aesimc */, X86::AESIMCrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 183 /* aeskeygenassist */, X86::AESKEYGENASSIST128rr, Convert__Reg1_0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 183 /* aeskeygenassist */, X86::AESKEYGENASSIST128rm, Convert__Reg1_0__Mem1285_1__Imm1_2, 0, { MCK_FR32, MCK_Mem128, MCK_Imm }, },
  { 199 /* and */, X86::AND8i8, Convert__Imm1_1, 0, { MCK_AL, MCK_Imm }, },
  { 199 /* and */, X86::AND8rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR8, MCK_GR8 }, },
  { 199 /* and */, X86::AND8ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR8, MCK_Imm }, },
  { 199 /* and */, X86::AND8rm, Convert__Reg1_0__Tie0__Mem85_1, 0, { MCK_GR8, MCK_Mem8 }, },
  { 199 /* and */, X86::AND16i16, Convert__Imm1_1, 0, { MCK_AX, MCK_Imm }, },
  { 199 /* and */, X86::AND16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 199 /* and */, X86::AND16ri8, Convert__Reg1_0__Tie0__ImmSExti16i81_1, 0, { MCK_GR16, MCK_ImmSExti16i8 }, },
  { 199 /* and */, X86::AND16ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR16, MCK_Imm }, },
  { 199 /* and */, X86::AND16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 199 /* and */, X86::AND32i32, Convert__Imm1_1, 0, { MCK_EAX, MCK_Imm }, },
  { 199 /* and */, X86::AND32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 199 /* and */, X86::AND32ri8, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_GR32, MCK_ImmSExti32i8 }, },
  { 199 /* and */, X86::AND32ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR32, MCK_Imm }, },
  { 199 /* and */, X86::AND32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 199 /* and */, X86::AND64i32, Convert__ImmSExti64i321_1, 0, { MCK_RAX, MCK_ImmSExti64i32 }, },
  { 199 /* and */, X86::AND64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 199 /* and */, X86::AND64ri8, Convert__Reg1_0__Tie0__ImmSExti64i81_1, 0, { MCK_GR64, MCK_ImmSExti64i8 }, },
  { 199 /* and */, X86::AND64ri32, Convert__Reg1_0__Tie0__ImmSExti64i321_1, 0, { MCK_GR64, MCK_ImmSExti64i32 }, },
  { 199 /* and */, X86::AND64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 199 /* and */, X86::AND16mr, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 199 /* and */, X86::AND16mi8, Convert__Mem165_0__ImmSExti16i81_1, 0, { MCK_Mem16, MCK_ImmSExti16i8 }, },
  { 199 /* and */, X86::AND16mi, Convert__Mem165_0__Imm1_1, 0, { MCK_Mem16, MCK_Imm }, },
  { 199 /* and */, X86::AND32mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 199 /* and */, X86::AND32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 199 /* and */, X86::AND32mi, Convert__Mem325_0__Imm1_1, 0, { MCK_Mem32, MCK_Imm }, },
  { 199 /* and */, X86::AND64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 199 /* and */, X86::AND64mi8, Convert__Mem645_0__ImmSExti64i81_1, 0, { MCK_Mem64, MCK_ImmSExti64i8 }, },
  { 199 /* and */, X86::AND64mi32, Convert__Mem645_0__ImmSExti64i321_1, 0, { MCK_Mem64, MCK_ImmSExti64i32 }, },
  { 199 /* and */, X86::AND8mr, Convert__Mem85_0__Reg1_1, 0, { MCK_Mem8, MCK_GR8 }, },
  { 199 /* and */, X86::AND8mi, Convert__Mem85_0__Imm1_1, 0, { MCK_Mem8, MCK_Imm }, },
  { 213 /* andn */, X86::ANDN32rr, Convert__Reg1_0__Reg1_1__Reg1_2, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 213 /* andn */, X86::ANDN32rm, Convert__Reg1_0__Reg1_1__Mem325_2, 0, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 213 /* andn */, X86::ANDN64rr, Convert__Reg1_0__Reg1_1__Reg1_2, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 213 /* andn */, X86::ANDN64rm, Convert__Reg1_0__Reg1_1__Mem645_2, 0, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 224 /* andnpd */, X86::ANDNPDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 224 /* andnpd */, X86::ANDNPDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 231 /* andnps */, X86::ANDNPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 231 /* andnps */, X86::ANDNPSrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 244 /* andpd */, X86::ANDPDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 244 /* andpd */, X86::ANDPDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 250 /* andps */, X86::ANDPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 250 /* andps */, X86::ANDPSrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 266 /* arpl */, X86::ARPL16rr, Convert__Reg1_0__Reg1_1, Feature_Not64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 266 /* arpl */, X86::ARPL16mr, Convert__Mem165_0__Reg1_1, Feature_Not64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 271 /* bextr */, X86::BEXTR32rr, Convert__Reg1_0__Reg1_1__Reg1_2, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 271 /* bextr */, X86::BEXTRI32ri, Convert__Reg1_0__Reg1_1__Imm1_2, 0, { MCK_GR32, MCK_GR32, MCK_Imm }, },
  { 271 /* bextr */, X86::BEXTR32rm, Convert__Reg1_0__Mem325_1__Reg1_2, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 271 /* bextr */, X86::BEXTRI32mi, Convert__Reg1_0__Mem325_1__Imm1_2, 0, { MCK_GR32, MCK_Mem32, MCK_Imm }, },
  { 271 /* bextr */, X86::BEXTR64rr, Convert__Reg1_0__Reg1_1__Reg1_2, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 271 /* bextr */, X86::BEXTRI64ri, Convert__Reg1_0__Reg1_1__ImmSExti64i321_2, 0, { MCK_GR64, MCK_GR64, MCK_ImmSExti64i32 }, },
  { 271 /* bextr */, X86::BEXTR64rm, Convert__Reg1_0__Mem645_1__Reg1_2, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 271 /* bextr */, X86::BEXTRI64mi, Convert__Reg1_0__Mem645_1__ImmSExti64i321_2, 0, { MCK_GR64, MCK_Mem64, MCK_ImmSExti64i32 }, },
  { 291 /* blcfill */, X86::BLCFILL32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 291 /* blcfill */, X86::BLCFILL32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 291 /* blcfill */, X86::BLCFILL64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 291 /* blcfill */, X86::BLCFILL64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 299 /* blci */, X86::BLCI32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 299 /* blci */, X86::BLCI32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 299 /* blci */, X86::BLCI64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 299 /* blci */, X86::BLCI64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 304 /* blcic */, X86::BLCIC32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 304 /* blcic */, X86::BLCIC32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 304 /* blcic */, X86::BLCIC64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 304 /* blcic */, X86::BLCIC64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 310 /* blcmsk */, X86::BLCMSK32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 310 /* blcmsk */, X86::BLCMSK32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 310 /* blcmsk */, X86::BLCMSK64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 310 /* blcmsk */, X86::BLCMSK64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 317 /* blcs */, X86::BLCS32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 317 /* blcs */, X86::BLCS32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 317 /* blcs */, X86::BLCS64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 317 /* blcs */, X86::BLCS64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 322 /* blendpd */, X86::BLENDPDrri, Convert__Reg1_0__Tie0__Reg1_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_FR32, MCK_ImmZExtu32u8 }, },
  { 322 /* blendpd */, X86::BLENDPDrmi, Convert__Reg1_0__Tie0__Mem1285_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_Mem128, MCK_ImmZExtu32u8 }, },
  { 330 /* blendps */, X86::BLENDPSrri, Convert__Reg1_0__Tie0__Reg1_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_FR32, MCK_ImmZExtu32u8 }, },
  { 330 /* blendps */, X86::BLENDPSrmi, Convert__Reg1_0__Tie0__Mem1285_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_Mem128, MCK_ImmZExtu32u8 }, },
  { 338 /* blendvpd */, X86::BLENDVPDrr0, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 338 /* blendvpd */, X86::BLENDVPDrm0, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 338 /* blendvpd */, X86::BLENDVPDrr0, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32, MCK_XMM0 }, },
  { 338 /* blendvpd */, X86::BLENDVPDrm0, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128, MCK_XMM0 }, },
  { 347 /* blendvps */, X86::BLENDVPSrr0, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 347 /* blendvps */, X86::BLENDVPSrm0, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 347 /* blendvps */, X86::BLENDVPSrr0, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32, MCK_XMM0 }, },
  { 347 /* blendvps */, X86::BLENDVPSrm0, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128, MCK_XMM0 }, },
  { 356 /* blsfill */, X86::BLSFILL32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 356 /* blsfill */, X86::BLSFILL32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 356 /* blsfill */, X86::BLSFILL64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 356 /* blsfill */, X86::BLSFILL64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 364 /* blsi */, X86::BLSI32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 364 /* blsi */, X86::BLSI32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 364 /* blsi */, X86::BLSI64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 364 /* blsi */, X86::BLSI64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 369 /* blsic */, X86::BLSIC32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 369 /* blsic */, X86::BLSIC32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 369 /* blsic */, X86::BLSIC64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 369 /* blsic */, X86::BLSIC64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 387 /* blsmsk */, X86::BLSMSK32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 387 /* blsmsk */, X86::BLSMSK32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 387 /* blsmsk */, X86::BLSMSK64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 387 /* blsmsk */, X86::BLSMSK64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 410 /* blsr */, X86::BLSR32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 410 /* blsr */, X86::BLSR32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 410 /* blsr */, X86::BLSR64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 410 /* blsr */, X86::BLSR64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 427 /* bound */, X86::BOUNDS16rm, Convert__Reg1_0__Mem165_1, Feature_Not64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 427 /* bound */, X86::BOUNDS32rm, Convert__Reg1_0__Mem325_1, Feature_Not64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 433 /* bsf */, X86::BSF16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 433 /* bsf */, X86::BSF16rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 433 /* bsf */, X86::BSF32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 433 /* bsf */, X86::BSF32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 433 /* bsf */, X86::BSF64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 433 /* bsf */, X86::BSF64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 452 /* bsr */, X86::BSR16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 452 /* bsr */, X86::BSR16rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 452 /* bsr */, X86::BSR32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 452 /* bsr */, X86::BSR32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 452 /* bsr */, X86::BSR64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 452 /* bsr */, X86::BSR64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 471 /* bswap */, X86::BSWAP32r, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 471 /* bswap */, X86::BSWAP64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 491 /* bt */, X86::BT16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 491 /* bt */, X86::BT16ri8, Convert__Reg1_0__ImmSExti16i81_1, 0, { MCK_GR16, MCK_ImmSExti16i8 }, },
  { 491 /* bt */, X86::BT32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 491 /* bt */, X86::BT32ri8, Convert__Reg1_0__ImmSExti32i81_1, 0, { MCK_GR32, MCK_ImmSExti32i8 }, },
  { 491 /* bt */, X86::BT64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 491 /* bt */, X86::BT64ri8, Convert__Reg1_0__ImmSExti64i81_1, 0, { MCK_GR64, MCK_ImmSExti64i8 }, },
  { 491 /* bt */, X86::BT16mr, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 491 /* bt */, X86::BT16mi8, Convert__Mem165_0__ImmSExti16i81_1, 0, { MCK_Mem16, MCK_ImmSExti16i8 }, },
  { 491 /* bt */, X86::BT32mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 491 /* bt */, X86::BT32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 491 /* bt */, X86::BT32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 491 /* bt */, X86::BT64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 491 /* bt */, X86::BT64mi8, Convert__Mem645_0__ImmSExti64i81_1, 0, { MCK_Mem64, MCK_ImmSExti64i8 }, },
  { 494 /* btc */, X86::BTC16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 494 /* btc */, X86::BTC16ri8, Convert__Reg1_0__ImmSExti16i81_1, 0, { MCK_GR16, MCK_ImmSExti16i8 }, },
  { 494 /* btc */, X86::BTC32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 494 /* btc */, X86::BTC32ri8, Convert__Reg1_0__ImmSExti32i81_1, 0, { MCK_GR32, MCK_ImmSExti32i8 }, },
  { 494 /* btc */, X86::BTC64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 494 /* btc */, X86::BTC64ri8, Convert__Reg1_0__ImmSExti64i81_1, 0, { MCK_GR64, MCK_ImmSExti64i8 }, },
  { 494 /* btc */, X86::BTC16mr, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 494 /* btc */, X86::BTC16mi8, Convert__Mem165_0__ImmSExti16i81_1, 0, { MCK_Mem16, MCK_ImmSExti16i8 }, },
  { 494 /* btc */, X86::BTC32mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 494 /* btc */, X86::BTC32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 494 /* btc */, X86::BTC32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 494 /* btc */, X86::BTC64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 494 /* btc */, X86::BTC64mi8, Convert__Mem645_0__ImmSExti64i81_1, 0, { MCK_Mem64, MCK_ImmSExti64i8 }, },
  { 521 /* btr */, X86::BTR16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 521 /* btr */, X86::BTR16ri8, Convert__Reg1_0__ImmSExti16i81_1, 0, { MCK_GR16, MCK_ImmSExti16i8 }, },
  { 521 /* btr */, X86::BTR32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 521 /* btr */, X86::BTR32ri8, Convert__Reg1_0__ImmSExti32i81_1, 0, { MCK_GR32, MCK_ImmSExti32i8 }, },
  { 521 /* btr */, X86::BTR64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 521 /* btr */, X86::BTR64ri8, Convert__Reg1_0__ImmSExti64i81_1, 0, { MCK_GR64, MCK_ImmSExti64i8 }, },
  { 521 /* btr */, X86::BTR16mr, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 521 /* btr */, X86::BTR16mi8, Convert__Mem165_0__ImmSExti16i81_1, 0, { MCK_Mem16, MCK_ImmSExti16i8 }, },
  { 521 /* btr */, X86::BTR32mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 521 /* btr */, X86::BTR32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 521 /* btr */, X86::BTR32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 521 /* btr */, X86::BTR64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 521 /* btr */, X86::BTR64mi8, Convert__Mem645_0__ImmSExti64i81_1, 0, { MCK_Mem64, MCK_ImmSExti64i8 }, },
  { 540 /* bts */, X86::BTS16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 540 /* bts */, X86::BTS16ri8, Convert__Reg1_0__ImmSExti16i81_1, 0, { MCK_GR16, MCK_ImmSExti16i8 }, },
  { 540 /* bts */, X86::BTS32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 540 /* bts */, X86::BTS32ri8, Convert__Reg1_0__ImmSExti32i81_1, 0, { MCK_GR32, MCK_ImmSExti32i8 }, },
  { 540 /* bts */, X86::BTS64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 540 /* bts */, X86::BTS64ri8, Convert__Reg1_0__ImmSExti64i81_1, 0, { MCK_GR64, MCK_ImmSExti64i8 }, },
  { 540 /* bts */, X86::BTS16mr, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 540 /* bts */, X86::BTS16mi8, Convert__Mem165_0__ImmSExti16i81_1, 0, { MCK_Mem16, MCK_ImmSExti16i8 }, },
  { 540 /* bts */, X86::BTS32mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 540 /* bts */, X86::BTS32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 540 /* bts */, X86::BTS32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 540 /* bts */, X86::BTS64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 540 /* bts */, X86::BTS64mi8, Convert__Mem645_0__ImmSExti64i81_1, 0, { MCK_Mem64, MCK_ImmSExti64i8 }, },
  { 563 /* bzhi */, X86::BZHI32rr, Convert__Reg1_0__Reg1_1__Reg1_2, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 563 /* bzhi */, X86::BZHI32rm, Convert__Reg1_0__Mem325_1__Reg1_2, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 563 /* bzhi */, X86::BZHI64rr, Convert__Reg1_0__Reg1_1__Reg1_2, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 563 /* bzhi */, X86::BZHI64rm, Convert__Reg1_0__Mem645_1__Reg1_2, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 580 /* call */, X86::CALL16r, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR16 }, },
  { 580 /* call */, X86::CALL32r, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 580 /* call */, X86::CALL64r, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 580 /* call */, X86::CALL64pcrel32, Convert__AbsMem1_0, Feature_In64BitMode, { MCK_AbsMem }, },
  { 580 /* call */, X86::CALLpcrel32, Convert__AbsMem1_0, Feature_Not64BitMode, { MCK_AbsMem }, },
  { 580 /* call */, X86::CALLpcrel16, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 580 /* call */, X86::CALL16m, Convert__Mem165_0, Feature_Not64BitMode, { MCK_Mem16 }, },
  { 580 /* call */, X86::CALL32m, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 580 /* call */, X86::CALL64m, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 580 /* call */, X86::CALL64m, Convert__Mem165_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 580 /* call */, X86::CALL32m, Convert__Mem165_1, Feature_In32BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 580 /* call */, X86::CALL16m, Convert__Mem165_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 580 /* call */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 580 /* call */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, Feature_Not16BitMode, { MCK_Imm, MCK_Imm }, },
  { 585 /* calll */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 597 /* callw */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 608 /* cbw */, X86::CBW, Convert_NoOperands, 0, {  }, },
  { 612 /* cdq */, X86::CDQ, Convert_NoOperands, 0, {  }, },
  { 616 /* cdqe */, X86::CDQE, Convert_NoOperands, 0, {  }, },
  { 621 /* clac */, X86::CLAC, Convert_NoOperands, 0, {  }, },
  { 626 /* clc */, X86::CLC, Convert_NoOperands, 0, {  }, },
  { 630 /* cld */, X86::CLD, Convert_NoOperands, 0, {  }, },
  { 634 /* clflush */, X86::CLFLUSH, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 642 /* clgi */, X86::CLGI, Convert_NoOperands, 0, {  }, },
  { 647 /* cli */, X86::CLI, Convert_NoOperands, 0, {  }, },
  { 651 /* clrb */, X86::XOR8rr, Convert__Reg1_0__Tie0__Reg1_0, 0, { MCK_GR8 }, },
  { 656 /* clrl */, X86::XOR32rr, Convert__Reg1_0__Tie0__Reg1_0, 0, { MCK_GR32 }, },
  { 661 /* clrq */, X86::XOR64rr, Convert__Reg1_0__Tie0__Reg1_0, 0, { MCK_GR64 }, },
  { 666 /* clrw */, X86::XOR16rr, Convert__Reg1_0__Tie0__Reg1_0, 0, { MCK_GR16 }, },
  { 681 /* clts */, X86::CLTS, Convert_NoOperands, 0, {  }, },
  { 686 /* cmc */, X86::CMC, Convert_NoOperands, 0, {  }, },
  { 690 /* cmova */, X86::CMOVA16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 690 /* cmova */, X86::CMOVA16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 690 /* cmova */, X86::CMOVA32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 690 /* cmova */, X86::CMOVA32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 690 /* cmova */, X86::CMOVA64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 690 /* cmova */, X86::CMOVA64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 696 /* cmovae */, X86::CMOVAE16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 696 /* cmovae */, X86::CMOVAE16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 696 /* cmovae */, X86::CMOVAE32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 696 /* cmovae */, X86::CMOVAE32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 696 /* cmovae */, X86::CMOVAE64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 696 /* cmovae */, X86::CMOVAE64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 748 /* cmovb */, X86::CMOVB16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 748 /* cmovb */, X86::CMOVB16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 748 /* cmovb */, X86::CMOVB32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 748 /* cmovb */, X86::CMOVB32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 748 /* cmovb */, X86::CMOVB64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 748 /* cmovb */, X86::CMOVB64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 754 /* cmovbe */, X86::CMOVBE16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 754 /* cmovbe */, X86::CMOVBE16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 754 /* cmovbe */, X86::CMOVBE32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 754 /* cmovbe */, X86::CMOVBE32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 754 /* cmovbe */, X86::CMOVBE64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 754 /* cmovbe */, X86::CMOVBE64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 806 /* cmove */, X86::CMOVE16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 806 /* cmove */, X86::CMOVE16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 806 /* cmove */, X86::CMOVE32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 806 /* cmove */, X86::CMOVE32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 806 /* cmove */, X86::CMOVE64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 806 /* cmove */, X86::CMOVE64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 833 /* cmovg */, X86::CMOVG16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 833 /* cmovg */, X86::CMOVG16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 833 /* cmovg */, X86::CMOVG32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 833 /* cmovg */, X86::CMOVG32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 833 /* cmovg */, X86::CMOVG64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 833 /* cmovg */, X86::CMOVG64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 839 /* cmovge */, X86::CMOVGE16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 839 /* cmovge */, X86::CMOVGE16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 839 /* cmovge */, X86::CMOVGE32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 839 /* cmovge */, X86::CMOVGE32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 839 /* cmovge */, X86::CMOVGE64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 839 /* cmovge */, X86::CMOVGE64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 891 /* cmovl */, X86::CMOVL16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 891 /* cmovl */, X86::CMOVL16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 891 /* cmovl */, X86::CMOVL32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 891 /* cmovl */, X86::CMOVL32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 891 /* cmovl */, X86::CMOVL64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 891 /* cmovl */, X86::CMOVL64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 897 /* cmovle */, X86::CMOVLE16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 897 /* cmovle */, X86::CMOVLE16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 897 /* cmovle */, X86::CMOVLE32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 897 /* cmovle */, X86::CMOVLE32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 897 /* cmovle */, X86::CMOVLE64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 897 /* cmovle */, X86::CMOVLE64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 949 /* cmovne */, X86::CMOVNE16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 949 /* cmovne */, X86::CMOVNE16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 949 /* cmovne */, X86::CMOVNE32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 949 /* cmovne */, X86::CMOVNE32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 949 /* cmovne */, X86::CMOVNE64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 949 /* cmovne */, X86::CMOVNE64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 980 /* cmovno */, X86::CMOVNO16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 980 /* cmovno */, X86::CMOVNO16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 980 /* cmovno */, X86::CMOVNO32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 980 /* cmovno */, X86::CMOVNO32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 980 /* cmovno */, X86::CMOVNO64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 980 /* cmovno */, X86::CMOVNO64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1011 /* cmovnp */, X86::CMOVNP16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 1011 /* cmovnp */, X86::CMOVNP16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 1011 /* cmovnp */, X86::CMOVNP32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 1011 /* cmovnp */, X86::CMOVNP32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1011 /* cmovnp */, X86::CMOVNP64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 1011 /* cmovnp */, X86::CMOVNP64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1042 /* cmovns */, X86::CMOVNS16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 1042 /* cmovns */, X86::CMOVNS16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 1042 /* cmovns */, X86::CMOVNS32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 1042 /* cmovns */, X86::CMOVNS32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1042 /* cmovns */, X86::CMOVNS64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 1042 /* cmovns */, X86::CMOVNS64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1073 /* cmovo */, X86::CMOVO16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 1073 /* cmovo */, X86::CMOVO16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 1073 /* cmovo */, X86::CMOVO32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 1073 /* cmovo */, X86::CMOVO32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1073 /* cmovo */, X86::CMOVO64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 1073 /* cmovo */, X86::CMOVO64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1100 /* cmovp */, X86::CMOVP16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 1100 /* cmovp */, X86::CMOVP16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 1100 /* cmovp */, X86::CMOVP32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 1100 /* cmovp */, X86::CMOVP32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1100 /* cmovp */, X86::CMOVP64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 1100 /* cmovp */, X86::CMOVP64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1127 /* cmovs */, X86::CMOVS16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 1127 /* cmovs */, X86::CMOVS16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 1127 /* cmovs */, X86::CMOVS32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 1127 /* cmovs */, X86::CMOVS32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1127 /* cmovs */, X86::CMOVS64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 1127 /* cmovs */, X86::CMOVS64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1154 /* cmp */, X86::CMP8i8, Convert__Imm1_1, 0, { MCK_AL, MCK_Imm }, },
  { 1154 /* cmp */, X86::CMP8rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR8, MCK_GR8 }, },
  { 1154 /* cmp */, X86::CMP8ri, Convert__Reg1_0__Imm1_1, 0, { MCK_GR8, MCK_Imm }, },
  { 1154 /* cmp */, X86::CMP8rm, Convert__Reg1_0__Mem85_1, 0, { MCK_GR8, MCK_Mem8 }, },
  { 1154 /* cmp */, X86::CMP16i16, Convert__Imm1_1, 0, { MCK_AX, MCK_Imm }, },
  { 1154 /* cmp */, X86::CMP16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 1154 /* cmp */, X86::CMP16ri8, Convert__Reg1_0__ImmSExti16i81_1, 0, { MCK_GR16, MCK_ImmSExti16i8 }, },
  { 1154 /* cmp */, X86::CMP16ri, Convert__Reg1_0__Imm1_1, 0, { MCK_GR16, MCK_Imm }, },
  { 1154 /* cmp */, X86::CMP16rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 1154 /* cmp */, X86::CMP32i32, Convert__Imm1_1, 0, { MCK_EAX, MCK_Imm }, },
  { 1154 /* cmp */, X86::CMP32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 1154 /* cmp */, X86::CMP32ri8, Convert__Reg1_0__ImmSExti32i81_1, 0, { MCK_GR32, MCK_ImmSExti32i8 }, },
  { 1154 /* cmp */, X86::CMP32ri, Convert__Reg1_0__Imm1_1, 0, { MCK_GR32, MCK_Imm }, },
  { 1154 /* cmp */, X86::CMP32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1154 /* cmp */, X86::CMP64i32, Convert__ImmSExti64i321_1, 0, { MCK_RAX, MCK_ImmSExti64i32 }, },
  { 1154 /* cmp */, X86::CMP64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 1154 /* cmp */, X86::CMP64ri8, Convert__Reg1_0__ImmSExti64i81_1, 0, { MCK_GR64, MCK_ImmSExti64i8 }, },
  { 1154 /* cmp */, X86::CMP64ri32, Convert__Reg1_0__ImmSExti64i321_1, 0, { MCK_GR64, MCK_ImmSExti64i32 }, },
  { 1154 /* cmp */, X86::CMP64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1154 /* cmp */, X86::CMP16mr, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1154 /* cmp */, X86::CMP16mi8, Convert__Mem165_0__ImmSExti16i81_1, 0, { MCK_Mem16, MCK_ImmSExti16i8 }, },
  { 1154 /* cmp */, X86::CMP16mi, Convert__Mem165_0__Imm1_1, 0, { MCK_Mem16, MCK_Imm }, },
  { 1154 /* cmp */, X86::CMP32mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1154 /* cmp */, X86::CMP32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 1154 /* cmp */, X86::CMP32mi, Convert__Mem325_0__Imm1_1, 0, { MCK_Mem32, MCK_Imm }, },
  { 1154 /* cmp */, X86::CMP64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1154 /* cmp */, X86::CMP64mi8, Convert__Mem645_0__ImmSExti64i81_1, 0, { MCK_Mem64, MCK_ImmSExti64i8 }, },
  { 1154 /* cmp */, X86::CMP64mi32, Convert__Mem645_0__ImmSExti64i321_1, 0, { MCK_Mem64, MCK_ImmSExti64i32 }, },
  { 1154 /* cmp */, X86::CMP8mr, Convert__Mem85_0__Reg1_1, 0, { MCK_Mem8, MCK_GR8 }, },
  { 1154 /* cmp */, X86::CMP8mi, Convert__Mem85_0__Imm1_1, 0, { MCK_Mem8, MCK_Imm }, },
  { 1154 /* cmp */, X86::CMPPDrri, Convert__Reg1_2__Tie0__Reg1_3__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_FR32, MCK_FR32 }, },
  { 1154 /* cmp */, X86::CMPPDrmi, Convert__Reg1_2__Tie0__Mem1285_3__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_FR32, MCK_Mem128 }, },
  { 1154 /* cmp */, X86::CMPPSrri, Convert__Reg1_2__Tie0__Reg1_3__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_FR32, MCK_FR32 }, },
  { 1154 /* cmp */, X86::CMPPSrmi, Convert__Reg1_2__Tie0__Mem1285_3__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_FR32, MCK_Mem128 }, },
  { 1154 /* cmp */, X86::CMPSDrr, Convert__Reg1_2__Tie0__Reg1_3__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_FR32, MCK_FR32 }, },
  { 1154 /* cmp */, X86::CMPSDrm, Convert__Reg1_2__Tie0__Mem645_3__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_FR32, MCK_Mem64 }, },
  { 1154 /* cmp */, X86::CMPSSrr, Convert__Reg1_2__Tie0__Reg1_3__Imm1_0, 0, { MCK_Imm, MCK_SS, MCK_FR32, MCK_FR32 }, },
  { 1154 /* cmp */, X86::CMPSSrm, Convert__Reg1_2__Tie0__Mem325_3__Imm1_0, 0, { MCK_Imm, MCK_SS, MCK_FR32, MCK_Mem32 }, },
  { 1168 /* cmppd */, X86::CMPPDrri_alt, Convert__Reg1_0__Tie0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 1168 /* cmppd */, X86::CMPPDrmi_alt, Convert__Reg1_0__Tie0__Mem1285_1__Imm1_2, 0, { MCK_FR32, MCK_Mem128, MCK_Imm }, },
  { 1174 /* cmpps */, X86::CMPPSrri_alt, Convert__Reg1_0__Tie0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 1174 /* cmpps */, X86::CMPPSrmi_alt, Convert__Reg1_0__Tie0__Mem1285_1__Imm1_2, 0, { MCK_FR32, MCK_Mem128, MCK_Imm }, },
  { 1185 /* cmpsb */, X86::CMPSB, Convert__DstIdx81_1__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_DstIdx8 }, },
  { 1191 /* cmpsd */, X86::CMPSL, Convert__DstIdx321_1__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_DstIdx32 }, },
  { 1191 /* cmpsd */, X86::CMPSDrr_alt, Convert__Reg1_0__Tie0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 1191 /* cmpsd */, X86::CMPSDrm_alt, Convert__Reg1_0__Tie0__Mem645_1__Imm1_2, 0, { MCK_FR32, MCK_Mem64, MCK_Imm }, },
  { 1203 /* cmpsq */, X86::CMPSQ, Convert__DstIdx641_1__SrcIdx642_0, 0, { MCK_SrcIdx64, MCK_DstIdx64 }, },
  { 1209 /* cmpss */, X86::CMPSSrr_alt, Convert__Reg1_0__Tie0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 1209 /* cmpss */, X86::CMPSSrm_alt, Convert__Reg1_0__Tie0__Mem325_1__Imm1_2, 0, { MCK_FR32, MCK_Mem32, MCK_Imm }, },
  { 1215 /* cmpsw */, X86::CMPSW, Convert__DstIdx161_1__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_DstIdx16 }, },
  { 1226 /* cmpxchg */, X86::CMPXCHG8rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR8, MCK_GR8 }, },
  { 1226 /* cmpxchg */, X86::CMPXCHG16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 1226 /* cmpxchg */, X86::CMPXCHG32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 1226 /* cmpxchg */, X86::CMPXCHG64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 1226 /* cmpxchg */, X86::CMPXCHG16rm, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1226 /* cmpxchg */, X86::CMPXCHG32rm, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1226 /* cmpxchg */, X86::CMPXCHG64rm, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1226 /* cmpxchg */, X86::CMPXCHG8rm, Convert__Mem85_0__Reg1_1, 0, { MCK_Mem8, MCK_GR8 }, },
  { 1234 /* cmpxchg16b */, X86::CMPXCHG16B, Convert__Mem1285_0, 0, { MCK_Mem128 }, },
  { 1245 /* cmpxchg8b */, X86::CMPXCHG8B, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1291 /* comisd */, X86::COMISDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1291 /* comisd */, X86::COMISDrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 1298 /* comiss */, X86::COMISSrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1298 /* comiss */, X86::COMISSrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 1305 /* cpuid */, X86::CPUID32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 1305 /* cpuid */, X86::CPUID64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 1311 /* cqo */, X86::CQO, Convert_NoOperands, 0, {  }, },
  { 1320 /* crc32 */, X86::CRC32r32r8, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR8 }, },
  { 1320 /* crc32 */, X86::CRC32r32r16, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR16 }, },
  { 1320 /* crc32 */, X86::CRC32r32r32, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 1320 /* crc32 */, X86::CRC32r32m16, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR32, MCK_Mem16 }, },
  { 1320 /* crc32 */, X86::CRC32r32m32, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1320 /* crc32 */, X86::CRC32r32m8, Convert__Reg1_0__Tie0__Mem85_1, 0, { MCK_GR32, MCK_Mem8 }, },
  { 1320 /* crc32 */, X86::CRC32r64r8, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR8 }, },
  { 1320 /* crc32 */, X86::CRC32r64r64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 1320 /* crc32 */, X86::CRC32r64m64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1320 /* crc32 */, X86::CRC32r64m8, Convert__Reg1_0__Tie0__Mem85_1, 0, { MCK_GR64, MCK_Mem8 }, },
  { 1354 /* cs */, X86::CS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1357 /* cvtdq2pd */, X86::CVTDQ2PDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1357 /* cvtdq2pd */, X86::CVTDQ2PDrm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 1366 /* cvtdq2ps */, X86::CVTDQ2PSrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1366 /* cvtdq2ps */, X86::CVTDQ2PSrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 1375 /* cvtpd2dq */, X86::CVTPD2DQrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1375 /* cvtpd2dq */, X86::CVTPD2DQrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 1384 /* cvtpd2pi */, X86::MMX_CVTPD2PIirr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_FR32 }, },
  { 1384 /* cvtpd2pi */, X86::MMX_CVTPD2PIirm, Convert__Reg1_0__Mem1285_1, 0, { MCK_VR64, MCK_Mem128 }, },
  { 1393 /* cvtpd2ps */, X86::CVTPD2PSrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1393 /* cvtpd2ps */, X86::CVTPD2PSrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 1402 /* cvtpi2pd */, X86::MMX_CVTPI2PDirr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_VR64 }, },
  { 1402 /* cvtpi2pd */, X86::MMX_CVTPI2PDirm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 1411 /* cvtpi2ps */, X86::MMX_CVTPI2PSirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_VR64 }, },
  { 1411 /* cvtpi2ps */, X86::MMX_CVTPI2PSirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 1420 /* cvtps2dq */, X86::CVTPS2DQrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1420 /* cvtps2dq */, X86::CVTPS2DQrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 1429 /* cvtps2pd */, X86::CVTPS2PDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1429 /* cvtps2pd */, X86::CVTPS2PDrm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 1438 /* cvtps2pi */, X86::MMX_CVTPS2PIirr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_FR32 }, },
  { 1438 /* cvtps2pi */, X86::MMX_CVTPS2PIirm, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 1447 /* cvtsd2si */, X86::CVTSD2SIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_FR32 }, },
  { 1447 /* cvtsd2si */, X86::CVTSD2SIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_FR32 }, },
  { 1447 /* cvtsd2si */, X86::CVTSD2SIrm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR32, MCK_Mem64 }, },
  { 1447 /* cvtsd2si */, X86::CVTSD2SIrm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR32, MCK_Mem64 }, },
  { 1447 /* cvtsd2si */, X86::CVTSD2SI64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_FR32 }, },
  { 1447 /* cvtsd2si */, X86::CVTSD2SI64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_FR32 }, },
  { 1447 /* cvtsd2si */, X86::CVTSD2SI64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1447 /* cvtsd2si */, X86::CVTSD2SI64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1476 /* cvtsd2ss */, X86::CVTSD2SSrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1476 /* cvtsd2ss */, X86::CVTSD2SSrm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 1485 /* cvtsi2sd */, X86::CVTSI2SDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_GR32 }, },
  { 1485 /* cvtsi2sd */, X86::CVTSI2SD64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_GR64 }, },
  { 1485 /* cvtsi2sd */, X86::CVTSI2SDrm, Convert__Reg1_0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 1485 /* cvtsi2sd */, X86::CVTSI2SDrm, Convert__Reg1_0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 1485 /* cvtsi2sd */, X86::CVTSI2SD64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 1514 /* cvtsi2ss */, X86::CVTSI2SSrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_GR32 }, },
  { 1514 /* cvtsi2ss */, X86::CVTSI2SS64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_GR64 }, },
  { 1514 /* cvtsi2ss */, X86::CVTSI2SSrm, Convert__Reg1_0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 1514 /* cvtsi2ss */, X86::CVTSI2SSrm, Convert__Reg1_0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 1514 /* cvtsi2ss */, X86::CVTSI2SS64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 1543 /* cvtss2sd */, X86::CVTSS2SDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1543 /* cvtss2sd */, X86::CVTSS2SDrm, Convert__Reg1_0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 1552 /* cvtss2si */, X86::CVTSS2SIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_FR32 }, },
  { 1552 /* cvtss2si */, X86::CVTSS2SIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_FR32 }, },
  { 1552 /* cvtss2si */, X86::CVTSS2SIrm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1552 /* cvtss2si */, X86::CVTSS2SIrm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1552 /* cvtss2si */, X86::CVTSS2SI64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_FR32 }, },
  { 1552 /* cvtss2si */, X86::CVTSS2SI64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_FR32 }, },
  { 1552 /* cvtss2si */, X86::CVTSS2SI64rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR64, MCK_Mem32 }, },
  { 1552 /* cvtss2si */, X86::CVTSS2SI64rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR64, MCK_Mem32 }, },
  { 1581 /* cvttpd2dq */, X86::CVTTPD2DQrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1581 /* cvttpd2dq */, X86::CVTTPD2DQrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 1591 /* cvttpd2pi */, X86::MMX_CVTTPD2PIirr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_FR32 }, },
  { 1591 /* cvttpd2pi */, X86::MMX_CVTTPD2PIirm, Convert__Reg1_0__Mem1285_1, 0, { MCK_VR64, MCK_Mem128 }, },
  { 1601 /* cvttps2dq */, X86::CVTTPS2DQrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1601 /* cvttps2dq */, X86::CVTTPS2DQrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 1611 /* cvttps2pi */, X86::MMX_CVTTPS2PIirr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_FR32 }, },
  { 1611 /* cvttps2pi */, X86::MMX_CVTTPS2PIirm, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 1621 /* cvttsd2si */, X86::CVTTSD2SIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_FR32 }, },
  { 1621 /* cvttsd2si */, X86::CVTTSD2SIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_FR32 }, },
  { 1621 /* cvttsd2si */, X86::CVTTSD2SIrm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR32, MCK_Mem64 }, },
  { 1621 /* cvttsd2si */, X86::CVTTSD2SIrm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR32, MCK_Mem64 }, },
  { 1621 /* cvttsd2si */, X86::CVTTSD2SI64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_FR32 }, },
  { 1621 /* cvttsd2si */, X86::CVTTSD2SI64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_FR32 }, },
  { 1621 /* cvttsd2si */, X86::CVTTSD2SI64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1621 /* cvttsd2si */, X86::CVTTSD2SI64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1653 /* cvttss2si */, X86::CVTTSS2SIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_FR32 }, },
  { 1653 /* cvttss2si */, X86::CVTTSS2SIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_FR32 }, },
  { 1653 /* cvttss2si */, X86::CVTTSS2SIrm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1653 /* cvttss2si */, X86::CVTTSS2SIrm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1653 /* cvttss2si */, X86::CVTTSS2SI64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_FR32 }, },
  { 1653 /* cvttss2si */, X86::CVTTSS2SI64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_FR32 }, },
  { 1653 /* cvttss2si */, X86::CVTTSS2SI64rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR64, MCK_Mem32 }, },
  { 1653 /* cvttss2si */, X86::CVTTSS2SI64rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR64, MCK_Mem32 }, },
  { 1685 /* cwd */, X86::CWD, Convert_NoOperands, 0, {  }, },
  { 1689 /* cwde */, X86::CWDE, Convert_NoOperands, 0, {  }, },
  { 1704 /* daa */, X86::DAA, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 1708 /* das */, X86::DAS, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 1712 /* data16 */, X86::DATA16_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1719 /* dec */, X86::DEC8r, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 1719 /* dec */, X86::DEC16r, Convert__Reg1_0__Tie0, Feature_Not64BitMode, { MCK_GR16 }, },
  { 1719 /* dec */, X86::DEC64_16r, Convert__Reg1_0__Tie0, Feature_In64BitMode, { MCK_GR16 }, },
  { 1719 /* dec */, X86::DEC32r, Convert__Reg1_0__Tie0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 1719 /* dec */, X86::DEC64_32r, Convert__Reg1_0__Tie0, Feature_In64BitMode, { MCK_GR32 }, },
  { 1719 /* dec */, X86::DEC64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 1719 /* dec */, X86::DEC16m, Convert__Mem165_0, Feature_Not64BitMode, { MCK_Mem16 }, },
  { 1719 /* dec */, X86::DEC64_16m, Convert__Mem165_0, Feature_In64BitMode, { MCK_Mem16 }, },
  { 1719 /* dec */, X86::DEC32m, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 1719 /* dec */, X86::DEC64_32m, Convert__Mem325_0, Feature_In64BitMode, { MCK_Mem32 }, },
  { 1719 /* dec */, X86::DEC64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1719 /* dec */, X86::DEC8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 1743 /* div */, X86::DIV8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 1743 /* div */, X86::DIV16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 1743 /* div */, X86::DIV32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 1743 /* div */, X86::DIV64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 1743 /* div */, X86::DIV16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 1743 /* div */, X86::DIV32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1743 /* div */, X86::DIV64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1743 /* div */, X86::DIV8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 1743 /* div */, X86::DIV8r, Convert__Reg1_1, 0, { MCK_AL, MCK_GR8 }, },
  { 1743 /* div */, X86::DIV8m, Convert__Mem85_1, 0, { MCK_AL, MCK_Mem8 }, },
  { 1743 /* div */, X86::DIV16r, Convert__Reg1_1, 0, { MCK_AX, MCK_GR16 }, },
  { 1743 /* div */, X86::DIV16m, Convert__Mem165_1, 0, { MCK_AX, MCK_Mem16 }, },
  { 1743 /* div */, X86::DIV32r, Convert__Reg1_1, 0, { MCK_EAX, MCK_GR32 }, },
  { 1743 /* div */, X86::DIV32m, Convert__Mem325_1, 0, { MCK_EAX, MCK_Mem32 }, },
  { 1743 /* div */, X86::DIV64r, Convert__Reg1_1, 0, { MCK_RAX, MCK_GR64 }, },
  { 1743 /* div */, X86::DIV64m, Convert__Mem645_1, 0, { MCK_RAX, MCK_Mem64 }, },
  { 1757 /* divpd */, X86::DIVPDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1757 /* divpd */, X86::DIVPDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 1763 /* divps */, X86::DIVPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1763 /* divps */, X86::DIVPSrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 1774 /* divsd */, X86::DIVSDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1774 /* divsd */, X86::DIVSDrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 1780 /* divss */, X86::DIVSSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1780 /* divss */, X86::DIVSSrm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 1791 /* dppd */, X86::DPPDrri, Convert__Reg1_0__Tie0__Reg1_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_FR32, MCK_ImmZExtu32u8 }, },
  { 1791 /* dppd */, X86::DPPDrmi, Convert__Reg1_0__Tie0__Mem1285_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_Mem128, MCK_ImmZExtu32u8 }, },
  { 1796 /* dpps */, X86::DPPSrri, Convert__Reg1_0__Tie0__Reg1_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_FR32, MCK_ImmZExtu32u8 }, },
  { 1796 /* dpps */, X86::DPPSrmi, Convert__Reg1_0__Tie0__Mem1285_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_Mem128, MCK_ImmZExtu32u8 }, },
  { 1801 /* ds */, X86::DS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1804 /* emms */, X86::MMX_EMMS, Convert_NoOperands, 0, {  }, },
  { 1809 /* enter */, X86::ENTER, Convert__Imm1_0__Imm1_1, 0, { MCK_Imm, MCK_Imm }, },
  { 1815 /* es */, X86::ES_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1818 /* extractps */, X86::EXTRACTPSrr, Convert__GR32orGR641_0__Reg1_1__ImmSExti32i81_2, 0, { MCK_GR32orGR64, MCK_FR32, MCK_ImmSExti32i8 }, },
  { 1818 /* extractps */, X86::EXTRACTPSmr, Convert__Mem325_0__Reg1_1__ImmSExti32i81_2, 0, { MCK_Mem32, MCK_FR32, MCK_ImmSExti32i8 }, },
  { 1828 /* extrq */, X86::EXTRQ, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 1828 /* extrq */, X86::EXTRQI, Convert__Reg1_0__Tie0__Imm1_1__Imm1_2, 0, { MCK_FR32, MCK_Imm, MCK_Imm }, },
  { 1834 /* f2xm1 */, X86::F2XM1, Convert_NoOperands, 0, {  }, },
  { 1840 /* fabs */, X86::ABS_F, Convert_NoOperands, 0, {  }, },
  { 1845 /* fadd */, X86::ADD_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1845 /* fadd */, X86::ADD_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1845 /* fadd */, X86::ADD_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1845 /* fadd */, X86::ADD_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 1845 /* fadd */, X86::ADD_FST0r, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1845 /* fadd */, X86::ADD_FrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1856 /* faddp */, X86::ADD_FPrST0, Convert__regST1, 0, {  }, },
  { 1856 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1856 /* faddp */, X86::ADD_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 1856 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1856 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1868 /* fbld */, X86::FBLDm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1873 /* fbstp */, X86::FBSTPm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1879 /* fchs */, X86::CHS_F, Convert_NoOperands, 0, {  }, },
  { 1884 /* fcmovb */, X86::CMOVB_F, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1891 /* fcmovbe */, X86::CMOVBE_F, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1899 /* fcmove */, X86::CMOVE_F, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1906 /* fcmovnb */, X86::CMOVNB_F, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1914 /* fcmovnbe */, X86::CMOVNBE_F, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1923 /* fcmovne */, X86::CMOVNE_F, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1931 /* fcmovnu */, X86::CMOVNP_F, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1939 /* fcmovu */, X86::CMOVP_F, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1946 /* fcom */, X86::COM_FST0r, Convert__regST1, 0, {  }, },
  { 1946 /* fcom */, X86::COM_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1946 /* fcom */, X86::FCOM32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1946 /* fcom */, X86::FCOM64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1951 /* fcomi */, X86::COM_FIr, Convert__regST1, 0, {  }, },
  { 1951 /* fcomi */, X86::COM_FIr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1951 /* fcomi */, X86::COM_FIr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 1951 /* fcomi */, X86::COM_FIr, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1963 /* fcomp */, X86::COMP_FST0r, Convert__regST1, 0, {  }, },
  { 1963 /* fcomp */, X86::COMP_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1963 /* fcomp */, X86::FCOMP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1963 /* fcomp */, X86::FCOMP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1969 /* fcompi */, X86::COM_FIPr, Convert__regST1, 0, {  }, },
  { 1969 /* fcompi */, X86::COM_FIPr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1969 /* fcompi */, X86::COM_FIPr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 1969 /* fcompi */, X86::COM_FIPr, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1983 /* fcompp */, X86::FCOMPP, Convert_NoOperands, 0, {  }, },
  { 2003 /* fcos */, X86::COS_F, Convert_NoOperands, 0, {  }, },
  { 2008 /* fdecstp */, X86::FDECSTP, Convert_NoOperands, 0, {  }, },
  { 2016 /* fdiv */, X86::DIV_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2016 /* fdiv */, X86::DIV_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2016 /* fdiv */, X86::DIV_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2016 /* fdiv */, X86::DIV_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2016 /* fdiv */, X86::DIV_FST0r, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2016 /* fdiv */, X86::DIV_FrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2027 /* fdivp */, X86::DIV_FPrST0, Convert__regST1, 0, {  }, },
  { 2027 /* fdivp */, X86::DIV_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2027 /* fdivp */, X86::DIV_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2027 /* fdivp */, X86::DIV_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2027 /* fdivp */, X86::DIV_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2033 /* fdivr */, X86::DIVR_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2033 /* fdivr */, X86::DIVR_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2033 /* fdivr */, X86::DIVR_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2033 /* fdivr */, X86::DIVR_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2033 /* fdivr */, X86::DIVR_FST0r, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2033 /* fdivr */, X86::DIVR_FrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2046 /* fdivrp */, X86::DIVR_FPrST0, Convert__regST1, 0, {  }, },
  { 2046 /* fdivrp */, X86::DIVR_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2046 /* fdivrp */, X86::DIVR_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2046 /* fdivrp */, X86::DIVR_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2046 /* fdivrp */, X86::DIVR_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2066 /* femms */, X86::FEMMS, Convert_NoOperands, 0, {  }, },
  { 2072 /* ffree */, X86::FFREE, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2078 /* fiadd */, X86::ADD_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2078 /* fiadd */, X86::ADD_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2098 /* ficom */, X86::FICOM16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2098 /* ficom */, X86::FICOM32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2111 /* ficomp */, X86::FICOMP16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2111 /* ficomp */, X86::FICOMP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2141 /* fidiv */, X86::DIV_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2141 /* fidiv */, X86::DIV_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2154 /* fidivr */, X86::DIVR_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2154 /* fidivr */, X86::DIVR_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2184 /* fild */, X86::ILD_F16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2184 /* fild */, X86::ILD_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2184 /* fild */, X86::ILD_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2208 /* fimul */, X86::MUL_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2208 /* fimul */, X86::MUL_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2228 /* fincstp */, X86::FINCSTP, Convert_NoOperands, 0, {  }, },
  { 2236 /* fist */, X86::IST_F16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2236 /* fist */, X86::IST_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2247 /* fistp */, X86::IST_FP16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2247 /* fistp */, X86::IST_FP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2247 /* fistp */, X86::IST_FP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2281 /* fisttp */, X86::ISTT_FP16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2281 /* fisttp */, X86::ISTT_FP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2281 /* fisttp */, X86::ISTT_FP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2313 /* fisub */, X86::SUB_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2313 /* fisub */, X86::SUB_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2326 /* fisubr */, X86::SUBR_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2326 /* fisubr */, X86::SUBR_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2356 /* fld */, X86::LD_Frr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2356 /* fld */, X86::LD_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2356 /* fld */, X86::LD_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2356 /* fld */, X86::LD_F80m, Convert__Mem805_0, 0, { MCK_Mem80 }, },
  { 2360 /* fld1 */, X86::LD_F1, Convert_NoOperands, 0, {  }, },
  { 2365 /* fldcw */, X86::FLDCW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2371 /* fldenv */, X86::FLDENVm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2383 /* fldl2e */, X86::FLDL2E, Convert_NoOperands, 0, {  }, },
  { 2390 /* fldl2t */, X86::FLDL2T, Convert_NoOperands, 0, {  }, },
  { 2397 /* fldlg2 */, X86::FLDLG2, Convert_NoOperands, 0, {  }, },
  { 2404 /* fldln2 */, X86::FLDLN2, Convert_NoOperands, 0, {  }, },
  { 2411 /* fldpi */, X86::FLDPI, Convert_NoOperands, 0, {  }, },
  { 2427 /* fldz */, X86::LD_F0, Convert_NoOperands, 0, {  }, },
  { 2432 /* fmul */, X86::MUL_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2432 /* fmul */, X86::MUL_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2432 /* fmul */, X86::MUL_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2432 /* fmul */, X86::MUL_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2432 /* fmul */, X86::MUL_FST0r, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2432 /* fmul */, X86::MUL_FrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2443 /* fmulp */, X86::MUL_FPrST0, Convert__regST1, 0, {  }, },
  { 2443 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2443 /* fmulp */, X86::MUL_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2443 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2443 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2455 /* fnclex */, X86::FNCLEX, Convert_NoOperands, 0, {  }, },
  { 2462 /* fninit */, X86::FNINIT, Convert_NoOperands, 0, {  }, },
  { 2469 /* fnop */, X86::FNOP, Convert_NoOperands, 0, {  }, },
  { 2474 /* fnsave */, X86::FSAVEm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2481 /* fnstcw */, X86::FNSTCW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2488 /* fnstenv */, X86::FSTENVm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2496 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, {  }, },
  { 2496 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, { MCK_AL }, },
  { 2496 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, { MCK_AX }, },
  { 2496 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, { MCK_EAX }, },
  { 2496 /* fnstsw */, X86::FNSTSWm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2503 /* fpatan */, X86::FPATAN, Convert_NoOperands, 0, {  }, },
  { 2510 /* fprem */, X86::FPREM, Convert_NoOperands, 0, {  }, },
  { 2516 /* fprem1 */, X86::FPREM1, Convert_NoOperands, 0, {  }, },
  { 2523 /* fptan */, X86::FPTAN, Convert_NoOperands, 0, {  }, },
  { 2529 /* frndint */, X86::FRNDINT, Convert_NoOperands, 0, {  }, },
  { 2537 /* frstor */, X86::FRSTORm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2544 /* fs */, X86::FS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 2547 /* fscale */, X86::FSCALE, Convert_NoOperands, 0, {  }, },
  { 2554 /* fsin */, X86::SIN_F, Convert_NoOperands, 0, {  }, },
  { 2559 /* fsincos */, X86::FSINCOS, Convert_NoOperands, 0, {  }, },
  { 2567 /* fsqrt */, X86::SQRT_F, Convert_NoOperands, 0, {  }, },
  { 2573 /* fst */, X86::ST_Frr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2573 /* fst */, X86::ST_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2573 /* fst */, X86::ST_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2582 /* fstp */, X86::ST_FPrr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2582 /* fstp */, X86::ST_FP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2582 /* fstp */, X86::ST_FP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2582 /* fstp */, X86::ST_FP80m, Convert__Mem805_0, 0, { MCK_Mem80 }, },
  { 2610 /* fsub */, X86::SUB_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2610 /* fsub */, X86::SUB_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2610 /* fsub */, X86::SUB_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2610 /* fsub */, X86::SUB_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2610 /* fsub */, X86::SUB_FST0r, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2610 /* fsub */, X86::SUB_FrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2621 /* fsubp */, X86::SUB_FPrST0, Convert__regST1, 0, {  }, },
  { 2621 /* fsubp */, X86::SUB_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2621 /* fsubp */, X86::SUB_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2621 /* fsubp */, X86::SUB_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2621 /* fsubp */, X86::SUB_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2627 /* fsubr */, X86::SUBR_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2627 /* fsubr */, X86::SUBR_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2627 /* fsubr */, X86::SUBR_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2627 /* fsubr */, X86::SUBR_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2627 /* fsubr */, X86::SUBR_FST0r, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2627 /* fsubr */, X86::SUBR_FrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2640 /* fsubrp */, X86::SUBR_FPrST0, Convert__regST1, 0, {  }, },
  { 2640 /* fsubrp */, X86::SUBR_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2640 /* fsubrp */, X86::SUBR_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2640 /* fsubrp */, X86::SUBR_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2640 /* fsubrp */, X86::SUBR_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2660 /* ftst */, X86::TST_F, Convert_NoOperands, 0, {  }, },
  { 2665 /* fucom */, X86::UCOM_Fr, Convert__regST1, 0, {  }, },
  { 2665 /* fucom */, X86::UCOM_Fr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2671 /* fucomi */, X86::UCOM_FIr, Convert__regST1, 0, {  }, },
  { 2671 /* fucomi */, X86::UCOM_FIr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2671 /* fucomi */, X86::UCOM_FIr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2671 /* fucomi */, X86::UCOM_FIr, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2678 /* fucomp */, X86::UCOM_FPr, Convert__regST1, 0, {  }, },
  { 2678 /* fucomp */, X86::UCOM_FPr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2685 /* fucompi */, X86::UCOM_FIPr, Convert__regST1, 0, {  }, },
  { 2685 /* fucompi */, X86::UCOM_FIPr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2685 /* fucompi */, X86::UCOM_FIPr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2685 /* fucompi */, X86::UCOM_FIPr, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2693 /* fucompp */, X86::UCOM_FPPr, Convert_NoOperands, 0, {  }, },
  { 2701 /* fxam */, X86::FXAM, Convert_NoOperands, 0, {  }, },
  { 2706 /* fxch */, X86::XCH_F, Convert__regST1, 0, {  }, },
  { 2706 /* fxch */, X86::XCH_F, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2711 /* fxrstor */, X86::FXRSTOR, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 2719 /* fxrstor64 */, X86::FXRSTOR64, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 2738 /* fxsave */, X86::FXSAVE, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 2745 /* fxsave64 */, X86::FXSAVE64, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 2762 /* fxtract */, X86::FXTRACT, Convert_NoOperands, 0, {  }, },
  { 2770 /* fyl2x */, X86::FYL2X, Convert_NoOperands, 0, {  }, },
  { 2776 /* fyl2xp1 */, X86::FYL2XP1, Convert_NoOperands, 0, {  }, },
  { 2784 /* gs */, X86::GS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 2787 /* haddpd */, X86::HADDPDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 2787 /* haddpd */, X86::HADDPDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 2794 /* haddps */, X86::HADDPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 2794 /* haddps */, X86::HADDPSrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 2801 /* hlt */, X86::HLT, Convert_NoOperands, 0, {  }, },
  { 2805 /* hsubpd */, X86::HSUBPDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 2805 /* hsubpd */, X86::HSUBPDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 2812 /* hsubps */, X86::HSUBPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 2812 /* hsubps */, X86::HSUBPSrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 2819 /* idiv */, X86::IDIV8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 2819 /* idiv */, X86::IDIV16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 2819 /* idiv */, X86::IDIV32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 2819 /* idiv */, X86::IDIV64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 2819 /* idiv */, X86::IDIV16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2819 /* idiv */, X86::IDIV32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2819 /* idiv */, X86::IDIV64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2819 /* idiv */, X86::IDIV8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 2819 /* idiv */, X86::IDIV8r, Convert__Reg1_1, 0, { MCK_AL, MCK_GR8 }, },
  { 2819 /* idiv */, X86::IDIV8m, Convert__Mem85_1, 0, { MCK_AL, MCK_Mem8 }, },
  { 2819 /* idiv */, X86::IDIV16r, Convert__Reg1_1, 0, { MCK_AX, MCK_GR16 }, },
  { 2819 /* idiv */, X86::IDIV16m, Convert__Mem165_1, 0, { MCK_AX, MCK_Mem16 }, },
  { 2819 /* idiv */, X86::IDIV32r, Convert__Reg1_1, 0, { MCK_EAX, MCK_GR32 }, },
  { 2819 /* idiv */, X86::IDIV32m, Convert__Mem325_1, 0, { MCK_EAX, MCK_Mem32 }, },
  { 2819 /* idiv */, X86::IDIV64r, Convert__Reg1_1, 0, { MCK_RAX, MCK_GR64 }, },
  { 2819 /* idiv */, X86::IDIV64m, Convert__Mem645_1, 0, { MCK_RAX, MCK_Mem64 }, },
  { 2848 /* imul */, X86::IMUL8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 2848 /* imul */, X86::IMUL16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 2848 /* imul */, X86::IMUL32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 2848 /* imul */, X86::IMUL64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 2848 /* imul */, X86::IMUL16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2848 /* imul */, X86::IMUL32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2848 /* imul */, X86::IMUL64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2848 /* imul */, X86::IMUL8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 2848 /* imul */, X86::IMUL16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 2848 /* imul */, X86::IMUL16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 2848 /* imul */, X86::IMUL32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 2848 /* imul */, X86::IMUL32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 2848 /* imul */, X86::IMUL64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 2848 /* imul */, X86::IMUL64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 2848 /* imul */, X86::IMUL16rri8, Convert__Reg1_0__Reg1_1__ImmSExti16i81_2, 0, { MCK_GR16, MCK_GR16, MCK_ImmSExti16i8 }, },
  { 2848 /* imul */, X86::IMUL16rri, Convert__Reg1_0__Reg1_1__Imm1_2, 0, { MCK_GR16, MCK_GR16, MCK_Imm }, },
  { 2848 /* imul */, X86::IMUL16rmi8, Convert__Reg1_0__Mem165_1__ImmSExti16i81_2, 0, { MCK_GR16, MCK_Mem16, MCK_ImmSExti16i8 }, },
  { 2848 /* imul */, X86::IMUL16rmi, Convert__Reg1_0__Mem165_1__Imm1_2, 0, { MCK_GR16, MCK_Mem16, MCK_Imm }, },
  { 2848 /* imul */, X86::IMUL32rri8, Convert__Reg1_0__Reg1_1__ImmSExti32i81_2, 0, { MCK_GR32, MCK_GR32, MCK_ImmSExti32i8 }, },
  { 2848 /* imul */, X86::IMUL32rri, Convert__Reg1_0__Reg1_1__Imm1_2, 0, { MCK_GR32, MCK_GR32, MCK_Imm }, },
  { 2848 /* imul */, X86::IMUL32rmi8, Convert__Reg1_0__Mem325_1__ImmSExti32i81_2, 0, { MCK_GR32, MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 2848 /* imul */, X86::IMUL32rmi, Convert__Reg1_0__Mem325_1__Imm1_2, 0, { MCK_GR32, MCK_Mem32, MCK_Imm }, },
  { 2848 /* imul */, X86::IMUL64rri8, Convert__Reg1_0__Reg1_1__ImmSExti64i81_2, 0, { MCK_GR64, MCK_GR64, MCK_ImmSExti64i8 }, },
  { 2848 /* imul */, X86::IMUL64rri32, Convert__Reg1_0__Reg1_1__ImmSExti64i321_2, 0, { MCK_GR64, MCK_GR64, MCK_ImmSExti64i32 }, },
  { 2848 /* imul */, X86::IMUL64rmi8, Convert__Reg1_0__Mem645_1__ImmSExti64i81_2, 0, { MCK_GR64, MCK_Mem64, MCK_ImmSExti64i8 }, },
  { 2848 /* imul */, X86::IMUL64rmi32, Convert__Reg1_0__Mem645_1__ImmSExti64i321_2, 0, { MCK_GR64, MCK_Mem64, MCK_ImmSExti64i32 }, },
  { 2859 /* imull */, X86::IMUL32rri8, Convert__Reg1_1__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 2859 /* imull */, X86::IMUL32rri, Convert__Reg1_1__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 2865 /* imulq */, X86::IMUL64rri8, Convert__Reg1_1__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 2865 /* imulq */, X86::IMUL64rri32, Convert__Reg1_1__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 2871 /* imulw */, X86::IMUL16rri8, Convert__Reg1_1__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 2871 /* imulw */, X86::IMUL16rri, Convert__Reg1_1__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 2877 /* in */, X86::IN8rr, Convert_NoOperands, 0, { MCK_AL, MCK_DX }, },
  { 2877 /* in */, X86::IN8ri, Convert__Imm1_1, 0, { MCK_AL, MCK_Imm }, },
  { 2877 /* in */, X86::IN16rr, Convert_NoOperands, 0, { MCK_AX, MCK_DX }, },
  { 2877 /* in */, X86::IN16ri, Convert__Imm1_1, 0, { MCK_AX, MCK_Imm }, },
  { 2877 /* in */, X86::IN32rr, Convert_NoOperands, 0, { MCK_EAX, MCK_DX }, },
  { 2877 /* in */, X86::IN32ri, Convert__Imm1_1, 0, { MCK_EAX, MCK_Imm }, },
  { 2880 /* inb */, X86::IN8rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 2880 /* inb */, X86::IN8ri, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 2884 /* inc */, X86::INC8r, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 2884 /* inc */, X86::INC16r, Convert__Reg1_0__Tie0, Feature_Not64BitMode, { MCK_GR16 }, },
  { 2884 /* inc */, X86::INC64_16r, Convert__Reg1_0__Tie0, Feature_In64BitMode, { MCK_GR16 }, },
  { 2884 /* inc */, X86::INC32r, Convert__Reg1_0__Tie0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 2884 /* inc */, X86::INC64_32r, Convert__Reg1_0__Tie0, Feature_In64BitMode, { MCK_GR32 }, },
  { 2884 /* inc */, X86::INC64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 2884 /* inc */, X86::INC16m, Convert__Mem165_0, Feature_Not64BitMode, { MCK_Mem16 }, },
  { 2884 /* inc */, X86::INC64_16m, Convert__Mem165_0, Feature_In64BitMode, { MCK_Mem16 }, },
  { 2884 /* inc */, X86::INC32m, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 2884 /* inc */, X86::INC64_32m, Convert__Mem325_0, Feature_In64BitMode, { MCK_Mem32 }, },
  { 2884 /* inc */, X86::INC64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2884 /* inc */, X86::INC8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 2908 /* inl */, X86::IN32rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 2908 /* inl */, X86::IN32ri, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 2912 /* insb */, X86::INSB, Convert__DstIdx81_0, 0, { MCK_DstIdx8, MCK_DX }, },
  { 2917 /* insd */, X86::INSL, Convert__DstIdx321_0, 0, { MCK_DstIdx32, MCK_DX }, },
  { 2922 /* insertps */, X86::INSERTPSrr, Convert__Reg1_0__Tie0__Reg1_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_FR32, MCK_ImmZExtu32u8 }, },
  { 2922 /* insertps */, X86::INSERTPSrm, Convert__Reg1_0__Tie0__Mem325_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_Mem32, MCK_ImmZExtu32u8 }, },
  { 2931 /* insertq */, X86::INSERTQ, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 2931 /* insertq */, X86::INSERTQI, Convert__Reg1_0__Tie0__Reg1_1__Imm1_2__Imm1_3, 0, { MCK_FR32, MCK_FR32, MCK_Imm, MCK_Imm }, },
  { 2944 /* insw */, X86::INSW, Convert__DstIdx161_0, 0, { MCK_DstIdx16, MCK_DX }, },
  { 2949 /* int */, X86::INT, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 2953 /* int3 */, X86::INT3, Convert_NoOperands, 0, {  }, },
  { 2958 /* into */, X86::INTO, Convert_NoOperands, 0, {  }, },
  { 2963 /* invd */, X86::INVD, Convert_NoOperands, 0, {  }, },
  { 2968 /* invept */, X86::INVEPT32, Convert__Reg1_0__Mem1285_1, Feature_Not64BitMode, { MCK_GR32, MCK_Mem128 }, },
  { 2968 /* invept */, X86::INVEPT64, Convert__Reg1_0__Mem1285_1, Feature_In64BitMode, { MCK_GR64, MCK_Mem128 }, },
  { 2975 /* invlpg */, X86::INVLPG, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 2982 /* invlpga */, X86::INVLPGA32, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX, MCK_ECX }, },
  { 2982 /* invlpga */, X86::INVLPGA64, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX, MCK_ECX }, },
  { 2990 /* invpcid */, X86::INVPCID32, Convert__Reg1_0__Mem1285_1, Feature_Not64BitMode, { MCK_GR32, MCK_Mem128 }, },
  { 2990 /* invpcid */, X86::INVPCID64, Convert__Reg1_0__Mem1285_1, Feature_In64BitMode, { MCK_GR64, MCK_Mem128 }, },
  { 2998 /* invvpid */, X86::INVVPID32, Convert__Reg1_0__Mem1285_1, Feature_Not64BitMode, { MCK_GR32, MCK_Mem128 }, },
  { 2998 /* invvpid */, X86::INVVPID64, Convert__Reg1_0__Mem1285_1, Feature_In64BitMode, { MCK_GR64, MCK_Mem128 }, },
  { 3006 /* inw */, X86::IN16rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 3006 /* inw */, X86::IN16ri, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 3010 /* iret */, X86::IRET16, Convert_NoOperands, 0, {  }, },
  { 3015 /* iretd */, X86::IRET32, Convert_NoOperands, 0, {  }, },
  { 3027 /* iretq */, X86::IRET64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 3039 /* ja */, X86::JA_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3039 /* ja */, X86::JA_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3039 /* ja */, X86::JA_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3042 /* jae */, X86::JAE_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3042 /* jae */, X86::JAE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3042 /* jae */, X86::JAE_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3046 /* jb */, X86::JB_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3046 /* jb */, X86::JB_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3046 /* jb */, X86::JB_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3049 /* jbe */, X86::JBE_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3049 /* jbe */, X86::JBE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3049 /* jbe */, X86::JBE_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3053 /* jcxz */, X86::JCXZ, Convert__AbsMem1_0, Feature_Not64BitMode, { MCK_AbsMem }, },
  { 3058 /* je */, X86::JE_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3058 /* je */, X86::JE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3058 /* je */, X86::JE_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3061 /* jecxz */, X86::JECXZ_32, Convert__AbsMem1_0, Feature_Not64BitMode, { MCK_AbsMem }, },
  { 3061 /* jecxz */, X86::JECXZ_64, Convert__AbsMem1_0, Feature_In64BitMode, { MCK_AbsMem }, },
  { 3067 /* jg */, X86::JG_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3067 /* jg */, X86::JG_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3067 /* jg */, X86::JG_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3070 /* jge */, X86::JGE_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3070 /* jge */, X86::JGE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3070 /* jge */, X86::JGE_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3074 /* jl */, X86::JL_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3074 /* jl */, X86::JL_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3074 /* jl */, X86::JL_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3077 /* jle */, X86::JLE_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3077 /* jle */, X86::JLE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3077 /* jle */, X86::JLE_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3081 /* jmp */, X86::JMP16r, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR16 }, },
  { 3081 /* jmp */, X86::JMP32r, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 3081 /* jmp */, X86::JMP64r, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 3081 /* jmp */, X86::JMP_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3081 /* jmp */, X86::JMP_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3081 /* jmp */, X86::JMP_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3081 /* jmp */, X86::JMP16m, Convert__Mem165_0, Feature_Not64BitMode, { MCK_Mem16 }, },
  { 3081 /* jmp */, X86::JMP32m, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 3081 /* jmp */, X86::JMP64m, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 3081 /* jmp */, X86::JMP64m, Convert__Mem165_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3081 /* jmp */, X86::JMP32m, Convert__Mem165_1, Feature_In32BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3081 /* jmp */, X86::JMP16m, Convert__Mem165_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3081 /* jmp */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3081 /* jmp */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, Feature_Not16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3085 /* jmpl */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 3095 /* jmpw */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 3100 /* jne */, X86::JNE_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3100 /* jne */, X86::JNE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3100 /* jne */, X86::JNE_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3104 /* jno */, X86::JNO_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3104 /* jno */, X86::JNO_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3104 /* jno */, X86::JNO_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3108 /* jnp */, X86::JNP_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3108 /* jnp */, X86::JNP_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3108 /* jnp */, X86::JNP_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3112 /* jns */, X86::JNS_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3112 /* jns */, X86::JNS_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3112 /* jns */, X86::JNS_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3116 /* jo */, X86::JO_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3116 /* jo */, X86::JO_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3116 /* jo */, X86::JO_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3119 /* jp */, X86::JP_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3119 /* jp */, X86::JP_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3119 /* jp */, X86::JP_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3122 /* jrcxz */, X86::JRCXZ, Convert__AbsMem1_0, Feature_In64BitMode, { MCK_AbsMem }, },
  { 3128 /* js */, X86::JS_2, Convert__AbsMem1_0, Feature_In16BitMode, { MCK_AbsMem }, },
  { 3128 /* js */, X86::JS_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3128 /* js */, X86::JS_4, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3131 /* kandnw */, X86::KANDNWrr, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3138 /* kandw */, X86::KANDWrr, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3144 /* kmovw */, X86::KMOVWrk, Convert__Reg1_0__Reg1_1, Feature_HasAVX512, { MCK_GR32, MCK_VK1 }, },
  { 3144 /* kmovw */, X86::KMOVWkr, Convert__Reg1_0__Reg1_1, Feature_HasAVX512, { MCK_VK1, MCK_GR32 }, },
  { 3144 /* kmovw */, X86::KMOVWkk, Convert__Reg1_0__Reg1_1, Feature_HasAVX512, { MCK_VK1, MCK_VK1 }, },
  { 3144 /* kmovw */, X86::KMOVWkm, Convert__Reg1_0__Mem165_1, Feature_HasAVX512, { MCK_VK1, MCK_Mem16 }, },
  { 3144 /* kmovw */, X86::KMOVWmk, Convert__Mem165_0__Reg1_1, Feature_HasAVX512, { MCK_Mem16, MCK_VK1 }, },
  { 3150 /* knotw */, X86::KNOTWrr, Convert__Reg1_0__Reg1_1, Feature_HasAVX512, { MCK_VK1, MCK_VK1 }, },
  { 3156 /* kortestw */, X86::KORTESTWrr, Convert__Reg1_0__Reg1_1, Feature_HasAVX512, { MCK_VK1, MCK_VK1 }, },
  { 3165 /* korw */, X86::KORWrr, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3170 /* kshiftlw */, X86::KSHIFTLWri, Convert__Reg1_0__Reg1_1__Imm1_2, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_Imm }, },
  { 3179 /* kshiftrw */, X86::KSHIFTRWri, Convert__Reg1_0__Reg1_1__Imm1_2, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_Imm }, },
  { 3188 /* kunpckbw */, X86::KUNPCKBWrr, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3197 /* kxnorw */, X86::KXNORWrr, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3204 /* kxorw */, X86::KXORWrr, Convert__Reg1_0__Reg1_1__Reg1_2, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3210 /* lahf */, X86::LAHF, Convert_NoOperands, 0, {  }, },
  { 3215 /* lar */, X86::LAR16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 3215 /* lar */, X86::LAR16rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 3215 /* lar */, X86::LAR32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 3215 /* lar */, X86::LAR32rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR32, MCK_Mem16 }, },
  { 3215 /* lar */, X86::LAR64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR32 }, },
  { 3215 /* lar */, X86::LAR64rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR64, MCK_Mem16 }, },
  { 3234 /* lcall */, X86::FARCALL16m, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 3234 /* lcall */, X86::FARCALL32m, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 3234 /* lcall */, X86::FARCALL64, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 3234 /* lcall */, X86::FARCALL32m, Convert__Mem5_1, Feature_Not16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3234 /* lcall */, X86::FARCALL16m, Convert__Mem5_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3234 /* lcall */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, Feature_Not16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3234 /* lcall */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3234 /* lcall */, X86::FARCALL16i, Convert__Imm1_0__Imm1_1, 0, { MCK_Imm, MCK_Imm }, },
  { 3234 /* lcall */, X86::FARCALL32i, Convert__Imm1_0__Imm1_1, 0, { MCK_Imm, MCK_Imm }, },
  { 3261 /* lddqu */, X86::LDDQUrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3267 /* ldmxcsr */, X86::LDMXCSR, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 3275 /* lds */, X86::LDS16rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR16, MCK_Mem }, },
  { 3275 /* lds */, X86::LDS32rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR32, MCK_Mem }, },
  { 3289 /* lea */, X86::LEA16r, Convert__Reg1_0__Mem325_1, 0, { MCK_GR16, MCK_Mem32 }, },
  { 3289 /* lea */, X86::LEA32r, Convert__Reg1_0__Mem325_1, Feature_Not64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 3289 /* lea */, X86::LEA64_32r, Convert__Reg1_0__Mem5_1, Feature_In64BitMode, { MCK_GR32, MCK_Mem }, },
  { 3289 /* lea */, X86::LEA64r, Convert__Reg1_0__Mem5_1, 0, { MCK_GR64, MCK_Mem }, },
  { 3303 /* leave */, X86::LEAVE, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 3303 /* leave */, X86::LEAVE64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 3314 /* les */, X86::LES16rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR16, MCK_Mem }, },
  { 3314 /* les */, X86::LES32rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR32, MCK_Mem }, },
  { 3328 /* lfence */, X86::LFENCE, Convert_NoOperands, 0, {  }, },
  { 3335 /* lfs */, X86::LFS16rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR16, MCK_Mem }, },
  { 3335 /* lfs */, X86::LFS32rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR32, MCK_Mem }, },
  { 3335 /* lfs */, X86::LFS64rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR64, MCK_Mem }, },
  { 3354 /* lgdt */, X86::LGDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3354 /* lgdt */, X86::LGDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3354 /* lgdt */, X86::LGDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 3377 /* lgs */, X86::LGS16rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR16, MCK_Mem }, },
  { 3377 /* lgs */, X86::LGS32rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR32, MCK_Mem }, },
  { 3377 /* lgs */, X86::LGS64rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR64, MCK_Mem }, },
  { 3396 /* lidt */, X86::LIDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3396 /* lidt */, X86::LIDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3396 /* lidt */, X86::LIDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 3419 /* ljmp */, X86::FARJMP16m, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 3419 /* ljmp */, X86::FARJMP32m, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 3419 /* ljmp */, X86::FARJMP64, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 3419 /* ljmp */, X86::FARJMP32m, Convert__Mem5_1, Feature_Not16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3419 /* ljmp */, X86::FARJMP16m, Convert__Mem5_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3419 /* ljmp */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, Feature_Not16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3419 /* ljmp */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3419 /* ljmp */, X86::FARJMP16i, Convert__Imm1_0__Imm1_1, 0, { MCK_Imm, MCK_Imm }, },
  { 3419 /* ljmp */, X86::FARJMP32i, Convert__Imm1_0__Imm1_1, 0, { MCK_Imm, MCK_Imm }, },
  { 3442 /* lldt */, X86::LLDT16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 3442 /* lldt */, X86::LLDT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 3453 /* lmsw */, X86::LMSW16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 3453 /* lmsw */, X86::LMSW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 3464 /* lock */, X86::LOCK_PREFIX, Convert_NoOperands, 0, {  }, },
  { 3469 /* lods */, X86::LODSB, Convert__SrcIdx82_1, 0, { MCK_AL, MCK_SrcIdx8 }, },
  { 3469 /* lods */, X86::LODSW, Convert__SrcIdx162_1, 0, { MCK_AX, MCK_SrcIdx16 }, },
  { 3469 /* lods */, X86::LODSL, Convert__SrcIdx322_1, 0, { MCK_EAX, MCK_SrcIdx32 }, },
  { 3469 /* lods */, X86::LODSQ, Convert__SrcIdx642_1, Feature_In64BitMode, { MCK_RAX, MCK_SrcIdx64 }, },
  { 3474 /* lodsb */, X86::LODSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8 }, },
  { 3474 /* lodsb */, X86::LODSB, Convert__SrcIdx82_1, 0, { MCK_AL, MCK_SrcIdx8 }, },
  { 3480 /* lodsd */, X86::LODSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32 }, },
  { 3480 /* lodsd */, X86::LODSL, Convert__SrcIdx322_1, 0, { MCK_EAX, MCK_SrcIdx32 }, },
  { 3492 /* lodsq */, X86::LODSQ, Convert__SrcIdx642_0, Feature_In64BitMode, { MCK_SrcIdx64 }, },
  { 3492 /* lodsq */, X86::LODSQ, Convert__SrcIdx642_1, 0, { MCK_RAX, MCK_SrcIdx64 }, },
  { 3498 /* lodsw */, X86::LODSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16 }, },
  { 3498 /* lodsw */, X86::LODSW, Convert__SrcIdx162_1, 0, { MCK_AX, MCK_SrcIdx16 }, },
  { 3504 /* loop */, X86::LOOP, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3509 /* loope */, X86::LOOPE, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3515 /* loopne */, X86::LOOPNE, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3540 /* lsl */, X86::LSL16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 3540 /* lsl */, X86::LSL16rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 3540 /* lsl */, X86::LSL32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 3540 /* lsl */, X86::LSL32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 3540 /* lsl */, X86::LSL64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 3540 /* lsl */, X86::LSL64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 3559 /* lss */, X86::LSS16rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR16, MCK_Mem }, },
  { 3559 /* lss */, X86::LSS32rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR32, MCK_Mem }, },
  { 3559 /* lss */, X86::LSS64rm, Convert__Reg1_0__Mem5_1, 0, { MCK_GR64, MCK_Mem }, },
  { 3578 /* ltr */, X86::LTRr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 3578 /* ltr */, X86::LTRm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 3587 /* lzcnt */, X86::LZCNT16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 3587 /* lzcnt */, X86::LZCNT16rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 3587 /* lzcnt */, X86::LZCNT32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 3587 /* lzcnt */, X86::LZCNT32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 3587 /* lzcnt */, X86::LZCNT64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 3587 /* lzcnt */, X86::LZCNT64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 3614 /* maskmovdqu */, X86::MASKMOVDQU, Convert__Reg1_0__Reg1_1, Feature_Not64BitMode, { MCK_FR32, MCK_FR32 }, },
  { 3614 /* maskmovdqu */, X86::MASKMOVDQU64, Convert__Reg1_0__Reg1_1, Feature_In64BitMode, { MCK_FR32, MCK_FR32 }, },
  { 3625 /* maskmovq */, X86::MMX_MASKMOVQ, Convert__Reg1_0__Reg1_1, Feature_Not64BitMode, { MCK_VR64, MCK_VR64 }, },
  { 3625 /* maskmovq */, X86::MMX_MASKMOVQ64, Convert__Reg1_0__Reg1_1, Feature_In64BitMode, { MCK_VR64, MCK_VR64 }, },
  { 3634 /* maxpd */, X86::MAXPDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3634 /* maxpd */, X86::MAXPDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3640 /* maxps */, X86::MAXPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3640 /* maxps */, X86::MAXPSrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3646 /* maxsd */, X86::MAXSDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3646 /* maxsd */, X86::MAXSDrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3652 /* maxss */, X86::MAXSSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3652 /* maxss */, X86::MAXSSrm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 3658 /* mfence */, X86::MFENCE, Convert_NoOperands, 0, {  }, },
  { 3665 /* minpd */, X86::MINPDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3665 /* minpd */, X86::MINPDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3671 /* minps */, X86::MINPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3671 /* minps */, X86::MINPSrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3677 /* minsd */, X86::MINSDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3677 /* minsd */, X86::MINSDrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3683 /* minss */, X86::MINSSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3683 /* minss */, X86::MINSSrm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 3689 /* monitor */, X86::MONITORrrr, Convert_NoOperands, 0, {  }, },
  { 3689 /* monitor */, X86::MONITORrrr, Convert_NoOperands, Feature_Not64BitMode, { MCK_EDX, MCK_ECX, MCK_EAX }, },
  { 3689 /* monitor */, X86::MONITORrrr, Convert_NoOperands, Feature_In64BitMode, { MCK_RDX, MCK_RCX, MCK_RAX }, },
  { 3697 /* montmul */, X86::MONTMUL, Convert_NoOperands, 0, {  }, },
  { 3705 /* mov */, X86::MOV8o8a, Convert__MemOffs82_1, Feature_In32BitMode, { MCK_AL, MCK_MemOffs8 }, },
  { 3705 /* mov */, X86::MOV8o8a_16, Convert__MemOffs82_1, Feature_In16BitMode, { MCK_AL, MCK_MemOffs8 }, },
  { 3705 /* mov */, X86::MOV8rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR8, MCK_GR8 }, },
  { 3705 /* mov */, X86::MOV8ri, Convert__Reg1_0__Imm1_1, 0, { MCK_GR8, MCK_Imm }, },
  { 3705 /* mov */, X86::MOV8rm, Convert__Reg1_0__Mem85_1, 0, { MCK_GR8, MCK_Mem8 }, },
  { 3705 /* mov */, X86::MOV16o16a, Convert__MemOffs162_1, Feature_In32BitMode, { MCK_AX, MCK_MemOffs16 }, },
  { 3705 /* mov */, X86::MOV16o16a_16, Convert__MemOffs162_1, Feature_In16BitMode, { MCK_AX, MCK_MemOffs16 }, },
  { 3705 /* mov */, X86::MOV16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 3705 /* mov */, X86::MOV16rs, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_SEGMENT_REG }, },
  { 3705 /* mov */, X86::MOV16ri, Convert__Reg1_0__Imm1_1, 0, { MCK_GR16, MCK_Imm }, },
  { 3705 /* mov */, X86::MOV16rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 3705 /* mov */, X86::MOV32o32a, Convert__MemOffs322_1, Feature_In32BitMode, { MCK_EAX, MCK_MemOffs32 }, },
  { 3705 /* mov */, X86::MOV32o32a_16, Convert__MemOffs322_1, Feature_In16BitMode, { MCK_EAX, MCK_MemOffs32 }, },
  { 3705 /* mov */, X86::MOV32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 3705 /* mov */, X86::MOV32rs, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_SEGMENT_REG }, },
  { 3705 /* mov */, X86::MOV32rd, Convert__Reg1_0__Reg1_1, Feature_Not64BitMode, { MCK_GR32, MCK_DEBUG_REG }, },
  { 3705 /* mov */, X86::MOV32rc, Convert__Reg1_0__Reg1_1, Feature_Not64BitMode, { MCK_GR32, MCK_CONTROL_REG }, },
  { 3705 /* mov */, X86::MOV32ri, Convert__Reg1_0__Imm1_1, 0, { MCK_GR32, MCK_Imm }, },
  { 3705 /* mov */, X86::MOV32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 3705 /* mov */, X86::MOV64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 3705 /* mov */, X86::MOV64rs, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_SEGMENT_REG }, },
  { 3705 /* mov */, X86::MOV64rd, Convert__Reg1_0__Reg1_1, Feature_In64BitMode, { MCK_GR64, MCK_DEBUG_REG }, },
  { 3705 /* mov */, X86::MOV64rc, Convert__Reg1_0__Reg1_1, Feature_In64BitMode, { MCK_GR64, MCK_CONTROL_REG }, },
  { 3705 /* mov */, X86::MOV64ri32, Convert__Reg1_0__ImmSExti64i321_1, 0, { MCK_GR64, MCK_ImmSExti64i32 }, },
  { 3705 /* mov */, X86::MOV64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 3705 /* mov */, X86::MOV16sr, Convert__Reg1_0__Reg1_1, 0, { MCK_SEGMENT_REG, MCK_GR16 }, },
  { 3705 /* mov */, X86::MOV32sr, Convert__Reg1_0__Reg1_1, 0, { MCK_SEGMENT_REG, MCK_GR32 }, },
  { 3705 /* mov */, X86::MOV64sr, Convert__Reg1_0__Reg1_1, 0, { MCK_SEGMENT_REG, MCK_GR64 }, },
  { 3705 /* mov */, X86::MOV16sm, Convert__Reg1_0__Mem165_1, 0, { MCK_SEGMENT_REG, MCK_Mem16 }, },
  { 3705 /* mov */, X86::MOV32sm, Convert__Reg1_0__Mem325_1, 0, { MCK_SEGMENT_REG, MCK_Mem32 }, },
  { 3705 /* mov */, X86::MOV32ms, Convert__Mem325_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_Mem32 }, },
  { 3705 /* mov */, X86::MOV64sm, Convert__Reg1_0__Mem645_1, 0, { MCK_SEGMENT_REG, MCK_Mem64 }, },
  { 3705 /* mov */, X86::MOV32dr, Convert__Reg1_0__Reg1_1, Feature_Not64BitMode, { MCK_DEBUG_REG, MCK_GR32 }, },
  { 3705 /* mov */, X86::MOV64dr, Convert__Reg1_0__Reg1_1, Feature_In64BitMode, { MCK_DEBUG_REG, MCK_GR64 }, },
  { 3705 /* mov */, X86::MOV32cr, Convert__Reg1_0__Reg1_1, Feature_Not64BitMode, { MCK_CONTROL_REG, MCK_GR32 }, },
  { 3705 /* mov */, X86::MOV64cr, Convert__Reg1_0__Reg1_1, Feature_In64BitMode, { MCK_CONTROL_REG, MCK_GR64 }, },
  { 3705 /* mov */, X86::MOV32sm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_SEGMENT_REG }, },
  { 3705 /* mov */, X86::MOV64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 3705 /* mov */, X86::MOV64ms, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_SEGMENT_REG }, },
  { 3705 /* mov */, X86::MOV64mi32, Convert__Mem645_0__ImmSExti64i321_1, 0, { MCK_Mem64, MCK_ImmSExti64i32 }, },
  { 3705 /* mov */, X86::MOV16ao16, Convert__MemOffs162_0, Feature_In32BitMode, { MCK_MemOffs16, MCK_AX }, },
  { 3705 /* mov */, X86::MOV16ao16_16, Convert__MemOffs162_0, Feature_In16BitMode, { MCK_MemOffs16, MCK_AX }, },
  { 3705 /* mov */, X86::MOV16mr, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 3705 /* mov */, X86::MOV16ms, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_SEGMENT_REG }, },
  { 3705 /* mov */, X86::MOV16mi, Convert__Mem165_0__Imm1_1, 0, { MCK_Mem16, MCK_Imm }, },
  { 3705 /* mov */, X86::MOV32ao32, Convert__MemOffs322_0, Feature_In32BitMode, { MCK_MemOffs32, MCK_EAX }, },
  { 3705 /* mov */, X86::MOV32ao32_16, Convert__MemOffs322_0, Feature_In16BitMode, { MCK_MemOffs32, MCK_EAX }, },
  { 3705 /* mov */, X86::MOV32mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 3705 /* mov */, X86::MOV32ms, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_SEGMENT_REG }, },
  { 3705 /* mov */, X86::MOV32mi, Convert__Mem325_0__Imm1_1, 0, { MCK_Mem32, MCK_Imm }, },
  { 3705 /* mov */, X86::MOV8ao8, Convert__MemOffs82_0, Feature_In32BitMode, { MCK_MemOffs8, MCK_AL }, },
  { 3705 /* mov */, X86::MOV8ao8_16, Convert__MemOffs82_0, Feature_In16BitMode, { MCK_MemOffs8, MCK_AL }, },
  { 3705 /* mov */, X86::MOV8mr, Convert__Mem85_0__Reg1_1, 0, { MCK_Mem8, MCK_GR8 }, },
  { 3705 /* mov */, X86::MOV8mi, Convert__Mem85_0__Imm1_1, 0, { MCK_Mem8, MCK_Imm }, },
  { 3709 /* movabs */, X86::MOV64o8a, Convert__MemOffs82_1, Feature_In64BitMode, { MCK_AL, MCK_MemOffs8 }, },
  { 3709 /* movabs */, X86::MOV64o16a, Convert__MemOffs162_1, Feature_In64BitMode, { MCK_AX, MCK_MemOffs16 }, },
  { 3709 /* movabs */, X86::MOV64o32a, Convert__MemOffs322_1, Feature_In64BitMode, { MCK_EAX, MCK_MemOffs32 }, },
  { 3709 /* movabs */, X86::MOV64o64a, Convert__MemOffs642_1, Feature_In64BitMode, { MCK_RAX, MCK_MemOffs64 }, },
  { 3709 /* movabs */, X86::MOV64ri, Convert__Reg1_0__Imm1_1, 0, { MCK_GR64, MCK_Imm }, },
  { 3709 /* movabs */, X86::MOV64ao16, Convert__MemOffs162_0, Feature_In64BitMode, { MCK_MemOffs16, MCK_AX }, },
  { 3709 /* movabs */, X86::MOV64ao32, Convert__MemOffs322_0, Feature_In64BitMode, { MCK_MemOffs32, MCK_EAX }, },
  { 3709 /* movabs */, X86::MOV64ao64, Convert__MemOffs642_0, Feature_In64BitMode, { MCK_MemOffs64, MCK_RAX }, },
  { 3709 /* movabs */, X86::MOV64ao8, Convert__MemOffs82_0, Feature_In64BitMode, { MCK_MemOffs8, MCK_AL }, },
  { 3748 /* movapd */, X86::MOVAPDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3748 /* movapd */, X86::MOVAPDrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3748 /* movapd */, X86::MOVAPDmr, Convert__Mem1285_0__Reg1_1, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3755 /* movaps */, X86::MOVAPSrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3755 /* movaps */, X86::MOVAPSrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3755 /* movaps */, X86::MOVAPSmr, Convert__Mem1285_0__Reg1_1, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3767 /* movbe */, X86::MOVBE16rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 3767 /* movbe */, X86::MOVBE32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 3767 /* movbe */, X86::MOVBE64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 3767 /* movbe */, X86::MOVBE16mr, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 3767 /* movbe */, X86::MOVBE32mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 3767 /* movbe */, X86::MOVBE64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 3794 /* movd */, X86::MMX_MOVD64grr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_VR64 }, },
  { 3794 /* movd */, X86::MOVPDI2DIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_FR32 }, },
  { 3794 /* movd */, X86::MMX_MOVD64from64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_VR64 }, },
  { 3794 /* movd */, X86::MMX_MOVD64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_GR32 }, },
  { 3794 /* movd */, X86::MMX_MOVD64to64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_GR64 }, },
  { 3794 /* movd */, X86::MMX_MOVD64rm, Convert__Reg1_0__Mem325_1, 0, { MCK_VR64, MCK_Mem32 }, },
  { 3794 /* movd */, X86::MOVDI2PDIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_GR32 }, },
  { 3794 /* movd */, X86::MOVDI2PDIrm, Convert__Reg1_0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 3794 /* movd */, X86::MMX_MOVD64mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_VR64 }, },
  { 3794 /* movd */, X86::MOVPDI2DImr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_FR32 }, },
  { 3799 /* movddup */, X86::MOVDDUPrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3799 /* movddup */, X86::MOVDDUPrm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3807 /* movdq2q */, X86::MMX_MOVDQ2Qrr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_FR32 }, },
  { 3815 /* movdqa */, X86::MOVDQArr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3815 /* movdqa */, X86::MOVDQArm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3815 /* movdqa */, X86::MOVDQAmr, Convert__Mem1285_0__Reg1_1, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3822 /* movdqu */, X86::MOVDQUrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3822 /* movdqu */, X86::MOVDQUrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3822 /* movdqu */, X86::MOVDQUmr, Convert__Mem1285_0__Reg1_1, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3829 /* movhlps */, X86::MOVHLPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3837 /* movhpd */, X86::MOVHPDrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3837 /* movhpd */, X86::MOVHPDmr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3844 /* movhps */, X86::MOVHPSrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3844 /* movhps */, X86::MOVHPSmr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3856 /* movlhps */, X86::MOVLHPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3864 /* movlpd */, X86::MOVLPDrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3864 /* movlpd */, X86::MOVLPDmr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3871 /* movlps */, X86::MOVLPSrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3871 /* movlps */, X86::MOVLPSmr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3878 /* movmskpd */, X86::MOVMSKPDrr, Convert__GR32orGR641_0__Reg1_1, 0, { MCK_GR32orGR64, MCK_FR32 }, },
  { 3887 /* movmskps */, X86::MOVMSKPSrr, Convert__GR32orGR641_0__Reg1_1, 0, { MCK_GR32orGR64, MCK_FR32 }, },
  { 3896 /* movntdq */, X86::MOVNTDQmr, Convert__Mem1285_0__Reg1_1, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3904 /* movntdqa */, X86::MOVNTDQArm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 3913 /* movnti */, X86::MOVNTImr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 3913 /* movnti */, X86::MOVNTI_64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 3936 /* movntpd */, X86::MOVNTPDmr, Convert__Mem1285_0__Reg1_1, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3944 /* movntps */, X86::MOVNTPSmr, Convert__Mem1285_0__Reg1_1, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3952 /* movntq */, X86::MMX_MOVNTQmr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_VR64 }, },
  { 3959 /* movntsd */, X86::MOVNTSD, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3967 /* movntss */, X86::MOVNTSS, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_FR32 }, },
  { 3975 /* movq */, X86::MMX_MOVD64to64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_VR64 }, },
  { 3975 /* movq */, X86::MOVPQIto64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_FR32 }, },
  { 3975 /* movq */, X86::MOVPQIto64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_FR32 }, },
  { 3975 /* movq */, X86::MMX_MOVD64from64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_GR64 }, },
  { 3975 /* movq */, X86::MMX_MOVQ64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 3975 /* movq */, X86::MMX_MOVQ64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 3975 /* movq */, X86::MOV64toPQIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_GR64 }, },
  { 3975 /* movq */, X86::MOV64toPQIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_GR64 }, },
  { 3975 /* movq */, X86::MOVZPQILo2PQIrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 3975 /* movq */, X86::MOVQI2PQIrm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 3975 /* movq */, X86::MOV64ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 3975 /* movq */, X86::MMX_MOVQ64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_VR64 }, },
  { 3975 /* movq */, X86::MOVPQI2QImr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3980 /* movq2dq */, X86::MMX_MOVQ2DQrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_VR64 }, },
  { 3988 /* movsb */, X86::MOVSB, Convert__DstIdx81_0__SrcIdx82_1, 0, { MCK_DstIdx8, MCK_SrcIdx8 }, },
  { 4015 /* movsd */, X86::MOVSDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4015 /* movsd */, X86::MOVSDrm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4015 /* movsd */, X86::MOVSL, Convert__DstIdx321_0__SrcIdx322_1, 0, { MCK_DstIdx32, MCK_SrcIdx32 }, },
  { 4015 /* movsd */, X86::MOVSDmr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4021 /* movshdup */, X86::MOVSHDUPrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4021 /* movshdup */, X86::MOVSHDUPrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4036 /* movsldup */, X86::MOVSLDUPrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4036 /* movsldup */, X86::MOVSLDUPrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4052 /* movsq */, X86::MOVSQ, Convert__DstIdx641_0__SrcIdx642_1, 0, { MCK_DstIdx64, MCK_SrcIdx64 }, },
  { 4058 /* movss */, X86::MOVSSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4058 /* movss */, X86::MOVSSrm, Convert__Reg1_0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 4058 /* movss */, X86::MOVSSmr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_FR32 }, },
  { 4064 /* movsw */, X86::MOVSW, Convert__DstIdx161_0__SrcIdx162_1, 0, { MCK_DstIdx16, MCK_SrcIdx16 }, },
  { 4084 /* movsx */, X86::MOVSX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4084 /* movsx */, X86::MOVSX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4084 /* movsx */, X86::MOVSX64rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4084 /* movsx */, X86::MOVSX16rr8, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR8 }, },
  { 4084 /* movsx */, X86::MOVSX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4084 /* movsx */, X86::MOVSX64rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4084 /* movsx */, X86::MOVSX16rm8, Convert__Reg1_0__Mem85_1, 0, { MCK_GR16, MCK_Mem8 }, },
  { 4084 /* movsx */, X86::MOVSX32rr8, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR8 }, },
  { 4084 /* movsx */, X86::MOVSX32rr16, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR16 }, },
  { 4084 /* movsx */, X86::MOVSX64rr32, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR64 }, },
  { 4084 /* movsx */, X86::MOVSX32rm16, Convert__Reg1_0__Mem165_1, 0, { MCK_GR32, MCK_Mem16 }, },
  { 4084 /* movsx */, X86::MOVSX32rm8, Convert__Reg1_0__Mem85_1, 0, { MCK_GR32, MCK_Mem8 }, },
  { 4084 /* movsx */, X86::MOVSX64rr8, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR8 }, },
  { 4084 /* movsx */, X86::MOVSX64rr16, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR16 }, },
  { 4084 /* movsx */, X86::MOVSX64rm16, Convert__Reg1_0__Mem165_1, 0, { MCK_GR64, MCK_Mem16 }, },
  { 4084 /* movsx */, X86::MOVSX64rm8, Convert__Reg1_0__Mem85_1, 0, { MCK_GR64, MCK_Mem8 }, },
  { 4084 /* movsx */, X86::MOVSX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4090 /* movsxd */, X86::MOVSX64rr32, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR32 }, },
  { 4090 /* movsxd */, X86::MOVSX64rm32, Convert__Reg1_0__Mem325_1, 0, { MCK_GR64, MCK_Mem32 }, },
  { 4097 /* movupd */, X86::MOVUPDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4097 /* movupd */, X86::MOVUPDrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4097 /* movupd */, X86::MOVUPDmr, Convert__Mem1285_0__Reg1_1, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4104 /* movups */, X86::MOVUPSrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4104 /* movups */, X86::MOVUPSrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4104 /* movups */, X86::MOVUPSmr, Convert__Mem1285_0__Reg1_1, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4151 /* movzx */, X86::MOVZX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4151 /* movzx */, X86::MOVZX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4151 /* movzx */, X86::MOVZX64rr8_Q, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4151 /* movzx */, X86::MOVZX16rr8, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR8 }, },
  { 4151 /* movzx */, X86::MOVZX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4151 /* movzx */, X86::MOVZX64rr16_Q, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4151 /* movzx */, X86::MOVZX16rm8, Convert__Reg1_0__Mem85_1, 0, { MCK_GR16, MCK_Mem8 }, },
  { 4151 /* movzx */, X86::MOVZX32rr8, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR8 }, },
  { 4151 /* movzx */, X86::MOVZX32rr16, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR16 }, },
  { 4151 /* movzx */, X86::MOVZX32rm16, Convert__Reg1_0__Mem165_1, 0, { MCK_GR32, MCK_Mem16 }, },
  { 4151 /* movzx */, X86::MOVZX32rm8, Convert__Reg1_0__Mem85_1, 0, { MCK_GR32, MCK_Mem8 }, },
  { 4151 /* movzx */, X86::MOVZX64rr8_Q, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR8 }, },
  { 4151 /* movzx */, X86::MOVZX64rr16_Q, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR16 }, },
  { 4151 /* movzx */, X86::MOVZX64rm16_Q, Convert__Reg1_0__Mem165_1, 0, { MCK_GR64, MCK_Mem16 }, },
  { 4151 /* movzx */, X86::MOVZX64rm8_Q, Convert__Reg1_0__Mem85_1, 0, { MCK_GR64, MCK_Mem8 }, },
  { 4151 /* movzx */, X86::MOVZX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4157 /* mpsadbw */, X86::MPSADBWrri, Convert__Reg1_0__Tie0__Reg1_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_FR32, MCK_ImmZExtu32u8 }, },
  { 4157 /* mpsadbw */, X86::MPSADBWrmi, Convert__Reg1_0__Tie0__Mem1285_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_Mem128, MCK_ImmZExtu32u8 }, },
  { 4165 /* mul */, X86::MUL8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 4165 /* mul */, X86::MUL16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 4165 /* mul */, X86::MUL32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 4165 /* mul */, X86::MUL64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 4165 /* mul */, X86::MUL16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4165 /* mul */, X86::MUL32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4165 /* mul */, X86::MUL64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 4165 /* mul */, X86::MUL8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 4179 /* mulpd */, X86::MULPDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4179 /* mulpd */, X86::MULPDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4185 /* mulps */, X86::MULPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4185 /* mulps */, X86::MULPSrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4196 /* mulsd */, X86::MULSDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4196 /* mulsd */, X86::MULSDrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4202 /* mulss */, X86::MULSSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4202 /* mulss */, X86::MULSSrm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 4213 /* mulx */, X86::MULX32rr, Convert__Reg1_0__Reg1_1__Reg1_2, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 4213 /* mulx */, X86::MULX32rm, Convert__Reg1_0__Reg1_1__Mem325_2, 0, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 4213 /* mulx */, X86::MULX64rr, Convert__Reg1_0__Reg1_1__Reg1_2, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4213 /* mulx */, X86::MULX64rm, Convert__Reg1_0__Reg1_1__Mem645_2, 0, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 4230 /* mwait */, X86::MWAITrr, Convert_NoOperands, 0, {  }, },
  { 4230 /* mwait */, X86::MWAITrr, Convert_NoOperands, Feature_Not64BitMode, { MCK_ECX, MCK_EAX }, },
  { 4230 /* mwait */, X86::MWAITrr, Convert_NoOperands, Feature_In64BitMode, { MCK_RCX, MCK_RAX }, },
  { 4236 /* neg */, X86::NEG8r, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 4236 /* neg */, X86::NEG16r, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 4236 /* neg */, X86::NEG32r, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 4236 /* neg */, X86::NEG64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 4236 /* neg */, X86::NEG16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4236 /* neg */, X86::NEG32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4236 /* neg */, X86::NEG64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 4236 /* neg */, X86::NEG8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 4260 /* nop */, X86::NOOP, Convert_NoOperands, 0, {  }, },
  { 4260 /* nop */, X86::NOOPW, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4260 /* nop */, X86::NOOPL, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4274 /* not */, X86::NOT8r, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 4274 /* not */, X86::NOT16r, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 4274 /* not */, X86::NOT32r, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 4274 /* not */, X86::NOT64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 4274 /* not */, X86::NOT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4274 /* not */, X86::NOT32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4274 /* not */, X86::NOT64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 4274 /* not */, X86::NOT8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 4298 /* or */, X86::OR8i8, Convert__Imm1_1, 0, { MCK_AL, MCK_Imm }, },
  { 4298 /* or */, X86::OR8rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR8, MCK_GR8 }, },
  { 4298 /* or */, X86::OR8ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR8, MCK_Imm }, },
  { 4298 /* or */, X86::OR8rm, Convert__Reg1_0__Tie0__Mem85_1, 0, { MCK_GR8, MCK_Mem8 }, },
  { 4298 /* or */, X86::OR16i16, Convert__Imm1_1, 0, { MCK_AX, MCK_Imm }, },
  { 4298 /* or */, X86::OR16rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 4298 /* or */, X86::OR16ri8, Convert__Reg1_0__Tie0__ImmSExti16i81_1, 0, { MCK_GR16, MCK_ImmSExti16i8 }, },
  { 4298 /* or */, X86::OR16ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR16, MCK_Imm }, },
  { 4298 /* or */, X86::OR16rm, Convert__Reg1_0__Tie0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 4298 /* or */, X86::OR32i32, Convert__Imm1_1, 0, { MCK_EAX, MCK_Imm }, },
  { 4298 /* or */, X86::OR32rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 4298 /* or */, X86::OR32ri8, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_GR32, MCK_ImmSExti32i8 }, },
  { 4298 /* or */, X86::OR32ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR32, MCK_Imm }, },
  { 4298 /* or */, X86::OR32rm, Convert__Reg1_0__Tie0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 4298 /* or */, X86::OR64i32, Convert__ImmSExti64i321_1, 0, { MCK_RAX, MCK_ImmSExti64i32 }, },
  { 4298 /* or */, X86::OR64rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 4298 /* or */, X86::OR64ri8, Convert__Reg1_0__Tie0__ImmSExti64i81_1, 0, { MCK_GR64, MCK_ImmSExti64i8 }, },
  { 4298 /* or */, X86::OR64ri32, Convert__Reg1_0__Tie0__ImmSExti64i321_1, 0, { MCK_GR64, MCK_ImmSExti64i32 }, },
  { 4298 /* or */, X86::OR64rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 4298 /* or */, X86::OR16mr, Convert__Mem165_0__Reg1_1, 0, { MCK_Mem16, MCK_GR16 }, },
  { 4298 /* or */, X86::OR16mi8, Convert__Mem165_0__ImmSExti16i81_1, 0, { MCK_Mem16, MCK_ImmSExti16i8 }, },
  { 4298 /* or */, X86::OR16mi, Convert__Mem165_0__Imm1_1, 0, { MCK_Mem16, MCK_Imm }, },
  { 4298 /* or */, X86::OR32mr, Convert__Mem325_0__Reg1_1, 0, { MCK_Mem32, MCK_GR32 }, },
  { 4298 /* or */, X86::OR32mi8, Convert__Mem325_0__ImmSExti32i81_1, 0, { MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 4298 /* or */, X86::OR32mi, Convert__Mem325_0__Imm1_1, 0, { MCK_Mem32, MCK_Imm }, },
  { 4298 /* or */, X86::OR64mr, Convert__Mem645_0__Reg1_1, 0, { MCK_Mem64, MCK_GR64 }, },
  { 4298 /* or */, X86::OR64mi8, Convert__Mem645_0__ImmSExti64i81_1, 0, { MCK_Mem64, MCK_ImmSExti64i8 }, },
  { 4298 /* or */, X86::OR64mi32, Convert__Mem645_0__ImmSExti64i321_1, 0, { MCK_Mem64, MCK_ImmSExti64i32 }, },
  { 4298 /* or */, X86::OR8mr, Convert__Mem85_0__Reg1_1, 0, { MCK_Mem8, MCK_GR8 }, },
  { 4298 /* or */, X86::OR8mi, Convert__Mem85_0__Imm1_1, 0, { MCK_Mem8, MCK_Imm }, },
  { 4309 /* orpd */, X86::ORPDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4309 /* orpd */, X86::ORPDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4314 /* orps */, X86::ORPSrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4314 /* orps */, X86::ORPSrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4327 /* out */, X86::OUT8rr, Convert_NoOperands, 0, { MCK_DX, MCK_AL }, },
  { 4327 /* out */, X86::OUT16rr, Convert_NoOperands, 0, { MCK_DX, MCK_AX }, },
  { 4327 /* out */, X86::OUT32rr, Convert_NoOperands, 0, { MCK_DX, MCK_EAX }, },
  { 4327 /* out */, X86::OUT8ir, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 4327 /* out */, X86::OUT16ir, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 4327 /* out */, X86::OUT32ir, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 4331 /* outb */, X86::OUT8rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 4331 /* outb */, X86::OUT8ir, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 4336 /* outl */, X86::OUT32rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 4336 /* outl */, X86::OUT32ir, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 4341 /* outsb */, X86::OUTSB, Convert__SrcIdx82_1, 0, { MCK_DX, MCK_SrcIdx8 }, },
  { 4347 /* outsd */, X86::OUTSL, Convert__SrcIdx322_1, 0, { MCK_DX, MCK_SrcIdx32 }, },
  { 4359 /* outsw */, X86::OUTSW, Convert__SrcIdx162_1, 0, { MCK_DX, MCK_SrcIdx16 }, },
  { 4365 /* outw */, X86::OUT16rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 4365 /* outw */, X86::OUT16ir, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 4370 /* pabsb */, X86::MMX_PABSBrr64, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4370 /* pabsb */, X86::MMX_PABSBrm64, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4370 /* pabsb */, X86::PABSBrr128, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4370 /* pabsb */, X86::PABSBrm128, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4376 /* pabsd */, X86::MMX_PABSDrr64, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4376 /* pabsd */, X86::MMX_PABSDrm64, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4376 /* pabsd */, X86::PABSDrr128, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4376 /* pabsd */, X86::PABSDrm128, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4382 /* pabsw */, X86::MMX_PABSWrr64, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4382 /* pabsw */, X86::MMX_PABSWrm64, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4382 /* pabsw */, X86::PABSWrr128, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4382 /* pabsw */, X86::PABSWrm128, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4388 /* packssdw */, X86::MMX_PACKSSDWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4388 /* packssdw */, X86::MMX_PACKSSDWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4388 /* packssdw */, X86::PACKSSDWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4388 /* packssdw */, X86::PACKSSDWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4397 /* packsswb */, X86::MMX_PACKSSWBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4397 /* packsswb */, X86::MMX_PACKSSWBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4397 /* packsswb */, X86::PACKSSWBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4397 /* packsswb */, X86::PACKSSWBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4406 /* packusdw */, X86::PACKUSDWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4406 /* packusdw */, X86::PACKUSDWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4415 /* packuswb */, X86::MMX_PACKUSWBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4415 /* packuswb */, X86::MMX_PACKUSWBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4415 /* packuswb */, X86::PACKUSWBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4415 /* packuswb */, X86::PACKUSWBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4424 /* paddb */, X86::MMX_PADDBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4424 /* paddb */, X86::MMX_PADDBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4424 /* paddb */, X86::PADDBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4424 /* paddb */, X86::PADDBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4430 /* paddd */, X86::MMX_PADDDirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4430 /* paddd */, X86::MMX_PADDDirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4430 /* paddd */, X86::PADDDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4430 /* paddd */, X86::PADDDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4436 /* paddq */, X86::MMX_PADDQirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4436 /* paddq */, X86::MMX_PADDQirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4436 /* paddq */, X86::PADDQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4436 /* paddq */, X86::PADDQrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4442 /* paddsb */, X86::MMX_PADDSBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4442 /* paddsb */, X86::MMX_PADDSBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4442 /* paddsb */, X86::PADDSBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4442 /* paddsb */, X86::PADDSBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4449 /* paddsw */, X86::MMX_PADDSWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4449 /* paddsw */, X86::MMX_PADDSWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4449 /* paddsw */, X86::PADDSWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4449 /* paddsw */, X86::PADDSWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4456 /* paddusb */, X86::MMX_PADDUSBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4456 /* paddusb */, X86::MMX_PADDUSBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4456 /* paddusb */, X86::PADDUSBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4456 /* paddusb */, X86::PADDUSBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4464 /* paddusw */, X86::MMX_PADDUSWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4464 /* paddusw */, X86::MMX_PADDUSWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4464 /* paddusw */, X86::PADDUSWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4464 /* paddusw */, X86::PADDUSWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4472 /* paddw */, X86::MMX_PADDWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4472 /* paddw */, X86::MMX_PADDWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4472 /* paddw */, X86::PADDWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4472 /* paddw */, X86::PADDWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4478 /* palignr */, X86::MMX_PALIGNR64irr, Convert__Reg1_0__Tie0__Reg1_1__Imm1_2, 0, { MCK_VR64, MCK_VR64, MCK_Imm }, },
  { 4478 /* palignr */, X86::MMX_PALIGNR64irm, Convert__Reg1_0__Tie0__Mem645_1__Imm1_2, 0, { MCK_VR64, MCK_Mem64, MCK_Imm }, },
  { 4478 /* palignr */, X86::PALIGNR128rr, Convert__Reg1_0__Tie0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 4478 /* palignr */, X86::PALIGNR128rm, Convert__Reg1_0__Tie0__Mem1285_1__Imm1_2, 0, { MCK_FR32, MCK_Mem128, MCK_Imm }, },
  { 4486 /* pand */, X86::MMX_PANDirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4486 /* pand */, X86::MMX_PANDirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4486 /* pand */, X86::PANDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4486 /* pand */, X86::PANDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4491 /* pandn */, X86::MMX_PANDNirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4491 /* pandn */, X86::MMX_PANDNirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4491 /* pandn */, X86::PANDNrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4491 /* pandn */, X86::PANDNrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4497 /* pause */, X86::PAUSE, Convert_NoOperands, 0, {  }, },
  { 4503 /* pavgb */, X86::MMX_PAVGBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4503 /* pavgb */, X86::MMX_PAVGBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4503 /* pavgb */, X86::PAVGBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4503 /* pavgb */, X86::PAVGBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4509 /* pavgusb */, X86::PAVGUSBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4509 /* pavgusb */, X86::PAVGUSBrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4517 /* pavgw */, X86::MMX_PAVGWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4517 /* pavgw */, X86::MMX_PAVGWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4517 /* pavgw */, X86::PAVGWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4517 /* pavgw */, X86::PAVGWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4523 /* pblendvb */, X86::PBLENDVBrr0, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4523 /* pblendvb */, X86::PBLENDVBrm0, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4523 /* pblendvb */, X86::PBLENDVBrr0, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32, MCK_XMM0 }, },
  { 4523 /* pblendvb */, X86::PBLENDVBrm0, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128, MCK_XMM0 }, },
  { 4532 /* pblendw */, X86::PBLENDWrri, Convert__Reg1_0__Tie0__Reg1_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_FR32, MCK_ImmZExtu32u8 }, },
  { 4532 /* pblendw */, X86::PBLENDWrmi, Convert__Reg1_0__Tie0__Mem1285_1__ImmZExtu32u81_2, 0, { MCK_FR32, MCK_Mem128, MCK_ImmZExtu32u8 }, },
  { 4540 /* pclmulhqhqdq */, X86::PCLMULQDQrr, Convert__Reg1_0__Tie0__Reg1_1__imm_17, 0, { MCK_FR32, MCK_FR32 }, },
  { 4540 /* pclmulhqhqdq */, X86::PCLMULQDQrm, Convert__Reg1_0__Tie0__Mem1285_1__imm_17, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4553 /* pclmulhqlqdq */, X86::PCLMULQDQrr, Convert__Reg1_0__Tie0__Reg1_1__imm_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4553 /* pclmulhqlqdq */, X86::PCLMULQDQrm, Convert__Reg1_0__Tie0__Mem1285_1__imm_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4566 /* pclmullqhqdq */, X86::PCLMULQDQrr, Convert__Reg1_0__Tie0__Reg1_1__imm_16, 0, { MCK_FR32, MCK_FR32 }, },
  { 4566 /* pclmullqhqdq */, X86::PCLMULQDQrm, Convert__Reg1_0__Tie0__Mem1285_1__imm_16, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4579 /* pclmullqlqdq */, X86::PCLMULQDQrr, Convert__Reg1_0__Tie0__Reg1_1__imm_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4579 /* pclmullqlqdq */, X86::PCLMULQDQrm, Convert__Reg1_0__Tie0__Mem1285_1__imm_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4592 /* pclmulqdq */, X86::PCLMULQDQrr, Convert__Reg1_0__Tie0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 4592 /* pclmulqdq */, X86::PCLMULQDQrm, Convert__Reg1_0__Tie0__Mem1285_1__Imm1_2, 0, { MCK_FR32, MCK_Mem128, MCK_Imm }, },
  { 4602 /* pcmpeqb */, X86::MMX_PCMPEQBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4602 /* pcmpeqb */, X86::MMX_PCMPEQBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4602 /* pcmpeqb */, X86::PCMPEQBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4602 /* pcmpeqb */, X86::PCMPEQBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4610 /* pcmpeqd */, X86::MMX_PCMPEQDirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4610 /* pcmpeqd */, X86::MMX_PCMPEQDirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4610 /* pcmpeqd */, X86::PCMPEQDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4610 /* pcmpeqd */, X86::PCMPEQDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4618 /* pcmpeqq */, X86::PCMPEQQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4618 /* pcmpeqq */, X86::PCMPEQQrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4626 /* pcmpeqw */, X86::MMX_PCMPEQWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4626 /* pcmpeqw */, X86::MMX_PCMPEQWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4626 /* pcmpeqw */, X86::PCMPEQWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4626 /* pcmpeqw */, X86::PCMPEQWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4634 /* pcmpestri */, X86::PCMPESTRIrr, Convert__Reg1_0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 4634 /* pcmpestri */, X86::PCMPESTRIrm, Convert__Reg1_0__Mem1285_1__Imm1_2, 0, { MCK_FR32, MCK_Mem128, MCK_Imm }, },
  { 4644 /* pcmpestrm */, X86::PCMPESTRM128rr, Convert__Reg1_0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 4644 /* pcmpestrm */, X86::PCMPESTRM128rm, Convert__Reg1_0__Mem1285_1__Imm1_2, 0, { MCK_FR32, MCK_Mem128, MCK_Imm }, },
  { 4654 /* pcmpgtb */, X86::MMX_PCMPGTBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4654 /* pcmpgtb */, X86::MMX_PCMPGTBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4654 /* pcmpgtb */, X86::PCMPGTBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4654 /* pcmpgtb */, X86::PCMPGTBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4662 /* pcmpgtd */, X86::MMX_PCMPGTDirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4662 /* pcmpgtd */, X86::MMX_PCMPGTDirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4662 /* pcmpgtd */, X86::PCMPGTDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4662 /* pcmpgtd */, X86::PCMPGTDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4670 /* pcmpgtq */, X86::PCMPGTQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4670 /* pcmpgtq */, X86::PCMPGTQrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4678 /* pcmpgtw */, X86::MMX_PCMPGTWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4678 /* pcmpgtw */, X86::MMX_PCMPGTWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4678 /* pcmpgtw */, X86::PCMPGTWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4678 /* pcmpgtw */, X86::PCMPGTWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4686 /* pcmpistri */, X86::PCMPISTRIrr, Convert__Reg1_0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 4686 /* pcmpistri */, X86::PCMPISTRIrm, Convert__Reg1_0__Mem1285_1__Imm1_2, 0, { MCK_FR32, MCK_Mem128, MCK_Imm }, },
  { 4696 /* pcmpistrm */, X86::PCMPISTRM128rr, Convert__Reg1_0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 4696 /* pcmpistrm */, X86::PCMPISTRM128rm, Convert__Reg1_0__Mem1285_1__Imm1_2, 0, { MCK_FR32, MCK_Mem128, MCK_Imm }, },
  { 4706 /* pdep */, X86::PDEP32rr, Convert__Reg1_0__Reg1_1__Reg1_2, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 4706 /* pdep */, X86::PDEP32rm, Convert__Reg1_0__Reg1_1__Mem325_2, 0, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 4706 /* pdep */, X86::PDEP64rr, Convert__Reg1_0__Reg1_1__Reg1_2, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4706 /* pdep */, X86::PDEP64rm, Convert__Reg1_0__Reg1_1__Mem645_2, 0, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 4723 /* pext */, X86::PEXT32rr, Convert__Reg1_0__Reg1_1__Reg1_2, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 4723 /* pext */, X86::PEXT32rm, Convert__Reg1_0__Reg1_1__Mem325_2, 0, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 4723 /* pext */, X86::PEXT64rr, Convert__Reg1_0__Reg1_1__Reg1_2, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4723 /* pext */, X86::PEXT64rm, Convert__Reg1_0__Reg1_1__Mem645_2, 0, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 4740 /* pextrb */, X86::PEXTRBrr, Convert__GR32orGR641_0__Reg1_1__ImmSExti32i81_2, 0, { MCK_GR32orGR64, MCK_FR32, MCK_ImmSExti32i8 }, },
  { 4740 /* pextrb */, X86::PEXTRBmr, Convert__Mem85_0__Reg1_1__ImmSExti32i81_2, 0, { MCK_Mem8, MCK_FR32, MCK_ImmSExti32i8 }, },
  { 4747 /* pextrd */, X86::PEXTRDrr, Convert__Reg1_0__Reg1_1__ImmSExti32i81_2, 0, { MCK_GR32, MCK_FR32, MCK_ImmSExti32i8 }, },
  { 4747 /* pextrd */, X86::PEXTRDmr, Convert__Mem325_0__Reg1_1__ImmSExti32i81_2, 0, { MCK_Mem32, MCK_FR32, MCK_ImmSExti32i8 }, },
  { 4754 /* pextrq */, X86::PEXTRQrr, Convert__Reg1_0__Reg1_1__ImmSExti32i81_2, 0, { MCK_GR64, MCK_FR32, MCK_ImmSExti32i8 }, },
  { 4754 /* pextrq */, X86::PEXTRQmr, Convert__Mem645_0__Reg1_1__ImmSExti32i81_2, 0, { MCK_Mem64, MCK_FR32, MCK_ImmSExti32i8 }, },
  { 4761 /* pextrw */, X86::MMX_PEXTRWirri, Convert__GR32orGR641_0__Reg1_1__ImmSExti32i81_2, 0, { MCK_GR32orGR64, MCK_VR64, MCK_ImmSExti32i8 }, },
  { 4761 /* pextrw */, X86::PEXTRWri, Convert__GR32orGR641_0__Reg1_1__ImmSExti32i81_2, 0, { MCK_GR32orGR64, MCK_FR32, MCK_ImmSExti32i8 }, },
  { 4761 /* pextrw */, X86::PEXTRWmr, Convert__Mem165_0__Reg1_1__ImmSExti32i81_2, 0, { MCK_Mem16, MCK_FR32, MCK_ImmSExti32i8 }, },
  { 4768 /* pf2id */, X86::PF2IDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4768 /* pf2id */, X86::PF2IDrm, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4774 /* pf2iw */, X86::PF2IWrr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4774 /* pf2iw */, X86::PF2IWrm, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4780 /* pfacc */, X86::PFACCrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4780 /* pfacc */, X86::PFACCrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4786 /* pfadd */, X86::PFADDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4786 /* pfadd */, X86::PFADDrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4792 /* pfcmpeq */, X86::PFCMPEQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4792 /* pfcmpeq */, X86::PFCMPEQrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4800 /* pfcmpge */, X86::PFCMPGErr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4800 /* pfcmpge */, X86::PFCMPGErm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4808 /* pfcmpgt */, X86::PFCMPGTrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4808 /* pfcmpgt */, X86::PFCMPGTrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4816 /* pfmax */, X86::PFMAXrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4816 /* pfmax */, X86::PFMAXrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4822 /* pfmin */, X86::PFMINrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4822 /* pfmin */, X86::PFMINrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4828 /* pfmul */, X86::PFMULrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4828 /* pfmul */, X86::PFMULrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4834 /* pfnacc */, X86::PFNACCrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4834 /* pfnacc */, X86::PFNACCrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4841 /* pfpnacc */, X86::PFPNACCrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4841 /* pfpnacc */, X86::PFPNACCrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4849 /* pfrcp */, X86::PFRCPrr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4849 /* pfrcp */, X86::PFRCPrm, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4855 /* pfrcpit1 */, X86::PFRCPIT1rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4855 /* pfrcpit1 */, X86::PFRCPIT1rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4864 /* pfrcpit2 */, X86::PFRCPIT2rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4864 /* pfrcpit2 */, X86::PFRCPIT2rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4873 /* pfrsqit1 */, X86::PFRSQIT1rr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4873 /* pfrsqit1 */, X86::PFRSQIT1rm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4882 /* pfrsqrt */, X86::PFRSQRTrr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4882 /* pfrsqrt */, X86::PFRSQRTrm, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4890 /* pfsub */, X86::PFSUBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4890 /* pfsub */, X86::PFSUBrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4896 /* pfsubr */, X86::PFSUBRrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4896 /* pfsubr */, X86::PFSUBRrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4903 /* phaddd */, X86::MMX_PHADDrr64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4903 /* phaddd */, X86::MMX_PHADDrm64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4903 /* phaddd */, X86::PHADDDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4903 /* phaddd */, X86::PHADDDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4910 /* phaddsw */, X86::MMX_PHADDSWrr64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4910 /* phaddsw */, X86::MMX_PHADDSWrm64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4910 /* phaddsw */, X86::PHADDSWrr128, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4910 /* phaddsw */, X86::PHADDSWrm128, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4918 /* phaddw */, X86::MMX_PHADDWrr64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4918 /* phaddw */, X86::MMX_PHADDWrm64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4918 /* phaddw */, X86::PHADDWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4918 /* phaddw */, X86::PHADDWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4925 /* phminposuw */, X86::PHMINPOSUWrr128, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4925 /* phminposuw */, X86::PHMINPOSUWrm128, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4936 /* phsubd */, X86::MMX_PHSUBDrr64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4936 /* phsubd */, X86::MMX_PHSUBDrm64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4936 /* phsubd */, X86::PHSUBDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4936 /* phsubd */, X86::PHSUBDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4943 /* phsubsw */, X86::MMX_PHSUBSWrr64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4943 /* phsubsw */, X86::MMX_PHSUBSWrm64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4943 /* phsubsw */, X86::PHSUBSWrr128, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4943 /* phsubsw */, X86::PHSUBSWrm128, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4951 /* phsubw */, X86::MMX_PHSUBWrr64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4951 /* phsubw */, X86::MMX_PHSUBWrm64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4951 /* phsubw */, X86::PHSUBWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4951 /* phsubw */, X86::PHSUBWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4958 /* pi2fd */, X86::PI2FDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4958 /* pi2fd */, X86::PI2FDrm, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4964 /* pi2fw */, X86::PI2FWrr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4964 /* pi2fw */, X86::PI2FWrm, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4970 /* pinsrb */, X86::PINSRBrr, Convert__Reg1_0__Tie0__GR32orGR641_1__ImmSExti32i81_2, 0, { MCK_FR32, MCK_GR32orGR64, MCK_ImmSExti32i8 }, },
  { 4970 /* pinsrb */, X86::PINSRBrm, Convert__Reg1_0__Tie0__Mem85_1__ImmSExti32i81_2, 0, { MCK_FR32, MCK_Mem8, MCK_ImmSExti32i8 }, },
  { 4977 /* pinsrd */, X86::PINSRDrr, Convert__Reg1_0__Tie0__Reg1_1__ImmSExti32i81_2, 0, { MCK_FR32, MCK_GR32, MCK_ImmSExti32i8 }, },
  { 4977 /* pinsrd */, X86::PINSRDrm, Convert__Reg1_0__Tie0__Mem325_1__ImmSExti32i81_2, 0, { MCK_FR32, MCK_Mem32, MCK_ImmSExti32i8 }, },
  { 4984 /* pinsrq */, X86::PINSRQrr, Convert__Reg1_0__Tie0__Reg1_1__ImmSExti32i81_2, 0, { MCK_FR32, MCK_GR64, MCK_ImmSExti32i8 }, },
  { 4984 /* pinsrq */, X86::PINSRQrm, Convert__Reg1_0__Tie0__Mem645_1__ImmSExti32i81_2, 0, { MCK_FR32, MCK_Mem64, MCK_ImmSExti32i8 }, },
  { 4991 /* pinsrw */, X86::MMX_PINSRWirri, Convert__Reg1_0__Tie0__GR32orGR641_1__ImmSExti32i81_2, 0, { MCK_VR64, MCK_GR32orGR64, MCK_ImmSExti32i8 }, },
  { 4991 /* pinsrw */, X86::MMX_PINSRWirmi, Convert__Reg1_0__Tie0__Mem165_1__ImmSExti32i81_2, 0, { MCK_VR64, MCK_Mem16, MCK_ImmSExti32i8 }, },
  { 4991 /* pinsrw */, X86::PINSRWrri, Convert__Reg1_0__Tie0__GR32orGR641_1__ImmSExti32i81_2, 0, { MCK_FR32, MCK_GR32orGR64, MCK_ImmSExti32i8 }, },
  { 4991 /* pinsrw */, X86::PINSRWrmi, Convert__Reg1_0__Tie0__Mem165_1__ImmSExti32i81_2, 0, { MCK_FR32, MCK_Mem16, MCK_ImmSExti32i8 }, },
  { 4998 /* pmaddubsw */, X86::MMX_PMADDUBSWrr64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 4998 /* pmaddubsw */, X86::MMX_PMADDUBSWrm64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4998 /* pmaddubsw */, X86::PMADDUBSWrr128, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4998 /* pmaddubsw */, X86::PMADDUBSWrm128, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5008 /* pmaddwd */, X86::MMX_PMADDWDirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5008 /* pmaddwd */, X86::MMX_PMADDWDirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5008 /* pmaddwd */, X86::PMADDWDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5008 /* pmaddwd */, X86::PMADDWDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5016 /* pmaxsb */, X86::PMAXSBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5016 /* pmaxsb */, X86::PMAXSBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5023 /* pmaxsd */, X86::PMAXSDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5023 /* pmaxsd */, X86::PMAXSDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5030 /* pmaxsw */, X86::MMX_PMAXSWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5030 /* pmaxsw */, X86::MMX_PMAXSWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5030 /* pmaxsw */, X86::PMAXSWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5030 /* pmaxsw */, X86::PMAXSWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5037 /* pmaxub */, X86::MMX_PMAXUBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5037 /* pmaxub */, X86::MMX_PMAXUBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5037 /* pmaxub */, X86::PMAXUBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5037 /* pmaxub */, X86::PMAXUBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5044 /* pmaxud */, X86::PMAXUDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5044 /* pmaxud */, X86::PMAXUDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5051 /* pmaxuw */, X86::PMAXUWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5051 /* pmaxuw */, X86::PMAXUWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5058 /* pminsb */, X86::PMINSBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5058 /* pminsb */, X86::PMINSBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5065 /* pminsd */, X86::PMINSDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5065 /* pminsd */, X86::PMINSDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5072 /* pminsw */, X86::MMX_PMINSWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5072 /* pminsw */, X86::MMX_PMINSWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5072 /* pminsw */, X86::PMINSWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5072 /* pminsw */, X86::PMINSWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5079 /* pminub */, X86::MMX_PMINUBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5079 /* pminub */, X86::MMX_PMINUBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5079 /* pminub */, X86::PMINUBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5079 /* pminub */, X86::PMINUBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5086 /* pminud */, X86::PMINUDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5086 /* pminud */, X86::PMINUDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5093 /* pminuw */, X86::PMINUWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5093 /* pminuw */, X86::PMINUWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5100 /* pmovmskb */, X86::MMX_PMOVMSKBrr, Convert__GR32orGR641_0__Reg1_1, 0, { MCK_GR32orGR64, MCK_VR64 }, },
  { 5100 /* pmovmskb */, X86::PMOVMSKBrr, Convert__GR32orGR641_0__Reg1_1, 0, { MCK_GR32orGR64, MCK_FR32 }, },
  { 5109 /* pmovsxbd */, X86::PMOVSXBDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5109 /* pmovsxbd */, X86::PMOVSXBDrm, Convert__Reg1_0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 5118 /* pmovsxbq */, X86::PMOVSXBQrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5118 /* pmovsxbq */, X86::PMOVSXBQrm, Convert__Reg1_0__Mem165_1, 0, { MCK_FR32, MCK_Mem16 }, },
  { 5127 /* pmovsxbw */, X86::PMOVSXBWrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5127 /* pmovsxbw */, X86::PMOVSXBWrm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 5136 /* pmovsxdq */, X86::PMOVSXDQrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5136 /* pmovsxdq */, X86::PMOVSXDQrm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 5145 /* pmovsxwd */, X86::PMOVSXWDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5145 /* pmovsxwd */, X86::PMOVSXWDrm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 5154 /* pmovsxwq */, X86::PMOVSXWQrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5154 /* pmovsxwq */, X86::PMOVSXWQrm, Convert__Reg1_0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 5163 /* pmovzxbd */, X86::PMOVZXBDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5163 /* pmovzxbd */, X86::PMOVZXBDrm, Convert__Reg1_0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 5172 /* pmovzxbq */, X86::PMOVZXBQrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5172 /* pmovzxbq */, X86::PMOVZXBQrm, Convert__Reg1_0__Mem165_1, 0, { MCK_FR32, MCK_Mem16 }, },
  { 5181 /* pmovzxbw */, X86::PMOVZXBWrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5181 /* pmovzxbw */, X86::PMOVZXBWrm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 5190 /* pmovzxdq */, X86::PMOVZXDQrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5190 /* pmovzxdq */, X86::PMOVZXDQrm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 5199 /* pmovzxwd */, X86::PMOVZXWDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5199 /* pmovzxwd */, X86::PMOVZXWDrm, Convert__Reg1_0__Mem645_1, 0, { MCK_FR32, MCK_Mem64 }, },
  { 5208 /* pmovzxwq */, X86::PMOVZXWQrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5208 /* pmovzxwq */, X86::PMOVZXWQrm, Convert__Reg1_0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 5217 /* pmuldq */, X86::PMULDQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5217 /* pmuldq */, X86::PMULDQrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5224 /* pmulhrsw */, X86::MMX_PMULHRSWrr64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5224 /* pmulhrsw */, X86::MMX_PMULHRSWrm64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5224 /* pmulhrsw */, X86::PMULHRSWrr128, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5224 /* pmulhrsw */, X86::PMULHRSWrm128, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5233 /* pmulhrw */, X86::PMULHRWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5233 /* pmulhrw */, X86::PMULHRWrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5241 /* pmulhuw */, X86::MMX_PMULHUWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5241 /* pmulhuw */, X86::MMX_PMULHUWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5241 /* pmulhuw */, X86::PMULHUWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5241 /* pmulhuw */, X86::PMULHUWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5249 /* pmulhw */, X86::MMX_PMULHWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5249 /* pmulhw */, X86::MMX_PMULHWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5249 /* pmulhw */, X86::PMULHWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5249 /* pmulhw */, X86::PMULHWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5256 /* pmulld */, X86::PMULLDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5256 /* pmulld */, X86::PMULLDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5263 /* pmullw */, X86::MMX_PMULLWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5263 /* pmullw */, X86::MMX_PMULLWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5263 /* pmullw */, X86::PMULLWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5263 /* pmullw */, X86::PMULLWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5270 /* pmuludq */, X86::MMX_PMULUDQirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5270 /* pmuludq */, X86::MMX_PMULUDQirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5270 /* pmuludq */, X86::PMULUDQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5270 /* pmuludq */, X86::PMULUDQrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5278 /* pop */, X86::POP16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5278 /* pop */, X86::POP16rmr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5278 /* pop */, X86::POP32r, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 5278 /* pop */, X86::POP32rmr, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 5278 /* pop */, X86::POP64r, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5278 /* pop */, X86::POP64rmr, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5278 /* pop */, X86::POPDS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 5278 /* pop */, X86::POPDS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 5278 /* pop */, X86::POPSS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 5278 /* pop */, X86::POPSS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 5278 /* pop */, X86::POPES16, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 5278 /* pop */, X86::POPES32, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 5278 /* pop */, X86::POPFS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_FS }, },
  { 5278 /* pop */, X86::POPFS64, Convert_NoOperands, Feature_In64BitMode, { MCK_FS }, },
  { 5278 /* pop */, X86::POPFS16, Convert_NoOperands, 0, { MCK_FS }, },
  { 5278 /* pop */, X86::POPGS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_GS }, },
  { 5278 /* pop */, X86::POPGS64, Convert_NoOperands, Feature_In64BitMode, { MCK_GS }, },
  { 5278 /* pop */, X86::POPGS16, Convert_NoOperands, 0, { MCK_GS }, },
  { 5278 /* pop */, X86::POP16rmm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 5278 /* pop */, X86::POP32rmm, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 5278 /* pop */, X86::POP64rmm, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 5282 /* popal */, X86::POPA32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5288 /* popaw */, X86::POPA16, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5294 /* popcnt */, X86::POPCNT16rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR16, MCK_GR16 }, },
  { 5294 /* popcnt */, X86::POPCNT16rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 5294 /* popcnt */, X86::POPCNT32rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR32, MCK_GR32 }, },
  { 5294 /* popcnt */, X86::POPCNT32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 5294 /* popcnt */, X86::POPCNT64rr, Convert__Reg1_0__Reg1_1, 0, { MCK_GR64, MCK_GR64 }, },
  { 5294 /* popcnt */, X86::POPCNT64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 5325 /* popf */, X86::POPF16, Convert_NoOperands, 0, {  }, },
  { 5330 /* popfd */, X86::POPF32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5342 /* popfq */, X86::POPF64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 5369 /* por */, X86::MMX_PORirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5369 /* por */, X86::MMX_PORirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5369 /* por */, X86::PORrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5369 /* por */, X86::PORrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5373 /* prefetch */, X86::PREFETCH, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5382 /* prefetchnta */, X86::PREFETCHNTA, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5394 /* prefetcht0 */, X86::PREFETCHT0, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5405 /* prefetcht1 */, X86::PREFETCHT1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5416 /* prefetcht2 */, X86::PREFETCHT2, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5427 /* prefetchw */, X86::PREFETCHW, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5437 /* psadbw */, X86::MMX_PSADBWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5437 /* psadbw */, X86::MMX_PSADBWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5437 /* psadbw */, X86::PSADBWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5437 /* psadbw */, X86::PSADBWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5444 /* pshufb */, X86::MMX_PSHUFBrr64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5444 /* pshufb */, X86::MMX_PSHUFBrm64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5444 /* pshufb */, X86::PSHUFBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5444 /* pshufb */, X86::PSHUFBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5451 /* pshufd */, X86::PSHUFDri, Convert__Reg1_0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 5451 /* pshufd */, X86::PSHUFDmi, Convert__Reg1_0__Mem1285_1__Imm1_2, 0, { MCK_FR32, MCK_Mem128, MCK_Imm }, },
  { 5458 /* pshufhw */, X86::PSHUFHWri, Convert__Reg1_0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 5458 /* pshufhw */, X86::PSHUFHWmi, Convert__Reg1_0__Mem1285_1__Imm1_2, 0, { MCK_FR32, MCK_Mem128, MCK_Imm }, },
  { 5466 /* pshuflw */, X86::PSHUFLWri, Convert__Reg1_0__Reg1_1__Imm1_2, 0, { MCK_FR32, MCK_FR32, MCK_Imm }, },
  { 5466 /* pshuflw */, X86::PSHUFLWmi, Convert__Reg1_0__Mem1285_1__Imm1_2, 0, { MCK_FR32, MCK_Mem128, MCK_Imm }, },
  { 5474 /* pshufw */, X86::MMX_PSHUFWri, Convert__Reg1_0__Reg1_1__Imm1_2, 0, { MCK_VR64, MCK_VR64, MCK_Imm }, },
  { 5474 /* pshufw */, X86::MMX_PSHUFWmi, Convert__Reg1_0__Mem645_1__Imm1_2, 0, { MCK_VR64, MCK_Mem64, MCK_Imm }, },
  { 5481 /* psignb */, X86::MMX_PSIGNBrr64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5481 /* psignb */, X86::MMX_PSIGNBrm64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5481 /* psignb */, X86::PSIGNBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5481 /* psignb */, X86::PSIGNBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5488 /* psignd */, X86::MMX_PSIGNDrr64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5488 /* psignd */, X86::MMX_PSIGNDrm64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5488 /* psignd */, X86::PSIGNDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5488 /* psignd */, X86::PSIGNDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5495 /* psignw */, X86::MMX_PSIGNWrr64, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5495 /* psignw */, X86::MMX_PSIGNWrm64, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5495 /* psignw */, X86::PSIGNWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5495 /* psignw */, X86::PSIGNWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5502 /* pslld */, X86::MMX_PSLLDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5502 /* pslld */, X86::MMX_PSLLDri, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_VR64, MCK_ImmSExti32i8 }, },
  { 5502 /* pslld */, X86::MMX_PSLLDrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5502 /* pslld */, X86::PSLLDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5502 /* pslld */, X86::PSLLDri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_FR32, MCK_Imm }, },
  { 5502 /* pslld */, X86::PSLLDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5508 /* pslldq */, X86::PSLLDQri, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_FR32, MCK_ImmSExti32i8 }, },
  { 5515 /* psllq */, X86::MMX_PSLLQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5515 /* psllq */, X86::MMX_PSLLQri, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_VR64, MCK_ImmSExti32i8 }, },
  { 5515 /* psllq */, X86::MMX_PSLLQrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5515 /* psllq */, X86::PSLLQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5515 /* psllq */, X86::PSLLQri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_FR32, MCK_Imm }, },
  { 5515 /* psllq */, X86::PSLLQrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5521 /* psllw */, X86::MMX_PSLLWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5521 /* psllw */, X86::MMX_PSLLWri, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_VR64, MCK_ImmSExti32i8 }, },
  { 5521 /* psllw */, X86::MMX_PSLLWrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5521 /* psllw */, X86::PSLLWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5521 /* psllw */, X86::PSLLWri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_FR32, MCK_Imm }, },
  { 5521 /* psllw */, X86::PSLLWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5527 /* psrad */, X86::MMX_PSRADrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5527 /* psrad */, X86::MMX_PSRADri, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_VR64, MCK_ImmSExti32i8 }, },
  { 5527 /* psrad */, X86::MMX_PSRADrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5527 /* psrad */, X86::PSRADrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5527 /* psrad */, X86::PSRADri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_FR32, MCK_Imm }, },
  { 5527 /* psrad */, X86::PSRADrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5533 /* psraw */, X86::MMX_PSRAWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5533 /* psraw */, X86::MMX_PSRAWri, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_VR64, MCK_ImmSExti32i8 }, },
  { 5533 /* psraw */, X86::MMX_PSRAWrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5533 /* psraw */, X86::PSRAWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5533 /* psraw */, X86::PSRAWri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_FR32, MCK_Imm }, },
  { 5533 /* psraw */, X86::PSRAWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5539 /* psrld */, X86::MMX_PSRLDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5539 /* psrld */, X86::MMX_PSRLDri, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_VR64, MCK_ImmSExti32i8 }, },
  { 5539 /* psrld */, X86::MMX_PSRLDrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5539 /* psrld */, X86::PSRLDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5539 /* psrld */, X86::PSRLDri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_FR32, MCK_Imm }, },
  { 5539 /* psrld */, X86::PSRLDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5545 /* psrldq */, X86::PSRLDQri, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_FR32, MCK_ImmSExti32i8 }, },
  { 5552 /* psrlq */, X86::MMX_PSRLQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5552 /* psrlq */, X86::MMX_PSRLQri, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_VR64, MCK_ImmSExti32i8 }, },
  { 5552 /* psrlq */, X86::MMX_PSRLQrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5552 /* psrlq */, X86::PSRLQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5552 /* psrlq */, X86::PSRLQri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_FR32, MCK_Imm }, },
  { 5552 /* psrlq */, X86::PSRLQrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5558 /* psrlw */, X86::MMX_PSRLWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5558 /* psrlw */, X86::MMX_PSRLWri, Convert__Reg1_0__Tie0__ImmSExti32i81_1, 0, { MCK_VR64, MCK_ImmSExti32i8 }, },
  { 5558 /* psrlw */, X86::MMX_PSRLWrm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5558 /* psrlw */, X86::PSRLWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5558 /* psrlw */, X86::PSRLWri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_FR32, MCK_Imm }, },
  { 5558 /* psrlw */, X86::PSRLWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5564 /* psubb */, X86::MMX_PSUBBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5564 /* psubb */, X86::MMX_PSUBBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5564 /* psubb */, X86::PSUBBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5564 /* psubb */, X86::PSUBBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5570 /* psubd */, X86::MMX_PSUBDirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5570 /* psubd */, X86::MMX_PSUBDirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5570 /* psubd */, X86::PSUBDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5570 /* psubd */, X86::PSUBDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5576 /* psubq */, X86::MMX_PSUBQirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5576 /* psubq */, X86::MMX_PSUBQirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5576 /* psubq */, X86::PSUBQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5576 /* psubq */, X86::PSUBQrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5582 /* psubsb */, X86::MMX_PSUBSBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5582 /* psubsb */, X86::MMX_PSUBSBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5582 /* psubsb */, X86::PSUBSBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5582 /* psubsb */, X86::PSUBSBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5589 /* psubsw */, X86::MMX_PSUBSWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5589 /* psubsw */, X86::MMX_PSUBSWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5589 /* psubsw */, X86::PSUBSWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5589 /* psubsw */, X86::PSUBSWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5596 /* psubusb */, X86::MMX_PSUBUSBirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5596 /* psubusb */, X86::MMX_PSUBUSBirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5596 /* psubusb */, X86::PSUBUSBrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5596 /* psubusb */, X86::PSUBUSBrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5604 /* psubusw */, X86::MMX_PSUBUSWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5604 /* psubusw */, X86::MMX_PSUBUSWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5604 /* psubusw */, X86::PSUBUSWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5604 /* psubusw */, X86::PSUBUSWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5612 /* psubw */, X86::MMX_PSUBWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5612 /* psubw */, X86::MMX_PSUBWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5612 /* psubw */, X86::PSUBWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5612 /* psubw */, X86::PSUBWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5618 /* pswapd */, X86::PSWAPDrr, Convert__Reg1_0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5618 /* pswapd */, X86::PSWAPDrm, Convert__Reg1_0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5625 /* ptest */, X86::PTESTrr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5625 /* ptest */, X86::PTESTrm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5631 /* punpckhbw */, X86::MMX_PUNPCKHBWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5631 /* punpckhbw */, X86::MMX_PUNPCKHBWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5631 /* punpckhbw */, X86::PUNPCKHBWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5631 /* punpckhbw */, X86::PUNPCKHBWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5641 /* punpckhdq */, X86::MMX_PUNPCKHDQirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5641 /* punpckhdq */, X86::MMX_PUNPCKHDQirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5641 /* punpckhdq */, X86::PUNPCKHDQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5641 /* punpckhdq */, X86::PUNPCKHDQrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5651 /* punpckhqdq */, X86::PUNPCKHQDQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5651 /* punpckhqdq */, X86::PUNPCKHQDQrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5662 /* punpckhwd */, X86::MMX_PUNPCKHWDirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5662 /* punpckhwd */, X86::MMX_PUNPCKHWDirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5662 /* punpckhwd */, X86::PUNPCKHWDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5662 /* punpckhwd */, X86::PUNPCKHWDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5672 /* punpcklbw */, X86::MMX_PUNPCKLBWirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5672 /* punpcklbw */, X86::MMX_PUNPCKLBWirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5672 /* punpcklbw */, X86::PUNPCKLBWrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5672 /* punpcklbw */, X86::PUNPCKLBWrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5682 /* punpckldq */, X86::MMX_PUNPCKLDQirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5682 /* punpckldq */, X86::MMX_PUNPCKLDQirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5682 /* punpckldq */, X86::PUNPCKLDQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5682 /* punpckldq */, X86::PUNPCKLDQrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5692 /* punpcklqdq */, X86::PUNPCKLQDQrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5692 /* punpcklqdq */, X86::PUNPCKLQDQrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5703 /* punpcklwd */, X86::MMX_PUNPCKLWDirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5703 /* punpcklwd */, X86::MMX_PUNPCKLWDirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5703 /* punpcklwd */, X86::PUNPCKLWDrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5703 /* punpcklwd */, X86::PUNPCKLWDrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5713 /* push */, X86::PUSH16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5713 /* push */, X86::PUSH16rmr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5713 /* push */, X86::PUSH32r, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 5713 /* push */, X86::PUSH32rmr, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 5713 /* push */, X86::PUSH64r, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5713 /* push */, X86::PUSH64rmr, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5713 /* push */, X86::PUSHCS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_CS }, },
  { 5713 /* push */, X86::PUSHCS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_CS }, },
  { 5713 /* push */, X86::PUSHDS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 5713 /* push */, X86::PUSHDS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 5713 /* push */, X86::PUSHSS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 5713 /* push */, X86::PUSHSS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 5713 /* push */, X86::PUSHES16, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 5713 /* push */, X86::PUSHES32, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 5713 /* push */, X86::PUSHFS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_FS }, },
  { 5713 /* push */, X86::PUSHFS64, Convert_NoOperands, Feature_In64BitMode, { MCK_FS }, },
  { 5713 /* push */, X86::PUSHFS16, Convert_NoOperands, 0, { MCK_FS }, },
  { 5713 /* push */, X86::PUSHGS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_GS }, },
  { 5713 /* push */, X86::PUSHGS64, Convert_NoOperands, Feature_In64BitMode, { MCK_GS }, },
  { 5713 /* push */, X86::PUSHGS16, Convert_NoOperands, 0, { MCK_GS }, },
  { 5713 /* push */, X86::PUSH64i8, Convert__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8 }, },
  { 5713 /* push */, X86::PUSH16i8, Convert__ImmSExti16i81_0, Feature_Not64BitMode, { MCK_ImmSExti16i8 }, },
  { 5713 /* push */, X86::PUSH32i8, Convert__ImmSExti32i81_0, Feature_Not64BitMode, { MCK_ImmSExti32i8 }, },
  { 5713 /* push */, X86::PUSH64i32, Convert__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32 }, },
  { 5713 /* push */, X86::PUSH64i16, Convert__Imm1_0, Feature_In64BitMode, { MCK_Imm }, },
  { 5713 /* push */, X86::PUSHi16, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 5713 /* push */, X86::PUSHi32, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 5713 /* push */, X86::PUSH16rmm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 5713 /* push */, X86::PUSH32rmm, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 5713 /* push */, X86::PUSH64rmm, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 5718 /* pushal */, X86::PUSHA32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5725 /* pushaw */, X86::PUSHA16, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5732 /* pushf */, X86::PUSHF16, Convert_NoOperands, 0, {  }, },
  { 5738 /* pushfd */, X86::PUSHF32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5752 /* pushfq */, X86::PUSHF64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 5784 /* pxor */, X86::MMX_PXORirr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_VR64, MCK_VR64 }, },
  { 5784 /* pxor */, X86::MMX_PXORirm, Convert__Reg1_0__Tie0__Mem645_1, 0, { MCK_VR64, MCK_Mem64 }, },
  { 5784 /* pxor */, X86::PXORrr, Convert__Reg1_0__Tie0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5784 /* pxor */, X86::PXORrm, Convert__Reg1_0__Tie0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5789 /* rcl */, X86::RCL8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 5789 /* rcl */, X86::RCL16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 5789 /* rcl */, X86::RCL32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 5789 /* rcl */, X86::RCL64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 5789 /* rcl */, X86::RCL16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 5789 /* rcl */, X86::RCL32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 5789 /* rcl */, X86::RCL64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 5789 /* rcl */, X86::RCL8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5789 /* rcl */, X86::RCL8rCL, Convert__Reg1_0__Tie0, 0, { MCK_GR8, MCK_CL }, },
  { 5789 /* rcl */, X86::RCL8ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR8, MCK_Imm }, },
  { 5789 /* rcl */, X86::RCL16rCL, Convert__Reg1_0__Tie0, 0, { MCK_GR16, MCK_CL }, },
  { 5789 /* rcl */, X86::RCL16ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR16, MCK_Imm }, },
  { 5789 /* rcl */, X86::RCL32rCL, Convert__Reg1_0__Tie0, 0, { MCK_GR32, MCK_CL }, },
  { 5789 /* rcl */, X86::RCL32ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR32, MCK_Imm }, },
  { 5789 /* rcl */, X86::RCL64rCL, Convert__Reg1_0__Tie0, 0, { MCK_GR64, MCK_CL }, },
  { 5789 /* rcl */, X86::RCL64ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR64, MCK_Imm }, },
  { 5789 /* rcl */, X86::RCL16mCL, Convert__Mem165_0, 0, { MCK_Mem16, MCK_CL }, },
  { 5789 /* rcl */, X86::RCL16mi, Convert__Mem165_0__Imm1_1, 0, { MCK_Mem16, MCK_Imm }, },
  { 5789 /* rcl */, X86::RCL32mCL, Convert__Mem325_0, 0, { MCK_Mem32, MCK_CL }, },
  { 5789 /* rcl */, X86::RCL32mi, Convert__Mem325_0__Imm1_1, 0, { MCK_Mem32, MCK_Imm }, },
  { 5789 /* rcl */, X86::RCL64mCL, Convert__Mem645_0, 0, { MCK_Mem64, MCK_CL }, },
  { 5789 /* rcl */, X86::RCL64mi, Convert__Mem645_0__Imm1_1, 0, { MCK_Mem64, MCK_Imm }, },
  { 5789 /* rcl */, X86::RCL8mCL, Convert__Mem85_0, 0, { MCK_Mem8, MCK_CL }, },
  { 5789 /* rcl */, X86::RCL8mi, Convert__Mem85_0__Imm1_1, 0, { MCK_Mem8, MCK_Imm }, },
  { 5813 /* rcpps */, X86::RCPPSr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5813 /* rcpps */, X86::RCPPSm, Convert__Reg1_0__Mem1285_1, 0, { MCK_FR32, MCK_Mem128 }, },
  { 5819 /* rcpss */, X86::RCPSSr, Convert__Reg1_0__Reg1_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 5819 /* rcpss */, X86::RCPSSm, Convert__Reg1_0__Mem325_1, 0, { MCK_FR32, MCK_Mem32 }, },
  { 5825 /* rcr */, X86::RCR8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 5825 /* rcr */, X86::RCR16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 5825 /* rcr */, X86::RCR32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 5825 /* rcr */, X86::RCR64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 5825 /* rcr */, X86::RCR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 5825 /* rcr */, X86::RCR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 5825 /* rcr */, X86::RCR64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 5825 /* rcr */, X86::RCR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5825 /* rcr */, X86::RCR8rCL, Convert__Reg1_0__Tie0, 0, { MCK_GR8, MCK_CL }, },
  { 5825 /* rcr */, X86::RCR8ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR8, MCK_Imm }, },
  { 5825 /* rcr */, X86::RCR16rCL, Convert__Reg1_0__Tie0, 0, { MCK_GR16, MCK_CL }, },
  { 5825 /* rcr */, X86::RCR16ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR16, MCK_Imm }, },
  { 5825 /* rcr */, X86::RCR32rCL, Convert__Reg1_0__Tie0, 0, { MCK_GR32, MCK_CL }, },
  { 5825 /* rcr */, X86::RCR32ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR32, MCK_Imm }, },
  { 5825 /* rcr */, X86::RCR64rCL, Convert__Reg1_0__Tie0, 0, { MCK_GR64, MCK_CL }, },
  { 5825 /* rcr */, X86::RCR64ri, Convert__Reg1_0__Tie0__Imm1_1, 0, { MCK_GR64, MCK_Imm }, },
  { 5825 /* rcr */, X86::RCR16mCL, Convert__Mem165_0, 0, { MCK_Mem16, MCK_CL }, },
  { 5825 /* rcr */, X86::RCR16mi, Convert__Mem165_0__Imm1_1, 0, { MCK_Mem16, MCK_Imm }, },
  { 5825 /* rcr */, X86::RCR32mCL, Convert__Mem325_0, 0, { MCK_Mem32, MCK_CL }, },
  { 5825 /* rcr */, X86::RCR32mi, Convert__Mem325_0__Imm1_1, 0, { MCK_Mem32, MCK_Imm }, },
  { 5825 /* rcr */, X86::RCR64mCL, Convert__Mem645_0, 0, { MCK_Mem64, MCK_CL }, },
  { 5825 /* rcr */, X86::RCR64mi, Convert__Mem645_0__Imm1_1, 0, { MCK_Mem64, MCK_Imm }, },
  { 5825 /* rcr */, X86::RCR8mCL, Convert__Mem85_0, 0, { MCK_Mem8, MCK_CL }, },
  { 5825 /* rcr */, X86::RCR8mi, Convert__Mem85_0__Imm1_1, 0, { MCK_Mem8, MCK_Imm }, },
  { 5849 /* rdfsbase */, X86::RDFSBASE, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR32 }, },
  { 5849 /* rdfsbase */, X86::RDFSBASE64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5878 /* rdgsbase */, X86::RDGSBASE, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR32 }, },
  { 5878 /* rdgsbase */, X86::RDGSBASE64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5907 /* rdmsr */, X86::RDMSR, Convert_NoOperands, 0, {  }, },
  { 5913 /* rdpmc */, X86::RDPMC, Convert_NoOperands, 0, {  }, },
  { 5919 /* rdrand */, X86::RDRAND16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5919 /* rdrand */, X86::RDRAND32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 5919 /* rdrand */, X86::RDRAND64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 5950 /* rdseed */, X86::RDSEED16r, Convert__Reg1_0, 0, 