/* engine.c generated by valac 0.12.0, the Vala compiler
 * generated from engine.vala, do not modify */

/* -*- mode: vala; indent-tabs-mode: nil -*-*/
/* Copyright (C) 2011  Daiki Ueno*/
/* Copyright (C) 2011  Red Hat, Inc.*/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gdk/gdk.h>


#define IBUS_GUCHARMAP_TYPE_ENGINE (ibus_gucharmap_engine_get_type ())
#define IBUS_GUCHARMAP_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_GUCHARMAP_TYPE_ENGINE, IBusGucharmapEngine))
#define IBUS_GUCHARMAP_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_GUCHARMAP_TYPE_ENGINE, IBusGucharmapEngineClass))
#define IBUS_GUCHARMAP_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_GUCHARMAP_TYPE_ENGINE))
#define IBUS_GUCHARMAP_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_GUCHARMAP_TYPE_ENGINE))
#define IBUS_GUCHARMAP_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_GUCHARMAP_TYPE_ENGINE, IBusGucharmapEngineClass))

typedef struct _IBusGucharmapEngine IBusGucharmapEngine;
typedef struct _IBusGucharmapEngineClass IBusGucharmapEngineClass;
typedef struct _IBusGucharmapEnginePrivate IBusGucharmapEnginePrivate;

#define IBUS_GUCHARMAP_TYPE_CHARMAP_PANEL (ibus_gucharmap_charmap_panel_get_type ())
#define IBUS_GUCHARMAP_CHARMAP_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_GUCHARMAP_TYPE_CHARMAP_PANEL, IBusGucharmapCharmapPanel))
#define IBUS_GUCHARMAP_CHARMAP_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_GUCHARMAP_TYPE_CHARMAP_PANEL, IBusGucharmapCharmapPanelClass))
#define IBUS_GUCHARMAP_IS_CHARMAP_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_GUCHARMAP_TYPE_CHARMAP_PANEL))
#define IBUS_GUCHARMAP_IS_CHARMAP_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_GUCHARMAP_TYPE_CHARMAP_PANEL))
#define IBUS_GUCHARMAP_CHARMAP_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_GUCHARMAP_TYPE_CHARMAP_PANEL, IBusGucharmapCharmapPanelClass))

typedef struct _IBusGucharmapCharmapPanel IBusGucharmapCharmapPanel;
typedef struct _IBusGucharmapCharmapPanelClass IBusGucharmapCharmapPanelClass;

#define IBUS_GUCHARMAP_TYPE_SEARCH_PANEL (ibus_gucharmap_search_panel_get_type ())
#define IBUS_GUCHARMAP_SEARCH_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_GUCHARMAP_TYPE_SEARCH_PANEL, IBusGucharmapSearchPanel))
#define IBUS_GUCHARMAP_SEARCH_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_GUCHARMAP_TYPE_SEARCH_PANEL, IBusGucharmapSearchPanelClass))
#define IBUS_GUCHARMAP_IS_SEARCH_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_GUCHARMAP_TYPE_SEARCH_PANEL))
#define IBUS_GUCHARMAP_IS_SEARCH_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_GUCHARMAP_TYPE_SEARCH_PANEL))
#define IBUS_GUCHARMAP_SEARCH_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_GUCHARMAP_TYPE_SEARCH_PANEL, IBusGucharmapSearchPanelClass))

typedef struct _IBusGucharmapSearchPanel IBusGucharmapSearchPanel;
typedef struct _IBusGucharmapSearchPanelClass IBusGucharmapSearchPanelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define IBUS_GUCHARMAP_ENGINE_TYPE_MOVE_BINDING (ibus_gucharmap_engine_move_binding_get_type ())
typedef struct _IBusGucharmapEngineMoveBinding IBusGucharmapEngineMoveBinding;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _IBusGucharmapEngine {
	IBusEngine parent_instance;
	IBusGucharmapEnginePrivate * priv;
};

struct _IBusGucharmapEngineClass {
	IBusEngineClass parent_class;
};

struct _IBusGucharmapEnginePrivate {
	IBusPropList* prop_list;
	GtkWindow* window;
	gint saved_x;
	gint saved_y;
	GtkContainer* panel;
	IBusGucharmapCharmapPanel* charmap_panel;
	IBusGucharmapSearchPanel* search_panel;
};

struct _IBusGucharmapEngineMoveBinding {
	guint keyval;
	guint state;
	GtkMovementStep step;
	gint count;
};


static gpointer ibus_gucharmap_engine_parent_class = NULL;
static GList* ibus_gucharmap_engine_instances;
static GList* ibus_gucharmap_engine_instances = NULL;

GType ibus_gucharmap_engine_get_type (void) G_GNUC_CONST;
GType ibus_gucharmap_charmap_panel_get_type (void) G_GNUC_CONST;
GType ibus_gucharmap_search_panel_get_type (void) G_GNUC_CONST;
#define IBUS_GUCHARMAP_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IBUS_GUCHARMAP_TYPE_ENGINE, IBusGucharmapEnginePrivate))
enum  {
	IBUS_GUCHARMAP_ENGINE_DUMMY_PROPERTY
};
#define IBUS_GUCHARMAP_ENGINE_INITIAL_WIDTH 320
#define IBUS_GUCHARMAP_ENGINE_INITIAL_HEIGHT 240
static GType ibus_gucharmap_engine_move_binding_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static IBusGucharmapEngineMoveBinding* ibus_gucharmap_engine_move_binding_dup (const IBusGucharmapEngineMoveBinding* self);
static void ibus_gucharmap_engine_move_binding_free (IBusGucharmapEngineMoveBinding* self);
static void ibus_gucharmap_engine_real_enable (IBusEngine* base);
static void ibus_gucharmap_engine_show_window (IBusGucharmapEngine* self);
static void ibus_gucharmap_engine_real_disable (IBusEngine* base);
static void ibus_gucharmap_engine_hide_window (IBusGucharmapEngine* self);
static void ibus_gucharmap_engine_real_focus_in (IBusEngine* base);
static void ibus_gucharmap_engine_real_focus_out (IBusEngine* base);
static void ibus_gucharmap_engine_real_property_activate (IBusEngine* base, const gchar* prop_name, guint prop_state);
static void ibus_gucharmap_engine_update_panel (IBusGucharmapEngine* self);
static gboolean ibus_gucharmap_engine_isascii (guint keyval);
static gboolean ibus_gucharmap_engine_process_charmap_key_event (IBusGucharmapEngine* self, guint keyval, guint keycode, guint state);
void ibus_gucharmap_charmap_panel_move_cursor (IBusGucharmapCharmapPanel* self, GtkMovementStep step, gint count);
void ibus_gucharmap_charmap_panel_activate_selected (IBusGucharmapCharmapPanel* self);
void ibus_gucharmap_charmap_panel_popup_chapters (IBusGucharmapCharmapPanel* self);
void ibus_gucharmap_search_panel_append_c (IBusGucharmapSearchPanel* self, gchar c);
static gboolean ibus_gucharmap_engine_process_search_key_event (IBusGucharmapEngine* self, guint keyval, guint keycode, guint state);
void ibus_gucharmap_search_panel_delete_c (IBusGucharmapSearchPanel* self);
gchar* ibus_gucharmap_search_panel_get_text (IBusGucharmapSearchPanel* self);
void ibus_gucharmap_search_panel_move_cursor (IBusGucharmapSearchPanel* self, GtkMovementStep step, gint count);
void ibus_gucharmap_search_panel_activate_selected (IBusGucharmapSearchPanel* self);
void ibus_gucharmap_search_panel_erase (IBusGucharmapSearchPanel* self);
static gboolean ibus_gucharmap_engine_real_process_key_event (IBusEngine* base, guint keyval, guint keycode, guint state);
static void ibus_gucharmap_engine_real_destroy (IBusObject* base);
static void ibus_gucharmap_engine_on_charmap_activate_character (IBusGucharmapEngine* self, gunichar uc);
static void ibus_gucharmap_engine_on_search_activate_character (IBusGucharmapEngine* self, gunichar uc);
static void ibus_gucharmap_engine_real_set_cursor_location (IBusEngine* base, gint x, gint y, gint w, gint h);
IBusGucharmapEngine* ibus_gucharmap_engine_new (void);
IBusGucharmapEngine* ibus_gucharmap_engine_construct (GType object_type);
static GObject * ibus_gucharmap_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
IBusGucharmapCharmapPanel* ibus_gucharmap_charmap_panel_new (void);
IBusGucharmapCharmapPanel* ibus_gucharmap_charmap_panel_construct (GType object_type);
static void _ibus_gucharmap_engine_on_charmap_activate_character_ibus_gucharmap_charmap_panel_activate_character (IBusGucharmapCharmapPanel* _sender, gunichar uc, gpointer self);
IBusGucharmapSearchPanel* ibus_gucharmap_search_panel_new (void);
IBusGucharmapSearchPanel* ibus_gucharmap_search_panel_construct (GType object_type);
static void _ibus_gucharmap_engine_on_search_activate_character_ibus_gucharmap_search_panel_activate_character (IBusGucharmapSearchPanel* _sender, gunichar uc, gpointer self);
static void _lambda1_ (IBusGucharmapEngine* self);
static void __lambda1__gtk_widget_hide (GtkWidget* _sender, gpointer self);
static void ibus_gucharmap_engine_finalize (GObject* obj);

static const IBusGucharmapEngineMoveBinding IBUS_GUCHARMAP_ENGINE_move_bindings[16] = {{(guint) IBUS_Up, (guint) 0, GTK_MOVEMENT_DISPLAY_LINES, -1}, {(guint) IBUS_KP_Up, (guint) 0, GTK_MOVEMENT_DISPLAY_LINES, -1}, {(guint) IBUS_Down, (guint) 0, GTK_MOVEMENT_DISPLAY_LINES, 1}, {(guint) IBUS_KP_Down, (guint) 0, GTK_MOVEMENT_DISPLAY_LINES, 1}, {(guint) IBUS_Home, (guint) 0, GTK_MOVEMENT_BUFFER_ENDS, -1}, {(guint) IBUS_KP_Home, (guint) 0, GTK_MOVEMENT_BUFFER_ENDS, -1}, {(guint) IBUS_End, (guint) 0, GTK_MOVEMENT_BUFFER_ENDS, 1}, {(guint) IBUS_KP_End, (guint) 0, GTK_MOVEMENT_BUFFER_ENDS, 1}, {(guint) IBUS_Page_Up, (guint) 0, GTK_MOVEMENT_PAGES, -1}, {(guint) IBUS_KP_Page_Up, (guint) 0, GTK_MOVEMENT_PAGES, -1}, {(guint) IBUS_Page_Down, (guint) 0, GTK_MOVEMENT_PAGES, 1}, {(guint) IBUS_KP_Page_Down, (guint) 0, GTK_MOVEMENT_PAGES, 1}, {(guint) IBUS_Left, (guint) 0, GTK_MOVEMENT_VISUAL_POSITIONS, -1}, {(guint) IBUS_KP_Left, (guint) 0, GTK_MOVEMENT_VISUAL_POSITIONS, -1}, {(guint) IBUS_Right, (guint) 0, GTK_MOVEMENT_VISUAL_POSITIONS, 1}, {(guint) IBUS_KP_Right, (guint) 0, GTK_MOVEMENT_VISUAL_POSITIONS, 1}};

static void ibus_gucharmap_engine_real_enable (IBusEngine* base) {
	IBusGucharmapEngine * self;
	self = (IBusGucharmapEngine*) base;
	ibus_gucharmap_engine_show_window (self);
}


static void ibus_gucharmap_engine_real_disable (IBusEngine* base) {
	IBusGucharmapEngine * self;
	self = (IBusGucharmapEngine*) base;
	ibus_gucharmap_engine_hide_window (self);
}


static void ibus_gucharmap_engine_real_focus_in (IBusEngine* base) {
	IBusGucharmapEngine * self;
	self = (IBusGucharmapEngine*) base;
	ibus_engine_register_properties ((IBusEngine*) self, self->priv->prop_list);
	ibus_gucharmap_engine_show_window (self);
}


static void ibus_gucharmap_engine_real_focus_out (IBusEngine* base) {
	IBusGucharmapEngine * self;
	self = (IBusGucharmapEngine*) base;
	ibus_gucharmap_engine_hide_window (self);
}


static void ibus_gucharmap_engine_real_property_activate (IBusEngine* base, const gchar* prop_name, guint prop_state) {
	IBusGucharmapEngine * self;
	GError * _inner_error_ = NULL;
	self = (IBusGucharmapEngine*) base;
	g_return_if_fail (prop_name != NULL);
	if (g_strcmp0 (prop_name, "setup") == 0) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf ("%s/ibus-setup-gucharmap", LIBEXECDIR);
		_tmp1_ = _tmp0_;
		g_spawn_command_line_async (_tmp1_, &_inner_error_);
		_g_free0 (_tmp1_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ibus_gucharmap_engine_update_panel (IBusGucharmapEngine* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* current;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) self->priv->window);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	current = _tmp1_;
	gtk_widget_hide (current);
	gtk_container_remove ((GtkContainer*) self->priv->window, current);
	gtk_widget_show_all ((GtkWidget*) self->priv->panel);
	gtk_container_add ((GtkContainer*) self->priv->window, (GtkWidget*) self->priv->panel);
	ibus_gucharmap_engine_show_window (self);
	_g_object_unref0 (current);
}


static gboolean ibus_gucharmap_engine_isascii (guint keyval) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if (0x20 <= keyval) {
		_tmp0_ = keyval <= 0x7E;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean ibus_gucharmap_engine_process_charmap_key_event (IBusGucharmapEngine* self, guint keyval, guint keycode, guint state) {
	gboolean result = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((IBUS_RELEASE_MASK & state) != 0) {
		result = FALSE;
		return result;
	}
	{
		IBusGucharmapEngineMoveBinding* binding_collection;
		int binding_collection_length1;
		int binding_it;
		binding_collection = IBUS_GUCHARMAP_ENGINE_move_bindings;
		binding_collection_length1 = G_N_ELEMENTS (IBUS_GUCHARMAP_ENGINE_move_bindings);
		for (binding_it = 0; binding_it < G_N_ELEMENTS (IBUS_GUCHARMAP_ENGINE_move_bindings); binding_it = binding_it + 1) {
			IBusGucharmapEngineMoveBinding binding;
			binding = binding_collection[binding_it];
			{
				gboolean _tmp0_ = FALSE;
				if (binding.keyval == keyval) {
					_tmp0_ = binding.state == state;
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					ibus_gucharmap_charmap_panel_move_cursor (self->priv->charmap_panel, binding.step, binding.count);
					result = TRUE;
					return result;
				}
			}
		}
	}
	if (keyval == IBUS_Return) {
		_tmp1_ = state == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ibus_gucharmap_charmap_panel_activate_selected (self->priv->charmap_panel);
		result = TRUE;
		return result;
	}
	if ((IBUS_MOD1_MASK & state) != 0) {
		gboolean _tmp3_ = FALSE;
		if (keyval == IBUS_Down) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = keyval == IBUS_KP_Down;
		}
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ibus_gucharmap_charmap_panel_popup_chapters (self->priv->charmap_panel);
		result = TRUE;
		return result;
	}
	if (state == 0) {
		gboolean _tmp5_;
		_tmp5_ = ibus_gucharmap_engine_isascii (keyval);
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar c;
		GtkContainer* _tmp6_;
		c = (gchar) keyval;
		ibus_gucharmap_search_panel_append_c (self->priv->search_panel, c);
		_tmp6_ = _g_object_ref0 ((GtkContainer*) self->priv->search_panel);
		_g_object_unref0 (self->priv->panel);
		self->priv->panel = _tmp6_;
		ibus_gucharmap_engine_update_panel (self);
		result = TRUE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean ibus_gucharmap_engine_process_search_key_event (IBusGucharmapEngine* self, guint keyval, guint keycode, guint state) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((IBUS_RELEASE_MASK & state) != 0) {
		result = FALSE;
		return result;
	}
	if (state == 0) {
		gboolean _tmp1_;
		_tmp1_ = ibus_gucharmap_engine_isascii (keyval);
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar c;
		c = (gchar) keyval;
		ibus_gucharmap_search_panel_append_c (self->priv->search_panel, c);
		result = TRUE;
		return result;
	}
	if (keyval == IBUS_BackSpace) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gint _tmp4_;
		gboolean _tmp5_;
		ibus_gucharmap_search_panel_delete_c (self->priv->search_panel);
		_tmp2_ = ibus_gucharmap_search_panel_get_text (self->priv->search_panel);
		_tmp3_ = _tmp2_;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_ == 0;
		_g_free0 (_tmp3_);
		if (_tmp5_) {
			GtkContainer* _tmp6_;
			_tmp6_ = _g_object_ref0 ((GtkContainer*) self->priv->charmap_panel);
			_g_object_unref0 (self->priv->panel);
			self->priv->panel = _tmp6_;
			ibus_gucharmap_engine_update_panel (self);
		}
		result = TRUE;
		return result;
	}
	{
		IBusGucharmapEngineMoveBinding* binding_collection;
		int binding_collection_length1;
		int binding_it;
		binding_collection = IBUS_GUCHARMAP_ENGINE_move_bindings;
		binding_collection_length1 = G_N_ELEMENTS (IBUS_GUCHARMAP_ENGINE_move_bindings);
		for (binding_it = 0; binding_it < G_N_ELEMENTS (IBUS_GUCHARMAP_ENGINE_move_bindings); binding_it = binding_it + 1) {
			IBusGucharmapEngineMoveBinding binding;
			binding = binding_collection[binding_it];
			{
				gboolean _tmp7_ = FALSE;
				if (binding.keyval == keyval) {
					_tmp7_ = binding.state == state;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					ibus_gucharmap_search_panel_move_cursor (self->priv->search_panel, binding.step, binding.count);
					result = TRUE;
					return result;
				}
			}
		}
	}
	if (keyval == IBUS_Return) {
		ibus_gucharmap_search_panel_activate_selected (self->priv->search_panel);
		result = TRUE;
		return result;
	}
	if (keyval == IBUS_Escape) {
		GtkContainer* _tmp8_;
		ibus_gucharmap_search_panel_erase (self->priv->search_panel);
		_tmp8_ = _g_object_ref0 ((GtkContainer*) self->priv->charmap_panel);
		_g_object_unref0 (self->priv->panel);
		self->priv->panel = _tmp8_;
		ibus_gucharmap_engine_update_panel (self);
		result = TRUE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean ibus_gucharmap_engine_real_process_key_event (IBusEngine* base, guint keyval, guint keycode, guint state) {
	IBusGucharmapEngine * self;
	gboolean result = FALSE;
	self = (IBusGucharmapEngine*) base;
	if (self->priv->panel == GTK_CONTAINER (self->priv->charmap_panel)) {
		gboolean _tmp0_;
		_tmp0_ = ibus_gucharmap_engine_process_charmap_key_event (self, keyval, keycode, state);
		result = _tmp0_;
		return result;
	} else {
		gboolean _tmp1_;
		_tmp1_ = ibus_gucharmap_engine_process_search_key_event (self, keyval, keycode, state);
		result = _tmp1_;
		return result;
	}
}


static void ibus_gucharmap_engine_real_destroy (IBusObject* base) {
	IBusGucharmapEngine * self;
	self = (IBusGucharmapEngine*) base;
	gtk_widget_destroy ((GtkWidget*) self->priv->window);
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


static void ibus_gucharmap_engine_on_charmap_activate_character (IBusGucharmapEngine* self, gunichar uc) {
	g_return_if_fail (self != NULL);
	if (uc > 0) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		IBusText* _tmp2_ = NULL;
		IBusText* _tmp3_;
		_tmp0_ = g_unichar_to_string (uc);
		_tmp1_ = _tmp0_;
		_tmp2_ = ibus_text_new_from_string (_tmp1_);
		_tmp3_ = g_object_ref_sink (_tmp2_);
		ibus_engine_commit_text ((IBusEngine*) self, _tmp3_);
		_g_object_unref0 (_tmp3_);
		_g_free0 (_tmp1_);
	}
}


static void ibus_gucharmap_engine_on_search_activate_character (IBusGucharmapEngine* self, gunichar uc) {
	GtkContainer* _tmp0_;
	g_return_if_fail (self != NULL);
	ibus_gucharmap_search_panel_erase (self->priv->search_panel);
	g_signal_emit_by_name (self->priv->charmap_panel, "activate-character", uc);
	_tmp0_ = _g_object_ref0 ((GtkContainer*) self->priv->charmap_panel);
	_g_object_unref0 (self->priv->panel);
	self->priv->panel = _tmp0_;
	ibus_gucharmap_engine_update_panel (self);
}


static void ibus_gucharmap_engine_show_window (IBusGucharmapEngine* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	gtk_widget_show_all ((GtkWidget*) self->priv->window);
	if (self->priv->saved_x >= 0) {
		_tmp0_ = self->priv->saved_y >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_window_move (self->priv->window, self->priv->saved_x, self->priv->saved_y);
	}
}


static void ibus_gucharmap_engine_hide_window (IBusGucharmapEngine* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->window != NULL) {
		gtk_widget_hide ((GtkWidget*) self->priv->window);
	}
}


static void ibus_gucharmap_engine_real_set_cursor_location (IBusEngine* base, gint x, gint y, gint w, gint h) {
	IBusGucharmapEngine * self;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gint rx = 0;
	gint ry = 0;
	gint rw = 0;
	gint rh = 0;
	GdkWindow* _tmp1_ = NULL;
	GdkWindow* _tmp2_;
	GdkWindow* root_window;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_ = FALSE;
	self = (IBusGucharmapEngine*) base;
	if (self->priv->window == NULL) {
		return;
	}
	gtk_widget_get_allocation ((GtkWidget*) self->priv->window, &_tmp0_);
	allocation = _tmp0_;
	_tmp1_ = gdk_get_default_root_window ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	root_window = _tmp2_;
	gdk_window_get_geometry (root_window, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	rx = _tmp3_;
	ry = _tmp4_;
	rw = _tmp5_;
	rh = _tmp6_;
	if ((x + allocation.width) > rw) {
		x = x - allocation.width;
	}
	_tmp7_ = MAX (x, rx);
	x = _tmp7_;
	if (((y + h) + allocation.height) > rh) {
		y = y - allocation.height;
	} else {
		y = y + h;
	}
	_tmp8_ = MAX (y, ry);
	y = _tmp8_;
	if (x != self->priv->saved_x) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = y != self->priv->saved_y;
	}
	if (_tmp9_) {
		gtk_window_move (self->priv->window, x, y);
		self->priv->saved_x = x;
		self->priv->saved_y = y;
	}
	_g_object_unref0 (root_window);
}


IBusGucharmapEngine* ibus_gucharmap_engine_construct (GType object_type) {
	IBusGucharmapEngine * self = NULL;
	self = (IBusGucharmapEngine*) g_object_new (object_type, NULL);
	return self;
}


IBusGucharmapEngine* ibus_gucharmap_engine_new (void) {
	return ibus_gucharmap_engine_construct (IBUS_GUCHARMAP_TYPE_ENGINE);
}


static void _ibus_gucharmap_engine_on_charmap_activate_character_ibus_gucharmap_charmap_panel_activate_character (IBusGucharmapCharmapPanel* _sender, gunichar uc, gpointer self) {
	ibus_gucharmap_engine_on_charmap_activate_character (self, uc);
}


static void _ibus_gucharmap_engine_on_search_activate_character_ibus_gucharmap_search_panel_activate_character (IBusGucharmapSearchPanel* _sender, gunichar uc, gpointer self) {
	ibus_gucharmap_engine_on_search_activate_character (self, uc);
}


static void _lambda1_ (IBusGucharmapEngine* self) {
	gtk_widget_hide ((GtkWidget*) self->priv->charmap_panel);
}


static void __lambda1__gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	_lambda1_ (self);
}


static GObject * ibus_gucharmap_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	IBusGucharmapEngine * self;
	GtkWindow* _tmp0_ = NULL;
	IBusGucharmapCharmapPanel* _tmp1_ = NULL;
	IBusGucharmapSearchPanel* _tmp2_ = NULL;
	GtkContainer* _tmp3_;
	IBusGucharmapEngine* _tmp5_;
	IBusPropList* _tmp6_ = NULL;
	IBusText* _tmp7_ = NULL;
	IBusText* _tmp8_;
	IBusText* _tmp9_ = NULL;
	IBusText* _tmp10_;
	IBusProperty* _tmp11_ = NULL;
	IBusProperty* _tmp12_;
	IBusProperty* prop;
	parent_class = G_OBJECT_CLASS (ibus_gucharmap_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = IBUS_GUCHARMAP_ENGINE (obj);
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	_g_object_unref0 (self->priv->window);
	self->priv->window = g_object_ref_sink (_tmp0_);
	gtk_widget_set_size_request ((GtkWidget*) self->priv->window, IBUS_GUCHARMAP_ENGINE_INITIAL_WIDTH, IBUS_GUCHARMAP_ENGINE_INITIAL_HEIGHT);
	_tmp1_ = ibus_gucharmap_charmap_panel_new ();
	_g_object_unref0 (self->priv->charmap_panel);
	self->priv->charmap_panel = g_object_ref_sink (_tmp1_);
	g_signal_connect_object (self->priv->charmap_panel, "activate-character", (GCallback) _ibus_gucharmap_engine_on_charmap_activate_character_ibus_gucharmap_charmap_panel_activate_character, self, 0);
	_tmp2_ = ibus_gucharmap_search_panel_new ();
	_g_object_unref0 (self->priv->search_panel);
	self->priv->search_panel = g_object_ref_sink (_tmp2_);
	g_signal_connect_object (self->priv->search_panel, "activate-character", (GCallback) _ibus_gucharmap_engine_on_search_activate_character_ibus_gucharmap_search_panel_activate_character, self, 0);
	_tmp3_ = _g_object_ref0 ((GtkContainer*) self->priv->charmap_panel);
	_g_object_unref0 (self->priv->panel);
	self->priv->panel = _tmp3_;
	gtk_container_add ((GtkContainer*) self->priv->window, (GtkWidget*) self->priv->panel);
	g_signal_connect_object ((GtkWidget*) self->priv->window, "hide", (GCallback) __lambda1__gtk_widget_hide, self, 0);
	{
		GList* engine_collection;
		GList* engine_it;
		engine_collection = ibus_gucharmap_engine_instances;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusGucharmapEngine* _tmp4_;
			IBusGucharmapEngine* engine;
			_tmp4_ = _g_object_ref0 ((IBusGucharmapEngine*) engine_it->data);
			engine = _tmp4_;
			{
				g_signal_emit_by_name ((IBusEngine*) engine, "disable");
				_g_object_unref0 (engine);
			}
		}
	}
	_tmp5_ = _g_object_ref0 (self);
	ibus_gucharmap_engine_instances = g_list_append (ibus_gucharmap_engine_instances, _tmp5_);
	_tmp6_ = ibus_prop_list_new ();
	_g_object_unref0 (self->priv->prop_list);
	self->priv->prop_list = g_object_ref_sink (_tmp6_);
	_tmp7_ = ibus_text_new_from_string ("Setup");
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_tmp9_ = ibus_text_new_from_string ("Configure Gucharmap engine");
	_tmp10_ = g_object_ref_sink (_tmp9_);
	_tmp11_ = ibus_property_new ("setup", PROP_TYPE_NORMAL, _tmp8_, "gtk-preferences", _tmp10_, TRUE, TRUE, PROP_STATE_UNCHECKED, NULL);
	_tmp12_ = g_object_ref_sink (_tmp11_);
	_g_object_unref0 (_tmp10_);
	_g_object_unref0 (_tmp8_);
	prop = _tmp12_;
	ibus_prop_list_append (self->priv->prop_list, prop);
	_g_object_unref0 (prop);
	return obj;
}


static IBusGucharmapEngineMoveBinding* ibus_gucharmap_engine_move_binding_dup (const IBusGucharmapEngineMoveBinding* self) {
	IBusGucharmapEngineMoveBinding* dup;
	dup = g_new0 (IBusGucharmapEngineMoveBinding, 1);
	memcpy (dup, self, sizeof (IBusGucharmapEngineMoveBinding));
	return dup;
}


static void ibus_gucharmap_engine_move_binding_free (IBusGucharmapEngineMoveBinding* self) {
	g_free (self);
}


static GType ibus_gucharmap_engine_move_binding_get_type (void) {
	static volatile gsize ibus_gucharmap_engine_move_binding_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_gucharmap_engine_move_binding_type_id__volatile)) {
		GType ibus_gucharmap_engine_move_binding_type_id;
		ibus_gucharmap_engine_move_binding_type_id = g_boxed_type_register_static ("IBusGucharmapEngineMoveBinding", (GBoxedCopyFunc) ibus_gucharmap_engine_move_binding_dup, (GBoxedFreeFunc) ibus_gucharmap_engine_move_binding_free);
		g_once_init_leave (&ibus_gucharmap_engine_move_binding_type_id__volatile, ibus_gucharmap_engine_move_binding_type_id);
	}
	return ibus_gucharmap_engine_move_binding_type_id__volatile;
}


static void ibus_gucharmap_engine_class_init (IBusGucharmapEngineClass * klass) {
	ibus_gucharmap_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusGucharmapEnginePrivate));
	IBUS_ENGINE_CLASS (klass)->enable = ibus_gucharmap_engine_real_enable;
	IBUS_ENGINE_CLASS (klass)->disable = ibus_gucharmap_engine_real_disable;
	IBUS_ENGINE_CLASS (klass)->focus_in = ibus_gucharmap_engine_real_focus_in;
	IBUS_ENGINE_CLASS (klass)->focus_out = ibus_gucharmap_engine_real_focus_out;
	IBUS_ENGINE_CLASS (klass)->property_activate = ibus_gucharmap_engine_real_property_activate;
	IBUS_ENGINE_CLASS (klass)->process_key_event = ibus_gucharmap_engine_real_process_key_event;
	IBUS_OBJECT_CLASS (klass)->destroy = ibus_gucharmap_engine_real_destroy;
	IBUS_ENGINE_CLASS (klass)->set_cursor_location = ibus_gucharmap_engine_real_set_cursor_location;
	G_OBJECT_CLASS (klass)->constructor = ibus_gucharmap_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = ibus_gucharmap_engine_finalize;
}


static void ibus_gucharmap_engine_instance_init (IBusGucharmapEngine * self) {
	self->priv = IBUS_GUCHARMAP_ENGINE_GET_PRIVATE (self);
}


static void ibus_gucharmap_engine_finalize (GObject* obj) {
	IBusGucharmapEngine * self;
	self = IBUS_GUCHARMAP_ENGINE (obj);
	_g_object_unref0 (self->priv->prop_list);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->panel);
	_g_object_unref0 (self->priv->charmap_panel);
	_g_object_unref0 (self->priv->search_panel);
	G_OBJECT_CLASS (ibus_gucharmap_engine_parent_class)->finalize (obj);
}


GType ibus_gucharmap_engine_get_type (void) {
	static volatile gsize ibus_gucharmap_engine_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_gucharmap_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusGucharmapEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_gucharmap_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusGucharmapEngine), 0, (GInstanceInitFunc) ibus_gucharmap_engine_instance_init, NULL };
		GType ibus_gucharmap_engine_type_id;
		ibus_gucharmap_engine_type_id = g_type_register_static (IBUS_TYPE_ENGINE, "IBusGucharmapEngine", &g_define_type_info, 0);
		g_once_init_leave (&ibus_gucharmap_engine_type_id__volatile, ibus_gucharmap_engine_type_id);
	}
	return ibus_gucharmap_engine_type_id__volatile;
}



