/* gen-index.c generated by valac 0.12.0, the Vala compiler
 * generated from gen-index.vala, do not modify */

/* -*- mode: vala; indent-tabs-mode: nil -*-*/
/* Copyright (C) 2011  Daiki Ueno*/
/* Copyright (C) 2011  Red Hat, Inc.*/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gucharmap/gucharmap.h>
#include <stdio.h>
#include <gtk/gtk.h>


#define IBUS_GUCHARMAP_TYPE_INDEX_GENERATOR (ibus_gucharmap_index_generator_get_type ())
#define IBUS_GUCHARMAP_INDEX_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_GUCHARMAP_TYPE_INDEX_GENERATOR, IBusGucharmapIndexGenerator))
#define IBUS_GUCHARMAP_INDEX_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_GUCHARMAP_TYPE_INDEX_GENERATOR, IBusGucharmapIndexGeneratorClass))
#define IBUS_GUCHARMAP_IS_INDEX_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_GUCHARMAP_TYPE_INDEX_GENERATOR))
#define IBUS_GUCHARMAP_IS_INDEX_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_GUCHARMAP_TYPE_INDEX_GENERATOR))
#define IBUS_GUCHARMAP_INDEX_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_GUCHARMAP_TYPE_INDEX_GENERATOR, IBusGucharmapIndexGeneratorClass))

typedef struct _IBusGucharmapIndexGenerator IBusGucharmapIndexGenerator;
typedef struct _IBusGucharmapIndexGeneratorClass IBusGucharmapIndexGeneratorClass;
typedef struct _IBusGucharmapIndexGeneratorPrivate IBusGucharmapIndexGeneratorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))

struct _IBusGucharmapIndexGenerator {
	GObject parent_instance;
	IBusGucharmapIndexGeneratorPrivate * priv;
};

struct _IBusGucharmapIndexGeneratorClass {
	GObjectClass parent_class;
};

struct _IBusGucharmapIndexGeneratorPrivate {
	gchar* filename;
};


static gpointer ibus_gucharmap_index_generator_parent_class = NULL;

GType ibus_gucharmap_index_generator_get_type (void) G_GNUC_CONST;
#define IBUS_GUCHARMAP_INDEX_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IBUS_GUCHARMAP_TYPE_INDEX_GENERATOR, IBusGucharmapIndexGeneratorPrivate))
enum  {
	IBUS_GUCHARMAP_INDEX_GENERATOR_DUMMY_PROPERTY
};
#define IBUS_GUCHARMAP_INDEX_GENERATOR_create_schema "\n" \
"DROP TABLE IF EXISTS unicode_blocks;\n" \
"CREATE TABLE unicode_blocks (\n" \
"    id INTEGER PRIMARY KEY ASC,\n" \
"    name TEXT,\n" \
"    first_codepoint INTEGER,\n" \
"    last_codepoint INTEGER\n" \
");\n" \
"\n" \
"DROP INDEX IF EXISTS unicode_blocks_by_name;\n" \
"CREATE INDEX unicode_blocks_by_name ON unicode_blocks (name);\n" \
"\n" \
"DROP TABLE IF EXISTS unicode_names;\n" \
"CREATE TABLE unicode_names (\n" \
"    codepoint INTEGER PRIMARY KEY,\n" \
"    name TEXT,\n" \
"    block_id INTEGER\n" \
");\n" \
"\n" \
"DROP INDEX IF EXISTS unicode_names_by_name;\n" \
"CREATE INDEX unicode_names_by_name ON unicode_names (name);\n"
IBusGucharmapIndexGenerator* ibus_gucharmap_index_generator_new (const gchar* filename);
IBusGucharmapIndexGenerator* ibus_gucharmap_index_generator_construct (GType object_type, const gchar* filename);
static gboolean ibus_gucharmap_index_generator_insert_block (IBusGucharmapIndexGenerator* self, sqlite3* database, GucharmapBlockChaptersModel* model, gint block_id, guint first_codepoint, guint last_codepoint);
static gboolean ibus_gucharmap_index_generator_insert_blocks (IBusGucharmapIndexGenerator* self, sqlite3* database);
gboolean ibus_gucharmap_index_generator_generate (IBusGucharmapIndexGenerator* self);
static void ibus_gucharmap_index_generator_finalize (GObject* obj);
gint ibus_gucharmap_main (gchar** args, int args_length1);


IBusGucharmapIndexGenerator* ibus_gucharmap_index_generator_construct (GType object_type, const gchar* filename) {
	IBusGucharmapIndexGenerator * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (IBusGucharmapIndexGenerator*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (filename);
	_g_free0 (self->priv->filename);
	self->priv->filename = _tmp0_;
	return self;
}


IBusGucharmapIndexGenerator* ibus_gucharmap_index_generator_new (const gchar* filename) {
	return ibus_gucharmap_index_generator_construct (IBUS_GUCHARMAP_TYPE_INDEX_GENERATOR, filename);
}


static gboolean ibus_gucharmap_index_generator_insert_block (IBusGucharmapIndexGenerator* self, sqlite3* database, GucharmapBlockChaptersModel* model, gint block_id, guint first_codepoint, guint last_codepoint) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (database != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	{
		guint uc;
		uc = first_codepoint;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gchar* _tmp2_;
				gchar* sql;
				gint rc = 0;
				sqlite3_stmt* stmt = NULL;
				gint _tmp3_;
				sqlite3_stmt* _tmp4_ = NULL;
				gint _tmp5_;
				gint _tmp7_;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* name;
				gchar* _tmp11_ = NULL;
				gint _tmp12_;
				gint _tmp14_;
				gint _tmp16_;
				if (!_tmp0_) {
					uc++;
				}
				_tmp0_ = FALSE;
				if (!(uc < last_codepoint)) {
					break;
				}
				_tmp1_ = gucharmap_unichar_isdefined ((gunichar) uc);
				if (!_tmp1_) {
					continue;
				}
				_tmp2_ = g_strdup ("INSERT INTO unicode_names VALUES (?, ?, ?);");
				sql = _tmp2_;
				_tmp3_ = strlen (sql);
				_tmp5_ = sqlite3_prepare (database, sql, _tmp3_, &_tmp4_, NULL);
				_sqlite3_finalize0 (stmt);
				stmt = _tmp4_;
				rc = _tmp5_;
				if (rc != SQLITE_OK) {
					const gchar* _tmp6_ = NULL;
					_tmp6_ = sqlite3_errmsg (database);
					fprintf (stderr, "can't prepare statement: %s\n", _tmp6_);
					result = FALSE;
					_sqlite3_finalize0 (stmt);
					_g_free0 (sql);
					return result;
				}
				_tmp7_ = sqlite3_bind_int64 (stmt, 1, (gint64) uc);
				rc = _tmp7_;
				if (rc != SQLITE_OK) {
					const gchar* _tmp8_ = NULL;
					_tmp8_ = sqlite3_errmsg (database);
					fprintf (stderr, "can't bind values: %s\n", _tmp8_);
					result = FALSE;
					_sqlite3_finalize0 (stmt);
					_g_free0 (sql);
					return result;
				}
				_tmp9_ = gucharmap_get_unicode_name ((gunichar) uc);
				_tmp10_ = g_strdup (_tmp9_);
				name = _tmp10_;
				_tmp11_ = g_strdup (name);
				_tmp12_ = sqlite3_bind_text (stmt, 2, _tmp11_, -1, g_free);
				rc = _tmp12_;
				if (rc != SQLITE_OK) {
					const gchar* _tmp13_ = NULL;
					_tmp13_ = sqlite3_errmsg (database);
					fprintf (stderr, "can't bind values: %s\n", _tmp13_);
					result = FALSE;
					_g_free0 (name);
					_sqlite3_finalize0 (stmt);
					_g_free0 (sql);
					return result;
				}
				_tmp14_ = sqlite3_bind_int64 (stmt, 3, (gint64) block_id);
				rc = _tmp14_;
				if (rc != SQLITE_OK) {
					const gchar* _tmp15_ = NULL;
					_tmp15_ = sqlite3_errmsg (database);
					fprintf (stderr, "can't bind values: %s\n", _tmp15_);
					result = FALSE;
					_g_free0 (name);
					_sqlite3_finalize0 (stmt);
					_g_free0 (sql);
					return result;
				}
				_tmp16_ = sqlite3_step (stmt);
				rc = _tmp16_;
				if (rc != SQLITE_DONE) {
					const gchar* _tmp17_ = NULL;
					_tmp17_ = sqlite3_errmsg (database);
					fprintf (stderr, "can't commit the change: %s\n", _tmp17_);
					result = FALSE;
					_g_free0 (name);
					_sqlite3_finalize0 (stmt);
					_g_free0 (sql);
					return result;
				}
				_g_free0 (name);
				_sqlite3_finalize0 (stmt);
				_g_free0 (sql);
			}
		}
	}
	result = TRUE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean ibus_gucharmap_index_generator_insert_blocks (IBusGucharmapIndexGenerator* self, sqlite3* database) {
	gboolean result = FALSE;
	GucharmapBlockChaptersModel* _tmp0_ = NULL;
	GucharmapBlockChaptersModel* model;
	GtkTreeIter iter = {0};
	gint block_id = 0;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (database != NULL, FALSE);
	_tmp0_ = (GucharmapBlockChaptersModel*) gucharmap_block_chapters_model_new ();
	model = _tmp0_;
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) model, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		_g_object_unref0 (model);
		return result;
	}
	block_id = 1;
	{
		gboolean _tmp3_;
		_tmp3_ = TRUE;
		while (TRUE) {
			gchar* name = NULL;
			gchar* _tmp5_;
			gchar* sql;
			gint rc = 0;
			sqlite3_stmt* stmt = NULL;
			gint _tmp6_;
			sqlite3_stmt* _tmp7_ = NULL;
			gint _tmp8_;
			gchar* _tmp10_ = NULL;
			gint _tmp11_;
			GucharmapCodepointList* _tmp13_ = NULL;
			GucharmapBlockCodepointList* _tmp14_;
			GucharmapBlockCodepointList* codepoint_list;
			guint _tmp15_;
			gint _tmp16_;
			guint _tmp18_;
			gint _tmp19_;
			gint _tmp21_;
			gint _tmp23_;
			guint _tmp24_;
			guint _tmp25_;
			if (!_tmp3_) {
				gboolean _tmp4_;
				_tmp4_ = gtk_tree_model_iter_next ((GtkTreeModel*) model, &iter);
				if (!_tmp4_) {
					break;
				}
			}
			_tmp3_ = FALSE;
			gtk_tree_model_get ((GtkTreeModel*) model, &iter, 0, &name, -1);
			if (g_strcmp0 (name, "All") == 0) {
				block_id++;
				_g_free0 (name);
				continue;
			}
			_tmp5_ = g_strdup ("INSERT INTO unicode_blocks VALUES (?, ?, ?, ?);");
			sql = _tmp5_;
			_tmp6_ = strlen (sql);
			_tmp8_ = sqlite3_prepare (database, sql, _tmp6_, &_tmp7_, NULL);
			_sqlite3_finalize0 (stmt);
			stmt = _tmp7_;
			rc = _tmp8_;
			if (rc != SQLITE_OK) {
				const gchar* _tmp9_ = NULL;
				_tmp9_ = sqlite3_errmsg (database);
				fprintf (stderr, "can't prepare statement: %s\n", _tmp9_);
				result = FALSE;
				_sqlite3_finalize0 (stmt);
				_g_free0 (sql);
				_g_free0 (name);
				_g_object_unref0 (model);
				return result;
			}
			_tmp10_ = g_strdup (name);
			_tmp11_ = sqlite3_bind_text (stmt, 2, _tmp10_, -1, g_free);
			rc = _tmp11_;
			if (rc != SQLITE_OK) {
				const gchar* _tmp12_ = NULL;
				_tmp12_ = sqlite3_errmsg (database);
				fprintf (stderr, "can't bind values: %s\n", _tmp12_);
				result = FALSE;
				_sqlite3_finalize0 (stmt);
				_g_free0 (sql);
				_g_free0 (name);
				_g_object_unref0 (model);
				return result;
			}
			_tmp13_ = gucharmap_chapters_model_get_codepoint_list ((GucharmapChaptersModel*) model, &iter);
			_tmp14_ = _g_object_ref0 (GUCHARMAP_BLOCK_CODEPOINT_LIST (_tmp13_));
			codepoint_list = _tmp14_;
			g_object_get (codepoint_list, "first-codepoint", &_tmp15_, NULL);
			_tmp16_ = sqlite3_bind_int64 (stmt, 3, (gint64) _tmp15_);
			rc = _tmp16_;
			if (rc != SQLITE_OK) {
				const gchar* _tmp17_ = NULL;
				_tmp17_ = sqlite3_errmsg (database);
				fprintf (stderr, "can't bind values: %s\n", _tmp17_);
				result = FALSE;
				_g_object_unref0 (codepoint_list);
				_sqlite3_finalize0 (stmt);
				_g_free0 (sql);
				_g_free0 (name);
				_g_object_unref0 (model);
				return result;
			}
			g_object_get (codepoint_list, "last-codepoint", &_tmp18_, NULL);
			_tmp19_ = sqlite3_bind_int64 (stmt, 4, (gint64) _tmp18_);
			rc = _tmp19_;
			if (rc != SQLITE_OK) {
				const gchar* _tmp20_ = NULL;
				_tmp20_ = sqlite3_errmsg (database);
				fprintf (stderr, "can't bind values: %s\n", _tmp20_);
				result = FALSE;
				_g_object_unref0 (codepoint_list);
				_sqlite3_finalize0 (stmt);
				_g_free0 (sql);
				_g_free0 (name);
				_g_object_unref0 (model);
				return result;
			}
			_tmp21_ = sqlite3_step (stmt);
			rc = _tmp21_;
			if (rc != SQLITE_DONE) {
				const gchar* _tmp22_ = NULL;
				_tmp22_ = sqlite3_errmsg (database);
				fprintf (stderr, "can't commit the change: %s\n", _tmp22_);
				result = FALSE;
				_g_object_unref0 (codepoint_list);
				_sqlite3_finalize0 (stmt);
				_g_free0 (sql);
				_g_free0 (name);
				_g_object_unref0 (model);
				return result;
			}
			_tmp23_ = block_id;
			block_id = _tmp23_ + 1;
			g_object_get (codepoint_list, "first-codepoint", &_tmp24_, NULL);
			g_object_get (codepoint_list, "last-codepoint", &_tmp25_, NULL);
			ibus_gucharmap_index_generator_insert_block (self, database, model, _tmp23_, _tmp24_, _tmp25_);
			_g_object_unref0 (codepoint_list);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (name);
		}
	}
	result = TRUE;
	_g_object_unref0 (model);
	return result;
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback sqlite3_callback, void* sqlite3_callback_target, gchar** errmsg) {
	gchar* _errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	gint ec;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, sqlite3_callback, sqlite3_callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if (_errmsg != NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (sqlite_errmsg);
		_g_free0 (_errmsg);
		_errmsg = _tmp2_;
	}
	sqlite3_free ((void*) sqlite_errmsg);
	result = ec;
	if (errmsg) {
		*errmsg = _errmsg;
	} else {
		_g_free0 (_errmsg);
	}
	return result;
}


gboolean ibus_gucharmap_index_generator_generate (IBusGucharmapIndexGenerator* self) {
	gboolean result = FALSE;
	sqlite3* database = NULL;
	gint rc = 0;
	sqlite3* _tmp0_ = NULL;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp4_;
	gboolean _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = sqlite3_open (self->priv->filename, &_tmp0_);
	_sqlite3_close0 (database);
	database = _tmp0_;
	rc = _tmp1_;
	if (rc != SQLITE_OK) {
		fprintf (stderr, "can't open database\n");
		result = FALSE;
		_sqlite3_close0 (database);
		return result;
	}
	_tmp2_ = _sqlite3_exec (database, IBUS_GUCHARMAP_INDEX_GENERATOR_create_schema, NULL, NULL, NULL);
	rc = _tmp2_;
	if (rc != SQLITE_OK) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = sqlite3_errmsg (database);
		fprintf (stderr, "can't create tables: %s\n", _tmp3_);
		result = FALSE;
		_sqlite3_close0 (database);
		return result;
	}
	_tmp4_ = _sqlite3_exec (database, "BEGIN;", NULL, NULL, NULL);
	rc = _tmp4_;
	if (rc != SQLITE_OK) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = sqlite3_errmsg (database);
		fprintf (stderr, "can't start transaction: %s\n", _tmp5_);
		result = FALSE;
		_sqlite3_close0 (database);
		return result;
	}
	_tmp6_ = ibus_gucharmap_index_generator_insert_blocks (self, database);
	if (!_tmp6_) {
		result = FALSE;
		_sqlite3_close0 (database);
		return result;
	}
	_tmp7_ = _sqlite3_exec (database, "COMMIT;", NULL, NULL, NULL);
	rc = _tmp7_;
	if (rc != SQLITE_OK) {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = sqlite3_errmsg (database);
		fprintf (stderr, "can't complete transaction: %s\n", _tmp8_);
		result = FALSE;
		_sqlite3_close0 (database);
		return result;
	}
	result = TRUE;
	_sqlite3_close0 (database);
	return result;
}


static void ibus_gucharmap_index_generator_class_init (IBusGucharmapIndexGeneratorClass * klass) {
	ibus_gucharmap_index_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusGucharmapIndexGeneratorPrivate));
	G_OBJECT_CLASS (klass)->finalize = ibus_gucharmap_index_generator_finalize;
}


static void ibus_gucharmap_index_generator_instance_init (IBusGucharmapIndexGenerator * self) {
	self->priv = IBUS_GUCHARMAP_INDEX_GENERATOR_GET_PRIVATE (self);
}


static void ibus_gucharmap_index_generator_finalize (GObject* obj) {
	IBusGucharmapIndexGenerator * self;
	self = IBUS_GUCHARMAP_INDEX_GENERATOR (obj);
	_g_free0 (self->priv->filename);
	G_OBJECT_CLASS (ibus_gucharmap_index_generator_parent_class)->finalize (obj);
}


GType ibus_gucharmap_index_generator_get_type (void) {
	static volatile gsize ibus_gucharmap_index_generator_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_gucharmap_index_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusGucharmapIndexGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_gucharmap_index_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusGucharmapIndexGenerator), 0, (GInstanceInitFunc) ibus_gucharmap_index_generator_instance_init, NULL };
		GType ibus_gucharmap_index_generator_type_id;
		ibus_gucharmap_index_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "IBusGucharmapIndexGenerator", &g_define_type_info, 0);
		g_once_init_leave (&ibus_gucharmap_index_generator_type_id__volatile, ibus_gucharmap_index_generator_type_id);
	}
	return ibus_gucharmap_index_generator_type_id__volatile;
}


gint ibus_gucharmap_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_;
	IBusGucharmapIndexGenerator* _tmp1_ = NULL;
	IBusGucharmapIndexGenerator* generator;
	_tmp0_ = gtk_init_check (&args_length1, &args);
	if (!_tmp0_) {
		g_warning ("gen-index.vala:215: Can't init GTK, but ignoring the error");
	}
	if (args_length1 < 2) {
		fprintf (stderr, "Usage: gen-index FILENAME\n");
		result = 1;
		return result;
	}
	_tmp1_ = ibus_gucharmap_index_generator_new (args[1]);
	generator = _tmp1_;
	ibus_gucharmap_index_generator_generate (generator);
	result = 0;
	_g_object_unref0 (generator);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return ibus_gucharmap_main (argv, argc);
}



