/********************************************************************\
 * ScrubBusiness.h -- Cleanup functions for the business objects.   *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, contact:                        *
 *                                                                  *
 * Free Software Foundation           Voice:  +1-617-542-5942       *
 * 51 Franklin Street, Fifth Floor    Fax:    +1-617-542-2652       *
 * Boston, MA  02110-1301,  USA       gnu@gnu.org                   *
\********************************************************************/

/** @addtogroup Engine
    @{ */
/** @addtogroup Scrub
    @{ */

/** @file ScrubBusiness.h
 *  @brief Cleanup functions for business objects
 *  @author Created by Geert Janssens August 2014
 *  @author Copyright (c) 2014 Geert Janssens <geert@kobaltwit.be>
 */
#ifndef GNC_SCRUBBUSINESS_H
#define GNC_SCRUBBUSINESS_H

#include "gnc-engine.h"

/** @name Cleanup functions for business objects
 * Provides the high-level API for checking and repairing ('scrubbing
 * clean') the various data objects used by the business functions.
 @{ */

/** The gncScrubBusinessLot() function makes sure that the indicated
 *    lot has all the correct properties required for a lot used in
 *    the business features.
 *
 *    Currently this function only does one thing: eliminate lot link
 *    transactions between invoice lots and payment lots (which were
 *    generated by GnuCash versions 2.6.0-2.6.3). Lot links
 *    between invoices and credit notes will still remain.
 *
 *    Scrubbing the lot may cause subsplits to be merged together,
 *    i.e. for splits to be deleted.  This routine returns true if
 *    any splits were modified or deleted.
 */
gboolean gncScrubBusinessLot (GNCLot *lot);

/** The gncScrubBusinessAccountLots() function will call
 *    gncScrubBusinessLot() on each lot in the given account.
 *
 *    This routine is the primary routine for ensuring that the
 *    lot structure of every lot of a business account is in good
 *    order.
 */
void gncScrubBusinessAccountLots (Account *acc);

/** The gncScrubBusinessAccountTreeLots() function will call
 *    gncScrubBusinessAccountLots() on each lot in the given account
 *    and its sub accounts.
 *
 *    This routine is the primary routine for ensuring that the
 *    lot structure of every lot of a business account is in good
 *    order.
 */
void gncScrubBusinessAccountTreeLots (Account *acc);

/** @} */
#endif /* GNC_SCRUBBUSINESS_H */
/** @} */
/** @} */
