/* puzzle-view.c generated by valac 0.26.0.30-a52f5a, the Vala compiler
 * generated from puzzle-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
typedef struct _PuzzleViewPrivate PuzzleViewPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;

struct _PuzzleView {
	GtkDrawingArea parent_instance;
	PuzzleViewPrivate * priv;
};

struct _PuzzleViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PuzzleViewPrivate {
	gint render_size;
	gint piece_x;
	gint piece_y;
	gboolean piece_unmoved;
	gchar _piece_id;
	gchar last_piece_id;
	gdouble kx;
	gdouble ky;
	RsvgHandle* tiles_handle;
	gchar* image_filepath;
	cairo_surface_t* surface;
	Puzzle* _puzzle;
};

struct _Puzzle {
	GObject parent_instance;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GObjectClass parent_class;
};


static gpointer puzzle_view_parent_class = NULL;

GType puzzle_view_get_type (void) G_GNUC_CONST;
GType puzzle_get_type (void) G_GNUC_CONST;
#define PUZZLE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE_VIEW, PuzzleViewPrivate))
enum  {
	PUZZLE_VIEW_DUMMY_PROPERTY,
	PUZZLE_VIEW_PUZZLE
};
#define PUZZLE_VIEW_SPACE_OFFSET 4
#define PUZZLE_VIEW_SPACE_PADDING 5
#define PUZZLE_VIEW_THEME_OVERLAY_SIZE 8
#define PUZZLE_VIEW_THEME_TILE_SEGMENTS 27
#define PUZZLE_VIEW_THEME_TILE_CENTER 14
#define PUZZLE_VIEW_THEME_TILE_SIZE 34
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void puzzle_view_load_image (PuzzleView* self);
static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* cr);
static gint puzzle_view_get_tile_size (PuzzleView* self);
Puzzle* puzzle_view_get_puzzle (PuzzleView* self);
static void puzzle_view_draw_square (PuzzleView* self, cairo_t* cr, gint x, gint y, gdouble kx, gdouble ky);
static gchar puzzle_view_get_piece_id (PuzzleView* self);
gchar puzzle_get_piece_id (Puzzle* self, gchar* src, int src_length1, gint x, gint y);
gint puzzle_get_piece_nr (Puzzle* self, gint x, gint y);
static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gboolean puzzle_game_over (Puzzle* self);
static void puzzle_view_set_piece_id (PuzzleView* self, gchar value);
static gchar* _vala_array_dup7 (gchar* self, int length);
static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
gboolean puzzle_movable (Puzzle* self, gint id);
gboolean puzzle_mapcmp (Puzzle* self, gchar* m1, int m1_length1, gchar* m2, int m2_length1);
static gchar* _vala_array_dup8 (gchar* self, int length);
static gchar* _vala_array_dup9 (gchar* self, int length);
static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
gboolean puzzle_move_piece (Puzzle* self, gchar id, gint x1, gint y1, gint x2, gint y2);
static void puzzle_view_puzzle_changed_cb (PuzzleView* self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
static void _puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender, gpointer self);
static void puzzle_view_finalize (GObject* obj);
static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


PuzzleView* puzzle_view_construct (GType object_type) {
	PuzzleView * self = NULL;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) g_object_new (object_type, NULL);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK));
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	puzzle_view_load_image (self);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return self;
#line 156 "puzzle-view.c"
}


PuzzleView* puzzle_view_new (void) {
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return puzzle_view_construct (TYPE_PUZZLE_VIEW);
#line 163 "puzzle-view.c"
}


static void puzzle_view_load_image (PuzzleView* self) {
	gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = g_build_filename (DATA_DIRECTORY, "gnome-klotski.svg", NULL, NULL);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_free0 (self->priv->image_filepath);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->image_filepath = _tmp0_;
#line 178 "puzzle-view.c"
	{
		RsvgHandle* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		RsvgHandle* _tmp3_ = NULL;
		RsvgHandle* _tmp4_ = NULL;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp2_ = self->priv->image_filepath;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = rsvg_handle_new_from_file (_tmp2_, &_inner_error_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp1_ = _tmp3_;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "puzzle-view.c"
			goto __catch10_g_error;
		}
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp4_ = _tmp1_;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp1_ = NULL;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_g_object_unref0 (self->priv->tiles_handle);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		self->priv->tiles_handle = _tmp4_;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_g_object_unref0 (_tmp1_);
#line 205 "puzzle-view.c"
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		FILE* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		e = _inner_error_;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_inner_error_ = NULL;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp5_ = stderr;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp6_ = e;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp7_ = _tmp6_->message;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		fprintf (_tmp5_, "%s %s\n", "Error in puzzle-view.vala load image:", _tmp7_);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp8_ = stderr;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp9_ = self->priv->image_filepath;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		fprintf (_tmp8_, "%s %s\n", "image path:", _tmp9_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		exit (EXIT_FAILURE);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_g_error_free0 (e);
#line 238 "puzzle-view.c"
	}
	__finally10:
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		g_clear_error (&_inner_error_);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		return;
#line 249 "puzzle-view.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 257 "puzzle-view.c"
}


static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* cr) {
	PuzzleView * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp24_ = NULL;
	GtkStyleContext* _tmp25_ = NULL;
	GdkRGBA fg = {0};
	GtkStyleContext* _tmp26_ = NULL;
	GdkRGBA _tmp27_ = {0};
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp28_ = NULL;
	GdkRGBA _tmp29_ = {0};
	cairo_t* _tmp30_ = NULL;
	GdkRGBA _tmp31_ = {0};
	cairo_t* _tmp32_ = NULL;
	gint width = 0;
	gint _tmp33_ = 0;
	gint height = 0;
	gint _tmp34_ = 0;
	cairo_t* _tmp35_ = NULL;
	GdkRGBA _tmp36_ = {0};
	cairo_t* _tmp37_ = NULL;
	gdouble kwidth = 0.0;
	Puzzle* _tmp38_ = NULL;
	Puzzle* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gdouble kheight = 0.0;
	Puzzle* _tmp43_ = NULL;
	Puzzle* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gdouble _tmp49_ = 0.0;
	gint _tmp50_ = 0;
	gdouble _tmp51_ = 0.0;
	cairo_t* _tmp52_ = NULL;
	gdouble _tmp53_ = 0.0;
	gdouble _tmp54_ = 0.0;
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_ = 0.0;
	cairo_t* _tmp57_ = NULL;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = puzzle_view_get_tile_size (self);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = self->priv->render_size;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp1_ != _tmp2_) {
#line 320 "puzzle-view.c"
		RsvgHandle* _tmp3_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = self->priv->tiles_handle;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp3_ != NULL) {
#line 328 "puzzle-view.c"
			gint height = 0;
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
			gint width = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			cairo_t* _tmp8_ = NULL;
			cairo_surface_t* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			cairo_surface_t* _tmp12_ = NULL;
			cairo_t* c = NULL;
			cairo_surface_t* _tmp13_ = NULL;
			cairo_t* _tmp14_ = NULL;
			gdouble sfw = 0.0;
			gint _tmp15_ = 0;
			gdouble sfh = 0.0;
			gint _tmp16_ = 0;
			cairo_t* _tmp17_ = NULL;
			gdouble _tmp18_ = 0.0;
			gdouble _tmp19_ = 0.0;
			RsvgHandle* _tmp20_ = NULL;
			cairo_t* _tmp21_ = NULL;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp4_ = puzzle_view_get_tile_size (self);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp5_ = _tmp4_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			height = _tmp5_ * 2;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp6_ = puzzle_view_get_tile_size (self);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp7_ = _tmp6_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			width = _tmp7_ * PUZZLE_VIEW_THEME_TILE_SEGMENTS;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp8_ = cr;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp9_ = cairo_get_target (_tmp8_);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp10_ = width;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp11_ = height;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp12_ = cairo_surface_create_similar (_tmp9_, CAIRO_CONTENT_COLOR_ALPHA, _tmp10_, _tmp11_);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_cairo_surface_destroy0 (self->priv->surface);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			self->priv->surface = _tmp12_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp13_ = self->priv->surface;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp14_ = cairo_create (_tmp13_);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			c = _tmp14_;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp15_ = width;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			sfw = ((gdouble) _tmp15_) / 918;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp16_ = height;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			sfh = ((gdouble) _tmp16_) / 68;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp17_ = c;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp18_ = sfw;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp19_ = sfh;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			cairo_scale (_tmp17_, _tmp18_, _tmp19_);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp20_ = self->priv->tiles_handle;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp21_ = c;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			rsvg_handle_render_cairo (_tmp20_, _tmp21_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_cairo_destroy0 (c);
#line 408 "puzzle-view.c"
		}
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp22_ = puzzle_view_get_tile_size (self);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp23_ = _tmp22_;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		self->priv->render_size = _tmp23_;
#line 416 "puzzle-view.c"
	}
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp25_ = _g_object_ref0 (_tmp24_);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	style = _tmp25_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp26_ = style;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_get_color (_tmp26_, GTK_STATE_FLAG_NORMAL, &_tmp27_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	fg = _tmp27_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp28_ = style;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_get_background_color (_tmp28_, GTK_STATE_FLAG_NORMAL, &_tmp29_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	bg = _tmp29_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp30_ = cr;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp31_ = bg;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gdk_cairo_set_source_rgba (_tmp30_, &_tmp31_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp32_ = cr;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	cairo_paint (_tmp32_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp33_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	width = _tmp33_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp34_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	height = _tmp34_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp35_ = cr;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp36_ = fg;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gdk_cairo_set_source_rgba (_tmp35_, &_tmp36_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp37_ = cr;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	cairo_set_line_width (_tmp37_, 1.0);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp38_ = puzzle_view_get_puzzle (self);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp39_ = _tmp38_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp40_ = _tmp39_->width;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp41_ = puzzle_view_get_tile_size (self);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp42_ = _tmp41_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	kwidth = ((_tmp40_ * _tmp42_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp43_ = puzzle_view_get_puzzle (self);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp44_ = _tmp43_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp45_ = _tmp44_->height;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp46_ = puzzle_view_get_tile_size (self);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp47_ = _tmp46_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	kheight = ((_tmp45_ * _tmp47_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp48_ = width;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp49_ = kwidth;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->kx = (_tmp48_ - _tmp49_) / 2.0;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp50_ = height;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp51_ = kheight;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->ky = (_tmp50_ - _tmp51_) / 2.0;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp52_ = cr;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp53_ = self->priv->kx;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp54_ = self->priv->ky;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp55_ = kwidth;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp56_ = kheight;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	cairo_rectangle (_tmp52_, _tmp53_, _tmp54_, _tmp55_, _tmp56_);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp57_ = cr;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	cairo_stroke (_tmp57_);
#line 516 "puzzle-view.c"
	{
		gint y = 0;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		y = 0;
#line 521 "puzzle-view.c"
		{
			gboolean _tmp58_ = FALSE;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp58_ = TRUE;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			while (TRUE) {
#line 528 "puzzle-view.c"
				gint _tmp60_ = 0;
				Puzzle* _tmp61_ = NULL;
				Puzzle* _tmp62_ = NULL;
				gint _tmp63_ = 0;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				if (!_tmp58_) {
#line 535 "puzzle-view.c"
					gint _tmp59_ = 0;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					_tmp59_ = y;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					y = _tmp59_ + 1;
#line 541 "puzzle-view.c"
				}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp58_ = FALSE;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp60_ = y;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp61_ = puzzle_view_get_puzzle (self);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp62_ = _tmp61_;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp63_ = _tmp62_->height;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				if (!(_tmp60_ < _tmp63_)) {
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					break;
#line 557 "puzzle-view.c"
				}
				{
					gint x = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					x = 0;
#line 563 "puzzle-view.c"
					{
						gboolean _tmp64_ = FALSE;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
						_tmp64_ = TRUE;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
						while (TRUE) {
#line 570 "puzzle-view.c"
							gint _tmp66_ = 0;
							Puzzle* _tmp67_ = NULL;
							Puzzle* _tmp68_ = NULL;
							gint _tmp69_ = 0;
							cairo_t* _tmp70_ = NULL;
							gint _tmp71_ = 0;
							gint _tmp72_ = 0;
							gdouble _tmp73_ = 0.0;
							gdouble _tmp74_ = 0.0;
							gchar _tmp75_ = '\0';
							gchar _tmp76_ = '\0';
							Puzzle* _tmp77_ = NULL;
							Puzzle* _tmp78_ = NULL;
							Puzzle* _tmp79_ = NULL;
							Puzzle* _tmp80_ = NULL;
							gchar* _tmp81_ = NULL;
							gint _tmp81__length1 = 0;
							gint _tmp82_ = 0;
							gint _tmp83_ = 0;
							gchar _tmp84_ = '\0';
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							if (!_tmp64_) {
#line 593 "puzzle-view.c"
								gint _tmp65_ = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp65_ = x;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								x = _tmp65_ + 1;
#line 599 "puzzle-view.c"
							}
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp64_ = FALSE;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp66_ = x;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp67_ = puzzle_view_get_puzzle (self);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp68_ = _tmp67_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp69_ = _tmp68_->width;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							if (!(_tmp66_ < _tmp69_)) {
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								break;
#line 615 "puzzle-view.c"
							}
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp70_ = cr;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp71_ = x;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp72_ = y;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp73_ = self->priv->kx;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp74_ = self->priv->ky;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							puzzle_view_draw_square (self, _tmp70_, _tmp71_, _tmp72_, _tmp73_, _tmp74_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp75_ = puzzle_view_get_piece_id (self);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp76_ = _tmp75_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp77_ = puzzle_view_get_puzzle (self);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp78_ = _tmp77_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp79_ = puzzle_view_get_puzzle (self);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp80_ = _tmp79_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp81_ = _tmp80_->map;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp81__length1 = _tmp80_->map_length1;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp82_ = x;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp83_ = y;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp84_ = puzzle_get_piece_id (_tmp78_, _tmp81_, _tmp81__length1, _tmp82_, _tmp83_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							if (_tmp76_ == _tmp84_) {
#line 653 "puzzle-view.c"
								cairo_t* _tmp85_ = NULL;
								GdkRGBA _tmp86_ = {0};
								cairo_t* _tmp87_ = NULL;
								gint _tmp88_ = 0;
								gint _tmp89_ = 0;
								gint _tmp90_ = 0;
								gdouble _tmp91_ = 0.0;
								gint _tmp92_ = 0;
								gint _tmp93_ = 0;
								gint _tmp94_ = 0;
								gdouble _tmp95_ = 0.0;
								gint _tmp96_ = 0;
								gint _tmp97_ = 0;
								gint _tmp98_ = 0;
								gint _tmp99_ = 0;
								cairo_t* _tmp100_ = NULL;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp85_ = cr;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp86_.red = 1.0;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp86_.green = 1.0;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp86_.blue = 1.0;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp86_.alpha = 0.2;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								gdk_cairo_set_source_rgba (_tmp85_, &_tmp86_);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp87_ = cr;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp88_ = x;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp89_ = puzzle_view_get_tile_size (self);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp90_ = _tmp89_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp91_ = self->priv->kx;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp92_ = y;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp93_ = puzzle_view_get_tile_size (self);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp94_ = _tmp93_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp95_ = self->priv->ky;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp96_ = puzzle_view_get_tile_size (self);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp97_ = _tmp96_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp98_ = puzzle_view_get_tile_size (self);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp99_ = _tmp98_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								cairo_rectangle (_tmp87_, (_tmp88_ * _tmp90_) + _tmp91_, (_tmp92_ * _tmp94_) + _tmp95_, (gdouble) _tmp97_, (gdouble) _tmp99_);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp100_ = cr;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								cairo_fill (_tmp100_);
#line 714 "puzzle-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = FALSE;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (style);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 728 "puzzle-view.c"
}


static void puzzle_view_draw_square (PuzzleView* self, cairo_t* cr, gint x, gint y, gdouble kx, gdouble ky) {
	GdkRectangle rect = {0};
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gdouble _tmp3_ = 0.0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GtkStyleContext* _tmp13_ = NULL;
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp14_ = NULL;
	GdkRGBA _tmp15_ = {0};
	cairo_t* _tmp16_ = NULL;
	GdkRectangle _tmp17_ = {0};
	cairo_t* _tmp18_ = NULL;
	GdkRGBA _tmp19_ = {0};
	cairo_t* _tmp20_ = NULL;
	Puzzle* _tmp21_ = NULL;
	Puzzle* _tmp22_ = NULL;
	Puzzle* _tmp23_ = NULL;
	Puzzle* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gchar _tmp28_ = '\0';
	Puzzle* _tmp47_ = NULL;
	Puzzle* _tmp48_ = NULL;
	Puzzle* _tmp49_ = NULL;
	Puzzle* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gint _tmp51__length1 = 0;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	gchar _tmp54_ = '\0';
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (cr != NULL);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	memset (&rect, 0, sizeof (GdkRectangle));
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = x;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = puzzle_view_get_tile_size (self);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = _tmp1_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp3_ = kx;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	rect.x = (((_tmp0_ * _tmp2_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) _tmp3_)) - 1;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp4_ = y;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp5_ = puzzle_view_get_tile_size (self);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp6_ = _tmp5_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp7_ = ky;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	rect.y = (((_tmp4_ * _tmp6_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) _tmp7_)) - 1;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp8_ = puzzle_view_get_tile_size (self);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp9_ = _tmp8_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	rect.width = _tmp9_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp10_ = puzzle_view_get_tile_size (self);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp11_ = _tmp10_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	rect.height = _tmp11_;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	style = _tmp13_;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp14_ = style;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_get_background_color (_tmp14_, GTK_STATE_FLAG_NORMAL, &_tmp15_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	bg = _tmp15_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp16_ = cr;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp17_ = rect;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gdk_cairo_rectangle (_tmp16_, &_tmp17_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp18_ = cr;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp19_ = bg;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gdk_cairo_set_source_rgba (_tmp18_, &_tmp19_);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp20_ = cr;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	cairo_fill (_tmp20_);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp21_ = puzzle_view_get_puzzle (self);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp22_ = _tmp21_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp23_ = puzzle_view_get_puzzle (self);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp24_ = _tmp23_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp25_ = _tmp24_->map;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp25__length1 = _tmp24_->map_length1;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp26_ = x;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp27_ = y;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp28_ = puzzle_get_piece_id (_tmp22_, _tmp25_, _tmp25__length1, _tmp26_, _tmp27_);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp28_ != ' ') {
#line 861 "puzzle-view.c"
		cairo_t* _tmp29_ = NULL;
		GdkRectangle _tmp30_ = {0};
		cairo_t* _tmp31_ = NULL;
		cairo_surface_t* _tmp32_ = NULL;
		GdkRectangle _tmp33_ = {0};
		gint _tmp34_ = 0;
		Puzzle* _tmp35_ = NULL;
		Puzzle* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		GdkRectangle _tmp42_ = {0};
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		cairo_t* _tmp46_ = NULL;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp29_ = cr;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp30_ = rect;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		gdk_cairo_rectangle (_tmp29_, &_tmp30_);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp31_ = cr;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp32_ = self->priv->surface;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp33_ = rect;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp34_ = _tmp33_.x;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp35_ = puzzle_view_get_puzzle (self);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp36_ = _tmp35_;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp37_ = x;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp38_ = y;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp39_ = puzzle_get_piece_nr (_tmp36_, _tmp37_, _tmp38_);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp40_ = puzzle_view_get_tile_size (self);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp41_ = _tmp40_;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp42_ = rect;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp43_ = _tmp42_.y;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp44_ = puzzle_view_get_tile_size (self);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp45_ = _tmp44_;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		cairo_set_source_surface (_tmp31_, _tmp32_, (gdouble) (_tmp34_ - (_tmp39_ * _tmp41_)), (gdouble) (_tmp43_ - (_tmp45_ / 2)));
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp46_ = cr;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		cairo_fill (_tmp46_);
#line 922 "puzzle-view.c"
	}
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp47_ = puzzle_view_get_puzzle (self);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp48_ = _tmp47_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp49_ = puzzle_view_get_puzzle (self);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp50_ = _tmp49_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp51_ = _tmp50_->map;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp51__length1 = _tmp50_->map_length1;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp52_ = x;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp53_ = y;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp54_ = puzzle_get_piece_id (_tmp48_, _tmp51_, _tmp51__length1, _tmp52_, _tmp53_);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp54_ == '*') {
#line 944 "puzzle-view.c"
		gint value = 0;
		Puzzle* _tmp55_ = NULL;
		Puzzle* _tmp56_ = NULL;
		Puzzle* _tmp57_ = NULL;
		Puzzle* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gint _tmp59__length1 = 0;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		gchar _tmp62_ = '\0';
		gint overlay_size = 0;
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		gint overlay_offset = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		gint _tmp67_ = 0;
		cairo_t* _tmp68_ = NULL;
		GdkRectangle _tmp69_ = {0};
		gint _tmp70_ = 0;
		gint _tmp71_ = 0;
		GdkRectangle _tmp72_ = {0};
		gint _tmp73_ = 0;
		gint _tmp74_ = 0;
		gint _tmp75_ = 0;
		gint _tmp76_ = 0;
		cairo_t* _tmp77_ = NULL;
		cairo_surface_t* _tmp78_ = NULL;
		GdkRectangle _tmp79_ = {0};
		gint _tmp80_ = 0;
		gint _tmp81_ = 0;
		gint _tmp82_ = 0;
		gint _tmp83_ = 0;
		GdkRectangle _tmp84_ = {0};
		gint _tmp85_ = 0;
		gint _tmp86_ = 0;
		gint _tmp87_ = 0;
		cairo_t* _tmp88_ = NULL;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		value = 22;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp55_ = puzzle_view_get_puzzle (self);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp56_ = _tmp55_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp57_ = puzzle_view_get_puzzle (self);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp58_ = _tmp57_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp59_ = _tmp58_->orig_map;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp59__length1 = _tmp58_->orig_map_length1;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp60_ = x;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp61_ = y;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp62_ = puzzle_get_piece_id (_tmp56_, _tmp59_, _tmp59__length1, _tmp60_, _tmp61_);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp62_ == '.') {
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			value = 20;
#line 1007 "puzzle-view.c"
		}
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp63_ = puzzle_view_get_tile_size (self);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp64_ = _tmp63_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		overlay_size = (PUZZLE_VIEW_THEME_OVERLAY_SIZE * _tmp64_) / PUZZLE_VIEW_THEME_TILE_SIZE;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp65_ = puzzle_view_get_tile_size (self);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp66_ = _tmp65_;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp67_ = overlay_size;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		overlay_offset = ((PUZZLE_VIEW_THEME_TILE_CENTER * _tmp66_) / PUZZLE_VIEW_THEME_TILE_SIZE) - (_tmp67_ / 2);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp68_ = cr;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp69_ = rect;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp70_ = _tmp69_.x;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp71_ = overlay_offset;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp72_ = rect;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp73_ = _tmp72_.y;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp74_ = overlay_offset;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp75_ = overlay_size;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp76_ = overlay_size;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		cairo_rectangle (_tmp68_, (gdouble) (_tmp70_ + _tmp71_), (gdouble) (_tmp73_ + _tmp74_), (gdouble) _tmp75_, (gdouble) _tmp76_);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp77_ = cr;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp78_ = self->priv->surface;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp79_ = rect;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp80_ = _tmp79_.x;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp81_ = value;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp82_ = puzzle_view_get_tile_size (self);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp83_ = _tmp82_;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp84_ = rect;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp85_ = _tmp84_.y;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp86_ = puzzle_view_get_tile_size (self);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp87_ = _tmp86_;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		cairo_set_source_surface (_tmp77_, _tmp78_, (gdouble) (_tmp80_ - (_tmp81_ * _tmp83_)), (gdouble) (_tmp85_ - (_tmp87_ / 2)));
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp88_ = cr;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		cairo_fill (_tmp88_);
#line 1071 "puzzle-view.c"
	}
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (style);
#line 1075 "puzzle-view.c"
}


static gchar* _vala_array_dup7 (gchar* self, int length) {
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1082 "puzzle-view.c"
}


static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = event;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = _tmp0_->button;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp1_ == ((guint) 1)) {
#line 1101 "puzzle-view.c"
		Puzzle* _tmp2_ = NULL;
		Puzzle* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		GdkEventButton* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		GdkEventButton* _tmp10_ = NULL;
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gchar new_piece_id = '\0';
		Puzzle* _tmp15_ = NULL;
		Puzzle* _tmp16_ = NULL;
		Puzzle* _tmp17_ = NULL;
		Puzzle* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gchar _tmp22_ = '\0';
		gboolean _tmp23_ = FALSE;
		gchar _tmp24_ = '\0';
		gchar _tmp25_ = '\0';
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gchar _tmp31_ = '\0';
		gchar _tmp38_ = '\0';
		Puzzle* _tmp39_ = NULL;
		Puzzle* _tmp40_ = NULL;
		Puzzle* _tmp41_ = NULL;
		Puzzle* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		gchar* _tmp44_ = NULL;
		gint _tmp44__length1 = 0;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp2_ = puzzle_view_get_puzzle (self);
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = _tmp2_;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp4_ = puzzle_game_over (_tmp3_);
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp4_) {
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1154 "puzzle-view.c"
		}
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp5_ = event;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp6_ = _tmp5_->x;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp7_ = self->priv->kx;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp8_ = puzzle_view_get_tile_size (self);
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp9_ = _tmp8_;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		self->priv->piece_x = ((gint) (_tmp6_ - _tmp7_)) / _tmp9_;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp10_ = event;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp11_ = _tmp10_->y;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp12_ = self->priv->ky;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp13_ = puzzle_view_get_tile_size (self);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp14_ = _tmp13_;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		self->priv->piece_y = ((gint) (_tmp11_ - _tmp12_)) / _tmp14_;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp15_ = puzzle_view_get_puzzle (self);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp16_ = _tmp15_;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp17_ = puzzle_view_get_puzzle (self);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp18_ = _tmp17_;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp19_ = _tmp18_->map;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp19__length1 = _tmp18_->map_length1;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp20_ = self->priv->piece_x;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp21_ = self->priv->piece_y;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp22_ = puzzle_get_piece_id (_tmp16_, _tmp19_, _tmp19__length1, _tmp20_, _tmp21_);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		new_piece_id = _tmp22_;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp24_ = puzzle_view_get_piece_id (self);
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp25_ = _tmp24_;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp25_ != '\0') {
#line 1206 "puzzle-view.c"
			gboolean _tmp26_ = FALSE;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp26_ = self->priv->piece_unmoved;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp23_ = _tmp26_;
#line 1212 "puzzle-view.c"
		} else {
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp23_ = FALSE;
#line 1216 "puzzle-view.c"
		}
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp23_) {
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			puzzle_view_set_piece_id (self, '\0');
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1226 "puzzle-view.c"
		}
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp31_ = new_piece_id;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp31_ == ' ') {
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp30_ = TRUE;
#line 1234 "puzzle-view.c"
		} else {
			gchar _tmp32_ = '\0';
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp32_ = new_piece_id;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp30_ = _tmp32_ == '.';
#line 1241 "puzzle-view.c"
		}
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp30_) {
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp29_ = TRUE;
#line 1247 "puzzle-view.c"
		} else {
			gchar _tmp33_ = '\0';
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp33_ = new_piece_id;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp29_ = _tmp33_ == '-';
#line 1254 "puzzle-view.c"
		}
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp29_) {
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp28_ = TRUE;
#line 1260 "puzzle-view.c"
		} else {
			gchar _tmp34_ = '\0';
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp34_ = new_piece_id;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp28_ = _tmp34_ == '#';
#line 1267 "puzzle-view.c"
		}
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp28_) {
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp27_ = TRUE;
#line 1273 "puzzle-view.c"
		} else {
			gchar _tmp35_ = '\0';
			gchar _tmp36_ = '\0';
			gchar _tmp37_ = '\0';
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp35_ = new_piece_id;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp36_ = puzzle_view_get_piece_id (self);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp37_ = _tmp36_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp27_ = _tmp35_ == _tmp37_;
#line 1286 "puzzle-view.c"
		}
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp27_) {
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1294 "puzzle-view.c"
		}
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		self->priv->piece_unmoved = TRUE;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp38_ = new_piece_id;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		puzzle_view_set_piece_id (self, _tmp38_);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp39_ = puzzle_view_get_puzzle (self);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp40_ = _tmp39_;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp41_ = puzzle_view_get_puzzle (self);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp42_ = _tmp41_;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp43_ = _tmp42_->map;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp43__length1 = _tmp42_->map_length1;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp44_ = (_tmp43_ != NULL) ? _vala_array_dup7 (_tmp43_, _tmp43__length1) : ((gpointer) _tmp43_);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp44__length1 = _tmp43__length1;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp40_->move_map = (g_free (_tmp40_->move_map), NULL);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp40_->move_map = _tmp44_;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp40_->move_map_length1 = _tmp44__length1;
#line 1324 "puzzle-view.c"
	}
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = FALSE;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1330 "puzzle-view.c"
}


static gchar* _vala_array_dup8 (gchar* self, int length) {
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1337 "puzzle-view.c"
}


static gchar* _vala_array_dup9 (gchar* self, int length) {
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1344 "puzzle-view.c"
}


static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = event;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = _tmp1_->button;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp2_ == ((guint) 1)) {
#line 1364 "puzzle-view.c"
		gchar _tmp3_ = '\0';
		gchar _tmp4_ = '\0';
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = puzzle_view_get_piece_id (self);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp4_ = _tmp3_;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp0_ = _tmp4_ != '\0';
#line 1373 "puzzle-view.c"
	} else {
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp0_ = FALSE;
#line 1377 "puzzle-view.c"
	}
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp0_) {
#line 1381 "puzzle-view.c"
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		Puzzle* _tmp7_ = NULL;
		Puzzle* _tmp8_ = NULL;
		gchar _tmp9_ = '\0';
		gchar _tmp10_ = '\0';
		gboolean _tmp11_ = FALSE;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp5_ = self->priv->piece_unmoved;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp5_) {
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1397 "puzzle-view.c"
		}
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp7_ = puzzle_view_get_puzzle (self);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp8_ = _tmp7_;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp9_ = puzzle_view_get_piece_id (self);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp10_ = _tmp9_;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp11_ = puzzle_movable (_tmp8_, (gint) _tmp10_);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp11_) {
#line 1411 "puzzle-view.c"
			Puzzle* _tmp12_ = NULL;
			Puzzle* _tmp13_ = NULL;
			Puzzle* _tmp14_ = NULL;
			Puzzle* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			Puzzle* _tmp17_ = NULL;
			Puzzle* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gint _tmp19__length1 = 0;
			gboolean _tmp20_ = FALSE;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp12_ = puzzle_view_get_puzzle (self);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp13_ = _tmp12_;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp14_ = puzzle_view_get_puzzle (self);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp15_ = _tmp14_;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp16_ = _tmp15_->move_map;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp16__length1 = _tmp15_->move_map_length1;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp17_ = puzzle_view_get_puzzle (self);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp18_ = _tmp17_;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp19_ = _tmp18_->map;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp19__length1 = _tmp18_->map_length1;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp20_ = puzzle_mapcmp (_tmp13_, _tmp16_, _tmp16__length1, _tmp19_, _tmp19__length1);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp6_ = _tmp20_;
#line 1447 "puzzle-view.c"
		} else {
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp6_ = FALSE;
#line 1451 "puzzle-view.c"
		}
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp6_) {
#line 1455 "puzzle-view.c"
			gboolean _tmp21_ = FALSE;
			gchar _tmp22_ = '\0';
			gboolean _tmp38_ = FALSE;
			Puzzle* _tmp39_ = NULL;
			Puzzle* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			Puzzle* _tmp56_ = NULL;
			Puzzle* _tmp57_ = NULL;
			Puzzle* _tmp58_ = NULL;
			Puzzle* _tmp59_ = NULL;
			gchar* _tmp60_ = NULL;
			gint _tmp60__length1 = 0;
			gchar* _tmp61_ = NULL;
			gint _tmp61__length1 = 0;
			Puzzle* _tmp62_ = NULL;
			Puzzle* _tmp63_ = NULL;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp22_ = self->priv->last_piece_id;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			if (_tmp22_ == '\0') {
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp21_ = TRUE;
#line 1478 "puzzle-view.c"
			} else {
				gchar _tmp23_ = '\0';
				gchar _tmp24_ = '\0';
				gchar _tmp25_ = '\0';
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp23_ = self->priv->last_piece_id;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp24_ = puzzle_view_get_piece_id (self);
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp25_ = _tmp24_;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp21_ = _tmp23_ != _tmp25_;
#line 1491 "puzzle-view.c"
			}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			if (_tmp21_) {
#line 1495 "puzzle-view.c"
				Puzzle* _tmp26_ = NULL;
				Puzzle* _tmp27_ = NULL;
				Puzzle* _tmp28_ = NULL;
				Puzzle* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gint _tmp30__length1 = 0;
				gchar* _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				Puzzle* _tmp32_ = NULL;
				Puzzle* _tmp33_ = NULL;
				gint _tmp34_ = 0;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp26_ = puzzle_view_get_puzzle (self);
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp27_ = _tmp26_;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp28_ = puzzle_view_get_puzzle (self);
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp29_ = _tmp28_;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp30_ = _tmp29_->lastmove_map;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp30__length1 = _tmp29_->lastmove_map_length1;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp31_ = (_tmp30_ != NULL) ? _vala_array_dup8 (_tmp30_, _tmp30__length1) : ((gpointer) _tmp30_);
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp31__length1 = _tmp30__length1;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp27_->undomove_map = (g_free (_tmp27_->undomove_map), NULL);
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp27_->undomove_map = _tmp31_;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp27_->undomove_map_length1 = _tmp31__length1;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp32_ = puzzle_view_get_puzzle (self);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp33_ = _tmp32_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp34_ = _tmp33_->moves;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				if (_tmp34_ < 999) {
#line 1537 "puzzle-view.c"
					Puzzle* _tmp35_ = NULL;
					Puzzle* _tmp36_ = NULL;
					gint _tmp37_ = 0;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					_tmp35_ = puzzle_view_get_puzzle (self);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					_tmp36_ = _tmp35_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					_tmp37_ = _tmp36_->moves;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					_tmp36_->moves = _tmp37_ + 1;
#line 1549 "puzzle-view.c"
				}
			}
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp39_ = puzzle_view_get_puzzle (self);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp40_ = _tmp39_;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp41_ = _tmp40_->moves;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			if (_tmp41_ > 0) {
#line 1560 "puzzle-view.c"
				Puzzle* _tmp42_ = NULL;
				Puzzle* _tmp43_ = NULL;
				Puzzle* _tmp44_ = NULL;
				Puzzle* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				gint _tmp46__length1 = 0;
				Puzzle* _tmp47_ = NULL;
				Puzzle* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				gboolean _tmp50_ = FALSE;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp42_ = puzzle_view_get_puzzle (self);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp43_ = _tmp42_;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp44_ = puzzle_view_get_puzzle (self);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp45_ = _tmp44_;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp46_ = _tmp45_->undomove_map;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp46__length1 = _tmp45_->undomove_map_length1;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp47_ = puzzle_view_get_puzzle (self);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp48_ = _tmp47_;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp49_ = _tmp48_->map;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp49__length1 = _tmp48_->map_length1;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp50_ = puzzle_mapcmp (_tmp43_, _tmp46_, _tmp46__length1, _tmp49_, _tmp49__length1);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp38_ = !_tmp50_;
#line 1596 "puzzle-view.c"
			} else {
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp38_ = FALSE;
#line 1600 "puzzle-view.c"
			}
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			if (_tmp38_) {
#line 1604 "puzzle-view.c"
				Puzzle* _tmp51_ = NULL;
				Puzzle* _tmp52_ = NULL;
				gint _tmp53_ = 0;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp51_ = puzzle_view_get_puzzle (self);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp52_ = _tmp51_;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp53_ = _tmp52_->moves;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp52_->moves = _tmp53_ - 1;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				self->priv->last_piece_id = '\0';
#line 1618 "puzzle-view.c"
			} else {
				gchar _tmp54_ = '\0';
				gchar _tmp55_ = '\0';
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp54_ = puzzle_view_get_piece_id (self);
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp55_ = _tmp54_;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				self->priv->last_piece_id = _tmp55_;
#line 1628 "puzzle-view.c"
			}
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp56_ = puzzle_view_get_puzzle (self);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp57_ = _tmp56_;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp58_ = puzzle_view_get_puzzle (self);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp59_ = _tmp58_;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp60_ = _tmp59_->map;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp60__length1 = _tmp59_->map_length1;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp61_ = (_tmp60_ != NULL) ? _vala_array_dup9 (_tmp60_, _tmp60__length1) : ((gpointer) _tmp60_);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp61__length1 = _tmp60__length1;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp57_->lastmove_map = (g_free (_tmp57_->lastmove_map), NULL);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp57_->lastmove_map = _tmp61_;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp57_->lastmove_map_length1 = _tmp61__length1;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp62_ = puzzle_view_get_puzzle (self);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp63_ = _tmp62_;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			g_signal_emit_by_name (_tmp63_, "moved");
#line 1658 "puzzle-view.c"
		}
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		puzzle_view_set_piece_id (self, '\0');
#line 1662 "puzzle-view.c"
	}
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = FALSE;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1668 "puzzle-view.c"
}


static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gint new_piece_x = 0;
	gint new_piece_y = 0;
	gchar _tmp0_ = '\0';
	gchar _tmp1_ = '\0';
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = puzzle_view_get_piece_id (self);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp1_ != '\0') {
#line 1689 "puzzle-view.c"
		GdkEventMotion* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GdkEventMotion* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
		gdouble _tmp9_ = 0.0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gint _tmp15_ = 0;
		Puzzle* _tmp16_ = NULL;
		Puzzle* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		Puzzle* _tmp27_ = NULL;
		Puzzle* _tmp28_ = NULL;
		gchar _tmp29_ = '\0';
		gchar _tmp30_ = '\0';
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gboolean _tmp35_ = FALSE;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp2_ = event;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = _tmp2_->x;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp4_ = self->priv->kx;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp5_ = puzzle_view_get_tile_size (self);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp6_ = _tmp5_;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		new_piece_x = ((gint) (_tmp3_ - _tmp4_)) / _tmp6_;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp7_ = event;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp8_ = _tmp7_->y;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp9_ = self->priv->ky;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp10_ = puzzle_view_get_tile_size (self);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp11_ = _tmp10_;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		new_piece_y = ((gint) (_tmp8_ - _tmp9_)) / _tmp11_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp15_ = new_piece_x;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp16_ = puzzle_view_get_puzzle (self);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp17_ = _tmp16_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp18_ = _tmp17_->width;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp15_ >= _tmp18_) {
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp14_ = TRUE;
#line 1752 "puzzle-view.c"
		} else {
			GdkEventMotion* _tmp19_ = NULL;
			gdouble _tmp20_ = 0.0;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp19_ = event;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp20_ = _tmp19_->x;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp14_ = _tmp20_ < ((gdouble) 0);
#line 1762 "puzzle-view.c"
		}
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp14_) {
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp13_ = TRUE;
#line 1768 "puzzle-view.c"
		} else {
			gint _tmp21_ = 0;
			Puzzle* _tmp22_ = NULL;
			Puzzle* _tmp23_ = NULL;
			gint _tmp24_ = 0;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp21_ = new_piece_y;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp22_ = puzzle_view_get_puzzle (self);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp23_ = _tmp22_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp24_ = _tmp23_->height;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp13_ = _tmp21_ >= _tmp24_;
#line 1784 "puzzle-view.c"
		}
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp13_) {
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp12_ = TRUE;
#line 1790 "puzzle-view.c"
		} else {
			GdkEventMotion* _tmp25_ = NULL;
			gdouble _tmp26_ = 0.0;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp25_ = event;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp26_ = _tmp25_->y;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp12_ = _tmp26_ < ((gdouble) 0);
#line 1800 "puzzle-view.c"
		}
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp12_) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1808 "puzzle-view.c"
		}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp27_ = puzzle_view_get_puzzle (self);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp28_ = _tmp27_;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp29_ = puzzle_view_get_piece_id (self);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp30_ = _tmp29_;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp31_ = self->priv->piece_x;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp32_ = self->priv->piece_y;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp33_ = new_piece_x;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp34_ = new_piece_y;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp35_ = puzzle_move_piece (_tmp28_, _tmp30_, _tmp31_, _tmp32_, _tmp33_, _tmp34_);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp35_) {
#line 1830 "puzzle-view.c"
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			self->priv->piece_unmoved = FALSE;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp36_ = new_piece_x;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			self->priv->piece_x = _tmp36_;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp37_ = new_piece_y;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			self->priv->piece_y = _tmp37_;
#line 1843 "puzzle-view.c"
		}
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		result = TRUE;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		return result;
#line 1849 "puzzle-view.c"
	}
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = FALSE;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1855 "puzzle-view.c"
}


static void puzzle_view_puzzle_changed_cb (PuzzleView* self) {
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1864 "puzzle-view.c"
}


static gchar puzzle_view_get_piece_id (PuzzleView* self) {
	gchar result;
	gchar _tmp0_ = '\0';
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = self->priv->_piece_id;
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = _tmp0_;
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1879 "puzzle-view.c"
}


static void puzzle_view_set_piece_id (PuzzleView* self, gchar value) {
	gchar _tmp0_ = '\0';
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = value;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->_piece_id = _tmp0_;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1893 "puzzle-view.c"
}


Puzzle* puzzle_view_get_puzzle (PuzzleView* self) {
	Puzzle* result;
	Puzzle* _tmp0_ = NULL;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = self->priv->_puzzle;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = _tmp0_;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1908 "puzzle-view.c"
}


static void _puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender, gpointer self) {
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	puzzle_view_puzzle_changed_cb ((PuzzleView*) self);
#line 1915 "puzzle-view.c"
}


void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value) {
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp2_ = NULL;
	Puzzle* _tmp3_ = NULL;
	Puzzle* _tmp4_ = NULL;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = self->priv->_puzzle;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp0_ != NULL) {
#line 1930 "puzzle-view.c"
		Puzzle* _tmp1_ = NULL;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp1_ = self->priv->_puzzle;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1936 "puzzle-view.c"
	}
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = value;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->_puzzle);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->_puzzle = _tmp3_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp4_ = self->priv->_puzzle;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_signal_connect_object (_tmp4_, "changed", (GCallback) _puzzle_view_puzzle_changed_cb_puzzle_changed, self, 0);
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_x = 0;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_y = 0;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	puzzle_view_set_piece_id (self, '\0');
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_object_notify ((GObject *) self, "puzzle");
#line 1960 "puzzle-view.c"
}


static gint puzzle_view_get_tile_size (PuzzleView* self) {
	gint result;
	gint s = 0;
	gint _tmp0_ = 0;
	Puzzle* _tmp1_ = NULL;
	Puzzle* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Puzzle* _tmp5_ = NULL;
	Puzzle* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp11_ = 0;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = puzzle_view_get_puzzle (self);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = _tmp1_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp3_ = _tmp2_->width;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp4_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp5_ = puzzle_view_get_puzzle (self);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp6_ = _tmp5_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp7_ = _tmp6_->height;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp8_ = MIN ((_tmp0_ - PUZZLE_VIEW_SPACE_PADDING) / _tmp3_, (_tmp4_ - PUZZLE_VIEW_SPACE_PADDING) / _tmp7_);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	s = _tmp8_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp9_ = s;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if ((_tmp9_ % 2) != 0) {
#line 2004 "puzzle-view.c"
		gint _tmp10_ = 0;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp10_ = s;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		s = _tmp10_ - 1;
#line 2010 "puzzle-view.c"
	}
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp11_ = s;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = _tmp11_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 2018 "puzzle-view.c"
}


static void puzzle_view_class_init (PuzzleViewClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	puzzle_view_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_type_class_add_private (klass, sizeof (PuzzleViewPrivate));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->draw = puzzle_view_real_draw;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = puzzle_view_real_button_press_event;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->button_release_event = puzzle_view_real_button_release_event;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->motion_notify_event = puzzle_view_real_motion_notify_event;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_view_get_property;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_view_set_property;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->finalize = puzzle_view_finalize;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_PUZZLE, g_param_spec_object ("puzzle", "puzzle", "puzzle", TYPE_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2043 "puzzle-view.c"
}


static void puzzle_view_instance_init (PuzzleView * self) {
	gchar* _tmp0_ = NULL;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv = PUZZLE_VIEW_GET_PRIVATE (self);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->render_size = 0;
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_x = 0;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_y = 0;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_unmoved = FALSE;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->_piece_id = '\0';
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->last_piece_id = '\0';
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->kx = (gdouble) 0;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->ky = (gdouble) 0;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->tiles_handle = NULL;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = g_strdup ("");
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->image_filepath = _tmp0_;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->surface = NULL;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->_puzzle = NULL;
#line 2077 "puzzle-view.c"
}


static void puzzle_view_finalize (GObject* obj) {
	PuzzleView * self;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_VIEW, PuzzleView);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->tiles_handle);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_free0 (self->priv->image_filepath);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_cairo_surface_destroy0 (self->priv->surface);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->_puzzle);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	G_OBJECT_CLASS (puzzle_view_parent_class)->finalize (obj);
#line 2095 "puzzle-view.c"
}


GType puzzle_view_get_type (void) {
	static volatile gsize puzzle_view_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleView), 0, (GInstanceInitFunc) puzzle_view_instance_init, NULL };
		GType puzzle_view_type_id;
		puzzle_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "PuzzleView", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_view_type_id__volatile, puzzle_view_type_id);
	}
	return puzzle_view_type_id__volatile;
}


static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		case PUZZLE_VIEW_PUZZLE:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		g_value_set_object (value, puzzle_view_get_puzzle (self));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		break;
#line 2122 "puzzle-view.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		break;
#line 2128 "puzzle-view.c"
	}
}


static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		case PUZZLE_VIEW_PUZZLE:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		puzzle_view_set_puzzle (self, g_value_get_object (value));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		break;
#line 2144 "puzzle-view.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		break;
#line 2150 "puzzle-view.c"
	}
}



