/* contacts-window.c generated by valac 0.26.1, the Vala compiler
 * generated from contacts-window.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <folks/folks-eds.h>
#include <folks/folks.h>
#include <contacts-esd-setup.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <libgd/gd.h>
#include <pango/pango.h>


#define CONTACTS_TYPE_WINDOW (contacts_window_get_type ())
#define CONTACTS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_WINDOW, ContactsWindow))
#define CONTACTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_WINDOW, ContactsWindowClass))
#define CONTACTS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_WINDOW))
#define CONTACTS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_WINDOW))
#define CONTACTS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_WINDOW, ContactsWindowClass))

typedef struct _ContactsWindow ContactsWindow;
typedef struct _ContactsWindowClass ContactsWindowClass;
typedef struct _ContactsWindowPrivate ContactsWindowPrivate;

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;

#define CONTACTS_TYPE_ACCOUNTS_LIST (contacts_accounts_list_get_type ())
#define CONTACTS_ACCOUNTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsList))
#define CONTACTS_ACCOUNTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsListClass))
#define CONTACTS_IS_ACCOUNTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_ACCOUNTS_LIST))
#define CONTACTS_IS_ACCOUNTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_ACCOUNTS_LIST))
#define CONTACTS_ACCOUNTS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsListClass))

typedef struct _ContactsAccountsList ContactsAccountsList;
typedef struct _ContactsAccountsListClass ContactsAccountsListClass;

#define CONTACTS_TYPE_LIST_PANE (contacts_list_pane_get_type ())
#define CONTACTS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPane))
#define CONTACTS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))
#define CONTACTS_IS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_IS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_LIST_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))

typedef struct _ContactsListPane ContactsListPane;
typedef struct _ContactsListPaneClass ContactsListPaneClass;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block37Data Block37Data;

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;
typedef struct _Block38Data Block38Data;
typedef struct _ContactsAccountsListPrivate ContactsAccountsListPrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ContactsContactPanePrivate ContactsContactPanePrivate;
typedef struct _ContactsListPanePrivate ContactsListPanePrivate;

#define CONTACTS_TYPE_LINK_OPERATION2 (contacts_link_operation2_get_type ())
#define CONTACTS_LINK_OPERATION2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LINK_OPERATION2, ContactsLinkOperation2))
#define CONTACTS_LINK_OPERATION2_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LINK_OPERATION2, ContactsLinkOperation2Class))
#define CONTACTS_IS_LINK_OPERATION2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LINK_OPERATION2))
#define CONTACTS_IS_LINK_OPERATION2_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LINK_OPERATION2))
#define CONTACTS_LINK_OPERATION2_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LINK_OPERATION2, ContactsLinkOperation2Class))

typedef struct _ContactsLinkOperation2 ContactsLinkOperation2;
typedef struct _ContactsLinkOperation2Class ContactsLinkOperation2Class;
typedef struct _Block39Data Block39Data;
typedef struct _Block40Data Block40Data;
typedef struct _Block41Data Block41Data;

#define CONTACTS_TYPE_LINK_OPERATION (contacts_link_operation_get_type ())
#define CONTACTS_LINK_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LINK_OPERATION, ContactsLinkOperation))
#define CONTACTS_LINK_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LINK_OPERATION, ContactsLinkOperationClass))
#define CONTACTS_IS_LINK_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LINK_OPERATION))
#define CONTACTS_IS_LINK_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LINK_OPERATION))
#define CONTACTS_LINK_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LINK_OPERATION, ContactsLinkOperationClass))

typedef struct _ContactsLinkOperation ContactsLinkOperation;
typedef struct _ContactsLinkOperationClass ContactsLinkOperationClass;
typedef struct _Block42Data Block42Data;

struct _ContactsWindow {
	GtkApplicationWindow parent_instance;
	ContactsWindowPrivate * priv;
};

struct _ContactsWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _ContactsWindowPrivate {
	GtkGrid* content_grid;
	GtkGrid* loading_box;
	GtkSizeGroup* left_pane_size_group;
	GtkHeaderBar* left_toolbar;
	GtkHeaderBar* right_toolbar;
	GtkOverlay* overlay;
	ContactsContactPane* contact_pane;
	GtkButton* add_button;
	GtkToggleButton* select_button;
	GtkButton* edit_button;
	GtkButton* cancel_button;
	GtkButton* done_button;
	GtkStack* view_switcher;
	GtkBox* content_header_bar;
	GtkHeaderBar* setup_header_bar;
	GtkButton* setup_done_button;
	GtkButton* setup_cancel_button;
	ContactsAccountsList* setup_accounts_list;
	ContactsListPane* list_pane;
	gboolean new_contact_mode;
	ContactsStore* _store;
	gboolean _selection_mode;
	gboolean _edit_mode;
};

struct _Block37Data {
	int _ref_count_;
	ContactsWindow* self;
	GtkApplication* app;
};

struct _ContactsApp {
	GtkApplication parent_instance;
	ContactsAppPrivate * priv;
	GSettings* settings;
	ContactsStore* contacts_store;
	ContactsWindow* window;
};

struct _ContactsAppClass {
	GtkApplicationClass parent_class;
};

struct _Block38Data {
	int _ref_count_;
	Block37Data * _data37_;
	GSimpleAction* change_book_action;
	gulong id2;
};

struct _ContactsAccountsList {
	GtkGrid parent_instance;
	ContactsAccountsListPrivate * priv;
	FolksPersonaStore* selected_store;
};

struct _ContactsAccountsListClass {
	GtkGridClass parent_class;
};

struct _ContactsContactPane {
	GtkNotebook parent_instance;
	ContactsContactPanePrivate * priv;
	ContactsContact* contact;
	gboolean on_edit_mode;
	GtkGrid* suggestion_grid;
};

struct _ContactsContactPaneClass {
	GtkNotebookClass parent_class;
};

struct _ContactsListPane {
	GtkFrame parent_instance;
	ContactsListPanePrivate * priv;
	GtkToolItem* search_tool_item;
	GtkSearchEntry* filter_entry;
	GtkButton* link_button;
	GtkButton* delete_button;
	GtkActionBar* actions_bar;
};

struct _ContactsListPaneClass {
	GtkFrameClass parent_class;
};

struct _Block39Data {
	int _ref_count_;
	ContactsWindow* self;
	ContactsLinkOperation2* operation;
	GdNotification* notification;
};

struct _Block40Data {
	int _ref_count_;
	ContactsWindow* self;
	GdNotification* notification;
	gboolean really_delete;
	GeeLinkedList* contact_list;
};

struct _Block41Data {
	int _ref_count_;
	ContactsWindow* self;
	GdNotification* notification;
	gboolean really_delete;
	ContactsContact* contact;
};

struct _Block42Data {
	int _ref_count_;
	ContactsWindow* self;
	GdNotification* notification;
	ContactsLinkOperation* operation;
};


static gpointer contacts_window_parent_class = NULL;

GType contacts_window_get_type (void) G_GNUC_CONST;
GType contacts_contact_pane_get_type (void) G_GNUC_CONST;
GType contacts_accounts_list_get_type (void) G_GNUC_CONST;
GType contacts_list_pane_get_type (void) G_GNUC_CONST;
GType contacts_store_get_type (void) G_GNUC_CONST;
#define CONTACTS_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_WINDOW, ContactsWindowPrivate))
enum  {
	CONTACTS_WINDOW_DUMMY_PROPERTY,
	CONTACTS_WINDOW_STORE,
	CONTACTS_WINDOW_SELECTION_MODE,
	CONTACTS_WINDOW_EDIT_MODE
};
ContactsWindow* contacts_window_new (GtkApplication* app, ContactsStore* contacts_store);
ContactsWindow* contacts_window_construct (GType object_type, GtkApplication* app, ContactsStore* contacts_store);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
void contacts_contact_pane_set_store (ContactsContactPane* self, ContactsStore* value);
GType contacts_app_get_type (void) G_GNUC_CONST;
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
ContactsStore* contacts_window_get_store (ContactsWindow* self);
static void ___lambda86_ (ContactsWindow* self);
void contacts_accounts_list_update_contents (ContactsAccountsList* self, gboolean select_active);
static void ____lambda86__contacts_store_eds_persona_store_changed (ContactsStore* _sender, gpointer self);
static void ___lambda87_ (Block38Data* _data38_);
static void ____lambda87__contacts_accounts_list_account_selected (ContactsAccountsList* _sender, gpointer self);
static void ___lambda88_ (Block38Data* _data38_);
static void ____lambda88__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda89_ (Block38Data* _data38_);
static void ____lambda89__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void contacts_window_init_content_widgets (ContactsWindow* self);
void contacts_window_set_list_pane (ContactsWindow* self);
ContactsListPane* contacts_list_pane_new (ContactsStore* contacts_store);
ContactsListPane* contacts_list_pane_construct (GType object_type, ContactsStore* contacts_store);
GType contacts_contact_get_type (void) G_GNUC_CONST;
static void contacts_window_list_pane_selection_changed_cb (ContactsWindow* self, ContactsContact* new_selection);
static void _contacts_window_list_pane_selection_changed_cb_contacts_list_pane_selection_changed (ContactsListPane* _sender, ContactsContact* contact, gpointer self);
static void contacts_window_list_pane_link_contacts_cb (ContactsWindow* self, GeeLinkedList* contact_list);
static void _contacts_window_list_pane_link_contacts_cb_contacts_list_pane_link_contacts (ContactsListPane* _sender, GeeLinkedList* contacts_list, gpointer self);
static void contacts_window_list_pane_delete_contacts_cb (ContactsWindow* self, GeeLinkedList* contact_list);
static void _contacts_window_list_pane_delete_contacts_cb_contacts_list_pane_delete_contacts (ContactsListPane* _sender, GeeLinkedList* contacts_list, gpointer self);
static void __lambda98_ (ContactsWindow* self, gint nr_contacts);
static void contacts_window_set_left_title (ContactsWindow* self, const gchar* value);
static void ___lambda98__contacts_list_pane_contacts_marked (ContactsListPane* _sender, gint contacts_marked, gpointer self);
void contacts_list_pane_select_contact (ContactsListPane* self, ContactsContact* contact, gboolean ignore_change);
void contacts_window_activate_selection_mode (ContactsWindow* self, gboolean active);
void contacts_window_set_selection_mode (ContactsWindow* self, gboolean value);
void contacts_list_pane_show_selection (ContactsListPane* self);
void contacts_list_pane_hide_selection (ContactsListPane* self);
void contacts_window_enter_edit_mode (ContactsWindow* self);
void contacts_window_set_edit_mode (ContactsWindow* self, gboolean value);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void contacts_window_set_right_title (ContactsWindow* self, const gchar* value);
void contacts_contact_pane_set_edit_mode (ContactsContactPane* self, gboolean on_edit, gboolean drop_changes);
void contacts_window_leave_edit_mode (ContactsWindow* self, gboolean drop_changes);
void contacts_contact_pane_create_contact (ContactsContactPane* self);
void contacts_window_add_notification (ContactsWindow* self, GtkWidget* notification);
void contacts_window_set_shown_contact (ContactsWindow* self, ContactsContact* c);
void contacts_contact_pane_show_contact (ContactsContactPane* self, ContactsContact* new_contact, gboolean show_matches);
void contacts_window_new_contact (ContactsWindow* self);
void contacts_contact_pane_new_contact (ContactsContactPane* self);
static void _contacts_window_new_contact_gtk_button_clicked (GtkButton* _sender, gpointer self);
void contacts_window_show_search (ContactsWindow* self, const gchar* query);
static void __lambda90_ (ContactsWindow* self);
static void ___lambda90__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void __lambda91_ (ContactsWindow* self);
static void ___lambda91__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda92_ (ContactsWindow* self);
static void ___lambda92__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda93_ (ContactsWindow* self);
static void ___lambda93__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean contacts_window_key_press_event_cb (ContactsWindow* self, GdkEventKey* event);
void contacts_utils_grab_entry_focus_no_select (GtkEntry* entry);
static gboolean _contacts_window_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean contacts_window_delete_event_cb (ContactsWindow* self, GdkEventAny* event);
static gboolean _contacts_window_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
GType contacts_link_operation2_get_type (void) G_GNUC_CONST;
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
void contacts_link_contacts_list (GeeLinkedList* contact_list, GAsyncReadyCallback _callback_, gpointer _user_data_);
ContactsLinkOperation2* contacts_link_contacts_list_finish (GAsyncResult* _res_);
static void __lambda94_ (Block39Data* _data39_, GObject* obj, GAsyncResult* _result_);
static void ___lambda94__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda95_ (Block39Data* _data39_);
void contacts_link_operation2_undo (ContactsLinkOperation2* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_link_operation2_undo_finish (ContactsLinkOperation2* self, GAsyncResult* _res_);
static void ___lambda95__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block40Data* block40_data_ref (Block40Data* _data40_);
static void block40_data_unref (void * _userdata_);
static void __lambda96_ (Block40Data* _data40_);
void contacts_contact_remove_personas (ContactsContact* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_contact_remove_personas_finish (ContactsContact* self, GAsyncResult* _res_, GError** error);
static void ___lambda96__gd_notification_dismissed (GdNotification* _sender, gpointer self);
static void __lambda97_ (Block40Data* _data40_);
void contacts_contact_show (ContactsContact* self);
static void ___lambda97__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void contacts_window_contact_pane_delete_contact_cb (ContactsWindow* self, ContactsContact* contact);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
static void __lambda99_ (Block41Data* _data41_);
static void ___lambda100_ (Block41Data* _data41_);
static void ____lambda100__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda99__gd_notification_dismissed (GdNotification* _sender, gpointer self);
static void __lambda101_ (Block41Data* _data41_);
static void ___lambda101__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _contacts_window_contact_pane_delete_contact_cb_contacts_contact_pane_will_delete (ContactsContactPane* _sender, ContactsContact* contact, gpointer self);
GType contacts_link_operation_get_type (void) G_GNUC_CONST;
static void contacts_window_contact_pane_contacts_linked_cb (ContactsWindow* self, const gchar* main_contact, const gchar* linked_contact, ContactsLinkOperation* operation);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
static void __lambda102_ (Block42Data* _data42_);
void contacts_link_operation_undo (ContactsLinkOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_link_operation_undo_finish (ContactsLinkOperation* self, GAsyncResult* _res_);
static void ___lambda102__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _contacts_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked (ContactsContactPane* _sender, const gchar* main_contact, const gchar* linked_contact, ContactsLinkOperation* operation, gpointer self);
static const gchar* contacts_window_get_left_title (ContactsWindow* self);
static const gchar* contacts_window_get_right_title (ContactsWindow* self);
void contacts_window_set_store (ContactsWindow* self, ContactsStore* value);
gboolean contacts_window_get_selection_mode (ContactsWindow* self);
gboolean contacts_window_get_edit_mode (ContactsWindow* self);
static void contacts_window_finalize (GObject* obj);
static void _vala_contacts_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_contacts_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block37Data* block37_data_ref (Block37Data* _data37_) {
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}


static void block37_data_unref (void * _userdata_) {
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		ContactsWindow* self;
		self = _data37_->self;
		_g_object_unref0 (_data37_->app);
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}


static Block38Data* block38_data_ref (Block38Data* _data38_) {
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}


static void block38_data_unref (void * _userdata_) {
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		ContactsWindow* self;
		self = _data38_->_data37_->self;
		_g_object_unref0 (_data38_->change_book_action);
		block37_data_unref (_data38_->_data37_);
		_data38_->_data37_ = NULL;
		g_slice_free (Block38Data, _data38_);
	}
}


static void ___lambda86_ (ContactsWindow* self) {
	ContactsAccountsList* _tmp0_ = NULL;
	_tmp0_ = self->priv->setup_accounts_list;
	contacts_accounts_list_update_contents (_tmp0_, FALSE);
}


static void ____lambda86__contacts_store_eds_persona_store_changed (ContactsStore* _sender, gpointer self) {
	___lambda86_ ((ContactsWindow*) self);
}


static void ___lambda87_ (Block38Data* _data38_) {
	Block37Data* _data37_;
	ContactsWindow* self;
	GtkButton* _tmp0_ = NULL;
	ContactsAccountsList* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	_data37_ = _data38_->_data37_;
	self = _data37_->self;
	_tmp0_ = self->priv->setup_done_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->setup_accounts_list;
	_tmp2_ = _data38_->id2;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
}


static void ____lambda87__contacts_accounts_list_account_selected (ContactsAccountsList* _sender, gpointer self) {
	___lambda87_ (self);
}


static void ___lambda88_ (Block38Data* _data38_) {
	Block37Data* _data37_;
	ContactsWindow* self;
	GtkStack* _tmp0_ = NULL;
	GtkBox* _tmp1_ = NULL;
	EdsfPersonaStore* e_store = NULL;
	ContactsAccountsList* _tmp2_ = NULL;
	FolksPersonaStore* _tmp3_ = NULL;
	EdsfPersonaStore* _tmp4_ = NULL;
	ESourceRegistry* _tmp5_ = NULL;
	EdsfPersonaStore* _tmp6_ = NULL;
	ESource* _tmp7_ = NULL;
	ESource* _tmp8_ = NULL;
	GtkApplication* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	GSimpleAction* _tmp11_ = NULL;
	_data37_ = _data38_->_data37_;
	self = _data37_->self;
	_tmp0_ = self->priv->view_switcher;
	gtk_stack_set_visible_child_name (_tmp0_, "content-view");
	_tmp1_ = self->priv->content_header_bar;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->setup_accounts_list;
	_tmp3_ = _tmp2_->selected_store;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, EDSF_TYPE_PERSONA_STORE) ? ((EdsfPersonaStore*) _tmp3_) : NULL);
	e_store = _tmp4_;
	_tmp5_ = eds_source_registry;
	_tmp6_ = e_store;
	_tmp7_ = edsf_persona_store_get_source (_tmp6_);
	_tmp8_ = _tmp7_;
	e_source_registry_set_default_address_book (_tmp5_, _tmp8_);
	_tmp9_ = _data37_->app;
	_tmp10_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, CONTACTS_TYPE_APP) ? ((ContactsApp*) _tmp9_) : NULL)->settings;
	g_settings_set_boolean (_tmp10_, "did-initial-setup", TRUE);
	_tmp11_ = _data38_->change_book_action;
	if (_tmp11_ != NULL) {
		GSimpleAction* _tmp12_ = NULL;
		_tmp12_ = _data38_->change_book_action;
		g_simple_action_set_enabled (_tmp12_, TRUE);
	}
	_g_object_unref0 (e_store);
}


static void ____lambda88__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda88_ (self);
}


static void ___lambda89_ (Block38Data* _data38_) {
	Block37Data* _data37_;
	ContactsWindow* self;
	GtkApplication* _tmp0_ = NULL;
	_data37_ = _data38_->_data37_;
	self = _data37_->self;
	_tmp0_ = _data37_->app;
	g_application_quit ((GApplication*) _tmp0_);
}


static void ____lambda89__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda89_ (self);
}


ContactsWindow* contacts_window_construct (GType object_type, GtkApplication* app, ContactsStore* contacts_store) {
	ContactsWindow * self = NULL;
	Block37Data* _data37_;
	GtkApplication* _tmp0_ = NULL;
	GtkApplication* _tmp1_ = NULL;
	GtkApplication* _tmp2_ = NULL;
	ContactsStore* _tmp3_ = NULL;
	ContactsContactPane* _tmp4_ = NULL;
	ContactsStore* _tmp5_ = NULL;
	GtkHeaderBar* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	GtkToggleButton* _tmp13_ = NULL;
	GtkHeaderBar* _tmp14_ = NULL;
	GtkApplication* _tmp15_ = NULL;
	GSettings* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (contacts_store != NULL, NULL);
	_data37_ = g_slice_new0 (Block37Data);
	_data37_->_ref_count_ = 1;
	_tmp0_ = app;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data37_->app);
	_data37_->app = _tmp1_;
	_tmp2_ = _data37_->app;
	_tmp3_ = contacts_store;
	self = (ContactsWindow*) g_object_new (object_type, "application", _tmp2_, "store", _tmp3_, NULL);
	_data37_->self = g_object_ref (self);
	g_debug ("contacts-window.vala:101: everyone creation: finalized already!!!");
	_tmp4_ = self->priv->contact_pane;
	_tmp5_ = contacts_store;
	contacts_contact_pane_set_store (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->right_toolbar;
	g_object_bind_property_with_closures ((GObject*) self, "selection-mode", (GObject*) _tmp6_, "show-close-button", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp7_ = self->priv->add_button;
	g_object_bind_property_with_closures ((GObject*) self, "selection-mode", (GObject*) _tmp7_, "visible", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp8_ = self->priv->edit_button;
	g_object_bind_property_with_closures ((GObject*) self, "selection-mode", (GObject*) _tmp8_, "visible", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp9_ = self->priv->edit_button;
	g_object_bind_property_with_closures ((GObject*) self, "edit-mode", (GObject*) _tmp9_, "visible", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp10_ = self->priv->done_button;
	g_object_bind_property_with_closures ((GObject*) self, "edit-mode", (GObject*) _tmp10_, "visible", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp11_ = self->priv->cancel_button;
	g_object_bind_property_with_closures ((GObject*) self, "edit-mode", (GObject*) _tmp11_, "visible", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp12_ = self->priv->add_button;
	g_object_bind_property_with_closures ((GObject*) self, "edit-mode", (GObject*) _tmp12_, "visible", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp13_ = self->priv->select_button;
	g_object_bind_property_with_closures ((GObject*) self, "edit-mode", (GObject*) _tmp13_, "visible", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp14_ = self->priv->right_toolbar;
	g_object_bind_property_with_closures ((GObject*) self, "edit-mode", (GObject*) _tmp14_, "show-close-button", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp15_ = _data37_->app;
	_tmp16_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, CONTACTS_TYPE_APP) ? ((ContactsApp*) _tmp15_) : NULL)->settings;
	_tmp17_ = g_settings_get_boolean (_tmp16_, "did-initial-setup");
	if (_tmp17_) {
		GtkStack* _tmp18_ = NULL;
		GtkBox* _tmp19_ = NULL;
		_tmp18_ = self->priv->view_switcher;
		gtk_stack_set_visible_child_name (_tmp18_, "content-view");
		_tmp19_ = self->priv->content_header_bar;
		gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp19_);
	} else {
		Block38Data* _data38_;
		GtkApplication* _tmp20_ = NULL;
		GAction* _tmp21_ = NULL;
		GSimpleAction* _tmp22_ = NULL;
		GSimpleAction* _tmp23_ = NULL;
		ContactsStore* _tmp25_ = NULL;
		ContactsAccountsList* _tmp26_ = NULL;
		gulong _tmp27_ = 0UL;
		GtkStack* _tmp28_ = NULL;
		GtkHeaderBar* _tmp29_ = NULL;
		ContactsAccountsList* _tmp30_ = NULL;
		GtkButton* _tmp31_ = NULL;
		GtkButton* _tmp32_ = NULL;
		_data38_ = g_slice_new0 (Block38Data);
		_data38_->_ref_count_ = 1;
		_data38_->_data37_ = block37_data_ref (_data37_);
		_tmp20_ = _data37_->app;
		_tmp21_ = g_action_map_lookup_action ((GActionMap*) _tmp20_, "change_book");
		_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp21_) : NULL);
		_data38_->change_book_action = _tmp22_;
		_tmp23_ = _data38_->change_book_action;
		if (_tmp23_ != NULL) {
			GSimpleAction* _tmp24_ = NULL;
			_tmp24_ = _data38_->change_book_action;
			g_simple_action_set_enabled (_tmp24_, FALSE);
		}
		_tmp25_ = self->priv->_store;
		g_signal_connect_object (_tmp25_, "eds-persona-store-changed", (GCallback) ____lambda86__contacts_store_eds_persona_store_changed, self, 0);
		_data38_->id2 = (gulong) 0;
		_tmp26_ = self->priv->setup_accounts_list;
		_tmp27_ = g_signal_connect_data (_tmp26_, "account-selected", (GCallback) ____lambda87__contacts_accounts_list_account_selected, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
		_data38_->id2 = _tmp27_;
		_tmp28_ = self->priv->view_switcher;
		gtk_stack_set_visible_child_name (_tmp28_, "setup-view");
		_tmp29_ = self->priv->setup_header_bar;
		gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp29_);
		_tmp30_ = self->priv->setup_accounts_list;
		contacts_accounts_list_update_contents (_tmp30_, FALSE);
		_tmp31_ = self->priv->setup_done_button;
		g_signal_connect_data (_tmp31_, "clicked", (GCallback) ____lambda88__gtk_button_clicked, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
		_tmp32_ = self->priv->setup_cancel_button;
		g_signal_connect_data (_tmp32_, "clicked", (GCallback) ____lambda89__gtk_button_clicked, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
		block38_data_unref (_data38_);
		_data38_ = NULL;
	}
	contacts_window_init_content_widgets (self);
	block37_data_unref (_data37_);
	_data37_ = NULL;
	return self;
}


ContactsWindow* contacts_window_new (GtkApplication* app, ContactsStore* contacts_store) {
	return contacts_window_construct (CONTACTS_TYPE_WINDOW, app, contacts_store);
}


static void _contacts_window_list_pane_selection_changed_cb_contacts_list_pane_selection_changed (ContactsListPane* _sender, ContactsContact* contact, gpointer self) {
	contacts_window_list_pane_selection_changed_cb ((ContactsWindow*) self, contact);
}


static void _contacts_window_list_pane_link_contacts_cb_contacts_list_pane_link_contacts (ContactsListPane* _sender, GeeLinkedList* contacts_list, gpointer self) {
	contacts_window_list_pane_link_contacts_cb ((ContactsWindow*) self, contacts_list);
}


static void _contacts_window_list_pane_delete_contacts_cb_contacts_list_pane_delete_contacts (ContactsListPane* _sender, GeeLinkedList* contacts_list, gpointer self) {
	contacts_window_list_pane_delete_contacts_cb ((ContactsWindow*) self, contacts_list);
}


static void __lambda98_ (ContactsWindow* self, gint nr_contacts) {
	gint _tmp0_ = 0;
	_tmp0_ = nr_contacts;
	if (_tmp0_ == 0) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("Select");
		contacts_window_set_left_title (self, _tmp1_);
	} else {
		gint _tmp2_ = 0;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp2_ = nr_contacts;
		_tmp3_ = ngettext ("%d Selected", "%d Selected", (gulong) _tmp2_);
		_tmp4_ = nr_contacts;
		_tmp5_ = g_strdup_printf (_tmp3_, _tmp4_);
		_tmp6_ = _tmp5_;
		contacts_window_set_left_title (self, _tmp6_);
		_g_free0 (_tmp6_);
	}
}


static void ___lambda98__contacts_list_pane_contacts_marked (ContactsListPane* _sender, gint contacts_marked, gpointer self) {
	__lambda98_ ((ContactsWindow*) self, contacts_marked);
}


void contacts_window_set_list_pane (ContactsWindow* self) {
	ContactsListPane* _tmp0_ = NULL;
	ContactsStore* _tmp1_ = NULL;
	ContactsListPane* _tmp2_ = NULL;
	ContactsListPane* _tmp3_ = NULL;
	ContactsListPane* _tmp4_ = NULL;
	ContactsListPane* _tmp5_ = NULL;
	ContactsListPane* _tmp6_ = NULL;
	GtkSizeGroup* _tmp7_ = NULL;
	ContactsListPane* _tmp8_ = NULL;
	GtkSizeGroup* _tmp9_ = NULL;
	GtkGrid* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	ContactsListPane* _tmp13_ = NULL;
	ContactsContactPane* _tmp14_ = NULL;
	ContactsContact* _tmp15_ = NULL;
	ContactsListPane* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_pane;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = self->priv->_store;
	_tmp2_ = contacts_list_pane_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->list_pane);
	self->priv->list_pane = _tmp2_;
	_tmp3_ = self->priv->list_pane;
	g_signal_connect_object (_tmp3_, "selection-changed", (GCallback) _contacts_window_list_pane_selection_changed_cb_contacts_list_pane_selection_changed, self, 0);
	_tmp4_ = self->priv->list_pane;
	g_signal_connect_object (_tmp4_, "link-contacts", (GCallback) _contacts_window_list_pane_link_contacts_cb_contacts_list_pane_link_contacts, self, 0);
	_tmp5_ = self->priv->list_pane;
	g_signal_connect_object (_tmp5_, "delete-contacts", (GCallback) _contacts_window_list_pane_delete_contacts_cb_contacts_list_pane_delete_contacts, self, 0);
	_tmp6_ = self->priv->list_pane;
	g_signal_connect_object (_tmp6_, "contacts-marked", (GCallback) ___lambda98__contacts_list_pane_contacts_marked, self, 0);
	_tmp7_ = self->priv->left_pane_size_group;
	_tmp8_ = self->priv->list_pane;
	gtk_size_group_add_widget (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->left_pane_size_group;
	_tmp10_ = self->priv->loading_box;
	gtk_size_group_remove_widget (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->loading_box;
	gtk_widget_destroy ((GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->content_grid;
	_tmp13_ = self->priv->list_pane;
	gtk_grid_attach (_tmp12_, (GtkWidget*) _tmp13_, 0, 0, 1, 1);
	_tmp14_ = self->priv->contact_pane;
	_tmp15_ = _tmp14_->contact;
	if (_tmp15_ != NULL) {
		ContactsListPane* _tmp16_ = NULL;
		ContactsContactPane* _tmp17_ = NULL;
		ContactsContact* _tmp18_ = NULL;
		_tmp16_ = self->priv->list_pane;
		_tmp17_ = self->priv->contact_pane;
		_tmp18_ = _tmp17_->contact;
		contacts_list_pane_select_contact (_tmp16_, _tmp18_, FALSE);
	}
	_tmp19_ = self->priv->list_pane;
	gtk_widget_show ((GtkWidget*) _tmp19_);
}


void contacts_window_activate_selection_mode (ContactsWindow* self, gboolean active) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = active;
	if (_tmp0_) {
		GtkHeaderBar* _tmp1_ = NULL;
		GtkStyleContext* _tmp2_ = NULL;
		GtkHeaderBar* _tmp3_ = NULL;
		GtkStyleContext* _tmp4_ = NULL;
		GtkHeaderBar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		ContactsListPane* _tmp7_ = NULL;
		contacts_window_set_selection_mode (self, TRUE);
		_tmp1_ = self->priv->left_toolbar;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
		gtk_style_context_add_class (_tmp2_, "selection-mode");
		_tmp3_ = self->priv->right_toolbar;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		gtk_style_context_add_class (_tmp4_, "selection-mode");
		_tmp5_ = self->priv->left_toolbar;
		_tmp6_ = _ ("Select");
		gtk_header_bar_set_title (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->list_pane;
		contacts_list_pane_show_selection (_tmp7_);
	} else {
		GtkHeaderBar* _tmp8_ = NULL;
		GtkStyleContext* _tmp9_ = NULL;
		GtkHeaderBar* _tmp10_ = NULL;
		GtkStyleContext* _tmp11_ = NULL;
		GtkHeaderBar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		ContactsListPane* _tmp14_ = NULL;
		ContactsContactPane* _tmp15_ = NULL;
		ContactsContact* _tmp16_ = NULL;
		contacts_window_set_selection_mode (self, FALSE);
		_tmp8_ = self->priv->left_toolbar;
		_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
		gtk_style_context_remove_class (_tmp9_, "selection-mode");
		_tmp10_ = self->priv->right_toolbar;
		_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
		gtk_style_context_remove_class (_tmp11_, "selection-mode");
		_tmp12_ = self->priv->left_toolbar;
		_tmp13_ = _ ("All Contacts");
		gtk_header_bar_set_title (_tmp12_, _tmp13_);
		_tmp14_ = self->priv->list_pane;
		contacts_list_pane_hide_selection (_tmp14_);
		_tmp15_ = self->priv->contact_pane;
		_tmp16_ = _tmp15_->contact;
		if (_tmp16_ == NULL) {
			GtkButton* _tmp17_ = NULL;
			_tmp17_ = self->priv->edit_button;
			gtk_widget_hide ((GtkWidget*) _tmp17_);
		}
	}
}


void contacts_window_enter_edit_mode (ContactsWindow* self) {
	ContactsContactPane* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	gchar* name = NULL;
	ContactsContactPane* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GtkHeaderBar* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GtkHeaderBar* _tmp13_ = NULL;
	GtkStyleContext* _tmp14_ = NULL;
	ContactsContactPane* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contact_pane;
	_tmp1_ = _tmp0_->contact;
	if (_tmp1_ == NULL) {
		return;
	}
	contacts_window_set_edit_mode (self, TRUE);
	_tmp2_ = self->priv->contact_pane;
	_tmp3_ = _tmp2_->contact;
	_tmp4_ = contacts_contact_get_display_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	name = _tmp6_;
	_tmp7_ = _ ("Editing %s");
	_tmp8_ = name;
	_tmp9_ = g_strdup_printf (_tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	contacts_window_set_right_title (self, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = self->priv->left_toolbar;
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _tmp11_);
	gtk_style_context_add_class (_tmp12_, "selection-mode");
	_tmp13_ = self->priv->right_toolbar;
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
	gtk_style_context_add_class (_tmp14_, "selection-mode");
	_tmp15_ = self->priv->contact_pane;
	contacts_contact_pane_set_edit_mode (_tmp15_, TRUE, FALSE);
	_g_free0 (name);
}


void contacts_window_leave_edit_mode (ContactsWindow* self, gboolean drop_changes) {
	GtkHeaderBar* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkHeaderBar* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	ContactsContactPane* _tmp13_ = NULL;
	ContactsContact* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	contacts_window_set_edit_mode (self, FALSE);
	_tmp0_ = self->priv->left_toolbar;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_remove_class (_tmp1_, "selection-mode");
	_tmp2_ = self->priv->right_toolbar;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_remove_class (_tmp3_, "selection-mode");
	_tmp4_ = self->priv->new_contact_mode;
	if (_tmp4_) {
		GtkButton* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = self->priv->done_button;
		_tmp6_ = _ ("Done");
		gtk_button_set_label (_tmp5_, _tmp6_);
		_tmp7_ = drop_changes;
		if (_tmp7_) {
			ContactsContactPane* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			_tmp8_ = self->priv->contact_pane;
			_tmp9_ = drop_changes;
			contacts_contact_pane_set_edit_mode (_tmp8_, FALSE, _tmp9_);
		} else {
			ContactsContactPane* _tmp10_ = NULL;
			_tmp10_ = self->priv->contact_pane;
			contacts_contact_pane_create_contact (_tmp10_);
		}
		self->priv->new_contact_mode = FALSE;
	} else {
		ContactsContactPane* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = self->priv->contact_pane;
		_tmp12_ = drop_changes;
		contacts_contact_pane_set_edit_mode (_tmp11_, FALSE, _tmp12_);
	}
	_tmp13_ = self->priv->contact_pane;
	_tmp14_ = _tmp13_->contact;
	if (_tmp14_ != NULL) {
		ContactsContactPane* _tmp15_ = NULL;
		ContactsContact* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp15_ = self->priv->contact_pane;
		_tmp16_ = _tmp15_->contact;
		_tmp17_ = contacts_contact_get_display_name (_tmp16_);
		_tmp18_ = _tmp17_;
		contacts_window_set_right_title (self, _tmp18_);
	} else {
		GtkButton* _tmp19_ = NULL;
		contacts_window_set_right_title (self, "");
		_tmp19_ = self->priv->edit_button;
		gtk_widget_hide ((GtkWidget*) _tmp19_);
	}
}


void contacts_window_add_notification (ContactsWindow* self, GtkWidget* notification) {
	GtkOverlay* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_tmp0_ = self->priv->overlay;
	_tmp1_ = notification;
	gtk_overlay_add_overlay (_tmp0_, _tmp1_);
}


void contacts_window_set_shown_contact (ContactsWindow* self, ContactsContact* c) {
	ContactsContactPane* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ContactsContactPane* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
	ContactsListPane* _tmp4_ = NULL;
	ContactsContact* _tmp7_ = NULL;
	gboolean _tmp11_ = FALSE;
	ContactsContact* _tmp12_ = NULL;
	GtkButton* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contact_pane;
	_tmp1_ = _tmp0_->on_edit_mode;
	if (_tmp1_) {
		contacts_window_leave_edit_mode (self, FALSE);
	}
	_tmp2_ = self->priv->contact_pane;
	_tmp3_ = c;
	contacts_contact_pane_show_contact (_tmp2_, _tmp3_, FALSE);
	_tmp4_ = self->priv->list_pane;
	if (_tmp4_ != NULL) {
		ContactsListPane* _tmp5_ = NULL;
		ContactsContact* _tmp6_ = NULL;
		_tmp5_ = self->priv->list_pane;
		_tmp6_ = c;
		contacts_list_pane_select_contact (_tmp5_, _tmp6_, FALSE);
	}
	_tmp7_ = c;
	if (_tmp7_ != NULL) {
		ContactsContact* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp8_ = c;
		_tmp9_ = contacts_contact_get_display_name (_tmp8_);
		_tmp10_ = _tmp9_;
		contacts_window_set_right_title (self, _tmp10_);
	} else {
		contacts_window_set_right_title (self, "");
	}
	_tmp12_ = c;
	if (_tmp12_ != NULL) {
		GtkToggleButton* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = self->priv->select_button;
		_tmp14_ = gtk_toggle_button_get_active (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp11_ = !_tmp15_;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp16_ = self->priv->edit_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp16_, _tmp11_);
}


void contacts_window_new_contact (ContactsWindow* self) {
	const gchar* _tmp0_ = NULL;
	GtkHeaderBar* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkHeaderBar* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	ContactsContactPane* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	contacts_window_set_edit_mode (self, TRUE);
	self->priv->new_contact_mode = TRUE;
	_tmp0_ = _ ("New Contact");
	contacts_window_set_right_title (self, _tmp0_);
	_tmp1_ = self->priv->left_toolbar;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, "selection-mode");
	_tmp3_ = self->priv->right_toolbar;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "selection-mode");
	_tmp5_ = self->priv->done_button;
	_tmp6_ = _ ("Add");
	gtk_button_set_label (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->contact_pane;
	contacts_contact_pane_new_contact (_tmp7_);
}


static void _contacts_window_new_contact_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	contacts_window_new_contact ((ContactsWindow*) self);
}


void contacts_window_show_search (ContactsWindow* self, const gchar* query) {
	ContactsListPane* _tmp0_ = NULL;
	GtkSearchEntry* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_tmp0_ = self->priv->list_pane;
	_tmp1_ = _tmp0_->filter_entry;
	_tmp2_ = query;
	gtk_entry_set_text ((GtkEntry*) _tmp1_, _tmp2_);
}


static void __lambda90_ (ContactsWindow* self) {
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->select_button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	contacts_window_activate_selection_mode (self, _tmp2_);
}


static void ___lambda90__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda90_ ((ContactsWindow*) self);
}


static void __lambda91_ (ContactsWindow* self) {
	contacts_window_enter_edit_mode (self);
}


static void ___lambda91__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda91_ ((ContactsWindow*) self);
}


static void __lambda92_ (ContactsWindow* self) {
	contacts_window_leave_edit_mode (self, FALSE);
}


static void ___lambda92__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda92_ ((ContactsWindow*) self);
}


static void __lambda93_ (ContactsWindow* self) {
	contacts_window_leave_edit_mode (self, TRUE);
}


static void ___lambda93__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda93_ ((ContactsWindow*) self);
}


static void contacts_window_init_content_widgets (ContactsWindow* self) {
	gchar* layout_desc = NULL;
	gchar** tokens = NULL;
	gint tokens_length1 = 0;
	gint _tokens_size_ = 0;
	GtkSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GtkToggleButton* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	GtkButton* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	g_object_get (_tmp0_, "gtk-decoration-layout", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_g_free0 (layout_desc);
	layout_desc = _tmp2_;
	_tmp3_ = layout_desc;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 2);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	tokens = _tmp5_;
	tokens_length1 = _vala_array_length (_tmp4_);
	_tokens_size_ = tokens_length1;
	_tmp6_ = tokens;
	_tmp6__length1 = tokens_length1;
	if (_tmp6_ != NULL) {
		GtkHeaderBar* _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GtkHeaderBar* _tmp12_ = NULL;
		gchar** _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		const gchar* _tmp14_ = NULL;
		_tmp7_ = self->priv->right_toolbar;
		_tmp8_ = tokens;
		_tmp8__length1 = tokens_length1;
		_tmp9_ = _tmp8_[1];
		_tmp10_ = g_strdup_printf (":%s", _tmp9_);
		_tmp11_ = _tmp10_;
		gtk_header_bar_set_decoration_layout (_tmp7_, _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = self->priv->left_toolbar;
		_tmp13_ = tokens;
		_tmp13__length1 = tokens_length1;
		_tmp14_ = _tmp13_[0];
		gtk_header_bar_set_decoration_layout (_tmp12_, _tmp14_);
	}
	_tmp15_ = self->priv->select_button;
	g_signal_connect_object (_tmp15_, "toggled", (GCallback) ___lambda90__gtk_toggle_button_toggled, self, 0);
	_tmp16_ = self->priv->edit_button;
	g_signal_connect_object (_tmp16_, "clicked", (GCallback) ___lambda91__gtk_button_clicked, self, 0);
	_tmp17_ = self->priv->done_button;
	g_signal_connect_object (_tmp17_, "clicked", (GCallback) ___lambda92__gtk_button_clicked, self, 0);
	_tmp18_ = self->priv->cancel_button;
	g_signal_connect_object (_tmp18_, "clicked", (GCallback) ___lambda93__gtk_button_clicked, self, 0);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (layout_desc);
}


static gboolean contacts_window_key_press_event_cb (ContactsWindow* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->keyval;
	_tmp3_ = gdk_keyval_from_name ("q");
	if (_tmp2_ == _tmp3_) {
		GdkEventKey* _tmp4_ = NULL;
		GdkModifierType _tmp5_ = 0;
		_tmp4_ = event;
		_tmp5_ = _tmp4_->state;
		_tmp0_ = (_tmp5_ & GDK_CONTROL_MASK) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ContactsContactPane* _tmp6_ = NULL;
		_tmp6_ = self->priv->contact_pane;
		contacts_contact_pane_show_contact (_tmp6_, NULL, TRUE);
		gtk_widget_destroy ((GtkWidget*) self);
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		GdkEventKey* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		_tmp9_ = event;
		_tmp10_ = _tmp9_->keyval;
		if (_tmp10_ == ((guint) GDK_KEY_s)) {
			_tmp8_ = TRUE;
		} else {
			GdkEventKey* _tmp11_ = NULL;
			guint _tmp12_ = 0U;
			_tmp11_ = event;
			_tmp12_ = _tmp11_->keyval;
			_tmp8_ = _tmp12_ == ((guint) GDK_KEY_f);
		}
		if (_tmp8_) {
			GdkEventKey* _tmp13_ = NULL;
			GdkModifierType _tmp14_ = 0;
			_tmp13_ = event;
			_tmp14_ = _tmp13_->state;
			_tmp7_ = (_tmp14_ & GDK_CONTROL_MASK) != 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ContactsListPane* _tmp15_ = NULL;
			GtkSearchEntry* _tmp16_ = NULL;
			_tmp15_ = self->priv->list_pane;
			_tmp16_ = _tmp15_->filter_entry;
			contacts_utils_grab_entry_focus_no_select ((GtkEntry*) _tmp16_);
		} else {
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
			GdkEventKey* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			_tmp23_ = event;
			_tmp24_ = _tmp23_->length;
			if (_tmp24_ >= 1) {
				GdkEventKey* _tmp25_ = NULL;
				guint _tmp26_ = 0U;
				guint32 _tmp27_ = 0U;
				_tmp25_ = event;
				_tmp26_ = _tmp25_->keyval;
				_tmp27_ = gdk_keyval_to_unicode (_tmp26_);
				_tmp22_ = _tmp27_ != ((guint32) 0);
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				GdkEventKey* _tmp28_ = NULL;
				GdkModifierType _tmp29_ = 0;
				_tmp28_ = event;
				_tmp29_ = _tmp28_->state;
				_tmp21_ = (_tmp29_ & GDK_CONTROL_MASK) == 0;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				GdkEventKey* _tmp30_ = NULL;
				GdkModifierType _tmp31_ = 0;
				_tmp30_ = event;
				_tmp31_ = _tmp30_->state;
				_tmp20_ = (_tmp31_ & GDK_MOD1_MASK) == 0;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				GdkEventKey* _tmp32_ = NULL;
				guint _tmp33_ = 0U;
				_tmp32_ = event;
				_tmp33_ = _tmp32_->keyval;
				_tmp19_ = _tmp33_ != ((guint) GDK_KEY_Escape);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				GdkEventKey* _tmp34_ = NULL;
				guint _tmp35_ = 0U;
				_tmp34_ = event;
				_tmp35_ = _tmp34_->keyval;
				_tmp18_ = _tmp35_ != ((guint) GDK_KEY_Tab);
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				GdkEventKey* _tmp36_ = NULL;
				guint _tmp37_ = 0U;
				_tmp36_ = event;
				_tmp37_ = _tmp36_->keyval;
				_tmp17_ = _tmp37_ != ((guint) GDK_KEY_BackSpace);
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				ContactsListPane* _tmp38_ = NULL;
				GtkSearchEntry* _tmp39_ = NULL;
				GdkEventKey* _tmp40_ = NULL;
				_tmp38_ = self->priv->list_pane;
				_tmp39_ = _tmp38_->filter_entry;
				contacts_utils_grab_entry_focus_no_select ((GtkEntry*) _tmp39_);
				_tmp40_ = event;
				gtk_window_propagate_key_event ((GtkWindow*) self, _tmp40_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean _contacts_window_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = contacts_window_key_press_event_cb ((ContactsWindow*) self, event);
	return result;
}


static gboolean contacts_window_delete_event_cb (ContactsWindow* self, GdkEventAny* event) {
	gboolean result = FALSE;
	ContactsContactPane* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp0_, NULL, TRUE);
	result = FALSE;
	return result;
}


static gboolean _contacts_window_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = contacts_window_delete_event_cb ((ContactsWindow*) self, event);
	return result;
}


static void contacts_window_list_pane_selection_changed_cb (ContactsWindow* self, ContactsContact* new_selection) {
	ContactsContact* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = new_selection;
	contacts_window_set_shown_contact (self, _tmp0_);
}


static Block39Data* block39_data_ref (Block39Data* _data39_) {
	g_atomic_int_inc (&_data39_->_ref_count_);
	return _data39_;
}


static void block39_data_unref (void * _userdata_) {
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
		ContactsWindow* self;
		self = _data39_->self;
		_g_object_unref0 (_data39_->notification);
		_g_object_unref0 (_data39_->operation);
		_g_object_unref0 (self);
		g_slice_free (Block39Data, _data39_);
	}
}


static void __lambda94_ (Block39Data* _data39_, GObject* obj, GAsyncResult* _result_) {
	ContactsWindow* self;
	GAsyncResult* _tmp0_ = NULL;
	ContactsLinkOperation2* _tmp1_ = NULL;
	self = _data39_->self;
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = _result_;
	_tmp1_ = contacts_link_contacts_list_finish (_tmp0_);
	_g_object_unref0 (_data39_->operation);
	_data39_->operation = _tmp1_;
}


static void ___lambda94__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda94_ (self, source_object, res);
	block39_data_unref (self);
}


static void __lambda95_ (Block39Data* _data39_) {
	ContactsWindow* self;
	self = _data39_->self;
	contacts_link_operation2_undo (_data39_->operation, NULL, NULL);
	gd_notification_dismiss (_data39_->notification);
}


static void ___lambda95__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda95_ (self);
}


static void contacts_window_list_pane_link_contacts_cb (ContactsWindow* self, GeeLinkedList* contact_list) {
	Block39Data* _data39_;
	GtkToggleButton* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GdNotification* _tmp2_ = NULL;
	GtkGrid* g = NULL;
	GtkGrid* _tmp3_ = NULL;
	gchar* msg = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	const gchar* _tmp7_ = NULL;
	GeeLinkedList* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	GtkButton* b = NULL;
	const gchar* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact_list != NULL);
	_data39_ = g_slice_new0 (Block39Data);
	_data39_->_ref_count_ = 1;
	_data39_->self = g_object_ref (self);
	contacts_window_set_shown_contact (self, NULL);
	_tmp0_ = self->priv->select_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
	_data39_->operation = NULL;
	_tmp1_ = contact_list;
	contacts_link_contacts_list (_tmp1_, ___lambda94__gasync_ready_callback, block39_data_ref (_data39_));
	_tmp2_ = (GdNotification*) gd_notification_new ();
	g_object_ref_sink (_tmp2_);
	_data39_->notification = _tmp2_;
	g_object_set (_data39_->notification, "timeout", 5, NULL);
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	g = _tmp3_;
	gtk_grid_set_column_spacing (g, (guint) 8);
	gtk_container_add ((GtkContainer*) _data39_->notification, (GtkWidget*) g);
	_tmp4_ = contact_list;
	_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = ngettext ("%d contacts linked", "%d contacts linked", (gulong) _tmp6_);
	_tmp8_ = contact_list;
	_tmp9_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf (_tmp7_, _tmp10_);
	msg = _tmp11_;
	_tmp12_ = _ ("_Undo");
	_tmp13_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp12_);
	g_object_ref_sink (_tmp13_);
	b = _tmp13_;
	_tmp14_ = (GtkLabel*) gtk_label_new (msg);
	g_object_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	gtk_container_add ((GtkContainer*) g, (GtkWidget*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	gtk_container_add ((GtkContainer*) g, (GtkWidget*) b);
	gtk_widget_show_all ((GtkWidget*) _data39_->notification);
	contacts_window_add_notification (self, (GtkWidget*) _data39_->notification);
	g_signal_connect_data (b, "clicked", (GCallback) ___lambda95__gtk_button_clicked, block39_data_ref (_data39_), (GClosureNotify) block39_data_unref, 0);
	_g_object_unref0 (b);
	_g_free0 (msg);
	_g_object_unref0 (g);
	block39_data_unref (_data39_);
	_data39_ = NULL;
}


static Block40Data* block40_data_ref (Block40Data* _data40_) {
	g_atomic_int_inc (&_data40_->_ref_count_);
	return _data40_;
}


static void block40_data_unref (void * _userdata_) {
	Block40Data* _data40_;
	_data40_ = (Block40Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data40_->_ref_count_)) {
		ContactsWindow* self;
		self = _data40_->self;
		_g_object_unref0 (_data40_->notification);
		_g_object_unref0 (_data40_->contact_list);
		_g_object_unref0 (self);
		g_slice_free (Block40Data, _data40_);
	}
}


static void __lambda96_ (Block40Data* _data40_) {
	ContactsWindow* self;
	self = _data40_->self;
	if (_data40_->really_delete) {
		{
			GeeLinkedList* _c_list = NULL;
			GeeLinkedList* _tmp0_ = NULL;
			GeeLinkedList* _tmp1_ = NULL;
			gint _c_size = 0;
			GeeLinkedList* _tmp2_ = NULL;
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
			gint _c_index = 0;
			_tmp0_ = _data40_->contact_list;
			_tmp1_ = _g_object_ref0 (_tmp0_);
			_c_list = _tmp1_;
			_tmp2_ = _c_list;
			_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_c_size = _tmp4_;
			_c_index = -1;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				ContactsContact* c = NULL;
				GeeLinkedList* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gpointer _tmp10_ = NULL;
				ContactsContact* _tmp11_ = NULL;
				_tmp5_ = _c_index;
				_c_index = _tmp5_ + 1;
				_tmp6_ = _c_index;
				_tmp7_ = _c_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _c_list;
				_tmp9_ = _c_index;
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
				c = (ContactsContact*) _tmp10_;
				_tmp11_ = c;
				contacts_contact_remove_personas (_tmp11_, NULL, NULL);
				_g_object_unref0 (c);
			}
			_g_object_unref0 (_c_list);
		}
	}
}


static void ___lambda96__gd_notification_dismissed (GdNotification* _sender, gpointer self) {
	__lambda96_ (self);
}


static void __lambda97_ (Block40Data* _data40_) {
	ContactsWindow* self;
	GeeLinkedList* _tmp12_ = NULL;
	gpointer _tmp13_ = NULL;
	ContactsContact* _tmp14_ = NULL;
	self = _data40_->self;
	_data40_->really_delete = FALSE;
	gd_notification_dismiss (_data40_->notification);
	{
		GeeLinkedList* _c_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _c_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _c_index = 0;
		_tmp0_ = _data40_->contact_list;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_c_list = _tmp1_;
		_tmp2_ = _c_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_c_size = _tmp4_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			ContactsContact* c = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			ContactsContact* _tmp11_ = NULL;
			_tmp5_ = _c_index;
			_c_index = _tmp5_ + 1;
			_tmp6_ = _c_index;
			_tmp7_ = _c_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _c_list;
			_tmp9_ = _c_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			c = (ContactsContact*) _tmp10_;
			_tmp11_ = c;
			contacts_contact_show (_tmp11_);
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_list);
	}
	_tmp12_ = _data40_->contact_list;
	_tmp13_ = gee_linked_list_last (_tmp12_);
	_tmp14_ = (ContactsContact*) _tmp13_;
	contacts_window_set_shown_contact (self, _tmp14_);
	_g_object_unref0 (_tmp14_);
}


static void ___lambda97__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda97_ (self);
}


static void contacts_window_list_pane_delete_contacts_cb (ContactsWindow* self, GeeLinkedList* contact_list) {
	Block40Data* _data40_;
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	GdNotification* _tmp3_ = NULL;
	GtkGrid* g = NULL;
	GtkGrid* _tmp4_ = NULL;
	gchar* msg = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	GeeLinkedList* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	GtkButton* b = NULL;
	const gchar* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact_list != NULL);
	_data40_ = g_slice_new0 (Block40Data);
	_data40_->_ref_count_ = 1;
	_data40_->self = g_object_ref (self);
	_tmp0_ = contact_list;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data40_->contact_list);
	_data40_->contact_list = _tmp1_;
	contacts_window_set_shown_contact (self, NULL);
	_tmp2_ = self->priv->select_button;
	gtk_toggle_button_set_active (_tmp2_, FALSE);
	_tmp3_ = (GdNotification*) gd_notification_new ();
	g_object_ref_sink (_tmp3_);
	_data40_->notification = _tmp3_;
	g_object_set (_data40_->notification, "timeout", 5, NULL);
	_tmp4_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp4_);
	g = _tmp4_;
	gtk_grid_set_column_spacing (g, (guint) 8);
	gtk_container_add ((GtkContainer*) _data40_->notification, (GtkWidget*) g);
	_tmp5_ = _data40_->contact_list;
	_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = ngettext ("%d contact deleted", "%d contacts deleted", (gulong) _tmp7_);
	_tmp9_ = _data40_->contact_list;
	_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf (_tmp8_, _tmp11_);
	msg = _tmp12_;
	_tmp13_ = _ ("_Undo");
	_tmp14_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp13_);
	g_object_ref_sink (_tmp14_);
	b = _tmp14_;
	_tmp15_ = (GtkLabel*) gtk_label_new (msg);
	g_object_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	gtk_container_add ((GtkContainer*) g, (GtkWidget*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	gtk_container_add ((GtkContainer*) g, (GtkWidget*) b);
	gtk_widget_show_all ((GtkWidget*) _data40_->notification);
	contacts_window_add_notification (self, (GtkWidget*) _data40_->notification);
	_data40_->really_delete = TRUE;
	g_signal_connect_data (_data40_->notification, "dismissed", (GCallback) ___lambda96__gd_notification_dismissed, block40_data_ref (_data40_), (GClosureNotify) block40_data_unref, 0);
	g_signal_connect_data (b, "clicked", (GCallback) ___lambda97__gtk_button_clicked, block40_data_ref (_data40_), (GClosureNotify) block40_data_unref, 0);
	_g_object_unref0 (b);
	_g_free0 (msg);
	_g_object_unref0 (g);
	block40_data_unref (_data40_);
	_data40_ = NULL;
}


static Block41Data* block41_data_ref (Block41Data* _data41_) {
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}


static void block41_data_unref (void * _userdata_) {
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		ContactsWindow* self;
		self = _data41_->self;
		_g_object_unref0 (_data41_->notification);
		_g_object_unref0 (_data41_->contact);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}


static void ___lambda100_ (Block41Data* _data41_) {
	ContactsWindow* self;
	ContactsContact* _tmp0_ = NULL;
	self = _data41_->self;
	_tmp0_ = _data41_->contact;
	contacts_contact_show (_tmp0_);
}


static void ____lambda100__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda100_ (self);
	block41_data_unref (self);
}


static void __lambda99_ (Block41Data* _data41_) {
	ContactsWindow* self;
	self = _data41_->self;
	if (_data41_->really_delete) {
		ContactsContact* _tmp0_ = NULL;
		_tmp0_ = _data41_->contact;
		contacts_contact_remove_personas (_tmp0_, ____lambda100__gasync_ready_callback, block41_data_ref (_data41_));
	}
}


static void ___lambda99__gd_notification_dismissed (GdNotification* _sender, gpointer self) {
	__lambda99_ (self);
}


static void __lambda101_ (Block41Data* _data41_) {
	ContactsWindow* self;
	ContactsContact* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	self = _data41_->self;
	_data41_->really_delete = FALSE;
	gd_notification_dismiss (_data41_->notification);
	_tmp0_ = _data41_->contact;
	contacts_contact_show (_tmp0_);
	_tmp1_ = _data41_->contact;
	contacts_window_set_shown_contact (self, _tmp1_);
}


static void ___lambda101__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda101_ (self);
}


static void contacts_window_contact_pane_delete_contact_cb (ContactsWindow* self, ContactsContact* contact) {
	Block41Data* _data41_;
	ContactsContact* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	GdNotification* _tmp3_ = NULL;
	GtkGrid* g = NULL;
	GtkGrid* _tmp4_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp5_ = NULL;
	ContactsContact* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkButton* b = NULL;
	const gchar* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_data41_ = g_slice_new0 (Block41Data);
	_data41_->_ref_count_ = 1;
	_data41_->self = g_object_ref (self);
	_tmp0_ = contact;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data41_->contact);
	_data41_->contact = _tmp1_;
	contacts_window_set_shown_contact (self, NULL);
	_tmp2_ = self->priv->select_button;
	gtk_toggle_button_set_active (_tmp2_, FALSE);
	_tmp3_ = (GdNotification*) gd_notification_new ();
	g_object_ref_sink (_tmp3_);
	_data41_->notification = _tmp3_;
	g_object_set (_data41_->notification, "timeout", 5, NULL);
	_tmp4_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp4_);
	g = _tmp4_;
	gtk_grid_set_column_spacing (g, (guint) 8);
	gtk_container_add ((GtkContainer*) _data41_->notification, (GtkWidget*) g);
	_tmp5_ = _ ("Contact deleted: \"%s\"");
	_tmp6_ = _data41_->contact;
	_tmp7_ = contacts_contact_get_display_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf (_tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	label = _tmp12_;
	gtk_label_set_max_width_chars (label, 45);
	gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
	_tmp13_ = _ ("_Undo");
	_tmp14_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp13_);
	g_object_ref_sink (_tmp14_);
	b = _tmp14_;
	gtk_container_add ((GtkContainer*) g, (GtkWidget*) label);
	gtk_container_add ((GtkContainer*) g, (GtkWidget*) b);
	_data41_->really_delete = TRUE;
	gtk_widget_show_all ((GtkWidget*) _data41_->notification);
	g_signal_connect_data (_data41_->notification, "dismissed", (GCallback) ___lambda99__gd_notification_dismissed, block41_data_ref (_data41_), (GClosureNotify) block41_data_unref, 0);
	g_signal_connect_data (b, "clicked", (GCallback) ___lambda101__gtk_button_clicked, block41_data_ref (_data41_), (GClosureNotify) block41_data_unref, 0);
	contacts_window_add_notification (self, (GtkWidget*) _data41_->notification);
	_g_object_unref0 (b);
	_g_object_unref0 (label);
	_g_object_unref0 (g);
	block41_data_unref (_data41_);
	_data41_ = NULL;
}


static void _contacts_window_contact_pane_delete_contact_cb_contacts_contact_pane_will_delete (ContactsContactPane* _sender, ContactsContact* contact, gpointer self) {
	contacts_window_contact_pane_delete_contact_cb ((ContactsWindow*) self, contact);
}


static Block42Data* block42_data_ref (Block42Data* _data42_) {
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}


static void block42_data_unref (void * _userdata_) {
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		ContactsWindow* self;
		self = _data42_->self;
		_g_object_unref0 (_data42_->notification);
		_g_object_unref0 (_data42_->operation);
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}


static void __lambda102_ (Block42Data* _data42_) {
	ContactsWindow* self;
	GdNotification* _tmp0_ = NULL;
	ContactsLinkOperation* _tmp1_ = NULL;
	self = _data42_->self;
	_tmp0_ = _data42_->notification;
	gd_notification_dismiss (_tmp0_);
	_tmp1_ = _data42_->operation;
	contacts_link_operation_undo (_tmp1_, NULL, NULL);
}


static void ___lambda102__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda102_ (self);
}


static void contacts_window_contact_pane_contacts_linked_cb (ContactsWindow* self, const gchar* main_contact, const gchar* linked_contact, ContactsLinkOperation* operation) {
	Block42Data* _data42_;
	ContactsLinkOperation* _tmp0_ = NULL;
	ContactsLinkOperation* _tmp1_ = NULL;
	GdNotification* _tmp2_ = NULL;
	GdNotification* _tmp3_ = NULL;
	GtkGrid* g = NULL;
	GtkGrid* _tmp4_ = NULL;
	GtkGrid* _tmp5_ = NULL;
	GdNotification* _tmp6_ = NULL;
	GtkGrid* _tmp7_ = NULL;
	gchar* msg = NULL;
	const gchar* _tmp8_ = NULL;
	GtkButton* b = NULL;
	const gchar* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	GtkGrid* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GtkLabel* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkGrid* _tmp22_ = NULL;
	GdNotification* _tmp23_ = NULL;
	GdNotification* _tmp24_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (linked_contact != NULL);
	g_return_if_fail (operation != NULL);
	_data42_ = g_slice_new0 (Block42Data);
	_data42_->_ref_count_ = 1;
	_data42_->self = g_object_ref (self);
	_tmp0_ = operation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data42_->operation);
	_data42_->operation = _tmp1_;
	_tmp2_ = (GdNotification*) gd_notification_new ();
	g_object_ref_sink (_tmp2_);
	_data42_->notification = _tmp2_;
	_tmp3_ = _data42_->notification;
	g_object_set (_tmp3_, "timeout", 5, NULL);
	_tmp4_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp4_);
	g = _tmp4_;
	_tmp5_ = g;
	gtk_grid_set_column_spacing (_tmp5_, (guint) 8);
	_tmp6_ = _data42_->notification;
	_tmp7_ = g;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = main_contact;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp9_ = _ ("%s linked to %s");
		_tmp10_ = main_contact;
		_tmp11_ = linked_contact;
		_tmp12_ = g_strdup_printf (_tmp9_, _tmp10_, _tmp11_);
		_g_free0 (msg);
		msg = _tmp12_;
	} else {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp13_ = _ ("%s linked to the contact");
		_tmp14_ = linked_contact;
		_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
		_g_free0 (msg);
		msg = _tmp15_;
	}
	_tmp16_ = _ ("_Undo");
	_tmp17_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp16_);
	g_object_ref_sink (_tmp17_);
	b = _tmp17_;
	_tmp18_ = g;
	_tmp19_ = msg;
	_tmp20_ = (GtkLabel*) gtk_label_new (_tmp19_);
	g_object_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = g;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) b);
	_tmp23_ = _data42_->notification;
	gtk_widget_show_all ((GtkWidget*) _tmp23_);
	g_signal_connect_data (b, "clicked", (GCallback) ___lambda102__gtk_button_clicked, block42_data_ref (_data42_), (GClosureNotify) block42_data_unref, 0);
	_tmp24_ = _data42_->notification;
	contacts_window_add_notification (self, (GtkWidget*) _tmp24_);
	_g_object_unref0 (b);
	_g_free0 (msg);
	_g_object_unref0 (g);
	block42_data_unref (_data42_);
	_data42_ = NULL;
}


static void _contacts_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked (ContactsContactPane* _sender, const gchar* main_contact, const gchar* linked_contact, ContactsLinkOperation* operation, gpointer self) {
	contacts_window_contact_pane_contacts_linked_cb ((ContactsWindow*) self, main_contact, linked_contact, operation);
}


static const gchar* contacts_window_get_left_title (ContactsWindow* self) {
	const gchar* result;
	GtkHeaderBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->left_toolbar;
	_tmp1_ = gtk_header_bar_get_title (_tmp0_);
	result = _tmp1_;
	return result;
}


static void contacts_window_set_left_title (ContactsWindow* self, const gchar* value) {
	GtkHeaderBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->left_toolbar;
	_tmp1_ = value;
	gtk_header_bar_set_title (_tmp0_, _tmp1_);
}


static const gchar* contacts_window_get_right_title (ContactsWindow* self) {
	const gchar* result;
	GtkHeaderBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->right_toolbar;
	_tmp1_ = gtk_header_bar_get_title (_tmp0_);
	result = _tmp1_;
	return result;
}


static void contacts_window_set_right_title (ContactsWindow* self, const gchar* value) {
	GtkHeaderBar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->right_toolbar;
	_tmp1_ = value;
	gtk_header_bar_set_title (_tmp0_, _tmp1_);
}


ContactsStore* contacts_window_get_store (ContactsWindow* self) {
	ContactsStore* result;
	ContactsStore* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}


void contacts_window_set_store (ContactsWindow* self, ContactsStore* value) {
	ContactsStore* _tmp0_ = NULL;
	ContactsStore* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_store);
	self->priv->_store = _tmp1_;
	g_object_notify ((GObject *) self, "store");
}


gboolean contacts_window_get_selection_mode (ContactsWindow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_selection_mode;
	result = _tmp0_;
	return result;
}


void contacts_window_set_selection_mode (ContactsWindow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_selection_mode = _tmp0_;
	g_object_notify ((GObject *) self, "selection-mode");
}


gboolean contacts_window_get_edit_mode (ContactsWindow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_edit_mode;
	result = _tmp0_;
	return result;
}


void contacts_window_set_edit_mode (ContactsWindow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_edit_mode = _tmp0_;
	g_object_notify ((GObject *) self, "edit-mode");
}


static void contacts_window_class_init (ContactsWindowClass * klass) {
	gint ContactsWindow_private_offset;
	contacts_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_WINDOW_STORE, g_param_spec_object ("store", "store", "store", CONTACTS_TYPE_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_WINDOW_SELECTION_MODE, g_param_spec_boolean ("selection-mode", "selection-mode", "selection-mode", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_WINDOW_EDIT_MODE, g_param_spec_boolean ("edit-mode", "edit-mode", "edit-mode", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ContactsWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/contacts/ui/contacts-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_grid", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, content_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "loading_box", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, loading_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "left_pane_size_group", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, left_pane_size_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "left_toolbar", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, left_toolbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "right_toolbar", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, right_toolbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_pane", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, contact_pane));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, add_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "select_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, select_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "edit_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, edit_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "done_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, done_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "view_switcher", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, view_switcher));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_header_bar", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, content_header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_header_bar", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, setup_header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_done_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, setup_done_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_cancel_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, setup_cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_accounts_list", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, setup_accounts_list));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "new_contact", G_CALLBACK(_contacts_window_new_contact_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "key_press_event_cb", G_CALLBACK(_contacts_window_key_press_event_cb_gtk_widget_key_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_event_cb", G_CALLBACK(_contacts_window_delete_event_cb_gtk_widget_delete_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "contact_pane_delete_contact_cb", G_CALLBACK(_contacts_window_contact_pane_delete_contact_cb_contacts_contact_pane_will_delete));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "contact_pane_contacts_linked_cb", G_CALLBACK(_contacts_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked));
}


static void contacts_window_instance_init (ContactsWindow * self) {
	self->priv = CONTACTS_WINDOW_GET_PRIVATE (self);
	self->priv->new_contact_mode = FALSE;
	g_type_ensure (CONTACTS_TYPE_ACCOUNTS_LIST);
	g_type_ensure (CONTACTS_TYPE_CONTACT_PANE);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void contacts_window_finalize (GObject* obj) {
	ContactsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_WINDOW, ContactsWindow);
	_g_object_unref0 (self->priv->content_grid);
	_g_object_unref0 (self->priv->loading_box);
	_g_object_unref0 (self->priv->left_pane_size_group);
	_g_object_unref0 (self->priv->left_toolbar);
	_g_object_unref0 (self->priv->right_toolbar);
	_g_object_unref0 (self->priv->overlay);
	_g_object_unref0 (self->priv->contact_pane);
	_g_object_unref0 (self->priv->add_button);
	_g_object_unref0 (self->priv->select_button);
	_g_object_unref0 (self->priv->edit_button);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->done_button);
	_g_object_unref0 (self->priv->view_switcher);
	_g_object_unref0 (self->priv->content_header_bar);
	_g_object_unref0 (self->priv->setup_header_bar);
	_g_object_unref0 (self->priv->setup_done_button);
	_g_object_unref0 (self->priv->setup_cancel_button);
	_g_object_unref0 (self->priv->setup_accounts_list);
	_g_object_unref0 (self->priv->list_pane);
	_g_object_unref0 (self->priv->_store);
	G_OBJECT_CLASS (contacts_window_parent_class)->finalize (obj);
}


GType contacts_window_get_type (void) {
	static volatile gsize contacts_window_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsWindow), 0, (GInstanceInitFunc) contacts_window_instance_init, NULL };
		GType contacts_window_type_id;
		contacts_window_type_id = g_type_register_static (gtk_application_window_get_type (), "ContactsWindow", &g_define_type_info, 0);
		g_once_init_leave (&contacts_window_type_id__volatile, contacts_window_type_id);
	}
	return contacts_window_type_id__volatile;
}


static void _vala_contacts_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_WINDOW, ContactsWindow);
	switch (property_id) {
		case CONTACTS_WINDOW_STORE:
		g_value_set_object (value, contacts_window_get_store (self));
		break;
		case CONTACTS_WINDOW_SELECTION_MODE:
		g_value_set_boolean (value, contacts_window_get_selection_mode (self));
		break;
		case CONTACTS_WINDOW_EDIT_MODE:
		g_value_set_boolean (value, contacts_window_get_edit_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_contacts_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ContactsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_WINDOW, ContactsWindow);
	switch (property_id) {
		case CONTACTS_WINDOW_STORE:
		contacts_window_set_store (self, g_value_get_object (value));
		break;
		case CONTACTS_WINDOW_SELECTION_MODE:
		contacts_window_set_selection_mode (self, g_value_get_boolean (value));
		break;
		case CONTACTS_WINDOW_EDIT_MODE:
		contacts_window_set_edit_mode (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



