/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;

public abstract class AbstractWriter {
    protected static final char NEWLINE = '\n';
    private Writer writer;
    private ElementIterator iter;
    private Document document;
    private int maxLineLength = 100;
    private int lineLength;
    private boolean canWrapLines;
    private int indentSpace = 2;
    private int indentLevel;
    private boolean indented;
    private int startOffset;
    private int endOffset;
    private String lineSeparator = "\n";
    private char[] lineSeparatorChars = this.lineSeparator.toCharArray();

    protected AbstractWriter(Writer writer, Document doc) {
        this.writer = writer;
        this.iter = new ElementIterator(doc);
        this.document = doc;
        this.startOffset = 0;
        this.endOffset = doc.getLength();
    }

    protected AbstractWriter(Writer writer, Document doc, int pos, int len) {
        this.writer = writer;
        this.iter = new ElementIterator(doc);
        this.document = doc;
        this.startOffset = pos;
        this.endOffset = pos + len;
    }

    protected AbstractWriter(Writer writer, Element elt) {
        this.writer = writer;
        this.iter = new ElementIterator(elt);
        this.document = elt.getDocument();
        this.startOffset = elt.getStartOffset();
        this.endOffset = elt.getEndOffset();
    }

    protected AbstractWriter(Writer writer, Element elt, int pos, int len) {
        this.writer = writer;
        this.iter = new ElementIterator(elt);
        this.document = elt.getDocument();
        this.startOffset = pos;
        this.endOffset = pos + len;
    }

    protected ElementIterator getElementIterator() {
        return this.iter;
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected Document getDocument() {
        return this.document;
    }

    protected abstract void write() throws IOException, BadLocationException;

    protected String getText(Element elt) throws BadLocationException {
        if (!elt.isLeaf()) {
            throw new BadLocationException("Element is not a leaf", elt.getStartOffset());
        }
        return this.document.getText(elt.getStartOffset(), elt.getEndOffset() - elt.getStartOffset());
    }

    protected void output(char[] data, int start, int len) throws IOException {
        this.writer.write(data, start, len);
        this.lineLength += len;
    }

    protected void writeLineSeparator() throws IOException {
        this.output(this.lineSeparatorChars, 0, this.lineSeparatorChars.length);
        this.lineLength = 0;
        this.indented = false;
    }

    protected void write(char ch) throws IOException {
        this.write(new char[]{ch}, 0, 1);
    }

    protected void write(String s) throws IOException {
        char[] v = s.toCharArray();
        this.write(v, 0, v.length);
    }

    protected void write(char[] data, int start, int len) throws IOException {
        if (this.getCanWrapLines()) {
            int i = 0;
            while (i < len) {
                int start_i = i;
                while (i < len && data[start + i] != ' ') {
                    ++i;
                }
                if (i < len && this.lineLength + i - start_i >= this.maxLineLength) {
                    this.writeLineSeparator();
                } else if (i < len) {
                    ++i;
                }
                this.output(data, start + start_i, start + i - start_i);
            }
        } else {
            int saved_i = start;
            int i = start;
            while (i < start + len) {
                if (data[i] == '\n') {
                    this.output(data, saved_i, i - saved_i);
                    this.writeLineSeparator();
                }
                ++i;
            }
            if (saved_i < start + len - 1) {
                this.output(data, saved_i, start + len - saved_i);
            }
        }
    }

    protected void indent() throws IOException {
        int spaces = this.indentLevel * this.indentSpace;
        if (spaces > 0) {
            char[] v = new char[spaces];
            Arrays.fill(v, ' ');
            this.write(v, 0, v.length);
        }
        this.indented = true;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    protected boolean inRange(Element elt) {
        int eltStart = elt.getStartOffset();
        int eltEnd = elt.getEndOffset();
        return eltStart >= this.startOffset && eltStart < this.endOffset || eltEnd >= this.startOffset && eltEnd < this.endOffset;
    }

    protected void text(Element elt) throws BadLocationException, IOException {
        int eltStart = elt.getStartOffset();
        int eltEnd = elt.getEndOffset();
        eltStart = Math.max(eltStart, this.startOffset);
        eltEnd = Math.min(eltEnd, this.endOffset);
        this.write(this.document.getText(eltStart, eltEnd));
    }

    protected void setLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    protected int getLineLength() {
        return this.maxLineLength;
    }

    protected void setCurrentLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    protected int getCurrentLineLength() {
        return this.lineLength;
    }

    protected boolean isLineEmpty() {
        return this.lineLength == 0 && !this.indented;
    }

    protected void setCanWrapLines(boolean canWrapLines) {
        this.canWrapLines = canWrapLines;
    }

    protected boolean getCanWrapLines() {
        return this.canWrapLines;
    }

    protected void setIndentSpace(int indentSpace) {
        this.indentSpace = indentSpace;
    }

    protected int getIndentSpace() {
        return this.indentSpace;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        this.lineSeparatorChars = lineSeparator.toCharArray();
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    protected void incrIndent() {
        ++this.indentLevel;
    }

    protected void decrIndent() {
        --this.indentLevel;
    }

    protected int getIndentLevel() {
        return this.indentLevel;
    }

    protected void writeAttributes(AttributeSet attrs) throws IOException {
        Enumeration<?> e = attrs.getAttributeNames();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            Object val = attrs.getAttribute(name);
            this.write(name + "=" + val);
            this.writeLineSeparator();
        }
    }
}

